<?php

/**
 * Brazilian Portuguese language file
 *
 * This Source Code Form is subject to the terms of the Mozilla Public License,
 * v. 2.0. If a copy of the MPL was not distributed with this file, You can
 * obtain one at https://mozilla.org/MPL/2.0/.
 *
 * @package phpMyFAQ
 * @author Pedro Lineu Orso <pedro.orso@gmail.com>
 * @copyright 2006-2024 phpMyFAQ Team
 * @license https://www.mozilla.org/MPL/2.0/ Mozilla Public License Version 2.0
 * @link https://www.phpmyfaq.de
 * @since 2006-04-05
 * @codingStandardsIgnoreFile
 */

$PMF_LANG['metaCharset'] = 'utf-8';
$PMF_LANG['metaLanguage'] = 'pt_br';
$PMF_LANG['language'] = 'Brazilian Portuguese';
$PMF_LANG['direction']= 'ltr';
$PMF_LANG['nplurals'] = '2';
$PMF_LANG['msgCategory'] = 'Categorias';
$PMF_LANG['msgShowAllCategories'] = 'Mostrar todas categorias';
$PMF_LANG['msgSearch'] = 'Pesquisar';
$PMF_LANG['msgAddContent'] = 'Adicionar';
$PMF_LANG['msgQuestion'] = 'Perguntar';
$PMF_LANG['msgOpenQuestions'] = 'Perguntas em aberto';
$PMF_LANG['msgHelp'] = 'Ajuda';
$PMF_LANG['msgContact'] = 'Contato';
$PMF_LANG['msgHome'] = 'Início';
$PMF_LANG['msgNews'] = 'Notícias';
$PMF_LANG['msgUserOnline'] = ' Usuário(s) Online';
$PMF_LANG['msgBack2Home'] = 'Voltar ao início';
$PMF_LANG['msgFullCategories'] = 'Categorias com entradas';
$PMF_LANG['msgFullCategoriesIn'] = 'Categorias com entradas em ';
$PMF_LANG['msgSubCategories'] = 'Subcategorias';
$PMF_LANG['msgEntries'] = 'Entradas';
$PMF_LANG['msgEntriesIn'] = 'Entradas em ';
$PMF_LANG['msgViews'] = 'visualizações';
$PMF_LANG['msgPage'] = 'Página ';
$PMF_LANG['msgPages'] = ' Páginas';
$PMF_LANG['msgPrevious'] = 'anterior';
$PMF_LANG['msgNext'] = 'próxima';
$PMF_LANG['msgCategoryUp'] = 'categoria acima';
$PMF_LANG['msgLastUpdateArticle'] = 'Última atualização: ';
$PMF_LANG['msgAuthor'] = 'Autor:';
$PMF_LANG['msgPrinterFriendly'] = 'Versão Impressão';
$PMF_LANG['msgPrintArticle'] = 'Imprimir';
$PMF_LANG['msgMakeXMLExport'] = 'Exportar como XML';
$PMF_LANG['msgAverageVote'] = 'Avaliação média:';
$PMF_LANG['msgVoteUsability'] = 'Avalie este conteúdo:';
$PMF_LANG['msgVoteFrom'] = 'de';
$PMF_LANG['msgVoteBad'] = 'Completamente <br>inútil';
$PMF_LANG['msgVoteGood'] = 'Muito<br>útil';
$PMF_LANG['msgVotings'] = 'Votos ';
$PMF_LANG['msgVoteSubmit'] = 'Votar';
$PMF_LANG['msgVoteThanks'] = 'Obrigado pelo seu voto!';
$PMF_LANG['msgYouCan'] = 'Pode ';
$PMF_LANG['msgWriteComment'] = 'comentar este artigo';
$PMF_LANG['msgShowCategory'] = 'Vista geral conteúdo: ';
$PMF_LANG['msgCommentBy'] = 'Comentário de ';
$PMF_LANG['msgCommentHeader'] = 'Comentar este registro';
$PMF_LANG['msgYourComment'] = 'Seus comentários:';
$PMF_LANG['msgCommentThanks'] = 'Obrigado pelos seu comentário!';
$PMF_LANG['msgSend2Friend'] = 'Enviar para um amigo';
$PMF_LANG['msgS2FButton'] = 'enviar e-mail';
$PMF_LANG['msgSearchWord'] = 'Palavra-Chave';
$PMF_LANG['msgSearchFind'] = 'Resultados da pesquisa por ';
$PMF_LANG['msgSearchAmount'] = ' resultados da pesquisa';
$PMF_LANG['msgSearchAmounts'] = ' resultados da pesquisa';
$PMF_LANG['msgSearchCategory'] = 'Categoria: ';
$PMF_LANG['msgSearchContent'] = 'Conteúdo: ';
$PMF_LANG['msgNewContentHeader'] = 'Proposta para FAQ';
$PMF_LANG['msgNewContentAddon'] = "Sua sugestão não aparecerá imediatamente, mas será verificada por nós antes da publicação. Campos obrigatórios são campos marcados com *.";
$PMF_LANG['msgNewContentName'] = 'Nome:';
$PMF_LANG['msgNewContentMail'] = 'E-mail:';
$PMF_LANG['msgNewContentCategory'] = 'Categoria:';
$PMF_LANG['msgNewContentTheme'] = 'Titulo:';
$PMF_LANG['msgNewContentArticle'] = 'Conteúdo:';
$PMF_LANG['msgNewContentKeywords'] = 'Palavras-Chave:';
$PMF_LANG['msgNewContentLink'] = 'Link:';
$PMF_LANG['msgNewContentSubmit'] = 'inserir';
$PMF_LANG['msgInfo'] = 'Mais informações: ';
$PMF_LANG['msgNewContentThanks'] = 'Obrigado por sua contribuição!';
$PMF_LANG['msgNoQuestionsAvailable'] = 'Atualmente não existem perguntas disponíveis.';
$PMF_LANG['msgNewQuestion'] = 'Você pode adicionar suas perguntas aqui.';
$PMF_LANG['msgAskCategory'] = 'Pergunta sobre a categoria';
$PMF_LANG['msgAskYourQuestion'] = 'Sua pergunta:';
$PMF_LANG['msgAskThx4Mail'] = '<h2>Obrigado pelo seu e-mail!</h2>';
$PMF_LANG['msgDate_User'] = 'Data / Usuário';
$PMF_LANG['msgQuestion2'] = 'Pergunta';
$PMF_LANG['msg2answer'] = 'Resposta';
$PMF_LANG['msgQuestionText'] = 'Aqui você pode ver algumas perguntas de outros usuários. Se quiser contribuir com respostas para essas perguntas, elas serão inseridas no FAQ.';
$PMF_LANG['msgHelpText'] = 'As FAQ (<strong>F</strong>requently <strong>A</strong>sked <strong>Q</strong>uestions em inglês) tem uma estrutura bastante simples. Pode pesquisar nas <strong><a href="?action=show">categorias</a></strong> ou usar a <strong><a href="?action=search">ferramenta de busca das FAQ</a></strong>.';
$PMF_LANG['msgContactEMail'] = 'E-mail ao administrador:';
$PMF_LANG['msgMessage'] = 'Sua mensagem:';
$PMF_LANG['msgTopTen'] = 'TOP 10';
$PMF_LANG['msgHomeThereAre'] = 'Existem ';
$PMF_LANG['msgHomeArticlesOnline'] = ' registros online';
$PMF_LANG['msgNoNews'] = 'Sem notícias disponiveis.';
$PMF_LANG['msgLatestArticles'] = 'Últimos 5 registros';
$PMF_LANG['msgMailThanks'] = 'Obrigado por sua proposta para a FAQ.';
$PMF_LANG['msgMailCheck'] = 'Existe um novo registro na FAQ! Veja a seção de Administração';
$PMF_LANG['msgMailContact'] = 'A sua mensagem foi enviada para o administrador!';
$PMF_LANG['err_noDatabase'] = 'Sem conexão com a base de dados!';
$PMF_LANG['err_noHeaders'] = 'Sem categorias!';
$PMF_LANG['msgErrorNoRecords'] = 'Sem artigos.';
$PMF_LANG['err_badID'] = 'ID Errado';
$PMF_LANG['err_noTopTen'] = 'Sem TOP 10 disponível.';
$PMF_LANG['err_nothingFound'] = 'Sem registros.';
$PMF_LANG['err_SaveEntries'] = 'Campos obrigatórios são <strong>Nome</strong>, <strong>E-mail</strong>, <strong>Categoria</strong>, <strong>Título</strong> e <strong>Texto</strong>!<br><br><a href="nojavascript...history.back();">voltar</a><br><br>';
$PMF_LANG['err_SaveComment'] = 'Campos obrigatórios são <strong>Nome</strong>, <strong>E-mail</strong> e <strong>Comentário</strong>!<br><br><a href="nojavascript...history.back();">voltar</a><br><br>';
$PMF_LANG['err_VoteTooMuch'] = 'Já votou.';
$PMF_LANG['err_noVote'] = '<strong>Não avaliou!</strong> <a href="nojavascript...history.back();">Clique aqui</a>, para votar.';
$PMF_LANG['err_noMailAdress'] = 'E-mail incorreto.<br><a href="nojavascript...history.back();">voltar</a>';
$PMF_LANG['err_sendMail'] = 'Campos obrigatórios são <strong>nome</strong>, <strong>e-mail</strong> e <strong>pergunta</strong>!';
$PMF_LANG['help_search'] = '<strong>Pesquisar registros:</strong><br>';
$PMF_LANG['ad'] = 'Seção Administração';
$PMF_LANG['ad_menu_user_administration'] = 'Administração de Usuários';
$PMF_LANG['ad_menu_entry_aprove'] = 'Aprovar Registros';
$PMF_LANG['ad_menu_entry_edit'] = 'Editar Registros';
$PMF_LANG['ad_menu_categ_add'] = 'Adicionar Categoria';
$PMF_LANG['msgHeaderCategoryOverview'] = 'Administração de Categorias';
$PMF_LANG['ad_menu_news_add'] = 'Adicionar Notícia';
$PMF_LANG['ad_menu_news_edit'] = 'Editar Notícia';
$PMF_LANG['ad_menu_open'] = 'Editar perguntas abertas';
$PMF_LANG['ad_menu_stat'] = 'Estatísticas de Avaliação';
$PMF_LANG['ad_menu_cookie'] = 'Cookies';
$PMF_LANG['ad_menu_session'] = 'Ver Sessões';
$PMF_LANG['ad_menu_adminlog'] = 'Ver Log Admin';
$PMF_LANG['ad_menu_passwd'] = 'Alterar Senha';
$PMF_LANG['ad_menu_logout'] = 'Sair';
$PMF_LANG['ad_menu_startpage'] = 'Página Inicial';
$PMF_LANG['ad_msg_identify'] = 'Identifique-se.';
$PMF_LANG['ad_msg_passmatch'] = 'As senhas não são iguais';
$PMF_LANG['ad_msg_savedsuc_1'] = 'Perfil de';
$PMF_LANG['ad_msg_savedsuc_2'] = 'salvo com sucesso.';
$PMF_LANG['ad_msg_mysqlerr'] = 'Devido a um <strong>erro de base de dados</strong> o perfil não foi salvo.';
$PMF_LANG['ad_msg_noauth'] = 'Sem autorização.';
$PMF_LANG['ad_gen_page'] = 'Página';
$PMF_LANG['ad_gen_of'] = 'de';
$PMF_LANG['ad_gen_lastpage'] = 'Página anterior';
$PMF_LANG['ad_gen_nextpage'] = 'Próxima página';
$PMF_LANG['ad_gen_save'] = 'Salvar';
$PMF_LANG['ad_gen_reset'] = 'Limpar';
$PMF_LANG['ad_gen_yes'] = 'Sim';
$PMF_LANG['ad_gen_no'] = 'Não';
$PMF_LANG['ad_gen_top'] = 'Topo';
$PMF_LANG['ad_gen_ncf'] = 'Sem categorias';
$PMF_LANG['ad_gen_delete'] = 'Remover';
$PMF_LANG['ad_user'] = 'Administração de Usuários';
$PMF_LANG['ad_user_username'] = 'Usuários Registrados';
$PMF_LANG['ad_user_rights'] = 'Permissões';
$PMF_LANG['ad_user_edit'] = 'editar';
$PMF_LANG['ad_user_delete'] = 'remover';
$PMF_LANG['ad_user_add'] = 'Adicionar Usuário';
$PMF_LANG['ad_user_profou'] = 'Perfil do Usuário';
$PMF_LANG['ad_user_name'] = 'Usuário';
$PMF_LANG['ad_user_password'] = 'Senha';
$PMF_LANG['ad_user_confirm'] = 'Confirmar';
$PMF_LANG['ad_user_del_1'] = 'O usuário';
$PMF_LANG['ad_user_del_2'] = 'será removido';
$PMF_LANG['ad_user_del_3'] = 'Tem certeza?';
$PMF_LANG['ad_user_deleted'] = 'Usuário removido com sucesso.';
$PMF_LANG['ad_user_checkall'] = 'Selecionar Tudo';
$PMF_LANG['msgHeaderFAQOverview'] = 'Administração de Registros';
$PMF_LANG['ad_entry_id'] = 'ID';
$PMF_LANG['ad_entry_topic'] = 'Tópico';
$PMF_LANG['ad_entry_action'] = 'Ação';
$PMF_LANG['ad_entry_edit_1'] = 'Editar Registro';
$PMF_LANG['ad_entry_theme'] = 'Tema:';
$PMF_LANG['ad_entry_content'] = 'Conteúdo:';
$PMF_LANG['ad_entry_keywords'] = 'Palavras-Chave:';
$PMF_LANG['ad_entry_author'] = 'Autor:';
$PMF_LANG['ad_entry_category'] = 'Categoria:';
$PMF_LANG['ad_entry_active'] = 'Ativo?';
$PMF_LANG['ad_entry_date'] = 'Data';
$PMF_LANG['ad_entry_status'] = 'Status da FAQ';
$PMF_LANG['ad_entry_changed'] = 'Alterado?';
$PMF_LANG['ad_entry_changelog'] = 'Log de Alterações';
$PMF_LANG['ad_entry_commentby'] = 'Comentário de';
$PMF_LANG['ad_entry_comment'] = 'Comentários:';
$PMF_LANG['ad_entry_save'] = 'Salvar';
$PMF_LANG['msgDelete'] = 'Remover';
$PMF_LANG['ad_entry_delcom_1'] = 'Tem certeza que o comentário do usuário ';
$PMF_LANG['ad_entry_delcom_2'] = 'deve ser removido?';
$PMF_LANG['ad_entry_commentdelsuc'] = 'Comentário removido com sucesso.';
$PMF_LANG['ad_entry_back'] = 'Voltar';
$PMF_LANG['ad_entry_commentdelfail'] = 'Comentário não removido.';
$PMF_LANG['ad_entry_savedsuc'] = 'Alterações salvas com sucesso.';
$PMF_LANG['ad_entry_savedfail'] = 'Ocorreu um erro na base de dados.';
$PMF_LANG['ad_entry_del_1'] = 'Tem certeza que o tópico';
$PMF_LANG['ad_entry_del_2'] = 'de';
$PMF_LANG['ad_entry_del_3'] = 'deve ser removido?';
$PMF_LANG['ad_entry_delsuc'] = 'Removido com sucesso.';
$PMF_LANG['ad_entry_delfail'] = 'Não removido';
$PMF_LANG['ad_news_header'] = 'Título do Artigo';
$PMF_LANG['ad_news_text'] = 'Texto do Artigo';
$PMF_LANG['ad_news_link_url'] = 'Link: (<strong>Sem https://</strong>)!';
$PMF_LANG['ad_news_link_title'] = 'Título do link:';
$PMF_LANG['ad_news_link_target'] = 'Target do link';
$PMF_LANG['ad_news_link_window'] = 'Link abre em nova janela';
$PMF_LANG['ad_news_link_faq'] = 'Link dentro da FAQ';
$PMF_LANG['ad_news_add'] = 'Adicionar noticias';
$PMF_LANG['ad_news_id'] = '#';
$PMF_LANG['ad_news_headline'] = 'Título';
$PMF_LANG['ad_news_date'] = 'Data';
$PMF_LANG['ad_news_action'] = 'Ação';
$PMF_LANG['ad_news_update'] = 'atualizar';
$PMF_LANG['ad_news_delete'] = 'remover';
$PMF_LANG['ad_news_nodata'] = 'Dados não encontrados';
$PMF_LANG['ad_news_updatesuc'] = 'Notícia atualizada.';
$PMF_LANG['ad_news_del'] = 'Tem certeza que deseja remover esta noticia?';
$PMF_LANG['ad_news_yesdelete'] = 'Sim';
$PMF_LANG['ad_news_nodelete'] = 'Não';
$PMF_LANG['ad_news_delsuc'] = 'Notícia removida.';
$PMF_LANG['ad_news_updatenews'] = 'Atualizar notícia';
$PMF_LANG['ad_categ_new'] = 'Adicionar Categoria';
$PMF_LANG['ad_categ_catnum'] = 'Categoria número:';
$PMF_LANG['ad_categ_subcatnum'] = 'Subcategoria número:';
$PMF_LANG['ad_categ_nya'] = '<em>indisponível</em>';
$PMF_LANG['ad_categ_titel'] = 'Título da Categoria';
$PMF_LANG['ad_categ_add'] = 'Adicionar Categoria';
$PMF_LANG['ad_categ_existing'] = 'Categorias Existentes';
$PMF_LANG['ad_categ_id'] = '#';
$PMF_LANG['ad_categ_categ'] = 'Categoria';
$PMF_LANG['ad_categ_subcateg'] = 'Subcategoria';
$PMF_LANG['ad_categ_action'] = 'Ação';
$PMF_LANG['ad_categ_update'] = 'atualizar';
$PMF_LANG['ad_categ_delete'] = 'remover';
$PMF_LANG['ad_categ_updatecateg'] = 'Atualizar Categoria';
$PMF_LANG['ad_categ_nodata'] = 'Dados não encontrados';
$PMF_LANG['msgCategoryRemark'] = 'Os registros existentes deixarão de ser visíveis se a categoria for removida.<br>Especifique uma nova categoria para os artigos ou removas os artigos.';
$PMF_LANG['ad_categ_edit_1'] = 'Editar';
$PMF_LANG['ad_categ_edit_2'] = 'Categoria';
$PMF_LANG['ad_categ_added'] = 'Categoria adicionada.';
$PMF_LANG['ad_categ_updated'] = 'Categoria atualizada.';
$PMF_LANG['ad_categ_del_yes'] = 'Sim';
$PMF_LANG['ad_categ_del_no'] = 'Não';
$PMF_LANG['ad_categ_deletesure'] = 'Tem certeza que deseja remover esta categoria?';
$PMF_LANG['ad_categ_deleted'] = 'Categoria removida.';
$PMF_LANG['ad_cookie_cookiesuc'] = 'Cookie adicionado com <strong>sucesso</strong>.';
$PMF_LANG['ad_cookie_already'] = 'Um cookie já existe:';
$PMF_LANG['ad_cookie_again'] = 'Alterar o cookie?';
$PMF_LANG['ad_cookie_delete'] = 'remover cookie';
$PMF_LANG['ad_cookie_no'] = 'Nã existe cookie salvo. Com um cookie pode evitar fazer o login:';
$PMF_LANG['ad_cookie_set'] = 'Adicionar cookie';
$PMF_LANG['ad_cookie_deleted'] = 'Cookie removido com sucesso.';
$PMF_LANG['ad_adminlog'] = 'Log do Administrador';
$PMF_LANG['ad_passwd_cop'] = 'Alterar senha';
$PMF_LANG['ad_passwd_old'] = 'Senha antiga';
$PMF_LANG['ad_passwd_new'] = 'Nova senha';
$PMF_LANG['ad_passwd_con'] = 'Confirma senha';
$PMF_LANG['ad_passwd_change'] = 'Alterar senha';
$PMF_LANG['ad_passwd_suc'] = 'Senha alterada com sucesso.';
$PMF_LANG['ad_passwd_remark'] = '<strong>ATENÇÃO:</strong><br>Você deve fazer o login novamente!';
$PMF_LANG['ad_passwd_fail'] = 'A senha antiga <strong>deve</strong> ser digitada corretamente e ambas as novas senhas devem ser <strong>iguais</strong>.';
$PMF_LANG['ad_adus_adduser'] = 'Adicionar Usuário';
$PMF_LANG['ad_adus_name'] = 'Usuário';
$PMF_LANG['ad_adus_password'] = 'Senha';
$PMF_LANG['ad_adus_add'] = 'Adicionar Usuário';
$PMF_LANG['ad_adus_suc'] = 'Usuário adicionado com <strong>sucesso</strong>.';
$PMF_LANG['ad_adus_edit'] = 'Editar perfil';
$PMF_LANG['ad_adus_dberr'] = '<strong>erro na base de dados!</strong>';
$PMF_LANG['ad_adus_exerr'] = 'Usuário já existe.';
$PMF_LANG['ad_sess_id'] = 'ID';
$PMF_LANG['ad_sess_sid'] = 'ID-Sessão';
$PMF_LANG['ad_sess_ip'] = 'Endereço IP';
$PMF_LANG['ad_sess_time'] = 'Hora';
$PMF_LANG['ad_sess_pageviews'] = 'Visualizações da Página';
$PMF_LANG['ad_sess_search'] = 'Pesquisa';
$PMF_LANG['ad_sess_sfs'] = 'Pesquisar Sessões';
$PMF_LANG['ad_sess_s_ip'] = 'IP:';
$PMF_LANG['ad_sess_s_minct'] = 'Ações min.:';
$PMF_LANG['ad_sess_s_date'] = 'Data';
$PMF_LANG['ad_sess_s_after'] = 'depois';
$PMF_LANG['ad_sess_s_before'] = 'antes';
$PMF_LANG['ad_sess_s_search'] = 'Pesquisa';
$PMF_LANG['ad_sess_session'] = 'Sessão';
$PMF_LANG['ad_sess_r'] = 'Resultados de pesquisa de';
$PMF_LANG['ad_sess_referer'] = 'Referência:';
$PMF_LANG['ad_sess_browser'] = 'Navegador:';
$PMF_LANG['ad_sess_ai_rubrik'] = 'Categoria:';
$PMF_LANG['ad_sess_ai_artikel'] = 'Registro:';
$PMF_LANG['ad_sess_ai_sb'] = 'Texto-Pesquisas:';
$PMF_LANG['ad_sess_ai_sid'] = 'ID Sessão:';
$PMF_LANG['ad_sess_back'] = 'Voltar';
$PMF_LANG['ad_rs'] = 'Estatísticas de avaliação';
$PMF_LANG['ad_rs_rating_1'] = 'Avaliação de';
$PMF_LANG['ad_rs_rating_2'] = 'Usuário mostra:';
$PMF_LANG['ad_rs_red'] = 'Vermelho';
$PMF_LANG['ad_rs_green'] = 'Verde';
$PMF_LANG['ad_rs_altt'] = 'com uma média inferior a 2';
$PMF_LANG['ad_rs_ahtf'] = 'com uma média superior a 4';
$PMF_LANG['ad_rs_no'] = 'Sem Avaliação';
$PMF_LANG['ad_auth_insert'] = 'Entre com seu usuário e senha.';
$PMF_LANG['ad_auth_user'] = 'Usuário:';
$PMF_LANG['ad_auth_passwd'] = 'Senha:';
$PMF_LANG['ad_auth_ok'] = 'OK';
$PMF_LANG['ad_auth_reset'] = 'Limpar';
$PMF_LANG['ad_auth_fail'] = 'Login não encontrado.';
$PMF_LANG['ad_auth_sess'] = 'O ID da sessão foi passado.';
$PMF_LANG['ad_config_edit'] = 'Editar configuração';
$PMF_LANG['ad_config_save'] = 'Salvar configuração';
$PMF_LANG['ad_config_reset'] = 'Reiniciar';
$PMF_LANG['ad_config_saved'] = 'A configuração foi salva com sucesso.';
$PMF_LANG['ad_menu_editconfig'] = 'Editar configuração';
$PMF_LANG['ad_att_none'] = 'Sem anexos disponíveis';
$PMF_LANG['ad_att_att'] = 'Arquivo';
$PMF_LANG['ad_att_add'] = 'Anexar arquivo';
$PMF_LANG['ad_entryins_suc'] = 'Registro salvo com sucesso.';
$PMF_LANG['ad_entryins_fail'] = 'Ocorreu um erro.';
$PMF_LANG['ad_att_del'] = 'Remover';
$PMF_LANG['ad_att_nope'] = 'Os anexos estão disponíveis somente quando o registro for editado.';
$PMF_LANG['ad_att_delsuc'] = 'O anexo foi removido com sucesso.';
$PMF_LANG['ad_att_delfail'] = 'Ocorreu um erro ao remover o anexo.';
$PMF_LANG['ad_entry_add'] = 'Criar Registro';
$PMF_LANG['ad_csv_make'] = 'Um backup é uma imagem completa do conteúdo da base de dados. Um backup deve ser feito pelo menos uma vez por mês. O formato do backup é suportado nativamente pelo MySQL e pode ser usado em aplicações externas como phpMyAdmin ou pela linha de comandos com o cliente MySQL.';
$PMF_LANG['ad_csv_link'] = 'Download backup';
$PMF_LANG['ad_csv_head'] = 'Criar backup';
$PMF_LANG['ad_att_addto'] = 'Adicionar anexo';
$PMF_LANG['ad_att_butt'] = 'OK';
$PMF_LANG['ad_att_suc'] = 'Arquivo anexado com sucesso.';
$PMF_LANG['ad_att_fail'] = 'Ocorreu um erro ao anexar o arquivo.';
$PMF_LANG['ad_att_close'] = 'Fechar esta janela';
$PMF_LANG['ad_csv_restore'] = 'Através desse formulário você pode restaurar o conteúdo da base de dados com um backup prévio feito pelo phpMyFAQ. Por favor note que os dados existentes serão removidos.';
$PMF_LANG['ad_csv_file'] = 'Arquivo';
$PMF_LANG['ad_csv_ok'] = 'OK';
$PMF_LANG['ad_csv_linklog'] = 'LOG\'s backup';
$PMF_LANG['ad_csv_linkdat'] = 'dados backup';
$PMF_LANG['ad_csv_head2'] = 'Restaurar';
$PMF_LANG['ad_csv_no'] = 'Backup inválido.';
$PMF_LANG['ad_csv_prepare'] = 'Preparando as queries da base de dados...';
$PMF_LANG['ad_csv_process'] = 'Executando...';
$PMF_LANG['ad_csv_of'] = 'de';
$PMF_LANG['ad_csv_suc'] = 'com sucesso.';
$PMF_LANG['ad_csv_backup'] = 'Backup';
$PMF_LANG['ad_csv_rest'] = 'Restaurar um backup';
$PMF_LANG['ad_menu_backup'] = 'Backup';
$PMF_LANG['ad_logout'] = 'Sessão terminada com sucesso.';
$PMF_LANG['ad_news_edit'] = 'Editar notícias';
$PMF_LANG['ad_cookie'] = 'Cookies';
$PMF_LANG['ad_sess_head'] = 'Ver sessão';
$PMF_LANG['msgAddCategory'] = 'Adicionar Categoria';
$PMF_LANG['ad_kateg_rename'] = 'Renomear';
$PMF_LANG['ad_adminlog_date'] = 'Data';
$PMF_LANG['ad_adminlog_user'] = 'Usuário';
$PMF_LANG['ad_adminlog_ip'] = 'Endereço IP';
$PMF_LANG['ad_stat_sess'] = 'Sessões';
$PMF_LANG['ad_stat_days'] = 'Dias';
$PMF_LANG['ad_stat_vis'] = 'Sessões (Visitas)';
$PMF_LANG['ad_stat_vpd'] = 'Visitas por Dia';
$PMF_LANG['ad_stat_fien'] = 'Log Inicial';
$PMF_LANG['ad_stat_laen'] = 'Último Log';
$PMF_LANG['ad_stat_browse'] = 'visualizar Sessões';
$PMF_LANG['ad_stat_ok'] = 'OK';
$PMF_LANG['ad_ques_take'] = 'Aceitar pergunta e editar';
$PMF_LANG['no_cats'] = 'Sem categoria';
$PMF_LANG['ad_log_lger'] = 'Senha ou Usuário inválido.';
$PMF_LANG['ad_log_sess'] = 'Sessão expirou.';
$PMF_LANG['ad_log_edit'] = '"Editar Usuário"-Formulário do Usuário: ';
$PMF_LANG['ad_log_crea'] = 'Formulário "Novo artigo".';
$PMF_LANG['ad_log_crsa'] = 'Criado novo registro.';
$PMF_LANG['ad_log_ussa'] = 'Dados atualizados para o seguinte Usuário: ';
$PMF_LANG['ad_log_usde'] = 'Removido o seguinte Usuário: ';
$PMF_LANG['ad_log_beed'] = 'Formulário de edição para o seguinte Usuário: ';
$PMF_LANG['ad_log_bede'] = 'Removido o registro: ';
$PMF_LANG['msgVisits'] = 'Visitas';
$PMF_LANG['ad_start_articles'] = 'Artigos';
$PMF_LANG['ad_start_comments'] = 'Comentários';
$PMF_LANG['ad_categ_paste'] = 'colar';
$PMF_LANG['ad_categ_cut'] = 'cortar';
$PMF_LANG['msgCopy'] = 'copiar';
$PMF_LANG['ad_categ_process'] = 'Processando categorias...';
$PMF_LANG['err_NotAuth'] = '<strong>Sem autorização.</strong>';
$PMF_LANG['msgPreviusPage'] = 'Página anterior';
$PMF_LANG['msgNextPage'] = 'próxima página';
$PMF_LANG['msgPageDoublePoint'] = 'Página: ';
$PMF_LANG['msgMainCategory'] = 'Categoria principal';
$PMF_LANG['ad_passwdsuc'] = 'A sua senha foi alterada';
$PMF_LANG['msgPDF'] = 'Versão PDF';
$PMF_LANG['ad_xml_head'] = 'Backup XML';
$PMF_LANG['ad_xml_hint'] = 'Salvar todos os registros do seu FAQ num arquivo XML.';
$PMF_LANG['ad_xml_gen'] = 'Criar arquivo XML';
$PMF_LANG['ad_entry_locale'] = 'Idioma';
$PMF_LANG['msgLanguageSubmit'] = 'Escolha o idioma';
$PMF_LANG['ad_entry_preview'] = 'Pré-visualizar';
$PMF_LANG['ad_attach_1'] = 'Escolha um diretório para anexos na configuração';
$PMF_LANG['ad_attach_2'] = 'Escolha um link para anexos na configuração';
$PMF_LANG['ad_attach_3'] = 'O arquivo attachment.php não pode ser acessado sem autenticação.';
$PMF_LANG['ad_attach_4'] = 'O anexo deve ser inferior a %s Bytes.';
$PMF_LANG['ad_menu_export'] = 'Exportar o seu FAQ';
$PMF_LANG['ad_export_file'] = 'Erro: Impossível escrever arquivo.';
$PMF_LANG['ad_export_pdf'] = 'Exportar todos os registros em PDF';
$PMF_LANG['permission::add_user'] = 'Adicionar usuário';
$PMF_LANG['permission::edit_user'] = 'Editar usuário';
$PMF_LANG['permission::delete_user'] = 'Excluir usuário';
$PMF_LANG['permission::add_faq'] = 'Adicionar registro';
$PMF_LANG['permission::edit_faq'] = 'Editar registro';
$PMF_LANG['permission::delete_faq'] = 'Excluir registro';
$PMF_LANG['permission::viewlog'] = 'Ver log';
$PMF_LANG['permission::adminlog'] = 'Ver log do administrador';
$PMF_LANG['permission::delcomment'] = 'Excluir comentário';
$PMF_LANG['permission::addnews'] = 'Adicionar notícia';
$PMF_LANG['permission::editnews'] = 'Editar notícia';
$PMF_LANG['permission::delnews'] = 'Excluir notícia';
$PMF_LANG['permission::addcateg'] = 'Adicionar categoria';
$PMF_LANG['permission::editcateg'] = 'Editar categoria';
$PMF_LANG['permission::delcateg'] = 'Excluir categoria';
$PMF_LANG['permission::passwd'] = 'Alterar senha';
$PMF_LANG['permission::editconfig'] = 'Editar configuração';
$PMF_LANG['permission::addatt'] = 'Adicionar arquivo anexo';
$PMF_LANG['permission::delatt'] = 'Excluir arquivo anexo';
$PMF_LANG['permission::backup'] = 'Criar backup';
$PMF_LANG['permission::restore'] = 'Restaurar backup';
$PMF_LANG['permission::delquestion'] = 'Excluir perguntas abertas';
$PMF_LANG['permission::changebtrevs'] = 'Editar revisões';
$PMF_LANG['permission::addglossary'] = 'Adicionar item ao dicionário';
$PMF_LANG['permission::editglossary'] = 'Editar item do dicionário';
$PMF_LANG['permission::delglossary'] = 'Deletar item do dicionário';
$PMF_LANG['permission::addgroup'] = 'Adicionar contas de grupo';
$PMF_LANG['permission::editgroup'] = 'Editar contas de grupo';
$PMF_LANG['permission::delgroup'] = 'Excluir contas de grupo';
$PMF_LANG['permission::addattachment'] = 'Direito de acrescentar anexos';
$PMF_LANG['permission::editattachment'] = 'Direito de editar anexos';
$PMF_LANG['permission::delattachment'] = 'Direito de apagar anexos';
$PMF_LANG['permission::dlattachment'] = 'Direito de fazer download de anexos';
$PMF_LANG['permission::reports'] = 'Direito de gerar relatórios';
$PMF_LANG['permission::addfaq'] = 'Direito de acrescentar FAQs no frontend';
$PMF_LANG['permission::addquestion'] = 'Direito de acrescentar perguntas no frontend';
$PMF_LANG['permission::addcomment'] = 'Direito de adicionar comentários no frontend';
$PMF_LANG['permission::editinstances'] = 'Direito de editar instâncias multi-site';
$PMF_LANG['permission::addinstances'] = 'Direito de acrescentar instâncias multi-site';
$PMF_LANG['permission::delinstances'] = 'Direito de excluir instâncias multi-site';
$PMF_LANG['permission::export'] = 'Direito de exportar o FAQ completo';
$PMF_LANG['msgAttachedFiles'] = 'Arquivos anexados';
$PMF_LANG['ad_user_action'] = 'Ação';
$PMF_LANG['msgEmail'] = 'Endereço de E-mail:';
$PMF_LANG['ad_entry_allowComments'] = 'Permitir comentários';
$PMF_LANG['msgWriteNoComment'] = 'Não pode comentar este artigo';
$PMF_LANG['msgRealname'] = 'Nome:';
$PMF_LANG['ad_export_generate_pdf'] = 'Gerar arquivo PDF';
$PMF_LANG['ad_export_full_faq'] = 'Exportar FAQ em PDF: ';
$PMF_LANG['err_bannedIP'] = 'O seu IP está banido.';
$PMF_LANG['err_SaveQuestion'] = 'Campos obrigatórios: <strong>Nome</strong>, <strong>e-mail</strong> e <strong>a sua pergunta</strong>!<br><br><a href="nojavascript...history.back();">voltar</a><br><br>';
$PMF_LANG['ad_entry_fontcolor'] = 'Cor da fonte:';
$PMF_LANG['ad_entry_fontsize'] = 'Tamanho da fonte:';
$PMF_LANG['ad_categ_new_main_cat'] = 'como a nova categoria principal';
$PMF_LANG['ad_categ_paste_error'] = 'Impopssível mover esta categoria.';
$PMF_LANG['ad_categ_move'] = 'mover categoria';
$PMF_LANG['ad_categ_lang'] = 'Idioma';
$PMF_LANG['ad_categ_desc'] = 'Descrição';
$PMF_LANG['ad_categ_change'] = 'Trocar com';
$PMF_LANG['lostPassword'] = 'Esqueceu a senha? Clique aqui.';
$PMF_LANG['lostpwd_err_1'] = 'Erro: Nome de usuário e e-mail não foram encontrados.';
$PMF_LANG['lostpwd_err_2'] = 'Erro: Entradas inválidas!';
$PMF_LANG['lostpwd_text_1'] = 'Obrigado por solicitar a informação da sua conta.';
$PMF_LANG['lostpwd_text_2'] = 'Por favor defina uma nova senha na seção de administração da FAQ.';
$PMF_LANG['lostpwd_mail_okay'] = 'E-Mail enviado.';
$PMF_LANG['msgButtonFetchLatestVersion'] = 'Obtenha a versão mais recente de phpMyFAQ';
$PMF_LANG['ad_xmlrpc_latest'] = 'Versão mais recente disponível em';
$PMF_LANG['ad_categ_select'] = 'Escolha o idioma';
$PMF_LANG['msgSitemap'] = 'Mapa do Site';
$PMF_LANG['err_inactiveArticle'] = 'Esta entrada está sendo revisada e não pode ser mostrada.';
$PMF_LANG['msgArticleCategories'] = 'Categorias para esta entrada';
$PMF_LANG['ad_entry_solution_id'] = 'ID de solução único';
$PMF_LANG['ad_entry_faq_record'] = 'Registro FAQ';
$PMF_LANG['ad_entry_new_revision'] = 'Criar nova revisão?';
$PMF_LANG['ad_entry_record_administration'] = 'Registro administração';
$PMF_LANG['ad_entry_revision'] = 'Revisão';
$PMF_LANG['ad_changerev'] = 'Selecione a Revisão';
$PMF_LANG['msgCaptcha'] = 'Digite os caracteres que aparecem na imagem';
$PMF_LANG['msgSelectCategories'] = 'Pesquisando em...';
$PMF_LANG['msgAllCategories'] = '... todas as categorias';
$PMF_LANG['ad_you_should_update'] = 'Seu phpMyFAQ está desatualizado. Você deve atualizar para a última versão disponível.';
$PMF_LANG['msgAdvancedSearch'] = 'Pesquisa avançada';
$PMF_LANG['spamControlCenter'] = 'Centro de controle de Spam';
$PMF_LANG['ad_session_expiring'] = 'Sua sessão irá expirar em %d minutos: gostaria de continuar trabalhando?';
$PMF_LANG['ad_stat_management'] = 'Gerenciamento de sessões';
$PMF_LANG['ad_stat_choose'] = 'Escolha o mês';
$PMF_LANG['ad_stat_delete'] = 'Apague imediatamente as sessões selecionadas';
$PMF_LANG['ad_menu_glossary'] = 'Dicionário';
$PMF_LANG['ad_glossary_add'] = 'Adicionar ao dicionário';
$PMF_LANG['ad_glossary_edit'] = 'Editar dicionário';
$PMF_LANG['ad_glossary_item'] = 'Item';
$PMF_LANG['ad_glossary_definition'] = 'Definição';
$PMF_LANG['ad_glossary_save'] = 'Salvar';
$PMF_LANG['ad_glossary_save_success'] = 'Informação salva com sucesso no dicionário';
$PMF_LANG['ad_glossary_save_error'] = 'Ocorreu um erro ao adicionar a nova entrada.';
$PMF_LANG['ad_glossary_update_success'] = 'Atualização do dicionário salva com sucesso';
$PMF_LANG['ad_glossary_update_error'] = 'Ocorreu um erro ao atualizar a entrada.';
$PMF_LANG['ad_glossary_delete'] = 'Remover entrada';
$PMF_LANG['ad_glossary_delete_success'] = 'Entrada do dicionário removida com sucesso';
$PMF_LANG['ad_glossary_delete_error'] = 'Ocorreu um erro ao remover a entrada.';
$PMF_LANG['msgNewQuestionVisible'] = 'A questão tem que ser revista antes de ser publicada.';
$PMF_LANG['msgQuestionsWaiting'] = 'Aguardando publicação pelos administradores: ';
$PMF_LANG['ad_entry_visibility'] = 'Publicar?';
$PMF_LANG['ad_user_error_password'] = 'Digite uma senha. ';
$PMF_LANG['ad_user_error_passwordsDontMatch'] = 'Senhas não coincidem. ';
$PMF_LANG['ad_user_error_loginInvalid'] = 'O nome de usuário especificado é inválido.';
$PMF_LANG['ad_user_error_noEmail'] = 'Digite um endereço de e-mail válido. ';
$PMF_LANG['ad_user_error_noRealName'] = 'Por favor digite o seu nome verdadeiro. ';
$PMF_LANG['ad_user_error_delete'] = 'Conta de usuário não pôde ser excluída. ';
$PMF_LANG['ad_user_error_noId'] = 'Nenhum ID especificado. ';
$PMF_LANG['ad_user_error_protectedAccount'] = 'Conta de usuário é protegida. ';
$PMF_LANG['ad_user_deleteUser'] = 'Excluir usuário';
$PMF_LANG['ad_user_status'] = 'Status:';
$PMF_LANG['ad_user_lastModified'] = 'Última modificação:';
$PMF_LANG['ad_gen_cancel'] = 'Cancelar';
$PMF_LANG['ad_menu_group_administration'] = 'Grupos';
$PMF_LANG['ad_user_loggedin'] = 'Logado como ';
$PMF_LANG['ad_group_details'] = 'Detalhes do Grupo';
$PMF_LANG['ad_group_add'] = 'Adicionar Grupo';
$PMF_LANG['ad_group_add_link'] = 'Adicionar Grupo';
$PMF_LANG['ad_group_name'] = 'Nome:';
$PMF_LANG['ad_group_description'] = 'Descrição:';
$PMF_LANG['ad_group_autoJoin'] = 'Auto-associação:';
$PMF_LANG['ad_group_suc'] = 'Grupo adicionado <strong>com sucesso</strong>.';
$PMF_LANG['ad_group_error_noName'] = 'Por favor digite o nome do grupo ';
$PMF_LANG['ad_group_error_delete'] = 'Grupo não pode ser excluído. ';
$PMF_LANG['ad_group_deleted'] = 'Grupo excluído com sucesso.';
$PMF_LANG['ad_group_deleteGroup'] = 'Excluir Grupo';
$PMF_LANG['ad_group_deleteQuestion'] = 'Você tem certeza que este grupo deve ser excluído?';
$PMF_LANG['ad_user_uncheckall'] = 'Desmarcar tudo';
$PMF_LANG['ad_group_membership'] = 'Membros do Grupo';
$PMF_LANG['ad_group_members'] = 'Membros';
$PMF_LANG['ad_group_addMember'] = '+';
$PMF_LANG['ad_group_removeMember'] = '-';
$PMF_LANG['ad_export_which_cat'] = 'Limitar os dados a serem exportados FAQ (opcional)';
$PMF_LANG['ad_export_cat_downwards'] = 'Incluir categorias abaixo?';
$PMF_LANG['ad_export_type'] = 'Formato de exportação';
$PMF_LANG['ad_export_type_choose'] = 'Escolha um dos formatos suportados:';
$PMF_LANG['ad_export_download_view'] = 'Faça o download ou visualização em linha?';
$PMF_LANG['ad_export_download'] = 'download';
$PMF_LANG['ad_export_view'] = 'visualização em linha';
$PMF_LANG['ad_export_gen_xhtml'] = 'Criar arquivo XHTML';
$PMF_LANG['ad_export_gen_docbook'] = 'Faça arquivo Docbook';
$PMF_LANG['ad_news_data'] = 'Novos dados';
$PMF_LANG['ad_news_author_name'] = 'Nome do Autor:';
$PMF_LANG['ad_news_author_email'] = 'Autor do e-mail:';
$PMF_LANG['ad_news_set_active'] = 'Ativar';
$PMF_LANG['ad_news_allowComments'] = 'Permitir comentários:';
$PMF_LANG['ad_news_expiration_window'] = 'Nova janela de tempo de validade (opcional)';
$PMF_LANG['ad_news_from'] = 'De:';
$PMF_LANG['ad_news_to'] = 'Para:';
$PMF_LANG['ad_news_insertfail'] = 'Ocorreu um erro ao inserir um novo item no banco de dados.';
$PMF_LANG['ad_news_updatefail'] = 'Ocorreu um erro na atualização de novos itens no banco de dados.';
$PMF_LANG['newsShowCurrent'] = 'Exibir notícias atuais.';
$PMF_LANG['newsShowArchive'] = 'Exibir notícias arquivadas.';
$PMF_LANG['newsArchive'] = ' Arquivo de notícias';
$PMF_LANG['newsWriteComment'] = 'Comentar este artigo';
$PMF_LANG['newsCommentDate'] = 'Adicionado em: ';
$PMF_LANG['ad_record_expiration_window'] = 'Janela de tempo de validade de registro (opcional)';
$PMF_LANG['adminHeaderDashboard'] = 'Painel de Controle';
$PMF_LANG['admin_mainmenu_users'] = 'Usuários';
$PMF_LANG['admin_mainmenu_content'] = 'Conteúdo';
$PMF_LANG['admin_mainmenu_statistics'] = 'Estatísticas';
$PMF_LANG['admin_mainmenu_backup'] = 'Backup';
$PMF_LANG['admin_mainmenu_configuration'] = 'Configuração';
$PMF_LANG['admin_mainmenu_logout'] = 'Sair';
$PMF_LANG['ad_categ_owner'] = 'Categoria principal';
$PMF_LANG['adminSection'] = 'Administração';
$PMF_LANG['err_expiredArticle'] = 'Esta entrada está expirada e não pode ser exibida';
$PMF_LANG['err_expiredNews'] = 'Esta notícia está expirada e não pode ser exibida';
$PMF_LANG['err_inactiveNews'] = 'Esta notícia está sendo revisada e não pode ser exibida';
$PMF_LANG['msgSearchOnAllLanguages'] = 'Pesquisar em todos os idiomas';
$PMF_LANG['ad_entry_tags'] = 'Tags';
$PMF_LANG['msg_tags'] = 'Tags';
$PMF_LANG['msg_related_articles'] = 'Registros relacionados';
$PMF_LANG['ad_categ_trans_1'] = 'Traduzir';
$PMF_LANG['ad_categ_trans_2'] = 'Categoria';
$PMF_LANG['ad_categ_translatecateg'] = 'Traduzir Categoria';
$PMF_LANG['ad_categ_translate'] = 'Traduzir';
$PMF_LANG['ad_categ_transalready'] = 'Já traduzido em: ';
$PMF_LANG['ad_categ_deletealllang'] = 'Excluir em todos os idiomas?';
$PMF_LANG['ad_categ_deletethislang'] = 'Excluir neste idioma?';
$PMF_LANG['ad_categ_translated'] = 'A categoria foi traduzida.';
$PMF_LANG['msgCategoryMatrix'] = 'Resumo';
$PMF_LANG['ad_menu_categ_structure'] = 'Resumo de categoria incluindo seus idiomas';
$PMF_LANG['ad_entry_userpermission'] = 'Permissões de usuário:';
$PMF_LANG['ad_entry_grouppermission'] = 'Permissões de grupo:';
$PMF_LANG['ad_entry_all_users'] = 'Acesso para todos usuários';
$PMF_LANG['ad_entry_restricted_users'] = 'Restringir acesso para';
$PMF_LANG['ad_entry_all_groups'] = 'Acesso para todos grupos';
$PMF_LANG['ad_entry_restricted_groups'] = 'Restringir acesso para';
$PMF_LANG['ad_session_expiration'] = 'Tempo para sua sessão expirar';
$PMF_LANG['ad_user_active'] = 'ativo';
$PMF_LANG['ad_user_blocked'] = 'bloqueado';
$PMF_LANG['ad_user_protected'] = 'protegido';
$PMF_LANG['ad_entry_intlink'] = 'Selecione um registro da FAQ para inserir isso como um link...';
$PMF_LANG['ad_categ_paste2'] = 'Colar depois';
$PMF_LANG['msgCategoryRemark_overview'] = 'A ordem correta de categorias será mostrada se todas as categorias forem definidas para o idioma atual (primeira coluna).';
$PMF_LANG['msgUsersOnline'] = '%d Convidados e %d Registrados';
$PMF_LANG['ad_adminlog_del_older_30d'] = 'Apagar os registros após 30 dias';
$PMF_LANG['ad_adminlog_delete_success'] = 'Registros antigos excluídos com sucesso.';
$PMF_LANG['ad_adminlog_delete_failure'] = 'Não há registros excluídos: ocorreu um erro ao executar a operação.';
$PMF_LANG['ad_quicklinks'] = 'Links rápidos';
$PMF_LANG['ad_quick_category'] = 'Adicionar nova categoria';
$PMF_LANG['ad_quick_record'] = 'Adicionar nova FAQ';
$PMF_LANG['ad_quick_user'] = 'Adicionar novo usuário';
$PMF_LANG['ad_quick_group'] = 'Adicionar novo grupo';
$PMF_LANG['msgNewTranslationHeader'] = 'Sugestão de tradução';
$PMF_LANG['msgNewTranslationAddon'] = 'Sua proposta não será publicada imediatamente, mas será liberado pelo administrador após o recebimento. Os campos obrigatórios são <strong>Seu Nome</strong>, <strong>seu email</strong>, <strong>manchete tradução</strong> e <strong>sua faq tradução</strong>. Por favor separe as palavras-chave com espaço apenas.';
$PMF_LANG['msgNewTransSourcePane'] = 'Painel fonte';
$PMF_LANG['msgNewTranslationPane'] = 'Painel de tradução';
$PMF_LANG['msgNewTranslationName'] = 'Seu Nome:';
$PMF_LANG['msgNewTranslationMail'] = 'Seu endereço de e-mail:';
$PMF_LANG['msgNewTranslationKeywords'] = 'Palavras-chave:';
$PMF_LANG['msgNewTranslationSubmit'] = 'Envie sua sugestão';
$PMF_LANG['msgTranslate'] = 'Traduzir este FAQ';
$PMF_LANG['msgTranslateSubmit'] = 'Iniciando a tradução...';
$PMF_LANG['msgNewTranslationThanks'] = 'Obrigado por sua sugestão de tradução!';
$PMF_LANG['ad_news_link_parent'] = 'Abrir o link na janela principal';
$PMF_LANG['ad_menu_comments'] = 'Comentários';
$PMF_LANG['adminHeaderComments'] = 'Comentários da administração';
$PMF_LANG['msgAdminCommentFaqs'] = 'Comentários no registro da FAQ:';
$PMF_LANG['msgAdminCommentNews'] = 'Comentários em novos registros:';
$PMF_LANG['ad_groups'] = 'Grupos';
$PMF_LANG['ad_conf_order_id'] = 'ID (padrão)';
$PMF_LANG['ad_conf_order_thema'] = 'Título';
$PMF_LANG['ad_conf_order_visits'] = 'Número de visitantes';
$PMF_LANG['ad_conf_order_updated'] = 'Data';
$PMF_LANG['ad_conf_order_author'] = 'Autor';
$PMF_LANG['ad_conf_desc'] = 'decrescente';
$PMF_LANG['ad_conf_asc'] = 'crescente';
$PMF_LANG['mainControlCenter'] = 'Configuração principal';
$PMF_LANG['recordsControlCenter'] = 'Configuração de registros da FAQ';
$PMF_LANG['msgInstantResponse'] = 'Pesquisa rápida';
$PMF_LANG['msgInstantResponseMaxRecords'] = '. Procurar abaixo o primeiro %d registros.';
$PMF_LANG['msgAllCatArticles'] = 'Registros nesta categoria';
$PMF_LANG['msgDescriptionInstantResponse'] = 'Basta digitar e encontrar as respostas ...';
$PMF_LANG['msgTagSearch'] = 'Entradas tag';
$PMF_LANG['ad_pmf_info'] = 'Estatísticas do phpMyFAQ';
$PMF_LANG['msgOnlineVersionCheck'] = 'Verificação online da versão';
$PMF_LANG['ad_system_info'] = 'Informação do Sistema';
$PMF_LANG['msgRegisterUser'] = 'Cadastrar-se?';
$PMF_LANG['msgUsername'] = 'Usuário:';
$PMF_LANG['errorRegistration'] = 'Este campo é obrigatório';
$PMF_LANG['submitRegister'] = 'Cadastrar';
$PMF_LANG['msgUserData'] = 'As informações do usuário necessárias para o registro';
$PMF_LANG['captchaError'] = 'Digite o código captcha corretamente';
$PMF_LANG['msgRegError'] = 'Ocorreram os seguintes erros. Por favor, corrigí-los:';
$PMF_LANG['successMessage'] = 'Seu cadastro foi realizado com sucesso. Em breve você receberá um e-mail de confirmação com seus dados de login.';
$PMF_LANG['msgRegThankYou'] = 'Obrigado pela sua inscrição';
$PMF_LANG['emailRegSubject'] = '[%sitename%] Inscrição: novo usuário';
$PMF_LANG['msgMostPopularSearches'] = 'As pesquisas mais populares são:';
$PMF_LANG['ad_menu_searchstats'] = 'Busca de Estatísticas';
$PMF_LANG['ad_searchstats_search_term'] = 'Palavra-chave';
$PMF_LANG['ad_searchstats_search_term_count'] = 'Contagem';
$PMF_LANG['ad_searchstats_search_term_lang'] = 'Linguagem';
$PMF_LANG['ad_searchstats_search_term_percentage'] = 'Percentagem';
$PMF_LANG['ad_record_sticky'] = 'Permanente';
$PMF_LANG['ad_entry_sticky'] = 'Permanente';
$PMF_LANG['stickyRecordsHeader'] = 'FAQs permanentes';
$PMF_LANG['ad_menu_stopwordsconfig'] = 'Palavras ignoradas';
$PMF_LANG['ad_config_stopword_input'] = 'Adicionar uma nova palavra a ser ignorada';
$PMF_LANG['msgSendMailDespiteEverything'] = 'Ainda não existe uma resposta adequada (um e-mail será enviado)';
$PMF_LANG['msgSendMailIfNothingIsFound'] = 'A resposta desejada está listada nos resultados acima?';
$PMF_LANG['msgChooseLanguageToTranslate'] = 'Por favor, selecione o idioma para tradução';
$PMF_LANG['msgLangDirIsntWritable'] = 'O diretório de tradução está sem permissão para gravar';
$PMF_LANG['ad_menu_translations'] = 'Menu de traduções';
$PMF_LANG['ad_start_notactive'] = 'Aguardando a ativação';
$PMF_LANG['msgTransToolAddNewTranslation'] = 'Adicionar nova tradução';
$PMF_LANG['msgTransToolLanguage'] = 'Idioma';
$PMF_LANG['msgTransToolActions'] = 'Ações';
$PMF_LANG['msgTransToolWritable'] = 'Gravável';
$PMF_LANG['msgEdit'] = 'Editar';
$PMF_LANG['msgDelete'] = 'Excluir';
$PMF_LANG['msgYes'] = 'sim';
$PMF_LANG['msgNo'] = 'não';
$PMF_LANG['msgVariable'] = 'Variável';
$PMF_LANG['msgCancel'] = 'Cancelar';
$PMF_LANG['msgSave'] = 'Salvar';
$PMF_LANG['msgSaving3Dots'] = 'salvando ...';
$PMF_LANG['msgRemoving3Dots'] = 'removendo ...';
$PMF_LANG['msgLanguage'] = 'Idioma';
$PMF_LANG['msgTransToolLanguageCharset'] = 'Charset do idioma';
$PMF_LANG['msgTransToolLanguageDir'] = 'Direção do idioma';
$PMF_LANG['msgTransToolLanguageDesc'] = 'Descrição do idioma';
$PMF_LANG['msgTransToolAddAuthor'] = 'Adicione Autor';
$PMF_LANG['msgTransToolCreateTranslation'] = 'Criar tradução';
$PMF_LANG['msgTransToolTransCreated'] = 'Nova tradução criada com sucesso';
$PMF_LANG['msgTransToolCouldntCreateTrans'] = 'Não foi possível criar nova tradução';
$PMF_LANG['msgAdding3Dots'] = 'adicionando ...';
$PMF_LANG['msgTransToolSendToTeam'] = 'Enviar à equipe do phpMyFAQ';
$PMF_LANG['msgSending3Dots'] = 'enviando ...';
$PMF_LANG['msgTransToolFileSent'] = 'Arquivo de idioma foi enviado com sucesso para a equipe do phpMyFAQ. Muito obrigado por compartilhar.';
$PMF_LANG['msgTransToolErrorSendingFile'] = 'Houve um erro ao enviar o arquivo de idioma';
$PMF_LANG['msgTransToolPercent'] = 'Percentual';
$PMF_LANG['msgAttachmentNotFound'] = 'O arquivo que você está tentando baixar não foi encontrado neste servidor';
$PMF_LANG['ad_sess_noentry'] = 'Nenhum registro';
$LANG_CONF['main.language'] = array("select", "Arquivo de idioma");
$LANG_CONF['main.languageDetection'] = array("checkbox", "Habilitar detecção automática de idioma");
$LANG_CONF['main.titleFAQ'] = array("input", "Título da FAQ");
$LANG_CONF['main.currentVersion'] = array("print", "Versão da FAQ");
$LANG_CONF['main.metaDescription'] = array('input', 'Descrição da página');
$LANG_CONF['main.metaPublisher'] = array('input', 'Nome do Editor');
$LANG_CONF['main.administrationMail'] = array('input', 'E-mail do Administrador');
$LANG_CONF['main.contactInformation'] = array('area', 'Contato');
$LANG_CONF['main.send2friendText'] = array('area', 'Texto para página envie para um amigo');
$LANG_CONF['records.maxAttachmentSize'] = array('input', 'Tamanho máximo para anexos em Bytes (max. %sByte)');
$LANG_CONF['records.disableAttachments'] = array('checkbox', 'Colocar links para anexos no rodapé das entradas?');
$LANG_CONF['main.enableUserTracking'] = array('checkbox', 'Usar Tracking?');
$LANG_CONF['main.enableAdminLog'] = array('checkbox', 'Usar log de Administrador?');
$LANG_CONF['security.ipCheck'] = array('checkbox', 'Faz checagem do IP quando verificando os UINs no admin.php?');
$LANG_CONF['records.numberOfRecordsPerPage'] = array('input', 'Número de tópicos mostrados por página');
$LANG_CONF['records.numberOfShownNewsEntries'] = array('input', 'Número de artigos novos');
$LANG_CONF['security.bannedIPs'] = array('area', 'Banir estes IPs');
$LANG_CONF['ldap.ldapSupport'] = array('checkbox', 'Habilita suporte para LDAP? (padrão: desativado)');
$LANG_CONF['main.referenceURL'] = array('input', 'Suporte URL para verificação de link (e.g.: https://www.example.org/faq/)');
$LANG_CONF['records.enableVisibilityQuestions'] = array('checkbox', 'Desabilitar visibilidade de novas perguntas?');
$LANG_CONF['security.permLevel'] = array('select', 'Nível de permissão');
$LANG_CONF['spam.enableSafeEmail'] = array('checkbox', 'Imprimir e-mail do usuário de forma segura (padrão: ativado).');
$LANG_CONF['spam.checkBannedWords'] = array('checkbox', 'Verificar palavras proibidas no conteúdo do formulário público (padrão: ativado). ');
$LANG_CONF['spam.enableCaptchaCode'] = array('checkbox', 'Usar captcha para permitir o envio de formulários públicos (padrão: ativado).');
$LANG_CONF['records.numberOfRelatedArticles'] = array('input', 'Número de entradas relacionadas');
$LANG_CONF['records.orderby'] = array('select', 'Gravar ordenando (de acordo com as propriedades)');
$LANG_CONF['records.sortby'] = array('select', 'Gravar ordenando (descrescente ou crescente)');
$LANG_CONF['records.defaultActivation'] = array('checkbox', 'Ativar novos registros (padrão: desativado)');
$LANG_CONF['records.defaultAllowComments'] = array('checkbox', 'Permitir comentários para novos registros (padrão: proibido)');
$LANG_CONF['main.enableWysiwygEditor'] = array('checkbox', 'Habilitar o editor WYSIWYG do pacote (padrão: ativado)');
$LANG_CONF['records.attachmentsPath'] = array('input', 'Caminho onde os anexos serão salvos.<br><small>Caminho relativo significa uma pasta dentro da raiz da web</small>');
$PMF_LANG['msgTransToolNoteFileSaving'] = 'Esteja ciente que nenhum arquivo será escrito até você clicar no botão salvar';
$PMF_LANG['msgTransToolPageBufferRecorded'] = 'Página %d do buffer gravada com sucesso';
$PMF_LANG['msgTransToolErrorRecordingPageBuffer'] = 'Erro gravando a página %d do buffer';
$PMF_LANG['msgTransToolRecordingPageBuffer'] = 'Gravando a página %d do buffer';
$PMF_LANG['ad_record_active'] = 'Ativo';
$PMF_LANG['msgAttachmentInvalid'] = 'O link é inválido, informe ao administrador';
$PMF_LANG['list_all_users'] = 'Listar todos os usuários';
$PMF_LANG['records.orderingPopularFaqs.visits'] = 'listar os mais visitados';
$PMF_LANG['records.orderingPopularFaqs.voting'] = 'listar os mais votados';
$PMF_LANG['msgShowHelp'] = 'Por favor, separe as palavras por vírgulas.';
$PMF_LANG['msgUpdateFaqDate'] = 'atualizar';
$PMF_LANG['msgKeepFaqDate'] = 'manter';
$PMF_LANG['msgEditFaqDat'] = 'editar';
$LANG_CONF['search.numberSearchTerms'] = array('input', 'Número de termos de busca listados');
$LANG_CONF['records.orderingPopularFaqs'] = array('select', 'Ordenação das Top FAQs');
$PMF_LANG['plmsgHomeArticlesOnline']['0'] = 'Tem %d FAQ online';
$PMF_LANG['plmsgHomeArticlesOnline']['1'] = 'Temos %d FAQs online';
$PMF_LANG['plmsgViews']['0'] = '%d visualização';
$PMF_LANG['plmsgViews']['1'] = '%d visualizações';
$PMF_LANG['plmsgGuestOnline']['0'] = '%d Convidado';
$PMF_LANG['plmsgGuestOnline']['1'] = '%d Convidados';
$PMF_LANG['plmsgRegisteredOnline']['0'] = ' e %d Registrado';
$PMF_LANG['plmsgRegisteredOnline']['1'] = ' e %d Registrados';
$PMF_LANG['plmsgSearchAmount']['0'] = '%d resultado da pesquisa';
$PMF_LANG['plmsgSearchAmount']['1'] = '%d resultados da pesquisa';
$PMF_LANG['plmsgPagesTotal']['0'] = ' %d Página';
$PMF_LANG['plmsgPagesTotal']['1'] = ' %d Páginas';
$PMF_LANG['plmsgVotes']['0'] = '%d Voto';
$PMF_LANG['plmsgVotes']['1'] = '%d Votos';
$PMF_LANG['plmsgEntries']['0'] = '%d FAQ';
$PMF_LANG['plmsgEntries']['1'] = '%d FAQs';
$PMF_LANG['permission::addtranslation'] = 'adicionar tradução';
$PMF_LANG['permission::edittranslation'] = 'editar tradução';
$PMF_LANG['permission::deltranslation'] = 'excluir tradução';
$PMF_LANG['permission::approverec'] = 'aprovar os registros';
$PMF_LANG['ad_menu_upgrade'] = 'phpMyFAQ Atualizar';
$PMF_LANG['ad_you_shouldnt_update'] = 'Você possui a versão mais recente do phpMyFAQ.';
$PMF_LANG['msgSecureSwitch'] = 'Alterar para o modo seguro para efetuar o login!';
$LANG_CONF['layout.templateSet'] = array('select', 'Template definida para uso');
$LANG_CONF['records.enableAttachmentEncryption'] = array('checkbox', 'Habilitar criptografia dos anexos <br><small>Ignorado quando os anexos estão desabilitados</small>');
$LANG_CONF['records.defaultAttachmentEncKey'] = array('input', 'Chave padrão para criptografia de anexos<br><small>Ignorado quando os anexos estão desabilitados</small><br><small><font color="red">AVISO: Não altere esta chave depois de habilitar a opção de criptografia de anexos!!!</font></small>');
$LANG_CONF['security.useSslForLogins'] = array('checkbox', 'Permitir logins apenas com conexão segura? (padrão: desabilitado)');
$PMF_LANG['plmsgUserOnline']['0'] = '%d usuário online';
$PMF_LANG['msgShowMore'] = 'mostrar mais';
$PMF_LANG['msgQuestionAnswered'] = 'Pergunta respondida';
$PMF_LANG['msgMessageQuestionAnswered'] = 'Sua pergunta %s foi respondida. Por favor, verifique-a aqui';
$PMF_LANG['ad_stopwords_desc'] = 'Selecione o idioma para adicionar ou editar palavras ignoradas';
$PMF_LANG['ad_visits_per_day'] = 'Visitas por dia';
$PMF_LANG['ad_instance_add'] = 'Adicionar uma nova instância do phpMyFAQ multi-site';
$PMF_LANG['ad_instance_error_notwritable'] = 'A pasta /multisite não é gravável.';
$PMF_LANG['ad_instance_url'] = 'Instância URL';
$PMF_LANG['ad_instance_path'] = 'Caminho da instância';
$PMF_LANG['ad_instance_name'] = 'Nome da instância';
$PMF_LANG['ad_instance_email'] = 'Seu e-mail de Administrador';
$PMF_LANG['ad_instance_admin'] = 'Login de Administrador';
$PMF_LANG['ad_instance_password'] = 'Senha de Administrador';
$PMF_LANG['ad_instance_hint'] = 'Atenção: Vai demorar alguns segundos para criar uma nova instância phpMyFAQ!';
$PMF_LANG['ad_instance_button'] = 'Salvar instância';
$PMF_LANG['ad_instance_error_cannotdelete'] = 'Não foi possível excluir a instância ';
$PMF_LANG['ad_instance_config'] = 'Configuração da instância';
$PMF_LANG['msgAboutThisNews'] = 'Sobre essa notícia';
$PMF_LANG['msgAccessDenied'] = 'Acesso negado.';
$LANG_CONF['records.randomSort'] = array('checkbox', 'Ordenar FAQs randomicamente (padrão: desativado)');
$LANG_CONF['main.enableWysiwygEditorFrontend'] = array('checkbox', 'Ativar editor WYSIWYG no frontend (padrão: desativado)');
$LANG_CONF['main.enableGravatarSupport'] = array('checkbox', 'Suporte para Gravatar (padrão: desativado)');
$PMF_LANG['ad_menu_attachments'] = 'Anexos';
$PMF_LANG['ad_menu_attachment_admin'] = 'Administração de anexos';
$PMF_LANG['msgAttachmentsFilename'] = 'Nome do arquivo';
$PMF_LANG['msgAttachmentsFilesize'] = 'Tamanho do arquivo';
$PMF_LANG['msgAttachmentsMimeType'] = 'Tipo MIME';
$PMF_LANG['msgAttachmentsWannaDelete'] = 'Tem certeza que deseja excluir esse anexo?';
$PMF_LANG['msgAttachmentsDeleted'] = 'Anexo excluído <strong>com sucesso</strong>.';
$PMF_LANG['ad_menu_reports'] = 'Relatórios';
$PMF_LANG['ad_stat_report_fields'] = 'Campos';
$PMF_LANG['ad_stat_report_category'] = 'Categoria';
$PMF_LANG['ad_stat_report_sub_category'] = 'Subcategoria';
$PMF_LANG['ad_stat_report_translations'] = 'Traduções';
$PMF_LANG['ad_stat_report_language'] = 'Idioma';
$PMF_LANG['ad_stat_report_id'] = 'FAQ ID';
$PMF_LANG['ad_stat_report_sticky'] = 'FAQ Permanente';
$PMF_LANG['ad_stat_report_title'] = 'Pergunta';
$PMF_LANG['ad_stat_report_creation_date'] = 'Data';
$PMF_LANG['ad_stat_report_owner'] = 'Autor original';
$PMF_LANG['ad_stat_report_last_modified_person'] = 'Último autor';
$PMF_LANG['ad_stat_report_url'] = 'URL';
$PMF_LANG['ad_stat_report_visits'] = 'Visitas';
$PMF_LANG['ad_stat_report_make_report'] = 'Gerar relatório';
$PMF_LANG['ad_stat_report_make_csv'] = 'Exportar para CSV';
$PMF_LANG['msgRegistration'] = 'Cadastro';
$PMF_LANG['msgRegistrationCredentials'] = 'Para se cadastrar, digite seu nome, login e um e-mail válido.';
$PMF_LANG['msgRegistrationNote'] = 'Após o cadastro, você receberá um e-mail depois que um administrador aprová-lo.';
$PMF_LANG['ad_entry_changelog_history'] = 'Histórico de mudanças';
$LANG_CONF['security.ssoSupport'] = array('checkbox', 'Suporte para Single Sign On (padrão: desativado)');
$LANG_CONF['security.ssoLogoutRedirect'] = array('input', 'URL do serviço de redirecionamento de logout do Single Sign On');
$LANG_CONF['main.dateFormat'] = array('input', 'Formato de Data (padrão: Y-m-d H:i)');
$PMF_LANG['securityControlCenter'] = 'Configurações de segurança';
$PMF_LANG['ad_search_delsuc'] = 'O termo de busca foi excluído.';
$PMF_LANG['ad_search_delfail'] = 'O termo de busca não foi excluído.';
$PMF_LANG['msg_about_faq'] = 'Sobre essa FAQ';
$PMF_LANG['msgTableOfContent'] = 'Conteúdo';
$PMF_LANG['msgExportAllFaqs'] = 'Imprimir como PDF';
$PMF_LANG['msgOnlineVerificationCheck'] = 'Verificação online';
$PMF_LANG['msgOnlineVerificationCheckButton'] = 'Clique para verificar sua instalação phpMyFAQ';
$PMF_LANG['ad_verification_notokay'] = 'Sua versão do phpMyFAQ tem alterações locais';
$PMF_LANG['ad_verification_okay'] = 'Sua versão do phpMyFAQ foi verificada com sucesso.';
$PMF_LANG['cacheControlCenter'] = 'Configuração de Cache';
$PMF_LANG['msgAdminSearchFaqs'] = 'Procurar por FAQs';
$PMF_LANG['msg2answerFAQ'] = 'Respondido';
$PMF_LANG['headerUserControlPanel'] = 'Sua Conta';
$PMF_LANG['rememberMe'] = 'Lembre-me';
$PMF_LANG['ad_menu_instances'] = 'FAQ Multi-sites';
$PMF_LANG['ad_record_inactive'] = 'FAQs inativas';
$PMF_LANG['msgMode'] = 'Modo';
$PMF_LANG['msgMaintenanceMode'] = 'A FAQ está em manutenção';
$PMF_LANG['msgOnlineMode'] = 'A FAQ está online';
$LANG_CONF['security.enableLoginOnly'] = array('checkbox', 'FAQ completamente segura (padrão: desativado)');
$LANG_CONF['security.useSslOnly'] = array('checkbox', 'FAQ somente com SSL (padrão: desativado)');
$LANG_CONF['records.enableCloseQuestion'] = array('checkbox', 'Fechar pergunta aberta após respondê-la?');
$LANG_CONF['records.enableDeleteQuestion'] = array('checkbox', 'Apagar pergunta aberta após repondê-la?');
$LANG_CONF['main.maintenanceMode'] = array('checkbox', 'FAQ em modo de manutenção');
$PMF_LANG['searchControlCenter'] = 'Buscar';
$PMF_LANG['search.relevance.thema-content-keywords'] = 'Pergunta - Resposta - Palavras-chave';
$PMF_LANG['search.relevance.thema-keywords-content'] = 'Pergunta - Palavras-chave - Resposta';
$PMF_LANG['search.relevance.content-thema-keywords'] = 'Resposta - Pergunta - Palavras-chave';
$PMF_LANG['search.relevance.content-keywords-thema'] = 'Resposta - Palavras-chave - Pergunta';
$PMF_LANG['search.relevance.keywords-content-thema'] = 'Palavras-chave - Resposta - Pergunta';
$PMF_LANG['search.relevance.keywords-thema-content'] = 'Palavras-chave - Pergunta - Resposta';
$PMF_LANG['msgLoginUser'] = 'Login';
$LANG_CONF['search.relevance'] = array('select', 'Ordenar por relevância');
$LANG_CONF['search.enableRelevance'] = array('checkbox', 'Ativar suporte à relevância? (padrão: desabilitado)');
$LANG_CONF["main.enableCategoryRestrictions"] = ["checkbox", "Habilitar restrições de categoria"];
$PMF_LANG['ad_entry_not_visibility'] = 'não publicada';
$PMF_LANG['msgSeeFAQinFrontend'] = 'Ver FAQ no Frontend';
$PMF_LANG["msgRelatedTags"] = 'Adicionar Palavra de Busca';
$PMF_LANG["msgPopularTags"] = 'Buscas mais populares';
$LANG_CONF["search.enableHighlighting"] = ["checkbox", "Destacar termos de busca"];
$LANG_CONF["records.allowCommentsForGuests"] = ["checkbox", "Permitir comentários de visitantes"];
$LANG_CONF["records.allowQuestionsForGuests"] = ["checkbox", "Permitir que visitantes adicionem perguntas"];
$LANG_CONF["records.allowNewFaqsForGuests"] = ["checkbox", "Permitir inclusão de novas FAQs"];
$PMF_LANG["ad_searchterm_del"] = 'Remover todos os termos de buscas registrados';
$PMF_LANG["ad_searchterm_del_suc"] = 'Todos os termos de buscas foram removidos com sucesso.';
$PMF_LANG["ad_searchterm_del_err"] = 'Não foi possível remover todos os termos de busca.';
$LANG_CONF["records.hideEmptyCategories"] = ["checkbox", "Ocultar categorias vazias"];
$LANG_CONF["search.searchForSolutionId"] = ["checkbox", "Pesquisar por ID da solução"];
$LANG_CONF["socialnetworks.disableAll"] = ["checkbox", "Desabilitar todas as redes sociais"];
$PMF_LANG["ad_tag_delete_success"] = 'A tag foi removida com sucesso';
$PMF_LANG["ad_tag_delete_error"] = 'A tag não foi removida devido a um erro';
$PMF_LANG["seoCenter"] = 'SEO';
$LANG_CONF["seo.metaTagsHome"] = ["select", "Meta Tags da página inicial"];
$LANG_CONF["seo.metaTagsFaqs"] = ["select", "Meta Tags das FAQs"];
$LANG_CONF["seo.metaTagsCategories"] = ["select", "Meta Tags das páginas de categoria"];
$LANG_CONF["seo.metaTagsPages"] = ["select", "Meta Tags das páginas estáticas"];
$LANG_CONF["seo.metaTagsAdmin"] = ["select", "Meta Tags da Administração"];
$PMF_LANG["msgMatchingQuestions"] = 'Os seguintes resultados mais se aproximam da sua pergunta';
$PMF_LANG["msgFinishSubmission"] = 'Se nenhuma sugestão acima bater com sua pergunta, clique no botão abaixo para enviar sua pergunta.';
$LANG_CONF['spam.manualActivation'] = ["checkbox", "Ativar novos usuários manualmente (padrão: ativado)"];
$PMF_LANG['mailControlCenter'] = 'Configuração de e-mail';
$LANG_CONF['mail.remoteSMTP'] = ["checkbox", "Usar servidor SMTP remoto (padrão: desativado)"];
$LANG_CONF['mail.remoteSMTPServer'] = ["input", "Endereço do servidor"];
$LANG_CONF['mail.remoteSMTPUsername'] = ["input", "Nome de usuário"];
$LANG_CONF['mail.remoteSMTPPassword'] = ["password", "Senha"];
$LANG_CONF['security.enableRegistration'] = ["checkbox", "Habilitar cadastro para os visitantes"];
$LANG_CONF['main.customPdfHeader'] = ["area", "Cabeçalho personalizado do PDF (permitido HTML)"];
$LANG_CONF['main.customPdfFooter'] = ["area", "Rodapé personalizado do PDF (permitido HTML)"];
$LANG_CONF['records.allowDownloadsForGuests'] = ["checkbox", "Permitir downloads para os visitantes"];
$PMF_LANG["ad_msgNoteAboutPasswords"] = 'Atenção! Se você informar uma senha, a senha do usuário será sobrescrita.';
$PMF_LANG["ad_delete_all_votings"] = 'Limpar todas as votações';
$PMF_LANG["ad_categ_moderator"] = 'Moderadores';
$PMF_LANG['ad_clear_all_visits'] = 'Limpas todas as visitas';
$PMF_LANG['ad_reset_visits_success'] = 'A limpeza de visitas foi feita com sucesso.';
$LANG_CONF['main.enableMarkdownEditor'] = ["checkbox", "Habilitar editor de Markdown"];
$PMF_LANG['faqOverview'] = 'Visão geral da FAQ';
$PMF_LANG['ad_dir_missing'] = 'O diretório %s não foi encontrado.';
$LANG_CONF['main.enableSmartAnswering'] = ["checkbox", "Habilitar respostas inteligentes para as perguntas dos usuários"];
$LANG_CONF['search.enableElasticsearch'] = ["checkbox", "Habilitar suporte a Elasticsearch"];
$PMF_LANG['ad_menu_elasticsearch'] = 'Configuração do Elasticsearch';
$PMF_LANG['ad_es_create_index'] = 'Criar índice';
$PMF_LANG['ad_es_drop_index'] = 'Remover índice';
$PMF_LANG['ad_es_bulk_index'] = 'Importação completa';
$PMF_LANG['ad_es_create_index_success'] = 'Índice criado com sucesso.';
$PMF_LANG['ad_es_create_import_success'] = 'Importação feita com sucesso.';
$PMF_LANG['ad_es_drop_index_success'] = 'Índice removido com sucesso.';
$PMF_LANG['ad_export_generate_json'] = 'Criar arquivo JSON';
$PMF_LANG['ad_media_name_search'] = 'Buscar por nome da mídia';
$PMF_LANG['ad_admin_notes'] = 'Notas Privadas';
$PMF_LANG['ad_admin_notes_hint'] = ' (visível somente para editores)';
$PMF_LANG['ad_quick_entry'] = 'Adicionar nova FAQ nesta categoria';
$LANG_CONF['ldap.ldap_mapping.name'] = ["input", 'Mapeamento do LDAP para nome, "cn" quando estiver usando um ADS'];
$LANG_CONF['ldap.ldap_mapping.username'] = ["input", 'Mapeamento do LDAP para nome de usuário, "samAccountName" quando estiver usando ADS'];
$LANG_CONF['ldap.ldap_mapping.mail'] = ["input", 'Mapeamento do LDAP para email, "mail" quando estiver usando ADS'];
$LANG_CONF['ldap.ldap_mapping.memberOf'] = ["input", 'Mapeamento do LDAP para "member of" quando estiver usando grupos no LDAP'];
$LANG_CONF['ldap.ldap_use_domain_prefix'] = ["checkbox", 'Prefixo de domínio do LDAP, ex.: "DOMINIO\username"'];
$LANG_CONF['ldap.ldap_options.LDAP_OPT_PROTOCOL_VERSION'] = ["input", "Versão do protocolo do LDAP (padrão: 3)"];
$LANG_CONF['ldap.ldap_options.LDAP_OPT_REFERRALS'] = ["input", "LDAP referrals (padrão: 0)"];
$LANG_CONF['ldap.ldap_use_memberOf'] = ["checkbox", 'Habilitar suporte a grupos do LDAP, ex.: "DOMINIO\username"'];
$LANG_CONF['ldap.ldap_use_sasl'] = ["checkbox", "Habilitar suporte a SASL do LDAP"];
$LANG_CONF['ldap.ldap_use_multiple_servers'] = ["checkbox", "Habilitar suporte a múltiplos servidores LDAP"];
$LANG_CONF['ldap.ldap_use_anonymous_login'] = ["checkbox", "Habilitar conexão anônimas do LDAP"];
$LANG_CONF['ldap.ldap_use_dynamic_login'] = ["checkbox", "Habilitar vínculo dinâmico de usuário do LDAP"];
$LANG_CONF['ldap.ldap_dynamic_login_attribute'] = ["checkbox", 'Atributo do LDAP para vínculo dinâmico de usuário, "uid" quando estiver usando ADS'];
$LANG_CONF['seo.enableXMLSitemap'] = ["checkbox", "Habilitar sitemap XML"];
$PMF_LANG['ad_category_image'] = 'Imagem de Categoria';
$PMF_LANG["ad_user_show_home"] = 'Mostrar na página inicial';
$PMF_LANG['ad_view_faq'] = 'Ver FAQ';
$LANG_CONF['main.enableCategoryRestrictions'] = ["checkbox", "Habilitar restrições de categoria"];
$LANG_CONF['main.enableSendToFriend'] = ["checkbox", "Habilitar enviar para amigos"];
$PMF_LANG['msgUserRemovalText'] = 'Você pode solicitar a remoção de sua conta e de seus dados pessoais. Será enviado um email para a equipe de administradores. A equipe removerá sua conta, comentários e perguntas. Como esse é um processo manual, poderá levar até 24 horas para ser realizado. Quando terminar, você receberá um email confirmando sua remoção. ';
$PMF_LANG["msgUserRemoval"] = 'Solicitar remoção de usuário';
$PMF_LANG["ad_menu_RequestRemove"] = 'Solicitar remoção de usuário';
$PMF_LANG["msgContactRemove"] = 'Solicitação de remoção da equipe de administradores';
$PMF_LANG["msgContactPrivacyNote"] = 'Por favor, veja nossa';
$PMF_LANG["msgPrivacyNote"] = 'Declaração de Privacidade';
$LANG_CONF['main.enableAutoUpdateHint'] = ["checkbox", "Verificar automaticamente novas versões"];
$PMF_LANG['ad_user_is_superadmin'] = 'Super-Admin';
$PMF_LANG['ad_user_overwrite_passwd'] = 'Sobrescrever senha';
$LANG_CONF['records.enableAutoRevisions'] = ["checkbox", "Permitir o versionamento das alterações na FAQ"];
$PMF_LANG['permission::view_faqs'] = 'Ver FAQs';
$PMF_LANG['permission::view_categories'] = 'Ver categorias';
$PMF_LANG['permission::view_sections'] = 'Ver seções';
$PMF_LANG['permission::view_news'] = 'Ver notícias';
$PMF_LANG['permission::administrate_groups'] = 'Administrar grupos';
$PMF_LANG['ad_group_rights'] = 'Permissões de grupo';
$PMF_LANG['ad_menu_section_administration'] = 'Seções';
$PMF_LANG['ad_section_add'] = 'Adicionar Seção';
$PMF_LANG['ad_section_add_link'] = 'Adicionar Seção';
$PMF_LANG['ad_sections'] = 'Seções';
$PMF_LANG['ad_section_details'] = 'Detalhe da Seção';
$PMF_LANG['ad_section_name'] = 'Nome';
$PMF_LANG['ad_section_description'] = 'Descrição';
$PMF_LANG['ad_section_membership'] = 'Atribuição da Seção';
$PMF_LANG['ad_section_members'] = 'Atribuições';
$PMF_LANG['ad_section_addMember'] = '+';
$PMF_LANG['ad_section_removeMember'] = '-';
$PMF_LANG['ad_section_deleteSection'] = 'Remover Seção';
$PMF_LANG['ad_section_deleteQuestion'] = 'Tem certeza que deseja remover esta seção?';
$PMF_LANG['ad_section_error_delete'] = 'Não foi possível remover a seção. ';
$PMF_LANG['ad_section_error_noName'] = 'Por favor, informe um nome para a seção. ';
$PMF_LANG['ad_section_suc'] = 'A seção foi adicionada com <strong>sucesso</strong>.';
$PMF_LANG['ad_section_deleted'] = 'A seção foi removida com sucesso.';
$PMF_LANG['permission::viewadminlink'] = 'Ver link de administração';
$LANG_CONF['mail.remoteSMTPPort'] = ["input", "Porta do servidor SMTP"];
$PMF_LANG['ad_record_faq'] = 'Pergunta e resposta';
$PMF_LANG['ad_record_permissions'] = 'Permissões';
$PMF_LANG['loginPageMessage'] = 'Entrar em ';
$PMF_LANG['ad_menu_faq_meta'] = 'Metadata da FAQ';
$LANG_CONF['main.privacyURL'] = ["input", "URL para nota de Privacidade"];
$PMF_LANG['msgUserDataVisible'] = 'Nome de usuário deve ser visível';
$PMF_LANG['ad_user_is_visible'] = 'Visível';
$PMF_LANG['ad_categ_save_order'] = 'Ordem de salvamento';
$PMF_LANG['ad_add_user_change_password'] = 'O usuário deve alterar a senha após o primeiro login';
$LANG_CONF['api.enableAccess'] = ["checkbox", "Habilitar REST API"];
$LANG_CONF['api.apiClientToken'] = ["input", "Token do client da API"];
$LANG_CONF['security.domainWhiteListForRegistrations'] = ["area", "Hosts permitidos para cadastros"];
$LANG_CONF['security.loginWithEmailAddress'] = ["checkbox", "Login somente com endereço de email"];
$PMF_LANG["plmsgUserOnline"][1] = '%d usuários online';

return $PMF_LANG;
