
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `mediawiki1442`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]actor`
--

CREATE TABLE `[[dbprefix]]actor` (
  `actor_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `actor_user` int(10) unsigned DEFAULT NULL,
  `actor_name` varbinary(255) NOT NULL,
  PRIMARY KEY (`actor_id`),
  UNIQUE KEY `actor_name` (`actor_name`),
  UNIQUE KEY `actor_user` (`actor_user`)
) ENGINE=InnoDB  DEFAULT CHARSET=binary AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]actor`
--

INSERT INTO `[[dbprefix]]actor` VALUES
(1, 1, 'MediaWiki default'),
(2, 2, '[[admin_username]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]archive`
--

CREATE TABLE `[[dbprefix]]archive` (
  `ar_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ar_namespace` int(11) NOT NULL DEFAULT '0',
  `ar_title` varbinary(255) NOT NULL DEFAULT '',
  `ar_comment_id` bigint(20) unsigned NOT NULL,
  `ar_actor` bigint(20) unsigned NOT NULL,
  `ar_timestamp` binary(14) NOT NULL,
  `ar_minor_edit` tinyint(4) NOT NULL DEFAULT '0',
  `ar_rev_id` int(10) unsigned NOT NULL,
  `ar_deleted` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `ar_len` int(10) unsigned DEFAULT NULL,
  `ar_page_id` int(10) unsigned DEFAULT NULL,
  `ar_parent_id` int(10) unsigned DEFAULT NULL,
  `ar_sha1` varbinary(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`ar_id`),
  UNIQUE KEY `ar_revid_uniq` (`ar_rev_id`),
  KEY `ar_name_title_timestamp` (`ar_namespace`,`ar_title`,`ar_timestamp`),
  KEY `ar_actor_timestamp` (`ar_actor`,`ar_timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=binary AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block`
--

CREATE TABLE `[[dbprefix]]block` (
  `bl_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bl_target` int(10) unsigned NOT NULL,
  `bl_by_actor` bigint(20) unsigned NOT NULL,
  `bl_reason_id` bigint(20) unsigned NOT NULL,
  `bl_timestamp` binary(14) NOT NULL,
  `bl_anon_only` tinyint(1) NOT NULL DEFAULT '0',
  `bl_create_account` tinyint(1) NOT NULL DEFAULT '1',
  `bl_enable_autoblock` tinyint(1) NOT NULL DEFAULT '1',
  `bl_expiry` varbinary(14) NOT NULL,
  `bl_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `bl_block_email` tinyint(1) NOT NULL DEFAULT '0',
  `bl_allow_usertalk` tinyint(1) NOT NULL DEFAULT '0',
  `bl_parent_block_id` int(10) unsigned DEFAULT NULL,
  `bl_sitewide` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`bl_id`),
  KEY `bl_timestamp` (`bl_timestamp`),
  KEY `bl_target` (`bl_target`),
  KEY `bl_expiry` (`bl_expiry`),
  KEY `bl_parent_block_id` (`bl_parent_block_id`)
) ENGINE=InnoDB DEFAULT CHARSET=binary AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_target`
--

CREATE TABLE `[[dbprefix]]block_target` (
  `bt_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bt_address` tinyblob,
  `bt_user` int(10) unsigned DEFAULT NULL,
  `bt_user_text` varbinary(255) DEFAULT NULL,
  `bt_auto` tinyint(1) NOT NULL DEFAULT '0',
  `bt_range_start` tinyblob,
  `bt_range_end` tinyblob,
  `bt_ip_hex` tinyblob,
  `bt_count` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`bt_id`),
  KEY `bt_address` (`bt_address`(42)),
  KEY `bt_ip_user_text` (`bt_ip_hex`(35),`bt_user_text`),
  KEY `bt_range` (`bt_range_start`(35),`bt_range_end`(35)),
  KEY `bt_user` (`bt_user`)
) ENGINE=InnoDB DEFAULT CHARSET=binary AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]bot_passwords`
--

CREATE TABLE `[[dbprefix]]bot_passwords` (
  `bp_user` int(10) unsigned NOT NULL,
  `bp_app_id` varbinary(32) NOT NULL,
  `bp_password` tinyblob NOT NULL,
  `bp_token` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `bp_restrictions` blob NOT NULL,
  `bp_grants` blob NOT NULL,
  PRIMARY KEY (`bp_user`,`bp_app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]category`
--

CREATE TABLE `[[dbprefix]]category` (
  `cat_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cat_title` varbinary(255) NOT NULL,
  `cat_pages` int(11) NOT NULL DEFAULT '0',
  `cat_subcats` int(11) NOT NULL DEFAULT '0',
  `cat_files` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cat_id`),
  UNIQUE KEY `cat_title` (`cat_title`),
  KEY `cat_pages` (`cat_pages`)
) ENGINE=InnoDB DEFAULT CHARSET=binary AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categorylinks`
--

CREATE TABLE `[[dbprefix]]categorylinks` (
  `cl_from` int(10) unsigned NOT NULL DEFAULT '0',
  `cl_to` varbinary(255) NOT NULL DEFAULT '',
  `cl_sortkey` varbinary(230) NOT NULL DEFAULT '',
  `cl_sortkey_prefix` varbinary(255) NOT NULL DEFAULT '',
  `cl_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `cl_collation` varbinary(32) NOT NULL DEFAULT '',
  `cl_type` enum('page','subcat','file') NOT NULL DEFAULT 'page',
  `cl_collation_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `cl_target_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`cl_from`,`cl_to`),
  KEY `cl_sortkey` (`cl_to`,`cl_type`,`cl_sortkey`,`cl_from`),
  KEY `cl_timestamp` (`cl_to`,`cl_timestamp`),
  KEY `cl_sortkey_id` (`cl_target_id`,`cl_type`,`cl_sortkey`,`cl_from`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]change_tag`
--

CREATE TABLE `[[dbprefix]]change_tag` (
  `ct_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ct_rc_id` bigint(20) unsigned DEFAULT NULL,
  `ct_log_id` int(10) unsigned DEFAULT NULL,
  `ct_rev_id` int(10) unsigned DEFAULT NULL,
  `ct_params` blob,
  `ct_tag_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`ct_id`),
  UNIQUE KEY `ct_rc_tag_id` (`ct_rc_id`,`ct_tag_id`),
  UNIQUE KEY `ct_log_tag_id` (`ct_log_id`,`ct_tag_id`),
  UNIQUE KEY `ct_rev_tag_id` (`ct_rev_id`,`ct_tag_id`),
  KEY `ct_tag_id_id` (`ct_tag_id`,`ct_rc_id`,`ct_rev_id`,`ct_log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=binary AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]change_tag_def`
--

CREATE TABLE `[[dbprefix]]change_tag_def` (
  `ctd_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ctd_name` varbinary(255) NOT NULL,
  `ctd_user_defined` tinyint(1) NOT NULL,
  `ctd_count` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ctd_id`),
  UNIQUE KEY `ctd_name` (`ctd_name`),
  KEY `ctd_count` (`ctd_count`),
  KEY `ctd_user_defined` (`ctd_user_defined`)
) ENGINE=InnoDB DEFAULT CHARSET=binary AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]collation`
--

CREATE TABLE `[[dbprefix]]collation` (
  `collation_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `collation_name` varbinary(64) NOT NULL,
  PRIMARY KEY (`collation_id`),
  UNIQUE KEY `collation_name` (`collation_name`)
) ENGINE=InnoDB DEFAULT CHARSET=binary AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comment`
--

CREATE TABLE `[[dbprefix]]comment` (
  `comment_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_hash` int(11) NOT NULL,
  `comment_text` blob NOT NULL,
  `comment_data` blob,
  PRIMARY KEY (`comment_id`),
  KEY `comment_hash` (`comment_hash`)
) ENGINE=InnoDB  DEFAULT CHARSET=binary AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]comment`
--

INSERT INTO `[[dbprefix]]comment` VALUES
(1, 0, '', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]content`
--

CREATE TABLE `[[dbprefix]]content` (
  `content_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `content_size` int(10) unsigned NOT NULL,
  `content_sha1` varbinary(32) NOT NULL,
  `content_model` smallint(5) unsigned NOT NULL,
  `content_address` varbinary(255) NOT NULL,
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=binary AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]content`
--

INSERT INTO `[[dbprefix]]content` VALUES
(1, 755, '22vz5zlxa2zctewimaum2bf1due8hkl', 1, 'tt:1');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]content_models`
--

CREATE TABLE `[[dbprefix]]content_models` (
  `model_id` int(11) NOT NULL AUTO_INCREMENT,
  `model_name` varbinary(64) NOT NULL,
  PRIMARY KEY (`model_id`),
  UNIQUE KEY `model_name` (`model_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=binary AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]content_models`
--

INSERT INTO `[[dbprefix]]content_models` VALUES
(1, 'wikitext');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]externallinks`
--

CREATE TABLE `[[dbprefix]]externallinks` (
  `el_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `el_from` int(10) unsigned NOT NULL DEFAULT '0',
  `el_to_domain_index` varbinary(255) NOT NULL DEFAULT '',
  `el_to_path` blob,
  PRIMARY KEY (`el_id`),
  KEY `el_from` (`el_from`),
  KEY `el_to_domain_index_to_path` (`el_to_domain_index`,`el_to_path`(60))
) ENGINE=InnoDB DEFAULT CHARSET=binary AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]file`
--

CREATE TABLE `[[dbprefix]]file` (
  `file_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `file_name` varbinary(255) NOT NULL,
  `file_latest` bigint(20) unsigned NOT NULL,
  `file_type` smallint(5) unsigned NOT NULL,
  `file_deleted` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`file_id`),
  UNIQUE KEY `file_name` (`file_name`),
  KEY `file_latest` (`file_latest`)
) ENGINE=InnoDB DEFAULT CHARSET=binary AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]filearchive`
--

CREATE TABLE `[[dbprefix]]filearchive` (
  `fa_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fa_name` varbinary(255) NOT NULL DEFAULT '',
  `fa_archive_name` varbinary(255) DEFAULT '',
  `fa_storage_group` varbinary(16) DEFAULT NULL,
  `fa_storage_key` varbinary(64) DEFAULT '',
  `fa_deleted_user` int(11) DEFAULT NULL,
  `fa_deleted_timestamp` binary(14) DEFAULT NULL,
  `fa_deleted_reason_id` bigint(20) unsigned NOT NULL,
  `fa_size` bigint(20) unsigned DEFAULT '0',
  `fa_width` int(11) DEFAULT '0',
  `fa_height` int(11) DEFAULT '0',
  `fa_metadata` mediumblob,
  `fa_bits` int(11) DEFAULT '0',
  `fa_media_type` enum('UNKNOWN','BITMAP','DRAWING','AUDIO','VIDEO','MULTIMEDIA','OFFICE','TEXT','EXECUTABLE','ARCHIVE','3D') DEFAULT NULL,
  `fa_major_mime` enum('unknown','application','audio','image','text','video','message','model','multipart','chemical') DEFAULT 'unknown',
  `fa_minor_mime` varbinary(100) DEFAULT 'unknown',
  `fa_description_id` bigint(20) unsigned NOT NULL,
  `fa_actor` bigint(20) unsigned NOT NULL,
  `fa_timestamp` binary(14) DEFAULT NULL,
  `fa_deleted` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `fa_sha1` varbinary(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`fa_id`),
  KEY `fa_name` (`fa_name`,`fa_timestamp`),
  KEY `fa_storage_group` (`fa_storage_group`,`fa_storage_key`),
  KEY `fa_deleted_timestamp` (`fa_deleted_timestamp`),
  KEY `fa_actor_timestamp` (`fa_actor`,`fa_timestamp`),
  KEY `fa_sha1` (`fa_sha1`(10))
) ENGINE=InnoDB DEFAULT CHARSET=binary AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]filerevision`
--

CREATE TABLE `[[dbprefix]]filerevision` (
  `fr_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `fr_file` bigint(20) NOT NULL,
  `fr_size` bigint(20) unsigned NOT NULL DEFAULT '0',
  `fr_width` int(10) unsigned NOT NULL DEFAULT '0',
  `fr_height` int(10) unsigned NOT NULL DEFAULT '0',
  `fr_metadata` mediumblob NOT NULL,
  `fr_bits` int(10) unsigned NOT NULL DEFAULT '0',
  `fr_description_id` bigint(20) unsigned NOT NULL,
  `fr_actor` bigint(20) unsigned NOT NULL,
  `fr_timestamp` binary(14) NOT NULL,
  `fr_sha1` varbinary(32) NOT NULL DEFAULT '',
  `fr_archive_name` varbinary(255) NOT NULL DEFAULT '',
  `fr_deleted` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`fr_id`),
  KEY `fr_actor_timestamp` (`fr_actor`,`fr_timestamp`),
  KEY `fr_size` (`fr_size`),
  KEY `fr_timestamp` (`fr_timestamp`),
  KEY `fr_sha1` (`fr_sha1`(10)),
  KEY `fr_file` (`fr_file`)
) ENGINE=InnoDB DEFAULT CHARSET=binary AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]filetypes`
--

CREATE TABLE `[[dbprefix]]filetypes` (
  `ft_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `ft_media_type` varbinary(255) NOT NULL,
  `ft_major_mime` varbinary(255) NOT NULL,
  `ft_minor_mime` varbinary(255) NOT NULL,
  PRIMARY KEY (`ft_id`),
  UNIQUE KEY `ft_media_mime` (`ft_media_type`,`ft_major_mime`,`ft_minor_mime`)
) ENGINE=InnoDB DEFAULT CHARSET=binary AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]image`
--

CREATE TABLE `[[dbprefix]]image` (
  `img_name` varbinary(255) NOT NULL DEFAULT '',
  `img_size` bigint(20) unsigned NOT NULL DEFAULT '0',
  `img_width` int(11) NOT NULL DEFAULT '0',
  `img_height` int(11) NOT NULL DEFAULT '0',
  `img_metadata` mediumblob NOT NULL,
  `img_bits` int(11) NOT NULL DEFAULT '0',
  `img_media_type` enum('UNKNOWN','BITMAP','DRAWING','AUDIO','VIDEO','MULTIMEDIA','OFFICE','TEXT','EXECUTABLE','ARCHIVE','3D') DEFAULT NULL,
  `img_major_mime` enum('unknown','application','audio','image','text','video','message','model','multipart','chemical') NOT NULL DEFAULT 'unknown',
  `img_minor_mime` varbinary(100) NOT NULL DEFAULT 'unknown',
  `img_description_id` bigint(20) unsigned NOT NULL,
  `img_actor` bigint(20) unsigned NOT NULL,
  `img_timestamp` binary(14) NOT NULL,
  `img_sha1` varbinary(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`img_name`),
  KEY `img_actor_timestamp` (`img_actor`,`img_timestamp`),
  KEY `img_size` (`img_size`),
  KEY `img_timestamp` (`img_timestamp`),
  KEY `img_sha1` (`img_sha1`(10)),
  KEY `img_media_mime` (`img_media_type`,`img_major_mime`,`img_minor_mime`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]imagelinks`
--

CREATE TABLE `[[dbprefix]]imagelinks` (
  `il_from` int(10) unsigned NOT NULL DEFAULT '0',
  `il_to` varbinary(255) NOT NULL DEFAULT '',
  `il_from_namespace` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`il_from`,`il_to`),
  KEY `il_to` (`il_to`,`il_from`),
  KEY `il_backlinks_namespace` (`il_from_namespace`,`il_to`,`il_from`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]interwiki`
--

CREATE TABLE `[[dbprefix]]interwiki` (
  `iw_prefix` varbinary(32) NOT NULL,
  `iw_url` blob NOT NULL,
  `iw_api` blob NOT NULL,
  `iw_wikiid` varbinary(64) NOT NULL,
  `iw_local` tinyint(1) NOT NULL,
  `iw_trans` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`iw_prefix`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

--
-- Dumping data for table `[[dbprefix]]interwiki`
--

INSERT INTO `[[dbprefix]]interwiki` VALUES
('acronym', 'https://www.acronymfinder.com/~/search/af.aspx?string=exact&Acronym=$1', '', '', 0, 0),
('arxiv', 'https://www.arxiv.org/abs/$1', '', '', 0, 0),
('c2', 'https://wiki.c2.com/?$1', '', '', 0, 0),
('commons', 'https://commons.wikimedia.org/wiki/$1', 'https://commons.wikimedia.org/w/api.php', '', 0, 0),
('dictionary', 'https://www.dict.org/bin/Dict?Database=*&Form=Dict1&Strategy=*&Query=$1', '', '', 0, 0),
('doi', 'https://dx.doi.org/$1', '', '', 0, 0),
('elibre', 'http://enciclopedia.us.es/index.php/$1', 'http://enciclopedia.us.es/api.php', '', 0, 0),
('emacswiki', 'https://www.emacswiki.org/emacs/$1', '', '', 0, 0),
('fandom', 'https://community.fandom.com/wiki/w:c:$1', '', '', 0, 0),
('foldoc', 'https://foldoc.org/?$1', '', '', 0, 0),
('freebsdman', 'https://www.FreeBSD.org/cgi/man.cgi?apropos=1&query=$1', '', '', 0, 0),
('google', 'https://www.google.com/search?q=$1', '', '', 0, 0),
('googlegroups', 'https://groups.google.com/groups?q=$1', '', '', 0, 0),
('hammondwiki', 'https://www.dairiki.org/HammondWiki/$1', '', '', 0, 0),
('hrwiki', 'http://www.hrwiki.org/wiki/$1', 'http://www.hrwiki.org/w/api.php', '', 0, 0),
('imdb', 'https://www.imdb.com/find?q=$1&tt=on', '', '', 0, 0),
('lojban', 'https://mw.lojban.org/papri/$1', '', '', 0, 0),
('meatball', 'http://meatballwiki.org/wiki/$1', '', '', 0, 0),
('mediawikiwiki', 'https://www.mediawiki.org/wiki/$1', 'https://www.mediawiki.org/w/api.php', '', 0, 0),
('memoryalpha', 'https://memory-alpha.fandom.com/wiki/$1', 'https://memory-alpha.fandom.com/api.php', '', 0, 0),
('metawikimedia', 'https://meta.wikimedia.org/wiki/$1', 'https://meta.wikimedia.org/w/api.php', '', 0, 0),
('mozillawiki', 'https://wiki.mozilla.org/$1', 'https://wiki.mozilla.org/api.php', '', 0, 0),
('mw', 'https://www.mediawiki.org/wiki/$1', 'https://www.mediawiki.org/w/api.php', '', 0, 0),
('oeis', 'https://oeis.org/$1', '', '', 0, 0),
('pmid', 'https://www.ncbi.nlm.nih.gov/pubmed/$1?dopt=Abstract', '', '', 0, 0),
('pythoninfo', 'https://wiki.python.org/moin/$1', '', '', 0, 0),
('rfc', 'https://datatracker.ietf.org/doc/html/rfc$1', '', '', 0, 0),
('senseislibrary', 'https://senseis.xmp.net/?$1', '', '', 0, 0),
('shoutwiki', 'https://www.shoutwiki.com/wiki/$1', 'https://www.shoutwiki.com/w/api.php', '', 0, 0),
('theopedia', 'https://www.theopedia.com/$1', '', '', 0, 0),
('tmbw', 'https://www.tmbw.net/wiki/$1', 'https://tmbw.net/wiki/api.php', '', 0, 0),
('twiki', 'https://twiki.org/cgi-bin/view/$1', '', '', 0, 0),
('uncyclopedia', 'https://en.uncyclopedia.co/wiki/$1', 'https://en.uncyclopedia.co/w/api.php', '', 0, 0),
('usemod', 'https://www.usemod.org/cgi-bin/wiki.pl?$1', '', '', 0, 0),
('wikia', 'https://community.fandom.com/wiki/w:c:$1', '', '', 0, 0),
('wikibooks', 'https://en.wikibooks.org/wiki/$1', 'https://en.wikibooks.org/w/api.php', '', 0, 0),
('wikidata', 'https://www.wikidata.org/wiki/$1', 'https://www.wikidata.org/w/api.php', '', 0, 0),
('wikihow', 'https://www.wikihow.com/$1', 'https://www.wikihow.com/api.php', '', 0, 0),
('wikimedia', 'https://foundation.wikimedia.org/wiki/$1', 'https://foundation.wikimedia.org/w/api.php', '', 0, 0),
('wikinews', 'https://en.wikinews.org/wiki/$1', 'https://en.wikinews.org/w/api.php', '', 0, 0),
('wikipedia', 'https://en.wikipedia.org/wiki/$1', 'https://en.wikipedia.org/w/api.php', '', 0, 0),
('wikiquote', 'https://en.wikiquote.org/wiki/$1', 'https://en.wikiquote.org/w/api.php', '', 0, 0),
('wikisource', 'https://wikisource.org/wiki/$1', 'https://wikisource.org/w/api.php', '', 0, 0),
('wikispecies', 'https://species.wikimedia.org/wiki/$1', 'https://species.wikimedia.org/w/api.php', '', 0, 0),
('wikiversity', 'https://en.wikiversity.org/wiki/$1', 'https://en.wikiversity.org/w/api.php', '', 0, 0),
('wikivoyage', 'https://en.wikivoyage.org/wiki/$1', 'https://en.wikivoyage.org/w/api.php', '', 0, 0),
('wikiwikiweb', 'http://wiki.c2.com/?$1', '', '', 0, 0),
('wikt', 'https://en.wiktionary.org/wiki/$1', 'https://en.wiktionary.org/w/api.php', '', 0, 0),
('wiktionary', 'https://en.wiktionary.org/wiki/$1', 'https://en.wiktionary.org/w/api.php', '', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ipblocks_restrictions`
--

CREATE TABLE `[[dbprefix]]ipblocks_restrictions` (
  `ir_ipb_id` int(10) unsigned NOT NULL,
  `ir_type` tinyint(4) NOT NULL,
  `ir_value` int(10) unsigned NOT NULL,
  PRIMARY KEY (`ir_ipb_id`,`ir_type`,`ir_value`),
  KEY `ir_type_value` (`ir_type`,`ir_value`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ip_changes`
--

CREATE TABLE `[[dbprefix]]ip_changes` (
  `ipc_rev_id` int(10) unsigned NOT NULL DEFAULT '0',
  `ipc_rev_timestamp` binary(14) NOT NULL,
  `ipc_hex` varbinary(35) NOT NULL DEFAULT '',
  PRIMARY KEY (`ipc_rev_id`),
  KEY `ipc_rev_timestamp` (`ipc_rev_timestamp`),
  KEY `ipc_hex_time` (`ipc_hex`,`ipc_rev_timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]iwlinks`
--

CREATE TABLE `[[dbprefix]]iwlinks` (
  `iwl_from` int(10) unsigned NOT NULL DEFAULT '0',
  `iwl_prefix` varbinary(32) NOT NULL DEFAULT '',
  `iwl_title` varbinary(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`iwl_from`,`iwl_prefix`,`iwl_title`),
  KEY `iwl_prefix_title_from` (`iwl_prefix`,`iwl_title`,`iwl_from`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]job`
--

CREATE TABLE `[[dbprefix]]job` (
  `job_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `job_cmd` varbinary(60) NOT NULL DEFAULT '',
  `job_namespace` int(11) NOT NULL,
  `job_title` varbinary(255) NOT NULL,
  `job_timestamp` binary(14) DEFAULT NULL,
  `job_params` mediumblob NOT NULL,
  `job_random` int(10) unsigned NOT NULL DEFAULT '0',
  `job_attempts` int(10) unsigned NOT NULL DEFAULT '0',
  `job_token` varbinary(32) NOT NULL DEFAULT '',
  `job_token_timestamp` binary(14) DEFAULT NULL,
  `job_sha1` varbinary(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`job_id`),
  KEY `job_sha1` (`job_sha1`),
  KEY `job_cmd_token` (`job_cmd`,`job_token`,`job_random`),
  KEY `job_cmd_token_id` (`job_cmd`,`job_token`,`job_id`),
  KEY `job_cmd` (`job_cmd`,`job_namespace`,`job_title`,`job_params`(128)),
  KEY `job_timestamp` (`job_timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=binary AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]l10n_cache`
--

CREATE TABLE `[[dbprefix]]l10n_cache` (
  `lc_lang` varbinary(35) NOT NULL,
  `lc_key` varbinary(255) NOT NULL,
  `lc_value` mediumblob NOT NULL,
  PRIMARY KEY (`lc_lang`,`lc_key`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]langlinks`
--

CREATE TABLE `[[dbprefix]]langlinks` (
  `ll_from` int(10) unsigned NOT NULL DEFAULT '0',
  `ll_lang` varbinary(35) NOT NULL DEFAULT '',
  `ll_title` varbinary(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`ll_from`,`ll_lang`),
  KEY `ll_lang` (`ll_lang`,`ll_title`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]linktarget`
--

CREATE TABLE `[[dbprefix]]linktarget` (
  `lt_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `lt_namespace` int(11) NOT NULL,
  `lt_title` varbinary(255) NOT NULL,
  PRIMARY KEY (`lt_id`),
  UNIQUE KEY `lt_namespace_title` (`lt_namespace`,`lt_title`)
) ENGINE=InnoDB DEFAULT CHARSET=binary AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]logging`
--

CREATE TABLE `[[dbprefix]]logging` (
  `log_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `log_type` varbinary(32) NOT NULL DEFAULT '',
  `log_action` varbinary(32) NOT NULL DEFAULT '',
  `log_timestamp` binary(14) NOT NULL DEFAULT '19700101000000',
  `log_actor` bigint(20) unsigned NOT NULL,
  `log_namespace` int(11) NOT NULL DEFAULT '0',
  `log_title` varbinary(255) NOT NULL DEFAULT '',
  `log_page` int(10) unsigned DEFAULT NULL,
  `log_comment_id` bigint(20) unsigned NOT NULL,
  `log_params` blob NOT NULL,
  `log_deleted` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`log_id`),
  KEY `log_type_time` (`log_type`,`log_timestamp`),
  KEY `log_actor_time` (`log_actor`,`log_timestamp`),
  KEY `log_page_time` (`log_namespace`,`log_title`,`log_timestamp`),
  KEY `log_times` (`log_timestamp`),
  KEY `log_actor_type_time` (`log_actor`,`log_type`,`log_timestamp`),
  KEY `log_page_id_time` (`log_page`,`log_timestamp`),
  KEY `log_type_action` (`log_type`,`log_action`,`log_timestamp`)
) ENGINE=InnoDB  DEFAULT CHARSET=binary AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]logging`
--

INSERT INTO `[[dbprefix]]logging` VALUES
(1, 'create', 'create', '[[touched]]', 1, 0, 'Main_Page', 1, 1, 'a:1:{s:17:"associated_rev_id";i:1;}', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]log_search`
--

CREATE TABLE `[[dbprefix]]log_search` (
  `ls_field` varbinary(32) NOT NULL,
  `ls_value` varbinary(255) NOT NULL,
  `ls_log_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ls_field`,`ls_value`,`ls_log_id`),
  KEY `ls_log_id` (`ls_log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

--
-- Dumping data for table `[[dbprefix]]log_search`
--

INSERT INTO `[[dbprefix]]log_search` VALUES
('associated_rev_id', '1', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]objectcache`
--

CREATE TABLE `[[dbprefix]]objectcache` (
  `keyname` varbinary(255) NOT NULL DEFAULT '',
  `value` mediumblob,
  `exptime` binary(14) NOT NULL,
  `modtoken` varbinary(17) NOT NULL DEFAULT '00000000000000000',
  `flags` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`keyname`),
  KEY `exptime` (`exptime`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]oldimage`
--

CREATE TABLE `[[dbprefix]]oldimage` (
  `oi_name` varbinary(255) NOT NULL DEFAULT '',
  `oi_archive_name` varbinary(255) NOT NULL DEFAULT '',
  `oi_size` bigint(20) unsigned NOT NULL DEFAULT '0',
  `oi_width` int(11) NOT NULL DEFAULT '0',
  `oi_height` int(11) NOT NULL DEFAULT '0',
  `oi_bits` int(11) NOT NULL DEFAULT '0',
  `oi_description_id` bigint(20) unsigned NOT NULL,
  `oi_actor` bigint(20) unsigned NOT NULL,
  `oi_timestamp` binary(14) NOT NULL,
  `oi_metadata` mediumblob NOT NULL,
  `oi_media_type` enum('UNKNOWN','BITMAP','DRAWING','AUDIO','VIDEO','MULTIMEDIA','OFFICE','TEXT','EXECUTABLE','ARCHIVE','3D') DEFAULT NULL,
  `oi_major_mime` enum('unknown','application','audio','image','text','video','message','model','multipart','chemical') NOT NULL DEFAULT 'unknown',
  `oi_minor_mime` varbinary(100) NOT NULL DEFAULT 'unknown',
  `oi_deleted` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `oi_sha1` varbinary(32) NOT NULL DEFAULT '',
  KEY `oi_actor_timestamp` (`oi_actor`,`oi_timestamp`),
  KEY `oi_name_timestamp` (`oi_name`,`oi_timestamp`),
  KEY `oi_name_archive_name` (`oi_name`,`oi_archive_name`(14)),
  KEY `oi_sha1` (`oi_sha1`(10)),
  KEY `oi_timestamp` (`oi_timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]page`
--

CREATE TABLE `[[dbprefix]]page` (
  `page_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `page_namespace` int(11) NOT NULL,
  `page_title` varbinary(255) NOT NULL,
  `page_is_redirect` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `page_is_new` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `page_random` double unsigned NOT NULL,
  `page_touched` binary(14) NOT NULL,
  `page_links_updated` binary(14) DEFAULT NULL,
  `page_latest` int(10) unsigned NOT NULL,
  `page_len` int(10) unsigned NOT NULL,
  `page_content_model` varbinary(32) DEFAULT NULL,
  `page_lang` varbinary(35) DEFAULT NULL,
  PRIMARY KEY (`page_id`),
  UNIQUE KEY `page_name_title` (`page_namespace`,`page_title`),
  KEY `page_random` (`page_random`),
  KEY `page_len` (`page_len`),
  KEY `page_redirect_namespace_len` (`page_is_redirect`,`page_namespace`,`page_len`)
) ENGINE=InnoDB  DEFAULT CHARSET=binary AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]page`
--

INSERT INTO `[[dbprefix]]page` VALUES
(1, 0, 'Main_Page', 0, 1, [[page_random]], '[[touched]]', NULL, 1, 755, 'wikitext', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pagelinks`
--

CREATE TABLE `[[dbprefix]]pagelinks` (
  `pl_from` int(10) unsigned NOT NULL DEFAULT '0',
  `pl_target_id` bigint(20) unsigned NOT NULL,
  `pl_from_namespace` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pl_from`,`pl_target_id`),
  KEY `pl_target_id` (`pl_target_id`,`pl_from`),
  KEY `pl_backlinks_namespace_target_id` (`pl_from_namespace`,`pl_target_id`,`pl_from`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]page_props`
--

CREATE TABLE `[[dbprefix]]page_props` (
  `pp_page` int(10) unsigned NOT NULL,
  `pp_propname` varbinary(60) NOT NULL,
  `pp_value` blob NOT NULL,
  `pp_sortkey` float DEFAULT NULL,
  PRIMARY KEY (`pp_page`,`pp_propname`),
  UNIQUE KEY `pp_propname_page` (`pp_propname`,`pp_page`),
  UNIQUE KEY `pp_propname_sortkey_page` (`pp_propname`,`pp_sortkey`,`pp_page`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]page_restrictions`
--

CREATE TABLE `[[dbprefix]]page_restrictions` (
  `pr_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pr_page` int(10) unsigned NOT NULL,
  `pr_type` varbinary(60) NOT NULL,
  `pr_level` varbinary(60) NOT NULL,
  `pr_cascade` tinyint(4) NOT NULL,
  `pr_expiry` varbinary(14) DEFAULT NULL,
  PRIMARY KEY (`pr_id`),
  UNIQUE KEY `pr_pagetype` (`pr_page`,`pr_type`),
  KEY `pr_typelevel` (`pr_type`,`pr_level`),
  KEY `pr_level` (`pr_level`),
  KEY `pr_cascade` (`pr_cascade`)
) ENGINE=InnoDB DEFAULT CHARSET=binary AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]protected_titles`
--

CREATE TABLE `[[dbprefix]]protected_titles` (
  `pt_namespace` int(11) NOT NULL,
  `pt_title` varbinary(255) NOT NULL,
  `pt_user` int(10) unsigned NOT NULL,
  `pt_reason_id` bigint(20) unsigned NOT NULL,
  `pt_timestamp` binary(14) NOT NULL,
  `pt_expiry` varbinary(14) NOT NULL,
  `pt_create_perm` varbinary(60) NOT NULL,
  PRIMARY KEY (`pt_namespace`,`pt_title`),
  KEY `pt_timestamp` (`pt_timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]querycache`
--

CREATE TABLE `[[dbprefix]]querycache` (
  `qc_type` varbinary(32) NOT NULL,
  `qc_value` int(10) unsigned NOT NULL DEFAULT '0',
  `qc_namespace` int(11) NOT NULL DEFAULT '0',
  `qc_title` varbinary(255) NOT NULL DEFAULT '',
  KEY `qc_type` (`qc_type`,`qc_value`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]querycachetwo`
--

CREATE TABLE `[[dbprefix]]querycachetwo` (
  `qcc_type` varbinary(32) NOT NULL,
  `qcc_value` int(10) unsigned NOT NULL DEFAULT '0',
  `qcc_namespace` int(11) NOT NULL DEFAULT '0',
  `qcc_title` varbinary(255) NOT NULL DEFAULT '',
  `qcc_namespacetwo` int(11) NOT NULL DEFAULT '0',
  `qcc_titletwo` varbinary(255) NOT NULL DEFAULT '',
  KEY `qcc_type` (`qcc_type`,`qcc_value`),
  KEY `qcc_title` (`qcc_type`,`qcc_namespace`,`qcc_title`),
  KEY `qcc_titletwo` (`qcc_type`,`qcc_namespacetwo`,`qcc_titletwo`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]querycache_info`
--

CREATE TABLE `[[dbprefix]]querycache_info` (
  `qci_type` varbinary(32) NOT NULL DEFAULT '',
  `qci_timestamp` binary(14) NOT NULL DEFAULT '19700101000000',
  PRIMARY KEY (`qci_type`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]recentchanges`
--

CREATE TABLE `[[dbprefix]]recentchanges` (
  `rc_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rc_timestamp` binary(14) NOT NULL,
  `rc_actor` bigint(20) unsigned NOT NULL,
  `rc_namespace` int(11) NOT NULL DEFAULT '0',
  `rc_title` varbinary(255) NOT NULL DEFAULT '',
  `rc_comment_id` bigint(20) unsigned NOT NULL,
  `rc_minor` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `rc_bot` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `rc_new` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `rc_cur_id` int(10) unsigned NOT NULL DEFAULT '0',
  `rc_this_oldid` int(10) unsigned NOT NULL DEFAULT '0',
  `rc_last_oldid` int(10) unsigned NOT NULL DEFAULT '0',
  `rc_type` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `rc_source` varbinary(16) NOT NULL DEFAULT '',
  `rc_patrolled` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `rc_ip` varbinary(40) NOT NULL DEFAULT '',
  `rc_old_len` int(11) DEFAULT NULL,
  `rc_new_len` int(11) DEFAULT NULL,
  `rc_deleted` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `rc_logid` int(10) unsigned NOT NULL DEFAULT '0',
  `rc_log_type` varbinary(255) DEFAULT NULL,
  `rc_log_action` varbinary(255) DEFAULT NULL,
  `rc_params` blob,
  PRIMARY KEY (`rc_id`),
  KEY `rc_timestamp` (`rc_timestamp`),
  KEY `rc_namespace_title_timestamp` (`rc_namespace`,`rc_title`,`rc_timestamp`),
  KEY `rc_cur_id` (`rc_cur_id`),
  KEY `rc_new_name_timestamp` (`rc_new`,`rc_namespace`,`rc_timestamp`),
  KEY `rc_ip` (`rc_ip`),
  KEY `rc_ns_actor` (`rc_namespace`,`rc_actor`),
  KEY `rc_actor` (`rc_actor`,`rc_timestamp`),
  KEY `rc_name_type_patrolled_timestamp` (`rc_namespace`,`rc_type`,`rc_patrolled`,`rc_timestamp`),
  KEY `rc_this_oldid` (`rc_this_oldid`)
) ENGINE=InnoDB DEFAULT CHARSET=binary AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]redirect`
--

CREATE TABLE `[[dbprefix]]redirect` (
  `rd_from` int(10) unsigned NOT NULL DEFAULT '0',
  `rd_namespace` int(11) NOT NULL DEFAULT '0',
  `rd_title` varbinary(255) NOT NULL DEFAULT '',
  `rd_interwiki` varbinary(32) DEFAULT NULL,
  `rd_fragment` varbinary(255) DEFAULT NULL,
  PRIMARY KEY (`rd_from`),
  KEY `rd_ns_title` (`rd_namespace`,`rd_title`,`rd_from`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]revision`
--

CREATE TABLE `[[dbprefix]]revision` (
  `rev_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rev_page` int(10) unsigned NOT NULL,
  `rev_comment_id` bigint(20) unsigned NOT NULL,
  `rev_actor` bigint(20) unsigned NOT NULL,
  `rev_timestamp` binary(14) NOT NULL,
  `rev_minor_edit` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `rev_deleted` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `rev_len` int(10) unsigned DEFAULT NULL,
  `rev_parent_id` bigint(20) unsigned DEFAULT NULL,
  `rev_sha1` varbinary(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`rev_id`),
  KEY `rev_timestamp` (`rev_timestamp`),
  KEY `rev_page_timestamp` (`rev_page`,`rev_timestamp`),
  KEY `rev_actor_timestamp` (`rev_actor`,`rev_timestamp`,`rev_id`),
  KEY `rev_page_actor_timestamp` (`rev_page`,`rev_actor`,`rev_timestamp`)
) ENGINE=InnoDB  DEFAULT CHARSET=binary AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]revision`
--

INSERT INTO `[[dbprefix]]revision` VALUES
(1, 1, 1, 1, '[[touched]]', 0, 0, 755, 0, '22vz5zlxa2zctewimaum2bf1due8hkl');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]searchindex`
--

CREATE TABLE `[[dbprefix]]searchindex` (
  `si_page` int(10) unsigned NOT NULL,
  `si_title` mediumtext NOT NULL,
  `si_text` mediumtext NOT NULL,
  PRIMARY KEY (`si_page`),
  FULLTEXT KEY `si_title` (`si_title`),
  FULLTEXT KEY `si_text` (`si_text`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sites`
--

CREATE TABLE `[[dbprefix]]sites` (
  `site_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `site_global_key` varbinary(64) NOT NULL,
  `site_type` varbinary(32) NOT NULL,
  `site_group` varbinary(32) NOT NULL,
  `site_source` varbinary(32) NOT NULL,
  `site_language` varbinary(35) NOT NULL,
  `site_protocol` varbinary(32) NOT NULL,
  `site_domain` varbinary(255) NOT NULL,
  `site_data` blob NOT NULL,
  `site_forward` tinyint(1) NOT NULL,
  `site_config` blob NOT NULL,
  PRIMARY KEY (`site_id`),
  UNIQUE KEY `site_global_key` (`site_global_key`)
) ENGINE=InnoDB DEFAULT CHARSET=binary AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]site_identifiers`
--

CREATE TABLE `[[dbprefix]]site_identifiers` (
  `si_type` varbinary(32) NOT NULL,
  `si_key` varbinary(32) NOT NULL,
  `si_site` int(10) unsigned NOT NULL,
  PRIMARY KEY (`si_type`,`si_key`),
  KEY `si_site` (`si_site`),
  KEY `si_key` (`si_key`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]site_stats`
--

CREATE TABLE `[[dbprefix]]site_stats` (
  `ss_row_id` int(10) unsigned NOT NULL,
  `ss_total_edits` bigint(20) unsigned DEFAULT NULL,
  `ss_good_articles` bigint(20) unsigned DEFAULT NULL,
  `ss_total_pages` bigint(20) unsigned DEFAULT NULL,
  `ss_users` bigint(20) unsigned DEFAULT NULL,
  `ss_active_users` bigint(20) unsigned DEFAULT NULL,
  `ss_images` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`ss_row_id`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

--
-- Dumping data for table `[[dbprefix]]site_stats`
--

INSERT INTO `[[dbprefix]]site_stats` VALUES
(1, 0, 0, 0, 1, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]slots`
--

CREATE TABLE `[[dbprefix]]slots` (
  `slot_revision_id` bigint(20) unsigned NOT NULL,
  `slot_role_id` smallint(5) unsigned NOT NULL,
  `slot_content_id` bigint(20) unsigned NOT NULL,
  `slot_origin` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`slot_revision_id`,`slot_role_id`),
  KEY `slot_revision_origin_role` (`slot_revision_id`,`slot_origin`,`slot_role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

--
-- Dumping data for table `[[dbprefix]]slots`
--

INSERT INTO `[[dbprefix]]slots` VALUES
(1, 1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]slot_roles`
--

CREATE TABLE `[[dbprefix]]slot_roles` (
  `role_id` int(11) NOT NULL AUTO_INCREMENT,
  `role_name` varbinary(64) NOT NULL,
  PRIMARY KEY (`role_id`),
  UNIQUE KEY `role_name` (`role_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=binary AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]slot_roles`
--

INSERT INTO `[[dbprefix]]slot_roles` VALUES
(1, 'main');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]templatelinks`
--

CREATE TABLE `[[dbprefix]]templatelinks` (
  `tl_from` int(10) unsigned NOT NULL DEFAULT '0',
  `tl_target_id` bigint(20) unsigned NOT NULL,
  `tl_from_namespace` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tl_from`,`tl_target_id`),
  KEY `tl_target_id` (`tl_target_id`,`tl_from`),
  KEY `tl_backlinks_namespace_target_id` (`tl_from_namespace`,`tl_target_id`,`tl_from`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]text`
--

CREATE TABLE `[[dbprefix]]text` (
  `old_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `old_text` mediumblob NOT NULL,
  `old_flags` tinyblob NOT NULL,
  PRIMARY KEY (`old_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=binary AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]text`
--

INSERT INTO `[[dbprefix]]text` VALUES
(1, '<strong>MediaWiki has been installed.</strong>\n\nConsult the [https://www.mediawiki.org/wiki/Special:MyLanguage/Help:Contents User''s Guide] for information on using the wiki software.\n\n== Getting started ==\n* [https://www.mediawiki.org/wiki/Special:MyLanguage/Manual:Configuration_settings Configuration settings list]\n* [https://www.mediawiki.org/wiki/Special:MyLanguage/Manual:FAQ MediaWiki FAQ]\n* [https://lists.wikimedia.org/postorius/lists/mediawiki-announce.lists.wikimedia.org/ MediaWiki release mailing list]\n* [https://www.mediawiki.org/wiki/Special:MyLanguage/Localisation#Translation_resources Localise MediaWiki for your language]\n* [https://www.mediawiki.org/wiki/Special:MyLanguage/Manual:Combating_spam Learn how to combat spam on your wiki]', 'utf-8');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]updatelog`
--

CREATE TABLE `[[dbprefix]]updatelog` (
  `ul_key` varbinary(255) NOT NULL,
  `ul_value` blob,
  PRIMARY KEY (`ul_key`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

--
-- Dumping data for table `[[dbprefix]]updatelog`
--

INSERT INTO `[[dbprefix]]updatelog` VALUES
('filearchive-fa_major_mime-patch-fa_major_mime-chemical.sql', NULL),
('image-img_major_mime-patch-img_major_mime-chemical.sql', NULL),
('oldimage-oi_major_mime-patch-oi_major_mime-chemical.sql', NULL),
('user_former_groups-ufg_group-patch-ufg_group-length-increase-255.sql', NULL),
('user_groups-ug_group-patch-ug_group-length-increase-255.sql', NULL),
('user_properties-up_property-patch-up_property.sql', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]uploadstash`
--

CREATE TABLE `[[dbprefix]]uploadstash` (
  `us_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `us_user` int(10) unsigned NOT NULL,
  `us_key` varbinary(255) NOT NULL,
  `us_orig_path` varbinary(255) NOT NULL,
  `us_path` varbinary(255) NOT NULL,
  `us_source_type` varbinary(50) DEFAULT NULL,
  `us_timestamp` binary(14) NOT NULL,
  `us_status` varbinary(50) NOT NULL,
  `us_chunk_inx` int(10) unsigned DEFAULT NULL,
  `us_props` blob,
  `us_size` bigint(20) unsigned NOT NULL,
  `us_sha1` varbinary(31) NOT NULL,
  `us_mime` varbinary(255) DEFAULT NULL,
  `us_media_type` enum('UNKNOWN','BITMAP','DRAWING','AUDIO','VIDEO','MULTIMEDIA','OFFICE','TEXT','EXECUTABLE','ARCHIVE','3D') DEFAULT NULL,
  `us_image_width` int(10) unsigned DEFAULT NULL,
  `us_image_height` int(10) unsigned DEFAULT NULL,
  `us_image_bits` smallint(5) unsigned DEFAULT NULL,
  PRIMARY KEY (`us_id`),
  UNIQUE KEY `us_key` (`us_key`),
  KEY `us_user` (`us_user`),
  KEY `us_timestamp` (`us_timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=binary AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user`
--

CREATE TABLE `[[dbprefix]]user` (
  `user_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_name` varbinary(255) NOT NULL DEFAULT '',
  `user_real_name` varbinary(255) NOT NULL DEFAULT '',
  `user_password` tinyblob NOT NULL,
  `user_newpassword` tinyblob NOT NULL,
  `user_newpass_time` binary(14) DEFAULT NULL,
  `user_email` tinyblob NOT NULL,
  `user_touched` binary(14) NOT NULL,
  `user_token` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `user_email_authenticated` binary(14) DEFAULT NULL,
  `user_email_token` binary(32) DEFAULT NULL,
  `user_email_token_expires` binary(14) DEFAULT NULL,
  `user_registration` binary(14) DEFAULT NULL,
  `user_editcount` int(10) unsigned DEFAULT NULL,
  `user_password_expires` varbinary(14) DEFAULT NULL,
  `user_is_temp` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `user_name` (`user_name`),
  KEY `user_email_token` (`user_email_token`),
  KEY `user_email` (`user_email`(50))
) ENGINE=InnoDB  DEFAULT CHARSET=binary AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]user`
--

INSERT INTO `[[dbprefix]]user` VALUES
(1, 'MediaWiki default', '', '', '', NULL, '', '[[touched]]', '*** INVALID ***\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0', NULL, NULL, NULL, '[[touched]]', 0, NULL, 0),
(2, '[[admin_username]]', '', '[[admin_pass]]', '', NULL, '[[wiki_mail]]', '[[touched]]', '[[token]]', NULL, NULL, NULL, '[[touched]]', 0, NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_autocreate_serial`
--

CREATE TABLE `[[dbprefix]]user_autocreate_serial` (
  `uas_shard` int(10) unsigned NOT NULL,
  `uas_year` smallint(5) unsigned NOT NULL,
  `uas_value` int(10) unsigned NOT NULL,
  PRIMARY KEY (`uas_shard`,`uas_year`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_former_groups`
--

CREATE TABLE `[[dbprefix]]user_former_groups` (
  `ufg_user` int(10) unsigned NOT NULL DEFAULT '0',
  `ufg_group` varbinary(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`ufg_user`,`ufg_group`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_groups`
--

CREATE TABLE `[[dbprefix]]user_groups` (
  `ug_user` int(10) unsigned NOT NULL DEFAULT '0',
  `ug_group` varbinary(255) NOT NULL DEFAULT '',
  `ug_expiry` varbinary(14) DEFAULT NULL,
  PRIMARY KEY (`ug_user`,`ug_group`),
  KEY `ug_group` (`ug_group`),
  KEY `ug_expiry` (`ug_expiry`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

--
-- Dumping data for table `[[dbprefix]]user_groups`
--

INSERT INTO `[[dbprefix]]user_groups` VALUES
(2, 'bureaucrat', NULL),
(2, 'interface-admin', NULL),
(2, 'sysop', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_newtalk`
--

CREATE TABLE `[[dbprefix]]user_newtalk` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_ip` varbinary(40) NOT NULL DEFAULT '',
  `user_last_timestamp` binary(14) DEFAULT NULL,
  KEY `un_user_id` (`user_id`),
  KEY `un_user_ip` (`user_ip`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_properties`
--

CREATE TABLE `[[dbprefix]]user_properties` (
  `up_user` int(10) unsigned NOT NULL,
  `up_property` varbinary(255) NOT NULL,
  `up_value` blob,
  PRIMARY KEY (`up_user`,`up_property`),
  KEY `up_property` (`up_property`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]watchlist`
--

CREATE TABLE `[[dbprefix]]watchlist` (
  `wl_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `wl_user` int(10) unsigned NOT NULL,
  `wl_namespace` int(11) NOT NULL DEFAULT '0',
  `wl_title` varbinary(255) NOT NULL DEFAULT '',
  `wl_notificationtimestamp` binary(14) DEFAULT NULL,
  PRIMARY KEY (`wl_id`),
  UNIQUE KEY `wl_user` (`wl_user`,`wl_namespace`,`wl_title`),
  KEY `wl_namespace_title` (`wl_namespace`,`wl_title`),
  KEY `wl_user_notificationtimestamp` (`wl_user`,`wl_notificationtimestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=binary AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]watchlist_expiry`
--

CREATE TABLE `[[dbprefix]]watchlist_expiry` (
  `we_item` int(10) unsigned NOT NULL,
  `we_expiry` binary(14) NOT NULL,
  PRIMARY KEY (`we_item`),
  KEY `we_expiry` (`we_expiry`)
) ENGINE=InnoDB DEFAULT CHARSET=binary;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
