<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'attendance', language 'es_mx', version '5.0'.
 *
 * @package     attendance
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['Aacronym'] = 'A';
$string['Afull'] = 'Ausente';
$string['Eacronym'] = 'E';
$string['Efull'] = 'Excusado (Justificado)';
$string['Lacronym'] = 'R';
$string['Lfull'] = 'Retrasado';
$string['Pacronym'] = 'P';
$string['Pfull'] = 'Presente';
$string['absenteereport'] = 'Reporte de ausentes';
$string['acronym'] = 'Acrónimo';
$string['add'] = 'Añadir';
$string['addedrecip'] = 'Se añadió {$a} nuevo';
$string['addedrecips'] = 'Se añadieron {$a} nuevos recipientes';
$string['addmultiplesessions'] = 'Sesiones múltiples';
$string['addsession'] = 'Añadir sesión';
$string['adduser'] = 'Añadir usuario';
$string['addwarning'] = 'Añadir advertencia';
$string['all'] = 'Todos';
$string['allcourses'] = 'Todos los cursos';
$string['allowupdatestatus'] = 'Permitir a alumnos actualizar su propia asistencia';
$string['allowupdatestatus_desc'] = 'Si se activa, los estudiantes podrán actualizar su asistencia para una sesión después de ellos ya la hayan auto reportado.';
$string['allowupdatestatus_help'] = 'Si se activa, los estudiantes podrán actualizar su asistencia para una sesión después de ellos ya la hayan auto reportado.';
$string['allpast'] = 'Todos los pasados';
$string['allsessions'] = 'Todas las sesiones';
$string['allsessionstotals'] = 'Totales para secciones seleccionadas';
$string['attendance:addinstance'] = 'Añadir una nueva actividad con asistencia';
$string['attendance:canbelisted'] = 'Aparecer en la lista';
$string['attendance:changeattendances'] = 'Cambiando Asistencias';
$string['attendance:changepreferences'] = 'Cambiando Preferencias';
$string['attendance:export'] = 'Exportar Reportes';
$string['attendance:import'] = 'Importar sesiones desde archivo (CSV)';
$string['attendance:manageattendances'] = 'Gestionar Asistencias';
$string['attendance:managetemporaryusers'] = 'Gestionar usuarios temporales';
$string['attendance:manualautomark'] = 'Permitir proceso de auto-calificación manual';
$string['attendance:takeattendances'] = 'Tomando Asistencias';
$string['attendance:view'] = 'Viendo Asistencias';
$string['attendance:viewreports'] = 'Viendo Reportes';
$string['attendance:viewsummaryreports'] = 'Ver reportes resumidos del curso';
$string['attendance:warningemails'] = 'Puede suscribirse a Emails con reportes de ausentes';
$string['attendance_already_submitted'] = 'Su asistencia ya ha sido configurada.';
$string['attendance_no_status'] = 'No estaba disponible ningún estatus válido - Usted puede estar demasiado tarde para grabar asistencia.';
$string['attendancedata'] = 'Datos de Asistencia';
$string['attendancefile'] = 'Archivo de asistencia (formato CSV)';
$string['attendancefile_help'] = 'El archivo debe ser un archivo CSV con una fila de encabezado y campos para identificar al usuario y la hora en la cual la asistencia fue grabada, como por ejemplo (email, scantime) o (username, time)';
$string['attendancegrade'] = 'Calificación por asistencia';
$string['attendancenotset'] = 'Usted debe de configurar su asistencia';
$string['attendancenotstarted'] = 'Asistencia no ha iniciado para este curso';
$string['attendancepercent'] = 'Porcentaje de asistencia';
$string['attendancereport'] = 'Asistencia';
$string['attendanceslogged'] = 'Asistencias guardadas en bitácora';
$string['attendancestaken'] = 'Asistencias tomadas';
$string['attendancesuccess'] = 'Se tomó exitosamente la asistencia';
$string['attendanceupdated'] = 'Se actualizó exitosamente la asistencia';
$string['attendanceuserreport'] = 'Reporte de asistencia';
$string['attforblockdirstillexists'] = 'Aún existe un directorio antiguo mod/attforblock - Usted debe eliminar este directorio antes de correr esta actualización.';
$string['attrecords'] = 'Registros de asistencia';
$string['autoassignstatus'] = 'Automáticamente seleccionar estatus más alto disponible';
$string['autoassignstatus_help'] = 'Si esto es seleccionado, a los estudiantes les será asignada automáticamente la calificación más alta disponible.';
$string['automark'] = 'Calificación automática';
$string['automark_help'] = 'Permitir que la calificación sea completada automáticamente.
"Sí" hará que los estudiantes sean calificados automáticamente dependiendo de su primer acceso al curso.
"Configurar sin_calificar al final de la sesión" hará que los estudiantes quienes no hayan marcado su asistencia sean configurados al estatus seleccionado de sin_calificar.';
$string['automarkall'] = 'Sí';
$string['automarkclose'] = 'Configurar sin_calificar al final de la sesión';
$string['automarkingcomplete'] = 'Calificación  automática completa';
$string['automarkingnotavailableyet'] = 'Esta sesión está usando auto-calificación en el cierre de sesión y la sesión aun no ha cerrado.';
$string['automarkingnotenabled'] = 'Calificación  automática  no habilitada en esta sesión';
$string['automarktask'] = 'Revisar las sesiones de asistencia que requieran auto-calificación';
$string['automarkuseempty'] = 'Manejo de disponibilidad de estado auto-calificar';
$string['automarkuseempty_desc'] = 'Si se activa, los elementos del estado que tengan  vacía/sin configurar la configuración "disponible para" serán permitidos durante auto-calificar';
$string['autorecorded'] = 'sistema atuto grabado';
$string['availability'] = 'Disponibilidad auto-marcaje';
$string['availability_help'] = 'Restringir disponibilidad de este estado. <br> Si la opción "Limitado" es seleccionada, entonces proporcione el número de minutos que este estado está disponible después que inicie la sesión. Esto es aplicable cuando los estudiantes están marcando su propia asistencia.';
$string['availabilityalways'] = 'Siempre';
$string['availabilitylimitedtime'] = 'Hora limitada';
$string['availabilityno'] = 'No';
$string['availablebeforesession'] = 'Disponible antes de que inicie la sesión';
$string['availablebeforesession_help'] = 'Cuando los estudiantes están marcando su propia asistencia, permitir que este estado sea elegido antes de que inicie la sesión.';
$string['averageattendance'] = 'Asistencia promedio';
$string['averageattendancegraded'] = 'Asistencia promedio';
$string['backtoparticipants'] = 'Regresar a lista de participantes';
$string['below'] = 'Debajo de {$a}%';
$string['calclose'] = 'Cerrar';
$string['calendarevent'] = 'Crear evento de calendario para sesión';
$string['calendarevent_help'] = 'Si se habilita, será creado un evento del calendario para esta sesión. Si se deshabilita, cualquier evento de calendario existente para esta sesión será eliminado.';
$string['caleventcreated'] = 'Evento de calendario para sesión creado exitosamente';
$string['caleventdeleted'] = 'Evento de calendario para sesión eliminado exitosamente';
$string['calmonths'] = 'Enero,Febrero,Marzo,Abril,Mayo,Junio,Julio,Agosto,Septiembre,Octubre,Noviembre,Diciembre';
$string['calshow'] = 'Fecha de término';
$string['calweekdays'] = 'Do,Lu,Ma,Mi,Ju,Vi,Sa';
$string['cannottakeforgroup'] = 'Usted no puede tomar asistencia para el grupo "{$a}"';
$string['cannottakethisgroup'] = 'Usted no es un miembro del grupo del curso con el cual se relaciona esta sesión de Asistencia; su asistencia NO ha sido grabada.';
$string['cantaddstatus'] = 'Usted debe configurar un acrónimo y una descripción al añadir un nuevo estatus.';
$string['canthidestatus'] = 'Usted no puede ocultar este estado porque ya está en uso dentro de esta actividad de Asistencia';
$string['categoryreport'] = 'Reporte de categoría de curso';
$string['changeattendance'] = 'Cambiar asistencia';
$string['changeduration'] = 'Cambiar duración';
$string['changesession'] = 'Cambiar sesión';
$string['checkweekdays'] = 'Seleccionar días de la semana que caen dentro del rango de fechas de sus sesiones seleccionadas.';
$string['closed'] = 'Esta sesión actualmente no está disponible para auto-calificar';
$string['column'] = 'columna';
$string['columnmap'] = 'Mapeo de columnas';
$string['columnmap_help'] = 'Para cada campo presentado, seleccione la columna correspondiente en el archivo CSV.';
$string['columns'] = 'columnas';
$string['commonsession'] = 'Todos los estudiantes';
$string['commonsessions'] = 'Todos los estudiantes';
$string['confirm'] = 'Confirmar';
$string['confirmcolumnmappings'] = 'Confirmar mapeo de columna';
$string['confirmdeletehiddensessions'] = '¿Está Usted seguro de querer eliminar {$a->count} sesiones agendadas para antes de la fecha de inicio del curso ({$a->date})?';
$string['confirmdeleteuser'] = '¿Está Usted seguro de querer eliminar al usuario \'{$a->fullname}\' ({$a->email})?<br/>Todos sus registros de asistencia serán eliminados permanentemente.';
$string['copyfrom'] = 'Copiar datos de asistencia desde';
$string['countofselected'] = 'Número de seleccionados';
$string['course'] = 'Curso';
$string['coursemessage'] = 'Mensajear a usuarios del curso';
$string['courseshortname'] = 'Nombre corto del curso';
$string['coursesummary'] = 'Reporte de resumen del curso';
$string['createmultiplesessions'] = 'Crear múltiples sesiones';
$string['createmultiplesessions_help'] = 'Esta función le permite crear sesiones múltiples en un paso simple.
Las sesiones empiezan en la fecha de la sesión base y continúan hasta la fecha de  \'repetir hasta\'.

 * <strong>Repetir en</strong>: Seleccione los días de la semana cuando se reunirá su clase (por ejemplo, Lunes/Miércoles/Viernes).
* <strong>Repetir cada</strong>: Estop permite una configuración de frecuencia. Si su clase se reúne cada semana, seleccione 1; si se reunirá una semana si y otra no, seleccione 2; y así sucesivamente
* <strong>Repetir hasta</strong>: Seleccione el último día de clase (el último día que Usted quiere tomar asistencia).';
$string['createonesession'] = 'Crear una sesión para el curso';
$string['csvdelimiter'] = 'Delimitador CSV';
$string['currentlyselectedusers'] = 'Usuarios actualmente seleccionados';
$string['customexportfields'] = 'Exportar campos personalizados de perfil del usuario';
$string['customexportfields_help'] = 'Campos personalizados de perfil del usuario extra a exponer en el reporte de exportación.';
$string['customfields'] = 'Campos personalizados de sesión';
$string['date'] = 'Fecha';
$string['days'] = 'Días';
$string['defaultdisplaymode'] = 'Modo de visualización por defecto';
$string['defaults'] = 'Ajustes por defecto';
$string['defaultsessionsettings'] = 'Configuraciones por defecto de la sesión';
$string['defaultsessionsettings_help'] = 'Estas configuraciones definen los valores por defecto para todas las sesiones nuevas';
$string['defaultsettings'] = 'Configuraciones por defecto de asistencia';
$string['defaultsettings_help'] = 'Estas configuraciones definen los valores por defecto para todas las asistencias nuevas';
$string['defaultstatus'] = 'Estatus por defecto configurado';
$string['defaultsubnet'] = 'Dirección de red por defecto';
$string['defaultsubnet_help'] = 'Las grabaciones de Asistencia pueden restringirse a subredes particulares al especificar una lista separada por comas de las direcciones IP parciales o completas. Este es el valor por defecto usado al crear nuvevas sesiones.';
$string['defaultview'] = 'Vista por defecto al ingreso';
$string['defaultview_desc'] = 'Esta es la vista por defecto mostrada a profesores en su primer ingreso.';
$string['defaultwarnings'] = 'Configuración de advertencia por defecto';
$string['defaultwarningsettings'] = 'Configuraciones de advertencia por defecto';
$string['defaultwarningsettings_help'] = 'Estas configuraciones definen los valores por defecto para todas las nuevas advertencias';
$string['delete'] = 'Eliminar';
$string['deletecheckfull'] = '¿Está absolutamente seguro de querer eliminar por completo  {$a},  incluyendo todos los datos de usuario?';
$string['deletedgroup'] = 'El grupo asociado con esta sesión ha sido eliminado';
$string['deletehiddensessions'] = 'Eliminar todas las sesiones ocultas';
$string['deletelogs'] = 'Eliminar datos de asistencia';
$string['deleteselected'] = 'Eliminar seleccionado';
$string['deletesession'] = 'Eliminar sesión';
$string['deletesessions'] = 'Eliminar todas las sesiones';
$string['deleteuser'] = 'Eliminar usuario';
$string['deletewarningconfirm'] = '¿ Está Usted seguro de querer eliminar esta advertencia ?';
$string['deletingsession'] = 'Eleminando sesión para el curso';
$string['deletingstatus'] = 'Eleminando estatus para el curso';
$string['description'] = 'Descripción';
$string['display'] = 'Mostrar';
$string['displaymode'] = 'Modo de visualización';
$string['donotusepaging'] = 'No usar buscapersonas';
$string['downloadexcel'] = 'Descargar en formato Excel';
$string['downloadooo'] = 'Descargar en formato OpenOffice';
$string['downloadtext'] = 'Descargar en formato de texto';
$string['duration'] = 'Duración';
$string['editsession'] = 'Editar sesión';
$string['edituser'] = 'Editar usuario';
$string['emailcontent'] = 'Contenido de Email';
$string['emailcontent_default'] = 'Hola %userfirstname%,
Su asistencia en %coursename% %attendancename% ha disminuído por debajo de %warningpercent% y actualmente está en %percent% - ¡Nosotros esperamos que Usted esté bien!
Para obtener los mejores resultados de este curso, Usted debería de mejorar su asistencia. Por favor, póngase en contacto si necesita más soporte.';
$string['emailcontent_help'] = 'Cuando es enviada una advertencia al estudiante, toma el contenido del Email de este campo. Pueden usarse los siguientes comodines (wildcards) TAL Y COMO ESTÁN ESCRITOS EN IDIOMA INGLÉS:
ul>
    <li>%coursename%</li>
    <li>%userfirstname%</li>
    <li>%userlastname%</li>
    <li>%userid%</li>
    <li>%warningpercent%</li>
    <li>%attendancename%</li>
    <li>%cmid%</li>
    <li>%numtakensessions%</li>
    <li>%points%</li>
    <li>%maxpoints%</li>
    <li>%percent%</li>
</ul>';
$string['emailsubject'] = 'Asunto del Email';
$string['emailsubject_default'] = 'Advertencia de Asistencia';
$string['emailsubject_help'] = 'Cuando se envía una advertencia a un estudiante, toma el asunto del Email de este campo.';
$string['emailuser'] = 'Email al usuario';
$string['emailuser_help'] = 'Si se activa, se enviará una advertencia al estudiante.';
$string['emptyacronym'] = 'No están permitidos los acrónimos vacíos. Registro de estatus no actualizado.';
$string['emptydescription'] = 'No están permitidas las descripciones vacías. Registro de estatus no actualizado.';
$string['enablecalendar'] = 'Crear eventos del calendario';
$string['enablecalendar_desc'] = 'Si se habilita, será creado un evento del calendario para cada sesión de Asistencia. Después de cambiar esta configuración Usted debería de correr el reincicio del reporte del calendario.';
$string['enablewarnings'] = 'Habilitar advertencias';
$string['enablewarnings_desc'] = 'Esto permite que sea definido un conjunto de advertencia para una asistencia y notificaciones Email a usuarios cuando la asistencia caiga debajo del umbral configurado. <br/><strong>ADVERTENCIA: Esta es una característica nueva y no ha sido probada extensivamente. Por favor, úsela bajo su propio riesgo y proporcione retroalimentación en los foros de Moodle si Usted encuentra que funciona bien.</strong>';
$string['encoding'] = 'Codificación';
$string['encoding_help'] = 'Esto se refiere al tipo de codificación de código de barras usado en la credencial de identificación del estudiante. Los tipos típicos de esquemas de codificación de código de barras incluyen Code-39, Code-128 y UPC-A.';
$string['endofperiod'] = 'Fin del período';
$string['endtime'] = 'Hora de fin de sesión';
$string['enrolmentend'] = 'La inscripción del usuario termina en {$a}';
$string['enrolmentstart'] = 'La inscripción del usuario principia en {$a}';
$string['enrolmentsuspended'] = 'Inscripción suspendida';
$string['enterpassword'] = 'Ingrese contraseña';
$string['error:coursehasnoattendance'] = 'El curso con el nombre corto {$a} no tiene actividades de asistencia.';
$string['error:coursenotfound'] = 'Un curso con el nombre corto {$a} no puede ser encontrado.';
$string['error:qrcode'] = '¡El permitirles a los estudiantes que registren su propia asistencia debe estar habilitado para usar el código QR! Saltándolo.';
$string['error:sessioncourseinvalid'] = '¡Un curso de sesión es inválido! Saltándolo.';
$string['error:sessiondateinvalid'] = '¡Una fecha de sesión es inválida! Saltándola.';
$string['error:sessionendinvalid'] = '¡Una hora de término de sesión es inválida! Saltándola.';
$string['error:sessionstartinvalid'] = '¡Una hora de inicio de sesión es inválida! Saltándola.';
$string['error:statusnotfound'] = 'Usuario: {$a->extuser} tiene un valor del status que no pudo ser encontrado: {$a->status}';
$string['error:timenotreadable'] = 'Usuario: {$a->extuser} tiene una horadeescaneo que no se pudo convertir por strtotime: {$a->scantime}';
$string['error:userduplicate'] = 'Usuario{$a} se encontró dos veces en la importación. Por favor incluya solamente un registro por usuario..';
$string['error:usernotfound'] = 'Un usuario con el {$a->userfield} configurado a {$a->extuser} no se pudo encontrar en este curso';
$string['errorgroupsnotselected'] = 'Seleccionar uno o más grupos';
$string['errorinaddingsession'] = 'Error al añadir sesión';
$string['erroringeneratingsessions'] = 'Error al generar sesión';
$string['eventdurationupdated'] = 'Duración de sesión actualizada';
$string['eventreportviewed'] = 'Reporte de asistencia visto';
$string['eventscreated'] = 'Eventos de calendario creados';
$string['eventsdeleted'] = 'Eventos de calendario eliminados';
$string['eventsessionadded'] = 'Sesión añadida';
$string['eventsessiondeleted'] = 'Sesión eliminada';
$string['eventsessionipshared'] = 'Conflicto de IP en auto-calificar de Asistencia';
$string['eventsessionsimported'] = 'Sesiones importadas';
$string['eventsessionupdated'] = 'Sesión actualizada';
$string['eventstatusadded'] = 'Estatus añadido';
$string['eventstatusupdated'] = 'Estatus actualizado';
$string['eventstudentattendancesessionsupdated'] = 'Reporte de sesión actualizado';
$string['eventstudentattendancesessionsviewed'] = 'Reporte de sesión visto';
$string['eventtaken'] = 'Asistencia tomada';
$string['eventtakenbystudent'] = 'Asistencia tomada por el estudiante';
$string['export'] = 'Exportar';
$string['extrarestrictions'] = 'Restricciones extra';
$string['formattexttype'] = 'Formateando';
$string['from'] = 'desde:';
$string['gradebookexplanation'] = 'Calificación en Libro de Calificaciones';
$string['gradebookexplanation_help'] = 'El módulo de asistencia muestra su calificación actual por asistencia basada en el número de puntos que Usted ha ganado a la fecha y el número total de puntos que podría haber ganado a la fecha; no incluye los períodos de clase del futuro. En el libro de calificaciones, su calificación de asistencia se basa en su porcentaje actual de asistencia y el número de puntos que pueden ganarse sobre la duración completa del curso, incluyendo a los períodos de clases futuras. Como tal, sus calificaciones de asistencia mostradas en el módulo de asistencia y en el libro de calificaciones puede que no sean el mismo número de puntos, pero son el mismo porcentaje.

Por ejemplo, si Usted ha ganado 8 de 10 puntos a la fecha (80% de asistencia), y la asistencia para el curso completo vale 50 puntos, el módulo de Asistencia le mostrará 8/10 y el Libro de calificaciones le mostrará 40/50. Usted no se ha ganado 40 puntos todavía, pero 40 es el equivalente del valor en puntos a su porcentaje de asistencia actual del 80%. El valor en puntos que Usted ha ganado en el módulo de Asistencia nunca puede disminuir, porque está basado únicamente en la asistencia a la fecha; sin embargo, el valor en puntos por asistencia mostrado en el Libro de calificaciones puede aumentar o disminuir dependiendo de sus asistencias futuras, dado que está basado en la asistencia al curso completo.';
$string['graded'] = 'Sesiones calificadas';
$string['gridcolumns'] = 'Columnas de rejilla';
$string['group'] = 'Grupo';
$string['groups'] = 'Grupos';
$string['groupsession'] = 'Grupo de estudiantes';
$string['groupsessionsby'] = 'Agrupar sesiones por';
$string['hiddensessions'] = 'Sesiones ocultas';
$string['hiddensessions_help'] = 'Las sesiones se ocultan si están agendadas para la fecha de inicio del curso.

Usted puede usar esta característica para ocultar sesiones antiguas en lugar de eliminarlas. Recuerde que solamente las sesiones visibles aparecerán en el Libro de Calificaciones.';
$string['hiddensessionsdeleted'] = 'Todas las sesiones ocultas fueron eliminadas';
$string['hideextrauserdetails'] = 'Ocultar detalles extra del usuario';
$string['hidensessiondetails'] = 'Ocultar detalles de sesiones';
$string['identifyby'] = 'Identificar al estudiante por';
$string['import'] = 'Importar';
$string['importfile'] = 'Importar archivo';
$string['importfile_help'] = 'El archivo CSV debe contener un encabezado y campos para identificar los grupos, la hora y las fechas de las sesiones que se crearán.<br/> La siguiente página después de depositar el archivo le mostrará ejemplos de todos los campos a los que puede asignar sus propios campos.<br/>Ejemplo:<br/>grupos;fecha de sesión;desde;hasta<br/>grupoA:05-10-2022;13:00;14:00<br/>grupoB;05-10-2022;14:00;15:00';
$string['importsessions'] = 'Importar Sesiones';
$string['importstatus'] = 'Campo del estatus';
$string['importstatus_help'] = 'Esto permite que un valor del estatus sea incluido en la importación - por ejemplo, valores como P, L o A (Present, Late, Absent)';
$string['includeabsentee'] = 'Incluir sesión al calcular reporte de faltantes';
$string['includeabsentee_help'] = 'Si se activa, esta sesión será incluida en los cálculos del reporte de faltantes.';
$string['includeall'] = 'Seleccionar todas las sesiones';
$string['includedescription'] = 'Incluir descripción de sesión';
$string['includenottaken'] = 'Incluir sesiones no tomadas';
$string['includeqrcode'] = 'Incluir código QR';
$string['includeremarks'] = 'Incluir comentarios';
$string['incorrectpassword'] = 'Usted ha ingresado una contraseña incorrecta y su asistencia no ha sido grabada; por favor ingrese la contraseña correcta.';
$string['incorrectpasswordshort'] = 'Contraseña incorrecta, la asistencia no fue grabada.';
$string['indetail'] = 'En detalle ...';
$string['indicator:cognitivedepth'] = 'Asistencia cognitiva';
$string['indicator:cognitivedepth_help'] = 'Este indicador está basado en la profundidad cognitiva alcanzada por el estudiante en la actividad Asistencia.';
$string['indicator:cognitivedepthdef'] = 'Asistencia cognitiva';
$string['indicator:cognitivedepthdef_help'] = 'El participante ha alcanzado este porcentaje del compromiso cognitivo ofrecido por la Asistencia durante este intervalo de análisis (Niveles = No Visto, Visto)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Asistencia social';
$string['indicator:socialbreadth_help'] = 'Este indicador está basado en la amplitud social alcanzada por el estudiante en la actividad Asistencia.';
$string['indicator:socialbreadthdef'] = 'Asistencia social';
$string['indicator:socialbreadthdef_help'] = 'El participante ha alcanzado este porcentaje del compromiso social ofrecido por la Asistencia durante este intervalo de análisis (Niveles = Sin participación, Solamente participación)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['invalidaction'] = 'Usted tiene que seleccionar una acción';
$string['invalidemails'] = 'Usted debe de especificar las direcciones de las cuentas de usuarios existentes; no pudo encontrarse : {$a}';
$string['invalidimportfile'] = 'El formato de archivo es inválido.';
$string['invalidsessionenddate'] = 'Esta fecha no puede ser anterior a la fecha de la sesión';
$string['invalidsessionendtime'] = 'La hora final debe ser posterior a la hora inicial';
$string['invalidstatus'] = 'Usted ha seleccionado un estatus inválido; por favor inténtelo nuevamente';
$string['iptimemissing'] = 'Minutos para liberación inválidos';
$string['jumpto'] = 'Saltar a';
$string['keepsearching'] = 'Seguir buscando';
$string['lasttaken'] = 'Asistencias tomadas por última vez';
$string['manualtriggerauto'] = 'Disparar manualmente calificación automática';
$string['marksessionimportcsvhelp'] = 'Este formato le permite subir un archivo CSV que contiene un identificador del usuario y un estado - el campo del estado puede ser el acrónimo del estado o la hora de cuando fue grabada la asistencia para ese usuario.Si una hora es pasada entonces tratará de asignar el valor del estado con la calificación más alta disponible en ese momento.';
$string['maxpossible'] = 'Máximo posible';
$string['maxpossible_help'] = 'Mostrar el puntaje que cada usuario puede alcanzar si recibe el máximo de puntos posibles en cada sesión que todavía no haya tomado (pasadas y futuras):
<ul>
<li><strong>Puntos</strong>: puntos máximos que cada usuario puede alcanzar sobre todas las sesiones.</li>
<li><strong>Porcentaje</strong>: porcentaje máximo que cada usuario puede alcanzar sobre todas las sesiones.</li>
</ul>';
$string['maxpossiblepercentage'] = 'Porcentaje posible máximo';
$string['maxpossiblepoints'] = 'Puntos posibles máximos';
$string['maxwarn'] = 'Número máximo de advertencias Email';
$string['maxwarn_help'] = 'El número máximo de veces que debería enviarse una advertencia (solamente es enviada una advertencia por sesión)';
$string['mergeuser'] = 'Juntar usuario';
$string['messagedselecteduserfailed'] = 'No se pudo enviar un mensaje a uno o más de los usuarios. Por favor active la depuración de errores para averiguar más.';
$string['mobilesessionfrom'] = 'Mostrar sesiones más antiguas que la última';
$string['mobilesessionfrom_help'] = 'Permitir que la lista de sesisones sea restringida al calificar en la App - solamente muestra sesiones que iniciaron después de este valor.';
$string['mobilesessionto'] = 'Mostrar sesiones futuras';
$string['mobilesessionto_help'] = 'Permitir que la lista de sesiones sea restringida a solamente mostrar un pequeño número de sesiones futuras.';
$string['mobilesettings'] = 'Configuraciones de App mobile';
$string['mobilesettings_help'] = 'Estas configuraciones controlan el comportamiento de la App mobile Moodle';
$string['modulename'] = 'Asistencia (Attendance)';
$string['modulename_help'] = 'El módulo de actividad Asistencia (Attendance) le permite al profesor pasar lista durante la clase y a los estudiantes les permite ver su propio registro de asistencias.

El profesor puede crear sesiones múltiples y puede calificar el status de asistencia como "Presente", "Ausente", "Retardo", o "Justificado" o modificar los estatus para que se adapten a sus necesidades.

Hay reportes disponibles para la clase completa o para alumnos individuales.';
$string['modulenameplural'] = 'Asistencias';
$string['months'] = 'Meses';
$string['moreattendance'] = 'La asistencia ha sido tomada exitosamente para esta página';
$string['moveleft'] = 'Mover a la izquierda';
$string['moveright'] = 'Mover a la derecha';
$string['multisessionexpanded'] = 'Sesiones múltiples expandidas';
$string['multisessionexpanded_desc'] = 'Mostrar las configuraciones de "Sesiones múltiples" como expandidas por defecto cuando se crean sesiones nuevas.';
$string['mustselectusers'] = 'Debe seleccionar los usuarios a exportar';
$string['name'] = 'Nombre';
$string['newdate'] = 'Nueva fecha';
$string['newduration'] = 'Nueva duración';
$string['newstatusset'] = 'Nuevo conjunto de estatuses';
$string['noabsentstatusset'] = 'El estatus configurado en uso no tiene un estatus a usar cuando no está calificado.';
$string['noattendanceusers'] = 'No es posible exportar ningún dato porque no hay estudiantes inscritos en el curso.';
$string['noattforuser'] = 'No hay registros de asistencia para el usuario';
$string['noautomark'] = 'Deshabilitado';
$string['nocapabilitytotakethisattendance'] = 'Usted intentó cambiar la asistencia de una sesión con cmid: {$a} la cual usted no tiene permitido modificar.';
$string['nodescription'] = 'Sesión de clase regular';
$string['noeventstoreset'] = 'No hay eventos del calendario que requieran una actualización.';
$string['nogroups'] = 'Esta actividad ha sido configurada para usar grupos, pero no existen grupos en este curso.';
$string['noguest'] = 'Los invitados no pueden ver la asistencia';
$string['noofdaysabsent'] = 'Número de días ausente';
$string['noofdaysexcused'] = 'Número de días disculpado';
$string['noofdayslate'] = 'Número de días con retardo';
$string['noofdayspresent'] = 'Número de días presente';
$string['nosessiondayselected'] = 'No se seleccionó día de sesión';
$string['nosessionexists'] = 'No existe sesión para este curso';
$string['nosessionsselected'] = 'Número de sesiones seleccionadas';
$string['notfound'] = '¡ No se encontró actividad de asistencia en este curso !';
$string['notifytask'] = 'Enviar advertencias a usuarios';
$string['notmember'] = 'no miembro';
$string['notset'] = 'no configurado';
$string['nounmarkedstatusset'] = 'No está configurado estado sin caliicar para esta sesión (id:{$a->sessionid}), para corregir esto actualice el <a href="{$a->url}">Estado configurado</a>';
$string['noupgradefromthisversion'] = 'El módulo de Asistencia (Attendance) no puede actualizarse desde la versión de attforblock que Usted tiene instalada. - Por favor, elimine attforblock o actualícelo a la versión más reciente antes de instalar el nuevo módulo de asistencia.';
$string['nousers'] = 'No se encontraron usuarios registrados para tomar asistencia.';
$string['numsessions'] = 'Número de sesiones';
$string['numsessionstaken'] = 'Número de sesiones tomadas';
$string['olddate'] = 'Fecha antigua';
$string['onactivitycompletion'] = 'En finalización de actividad';
$string['onlyselectedusers'] = 'Exportar usuarios específicos';
$string['overallsessions'] = 'Sobre todas las sesiones';
$string['overallsessions_help'] = 'Mostrar estadísticas para todas las sesiones incluyendo aquellas aun no tomadas (pasadas y futuras):
<ul>
<li><strong>Sesiones</strong>: número total de sesiones.</li>
<li><strong>Puntos</strong>: puntos otorgados basados en las sesiones tomadas.</li>
<li><strong>Porcentaje</strong>: porcentaje de puntos otorgados sobre el máximo posible de puntos para todas las sesiones.</li>
</ul>';
$string['oversessionstaken'] = 'Sobre sesiones tomadas';
$string['oversessionstaken_help'] = 'Mostrar estadísticas para sesiones en donde se ha tomado asistencia:
<ul>
   <li><strong>Sesiones</strong>: número de sesiones ya tomadas.</li>
   <li><strong>Puntos</strong>: puntos otorgados basados en las sesiones tomadas.</li>
   <li><strong>Porcentaje</strong>: porcentaje de puntos otorgados sobre el máximo de puntos posibles de las sesiones tomadas.</li>
</ul>';
$string['pageof'] = 'Página {$a->page} de {$a->numpages}';
$string['participant'] = 'Participante';
$string['password'] = 'Contraseña';
$string['passwordgrp'] = 'Contraseña del estudiante';
$string['passwordgrp_help'] = 'Si se activa, a los estudiantes se les pedirá que ingresen esta contraseña antes de que ellos puedan configurar su propio estatus de asistencia para la sesión. Si se deja vacío, no se necesitará contraseña.';
$string['passwordheader'] = 'Usar la contraseña enlistada debajo para tomar su asistencia';
$string['passwordrequired'] = 'Usted debe de ingresar la contraseña de sesión antes de que Usted pueda enviar su asistencia';
$string['percentage'] = 'Porcentaje';
$string['percentageallsessions'] = 'Porcentaje sobre todas las sesiones';
$string['percentagesessionscompleted'] = 'Porcentaje sobre las sesiones tomadas';
$string['pluginadministration'] = 'Administración de asistencia';
$string['pluginname'] = 'Asistencia';
$string['points'] = 'Puntos';
$string['pointsallsessions'] = 'Puntos sobre todas las sesiones';
$string['pointssessionscompleted'] = 'Puntos sobre las sesiones tomadas';
$string['preferences_desc'] = 'Cambios a los conjuntos de estatus afectarán a las asistencias existentes y podrían afectar la calificación.';
$string['preventsharederror'] = 'El auto-calificar ha sido deshabilitado por una sesión porque este dispositivo parece que ha sido usado  para grabar asistencia para otro estudiante.';
$string['preventsharedip'] = 'Impedir que los estudiantes compartan dirección IP';
$string['preventsharedip_help'] = 'Impedirle a estudiantes usar el mismo dispositivo (identificado usando la dirección IP) para tomar asistencia para otros estudiantes.';
$string['preventsharediptime'] = 'Tiempo para permitir re-utilización de dirección IP (minutos)';
$string['preventsharediptime_help'] = 'Permitir que una dirección IP sea re-utilizada para tomar asistencia en esta sesión después de que haya pasado este tiempo.';
$string['preview'] = 'Previsualización del archivo';
$string['previewhtml'] = 'Previsualización formato HTML';
$string['priorto'] = 'La fecha de la sesión es anterior a la fecha de inicio del curso ({$a}) de forma tal que las nuevas sesiones agendadas antes de esta fecha estarán ocultas (no accessibles).Usted puede cambiar la fecha de inicio del curso en cualquier momento  (vea las configuraciones del curso) para sí tener acceso a sesiones anteriores.<br><br>Por favor, cambie la fecha de la sesión o simplemente haga clic en  el botón para "Añadir sesión" para confirmar?';
$string['privacy:metadata:attendancelog'] = 'Bitácora de asistencias del usuario grabada.';
$string['privacy:metadata:attendancesessions'] = 'Sesiones cuyas asistencias serán grabadas.';
$string['privacy:metadata:attendancewarningdone'] = 'Bitácora de advertencias enviadas a usuarios acerca de sus registros de asistencias.';
$string['privacy:metadata:duration'] = 'DSuración de la sesión en segundos';
$string['privacy:metadata:groupid'] = 'ID del grupo asociada con la sesión.';
$string['privacy:metadata:ipaddress'] = 'Dirección IP desde donde se marcó la asistencia.';
$string['privacy:metadata:lasttaken'] = 'Sello de tiempo de cuando se tomó por última vez la asistencia a sesión.';
$string['privacy:metadata:lasttakenby'] = 'ID del último usuario en tomar asistencia en esta sesión.';
$string['privacy:metadata:notifyid'] = 'ID de la sesión de asistencia con la cual está asociada la advertencia.';
$string['privacy:metadata:remarks'] = 'Comentarios acerca de la asistencia del usuario.';
$string['privacy:metadata:sessdate'] = 'Sello de tiempo de cuando inicia la sesión.';
$string['privacy:metadata:sessionid'] = 'ID de la sesión de asistencia.';
$string['privacy:metadata:statusid'] = 'ID del estado de asistencia del estudiante.';
$string['privacy:metadata:statusset'] = 'Estado configurado a donde pertenece la ID del estado.';
$string['privacy:metadata:studentid'] = 'ID del estudiante a quien se le está grabando su asistencia.';
$string['privacy:metadata:takenby'] = 'ID del usuario del usuario que tomó asistencia para el estudiante.';
$string['privacy:metadata:timemodified'] = 'Sello de tiempo de cuando la sesión fue modificada por última vez.';
$string['privacy:metadata:timesent'] = 'Sello de tiempo de cuando se configuró la advertencia.';
$string['privacy:metadata:timetaken'] = 'Sello de tiempo de cuando fue tomada la asistencia para el estudiante.';
$string['privacy:metadata:userid'] = 'ID del usuario a quien enviar advertencia.';
$string['processingfile'] = 'Procesando archivo';
$string['qr_cookie_error'] = 'Sesión QR ha expirado';
$string['qr_pass_wrong'] = 'El código QR ha expirado; por favor escanee nuevamente el código QR.';
$string['qrcode'] = 'Código QR';
$string['qrcodeandpasswordheader'] = 'Escanear el código QR inferior o usar la contraseña enlistada debajo para tomar su asistencia';
$string['qrcodeheader'] = 'Escanee el código QR inferior para tomar su asistencia';
$string['qrcodevalidafter'] = 'segundos';
$string['qrcodevalidbefore'] = 'Código QR válido por:';
$string['randompassword'] = 'Contraseña aleatoria';
$string['remark'] = 'Comentario para: {a}';
$string['remarks'] = 'Observaciones';
$string['repeatasfollows'] = 'Repetir la sesión de arriba como sigue';
$string['repeatevery'] = 'Repetir cada';
$string['repeaton'] = 'Repetir en';
$string['repeatuntil'] = 'Repetir hasta';
$string['report'] = 'Reporte';
$string['reportsessiondate'] = 'Fecha de sesión';
$string['reportsessionduration'] = 'Duración de sesión';
$string['reportsessionlasttaken'] = 'Hora de última vez que se tomó la sesión (profesor)';
$string['required'] = 'Requerida*';
$string['requiredentries'] = 'Registros temporales sobrescriben registros de asistencia de participante';
$string['requiredentry'] = 'Guía para ayuda con unión de usuario temporal';
$string['requiredentry_help'] = '<p align="center"><b>Asistencia (Attendance)</b></p>
<p align="left"><strong>Unir Cuentas</strong></p>
<p align="left">
<table border="2" cellpadding="4">
<tr>
<th>Usuario Moodle</th>
<th>Usuario Temporal</th>
<th>Acción</th>
</tr>
<tr>
<td>Datos de asistencia</td>
<td>Datos de asistencia</td>
<td>Usuario temporal anulará a usuario Moodle</td>
</tr>
<tr>
<td>Sin datos de asistencia</td>
<td>Datos de asistencia</td>
<td>La sistencia del usuario temporal será transferida al usuario Moodle</td>
</tr>
<tr>
<td>Datos de asistencia</td>
<td>Sin datos de asistencia</td>
<td>El usuario temporal será eliminado</td>
</tr>
<tr>
<td>Sin datos de asistencia</td>
<td>Sin datos de asistencia</td>
<td>El usuario temporal será eliminado</td>
</tr>
</table>

</p>
<p align="left"><strong>El usuario temporal será eliminado en todos los casos después de la acción de juntar</strong></p>';
$string['requiresubnet'] = 'Requerir direcciones de red';
$string['requiresubnet_help'] = 'La grabación de asistencia puede restringirse a sub-redes particulares al especificar una lista separada por comas de direcciones IP parciales o completas.';
$string['resetcaledarcreate'] = 'Los eventos del calendario han sido habilitados, pero varias sesiones no tienen eventos. ¿ Quiere Usted crear eventos del calendario paa todas las sesiones existetes ?';
$string['resetcaledardelete'] = 'Los eventos del calendario han sido des-habilitados, pero varias sesiones tienen eventos que deberían de ser eliminados. ¿ Quiere Usted eliminar todos los eventos existetes ?';
$string['resetcalendar'] = 'Reiniciar calendario';
$string['resetdescription'] = 'Recuerde que al eliminar datos de asistencias eliminará información de la BasedeDatos. ¡ Usted puede simplemente ocultar las sesiones antiguas al cambiarles la fecha de inicio del curso !';
$string['resetstatuses'] = 'Reiniciar estatus a como estaban por defecto';
$string['restoredefaults'] = 'Restaurar por defecto';
$string['resultsperpage'] = 'Resultados por página';
$string['resultsperpage_desc'] = 'Número de estudiantes mostrados en una página';
$string['rotateqrcode'] = 'Rotar código QR';
$string['rotateqrcode_cleartemppass_task'] = 'Trabajo para borrar contraseñas temporales generadas por la funcionalidad de rotar código QR.';
$string['rotateqrcodeexpirymargin'] = 'Margen (segundos) de expiración para rortar contraseña/código QR';
$string['rotateqrcodeexpirymargin_desc'] = 'Intervalo de tiempo (segundos) para permitir contraseña/código QR expirado.';
$string['rotateqrcodeinterval'] = 'Intervalo (segundos) para rotar contraseña/código QR';
$string['rotateqrcodeinterval_desc'] = 'Intervalo de tiempo (segundos) para rotar contraseña/código QR.';
$string['save'] = 'Guardar asistencia';
$string['saveandshownext'] = 'Guardar y mostrar página siguiente';
$string['scantime'] = 'Hora de escaneo';
$string['scantime_help'] = 'Esto permite que un sello de tiempo sea incluido en el archivo de importación - intentará convertir el sello de tiempo pasado usando la función PHP strotime y después usar la configuración del estado de asistencia para decidir cual estado es configurado para el usuario';
$string['search:activity'] = 'Asistencia - información de actividad';
$string['selectactivity'] = 'Seleccionar actividad';
$string['session'] = 'Sesión';
$string['session_help'] = 'Sesión';
$string['sessionadded'] = 'Sesión actualizada exitosamente';
$string['sessionalreadyexists'] = 'La sesión ya existe para esta fecha';
$string['sessiondate'] = 'Fecha';
$string['sessiondays'] = 'Días de sesión';
$string['sessiondeleted'] = 'Sesión eliminada exitosamente';
$string['sessiondescription'] = 'Descripción de sesión';
$string['sessionduplicate'] = 'Existe una sesión duplicada para el curso: {$a->course} en asistencia: {$a->activity}, {$a->date}';
$string['sessionexist'] = 'Sesión no añadida (Ya existe)';
$string['sessiongenerated'] = 'Se ha generado exitosamente una sesión';
$string['sessions'] = 'Sesiones';
$string['sessionsallcourses'] = 'Todos los cursos';
$string['sessionsbyactivity'] = 'Instancia de asistencia';
$string['sessionsbycourse'] = 'Curso';
$string['sessionsbydate'] = 'Semana';
$string['sessionscompleted'] = 'Sesiones tomadas';
$string['sessionscurrentcourses'] = 'Cursos actuales';
$string['sessionsgenerated'] = '{$a}  sesiones fueron generadas exitosamente';
$string['sessionsids'] = 'IDs de sesiones:';
$string['sessionsnotfound'] = 'No hay sesiones en el rango de fechas-horas seleccionado';
$string['sessionstartdate'] = 'Fecha de inicio de sesión';
$string['sessionstotal'] = 'Número total de sesiones';
$string['sessionsupdated'] = 'Sesiones actualizadas';
$string['sessiontype'] = 'Tipo';
$string['sessiontype_help'] = 'Usted puede añadir sesiones para todos los estudiantes o para un grupo de estudiantes. La habilidad para añadir diferentes tipos depende del modo de grupo de la actividad.

 * En el modo de grupos "Sin grupos" Usted solamente puede añadir sesiones comunes.}
* En el modo de grupo  "Grupos Separados" Usted solamente puede añadir sesiones para un grupo de estudiantes.
* En el modo de grupo "Grupos visibles" Usted puede añadir ambos tipos de sesiones.';
$string['sessiontypeshort'] = 'Tipo';
$string['sessionunknowngroup'] = 'Una sesión especifica grupo(s) desconocido(s): {$a}';
$string['sessionupdated'] = 'Sesión actualizada exitosamente';
$string['set_by_student'] = 'Auto-grabada';
$string['setallstatuses'] = 'Configurar estatus para';
$string['setallstatusesto'] = 'Configurar estatus a «{$a}»';
$string['setperiod'] = 'Tiempo especificado en minutos para liberar IP';
$string['settings'] = 'Configuraciones';
$string['setunmarked'] = 'Configurado automáticamente cuando no está calificado';
$string['setunmarked_help'] = 'Si se habilita en la sesión, configura este estatus si es que un estudiante no ha calificado sus propia asistencia.';
$string['showdefaults'] = 'Mostrar valores por defecto';
$string['showduration'] = 'Mostrar duración';
$string['showextrauserdetails'] = 'Mostrar detalles extra del usuario';
$string['showqrcode'] = 'Mostrar Código QR';
$string['showsessiondescriptiononreport'] = 'Mostrar descripción de sesión en el reporte';
$string['showsessiondescriptiononreport_desc'] = 'Mostrar la descripción de la sesión en el listado del reporte de asistencia.';
$string['showsessiondetails'] = 'Mostrar detalles de sesiones';
$string['somedisabledstatus'] = '(Algunas opciones han sido eliminadas porque la sesión ha comenzado).';
$string['sortedgrid'] = 'Parrilla ordenada';
$string['sortedlist'] = 'Lista ordenada';
$string['startofperiod'] = 'Inicio del período';
$string['starttime'] = 'Hora de inicio';
$string['status'] = 'Estatus';
$string['statusall'] = 'todos';
$string['statusdeleted'] = 'Estatus eliminado';
$string['statuses'] = 'Estatus';
$string['statusset'] = 'Estatus configurado {$a}';
$string['statussetsettings'] = 'Estatus configurado';
$string['statustotalcount'] = 'Estado {$a} - Número total';
$string['statustotalcountcurrentweek'] = 'Estado {$a} - Número total para semana actual';
$string['statustotalcountpreviousweek'] = 'Estado {$a} - Número total para semana anterior';
$string['statusunselected'] = 'no seleccionados';
$string['strftimedm'] = '%b %d';
$string['strftimedmw'] = '<nobr>%a %b %d</nobr>';
$string['strftimedmy'] = '%d %b %Y';
$string['strftimedmyhm'] = '%d %b %Y %I.%M%p';
$string['strftimedmyw'] = '<nobr>%a %d %b %Y</nobr>';
$string['strftimeh'] = '%I%p';
$string['strftimehm'] = '%I:%M%p';
$string['strftimeshortdate'] = '%d.%m.%Y';
$string['studentid'] = 'ID del estudiante';
$string['studentmarked'] = 'Su asistencia en esta sesión ha sido registrada.';
$string['studentmarking'] = 'Grabación del estudiante';
$string['studentpassword'] = 'Contraseña del estudiante';
$string['studentrecordingexpanded'] = 'Grabación del estudiante expandida';
$string['studentrecordingexpanded_desc'] = 'Mostrar las configuraciones de "Grabación del estudiante" como expandidas por defecto al crear sesiones nuevas.';
$string['studentscanmark'] = 'Permitirles a los estudiantes grabar su propia asistencia';
$string['studentscanmark_desc'] = 'Si se activa, los profesores podrán permitirles a los estudiantes el que marquen su propia asistencia.';
$string['studentscanmark_help'] = 'Si se activa, los estudiantes podrán cambiar el estatus de su propia asistencia para la sesión.';
$string['studentscanmarksessiontime'] = 'Los estudiantes registran asistencia durante el tiempo de la sesión';
$string['studentscanmarksessiontime_desc'] = 'Si se activa, los estudiantes solamente pueden registrar sus asistencias durante la sesión.';
$string['studentscanmarksessiontimeend'] = 'Fin de sesión (minutos)';
$string['studentscanmarksessiontimeend_desc'] = 'Si la sesión no tiene una hora de terminación, por cuantos minutos debería de estar disponible la sesión para que los estudiantes registren su asistencia.';
$string['studentsearlyopentime'] = 'Abrir sesión temprano para calificarla';
$string['studentsearlyopentime_help'] = 'Esto le permite a los profesores el abrir temprano la sesión, lo que permite que se tome la asistencia antes de la hora real de inicio.';
$string['submit'] = 'Enviar';
$string['submitattendance'] = 'Enviar asistencia';
$string['submitattendancefuture'] = 'Reportar ausencia futura';
$string['submitpassword'] = 'Enviar contraseña';
$string['subnet'] = 'Subred';
$string['subnetactivitylevel'] = 'Permitir configurar subred a nivel de actividad';
$string['subnetactivitylevel_desc'] = 'Si se habilita, los profesores pueden anular la sub-red por defecto al nivel de actividad al crear una asistencia. De lo contrario, se usará la configuración por defecto del sitio al crear una sesión.';
$string['subnetwrong'] = 'La asistencia solamente puede ser grabada desde ciertas localidades, y esta computadora no está en la lista permitida.';
$string['summary'] = 'Resumen';
$string['tablerenamefailed'] = 'Falló al renombrar tabla attforblock hacia asistencia';
$string['tactions'] = 'Acción';
$string['takeattendance'] = 'Tomar asistencia';
$string['takensessions'] = 'Sesiones tomadas';
$string['tcreated'] = 'Creado';
$string['tempaddform'] = 'Añadir usuario temporal';
$string['tempexists'] = 'Ya existe un usuario temporal con esta dirección Email';
$string['temptable'] = 'Lista de usuarios temporales';
$string['tempuser'] = 'Usuario temporal';
$string['tempusermerge'] = 'Unir usuario temporal';
$string['tempusers'] = 'Usuarios temporales';
$string['tempusersedit'] = 'Editar usuario temporal';
$string['tempuserslist'] = 'Usuarios temporales';
$string['thirdpartyemails'] = 'Notificar a otros usuarios';
$string['thirdpartyemails_help'] = 'Lista de todos los usuarios que serán notificados (requiere la capacidad mod/attendance:viewreports).';
$string['thirdpartyemailsubject'] = 'Advertencia de Asistencia';
$string['thirdpartyemailtext'] = '{$a->firstname} {$a->lastname} asistencia dentro de  {$a->coursename} {$a->aname} es menor que {$a->warningpercent} ({$a->percent})';
$string['thirdpartyemailtextfooter'] = 'Usted está está recibiendo esto porque el profesor de este curso ha añadido su Email a la lista de destinatarios';
$string['thiscourse'] = 'Este curso';
$string['time'] = 'Hora';
$string['timeahead'] = 'No pueden crearse sesiones múltiples que excedan de un año; por favor, ajuste las fechas de inicio y fin.';
$string['timemodified'] = 'Hora de modificación';
$string['timetaken'] = 'Hora de toma de asistencia';
$string['to'] = 'hasta:';
$string['todate'] = 'a la fecha';
$string['totalnumsessions'] = 'Número total de sesiones';
$string['triggered'] = 'Primer notificado';
$string['tuseremail'] = 'Email';
$string['tusername'] = 'Nombre completo';
$string['ungraded'] = 'Sesiones no-calificadas';
$string['unknowngroup'] = 'Grupo desconocido';
$string['unknownstatus'] = 'ID de estado desconocido: {$a}';
$string['update'] = 'Actualizar';
$string['updateattendance'] = 'Actualizar asistencia';
$string['uploadattendance'] = 'Actualizar asistencia por CSV';
$string['usedefaultsubnet'] = 'Usar valor por defecto';
$string['usemessageform'] = 'o usar el formato inferior para enviarle un mensaje a los estudiantes seleccionados';
$string['userexistingstatus'] = 'Su asistencia ya ha sido marcada como: <strong>{$a}</strong>, use el formato inferior para cambiarla si lo necesitara.';
$string['userexists'] = 'Ya existe un usuario real con esta dirección email';
$string['userid'] = 'ID del usuario';
$string['userimportfield'] = 'Campo externo del usuario';
$string['userimportfield_help'] = 'Campo del CSV subido que contiene identificador del usuario';
$string['userimportto'] = 'Campo Moodle del usuario';
$string['userimportto_help'] = 'Campo Moodle que coincide con los datos de la exportación CSV';
$string['users'] = 'Usuarios a exportar';
$string['usersessiongrade'] = 'Calificación de sesión del usuario';
$string['usersessionremarks'] = 'Comentarios a sesión del usuario';
$string['usersessiontaken'] = 'Sesión de usuario tomada';
$string['userstatus'] = 'Estado de sesión de usuario';
$string['usestatusset'] = 'Estatus configurado';
$string['variable'] = 'variable';
$string['variablesupdated'] = 'Variables actualizadas exitosamente';
$string['versionforprinting'] = 'versión para imprimir';
$string['viewmode'] = 'Modo de vista';
$string['warnafter'] = 'Número de sesiones tomadas antes de advertencia';
$string['warnafter_help'] = 'Las advertencias solamente serán disparadas cuando el usuario haya tenido su asistencia tomada por al menos este número de sesiones.';
$string['warningdeleted'] = 'Advertencia eliminada';
$string['warningdesc'] = 'Estas advertencias serán añadidas automáticamente a cuanquier nueva actividad de asistencia. Si más de una advertencia es disparada exactamente al mismo tiempo, solamente la advertencia con el umbral más bajo será enviada.';
$string['warningdesc_course'] = 'Los umbrales de advertencia aquí configurados afectan al reporte de inasistencias y les peermiten a los estudiantes y a terceras personas el ser notificados. Si más de una advertencia es disparada exactamente al mismo tiempo, solamente la advertencia con el umbral más bajo será enviada.';
$string['warningfailed'] = 'Usted no puede crear una advertencia que use el mismo porcentaje y número de sesiones.';
$string['warningpercent'] = 'Advertir si el porcentaje disminuye por debajo de';
$string['warningpercent_help'] = 'Se disparará una advertencia cuando el porcentaje general caiga por debajo de este número.';
$string['warnings'] = 'Advertencias configuradas';
$string['warningthreshold'] = 'Umbral de advertencia';
$string['warningupdated'] = 'Advertencias actualizadas';
$string['week'] = 'semana(s)';
$string['weekcommencing'] = 'Semana comenzando';
$string['weeks'] = 'Semanas';
$string['youcantdo'] = 'Usted no puede hacer nada';
