<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hsuforum', language 'fr', version '5.0'.
 *
 * @package     hsuforum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessible'] = 'Ouvert';
$string['activityoverview'] = 'Il y a de nouveaux messages dans le forum';
$string['addanewtopic'] = 'Ajouter une nouvelle discussion';
$string['addareply'] = 'Ajouter votre réponse';
$string['addyourdiscussion'] = 'Ajouter votre discussion';
$string['advancedsearch'] = 'Recherche avancée';
$string['ajaxrequesterror'] = 'Impossible de compléter la requête. Veuillez réessayer.';
$string['all'] = 'Tout';
$string['allforums'] = 'Tous les forums';
$string['allowanonymous'] = 'Autoriser les messages anonymes';
$string['allowanonymous_help'] = 'Le nom de l’auteur des messages sera supprimé dans le forum si cette option est cochée.';
$string['allowdiscussions'] = 'Est-ce que {$a} peut écrire un message dans ce forum ?';
$string['allowsallsubscribe'] = 'Ce forum permet à tous de choisir s’ils s’abonnent ou non';
$string['allowsdiscussions'] = 'Ce forum permet à tout le monde de démarrer une discussion.';
$string['allsubscribe'] = 'S’abonner à tous les forums';
$string['allunsubscribe'] = 'Se désabonner de tous les forums';
$string['alreadyfirstpost'] = 'C’est déjà le premier message de la discussion';
$string['anonymousalternatename'] = 'Anonyme';
$string['anonymousfirstname'] = 'Anonyme';
$string['anonymousfirstnamephonetic'] = 'Anonyme';
$string['anonymouslastname'] = 'Utilisateur';
$string['anonymouslastnamephonetic'] = 'Utilisateur';
$string['anonymousrecentactivity'] = 'Il peut y avoir eu une activé récente dans ce forum mais les détails ne peuvent pas être affichés car celui-ci est anonyme.';
$string['anonymouswarning'] = 'En déplaçant ce sujet de discussion vous pourriez révéler des informations sur les contributeurs anonymes. Voulez-vous vraiment continuer ?';
$string['anyfile'] = 'Tous les fichiers';
$string['areapost'] = 'Messages';
$string['articledateformat'] = 'Le %d/%m/%Y à %H:%i:%s';
$string['attachment'] = 'Pièce jointe';
$string['attachment_help'] = 'Vous pouvez ajouter une ou plusieurs pièces jointes à ce message. Si vous attachez une image, celle-ci sera affichée à la fin du message.';
$string['attachmentnopost'] = 'Vous ne pouvez pas exporter de pièces jointes sans l’identifiant (ID) du message';
$string['attachments'] = 'Pièces jointes';
$string['attachments:x'] = 'Pièces jointes : {$a}';
$string['author'] = 'Auteur';
$string['blockafter'] = 'Seuil de blocage des messages';
$string['blockafter_help'] = 'Ce réglage spécifie le nombre maximum de message qu’un utilisateur peut écrire durant une période donnée. Les utilisateurs avec la capacité mod/hsuforum:postwithoutthrottling ne sont pas impactés par cette limitation.';
$string['blockperiod'] = 'Période de blocage';
$string['blockperiod_help'] = 'Les étudiants peuvent être bloqués après avoir posté un nombre spécifique de message dans une période donnée. Les utilisateurs avec la capacité mod/hsuforum:postwithoutthrottling ne sont pas impactés par cette limitation.';
$string['blockperioddisabled'] = 'Ne pas bloquer';
$string['blogforum'] = 'Les forums standards sont affichés au format blog';
$string['bynameondate'] = 'par {$a->name} - {$a->date}';
$string['byx'] = 'par {$a}';
$string['cannnotdeletesinglediscussion'] = 'Désolé, vous n’êtes pas autorisé(e) à supprimer cette discussion !';
$string['cannotadd'] = 'Impossible d’ajouter la discussion dans ce forum';
$string['cannotadddiscussion'] = 'Vous devez être membre du groupe pour ajouter des discussions à ce forum.';
$string['cannotadddiscussionall'] = 'Vous n’avez pas la permission d’ajouter un nouveau sujet de discussion pour tous les participants.';
$string['cannotaddsubscriber'] = 'Impossible d’ajouter l’abonné avec l’identifiant {$a} dans ce forum !';
$string['cannotaddteacherforumto'] = 'Impossible d’ajouter l’instance convertie du forum des enseignants dans la section 0 du cours';
$string['cannotcreatediscussion'] = 'Impossible de créer une nouvelle discussion';
$string['cannotcreateinstanceforteacher'] = 'Impossible de créer une nouvelle instance de module de cours pour les forum des enseignants';
$string['cannotdeletepost'] = 'Vous ne pouvez pas supprimer ce message !';
$string['cannoteditposts'] = 'Vous ne pouvez pas modifier les messages des autres !';
$string['cannotfinddiscussion'] = 'Impossible de trouver cette discussion dans le forum';
$string['cannotfindfirstpost'] = 'Impossible de trouver le premier message de ce forum';
$string['cannotfindorcreateforum'] = 'Impossible de trouver ou de créer un forum des nouvelles principal pour le site';
$string['cannotfindparentpost'] = 'Impossible de trouver le parent du message {$a}';
$string['cannotmakeprivatereplies'] = 'Désolé, vous n’êtes pas autorisé(e) à écrire des réponses privées dans ce forum';
$string['cannotmovefromsingleforum'] = 'Impossible de déplacer la discussion depuis un forum au format "une seule discussion"';
$string['cannotmovenotvisible'] = 'Le forum est invisible';
$string['cannotmovetonotexist'] = 'Vous ne pouvez pas vous déplacer vers ce forum. Il n’existe pas !';
$string['cannotmovetonotfound'] = 'Le forum cible n’a pas été trouvé dans ce cours.';
$string['cannotmovetosingleforum'] = 'Impossible de déplacer la discussion vers un forum au format "une seule discussion"';
$string['cannotpurgecachedrss'] = 'Impossible de purger le flux RSS depuis le forum source ou de destination. Vérifiez votre fichier permissionsforums';
$string['cannotremovesubscriber'] = 'Impossible de supprimer l’abonné avec l’identifiant {$a} de ce forum !';
$string['cannotreply'] = 'Vous ne pouvez pas répondre à ce message';
$string['cannotsplit'] = 'Les discussions de ce forum ne peuvent pas être séparées';
$string['cannotsubscribe'] = 'Désolé, vous devez être membre du groupe pour vous abonner.';
$string['cannottrack'] = 'Impossible d’arrêter de suivre ce forum';
$string['cannotunsubscribe'] = 'Impossible de se désabonner de ce forum';
$string['cannotupdatepost'] = 'Vous ne pouvez pas modifier ce message';
$string['cannotviewpostyet'] = 'Vous ne pouvez pas encore lire les questions des autres étudiants dans cette discussion car vous n’avez pas encore écrit de message';
$string['cannotviewusersposts'] = 'Il n’y a aucun message de cet utilisateur que vous êtes capable de voir.';
$string['cansubscribediscerror'] = 'Vous n’êtes pas autorisé(e) à vous abonner à cette discussion.';
$string['cleanreadtime'] = 'Marquer les anciens messages comme lus';
$string['clicktocollapse'] = 'Cliquez ici pour cacher ce message et toutes ses réponses';
$string['clicktoexpand'] = 'Cliquez ici pour afficher le message et toutes ses réponses';
$string['collapseall'] = 'Tout réduire';
$string['completiondiscussions'] = 'L’étudiant doit créer des discussions :';
$string['completiondiscussionsgroup'] = 'Nécessite des discussions';
$string['completiondiscussionshelp'] = 'Des discussions sont requises pour continuer';
$string['completionposts'] = 'L’étudiant doit créer des discussions ou écrire des réponses :';
$string['completionpostsgroup'] = 'Nécessite des messages';
$string['completionpostshelp'] = 'Des discussions ou des réponses sont requises pour continuer';
$string['completionreplies'] = 'L’étudiant doit écrire une réponse :';
$string['completionrepliesgroup'] = 'Réponses requises';
$string['completionreplieshelp'] = 'Des réponses sont requises pour continuer';
$string['completionusegradeerror'] = 'Impossible d’exiger la gradation car ce forum ne le permet pas. Vous pouvez soit supprimer cette condition, soit activer la gradation pour ce forum.';
$string['configcleanreadtime'] = 'L’heure du jour pour nettoyer les vieux messages depuis la table \'read\'.';
$string['configdigestmailtime'] = 'Les personnes qui ont choisi de recevoir les courriels au format réduit recevront un résumé quotidiennement. Ce paramètre contrôle à quelle période de la journée ce message sera transmis (au moment de l’exécution du cron ayant lieu juste après la période définie).';
$string['configenablerssfeeds'] = 'Ce réglage activera les flux RSS sur tous les forums. Vous devez toutefois activer manuellement les flux RSS sur chacun des forums depuis leurs paramètres.';
$string['configenabletimedposts'] = 'Mettre sur "oui" si vous voulez autoriser le réglage de la visibilité des périodes lorsqu’une nouvelle discussion est créée (fonctionnalité expérimentale)';
$string['confighiderecentposts'] = 'Mettre sur oui pour désactiver l’affichage des messages non lus sur la page du cours.';
$string['configlongpost'] = 'Tous les messages supérieurs à cette taille (en termes de caractères, or HTML) sont considérés comme long. Les messages affichés sur la page d’accueil du site, les cours au format social ou les profils utilisateurs sont réduits de manières naturelle quelque part entre les valeurs hsuforum_shortpost et hsuforum_longpost.';
$string['configmanydiscussions'] = 'Nombre maximum de discussions affichées par page dans un forum.';
$string['configmaxattachments'] = 'Nombre par défaut de pièces jointes autorisées par message.';
$string['configmaxbytes'] = 'Taille maximum par défaut pour les pièces jointes de tous les forums du site (n’écrase pas les réglages locaux ni les limitations de cours)';
$string['configoldpostdays'] = 'Nombre de jours après lesquels les messages sont considérés comme lus.';
$string['configreplytouser'] = 'Lorsqu’un message est envoyé par courriel, est-ce qu’il doit contenir le courriel de l’utilisateur de telle sorte que le destinataire puisse y répondre directement plutôt que via le forum ? Dans tous les cas les utilisateurs peuvent cacher leur adresse en le spécifiant dans leur profil.';
$string['configshortpost'] = 'Tous les messages inférieurs à cette taille (en termes de caractères, or HTML) sont considérés comme court (voir ci-dessous).';
$string['configusermarksread'] = 'Si "oui", l’utilisateur devra marquer ses messages comme lus manuellement. Si "non", il sera marqué comme lu dès qu’il aura été vu.';
$string['confirmsubscribe'] = 'Voulez-vous vraiment vous abonner au forum « {$a} » ?';
$string['confirmunsubscribe'] = 'Voulez-vous vraiment vous désabonner du forum « {$a} » ?';
$string['couldnotadd'] = 'Impossible d’ajouter votre message à cause d’une erreur inconnue';
$string['couldnotdeletereplies'] = 'Désolé, ce message ne peut pas être supprimé car quelqu’un y a déjà répondu';
$string['couldnotupdate'] = 'Impossible de mettre à jour votre message à cause d’une erreur inconnue';
$string['createdbynameondate'] = 'Créé par {$a->name} le {$a->date}';
$string['crontask'] = 'Mailings avancés du forum et travaux de maintenance';
$string['csv'] = 'CSV';
$string['date'] = 'Date';
$string['default'] = 'Défaut';
$string['delete'] = 'Supprimer';
$string['deleteattachments'] = 'Supprimer les pièces jointes';
$string['deleteattachmentx'] = 'Supprimer {$a}';
$string['deleteddiscussion'] = 'Le sujet de discussion a été supprimé';
$string['deletedpost'] = 'Le message a été supprimé';
$string['deletedposts'] = 'Le message a été supprimé';
$string['deletesure'] = 'Voulez-vous vraiment supprimer ce message ?';
$string['deletesureplural'] = 'Voulez-vous vraiment supprimer ce message et toutes ses réponses ? ({$a} messages)';
$string['digestmailheader'] = 'Ceci est votre résumé journalier des nouveaux messages en provenance des forums du site {$a->sitename}. Pour changer vos préférences par défaut concernant ces messages, rendez-vous ici : {$a->userprefs}.';
$string['digestmailpost'] = 'Changez vos préférences de résumé des forums';
$string['digestmailprefs'] = 'Votre profil utilisateur';
$string['digestmailsubject'] = '{$a} : résumé du forum';
$string['digestmailtime'] = 'Heure à laquelle envoyer les résumés par courriel';
$string['digestsentusers'] = 'Les résumés par courriel ont correctement été envoyés à {$a} utilisateurs.';
$string['disallowsubscribe'] = 'Abonnement non autorisé';
$string['disallowsubscribeteacher'] = 'Abonnement non autorisé (sauf pour les enseignants)';
$string['discussion'] = 'Discussion';
$string['discussion:x'] = 'Discussion : {$a}';
$string['discussiondisplay'] = 'Affichage de la discussion';
$string['discussionmoved'] = 'Cette discussion a été déplacée vers "{$a}".« {$a} »';
$string['discussionmovedpost'] = 'Cette discussion a été déplacée <a href="{$a->discusshref}">ici</a> dans le forum<a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Nom de la discussion';
$string['discussions'] = 'Discussions';
$string['discussionsortkey:created'] = 'Date de création';
$string['discussionsortkey:lastreply'] = 'Récent';
$string['discussionsortkey:replies'] = 'Le plus actif';
$string['discussionsortkey:subscribe'] = 'Abonné';
$string['discussionsstartedby'] = 'Discussion lancée par {$a}';
$string['discussionsstartedbyrecent'] = 'Discussions récemment lancées par {$a}';
$string['discussionsstartedbyuserincourse'] = 'Discussions lancées par {$a->fullname} dans {$a->coursename}';
$string['discussionsubscribers'] = 'Abonnés de la discussion';
$string['discussionsummary'] = 'Un tableau de toutes les discussions du forum pour {$a}. Les nom et prénom d’en-tête sont une concaténation du prénom, du nom et de l’avatar de l’utilisateur.';
$string['discussthistopic'] = 'Discuter sur ce sujet';
$string['displaydiscussionreplies'] = 'Afficher les réponses de la discussion';
$string['displayend'] = 'Afficher la fin';
$string['displayend_help'] = 'Ce paramètre permet de masquer un message après une certaine date. Notez que les administrateurs verront dans tous les cas tous les messages.';
$string['displayperiod'] = 'Période d’affichage';
$string['displaystart'] = 'Début de l’affichage';
$string['displaystart_help'] = 'Ce paramètre permet d’afficher un message après une certaine date. Notez que les administrateurs verront dans tous les cas tous les messages.';
$string['displaywordcount'] = 'Afficher le nombre de mots';
$string['displaywordcount_help'] = 'Ce paramètre permet de définir si le nombre de mots est affiché pour chacun des messages ou non.';
$string['eachuserforum'] = 'Chaque personne ouvre une discussion';
$string['edit'] = 'Editer';
$string['editedby'] = 'Edité par {$a->name} - initialement écrit le {$a->date}';
$string['editedpostupdated'] = 'Les messages de {$a} ont été mis à jour';
$string['editing'] = 'Édition';
$string['editingpost'] = 'Édition du message';
$string['emaildigest_0'] = 'Vous recevrez un email pour chaque message envoyé sur le forum.';
$string['emaildigest_1'] = 'Vous recevrez un résumé par email chaque jour contenant tous les messages du forum.';
$string['emaildigest_2'] = 'Vous recevrez un résumé par email chaque jour contenant uniquement les sujets des messages du forum.';
$string['emaildigestcompleteshort'] = 'Messages complets';
$string['emaildigestdefault'] = 'Par défaut ({$a})';
$string['emaildigestoffshort'] = 'Pas de résumé';
$string['emaildigestsubjectsshort'] = 'Sujets seulement';
$string['emaildigesttype'] = 'Paramètres des résumés par courriel';
$string['emaildigesttype_help'] = 'Le type de notification que vous recevrez pour chaque forum.

* Par défaut  : suit le paramètre que vous avez définit dans votre profil utilisateur. Si vous mettez à jour votre profil le changement sera opéré ici aussi ;
* Pas de résumé : vous recevrez un courriel par message ;
* Résumé - messages complets : vous recevrez un courriel résumé par jour contenant tous les messages ;
* Résumé - sujets seulement : vous recevrez un courriel résumé par jour contenant uniquement les sujets des messages.';
$string['emaildigestupdated'] = 'Les paramètres du résumé par email ont été changés par "{$a->maildigesttitle}" pour le forum "{$a->forum}". {$a->maildigestdescription}';
$string['emaildigestupdated_default'] = 'Le paramètre par défaut de votre profil pour "{$a->maildigesttitle}" a été utilisé pour le forum "{$a->forum}". {$a->maildigestdescription}.';
$string['emptymessage'] = 'Quelque chose ne va pas avec votre message. Peut-être avez laissé';
$string['erroremptymessage'] = 'Le message ne peut pas être vide';
$string['erroremptysubject'] = 'Le sujet ne peut pas être vide.';
$string['errorenrolmentrequired'] = 'Vous devez être inscrit à ce cours pour pouvoir accéder à ce contenu';
$string['errorwhiledelete'] = 'Une erreur est survenue durant la suppression de l’enregistrement.';
$string['eventassessableuploaded'] = 'Du contenu a été envoyé.';
$string['eventcoursesearched'] = 'Cours recherchés';
$string['eventdiscussioncreated'] = 'Discussion créée';
$string['eventdiscussiondeleted'] = 'Discussion supprimée';
$string['eventdiscussionmoved'] = 'Discussion déplacée';
$string['eventdiscussionupdated'] = 'Discussion mise à jour';
$string['eventdiscussionviewed'] = 'Discussion vue';
$string['eventpostcreated'] = 'Message créé';
$string['eventpostdeleted'] = 'Message supprimé';
$string['eventpostupdated'] = 'Message mis à jour';
$string['eventreadtrackingdisabled'] = 'Affichage des messages non lus désactivé';
$string['eventreadtrackingenabled'] = 'Affichage des messages non lus activé';
$string['eventsubscribersviewed'] = 'Abonnés vus';
$string['eventsubscriptioncreated'] = 'Abonnement créé';
$string['eventsubscriptiondeleted'] = 'Abonnement supprimé';
$string['eventuserreportviewed'] = 'Rapport d’utilisateur vu';
$string['everyonecanchoose'] = 'Tout le monde peut choisir de s’abonner';
$string['everyonecannowchoose'] = 'Tout le monde peut maintenant choisir de s’abonner';
$string['everyoneisnowsubscribed'] = 'Tout le monde est désormais abonné au forum';
$string['everyoneissubscribed'] = 'Tout le monde est abonné au forum';
$string['existingsubscribers'] = 'Abonnés existant';
$string['expandall'] = 'Tout agrandir';
$string['export'] = 'Exporter';
$string['exportattachments'] = 'Exporter les pièces jointes';
$string['exportdiscussion'] = 'Exporter toute la discussion';
$string['exportformat'] = 'Format d’exportation';
$string['forcessubscribe'] = 'L’abonnement à ce forum est imposé';
$string['forum'] = 'Forum';
$string['forumauthorhidden'] = 'Auteur (caché)';
$string['forumblockingalmosttoomanyposts'] = 'Vous approchez du seuil maximal de message. Vous avez écrit {$a->numposts} fois depuis {$a->blockperiod} et la limite est fixée à {$a->blockafter} messages.';
$string['forumbodyhidden'] = 'Vous ne pouvez pas voir ce message. Probablement parce que vous n’avez pas encore écrit dans cette discussion, le délai d’édition n’est pas encore écoulé, la discussion n’a pas démarré ou la discussion a expiré.';
$string['forumintro'] = 'Description';
$string['forumname'] = 'Nom du forum';
$string['forumposts'] = 'Messages du forum';
$string['forums'] = 'Forums';
$string['forumsubjecthidden'] = 'Sujet (caché)';
$string['forumtracked'] = 'Les messages non lus sont affichés';
$string['forumtrackednot'] = 'Les messages non lus ne sont pas affichés';
$string['forumtype'] = 'Type de forum';
$string['forumtype_help'] = 'Il y a 5 types de forum :

* Simple discussion : un sujet de discussion simple dans lequel chacun peut répondre (ne peut pas être utilisé avec les groupes séparés) ;
* Chaque personne lance une discussion : chaque étudiant peut lancer un seul et unique sujet de discussion dans lequel tout le monde peut répondre ;
* Forum des questions et réponses : l’étudiant doit d’abord écrire un message avant de pouvoir voir les messages des autres étudiants ;
* Forum standard affiché au format blog : un forum ouvert dans lequel chacun peut démarrer un nouveau sujet de discussion lorsqu’il le souhaite. Ces sujets sont affichés sur une seule page avec des liens "discuter de ce sujet" ;
* Forum standard pour une utilisation générale : un forum ouvert où chacun peut démarrer une nouvelle discussion lorsqu’il le souhaite.';
$string['general'] = 'Général';
$string['generalforum'] = 'Forum standard pour une utilisation générale';
$string['generalforums'] = 'Forums généraux';
$string['grade'] = 'Évaluation';
$string['gradetype'] = 'Type d’évaluation';
$string['gradetype_help'] = 'Le type d’évaluation est utilisé pour déterminer la méthode de notation.

* Aucun : le forum ne permet pas les évaluations ;
* Manuel : le forum doit être évalué manuellement par l’enseignant via le carnet de notes ;
* Critères d’évaluation : utilise des critères pour générer une évaluation.';
$string['gradetypemanual'] = 'Manuel';
$string['gradetypenone'] = 'Aucun';
$string['gradetyperating'] = 'Évaluation';
$string['hiddenforumpost'] = 'Messages cachés du forum';
$string['hiderecentposts'] = 'Cacher les messages récents';
$string['hsuforum:addinstance'] = 'Ajouter un nouveau forum';
$string['hsuforum:addnews'] = 'Ajouter une nouvelle';
$string['hsuforum:addquestion'] = 'Ajouter une question';
$string['hsuforum:allowforcesubscribe'] = 'Autoriser l’abonnement imposé';
$string['hsuforum:allowprivate'] = 'Autoriser les utilisateurs à répondre en privé';
$string['hsuforum:createattachment'] = 'Créer des pièces jointes';
$string['hsuforum:deleteanypost'] = 'Supprimer tous les messages (en tout temps)';
$string['hsuforum:deleteownpost'] = 'Supprimer mes messages (dans un intervalle)';
$string['hsuforum:editanypost'] = 'Editer tous les messages';
$string['hsuforum:exportdiscussion'] = 'Exporter toute la discussion';
$string['hsuforum:exportownpost'] = 'Exporter mon message';
$string['hsuforum:exportpost'] = 'Exporter le message';
$string['hsuforum:managesubscriptions'] = 'Gérer les abonnements';
$string['hsuforum:movediscussions'] = 'Déplacer les discussions';
$string['hsuforum:postwithoutthrottling'] = 'Exempté du seuil maximal de message';
$string['hsuforum:rate'] = 'Evaluer le message';
$string['hsuforum:replynews'] = 'Répondre à la nouvelle';
$string['hsuforum:replypost'] = 'Répondre au message';
$string['hsuforum:revealpost'] = 'Révéler son identité dans un forum anonyme';
$string['hsuforum:splitdiscussions'] = 'Séparer les discussions';
$string['hsuforum:startdiscussion'] = 'Démarrer de nouvelles discussions';
$string['hsuforum:viewallratings'] = 'Voir toutes les évaluations brutes données par les personnes';
$string['hsuforum:viewanyrating'] = 'Voir toutes les évaluations que les personnes ont reçues';
$string['hsuforum:viewdiscussion'] = 'Voir les messages';
$string['hsuforum:viewflags'] = 'Voir les étiquettes des messages';
$string['hsuforum:viewhiddentimedposts'] = 'Voir les messages cachés après un laps de temps';
$string['hsuforum:viewposters'] = 'Voir les participants du forum';
$string['hsuforum:viewqandawithoutposting'] = 'Toujours voir les messages de type question / réponse';
$string['hsuforum:viewrating'] = 'Voir la totalité des évaluations que vous avez reçues';
$string['hsuforum:viewsubscribers'] = 'Voir les abonnés';
$string['id'] = 'id';
$string['inforum'] = 'dans {$a}';
$string['inprivatereplyto'] = 'en réponse en privé à';
$string['inreplyto'] = 'en réponse à';
$string['introblog'] = 'Les messages de ce forum ont été automatiquement copiés depuis les blogs des utilisateurs de ce cours car les entrées de ces blogs ne sont plus disponibles';
$string['intronews'] = 'Annonces et nouvelles générales';
$string['introsocial'] = 'Un forum ouvert pour discuter à propos de tout et n’importe quoi';
$string['introteacher'] = 'Un forum de discussion et de notation uniquement ouvert aux enseignants';
$string['invalidaccess'] = 'L’accès à cette page n’a pas été fait correctement';
$string['invaliddigestsetting'] = 'Un paramètre non valide a été donné pour le résumé par courriel';
$string['invaliddiscussionid'] = 'L’identifiant de la discussion était incorrect ou n’existait plus';
$string['invalidforcesubscribe'] = 'Mode d’abonnement imposé non valide';
$string['invalidforumid'] = 'L’identifiant du forum était incorrect';
$string['invalidparentpostid'] = 'L’identifiant du message parent était incorrect';
$string['invalidpostid'] = 'Identifiant de message non valide - {$a}';
$string['javascriptdisableddisplayformat'] = 'Javascript a été désactivé dans votre navigateur. Merci de l’activer et de recharger la page ou de sélectionner un affichage des discussions différent.';
$string['jsondecodeerror'] = 'Le décodage de la réponse a échoué. Veuillez réessayer.';
$string['lastpostbyx'] = 'Dernier message par {$a->name} le {$a->time}';
$string['lastposttimeago'] = 'Dernier {$a}';
$string['learningforums'] = 'Forums d’apprentissage';
$string['loadmorediscussions'] = 'Charger plus de discussions';
$string['longpost'] = 'Long message';
$string['mailnow'] = 'Envoyer un courriel maintenant';
$string['manageforumsubscriptions'] = 'Gérer les abonnements au forum';
$string['manualwarning'] = 'L’évaluation n’est pas encore supportée. L’évaluation est uniquement disponible depuis le carnet de notes du cours.';
$string['manydiscussions'] = 'Discussions par page';
$string['markalldread'] = 'Marquer tous les messages de cette discussion comme lus.';
$string['markallread'] = 'Marquer tous les messages du forum comme lus.';
$string['markread'] = 'Marqué comme lu';
$string['markreadbutton'] = 'Marqué<br />comme<br />lu';
$string['markunread'] = 'Marque comme non lu';
$string['markunreadbutton'] = 'Marquer<br />comme<br />non lu';
$string['maxattachments'] = 'Nombre maximum de pièces jointes';
$string['maxattachments_help'] = 'Ce paramètre spécifie le nombre maximum de pièces jointes qui peuvent être attachées à un message.';
$string['maxattachmentsize'] = 'Taille maximum des pièces jointes';
$string['maxattachmentsize_help'] = 'Ce paramètre spécifie le taille maximum des pièces jointes qui peuvent être attachées à un message.';
$string['maxtimehaspassed'] = 'Désolé mais le délai imparti pour l’édition de ce message ({$a}) est dépassé !';
$string['message'] = 'Message';
$string['messageisrequired'] = 'Le message est requis';
$string['messageplaceholder'] = 'Tapez votre message';
$string['messageprovider:digests'] = 'Abonné aux résumés avancés du forum';
$string['messageprovider:posts'] = 'Abonné aux messages avancés du forum';
$string['missingsearchterms'] = 'Le terme de recherche suivant n’apparaît que dans le code HTML de ce message :';
$string['modeflatfirstname'] = 'Afficher les réponses en ligne, en fonction du prénom de l’utilisateur';
$string['modeflatlastname'] = 'Afficher les réponses en ligne, en fonction du nom de l’utilisateur';
$string['modeflatnewestfirst'] = 'Afficher les réponses en ligne, les plus récentes en premier';
$string['modeflatoldestfirst'] = 'Afficher les réponses en ligne, les plus anciennes en premier';
$string['modenested'] = 'Afficher les réponses de façon condensée';
$string['modethreaded'] = 'Afficher les réponses sous la forme d’un fil de discussion';
$string['modulename'] = 'Forum avancé';
$string['modulename_link'] = 'mod/hsuforum/view';
$string['modulenameplural'] = 'Forums avancés';
$string['more'] = 'plus';
$string['movedmarker'] = '(Déplacé)';
$string['movethisdiscussionto'] = 'Déplacer cette discussion vers…';
$string['mustprovidediscussionorpost'] = 'Vous devez au moins indiquer un identifiant de discussion ou de message pour exporter';
$string['namenews'] = 'Forum des nouvelles';
$string['namenews_help'] = 'Le forum des nouvelles est un forum d’annonces spécial qui est automatiquement créé avec le cours. Un cours ne peut avoir qu’un seul forum des nouvelles. Seuls les enseignants et administrateurs peuvent écrire des nouvelles';
$string['namesocial'] = 'Forum social';
$string['nested'] = 'Imbriqué';
$string['newforumposts'] = 'Messages récents';
$string['nextdiscussion'] = 'Nouvelle discussion';
$string['nextdiscussionx'] = '({$a}) Suivante >';
$string['noattachments'] = 'Il n’y a pas de pièce jointe pour ce message';
$string['nodiscussionsstartedby'] = '{$a} n’a lancé aucune discussion';
$string['nodiscussionsstartedbyyou'] = 'Vous n’avez lancée aucune discussion pour l’instant';
$string['noguestpost'] = 'Désolé, les visiteurs anonymes ne sont pas autorisés à écrire des messages.';
$string['noguesttracking'] = 'Désolé, les visiteurs anonymes ne sont pas autorisés à définir les paramètres de suivi.';
$string['nomorepostscontaining'] = 'Aucun autre message contenant le(s) terme(s) « {$a} » n’a été trouvé';
$string['nonanonymous'] = 'Non anonymement';
$string['noonecansubscribenow'] = 'Les abonnements ne sont désormais plus autorisés';
$string['nopermissiontosubscribe'] = 'Vous n’avez pas la permission de voir la liste des abonnés au forum';
$string['nopermissiontoview'] = 'Vous n’avez pas la permission de voir ce message';
$string['nopostforum'] = 'Désolé, vous n’êtes pas autorisé à écrire un message dans ce forum';
$string['noposts'] = 'Aucun message';
$string['nopostsmadebyuser'] = '{$a} n’a écrit aucun message';
$string['nopostsmadebyyou'] = 'Vous n’avez écrit';
$string['nosubscribers'] = 'Il n’y a aucun abonné à ce forum pour l’instant';
$string['notexists'] = 'La discussion n’existe plus';
$string['nothingnew'] = 'Rien de nouveau pour {$a}';
$string['notingroup'] = 'Désolé, mais vous devez faire parti du groupe pour voir ce forum.';
$string['notinstalled'] = 'Le module forum n’est pas installé';
$string['notpartofdiscussion'] = 'Ce message ne fait parti d’aucune discussion !';
$string['notrackforum'] = 'Ne pas suivre les messages non lus';
$string['notuploadedfile'] = 'Il y a eu un problème durant le chargement de votre fichier. Veuillez réessayer';
$string['noviewdiscussionspermission'] = 'Vous n’avez pas la permission de voir les discussions de ce forum';
$string['nowallsubscribed'] = 'Tous les forums dans {$a} sont abonnés.';
$string['nowallunsubscribed'] = 'Tous les forums dans {$a} ne sont pas abonnés.';
$string['nownotsubscribed'] = '{$a->name} ne sera PAS notifié des nouveaux messages dans « {$a->forum} »';
$string['nownottracking'] = '{$a->name} ne suit plus « {$a->forum} ».';
$string['nowsubscribed'] = '{$a->name} sera notifié des nouveaux messages dans « {$a->forum} »';
$string['nowtracking'] = '{$a->name} suit désormais « {$a->forum} ».';
$string['numposts'] = '{$a} messages';
$string['olderdiscussions'] = 'Anciennes discussions';
$string['oldertopics'] = 'Anciens sujets';
$string['oldpostdays'] = 'Lire après quelques jours';
$string['onereply'] = '1 réponse';
$string['openmode0'] = 'Aucune discussion, aucune réponse';
$string['openmode1'] = 'Aucune discussion mais les réponses sont acceptées';
$string['openmode2'] = 'Les discussions et réponses sont acceptées';
$string['options'] = 'Options';
$string['orderdiscussionsby'] = 'Trier par';
$string['overviewnumpostssince'] = '{$a} messages depuis votre dernière connexion';
$string['overviewnumunread'] = '{$a} non lu(s)';
$string['page-mod-hsuforum-discuss'] = 'Fil de discussion de la page du module forum';
$string['page-mod-hsuforum-view'] = 'Page principale du module forum';
$string['page-mod-hsuforum-x'] = 'Toutes les pages du module forum';
$string['parent'] = 'Montrer le parent';
$string['parentofthispost'] = 'Parent de ce message';
$string['participants'] = 'Participants';
$string['plaintext'] = 'Texte plein';
$string['pluginadministration'] = 'Administration du forum';
$string['pluginname'] = 'Forum avancé';
$string['postadded'] = '<p>Votre message a été ajouté avec succès.</p><p>Vous avez {$a} pour le modifier.</p>';
$string['postaddedsuccess'] = 'Votre message a correctement été ajouté.';
$string['postaddedtimeleft'] = 'Vous avez {$a} pour le modifier.';
$string['postbyuser'] = '{$a->post} par {$a->user}';
$string['postbyx'] = 'Message par {$a}';
$string['postbyxinprivatereplytox'] = 'àRéponse privée à {$a->parent} de {$a->author}';
$string['postbyxinreplytox'] = 'Répondre à {$a->parent} de {$a->author} {$a->parentpost}';
$string['postcreated'] = 'Message créé';
$string['postdeleted'] = 'Message supprimé';
$string['postincontext'] = 'Voir ce message dans son contexte';
$string['postmailnow'] = '<p>Ce message sera envoyé automatiquement par courriel à tous les abonnés du forum</p>';
$string['postmailsubject'] = '{$a->courseshortname} : {$a->subject}';
$string['postoptions'] = 'Paramètres du message';
$string['postrating1'] = 'Connaissances les plus séparées';
$string['postrating2'] = 'Séparée et connectée';
$string['postrating3'] = 'Connaissances les plus connectées';
$string['posts'] = 'Messages';
$string['postsfor'] = 'Messages pour';
$string['postsmadebyuser'] = 'Messages écrits par {$a}';
$string['postsmadebyuserincourse'] = 'Messages écrits par {$a->fullname} dans {$a->coursename}';
$string['posttoforum'] = 'Ecrire dans le forum';
$string['postupdated'] = 'Votre message a été mis à jour';
$string['postwasupdated'] = 'Le message a été mis à jour';
$string['potentialsubscribers'] = 'Abonnés potentiels';
$string['prevdiscussionx'] = '< Précédent ({$a})';
$string['previousdiscussion'] = 'Ancienne discussion';
$string['print'] = 'Imprimer';
$string['privatereplies'] = 'Autoriser les réponses privées';
$string['privatereplies_help'] = 'Avec cette fonctionnalité, les enseignants peuvent répondre en privé aux messages d’un forum. Cette réponse n’est visible que par l’étudiant qui a écrit le message original ou sa réponse. Elle est donc invisible pour tous les autres étudiants.';
$string['privaterepliesdisabledglobally'] = 'Les réponses privées ont été désactivées de manière globale.';
$string['privatereply'] = 'Réponse privée';
$string['privatereply_help'] = 'Si coché ce message ne sera visible que pour l’utilisateur à qui vous répondez. Aussi, plus personne ne pourra répondre à ce message.';
$string['privatereplybyx'] = 'Réponse privée par {$a}';
$string['processingdigest'] = 'Traitement du résumé par courriel pour l’utilisateur {$a}';
$string['processingpost'] = 'Traitement du message {$a}';
$string['prune'] = 'Séparer';
$string['prunedpost'] = 'Une nouvelle discussion a été créée à partir de ce message';
$string['pruneheading'] = 'Séparer la discussion et déplacer ce message dans la nouvelle discussion';
$string['qandaforum'] = 'Forum des questions et réponses';
$string['qandanotify'] = 'C’est un forum des questions et réponses.Vous devez d’abord écrire une réponse avant de pouvoir voir celles des autres';
$string['re'] = 'Re :';
$string['readtherest'] = 'Lire le reste de ce sujet de discussion';
$string['replies'] = 'Réponses';
$string['repliesmany'] = '{$a} réponses à ce jour';
$string['repliesone'] = '{$a} réponse à ce jour';
$string['repliesx'] = 'Réponses : {$a}';
$string['reply'] = 'Réponse';
$string['replybuttontitle'] = 'Répondre à {$a}';
$string['replybyx'] = 'Réponse par {$a}';
$string['replyforum'] = 'Répondre dans le forum';
$string['replytouser'] = 'Utiliser l’adresse de courriel pour répondre';
$string['replytox'] = 'Répondre à {$a}';
$string['resetdigests'] = 'Supprimer toutes les préférences utilisateur concernant les résumés de forum';
$string['resetforums'] = 'Supprimer les messages de';
$string['resetforumsall'] = 'Supprimer tous les messages';
$string['resetsubscriptions'] = 'Supprimer tous les abonnements au forum';
$string['resettrackprefs'] = 'Supprimer tous les réglages de suivi du forum';
$string['reveal'] = 'Révéler son identité dans ce message';
$string['reveal_help'] = 'Si coché, vous perdrez votre anonymat et votre nom sera affiché dans le message.';
$string['rssarticles'] = 'Nombre d’articles RSS récents';
$string['rssarticles_help'] = 'Ce paramètre spécifie le nombre d’articles (discussions ou messages) à inclure dans le flux RSS. 5 à 20 paraissent raisonnable.';
$string['rsssubscriberssdiscussions'] = 'Flux RSS des discussions';
$string['rsssubscriberssposts'] = 'Flux RSS des messages';
$string['rsstype'] = 'Flux RSS pour cette activité';
$string['rsstype_help'] = 'Pour activer le flux RSS dans cette activité, sélectionnez les discussions ou messages à inclure au flux.';
$string['search'] = 'Rechercher';
$string['searchdatefrom'] = 'Les messages doivent être plus récents que ça';
$string['searchdateto'] = 'Les messages doivent être plus anciens que ça';
$string['searchforumintro'] = 'Merci d’indiquer des termes de recherche dans un ou plusieurs des champs suivants :';
$string['searchforums'] = 'Rechercher';
$string['searchfullwords'] = 'Ces mots devraient apparaître comme tous les mots';
$string['searchnotwords'] = 'Ces mots ne devraient PAS être inclus';
$string['searcholderposts'] = 'Rechercher des messages plus anciens…';
$string['searchphrase'] = 'Cette phrase exact doit apparaître dans le message';
$string['searchresults'] = 'Résultats de la recherche';
$string['searchsubject'] = 'Ces mots devraient être dans le sujet';
$string['searchuser'] = 'Ce nom devrait correspondre à l’auteur';
$string['searchuserid'] = 'L’identifiant Moodle de l’auteur';
$string['searchwhichforums'] = 'Choisissez dans quels forums chercher';
$string['searchwords'] = 'Ces mots peuvent apparaître n’importe où dans le message';
$string['seeallposts'] = 'Voir tous les messages écrits par cet utilisateur';
$string['shortpost'] = 'Message court';
$string['showbookmark'] = 'Autoriser la mise en favori des messages';
$string['showbookmark_help'] = 'Si activé, les messages du forum pourront être mis en favori.';
$string['showbookmarkdisabledglobally'] = 'Les favoris ont été désactivés de manière globale au niveau du plugin.';
$string['showdiscussionsubscribers'] = 'Afficher ou modifier les abonnés à la discussion';
$string['showrecent'] = 'Afficher les messages récents sur la page du cours';
$string['showrecent_help'] = 'Si activé les messages récents seront affichés sur la page du cours';
$string['showsubscribers'] = 'Afficher ou modifier les abonnés au forum';
$string['showsubstantive'] = 'Autoriser le marquage en tant que substantif';
$string['showsubstantive_help'] = 'Si activé, cette fonctionnalité permettra aux enseignants de marquer les messages en tant que valeur substantive.';
$string['showsubstantivedisabledglobally'] = 'Le marquage en tant que substantif a été désactivé de manière globale au niveau du plugin.';
$string['singleforum'] = 'Une de discussion simple et unique';
$string['smallmessage'] = '{$a->user} a écrit dans {$a->forumname}';
$string['sortdiscussions'] = 'Trier les discussions';
$string['sortdiscussionsby'] = 'Trier';
$string['splitprivatewarning'] = 'Vous êtes en train de séparer une réponse privée. Après la séparation, ce message ne sera plus privé.';
$string['startedby'] = 'Démarré par';
$string['startedbyx'] = 'Démarré par {$a}';
$string['startedbyxgroupx'] = 'Démarré par {$a->name} pour le groupe {$a->group}';
$string['subject'] = 'Objet';
$string['subjectbyprivateuserondate'] = '{$a->subject} (privé) par {$a->author} le {$a->date}';
$string['subjectbyuserondate'] = '{$a->subject} par {$a->author} le {$a->date}';
$string['subjectisrequired'] = 'L’objet est requis';
$string['subjectplaceholder'] = 'Votre objet';
$string['submit'] = 'Envoyer';
$string['subscribe'] = 'S’abonner au forum';
$string['subscribeall'] = 'Abonner tout le monde à ce forum';
$string['subscribed'] = 'Abonné(e)';
$string['subscribedisc'] = 'S’abonner à la discussion';
$string['subscribeenrolledonly'] = 'Désolé, seuls les utilisateurs inscrits sont autorisés à s’abonner aux notifications des messages de ce forum.';
$string['subscribenone'] = 'Désabonner tout le monde de ce forum';
$string['subscribers'] = 'Abonnés';
$string['subscribeshort'] = 'S’abonner';
$string['subscribestart'] = 'M’envoyer une notification lorsqu’il y a de nouveaux messages sur ce forum';
$string['subscribestop'] = 'Je ne veux pas recevoir de notifications lorsqu’il y a de nouveaux messages sur ce forum';
$string['subscription'] = 'Abonnement';
$string['subscription_help'] = 'Si vous vous abonnez à un forum vous recevrez des notifications à chaque nouveau message. Vous pouvez habituellement choisir votre mode d’abonnement sauf si l’abonnement est imposé auquel cas tout le monde recevra les notifications.';
$string['subscriptionauto'] = 'Abonnement automatique';
$string['subscriptiondisabled'] = 'Abonnement désactivé';
$string['subscriptionforced'] = 'Abonnement imposé';
$string['subscriptionmode'] = 'Mode d’abonnement';
$string['subscriptionmode_help'] = 'Lorsqu’un participant s’abonne à un forum, cela signifie qu’il recevra des notifications concernant les nouveaux messages écrits sur le forum. Il y a 4 modes d’abonnement :

 * Abonnement facultatif : les participants choisissent s’ils veulent ou non s’abonner ;
* Abonnement imposé : tout le monde est abonné et personne ne peut se désabonner ;
* Abonnement automatique : tout le monde est abonné mais chacun peut décider de se désabonner ;
* Abonnement désactivé : les abonnements ne sont pas autorisés.

Remarque : le changement du mode d’abonnement n’affectera que les utilisateurs qui ne sont pas déjà inscrit au cours.';
$string['subscriptionoptional'] = 'Abonnement facultatif';
$string['subscriptions'] = 'Abonnements';
$string['substantive'] = 'Substantif';
$string['switchtoaccessible'] = 'Passer en mode accessible';
$string['thisforumisthrottled'] = 'Ce forum possède limite le nombre de message que vous pouvez écrire durant une période donnée - le réglage est actuellement fixé sur {$a->blockafter} message(s) en {$a->blockperiod}';
$string['thisisanonymous'] = 'Ce forum est anonyme.';
$string['timedposts'] = 'Messages temporisés';
$string['timestartenderror'] = 'La date de fin d’affichage ne peut être antérieure à la date de début';
$string['toggle:bookmark'] = 'Marque page';
$string['toggle:subscribe'] = 'S’abonner';
$string['toggle:substantive'] = 'Substantif';
$string['toggled:bookmark'] = 'AJouté(e) au marque page';
$string['toggled:subscribe'] = 'Abonné';
$string['toggled:substantive'] = 'Marqué comme substantive';
$string['totaldiscussions'] = 'Messages : {$a}';
$string['totalposts'] = 'Total des messages';
$string['totalpostsanddiscussions'] = 'Total des messages : {$a}';
$string['totalrating'] = 'Évaluation : {$a}';
$string['totalreplies'] = 'Réponses : {$a}';
$string['totalsubstantive'] = 'Messages substantifs : {$a}';
$string['trackforum'] = 'Suivre les messages non lus';
$string['trackingoptions'] = 'Options de suivi';
$string['tree'] = 'Arbre';
$string['unread'] = 'Nouveau';
$string['unreadposts'] = 'Messages non lus';
$string['unreadpostsnumber'] = '{$a} message(s) non lu(s)';
$string['unreadpostsone'] = '1 message non lu';
$string['unreadx'] = 'Non lu(s) : {$a}';
$string['unsubscribe'] = 'Se désabonner de ce forum';
$string['unsubscribeall'] = 'Se désabonner de tous les forums';
$string['unsubscribeallconfirm'] = 'Vous êtes abonné(e) à {$a} forums. Voulez-vous vraiment vous désabonner de tous les forums et désactiver tous les abonnements automatique par la même occasion ?';
$string['unsubscribealldone'] = 'Tous les abonnements facultatifs ont été supprimés. Vous recevrez toujours les notifications en provenance des forums avec abonnement imposé. Pour gérer les notifications rendez-vous dans la messagerie depuis les paramètres de votre profil utilisateur.';
$string['unsubscribeallempty'] = 'Vous n’êtes abonné(e) à aucun forum. Pour désactiver toutes les notifications du serveur, rendez-vous dans la messagerie depuis les paramètres de votre profil utilisateur.';
$string['unsubscribed'] = 'Désabonné(e)';
$string['unsubscribedisc'] = 'Se désabonner de cette discussion';
$string['unsubscribeshort'] = 'Se désabonner';
$string['useadvancededitor'] = 'Utiliser l’éditeur de texte avancé';
$string['usermarksread'] = 'Marquage manuel des messages lus';
$string['validationerrorsx'] = 'Il y a {$a->count} erreur(s) lors de votre envoi : {$a->errors}';
$string['validationerrorx'] = 'Il y a eu une erreur lors de votre envoi : {$a}';
$string['viewalldiscussions'] = 'Voir toutes les discussions';
$string['viewposters'] = 'Voir les participants';
$string['warnafter'] = 'Seuil d’alerte pour le message';
$string['warnafter_help'] = 'Les étudiants peuvent être alertés lorsqu’ils approchent de la limite maximum de messages autorisés durant une période donnée. Ce paramètre indique après combien de messages ils seront prévenus. Les utilisateurs avec la capacité mod/hsuforum:postwithoutthrottling en sont exempts.';
$string['warnformorepost'] = 'Attention ! Il y a plus d’une discussion dans ce forum - utilisation de la plus récente';
$string['xdiscussions'] = '{$a} discussions';
$string['xreplies'] = '{$a} réponses';
$string['xunread'] = '{$a} nouveau';
$string['yournewquestion'] = 'Votre nouvelle question';
$string['yournewtopic'] = 'Votre nouveau sujet de discussion';
$string['yourreply'] = 'Votre réponse';
