<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_adaptable', language 'af', version '5.0'.
 *
 * @package     theme_adaptable
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutme'] = 'Oor my';
$string['actingasrole'] = 'Jy tree tans as \'n ander rol op';
$string['activatetemplateoverride'] = 'Aktiewe templaatoorheenskryf vir \'{$a}\'';
$string['activatetemplateoverridedesc'] = 'Wanneer gemerk, sal die waarde in die \'{$a->setting}\' verstelling as die \'{$a->template}\' templaat gebruik as dit teks bevat.';
$string['activitiesheading'] = 'Aktiwiteite';
$string['alertaccess'] = 'Waarskuwingsigbaarheid';
$string['alertaccessadmins'] = 'Sigbaar aan administrateurs';
$string['alertaccessdesc'] = 'Stel toegangsbeperkingtipe vir waarskuwingsboks se sigbaarheid. Let wel: as "Voeg doelgemaakte profielveldbeperking by" gebruik word, sal jy waardes vir profielvelde hieronder moet byvoeg.';
$string['alertaccessglobal'] = 'Sigbaar aan almal';
$string['alertaccessprofile'] = 'Voeg doelgemaakte profielveldbeperking by';
$string['alertaccessusers'] = 'Sigbaar aan ingetekende gebruikers';
$string['alertannounce'] = 'Aankondiging';
$string['alertannouncedesc'] = 'Vertoon \'n aankondiging in die waarskuwingsboks.';
$string['alertbackgroundcolorinfo'] = 'Agtergrondkleur van Inligting';
$string['alertbackgroundcolorinfodesc'] = 'Agtergrondkleur van die inligtingtipe waarskuwingsbokse.';
$string['alertbackgroundcolorsuccess'] = 'Agtergrondkleur van aankondiging';
$string['alertbackgroundcolorsuccessdesc'] = 'Agtergrondkleur van die aankondigingtipe waarskuwingsbokse.';
$string['alertbackgroundcolorwarning'] = 'Agtergrondkleur van waarskuwing';
$string['alertbackgroundcolorwarningdesc'] = 'Agtergrondkleur van die Waarskuwingtipe waarskuwingsbokse.';
$string['alertbordercolorinfo'] = 'Rantkleur van Inligting';
$string['alertbordercolorinfodesc'] = 'Rantkleur van die inligtingtipe waarskuwingsbokse';
$string['alertbordercolorsuccess'] = 'Rantkleur van Aankondiging';
$string['alertbordercolorsuccessdesc'] = 'Rantkleur van die aankondigingtipe waarskuwingsbokse.';
$string['alertbordercolorwarning'] = 'Rantkleur van Waarskuwing';
$string['alertbordercolorwarningdesc'] = 'Rantkleur van die Waarskuwingstipe Waarskuwingsbokse.';
$string['alertcolorinfo'] = 'Kleur van Inligting';
$string['alertcolorinfodesc'] = 'Ikoonkleur van die Inligtingtipe waarskuwingsbokse.';
$string['alertcolorsheading'] = 'Doelmaak top waarskuwingsbokse';
$string['alertcolorsuccess'] = 'Kleur van Aankondiging';
$string['alertcolorsuccessdesc'] = 'Ikoonkleur van die aankondigingtipe waarskuwingsbokse.';
$string['alertcolorwarning'] = 'Kleur van Waarskuwing';
$string['alertcolorwarningdesc'] = 'Ikoonkleur van die waarskuwingstipe waarskuwingsbokse.';
$string['alertcount'] = 'Aantal Waarskuwings';
$string['alertcountdesc'] = 'Die aantal waarskuwings om in die wysigingsarea hieronder te vertoon.';
$string['alertdesc'] = 'Voer in en doelmaak \'n teks om in die boonste deel van die werf as waarskuwing te vertoon. Dit is moontlik om meer as een waarskuwing te stel om verskillende tipes gebruikers te teiken. Jy het ook die opsie om waarskuwings regoor die werf of slegs op tuisblaaie te vertoon. <br /><br /><strong>Let wel:</strong> dit is ook nou moontlik om waarskuwings binne kursusblaaie te vertoon om onderwysers te waarsku dat kursusse versteek is.';
$string['alertdisabled'] = 'Versper';
$string['alertdisabledesc'] = 'Versper hierdie waarskuwing.';
$string['alerthiddencourse'] = 'Ontsper kursuswaarskuwings';
$string['alerthiddencoursedesc'] = 'Vertoon waarskuwings op kursusblad.';
$string['alerticoninfo'] = 'Inligtingikoon';
$string['alerticoninfodesc'] = 'Stel die \'<a href="http://fortawesome.github.io/Font-Awesome/icons/">Font Awesome Icon</a>\' om in inligtingtipe waarskuwingsbokse te gebruik. Voer die ikoonnaam sonder die fa- prefiks in.';
$string['alerticonsuccess'] = 'Aankondigingikoon';
$string['alerticonsuccessdesc'] = 'Stel die \'<a href="http://fortawesome.github.io/Font-Awesome/icons/">Font Awesome Icon</a>\' om in aankondigingtipe waarskuwingsbokse te gebruik. Voer die ikoonnaam sonder die fa- prefiks in.';
$string['alerticonwarning'] = 'Waarskuwingsikoon';
$string['alerticonwarningdesc'] = 'Stel die \'<a href="http://fortawesome.github.io/Font-Awesome/icons/">Font Awesome Icon</a>\' om in waarskuwingtipe waarskuwingsbokse te gebruik. Voer die ikoonnaam sonder die fa- prefiks in.';
$string['alertinfo'] = 'Inligting';
$string['alertinfodesc'] = 'Vertoon inligting in die waarskuwingsboks.';
$string['alertkeyvalue'] = 'Waarskuwingsleutel';
$string['alertkeyvalue_details'] = 'Die sleutel wat hierdie waarskuwing identifiseer, uit vorige waarskuwings. As jy dit verander, sal alle gebruikers wat die waarskuwing voorheen afgeskakel het, dit weer sien. As jy die waarskuwing verander, sal jy hierdie waarskynlik ook wil verander om te verseker dat alle gebruikers dit sien.';
$string['alertprofilefield'] = 'Doelgemaakte profielveldnaam=Waarde  (opsioneel)';
$string['alertprofilefielddesc'] = 'Voeg toegangsreël by vir die gebruik van doelgemaakte profielveld, bv. gebruikertipe=student.';
$string['alertsettings'] = 'Waarskuwingsboks';
$string['alertsettingscourse'] = 'Kursuswaarskuwing-verstellings';
$string['alertsettingsgeneral'] = 'Algemene waarskuwing-verstellings';
$string['alertsettingsheading'] = 'Doelmaak top Waarskuwingsboks. Sien die uitleg <a href="./../theme/adaptable/pix/layout.png" target="_blank"> hier</a>';
$string['alerttext'] = 'Waarskuwingteks';
$string['alerttextdesc'] = 'Voer die teks in om in die waarskuwingsboks te vertoon.';
$string['alerttype'] = 'Waarskuwingsbokstipe';
$string['alerttypedesc'] = 'Stel die tipe waarskuwing: inligting (blou), waarskuwing (geel), of aankondiging (groen).';
$string['alertwarning'] = 'Waarskuwing';
$string['alertwarningdesc'] = 'Vertoon \'n waarskuwing in die waarskuwingsboks.';
$string['analyticscount'] = 'Ontledingstelling';
$string['analyticscountdesc'] = 'Die aantal ontledingsvelde om in die wysigingsarea hieronder te vertoon.';
$string['analyticsprofilefield'] = 'Doelgemaakte Profielveldnaam=Waarde (opsioneel)';
$string['analyticsprofilefielddesc'] = 'Voeg toegangsreël by vir doelgemaakte profielveld, bv. gebruikertipe=student.';
$string['analyticssettings'] = 'Ontleding';
$string['analyticssettingsdesc'] = 'Jy kan etlike kodes vir Google Analytics opstel en dit na gebruikerprofielvelde teiken. Of jy kan Matomo, die oop hulpbronontledingsprogram, gebruik.';
$string['analyticssettingsheading'] = 'Stel  Google Analytics en/of Matomo op';
$string['analyticstext'] = 'Analytics-ID';
$string['analyticstextdesc'] = 'Voer Google Analytics-ID in';
$string['anonymizega'] = 'Maak die gebruiker se IP anoniem';
$string['anonymizegadesc'] = 'Maak die gebruiker-IP anoniem en stuur na Google Analytics.';
$string['bcustyle'] = 'BCU-styl';
$string['blockbackgroundcolor'] = 'Blok-agtergrondkleur';
$string['blockbackgroundcolordesc'] = 'Stel die agtergrondkleur vir alle blokke';
$string['blockbordercolor'] = 'Blok-rantkleur';
$string['blockbordercolordesc'] = 'Stel die blok se rantkleur';
$string['blockheaderbackgroundcolor'] = 'Blok-opskrifagtergrondkleur';
$string['blockheaderbackgroundcolordesc'] = 'Stel die opskrifagtergrondkleur vir alle blokke.';
$string['blockheaderborderbottom'] = 'Dikte van onderkantse blok-hofierant';
$string['blockheaderborderbottomdesc'] = 'Stel die dikte van die onderste rant van blok-hofies.';
$string['blockheaderborderleft'] = 'Dikte van linkerkantse blok-hofierant';
$string['blockheaderborderleftdesc'] = 'Stel die dikte van die linkerkantse rant van blok-hofies.';
$string['blockheaderborderright'] = 'Dikte van regterkantse blok-hofierant';
$string['blockheaderborderrightdesc'] = 'Stel die dikte van die regterkantse rant van blok-hofies.';
$string['blockheaderbordertop'] = 'Dikte van boonste blok-hofierant';
$string['blockheaderbordertopdesc'] = 'Stel die dikte van die boonste rant van blok-hofies.';
$string['blockheaderbordertopstyle'] = 'Rantstyl van blok-hofie';
$string['blockheaderbordertopstyledesc'] = 'Stel die styl van die rant van blok-hofies.';
$string['blockheaderbottomradius'] = 'Onderste radius van blok-hofie';
$string['blockheaderbottomradiusdesc'] = 'Stel die radius van onderste hofie-blok om \'n geboë/geronde effek te verkry.';
$string['blockheadercolor'] = 'Voorste kleur van blok-hofie';
$string['blockheadercolordesc'] = 'Stel die voorste kleur van die blok-hofie.';
$string['blockheadertopradius'] = 'Boonste radius van blok-hofie';
$string['blockheadertopradiusdesc'] = 'Stel die radius van die boonste hofie-blok om \'n geboë/geronde effek te verkry.';
$string['blockicons'] = 'Blok-ikone';
$string['blockiconsdesc'] = 'Stel hierdie om blok-ikone in die blok-opskrifarea te vertoon.';
$string['blockiconsheadersize'] = 'Ikoongrootte van blok-hofie';
$string['blockiconsheadersizedesc'] = 'Stel die voorste ikoongrootte wat in die moodle blok-hofie gebruik word. Kies \'n waarde uit die lys.';
$string['blocklayoutbuilder'] = 'Voorblad blokareas';
$string['blocklayoutbuilderdesc'] = 'Hieronder kan jy jou eie uitleg vir blokareas op die voorblad bou.<br/>Om inhoud by hierdie areas te voeg, sal jy <strong>wysiging op die voorblad van Moodle moet aanskakel</strong>.<br/>Dan kan jy begin om blokke in die areas wat jy skep te sleep/laat los.';
$string['blocklayoutlayoutcheck'] = 'Kontroleer jou uitleg';
$string['blocklayoutlayoutcheckdesc'] = 'Gebruik die hulpmiddel hieronder om die aantal blokke wat jy gebruik het te kontroleer en \'n voorstelling van jou nuwe uitleg te sien.';
$string['blocklayoutlayoutcount1'] = 'Jy kan \'n maksimum stel van';
$string['blocklayoutlayoutcount2'] = 'blokareas. Jy gebruik tans:';
$string['blocklayoutlayoutrow'] = 'Blokarea-ry';
$string['blocklayoutlayoutrowdesc'] = 'Voeg by/stel uitleg vir blokarea op voorblad.';
$string['blockmainborderbottom'] = 'Rantdikte van hoof-onderste blok';
$string['blockmainborderbottomdesc'] = 'Stel die dikte van die onderste rant van die hoof-blokarea.';
$string['blockmainborderleft'] = 'Rantdikte van linkerkantse hoof-blok';
$string['blockmainborderleftdesc'] = 'Stel die dikte van die linkerkantse rant van die hoof-blokarea.';
$string['blockmainborderright'] = 'Rantdikte van regterkantse hoof-blok';
$string['blockmainborderrightdesc'] = 'Stel die dikte van die regterhandse rant van die hoof-blokarea.';
$string['blockmainbordertop'] = 'Rantdikte van boonste hoof-blok';
$string['blockmainbordertopdesc'] = 'Stel die dikte van die boonste rant van die hoof-blokarea.';
$string['blockmainbordertopstyle'] = 'Rantstyl van die hoof-blok';
$string['blockmainbordertopstyledesc'] = 'Stel die styl van die rant van die blokinhoudarea.';
$string['blockmainbottomradius'] = 'Onderste radius van hoof-blok';
$string['blockmainbottomradiusdesc'] = 'Stel die onderste radius van die hoof-blokarea om \'n geboë/geronde effek te verkry.';
$string['blockmaintopradius'] = 'Boonste radius van hoof-blok';
$string['blockmaintopradiusdesc'] = 'Stel die boonste radius van die hoof-blokarea om \'n geboë/geronde effek te verkry.';
$string['blockregionbackground'] = 'Agtergrondkleur van blokarea';
$string['blockregionbackgrounddesc'] = 'Agtergrondkleur van die houer van doelgemaakte blokuitlegte van die voorblad berg.';
$string['blockside'] = 'Ligging van die blokke';
$string['blocksidedesc'] = 'Beheer of die blokke links of regs op die bladsy verskyn.';
$string['breadcrumb'] = 'Breadcrumb';
$string['breadcrumbbackgroundcolor'] = 'Breadcrumb-agtergrondkleur';
$string['breadcrumbbackgroundcolordesc'] = 'Stel die agtergrondkleure van die Breadcrumb.';
$string['breadcrumbdisplay'] = 'Breadcrumb-vertoon';
$string['breadcrumbdisplaydesc'] = 'Stel die vertoon van wat in die Breadcrumb-area in \'n kursus behoort te wees.';
$string['breadcrumbhome'] = 'Breadcrumb-tuis';
$string['breadcrumbhomedesc'] = 'Vertoon tuis-Breadcrumb as \'n ikoon of as teks.';
$string['breadcrumbhomeicon'] = 'Ikoon';
$string['breadcrumbhometext'] = 'Teks';
$string['breadcrumbseparator'] = 'Breadcrumb-skeier';
$string['breadcrumbseparatordesc'] = 'Sien die <a href="https://fortawesome.github.io/Font-Awesome/icons/" target="_blank">Font Awesome Icon</a> om as itemskeier in die breadcrumb te gebruik. Voer die ikoonnaam sonder die fa- prefiks in.';
$string['breadcrumbtextcolor'] = 'Tekskleur van Breadcrumb';
$string['breadcrumbtextcolordesc'] = 'Stel die tekskleur van die Breadcrumb.';
$string['breadcrumbtitle'] = 'Breadcrumb-kursusnaam';
$string['breadcrumbtitledesc'] = 'Stel die modus om die kursustitel in die Breadcrumb te vertoon.';
$string['bs4all'] = 'Ekstraklein - Ekstragroot';
$string['bs4extralarge'] = 'Slegs Ekstragroot';
$string['bs4large'] = 'Groot - Ekstragroot';
$string['bs4medium'] = 'Medium - Ekstragroot';
$string['bs4none'] = 'Geen';
$string['bs4small'] = 'Klein - Ekstragroot';
$string['buttoncolor'] = 'Knoppiekleur';
$string['buttoncolorcancel'] = 'Kanselleer knoppiekleur';
$string['buttoncolordesc'] = 'Die kleur van die hoofknoppie wat regdeur die werf gebruik word.';
$string['buttoncolordesccancel'] = 'Agtergrondkleur vir Kanselleer-knoppie.<br />Tik "transparent" in die boks vir deursigtigheid.';
$string['buttoncolordescscnd'] = 'Die kleur van die sekondêre knoppies wat regdeur die werf gebruik word.';
$string['buttoncolorscnd'] = 'Sekondêre knoppiekleur';
$string['buttondesc'] = 'Verander die voorkoms van knoppies wat in hierdie tema gebruik word.';
$string['buttondropshadow'] = 'Hangskaduversiering van onderkant van knoppie';
$string['buttondropshadowdesc'] = 'Vertoon \'n hangskaduwee (verdowwing) aan onderkant van knoppie.';
$string['buttonhovercolor'] = 'Knoppie-sweef kleur';
$string['buttonhovercolorcancel'] = 'Kanselleer knoppie-sweef kleur';
$string['buttonhovercolordesc'] = 'Die kleur waarna die knoppie verander wanneer daar oor die knoppie gesweef word.';
$string['buttonhovercolordesccancel'] = 'Die kleur waarna die kanselleer-knoppie verander wanneer daar oor die knoppie gesweef word.<br />Tik "transparent" in die boks vir deursigtigheid.';
$string['buttonhovercolordescscnd'] = 'Die kleur waarna die sekondêre knoppie verander wanneer daar oor die knoppie gesweef word.';
$string['buttonhovercolorscnd'] = 'Sekondêre knoppie-sweef kleur';
$string['buttonlogincolor'] = 'Kleur van intekenknoppie';
$string['buttonlogincolordesc'] = 'Die kleur van die intekenknoppie.';
$string['buttonloginheight'] = 'Stel die hoogte van die intekenknoppie';
$string['buttonloginheightdesc'] = 'Slegs doeltreffend as \'n intekenvorm in die boonste opskrif gebruik word.';
$string['buttonloginhovercolor'] = 'Kleur van intekenknoppie-sweef';
$string['buttonloginhovercolordesc'] = 'Die sweefkleur van die intekenknoppie.';
$string['buttonloginmargintop'] = 'Stel die boonste grens van die intekenknoppie';
$string['buttonloginmargintopdesc'] = 'Laat spasiëring/posisionering van die intekenknoppie gewysig word.';
$string['buttonloginpadding'] = 'Stel die opvulling van die intekenknoppie';
$string['buttonloginpaddingdesc'] = 'Groter getal = groter knoppie';
$string['buttonlogintextcolor'] = 'Tekskleur van intekenknoppie';
$string['buttonlogintextcolordesc'] = 'Die tekskleur wat op die intekenknoppie gebruik word.';
$string['buttonradius'] = 'Stel die knoppieradius';
$string['buttonradiusdesc'] = 'Groter radius = geboë knoppies, kleiner radius = vierkantige knoppies.';
$string['buttonsettings'] = 'Knoppies';
$string['buttonsettingsheading'] = 'Doelmaak die knoppies van hierdie tema.';
$string['buttontextcolor'] = 'Tekskleur van knoppie';
$string['buttontextcolorcancel'] = 'Kanselleer tekskleur van knoppie';
$string['buttontextcolordesc'] = 'Die tekskleur wat op knoppies gebruik word.';
$string['buttontextcolordesccancel'] = 'Die tekskleur wat op die kanselleer-knoppies gebruik word.';
$string['buttontextcolordescscnd'] = 'Die tekskleur wat op sekondêre knoppies gebruik word.';
$string['buttontextcolorscnd'] = 'Tekskleur van sekondêre knoppie';
$string['categoryhavecustomheader'] = 'Doelgemaakte kategoriehofie';
$string['categoryhavecustomheaderdesc'] = 'Kies die topvlak-kategorieë wat \'n doelgemaakte hofie sal hê. Om meer as een te kies, of om \'n kategorie te ontkies, gebruik die \'CTRL\'-sleutel. Berg en verfris die bladsy om by te werk. Let wel: Subkategorieë van die geselekteerde sal die verstellingswaardes erf.';
$string['categoryheaderbgimage'] = 'Kategorie \'{$a->name}\' met id \'{$a->id}\' agtergrondprent';
$string['categoryheaderbgimagedesc'] = 'Stel \'n agtergrondprent vir die topvlak-kategorie \'{$a->name}\' met id \'{$a->id}\' in die hofie. Minimum grootte is 1600 x 180 px (1900 x180 px word aanbeveel). Die prent sal die volledige hofie bedek.';
$string['categoryheaderbgimagedescchildren'] = 'Stel \'n agtergrondprent vir die topvlak-kategorie \'{$a->name}\' met id \'{$a->id}\' en die afstammelinge daarvan \'{$a->children}\' in die hofie. Minimum grootte is 1600 x 180 px (1900 x180 px word aanbeveel). Die prent sal die volledige hofie bedek.';
$string['categoryheadercustomcss'] = 'Kategorie \'{$a->name}\' met id \'{$a->id}\' doelgemaakte CSS';
$string['categoryheadercustomcssdesc'] = 'Stel doelgemaakte CSS vir die topvlak-kategorie \'{$a->name}\' met id \'{$a->id}\'. Dit sal CSS vir die temakieser met die prefiks \'.category-{$a->id}\' genereer. As die CSS lyk asof dit nie toegepas is nie, kontroleer die PHP-logdokument.';
$string['categoryheadercustomcssdescchildren'] = 'Stel doelgemaakte CSS vir die topvlak-kategorie \'{$a->name}\' met id \'{$a->id}\' en sy nasate \'{$a->children}\'. Dit sal CSS vir die temakieser met die prefiks \'.category-{$a->id}\' vir alle nasaat-id\'s genereer. As die CSS lyk asof dit nie toegepas is nie, kontroleer die PHP-logdokument.';
$string['categoryheadercustomtitle'] = 'Kategorie \'{$a->name}\' met id \'{$a->id}\' doelgemaakte titel';
$string['categoryheadercustomtitledesc'] = 'Stel doelgemaakte CSS vir die topvlak-kategorie \'{$a->name}\' met id \'{$a->id}\' in die opskrif. Indien dit leeg is, sal jy dit wat deur die \'sitetitle\' en \'sitetitletext\'-verstellings op niekursusbladsye gekonfigureer is, of op kursusbladsye wanneer \'enableheading\' \'af is\', ontvang. Wanneer dit met niekursuskategorie-geskakelde bladsye bevolk is, sal dit die werf se titel vervang. Indien dit op kursusbladsye bevolk is, sal dit bokant die titel verskyn, soos bepaal deur die \'enableheading\'-verstelling. Op mobiele toestelle sal enige \'title\' slegs afhangend van die \'responsivecoursetitle\'-verstelling verskyn.';
$string['categoryheadercustomtitledescchildren'] = 'Stel doelgemaakte CSS vir die topvlak-kategorie \'{$a->name}\' met id \'{$a->id}\' en sy nasate \'{$a->children}\' in die opskrif. Indien dit leeg is, sal jy dit wat deur die \'sitetitle\' en \'sitetitletext\'-verstellings op niekursusbladsye gekonfigureer is, of op kursusbladsye wanneer \'enableheading\' \'af is\', ontvang. Wanneer dit met niekursuskategorie-geskakelde bladsye bevolk is, sal dit die werf se titel vervang. Indien dit op kursusbladsye bevolk is, sal dit bokant die titel verskyn, soos bepaal deur die \'enableheading\'-verstelling. Op mobiele toestelle sal enige \'title\' slegs afhangend van die \'responsivecoursetitle\'-verstelling verskyn.';
$string['categoryheaderheader'] = 'Verstellings vir die topvlak-kategorie \'{$a->name}\' met id \'{$a->id}\'.';
$string['categoryheaderheaderdesc'] = 'Stel die verstellings vir die topvlak-kategorie \'{$a->name}\' met id \'{$a->id}\'.';
$string['categoryheaderheaderdescchildren'] = 'Stel die verstellings vir die topvlak-kategorie \'{$a->name}\' met id \'{$a->id}\' en sy nasate \'{$a->children}\'.';
$string['categoryheaderlogo'] = 'Kategorie \'{$a->name}\' met id \'{$a->id}\' logo';
$string['categoryheaderlogodesc'] = 'Stel \'n logo vir die topvlak-kategorie \'{$a->name}\' met id \'{$a->id}\' in die hofie. Aanbevole grootte is 200 px by 80 px.';
$string['categoryheaderlogodescchildren'] = 'Stel \'n logo vir die topvlak-kategorie \'{$a->name}\' met id \'{$a->id}\' en sy nasate in die hofie. Aanbevole grootte is 200 px by 80 px.';
$string['categoryheaderssettings'] = 'Kategoriehofies';
$string['categoryheaderssettingsdesc'] = 'Stel verstellings vir die hofie binne \'n kategorie.';
$string['categoryheaderssettingsheading'] = 'Verander die hofie van een of meer topvlak-kategorieë, en onder.';
$string['cdefaulticon'] = 'Verstek ikoon: My Kursusse';
$string['cdefaulticondesc'] = 'Die Font Awesome 4-ikoon sonder die prefiks \'fa-\' kan gebruik word vir kursusse wat nie reeds \'n ikoon het nie. Indien leeg, sal die verstek gebruik word.';
$string['cfrozenicon'] = 'Vriesikoon: My Kursusse';
$string['cfrozenicondesc'] = 'Die Font Awesome 4-ikoon sonder die prefiks \'fa-\' kan gebruik word vir bevriesde kursusse. Indien leeg, sal die verstek gebruik word.';
$string['chiddenicon'] = 'Versteekte ikoon: My kursusse';
$string['chiddenicondesc'] = 'Die Font Awesome 4-ikoon sonder die prefiks \'fa-\' kan gebruik word vir versteekte kursusse. Indien leeg, sal die verstek gebruik word.';
$string['choosereadme'] = '<div class="clearfix">
<h2>Adaptable</h2>
<p><img class="img-polaroid" src="adaptable/pix/screenshot.png" /></p>
<h3>Inligting oor</h3>
<p>Adaptable is \'n twee-kolom reagerende tema, hoogs aanpasbaar en gebaseer op die populêre BCU-tema. Weergawes 2 en 3 gebruik Boost as basistema, en derhalwe Bootstrap 4.</p>
<p>Die tema is onder die GPL (General Public License) weergawe 3 gelisensieer. Jy kan die volledige besonderhede \'<a href="http://www.gnu.org/licenses/gpl-3.0.html" target="_blank">hier</a>\' kry.</p>
<br>
<h4>Wysig dit! - Verbeter dit! - Deel dit!</h4>
<br>
<h3>Krediete</h3>
<p>Hierdie weergawe van die tema is ontwikkel deur:<br>
Gareth J Barnard (<a href="http://moodle.org/user/profile.php?id=442195" target="_blank">moodle.org/user/profile.php?id=442195</a>).
</p>
<p>Hierdie tema is voorheen ontwikkel deur:<ul>
<li>Jeremy Hopkins (Coventry Universiteit).</li>
<li>Fernando Acedo (<a href="https://3-bits.com" target="_blank">3-bits.com</a>).</li>
<li>Manoj Solanki (Coventry Universiteit).</li>
</ul></p>
<h3>Ander krediete</h3>
<p>Samewerkers met weergawe 2:<ul>
<li>Gareth J Barnard (<a href="http://moodle.org/user/profile.php?id=442195" target="_blank">moodle.org/user/profile.php?id=442195</a>).</li>
<li>Stuart Lamour.</li>
<li>Alistair Spark (University Kollege, Londen).</li>
</ul><p>onder baie ander ontwikkelaars, toetsers, vertalers en vrywilligers (sien asseblief die  <a href="adaptable/README.md" target="_blank">README.md</a> dokument).</p>
<br>
<h3>Rapporteer foute</h3>
<p>Jy kan foute en verbeterings, wat jy graag wil befons, in ons \'<a href="https://gitlab.com/jezhops/moodle-theme_adaptable/-/issues" target="_blank">bewaararea</a>\' rapporteer.</p>
<br>
<h3>Tegniese Ondersteuning</h3>
<p>Jy kan jou vrae op die Moodle-forum vra:</p>
<ul>
<li>Engels: <a href="https://moodle.org/mod/forum/view.php?id=46" target="_blank">Temaforum</a>.</li>
</ul>
</div>';
$string['cneveraccessedicon'] = 'Ikoon - Toegang nooit verkry nie: My kursusse';
$string['cneveraccessedicondesc'] = 'Die Font Awesome 4-ikoon sonder die prefiks \'fa-\' kan gebruik word vir kursusse waarvoor die gebruiker ingeskryf is, maar nog nie toegang tot verkry het nie. Indien leeg, sal die verstek gebruik word.';
$string['collapsedtopicscoloursenabled'] = 'Voor- en agtergrondkleurverstellings van Toegevoude Onderwerpe-tokkel';
$string['collapsedtopicscoloursenableddesc'] = 'Gebruik die voor- en agtergrondkleurverstellings van Toegevoude Onderwerpe-tokkel, eerder as Adaptable se \'sectionheadingcolor\'- en \'coursesectionheaderbg\'-verstellings.';
$string['colordesc'] = 'Jy kan die kleure wat jy deur hierdie tema wil gebruik, kies. Gebruik Hex of enige ander standaard notasie. As alternatiewe opsie kan jy deursigtig en geërf as \'n waarde gebruik.';
$string['colorsettings'] = 'Kleure';
$string['colorsettingsheading'] = 'Wysig die hoofkleure wat regdeur die tema gebruik word.';
$string['configtabtitle'] = 'Verstellings';
$string['configtitle'] = 'Adaptable';
$string['coursepageactivitybottomblockregionheading'] = 'Doelgemaakte kursusaktiwiteit onderste blokarea';
$string['coursepageactivitybottomblockregionheadingdesc'] = '\'n Doelgemaakte blokarea wat ná die einde van aktiwiteite verkyn.';
$string['coursepageblockactivitybottomenabled'] = 'Ontsper kursusaktiwiteit onderste blokarea op kursusblad';
$string['coursepageblockactivitybottomenableddesc'] = 'Ontsper hierdie area op alle kursusblaaie.';
$string['coursepageblocklayoutbuilder'] = 'Kursusblad blokareas';
$string['coursepageblocklayoutbuilderdesc'] = 'Hieronder kan jy jou eie uitleg vir blokareas op die kursusblad bou.<br/>Om inhoud by hierdie areas te voeg, sal jy <strong>wysiging op die kursusblad van Moodle moet aanskakel</strong>.<br/>Dan kan jy begin om blokke na die areas wat jy skep te sleep en laat los.';
$string['coursepageblocklayoutlayoutbottomrow'] = 'Kursusblad-blok onderste area-ry';
$string['coursepageblocklayoutlayoutbottomrowdesc'] = 'Voeg by / stel uitleg van blokareary op die kursusblad.';
$string['coursepageblocklayoutlayouttoprow'] = 'Kursusblad-blok boonste area-ry';
$string['coursepageblocklayoutlayouttoprowdesc'] = 'Voeg by / stel uitleg van blokarea op Kursusblad.';
$string['coursepageblockregionsettings'] = 'Kursusblad-blokarea bouer';
$string['coursepageblocksenabled'] = 'Ontsper doelgemaakte blokareas op die kursusblad';
$string['coursepageblocksenableddesc'] = 'Jy kan doelgemaakte blokareas (bo en onder) op die Kursusblad ontsper / versper. Jy kan dan blokke na die areas wat jy geskep het, sleep en laat los.';
$string['coursepagesidebarinfooterenabled'] = 'Skuif kantstafie na onderskrif op Kursusbladsy';
$string['coursepagesidebarinfooterenableddesc'] = 'Verbreed kursusblad se uitleg deur kantstafie na onderskrif te skuif.';
$string['coursepagesidebarinfooterenabledsection'] = 'Algemene verstellings';
$string['coursepagesidebarinfooterenabledsectiondesc'] = 'Algemene verstellings vir die meeste van die kursusformate.';
$string['coursesectionactivityassignbgcolor'] = 'Agtergrondkleur van opdragaktiwiteit';
$string['coursesectionactivityassignbgcolordesc'] = 'Stel die agtergrondkleur van die Opdragaktiwiteit. Tik <strong>transparent</strong> in die boks vir deursigtigheid.';
$string['coursesectionactivityassignleftbordercolor'] = 'Linkerrant vertoonkleur van Opdragaktiwiteit';
$string['coursesectionactivityassignleftbordercolordesc'] = 'Stel die kleur van die linkerrant.';
$string['coursesectionactivitybordercolor'] = 'Onderrant vertoonkleur van Kursusafdelingaktiwiteit';
$string['coursesectionactivitybordercolordesc'] = 'Stel die kleur van die kursusafdelingaktiwiteit se onderste rant.';
$string['coursesectionactivityborderstyle'] = 'Onderrantstyl van Kursusafdelingaktiwiteit';
$string['coursesectionactivityborderstyledesc'] = 'Stel die styl van die kursusafdelingaktiwiteit se onderste rant.';
$string['coursesectionactivityborderwidth'] = 'Breedte van Kursusafdelingaktiwiteit se onderste rant.';
$string['coursesectionactivityborderwidthdesc'] = 'Stel breedte van die rant wat onderaan \'n kursusafdelingaktiwiteit verskyn.';
$string['coursesectionactivitycolors'] = 'Kursusafdelingaktiwiteitopsies';
$string['coursesectionactivityforumbgcolor'] = 'Agtergrondkleur van Forumaktiwiteit';
$string['coursesectionactivityforumbgcolordesc'] = 'Stel die agtergrondkleur van forumaktiwiteit. Tik <strong>transparent</strong> in die boks vir deursigtigheid.';
$string['coursesectionactivityforumleftbordercolor'] = 'Linkerrant vertoonkleur van Forumaktiwiteit';
$string['coursesectionactivityforumleftbordercolordesc'] = 'Stel die kleur van die linkerkantse rant.';
$string['coursesectionactivityheadingcolour'] = 'Opskrifkleur van Kursusafdelingaktiwiteit';
$string['coursesectionactivityheadingcolourdesc'] = 'Die kleur van kliekbare aktiwiteite wat op die kursus se tuisblad vertoon word.';
$string['coursesectionactivityiconsize'] = 'Ikoongrootte van Kursusafdelingaktiwiteit';
$string['coursesectionactivityiconsizedesc'] = 'Stel die ikoongrootte van aktiwiteite/hulpbronne (bv. \'n waarde van 16 px sal dit na 16 px by 16 px stel).';
$string['coursesectionactivityleftborderwidth'] = 'Breedte van linkerrant van Kursusafdeling';
$string['coursesectionactivityleftborderwidthdesc'] = 'Stel breedte van die rant wat links van \'n kursusafdelingaktiwiteit verskyn.';
$string['coursesectionactivitymarginbottom'] = 'Aktiwiteitspasiëring van onderste kantlyn.';
$string['coursesectionactivitymarginbottomdesc'] = 'Spasiëring van onderste kantlyn tussen aktiwiteite.';
$string['coursesectionactivitymargintop'] = 'Aktiwiteitspasiëring van boonste kantlyn.';
$string['coursesectionactivitymargintopdesc'] = 'Spasiëring van boonste kantlyn tussen aktiwiteite.';
$string['coursesectionactivityquizbgcolor'] = 'Agtergrondkleur van vasvra-aktiwiteit';
$string['coursesectionactivityquizbgcolordesc'] = 'Stel die agtergrondkleur van die vasvra-aktiwiteit. Tik <strong>transparent</strong> in die boks vir deursigtigheid.';
$string['coursesectionactivityquizleftbordercolor'] = 'Vertoonkleur van linkerrant van Vasvra-aktiwiteit';
$string['coursesectionactivityquizleftbordercolordesc'] = 'Stel die kleur van die linkerrant.';
$string['coursesectionbgcolor'] = 'Agtergrond van Kursusafdeling';
$string['coursesectionbgcolordesc'] = 'Stel die agtergrondkleur van die kursusafdeling.';
$string['coursesectionbordercolor'] = 'Rantkleur van Kursusafdeling';
$string['coursesectionbordercolordesc'] = 'Stel die rantkleur van Kursusafdelings.';
$string['coursesectionborderradius'] = 'Rantradius van Kursusafdeling';
$string['coursesectionborderradiusdesc'] = 'Stel die radius van kursusafdelingrante (geronde hoeke).';
$string['coursesectionborderstyle'] = 'Rantstyl van Kursusafdeling';
$string['coursesectionborderstyledesc'] = 'Stel die rantstyl van kursusafdelings.';
$string['coursesectionborderwidth'] = 'Rantbreedte van Kursusafdeling';
$string['coursesectionborderwidthdesc'] = 'Stel die breedte van Kursusafdelingrante.';
$string['coursesectionheaderbg'] = 'Hofieagtergrond van Kursusafdeling';
$string['coursesectionheaderbgdesc'] = 'Stel die agtergrondkleur van die kursusafdeling se hofies.';
$string['coursesectionheaderbordercolor'] = 'Rantkleur van Kursusafdeling se hofie';
$string['coursesectionheaderbordercolordesc'] = 'Stel die rantkleur van die kursusafdeling se hofie (slegs onderste rant wat as buitenste houer gebruik word, het ook \'n rant).';
$string['coursesectionheaderborderradiusbottom'] = 'Onderste radius van Kursusafdeling se hofierant';
$string['coursesectionheaderborderradiusbottomdesc'] = 'Stel die onderste radius van kursusafdeling se hofierante (geronde hoeke).';
$string['coursesectionheaderborderradiustop'] = 'Boonste radius van Kursusafdeling se hofierant';
$string['coursesectionheaderborderradiustopdesc'] = 'Stel die boonste radius van kursusafdeling se hofierante (geronde hoeke).';
$string['coursesectionheaderborderstyle'] = 'Rantstyl van Kursusafdeling se hofie';
$string['coursesectionheaderborderstyledesc'] = 'Stel die styl van die kursusafdeling se hofierant (slegs onderste rant wat as buitenste houer gebruik word, het ook \'n rant).';
$string['coursesectionheaderborderwidth'] = 'Rantbreedte van Kursusafdeling se hofie';
$string['coursesectionheaderborderwidthdesc'] = 'Stel die breedte van die Kursusafdeling se hofierant (slegs onderste rant wat as buitense houer gebruik word, het ook \'n rant).';
$string['coursesections'] = 'Kursusafdelings';
$string['coursesettings'] = 'Kursusformate';
$string['coursesettingsdesc'] = 'Doelmaak sommige van die Moodle-kursusformate wat die meeste gebruik word, om by die hoofontwerp te pas.';
$string['coursesettingsheading'] = 'Kursusformaatverstellings';
$string['coursetitlefullname'] = 'Kursus volle naam';
$string['coursetitlemaxwidth'] = 'Maksimum lengte van kursustitel';
$string['coursetitlemaxwidthdesc'] = 'Stel die maksimum aantal karakters in die kursustitel-area.';
$string['coursetitleshortname'] = 'Kursus kortnaam / kode';
$string['covbkcolor'] = 'Titelagtergrondkleur van Coventry-teëls';
$string['covbkcolordesc'] = 'Stel die titelagtergrondkleur met die Coventry-teëluitbeelder wat gekies is.';
$string['coventrystyle'] = 'Coventry-styl';
$string['covfontcolor'] = 'Coventry-styl titelfontkleur';
$string['covfontcolordesc'] = 'Stel die titel se fontkleur met die Coventry-teëluitbeelder wat gekies is.';
$string['covhidebutton'] = 'Coventry-teëls kursusknoppie';
$string['covhidebuttondesc'] = 'Stel dit om die kursusknoppie te versteek wanneer Coventry-teëls geselekteer is.';
$string['currentcolor'] = 'Huidige kursusafdeling beligtingkleur';
$string['currentcolordesc'] = 'Stel die kleur van die huidige kursusafdelingbeligting.';
$string['customcoursesubtitle'] = 'Doelgemaakte kursustitel';
$string['customcoursesubtitledesc'] = 'Naam van die gebruikerprofiel doelgemaakte veld vir die kursustitel.';
$string['customcoursetitle'] = 'Doelgemaakte kursustitel';
$string['customcoursetitledesc'] = 'Naam van die gebruikerprofiel doelgemaakte veld vir die kursustitel.';
$string['customcss'] = 'Doelgemaakte CSS';
$string['customcssdesc'] = 'Watter CCS-reëls jy ook al by hierdie teksarea voeg, sal in elke bladsy weerspieël word, wat die doelmaak van hierdie tema vergemaklik.';
$string['dangericoncolor'] = 'Kleur van Waakskuwingikoon';
$string['dangericoncolordesc'] = 'Stel die kleur van die waarskuwing-/gevaar-ikoon wat hoofsaaklik in verpligte velde gebruik word.';
$string['dashblocklayoutbuilder'] = 'Paneelbordblokareas';
$string['dashblocklayoutbuilderdesc'] = 'Hieronder kan jy jou eie uitleg vir blokareas op die paneelbordblad bou.<br/>Om inhoud by hierdie areas te sit, moet jy <strong>wysiging op die paneelbordblad van Moodle aanskakel</strong>.<br/>Dan kan jy begin om blokke na die areas wat jy geskep het, te sleep/laat los.';
$string['dashblocklayoutlayoutrow'] = 'Paneelbordblokarea-ry';
$string['dashblocklayoutlayoutrowdesc'] = 'Voeg by/stel uitleg vir blokarea-ry op Paneelbordblad.';
$string['dashblocksabovecontent'] = 'Vertoon bo hoofinhoud';
$string['dashblocksbelowcontent'] = 'Vertoon onder hoofinhoud';
$string['dashblocksenabled'] = 'Ontsper doelgemaakte blokarea op die \'Paneelbord\'-blad';
$string['dashblocksenableddesc'] = 'Jy kan doelgemaakte blokareas op die \'Paneelbord\'-bladsy ontsper/versper. Jy kan dan blokke na die areas wat jy geskep het, sleep en laat los.';
$string['dashblocksposition'] = 'Doelgemaakte blokareaposisie';
$string['dashblockspositiondesc'] = 'Wanneer doelgemaakte blokareas vir die paneelbordblad ontsper is, kies die posisie.';
$string['dashboardblockregionsettings'] = 'Paneelbordblokarea-bouer';
$string['defaultzoom'] = 'Verstek zoem';
$string['defaultzoomdesc'] = 'Verstek skermgrootte wanneer ontsper zoem versper is, of die gebruiker nie \'n voorkeur aangedui het nie. Kies tussen volskerm en vasgestelde breedte.';
$string['disablecustommenu'] = 'Versper Moodle doelgemaakte kieslys';
$string['disablecustommenudesc'] = 'Versper Moodle doelgemaakte kieslyste in die navigasiestafie (sal steeds uitbeeld in ander temas wat jy moontlik geïnstalleer het).';
$string['disabled'] = 'Versper';
$string['disablemenuscoursepages'] = 'Versper kieslyste op kursusbladsye';
$string['disablemenuscoursepagesdesc'] = 'Deur hierdie opsie aan te skakel, sal die vertoon van boonste kieslyste tot werfblaaie beperk word, asook tot die tuisblad en paneelbord (\'My Tuiste\'), ens. en dit sal in geen ander kursusblaaie vertoon word nie.';
$string['discardbuttontext'] = 'Kanselleer';
$string['displayeditingbuttontext'] = 'Knoppieteks word gewysig';
$string['displayeditingbuttontextdesc'] = 'Vertoon of versteek die teks op die wysigingsknoppie. Let wel: Slegs van toepassing op die kursuswysigingsknoppie.';
$string['displaygrades'] = 'Vertoon punte';
$string['displaygradesdesc'] = 'Vertoon die puntitem in die kieslys.';
$string['displaylogin'] = 'Vertoon inteken';
$string['displayloginbox'] = 'Intekenboks';
$string['displayloginbutton'] = 'Knoppie';
$string['displaylogindesc'] = 'Kies hoe die intekenboks in opskrif moet vertoon.';
$string['displayloginno'] = 'Geen Intekenboks nie';
$string['displayparticipants'] = 'Vertoon deelnemers';
$string['displayparticipantsdesc'] = 'Vertoon die deelnemersitem in die kieslys.';
$string['editcognocourseupdate'] = 'Vertoon die ratjie aan geen kursusbywerkingsgebruikers nie';
$string['editcognocourseupdatedesc'] = 'Vertoon die ratjie aan gebruikers wat nie oor die \'moodle/course:update\' vermoë beskik nie, d.w.s. \'Niewysigende Onderwyser\'-rol.';
$string['editfont'] = 'Wysiging en doelmaking van hierdie bladsy se knoppiefontkleur';
$string['editfontdesc'] = 'Stel die wysiging en doelmaking van hierdie bladsy se knoppiefontkleur';
$string['edithorizontalpadding'] = 'Stel horisontale opvulling van die wysigingsknoppies';
$string['editoffbk'] = 'Wysiging en doelmaking van hierdie bladsy se \'Af\'-knoppieagtergrond';
$string['editoffbkdesc'] = 'Stel die agtergrondkleur van die wysiging en doelmaking van hierdie bladyknoppie in \'Af\'-toestand.';
$string['editonbk'] = 'Wysiging en doelmaak van hierdie bladsy se knoppie-agtergrond';
$string['editonbkdesc'] = 'Stel die agtergrondkleur vir die wysiging en doelmaak van hierdie bladsyknoppie.';
$string['editsettingsbutton'] = 'Wysig verstellings en knoppievertoon';
$string['editsettingsbuttondesc'] = 'Konfigureer hier wat in die Navstafie vir wysigingsverstellings behoort te verskyn. Let daarop dat hierdie opsies nie van toepassing is op bladsye waarvoor daar geen verwante verstellings is nie, soos die paneelbordblad.';
$string['editsettingsbuttonshowbutton'] = 'Vertoon slegs wysigknoppie, bv. "Skakel Wysiging aan"-knoppie op kursusblad.';
$string['editsettingsbuttonshowcog'] = 'Vertoon slegs wysig verstellings-ikoon (ratikoon).';
$string['editsettingsbuttonshowcogandbutton'] = 'Vertoon wysig verstellings-ikoon en -rat. Let daarop dat dit meer spasie in navigasie gebruik.';
$string['emoticonsize'] = 'Emotikons grootte';
$string['emoticonsizedesc'] = 'Stel die hoogte en breedte van die Moodle Emotikons.';
$string['enableaccesstool'] = 'Toeganklikheidhulpmiddel';
$string['enableaccesstooldesc'] = 'Vertoon \'n skakel aan die gebruikers "Toeganklikheidhulpmiddel"-voorkeureblad - Let wel: Dit verg die \'<a href="https://github.com/sharpchi/moodle-local_accessibilitytool" target="blank">Toeganklikheidhulpmiddel-invoegtoepassing</a>\'.';
$string['enablealert'] = 'Ontsper waarskuwingsboks {$a}';
$string['enablealertdesc'] = 'Ontsper waarskuwingsboks {$a}.';
$string['enablealerts'] = 'Ontsper / versper waarskuwings';
$string['enablealertsdesc'] = 'Ontsper / versper werfwaarskuwings, nie kursus nie, sien die \'alerthiddencourse\'-verstelling.';
$string['enablealertstriptags'] = 'Verwyder html-merkers outomaties uit waarskuwings';
$string['enablealertstriptagsdesc'] = 'Ontsper sal die waarskuwingsboodskappe outomaties opruim en versper, om jou toe te laat om html / skakels in boodskappe te gebruik, maar jy sal per hand in html-aansig moet skoonmaak.';
$string['enableanalytics'] = 'Ontsper Google Analytics';
$string['enableanalyticsdesc'] = 'Ontsper Google Analytics-verstellings op jou Moodle-werf';
$string['enableavailablecourses'] = 'Vertoon "Beskikbare Kursusse"';
$string['enableavailablecoursesdesc'] = 'Vertoon "Beskikbare Kursusse"-teks op die voorblad.';
$string['enablebadges'] = 'Kentekens';
$string['enablebadgesdesc'] = 'Vertoon \'n skakel na die gebruikers se kentekens.';
$string['enableblog'] = 'Ontsper my blogs';
$string['enableblogdesc'] = 'Vertoon \'n skakel na die gebruikers se blogblad.';
$string['enablecalendar'] = 'Gebruikerkalender';
$string['enablecalendardesc'] = 'Vertoon \'n skakel na die gebruikers se kalender.';
$string['enablecompetencieslink'] = 'Bevoegdhede-skakel';
$string['enablecompetencieslinkdesc'] = 'Vertoon bevoegdhede-skakel in die \'Hierdie Kursus\'-kieslys. Let wel: \'core_competency|enabled\' moet gemerk wees.';
$string['enablecoursesectionsdesc'] = 'Vertoon \'n subkieslys op die \'Hierdie Kursus\'-kieslys, wat skakels bevat na elke vertoonde afdeling.';
$string['enabledtabbedprofileeditprofilelink'] = 'Ontsper wysig profiel-skakel';
$string['enabledtabbedprofileeditprofilelinkdesc'] = 'Ontsper die getabuleerde profiel wysig profiel-skakel. Let wel: Wanneer ontsper, sal dit slegs vertoon word as die gebruiker toestemming het om die profiel te wysig.';
$string['enabledtabbedprofileuserpreferenceslink'] = 'Ontsper voorkeure-skakel';
$string['enabledtabbedprofileuserpreferenceslinkdesc'] = 'Ontsper die getabuleerde profiel gebruikervoorkeure-skakel.';
$string['enableeditprofile'] = 'Wysig profiel';
$string['enableeditprofiledesc'] = 'Vertoon \'n skakel om die gebruikersprofiel te wysig.';
$string['enableeventsdesc'] = 'Vertoon \'n skakel na die kalender.';
$string['enablefeed'] = 'My Terugvoer';
$string['enablefeeddesc'] = 'Vertoon \'n skakel na die gebruiker se "My Terugvoer"-blad - Let wel: Dit verg die \'<a href="https://moodle.org/plugins/report_myfeedback" target="blank">My Terugvoer-invoegtoepassing</a>\'.';
$string['enablegrades'] = 'Punte';
$string['enablegradesdesc'] = 'Vertoon \'n skakel na die gebruiker se punte.';
$string['enablehelp'] = 'Hulpskakel \'{$a->number}\'';
$string['enablehelpdesc'] = 'Voeg \'n hulpskakel \'{$a->number}\' in die navstafie in.';
$string['enablehomedesc'] = 'Vertoon \'n skakel na die voorblad.';
$string['enablehomeredirect'] = 'Ontsper tuiste-herlei=0';
$string['enablehomeredirectdesc'] = 'Ontsper herlei=0 op tuiste. Dit is vir gebruik op werwe waar My Tuiste die verstek tuisblad is. Die verhoed dat gebruikers wat die Tuiste-skakel kliek, na "My Tuiste / Paneelbord" herlei word.';
$string['enablemenus'] = 'Ontsper kieslyste';
$string['enablemenusdesc'] = 'Jy word aangeraai om hierdie af te los as kieslyste weens prestasieredes nie gebruik word nie.';
$string['enablemy'] = 'Paneelbord';
$string['enablemydesc'] = 'Vertoon \'n skakel na die Paneelbordbladsy.';
$string['enablemysitesdesc'] = 'Vertoon \'n aftreklys met \'n gebruiker se kursusse';
$string['enablemysitesrestriction'] = 'Beperk gebruiker se kursusse-aftreklys tot \'n doelgemaakte profielveld';
$string['enablemysitesrestrictiondesc'] = 'Beperk aftreklys met \'n gebruiker se kursusse volgens doelgemaakte profielveld, bv. gebruikertipe=personeel.';
$string['enablenavbarwhenloggedout'] = 'Ontsper navstafie wanneer uitgeteken is';
$string['enablenavbarwhenloggedoutdesc'] = 'Vertoon die navstafie selfs wanneer uitgeteken. Beperk tot slegs hulp en hulpmiddelskieslys.';
$string['enablenote'] = 'My Kennisgewings';
$string['enablenotedesc'] = 'Vertoon \'n skakel na die gebruiker se kennisgewingsblad.';
$string['enableposts'] = 'My Plasings';
$string['enablepostsdesc'] = 'Vertoon \'n skakel na die My Plasingsblad.';
$string['enablepref'] = 'My Voorkeure';
$string['enableprefdesc'] = 'Vertoon \'n skakel na die gebruiker se voorkeureblad.';
$string['enableprivatefiles'] = 'Private dokumente';
$string['enableprivatefilesdesc'] = 'Vertoon \'n skakel na die gebruiker se private dokumente.';
$string['enableprofile'] = 'Gebruikerprofiel';
$string['enableprofiledesc'] = 'Vertoon \'n skakel na die gebruiker se profiel.';
$string['enablesavecanceloverlay'] = 'Ontsper Berg- / Kanselleer-oorlegging op verstellingsbladsye';
$string['enablesavecanceloverlaydesc'] = 'Vertoon \'n Berg- / Kanselleer-knoppie-oorlegging boaan \'n verstellingsblad om die berg van verstellings te vergemaklik.';
$string['enableshowhideblocks'] = 'Ontsper Vertoon Versteek Blokke';
$string['enableshowhideblocksdesc'] = 'Laat gebruikers toe om alle blokke te vertoon / versteek.';
$string['enableshowhideblockstext'] = 'Vertoon teks vir Vertoon Versteek Blokke';
$string['enableshowhideblockstextdesc'] = 'Vertoon die teks langs die knoppie.';
$string['enabletabbedprofile'] = 'Ontsper getabuleerde profiel';
$string['enabletabbedprofiledesc'] = 'Ontsper die getabuleerde profiel-funksie.';
$string['enablethiscoursedesc'] = 'Vertoon \'n aftreklys met aktiwiteite uit die huidige kursus.';
$string['enableticker'] = 'Ontsper die nuusflitser op die tuisblad?';
$string['enabletickerc'] = 'Ontsper die nuusflitser op interne bladsye?';
$string['enabletickercdesc'] = 'Merk om die flitser op interne bladsye te ontsper.';
$string['enabletickerdesc'] = 'Merk om die tuisbladflitser te ontsper.';
$string['enabletickermy'] = 'Ontsper die nuusflitser?';
$string['enabletickermydesc'] = 'Merk om die flitser op die \'My Tuiste\'- / \'Paneelbord\'-blaaie te ontsper.';
$string['enabletoolsmenus'] = 'Ontsper hulpmiddelkieslyste';
$string['enabletoolsmenusdesc'] = 'Jy word aangeraai om hierdie af te los as kieslyste weens prestasieredes nie gebruik word nie.';
$string['enablezoom'] = 'Ontsper Zoem';
$string['enablezoomdesc'] = 'Laat gebruikers toe om tussen volskerm en vasgestelde breedte te tokkel.';
$string['events'] = 'Gebeurtenisse';
$string['expandable'] = 'Uitbreibaar';
$string['favicon'] = 'Favicon';
$string['favicondesc'] = 'Laai \'n Favicon op vir gebruik op jou werf.';
$string['fontblockheadercolor'] = 'Fontkleur van blok-hofie';
$string['fontblockheadercolordesc'] = 'Stel die kleur van die hofiefont moodle-blokke, gebruik html-hex-kode. Let daarop dat dit die ikoonkleur ook affekteer.';
$string['fontblockheadersize'] = 'Fontgrootte van blokke hofie';
$string['fontblockheadersizedesc'] = 'Stel die fontgrootte wat in die moodle blokopskrif gebruik word. Kies \'n waarde uit die lys.';
$string['fontblockheaderweight'] = 'Fontgewig van blokopskrif';
$string['fontblockheaderweightdesc'] = 'Stel die gewig van die font wat in die moodle blokopskrif gebruik word. Kies \'n waarde tussen 100 en 900, afhangend van watter font gekies is.';
$string['fontdesc'] = 'Jy kan die <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> wat jy in die tema wil gebruik, kies. Kies die substel wat nodig is (Latyn is altyd ingesluit) en voer die korrekte fontgewig in, anders sal die font nie vertoon nie.';
$string['fontheadercolor'] = 'Fontkleur van opskrifte';
$string['fontheadercolordesc'] = 'Stel die kleur van die opskriffont in die tema, gebruik html-hex-kode.';
$string['fontheadername'] = 'Opskriffont';
$string['fontheadernamedesc'] = 'Stel die verstek font, \'sans-serif\', of <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> wat in die teks en blokopskrifte gebruik word.';
$string['fontheaderweight'] = 'Fontgewig van opskrifte';
$string['fontheaderweightdesc'] = 'Fontgewig wat vir die opskrifte in die werf gebruik word. Kies \'n waarde tussen 100 en 900, afhangend van watter font gekies is.';
$string['fontname'] = 'Hooffont';
$string['fontnamedesc'] = 'Kies die verstek font, \'sans-serif\', of <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> wat in die werf gebruik word.';
$string['fontsettings'] = 'Fonte';
$string['fontsettingsheading'] = 'Wysig die fonte wat deur die tema gebruik word.';
$string['fontsize'] = 'Grootte van die hooffont';
$string['fontsizedesc'] = 'Stel die verstek fontgrootte (in persentasie) wat deur die hele werf gebruik word.';
$string['fontsubset'] = 'Google-fonte substel';
$string['fontsubsetdesc'] = 'Kies ander karaktersubstel as Latyn wat op al die fonte toegepas kan word. Latyn-substel is reeds by die verstek ingesluit.';
$string['fonttitlecolor'] = 'Fontkleur van werf- / kursustitel';
$string['fonttitlecolordesc'] = 'Stel die kleur van die werftitel- en kursustitelfont in die tema, gebruik html-hex-kode.';
$string['fonttitlename'] = 'Font van Werf- / Kursustitel';
$string['fonttitlenamedesc'] = 'Kies die verstek font, \'sans-serif\', of <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> wat in die werf- en kursustitels gebruik word.';
$string['fonttitlesize'] = 'Fontgrootte van werf- /kursustitel';
$string['fonttitlesizedesc'] = 'Fontgrootte van die werf- en kursustitel wat in die werf gebruik word. Kies \'n waarde uit die lys.';
$string['fonttitleweight'] = 'Fontgewig van werf- / kursustitel';
$string['fonttitleweightdesc'] = 'Stel die fontgewig wat in die werf- en kursustitels gebruik word. Kies \'n waarde tussen 100 en 900, afhangend van watter font gekies is.';
$string['fontweight'] = 'Gewig van hooffont';
$string['fontweightdesc'] = 'Fontgewig wat in werf gebruik word. Kies \'n waarde tussen 100 en 900, afhangend van watter font gekies is.';
$string['footerbkcolor'] = 'Agtergrondkleur van onderskrif';
$string['footerbkcolordesc'] = 'Stel die onderskrif se agtergrondkleur.';
$string['footerblocksplacement'] = 'Blokplasing van onderskrif';
$string['footerblocksplacement1'] = 'Regoor die werf';
$string['footerblocksplacement2'] = 'Slegs Tuisblad';
$string['footerblocksplacement3'] = 'Nooit';
$string['footerblocksplacementdesc'] = 'Beheer waar die boonste onderskrifblokke vertoon word. Regoor die werf is die verstek.';
$string['footercontent'] = 'Inhoud van onderskrifafdeling';
$string['footercontentdesc'] = 'Voeg inhoud by onderskrifafdeling.';
$string['footerdesc'] = 'Voeg \'n titel vir onderskrifafdeling by.';
$string['footerheader'] = 'Titel van onderskrifafdeling';
$string['footerlayoutrow'] = 'Onderskrifuitlegbouer';
$string['footerlayoutrowdesc'] = 'Ontwerp jou uitleg vir onderskrifblokareas.';
$string['footerlinkcolor'] = 'Skakelkleur van onderskrifblokke';
$string['footerlinkcolordesc'] = 'Skakelkleur van onderskrifblokke';
$string['footersettings'] = 'Onderskrif';
$string['footersettingsheading'] = 'Stel die inhoud wat in die onderskrif vertoon moet word. Sien die uitleg <a href="./../theme/adaptable/pix/layout.png" target="_blank"> hier</a>';
$string['footertextcolor'] = 'Tekskleur van onderskrif';
$string['footertextcolor2'] = 'Tekskleur van onderste onderskrif';
$string['footertextcolor2desc'] = 'Tekskleur van onderste onderskrif.';
$string['footertextcolordesc'] = 'Die kleur van die teks in die onderskrif, gebruik html-hex-kode.';
$string['footnote'] = 'Voetnoot';
$string['footnotedesc'] = 'Voeg teks by die onderskrif.';
$string['forumbodybackgroundcolor'] = 'Agtergrond van liggaam van forumplasing';
$string['forumbodybackgroundcolordesc'] = 'Agtergrondkleur van \'n forumplasing.';
$string['forumheaderbackgroundcolor'] = 'Agtergrond van opskrif van forumplasing';
$string['forumheaderbackgroundcolordesc'] = 'Agtergrondkleur van \'n forumplasing.';
$string['frnt-footer'] = 'Blokke in hierdie area sal slegs aan admingebruikers sigbaar wees.';
$string['frontpageblocksenabled'] = 'Ontsper doelgemaakte blokarea op die voorblad';
$string['frontpageblocksenableddesc'] = 'Jy kan doelgemaakte blokareas op die voorblad ontsper/versper. Jy kan dan blokke na die areas wat jy geskep het, sleep en laat los.';
$string['frontpageblocksettings'] = 'Bemarkingsblokke';
$string['frontpagecoursesettings'] = 'Kursuslys op Voorblad';
$string['frontpagedesc'] = 'Konfigureer die manier waarop die kursusbokse op die voorblad uitgebeeld word.';
$string['frontpagemarketenabled'] = 'Ontsper bemarkingsblokke';
$string['frontpagemarketenableddesc'] = 'Stel die voorblad se bemarkingsblokke.';
$string['frontpagemarketoption'] = 'Kies styl van bemarkingsblokke';
$string['frontpagemarketoptiondesc'] = 'Jy kan verskillende style op bemarkingsblokke toepas.
Let wel: BCU-styl is ontwerp om met prente aan die bokant van die blok te werk.';
$string['frontpagenumbertiles'] = 'Aantal kursusteëls per ry';
$string['frontpagenumbertilesdesc'] = 'Aantal kursusteëls om per ry in die kursuslys op die voorblad te vertoon.';
$string['frontpagerenderer'] = 'Kursusbokse op die voorblad';
$string['frontpagerendererdefaultimage'] = 'Verstek kursusprent';
$string['frontpagerendererdefaultimagedesc'] = 'Die verstek prent om te gebruik wanneer geen kursusprent gevind kan word nie (slegs van toepassing op Teëls met oorlegging).';
$string['frontpagerendererdesc'] = 'Beheer die manier waarop die kursusbokse op die voorblad uitgebeeld word.';
$string['frontpagerendereroption1'] = 'Teëls';
$string['frontpagerendereroption2'] = 'Teëls met oorlegging';
$string['frontpagerendereroption3'] = 'Moodle verstek';
$string['frontpagerendereroption4'] = 'Coventry-teëls';
$string['frontpagesettingsheading'] = 'Uitbeelding van voorblad';
$string['frontpageslidersettings'] = 'Voorbladglyer';
$string['frontpagetiles1'] = '1 teël';
$string['frontpagetiles2'] = '2 teëls';
$string['frontpagetiles3'] = '3 teëls';
$string['frontpagetiles4'] = '4 teëls';
$string['frontpagetiles6'] = '6 teëls';
$string['fullscreen'] = 'Volskerm';
$string['fullscreenwidth'] = 'Volskermbreedte';
$string['fullscreenwidthdesc'] = 'Stel die maks. breedte van die tema wanneer dit in volskermmodus/zoem is.';
$string['future'] = 'Toekoms';
$string['gdprbutton'] = 'Dataretensie-opsomming-knoppie';
$string['gdprbuttondesc'] = 'Vertoon die dataretensie-opsomming-knoppie in die onderskrif.';
$string['googleanalyticssettings'] = 'Google Analytics';
$string['googleanalyticssettingsdesc'] = 'Jy kan veelvuldige kodes vir Google Analytics opstel en gebruikerprofielvelde daarmee teiken.';
$string['googleanalyticssettingsheading'] = 'Stel Google Analytics vir jou werf op.';
$string['headerbgimage'] = 'Agtergrondprent';
$string['headerbgimagedesc'] = 'Stel \'n agtergrondprent in die opskrif. Minimum grootte is 1600 x 180 px (1900 x 180 px word aanbeveel). Die prent bedek die volledige opskrif. Jy kan \'n kleur in \'Agtergrondkleur van boonste opskrif\' byvoeg, of gebruik <i>transparent</i> om die agtergrondprent te vertoon. In daardie geval moet jy die tekskleur wysig om korrek oor die prent te vertoon.';
$string['headerdesc'] = 'Laai jou favicon, logo op, stel intekenvorm in opskrif, pas titels in opskrif aan.<br/>Jy kan die fontgrootte en -style van titels stel in die \'<a href="./../admin/settings.php?section=theme_adaptable_font">fonts</a>\' verstellingsblad stel.';
$string['headernavbarhelpheading'] = 'Hulpskakels en -opsies';
$string['headernavbarhelpheadingdesc'] = 'Opsies vir hulpkieslysskakels';
$string['headernavbarmycoursesheading'] = 'My Kursusse-kieslys';
$string['headernavbarmycoursesheadingdesc'] = 'Alle opsies vir die \'My Kursusse\' (\'My werwe\') kieslysopsie wat die lys van huidige gebruikers se kursusse vertoon.';
$string['headernavbarthiscourseheading'] = 'Hierdie Kursus-kieslys';
$string['headernavbarthiscourseheadingdesc'] = 'In hierdie kieslys kan die student direkte toegang verkry tot al die kursusaktiwiteite en die deelnemerslys, asook hul punte.';
$string['headersettings'] = 'Opskrif';
$string['headersettingsheading'] = 'Doelmaak die opskrif van hierdie tema. Sien die uitleg \'<a href="./../theme/adaptable/pix/layout.png" target="_blank">hier</a>\'.';
$string['headerstyle'] = 'Opskrifstyl';
$string['headerstyle1'] = 'Opskrif 1 (oorspronklike 3-ry opskrif)';
$string['headerstyle2'] = 'Opskrif 2 (2-ry opskrif)';
$string['headerstyledesc'] = 'Kies die opskrifstyl. Opskrif 1 verwys na die oorspronklike 3-ry Adaptable-opskrif. Opskrif 2 is \'n minimale 2-ry opskrif. Let daarop dat, wanneer Opskrif 2 vir die verstelling "Gebruik Soekboks of Sosiale Ikone" gebruik word, dit altyd \'n soekboks sal wees.';
$string['headerstyleheading'] = 'Verstellings van Opskrifstyl';
$string['headerstyleheadingdesc'] = 'Adaptable ondersteun twee opskrifstyle, nl. die oorspronklike 3-ry opskrif en \'n nuwe, vereenvoudigde 2-ry opskrif.<br/>Wees bewus dat, as jy na die nuwer 2-ry opskrif verander, jy <strong>NIE</strong>:<br /><ol><li>Sosiale ikone in die opskrif sal kan vertoon nie.</li><li>Vertoon die werflogo op die mobiele toestelle.</li><ol>';
$string['help'] = 'Hulp';
$string['helplinkscount'] = 'Aantal hulpskakels';
$string['helplinkscountdesc'] = 'Stel die aantal hulpskakels wat jy by die hoof navigasiestafie wil voeg.';
$string['helplinktitle'] = 'Hulpskakel \'{$a->number}\' titel';
$string['helplinktitledesc'] = 'Die titel van hulpskakel \'{$a->number}\' in die navstafie. Indien leeg, word \'Hulp {$a->number}\' as verstek gebruik.';
$string['helpprofilefield'] = 'Hulpskakel \'{$a->number}\' doelgemaakte profielveld (opsioneel)';
$string['helpprofilefielddesc'] = 'Voeg hulpskakel \'{$a->number}\' toegangsreël by deur doelgemaakte profielveld, bv. gebruikertipe=student.';
$string['helptarget'] = 'Hulpteiken';
$string['helptargetdesc'] = 'Wil jy die hulpskakel in \'n nuwe venster oopmaak?';
$string['helptitle'] = 'Hulp {$a->number}';
$string['hiddencourses'] = 'Versteekte kursusse';
$string['hiddenfromview'] = 'Buite sig versteek';
$string['hide'] = 'Versteek';
$string['hidefootersocial'] = 'Vertoon sosiale ikone';
$string['hidefootersocialdesc'] = 'Vertoon sosiale ikone in die onderskrif onder die blokke.';
$string['hideinforum'] = 'Versteek hulp en hulpmiddels in forums';
$string['hideinforumdesc'] = 'Wanneer vasgestelde breedte en alle kieslysopsies gebruik word, loop die forum se soekboks oor in die lyn daaronder. Deur hierdie opsie aan te skakel, sal hulpmiddels en hulpkieslysitems in forums versteek word, wat toelaat dat dit reg vertoon.';
$string['home'] = 'Tuis';
$string['homebk'] = 'Agtergrondprent van voorblad';
$string['homebkdesc'] = 'Laai \'n prent op wat as agtergrondprent op die tuisblad sal dien.';
$string['infobox'] = 'Inligtingsboks van voorblad';
$string['infobox2'] = 'Sekondêre inligtingsboks van voorblad';
$string['infobox2desc'] = 'Sekondêre inligtingsboks van voorblad (sien die <a href="./../theme/adaptable/README.txt" target="_blank">LEESMY</a> dokument vir addisionele inligting en wenke).<br><br><strong>Let wel: </strong><i>Hierdie element word slegs gebruik vir versoenbaarheid met BCU en sal in komende weergawes verwyder word.</i>';
$string['infoboxdesc'] = 'Inligtingsblok-HTML van voorblad (sien die <a href="./../theme/adaptable/README.txt" target="_blank">LEESMY</a> dokument vir addisionele inligting en wenke.<br><br><strong>Let wel: </strong><i>Hierdie element word slegs gebruik vir versoenbaarheid met BCU en sal in komende weergawes verwyder word.</i>';
$string['infoboxfullscreen'] = 'Maak inligtingsboks volskerm';
$string['infoboxfullscreendesc'] = 'Deur hierdie opsie aan te skakel, sal die inligtingsboks volskerm gemaak word.';
$string['infoiconcolor'] = 'Kleur van Hulpikoon';
$string['infoiconcolordesc'] = 'Stel die kleur van die inligting-/hulpikoon wat deur nutswenke gebruik word.';
$string['informationsettingsdesc'] = 'Inligting oor die Adaptable-tema.';
$string['inprogress'] = 'Aan die gang';
$string['introboxbackgroundcolor'] = 'Agtergrondkleur van Inleidingsboks';
$string['introboxbackgroundcolordesc'] = 'Agtergrondkleur van die inleidingsboks (belig aktiwiteitbeskrywing) wat in forums en ander aktiwiteite gebruik word.';
$string['jssectionrestricteddashboardonly'] = 'Sluit javateks slegs op paneelbordblad in';
$string['jssectionrestricteddashboardonlydesc'] = 'Vertoon die javateks slegs op die paneelbordblad. Andersins word hierdie regoor die werf vertoon.';
$string['jssectionrestrictedprofilefield'] = 'Javeteksafdeling doelgemaakte profielveld';
$string['jssectionrestrictedprofilefielddesc'] = 'Vertoon die javateks SLEGS wanneer gebruiker met hierdie doelgemaakte profielveldwaarde ooreenstem, bv. fakulteit=fbl.';
$string['jumpto'] = 'Spring na ...';
$string['landscape'] = 'Landskap';
$string['layoutaddcontent'] = 'Tevrede met jou uitleg? Voeg nou inhoud by jou blokke:';
$string['layoutaddcontentdesc1'] = 'Jy het gekonfigureer';
$string['layoutaddcontentdesc2'] = 'bemarkingsblokke. As jy tevrede met hierdie uitleg is, voeg inhoud by die blokke hieronder.<br/>As jy nie tevrede is nie, gebruik die uitlegbouer hierbo om veranderinge aan te bring.';
$string['layoutcheck'] = 'Kontroleer jou uitleg';
$string['layoutcheckdesc'] = 'Gebruik die hulpmiddel hieronder om die aantal blokke wat jy gebruik het, te kontroleer, en \'n voorstelling van jou nuwe uitleg te sien.';
$string['layoutcount1'] = 'Jy kan \'n maksimum stel van';
$string['layoutcount2'] = 'blokareas. Jy gebruik tans:';
$string['layoutdesc'] = 'Stel die verstek uitleg wat gebruikers sien.';
$string['layoutsettings'] = 'Uitleg';
$string['layoutsettingsheading'] = 'Beheer aspekte van die werf se uitleg';
$string['leftblocks'] = 'Linkerkant';
$string['linkhover'] = 'Skakel-sweef-kleur';
$string['linkhoverdesc'] = 'Stel die kleur van skakels (met sweef) in die tema, gebruik html-hex-kode.';
$string['linksmenu'] = 'Skakelkieslys';
$string['loadingcolor'] = 'Laaikleur';
$string['loadingcolordesc'] = 'Die kleur van die laaistafie boaan die bladsy.';
$string['loginbgimage'] = 'Agtergrondprent';
$string['loginbgimagedesc'] = 'Voer \'n agtergrondprent by die volgrootte bladsy.';
$string['loginbgopacity'] = 'Opskrif van intekenblad, navstafie, intekenboks en onderskrifagtergrond se deursigtigheid wanneer daar \'n agtergrondprent is.';
$string['loginbgopacitydesc'] = 'Deursigtigheid van intekenagtergrond van die opskrif, navstafie, intekenboks en onderskrif wanneer daar \'n agtergrondprent is.';
$string['loginbgstyle'] = 'Styl van intekenagtergrond';
$string['loginbgstyledesc'] = 'Kies die styl van die opgelaaide prent.';
$string['logindesc'] = 'Doelmaak die intekenblad deur \'n agtergrondprent en teks bo en onder die intekenboks by te voeg.';
$string['loginfooter'] = 'Onderskrif van intekenblad';
$string['loginfooterdesc'] = 'Vertoon die onderskrif van intekenblad.';
$string['loginheader'] = 'Intekenbladhofie';
$string['loginheaderdesc'] = 'Vertoon die intekenbladhofie.';
$string['loginplaceholder'] = 'Gebruikernaam';
$string['loginsettings'] = 'Intekenblad';
$string['loginsettingsheading'] = 'Doelmaak die intekenblad.';
$string['logintextboxbottom'] = 'Onderste teksboks';
$string['logintextboxbottomdesc'] = 'Voeg \'n doelgemaakte teksboks onder die intekenboks in.';
$string['logintextboxtop'] = 'Boonste teksboks';
$string['logintextboxtopdesc'] = 'Voeg \'n doelgemaakte teks bo die intekenboks in.';
$string['logintextbutton'] = 'Teken in';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Laai \'n logo op vir gebruik op jou werf. Aanbevole grootte is 200 px by 80 px.';
$string['maincoursepage'] = 'Hoof kursusblad';
$string['market'] = 'Bemarkingsblok';
$string['marketblockbordercolor'] = 'Lynkleur van bemarkingsblok se rant';
$string['marketblockbordercolordesc'] = 'Stel die lynkleur van die bemarkingsblok se rant.';
$string['marketblocksbackgroundcolor'] = 'Agtergrondkleur van bemarkingsblokke-area';
$string['marketblocksbackgroundcolordesc'] = 'Stel die agtergrondkleur van die bemarkingsblokke-area.';
$string['marketdesc'] = 'Voeg html vir bemarkingsblok by (sien die <a href="./../theme/adaptable/README.txt" target="_blank">LEESMY</a> dokument vir addisionele inligting en wenke).';
$string['marketingbuilderdesc'] = 'Gebruik die hulpmiddel hieronder om jou bemarkingsblokke op te stel. Wanneer dit gedefinieer is, sal die blokverstellings laer af op die bladsy vertoon word.';
$string['marketingbuilderheading'] = 'Uitlegbouer vir bemarkingsblokke';
$string['marketingdesc'] = 'Daar is twee volbreedte inligtingsbokse met verskillende style wat jy kan gebruik.<br/>Daarby is daar \'n uitlegbouer wat jou toelaat om te besluit hoeveel blokke jy nodig het en om jou eie uitleg te definieer. Sien asseblief die <a href="./../theme/adaptable/README.txt" target="_blank">LEESMY</a> dokument wat met hierdie tema gepaardgaan.';
$string['marketingsettings'] = 'Bemarkingsblokke';
$string['marketingsettingsheading'] = 'Doelmaak die bemarkingsblokke wat op die voorblad verskyn. Sien die uitleg <a href="./../theme/adaptable/pix/layout.png" target="_blank"> hier</a>';
$string['marketlayoutrow'] = 'Bemarkingsblok-ry';
$string['marketlayoutrowdesc'] = 'Voeg by / stel uitleg van bemarkingsblok-ry op voorblad';
$string['menubkcolor'] = 'Agtergrondkleur van hoofkieslys';
$string['menubkcolordesc'] = 'Stel \'n agtergrondkleur vir die hoofkieslys.';
$string['menubordercolor'] = 'Onderste rantkleur van hoofkieslys';
$string['menubordercolordesc'] = 'Stel \'n onderste rantkleur vir die hoofkieslys.';
$string['menufontcolor'] = 'Fontkleur van hoofkieslys';
$string['menufontcolordesc'] = 'Stel \'n fontkleur vir die hoofkieslys.';
$string['menufontpadding'] = 'Opvulling vir navigasie-items';
$string['menufontpaddingdesc'] = 'Stel die opvulling van die items in die hoof navigasiestafie.';
$string['menufontsize'] = 'Fontgrootte van navigasiestafie';
$string['menufontsizedesc'] = 'Stel die grootte van die font wat in die hoof navigasiestafie gebruik word.';
$string['menuoverrideprofilefield'] = 'Doelgemaakte profielveldnaam';
$string['menuoverrideprofilefielddefault'] = 'boonstekieslysverstellings';
$string['menuoverrideprofilefielddesc'] = 'Die naam van die doelgemaakte profiel "lys" veld wat vir gebruikeroorheersing gebruik word.';
$string['menusdesc'] = '';
$string['menusession'] = 'Berg toegangsbesonderhede in sessie';
$string['menusessiondesc'] = 'Om prestasieredes word daar aanbeveel dat jy dit ontsper. Jy kan dit moontlik wil versper tydens toetsing.';
$string['menusessionttl'] = 'Minute om toegangsreëls in sessie te berg';
$string['menusessionttldesc'] = 'Aantal minute waarna kieslystoegangsreëls in die gebruikersessie verfris word.';
$string['menusettings'] = 'Hofiekieslyste';
$string['menusettingsheading'] = 'Doelmaak kieslyste in die boonste hofie van hierdie tema.';
$string['menusheading'] = 'Konfigureer navigasie vir skakelkieslyste in die boonste hofie.';
$string['menusheadingvisibility'] = 'Algemene verstellings vir sigbaarheid van boonste kieslys';
$string['menusheadingvisibilitydesc'] = 'Die volgende verstellings laat jou toe om te beheer waar kieslyste verskyn en laat gebruikers opsioneel toe om hul verstellings te doelmaak.';
$string['menuslinkicon'] = 'Skakelskieslysikoon';
$string['menuslinkicondesc'] = 'Kies \'n doelgemaakte font awesome-ikoon.';
$string['menuslinkright'] = 'Vertoon kieslysteskakel regs bo';
$string['menuslinkrightdesc'] = 'Indien gemerk, vertoon die skakel na die kieslyste regs bo, langs die boodskappe-kieslys.';
$string['menustitledesc'] = 'Hulpmiddelskieslyste (in navstafie) en boonste kieslyste (boonste hofie) kan beperk word, gebaseer op doelgemaakte profielvelde (opsioneel). Om \'n beperking by te voeg, voer die naam van die profielveld en die verwagte waarde in. Kieslysstruktuur volg die algemene Moodle-formaat:<br/><pre>
Moodle community|https://moodle.org
-Moodle free support|https://moodle.org/support
-Moodle development|https://moodle.org/development
--Moodle Docs|http://docs.moodle.org|Moodle Docs
--German Moodle Docs|http://docs.moodle.org/de|Documentation in German|de
Moodle.com|http://moodle.com/
</pre>';
$string['menuuseroverride'] = 'Laat gebruikeroorheenskryf toe';
$string['menuuseroverridedesc'] = 'Hierdie verstellings kan gebruik word om aan gebruikers beheer te gee oor waar kieslyste verskyn via \'n doelgemaakte profielveld. Om hierdie opsie te gebruik, sal jy \'n doelgemaakte profielveld in die "lys" formaat moet skep, met waardes in die ooreenstemmende volgorde:<br/><pre>1. Regoor werf (die eerste item in die lys sal vir kieslyssigbaarheid regoor die werf wees)
2. Slegs Tuisblaaie (die tweede item op die lys sal sigbaarheid stel na slegs werf / tuisblaaie)
3. Versteek (die derde waarde in die lys sal kieslyste heeltemal versteek)</pre>
Jy behoort NIE die "Versper Kieslyste op Kursusbladsye"-opsie saam met profielveldverstellings te gebruik nie; stel eerder die verstek waarde na jou "Slegs Tuisblaaie"-invoer wanneer jy jou profielveldlys opstel.

Let wel: Gebruikers sal uit Moodle en weer in moet teken vir hierdie verandering om in werking te tree; jy kan moontlik \'n nota in die doelgemaakte profielveld wil byvoeg om dit te verduidelik.';
$string['messagepopupbackground'] = 'Agtergrondkleur van Boodskappe-opspring';
$string['messagepopupbackgrounddesc'] = 'Stel die agtergrondkleur van boodskappe-opspringhofie.';
$string['messagepopupcolor'] = 'Tekskleur van Boodskappe-opspring';
$string['messagepopupcolordesc'] = 'Stel die tekskleur van boodskappe-opspringhofie.';
$string['messagingbackgroundcolor'] = 'Agtergrondkleur van Boodskappe-hoofvenster';
$string['messagingbackgroundcolordesc'] = 'Stel die agtergrondkleur vir die hoofkletsvenster van boodskappe.';
$string['mobilemenubkcolor'] = 'Agtergrondkleur van mobiele kieslys';
$string['mobilemenubkcolordesc'] = 'Stel die agtergrondkleur van hoofkieslys op mobiele toestelle (toegevou).';
$string['moodledocs'] = 'Moodle-dokumenteskakel';
$string['moodledocsdesc'] = 'Vertoon die Moodle-dokumentskakel in die onderskrif.';
$string['more'] = 'Meer';
$string['myblogs'] = 'My Blogs';
$string['mycoursesmenulimit'] = 'My Kursusse kieslyslimiet';
$string['mycoursesmenulimitdesc'] = 'Verstel die maks. aantal kursusse wat in die My Kursusse-aftreklys kan verskyn. 0 sal alle kursusse vertoon.';
$string['mysites'] = 'My Kursusse';
$string['mysitesdisabled'] = 'Versper';
$string['mysitesexclude'] = 'Ontsper, behalwe versteekte kursusse';
$string['mysitesinclude'] = 'Ontsper, met versteekte kursusse';
$string['mysitesmaxlength'] = 'My Kursusse maks. lengte';
$string['mysitesmaxlengthdesc'] = 'Verstel die maks. lengte van kursusname in die My Kursusse-aftreklys om vir jou font te optimaliseer.';
$string['mysitesmenudisplay'] = 'My Kursusse Kieslysvertoon';
$string['mysitesmenudisplaydesc'] = 'Kies watter teks om vir \'n kieslysitem en met sweef te vertoon.';
$string['mysitesmenudisplayfullnamefullnameonhover'] = 'Vertoon volledige kursustitel en volledige titel met sweef.';
$string['mysitesmenudisplayfullnamenohover'] = 'Vertoon volledige kursustitel en geen teks met sweef.';
$string['mysitesmenudisplayshortcodefullnameonhover'] = 'Vertoon kort kode en volledige kursusnaam met sweef.';
$string['mysitesmenudisplayshortcodenohover'] = 'Vertoon kort kode en geen teks met sweef.';
$string['mysitessortoverride'] = 'Ontsper doelgemaakte sortering vir My Kursusse';
$string['mysitessortoverridedesc'] = 'Gebruik doelgemaakte profielvelde of generiese stringe (jaar, ens.) om vorige kursusse in subkieslys toe te vou.';
$string['mysitessortoverridefield'] = 'My Kursusse Doelgemaakte Profielveld(e) of Stringe';
$string['mysitessortoverridefielddesc'] = 'Komma-geskeide lys profielvelde of stringe waarvoor in kortkodes van kursus gekontroleer moet word.';
$string['mysitessortoverridelast'] = 'Tyd wat laaste toegang verkry is of begin van inskrywing indien nooit toegang verkry is nie';
$string['mysitessortoverridemyoverview'] = 'Gebruik lys uit My Oorsig';
$string['mysitessortoverrideoff'] = 'Vertoon alle ingeskrewe kursusse in enkele, plat lys';
$string['mysitessortoverrideprofilefields'] = 'Vertoon kursusse wat in profielvelde, in eerste lys, gevind is, ander in subkieslys.';
$string['mysitessortoverrideprofilefieldscohort'] = 'Vertoon kursusse wat in profielvelde gevind is, + kohorte in eerste lys, ander in subkieslys';
$string['mysitessortoverridestrings'] = 'Vertoon ingeskrewe met stringe in eerste lys, ander in subkieslys';
$string['navbarcachetime'] = 'Navstafie-kasgeheuetyd';
$string['navbarcachetimedesc'] = 'Die aantal minute waarvoor die navigasiestafie gekas word.';
$string['navbardisplayicons'] = 'Vertoon ikone';
$string['navbardisplayiconsdesc'] = 'Vertoon ikone langs opskrifte van hoofkieslys';
$string['navbardropdownborderradius'] = 'Rantradius van Aftrekkieslys';
$string['navbardropdownborderradiusdesc'] = 'Beheer die rantradius vir aftrekkieslyste (bv. geronde hoeke).';
$string['navbardropdownhovercolor'] = 'Agtergrondsweefkleur van aftrekkieslys';
$string['navbardropdownhovercolordesc'] = 'Agtergrondkleur van aftrekkieslys wanneer oor kieslysitems gesweef word.';
$string['navbardropdowntextcolor'] = 'Tekskleur van Aftrekkieslys';
$string['navbardropdowntextcolordesc'] = 'Tekskleur van Aftrekkieslysitem.';
$string['navbardropdowntexthovercolor'] = 'Tekssweefkleur van aftrekkieslys';
$string['navbardropdowntexthovercolordesc'] = 'Tekskleur van aftrekkieslys wanneer oor kieslysitems gesweef word.';
$string['navbardropdowntransitiontime'] = 'Navstafie-oorgangstyd';
$string['navbardropdowntransitiontimedesc'] = 'Navstafie-oorgangeffektyd in sekondes. Bied \'n indoof animasie-effek wanneer daar oor \'n kieslys gesweef word wat subkieslyste het.';
$string['navbarlinksettingsdesc'] = 'Laat toe dat jy die skakels beheer wat op die navigasiestafie verskyn.';
$string['navbarlinksettingsheading'] = 'Doelmaak die skakels op die navigasiestafie';
$string['navbarlinkssettings'] = 'Navstafieskakels';
$string['navbarsettings'] = 'Navstafie';
$string['navbarsettingsheading'] = 'Doelmaak die navigasiestafie';
$string['navbarstyles'] = 'Navstafiestyle';
$string['navbarstylesdesc'] = 'Laat toe dat jy die style van die elemente wat op die navigasiestafie verskyn, beheer.';
$string['navbarstylesheading'] = 'Doelmaak die navigasiestafiestyle';
$string['newmenu'] = 'Boonste kieslysaftrek';
$string['newmenudesc'] = 'Konfigureer skakels om onder \'n boonste hofiekieslys vertoon te word.';
$string['newmenufield'] = 'Doelgemaakte profielveldnaam=Waarde (opsioneel)';
$string['newmenufielddesc'] = 'Voeg toegangsreël vir doelgemaakte profielveld by, bv. gebruikertipe=student.';
$string['newmenuheading'] = 'Boonste kieslys';
$string['newmenurequirelogin'] = 'Vereis intekening';
$string['newmenurequirelogindesc'] = 'Indien ontsper, sal hierdie kieslys slegs aan ingetekende gebruikers sigbaar wees.';
$string['newmenutitle'] = 'Boonstel kieslystitel';
$string['newmenutitledefault'] = 'Kieslys';
$string['newmenutitledesc'] = 'Die titel van die aftreklys wat in die hofie van jou werf sal verskyn.';
$string['newstickercount'] = 'Aantal nuusflitserafdelings';
$string['newstickercountdesc'] = 'Definieer veelvuldige nuusflitserafdelings met toegangsreëls om verskillende gehore te teiken.';
$string['nextactivity'] = 'Volgende aktiwiteit';
$string['nextsection'] = 'Volgende afdeling';
$string['noenrolments'] = 'Geen inskrywings gevind nie';
$string['none'] = 'Geen';
$string['normal'] = 'Vasgestelde breedte';
$string['nostyle'] = 'Geen styl';
$string['originaltemplatepreview'] = 'Oorspronklike / oorheengeskrewe temadokumentvoorskou';
$string['originaltemplatesource'] = 'Oorspronklike / oorheengeskrewe temadokumentbron';
$string['overriddentemplate'] = 'Oorheengeskrewe templaat: {$a}';
$string['overriddentemplatedesc'] = 'Indien gestel, sal die teks hier as die templaat \'{$a}\' gebruik word. Om te verseker dat die voorskou funksioneer, moet die standaard voorbeeldkonteks in JSON-formaat wees.';
$string['overriddentemplatenopreview'] = 'Geen voorskou weens ontbrekende JSON-voorbeeld';
$string['overriddentemplatepreview'] = 'Oorheengeskrewe voorskou word gestel';
$string['overridetemplate'] = 'Skryf templaat oorheen: {$a}';
$string['pageheaderalternative'] = 'Alternatief';
$string['pageheaderlayout'] = 'Uitleg van bladsyhofie';
$string['pageheaderlayoutdesc'] = 'Die uitleg van bladsyhofie. Affekteer slegs hofiestyl een. Hofiestyl twee bly onverander. Let wel: \'Alternative\' kan sonder waarskuwing verander en is steeds in die ontwikkelingsfase.';
$string['pageheaderoriginal'] = 'Oorspronklik';
$string['passwordplaceholder'] = 'Wagwoord';
$string['past'] = 'Vorige';
$string['pastcourses'] = 'Vorige kursusse';
$string['people'] = 'Deelnemers';
$string['piwikenabled'] = 'Ontsper';
$string['piwikenableddesc'] = 'Ontsper Matomo-sporing vir Moodle';
$string['piwikimagetrack'] = 'Prentsporing';
$string['piwikimagetrackdesc'] = 'Ontsper prentsporing vir Moodle vir blaaiers waarvan JavaScript versper is.';
$string['piwiksettings'] = 'Matomo (voorheen Piwik) Analytics';
$string['piwiksettingsdesc'] = 'Genereer skoon URL vir gevorderde sporing.';
$string['piwiksettingsheading'] = 'Stel Matomo op';
$string['piwiksiteid'] = 'Werf-ID';
$string['piwiksiteiddesc'] = 'Voer jou Werf-ID in.';
$string['piwiksiteurl'] = 'Matomo-URL';
$string['piwiksiteurldesc'] = 'Voer jou Matomo Analytics-URL in sonder http(s) of \'n agterste skuinsstreep.';
$string['piwiktrackadmin'] = 'Sporing van admins';
$string['piwiktrackadmindesc'] = 'Ontsper sporing van admingebruikers (nie aanbeveel nie).';
$string['pluginname'] = 'Adaptable';
$string['portrait'] = 'Portret';
$string['previousactivity'] = 'Vorige aktiwiteit';
$string['previoussection'] = 'Vorige afdeling';
$string['printbodyfontsize'] = 'Fontgrootte van liggaam';
$string['printbodyfontsizedesc'] = 'Stel die fontgrootte van die liggaam.';
$string['printlineheight'] = 'Lynhoogte';
$string['printlineheightdesc'] = 'Stel die lynhoogte.';
$string['printmargin'] = 'Kantlyn';
$string['printmargindesc'] = 'Stel die kantlyn.';
$string['printpageorientation'] = 'Bladsyoriëntasie';
$string['printpageorientationdesc'] = 'Stel oriëntasie van die bladsy na \'Portret\' of \'Landskap\'';
$string['printsettings'] = 'Druk';
$string['printsettingsdesc'] = 'Stel die verstellings om te druk.';
$string['printsettingsheading'] = 'Drukverstellings';
$string['properties'] = 'Voer verstellings in / uit';
$string['propertiesdesc'] = 'In hierdie afdeling kan jy huidige Adaptable temaverstellings (eienskappe) in JSON-formaat in-/uitvoer. Jy kan ook alle huidige verstellings op hierdie Moodle-installasie besigtig.';
$string['propertiesexport'] = 'Voer eienskappe as JSON-string uit';
$string['propertiesproperty'] = 'Eienskap';
$string['propertiesreturn'] = 'Keer terug';
$string['propertiessub'] = 'Huidige temaverstellings';
$string['propertiesvalue'] = 'Waarde';
$string['putpropertiesadded'] = 'Bygevoeg:';
$string['putpropertieschanged'] = 'Verander:';
$string['putpropertiesdesc'] = 'Plak die JSON-string en \'Berg veranderinge\'. Waarskuwing! Valideer nie verstellingswaardes nie en voer \'n \'Skrap alle kasgeheue\' uit.';
$string['putpropertiesfrom'] = 'vanaf';
$string['putpropertiesheading'] = 'Voer temaverstellings in';
$string['putpropertiesignorecti'] = 'Alle kursustitel-prentverstellings word geïgnoreer.';
$string['putpropertiesignored'] = 'Geïgnoreer:';
$string['putpropertiesname'] = 'Voer eienskappe in';
$string['putpropertiesreportfiles'] = 'Onthou om die volgende dokumente na hul verstellings op te laai:';
$string['putpropertiessettingsreport'] = 'Verstellingsverslag:';
$string['putpropertiesunchanged'] = 'Onverander:';
$string['putpropertiesvalue'] = '->';
$string['putpropertyour'] = 'Ons';
$string['putpropertyproperties'] = 'Eienskappe';
$string['putpropertyreport'] = 'Verslag:';
$string['region-course-bottom-a'] = 'Kursusbladsy onderste area 5';
$string['region-course-bottom-b'] = 'Kursusbladsy onderste area 6';
$string['region-course-bottom-c'] = 'Kursusbladsy onderste area 7';
$string['region-course-bottom-d'] = 'Kursusbladsy onderste area 8';
$string['region-course-section-a'] = 'Kursusbladsy aktiwiteiteinde onderste area';
$string['region-course-tab-one-a'] = 'Kursusbladsy oortjie-area 1';
$string['region-course-tab-two-a'] = 'Kursusbladsy oortjie-area 2';
$string['region-course-top-a'] = 'Kursusbladsy boonste area 1';
$string['region-course-top-b'] = 'Kursusbladsy boonste area 2';
$string['region-course-top-c'] = 'Kursusbladsy boonste area 3';
$string['region-course-top-d'] = 'Kursusbladsy boonste area 4';
$string['region-frnt-footer'] = 'Onderskrif';
$string['region-frnt-market-a'] = 'Bladsyarea 1';
$string['region-frnt-market-b'] = 'Bladsyarea 2';
$string['region-frnt-market-c'] = 'Bladsyarea 3';
$string['region-frnt-market-d'] = 'Bladsyarea 4';
$string['region-frnt-market-e'] = 'Bladsyarea 5';
$string['region-frnt-market-f'] = 'Bladsyarea 6';
$string['region-frnt-market-g'] = 'Bladsyarea 7';
$string['region-frnt-market-h'] = 'Bladsyarea 8';
$string['region-frnt-market-i'] = 'Bladsyarea 9';
$string['region-frnt-market-j'] = 'Bladsyarea 10';
$string['region-frnt-market-k'] = 'Bladsyarea 11';
$string['region-frnt-market-l'] = 'Bladsyarea 12';
$string['region-frnt-market-m'] = 'Bladsyarea 13';
$string['region-frnt-market-n'] = 'Bladsyarea 14';
$string['region-frnt-market-o'] = 'Bladsyarea 15';
$string['region-frnt-market-p'] = 'Bladsyarea 16';
$string['region-frnt-market-q'] = 'Bladsyarea 17';
$string['region-frnt-market-r'] = 'Bladsyarea 18';
$string['region-frnt-market-s'] = 'Bladsyarea 19';
$string['region-frnt-market-t'] = 'Bladsyarea 20';
$string['region-my-tab-one-a'] = 'Paneelbordbladsyoortjie area 1';
$string['region-my-tab-two-a'] = 'Paneelbordbladsyoortjie area 2';
$string['region-news-slider-a'] = 'Kursusbladsyglyerarea';
$string['region-side-post'] = 'Regs';
$string['region-side-pre'] = 'Links';
$string['rendereroverlaycolor'] = 'Kleur van oorlegging';
$string['rendereroverlaycolordesc'] = 'Die kleur van die oorlegging, wanneer die "Teëls met oorlegging"-uitbeelder gekies is.';
$string['rendereroverlayfontcolor'] = 'Kleur van oorleggingfont';
$string['rendereroverlayfontcolordesc'] = 'Die kleur van die font, wanneer oor \'n kursusboks met "Teëls met oorlegging"-uitbeelder ontsper gesweef word.';
$string['responsivebreadcrumb'] = 'Breadcrumb-navigasie';
$string['responsivebreadcrumbdesc'] = 'Op watter grootte skerms wil jy Bradcrumb-navigasie laat vertoon?';
$string['responsiveheader'] = 'Hoof hofie';
$string['responsiveheaderdesc'] = 'Op watter grootte skerms wil jy die hoof hofie laat vertoon?<br/>Hierdie verstelling is slegs van toepassing as jy die verstek/oorspronklike 3-ry hofie gebruik.<br/>Om die hofie heeltemal te verwyder, sal ook elemente wat daarbinne bevat word, verwyder:<br/><ul><li>Sosiale Ikone</li><li>Logo</li><li>Werf-/Kursustitel</li></ul>';
$string['responsivelogo'] = 'Logo';
$string['responsivelogodesc'] = 'Op watter grootte skerms wil jy die logo laat vertoon?';
$string['responsivepagefooter'] = 'Onderskrif';
$string['responsivepagefooterdesc'] = 'Op watter grootte skerms wil jy die onderskrif laat vertoon?';
$string['responsivesectionnav'] = 'Aktiwiteit-/afdelingnavigasie';
$string['responsivesectionnavdesc'] = 'Vertoon/versteek die <strong>teks</strong> vir "prev" "next" aktiwiteit/afdelingnavigasie op klein skerms.
        Ons versteek by verstek hierdie teks op kleiner skerms sodat slegs die ikone vir <prev> <next> skakels vertoon en nie die volledige afdeling-/aktiwiteitnaam nie.';
$string['responsivesettings'] = 'Uitlegsensitief';
$string['responsivesettingsdesc'] = 'Hier kan jy die responsiewe gedrag van jou werf beheer (watter elemente op verskillende groottes skerms vertoon).<br/>By verstek is die meeste nienoodsaaklike items op mobiele toestelle versteek, omdat dit gestel is om net op groter skerms te verskyn.<br/>Jy kan elemente op kleiner skerms laat verskyn deur te kies om dit te vertoon by "Ekstraklein" of "Klein skerms".<br/>Om beter te verstaan hoe hierdie verstellings werk, verwys asseblief na die Bootstrap 4-dokumentasie:<br/><br/>https://getbootstrap.com/docs/4.5/utilities/display/<br/><br/>';
$string['responsivesettingsheading'] = 'Beheer hoe jou werf optree op verskillende skermgroottes';
$string['responsiveslider'] = 'Voorbladglyer';
$string['responsivesliderdesc'] = 'Op watter grootte skerms sal jy die Voorbladglyer vertoon wil hê?';
$string['responsivesocial'] = 'Sosiale ikone';
$string['responsivesocialdesc'] = 'Op watter grootte skerms sal jy Sosiale ikone vertoon wil hê?';
$string['responsivesocialsize'] = 'Stel die fontgrootte van die sosiale ikone op Mobiel';
$string['responsivesocialsizedesc'] = 'Vir \'n beter voorkoms moet die grootte 5 px groter as die verlangde werklike grootte wees.';
$string['responsiveticker'] = 'Nuusflitser';
$string['responsivetickerdesc'] = 'Op watter grootte skerms sal jy die Nuusflitser vertoon wil hê?';
$string['rightblocks'] = 'Regterkant';
$string['savebuttontext'] = 'Berg veranderinge';
$string['searchboxpadding'] = 'Soekboksopvulling';
$string['searchboxpaddingdesc'] = 'Stel opvulling bokant soekboks (indien in die plek van sosiale ikone gebruik word) <br />Bv. 5 px 10 px 5 px 10 px (bo, regs, onder, links).<br> Jy kan sosiale ikone stel by die <a href="./../admin/settings.php?section=theme_adaptable_social">Hofie Sosiale</a> verstellingsblad</strong>.';
$string['sectionheadingcolor'] = 'Tekskleur van afdelingopskrif';
$string['sectionheadingcolordesc'] = 'Stel die kleur vir die afdelingsopskrif se teks.';
$string['sections'] = 'Afdelings';
$string['selectionbackground'] = 'Agtergrondkleur van Seleksie';
$string['selectionbackgrounddesc'] = 'Stel die agtergrondkleur wanneer \'n teks in die skerm geselekteer is.';
$string['selectiontext'] = 'Tekskleur van Seleksie';
$string['selectiontextdesc'] = 'Stel die tekskleur wanneer \'n teks in die skerm geselekteer is.';
$string['settingsalertbox'] = 'Waarskuwingsboks';
$string['settingsanalytics'] = 'Analytics';
$string['settingsblockicons'] = 'Ikone';
$string['settingsborders'] = 'Rante';
$string['settingscolors'] = 'Kleure';
$string['settingscourses'] = 'Kursusse';
$string['settingsfonts'] = 'Fonte';
$string['settingsforumheading'] = 'Forum';
$string['settingsinfoboxcolors'] = 'Kleure van Inligtingsboks';
$string['settingsinformation'] = 'Inligting';
$string['settingsmaincolors'] = 'Hoofkleure';
$string['settingsmarketingcolors'] = 'Kleure van Bemarkingsblok';
$string['settingsmobilecolors'] = 'Mobiele kleure';
$string['settingsnavbarcolors'] = 'Kleure van Navigasiestafie (navstafie)';
$string['settingssecondinfoboxcolors'] = 'Kleure van Tweede Inligtingsboks';
$string['settingstopicsweeks'] = 'Onderwerpe / Weke';
$string['show'] = 'Vertoon';
$string['showfooterblocks'] = 'Vertoon onderskrifblokke';
$string['showfooterblocksdesc'] = 'Vertoon / versteek die vier onderskrifblokke wat gekonfigureer kan word.';
$string['shownavigationblockoncoursepage'] = 'Vertoon navigasieblok op kursusblad';
$string['shownavigationblockoncoursepagedesc'] = 'Stel hierdie om die navigasieblok op die kursusblad te vertoon.';
$string['showusername'] = 'Vertoon gebruikersnaam';
$string['showusernamedesc'] = 'Vertoon die gebruikersnaam op die gebruikerkieslys van die navstafie.';
$string['side-post1'] = 'kantstafie in onderskrif';
$string['sidebaricon'] = 'Vertoon / versteek die kantstafie';
$string['sitelinkslabel'] = 'Werfskakels';
$string['sitetitle'] = 'Vertoon werfskakel';
$string['sitetitlecoursesdisabled'] = 'Versper - vertoon slegs kursustitels in kursusbladsye';
$string['sitetitlecoursesenabled'] = 'Ontsper - vertoon werftitel en kursustitels in kursusbladsye';
$string['sitetitlecustom'] = 'Vertoon doelgemaakte werftitel (voer in die \'werftitelteks\'-boks hieronder in)';
$string['sitetitledefault'] = 'Gebruik Moodle-werftitel (werfnaam)';
$string['sitetitledesc'] = 'Vertoon die verstek Moodle-werftitel van <a href="./../admin/settings.php?section=frontpagesettings" target="_blank">Voorbladverstellings</a> of voer \'n doelgemaakte werftitel in die teksboks hieronder in.';
$string['sitetitleoff'] = 'Versper werftitel';
$string['sitetitletext'] = 'Werftitel';
$string['sitetitletextdesc'] = 'Werftitel word in die hofie vertoon. Jy kan enige HTML-merker gebruik en inlynstyle toepas. Dit word aanbeveel dat jy \'n h1 HTML-merker rondom die titel gebruik, eerder as die p-merker wat as verstek bygevoeg word wanneer jy iets in hierdie veld tik.';
$string['slider2h3bgcolor'] = 'Glyer 2 H3 bg kleur';
$string['slider2h3bgcolordesc'] = 'Kies die agtergrondkleur wat jy vir die glyer 2 H3-merker wil hê.';
$string['slider2h3color'] = 'Glyer 2 H3-tekskleur';
$string['slider2h3colordesc'] = 'Kies die tekskleur wat jy vir die glyer 2 H3-merker wil hê.';
$string['slider2h4bgcolor'] = 'Glyer 2 H4 bg kleur';
$string['slider2h4bgcolordesc'] = 'Kies die agtergrondkleur wat jy vir die glyer 2 H4-merker wil hê.';
$string['slider2h4color'] = 'Glyer 2 H4-tekskleur';
$string['slider2h4colordesc'] = 'Kies die tekskleur wat jy vir die glyer 2 H4-merker wil hê.';
$string['slidercaption'] = 'Glyeropskrif';
$string['slidercaptiondesc'] = 'Voeg \'n opskrif vir jou glyer by';
$string['slidercount'] = 'Glyertelling';
$string['slidercountdesc'] = 'Kies hoeveel glyers jy wil byvoeg en <strong>kliek dan BERG</strong> om die toevoervelde te laai.';
$string['sliderenabled'] = 'Ontsper glyer';
$string['sliderenableddesc'] = 'Ontsper \'n glyer boaan jou tuisblad.';
$string['sliderfullscreen'] = 'Glyer volskerm';
$string['sliderfullscreendesc'] = 'Merk hierdie boks om die glyer volskerm te maak (100% breedte).';
$string['sliderh3color'] = 'Glyer 1 H3 kleur';
$string['sliderh3colordesc'] = 'Kies die kleur wat jy vir die glyer 1 H3-merker wil hê.';
$string['sliderh4color'] = 'Glyer 1 H4 kleur';
$string['sliderh4colordesc'] = 'Kies die kleur wat jy vir die glyer 1 H4-merker wil hê.';
$string['sliderimage'] = 'Glyerprent';
$string['sliderimagedesc'] = 'Voeg \'n prent vir jou glyer by. Die aanbevole grootte is 1600 px x 400 px of groter.';
$string['slidermarginbottom'] = 'Kantlyn onder glyer';
$string['slidermarginbottomdesc'] = 'Stel die grootte van die kantlyn onder die glyer.';
$string['slidermargintop'] = 'Kantlyn bokant glyer';
$string['slidermargintopdesc'] = 'Stel die grootte van die kantlyn bokant die glyer.';
$string['slideroption2'] = 'Kies glyertipe';
$string['slideroption2a'] = 'Glyerstylopsie 2 pyltjie agtergrondkleur';
$string['slideroption2adesc'] = 'Stel die glyerstylopsie 2 pyltjie agtergrondkleur';
$string['slideroption2color'] = 'Glyer 2 dien in bg';
$string['slideroption2colordesc'] = 'Stel \'n agtergrondkleur vir die indien-teks in glyerstylopsie.';
$string['slideroption2desc'] = 'Kies die glyertipe en <strong>kliek dan BERG</strong> om kleurverstellings vir jou gekose glyer te sien.';
$string['slideroption2submitcolor'] = 'Glyer 2 indien-teks';
$string['slideroption2submitcolordesc'] = 'Stel \'n agtergrondkleur vir die Indien-teks in glyerstylopsie 2 kleur.';
$string['sliderstyle1'] = 'Glyer styl 1';
$string['sliderstyle2'] = 'Glyer styl 2';
$string['slidersubmitbgcolor'] = 'Glyer 1 indien bg';
$string['slidersubmitbgcolordesc'] = 'Kies die agtergrondkleur van die Glyer 1 indien-knoppie.';
$string['slidersubmitcolor'] = 'Glyer 1 indien-teks';
$string['slidersubmitcolordesc'] = 'Kies die tekskleur van die Glyer 1 indien-knoppie.';
$string['sliderurl'] = 'Glyerskakel-URL';
$string['sliderurldesc'] = 'Voeg \'n URL by waarna jou glyer skakel wanneer daarop gekliek word.';
$string['slideshowdesc'] = 'Laai die prente op, voeg die skakels en beskrywing by vir die karousel op die voorblad.';
$string['slideshowsettings'] = 'Skyfievertoning';
$string['slideshowsettingsheading'] = 'Doelmaak die karousel op die voorblad. Sien die uitleg <a href="./../theme/adaptable/pix/layout.png" target="_blank"> hier</a>';
$string['slight'] = 'Gering';
$string['socialicondesc'] = 'Stel Font Awesome-ikoon, byvoorbeeld: fa-facebook.';
$string['socialiconlist'] = 'Lys van sosiale ikone';
$string['socialiconlistdesc'] = 'Voer \'n geskeide lys by om sosiale ikone / skakels wat jy benodig op te stel met die formaat: url|titel|ikoon.';
$string['socialpaddingside'] = 'Verstel opvulling van die kant van die sosiale ikoon';
$string['socialpaddingsidedesc'] = 'Dit sal spasie wees tussen die ikoon en nog \'n element of die gaping tussen twee ikone, d.w.s. die opvulling op die ikoon sal hierdie waarde gedeel deur twee wees. Verstek waarde volg Instagram-handelsmerkriglyne.';
$string['socialpaddingtop'] = 'Pas opvulling bokant sosiale ikone aan (verstel vertikale posisie)';
$string['socialpaddingtopdesc'] = 'Hierdie sal die minimum van 15 px wees (stel deur die kantlyn te gebruik) plus hierdie waarde.';
$string['socialsearchicon'] = 'Deursoek Moodle';
$string['socialsearchicondesc'] = 'Ontsper om \'n soekskakel langs sosiale ikone te plaas (aangesien die gebruik van sosiale ikone die soekboks wat regoor die werf funksioneer, versper).';
$string['socialsize'] = 'Stel die fontgrootte van die sosiale ikone';
$string['socialsizedesc'] = 'Vir \'n beter aansig moet die grootte 5 px groter as die verlangde, werklike grootte wees.';
$string['socialtarget'] = 'Sosiale skakels oopmaak-teiken';
$string['socialtargetdesc'] = 'Hoe sou jy wou hê moet jou sosiale skakels oopmaak (dieselfde of nuwe venster).';
$string['standard'] = 'Standaard';
$string['standardscreenwidth'] = 'Standaard skermbreedte';
$string['standardscreenwidthdesc'] = 'Stel die breedte van die skerm wanneer getokkel word na "standaard" aansig (sien ook verwante ontsperzoem- en verstekzoem-verstellings).';
$string['standardview'] = 'Standaard aansig';
$string['static'] = 'Staties';
$string['stickynavbar'] = 'Plak navstafie boaan vas';
$string['stickynavbardesc'] = 'Plak die navstrafie booaan die skerm vas wanneer daar na onder gerol word.';
$string['stylecover'] = 'Bedek';
$string['stylestretch'] = 'Strek';
$string['tabbedlayoutcoursepage'] = 'Getabuleerde uitleg van Kursusbladsy';
$string['tabbedlayoutcoursepagedesc'] = 'Gebruik \'n getabuleerde uitleg vir die kursusbladsy. Dit vertoon alle inhoud in oortjies, met kursusinhoud in een oortjie, en dit laat jou toe om die inhoud in ander oortjies pas te maak. Gebruik hierdie verstelling om die volgorde van oortjies te konfigureer.';
$string['tabbedlayoutcoursepagelink'] = 'Kursusskakel van kursusblad met getabuleerde uitleg';
$string['tabbedlayoutcoursepagelinkdesc'] = 'Hê \'n oortjieskakel terug na die kursusblad in die kursusoortjies.';
$string['tabbedlayoutcoursepagetabcolorselected'] = 'Gekose kleur van kursusbladoortjie';
$string['tabbedlayoutcoursepagetabcolorselecteddesc'] = 'Kies die kleur van die tans geselekteerde oortjie.';
$string['tabbedlayoutcoursepagetabcolorunselected'] = 'Kleur van niegeselekteerde oortjies op kursusblad.';
$string['tabbedlayoutcoursepagetabcolorunselecteddesc'] = 'Kies die kleur van enige ander oortjie.';
$string['tabbedlayoutcoursepagetabpersistencetime'] = 'Kursustuisbladoortjie nagloedtyd';
$string['tabbedlayoutcoursepagetabpersistencetimedesc'] = 'Kursustuisbladoortjie het \'n nagloed op die geselekteerde oortjie wanneer dit verfris vir \'n tydperk van onaktiwiteit. Stel die tydperk van onaktiwiteit hier. Byvoorbeeld: stel op 30 sodat die eerste oortjie gekies word ná 30 minute se onaktiwiteit.';
$string['tabbedlayoutdashboard'] = 'Paneelbordblad oortjie-uitleg';
$string['tabbedlayoutdashboarddesc'] = 'Gebruik \'n getabuleerde uitleg vir die Paneelbordblad. Dit vertoon alle inhoud in oortjies, met kursusinhoud in een oortjie en laat jou toe om die inhoud van die ander oortjies pas te maak. Gebruik hierdie verstelling om die volgorde van ander oortjies te konfigureer.';
$string['tabbedlayoutdashboardtab1condition'] = 'Oortjie 1 Doelgemaakte Profielveldbeperking (opsioneel)';
$string['tabbedlayoutdashboardtab1conditiondesc'] = 'Voeg toegangsreël vir vertoon van Oortjie 1 met doelgemaakte profielveld by, bv. vertoonoortjie1=waar.';
$string['tabbedlayoutdashboardtab2condition'] = 'Oortjie 2 Doelgemaakte Profielveldbeperking (opsioneel)';
$string['tabbedlayoutdashboardtab2conditiondesc'] = 'Voeg toegangsreël vir vertoon van Oortjie 2 met doelgemaakte profielveld by, bv. vertoonoortjie2=waar.';
$string['tabbedlayoutdashboardtabcolorselected'] = 'Geselekteerde oortjiekleur vir paneelbord';
$string['tabbedlayoutdashboardtabcolorselecteddesc'] = 'Kies die kleur van die tans geselekteerde oortjie.';
$string['tabbedlayoutdashboardtabcolorunselected'] = 'Ongeselekteerde oortjiekleur vir paneelbord';
$string['tabbedlayoutdashboardtabcolorunselecteddesc'] = 'Kies die kleur van enige ander oortjie.';
$string['tabbedlayoutheading'] = 'Aanpasbare getabuleerde uitleg';
$string['tabbedlayouttablabelcourse'] = 'Kursusinhoud';
$string['tabbedlayouttablabelcourse1'] = 'Oortjie 1';
$string['tabbedlayouttablabelcourse2'] = 'Oortjie 2';
$string['tabbedlayouttablabeldashboard'] = 'Paneelbordinhoud';
$string['tabbedlayouttablabeldashboard1'] = 'Oortjie 1';
$string['tabbedlayouttablabeldashboard2'] = 'Oortjie 2';
$string['targetnewwindow'] = 'Nuwe venster';
$string['targetsamewindow'] = 'Dieselfde venster';
$string['templatesheading'] = 'Templaatverstellings';
$string['templatesheadingdesc'] = 'Skryf template oorheen.';
$string['templatessel'] = 'Template om oorheen te skryf';
$string['templatesseldesc'] = 'Kies die template om oorheen te skryf, dan sal elkeen op sy eie blad vertoon word. Indien nie hier geselekteer nie, sal die templaat nie oorheengeskryf word nie, al is dit ontsper. Om geen te selekteer, gebruik te \'Ctrl\'-sleutel.';
$string['templatessettings'] = 'Template';
$string['themechanges'] = 'Veranderinge';
$string['themereadme'] = 'Leesmy';
$string['thiscourse'] = 'Hierdie kursus';
$string['ticker'] = 'Aankondigings';
$string['tickerdefault'] = 'Geen nuusitems om te vertoon nie';
$string['tickerdesc'] = 'Hier kan jy \'n nuusflitser stel om oor die voorblad van jou Moodle-werf te loop.
  Dit het ten doel om \'n minder steurende alternatief vir die glyer te wees, omdat dit min spasie gebruik.
  Om jou flitser op te stel, voer eenvoudig \'n paragraaflys in en sluit enige hiperskakels wat jy nodig het in daardie teks in.
  <strong>Let wel:</strong> As jou flitser nie reg laai nie, verander na HTML-aansig en verseker dat jy net p-merkers het:
  <pre>
  &lt;p&gt;Nuusitem een...&lt;/p&gt;
  &lt;p&gt;Nuusitem twee...&lt;/p&gt;
  </pre>';
$string['tickerfullscreen'] = 'Volskermbreedte';
$string['tickersettings'] = 'Nuusflitser';
$string['tickersettingsheading'] = 'Stel nuusflitser op voorblad op. Sien die uitleg <a href="./../theme/adaptable/pix/layout.png" target="_blank"> hier</a>';
$string['tickertext'] = 'Nuusflitserteks';
$string['tickertextdesc'] = 'Voeg nuusflitserteks in lysformaat in. Sien die leesmy vir meer inligting.';
$string['tickertextprofilefield'] = 'Doelgemaakte Profielveldnaam=Waarde (opsioneel)';
$string['tickertextprofilefielddesc'] = 'Voeg toegangsreël by vir die gebruik van doelgemaakte profielveld, bv. gebruikertipe=student';
$string['tickerwidth'] = 'Vasgestelde breedte';
$string['tickerwidthdesc'] = 'Jy kan hierdie verstelling gebruik om die nuusflitser op 100% breedte vas te stel.';
$string['tilesbordercolor'] = 'Rantkleur van kursusboksteëls';
$string['tilesbordercolordesc'] = 'Stel \'n kleur vir die kursusboksteëls se rant.';
$string['tilescontactstitle'] = 'Vertoon kursuskontakrol';
$string['tilescontactstitledesc'] = 'Vertoon / versteek die rol van \'n kursuskontak. Indien nie vertoon nie, sal \'n prent voor elke kontak vertoon word.';
$string['tilesshowallcontacts'] = 'Vertoon alle kursuskontake';
$string['tilesshowallcontactsdesc'] = 'Vertoon alle kursuskontakte, of slegs een.';
$string['tilesshowcontacts'] = 'Vertoon kursuskontake';
$string['tilesshowcontactsdesc'] = 'Vertoon / versteek kursuskontakte.';
$string['togglenavigation'] = 'Tokkel navigasie';
$string['toolsmenu'] = 'Hulpmiddelsaftrekkieslys';
$string['toolsmenudesc'] = 'Voeg \'n aftrekkieslys by die hoof navigasiestafie';
$string['toolsmenufield'] = 'Doelgemaakte profielveldnaam=Waarde (opsioneel)';
$string['toolsmenufielddesc'] = 'Voeg toegangsreël by vir die gebruik van doelgemaakte profielveld, bv. gebruikertipe=student.';
$string['toolsmenuheading'] = 'Hulpmiddelkieslys';
$string['toolsmenuheadingdesc'] = 'Jy kan skakels konfigureer om onder \'n hulpmiddelkieslys te vertoon (in die hoof navigasiestafie). Die formaat is soortgelyk aan dié van Moodle se doelgemaakte kieslyste, maar laat toe dat jy fa-ikone by kieslysitems voeg:<br/><pre>
&lt;span class=&quot;fa fa-video-camera&quot;&gt;&lt;/span&gt; Record Screen|http://google.co.uk|Record Screen
&lt;span class=&quot;fa fa-picture-o&quot;&gt;&lt;/span&gt; ThinkStock|http://google.co.uk|ThinkStock
&lt;span class=&quot;fa fa-clock-o&quot;&gt;&lt;/span&gt; Exam Clock|http://google.co.uk|Exam Clock
</pre><br />';
$string['toolsmenuscount'] = 'Aantal hulpmiddelkieslyste';
$string['toolsmenuscountdesc'] = 'Stel die aantal hulpmiddelkieslyste wat jy by die hoof navigasiestafie wil voeg.';
$string['toolsmenutitle'] = 'Titel van hulpmiddelkieslys';
$string['toolsmenutitledefault'] = 'Hulpmiddels';
$string['toolsmenutitledesc'] = 'Voeg die titel van die kieslys by wat jy in die hoof navigasiestafie wil vertoon.';
$string['topicsweeks'] = 'Onderwerpe / Weke kursusformaat';
$string['topicsweeksdesc'] = 'Stel style vir die \'Onderwerpe\' / \'Weke\' kursusformaat.';
$string['topmenuscount'] = 'Aantal boonste kieslyste';
$string['topmenuscountdesc'] = 'Stel die aantal boonste kieslyste wat jy by die temahofie wil voeg.';
$string['turngradereditingoff'] = 'Skakel graderingwysiging af';
$string['turngradereditingon'] = 'Skakel graderingwysiging aan';
$string['usermenu'] = 'Gebruikerkieslys';
$string['usernameposition'] = 'Gebruikernaamposisie';
$string['usernamepositiondesc'] = 'Stel die posisie van die gebruikernaam, \'Links\' of \'Regs\'.';
$string['usernav'] = 'Hofiegebruiker';
$string['usernavdesc'] = 'Laat jou toe om al die elemente te beheer wat in die gebruikernavigasie-aftreklys verskyn.';
$string['usernavheading'] = 'Doelmaak die gebruikernavigasie-aftreklys';
$string['usernodescription'] = 'Gebruiker het nog nie hul beskrywing bygewerk nie.';
$string['usernointerests'] = 'Gebruiker het nog nie hul belangstellings bygewerk nie.';
$string['usersettings'] = 'Gebruikerprofiel';
$string['usersettingsdesc'] = 'Stel verstellings vir die gebruikerprofiel';
$string['usersettingsheading'] = 'Beheer aspekte van die gebruikerprofiel';
$string['versioninfo'] = 'Vrystelling {$a->release}, weergawe {$a->version} op Moodle {$a->moodle}';
$string['wide'] = 'Volskerm';
