<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'data', language 'ja', version '5.0'.
 *
 * @package     data
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = '操作';
$string['actionsmenu'] = 'アクションメニュー';
$string['add'] = 'エントリを追加する';
$string['addcomment'] = 'コメントを追加する';
$string['addtemplate'] = 'エントリテンプレートを追加する';
$string['advancedsearch'] = '高度な検索';
$string['allowcomments'] = 'エントリへのコメントを許可する';
$string['alttext'] = '代替テキスト';
$string['approvalstatus'] = '承認ステータス';
$string['approve'] = '承認';
$string['approved'] = '承認日時';
$string['areacontent'] = 'フィールド';
$string['ascending'] = '昇順';
$string['asearchtemplate'] = '高度な検索テンプレート';
$string['atmaxentry'] = 'あなたは許可されたエントリの最大数を入力しました!';
$string['authorfirstname'] = '名';
$string['authorlastname'] = '姓';
$string['autogenallforms'] = 'すべてのデフォルトテンプレートを生成する';
$string['autolinkurl'] = 'URLにオートリンクする';
$string['availablefromdate'] = '開始日時';
$string['availabletags'] = '利用可能なタグ';
$string['availabletags_help'] = 'タグはエントリが編集または閲覧される時にフィールドや他のアイテムと置換されるテンプレート内の入れ物です。

フィールドは次のようなフォーマットとなります: [fieldname]]。他のタグすべては次のようなフォーマットとなります:  ##sometag##

現在のテンプレートでは「利用可能なタグ」一覧にあるタグのみ使用することができます。';
$string['availabletodate'] = '終了日時';
$string['availabletodatevalidation'] = '終了日時を開始日時の前にすることはできません。';
$string['bynameondate'] = '{$a->date} - {$a->name} の投稿';
$string['calendarend'] = '「{$a}」終了';
$string['calendarstart'] = '「{$a}」開始';
$string['cancel'] = 'キャンセル';
$string['cannotaccesspresentsother'] = 'あなたは他のユーザのプリセットへのアクセスを許可されていません。';
$string['cannotadd'] = 'エントリを追加できません!';
$string['cannotapplypreset'] = 'プリセットの適用中にエラーが発生しました。';
$string['cannotdeletepreset'] = 'プリセットの削除中にエラーが発生しました。';
$string['cannotoverwritepreset'] = 'プリセットの上書き中にエラーが発生しました。';
$string['cannotunziptopreset'] = 'プリセットディレクトリにZIPファイルを展開できません。';
$string['checkbox'] = 'チェックボックス';
$string['chooseexportfields'] = 'あなたがエクスポートしたいフィールドを選択してください。';
$string['chooseexportformat'] = 'あなたがエクスポートしたいフォーマットを選択してください。';
$string['chooseorupload'] = 'ファイルを選択する';
$string['choosepreset'] = 'プリセットファイル';
$string['closebeforeopen'] = 'あなたは開始日の前に終了日を指定しました。';
$string['columns'] = 'カラム';
$string['comment'] = 'コメント';
$string['commentdeleted'] = 'コメントが削除されました。';
$string['commentempty'] = 'コメントが空です。';
$string['comments'] = 'コメント';
$string['commentsaved'] = 'コメントが保存されました。';
$string['commentsn'] = '{$a} コメント';
$string['commentsoff'] = 'コメント機能は有効にされていません。';
$string['completiondetail:entries'] = 'エントリを作成する: {$a}';
$string['completionentriescount'] = 'エントリを追加する';
$string['completionentriesdesc'] = '最少必須エントリ数 : {$a}';
$string['configenablerssfeeds'] = 'ここではすべてのデータベースに関するRSSフィードを有効にします。さらにあなたはそれぞれのデータベースのRSSフィード設定を手動で有効にする必要があります。';
$string['confirmdeletefield'] = 'あなたはこのフィールドを削除しようとしています。よろしいですか?';
$string['confirmdeleterecord'] = '本当にこのエントリを削除してもよろしいですか?';
$string['confirmdeleterecords'] = '本当にこれらのエントリを削除してもよろしいですか?';
$string['createactivity'] = 'あなた独自のフィールドを作成してデータを収集することも、すでにフィールドが含まれているプリセットを使用することもできます。';
$string['createfields'] = '異なるタイプのデータを収集するためにフィールドを作成します。';
$string['createtemplates'] = 'テンプレートはあなたの活動のインタフェースを定義します。あなたがフィールドを作成した場合、テンプレートが自動的に作成されます。あなたは代わりにフィールドおよびテンプレートを含むプリセットも使用できます。';
$string['csstemplate'] = 'カスタムCSS';
$string['csvfailed'] = 'CSVファイルから生データを読み込めません。';
$string['csvfile'] = 'CSVまたはCSVファイルを含むZIP';
$string['csvimport'] = 'CSVファイルインポート';
$string['csvimport_help'] = 'エントリは最初の行にフィールド名の一覧そして1行あたり1レコードを含むテキストファイルによりインポートすることができます。';
$string['csvwithselecteddelimiter'] = '<abbr title="カンマ区切り値">CSV</abbr>';
$string['data:addinstance'] = '新しいデータベースを追加する';
$string['data:approve'] = 'エントリを承認または承認済みエントリを取り消す';
$string['data:comment'] = 'コメントを書く';
$string['data:exportallentries'] = 'すべてのデータベースエントリをエクスポートする';
$string['data:exportentry'] = 'データベースエントリをエクスポートする';
$string['data:exportownentry'] = '自分のデータベースエントリをエクスポートする';
$string['data:exportuserinfo'] = 'ユーザ情報をエクスポートする';
$string['data:managecomments'] = 'コメントを管理する';
$string['data:manageentries'] = 'エントリを管理する';
$string['data:managetemplates'] = 'テンプレートを管理する';
$string['data:manageuserpresets'] = 'プリセットを管理する';
$string['data:rate'] = 'エントリを評価する';
$string['data:readentry'] = 'エントリを読む';
$string['data:view'] = 'データベース活動を表示する';
$string['data:viewallratings'] = '個別のユーザから与えられた実評価すべてを表示する';
$string['data:viewalluserpresets'] = 'すべてのユーザのプリセットを表示する';
$string['data:viewanyrating'] = 'すべてのユーザが受けた評価合計を表示する';
$string['data:viewentry'] = 'エントリを表示する';
$string['data:viewrating'] = 'あなたが受けた評価合計を表示する';
$string['data:writeentry'] = 'エントリを書く';
$string['date'] = '日付';
$string['dateentered'] = '入力日時';
$string['datemodified'] = '最終編集日時:';
$string['defaultfielddelimiter'] = '(デフォルト: カンマ)';
$string['defaultfieldenclosure'] = '(デフォルト: なし)';
$string['defaultsortfield'] = 'デフォルトのフィールド並べ替え順';
$string['delcheck'] = 'バルク削除チェックボックス';
$string['delete'] = '削除';
$string['deleteallentries'] = 'すべてのエントリ';
$string['deletecomment'] = '本当にこのコメントを削除してもよろしいですか?';
$string['deleteconfirm'] = 'プリセット {$a} を削除してもよろしいですか?';
$string['deleted'] = '削除されました。';
$string['deleteentry'] = 'エントリを削除する';
$string['deletefield'] = 'フィールドを削除する';
$string['deletenotenrolled'] = '登録されていないユーザのエントリ';
$string['deletewarning'] = 'プリセットを削除した場合、すべてのコースで利用可能なプリセット一覧から削除されます。';
$string['descending'] = '降順';
$string['directorynotapreset'] = '{$a->directory} はプリセットではありません。不明のファイル: {$a->missing_files}';
$string['disapprove'] = '承認を取り消す';
$string['download'] = 'ダウンロード';
$string['edit'] = '編集';
$string['editcomment'] = 'コメントを編集する';
$string['editentry'] = 'エントリを編集する';
$string['editfield'] = 'フィールドを編集する';
$string['editordisable'] = 'エディタを無効にする';
$string['editorenable'] = 'コードエディタを有効にする';
$string['editpreset'] = 'プリセットを編集する';
$string['emptyadd'] = '追加用テンプレートが空です。デフォルトフォームを生成しています ...';
$string['emptyaddform'] = 'あなたはどのフィールドにも入力していません!';
$string['emptypresetname'] = 'プリセット名またはファイルを空にできません。';
$string['enabletemplateeditorcheck'] = '本当にエディタを有効にしてもよろしいですか? テンプレート保存時にコンテンツが変更されてしまうことになります。';
$string['entries'] = 'エントリ';
$string['entrieslefttoadd'] = 'この活動を完了するにはさらに {$a->entriesleft} 件以上のエントリを追加してください。';
$string['entrieslefttoaddtoview'] = '他の参加者のエントリを閲覧するにはさらに {$a->entrieslefttoview} 件以上のエントリを追加してください。';
$string['entry'] = 'エントリ';
$string['entrysaved'] = 'あなたのエントリが保存されました。';
$string['errordatafilenotfound'] = 'ファイルをインポートできませんでした。利用可能なファイル形式はCSVまたはエントリのエクスポートに使用される形式のCSVファイルを含むZIPです。';
$string['errormustbeteacher'] = 'このページを使用するにはあなたは教師である必要があります!';
$string['errormustsupplyvalue'] = 'あなたはここで値を提供する必要があります。';
$string['errorpresetexists'] = 'この名称のプリセットはすでに存在します。';
$string['errorpresetexistsbutnotoverwrite'] = 'この名称のプリセットはすでに存在します。別の名称を選択してください。';
$string['errorpresetnotfound'] = '名称「 {$a} 」のプリセットは見つかりませんでした。';
$string['eventfieldcreated'] = 'フィールドが作成されました。';
$string['eventfielddeleted'] = 'フィールドが削除されました。';
$string['eventfieldupdated'] = 'フィールドが更新されました。';
$string['eventrecordcreated'] = 'レコードが作成されました。';
$string['eventrecorddeleted'] = 'レコードが削除されました。';
$string['eventrecordupdated'] = 'レコードが更新されました。';
$string['eventtemplateupdated'] = 'テンプレートが更新されました。';
$string['eventtemplateviewed'] = 'テンプレートが閲覧されました。';
$string['example'] = 'データベースモジュール例';
$string['excel'] = 'Excel';
$string['expired'] = '申し訳ございません、この活動は {$a} に終了して利用することはできません。';
$string['export'] = 'エクスポート';
$string['exportaszip'] = 'ZIPファイルとしてエクスポートする';
$string['exportaszip_help'] = 'ZIPファイルとしてエクスポートする機能ではあなたはテンプレートおよびフィールドをダウンロードするためのプリセットZIPとして保存することができます。その後、ZIPファイルを別のコースにインポートすることができます。';
$string['exportedtozip'] = 'ZIPファイルとして一時的にエクスポートしました ...';
$string['exportentries'] = 'エントリをエクスポートする';
$string['exportformat'] = 'エクスポートフォーマット';
$string['exportoptions'] = 'エクスポートオプション';
$string['exportownentries'] = 'あなたのエントリのみエクスポートしますか? ({$a->mine}/{$a->all})';
$string['exportpreset'] = 'プリセットをエクスポートする';
$string['failedpresetdelete'] = 'プリセット削除中にエラーが発生しました!';
$string['fieldadded'] = 'フィールドが追加されました。';
$string['fieldallowautolink'] = 'オートリンクを許可する';
$string['fielddeleted'] = 'フィールドが削除されました。';
$string['fielddelimiter'] = 'フィールドセパレータ';
$string['fielddescription'] = 'フィールド説明';
$string['fieldenclosure'] = 'フィールド囲み文字';
$string['fieldheight'] = '高さ';
$string['fieldheightlistview'] = '一覧表示の高さ (ピクセル)';
$string['fieldheightsingleview'] = '個別表示の高さ (ピクセル)';
$string['fieldmappings'] = 'フィールドマッピング';
$string['fieldmappings_help'] = 'このメニューでは既存のデータベースのデータを保持することができます。フィールドのデータを保持するにはそのフィールドをデータが表示されることになる新しいフィールドにマップする必要があります。どのフィールドでも空白のまましてデータをコピーしないこともできます。新しいフィールドにマップされない古いフィールドおよび関連するすべてのデータは削除されます。

あなたは同じタイプのフィールドのみマップできます。そのため、それぞれのドロップダウンメニューにはその他のフィールドも表示される場合があります。古いフィールドを2個以上の新しいフィールドにマップしないよう気をつけてください。';
$string['fieldname'] = 'フィールド名';
$string['fieldnametype'] = '{$a->name} ({$a->type})';
$string['fieldnotmatched'] = 'あなたのファイル内の次のフィールドは不明なフィールドです: {$a}';
$string['fieldoptions'] = 'オプション (1行あたり1つ)';
$string['fields'] = 'フィールド';
$string['fieldshelp'] = '異なるタイプのデータを収集するためのフィールドを作成してください。フィールドはあなたのデータベース内のエントリの構造を定義します。';
$string['fieldsinformationtags'] = 'フィールド情報';
$string['fieldsnavigation'] = 'フィールド3次ナビゲーション';
$string['fieldtagdescription'] = '{$a} 説明';
$string['fieldtagid'] = '{$a} ID';
$string['fieldtagname'] = '{$a} 名称';
$string['fieldupdated'] = 'フィールドが更新されました。';
$string['fieldwidth'] = '幅';
$string['fieldwidthlistview'] = '一覧表示の幅 (ピクセル)';
$string['fieldwidthsingleview'] = '個別表示の幅 (ピクセル)';
$string['file'] = 'ファイル';
$string['fileencoding'] = 'エンコーディング';
$string['filesnotgenerated'] = 'すべてのファイルは生成されませんでした: {$a}';
$string['filtername'] = 'データベースオートリンク';
$string['footer'] = 'フッタ';
$string['forcelinkname'] = '強制リンク名';
$string['foundnorecords'] = 'レコードは見つかりませんでした。<a href="{$a->reseturl}">すべてをクリアする</a>';
$string['foundrecords'] = '{$a->num}/{$a->max} 件のレコードが見つかりました。<a href="{$a->reseturl}">すべてをクリアする</a>';
$string['fromfile'] = 'ZIPファイルからインポートする';
$string['fromfile_help'] = 'ZIPファイルからインポートする機能ではあなたはテンプレートおよびフィールドのプリセットのZIPを閲覧およびアップロードすることができます。';
$string['generateerror'] = 'すべてのファイルは生成されませんでした!';
$string['header'] = 'ヘッダ';
$string['headeraddtemplate'] = 'エントリ追加および編集用のインタフェース定義です。';
$string['headerasearchtemplate'] = '高度な検索のインタフェースを定義します。';
$string['headercsstemplate'] = 'テンプレートにカスタムCSSを追加します。';
$string['headerjstemplate'] = '一覧、個別またはテンプレート追加のカスタムJavaScriptを追加します。';
$string['headerlisttemplate'] = '一覧表示アピアランスを定義します。';
$string['headerrsstemplate'] = 'RSSフィードエントリのアピアランスを定義します。';
$string['headersingletemplate'] = '個別表示用のインタフェースを定義します。';
$string['id'] = 'エントリID';
$string['importandapply'] = 'プリセットをインポートおよび適用する';
$string['importapreset'] = 'プリセットをインポートする';
$string['importentries'] = 'エントリをインポートする';
$string['importpreset'] = 'プリセットをインポートする';
$string['importpreset_desc'] = 'この活動にプリセットが適用された上でフィールドおよびテンプレートが作成されます。プリセット一覧には表示されません。';
$string['importpresetmissingcapability'] = 'あなたにはプリセットをインポートするためのパーミッションがありません。';
$string['importsuccess'] = 'プリセットが適用されました。';
$string['includeapproval'] = '承認ステータスを含む';
$string['includefiles'] = 'エクスポートにファイルを含める';
$string['includetags'] = 'タグを含む';
$string['includetime'] = '追加/修正時間を含む';
$string['includeuserdetails'] = 'ユーザ詳細を含む';
$string['indicator:cognitivedepth'] = 'データベース認知的';
$string['indicator:cognitivedepth_help'] = 'この指標はデータベース活動で学生が到達した認識深度に基づきます。';
$string['indicator:cognitivedepthdef'] = 'データベース認知的';
$string['indicator:cognitivedepthdef_help'] = 'この分析間隔中、参加者がデータベース活動から提供された認知的関与のこのパーセンテージに到達しました (レベル = 閲覧なし, 閲覧, 送信)。';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'データベース社会的';
$string['indicator:socialbreadth_help'] = 'この指標はデータベース活動で学生が到達した社会的広がりに基づきます。';
$string['indicator:socialbreadthdef'] = 'データベース社会的';
$string['indicator:socialbreadthdef_help'] = 'この分析間隔中、参加者がデータベース活動から提供された社会的関与のこのパーセンテージに到達しました (レベル = 参加なし, 個人で参加)。';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insufficiententries'] = 'このデータベースを閲覧するにはさらにエントリが必要です。';
$string['intro'] = '説明';
$string['invalidaccess'] = 'このページは正しくアクセスされていません。';
$string['invalidfieldid'] = 'フィールドIDが正しくありません。';
$string['invalidfieldname'] = 'このフィールドに別の名称を選択してください。';
$string['invalidfieldtype'] = 'フィールドタイプが正しくありません。';
$string['invalidid'] = 'データIDが正しくありません。';
$string['invalidpreset'] = '{$a} はプリセットではありません。';
$string['invalidrecord'] = 'レコードが正しくありません。';
$string['invalidurl'] = 'あなたが入力したURLは正しくありません。';
$string['jstemplate'] = 'カスタムJavaScript';
$string['latitude'] = '経度';
$string['latlong'] = '座標';
$string['latlongboth'] = '緯度および経度の両方とも必須です。';
$string['latlongdownloadallhint'] = 'すべてのエントリのリンクをKMLとしてダウンロードする';
$string['latlongkmllabelling'] = 'KMLファイル (Google Earth) でのラベルのつけ方';
$string['latlonglinkservicesdisplayed'] = '表示するLink-outサービス';
$string['latlongotherfields'] = 'その他のフィールド';
$string['list'] = '一覧表示';
$string['listtemplate'] = '一覧表示用テンプレート';
$string['listview'] = 'リストビュー';
$string['longitude'] = '経度';
$string['manageapproved'] = '承認済みエントリの編集を許可する';
$string['manageapproved_help'] = '承認後に学生がエントリを編集または削除できるようにします。編集済みエントリは再承認が必要です。';
$string['managefields'] = 'フィールドを管理する';
$string['mapexistingfield'] = '{$a} にマップする';
$string['mapnewfield'] = '新しいフィールドを作成する';
$string['mapping:applypresets'] = 'プリセットを適用する';
$string['mapping:dialogtitle:usepreset'] = 'プリセット {$a} を適用しますか?';
$string['mapping:fieldstocreate'] = '作成するフィールド: {$a}';
$string['mapping:fieldstodelete'] = '削除される既存のフィールド: {$a}';
$string['mapping:mapfields'] = 'フィールドをマップする';
$string['mapping:warningmessagedelete'] = '削除するフィールドが適用するプリセットの新しいフィールドと同じタイプである場合、あなたは「フィールドをマップする」でマッピングできる場合があります。';
$string['mapping:warningmessagedeleteandcreate'] = '削除するフィールドが作成するフィールドと同じタイプである場合、あなたは「フィールドをマップする」でマッピングできる場合があります。';
$string['mappingwarning'] = '新しいフィールドにマップされない古いフィールドは喪失します。古いフィールドのすべてのデータは削除されます。';
$string['maxentries'] = '最大エントリ数';
$string['maxentries_help'] = '参加者がこのデータベースに登録できる最大エントリ数です。';
$string['maxsize'] = '最大サイズ';
$string['menu'] = 'メニュー';
$string['menuchoose'] = '選択 ...';
$string['missingdata'] = 'フィールドクラスにはデータIDまたはオブジェクトを提供してください。';
$string['missingfield'] = 'プログラマエラー: フィールドクラスを定義するにはあなたはフィールドおよびデータを指定する必要があります。';
$string['missingfieldtype'] = '{$a->name} のファイルタイプが見つかりませんでした。';
$string['missingfieldtypeimport'] = '対応するフィールドタイプがインストールされていないため、次のフィールドはインポートされませんでした。';
$string['missingfieldtypes'] = '以下のフィールドは対応するフィールドタイプがインストールされていないため「エントリを追加する」フォームに含まれません。あなたは「エントリテンプレートを追加する」を確認してフィールド名を削除する必要があります。';
$string['modulename'] = 'データベース';
$string['modulename_help'] = 'データベースは参加者がエントリのコレクションを作成、維持および検索できるようにします。

エントリの構造は短文テキスト、ドロップダウンリスト、テキストエリア、URL、画像、ファイル等、様々なタイプのフィールドを使用して定義されます。

教師としてエントリにコメントしたり評価できます。また、あなたは学生にエントリに対する評価およびコメント (相互評価) も許可できます。評価は最終的な評点として集計された上で評定表で記録されます。

データベース自動リンクフィルタが有効な場合、データベースのエントリはコース内の単語または語句が表示される場所に自動的にリンクされます。

あなたは以下の目的でデータベースを使用できます:

* ウェブリンク、書籍、書評、論文書誌等の共同収集作業用として
* 学生による写真、ポスター、ウェブサイトまたは詩の展示用またはピアコメントまたはピアレビュー用として';
$string['modulename_link'] = 'mod/data/view';
$string['modulenameplural'] = 'データベース';
$string['more'] = '詳細';
$string['moreurl'] = 'URL詳細';
$string['movezipfailed'] = 'ZIPファイルを移動できません。';
$string['multientry'] = '繰り返しエントリ';
$string['multimenu'] = 'メニュー (複数選択)';
$string['multipletags'] = '重複タグが見つかりました! テンプレートは保存されませんでした。';
$string['newentry'] = '新しいエントリ';
$string['newfield'] = 'フィールドを作成する';
$string['newfield_help'] = 'フィールドにはデータを入力することができます。データベース活動内のそれぞれのエントリには参加者が年月日をドロップダウンメニューから選択できる日付フィールド、イメージをアップロードできる画像フィールド、1つまたはそれ以上のオプションを選択できるチェックボックスフィールドのように複数タイプのフィールドを配置できます。

それぞれのフィールドには固有のフィールド名を設定してください。フィールド説明は任意です。';
$string['noaccess'] = 'あなたはこのページにアクセスできません。';
$string['nodefinedfields'] = '新しいプリセットにフィールドが定義されていません!';
$string['nofieldcontent'] = 'フィールドコンテンツが見つかりませんでした。';
$string['nofieldindatabase'] = 'このデータベースにはフィールドが定義されていません。';
$string['nofields'] = 'まだフィールドはありません。';
$string['nolisttemplate'] = '一覧表示用テンプレートはまだ定義されていません。';
$string['nomatch'] = '該当するエントリが見つかりませんでした!';
$string['nomaximum'] = '最大数なし';
$string['nopreviewavailable'] = '{$a} で利用できるプレビューはありません。';
$string['norecords'] = 'まだエントリはありません。';
$string['notapproved'] = '承認保留';
$string['notapprovederror'] = 'エントリはまだ承認されていません。';
$string['notemplates'] = 'まだテンプレートはありません。';
$string['notinjectivemap'] = 'エントリを追加できるマップではありません。';
$string['notopenyet'] = '申し訳ございません、この活動は {$a} まで利用できません。';
$string['number'] = '数値';
$string['numberrssarticles'] = 'RSSフィードエントリ';
$string['numnotapproved'] = '保留';
$string['numrecords'] = '{$a} エントリ';
$string['ods'] = '<abbr title="OpenDocumentスプレッドシート">ODS</abbr> &nbsp;(OpenOffice)';
$string['openafterclose'] = 'あなたは終了日の後に開始日を指定しました。';
$string['optionaldescription'] = '短い説明 (任意)';
$string['optionalfilename'] = 'ファイル名 (任意)';
$string['other'] = 'その他';
$string['otherfields'] = 'その他すべてのフィールド';
$string['overrwritedesc'] = '既存のプリセットをこの名称で置換およびコンテンツを上書きする';
$string['overwrite'] = '上書き';
$string['overwritesettings'] = 'コメント、評価等の現在の設定を上書きする';
$string['page-mod-data-x'] = 'すべてのデータベース活動ページ';
$string['pagesize'] = '1ページあたりのエントリ数';
$string['participants'] = '参加者';
$string['picture'] = '画像';
$string['pluginadministration'] = 'データベース活動管理';
$string['pluginname'] = 'データベース';
$string['portfolionotfile'] = 'ファイル (csvおよびLeap2Aのみ) ではなくポートフォリオにエクスポートする';
$string['presetdeleted'] = 'プリセットが削除されました。';
$string['presetinfo'] = 'プリセットとして保存することによりこのテンプレートが公開されます。他のユーザはこのテンプレートを自分のデータベースで使用することができます。';
$string['presetnotselected'] = '選択されたプリセットはありません。';
$string['presets'] = 'プリセット';
$string['presetshelp'] = '出発点として使用するプリセットを選択してください。';
$string['preview'] = '{$a} のプレビュー';
$string['previewaction'] = 'プレビュー';
$string['privacy:metadata:commentpurpose'] = 'データベースレコードのコメントです。';
$string['privacy:metadata:data_content'] = 'フィールドコンテンツ';
$string['privacy:metadata:data_content:content'] = 'コンテンツです。';
$string['privacy:metadata:data_content:content1'] = '追加コンテンツ1です。';
$string['privacy:metadata:data_content:content2'] = '追加コンテンツ2です。';
$string['privacy:metadata:data_content:content3'] = '追加コンテンツ3です。';
$string['privacy:metadata:data_content:content4'] = '追加コンテンツ4です。';
$string['privacy:metadata:data_content:fieldid'] = 'フィールド定義IDです。';
$string['privacy:metadata:data_records'] = 'データベース活動内レコード';
$string['privacy:metadata:data_records:approved'] = '承認ステータスです。';
$string['privacy:metadata:data_records:groupid'] = 'グループです。';
$string['privacy:metadata:data_records:timecreated'] = 'レコードが作成された日時です。';
$string['privacy:metadata:data_records:timemodified'] = 'レコードが最後に修正された日時です。';
$string['privacy:metadata:data_records:userid'] = 'レコードを作成したユーザです。';
$string['privacy:metadata:datafieldnpluginsummary'] = 'データベース活動モジュールのフィールです。';
$string['privacy:metadata:filepurpose'] = 'データベースレコードに添付されたファイルです。';
$string['privacy:metadata:ratingpurpose'] = 'データベースレコードの評価です。';
$string['privacy:metadata:tagpurpose'] = 'データベースレコードのタグです。';
$string['radiobutton'] = 'ラジオボタン';
$string['recordapproved'] = 'エントリが承認されました。';
$string['recorddeleted'] = 'エントリが削除されました。';
$string['recorddisapproved'] = 'エントリ未承認';
$string['recordsnotsaved'] = 'エントリは保存されませんでした。アップロードファイルのフォーマットをご確認ください。';
$string['recordssaved'] = 'エントリが保存されました。';
$string['removealldatatags'] = 'すべてのデータベースタグ';
$string['requireapproval'] = '要承認';
$string['requireapproval_help'] = '誰でも閲覧できるようにするには教師が承認する必要があります。';
$string['required'] = '必須';
$string['requiredentries'] = '完了のための必須エントリ数 (旧)';
$string['requiredentries_help'] = 'この設定を有効にした場合、完了に必要なエントリ数の最初にメッセージが表示されます。この設定は活動完了に関連付けられないことに留意してください。
活動完了にエントリを必要とする場合、新しい活動完了設定「必須エントリ」を使用してください。この設定を完全に削除する場合、「なし」に設定して変更を保存してください。
代わりに活動完了セクションの必須エントリ数フィールドを使用してください。';
$string['requiredentriestoview'] = '閲覧前に必要な入力エントリ数';
$string['requiredentriestoview_help'] = '他の学生のエントリ閲覧が許可される前に学生が追加する必要のあるエントリ数です。

これはデータベース自動リンクフィルタとは互換性がありません。';
$string['requiredentrieswarning'] = 'この設定は活動完了設定「必須エントリ」と置換されました。';
$string['requiredfield'] = '必須フィールド';
$string['resetalltemplates'] = 'すべてのテンプレートをリセットする';
$string['resetalltemplatesconfirm'] = 'あなたは現在のプリセットのすべてのテンプレートを削除しようとしています。あなたが後でテンプレートを復元したい場合、再度「プリセット」タブでプリセットを選択する必要があります。';
$string['resetalltemplatesconfirmtitle'] = 'すべてのテンプレートをリセットしますか?';
$string['resetsettings'] = 'フィルタをリセットする';
$string['resettemplate'] = '現在のテンプレートをリセットする';
$string['resettemplateconfirm'] = 'これで現在のプリセットの {$a} が完全に削除されます。';
$string['resettemplateconfirmtitle'] = 'テンプレートをリセットしてもよろしいですか?';
$string['resizingimages'] = 'イメージサムネイルのリサイズ...';
$string['rows'] = '行';
$string['rssglobaldisabled'] = '使用不可、サイト詳細設定をご覧ください。';
$string['rsstemplate'] = 'RSSテンプレート';
$string['rsstitletemplate'] = 'RSSタイトルテンプレート';
$string['rsstype'] = 'この活動のRSSフィード';
$string['save'] = '保存';
$string['saveandadd'] = '保存して次を追加する';
$string['saveandview'] = '保存して表示する';
$string['saveaspreset'] = 'このサイトでプリセットを公開する';
$string['saveaspreset_help'] = 'プリセットとして保存する機能ではサイトの誰でも利用できるようプリセットおよびフィールドを公開します (あなたは保存したプリセットをいつでもプリセット一覧から削除することができます)。';
$string['saveaspresetmissingcapability'] = 'ユーザにはデータベースをプリセットとして保存するためのパーミッションがありません。';
$string['savedataaspreset'] = 'すべてのフィールド、テンプレートおよび公開をプリセットとして保存する';
$string['savesettings'] = '設定を保存する';
$string['savesuccess'] = 'プリセットが保存されました。<a href="{$a->url}">プリセットをプレビューする</a>';
$string['search'] = '検索';
$string['search:activity'] = 'データベース - 活動情報';
$string['search:entry'] = 'データベース - エントリ';
$string['searchresults'] = '「 {$a} 」を含むエントリ';
$string['selectedrequired'] = '選択したすべてを含む';
$string['selectexportoptions'] = 'エクスポートオプションを選択する';
$string['selectfields'] = 'フィールドを選択する';
$string['selectfordeletion'] = '削除するエントリを選択する';
$string['showall'] = 'すべてのエントリを表示する';
$string['showmore'] = 'さらに表示する';
$string['single'] = '個別表示';
$string['singletemplate'] = '個別表示用テンプレート';
$string['singleview'] = '個別表示';
$string['startbuilding'] = 'あなたの活動の構築を開始する';
$string['subplugintype_datafield'] = 'データベースフィールドタイプ';
$string['subplugintype_datafield_plural'] = 'データベースフィールドタイプ';
$string['subplugintype_datapreset'] = 'プリセット';
$string['subplugintype_datapreset_plural'] = 'プリセット';
$string['tagarea_data_records'] = 'データレコード';
$string['tags'] = 'タグ';
$string['tagsdeleted'] = 'データベースタグが削除されました。';
$string['teachersandstudents'] = '{$a->teachers} および {$a->students}';
$string['templatereset'] = 'テンプレートリセット';
$string['templateresetall'] = 'すべてのテンプレートリセット';
$string['templates'] = 'テンプレート';
$string['templatesaved'] = 'テンプレートが保存されました。';
$string['templatesnavigation'] = 'テンプレート3次ナビゲーション';
$string['text'] = 'テキスト';
$string['textarea'] = 'テキストエリア';
$string['timeadded'] = '追加日時';
$string['timemodified'] = '修正日時';
$string['type'] = 'フィールドタイプ';
$string['undefinedprocessactionmethod'] = 'アクション「 {$a} 」を処理するためのアクションメソッドがData_Presetに定義されていません。';
$string['unknown'] = '不明なフィールド';
$string['unsupportedfields'] = '未サポートフィールド';
$string['unsupportedfieldslist'] = '次のフィールドはエクスポートできません:';
$string['updatefield'] = '既存のフィールドを更新します。';
$string['uploadfile'] = 'ファイルをアップロードする';
$string['uploadrecords'] = 'エントリをインポートする';
$string['uploadrecords_help'] = '別のデータベースからエクスポートしたエントリをCSVまたはCSVファイルを含むZIP (エクスポートにファイルが含まれる場合) でインポートします。

代わりにインポート用CSVファイルを作成するにはデータベースにエントリを1つ追加してエクスポートしてください。そのCSVファイルを編集してさらにエントリを追加してください。';
$string['uploadrecords_link'] = 'mod/data/import';
$string['url'] = 'URL';
$string['usedate'] = '検索に含む';
$string['usepredefinedset'] = '定義済みセットを使用する';
$string['usepreset'] = 'このプリセットを使用する';
$string['usestandard'] = 'プリセットを使用する';
$string['usestandard_help'] = 'サイト全体でプリセットを使用できるようにするにはリストよりプリセットを選択してください (あなたが「プリセットとして保存する」を使用してライブラリに保存したプリセットは削除することもできます)。';
$string['viewfromdate'] = '閲覧開始日時';
$string['viewnavigation'] = 'モード3次ナビゲーションを表示する';
$string['viewtemplates'] = 'テンプレートを表示する';
$string['viewtodate'] = '閲覧終了日時';
$string['viewtodatevalidation'] = '閲覧終了日時を閲覧開始日時の前にすることはできません。';
$string['wrongdataid'] = '無効なデータIDが提供されました。';
