<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'groupformation', language 'it', version '5.0'.
 *
 * @package     groupformation
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activity'] = 'Attività';
$string['activity_end'] = 'Termina attività';
$string['activity_start'] = 'Inizia attività';
$string['activity_visible'] = 'Non puoi visualizzare l\'attività.';
$string['add_line'] = 'Aggiungi linea';
$string['adopt_groups_task'] = 'Attività di adozione di gruppo';
$string['allanswersrequired'] = 'Rispondere a tutte le domande per completare l\'attività.';
$string['allanswersrequired_description'] = 'Rispondere a tutte le domande per completare l\'attività.';
$string['alreadySubmitted'] = 'Già inviato';
$string['analyse'] = 'Analisi';
$string['answers_for_eval_text'] = 'Se hai risposto a tutte le domande, puoi ricevere un feedback nella scheda di valutazione. Se le risposte non sono complete, la valutazione non sarà possibile a causa delle risposte mancanti.';
$string['archive_activity_task'] = 'Attività di archiviazione';
$string['archived_activity_admin'] = 'L\'attività è stata archiviata. Non c\'è nulla da svolgere qui.';
$string['archived_activity_answers'] = 'L\'attività è stata archiviata. Le tue risposte non sono più archiviate e non c\'è nulla da svolgere qui.';
$string['are'] = 'Ci sono';
$string['are_now'] = 'Ora, ci sono';
$string['availability_nochangespossible'] = 'Il questionario ha già ricevuto una risposta. Non è più possibile modificare la disponibilità.';
$string['bad'] = 'male';
$string['build_groups_task'] = 'Attività di formazione di gruppo';
$string['cannotloadxml'] = 'Impossibile caricare file XML';
$string['category_catfreetext'] = 'Testo libero';
$string['category_catmultiselect'] = 'Selezione multipla';
$string['category_catnumber'] = 'Numero';
$string['category_character'] = 'Carattere';
$string['category_demographic'] = 'Demografico';
$string['category_general'] = 'Generale';
$string['category_grade'] = 'Obiettivi';
$string['category_honesty'] = 'Onestà';
$string['category_knowledge'] = 'Conoscenza';
$string['category_learning'] = 'Apprendimento';
$string['category_motivation'] = 'Motivazione';
$string['category_points'] = 'Obiettivi';
$string['category_self'] = 'Autovalutazione';
$string['category_sellmo'] = 'Motivazione dell\'apprendimento e del successo';
$string['category_skills'] = 'Esperienza';
$string['category_srl'] = 'Apprendimento auto-gestito';
$string['category_team'] = 'Team';
$string['category_times'] = 'Disponibilità';
$string['category_topic'] = 'Argomenti';
$string['choose_evaluationmethod'] = 'Seleziona metodo';
$string['choose_number'] = 'Seleziona numero';
$string['choose_scenario'] = 'Seleziona scenario';
$string['cohort_index'] = 'Indice di prestazione dei gruppi globali:';
$string['cohort_index_info'] = 'L\'Indice di prestazione dei gruppi globali (Cohorts-Performance-Index - KPI) rappresenta la qualità dei gruppi formati e ha un intervallo tra 0 e 1. Maggiore è il valore, migliori saranno i gruppi formati.';
$string['committed_not_completed'] = 'dai questionari sottoposti non sono completi.';
$string['completeTheForm'] = 'Questionario completo';
$string['completed_questionnaire'] = 'questionari con tutte le risposte complete.';
$string['consent_agree'] = 'Accetto i termini';
$string['consent_alert_message'] = 'È necessario dare il consenso prima di accedere al questionario. Scorri verso il basso e accetta i termini prima di fare clic su "Avanti".';
$string['consent_header'] = 'Voglio partecipare al plug-in di Formazione del gruppo e accetto di inviare le risposte al questionario. La partecipazione o la non partecipazione non ha alcun impatto sul processo di valutazione (o sui punti di credito).';
$string['consent_header_import'] = 'Importando le tue risposte, accetti di partecipare al plugin Formazione del gruppo e accetti di inviare le risposte al questionario. La partecipazione o la non partecipazione non ha alcun impatto sul processo di valutazione (o sui punti di credito).';
$string['consent_message'] = '<ul><li>
Il docente non ha accesso diretto alle mie risposte fornite per la formazione del gruppo (solo io sono in grado di accedere alla valutazione sulla mia personalità e sulla media del gruppo).
</li><li>
I miei dati personali verranno cancellati al termine del corso, al massimo dopo 360 giorni.
</ul>';
$string['consent_opt_in'] = 'Consenso (opt-in)';
$string['contact_members'] = 'Per contattare i membri del tuo team puoi fare clic sui loro nomi utente.';
$string['continueTheForm'] = 'Continua';
$string['cron_job_not_running'] = 'Per gestire la coda delle richieste, un cron funziona in background. Sfortunatamente il cron non risponde o non funziona affatto. Se questo messaggio continua ad apparire dopo 24 ore, contattare l\'amministratore di sistema.';
$string['drop_selection'] = 'Deseleziona tutto';
$string['edit_param'] = 'Modifica';
$string['editparam'] = 'Modifica parametri';
$string['emailnotifications'] = '<i style="color:red;">La notifica automatica al termine della formazione del gruppo non è al momento disponibile.</i>';
$string['emailnotifications_description'] = '<i style="color:red;">La notifica automatica al termine della formazione del gruppo non è al momento disponibile.</i>';
$string['emailnotifications_info'] = 'Riceverai un messaggio di notifica quando è terminata.';
$string['endtime'] = 'Tempo finale';
$string['eval_caption_course'] = 'Corso';
$string['eval_caption_group'] = 'Gruppo';
$string['eval_caption_user'] = 'Utente';
$string['eval_cutoff_caption_agreeableness'] = 'Gradevolezza sociale';
$string['eval_cutoff_caption_challenge'] = 'Sfida';
$string['eval_cutoff_caption_conscientiousness'] = 'Coscienza';
$string['eval_cutoff_caption_extraversion'] = 'Estroversione';
$string['eval_cutoff_caption_interest'] = 'Interesse';
$string['eval_cutoff_caption_lackofconfidence'] = 'Aspettative di fallimento';
$string['eval_cutoff_caption_neuroticism'] = 'Nevrosi';
$string['eval_cutoff_caption_openness'] = 'Apertura all\'esperienza';
$string['eval_cutoff_caption_successprobability'] = 'Probabilità di successo';
$string['eval_final_text'] = 'Il paragone è effettuato su {$a->percent}% delle  {$a->completed} risposte degli utenti di {$a->coursesize} utenti che hanno già risposto.';
$string['eval_first_page_text'] = 'Con la presente riceverai il tuo feedback personalizzato riguardo alle risposte che hai fornito nel questionario. A tale scopo, le domande relative allo stesso argomento sono state raggruppate e i valori medi sono stati calcolati e confrontati con uno studente-campione. Sono stati calcolati i cosiddetti ranghi percentili, non con l\'intenzione di giudicare se un determinato valore ottenuto fosse buono o cattivo, ma per vedere con quale frequenza quei valori sono all\'interno di uno studente-campione. Un grado percentile del 10% significa che il 10% del campione di confronto aveva un valore uguale o inferiore. D\'altra parte, una percentuale percentile del 90% significa che il 90% del campione di confronto ha ottenuto un valore uguale o inferiore.
\\n\\n
In primo luogo, riceverai feedback su cinque caratteristiche della personalità, che possono essere intese come relativamente stabili, cioè indipendenti da situazioni specifiche: estroversione, nevrosi, coscienziosità, gradevolezza sociale e apertura all\'esperienza. Riceverai quindi un feedback su quattro dimensioni della motivazione, che si riferiscono al corso o al corrente esercizio corrente e quindi possono variare da situazione a situazione: interesse, sfida, probabilità di successo e aspettativa di fallimento.';
$string['eval_first_page_title'] = 'Informazione generale';
$string['eval_max_caption_agreeableness'] = 'piacevole';
$string['eval_max_caption_challenge'] = 'Sfida';
$string['eval_max_caption_conscientiousness'] = 'coscienzioso';
$string['eval_max_caption_extraversion'] = 'estroverso';
$string['eval_max_caption_interest'] = 'interesse';
$string['eval_max_caption_lackofconfidence'] = 'Aspettative di fallimento';
$string['eval_max_caption_neuroticism'] = 'stabile emotivamente';
$string['eval_max_caption_openness'] = 'aperto';
$string['eval_max_caption_successprobability'] = 'Probabilità di successo';
$string['eval_max_text_agreeableness'] = 'La gradevolezza sociale si riferisce al comportamento nei confronti delle altre persone.';
$string['eval_max_text_challenge'] = 'La sfida è una dimensione della motivazione, che esprime fino a che punto il corso o l\'esercizio corrente è interpretato come correlato alla performance, cioè fino a che punto senti di esercitare le tue abilità e le tue abilità.';
$string['eval_max_text_conscientiousness'] = 'Il fattore "Coscienza" descrive principalmente il grado di autocontrollo, accuratezza e determinazione.';
$string['eval_max_text_extraversion'] = 'Introversione ed estroversione sono due poli di un tratto della personalità che è caratterizzato dall\'interazione con l\'ambiente. L\'introversione denota un atteggiamento rivolto verso l\'interiorità mentre l\'estroversione ne indica uno verso l\'esterno.';
$string['eval_max_text_interest'] = 'L\'interesse è una dimensione della motivazione, che deriva dall\'apprezzamento del contenuto di un compito. L\'interesse si esprime, tra l\'altro, nel fatto che i compiti vengono svolti volentieri e di spontanea volontà. Soprattutto quando si tratta di svolgere compiti auto-diretti e di approfondirne la comprensione, l\'interesse contribuisce notevolmente a un apprendimento di successo.';
$string['eval_max_text_lackofconfidence'] = 'L\'aspettativa di fallimento è una forma di motivazione, che nasce dal timore di non riuscire nel compito, combinata con l\'idea che a causa della pressione della situazione non si sarà in grado di studiare in modo ottimale.';
$string['eval_max_text_neuroticism'] = 'Il fattore di personalità "Nevrosi" riflette le differenze individuali nell\'esperienza delle emozioni negative ed è anche noto come labilità emotiva. Il polo opposto è indicato anche come stabilità emotiva.';
$string['eval_max_text_openness'] = 'Il fattore "Apertura all\'esperienza" descrive l\'interesse e la quantità di impegno in nuove esperienze e impressioni.';
$string['eval_max_text_successprobability'] = 'La probabilità di successo include l\'ipotesi su quanto sia sicuro che si otterrà una buona valutazione nel corso o nell\'esercizio corrente. Un\'alta probabilità di successo prevista può derivare dalla stima di essere sufficientemente capaci, o dal trovare il compito facile.';
$string['eval_min_caption_agreeableness'] = 'competitivo';
$string['eval_min_caption_challenge'] = 'Sfida';
$string['eval_min_caption_conscientiousness'] = 'negligente';
$string['eval_min_caption_extraversion'] = 'introverso';
$string['eval_min_caption_interest'] = 'interesse';
$string['eval_min_caption_lackofconfidence'] = 'Aspettativa di fallimento';
$string['eval_min_caption_neuroticism'] = 'emotivamente instabile';
$string['eval_min_caption_openness'] = 'conservativo';
$string['eval_min_caption_successprobability'] = 'Probabilità di successo';
$string['eval_min_text_agreeableness'] = 'La gradevolezza sociale si riferisce al comportamento nei confronti delle altre persone.';
$string['eval_min_text_challenge'] = 'La sfida è una dimensione della motivazione, che esprime fino a che punto il corso o il corrente esercizio è interpretato come correlato alla performance, cioè fino a che punto senti di esercitare le tue abilità e le tue abilità.';
$string['eval_min_text_conscientiousness'] = 'Il fattore "Coscienza" descrive principalmente il grado di autocontrollo, precisione e determinazione.';
$string['eval_min_text_extraversion'] = 'Introversione ed estroversione sono due poli di un tratto della personalità che è caratterizzato dall\'interazione con l\'ambiente. L\'introversione denota un atteggiamento rivolto verso l\'interiorità mentre l\'estroversione ne indica uno rivolto verso l\'esterno.';
$string['eval_min_text_interest'] = 'L\'interesse è una dimensione della motivazione, che deriva dall\'apprezzamento del contenuto di un compito. L\'interesse si esprime, tra l\'altro, nel fatto che i compiti vengono svolti volentieri e di spontanea volontà. Soprattutto quando si tratta di svolgere compiti auto-diretti e di approfondirne la comprensione, l\'interesse contribuisce notevolmente a un apprendimento di successo.';
$string['eval_min_text_lackofconfidence'] = 'L\'aspettativa di fallimento è una forma di motivazione, che nasce dal timore di non riuscire nel compito, combinata con l\'idea che a causa della pressione della situazione non si sarà in grado di studiare in modo ottimale.';
$string['eval_min_text_neuroticism'] = 'Il fattore di personalità "Nevorsi" riflette le differenze individuali nell\'esperienza delle emozioni negative ed è anche noto come labilità emotiva. Il polo opposto è indicato anche come stabilità emotiva.';
$string['eval_min_text_openness'] = 'Il fattore "Apertura all\'esperienza" descrive l\'interesse e la quantità di impegno in nuove esperienze e impressioni.';
$string['eval_min_text_successprobability'] = 'La probabilità di successo include ipotesi su quanto sia sicuro che si otterrà una buona valutazione nel corso o nel corrente esercizio. Un\'alta probabilità di successo prevista può derivare dalla stima di essere sufficientemente capaci, o dal trovare il compito facile.';
$string['eval_name_big5'] = 'Personalità';
$string['eval_name_fam'] = 'Motivazione';
$string['eval_text_big5_agreeableness_1'] = 'I tuoi punteggi bassi sulla gradevolezza indicano che sei fondamentalmente piuttosto polemico, egocentrico e sospettoso delle intenzioni di altre persone. Ti comporti in modo più competitivo che cooperativo, hai la capacità di combattere per i tuoi stessi interessi e sei meno arrendevole.';
$string['eval_text_big5_agreeableness_2'] = 'I tuoi punteggi medi sulla gradevolezza indicano che non sei predisposto né fortemente egocentrico né altruista. Non ti descriveresti né particolarmente sospettoso né particolarmente rapido nel fidarti, né estremamente arrendevole né estremamente testardo.';
$string['eval_text_big5_agreeableness_3'] = 'I tuoi punteggi alti  in termini di gradevolezza indicano che in generale sei più altruista. Tratti gli altri con comprensione, gentilezza ed empatia, e cerchi di aiutare gli altri, supponendo che anche gli altri agiscano in modo utile. Tendi alla fiducia interpersonale, alla cooperazione e alla conformità.';
$string['eval_text_big5_conscientiousness_1'] = 'Sembri avere un punteggio piuttosto basso sulla coscienziosità. Di conseguenza, si può concludere che tendi ad essere spontaneo e che agisci in modo piuttosto superficiale e impreciso.';
$string['eval_text_big5_conscientiousness_2'] = 'Sembri avere un punteggio medio sulla coscienziosità. Di conseguenza, si può presumere che tu abbia una relazione equilibrata tra coscienziosità e spontaneità e che non sei né molto rigidamente organizzato né disorganizzato.';
$string['eval_text_big5_conscientiousness_3'] = 'Sembri avere un punteggio elevato nella "coscienza". Di conseguenza, si può presumere che tu sia organizzato, che tu pianifichi attentamente, che sia efficace, responsabile e affidabile e che agisca in modo ragionevole.';
$string['eval_text_big5_extraversion_1'] = 'Le tue risposte riportano un punteggio basso sull\'estroversione. Di conseguenza, probabilmente tendi verso comportamenti introversi e discreti nelle interazioni sociali e sei felice da solo e da solo. Le persone introverse sono spesso descritte come calme, tranquille e riservate.';
$string['eval_text_big5_extraversion_2'] = 'Le tue risposte riportano un punteggio medio sull\'estroversione. Di conseguenza, sei probabilmente entusiasta in maniera piuttosto moderata, e non sei particolarmente dominante o loquace.';
$string['eval_text_big5_extraversion_3'] = 'Le tue risposte indicano un punteggio elevato sull\'estroversione. Di conseguenza, probabilmente tendi a socializzare, ad esprimere un comportamento attivo e loquace, ad essere ottimista e caloroso, e probabilmente reagisci con una maggiore suscettibilità agli stimoli e alle eccitazioni.';
$string['eval_text_big5_neuroticism_1'] = 'Sembra che abbia un punteggio basso su "nevrosi". Di conseguenza, sei piuttosto tranquillo, soddisfatto, stabile, rilassato e sicuro e spesso riesci a gestire meglio situazioni stressanti.';
$string['eval_text_big5_neuroticism_2'] = 'Sembri avere un punteggio medio su "nevrosi". Di conseguenza, non si verificano né particolarmente spesso né raramente ansia, nervosismo, tensione, tristezza, incertezza e imbarazzo. In situazioni di stress, non sei particolarmente suscettibile ai problemi né particolarmente forte nei loro confronti.';
$string['eval_text_big5_neuroticism_3'] = 'Sembri avere un punteggio piuttosto alto su "nevrosi". Di conseguenza, si verificano frequenti ansietà, nervosismo, tensione, tristezza, incertezza e imbarazzo. Inoltre, questi sentimenti rimangono con te più a lungo e vengono attivati più facilmente. Tendi ad essere più preoccupato per la tua salute, a sviluppare idee non realistiche e trovi difficile rispondere a situazioni stressanti.';
$string['eval_text_big5_openness_1'] = 'Hai ottenuto punteggi sull\'"apertura" piuttosto bassi. Questo suggerisce che sei più incline al comportamento convenzionale e agli atteggiamenti conservatori. Preferisci le cose stabili e approvate a cose nuove e percepisci le tue reazioni emotive piuttosto attenuate. Agisci pragmaticamente nel "qui e ora".';
$string['eval_text_big5_openness_2'] = 'Hai ottenuto valori medi sull\'"apertura". Questo indica che non tendi ad atteggiamenti e comportamenti molto convenzionali o molto anticonvenzionali. Per te, la disposizione visionaria e fantasiosa è bilanciata dalla vita pragmatica nel "qui e ora".';
$string['eval_text_big5_openness_3'] = 'Hai ottenuto punteggi piuttosto alti in "apertura". Questo suggerisce che hai una vita attiva e che sei interessato a molti processi privati e pubblici. Queste persone sono spesso descritte come intellettuali, sperimentali e con interessi artistici, spesso si comportano in modo non convenzionale e preferiscono la varietà.';
$string['eval_text_fam_challenge_1'] = 'L\'attuale corso o esercizio è stato considerato da te come non molto impegnativo. Questo può essere positivo nei compiti diretti dall\'esterno, ma può avere effetti negativi quando l\'esercizio è auto-diretto.';
$string['eval_text_fam_challenge_2'] = 'L\'attuale corso o esercizio è stato considerato da te come non particolarmente impegnativo, né molto semplice.';
$string['eval_text_fam_challenge_3'] = 'L\'attuale corso o esercizio è stato considerato da te particolarmente impegnativo. Questo può essere negativo nel caso in cui l\'esercizio sia regolato esternamente. Al contrario, può avere effetti molto positivi se l\'esercizio è auto-diretto.';
$string['eval_text_fam_interest_1'] = 'Sembra che tu abbia un basso interesse per il contenuto del corso o dell\'esercizio corrente, il che può essere negativo per il tuo stesso apprendimento, nel caso in cui il processo stesso avvenga in modo auto-diretto in misura maggiore.';
$string['eval_text_fam_interest_2'] = 'Sembra che tu abbia un interesse moderato nei contenuti del corso o dell\'esercizio corrente.';
$string['eval_text_fam_interest_3'] = 'Sembri avere un alto interesse per il contenuto del corso o dell\'esercizio corrente, che dovrebbe essere positivo per il tuo apprendimento, nel caso in cui il processo stesso si svolga in modo autonomo.';
$string['eval_text_fam_lackofconfidence_1'] = 'Il tuo punteggio suggerisce che la tua aspettativa di fallimento è poco presente in te. Ciò potrebbe derivare da un timore di fallimento generalmente inesistente o ansia da test, ma potrebbe anche riguardare fattori più specifici della situazione del corso o dell\'esercizio corrente. Generalmente si ritiene che la mancanza di aspettativa di fallimento abbia un effetto positivo sull\'apprendimento.';
$string['eval_text_fam_lackofconfidence_2'] = 'Il tuo punteggio suggerisce l\'ipotesi che la tua aspettativa di fallimento sia moderata. Ciò potrebbe derivare da un timore generale di fallimento o ansia da test, ma potrebbe anche riguardare fattori più specifici della situazione del corso o dell\'esercizio corrente. Generalmente si ritiene che le aspettative di fallimento abbiano un impatto negativo sullo studio.';
$string['eval_text_fam_lackofconfidence_3'] = 'Il tuo punteggio suggerisce che l\'aspettativa di fallimento è molto pronunciata in te. Ciò potrebbe derivare da un timore generale di fallimento o ansia da test, ma potrebbe anche riguardare fattori più specifici della situazione del corso o dell\'esercizio corrente. Generalmente si ritiene che l\'aspettativa di fallimento abbia un impatto negativo sullo studio.';
$string['eval_text_fam_successprobability_1'] = 'Hai considerato di avere basse probabilità di successo nel corso o nell\'esercizio corrente. Di solito questo ha un effetto negativo sul processo di apprendimento.';
$string['eval_text_fam_successprobability_2'] = 'Hai considerato di ottenere risultati moderati nel corso o nell\'esercizio corrente. Questo non dovrebbe avere un\'influenza particolarmente positiva o negativa sul tuo processo di apprendimento.';
$string['eval_text_fam_successprobability_3'] = 'Hai considerato che molto probabilmente avrai successo nel corso o nell\'esercizio corrente. In generale, questo dovrebbe facilitare il processo di apprendimento.';
$string['evaluation'] = 'Valutazione';
$string['evaluation_point_info'] = 'indica i massimi punti disponibili';
$string['evaluationmethod_description'] = 'Come valuti il lavoro?';
$string['evaluationmethod_error'] = 'Selezionare un metodo di valutazione.';
$string['excellent'] = 'eccellente';
$string['export'] = 'Esporta';
$string['export_all'] = 'Esporta tutti i dati personali';
$string['export_all_data_check'] = 'Include tutti i dati personali della formazione gruppi e presenti nel sistema (in accordo con il regolamento EU General Data Protection Regulation)';
$string['export_all_description'] = 'E\' possibile esportare tutti i dati personali raccolti dall\'attività al seguente link:';
$string['export_answers'] = 'Scaricare tutte le risposte con ID utente anonimizzati qui:';
$string['export_description_no'] = 'Non è possibile esportare le risposte poiché non si è risposto a nessuna domanda nelle categorie esportabili.';
$string['export_description_yes'] = 'Puoi esportare le tue risposte cliccando sul pulsante qui sotto.';
$string['export_group_users'] = 'Puoi scaricare tutte le relazioni utenti-gruppo con gli ID utente anonimizzati qui:';
$string['export_groups'] = 'Scaricare tutti i gruppi con ID utente anonimizzati qui:';
$string['export_logging'] = 'Puoi scaricare tutti i log con ID utente anonimizzati qui:';
$string['export_users'] = 'Puoi scaricare tutti i dati relativi agli utenti con ID utente anonimizzati qui:';
$string['failed_import'] = 'L\'importazione non è riuscita a causa di un formato non valido. Caricare un file con formato di risposta esportabile';
$string['file_error'] = 'Occorre caricare un file *.xml';
$string['freetext_noanswer'] = 'Nessuna risposta';
$string['generategroups'] = 'Genera gruppi';
$string['go_to_group_view'] = 'alla visualizzazione dei gruppi di Moodle';
$string['grades'] = 'Valutazioni';
$string['groupSettingsInfo'] = 'Hai scelto di definire gli argomenti. Di conseguenza, verrà calcolato il numero di gruppi e la loro dimensione, come puoi vedere di seguito.';
$string['group_building'] = 'Costruzione di gruppi';
$string['group_overview'] = 'Panoramica dei gruppi costruiti';
$string['groupformation'] = 'Formazione di gruppi';
$string['groupformation:addinstance'] = 'Aggiungi Formazione di gruppi';
$string['groupformation:editsettings'] = 'Modifica Formazione di gruppi';
$string['groupformation:onlymanager'] = 'formazione di gruppi: solo manager';
$string['groupformation:onlyread'] = 'formazione di gruppi: sola lettura';
$string['groupformation:onlystudent'] = 'formazione di gruppi: solo studente';
$string['groupformation:readsettings'] = 'formazione di gruppi: leggi impostazioni';
$string['groupformation:submit'] = 'formazione di gruppi: invia';
$string['groupformation:view'] = 'formazione di gruppi: visualizza';
$string['groupformation_message'] = 'La formazione dei gruppi è finita. È ora possibile visualizzare il risultato.';
$string['groupformation_message_contexturlname'] = 'risultati';
$string['groupformation_message_subject'] = 'Formazione di gruppi completata';
$string['groupformation_subject'] = 'formazione di gruppi terminata';
$string['groupformationfieldset'] = 'Set di campi di esempio personalizzato';
$string['groupformationname'] = 'Formazione di gruppi';
$string['groupformationname_help'] = 'ToolTip di Formazione di Gruppi';
$string['groupformationsettings'] = 'Impostazioni della formazione di gruppi';
$string['groupingNotReady'] = 'La Formazione di gruppo non è ancora terminata.';
$string['grouping_abort'] = 'Annulla gruppi generati';
$string['grouping_adopt'] = 'Importa gruppi';
$string['grouping_delete'] = 'Elimina gruppi';
$string['grouping_delete_moodle_groups'] = 'Elimina gruppi di Moodle';
$string['grouping_edit'] = 'Modifica gruppi';
$string['grouping_start'] = 'Inizia formazione di gruppo';
$string['grouping_status_0'] = 'Occorre chiudere il questionario per iniziare la formazione del gruppo.';
$string['grouping_status_1'] = 'Puoi iniziare la formazione di gruppo adesso';
$string['grouping_status_2'] = 'La formazione dei gruppi è in corso. L\'elaborazione può richiedere tra i 2 e i 5 minuti. Aggiornare la pagina per visualizzare i risultati.';
$string['grouping_status_3'] = 'La conclusione della formazione di gruppo è in corso';
$string['grouping_status_4'] = 'La formazione del gruppo è finita. È possibile importare i gruppi su Moodle o generare nuovi risultati per algoritmo.';
$string['grouping_status_5'] = 'I gruppi generati sono stati importati su Moodle. Puoi modificarli manualmente.';
$string['grouping_status_6'] = 'I gruppi generati verranno utilizzati da Moodle. L\'elaborazione può richiedere tra i 2 e i 5 minuti. Aggiornare la pagina per visualizzare i risultati.';
$string['groupname'] = 'Nome del raggruppamento';
$string['groupname_error'] = 'Scegliere un nome con meno di 100 caratteri.';
$string['groupname_help'] = 'Il nome di raggruppamento scelto sarà il prefisso per i gruppi generati. Lo schema è [nome del gruppo] _XXX, dove XXX è il numero del gruppo.';
$string['groupnameexists'] = 'Gruppo già esistente';
$string['groupoption_allanswersrequired'] = 'Prima di passare alla pagina successiva del questionario è necessario rispondere a tutte le domande.';
$string['groupoption_description'] = 'Descrizione delle impostazioni di gruppo';
$string['groupoption_help'] = 'Questo parametro può essere ottimizzato dopo l\'invio dei questionari.';
$string['groupoption_onlyactivestudents'] = 'Gli studenti che non hanno risposto non saranno assegnati ad alcun gruppo.';
$string['groupoptions'] = 'Impostazioni del gruppo';
$string['groupsize'] = 'Grandezza del gruppo:';
$string['import'] = 'Importa';
$string['import_description_no'] = 'Non puoi importare le tue risposte perché hai già inviato le risposte o il questionario non è disponibile.';
$string['import_description_yes'] = 'È possibile importare le risposte facendo clic sul pulsante in basso e caricando un file con formato di risposta esportabile.';
$string['import_form_description'] = 'È possibile importare le risposte dai questionari precedenti inviando un file "answers.xml" sotto.';
$string['inactive_members_are'] = 'Gli utenti che lasciano il gruppo o il corso:';
$string['info_header_student'] = 'A cosa serve Formazione dei gruppi?';
$string['info_header_teacher_analysis'] = 'Come funziona l\'attività di Formazione dei gruppi?';
$string['info_header_teacher_settings'] = 'Come funziona l\'attività di Formazione dei gruppi?';
$string['info_text_student'] = 'In questo corso Moodle viene utilizzata la "Formazione di gruppi" per costruire una collaborazione di successo {$a->scenario_name}.
         Dopo aver completato e inviato il questionario, saranno determinati i tuoi partner di apprendimento più adatti.
         Tutti i dettagli sono mantenuti riservati.
         <br> Una volta chiuso il questionario, i gruppi verranno generati considerando i tuoi dati e le tue preferenze.
         <br>
         Domande, problemi o suggerimenti?
         Puoi trovare lo sviluppatore del plugin e lo scienziato sotto <br>
         https://github.com/moodlepeers <br>
         (creato e sviluppato con mezzi per il miglioramento della qualità dell\'insegnamento alla TU Darmstadt)';
$string['info_text_teacher_analysis'] = 'Il plugin ottimizza la formazione di gruppi di studenti. I passi da seguire sono:
1.) Aggiungi l\'attività "formazione gruppi" al corso.
Nelle impostazioni puoi scegliere quale scenario corrisponde meglio alle tue esigenze (nel caso di dubbi, scegli project teams). Le impostazioni successive permettono di selezionare la dimensione del gruppo o i requisiti di conoscenza degli studenti. Se le conoscenze pregresse degli studenti devono essere complementari, puoi inserirlo nelle impostazioni.
2.) Gli studenti svolgeranno un questionario sulla base delle impostazioni selezionate. Puoi selezionare il periodo di disponibilità del questionario (vedi passaggio 1).
Un\'anteprima del questionario può essere visualizzata in seguito accedendo all\'attività con il ruolo di docente.
3.) Le statistiche delle risposte possono essere visualizzate aprendo l\'attività. Se le risposte ricevute sono adeguate, sarà possibile avviare la formazione dei gruppi manualmente (non avviene mai automaticamente).
Trascorrerà un po\' di tempo prima che i gruppi vengano formati. Puoi osservare i gruppi generati prima di utilizzarli in Moodle.

Una volta formati i gruppi, anche gli studenti potranno vedere chi sono i loro compagni di gruppo. Come docente puoi modificare i gruppi in Moodle in qualsiasi momento (es. studenti in ritardo).';
$string['info_text_teacher_settings'] = 'Il plugin ottimizza la formazione di gruppi di studenti. I passi da seguire sono:
1.) Aggiungi l\'attività "formazione gruppi" al corso.
Nelle impostazioni puoi scegliere quale scenario corrisponde meglio alle tue esigenze (nel caso di dubbi, scegli project teams). Le impostazioni successive permettono di selezionare la dimensione del gruppo o i requisiti di conoscenza degli studenti. Se le conoscenze pregresse degli studenti devono essere complementari, puoi inserirlo nelle impostazioni.
2.) Gli studenti svolgeranno un questionario sulla base delle impostazioni selezionate. Puoi selezionare il periodo di disponibilità del questionario (vedi passaggio 1).
Un\'anteprima del questionario può essere visualizzata in seguito accedendo all\'attività con il ruolo di docente.
3.) Le statistiche delle risposte possono essere visualizzate aprendo l\'attività. Se le risposte ricevute sono adeguate, sarà possibile avviare la formazione dei gruppi manualmente (non avviene mai automaticamente).
Trascorrerà un po\' di tempo prima che i gruppi vengano formati. Puoi osservare i gruppi generati prima di utilizzarli in Moodle.

Una volta formati i gruppi, anche gli studenti potranno vedere chi sono i loro compagni di gruppo. Come docente puoi modificare i gruppi in Moodle in qualsiasi momento (es. studenti in ritardo).';
$string['input'] = 'Input:';
$string['invalid'] = 'Stato non valido';
$string['jobget_name'] = 'Formazione dei gruppi e pulizia';
$string['justpass'] = 'Passa solamente';
$string['knowledge'] = 'Conoscenza';
$string['knowledgeChoice'] = 'Conoscenza';
$string['knowledge_description'] = 'Desidero includere domande sulla conoscenza';
$string['knowledge_description_extended'] = 'Elencare le aree di conoscenza in cui gli studenti dovrebbero autovalutarsi.
     Dai un\'occhiata all\'anteprima sul lato destro.';
$string['knowledge_dummy'] = 'Esempio';
$string['knowledge_help'] = 'Se gli argomenti (opzione in basso) sono attivi, questa opzione si disattiva automaticamente e e si disabilita.';
$string['knowledge_info_homework'] = 'Elencare le aree di conoscenza in cui gli studenti dovrebbero autovalutarsi.
Dai un\'occhiata all\'anteprima sul lato destro.
Secondo la tua selezione "gruppi per compiti a casa" le conoscenze pregresse (aree) saranno variate all\'interno di ciascun gruppo.';
$string['knowledge_info_presentation'] = 'Elencare le aree di conoscenza in cui gli studenti dovrebbero autovalutarsi.
     Dai un\'occhiata all\'anteprima sul lato destro.
     Secondo la tua selezione "gruppi di presentazione", le conoscenze pregresse saranno variate all\'interno di ciascun gruppo (ignorate quando gli argomenti sono impostati).';
$string['knowledge_info_project'] = 'Elencare le aree di conoscenza in cui gli studenti dovrebbero autovalutarsi.
     Dai un\'occhiata all\'anteprima sul lato destro.
     Secondo la tua selezione "team di progetto" le conoscenze pregresse (aree) saranno variate all\'interno di ciascun gruppo, ma il livello di conoscenza deve essere simile.';
$string['knowledge_question'] = 'Quanto ne sai sui seguenti argomenti?';
$string['knowledge_scale'] = '0 = nessuna conoscenza, 100 = grande conoscenza';
$string['language'] = 'en';
$string['max_group_size'] = 'Dimensione massima dei gruppi';
$string['max_group_size_not_reached'] = 'La dimensione massima del gruppo non è stata raggiunta dai seguenti gruppi:';
$string['maxgroups'] = 'Massimo numero di gruppi';
$string['maxgroups_error'] = 'Selezionare un numero maggiore di 0';
$string['maxmembers'] = 'Numero massimo di membri del gruppo';
$string['maxmembers_error'] = 'Selezionare un numero maggiore di 0';
$string['maxpoints'] = 'Punteggio massimo';
$string['maxpoints_error'] = 'Selezionare un numero tra 1 e 100';
$string['members_are'] = 'I membri del tuo gruppo sono';
$string['messageprovider:submission'] = 'Inviami una notifica quando l\'algoritmo di formazione dei gruppi è finito';
$string['modulename'] = 'Formazione di gruppi';
$string['modulename_help'] = 'Il plugin Formazione di gruppi genera gruppi di partecipanti sulla base delle risposte a un questionario.';
$string['modulenameplural'] = 'Formazioni di gruppi';
$string['name_by_group'] = 'Nome:';
$string['namingschema'] = 'Schema di denominazione';
$string['noGroup'] = 'Non ti è stato assegnato alcun gruppo perché non hai risposto al questionario.';
$string['noUser'] = 'L\'utente non esiste';
$string['no_data_to_display'] = 'Nessun dato da visualizzare';
$string['no_evaluation_ready'] = 'Non c\'è una valutazione per te. La valutazione delle tue risposte è possibile se hai risposto a tutte le domande e inviato le tue risposte.';
$string['no_evaluation_text'] = 'Non esiste una valutazione per questa attività di formazione di gruppo.';
$string['no_time'] = 'Nessun tempo impostato';
$string['nochangespossible'] = 'Il questionario ha già ricevuto risposte.
È possibile modificare solo il numero massimo di membri o il numero massimo di gruppi. Ulteriori modifiche non verranno salvate.';
$string['noevaluation'] = 'Nessuna valutazione';
$string['nogroupformation'] = 'Nessuna formazione di gruppi';
$string['none'] = 'nessuna';
$string['notOpen'] = 'Invio dei questionari chiuso';
$string['notamember'] = 'Lascia il gruppo o il corso';
$string['number_member'] = 'Numero di membri:';
$string['number_of_groups'] = 'Numero di gruppi costruiti:';
$string['oneManGroup'] = 'Sei l\'unico membro del gruppo';
$string['onlyactivestudents'] = 'Solo gli studenti con almeno una risposta inviata devono essere considerati per la costruzione dei gruppi.';
$string['onlyactivestudents_description'] = 'Solo gli studenti con almeno una risposta inviata devono essere considerati per la costruzione dei gruppi.';
$string['onlyactivestudents_info'] = 'Solo gli studenti con almeno una risposta inviata saranno presi in considerazione per la formazione del gruppo. Questo può essere configurato in {$a->url}.';
$string['options'] = 'Opzioni';
$string['overview'] = 'Panoramica';
$string['page_title_analysis'] = 'Attività';
$string['page_title_evaluation'] = 'Valutazione';
$string['page_title_export'] = 'Esporta';
$string['page_title_group'] = 'Assegnazione di gruppo';
$string['page_title_grouping'] = 'Formazione di gruppi';
$string['page_title_grouping_edit'] = 'Formazione di gruppi - modalità modifica';
$string['page_title_import_export'] = 'Importa ed Esporta';
$string['page_title_overview'] = 'Panoramica';
$string['participant_code_alert_message'] = 'È necessario inserire un codice partecipante valido prima di accedere al questionario. Scorri verso il basso e inserisci il codice del partecipante.';
$string['participant_code_footer'] = 'Il tuo codice partecipante personale è';
$string['participant_code_title'] = 'Codice partecipante';
$string['password_wrong'] = 'password sbagliata';
$string['pluginadministration'] = 'Amministrazione: Formazione dei gruppi';
$string['pluginname'] = 'Formazione dei gruppi';
$string['points'] = 'Punteggio';
$string['preview'] = 'Anteprima:';
$string['quality'] = 'Qualità del gruppo';
$string['quality_info'] = 'Group-Performance-Index (GPI) rappresenta la qualità del gruppo costruito e ha un range compreso tra 0 e 1. Maggiore è il valore, migliore il gruppo. Se non è menzionato alcun valore, il gruppo non è costruito algoritmicamente, ma in maniera casuale.';
$string['questionnaire_answer_stats'] = 'Stato attuale del questionario:';
$string['questionnaire_availability_info_from'] = 'Il questionario sarà disponibile da {$a->start}.';
$string['questionnaire_availability_info_future'] = 'Il questionario sarà disponibile nel periodo da {$a->start} a {$a->end}.';
$string['questionnaire_availability_info_now'] = 'Il questionario è disponibile fino a {$a->end}.';
$string['questionnaire_availability_info_until'] = 'Il questionario è ancora disponibile fino a {$a->end}';
$string['questionnaire_available'] = 'Il questionario è pronto per l\'elaborazione.';
$string['questionnaire_available_end'] = 'Il questionario è disponibile fino a {$a->end}.';
$string['questionnaire_committed'] = 'Le tue risposte sono state inviate. Non puoi cambiarle in questa attività.';
$string['questionnaire_delete'] = 'Rimuovi il consenso';
$string['questionnaire_go_to_start'] = 'Vai all\'Inizio';
$string['questionnaire_no_more_questions'] = 'Non ci sono più domande a cui rispondere.';
$string['questionnaire_not_available'] = 'Il questionario non è al momento disponibile.';
$string['questionnaire_not_available_begin'] = 'Il questionario è disponibile da {$a->start}.';
$string['questionnaire_not_available_begin_end'] = 'Il questionario è disponibile da {$a->start} a {$a->end}.';
$string['questionnaire_not_available_end'] = 'Il questionario non è più disponibile.';
$string['questionnaire_not_started'] = 'Il questionario è pronto.';
$string['questionnaire_not_submitted'] = 'Le tue risposte non sono ancora state inviate.';
$string['questionnaire_outdated'] = 'Questa attività è troppo vecchia. Non è possibile garantire la corretta funzionalità. Si prega di creare una nuova attività per godere della piena funzionalità.';
$string['questionnaire_press_beginning_submit'] = 'Fai clic su "Vai all\'inizio" per tornare alla pagina iniziale. Qui puoi inviare le tue risposte che hai attualmente dato.';
$string['questionnaire_press_continue_submit'] = 'Fai clic su "Modifica" per continuare il questionario o "Invia" per inviare le risposte che hai attualmente inserito.
Puoi anche rimuovere il tuo consenso, che elimina anche tutte le risposte date, cliccando su "Rimuovi consenso".';
$string['questionnaire_press_preview'] = 'Premi "Anteprima" per dare un\'occhiata al questionario.';
$string['questionnaire_press_revert'] = 'Fai clic su "Ripristina" per annullare la decisione di inviare il questionario. Puoi anche rimuovere il tuo consenso, che elimina anche tutte le risposte date, cliccando su "Rimuovi consenso".';
$string['questionnaire_press_to_begin'] = 'Dai il tuo consenso e fai clic su "Avanti" per iniziare.';
$string['questionnaire_press_to_begin_participant_code'] = 'Inserisci il codice del partecipante e dai il tuo consenso. Fai clic su "Avanti" per iniziare.';
$string['questionnaire_preview'] = 'Questa è un\'anteprima del questionario.';
$string['questionnaire_submit'] = 'Invia risposte';
$string['questionnaire_submit_disabled_teacher'] = 'L\'invio è disabilitato perché è solo un\'anteprima.';
$string['questionnaire_submitted'] = 'Hai inviato le tue risposte. Revoca il tuo invio o rimuovi il consenso per ricominciare.';
$string['remove_line'] = 'Rimuovi linea';
$string['sampleGroupName'] = 'Il nome del tuo gruppo è';
$string['scenario'] = 'Scenario';
$string['scenarioInfo'] = 'I tre scenari differiscono nel modo in cui gli elementi del questionari influenzano la formazione del gruppo.
             Per i team di progetto, prende in considerazione le conoscenze e i tratti pregressi dei membri del gruppo che si modificano a vicenda, mentre il livello di motivazione e gli obiettivi personali dovrebbero essere il più simili possibile.
             Per i gruppi "compiti a casa", ottimizza ciascun gruppo per avere i migliori prerequisiti possibili per l\'apprendimento collaborativo.
             Per i gruppi "presentazione", l\'aspetto principale è l\'interesse reciproco nello stesso argomento selezionato (e assegnato) su cui lavorare.';
$string['scenario_description'] = 'Scegliere lo scenario più adatto per la formazione del gruppo.';
$string['scenario_error'] = 'Scegliere uno scenario';
$string['scenario_homeworkgroups'] = 'Gruppo "compiti a casa"';
$string['scenario_homeworkgroups_description'] = 'I gruppi "compiti a casa" completano compiti (più piccoli) a intervalli regolari (spesso settimanali) come preparazione per l\'esame. Anche se i compiti (spesso chiamati esercizi, pratica, domande di controllo o compiti a casa) sono principalmente suddivisibili tra i membri del gruppo, non è così per l\'esame finale, in cui ogni membro sarà classificato individualmente e dovrà essere in grado di risolvere tutti i compiti da solo. Di conseguenza, la formazione di gruppo mira a diverse conoscenze pregresse e a diversi stili di apprendimento che beneficiano l\'uno dell\'altro.';
$string['scenario_homeworkgroups_short'] = 'Le aree di conoscenza e gli obiettivi mirati sono eterogenei; orientamento della squadra omogeneo.';
$string['scenario_presentationgroups'] = 'Gruppi "presentazione"';
$string['scenario_presentationgroups_description'] = 'I gruppi "presentazione" lavorano insieme per un periodo di tempo relativamente breve per terminare una presentazione (di solito da tenere in classe). Spesso all\'inizio uno specifico sotto-compito è assegnato a (o selezionato da) ogni studente, lavorato individualmente e alla fine riassemblato in una presentazione completa. La valutazione viene solitamente effettuata per la performance di tutto il gruppo . Pertanto, la formazione di gruppo mira principalmente all\'interesse reciproco nello stesso argomento.';
$string['scenario_presentationgroups_short'] = 'Consente esclusivamente di ordinare un elenco di argomenti tramite Drag & Drop. La procedura "primo arrivato, primo servito" viene evitata per consentire una distribuzione degli argomenti più corretta.';
$string['scenario_projectteams'] = 'Team di progetto';
$string['scenario_projectteams_description'] = 'I team di progetto lavorano intensamente insieme per completare un progetto (ad esempio, condurre uno studio, consegnare un report, ecc.). Spesso doveri e compiti possono essere suddivisi tra i membri del team. Di conseguenza, è vantaggioso avere una combinazione di fattori modificativi nella squadra. Di solito, un risultato di lavoro collettivo di questo tipo è valutato con un marchio di gruppo uguale per tutti i membri. Pertanto, la formazione di gruppo mira a motivazioni simili e obiettivi simili (oltre ai prerequisiti).';
$string['scenario_projectteams_short'] = 'Le aree e le motivazioni della conoscenza sono eterogenee; livello di conoscenza, obiettivi mirati e orientamento al gruppo sono omogenei; i tratti caratteriali sono parzialmente omogenei, parzialmente eterogenei.';
$string['scenario_usage_header'] = 'Utilizzo del questionario';
$string['scenario_usage_header_presentation'] = 'Gli studenti impostano le preferenze';
$string['select_info'] = 'Seleziona i membri del gruppo per spostarli in un altro gruppo';
$string['settings_archiving_time'] = 'Tempo di archiviazione';
$string['settings_archiving_time_description'] = 'Dopo x giorni l\'attività verrà archiviata.';
$string['settings_description'] = 'Impostazioni per l\'archiviazione e funzionalità aggiuntive.';
$string['settings_header'] = 'Generale';
$string['settings_import_export'] = 'Importa/Esporta risposte';
$string['settings_import_export_description'] = 'Se impostato, gli studenti possono esportare le loro risposte e importarle in un\'altra istanza.';
$string['settings_participant_code'] = 'Codice partecipante';
$string['settings_participant_code_description'] = 'Gli studenti devono inserire un codice partecipante (come nei test psicologici).';
$string['starttime'] = 'Tempo inizio';
$string['statistic'] = 'Statistiche del questionario';
$string['stats_all'] = 'Hai risposto a tutte le domande nella categoria "{$a->category}".';
$string['stats_none'] = 'Non hai risposto a tutte le domande nella categoria "{$a->category}".';
$string['stats_partly'] = 'Hai risposto a {$a->answered} su {$a->questions} domande nella categoria "{$a->category}".';
$string['students_enrolled_info'] = 'Gli studenti sono iscritti a questo corso';
$string['students_selected'] = 'studenti selezionati';
$string['submit-modal-text'] = 'Per ragioni scientifiche e per il processo di formazione dei gruppi, è importante che le risposte a tutte le domande siano veritiere e corrette. Apprezziamo il tuo supporto.

Clicca su \'Annulla\' se vuoi modificare la tua risposta prima di inviarla.';
$string['submit-modal-title'] = 'Invia le tue risposte';
$string['successful_import'] = 'L\'importazione ha avuto successo. È possibile rivedere le risposte nel questionario.';
$string['tab_analysis'] = 'Analisi';
$string['tab_evaluation'] = 'Valutazione';
$string['tab_group'] = 'Assegnazione di gruppo';
$string['tab_grouping'] = 'Formazione dei gruppi';
$string['tab_overview'] = 'Panoramica';
$string['tab_preview'] = 'Questionario (Anteprima)';
$string['tab_questionnaire'] = 'Questionario';
$string['tabletitle_catfreetext'] = 'Testo libero';
$string['tabletitle_catmultiselect'] = 'Multiselezione';
$string['tabletitle_catnumber'] = 'Numero';
$string['tabletitle_character'] = 'Carattere';
$string['tabletitle_demographic'] = 'Demografico';
$string['tabletitle_general'] = 'Generale';
$string['tabletitle_grade'] = 'Obiettivi';
$string['tabletitle_honesty'] = 'Onestà';
$string['tabletitle_knowledge'] = 'Quanto ne sai sui seguenti argomenti?';
$string['tabletitle_learning'] = 'Apprendimento';
$string['tabletitle_motivation'] = 'Motivazione';
$string['tabletitle_points'] = 'Obiettivi';
$string['tabletitle_self'] = 'Autovalutazione';
$string['tabletitle_sellmo'] = 'Motivazione dell\'apprendimento e del successo';
$string['tabletitle_skills'] = 'Esperienza';
$string['tabletitle_srl'] = 'Apprendimento auto-controllato';
$string['tabletitle_team'] = 'Team';
$string['tabletitle_times'] = 'Disponibilità';
$string['tabletitle_topic'] = 'Argomenti';
$string['time'] = 'Tempo';
$string['topic'] = 'Argomento';
$string['topic_group_info'] = 'Il tuo argomento è';
$string['topicchoice'] = 'Selezione argomento';
$string['topics'] = 'Argomenti';
$string['topics_description'] = 'Voglio definire argomenti';
$string['topics_description_extended'] = 'Elencare gli argomenti tra cui devono scegliere gli studenti. <strong> Quindi la formazione dei gruppi si ottimizza utilizzando esclusivamente le preferenze di selezione dell\'argomento. </strong> Tutte le altre parti del questionario saranno ignorate.';
$string['topics_dummy'] = 'Argomento';
$string['topics_help'] = 'Quando si utilizzano gli argomenti, le domande sulla conoscenza saranno disattivate e il numero di gruppi corrisponderà al numero di argomenti.';
$string['topics_question'] = 'Metti in ordine i seguenti argomenti sulla base dei tuoi interessi personali, iniziando con il tuo argomento preferito. Ordina tramite trascinamento.';
$string['topics_statistics'] = 'Statistiche degli argomenti offerti';
$string['topics_statistics_description'] = 'I seguenti punteggi indicano quali argomenti sono stati preferiti dagli studenti, vale a dire un punteggio vicino a 1 indica che l\'argomento è più gradito rispetto agli argomenti con un punteggio inferiore.';
$string['topics_statistics_score'] = 'Punteggio [0-1]';
$string['unselect_all'] = 'Deseleziona tutti';
$string['useOneLineForEachKnowledge'] = 'Utilizza una linea per ogni argomento';
$string['useOneLineForEachTopic'] = 'Utilizza una linea per ogni argomento';
$string['userpergroup'] = 'Quanti utenti in un gruppo?';
$string['your_group'] = 'Il nome del tuo gruppo è:';
