<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'question', language 'et', version '5.0'.
 *
 * @package     question
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Toiming';
$string['addanotherhint'] = 'Lisa veel üks vihje';
$string['addcategory'] = 'Lisa kategooria';
$string['addmorechoiceblanks'] = 'Tühjad väljad veel {no} valiku jaoks';
$string['adminreport'] = 'Teavita võimalikest probleemidest küsimustepangas';
$string['advancedsearchoptions'] = 'Otsinguvalikud';
$string['alltries'] = 'Kõik soorituskatsed';
$string['answer'] = 'Vastus';
$string['answers'] = 'Vastused';
$string['answersaved'] = 'Vastus on salvestatud';
$string['attemptfinished'] = 'Soorituskatse on lõpetatud';
$string['attemptfinishedsubmitting'] = 'Soorituskatse lõpetas esitamise:';
$string['attemptoptions'] = 'Soorituskatse valikud';
$string['availableq'] = 'Saadaval?';
$string['badbase'] = 'Vigane alus enne **: {$a}**';
$string['behaviour'] = 'Toimimisviis';
$string['behaviourbeingused'] = 'Kasutatav toimimisviis: {$a}';
$string['broken'] = 'See on "katkenud link", mis viitab olematule failile.';
$string['byandon'] = 'kasutaja: <em>{$a->user}</em>, aeg: <em>{$a->time}</em>';
$string['cannotcopybackup'] = 'Varufaili ei saanud kopeerida';
$string['cannotcreate'] = 'Uut kannet ei saanud tabelisse question_attempts luua';
$string['cannotcreatepath'] = 'Teed ei saa luua: {$a}';
$string['cannotdeletebehaviourinuse'] = 'Toimimisviisi „{$a}“ ei saa kustutada. Seda kasutatakse küsimustele vastamise katsete korral.';
$string['cannotdeletecate'] = 'Seda kategooriat ei saa kustutada, kuna see on selle konteksti vaikekategooria.';
$string['cannotdeleteneededbehaviour'] = 'Küsimuste toimimisviisi „{$a}“ ei saa kustutada. Mõni muu installitud toimimisviis toetub sellele.';
$string['cannotdeleteqtypeinuse'] = 'Küsimusetüüpi „{$a}“ ei saa kustutada. Küsimustepangas on seda tüüpi küsimusi.';
$string['cannotdeleteqtypeneeded'] = 'Küsimusetüüpi „{$a}“ ei saa kustutada. Mõni muu installitud küsimusetüüp toetub sellele.';
$string['cannotdeletetopcat'] = 'Ülemkategooriaid ei saa kustutada.';
$string['cannotedittopcat'] = 'Ülemkategooriaid ei saa muuta.';
$string['cannotenable'] = 'Küsimusetüüpi {$a} ei saa otse luua.';
$string['cannotenablebehaviour'] = 'Küsimuste toimimisviisi {$a} ei saa otse kasutada. See on ainult sisemiseks kasutamiseks.';
$string['cannotfindcate'] = 'Kategooriakirjet ei leitud';
$string['cannotfindquestionfile'] = 'ZIP-failist ei leitud küsimuseandmete faili';
$string['cannotgetdsfordependent'] = 'Andmestikust sõltuva küsimuse jaoks ei saa määratud andmestikku tuua! (Küsimus: {$a->id}, andmestikuüksus: {$a->item})';
$string['cannotgetdsforquestion'] = 'Arvutusliku küsimuse jaoks ei saa määratud andmestikku tuua! (Küsimus: {$a})';
$string['cannothidequestion'] = 'Küsimust ei saanud peita';
$string['cannotimportformat'] = 'Kahjuks pole selle vormingu import veel juurutatud.';
$string['cannotinsertquestion'] = 'Uue küsimuse sisestamine ebaõnnestus!';
$string['cannotinsertquestioncatecontext'] = 'Uut küsimusekategooriat {$a->cat} ei saanud sisestada; lubamatu konteksti-ID {$a->ctx}';
$string['cannotloadquestion'] = 'Küsimust ei saanud laadida';
$string['cannotmovequestion'] = 'Seda skripti ei saa kasutada selliste küsimuste teisaldamiseks, mis on seotud muudel aladel olevate failidega.';
$string['cannotopenforwriting'] = 'Ei saa kirjutamiseks avada: {$a}';
$string['cannotpreview'] = 'Nende küsimuste eelvaadet ei saa vaadata!';
$string['cannotread'] = 'Impordifaili ei saanud lugeda (või fail on tühi)';
$string['cannotretrieveqcat'] = 'Küsimusekategooriat ei saanud serverist tuua';
$string['cannotunhidequestion'] = 'Küsimuse peidust väljavõtmine ebaõnnestus.';
$string['cannotunzip'] = 'Faili ei saanud lahti pakkida.';
$string['cannotwriteto'] = 'Eksporditud küsimusi ei saa kirjutada faili {$a}';
$string['categories'] = 'Kategooriad';
$string['category'] = 'Kategooria';
$string['categorycurrent'] = 'Praegune kategooria';
$string['categorycurrentuse'] = 'Kasuta seda kategooriat';
$string['categorydoesnotexist'] = 'Seda kategooriat pole olemas';
$string['categoryinfo'] = 'Kategooriateave';
$string['categorymove'] = 'Kategooria „{$a->name}“ sisaldab {$a->count} küsimust (mõned neist võivad olla peidetud või juhuslikud mõnes testis endiselt kasutusel olevad küsimused). Valige teine kategooria, kuhu need teisaldada.';
$string['categorymoveto'] = 'Salvesta kategooriasse';
$string['categorynamecantbeblank'] = 'Kategooria nimi väli ei tohi olla tühi';
$string['categorynamewithcount'] = '{$a->name} ({$a->questioncount})';
$string['categorynamewithidnumber'] = '{$a->name} [{$a->idnumber}]';
$string['categorynamewithidnumberandcount'] = '{$a->name} [{$a->idnumber}] ({$a->questioncount})';
$string['changeoptions'] = 'Muuda valikuid';
$string['changepublishstatuscat'] = '<a href="{$a->caturl}">Kategooria "{$a->name}"</a>kursusel" {$a->coursename} "muudetakse jagamise olekut<strong>{$a->changefrom} - {$a->changeto}</strong>.';
$string['check'] = 'Kontrolli';
$string['chooseqtypetoadd'] = 'Valige lisatav küsimusetüüp';
$string['clearwrongparts'] = 'Eemalda valed vastused';
$string['clickflag'] = 'Märgi küsimus lipuga';
$string['clicktoflag'] = 'Märgi see küsimus edaspidiseks lipuga';
$string['clicktounflag'] = 'Eemalda lipp';
$string['clickunflag'] = 'Eemalda lipp';
$string['closepreview'] = 'Sulge eelvaade';
$string['combinedfeedback'] = 'Kombineeritud tagasiside';
$string['comment'] = 'Kommentaar';
$string['commented'] = 'Kommenteeritud: {$a}';
$string['commentormark'] = 'Kommenteeri või kirjuta hindepunktid üle';
$string['comments'] = 'Kommentaarid';
$string['commentx'] = 'Kommentaar: {$a}';
$string['complete'] = 'Valmis';
$string['contexterror'] = 'Kui te parajasti ei teisalda kategooriat mõnda teise konteksti, poleks te pidanud siia sattuma.';
$string['copy'] = 'Kopeerige asukohast {$a} ja muutke linke.';
$string['correct'] = 'Õige';
$string['correctfeedback'] = 'Iga õige vastuse korral';
$string['correctfeedbackdefault'] = 'Teie vastus on õige.';
$string['created'] = 'Loodud';
$string['createdby'] = 'Koostanud';
$string['createdmodifiedheader'] = 'Loodud / viimati salvestatud';
$string['createnewquestion'] = 'Koosta uus küsimus...';
$string['cwrqpfs'] = 'Juhuslikud küsimused valivad alamkategooriatest küsimusi.';
$string['cwrqpfsnoprob'] = 'Probleem „Juhuslikud küsimused, mis valivad alamkategooriatest” ei mõjuta sinu saidi ühtegi küsimusekategooriat.';
$string['decimalplacesingrades'] = 'Kümnendkohti hinnetes';
$string['defaultfor'] = 'Sätte {$a} vaikeväärtus';
$string['defaultinfofor'] = 'Vaikekategooria kontekstis „{$a}“ jagatud küsimustele.';
$string['defaultmark'] = 'Vaikehindepunktid';
$string['defaultmarkmustbepositive'] = 'Vaikehinne peab olema positiivne.';
$string['deletecoursecategorywithquestions'] = 'Selle kursuse kategooriaga on küsimustepangas seotud küsimusi. Kui jätkad, need kustutatakse. Esmalt võiksid need eemaldada kasutades küsimuste panga liidest.';
$string['deletequestioncheck'] = 'Kas soovite kindlasti üksuse „{$a}“ kustutada?';
$string['deletequestionscheck'] = 'Kas soovite kindlasti järgmised küsimused kustutada?<br /><br />{$a}';
$string['deletingbehaviour'] = 'Küsimuste toimimisviisi „{$a}“ kustutamine';
$string['deletingqtype'] = 'Küsimusetüübi „{$a}“ kustutamine';
$string['didnotmatchanyanswer'] = '[Ei vastanud ühelegi küsimusele]';
$string['disabled'] = 'Keelatud';
$string['displayoptions'] = 'Kuvamissätted';
$string['disterror'] = 'Jaotus {$a} põhjustas probleeme';
$string['donothing'] = 'Ärge kopeerige ega teisaldage faile ega muutke linke';
$string['editcategories'] = 'Muuda kategooriaid';
$string['editcategories_help'] = 'Selle asemel, et hoida kõike ühes suures loendis, saab küsimused jaotada kategooriatesse ja alamkategooriatesse.

Igal kategoorial on kontekst, mis määrab selle, kus saab kategooriasse kuuluvaid küsimusi kasutada:

* tegevuskontekst – küsimused on saadaval ainult ühes kindlas tegevusmoodulis
* kursusekontekst – küsimused on saadaval ühe kindla kursuse kõigis tegevusmoodulites
* kursusekategooria kontekst – küsimused on saadaval ühe kindla kursusekategooria kõigis tegevusmoodulites ja kursustes
* süsteemikontekst – küsimused on saadaval saidi kõigis kursustes ja tegevustes

Kategooriaid kasutatakse ka juhuküsimuste korral: küsimused valitakse konkreetsest kategooriast.';
$string['editcategories_link'] = 'question/category';
$string['editcategory'] = 'Muuda kategooriat';
$string['editingcategory'] = 'Kategooria muutmine';
$string['editingquestion'] = 'Küsimuse muutmine';
$string['editquestion'] = 'Muuda küsimust';
$string['editquestions'] = 'Muuda küsimusi';
$string['editthiscategory'] = 'Muuda seda kategooriat';
$string['emptyxml'] = 'Tundmatu tõrge – tühi imsmanifest.xml';
$string['enabled'] = 'Lubatud';
$string['erroraccessingcontext'] = 'Kontekstile ei pääse ligi.';
$string['errordeletingquestionsfromcategory'] = 'Tõrge küsimuste kustutamisel kategooriast {$a}.';
$string['errorduringpost'] = 'Järeltöötluse käigus juhtus viga!';
$string['errorduringpre'] = 'Juhtus viga eeltöötluse käigus!';
$string['errorduringproc'] = 'Töötluse käigus juhtus viga!';
$string['errorduringregrade'] = 'Küsimust {$a->qid} ei saanud uuesti hinnata, selle olekuks saab {$a->stateid}.';
$string['errorfilecannotbecopied'] = 'Tõrge: faili {$a} ei saa kopeerida.';
$string['errorfilecannotbemoved'] = 'Tõrge: faili {$a} ei saa teisaldada.';
$string['errorfileschanged'] = 'Tõrge: vormi küsimustega lingitud faile on pärast vormi kuvamist muudetud.';
$string['erroritemappearsmorethanoncewithdifferentweight'] = 'Küsimus ({$a}) esineb testis mitu korda ja selle kaal on eri asukohtades erinev. Statistikaaruanne ei toeta praegu sellist küsimusekasutust ja seetõttu ei pruugi selle küsimuse statistika olla usaldusväärne.';
$string['errormanualgradeoutofrange'] = 'Küsimuse {$a->name} hinne {$a->grade} pole vahemikus 0–{$a->maxgrade}. Punktisumma ja kommentaar pole salvestatud.';
$string['errormovingquestions'] = 'Tõrge küsimuste teisaldamisel (ID-d: {$a}).';
$string['errorpostprocess'] = 'Järeltöötluse ajal ilmnes tõrge.';
$string['errorpreprocess'] = 'Eeltöötluse ajal ilmnes tõrge.';
$string['errorprocess'] = 'Töötluse ajal ilmnes tõrge.';
$string['errorprocessingresponses'] = 'Teie vastuste töötlemisel ilmnes tõrge ({$a}). Eelmisele lehele naasmiseks ja uuesti proovimiseks klõpsake jätkamisnuppu.';
$string['errorsavingcomment'] = 'Küsimuse {$a->name} kommentaari salvestamisel tekkis andmebaasis viga.';
$string['errorsavingflags'] = 'Tõrge lipu oleku salvestamisel.';
$string['errorupdatingattempt'] = 'Uuendamise katse {$a->id} andmebaasis ebaõnnestus.';
$string['eventquestioncategorycreated'] = 'Küsimuste kategooria on loodud.';
$string['eventquestioncategorydeleted'] = 'Küsimuse kategooria kustutatud.';
$string['eventquestioncategorymoved'] = 'Küsimuse kategooria teisaldatud';
$string['eventquestioncategoryupdated'] = 'Küsimuse kategooria uuendatud';
$string['eventquestioncategoryviewed'] = 'Küsimuse kategooriat vaadatud';
$string['eventquestioncreated'] = 'Küsimus loodud';
$string['eventquestiondeleted'] = 'Küsimus kustutatud';
$string['eventquestionmoved'] = 'Küsimus teisaldatud';
$string['eventquestionsexported'] = 'Küsimused eksporditud';
$string['eventquestionsimported'] = 'Küsimused imporditud';
$string['eventquestionupdated'] = 'Küsimus uuendatud';
$string['eventquestionviewed'] = 'Küsimust vaadatud';
$string['export'] = 'Ekspordi';
$string['exportasxml'] = 'Ekspordi Moodle XML-ina';
$string['exportcategory'] = 'Ekspordikategooria';
$string['exportcategory_help'] = 'Selle sättega määratakse kategooria, kust eksporditavad küsimused võetakse.

Teatud impordivormingud (nt GIFT ja Moodle XML) lubavad kategooria- ja kontekstiandmed kaasata ekspordifaili, võimaldades need (valikuliselt) taasluua importimisel. Vajaduse korral tuleb märkida vastavad ruudud.';
$string['exporterror'] = 'Eksportimisel ilmnesid tõrked!';
$string['exportfilename'] = 'küsimused';
$string['exportnameformat'] = '%Y%m%d-%H%M';
$string['exportonequestion'] = 'Laadi see küsimus alla Moodle XML formaadis';
$string['exportquestions'] = 'Ekspordi küsimused faili';
$string['exportquestions_help'] = 'See funktsioon võimaldab eksportida faili kogu küsimuste kategooria (ja kõik alamkategooriad). Pange tähele, et olenevalt valitud failivormingust ei pruugita mõnesid küsimuseandmeid ega teatud küsimusetüüpe eksportida.';
$string['exportquestions_link'] = 'question/export';
$string['feedback'] = 'Tagasiside';
$string['filecantmovefrom'] = 'Küsimusefaile ei saa teisaldada, sest teil pole õigust eemaldada faile kohast, kust proovite küsimusi teisaldada.';
$string['filecantmoveto'] = 'Küsimusefaile ei saa teisaldada või kopeerida, sest teil pole õigust lisada faile kohta, kuhu proovite küsimusi teisaldada.';
$string['fileformat'] = 'Failivorming';
$string['filesareacourse'] = 'kursusefailide ala';
$string['filesareasite'] = 'saidifailide ala';
$string['filestomove'] = 'Kas teisaldada/kopeerida failid asukohta {$a}?';
$string['fillincorrect'] = 'Sisesta õiged vastused';
$string['filterbytags'] = 'Filtreeri siltide järgi';
$string['firsttry'] = 'Esimene katse';
$string['flagged'] = 'Lipuga märgitud';
$string['flagthisquestion'] = 'Märgi see küsimus lipuga';
$string['formquestionnotinids'] = 'Vorm sisaldas küsimust, mida pole küsimuste ID-de hulgas';
$string['fractionsnomax'] = 'Selleks et küsimuse eest võiks saada maksimumpunktid, peab ühe vastuse punktisumma vastama 100%-le.';
$string['generalfeedback'] = 'Üldine tagasiside';
$string['generalfeedback_help'] = 'Õppijale kuvatakse pärast küsimuse lõpetamist üldine tagasiside. Erinevalt konkreetsest tagasisidest, mis sõltub küsimuse tüübist ja õppija vastusest, on üldine tagasiside kõigile õppijatele alati sama.

Üldine tagasiside on hea võimalus anda õppijatele ülevaade õigetest vastustest ja lisateabe lingid, kui nende jaoks midagi arusaamatuks jäi.';
$string['getcategoryfromfile'] = 'Too kategooria failist';
$string['getcontextfromfile'] = 'Too kontekst failist';
$string['hintn'] = '{no}. vihje';
$string['hintnoptions'] = '{no}. vihje valikud';
$string['hinttext'] = 'Vihjetekst';
$string['howquestionsbehave'] = 'Küsimuste toimimisviis';
$string['howquestionsbehave_help'] = 'Õppijad saavad testi küsimustele vastata mitut moodi. Näiteks võite soovida, et õppijad vastaksid kõigile küsimustele ja esitaksid korraga kogu testi, et saaksite nende tööd hinnata ja tagasisidet anda. Seda nimetatakse viivitusega tagasiside režiimiks.

Teine võimalus on lasta õppijatel esitada iga küsimuse vastus jooksvalt, sellele kohe tagasisidet saada ja vale vastuse korral madalama hinde eest uuesti proovida. Seda nimetatakse mitme katsega interaktiivseks režiimiks.

Need on kaks kõige sagedamini kasutatavat vastamisrežiimi.';
$string['howquestionsbehave_link'] = 'question/behaviour';
$string['idnumber'] = 'ID number';
$string['idnumber_help'] = 'Kui seda kasutatakse, peab ID-number olema igas küsimuste kategoorias ainulaadne. See pakub teist moodust küsimuse tuvastamiseks, mis on mõnikord kasulik, kuid mille võib tavaliselt tühjaks jätta.';
$string['ignorebroken'] = 'Eira katkenud linke';
$string['import'] = 'Impordi';
$string['importcategory'] = 'Impordikategooria';
$string['importcategory_help'] = 'Selle sättega määratakse kategooria, kuhu imporditud küsimused paigutatakse.

Teatud impordivormingute korral (nt GIFT ja Moodle XML) võib impordifail sisaldada kategooria- ja kontekstiandmeid. Selleks et valitud kategooria asemel kasutada neid andmeid, tuleb märkida vastavad ruudud. Kui impordifailis määratud kategooriaid pole olemas, siis need luuakse.';
$string['importerror'] = 'Impordi töötlemise käigus ilmnes tõrge';
$string['importerrorquestion'] = 'Küsimuse importimisel ilmnes tõrge';
$string['importfromcoursefiles'] = '...või valige imporditav kursusefail.';
$string['importfromupload'] = 'Valige üleslaadimiseks fail...';
$string['importingquestions'] = 'Failist {$a} küsimuse importimine';
$string['importparseerror'] = 'Impordifaili sõelumisel on leitud vigu. Küsimusi pole imporditud. Vigadeta küsimuste importimiseks proovige sätte „Lõpeta vea korral“ väärtuseks seada uuesti Ei.';
$string['importquestions'] = 'Impordi küsimused failist';
$string['importquestions_help'] = 'See funktsioon võimaldab tekstifailiga importida mitmes vormingus küsimusi. Pöörake tähelepanu sellele, et failis tuleb kasutada UTF-8-kodeeringut.';
$string['importquestions_link'] = 'question/import';
$string['importwrongfiletype'] = 'Teie valitud faili tüüp ({$a->actualtype}) ei lange kokku selle impordivormingu korral eeldatava failitüübiga ({$a->expectedtype}).';
$string['impossiblechar'] = 'Sulumärgina tuvastati võimatu märk {$a}';
$string['includesubcategories'] = 'Kuva küsimused ka alamkategooriatest';
$string['incorrect'] = 'Vale';
$string['incorrectfeedback'] = 'Iga vale vastuse korral';
$string['incorrectfeedbackdefault'] = 'Teie vastus on vale.';
$string['information'] = 'Teave';
$string['invalidanswer'] = 'Mittetäielik vastus';
$string['invalidarg'] = 'Sobivaid argumente ei esitatud või on serveri konfiguratsioon vale';
$string['invalidcategoryidforparent'] = 'Emakategooria sobimatu ID!';
$string['invalidcategoryidtomove'] = 'Teisaldamiseks sobimatu kategooria ID!';
$string['invalidconfirm'] = 'Kinnitusstring oli vale';
$string['invalidcontextinhasanyquestions'] = 'Funktsiooni question_context_has_any_questions jaoks on sisestatud sobimatu kontekst.';
$string['invalidgrade'] = 'Hinded ({$a}) ei kattu hindevariantidega – küsimus jäeti vahele.';
$string['invalidpenalty'] = 'Sobimatu trahv';
$string['invalidwizardpage'] = 'Määratud on vale viisardileht või lehte pole määratud!';
$string['lastmodifiedby'] = 'Viimati muutnud:';
$string['lasttry'] = 'Viimane soorituskatse';
$string['linkedfiledoesntexist'] = 'Lingitud faili {$a}  ei eksisteeri';
$string['makechildof'] = 'Koosta kategooria „{$a}“ alamkategooria';
$string['makecopy'] = 'Tee koopia';
$string['maketoplevelitem'] = 'Teisalda ülatasemele';
$string['manualgradeinvalidformat'] = 'See arv ei sobi.';
$string['manualgradeoutofrange'] = 'See hinne on väljaspool sobivat vahemikku.';
$string['manuallygraded'] = 'Käsitsi hinnatud {$a->mark} järgmise kommentaariga: {$a->comment}';
$string['mark'] = 'Hindepunktid';
$string['markedoutof'] = 'Võimalik punktisumma';
$string['markedoutofmax'] = 'Võimalik punktisumma: {$a}';
$string['markoutofmax'] = 'Hindepunkte {$a->mark}/{$a->max}';
$string['marks'] = 'Hindepunktid';
$string['matchgrades'] = 'Vastenda hinded';
$string['matchgrades_help'] = 'Imporditud hinded peavad kattuma ühega fikseeritud hinneteloendis olevatest väärtustest: 100; 90; 80; 75; 70; 66,666; 60; 50; 40; 33,333; 30; 25; 20; 16,666; 14,2857; 12,5; 11,111; 10; 5; 0 (ka negatiivsed väärtused). Loendist puuduva hinde korral on saadaval kaks valikut.

* Kui hinne pole loendis, kuva viga – kui küsimus sisaldab hinnet, mida pole loendis, kuvatakse veateade ja seda küsimust ei impordita.
* Kui hinne pole loendis, vali lähim hinne – kui leitud hinne ei kattu mõne loendis oleva väärtusega, asendatakse see loendis oleva lähima väärtusega.';
$string['matchgradeserror'] = 'Kui hinne pole loendis, kuva viga';
$string['matchgradesnearest'] = 'Kui hinne pole loendis, vali lähim hinne';
$string['missingcourseorcmid'] = 'Funktsiooni print_question jaoks on vaja sisestada parameeter courseid või cmid.';
$string['missingcourseorcmidtolink'] = 'Funktsiooni get_question_edit_link jaoks on vaja sisestada parameeter courseid või cmid.';
$string['missingimportantcode'] = 'Sellel küsimusetüübil on puudu oluline kood: {$a}.';
$string['missingoption'] = 'Cloze-küsimusel {$a} puuduvad valikud';
$string['modified'] = 'Viimati salvestatud';
$string['move'] = 'Teisalda asukohast {$a} ja muuda lingid.';
$string['movecategory'] = 'Teisalda kategooria';
$string['movedquestionsandcategories'] = 'Küsimused ja küsimusekategooriad on teisaldatud asukohast {$a->oldplace} asukohta {$a->newplace}.';
$string['movelinksonly'] = 'Muutke vaid asukohta, millele lingid osutavad, ärge teisaldage ega kopeerige faile.';
$string['moveq'] = 'Teisalda küsimus(ed)';
$string['moveqtoanothercontext'] = 'Teisalda küsimus teise konteksti.';
$string['moveto'] = 'Teisalduskoht >>';
$string['movingcategory'] = 'Kategooria teisaldamine';
$string['movingcategoryandfiles'] = 'Kas soovite kindlasti teisaldada kategooria „{$a->name}“ ja kõik alamkategooriad üksuse „{$a->contextto}“ konteksti?<br /> Oleme leidnud {$a->urlcount} faili, mis on lingitud alas {$a->fromareaname} olevate küsimustega. Kas soovite need kopeerida või teisaldada alasse {$a->toareaname}?';
$string['movingcategorynofiles'] = 'Kas soovite kindlasti teisaldada kategooria „{$a->name}“ ja kõik alamkategooriad üksuse „{$a->contextto}“ konteksti?';
$string['movingquestions'] = 'Küsimuste ja failide teisaldamine';
$string['movingquestionsandfiles'] = 'Kas soovite kindlasti teisaldada küsimuse(d) {$a->questions} üksuse <strong>„{$a->tocontext}“</strong> konteksti?<br /> Oleme leidnud <strong>{$a->urlcount} faili</strong>, mis on lingitud alas {$a->fromareaname} olevate küsimustega. Kas soovite need kopeerida või teisaldada alasse {$a->toareaname}?';
$string['movingquestionsnofiles'] = 'Kas soovite kindlasti teisaldada küsimuse(d) {$a->questions} üksuse <strong>„{$a->tocontext}“</strong> konteksti?<br /> Nende alas {$a->fromareaname} olevate küsimustega <strong>pole faile</strong> lingitud.';
$string['needtochoosecat'] = 'Selle küsimuse teisaldamiseks on sul vaja valida kategooria või vajutada \'cancel\'.';
$string['nocate'] = 'Kategooriat {$a} pole olemas!';
$string['nopermissionadd'] = 'Teil pole õigust siia küsimusi lisada.';
$string['noprobs'] = 'Sinu küsimuste andmebaasis ei ei leitud probleeme.';
$string['noquestions'] = 'Ei leitud ühtegi eksporditavat küsimust. Veenduge, et eksportimiseks oleks valitud selline kategooria, mis sisaldab küsimusi.';
$string['noquestionsinfile'] = 'Impordifailis pole küsimusi';
$string['noresponse'] = '[Vastusei pole]';
$string['notagfiltersapplied'] = 'Ühtegi sildifiltrit pole lisatud';
$string['notanswered'] = 'Pole vastatud';
$string['notchanged'] = 'Muutmata viimasest heakskiidust alates';
$string['notenoughanswers'] = 'Seda tüüpi küsimusel peab olema vähemalt {$a} vastust';
$string['notenoughdatatoeditaquestion'] = 'Küsimuse ID-d, kategooria ID-d ega küsimusetüüpi polnud määratud.';
$string['notenoughdatatomovequestions'] = 'Küsimuste teisaldamisel pead lisadama küsimuste ID-d';
$string['notgraded'] = 'Hindamata';
$string['notshown'] = 'Pole kuvatud';
$string['notyetanswered'] = 'Pole veel vastatud';
$string['notyourpreview'] = 'See eelvaade ei kuulu teile';
$string['novirtualquestiontype'] = 'Küsimustüübil {$a} pole ühtegi virtuaalset küsimust';
$string['numqas'] = 'Küsimusele vastamise katsete arv';
$string['numquestions'] = 'Küsimuste arv';
$string['numquestionsandhidden'] = '{$a->numquestions} (+{$a->numhidden} peidetud)';
$string['options'] = 'Valikud';
$string['page-question-category'] = 'Küsimuste kategooria leht';
$string['page-question-edit'] = 'Küsimuste redigeerimise leht';
$string['page-question-export'] = 'Küsimuste ekspordi leht';
$string['page-question-import'] = 'Küsimuste impordi leht';
$string['page-question-x'] = 'Mis tahes küsimuste leht';
$string['parent'] = 'Ülem';
$string['parentcategory'] = 'Ülemkategooria';
$string['parentcategory_help'] = 'Ülemkategooria on see kategooria, kuhu uus kategooria paigutatakse. „Ülatase“ tähendab seda, et see kategooria ei kuulu ühessegi teise kategooriasse. Kategooria kontekstid kuvatakse paksus kirjas. Igas kontekstis peab olema vähemalt üks kategooria.';
$string['parentcategory_link'] = 'question/category';
$string['parenthesisinproperclose'] = 'Tärnidele (**) eelnev lõpusulg on puudu: {$a}**';
$string['parenthesisinproperstart'] = 'Tärnidele (**) eelnev algussulg on puudu: {$a}**';
$string['parsingquestions'] = 'Impordifaili küsimuste sõelumine.';
$string['partiallycorrect'] = 'Osaliselt õige';
$string['partiallycorrectfeedback'] = 'Iga osaliselt õige vastuse korral';
$string['partiallycorrectfeedbackdefault'] = 'Teie vastus on osaliselt õige.';
$string['penaltyfactor'] = 'Trahvitegur';
$string['penaltyfactor_help'] = 'See säte määrab, milline saadud punktisumma murdosa lahutatakse iga vale vastuse korral. Seda saab rakendada ainult siis, kui test on käivitatud adaptiivrežiimis.

Trahvitegur peab olema number vahemikus 0–1. Trahvitegur 1 tähendab seda, et õppija saab punkte ainult siis, kui vastab õigesti kohe esimesel korral. Trahvitegur 0 tähendab seda, et õppija võib proovida nii palju kordi, kui soovib, ja saada ikkagi maksimumhindepunktid.';
$string['penaltyforeachincorrecttry'] = 'Trahv iga vale vastamiskatse korral';
$string['penaltyforeachincorrecttry_help'] = 'Kui küsimust käitatakse režiimis „Interaktiivne, mitme katsega“ või „Adaptiivrežiim“, nii et õppija saab vastata proovida mitu korda, siis määrab see valik, kui palju neid iga vale katse eest trahvitakse.

Trahv on proportsionaalne osa küsimuse koguhindest, seega kui küsimuse väärtus on kolm hindepunkti ja trahv on 0,3333333, siis saab õppija esimesel katsel õigesti vastates kolm punkti, teisel katsel kaks punkti, ja kui ta saab õige vastuse kolmandal katsel, siis ühe punkti.';
$string['permissionedit'] = 'Redigeeri seda küsimust';
$string['permissionmove'] = 'Nihuta seda küsimust';
$string['permissionsaveasnew'] = 'Salvesta see uue küsimusena';
$string['permissionto'] = 'Teil on õigus teha järgmist:';
$string['previewquestion'] = 'Kuva küsimuse eelvaade: {$a}';
$string['privacy:metadata:database:question'] = 'Konkreetse küsimuse üksikasjad.';
$string['privacy:metadata:database:question:createdby'] = 'Küsimuse loonud inimene.';
$string['privacy:metadata:database:question:generalfeedback'] = 'Üldine tagasiside küsimuse kohta.';
$string['privacy:metadata:database:question:modifiedby'] = 'Viimati küsimusti uuendanud inimene.';
$string['privacy:metadata:database:question:name'] = 'Küsimuse nimi.';
$string['privacy:metadata:database:question:questiontext'] = 'Küsimuse tekst.';
$string['privacy:metadata:database:question:timecreated'] = 'Küsimuse loomise kuupäev ja aeg.';
$string['privacy:metadata:database:question:timemodified'] = 'Küsimuse kustutamise kuupäev ja aeg.';
$string['privacy:metadata:database:question_attempt_step_data'] = 'Küsimiskatse toimingutel võib olla selle sammu kohta täiendavaid andmeid. Andmed salvestatakse tabelis step_data.';
$string['privacy:metadata:database:question_attempt_step_data:name'] = 'Andmeühiku nimi';
$string['privacy:metadata:database:question_attempt_step_data:value'] = 'Andmeühiku väärtus';
$string['privacy:metadata:database:question_attempt_steps'] = 'Igal küsimusekatsel on mitu sammu, et näidata erinevaid etappe algusest lõpuni kuni märgistamiseni. Selles tabelis on salvestatud teave kõigi nende sammude kohta.';
$string['privacy:metadata:database:question_attempt_steps:fraction'] = 'Selle küsimuse katse eest antud hinne muudeti väärtuseks 1.';
$string['privacy:metadata:database:question_attempt_steps:state'] = 'Selle küsimuse katse olek astme ülemineku lõpus.';
$string['privacy:metadata:database:question_attempt_steps:timecreated'] = 'Selle tegevuse alguse kuupäev ja aeg.';
$string['privacy:metadata:database:question_attempt_steps:userid'] = 'Kasutaja, kes sooritas sammu ülemineku.';
$string['privacy:metadata:database:question_attempts'] = 'Teave konkreetse küsimuse katse kohta.';
$string['privacy:metadata:database:question_attempts:flagged'] = 'Märge selle kohta, et kasutaja on selle küsimuse lipuga märkinud.';
$string['privacy:metadata:database:question_attempts:responsesummary'] = 'Küsimuse vastuse kokkuvõte.';
$string['privacy:metadata:database:question_attempts:timemodified'] = 'Küsimuse katse värskendamise aeg.';
$string['privacy:metadata:link:qbehaviour'] = 'Küsimuste alamsüsteem kasutab küsimuste käitumise (Question Behaviour) plugina tüüpi.';
$string['privacy:metadata:link:qformat'] = 'Küsimuste allsüsteem kasutab küsimuste importimiseks ja eksportimiseks erinevas vormingus plugina tüüpi Küsimuse vorming.';
$string['privacy:metadata:link:qtype'] = 'Küsimuste alamsüsteem suhtleb küsimuste tüübi plugina tüübiga (Question type plugintype) mis sisaldab erinevat tüüpi küsimusi.';
$string['published'] = 'jagatud';
$string['qtypeveryshort'] = 'T';
$string['questionaffected'] = '<a href="{$a-> qurl} "> Küsimus" {$a->name}" ({$a->qtype})</a>kuulub sellesse küsimusekategooriasse, kuid seda kasutatakse ka jaotises <a href ="{$a->qurl}"> test
"{$a->quizname}"</a>teisel kursusel "{$a->coursename}".';
$string['questionbank'] = 'Küsimustepank';
$string['questionbehaviouradminsetting'] = 'Küsimuste toimimisviiside sätted';
$string['questionbehavioursdisabled'] = 'Keelatavad küsimuste toimimisviisid';
$string['questionbehavioursdisabledexplained'] = 'Sisestage loend toimimisviisidest, mida te ei soovi rippmenüüs kuvada (eraldage loendiüksused komadega)';
$string['questionbehavioursorder'] = 'Küsimuste toimimisviiside järjestus';
$string['questionbehavioursorderexplained'] = 'Sisestage toimimisviiside loend sellises järjestuses, nagu soovite selle kuvada rippmenüüs (eraldage loendiüksused komadega)';
$string['questioncategories'] = 'Küsimuse kategooriad';
$string['questioncategory'] = 'Küsimusekategooria';
$string['questioncatsfor'] = 'Küsimusekategooriad: {$a}';
$string['questiondoesnotexist'] = 'Seda küsimust pole olemas';
$string['questionformtagheader'] = '{$a} sildid';
$string['questionidmismatch'] = 'Küsimuse-ID-d ei ühti';
$string['questionname'] = 'Küsimuse nimi';
$string['questionnamecopy'] = '{$a} (koopia)';
$string['questionno'] = 'Küsimus {$a}';
$string['questionpreviewdefaults'] = 'Küsimuse eelvaate vaikesätted';
$string['questionpreviewdefaults_desc'] = 'Neid vaikeväärtusi kasutatakse siis, kui kasutaja kuvab küsimusepanga küsimuse eelvaate esimest korda. Kui kasutaja on küsimuse eelvaate juba kuvanud, salvestatakse kasutajaeelistustena nende isiklikud eelistused.';
$string['questions'] = 'Küsimused';
$string['questionsaveerror'] = 'Küsimuse ({$a}) salvetamise ajal tekkis tõrge';
$string['questionsinuse'] = '(* Tärniga märgitud küsimused on mõnes õppetestis juba kasutusel. Neid küsimusi ei kustutata nendest testidest, vaid ainult kategoorialoendist.)';
$string['questionsmovedto'] = 'Kasutusel olevad küsimused on teisaldatud ülemkursuse kategooria konteksti "{$a}".';
$string['questionsrescuedfrom'] = 'Küsimused on salvestatud kontekstist {$a}.';
$string['questionsrescuedfrominfo'] = 'Kui kontekst {$a} kustutati, siis need küsimused (mõned neist võivad olla peidetud) salvestati, sest need on veel kasutusel mõnes muus testis või tegevuses.';
$string['questiontags'] = 'Küsimuse sildid';
$string['questiontext'] = 'Küsimuse tekst';
$string['questiontype'] = 'Küsimuse tüüp';
$string['questionuse'] = 'Kasuta küsmust selles tegevuses';
$string['questionvariant'] = 'Küsimuse variant';
$string['questionx'] = 'Küsimus {$a}';
$string['requiresgrading'] = 'Vajab hindamist';
$string['responsehistory'] = 'Vastuste ajalugu';
$string['restart'] = 'Alusta uuesti';
$string['restartwiththeseoptions'] = 'Alusta nende valikutega uuesti';
$string['restoremultipletopcats'] = 'Varukoopia fail sisaldab rohkem kui ühte konteksti kõrgemat küsimustekategooriat {$a}.';
$string['reviewresponse'] = 'Vaata vastus läbi';
$string['rightanswer'] = 'Õige vastus';
$string['rightanswer_help'] = 'automaatselt loodud kokkuvõte õigest vastusest. See võib olla piiratud, seega soovitatav on see säte välja lülitada ja selgitada õiget lahendust küsimuse üldises tagasisides.';
$string['save'] = 'Salvesta';
$string['savechangesandcontinueediting'] = 'Salvesta muudatused ja jätka muutmist';
$string['saved'] = 'Salvestatud: {$a}';
$string['saveflags'] = 'Salvesta lippude olek';
$string['selectacategory'] = 'Valige kategooria:';
$string['selectaqtypefordescription'] = 'Kirjelduse vaatamiseks valige küsimusetüüp.';
$string['selectcategoryabove'] = 'Valige ülalt kategooria';
$string['selectquestionsforbulk'] = 'Valige hulgitoiminguteks küsimused';
$string['settingsformultipletries'] = 'Mitu katset';
$string['shareincontext'] = 'Jaga kontekstis: {$a}';
$string['showhidden'] = 'Kuva ka vanad küsimused';
$string['showmarkandmax'] = 'Kuva hindepunktid ja maksimum';
$string['showmaxmarkonly'] = 'Kuva ainult maksimumhindepunktid';
$string['shown'] = 'Kuvatud';
$string['shownumpartscorrect'] = 'Kuva õigete vastuste arv';
$string['shownumpartscorrectwhenfinished'] = 'Kuva pärast küsimuse lõpetamist õigete vastuste arv';
$string['showquestiontext'] = 'Kuva küsimuste loendis küsimuse tekst';
$string['specificfeedback'] = 'Konkreetne tagasiside';
$string['specificfeedback_help'] = 'Tagasiside, mis sõltub õppuri antud vastusest.';
$string['started'] = 'Alustatud';
$string['state'] = 'Olek';
$string['step'] = 'Toiming';
$string['steps'] = 'Sammud';
$string['stoponerror'] = 'Lõpeta vea korral';
$string['stoponerror_help'] = 'Selle sättega saate määrata, kas vigade tuvastamise korral lõpetatakse importimine, nii et ühtegi küsimust ei impordita, või eiratakse vigu sisaldavaid küsimusi ja imporditakse kõik vigadeta küsimused.';
$string['submissionoutofsequence'] = 'Jõudsite siia väljaspool õiget järjekorda. Ärge klõpsake õppetesti küsimustele vastamise ajal tagasiminekunuppu.';
$string['submissionoutofsequencefriendlymessage'] = 'Olete sisestanud andmeid väljaspool tavajärjekorda. See võib juhtuda siis, kui kasutate brauseri nuppe „Tagasi“ ja „Edasi“. Ärge kasutage neid nuppe testi tegemise ajal. See võib juhtuda ka siis, kui klõpsate midagi lehe laadimise ajal. Klõpsake jätkamiseks nuppu <strong>Jätka</strong>.';
$string['submit'] = 'Esita';
$string['submitandfinish'] = 'Esita ja lõpeta';
$string['submitted'] = 'Esita: {$a}';
$string['tagarea_question'] = 'Küsimused';
$string['technicalinfo'] = 'Tehniline teave';
$string['technicalinfo_help'] = 'See tehniline teave on arvatavasti kasulik vaid arendajatele, kes tegelevad uute küsimusetüüpide väljatöötamisega. Samas võib sellest teabest olla kasu ka küsimustega seotud probleemide diagnoosimisel.';
$string['technicalinfomaxfraction'] = 'Maksimumosa: {$a}';
$string['technicalinfominfraction'] = 'Miinimumosa: {$a}';
$string['technicalinfoquestionsummary'] = 'Küsimuse kokkuvõte: {$a}';
$string['technicalinforesponsesummary'] = 'Vastuste kokkuvõte: {$a}';
$string['technicalinforightsummary'] = 'Õige vastuse kokkuvõte: {$a}';
$string['technicalinfostate'] = 'Küsimuse olek: {$a}';
$string['technicalinfovariant'] = 'Küsimuse variant: {$a}';
$string['tofilecategory'] = 'Kirjuta kategooria faili';
$string['tofilecontext'] = 'Kirjuta kontekst faili';
$string['topfor'] = 'Peamine {$a}';
$string['uninstallbehaviour'] = 'Saate selle küsimuste toimimisviisi desinstallida.';
$string['uninstallqtype'] = 'Saate selle küsimusetüübi desinstallida.';
$string['unknown'] = 'Teadmata';
$string['unknownbehaviour'] = 'Tundmatu toimimisviis: {$a}.';
$string['unknownorunhandledtype'] = 'Tundmatu või käsitlematu küsimusetüüp: {$a}';
$string['unknownquestion'] = 'Tundmatu küsimus: {$a}.';
$string['unknownquestioncatregory'] = 'Tundmatu küsimusekategooria: {$a}.';
$string['unknownquestiontype'] = 'Tundmatu küsimusetüüp: {$a}.';
$string['unknowntolerance'] = 'Tundmatu lubatava hälbe tüüp {$a}';
$string['unpublished'] = 'mittejagatud';
$string['unusedcategorydeleted'] = 'See kategooria on kustutatud, kuna pärast kursuse kustutamist ei kasutatud enam selle kategooria küsimusi.';
$string['updatedisplayoptions'] = 'Värskenda kuvamissätteid';
$string['upgradeproblemcategoryloop'] = 'Küsimuste kategooriate uuendamisel tekkis viga. Kategooriapuus on viga. Mõjutatud kategooriate ID-d on {$a}.';
$string['upgradeproblemcouldnotupdatecategory'] = 'Küsimuse kategooria {$a->name} ({$a->id}) uuendamine ebaõnnestus.';
$string['upgradeproblemunknowncategory'] = 'Küsimuste kategooriate uuendamisel tekkis viga. Kategooria {$a->id}  viitab ülemkategooriale {$a->parent}, mida ei eksisteeri. Probleemi lahendamiseks muudeti ülemkategooriat.';
$string['whethercorrect'] = 'Kas on õige';
$string['whethercorrect_help'] = 'See hõlmab nii tekstilist kirjeldust („Õige“, „Osaliselt õige“ või „Vale“) ja värvilist esiletõstu, mis tähendab sisuliselt sama.';
$string['whichtries'] = 'Mis katsed';
$string['withselected'] = 'Valitutega';
$string['wrongprefix'] = 'Vale formaadiga eelseadistus {$a}';
$string['xoutofmax'] = '{$a->mark}/{$a->max}';
$string['yougotnright'] = 'Olete õigesti valinud {$a->num}.';
$string['youmustselectaqtype'] = 'Peate valima küsimusetüübi.';
$string['yourfileshoulddownload'] = 'Teie ekspordifaili allalaadimine peaks algama mõne hetke pärast. Kui allalaadimine ei käivitu, <a href="{$a}">klõpsake siin</a>.';
