<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'webservice', language 'da', version '5.0'.
 *
 * @package     webservice
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessexception'] = 'Undtagelse fra adgangskontrol';
$string['actwebserviceshhdr'] = 'Aktive webservice-protokoller';
$string['addaservice'] = 'Tilføj service';
$string['addcapabilitytousers'] = 'Tjek brugers rettighed';
$string['addcapabilitytousersdescription'] = 'Brugere skal have to rettigheder – webservice:createtoken og en rettighed, der matcher de anvendte protokoller, for eksempel webservice/rest:use, webservice/soap:use. For at opnå dette skal der oprettes en webtjenesterolle med de relevante rettigheder tilladt og tildeles webtjenestebrugeren som en systemrolle';
$string['addexternalservice'] = 'Tilføj ekstern tjeneste.';
$string['addfunction'] = 'Tilføj funktion';
$string['addfunctionhelp'] = 'Vælg den funktion der skal tilføjes servicen.';
$string['addfunctions'] = 'Tilføj funktioner';
$string['addfunctionsdescription'] = 'Vælg krævede funktioner for den nyligt oprettede service.';
$string['addrequiredcapability'] = 'Tildel/fratag den krævederettighed';
$string['addservice'] = 'Tilføj en ny service: {$a->name} (id: {$a->id})';
$string['addservicefunction'] = 'Tilføj funktioner til servicen "{$a}"';
$string['allusers'] = 'Alle brugere';
$string['apiexplorer'] = 'API-udforsker.';
$string['apiexplorernotavalaible'] = 'API explorer endnu ikke tilgængelig';
$string['arguments'] = 'Argumenter';
$string['authmethod'] = 'Godkendelsesmetode';
$string['callablefromajax'] = 'Muligt via AJAX';
$string['cannotcreatetoken'] = 'Ingen tilladelse til oprettelse af webservice-token til denne service, {$a}.';
$string['checkusercapability'] = 'Tjek brugerrettigheder';
$string['checkusercapabilitydescription'] = 'Brugeren skal have relevante rettigheder i henhold til de anvendte protokoller, for eksempel webservice/rest:use, webservice/soap:use. For at opnå dette skal der oprettes en webtjenesterolle med protokollrettigheder tilladt og tildeles webtjenestebrugeren som en systemrolle';
$string['configwebserviceplugins'] = 'Af sikkerhedsmæssige årsager kan kun protokoller, der er i brug, aktiveres.';
$string['context'] = 'Kontekst';
$string['createservicedescription'] = 'En tjeneste er et sæt af webtjenestefunktioner. Du vil give brugeren adgang til en ny tjeneste. På siden <strong>Tilføj tjeneste</strong> skal du markere indstillingerne \'Aktiver\' og \'Autoriserede brugere\'. Vælg \'Ingen påkrævet rettighed\'';
$string['createserviceforusersdescription'] = 'En tjeneste er et sæt af webtjenestefunktioner. Du vil give brugere adgang til en ny tjeneste. På siden <strong>Tilføj tjeneste</strong> skal du markere indstillingen \'Aktiver\' og fjerne markeringen af \'Autoriserede brugere\'. Vælg \'Ingen påkrævet rettighed\'';
$string['createtoken'] = 'Opret token';
$string['createtokenforuser'] = 'Opret token for en bruger';
$string['createtokenforuserdescription'] = 'Opret token for en webservices-bruger';
$string['createuser'] = 'Opret specifik bruger';
$string['createuserdescription'] = 'En webservice-bruger kræves til at repræsentere systemet der kontrollerer Moodle.';
$string['criteriaerror'] = 'Mangler tilladelser til at søge på et kriterium.';
$string['default'] = 'Standard for "{$a}"';
$string['deleteaservice'] = 'Slet service';
$string['deleteservice'] = 'Slet servicen: {$a->name} (id: {$a->id})';
$string['deleteserviceconfirm'] = 'Sletning af en service vil også slette tokens relateret til den. Er du sikker på at du vil slette den eksterne service "{$a}"?';
$string['deletetoken'] = 'Slet token.';
$string['deletetokenconfirm'] = 'Bekræft at du vil slette denne webservice-token for <strong>{$a->user}</strong> på servicen <strong>{$a->service}</strong>.';
$string['deprecated'] = 'Udfaset.';
$string['disabledwarning'] = 'Alle webservice-protokoller er deaktiverede. Indstillingen "Aktiver webservices" findes under "Avancerede funktioner".';
$string['doc'] = 'Dokumentation';
$string['docaccessrefused'] = 'Du har ikke tilladelse til at se dokumentation for denne token';
$string['downloadfiles'] = 'Kan downloade filer';
$string['downloadfiles_help'] = 'Er indstillingen aktiveret, kan brugere downloade filer med deres sikkerhedsnøgle. Naturligvis er de fortsat begrænset til de filer som de har tilladelse til at downloade på sitet.';
$string['editaservice'] = 'Rediger service';
$string['editexternalservice'] = 'Rediger ekstern tjeneste.';
$string['editservice'] = 'Rediger servicen: {$a->name} (id: {$a->id})';
$string['enabled'] = 'Aktiveret';
$string['enabledocumentation'] = 'Aktiver udviklerdokumentation';
$string['enabledocumentationdescription'] = 'Detaljeret dokumentation for webservices er tilgængelig for aktiverede protokoller.';
$string['enableprotocols'] = 'Aktiver protokoller';
$string['enableprotocolsdescription'] = 'Mindst en protokol bør aktiveres. Af sikkerhedsmæssige årsager bør kun protokoller i brug aktiveres.';
$string['enablews'] = 'Aktiver webservices';
$string['enablewsdescription'] = 'Webservices skal være aktiveret under Avancerede funktioner.';
$string['entertoken'] = 'Tast en sikkerhedsnøgle/token:';
$string['error'] = 'Fejl: {$a}';
$string['errorcatcontextnotvalid'] = 'Du kan ikke eksekvere funktioner i kategorikonteksten (category id:{$a->catid}). Kontekstens fejlbesked var: {$a->message}';
$string['errorcodes'] = 'Fejlbesked';
$string['errorcoursecontextnotvalid'] = 'Du kan ikke eksekvere funktioner i kursuskonteksten (course id:{$a->courseid}). Kontekstens fejlbesked var: {$a->message}';
$string['errorinvalidparam'] = 'Parameteren "{$a}" er ugyldig.';
$string['errornotemptydefaultparamarray'] = 'Webservice-beskrivelsens parameter, {$a}, har en enkelt eller flersidet struktur. Standard kan kun være en tom række. Tjek webservice-beskrivelsen.';
$string['erroroptionalparamarray'] = 'Webservice-beskrivelsens parameter, {$a}, er en enkelt eller flersidet struktur. Den kan ikke have VALUE_OPTIONAL. Tjek webservice-beskrivelsen.';
$string['eventwebservicefunctioncalled'] = 'Webservice-funktion kaldt';
$string['eventwebserviceloginfailed'] = 'Webservice-login mislykkedes';
$string['eventwebserviceservicecreated'] = 'Webservice oprettet';
$string['eventwebserviceservicedeleted'] = 'Webservice slettet';
$string['eventwebserviceserviceupdated'] = 'Webservice opdateret';
$string['eventwebserviceserviceuseradded'] = 'Webservice-bruger tilføjet';
$string['eventwebserviceserviceuserremoved'] = 'Webservice-bruger slettet';
$string['eventwebservicetokencreated'] = 'Webservice-token oprettet';
$string['eventwebservicetokensent'] = 'Webservice-token sendt';
$string['execute'] = 'Udfør';
$string['executewarnign'] = 'ADVARSEL: Hvis du trykker eksekver vil din database blive ændret, og ændringerne kan ikke automatisk tilbageføres!';
$string['externalservice'] = 'Ekstern service';
$string['externalservicefunctions'] = 'Eksterne servicefunktioner';
$string['externalservices'] = 'Eksterne services';
$string['externalserviceusers'] = 'Eksterne servicebrugere';
$string['failedtolog'] = 'Mislykkedes at logge';
$string['filenameexist'] = 'Filnavnet eksisterer allerede: {$a}';
$string['forbiddenwsuser'] = 'Kan ikke oprette token for en ubekræftet, slettet, suspenderet bruger eller gæst.';
$string['function'] = 'Funktion';
$string['functions'] = 'Funktioner';
$string['generalstructure'] = 'Generel struktur';
$string['information'] = 'Information';
$string['installexistingserviceshortnameerror'] = 'En webservice med det korte navn "{$a}" er allerede i brug. Kan ikke installere/opdatere en anden service med dette korte navn.';
$string['installserviceshortnameerror'] = 'Kodningsfejl: servicens korte navn, "{$a}", kan kun indeholde alfanumeriske tegn (tal og bogstaver), understregning (_), bindestreg (-) eller punktum (.)';
$string['invalidextparam'] = 'Ugyldig ekstern api-parameter: {$a}';
$string['invalidextresponse'] = 'Ugyldig ekstern api-respons: {$a}';
$string['invalidiptoken'] = 'Ugyldig token - din IP understøttes ikke';
$string['invalidtimedtoken'] = 'Ugyldig token - token udløbet';
$string['invalidtoken'] = 'Ugyldig token - token blev ikke fundet';
$string['iprestriction'] = 'IP-restriktion';
$string['iprestriction_help'] = 'Brugeren vil skulle kalde webservicen fra de listede (kommaseparerede) IP-adresser.';
$string['key'] = 'Nøgle';
$string['keyshelp'] = 'Nøglen bruges til at få adgang til din Moodlekonto fra eksterne applikationer.';
$string['loginrequired'] = 'Begrænset til brugere der er logget ind';
$string['manageprotocols'] = 'Administrer protokoller';
$string['managetokens'] = 'Administrer tokens';
$string['missingcaps'] = 'Manglende rettigheder';
$string['missingcaps_help'] = 'Liste over rettigheder, der er angivet af tjenesten, som brugeren ikke har. Nogle funktioner i tjenesten er muligvis ikke tilgængelige uden disse rettigheder';
$string['missingpassword'] = 'Manglende adgangskode';
$string['missingrequiredcapability'] = 'Rettigheden {$a} kræves.';
$string['missingusername'] = 'Manglende brugernavn';
$string['nameexists'] = 'Dette navn bruges allerede af en anden service';
$string['nocapabilitytouseparameter'] = 'Brugeren har ikke de krævede rettigheder til at bruge denne parameter {$a}';
$string['nofunctions'] = 'Denne service har ingen funktioner';
$string['norequiredcapability'] = 'Ingen krævede rettigheder';
$string['notoken'] = 'Token-listen er tom';
$string['onesystemcontrolling'] = 'Tillad et eksternt system at kontrollere Moodle';
$string['onesystemcontrollingdescription'] = 'De følgende trin hjælper dig med opsætning af Moodles webservicer for at tillade et eksternt system at interagere med Moodle. Dette indbefatter opsætning af en token- (sikkerhedsnøgle) godkendelsesmetode.';
$string['onlyseecreatedtokens'] = 'Du kan kun se tokens du selv har oprettet.';
$string['operation'] = 'Operation';
$string['optional'] = 'Valgfri';
$string['passwordisexpired'] = 'Adgangskoden er udløbet.';
$string['phpparam'] = 'XML-RPC (PHP-struktur)';
$string['phpresponse'] = 'XML-RPC (PHP-struktur)';
$string['postrestparam'] = 'PHP-kode for REST (POST request)';
$string['potusers'] = 'Ikke godkendte brugere';
$string['potusersmatching'] = 'Ikke godkendte brugere der matcher';
$string['print'] = 'Print alle';
$string['privacy:metadata'] = 'Webservice API\'en gemmer ingen data.';
$string['protocol'] = 'Protokol';
$string['removefunction'] = 'Slet';
$string['removefunctionconfirm'] = 'Vil du virkelig fjerne funktionen "{$a->function}" fra servicen "{$a->service}"?';
$string['requireauthentication'] = 'Denne metode kræver godkendelse med xxx tilladelse.';
$string['required'] = 'Obligatorisk';
$string['requiredcapability'] = 'Obligatorisk rettighed';
$string['requiredcapability_help'] = 'Er indstillingen aktiveret, vil kun brugere med de krævede rettigheder have adgang til servicen.';
$string['requiredcaps'] = 'Krævede rettigheder';
$string['resettokencomplete'] = 'Det valgte token er blevet nulstillet.';
$string['resettokenconfirm'] = 'Bekræft at du vil nulstille denne webservice-nøgle for <strong>{$a->user}</strong> på servicen <strong>{$a->service}</strong>.';
$string['resettokenconfirmsimple'] = 'Vil du virkelig nulstille denne nøgle? Alle gemte links med den gamle nøgle vil ikke virke længere.';
$string['response'] = 'Respons';
$string['restcode'] = 'REST';
$string['restexception'] = 'REST';
$string['restoredaccountresetpassword'] = 'Gendannet konto skal have ny adgangskode for at kunne få en token.';
$string['restparam'] = 'REST (POST-parametre)';
$string['restrictedusers'] = 'Kun godkendte brugere';
$string['restrictedusers_help'] = 'Indstillingen styrer hvorvidt alle brugere med tilladelse til at oprette webservice-token kan generere en token for denne service via deres sikkerhedsnøgleside, eller om kun autoriserede brugere kan det.';
$string['securitykey'] = 'Sikkerhedsnøgle (token)';
$string['securitykeys'] = 'Sikkerhedsnøgler';
$string['selectauthorisedusers'] = 'Vælg godkendte brugere';
$string['selectedcapability'] = 'Udvalgt';
$string['selectedcapabilitydoesntexit'] = 'De aktuelle krævede rettigheder ({$a}) eksisterer ikke længere. Ændr det og gem ændringerne.';
$string['selectservice'] = 'Vælg en service';
$string['selectspecificuser'] = 'Vælg en specifik bruger';
$string['selectspecificuserdescription'] = 'Tilføj webservice-brugeren som en godkendt bruger.';
$string['service'] = 'Service';
$string['servicehelpexplanation'] = 'En service er et sæt funktioner. En service kan tilgås af alle brugere eller kun af specificerede brugere.';
$string['servicename'] = 'Servicenavn';
$string['servicenotavailable'] = 'Webservice er ikke tilgængelig. (Den eksisterer ikke eller kan være deaktiveret)';
$string['servicerequireslogin'] = 'Webservice er ikke tilgængelig. (Sessionen er logget ud eller er udløbet.)';
$string['servicesbuiltin'] = 'Indbyggede servicer';
$string['servicescustom'] = 'Brugerdefinerede servicer';
$string['serviceusers'] = 'Godkendte brugere';
$string['serviceusersettings'] = 'Brugerindstillinger';
$string['serviceusersmatching'] = 'Godkendte brugere der matcher';
$string['serviceuserssettings'] = 'Rediger indstillinger for godkendte brugere';
$string['shortnametaken'] = 'Det korte navn bruges allerede til en anden service ({$a})';
$string['simpleauthlog'] = 'Simpel godkendelses-login';
$string['step'] = 'Trin';
$string['supplyinfo'] = 'Yderligere oplysninger';
$string['testauserwithtestclientdescription'] = 'Simuler ekstern adgang til tjenesten ved hjælp af webtjenestens testklient. Før du gør dette, skal du logge ind som en bruger med rettigheden moodle/webservice:createtoken og hente sikkerhedsnøglen (token) via brugerens indstillingsside. Du vil bruge dette token i testklienten. I testklienten skal du også vælge en aktiveret protokol med token-godkendelse. <strong>ADVARSEL: De funktioner, du tester, VIL BLIVE UDFØRT for denne bruger, så vær forsigtig med, hvad du vælger at teste!</strong>';
$string['testclient'] = 'Webservice-testklient';
$string['testclientdescription'] = '* Webservice-testklienten <strong>kører</strong> funktionerne <strong>I VIRKELIGHEDEN</strong>. Test ikke funktioner du ikke kender.
* Alle eksisterende webservice-funktioner er endnu ikke implementeret i testklienten.
* Til tjek af at en bruger ikke kan tilgå visse funktioner, kan du teste nogle funktioner, du ikke har tilladt.
* Klarere fejlbeskeder vises hvis du sætter debugging-tilstand til <strong>{$a->mode}</strong> i {$a->atag}';
$string['testwithtestclient'] = 'Test servicen';
$string['testwithtestclientdescription'] = 'Simuler ekstern adgang til servicen ved brug af webservice\'s testklient. Brug en aktiveret protokol med token-godkendelse. <strong>ADVARSEL: Funktionerne du tester, VIL BLIVE KØRT for denne bruger, så vær forsigtig med hvad du vælger at teste!</strong>';
$string['token'] = 'Token';
$string['tokenauthlog'] = 'Token-godkendelse';
$string['tokencopied'] = 'Tekst kopieret til udklipsholderen.';
$string['tokencreatedbyadmin'] = 'Kan kun nulstilles af administrator (*)';
$string['tokencreator'] = 'Token-opretter';
$string['tokenfilter'] = 'Tokenfilter.';
$string['tokenfilterreset'] = 'Vis alle tokens.';
$string['tokenfiltersubmit'] = 'Vis kun matchende tokens.';
$string['tokenname'] = 'Navn';
$string['tokennamehint'] = 'Hvis du ikke indtaster et navn, vil et tilfældigt navn blive brugt.';
$string['tokennameprefix'] = 'Webservice-{$a}';
$string['tokennewmessage'] = 'Kopier tokenet nu. Det vil ikke blive vist igen, når du forlader denne side.';
$string['unknownoptionkey'] = 'Ukendt indstillingsnøgle ({$a})';
$string['unnamedstringparam'] = 'En streng-parameter er ikke navngivet.';
$string['updateusersettings'] = 'Opdater';
$string['uploadfiles'] = 'Kan uploade filer';
$string['uploadfiles_help'] = 'Er indstillingen aktiveret, kan enhver bruger uploade filer med deres sikkerhedsnøgler til deres eget private filområde eller kladde-filområde. Alle kvoter på brugerfiler gælder.';
$string['userasclients'] = 'Brugere som klienter med token';
$string['userasclientsdescription'] = 'De følgende trin hjælper med opsætning af Moodles webservice for brugere og klienter. Disse trin hjælper også med opsætning af den anbefalede token- (godkendelsesnøgler) godkendelsesmetode. I denne brugers tilfælde vil brugeren generere sin token fra siden med sikkerhedsnøgler via sine brugerindstillinger.';
$string['usermissingcaps'] = 'Manglende rettigheder: {$a}';
$string['usernameorid'] = 'Brugernavn/bruger-id';
$string['usernameorid_help'] = 'Angiv et brugernavn eller et bruger-id';
$string['usernotallowed'] = 'Brugeren har ikke adgang til denne service. Du skal først tillade brugeren på {$a}\'s administrationsside med tilladte brugere .';
$string['userservices'] = 'Brugerservicer: {$a}';
$string['usersettingssaved'] = 'Brugerindstillinger gemt';
$string['validuntil'] = 'Gyldig indtil';
$string['validuntil_empty'] = 'Dette token har ingen udløbsdato.';
$string['validuntil_help'] = 'Er indstillingen specificeret, vil servicen for denne bruger være deaktiveret efter denne dato.';
$string['webservice'] = 'Webservice';
$string['webservices'] = 'Webservicer';
$string['webservicesoverview'] = 'Oversigt';
$string['webservicetokens'] = 'Webservice-tokens';
$string['wrongusernamepassword'] = 'Forkert brugernavn eller adgangskode';
$string['wsaccessuserdeleted'] = 'Nægtet webservice-adgang for slettet brugernavn: {$a}';
$string['wsaccessuserexpired'] = 'Nægtet webservice-adgang for brugernavnet {$a} med udløbet adgangskode';
$string['wsaccessusernologin'] = 'Afvist webserviceadgang for nologin-godkendelse af brugernavn: {$a}';
$string['wsaccessusersuspended'] = 'Nægtet webservice-adgang for suspenderet brugernavn: {$a}';
$string['wsaccessuserunconfirmed'] = 'Nægtet webservice-adgang for ubekræftet brugernavn: {$a}';
$string['wsclientdoc'] = 'Dokumentation for Moodle webservice-klient';
$string['wsdocapi'] = 'API-dokumentation';
$string['wsdocumentation'] = 'Webservice-dokumentation';
$string['wsdocumentationdisable'] = 'Webservice-dokumentation er deaktiveret';
$string['wsdocumentationintro'] = 'For at oprette en klient anbefaler vi at du læser {$a->doclink}';
$string['wsdocumentationlogin'] = 'eller skriv brugernavn og adgangskode til din webservice:';
$string['wspassword'] = 'Webservice-adgangskode';
$string['wsusername'] = 'Webservice-brugernavn';
