<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_certification', language 'da', version '5.0'.
 *
 * @package     tool_certification
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Handling.';
$string['actions'] = 'handlinger.';
$string['active'] = 'Aktiv.';
$string['activecertifications'] = 'Aktive certificeringer.';
$string['afteractualcertcompletion'] = 'Efter nuværende certificeringsfuldførelse.';
$string['afteractualcertcompletionwithrelativedate'] = '{$a} efter nuværende certificeringsfuldførelse.';
$string['afterallocationdate'] = 'Efter allokeringsdato.';
$string['afterallocationdatewithrelativedate'] = '{$a} efter allokeringsdato.';
$string['aftercompletion'] = 'Efter fuldførelse.';
$string['aftercompletionwithrelativedate'] = '{$a} efter fuldførelse.';
$string['afterduedate'] = 'Efter forfaldsdato.';
$string['afterduedatewithrelativedate'] = '{$a} efter forfaldsdato.';
$string['afterlatest'] = 'Efter den seneste af den nuværende fuldførelse eller udløb.';
$string['afterlatestwithrelativedate'] = '{$a} efter den seneste af den nuværende fuldførelse eller udløb.';
$string['afterpreviouscertexpdate'] = 'Efter tidligere certificerings udløbsdato.';
$string['afterpreviouscertexpdatewithrelativedate'] = '{$a} efter tidligere certificerings udløbsdato.';
$string['afterstartdate'] = 'Efter startdato.';
$string['afterstartdatewithrelativedate'] = '{$a} efter startdato.';
$string['allocatetocertification'] = 'Alloker til certificering.';
$string['allocatetocertifications'] = 'Alloker til certificeringer..';
$string['allocateusers'] = 'Alloker brugere.';
$string['allocateuserstocertification'] = 'Alloker brugere til certificeringer..';
$string['allocationdate'] = 'Allokeringsdato.';
$string['allocationdateisonorafter'] = 'Allokeringsdato på eller efter.';
$string['allocationdefaultvalue'] = 'Samme som defineret i certificeringer (Standard).';
$string['allocationenddate'] = 'Allokeringsslutdato.';
$string['allocationfor'] = 'Allokering for \'{$a}\'.';
$string['allocationsource'] = 'Allokeringskilde.';
$string['allocationstartdate'] = 'Allokeringsstartdato.';
$string['allocationwindowenddate'] = 'Slutdato.';
$string['allocationwindowenddate_help'] = 'Slutdato for allokeringsvinduet.';
$string['allocationwindowendedon'] = 'Allokeringsvinduet for denne certificering sluttede den {$a}';
$string['allocationwindowstartdate'] = 'Startdato.';
$string['allocationwindowstartdate_help'] = 'Startdato for allokeringsvinduet.';
$string['allocationwindowstartson'] = 'Allokeringsvinduet for denne certificering starter den {$a}';
$string['archive'] = 'Arkiv.';
$string['archived'] = 'Arkiveret.';
$string['archivedcertifications'] = 'Arkiverede certificeringer.';
$string['archivedconfirmation'] = 'Er du sikker på, at du vil arkivere certificeringen \'{$a}\'? Arkiverede certificeringer vil ikke længere være tilgængelige for ledere eller elever og kan kun ses i historiske rapporter';
$string['archivedon'] = 'Arkiveret den.';
$string['autocreategroups'] = 'Føj til kursusgrupper.';
$string['autocreategroups_help'] = 'Når brugere er tilmeldt programkurserne, kan de automatisk tilføjes til den samme gruppe. I tilfælde hvor "for denne certificering" er valgt, vil en separat gruppe for denne certificering blive brugt, og den vil være forskellig fra de andre certificeringer, der bruger det samme program';
$string['autocreategroupsasinprogram'] = 'Som defineret i programmet.';
$string['autocreategroupscertification'] = 'Opret grupper for denne certificering.';
$string['becamecertified'] = 'Blev certificeret ({$a}).';
$string['beforepreviouscertexpdate'] = 'før tidligere certificerings udløbsdato.';
$string['calendarduedate'] = 'Forfaldsdato for certificering {$a}.';
$string['calendarexpirydate'] = 'Udløbsdato for certificering {$a}.';
$string['certification'] = 'Certificering.';
$string['certification:allocateuser'] = 'Tilladelse til at allokere bruger.';
$string['certification:configurecustomfields'] = 'Konfigurer brugerdefinerede felter for certificeringer.';
$string['certification:edit'] = 'Tilladelse til at redigere.';
$string['certificationdates'] = 'Datoer.';
$string['certificationdates_help'] = 'Vælg de datoer, der gælder for denne certificeringsallokering:

*   **Samme som defineret i certificeringer:** Det vil bruge de datoer, der er defineret i certificeringerne.
*   **Vælg dato:** Du kan vælge en specifik dato (start, forfald) for denne certificeringsallokering';
$string['certificationfullname'] = 'Certificeringens fulde navn.';
$string['certificationfullname_help'] = 'Certificeringens fulde navn.';
$string['certificationidnumber'] = 'Certificerings ID-nummer.';
$string['certificationidnumber_help'] = 'ID-nummeret for en certificering bruges kun, når certificeringen matches mod eksterne systemer og vises ikke noget sted på webstedet. Hvis certificeringen har et officielt kodenavn, kan det indtastes, ellers kan feltet efterlades tomt';
$string['certificationname'] = 'Certificeringsnavn.';
$string['certificationnamewitheditlink'] = 'Certificeringsnavn med link til redigering.';
$string['certificationprogress'] = 'Certificeringsforløb.';
$string['certificationprogressexport'] = '{$a} certificeringsforløb.';
$string['certificationrules'] = 'Certificeringsregler.';
$string['certifications'] = 'Certificeringer.';
$string['certificationscustomfield'] = 'Brugerdefinerede felter for certificeringer.';
$string['certificationslink'] = '<a href="{$a->href}">{$a->count} certificering</a>.';
$string['certificationslink_plural'] = '<a href="{$a->href}">{$a->count} certificeringer</a>.';
$string['certificationstatus'] = 'Certificeringsstatus.';
$string['certificationstatus_help'] = 'Status for den nuværende certificering.';
$string['certificationtags'] = 'Certificeringstags.';
$string['certificationtags_help'] = 'Tags for denne certificering.';
$string['certificationtenant'] = 'Certificeringslejer.';
$string['certificationuserlog'] = '{$a} aktivitetslog.';
$string['certificationuserlogempty'] = 'Der er ingen hændelseslogge for denne brugercertificering';
$string['certificationuserlogfilename'] = '{$a->user} aktivitetslog {$a->certification}.';
$string['certified'] = 'Certificeret.';
$string['certifiedandrevoked'] = 'Certificeret og tilbagekaldt.';
$string['certifiedby'] = 'Certificeret af.';
$string['certifiedcertificationslink'] = '<a href="{$a->href}">{$a->count} certificerede certificeringer</a>.';
$string['certifieddate'] = 'Certificeringsdato.';
$string['certifieddateisonorafter'] = 'Certificeringsdato er på eller efter.';
$string['certifiednotification'] = 'Brugeren er blevet certificeret med succes.';
$string['certifiedtype'] = 'Certificeringstype.';
$string['certify'] = 'Certificer.';
$string['certifycertifieddate'] = 'Certificeringsdato.';
$string['certifycertifieddate_help'] = 'Vælg en certificeringsdato for denne bruger mellem \'Nu\' (brugerens certificering vil blive certificeret med det samme) eller en brugerdefineret dato i fortiden';
$string['certifyexpirydate'] = 'Udløbsdato.';
$string['certifyexpirydate_help'] = 'Vælg en udløbsdato for denne certificerede bruger mellem \'Standard\' (viser den aktuelle certificeringskonfiguration), \'Aldrig\' eller en brugerdefineret dato';
$string['certifyuser'] = 'Certificer bruger.';
$string['completedtheprogram'] = 'Fuldførte programmet {$a}.';
$string['conditioncertificationcertified'] = 'Certificering certificeret.';
$string['conditioncertificationcertifieddescription'] = 'Brugere, der er certificeret i certificeringen \'{$a->fullname}\'.';
$string['conditioncertificationcertifieddescriptionall'] = 'Brugere, der er certificeret i alle de følgende certificeringer: \'{$a->fullname}\'.';
$string['conditioncertificationcertifieddescriptionallwithdate'] = 'Brugere, der er certificeret i alle de følgende certificeringer: \'{$a->fullname}\'<br />
Certificeringsdato er på eller efter \'{$a->conditiondate}\'.';
$string['conditioncertificationcertifieddescriptionany'] = 'Brugere, der er certificeret i mindst én af følgende certificeringer: \'{$a->fullname}\'.';
$string['conditioncertificationcertifieddescriptionanywithdate'] = 'Brugere, der er certificeret i mindst én af de følgende certificeringer: \'{$a->fullname}\'<br />
Certificeringsdato er på eller efter \'{$a->conditiondate}\'.';
$string['conditioncertificationcertifieddescriptiononrecert'] = 'Udfør for hver recertificering.';
$string['conditioncertificationcertifieddescriptionstatusonly'] = 'Udfør kun ved statusændring.';
$string['conditioncertificationcertifieddescriptionwithdate'] = 'Brugere, der er certificeret i certificeringen \'{$a->fullname}\'<br />Certificeringsdato er på eller efter \'{$a->conditiondate}\'.';
$string['conditioncertificationcertifiedonrecert'] = 'Udfør altid handlinger ved alle gen-certificeringer.';
$string['conditioncertificationcertifiedonrecert_help'] = 'Dette vil effektivt ændre betingelsen til <b>"Bruger er certificeret, og gen-certificeringsperioden er ikke åben"</b>. Dette vil sikre, at brugeren markeres som "ikke matchende", når gen-certificeringen åbner, og handlingerne udføres for dem igen ved programafslutning, selvom de fortsætter med at være certificeret hele tiden';
$string['conditioncertificationcertifiedstatusonly'] = 'Udfør kun handlinger, når brugerens status ændres fra "ikke certificeret" til "certificeret".';
$string['conditioncertificationcertifiedstatusonly_help'] = 'I dette tilfælde kan handlingerne muligvis eller muligvis ikke udføres ved gen-certificering, afhængigt af om den tidligere certificering er udløbet eller ej. For at sikre, at handlinger <b>aldrig</b> udføres under gen-certificering, bør du overveje at indstille "Regelhandlingsgrænse" i regelindstillingerne';
$string['conditioncertificationexpired'] = 'Certificering udløbet.';
$string['conditioncertificationexpireddescription'] = 'Brugere, hvis certificering \'{$a}\' er udløbet.';
$string['conditioncertificationexpireddescriptionwithdate'] = 'Brugere, hvis certificering \'{$a->fullname}\' er udløbet<br />Udløbsdato er på eller efter \'{$a->conditiondate}\'.';
$string['conditioncertificationnotcertified'] = 'Certificering ikke certificeret.';
$string['conditioncertificationnotcertifieddescription'] = 'Brugere, der ikke er certificeret i certificeringen \'{$a}\'.';
$string['conditioncertificationoverdue'] = 'Certificering overskredet.';
$string['conditioncertificationoverduedescription'] = 'Brugere, der er overskredet i certificeringen \'{$a}\'.';
$string['conditioncertificationoverduedescriptionwithdate'] = 'Brugere, der er overskredet i certificeringen \'{$a->fullname}\'<br />Forfaldsdato er på eller efter \'{$a->conditiondate}\'.';
$string['conditioncertificationsuspended'] = 'Certificering suspenderet.';
$string['conditioncertificationsuspendeddescription'] = 'Brugere, der er suspenderet i certificeringen \'{$a}\'.';
$string['conditioncertificationsuspendeddescriptionwithdate'] = 'Brugere, der er suspenderet i certificeringen \'{$a->fullname}\'<br />Suspensionsdato er på eller efter \'{$a->conditiondate}\'.';
$string['conditionrecertificationgraceperiod'] = 'Recertificerings-graceperiode udløber.';
$string['conditionrecertificationgraceperiodendsdescription'] = 'Brugere, hvis graceperiode udløber i certificeringen \'{$a->fullname}\'.';
$string['conditionrecertificationgraceperiodendsdescriptionwithdate'] = 'Brugere, hvis graceperiode udløber i certificeringen \'{$a->fullname}\'<br />Recertificerings-graceperioden udløber på eller før \'{$a->conditiondate}\'.';
$string['conditionrecertificationstarted'] = 'Recertificeringsperiode startet.';
$string['conditionrecertificationstarteddescription'] = 'Brugere, der har startet en recertificeringsperiode i certificeringen \'{$a->fullname}\'.';
$string['conditionrecertificationstarteddescriptionwithdate'] = 'Brugere, der har startet en recertificeringsperiode i certificeringen \'{$a->fullname}\'<br />Recertificering startet på eller efter \'{$a->conditiondate}\'.';
$string['conditionuserallocated'] = 'Brugere tildelt til certificering.';
$string['conditionuserallocateddescription'] = 'Brugere tildelt certificeringen \'{$a}\'.';
$string['conditionuserallocateddescriptionwithdate'] = 'Brugere tildelt certificeringen \'{$a->fullname}\'<br />Tildelingsdato er på eller efter \'{$a->conditiondate}\'.';
$string['conditionusernotallocated'] = 'Brugere ikke tildelt til certificering.';
$string['conditionusernotallocateddescription'] = 'Brugere ikke tildelt certificeringen \'{$a}\'.';
$string['confirmdeallocateusers'] = 'Denne handling vil fuldstændigt slette allokering og tilhørende data for alle de valgte brugere. Denne handling kan ikke fortrydes.';
$string['confirmdeallocateusersheader'] = 'Af-alloker brugere';
$string['confirmdeletecertification'] = 'Er du sikker på, at du vil slette certificeringen \'{$a}\' og tilhørende data? Denne handling kan ikke fortrydes';
$string['confirmdeleteuserallocation'] = 'Er du sikker på, at du vil slette tildelingen af bruger \'{$a}\' fuldstændigt samt tilknyttede data? Denne handling kan ikke fortrydes';
$string['confirmduplicate'] = 'Der oprettes en kopi af certificeringskonfigurationen, og du vil kunne ændre programmet og andre egenskaber. Ingen brugertildelinger vil blive overført til kopien';
$string['content'] = 'Indhold.';
$string['criteriaall'] = 'Alle de valgte certificeringer er blevet certificeret.';
$string['criteriaany'] = 'Mindst én af de valgte certificeringer er certificeret.';
$string['criteriaany_help'] = 'Når en bruger allerede er blevet certificeret i en af certificeringerne, udløser certificering i den anden certificering ikke handlingerne igen';
$string['criteriaeach'] = 'Hver gang en bruger er certificeret i en hvilken som helst af de valgte certificeringer.';
$string['criteriaeach_help'] = 'Svarer til at oprette flere regler, én for hver af de valgte certificeringer.';
$string['currentcertification'] = 'Nuværende certificering.';
$string['currentprogram'] = 'Nuværende program.';
$string['currentprogram_help'] = 'Dette er det nuværende program, som denne bruger gennemgår.';
$string['currentprogramprogress'] = 'Nuværende programfremskridt.';
$string['currentprogramstatus'] = 'Nuværende programstatus.';
$string['dateoverrided'] = 'Dato tilsidesat.';
$string['dayssinceallocation'] = 'Dage siden tildeling.';
$string['daystakingcertification'] = 'Dage under certificering.';
$string['deallocateusers'] = 'Fjern tildeling af brugere.';
$string['default'] = 'Standard.';
$string['deleteallocation'] = 'Slet tildeling.';
$string['deleteuserallocation'] = 'Slet brugertildeling.';
$string['displaycertificationdate'] = 'Certificeringsdato.';
$string['displaycertificationduedate'] = 'Certificeringsforfaldsdato.';
$string['displaycertificationid'] = 'Internt certificerings-id brugt i URL\'er.';
$string['displaycertificationname'] = 'Certificeringsnavn.';
$string['displaycertificationprogramname'] = 'Startprogramnavn for denne certificering.';
$string['displaycertificationreopen'] = 'Recertificerings startdato.';
$string['displayexpirydate'] = 'Certificeringsudløbsdato.';
$string['displayexpirydatetimestamp'] = 'Certificeringsudløbsdato tidsstempel.';
$string['displaygraceperiodend'] = 'Grace periodes slutdato.';
$string['displayrecertificationprogramname'] = 'Recertificeringsprogramnavn.';
$string['dontchange'] = 'Foretag ingen ændringer';
$string['duedate'] = 'Forfaldsdato.';
$string['duedate_help'] = 'Dato hvor certificeringen forfalder.';
$string['duedateisonorafter'] = 'Forfaldsdato på eller efter.';
$string['duplicate'] = 'Dupliker.';
$string['dynamic'] = 'Dynamisk.';
$string['dynamicrules'] = 'Dynamiske regler.';
$string['dynamicrulesplugincheck'] = 'Visning af listen over dynamiske regler er umulig uden plugin\'et tool_dynamicrules.';
$string['dynamicrulewarningdeallocation'] = 'Brugere kan kun deallokeres, hvis de er blevet allokeret af en anden dynamisk regel. Manuelle allokeringer vil ikke blive påvirket';
$string['editallocation'] = 'Rediger allokering.';
$string['editcertificationname'] = 'Rediger certificeringsnavn.';
$string['editstatusanddates'] = 'Rediger status og datoer.';
$string['editstatusanddatesbulk'] = 'Rediger status og datoer for flere brugere.';
$string['enddate'] = 'Slutdato.';
$string['entitycertification'] = 'Certificering.';
$string['entitycertificationusers'] = 'Certificering af brugerallokering og fuldførelse.';
$string['errorallocatinguserintorelatedprogram'] = 'Kan ikke allokere bruger til relateret program.';
$string['errorallocationsourcenotfound'] = 'Allokeringskilde ikke fundet.';
$string['erroralreadycertified'] = 'Brugeren er allerede certificeret i denne certificering med denne startdato';
$string['errorcannotallocate'] = 'Kan ikke allokere bruger til certificering (allokering eksisterer allerede eller er ikke tilladt).';
$string['errorcantdeletecertification'] = 'Kan ikke slette certificering.';
$string['errorcantdeletenotarchivedcertification'] = 'Kan ikke slette en ikke-arkiveret certificering.';
$string['errorcantmanageusers'] = 'Kan ikke administrere brugere.';
$string['errorcantrestorecertification'] = 'Kan ikke gendanne certificering.';
$string['errorcertificationdateinfuture'] = 'Certificeringsdatoen skal være i fortiden';
$string['errorcertificationsdontexist'] = 'Nogle certificeringer eksisterer ikke';
$string['errorcouldnotallocate'] = 'Kunne ikke allokere bruger \'{$a->originaluserfullname}\' til certificering \'{$a->certification}\'.';
$string['errorevaluatinguserallocationstatus'] = 'Fejl ved evaluering af brugerallokeringsstatus.';
$string['errorexpirydatepreviouscertifieddate'] = 'Udløbsdatoen kan ikke ligge før certificeringsdatoen';
$string['errorexpirydatepreviousduedate'] = 'Udløbsdatoen kan ikke ligge før forfaldsdatoen';
$string['erroridnumberuniquetenant'] = 'Dette ID-nummer er allerede i brug i en anden certificering';
$string['errorinvalidcertification'] = 'Ugyldig certificering.';
$string['errorinvaliddate'] = 'Ugyldig dato.';
$string['errorinvalidpastduedate'] = 'Forfaldsdatoen kan ikke ligge før startdatoen';
$string['errorinvalidpastexpirydate'] = 'Udløbsdatoen kan ikke ligge i fortiden';
$string['errorinvalidpaststartdate'] = 'Startdatoen kan ikke ligge i fortiden';
$string['errorinvalidtimecertified'] = 'Certificeringstidspunktet kan ikke ligge i fremtiden';
$string['errormissingassociatedprogram'] = 'Manglende tilknyttet program.';
$string['errormissingexpirydate'] = 'Udløbsdato mangler';
$string['errornopermissionallocateusers'] = 'Ingen tilladelse til at allokere brugere til certificering';
$string['errornopermissioncertifyuser'] = 'Denne bruger kan ikke markeres som certificeret, fordi enten er de allerede markerede som certificeret, eller også har du ikke tilladelse til at udføre denne handling';
$string['errornopermissionmanagecertifications'] = 'Ingen tilladelse til at administrere certificeringer';
$string['errornopermissionviewallocatedusers'] = 'Ingen tilladelse til at se allokerede brugere i certificeringen';
$string['errornopermissionviewreports'] = 'Ingen tilladelse til at se rapporter.';
$string['errornothingtoexportforcertifications'] = 'Intet at eksportere for delte certificeringer: {$a}.';
$string['errorrecertificationprogram'] = 'Programmet skal være anderledes end det oprindelige program.';
$string['errorreporttypedoesnotexist'] = 'Rapporttypen eksisterer ikke';
$string['errorsameidnumber'] = 'Certificering med samme ID-nummer eksisterer allerede';
$string['erroruseralreadyallocatedincertification'] = 'Brugeren er allerede allokeret i certificeringen';
$string['erroruseralreadyallocatedinprogram'] = 'Brugeren er allerede allokeret i programmet';
$string['errorusernotinsametenant'] = 'Brugeren er ikke i samme lejer';
$string['eventcertificationcompleted'] = 'Certificering fuldført.';
$string['eventcertificationcreated'] = 'Certificering oprettet.';
$string['eventcertificationdeleted'] = 'Certificering slettet.';
$string['eventcertificationupdated'] = 'Certificering opdateret.';
$string['eventrecertificationgraceperiodended'] = 'Recertificerings grace periode er udløbet.';
$string['eventrecertificationstarted'] = 'Recertificering startet.';
$string['eventuserallocated'] = 'Blev allokeret til certificeringen.';
$string['eventuserdeallocated'] = 'Bruger deallokeret.';
$string['eventuserupdated'] = 'Brugerallokering opdateret.';
$string['expired'] = 'Udløbet.';
$string['expiredcertificationslink'] = '<a href="{$a->href}">{$a->count} udløbne certificeringer</a>.';
$string['expireddateisonorafter'] = 'Udløbsdato på eller efter.';
$string['expireson'] = 'udløber den {$a}.';
$string['expirydate'] = 'Udløbsdato.';
$string['expirydate_help'] = 'Udløbsdato for certificeringen.';
$string['export_content'] = 'Indstillinger.';
$string['export_content_help'] = 'Certificeringer, navne, beskrivelser, datoer, tags osv';
$string['export_dynamic_rules'] = 'Dynamiske regler.';
$string['export_dynamic_rules_help'] = 'Al konfiguration af dynamiske regler for disse certificeringer.';
$string['export_programs'] = 'Tilknyttede programmer.';
$string['export_programs_help'] = 'Programmer, navne, beskrivelser, datoer, tags osv';
$string['export_user_allocations'] = 'Certificeringsbrugerallokeringer.';
$string['export_user_allocations_help'] = 'Inkluderer brugerallokeringer til disse certificeringer. En kopi af selve brugerne vil ikke blive inkluderet';
$string['exportcertificationsdescription'] = 'Certificeringer med deres tilknyttede programmer, kurser, brugerallokeringer og komponentdynamiske regler';
$string['exportonlyallocationspostfix'] = '(kun brugerallokeringer).';
$string['fullcertificationreport'] = 'Fuld certificeringsrapport.';
$string['futureallocation'] = 'Fremtidig allokering.';
$string['gotocertification'] = 'Gå til certificering.';
$string['historicalcertificationcompletion'] = 'Certificering af brugeres historiske fuldførelse';
$string['historicalstatus'] = 'Historisk status.';
$string['idnumber'] = 'ID-nummer.';
$string['import_content'] = 'Indstillinger.';
$string['import_content_help'] = 'Certificeringer, navne, beskrivelser, datoer, tags osv';
$string['import_dynamic_rules'] = 'Dynamiske regler.';
$string['import_dynamic_rules_help'] = 'Al konfiguration af dynamiske regler for disse programmer';
$string['import_programs'] = 'Tilknyttede programmer.';
$string['import_programs_help'] = 'Programmer, navne, beskrivelser, datoer, tags osv';
$string['import_user_allocations'] = 'Certificeringsbrugerallokeringer.';
$string['import_user_allocations_help'] = 'Inkluderer brugerallokeringer til disse certificeringer';
$string['importcannotallocate'] = 'Det er ikke muligt at allokere bruger \'{$a->originaluserfullname}\' til certificering \'{$a->certification}\', da allokeringen allerede eksisterer eller ikke er tilladt.';
$string['importlogfailed'] = 'Kunne ikke importere certificeringen \'{$a->fullname}\'.';
$string['importlogidnumberexists'] = 'Certificering med ID-nummer \'{$a->originalidnumber}\' eksisterer allerede.';
$string['importlogsuccess'] = 'Oprettet ny certificering \'<a href="{$a->url}">{$a->fullname}</a>\'.';
$string['importlogsuccessuserallocations'] = 'Allokerede bruger \'{$a->userfullname}\' til certificeringen \'{$a->certification}\'.';
$string['include_shared_entities'] = 'Inkluder delte enheder.';
$string['include_shared_entities_help'] = 'Ved at aktivere denne indstilling vil den eksporterede fil også indeholde:

*   Alle delte certificeringer, der er tilgængelige i den nuværende lejer
*   Alle delte programmer, der er knyttet til de valgte certificeringer
*   Alle programkurser uden for den nuværende lejers kursuskategori.';
$string['isrecertification'] = 'Er recertificering.';
$string['keepcertificationdefaults'] = 'Behold standardindstillinger for certificering.';
$string['lastallocationdate'] = 'Seneste allokeringsdato: {$a}.';
$string['lessthanaday'] = 'Mindre end en dag.';
$string['managedusersoverdue'] = 'Nogle teammedlemmer har overskredet deres certificeringsfrister';
$string['manageprograms'] = 'Administrer programmer.';
$string['manual'] = 'Manuel.';
$string['manuallycertifieduser'] = 'Manuelt certificeret {$a->usertarget} ({$a->expirydate}).';
$string['mappingerrorcertificationnotfound'] = 'Certificeringen {$a} blev ikke fundet';
$string['mappingnoticenoidnumber'] = 'Certificeringen blev lokaliseret efter navn, fordi ID-nummeret var tomt. Det anbefales at tildele ID-numre til certificeringer.';
$string['markcertificationcompletednotice'] = 'Markér certificeringen som fuldført uden at vente på programmets fuldførelse.';
$string['messageprovider:certificationcompleted'] = 'Certificering fuldført.';
$string['messageprovider:certificationuserallocated'] = 'Bruger allokeret til certificering.';
$string['messageprovider:certificationuserdeallocated'] = 'Bruger deallokeret fra certificering.';
$string['missingcertification'] = 'Manglende certificering.';
$string['missingfullname'] = 'Manglende fuldt navn.';
$string['missingprogram'] = 'Manglende program.';
$string['never'] = 'Aldrig.';
$string['neverexpires'] = 'udløber aldrig';
$string['newcertification'] = 'Ny certificering.';
$string['newvaluefor'] = 'Ny værdi for.';
$string['notavailable'] = 'Ikke tilgængelig.';
$string['notificationcertification'] = 'Dette program er en del af certificeringen \'{$a->certificationname}\'.<br /><br />.';
$string['notificationcertificationcompletedexpiry'] = '{$a->expirymessage}
Efter {$a->reopendate} vil du kunne tage programmet \'{$a->recertificationprogram}\' igen for at opretholde din certificering.<br /><br />.';
$string['notificationcertificationcompletedmanual'] = 'Hej {$a->userfullname},<br /><br />
Tillykke med at have opnået certificeringen i \'{$a->certificationname}\'!<br /><br />
{$a->expirymessage}
{$a->sitename}<br />
{$a->siteurl}.';
$string['notificationcertificationcompletedprogram'] = 'Hej {$a->userfullname},<br /><br />
Tillykke med at have fuldført programmet \'{$a->programname}\'. Du er nu certificeret i \'{$a->certificationname}\'!<br /><br />
Du kan til enhver tid gense kurserne i programmet. Det fulde program kan findes på din \'Mine kurser\' side.<br /><br />
{$a->expirymessage}
{$a->sitename}<br />
{$a->siteurl}.';
$string['notificationcertificationdue'] = 'Dette program er en del af certificeringen \'{$a->certificationname}\', som forfalder den {$a->duedate}.<br /><br />.';
$string['notificationcertificationuserallocated'] = 'Hej {$a->userfullname},<br /><br />
Velkommen til programmet \'{$a->programname}\', som du kan finde på din side \'Mine kurser\'.<br /><br />
{$a->certmsg}<br /><br />
{$a->sitename}<br />
{$a->siteurl}.';
$string['notificationcertificationuserdeallocated'] = 'Hej {$a->userfullname},<br /><br />
Programmet \'{$a->programname}\' er nu lukket og kan ikke længere tilgås.<br /><br />
{$a->sitename}<br />
{$a->siteurl}.';
$string['notificationcertificationwillexpireon'] = 'Din certificering udløber den {$a}.<br /><br />.';
$string['notificationsubjectcertificationcompleted'] = 'Certificering \'{$a}\' fuldført.';
$string['notificationsubjectcertificationcompletedmanual'] = 'Tillykke - \'{$a}\' certificering!.';
$string['notificationsubjectcertificationuserallocated'] = 'Velkommen til \'{$a}\'.';
$string['notificationsubjectcertificationuserdeallocated'] = '\'{$a}\' lukket.';
$string['notset'] = 'Ikke angivet.';
$string['nousersselected'] = 'Vælg mindst én bruger.';
$string['now'] = 'Nu.';
$string['ongoingcertificationslink'] = '<a href="{$a->href}">{$a->count} igangværende certificeringer</a>.';
$string['open'] = 'Åben.';
$string['outcomeallocation'] = 'Alloker brugere til certificeringer.';
$string['outcomeallocationdescdate'] = 'Alloker brugere til certificering {$a->certificationname}<br />
{$a->startdatestr}<br />
Med suspenderede brugere: {$a->suspendedusers}.';
$string['outcomeallocationdesckeepdate'] = 'Ophæv suspension og behold den eksisterende certificeringsstartdato.';
$string['outcomeallocationdesckeepstartdate'] = 'Behold standardstartdato for certificeringen.';
$string['outcomeallocationdescription'] = 'Alloker brugere til certificering {$a}<br />
Behold standard startdato for certificering.';
$string['outcomeallocationdescstartdate'] = 'Certificerings startdato: \'{$a->startdate}\'.';
$string['outcomeallocationdescsuspendchangedate'] = 'Ophæv suspension og ændre certificeringens startdato.';
$string['outcomeallocationdontmodify'] = 'Rediger ikke allokeringer.';
$string['outcomeallocationsuspendedusers'] = 'Med suspenderede brugere.';
$string['outcomeallocationsuspendedusers_help'] = 'Handling der skal udføres, når brugere allerede er allokeret, men deres allokering er suspenderet eller afsluttet';
$string['outcomeallocationunsuspend'] = 'Ophæv suspension og behold den eksisterende certificeringsstartdato.';
$string['outcomeallocationunsuspendchangedate'] = 'Ophæv suspension og ændre certificeringens startdato.';
$string['outcomedeallocate'] = 'Dealloker bruger fra certificering.';
$string['outcomedeallocatesuspend'] = 'Suspender eksisterende allokering.';
$string['outcomedeallocation'] = 'Dealloker brugere fra certificeringer.';
$string['outcomedeallocationdescription'] = 'Dealloker brugere fra certificering {$a}.';
$string['outcomedeallocationdescriptionsuspend'] = 'Suspender eksisterende brugerallokeringer fra certificering \'{$a}\'.';
$string['overdue'] = 'Overskredet.';
$string['overduecertifications'] = 'Overskredne certificeringer.';
$string['overduecertificationslink'] = '<a href="{$a->href}">{$a->count} overskredne certificeringer</a>.';
$string['overduex'] = '{$a} overskredet.';
$string['pluginname'] = 'Certificeringer.';
$string['previewcertificationname'] = 'Certificeringsnavn forhåndsvisning.';
$string['previouscertexpirydate'] = 'Tidligere certificerings udløbsdato.';
$string['privacy:metadata:certification_completions'] = 'Information om fuldførelse af certificering..';
$string['privacy:metadata:certification_completions:certificationid'] = 'Den certificering brugeren har fuldført';
$string['privacy:metadata:certification_completions:certifiedby'] = 'Den bruger der genererede certificeringen';
$string['privacy:metadata:certification_completions:expirydate'] = 'Udløbsdatoen for denne certificeringsfuldførelse';
$string['privacy:metadata:certification_completions:revokedby'] = 'Den bruger der tilbagekaldte certificeringen';
$string['privacy:metadata:certification_completions:timecertified'] = 'Tidspunktet hvor brugeren fuldførte certificeringen';
$string['privacy:metadata:certification_completions:timecreated'] = 'Tidspunktet hvor fuldførelsesoptegnelsen blev oprettet';
$string['privacy:metadata:certification_completions:timemodified'] = 'Det ændrede tidspunkt for certificeringsfuldførelsen';
$string['privacy:metadata:certification_completions:userid'] = 'Den bruger der fuldførte certificeringen';
$string['privacy:metadata:certification_users'] = 'Information om brugercertificeringsallokering';
$string['privacy:metadata:certification_users:certificationid'] = 'Certificeringen allokeret til';
$string['privacy:metadata:certification_users:currentprogramid'] = 'Det aktuelle program som brugeren er allokeret til';
$string['privacy:metadata:certification_users:isrecertification'] = 'Hvis brugeren er i en recertificering.';
$string['privacy:metadata:certification_users:status'] = 'Om brugeren er blevet suspenderet fra certificeringen';
$string['privacy:metadata:certification_users:timemodified'] = 'Det ændrede tidspunkt for brugerallokeringen';
$string['privacy:metadata:certification_users:userid'] = 'Den allokerede bruger';
$string['privacy:metadata:core_tag'] = 'Tags føjet til certificeringer.';
$string['program'] = 'Program.';
$string['programchangewarning'] = 'Brugere der aktuelt er i gang med dette program vil ikke blive reallokeret automatisk. Dette kan gøres manuelt per bruger. Status for brugere der allerede har gennemført programmet, eller dem der manuelt er markeret som certificeret, vil ikke ændre sig, men de vil blive deallokeret fra det gamle program og ikke længere se det på deres kursusliste';
$string['programcourse'] = 'Programkursus.';
$string['programuserallocation'] = 'Program brugerallokering.';
$string['progress'] = '{$a} fuldført.';
$string['progressreport'] = 'Statusrapport.';
$string['recertdifferentprogram'] = 'Vælg et andet program.';
$string['recertdifferentprogram_help'] = 'Vælg \'Ja\' hvis du vil vælge et andet program til recertificeringen end det, der er angivet som det oprindelige program';
$string['recertduedaterelative'] = 'Forfaldsdato.';
$string['recertduedaterelative_help'] = 'Dette er datoen hvor recertificeringen forfalder';
$string['recertexpirydate'] = 'Udløbsdato.';
$string['recertexpirydate_help'] = 'Dette er datoen hvor recertificeringen vil udløbe for brugeren. <br /> Hvis \'Efter tidligere certificerings udløbsdato\' er valgt, vil denne indstilling tillade altid at have udløbsdato på samme dato. Hvis brugeren går glip af en recertificering, vil datoen blive justeret';
$string['recertexpirydatewarning'] = 'Den indledende certificering er indstillet til aldrig at udløbe, recertificering vil kun være mulig for brugere, hvis udløbsdato er blevet indstillet individuelt';
$string['recertgraceperiod'] = 'Grace periode.';
$string['recertgraceperiod_help'] = 'Grace periode er den ekstra tidsperiode, vi giver brugeren til at fuldføre programmet og blive certificeret efter, at den tidligere certificering udløber. Denne mulighed er kun tilgængelig, hvis recertificeringsprogrammet er forskelligt fra det oprindelige program';
$string['recertgraceperiodends'] = 'Grace periode udløber.';
$string['recertification'] = 'Recertificering.';
$string['recertificationgraceperiodendsonorbefore'] = 'Recertificering.';
$string['recertificationprogram'] = 'Recertificeringsprogram.';
$string['recertificationprogram_help'] = 'Vælg et program der skal bruges i recertificeringen. Dette program skal være forskelligt fra det indledende certificeringsprogram';
$string['recertificationstartdate'] = 'Recertificerings startdato.';
$string['recertificationstartedonorafter'] = 'Recertificering startet på eller efter.';
$string['recertstartdaterelative'] = 'Startdato.';
$string['recertstartdaterelative_help'] = 'Dette er datoen hvor recertificeringsprogrammet vil starte med at være tilgængeligt for brugeren';
$string['recertstartdatewarning'] = 'På denne dato vil recertificeringsprogrammet blive nulstillet. Sørg for, at brugerne ikke er tilmeldt programkurserne andre steder, allokeret til det samme program direkte eller allokeret via andre certificeringer, fordi de kan miste deres fremskridt';
$string['reg_wpcertifications'] = 'Antal certificeringer ({$a}).';
$string['requirerecertification'] = 'Kræv recertificering.';
$string['requirerecertification_help'] = 'Vælg \'Ja\' for at aktivere recertificering for denne certificering';
$string['resetadditionalcourses'] = 'Nulstil yderligere kurser.';
$string['resetadditionalcourses_help'] = 'Nulstiller de kurser, der er en del af det nye program, som ikke var en del af det gamle program';
$string['restore'] = 'Gendan.';
$string['revokecertification'] = 'Tilbagekald certificering.';
$string['revoked'] = 'Tilbagekaldt.';
$string['revokedby'] = 'Tilbagekaldt af.';
$string['revokednotification'] = 'Certificeringen er blevet tilbagekaldt med succes';
$string['revokedon'] = 'Tilbagekaldt den.';
$string['revokedthisuser'] = 'Tilbagekaldt {$a}\'s certificering.';
$string['revokewarning'] = 'Er du sikker på, at du vil tilbagekalde certificeringen fra \'{$a}\'? Priser, der måtte være givet ved fuldførelse, vil ikke blive tilbagekaldt';
$string['rolemanager'] = 'Certificeringsadministrator.';
$string['rolemanagerdescription'] = 'Giver mulighed for at oprette og administrere certificeringer inden for den aktuelle lejer og allokere brugere til dem';
$string['schedule'] = 'Certificeringsdatoer.';
$string['selectactiveandarchivedcertifications'] = 'Vælg aktive og arkiverede certificeringer.';
$string['selectadifferentprogram'] = 'Vælg et andet program';
$string['selectallactivecertifications'] = 'Vælg alle aktive certificeringer';
$string['selectallcertificationsinthisfile'] = 'Vælg alle certificeringer i denne fil';
$string['selectatleastonecertification'] = 'Vælg mindst én certificering';
$string['selectcertificationcondition'] = 'Certificering.';
$string['selectcertificationcondition_help'] = 'Vælg den certificering, hvor denne betingelse skal anvendes';
$string['selectcertificationoutcome'] = 'Certificering.';
$string['selectcertificationoutcome_help'] = 'Vælg den certificering, hvor denne handling skal anvendes';
$string['selectcertificationstoallocate'] = 'Certificeringer.';
$string['selectcertificationstoallocate_help'] = 'Vælg de certificeringer, hvor brugerne skal allokeres';
$string['selectdate'] = 'Vælg dato.';
$string['selectmanually'] = 'Vælg manuelt..';
$string['selectprogram'] = 'Vælg program.';
$string['selectprogram_help'] = 'Vælg et program, der skal knyttes til denne certificering';
$string['separatetenantsingroupswarning'] = 'I kurser der deles mellem lejere, vil brugere fra hver lejer blive tilføjet til separate grupper';
$string['startdate'] = 'Startdato.';
$string['startdate_help'] = 'Datoen hvor certificeringen starter';
$string['status'] = 'Status.';
$string['suspended'] = 'Suspenderet.';
$string['suspendeddateisonorafter'] = 'Suspenderingsdato på eller efter.';
$string['system'] = 'System.';
$string['tagarea_tool_certification'] = 'Certificeringer.';
$string['tags'] = 'Tags.';
$string['timecreated'] = 'Oprettet den.';
$string['timemodified'] = 'Senest ændret den.';
$string['timesuspended'] = 'Suspenderet den.';
$string['toomanycertificationstoshow'] = 'For mange certificeringer at vise';
$string['uponcompletion'] = 'Ved fuldførelse.';
$string['userallocation'] = 'Brugerallokering.';
$string['usercompletion'] = 'Brugerfuldførelse.';
$string['userduedate'] = 'Forfaldsdato';
$string['userduedate_help'] = 'Vælg forfaldsdato for denne certificering for denne bruger.';
$string['usergotsuspended'] = 'Bruger blev suspenderet';
$string['userlist'] = 'Vælg brugere';
$string['userlist_help'] = 'Vælg brugere, der skal allokeres til denne certificering';
$string['users'] = 'Brugere';
$string['usersallocatedsuccess'] = '{$a} users were successfully allocated';
$string['usersallocationnotavailable'] = 'Brugerallokering er ikke tilgængelig';
$string['usersdeallocatedsuccess'] = '{$a} bruger(e) er blevet af-allokeret';
$string['userseditedsuccess'] = '{$a} bruger(e) er blevet ændret med succes';
$string['usersskipped'] = '{$a} bruger(e) blev sprunget over, fordi denne mulighed ikke er tilgængelig for dem';
$string['userstartdate'] = 'Startdato';
$string['userstartdate_help'] = 'Vælg den dato, hvor denne bruger vil kunne starte certificeringen. Denne dato vil kun blive anvendt på denne bruger.';
$string['userstatus'] = 'Status';
$string['userstatus_help'] = 'Suspenderet status vil skjule denne certificering for denne bruger, hvorimod Standardstatus vil vise den.';
$string['viewcertificationuserlog'] = 'Certificeringsaktivitetslog';
