<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_stack', language 'da', version '5.0'.
 *
 * @package     qtype_stack
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['ATAlgEquiv_SA_not_equation'] = 'Dit svar skal være en ligning.';
$string['ATAlgEquiv_SA_not_expression'] = 'Dit svar skal være et udtryk, ikke en ligning, ulighed, liste, sæt eller matrix.';
$string['ATAlgEquiv_SA_not_function'] = 'Dit svar skal være en funktion, defineret ved hjælp af operatoren <tt>:=</tt>.';
$string['ATAlgEquiv_SA_not_inequality'] = 'Dit svar skal være en ulighed.';
$string['ATAlgEquiv_SA_not_list'] = 'Dit svar skal være en liste. Syntaksen for at indsætte en liste er at omgive kommaseparerede værdier med firkantede parenteser.';
$string['ATAlgEquiv_SA_not_logic'] = 'Dit svar skal være en ligning, ulighed eller en logisk kombination af flere af disse.';
$string['ATAlgEquiv_SA_not_matrix'] = 'Dit svar skal være en matrix.';
$string['ATAlgEquiv_SA_not_realset'] = 'Dit svar skal være et subsæt af de reelle tal. Dette kan være et sæt tal, eller en samling af intervaller.';
$string['ATAlgEquiv_SA_not_set'] = 'Dit svar skal være et sæt. Syntaksen for at indsætte et sæt er at omgive kommaseparerede værdier med krøllede parenteser.';
$string['ATAlgEquiv_SA_not_string'] = 'Dit svar skal være en tekststreng.';
$string['ATAlgEquiv_TA_not_equation'] = 'Du har indsat en ligning, men en ligning er ikke forventet her. Du har måske skrevet noget som "y=2*x+1" når du kun behøvede at skrive "2*x+1".';
$string['ATCompSquare_SA_not_depend_var'] = 'Dit svar bør afhænge af variablen {$a->m0}.';
$string['ATCompSquare_false'] = '';
$string['ATCompSquare_false_no_summands'] = 'Den fuldstændiggjorte kvadrat er af formen \\( a(\\cdots\\cdots)^2 + b\\) hvor \\(a\\) og \\(b\\) ikke afhænger af din variabel. I dit svar ser en af disse ud til at afhænge af din variabel.';
$string['ATCompSquare_not_AlgEquiv'] = 'Dit svar er i den rigtige form, men er ikke ækvivalent til det rigtige svar.';
$string['ATCompSquare_true'] = '';
$string['ATDiff_error_list'] = 'Svartesten fejlede. Kontakt din systemadministrator.';
$string['ATDiff_int'] = 'Det ser ud som om du har integreret i stedet for at differentiere!';
$string['ATEquivFirst_SA_not_list'] = 'Det første argument i Equiv-svartesten skal være en liste, men testen fejlede. Kontakt din lærer.';
$string['ATEquivFirst_SA_wrong_end'] = 'Dit endelige svar er i den forkerte form.';
$string['ATEquivFirst_SA_wrong_start'] = 'Den første linje i dit svar skal være "{$a->m0}".';
$string['ATEquivFirst_SB_not_list'] = 'Det andet argument til Equiv-svartesten skal være en liste, men testen fejlede. Kontakt din lærer.';
$string['ATEquiv_SA_not_list'] = 'Det første argument til Equiv-svartesten skal være en liste, men testen fejlede. Kontakt din lærer.';
$string['ATEquiv_SB_not_list'] = 'Det andet argument til Equiv-svartesten skal være en liste, men testen fejlede. Kontakt din lærer.';
$string['ATFacForm_error_list'] = 'Svartesten fejlede. Kontakt din systemadministrator.';
$string['ATFacForm_isfactored'] = 'Dit svar er opløst i faktorer. Flot klaret.';
$string['ATFacForm_notalgequiv'] = 'Dit svar er ikke algebraisk ækvivalent til det rigtige svar, så du må have gjort noget forkert.';
$string['ATFacForm_notfactored'] = 'Dit svar er ikke opløst i faktorer.';
$string['ATInequality_backwards'] = 'Det ser ud til at din ulighed er bagvendt.';
$string['ATInequality_nonstrict'] = 'Din ulighed skal være skarp.';
$string['ATInequality_strict'] = 'Din ulighed skal ikke være skarp.';
$string['ATInt_EqFormalDiff'] = 'Den formelle afledte af dit svar er lig det udtryk du skulle integrere. Men dit svar er væsentligt anderledes end det korrekte svar, det vil sige det mangler ikke kun f.eks. en integrationskonstant. Kontakt din lærer.';
$string['ATInt_STACKERROR_OptList'] = 'Svartesten kunne ikke udføres, kontakt din lærer. Når valgmuligheden til ATInt er en liste, bør den have præcist to elementer, men det har den ikke her.';
$string['ATInt_const'] = 'Du skal tilføje en integrationskonstant, men ellers ser dit svar korrekt ud. Flot klaret.';
$string['ATInt_const_int'] = 'Du skal tilføje en integrationskonstant. Dette skal være en arbitrær konstant, ikke et tal.';
$string['ATInt_diff'] = 'Det ser ud til at du har differentieret i stedet for at integrere.';
$string['ATInt_error_list'] = 'Svartesten fejlede. Kontakt din systemadministrator.';
$string['ATInt_generic'] = 'Den afledte af dit svar skal være lig det udtryk du skulle integrere, altså {$a->m0}. Faktisk er den afledte af dit svar med hensyn til {$a->m1}: {$a->m2} så du må have gjort noget forkert!';
$string['ATInt_logabs'] = 'Den formelle afledte af dit svar er lig det udtryk du skulle integrere, men dit svar er væsentligt anderledes end det korrekte svar, det vil sige det mangler ikke bare f.eks. en integrationskonstant. Din lærer forventer måske at du bruger resultatet \\(\\int\\frac{1}{x} dx = \\log(|x|)+c\\), i stedet for \\(\\int\\frac{1}{x} dx = \\log(x)+c\\). Kontakt din lærer.';
$string['ATInt_logabs_inconsistent'] = 'Der er mærkelige uoverensstemmelser mellem dit brug af \\(\\log(...)\\) og \\(\\log(|...|)\\). Kontakt din lærer.';
$string['ATInt_weirdconst'] = 'Den formelle afledte af dit svar er lig det udtryk du skulle integrere, men du har en mærkelig integrationskonstant. Kontakt din lærer.';
$string['ATList_wrongentries'] = 'De ukorrekte indtastninger er understregede i rødt. {$a->m0}';
$string['ATList_wronglen'] = 'Din liste bør have {$a->m0} elementer, men faktisk har den {$a->m1}.';
$string['ATLowestTerms_entries'] = 'Følgende udtryk i dit svar er ikke forkortet så mest muligt: {$a->m0}. Prøv igen.';
$string['ATLowestTerms_not_rat'] = 'Du skal rydde følgende fra din nævner: {$a->m0}';
$string['ATLowestTerms_wrong'] = 'Du skal forkorte brøker i dit svar mest muligt.';
$string['ATMatrix_wrongentries'] = 'De ukorrekte indtastninger er understregede i rødt. {$a->m0}';
$string['ATMatrix_wrongsz'] = 'Din matrix skal være {$a->m0} gange {$a->m1}, men faktisk er den {$a->m2} gange {$a->m3}.';
$string['ATNumDecPlacesWrong_OptNotInt'] = 'Testvalgmuligheden til ATNumDecPlaces skal være et positivt heltal, men du skrev "{$a->opt}".';
$string['ATNumDecPlaces_Float'] = 'Dit svar skal være et decimaltal.';
$string['ATNumDecPlaces_NoDP'] = 'Dit svar skal være et decimaltal, inklusiv decimalpunktum.';
$string['ATNumDecPlaces_OptNotInt'] = 'Testvalgmuligheden til ATNumDecPlaces skal være et positivt heltal, men du har skrevet "{$a->opt}".';
$string['ATNumDecPlaces_Wrong_DPs'] = 'Dit svar har det forkerte antal decimaler.';
$string['ATNumSigFigs_Inaccurate'] = 'Dit svars nøjagtighed er ikke korrekt. Enten har du ikke rundet korrekt, eller også har du rundet et mellemliggende svar.';
$string['ATNumSigFigs_NotDecimal'] = 'Dit svar skal være et decimaltal, men det er det ikke.';
$string['ATNumSigFigs_WrongDigits'] = 'Dit svar har det forkerte antal signifikante cifre.';
$string['ATNumSigFigs_WrongSign'] = 'Dit svar har det forkerte fortegn.';
$string['ATNumSigFigs_error_list'] = 'Svartesten fejlede. Kontakt din systemadministrator.';
$string['ATNum_OutofRange'] = 'Et numerisk udtryk er uden for den understøttede værdimængde. Kontakt din lærer.';
$string['ATNumerical_FAILED'] = 'Dit svar skal være et decimaltal, eller en liste eller sæt af tal, men det er det ikke.';
$string['ATNumerical_SA_not_list'] = 'Dit svar skal være en liste. Syntaksen for at indsætte en liste er at omgive kommaseparerede værdier med firkantede parenteser.';
$string['ATNumerical_SA_not_number'] = 'Dit svar skal være et decimaltal, men det er det ikke.';
$string['ATNumerical_SA_not_set'] = 'Dit svar skal være et sæt. Syntaksen for at indsætte et sæt er at omgive kommaseparerede værdier med krøllede parenteser.';
$string['ATNumerical_STACKERROR_tol'] = 'Den numeriske tolerance for ATNumerical skal være et decimaltal, men det er det ikke. Dette er en intern fejl. Kontakt din lærer.';
$string['ATPartFrac_denom_ret'] = 'Hvis dit svar er skrevet som en enkelt brøk, er nævneren {$a->m0}. Men faktisk skal nævneren være {$a->m1}.';
$string['ATPartFrac_diff_variables'] = 'Dit svars variabler er anderledes end dem der er brugt i spørgsmålet.';
$string['ATPartFrac_error_list'] = 'Svartesten fejlede. Kontakt din systemadministrator.';
$string['ATPartFrac_ret_expression'] = 'Dit svar, skrevet som en enkelt brøk, er {$a->m0}';
$string['ATSRegExp_SA_not_string'] = 'Det første argument til SRegExp-svartesten skal være en tekststreng. Testen fejlede. Kontakt din lærer.';
$string['ATSRegExp_SB_not_string'] = 'Det andet argument til SRegExp-svartesten skal være en tekststreng. Testen fejlede. Kontakt din lærer.';
$string['ATSet_wrongentries'] = 'Følgende værdier er forkerte, selvom de måske ligner forenklede versioner af hvad du faktisk indtastede. {$a->m0}';
$string['ATSet_wrongsz'] = 'Dit sæt bør have {$a->m0} forskellige værdier, men faktisk har det {$a->m1}.';
$string['ATSets_SA_not_set'] = 'Dit svar skal være et sæt, men det er det ikke. Syntaksen for for at indsætte et sæt er at omringe kommaseparerede værdier med krøllede parenteser.';
$string['ATSets_SB_not_set'] = '"Sets"-svartesten forventer at det andet argument er et sæt. Dette er en fejl. Kontakt din lærer.';
$string['ATSets_duplicates'] = 'Dit sæt ser ud til at have duplikerede elementer.';
$string['ATSets_missingentries'] = 'Du mangler følgende i dit sæt: {$a->m0}';
$string['ATSets_wrongentries'] = 'Følgende værdier bør ikke være i dit sæt: {$a->m0}';
$string['ATSingleFrac_div'] = 'Dit svar indholder brøker i brøker. Du skal forkorte disse og skrive dit svar som en enkelt brøk.';
$string['ATSingleFrac_error_list'] = 'Svartesten fejlede. Kontakt din systemadministrator.';
$string['ATSingleFrac_part'] = 'Dit svar skal være en enkelt brøk i formen \\( {a}\\over{b} \\).';
$string['ATSingleFrac_ret_exp'] = 'Dit svar er ikke algebraisk ækvivalent til det korrekte svar, så du må have gjordt noget forkert.';
$string['ATSingleFrac_var'] = 'Dit svars variabler er anderledes end dem, der er brugt i spørgsmålet.';
$string['ATSysEquiv_SA_extra_variables'] = 'Dit svar indeholder for mange variabler!';
$string['ATSysEquiv_SA_missing_variables'] = 'Dit svar mangler en eller flere variabler.';
$string['ATSysEquiv_SA_not_eq_list'] = 'Dit svar skal være en liste af ligninger, men det er det ikke.';
$string['ATSysEquiv_SA_not_list'] = 'Dit svar skal være en liste, men det er det ikke.';
$string['ATSysEquiv_SA_not_poly_eq_list'] = 'En eller flere af dine ligninger er ikke en polynom.';
$string['ATSysEquiv_SA_system_overdetermined'] = 'Indtastningerne understreget i rødt er dem, der er forkerte. {$a->m0}';
$string['ATSysEquiv_SA_system_underdetermined'] = 'Ligningerne i dit svar ser rigtige ud, men du mangler flere udover disse.';
$string['ATSysEquiv_SA_wrong_variables'] = 'Dit svar bruger de forkerte variabler.';
$string['ATSysEquiv_SB_not_eq_list'] = 'Lærerens svar er ikke en liste af ligninger, men det skal det være.';
$string['ATSysEquiv_SB_not_list'] = 'Lærerens svar er ikke en liste, men det skal det være.';
$string['ATSysEquiv_SB_not_poly_eq_list'] = 'Lærerens svar er ikke en liste af polynomier, men det skal det være.';
$string['ATUnits_SA_bad_units'] = 'Dit svar skal have enheder, og du skal bruge multiplikation til at tilknytte enheder til en værdi, f.eks. <code>3.2*m/s</code>.';
$string['ATUnits_SA_errorbounds_invalid'] = 'Dit svar har fejlgrænser. Her bør du ikke indikere fejlgrænser, men kun bruge værdier og enheder.';
$string['ATUnits_SA_excess_units'] = 'Dit svar har brugt enheder (eller variabler), men det bør det ikke.';
$string['ATUnits_SA_no_units'] = 'Dit svar skal have enheder.';
$string['ATUnits_SA_not_expression'] = 'Dit svar skal være et tal med enheder. Brug ikke sæt, lister, ligninger eller matricer.';
$string['ATUnits_SA_only_units'] = 'Dit svar skal vfære et tal med enheder. Dit svar har kun enheder.';
$string['ATUnits_SO_wrong_units'] = 'Enhederne du specificerer for numerisk tolerance skal være de samme enheder brugt i lærerens svar. Dette er en intern fejl i testen. Kontakt din lærer.';
$string['ATUnits_compatible_units'] = 'Dine enheder er anderledes end dem din lærer brugte, men er kompatible med dem. Dine værdier er blevet konverteret til SI-enheder til sammenligning.';
$string['ATUnits_correct_numerical'] = 'Check dine enheder.';
$string['ATUnits_incompatible_units'] = 'Dine enheder er inkompatible med dem, din lærer brugte.';
$string['AT_EmptySA'] = 'Prøvede at køre en svartest hvor den studerendes svar var tom. Dette er sikkert grundet en CAS-valideringsfejl.';
$string['AT_EmptyTA'] = 'Prøvede at køre en svartest hvor lærerens svar var tom. Dette er sikkert grundet en CAS-valideringsfejl.';
$string['AT_InvalidOptions'] = 'Valgmulighedsfeltet er ugyldigt. {$a->errors}';
$string['AT_MissingOptions'] = 'En valgmulighed manglede ved testens udførelse.';
$string['Bad_assignment'] = 'Når du giver værdier til en variabel bør du gøre det på følgende måde: {$a->m0}. Tilpas dit input.';
$string['CommaError'] = 'Dit svar indeholder kommaer som ikke er en del af en liste, sæt eller matrix.  <ul><li>Hvis du ville indsætte en liste, brug <tt>{...}</tt>,</li><li>Hvis du ville indsætte et sæt, brug <tt>{...}</tt>.</li></ul>';
$string['Equiv_Illegal_list'] = 'Lister er ikke tilladt under ækvivalensargumentation.';
$string['Equiv_Illegal_matrix'] = 'Matricer er ikke tilladt under ækvivalensargumentation.';
$string['Equiv_Illegal_set'] = 'Sæt er ikke tilladt under ækvivilensargumentation.';
$string['FacForm_UnPick_morework'] = 'Du kan stadig i højere grad opløse udtrykket {$a->m0} i faktorer.';
$string['Illegal_control_flow'] = 'Dit svar indeholder control-flow-elementer, som <code>if</code>-betingelser eller <code>do</code>-løkker. Disse er ikke tilladt her.';
$string['Illegal_floats'] = 'Dit svar indeholder flydende tal, som ikke er tilladt her.  Du skal indtaste tal som brøker.  For eksempel skal du skrive 1/3 ikke 0,3333, hvilket jo kun er en tilnærmelse til en tredjedel.';
$string['Illegal_groupping'] = 'Dit svar indeholder parenteser brugt til at gruppere operationer, og det er ikke tilladt her. Du bør nok manipulere udtrykket for at fjerne dem.';
$string['Illegal_groups'] = 'Dit svar indeholder evalueringsgrupper "(a,b,c)", som ikke er tilladt her.';
$string['Illegal_identifiers_in_units'] = 'Dit svar indeholder et variabelnavn, når kun enheder forventes.';
$string['Illegal_illegal_operation_in_units'] = 'Udtrykket <code>{$a}</code> er ikke tilladt her.';
$string['Illegal_illegal_power_of_ten_in_units'] = 'Dit svar må ikke indeholde 10 opløftet til andet end et heltal.';
$string['Illegal_input_form_units'] = 'Dette input forventer en numerisk værdi fulgt af, eller ganget med, et udtryk der definerer en enhed, f.eks. <code>1.23*W/m^2</code>.';
$string['Illegal_lists'] = 'Dit svar indeholder lister "[a,b,c]", hvilket ikke er tilladt her.';
$string['Illegal_sets'] = 'Dit svar indeholder sæt "{a,b,c}", hvilket ikke er tilladt her.';
$string['Illegal_singleton_floats'] = 'Dette input accepterer ikke decimaltal i den givne form. Dit svar skal være en numerisk værdi repræsenteret i en af de følgende former: <code>{$a->forms}</code>';
$string['Illegal_singleton_integer'] = 'Dette input accepterer ikke heltal. Dit svar skal være en numerisk værdi repræsenteret i en af de følgende former: <code>{$a->forms}</code>';
$string['Illegal_singleton_power'] = 'Dit svar skal være en numerisk værdi repræsenteret i en af de følgende former: <code>{$a->forms}</code>';
$string['Illegal_strings'] = 'Dit svar indeholder "tekststrenge", hvilket ikke er tilladt her.';
$string['Illegal_x10'] = 'Det ser ud som om du bruger "x" til at gange. Brug <code>*</code> til at gange.';
$string['Interval_backwards'] = 'Når du konstruerer et interval, bør endepunkterne være i den rigtige rækkefølge. {$a->m0} bør være {$a->m1}.';
$string['Interval_illegal_entries'] = 'Følgende bør ikke forekomme, når du bygger reelle sæt: {$a->m0}';
$string['Interval_notinterval'] = 'Dit svar bør være et interval, men i stedet var det {$a->m0}.';
$string['Interval_wrongnumargs'] = 'Intervaller skal have præcist to argumenter, så dette må være en fejl: {$a->m0}.';
$string['Lowest_Terms'] = 'Dit svar indeholder brøker som ikke er forkortet. Prøv igen.';
$string['Maxima_Args'] = 'args: argumentet må ikke være et atomisk udtryk.';
$string['Maxima_DivisionZero'] = 'Division med nul.';
$string['Subst'] = 'Dit svar ville være korrekt, hvis du brugte følgende substitution: {$a->m0}';
$string['TEST_FAILED'] = 'Svartesten kunne ikke udføres: Kontakt din lærer. {$a->errors}';
$string['TEST_FAILED_Q'] = 'Svartesten kunne ikke udføres: Kontakt din lærer.';
$string['Variable_function'] = 'Følgende findes i dit udtryk som både variabel og funktion: {$a->m0}.  Du kan enten bruge <code>*</code> symboler for at fjerne funktioner, eller sørge for at alle forekomster er funktioner.';
$string['addanothernode'] = 'Tilføj endnu en node.';
$string['addanothertestcase'] = 'Tilføj endnu en test...';
$string['addatestcase'] = 'Tilføj en test...';
$string['addingatestcase'] = 'Tilføjer en test til spørgsmålet {$a}';
$string['alg_indices_fact'] = 'Reglerne for potensberegning er som følger:
\\[a^ma^n = a^{m+n}\\]
\\[\\frac{a^m}{a^n} = a^{m-n}\\]
\\[(a^m)^n = a^{mn}\\]
\\[a^0 = 1\\]
\\[a^{-m} = \\frac{1}{a^m}\\]
\\[a^{\\frac{1}{n}} = \\sqrt[n]{a}\\]
\\[a^{\\frac{m}{n}} = \\left(\\sqrt[n]{a}\\right)^m\\]';
$string['alg_indices_name'] = 'Potensreglerne';
$string['alg_inequalities_fact'] = '\\[a>b \\hbox{ betyder } a \\hbox{ er større end } b.\\]
\\[ a < b \\hbox{ betyder } a \\hbox{ er mindre end } b.\\]
\\[a\\geq b \\hbox{ betyder} a \\hbox{ er større eller lig } b.\\]
\\[a\\leq b \\hbox{ betyder } a \\hbox{ er mindre eller lig } b.\\]';
$string['alg_inequalities_name'] = 'Uligheder';
$string['alg_logarithms_fact'] = 'For et grundtal \\(c>0\\) hvor \\(c \\neq 1\\):
\\[\\log_c(a) = b \\mbox{, betyder } a = c^b\\]
\\[\\log_c(a) + \\log_c(b) = \\log_c(ab)\\]
\\[\\log_c(a) - \\log_c(b) = \\log_c\\left(\\frac{a}{c}\\right)\\]
\\[n\\log_c(a) = \\log_c\\left(a^n\\right)\\]
\\[\\log_c(1) = 0\\]
\\[\\log_c(b) = 1\\]
Formlen for at skifte grundtal er:
\\[\\log_a(x) = \\frac{\\log_b(x)}{\\log_b(a)}\\]
Logaritmer med grundtal \\(e\\), skrevet \\(\\log_e\\) eller \\(\\ln\\) hedder naturlige logaritmer.  Bogstavet \\(e\\) repræsenterer Eulers konstant, som er cirka \\(2.718\\).';
$string['alg_logarithms_name'] = 'Logaritmereglerne';
$string['alg_partial_fractions_fact'] = 'Ægte brøker er brøker \\[{\\frac{P(x)}{Q(x)}}\\]
hvor \\(P\\) og \\(Q\\) er polynomier og graden af \\(P\\) er mindre en graden af \\(Q\\).  For disse brøker gør vi som følgende: Skriv \\(Q(x)\\) i fuldt forkortet form,
<ul>
<li>
en <em>lineær faktor</em> \\(ax+b\\) i nævneren skaber en partiel brøk \\[{\\frac{A}{ax+b}}.\\]
</li>
<li>
<em>gentagne lineære faktorer</em> \\((ax+b)^2\\) i nævneren skaber partielle brøker \\[{A\\over ax+b}+{B\\over (ax+b)^2}.\\]
</li>
<li>
en <em>kvadratisk faktor</em> \\(ax^2+bx+c\\)
i nævneren skaber en partiel brøk \\[{Ax+B\\over ax^2+bx+c}\\]
</li>
<li>
<em>uægte brøker</em> kræver et ekstra udtryk som er en polynomium af grad \\(n-d\\) hvor \\(n\\) er tællerens grad (dvs. \\(P(x)\\)) og \\(d\\) er lig nævnerens grad (dvs. \\(Q(x)\\)).
</li></ul>';
$string['alg_partial_fractions_name'] = 'Partielle brøker';
$string['alg_quadratic_formula_fact'] = 'Hvis vi har en kvadratisk ligning
\\[ax^2 + bx + c = 0,\\]
så er løsningen/løsningerne givet af den kvadratiske formel:
\\[x = \\frac{-b \\pm \\sqrt{b^2 - 4ac}}{2a}.\\]';
$string['alg_quadratic_formula_name'] = 'Den kvadratiske formel';
$string['all'] = 'Alle';
$string['allnodefeedbackmustusethesameformat'] = 'Al feedback for alle noderne i et PRT skal bruge det samme tekstformat.';
$string['allowwords'] = 'Tilladte ord';
$string['allowwords_help'] = 'Som udgangspunkt er arbitrære funktioner og variabelnavne med mere end to tegn ikke tilladt. Dette er en kommasepareret liste af funktioner og variabelnavne som er tilladte i studentens svar.';
$string['allowwords_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Allow_Words';
$string['alreadydeployed'] = 'En variant, som hører sammen med denne spørgsmålsnote, er allerede blevet indsat.';
$string['ansnotemismatch'] = '[Answernote mismatch]';
$string['answernote'] = 'Svarnote';
$string['answernote_err'] = 'Svarnoter må ikke indeholde tegnet |. Dette tegn er automatisk indsat af STACK og bliver senere brugt til automatisk at splitte svarnoter.';
$string['answernote_err2'] = 'Svarnoter må ikke indeholde tegnene ; og :';
$string['answernote_help'] = 'Dette er et mærke som bruges til at registrere den unikke sti gennem træet, samt resultatet af hver svartest. Dette er automatisk genereret, men kan også ændres til noget mere meningsfuldt.';
$string['answernote_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Potential_response_trees.md#Answer_note';
$string['answernotedefaultfalse'] = '{$a->prtnavn}-{$a->nodenavn}-F';
$string['answernotedefaulttrue'] = '{$a->prtnavn}-{$a->nodenavn}-T';
$string['answernoterequired'] = 'Svarnoten må ikke være tom.';
$string['answernoteunique'] = 'Der er fundet duplikerede svarnoter i dette potentielle svartræ.';
$string['answertest'] = 'Svartest';
$string['answertest_help'] = 'En svartest bruges til at sammenligne to udtryk og fastslå om de tilfredsstiller nogle matematiske kriterier.';
$string['answertest_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Answer_Tests/index.md';
$string['assumepositive'] = 'Antag tal er positive';
$string['assumepositive_help'] = 'Denne valgmulighed bestemmer værdien af maxima\'s assume_pos variabel.';
$string['assumepositive_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#Assume_Positive';
$string['assumereal'] = 'Antag tal er reelle';
$string['assumereal_help'] = 'Denne valgmulighed bestemmer værdien af maxima\'s assume_real variabel.';
$string['assumereal_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#Assume_Real';
$string['autosimplify'] = 'Simplificer automatisk';
$string['autosimplify_help'] = 'Sætter variablen "simp" i Maxima for dette spørgsmål. F.eks. spørgsmålsvariabler, spørgsmålstekst, osv. Værdien i hvert potentielt responstræ vil tilsidesætte dette for alle udtryk defineret i det træ.';
$string['autosimplify_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Maxima.md#Simplification';
$string['autosimplifyprt'] = 'Simplificer automatisk';
$string['autosimplifyprt_help'] = 'Sætter variablen "simp" i Maxima for feedbackvariabler defineret i dette træ og mens træet evalueres. Dette vil tilsidesætte den værdi sat for hele spørgsmålet for alle udtryk defineret i dette træ.';
$string['autosimplifyprt_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Maxima.md#Simplification';
$string['basicquestionreport'] = 'Grundlæggende rapport om spørgsmålsbrug';
$string['basicquestionreport_help'] = 'Genererer en grundlæggende rapport om spørgsmålsforsøg på serveren. Dette er nyttigt for at bestemme hvilke svartests kan tilføjes for at forbedre feedback.';
$string['basicreportinputsummary'] = 'Rå inputs, uanset hvilke varianter bruges.';
$string['basicreportnotes'] = 'Hyppighed af svarnoter for hvert PRT, uanset hvilke varianter bruges.';
$string['basicreportnotessplit'] = 'Hyppighed af svarnoter for hvert PRT, opdelt med |, uanset hvilke varianter bruges.';
$string['basicreportraw'] = 'Rå data';
$string['basicreportvariants'] = 'Rå inputs og PRT svarnoter per variant.';
$string['booleangotunrecognisedvalue'] = 'Ugyldigt input';
$string['boxsize'] = 'Inputboksens størrelse';
$string['boxsize_help'] = 'Bredden af html-formularfelt.';
$string['boxsize_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Box_Size';
$string['branchfeedback'] = 'Node feedback';
$string['branchfeedback_help'] = 'Dette er CASText som må afhænge af spørgsmålsvariabler, inputelementer eller feedbackvariabler. Dette er evalueret og vist til den studerende hvis de passerer denne gren.';
$string['bulktestcontinuefromhere'] = 'Kør igen, eller genoptag, men start herfra.';
$string['bulktestindexintro'] = 'Hvis du klikker på et af linkene, vil alle spørgsmålstestene blive kørt i alle STACK spørgsmål i den kontekst.';
$string['bulktestindexintro_desc'] = '<a href="{$a->link}">Kør alle spørgsmålstestene samlet i script</a> lader dig hurtigt køre alle STACK-spørgsmål i en givet kontekst. Dette tester ikke blot spørgsmålene, men er også en god måde at genudfylde CAS-cachen efter den er blevet ryddet.';
$string['bulktestindextitle'] = 'Kør alle spørgsmålstestene';
$string['bulktestnodeployedseeds'] = 'Spørgsmålet har tilfældige varianter, men ingen indsat seeds.';
$string['bulktestnogeneralfeedback'] = 'Dette spørgsmål har ikke nogen generel feedback.';
$string['bulktestnotests'] = 'Dette spørgsmål har ikke nogen tests.';
$string['bulktestrun'] = 'Kør alle spørgsmålstests for alle spørgsmål i systemet (langsomt, kun for admins)';
$string['bulktesttitle'] = 'Kør alle spørgsmålstests i {$a}';
$string['cachedef_parsercache'] = 'STACK-separerede Maxima udtryk';
$string['calc_chain_rule_fact'] = 'Følgende regel lader dig finde den afledte af en sammensætning af to funktioner.
Antag at vi har en funktion \\(f(g(x))\\), så hvis vi definerer \\(u=g(x)\\) er den afledte med hensyn til \\(x\\) givet af:
\\[\\frac{df(g(x))}{dx} = \\frac{dg(x)}{dx}\\cdot\\frac{df(u)}{du}.\\]
Vi kan alternativt skrive:
\\[\\frac{df(x)}{dx} = f\'(g(x))\\cdot g\'(x).\\]';
$string['calc_chain_rule_name'] = 'Kædereglen';
$string['calc_diff_linearity_rule_fact'] = '\\[{{\\rm d}\\,\\over {\\rm d}x}\\big(af(x)+bg(x)\\big)=a{{\\rm d}f(x)\\over {\\rm d}x}+b{{\\rm d}g(x)\\over {\\rm d}x}\\quad a,b {\\rm\\  constant.}\\]';
$string['calc_diff_linearity_rule_name'] = 'Den lineære differentiationsregel';
$string['calc_diff_standard_derivatives_fact'] = 'Følgende tabel viser de afledte af nogle standardfunktioner. Det er godt at lære disse standard afledte, da de tit bruges i calculus.
<center>
<table>
<tr><th>\\(f(x)\\)               </th><th> \\(f\'(x)\\)</th></tr>
<tr>
<td>\\(k\\), constant           </td> <td> \\(0\\) </td> </tr> <tr> <td>
\\(x^n\\), any constant \\(n\\) </td> <td> \\(nx^{n-1}\\)</td> </tr> <tr> <td>
\\(e^x\\)                   </td> <td> \\(e^x\\)</td> </tr> <tr> <td>
\\(\\ln(x)=\\log_{\\rm e}(x)\\)              </td> <td> \\(\\frac{1}{x}\\)                </td> </tr> <tr> <td>
\\(\\sin(x)\\)                             </td> <td> \\(\\cos(x)\\)                    </td> </tr> <tr> <td>
\\(\\cos(x)\\)                             </td> <td> \\(-\\sin(x)\\)                   </td> </tr> <tr> <td>
\\(\\tan(x) = \\frac{\\sin(x)}{\\cos(x)}\\)   </td> <td>   \\(\\sec^2(x)\\)                </td> </tr> <tr> <td>
\\(cosec(x)=\\frac{1}{\\sin(x)}\\)         </td> <td>   \\(-cosec(x)\\cot(x)\\)        </td> </tr> <tr> <td>
\\(\\sec(x)=\\frac{1}{\\cos(x)}\\)           </td> <td>   \\(\\sec(x)\\tan(x)\\)           </td> </tr> <tr> <td>
\\(\\cot(x)=\\frac{\\cos(x)}{\\sin(x)}\\)     </td> <td>   \\(-cosec^2(x)\\)             </td> </tr> <tr> <td>
\\(\\cosh(x)\\)                            </td> <td>   \\(\\sinh(x)\\)                 </td> </tr> <tr> <td>
\\(\\sinh(x)\\)                            </td> <td>   \\(\\cosh(x)\\)                 </td> </tr> <tr> <td>
\\(\\tanh(x)\\)                            </td> <td>   \\(sech^2(x)\\)               </td> </tr> <tr> <td>
\\(sech(x)\\)                            </td> <td>   \\(-sech(x)\\tanh(x)\\)        </td> </tr> <tr> <td>
\\(cosech(x)\\)                          </td> <td>   \\(-cosech(x)\\coth(x)\\)      </td> </tr> <tr> <td>
\\(coth(x)\\)                            </td> <td>   \\(-cosech^2(x)\\)            </td> </tr>
</table>
</center>

 \\[ \\frac{d}{dx}\\left(\\sin^{-1}(x)\\right) =  \\frac{1}{\\sqrt{1-x^2}}\\]
 \\[ \\frac{d}{dx}\\left(\\cos^{-1}(x)\\right) =  \\frac{-1}{\\sqrt{1-x^2}}\\]
 \\[ \\frac{d}{dx}\\left(\\tan^{-1}(x)\\right) =  \\frac{1}{1+x^2}\\]
 \\[ \\frac{d}{dx}\\left(\\cosh^{-1}(x)\\right) =  \\frac{1}{\\sqrt{x^2-1}}\\]
 \\[ \\frac{d}{dx}\\left(\\sinh^{-1}(x)\\right) =  \\frac{1}{\\sqrt{x^2+1}}\\]
 \\[ \\frac{d}{dx}\\left(\\tanh^{-1}(x)\\right) =  \\frac{1}{1-x^2}\\]';
$string['calc_diff_standard_derivatives_name'] = 'Standard afledte';
$string['calc_int_linearity_rule_fact'] = '\\[\\int \\left(af(x)+bg(x)\\right){\\rm d}x = a\\int\\!\\!f(x)\\,{\\rm d}x
\\,+\\,b\\int \\!\\!g(x)\\,{\\rm d}x, \\quad (a,b \\, \\, {\\rm constant.})
\\]';
$string['calc_int_linearity_rule_name'] = 'Den lineære integrationsregel';
$string['calc_int_methods_parts_fact'] = '\\[
\\int_a^b u{{\\rm d}v\\over {\\rm d}x}{\\rm d}x=\\left[uv\\right]_a^b-
\\int_a^b{{\\rm d}u\\over {\\rm d}x}v\\,{\\rm d}x\\]
eller alternativt: \\[\\int_a^bf(x)g(x)\\,{\\rm d}x=\\left[f(x)\\,\\int
g(x){\\rm d}x\\right]_a^b -\\int_a^b{{\\rm d}f\\over {\\rm
d}x}\\left\\{\\int g(x){\\rm d}x\\right\\}{\\rm d}x.\\]';
$string['calc_int_methods_parts_name'] = 'Partiel integration';
$string['calc_int_methods_substitution_fact'] = '\\[
\\int f(u){{\\rm d}u\\over {\\rm d}x}{\\rm d}x=\\int f(u){\\rm d}u
\\quad\\hbox{and}\\quad \\int_a^bf(u){{\\rm d}u\\over {\\rm d}x}\\,{\\rm
d}x = \\int_{u(a)}^{u(b)}f(u){\\rm d}u.
\\]';
$string['calc_int_methods_substitution_name'] = 'Integration ved substitution';
$string['calc_int_standard_integrals_fact'] = '\\[\\int k\\ dx = kx +c, \\mbox{ where k is constant.}\\]
\\[\\int x^n\\ dx  = \\frac{x^{n+1}}{n+1}+c, \\quad (n\\ne -1)\\]
\\[\\int x^{-1}\\ dx = \\int {\\frac{1}{x}}\\ dx = \\ln(|x|)+c = \\ln(k*|x|) = \\left\\{\\matrix{\\ln(x)+c & x>0\\cr
\\ln(-x)+c & x<0\\cr}\\right.\\]

<center>
<table>
<tr><th>\\(f(x)\\)</th><th> \\(\\int f(x)\\ dx\\)</th></tr>
<tr><td>\\(e^x\\) </td> <td>  \\(e^x+c\\)</td> <td> </td> </tr>
<tr><td>\\(\\cos(x)\\) </td> <td>  \\(\\sin(x)+c\\)   </td> <td> </td> </tr>
<tr><td>\\(\\sin(x)\\) </td> <td>  \\(-\\cos(x)+c\\)  </td> <td> </td> </tr>
<tr><td>\\(\\tan(x)\\) </td> <td>  \\(\\ln(\\sec(x))+c\\) </td> <td>\\(-\\frac{\\pi}{2} < x < \\frac{\\pi}{2}\\)</td> </tr>
<tr><td>\\(\\sec x\\)  </td> <td>  \\(\\ln (\\sec(x)+\\tan(x))+c\\) </td> <td> \\( -{\\pi\\over 2}< x < {\\pi\\over 2}\\)</td> </tr>
<tr><td>cosec\\(\\, x\\) </td> <td>  \\(\\ln ($cosec$(x)-\\cot(x))+c\\) </td> <td>\\(0 < x < \\pi\\)</td> </tr>
<tr><td>cot\\(\\,x\\) </td> <td>  \\(\\ln(\\sin(x))+c\\) </td> <td>  \\(0< x< \\pi\\) </td> </tr>
<tr><td>\\(\\cosh(x)\\) </td> <td>  \\(\\sinh(x)+c\\)</td> <td></td> </tr>
<tr><td>\\(\\sinh(x)\\) </td> <td>  \\(\\cosh(x) + c\\) </td> <td> </td> </tr>
<tr><td>\\(\\tanh(x)\\) </td> <td>  \\(\\ln(\\cosh(x))+c\\)</td> <td> </td> </tr>
<tr><td>coth\\((x)\\) </td> <td>  \\(\\ln(\\sinh(x))+c \\)</td> <td>   \\(x>0\\)</td> </tr>
<tr><td>\\({1\\over x^2+a^2}\\) </td> <td>  \\({1\\over a}\\tan^{-1}{x\\over a}+c\\)</td> <td> \\(a>0\\)</td> </tr>
<tr><td>\\({1\\over x^2-a^2}\\) </td> <td>  \\({1\\over 2a}\\ln{x-a\\over x+a}+c\\) </td> <td>  \\(|x|>a>0\\)</td> </tr>
<tr><td>\\({1\\over a^2-x^2}\\) </td> <td>  \\({1\\over 2a}\\ln{a+x\\over a-x}+c\\) </td> <td>   \\(|x|<a\\)</td> </tr>
<tr><td>\\({1\\over \\sqrt{x^2+a^2}}\\) </td> <td>  \\(\\sinh^{-1}\\left(\\frac{x}{a}\\right) + c\\) </td> <td> \\(a>0\\) </td> </tr>
<tr><td>\\({1\\over \\sqrt{x^2-a^2}}\\) </td> <td>  \\(\\cosh^{-1}\\left(\\frac{x}{a}\\right) + c\\) </td> <td>  \\(x\\geq a > 0\\) </td> </tr>
<tr><td>\\({1\\over \\sqrt{x^2+k}}\\) </td> <td>  \\(\\ln (x+\\sqrt{x^2+k})+c\\)</td> <td> </td> </tr>
<tr><td>\\({1\\over \\sqrt{a^2-x^2}}\\) </td> <td>  \\(\\sin^{-1}\\left(\\frac{x}{a}\\right)+c\\)</td> <td>  \\(-a\\leq x\\leq a\\)  </td> </tr>
</table></center>';
$string['calc_int_standard_integrals_name'] = 'Standard integraler';
$string['calc_product_rule_fact'] = 'Følgende regel lader dig differentiere et produkt af to funktioner. Antag at vi ønsker at differentiere \\(f(x)g(x)\\) med hensyn til \\(x\\).
\\[ \\frac{\\mathrm{d}}{\\mathrm{d}{x}} \\big(f(x)g(x)\\big) = f(x) \\cdot \\frac{\\mathrm{d} g(x)}{\\mathrm{d}{x}}  + g(x)\\cdot \\frac{\\mathrm{d} f(x)}{\\mathrm{d}{x}},\\] eller alternativt, \\[ (f(x)g(x))\' = f\'(x)g(x)+f(x)g\'(x). \\]';
$string['calc_product_rule_name'] = 'Produktreglen';
$string['calc_quotient_rule_fact'] = 'Kvotientreglen siger at for to differentiable funktioner \\(f(x)\\) og \\(g(x)\\),
 \\[\\frac{d}{dx}\\left(\\frac{f(x)}{g(x)}\\right)=\\frac{g(x)\\cdot\\frac{df(x)}{dx}\\ \\ - \\ \\ f(x)\\cdot \\frac{dg(x)}{dx}}{g(x)^2}. \\]';
$string['calc_quotient_rule_name'] = 'Kvotientreglen';
$string['calc_rules_fact'] = 'Følgende regel lader dig differentiere et produkt af to funktioner. Antag at vi ønsker at differentiere \\(f(x)g(x)\\) med hensyn til \\(x\\). \\[ \\frac{\\mathrm{d}}{\\mathrm{d}{x}} \\big(f(x)g(x)\\big) = f(x) \\cdot \\frac{\\mathrm{d} g(x)}{\\mathrm{d}{x}} + g(x)\\cdot \\frac{\\mathrm{d} f(x)}{\\mathrm{d}{x}},\\] eller alternativt, \\[ (f(x)g(x))\' = f\'(x)g(x)+f(x)g\'(x). \\] <b>Kvotientreglen</b><br />Kvotientreglen siger at for to differentiable funktioner \\(f(x)\\) og \\(g(x)\\), \\[\\frac{d}{dx}\\left(\\frac{f(x)}{g(x)}\\right)=\\frac{g(x)\\cdot\\frac{df(x)}{dx}\\ \\ - \\ \\ f(x)\\cdot \\frac{dg(x)}{dx}}{g(x)^2}. \\] <b>Kædereglen</b><br />Følgende regel lader dig finde den afledte af en sammensætning af to funktioner. Antag at vi har en funktion \\(f(g(x))\\), så hvis vi definerer \\(u=g(x)\\) er den afledte med hensyn til \\(x\\) givet af: \\[\\frac{df(g(x))}{dx} = \\frac{dg(x)}{dx}\\cdot\\frac{df(u)}{du}.\\] Vi kan alternativt skrive: \\[\\frac{df(x)}{dx} = f\'(g(x))\\cdot g\'(x).\\]';
$string['calc_rules_name'] = 'Calculusregler';
$string['casdisplay'] = 'CAS-visning';
$string['cassuitecolerrors'] = 'CAS-fejl';
$string['castext'] = 'CAS-tekst';
$string['casvalid'] = 'V2';
$string['casvalidatemismatch'] = '[CAS validate mismatch]';
$string['casvalue'] = 'CAS-værdi';
$string['chat'] = 'Send til CAS';
$string['chat_desc'] = '<a href="{$a->link}">CAS chat scriptet</a> lader dig teste CAS-forbindelsen, og prøve Maxima-syntaks.';
$string['chatintro'] = 'Denne side lader CAS-tekst blive evalueret direkte. Det er et simpelt script som er et nyttigt minimalt eksempel, samt en let måde at tjekke om CAS virker, og at teste forskellige input. Den første tekstboks gør det muligt at definere variabler, mens den anden boks er til CASteksten.';
$string['chattitle'] = 'Test CAS forbindelsen';
$string['checkanswertype'] = 'Tjek responstypen';
$string['checkanswertype_help'] = 'Hvis ja, bliver svar med forskellige typer (f.eks. udtryk, ligning, matrix, liste, sæt) afvist.';
$string['checkanswertype_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Check_Type';
$string['clearedthecache'] = 'CAS-cachen er ryddet.';
$string['clearingcachefiles'] = 'Rydder cachede STACK plot-filer {$a->done}/{$a->total}';
$string['clearthecache'] = 'Ryd cachen';
$string['completetestcase'] = 'Udfyld resten af formen så testen består';
$string['complexno'] = 'Betydning og visning af sqrt(-1)';
$string['complexno_help'] = 'Kontrollerer betydningen af symbolet i og sqrt(-1), samt hvordan de skal vises.';
$string['complexno_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#sqrt_minus_one.';
$string['createtestcase'] = 'Lav en test';
$string['currentlyselectedvariant'] = 'Dette er varianten vist nedenfor';
$string['ddl_badanswer'] = 'Det bedste svar er misdannet for dette input: <code>{$a}</code>.';
$string['ddl_duplicates'] = 'Duplikerede svar er fundet under generering af inputvalgmulighederne.';
$string['ddl_empty'] = 'Ingen valgmulighed var givet for denne rullemenu.';
$string['ddl_nocorrectanswersupplied'] = 'Læreren har ikke indikeret mindst et korrekt svar.';
$string['ddl_runtime'] = 'Dit input har genereret følgende runtime-fejl. Kontakt din lærer.';
$string['ddl_unknown'] = 'STACK modtog <code>{$a}</code>, men dette er ikke givet som et muligt svar af læreren.';
$string['debuginfo'] = 'Debug info';
$string['defaultmarkzeroifnoprts'] = 'Standardkarakteren skal være 0, hvis dette spørgsmål ikke har nogen PRTs.';
$string['defaultprtcorrectfeedback'] = '<span style="font-size: 1.5em; color:green;"><i class="fa fa-check"></i></span> Korrekt svar, flot klaret.';
$string['defaultprtincorrectfeedback'] = '<span style="font-size: 1.5em; color:red;"><i class="fa fa-times"></i></span> Forkert svar.';
$string['defaultprtpartiallycorrectfeedback'] = '<span style="font-size: 1.5em; color:orange;"><i class="fa fa-adjust"></i></span> Dit svar er delvist korrekt.';
$string['deletetestcase'] = 'Slet test {$a->no} for spørgsmål {$a->question}';
$string['deletetestcaseareyousure'] = 'Er du sikker på, du vil slette test {$a->no} for spørgsmål {$a->question}?';
$string['deletethistestcase'] = 'Slet test...';
$string['deploy'] = 'Indsæt';
$string['deployedprogress'] = 'Indsætter varianter';
$string['deployedvariants'] = 'Varianter indsat';
$string['deployedvariantsn'] = 'Indsatte varianter ({$a})';
$string['deploymanyerror'] = 'Fejl i brugerinput: kan ikke indsætte "{$a->err}" varianter.';
$string['deploymanynonew'] = 'For mange gentagne spørgsmålsnoter blev genereret.';
$string['deploymanynotes'] = 'STACK giver op hvis der er mere end 10 mislykkede forsøg på at generere en ny spørgsmålsnote, eller hvis en spørgsmålstest fejler.';
$string['deploymanysuccess'] = 'Antal nye varianter oprettet, testet og indsat: {$a->no}.';
$string['deployoutoftime'] = 'STACK brugte for lang tid på at indsætte varianter, da cirka {$a->time} sekunder blev brugt. Prøv igen.';
$string['deployremoveall'] = 'Fjern alle varianter.';
$string['deploytestall'] = 'Kør alle tests på alle indsatte varianter (langsom):';
$string['deploytoomanyerror'] = 'STACK vil ikke prøve a indsætte mere end 100 nye varianter på en gang. Ingen nye varianter blev indsat.';
$string['displaymismatch'] = '[LaTeX mismatch]';
$string['dropdowngotunrecognisedvalue'] = 'Ugyldigt input.';
$string['editingtestcase'] = 'Redigerer test {$a->no} for spørgsmålet {$a->question}';
$string['editthistestcase'] = 'Rediger denne test...';
$string['equiv_AND'] = 'og';
$string['equiv_ANDOR'] = 'og/eller forvirring!';
$string['equiv_ASSUMEPOSREALVARS'] = 'og/eller forvirring!';
$string['equiv_ASSUMEPOSVARS'] = 'Antag +ve variabler';
$string['equiv_IMPLIES'] = 'medfører';
$string['equiv_LET'] = 'Lad';
$string['equiv_MISSINGVAR'] = 'Manglende definitioner af variabler';
$string['equiv_NAND'] = 'nand';
$string['equiv_NOR'] = 'hverken';
$string['equiv_NOT'] = 'ikke';
$string['equiv_OR'] = 'eller';
$string['equiv_SAMEROOTS'] = '(Samme rødder)';
$string['equiv_XNOR'] = 'xnor';
$string['equiv_XOR'] = 'xor';
$string['equivfirstline'] = 'Du har brugt den forkerte første linje i dit argument.';
$string['equivnocomments'] = 'Det er ikke tilladt at bruge kommentarer i denne inputtype.';
$string['errors'] = 'Fejl';
$string['exceptionmessage'] = '{$a}';
$string['expectedanswernote'] = 'Forventet svarnote';
$string['expectedoutcomes'] = 'Forventet PRT resultater: [inputs used]';
$string['expectedpenalty'] = 'Forventet straf';
$string['expectedscore'] = 'Forventet score';
$string['exportthisquestion'] = 'Eksporter dette spørgsmål';
$string['exportthisquestion_help'] = 'Dette skaber en Moodle XML-eksportfil som kun indeholder dette ene spørgsmål. Dette kan for eksempel være brugbart hvis du tror dette spørgsmål demonstrerer en fejl i STACK, som du vil rapportere til STACKs udviklere.';
$string['false'] = 'Forkert';
$string['falsebranch'] = 'Forkert gren';
$string['falsebranch_help'] = 'Disse felter kontrollerer hvad der sker hvis svartesten fejler.
### Mod og karakter
Hvordan karakteren skal justeres. = betyder karakteren sættes til en bestemt værdi, +/- betyder tallet skal tilføjes eller trækkes fra den nuværende karakter.

### Straf
I adaptiv eller interaktiv tilstand, tilføj et bestemt antal straf.

### Næste
Om der skal føres til endnu en node, eller om der skal stoppes.

### Svarnote
Dette er en node som bruges til rapportere. Den er lavet for at dokumentere den unikke sti gennem træet, samt udkommet af hver svartest. Svarnoten er automatisk genereret, men kan også ændres til noget meningsfuldt.';
$string['feedbackfromprtx'] = '[ Feedback from {$a}. ]';
$string['feedbackstyle'] = 'PTR feedback stil';
$string['feedbackstyle0'] = 'Formativ';
$string['feedbackstyle1'] = 'Standard';
$string['feedbackstyle2'] = 'Kompakt';
$string['feedbackstyle3'] = 'Kun symbol';
$string['feedbackstyle_help'] = 'Kontrollerer hvordan PTR-feedback vises.';
$string['feedbackstyle_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Potential_response_trees.md';
$string['feedbackvariables'] = 'Feedback variabler.';
$string['feedbackvariables_help'] = 'Feedback variablerne lader dig manipulere input sammen med spørgsmålsvariablerne før træet gennemgås. De variabler du definerer her, kan bruges hvor som helst i dette træ.';
$string['feedbackvariables_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Variables.md#Feedback_variables';
$string['fieldshouldnotcontainplaceholder'] = '{$a->field} bør ikke indeholde nogen [[{$a->type}:...]] pladsholdere.';
$string['fixdollars'] = 'Fix dollars.';
$string['fixdollars_help'] = 'Denne valgmulighed er nyttig hvis du skal indsætte TeX med mange <code>$...$</code> og <code>$$...$$</code> afgrænsninger. Disse afgrænsninger vil automatisk blive erstattet af de anbefalede afgrænsninger når der gemmes.';
$string['fixdollarslabel'] = 'Erstat <code>$...$</code> med <code>\\(...\\)</code>, <code>$$...$$</code> med <code>\\[...\\]</code> og <code>@...@</code> med <code>{@...@}</code> når der gemmes.';
$string['forbiddendoubledollars'] = 'Brug <code>\\(...\\)</code> for inline matematik og <code>\\[...\\]</code> for vist matematik. <code>$...$</code> og <code>$$...$$</code> er ikke tilladt. Der er en valgmulighed ved bunden af siden for at automatisk fikse dette problem.';
$string['forbidfloat'] = 'Forbyd decimaltal.';
$string['forbidfloat_help'] = 'Hvis dette er sat til ja, vil den studerendes svar blive afvist, hvis det indeholder et decimaltal.';
$string['forbidfloat_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Forbid_Floats';
$string['forbidwords'] = 'Forbudne ord';
$string['forbidwords_help'] = 'Dette er en komma-separeret liste af tekststrenge som er forbudte i en studerendes svar.';
$string['forbidwords_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Forbidden_Words';
$string['generalfeedback'] = 'Generel feedback';
$string['generalfeedback_help'] = 'Generel feedback er CASTekst. Generel feedback, også kendt som "bearbejdet løsning", vises til den studerende efter han/hun har prøvet at besvare spørgsmålet. I modsætning til feedback som afhænger af hvilket svar den studerende gav, vises den samme generelle feedbacktekst til alle.  Det kan afhænge af de spørgsmålsvariabler, der anvendes i spørgsmålets variant.';
$string['generalfeedback_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/CASText.md#general_feedback';
$string['greek_alphabet_fact'] = '<center>
<table>
<tr><td>
Store bogstaver, \\(\\quad\\) </td><td>  Små bogstaver, \\(\\quad\\) </td><td>  navn </td> </tr>   <tr> <td>
 \\(A\\)  </td><td>  \\(\\alpha\\)  </td><td>  alpha  </td> </tr>   <tr> <td>
 \\(B\\)  </td><td>  \\(\\beta\\)  </td><td>  beta </td> </tr>   <tr> <td>
 \\(\\Gamma\\)  </td><td>  \\(\\gamma\\)  </td><td>  gamma </td> </tr>   <tr> <td>
 \\(\\Delta\\)  </td><td>  \\(\\delta\\)  </td><td>  delta </td> </tr>   <tr> <td>
 \\(E\\)  </td><td>  \\(\\epsilon\\)  </td><td>  epsilon </td> </tr>   <tr> <td>
 \\(Z\\)  </td><td>  \\(\\zeta\\)  </td><td>  zeta </td> </tr>   <tr> <td>
 \\(H\\)  </td><td>  \\(\\eta\\)  </td><td>  eta </td> </tr>   <tr> <td>
 \\(\\Theta\\)  </td><td>  \\(\\theta\\)  </td><td>  theta </td> </tr>   <tr> <td>
 \\(K\\)  </td><td>  \\(\\kappa\\)  </td><td>  kappa </td> </tr>   <tr> <td>
 \\(M\\)  </td><td>  \\(\\mu\\)  </td><td>  mu </td> </tr>   <tr> <td>
 \\(N\\)  </td><td>  \\( u\\)  </td><td>  nu </td> </tr>   <tr> <td>
 \\(\\Xi\\)  </td><td>  \\(\\xi\\)  </td><td>  xi </td> </tr>   <tr> <td>
 \\(O\\)  </td><td>  \\(o\\)  </td><td>  omicron </td> </tr>   <tr> <td>
 \\(\\Pi\\)  </td><td>  \\(\\pi\\)  </td><td>  pi </td> </tr>   <tr> <td>
 \\(I\\)  </td><td>  \\(\\iota\\)  </td><td>  iota </td> </tr>   <tr> <td>
 \\(P\\)  </td><td>  \\(\\rho\\) </td><td>  rho </td> </tr>   <tr> <td>
 \\(\\Sigma\\)  </td><td>  \\(\\sigma\\)  </td><td>  sigma </td> </tr>   <tr> <td>
 \\(\\Lambda\\)  </td><td>  \\(\\lambda\\)  </td><td>  lambda </td> </tr>   <tr> <td>
 \\(T\\)  </td><td>  \\(\\tau\\)  </td><td>  tau </td> </tr>   <tr> <td>
 \\(\\Upsilon\\)  </td><td>  \\(\\upsilon\\)  </td><td>  upsilon </td> </tr>   <tr> <td>
 \\(\\Phi\\)  </td><td>  \\(\\phi\\)  </td><td>  phi </td> </tr>   <tr> <td>
 \\(X\\)  </td><td>  \\(\\chi\\)  </td><td>  chi </td> </tr>   <tr> <td>
 \\(\\Psi\\)  </td><td>  \\(\\psi\\)  </td><td> psi </td> </tr>   <tr> <td>
 \\(\\Omega\\)  </td><td>  \\(\\omega\\)  </td><td>  omega </td></tr>
</table></center>';
$string['greek_alphabet_name'] = 'Det græske alfabet.';
$string['healthautomaxopt'] = 'Opret automatisk et optimeret Maxima-billede.';
$string['healthautomaxopt_failed'] = 'Forsøg på at skabe et optimeret Maxima billede fejlede : [{$a->errmsg}]';
$string['healthautomaxopt_nolisp'] = 'LISP-version kunne ikke bestemmes, så et optimeret Maxima-billede kunne ikke oprettes automatisk.';
$string['healthautomaxopt_nolisprun'] = 'lisp.run kunne ikke automatisk lokaliseres. Prøv "sudo updatedb" fra kommandolinjen og referer til optimization docs.';
$string['healthautomaxopt_notok'] = 'Maxima-billedet blev ikke oprettet automatisk.';
$string['healthautomaxopt_ok'] = 'Maxima-billede oprettet ved: <tt>{$a->command}</tt>';
$string['healthautomaxopt_succeeded'] = 'Maxima-billede oprettet.';
$string['healthautomaxoptintro'] = 'For at opnå den bedste præstation skal vi optimere Maxima på en Linuxmaskine. Se <a href="doc/doc.php/CAS/Optimising_Maxima.md">dokumentationen</a> for mere information.';
$string['healthcheck'] = 'STACK-sundhedscheck';
$string['healthcheck_desc'] = '<a href="{$a->link}">Scriptet healthcheck </a> hjælper dig med at bekræfte at alle aspekter af STACK virker korrekt.';
$string['healthcheckcache_db'] = 'CAS-resultater bliver gemt i databasen.';
$string['healthcheckcache_none'] = 'CAS-resulter bliver ikke gemt.';
$string['healthcheckcache_otherdb'] = 'CAS-resultater bliver gemt i en anden database.';
$string['healthcheckcachestatus'] = 'Cachen indeholder lige nu {$a} elementer.';
$string['healthcheckconnect'] = 'Prøver at forbinde til CAS';
$string['healthcheckconnectintro'] = 'Vi prøver at evaluere følgende CAS-tekst:';
$string['healthcheckcreateimage'] = 'Opret Maxima-billede';
$string['healthcheckfilters'] = 'Sørg for at {$a->filter}$ er aktiveret på siden <a href="{$a->url}">Manage filters</a>.';
$string['healthchecklatex'] = 'Tjek at LaTeX konverteres korrekt.';
$string['healthchecklatexintro'] = 'STACK genererer LaTeX spontant, og lader lærere skrive LaTeX i spørgsmål. Det antager at LaTeX konverteres af et Moodle-filter. Herunder er eksampler på viste og inline udtryk, hvor LaTeX burde vises korrekt i din browser. Hvis der er fejl her, er det grundet ukorrekte valgmuligheder i Moodles filter, ikke fejl med STACK selv. STACK bruger kun enkelt og dobbelt dollartegn, men nogle lærere bruger andre former.';
$string['healthchecklatexmathjax'] = 'STACK bruger Moodles MathJax filter. Et alternativ er at tilføje javascript kode til Moodles HTML. Se STACK installationsdokumenterne for mere information.';
$string['healthcheckmathsdisplaymethod'] = 'Metoder brugt til at vise matematik: {$a}.';
$string['healthchecknombstring'] = 'STACK v4.3 og senere skal bruge PHP-modulet mbstring, hvilket mangler. Læs installationsdokumenterne.';
$string['healthcheckplots'] = 'Plotting af graf';
$string['healthcheckplotsintro'] = 'Der bør vises to forskellige plots. Hvis to identiske plotter vises, er dette grundet en fejl i navngivning af plotternes filer. Hvis der ikke er nogen fejlbeskeder, men der ikke vises nogen plots, kan følgende muligvis hjælpe: (i) tjek "read"-tilladelse på de to foreløbige mapper, (ii) skift valgmulighederne brugt af GNUPlot til at oprette plottet. Der er aktuelt ikke webinterface til disse valgmuligheder.';
$string['healthchecksamplecas'] = 'Den afledte af {@ x^4/(1+x^4) @} er \\[ \\frac{d}{dx} \\frac{x^4}{1+x^4} = {@ diff(x^4/(1+x^4),x) @}. \\]  Bekræft at unicode kan bruges: \\(\\forall\\) bør vise {@unicode(2200)@}.';
$string['healthchecksampledisplaytex'] = '\\[\\sum_{n=1}^\\infty \\frac{1}{n^2} = \\frac{\\pi^2}{6}.\\]';
$string['healthchecksampleinlinetex'] = '\\(\\sum_{n=1}^\\infty \\frac{1}{n^2} = \\frac{\\pi^2}{6}\\).';
$string['healthchecksampleplots'] = 'To plot vises nedenunder. {@plot([x^4/(1+x^4),diff(x^4/(1+x^4),x)],[x,-3,3])@} {@plot([sin(x),x,x^2,x^3],[x,-3,3],[y,-3,3],grid2d)@}  Et trejde, mindre plot er muligvis vist her med traditionelle akser.  (Kun for nyere versioner af Maxima.) {@plot([sin(x),x,x^2,x^3],[x,-3,3],[y,-3,3],[box, false],[yx_ratio, 1],[axes, solid],[xtics, -3, 1, 3],[ytics, -3, 1, 3],[size,250,250])@}';
$string['healthchecksstackmaximanotupdated'] = 'Det ser ud som om STACK ikke er blevet opdateret ordentligt. Tjek siden <a href="{$a}">System administration-> Notifications</a>';
$string['healthchecksstackmaximatooold'] = 'Så den gamle version er ukendt!';
$string['healthchecksstackmaximaversion'] = 'Maxima version';
$string['healthchecksstackmaximaversionfixoptimised'] = '<a href="{$a->url}">Genbyg din optimerede Maxima executable</a>.';
$string['healthchecksstackmaximaversionfixserver'] = 'Genbyg Maximakoden på din MaximaPool server.';
$string['healthchecksstackmaximaversionfixunknown'] = 'Det er ukendt hvordan det skete. Du bliver nødt til at debugge dette problem selv. Start med at rydde CAS-cachen.';
$string['healthchecksstackmaximaversionmismatch'] = 'Versionen af biblioteket STACK-maxima der bruges ({$a->usedversion}) stemmer ikke overens med hvad der forventes ({$a->expectedversion}) af denne version at STACK spørgsmålstypen. {$a->fix}';
$string['healthchecksstackmaximaversionok'] = 'Korrekte og forventede STACK-Maxima biblioteksversion der bruges ({$a->usedversion}).';
$string['healthunabletolistavail'] = 'Platformens type er ikke aktuelt sat til "unix", så de tilgængelige versioner af Maxima kunne ikke listes.';
$string['healthuncached'] = 'Ikke gemt CAS-kald';
$string['healthuncachedintro'] = 'Denne sektion sender altid et oprigtigt kald til CAS, uanset hvad de nuværende cachevalgmuligheder er. Dette sørger for at forbindelsen til CAS virker.';
$string['healthuncachedstack_CAS_calculation'] = 'Forventet CAS-udregning: {$a->expected}. Faktisk CAS-udregning: {$a->actual}.';
$string['healthuncachedstack_CAS_not'] = 'CAS returnerede noget data som forventet, men der var nogle fejl.';
$string['healthuncachedstack_CAS_ok'] = 'Din forbindelse til CAS er live.';
$string['healthuncachedstack_CAS_version'] = 'Forventet Maxima version: {$a->expected}.  Faktisk Maxima version: {$a->actual}.';
$string['healthuncachedstack_CAS_versionnotchecked'] = 'Du har valgt "standard" Maxima versionen, så Maximas version vil ikke blive tjekket. Din forbindelse bruger version {$a->actual}.';
$string['hyp_functions_fact'] = 'Hyperbolske funktioner har lignende egenskaber til dem trigonometriske funktioner har, men kan også repræstenteres i eksponentiel form:  \\[ \\cosh(x)      = \\frac{e^x+e^{-x}}{2}, \\qquad \\sinh(x)=\\frac{e^x-e^{-x}}{2} \\]
 \\[ \\tanh(x)      = \\frac{\\sinh(x)}{\\cosh(x)} = \\frac{{e^x-e^{-x}}}{e^x+e^{-x}} \\]
 \\[ {\\rm sech}(x) ={1\\over \\cosh(x)}={2\\over {\\rm e}^x+{\\rm e}^{-x}}, \\qquad  {\\rm cosech}(x)= {1\\over \\sinh(x)}={2\\over {\\rm e}^x-{\\rm e}^{-x}} \\]
 \\[ {\\rm coth}(x) ={\\cosh(x)\\over \\sinh(x)} = {1\\over {\\rm tanh}(x)} ={{\\rm e}^x+{\\rm e}^{-x}\\over {\\rm e}^x-{\\rm e}^{-x}}\\]';
$string['hyp_functions_name'] = 'Hyperbolske funktioner';
$string['hyp_identities_fact'] = 'Sammenligningerne mellem hyperbolske og trigonometriske funktioner er tydelige, når man observerer disse hyperbolske identiteter:
  \\[{\\rm e}^x=\\cosh(x)+\\sinh(x), \\quad {\\rm e}^{-x}=\\cosh(x)-\\sinh(x)\\]
  \\[\\cosh^2(x) -\\sinh^2(x) = 1\\]
  \\[1-{\\rm tanh}^2(x)={\\rm sech}^2(x)\\]
  \\[{\\rm coth}^2(x)-1={\\rm cosech}^2(x)\\]
  \\[\\sinh(x\\pm y)=\\sinh(x)\\ \\cosh(y)\\ \\pm\\ \\cosh(x)\\ \\sinh(y)\\]
  \\[\\cosh(x\\pm y)=\\cosh(x)\\ \\cosh(y)\\ \\pm\\ \\sinh(x)\\ \\sinh(y)\\]
  \\[\\sinh(2x)=2\\,\\sinh(x)\\cosh(x)\\]
  \\[\\cosh(2x)=\\cosh^2(x)+\\sinh^2(x)\\]
  \\[\\cosh^2(x)={\\cosh(2x)+1\\over 2}\\]
  \\[\\sinh^2(x)={\\cosh(2x)-1\\over 2}\\]';
$string['hyp_identities_name'] = 'Hyperbolske identiteter';
$string['hyp_inverse_functions_fact'] = '\\[\\cosh^{-1}(x)=\\ln\\left(x+\\sqrt{x^2-1}\\right) \\quad \\mbox{ for } x\\geq 1\\]
 \\[\\sinh^{-1}(x)=\\ln\\left(x+\\sqrt{x^2+1}\\right)\\]
 \\[\\tanh^{-1}(x) = \\frac{1}{2}\\ln\\left({1+x\\over 1-x}\\right) \\quad \\mbox{ for } -1< x < 1\\]';
$string['hyp_inverse_functions_name'] = 'Inverse hyperbolske identiteter';
$string['illegalcaschars'] = 'Tegnene @,$ og \\ er ikke tilladt i CAS input.';
$string['inputdisplayed'] = 'Vist som';
$string['inputentered'] = 'Indtastet værdi';
$string['inputexpression'] = 'Test input';
$string['inputextraoptions'] = 'Ekstra valgmuligheder';
$string['inputextraoptions_help'] = 'Nogle input har brug for ekstra valgmuligheder for at virke. Du kan indsætte dem her. Denne værdi er et CAS-udtryk.';
$string['inputextraoptions_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Extra options';
$string['inputheading'] = 'Input: {$a}';
$string['inputinvalidparamater'] = 'Ugyldigt parameter';
$string['inputlanguageproblems'] = 'Der er uoverensstemmelser i dine input- og valideringstags for forskellige sprog.';
$string['inputname'] = 'Inputtets navn';
$string['inputnameform'] = 'Inputtets navn skal være bogstaver, evt. fulgt af tal. "{$a}" er ikke tilladt.';
$string['inputnamelength'] = 'Inputtets navn må ikke være længere end 18 tegn. "{$a}" er for langt.';
$string['inputopterr'] = 'Værdien af valgmuligheden <code>{$a->opt}</code> kan ikke gives som <code>{$a->val}</code>.';
$string['inputoptionunknown'] = 'Inputtet understøtter ikke valgmuligheden "{$a}".';
$string['inputremovedconfirm'] = 'Jeg bekræfter at jeg gerne vil fjerne dette input fra spørgsmålet.';
$string['inputremovedconfirmbelow'] = 'Input "{$a}" er blevet fjernet. Bekræft dette nedenunder.';
$string['inputs'] = 'Inputs';
$string['inputstatus'] = 'Status';
$string['inputstatusname'] = 'Blank';
$string['inputstatusnameinvalid'] = 'Ugyldigt';
$string['inputstatusnamescore'] = 'Score';
$string['inputstatusnamevalid'] = 'Gyldigt';
$string['inputtest'] = 'Inputtest';
$string['inputtype'] = 'Inputtype';
$string['inputtype_help'] = 'Dette bestemmer input-elementets type, f.eks. sandt/falsk og tekstfelt.';
$string['inputtype_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md';
$string['inputtypealgebraic'] = 'Algebraisk input';
$string['inputtypeboolean'] = 'Sandt/Falskt';
$string['inputtypecheckbox'] = 'Afkrydsningsfelt';
$string['inputtypedropdown'] = 'Rullemenu-liste';
$string['inputtypeequiv'] = 'Ækvivalensargumentation';
$string['inputtypematrix'] = 'Matrice';
$string['inputtypenotes'] = 'Noter';
$string['inputtypenumerical'] = 'Numerisk';
$string['inputtyperadio'] = 'Radio';
$string['inputtypesinglechar'] = 'Enkelt tegn';
$string['inputtypestring'] = 'Tekststreng';
$string['inputtypetextarea'] = 'Tekstfelt';
$string['inputtypeunits'] = 'Enheder';
$string['inputtypevarmatrix'] = 'Matrice af varierende størrelse';
$string['inputwillberemoved'] = 'Dette input er ikke længere henvist til i spørgsmålsteksten. Hvis du gemmer spørgsmålet nu, vil al data om dette input blive tabt. Bekræft at du ønsker dette. Alternativt kan du redigere spørgsmålsteksten og indsætte "[[input:{$a}]]" og "[[validation:{$a}]]" pladsholderne.';
$string['insertspaces'] = 'Indsæt kun stjerner for mellemrum';
$string['insertstars'] = 'Indsæt stjerner';
$string['insertstars_help'] = 'Denne valgmulighed giver forskellige muligheder for at indsætte stjerner hvor multiplikation forventes. Læs dokumentationen for mere info.';
$string['insertstars_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Insert_Stars';
$string['insertstarsassumesinglechar'] = 'Indsæt stjerner, hvor alle variablers navne antages at være ét bogstav langt';
$string['insertstarsno'] = 'Indsæt ikke stjerner';
$string['insertstarsspaces'] = 'Indsæt stjerner for implicit multiplikation og for mellemrum';
$string['insertstarsspacessinglechar'] = 'Indsæt stjerner for implicit multiplikation og for mellemrum, hvor alle variablers navne antages at være ét bogstav langt';
$string['insertstarsyes'] = 'Indsæt kun stjerner for implicit multiplikation';
$string['inversetrig'] = 'Inverse trigonometriske funktioner.';
$string['inversetrig_help'] = 'Kontrollerer hvordan inverse trigonometriske funktioner vises.';
$string['inversetrig_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#inverse_trig';
$string['irred_Q_commonint'] = 'Du skal udtage en fælles faktor.';
$string['irred_Q_optional_fac'] = 'Du kan gøre udtrykket {$a->m0} mere simpelt ved at opløse i faktorer, men det behøver du ikke.';
$string['logicsymbol'] = 'Logiske symboler';
$string['logicsymbol_help'] = 'Kontrollerer hvordan logiske symboler vises.';
$string['logicsymbol_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#logicsymbol';
$string['logicsymbollang'] = 'Sprog';
$string['logicsymbolsymbol'] = 'Symbolsk';
$string['matrixparens'] = 'Standard form af matriceparenteser.';
$string['matrixparens_help'] = 'Kontrollerer hvordan matricer vises i CAS-output.';
$string['matrixparens_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Matrix.md#matrixparens';
$string['mbstringrequired'] = 'Installerer MBSTRING-biblioteket.';
$string['multcross'] = 'Kryds';
$string['multdot'] = 'Prik';
$string['multiplicationsign'] = 'Multiplikationssymbol';
$string['multiplicationsign_help'] = 'Kontrollerer hvordan multiplikation vises.';
$string['multiplicationsign_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#multiplication';
$string['mustverify'] = 'Den studerende skal godkende svar';
$string['mustverify_help'] = 'Bestemmer hvorvidt systemets fortolkning af den studerendes svar bliver vist til dem, hvorefter den studerende skal bekræfte at det er rigtigt fortolket, før svaret bliver sendt videre til scoringsmekanismen. Syntaksfejl bliver altid vist til eleven.';
$string['mustverify_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Student_must_verify';
$string['mustverifyshowvalidation'] = 'Du kan ikke vælge at kræve to-trinsvalidering uden samtidig at vise resultatet af valideringen til den studerende efter første trin. Det sætter den studerende i en umulig situation.';
$string['namealreadyused'] = 'Du har allerede brugt dette navn.';
$string['newnameforx'] = 'Nyt navn til \'{$a}\\';
$string['next'] = 'Næste';
$string['nodehelp'] = 'Responstræsnode';
$string['nodehelp_help'] = '### Svartest
En svartest sammenligner to udtryk for at bestemme om de begge tilfredsstiller visse matematiske kriterier.

### SAns
Dette er svartestens første argument. I asymmetriske tests ses dette som "den studerendes svar", men det kan være ethvert gyldigt CAS-udtryk. Det kan afhænge af både spørgsmålsvariablerne og feedbackvariablerne.

### TAns
Dette er svartestens andet argument. I asymmetriske tests ses dette som "lærerens svar", men det kan være ethvert gyldigt CAS-udtryk. Det kan afhænge af både spørgsmålsvariablerne og feedbackvariablerne.

### Testvalgmuligheder
Dette felt aktiverer muligheden for at give svartesten en valgmulighed, f.eks. en variabel eller en numerisk præcision.

### Stille
Hvis denne valgmulighed er sat til ja, ville al automatisk genereret feedback ikke vises til eleven. Feedbackfelterne i grenene er ikke påvirket af denne valgmulighed.';
$string['nodeloopdetected'] = 'Dette link skaber en cyklus i dette PRT.';
$string['nodenotused'] = 'Ingen andre noder i dette PRT fører til denne node.';
$string['nodex'] = 'Node {$a}';
$string['nodexdelete'] = 'Slet node {$a}';
$string['nodexfalsefeedback'] = 'Node {$a} falsk feedback';
$string['nodextruefeedback'] = 'Node {$a} sand feedback';
$string['nodexwhenfalse'] = 'Node {$a} når falskt';
$string['nodexwhentrue'] = 'Node {$a} når sandt';
$string['nonempty'] = 'Dette må ikke være tomt.';
$string['noprtsifnoinputs'] = 'Et spørgsmål uden inputs kan ikke have PRT\'er.';
$string['notanswered'] = '(Intet svar givet)';
$string['notavalidname'] = 'Ugyldigt navn';
$string['notestcasesyet'] = 'Der er endnu ikke tilføjet nogen tests.';
$string['numericalinputdp'] = 'Du skal give præcist \\( {$a} \\) antal decimaler.';
$string['numericalinputmaxdp'] = 'Du skal give maks \\( {$a} \\) væsentlige tal.';
$string['numericalinputmaxsf'] = 'Du skal give maks \\( {$a} \\) antal decimaler.';
$string['numericalinputmindp'] = 'Du skal give mindst \\( {$a} \\) antal decimaler.';
$string['numericalinputminmaxerr'] = 'Det påkrævede minimum antal numeriske pladser er mere end det maksimale antal pladser.';
$string['numericalinputminsf'] = 'Du skal give mindst \\( {$a} \\) væsentlige tal.';
$string['numericalinputminsfmaxdperr'] = 'Undgå at sætte grænser for både antal decimaler og væsentlige tal for det samme input.';
$string['numericalinputmustfloat'] = 'Dette input forventer et decimaltal.';
$string['numericalinputmustnumber'] = 'Dette input forventer et tal.';
$string['numericalinputmustrational'] = 'Dette input forventer en brøk eller et rationelt tal.';
$string['numericalinputoptboolerr'] = 'Værdien for valgmuligheden <code>{$a->opt}</code> skal være en boolean, men du har givet en <code>{$a->val}</code>.';
$string['numericalinputoptinterr'] = 'Værdien for valgmuligheden <code>{$a->opt}</code> skal være et heltal, men du har givet en <code>{$a->val}</code>.';
$string['numericalinputsf'] = 'Du skal give præcist \\( {$a} \\) væsentlige tal.';
$string['numericalinputvarsforbidden'] = 'Dette input forventer et tal, og må derfor ikke indeholde variabler.';
$string['options'] = 'Valgmuligheder';
$string['overallresult'] = 'Totalt resultat';
$string['penalty'] = 'Straf';
$string['penalty_help'] = 'Strafsystemet fratrækker denne værdi fra resultatet af hvert PRT for hvert forskelligt og gyldigt forsøg som ikke er helt korrekt.';
$string['penalty_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Feedback.md';
$string['penaltyerror'] = 'Straffen skal være et tal mellem 0 og 1.';
$string['penaltyerror2'] = 'Straffen skal være tom, eller være et tal mellem 0 og 1.';
$string['phpcasstring'] = 'PHP-resultat';
$string['phpsuitecolerror'] = 'PHP-fejl';
$string['phpvalid'] = 'V1';
$string['phpvalidatemismatch'] = '[PHP validate mismatch]';
$string['pleaseananswerallparts'] = 'Besvar alle dele af spørgsmålet.';
$string['pleasecheckyourinputs'] = 'Bekræft at din indtastning blev fortolket som forventet.';
$string['pluginname'] = 'STACK';
$string['pluginname_help'] = 'STACK er et matematisk evalueringssystem.';
$string['pluginnameadding'] = 'Tilføjer STACK-spørgsmål';
$string['pluginnameediting'] = 'Redigerer STACK-spørgsmål';
$string['pluginnamesummary'] = 'STACK skaber matematiske spørgsmål for Moodle-quizzer. Disse spørgsmål bruger et computeralgebrasystem til at etablere matematiske egenskaber af studerendes svar.';
$string['privacy:metadata'] = 'STACK-plugintypen lagrer ikke personlige data.';
$string['prtcorrectfeedback'] = 'Standard feedback for korrekte svar';
$string['prtheading'] = 'Potientelt responstræ: {$a}';
$string['prtincorrectfeedback'] = 'Standard feedback for forkerte svar';
$string['prtmustbesetup'] = 'Dette PRT skal sættes op før spørgsmålet kan gemmes.';
$string['prtname'] = 'PRT-navn.';
$string['prtnamelength'] = 'PRT\'er kan ikke have navne der er længere end 18 tegn. "{$a}" er for langt.';
$string['prtnodesheading'] = 'Potentielt responsetræsnoder ({$a})';
$string['prtpartiallycorrectfeedback'] = 'Standard feedback for delvist korrekte svar';
$string['prtremovedconfirm'] = 'Jeg bekræfter, at jeg ønsker at fjerne dette potentielle responstræ fra spørgsmålet.';
$string['prtremovedconfirmbelow'] = 'Potentielt responstræ "{$a}" er blevet fjernet. Bekræft dette herunder.';
$string['prtruntimeerror'] = 'Node {$a->node} genererede følgende fejl: {$a->error}';
$string['prts'] = 'Potentielle responstræer';
$string['prtwillbecomeactivewhen'] = 'Dette potentielle responstræ aktiveres når den studerende har svaret: {$a}';
$string['prtwillberemoved'] = 'Der henvises ikke længere til dette potentielle responstræ i spørgsmålsteksten eller i den specifikke feedback. Hvis du gemmer spørgsmålet nu, vil dette responstræ blive slettet. Bekræft dette. Alternativt kan du redigere spørgsmålsteksten eller den specifikke feedback og inkludere pladsholderen "[[feedback:{$a}]]".';
$string['qm_error'] = 'Dit svar indeholder spørgsmålstegn, ?, hvilket ikke er tilladt.';
$string['questiondoesnotuserandomisation'] = 'Dette spørgsmål bruger ikke tilfældig generering.';
$string['questionnotdeployedyet'] = 'Ingen varianter af dette spørgsmål er blevet aktiveret endnu.';
$string['questionnote'] = 'Spørgsmålsnote';
$string['questionnote_help'] = 'Spørgsmålsnoten er CASText. Formålet med spørgsmålsnoten er at skelne mellem forskellige varianter af et spørgsmål. To spørgsmålsvarianer er set som ens hvis, og kun hvis, deres spørgsmålsnoter er ens.  I senere analyser er hjælper det at efterlade en meningsfuld spørgsmålsnote.';
$string['questionnote_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Question_note.md';
$string['questionnotempty'] = 'Spørgsmålsnoten kan ikke være tom hvis spørgsmålsvariablerne indeholder rand(). Spørgsmålsnoten bruges til at skelne mellem forskellige tilfældige varianter af et spørgsmål.';
$string['questionpreview'] = 'Forhåndsvisning';
$string['questionsimplify'] = 'Forenkling på spørgsmålsniveau';
$string['questionsimplify_help'] = 'Sætter den globale Maxima-variabel "simp" for hele spørgsmålet.';
$string['questionsimplify_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Maxima.md#Simplification';
$string['questiontests'] = 'Spørgsmålstests';
$string['questiontestsdefault'] = '(Standard)';
$string['questiontestsfor'] = 'Spørgsmålstests for seed {$a}';
$string['questiontestspass'] = 'Alle spørgsmålstests bestod.';
$string['questiontext'] = 'Spørgsmålstekst.';
$string['questiontext_help'] = 'Spørgsmålsteksten er CASText.  Dette er "spørgsmålet" som eleven faktisk ser. Du skal indsætte både input og validationselemeter her, og kun her. F.eks. som `[[input:ans1]] [[validation:ans1]]`.';
$string['questiontext_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/CASText.md#question_text';
$string['questiontextfeedbacklanguageproblems'] = 'Der er uoverensstemmelser mellem feedback-tags på forskellige sprog.';
$string['questiontextfeedbackonlycontain'] = 'Spørgsmålsteksten sammen med den specifikke feedback bør kun indeholde "{$a}" én gang.';
$string['questiontextmustcontain'] = 'Spørgsmålsteksten skal indeholde elementet "{$a}".';
$string['questiontextnonempty'] = 'Spørgsmålsteksten må ikke være tom.';
$string['questiontextonlycontain'] = 'Spørgsmålsteksten må kun indeholde elementet "{$a}" én gang.';
$string['questiontextplaceholderswhitespace'] = 'Pladsholdere må ikke indeholde mellemrum, men det ser denne ud til at gøre: "{$a}".';
$string['questionvalue'] = 'Spørgsmålets værdi';
$string['questionvaluepostive'] = 'Spørgsmålets værdi må ikke være negativ.';
$string['questionvariables'] = 'Spørgsmålsvariabler';
$string['questionvariables_help'] = 'Dette felt lader dig definere og manipulere CAS-variabler, f.eks. for at lave tilfældige varianter. Disse er tilgængelige til alle andre dele af spørgsmålet.';
$string['questionvariables_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Variables.md#Question_variables';
$string['questionvariablevalues'] = 'Spørgsmålets variabelværdier';
$string['quiet'] = 'Stille';
$string['quiet_help'] = 'Hvis denne valgmulighed er sat til ja, vil al automatisk genereret feedback ikke vises til den studerende. Feedbackfelterne i grenene er ikke påvirket af denne valgmulighed.';
$string['renamequestionparts'] = 'Giv dele af spørgsmålet nye navne';
$string['replacedollarscount'] = 'Denne kategori indeholder {$a} STACK-spørgsmål.';
$string['replacedollarsin'] = 'Fiksede matematiske afgrænsninger i felt {$a}';
$string['replacedollarsindex'] = 'Kontekster i STACK-spørgsmål';
$string['replacedollarsindexintro'] = 'Hvis du klikker på et af linkene, vil du blive ført til en side hvor du kan gennemse spørgsmålene med hensyn til gamle matematiske afgrænsninger, og få mulighed for automatisk at fikse dem. Hvis du har for mange spørgsmål (tusinde), vil dette nok overvælde din browser, så i det tilfælde bør du indsætte parameteret preview=0 i din URL og prøve igen.';
$string['replacedollarsindextitle'] = 'Erstat $s i spørgsmålstekst.';
$string['replacedollarsnoproblems'] = 'Ingen problemer med afgrænsninger fundet.';
$string['replacedollarstitle'] = 'Erstat $s i spørgsmålsteksterne i {$a}.';
$string['requirelowestterms'] = 'Brøker skal forkortes';
$string['requirelowestterms_help'] = 'Hvis dette er sat til ja, skal alle brøker forkortes. Ellers bliver svaret afvist som ugyldigt.';
$string['requirelowestterms_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Require_lowest_terms';
$string['runquestiontests'] = 'Spørgsmålstests og indsatte varianter';
$string['runtimeerror'] = 'Dette spørgsmål genererede en uventet fejl. Kontakt din lærer.';
$string['runtimefielderr'] = 'Feltet ""{$a->field}"" genererede følgende fejl: {$a->err}';
$string['sans'] = 'SAns';
$string['sans_help'] = 'Dette er svartestens første argument. I asymmetriske tests ses dette som "den studerendes svar", men det kan være ethvert gyldigt CAS-udtryk. Det kan afhænge af både spørgsmålsvariablerne og feedbackvariablerne.';
$string['sans_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Answer_Tests/index.md';
$string['sansrequired'] = 'SAns må ikke være tom';
$string['score'] = 'Karakter';
$string['scoreerror'] = 'Karakteren skal være et tal mellem 0 og 1.';
$string['scoremode'] = 'Mod';
$string['seedx'] = 'Seed {$a}';
$string['seethisquestioninthequestionbank'] = 'Se dette spørgsmål i spørgsmålsbanken';
$string['settingajaxvalidation'] = 'Øjeblikkelig validering';
$string['settingajaxvalidation_desc'] = 'Hvis denne valgmulighed er sat til ja, vil den studerendes input blive valideret hver gang de holder op med at skrive. Dette giver en bedre oplevelse for deltageren, men kan forøge serverbelastningen.';
$string['settingcasdebugging'] = 'CAS debugging';
$string['settingcasdebugging_desc'] = 'Bestemmer om debugging-information vedrørende CAS-forbindelsen skal gemmes.';
$string['settingcasmaximaversion'] = 'Maxima version';
$string['settingcasmaximaversion_desc'] = 'Versionen af Maxima som bruges.';
$string['settingcasresultscache'] = 'Gemning af CAS resultater';
$string['settingcasresultscache_db'] = 'Gem i databasen';
$string['settingcasresultscache_desc'] = 'Denne valgmulighed bestemmer om CAS-kald skal gemmes. Valgmuligheden bør sættes til ja, med mindre du laver udvikling, hvor du skal ændre Maxima-kode. Den nuværende tilstand af cachen vises på siden healthcheck. Hvis du ændrer på valgmulighederne skal du rydde cachen før du kan se effekten af disse ændringer.';
$string['settingcasresultscache_none'] = 'Cache ikke';
$string['settingcastimeout'] = 'CAS-forbindelse timeout';
$string['settingcastimeout_desc'] = 'Brug denne timeout når du prøver at forbinde til Maxima.';
$string['settingdefaultinputoptions'] = 'Standardindstillinger for input';
$string['settingdefaultinputoptions_desc'] = 'Bruges når du laver et nyt spørgsmål, eller indsætter et nyt input til et nuværende spørgsmål.';
$string['settingdefaultquestionoptions'] = 'Standardindstillinger for input';
$string['settingdefaultquestionoptions_desc'] = 'Bruges når du laver et nyt spørgsmål.';
$string['settingmathsdisplay'] = 'Matematisk filter';
$string['settingmathsdisplay_desc'] = 'Metoden der skal bruges til at vise matematik. Hvis du vælger MathJax, skal du følge instrukserne på siden Healthcheck for at aktivere det. Hvis du vælger et filter, skal du sørge for at det filter er aktiveret på administrationssiden "Håndter filtre".';
$string['settingmathsdisplay_mathjax'] = 'MathJax';
$string['settingmathsdisplay_maths'] = 'Gammelt OU matematisk filter';
$string['settingmathsdisplay_oumaths'] = 'Nyt OU matematisk filter';
$string['settingmathsdisplay_tex'] = 'Moodle TeX-filter';
$string['settingmaximalibraries'] = 'Indlæs ekstra Maxima biblioteker:';
$string['settingmaximalibraries_desc'] = 'Dette er en kommasepareret liste af Maxima-biblioteksnavne som automatisk indlæses i Maxima. Du kan kun bruge biblioteksnavne som er understøttet: "stats, distrib, descriptive, simplex". Disse biblioteker vil ikke blive indlæst hvis du har gemt et Maxima-billede for at optimere ydelsen.';
$string['settingmaximalibraries_error'] = 'Følgende pakke er ikke understøttet: {$a}';
$string['settingmaximalibraries_failed'] = 'Det ser ud som om en af Maxima-pakkerne ikke kunne indlæses. Se installationsinstrukserne for mere information.';
$string['settingparsercacheinputlength'] = 'Gem parsede udtryk længere end';
$string['settingparsercacheinputlength_desc'] = 'Parseren kan være ret langsom hvis du har lange udtryk (for eksempel med komplicerede spørgsmålsvariabler). Derfor gemmer vi resultaterne af parsede udtryk, hvis de er længere end denne grænseværdi. 50 tegn er en god standardværdi. Hvis denne valgmulighed er sat til 0, vil cachen deaktiveres.';
$string['settingplatformmaximacommand'] = 'Maxima-kommando';
$string['settingplatformmaximacommand_desc'] = 'Hvis platformstypen er Server, skal denne valgmulighed sættes til URL\'en af Maxima Poolen servlet. Med hensyn til andre platformstyper, hvis denne valgmulighed er tom, vil STACK prøve at gætte hvor Maxima kan findes. Hvis det fejler, skal du sætte valgmuligheden som den fulde sti til Maxima. Du bør overveje at bruge timeout-kommandoen på unix-baserede systemer: f.eks. timeout --kill-after=10s 10s maxima.';
$string['settingplatformplotcommand'] = 'Plot-kommando';
$string['settingplatformplotcommand_desc'] = 'Du kan normalt lade dette felt være tomt, men hvis der er problemer med at plotte grafer, kan det hjælpe at give den fulde sti til gnuplot-kommandoen her.';
$string['settingplatformtype'] = 'Platformens type';
$string['settingplatformtype_desc'] = 'STACK skal vide hviklet operativsystem det kører på. "Server"-valgmuligheden giver bedre performance, men kræver også at en ekstra server bliver oprettet. Valgmuligheden "Linux (optimised)" forklares på siden Optimising Maxima i dokumentationen.';
$string['settingplatformtypeserver'] = 'Server';
$string['settingreplacedollars'] = 'Erstat <code>$</code> og <code>$$</code>';
$string['settingreplacedollars_desc'] = 'Erstat <code>$</code> og <code>$$</code> i spørgsmålstekst sammen med <code>\\\\[...\\\\]</code> og <code>\\\\(...\\\\)</code>. Det er bedre at bruge valgmuligheden "fix matematiske afgrænsninger" herunder.';
$string['settingserveruserpass'] = 'Server brugernavn:adgangskode';
$string['settingserveruserpass_desc'] = 'Hvis du bruger Platformtype: Server, og du har en Maxima pool server med HTTP-godkendelse, kan du indsætte brugernavnet og adgangskoden her. Dette er mere sikkert end at putte dem i URL\'en. Formatet er brugernavn:adgangskode.';
$string['settingsmathsdisplayheading'] = 'Valgmuligheder for hvordan matematik vises';
$string['settingsmaximasettings'] = 'Forbinder til Maxima';
$string['settingusefullinks'] = 'Nyttige links';
$string['showingundeployedvariant'] = 'Viser (ikke indsat) variant: {$a}';
$string['showvalidation'] = 'Vis validering';
$string['showvalidation_help'] = 'Viser al valideringsfeedback for dette input, inklusiv et ekko af den studerendes udtryk i traditionel todimensional notation. Syntaksfejl vises altid.';
$string['showvalidation_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Show_validation';
$string['showvalidationcompact'] = 'Ja, kompakt';
$string['showvalidationno'] = 'Nej';
$string['showvalidationyes'] = 'Ja, med variabelliste';
$string['showvalidationyesnovars'] = 'Ja, uden variabelliste';
$string['singlechargotmorethanone'] = 'Du kan kun indsætte et enkelt tegn her.';
$string['specificfeedback'] = 'Specifik feedback';
$string['specificfeedback_help'] = 'Som udgangspunkt vil feedback for hvert PRT vises her. Det kan også flyttes til spørgsmålsteksten, men så vil Moodle have mindre kontrol over hvornår det vises. Denne blok er ikke CASText.';
$string['sqrtsign'] = 'Rod-symbol for kvadratrødder';
$string['sqrtsign_help'] = 'Kontrollerer hvordan kvadratrødder vises.';
$string['sqrtsign_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#surd';
$string['stack:usediagnostictools'] = 'Brug STACKs redskaber';
$string['stackBlock_elif_after_else'] = '"elif" efter en "else" i en "if"-løkke.';
$string['stackBlock_elif_out_of_an_if'] = '"elif" kan ikke eksistere udenfor en "if"-løkke.';
$string['stackBlock_else_out_of_an_if'] = '"else" kan ikke eksistere udenfor en "if"-løkke.';
$string['stackBlock_escapeNeedsValue'] = 'Escape-blokken skal have en attributværdi.';
$string['stackBlock_ifNeedsCondition'] = 'If-blokken skal have en attributværdi.';
$string['stackBlock_jsxgraph_height'] = 'En JSXGraphs højde skal bruge en kendt CSS-længde enhed.';
$string['stackBlock_jsxgraph_height_num'] = 'Den numeriske portion af højden af en JSXGraph skal være et tal, og må ikke indeholde ekstra tegn.';
$string['stackBlock_jsxgraph_param'] = 'JSXGraph-blokken understøtter i dette tilfælde kun disse parametre: {$a->param}.';
$string['stackBlock_jsxgraph_ref'] = 'JSXGraph-blokken kan kun referere til inputs i samme CASText sektion. "{$a->var}" findes ikke her.';
$string['stackBlock_jsxgraph_width'] = 'En JSXGraphs bredde skal bruge en kendt CSS-længde enhed.';
$string['stackBlock_jsxgraph_width_num'] = 'Den numeriske portion af bredden af en JSXGraph skal være et tal, og må ikke indeholde ekstra tegn.';
$string['stackBlock_missmatch'] = 'har ingen match.';
$string['stackBlock_multiple_else'] = 'Der er for mange "else"-grene i din "if"-løkke.';
$string['stackBlock_unknownBlock'] = 'Følgende blok er ukendt:';
$string['stackCas_CASError'] = 'CAS har givet følgende fejl:';
$string['stackCas_CASErrorCaused'] = 'ledte til følgende fejl:';
$string['stackCas_MissingAt'] = 'Du mangler et <code>@</code>.';
$string['stackCas_MissingCloseDisplay'] = 'Du mangler et <code>\\]</code>.';
$string['stackCas_MissingCloseHTML'] = 'Du mangler slutningen på et html tag.';
$string['stackCas_MissingCloseInline'] = 'Du mangler et <code>\\)</code>.';
$string['stackCas_MissingClosingRawCAS'] = 'Du mangler et <code>#}</code>.';
$string['stackCas_MissingClosingTeXCAS'] = 'Du mangler et <code>@}</code>.';
$string['stackCas_MissingDollar'] = 'Du mangler et <code>$</code>.';
$string['stackCas_MissingOpenDisplay'] = 'Du mangler et <code>\\[</code>.';
$string['stackCas_MissingOpenHTML'] = 'Du mangler starten på et html-tag.';
$string['stackCas_MissingOpenInline'] = 'Du mangler et <code>\\(</code>.';
$string['stackCas_MissingOpenRawCAS'] = 'Du mangler et <code>{#</code>.';
$string['stackCas_MissingOpenTeXCAS'] = 'Du mangler et <code>{@</code>.';
$string['stackCas_MissingStars'] = 'Du mangler *-tegn. Måske ville du skrive {$a->cmd}.';
$string['stackCas_MissingString'] = 'Du mangler et <code>"</code>.';
$string['stackCas_StringOperation'] = 'Det ser ud som om en tekststreng er på det forkerte sted. Fejlen er som følger: <code>{$a->issue}</code>.';
$string['stackCas_allFailed'] = 'CAS kunne ikke finde nogen evaluerede udtryk. Tjek din forbindelse til CAS.';
$string['stackCas_apostrophe'] = 'Apostroffer er ikke tilladt i svar.';
$string['stackCas_applyingnonobviousfunction'] = 'Funktionskaldet {$a->problem} har ikke et let synligt funktionsnavn. Af sikkerhedsgrunde, bliver du muligvist nødt til at forenkle kaldet så valideringssystemet kan se funktionsnavnet.';
$string['stackCas_backward_inequalities'] = 'Ikke-nøjagtige uligheder, f.eks. \\( \\leq \\) eller \\( \\geq \\), skal indsættes som <= eller >=.  Du har {$a->cmd} i dit udtryk, hvilket er bagvendt.';
$string['stackCas_badLogIn'] = 'Du har skrevet <tt>In</tt>.  Den naturlige logaritme skrives som <tt>ln</tt> i små bogstaver.  ("Lima November", ikke "India November")';
$string['stackCas_badpostfixop'] = 'Du har en dårlig "postfix" operator i dit udtryk.';
$string['stackCas_bracketsdontmatch'] = 'Parenteserne er blevet indlejret forkert i dit udtryk: {$a->cmd}.';
$string['stackCas_callingasfunction'] = 'Det er forbudt at kalde resultatet af et funktionskald: {$a->problem}. Lambdas er stadig tilladt.';
$string['stackCas_chained_inequalities'] = 'Det ser ud som om du har dobbelte uligheder, f.eks. \\(a < b < c\\). Du skal sammensætte individuelle uligheder med logiske symboler som \\(and\\) eller \\(or\\).';
$string['stackCas_errorpos'] = 'Ved cirka linje {$a->line} tegn {$a->col}.';
$string['stackCas_failedReturn'] = 'CAS kunne ikke returnere nogen data.';
$string['stackCas_failedReturnOne'] = 'CAS kunne ikke returnere nogle data.';
$string['stackCas_failedValidation'] = 'CASText-validering fejlede.';
$string['stackCas_finalChar'] = '"{$a->char}" er et ugyldigt sidste tegn i {$a->cmd}.';
$string['stackCas_forbiddenChar'] = 'CAS-kommandoer må ikke indeholde følgende tegn: {$a->char}.';
$string['stackCas_forbiddenFunction'] = 'Forbudt funktion: {$a->forbid}.';
$string['stackCas_forbiddenOperator'] = 'Forbudt operator: {$a->forbid}.';
$string['stackCas_forbiddenVariable'] = 'Forbudt variabel eller konstant: {$a->forbid}.';
$string['stackCas_forbiddenWord'] = 'Forbudt udtryk: {$a->forbid}.';
$string['stackCas_inputsdefined'] = 'Du må ikke bruge inputnavne som variabler. Du har forsøgt at definere <code>{$a}</code>.';
$string['stackCas_invalidCommand'] = 'Ugyldige CAS-kommandoer.';
$string['stackCas_missingLeftBracket'] = 'Du mangler en venstre parentes <span class="stacksyntaxexample">{$a->bracket}</span> i udtrykket: {$a->cmd}.';
$string['stackCas_missingRightBracket'] = 'Du mangler en højre parentes <span class="stacksyntaxexample">{$a->bracket}</span> i udtrykket: {$a->cmd}.';
$string['stackCas_newline'] = 'Newline-tegn er ikke tilladt i svar.';
$string['stackCas_noFunction'] = 'Brug af funktionen {$a->forbid} i udtrykket {$a->term} er ikke tilladt her.';
$string['stackCas_operatorAsVariable'] = 'Operatoren {$a->op} blev fortolket som variabel, tjek din syntaks.';
$string['stackCas_percent'] = '% blev fundet i udtrykket {$a->expr}.';
$string['stackCas_qmarkoperators'] = 'Spørgsmålstegn er ikke tilladt i svar.';
$string['stackCas_redefinitionOfConstant'] = 'Du må ikke omdefinere konstanter: {$a->constant}.';
$string['stackCas_spaces'] = 'Ugyldige mellemrum blev fundet i udtrykket {$a->expr}.';
$string['stackCas_spuriousop'] = 'Ukendt operator: {$a->cmd}.';
$string['stackCas_trigexp'] = 'Du kan ikke opløfte en trigonometrisk funktion til et tal ved at skrive {$a->forbid}. \\(\\{$a->identifier}(x)\\) i anden, skrives som <tt>{$a->identifier}(x)^2</tt>.  Den omvendte funktion af \\(\\{$a->identifier}(x)\\) skrives som <tt>a{$a->identifier}(x)</tt> og ikke som \\(\\{$a->identifier}^{-1}(x)\\) .';
$string['stackCas_triginv'] = 'Omvendte trigonometriske funktioner skrives som {$a->goodinv}, ikke som {$a->badinv}.';
$string['stackCas_trigop'] = 'Du skal give {$a->trig} et argument.  Du har {$a->forbid}, hvilket ser ud som om du prøver at bruge {$a->trig} som en variabel.';
$string['stackCas_trigparens'] = 'Når du giver en trigonometrisk funktion et argument, skal du bruge runde parenteser, ikke firkantede parenteser. F.eks. {$a->forbid}.';
$string['stackCas_trigspace'] = 'Når du giver en trigonometrisk funktion et argument, skal du bruge parenteser, ikke mellemrum. Prøv at bruge {$a->trig} i stedet for.';
$string['stackCas_underscores'] = 'Følgende brug af understregning er ikke tilladt: {$a}.';
$string['stackCas_unencpsulated_comma'] = 'Et komma bruges i dit udtryk på en mærkelig måde. I STACK bruges kommaer til at separere lister, sæt, osv. Du skal bruge et punktum, ikke et komma, i decimaltal.';
$string['stackCas_unitssynonym'] = 'Det ser ud som om du bruger enhederne {$a->forbid}.  Mente du {$a->unit}?';
$string['stackCas_unknownFunction'] = 'Ukendt funktion: {$a->forbid} i udtrykket {$a->term}.';
$string['stackCas_unknownFunctionCase'] = 'Input er versalfølsomt: {$a->forbid} er en ukendt funktion. Mente du {$a->lower}?';
$string['stackCas_unknownUnitsCase'] = 'Input er versalfølsomt: {$a->forbid} er en ukendt enhed. Mente du en af følgende {$a->unit}?';
$string['stackCas_unknownVariableCase'] = 'Input er versalfølsomt: {$a->forbid} er en ukendt variabel. Mente du {$a->lower}?';
$string['stackCas_useinsteadChar'] = 'Erstat <span class="stacksyntaxexample">{$a->bad}</span> med "<span class="stacksyntaxexample">{$a->char}</span>".';
$string['stackDoc_404'] = 'Fejl 404';
$string['stackDoc_404message'] = 'Filen kunne ikke findes.';
$string['stackDoc_directoryStructure'] = 'Mappestruktur';
$string['stackDoc_docs'] = 'STACK-dokumentation';
$string['stackDoc_docs_desc'] = '<a href="{$a->link}">STACK-dokumentation</a>: en lokal statisk wiki.';
$string['stackDoc_home'] = 'Dokumentation hjem';
$string['stackDoc_index'] = 'Indholdsfortegnelse';
$string['stackDoc_siteMap'] = 'Sidemappe';
$string['stackDoc_siteMap_en'] = 'Engelsk sidemappe';
$string['stackDoc_version'] = 'Din hjemmeside kører STACK version {$a}.';
$string['stackInstall_input_intro'] = 'Denne side lader dig teste hvordan STACK fortolker forskellige svar fra en studerende. Lige nu understøtter dette kun de mest basale indstillinger:  Fortolkning af uformel syntaks og indsætning af stjerner. <br />\'V\'-kolonner giver gyldighed, udregnet af PHP og CAS.  V1 = PHP gyldigt, V2 = CAS gyldigt.';
$string['stackInstall_input_title'] = 'Et testområde for validering af den studerendes input';
$string['stackInstall_input_title_desc'] = '<a href="{$a->link}">Input-tests scriptet</a> giver eksempler på hvordan STACK fortolker forskellige matematiske udtryk.';
$string['stackInstall_replace_dollars_desc'] = '<a href="{$a->link}">Scriptet Fiks matematiske afgrænsninger </a> kan erstatte gamle <code>@...@</code>, <code>$...$</code> og <code>$$...$$</code> områder i dine spørgsmål med de nye <code>{@...@}</code>, <code>\\(...\\)</code> og <code>\\[...\\]</code> områder.';
$string['stackInstall_testsuite_choose'] = 'Vælg en svartest.';
$string['stackInstall_testsuite_errors'] = 'Dette spørgsmål genererede følgende fejl.';
$string['stackInstall_testsuite_fail'] = 'Nogle tests fejlede!';
$string['stackInstall_testsuite_failingtests'] = 'Tests som fejlede';
$string['stackInstall_testsuite_failingupgrades'] = 'Spørgsmål som ikke kunne opgraderes.';
$string['stackInstall_testsuite_intro'] = 'Denne side lader dig teste om STACKs svartests virker korrekt. Nogle spørgsmålstests kan kun tjekkes via web-interfacen. Andre Maxima-kommandoer skal tjekkes fra kommandolinjen: se unittests.mac.';
$string['stackInstall_testsuite_nogeneralfeedback'] = 'Spørgsmål uden generel feedback: Studerende sætter pris på gennemgåede løsninger!';
$string['stackInstall_testsuite_notests'] = 'Spørgsmål uden tests: Tilføj nogle tests.';
$string['stackInstall_testsuite_pass'] = 'Alle tests bestod!';
$string['stackInstall_testsuite_title'] = 'Et testområde for STACK svartests.';
$string['stackInstall_testsuite_title_desc'] = '<a href="{$a->link}">Svar-test scripet</a> bekræfter at alle svartests virker korrekt.';
$string['stackOptions_AnsTest_values_AlgEquiv'] = 'AlgEquiv';
$string['stackOptions_AnsTest_values_AlgEquivNouns'] = 'AlgEquivNouns';
$string['stackOptions_AnsTest_values_CasEqual'] = 'CasEqual';
$string['stackOptions_AnsTest_values_CompSquare'] = 'CompletedSquare';
$string['stackOptions_AnsTest_values_Diff'] = 'Diff';
$string['stackOptions_AnsTest_values_EqualComAss'] = 'EqualComAss';
$string['stackOptions_AnsTest_values_Equiv'] = 'EquivReasoning';
$string['stackOptions_AnsTest_values_EquivFirst'] = 'EquivFirst';
$string['stackOptions_AnsTest_values_Expanded'] = 'Expanded';
$string['stackOptions_AnsTest_values_FacForm'] = 'FacForm';
$string['stackOptions_AnsTest_values_GT'] = 'Num-GT';
$string['stackOptions_AnsTest_values_GTE'] = 'Num-GTE';
$string['stackOptions_AnsTest_values_Int'] = 'Int';
$string['stackOptions_AnsTest_values_LowestTerms'] = 'LowestTerms';
$string['stackOptions_AnsTest_values_NumAbsolute'] = 'NumAbsolute';
$string['stackOptions_AnsTest_values_NumDecPlaces'] = 'NumDecPlaces';
$string['stackOptions_AnsTest_values_NumDecPlacesWrong'] = 'NumDecPlacesWrong';
$string['stackOptions_AnsTest_values_NumRelative'] = 'NumRelative';
$string['stackOptions_AnsTest_values_NumSigFigs'] = 'NumSigFigs';
$string['stackOptions_AnsTest_values_PartFrac'] = 'PartFrac';
$string['stackOptions_AnsTest_values_PropLogic'] = 'PropositionalLogic';
$string['stackOptions_AnsTest_values_SRegExp'] = 'SRegExp';
$string['stackOptions_AnsTest_values_SameType'] = 'SameType';
$string['stackOptions_AnsTest_values_Sets'] = 'Sets';
$string['stackOptions_AnsTest_values_SigFigsStrict'] = 'SigFigsStrict';
$string['stackOptions_AnsTest_values_SingleFrac'] = 'SingleFrac';
$string['stackOptions_AnsTest_values_String'] = 'String';
$string['stackOptions_AnsTest_values_StringSloppy'] = 'StringSloppy';
$string['stackOptions_AnsTest_values_SubstEquiv'] = 'SubstEquiv';
$string['stackOptions_AnsTest_values_SysEquiv'] = 'SysEquiv';
$string['stackOptions_AnsTest_values_UnitsAbsolute'] = 'UnitsAbsolute';
$string['stackOptions_AnsTest_values_UnitsRelative'] = 'UnitsRelative';
$string['stackOptions_AnsTest_values_UnitsSigFigs'] = 'UnitsSigFigs';
$string['stackOptions_AnsTest_values_UnitsStrictAbsolute'] = 'UnitsStrictAbsolute';
$string['stackOptions_AnsTest_values_UnitsStrictRelative'] = 'UnitsStrictRelative';
$string['stackOptions_AnsTest_values_UnitsStrictSigFigs'] = 'UnitsStrictSigFigs';
$string['stackversionedited'] = 'Dette spørgsmål blev skrevet med STACK version {$a}.';
$string['stackversionerror'] = 'Dette spørgsmål bruger {$a->pat} i {$a->qfield}, hvilket ændrede i STACK version {$a->ver} og understøttes ikke længere.';
$string['stackversionerroralt'] = 'Et alternativ er {$a}.';
$string['stackversionmulerror'] = 'Dette spørgsmål har et input som bruger "mul"-valgmuligheden, hvilket ikke understøttes efter STACK version 4.2. Rediger dette spørgsmål.';
$string['stackversionnone'] = 'Dette spørgsmål er ikke blevet redigeret siden nummererede spørgsmålsvarianter blev tilføjet i STACK version 4.2. Tjek dette spørgsmål.';
$string['stackversionnow'] = 'Den nuværende STACK version er {$a}.';
$string['stackversionregexp'] = 'RegExp svartesten understøttes ikke efter STACK version 4.3. Brug then nye SRegExp-test i stedet for.';
$string['stop'] = '[stop]';
$string['strictsyntax'] = 'Streng syntaks';
$string['strictsyntax_help'] = 'Skal svaret bruge streng Maxima syntaks? Hvis ikke, vil der være flere mønstre som indikerer manglende *er i et svar, inklusiv funktioner og videnskabelig notation.';
$string['strictsyntax_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/';
$string['strlengtherror'] = 'Tekstrengen må ikke være længere end 255 tegn.';
$string['studentValidation_invalidAnswer'] = 'Svaret er ugyldigt.';
$string['studentValidation_listofunits'] = 'Enheder fundet i dit svar: {$a}';
$string['studentValidation_listofvariables'] = 'Variabler fundet i dit svar: {$a}';
$string['studentValidation_notes'] = '(Dette svar bliver ikke automatisk givet karakter af STACK)';
$string['studentValidation_yourLastAnswer'] = 'Dit sidste svar blev fortolket som følger: {$a}';
$string['studentanswer'] = 'Den studerendes svar';
$string['switchtovariant'] = 'Skift til en vilkårlig variant';
$string['symbolicprtcorrectfeedback'] = '<span style="font-size: 1.5em; color:green;"><i class="fa fa-check"></i></span>';
$string['symbolicprtincorrectfeedback'] = '<span style="font-size: 1.5em; color:red;"><i class="fa fa-times"></i></span>';
$string['symbolicprtpartiallycorrectfeedback'] = '<span style="font-size: 1.5em; color:orange;"><i class="fa fa-adjust"></i>';
$string['syntaxattribute'] = 'Hintegenskab';
$string['syntaxattribute_help'] = 'Syntakshintet vil ses som en redigerbar *værdi*, eller en *pladsholder* som ikke kan redigeres.';
$string['syntaxattribute_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Syntax_Hint';
$string['syntaxattributeplaceholder'] = 'Pladsholder';
$string['syntaxattributevalue'] = 'Værdi';
$string['syntaxhint'] = 'Syntakshint';
$string['syntaxhint_help'] = 'Syntakshintet vil vises i svarboksen, når den er tom.';
$string['syntaxhint_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Syntax_Hint';
$string['tans'] = 'TAns';
$string['tans_help'] = 'Dette er svartestens andet argument. I asymmetriske tests ses dette som "lærerens svar", men det kan være ethvert gyldigt CAS-udtryk. Det kan afhænge af både spørgsmålvariablerne og feedbackvariablerne.';
$string['tans_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Answer_Tests/index.md';
$string['tansrequired'] = 'TAns må ikke være tom.';
$string['teacheranswer'] = 'Lærerens svar';
$string['teacheranswerempty'] = 'Dette input må godt være tomt.';
$string['teacheranswershow'] = 'Et korrekt svar er \\( {$a->display} \\), hvilket kan skrives som følger: {$a->value}';
$string['teacheranswershow_disp'] = 'Et korrekt svar er {$a->display}.';
$string['teacheranswershow_mcq'] = 'Et korrekt svar er: {$a->display}';
$string['teacheranswershownotes'] = 'Dette input har ikke noget korrekt svar.';
$string['teachersanswer'] = 'Et korrekt svar';
$string['teachersanswer_help'] = 'Læreren skal specificere et korrekt svar for hvert input. Dette skal være en gyldig Maxima-tekststreng, og kan indeholde spørgsmålsvariablerne.';
$string['teachersanswer_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#model_answer';
$string['testcasexresult'] = 'Test {$a->no} {$a->result}';
$string['testingquestion'] = 'Tester spørgsmål {$a}';
$string['testingquestionvariants'] = 'Forbereder spørgsmålsvarianter';
$string['testinputs'] = 'Testinputs';
$string['testinputsimpwarning'] = 'Testinputs er <em>aldrig forenklede</em>, uanset hvad spørgsmåls- eller PRT-instillingerne er sat til. Brug <tt>ev(...,simp)</tt> for at forenkle dele af eller alle testinputudtrykkene.';
$string['testoptions'] = 'Testvalgmuligheder';
$string['testoptions_help'] = 'Dette felt lader svartests bruge en valgmulighed, f.eks. en variabel eller en numerisk præcision.';
$string['testoptions_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Potential_response_trees.md';
$string['testoptionsinvalid'] = 'Testvalgmulighederne er ugyldige: {$a}';
$string['testoptionsrequired'] = 'Denne test skal bruge testvalgmuligheder.';
$string['testpassesandfails'] = '{$a->passes} bestod og {$a->fails} fejlede.';
$string['testsuitecolerror'] = 'CAS-fejl';
$string['testsuitecolpassed'] = 'Bestod?';
$string['testsuitefail'] = 'Fejl';
$string['testsuitefeedback'] = 'Feedback';
$string['testsuiteknownfail'] = 'Forventet fejl';
$string['testsuiteknownfailmaths'] = 'Forventet fejl (matematik)';
$string['testsuitenotests'] = 'Antal tests: {$a->no}.';
$string['testsuitepass'] = 'Bestod';
$string['testsuiteteststook'] = 'Tests tog {$a->time} sekunder.';
$string['testsuiteteststookeach'] = 'Gennemsnit: {$a->time} sekunder.';
$string['testthisvariant'] = 'Skift til at teste denne variant.';
$string['texdisplaystyle'] = 'Vist ligning';
$string['texinlinestyle'] = 'Inline ligning';
$string['tidyquestion'] = 'Ryd op i STACK-spørgsmål';
$string['tidyquestionx'] = 'Omdøb dele af spørgsmålet {$a}';
$string['trig_degrees_radians_fact'] = '\\[
360^\\circ= 2\\pi \\hbox{ radians},\\quad
1^\\circ={2\\pi\\over 360}={\\pi\\over 180}\\hbox{ radians}
\\]
\\[
1 \\hbox{ radian} = {180\\over \\pi} \\hbox{ degrees}
\\approx 57.3^\\circ
\\]';
$string['trig_degrees_radians_name'] = 'Grader og Radianer';
$string['trig_standard_identities_fact'] = '\\[\\sin(a\\pm b)\\ = \\  \\sin(a)\\cos(b)\\ \\pm\\  \\cos(a)\\sin(b)\\]
 \\[\\cos(a\\ \\pm\\ b)\\ = \\  \\cos(a)\\cos(b)\\ \\mp \\sin(a)\\sin(b)\\]
 \\[\\tan (a\\ \\pm\\ b)\\ = \\  {\\tan (a)\\ \\pm\\ \\tan (b)\\over1\\ \\mp\\ \\tan (a)\\tan (b)}\\]
 \\[ 2\\sin(a)\\cos(b)\\ = \\  \\sin(a+b)\\ +\\ \\sin(a-b)\\]
 \\[ 2\\cos(a)\\cos(b)\\ = \\  \\cos(a-b)\\ +\\ \\cos(a+b)\\]
 \\[ 2\\sin(a)\\sin(b) \\ = \\  \\cos(a-b)\\ -\\ \\cos(a+b)\\]
 \\[ \\sin^2(a)+\\cos^2(a)\\ = \\  1\\]
 \\[ 1+{\\rm cot}^2(a)\\ = \\  {\\rm cosec}^2(a),\\quad \\tan^2(a) +1 \\ = \\  \\sec^2(a)\\]
 \\[ \\cos(2a)\\ = \\  \\cos^2(a)-\\sin^2(a)\\ = \\  2\\cos^2(a)-1\\ = \\  1-2\\sin^2(a)\\]
 \\[ \\sin(2a)\\ = \\  2\\sin(a)\\cos(a)\\]
 \\[ \\sin^2(a) \\ = \\  {1-\\cos (2a)\\over 2}, \\qquad \\cos^2(a)\\ = \\  {1+\\cos(2a)\\over 2}\\]';
$string['trig_standard_identities_name'] = 'Standard trigonometriske identiteter';
$string['trig_standard_values_fact'] = '\\[\\sin(45^\\circ)={1\\over \\sqrt{2}}, \\qquad \\cos(45^\\circ) = {1\\over \\sqrt{2}},\\qquad
\\tan( 45^\\circ)=1
\\]
\\[
\\sin (30^\\circ)={1\\over 2}, \\qquad \\cos (30^\\circ)={\\sqrt{3}\\over 2},\\qquad
\\tan (30^\\circ)={1\\over \\sqrt{3}}
\\]
\\[
\\sin (60^\\circ)={\\sqrt{3}\\over 2}, \\qquad \\cos (60^\\circ)={1\\over 2},\\qquad
\\tan (60^\\circ)={ \\sqrt{3}}
\\]';
$string['trig_standard_values_name'] = 'Standard trigonometriske værdier';
$string['true'] = 'Sandt';
$string['truebranch'] = 'Sand gren';
$string['truebranch_help'] = 'Disse felter kontrollerer hvad der sker, når svartesten består.
### Mod og Karakter
Hvordan karakteren skal justeres. = betyder karakteren skal sættes til en bestemt værdi, +/- betyder den givne værdi tilføjes eller fratrækkes den nuværende karakter.

### Straf
I adaptiv eller interaktiv tilstand, tilføj så meget straf.

### Næste
Om denne node skal føre til en anden node eller stoppe.

### Svarnote
Dette er et mærke for den unikke sti gennem træet, samt udkommet af hver svartest. Dette er automatisk genereret, men du kan også ændre det til noget meningsfuldt.';
$string['undeploy'] = 'U-indsæt';
$string['unrecognisedfactstags'] = 'Følgende tags kan ikke genkendes: {$a->tags}.';
$string['variant'] = 'Variant';
$string['variantsselectionseed'] = 'Tilfældig gruppe.';
$string['variantsselectionseed_help'] = 'Du kan normalt lade denne boks være tom. Hvis du vil have at to forskellige spørgsmål i en quiz bruger samme tilfældige seed, så skal du indsætte samme tekststreng i denne boks for de to spørgsmål (og indsætte det samme sæt tilfældige seeds, hvis du bruger indsatte varianter), og de tilfældige seeds for de to spørgsmål vil synkroniseres.';
$string['verifyquestionandupdate'] = 'Verificer spørgsmålsteksten og opdater formlen.';
$string['yamlrecommended'] = 'Installerer det anbefalede YAML-bibliotek.';
$string['youmustconfirm'] = 'Du skal bekræfte her.';
