<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hvp', language 'lt', version '5.0'.
 *
 * @package     hvp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptterms'] = 'Sutinku su <a href=":url" target="_blank">naudojimo sąlygomis</a>';
$string['accountdetailslinktext'] = 'čia';
$string['action'] = 'Veiksmas';
$string['add'] = 'Pridėti';
$string['addedandupdatedpp'] = 'Pridėta {$a->%new} naujų H5P bibliotekų ir atnaujinta {$a->%old} senų.';
$string['addedandupdatedps'] = 'Pridėta {$a->%new} naujų H5P bibliotekų ir atnaujinta {$a->%old} senosios.';
$string['addedandupdatedsp'] = 'Pridėta {$a->%new} naujų H5P bibliotekų ir atnaujinta {$a->%old} senosios.';
$string['addedandupdatedss'] = 'Pridėta {$a->%new} naujų H5P bibliotekų ir atnaujinta {$a->%old} senosios.';
$string['addednewlibraries'] = 'Pridėta {$a->%new} naujų H5P bibliotekų.';
$string['addednewlibrary'] = 'Pridėta {$a->%new} nauja H5P biblioteka.';
$string['additionalinfo'] = 'Papildoma informacija';
$string['additionallicenseinfo'] = 'Bet kokia papildoma informacija apie licenciją';
$string['addlibraries'] = 'Pridėti bibliotekų';
$string['address'] = 'Adresas';
$string['age'] = 'Tipiškas amžius';
$string['agedescription'] = 'Šio turinio tikslinė auditorija. Galimi įvesties formatai, atskirti kableliais: "1,34-45,-50,59-".';
$string['ajaxfailed'] = 'Nepavyko įkelti duomenų.';
$string['alttext'] = 'Alternatyvus tekstas';
$string['anunexpectedsave'] = 'Kažkas nutiko. Turinys neišsaugotas.';
$string['assistivetechnologieslabel'] = 'Pagalbinių technologijų etiketė';
$string['attribution'] = 'Priskyrimas 4.0';
$string['attributionnc'] = 'Priskyrimas - Nekomercinis naudojimas 4.0';
$string['attributionncnd'] = 'Priskyrimas - Nekomercinis naudojimas - Jokių išvestinių kūrinių 4.0';
$string['attributionncsa'] = 'Priskyrimas - Nekomercinis naudojimas - Analogiškas platinimas 4.0';
$string['attributionnd'] = 'Priskyrimas - Jokių išvestinių kūrinių 4.0';
$string['attributionsa'] = 'Priskyrimas - Analogiškas platinimas 4.0';
$string['author'] = 'Autorius';
$string['authorcomments'] = 'Autoriaus komentarai';
$string['authorcommentsdescription'] = 'Turinio redagavimo komentarai (šis tekstas nebus skelbiamas kaip dalis informacijos apie autorių teises)';
$string['authorname'] = 'Autoriaus vardas';
$string['authorrole'] = 'Autoriaus vaidmuo';
$string['back'] = 'Atgal';
$string['cancel'] = 'Atšaukti';
$string['cancellabel'] = 'Atšaukti';
$string['cancelpublishconfirmationdialogcancelbuttontext'] = 'Ne';
$string['cancelpublishconfirmationdialogconfirmbuttontext'] = 'Taip';
$string['cancelpublishconfirmationdialogdescription'] = 'Ar tikrai norite atšaukti bendrinimo procesą?';
$string['cancelpublishconfirmationdialogtitle'] = 'Cancel sharing';
$string['ccattribution'] = 'Priskyrimas (CC BY)';
$string['ccattributionnc'] = 'Priskyrimas - Nekomercinis naudojimas (CC BY-NC)';
$string['ccattributionncnd'] = 'Priskyrimas - Nekomercinis naudojimas - Jokių išvestinių kūrinių (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Priskyrimas - Nekomercinis naudojimas - Analogiškas platinimas (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Priskyrimas - Jokių išvestinių kūrinių (CC BY-ND)';
$string['ccattributionsa'] = 'Priskyrimas - Analogiškas platinimas (CC BY-SA)';
$string['ccpdd'] = 'Atidavimas naudoti viešai (CC0)';
$string['ccpdm'] = 'Viešo naudojimo žyma (PDM)';
$string['changedby'] = 'Keitimas atliktas';
$string['changedescription'] = 'Keitimo aprašymas';
$string['changehasbeensubmitted'] = 'Buvo pateiktas pakeitimas';
$string['changelog'] = 'Keitimo žurnalas';
$string['changeplaceholder'] = 'Apkarpyta nuotrauka, pakeistas tekstas ir pan.';
$string['city'] = 'Miestas';
$string['close'] = 'Uždaryti';
$string['completionpass'] = 'Reikalauti išlaikymo įverčio';
$string['completionpass_help'] = 'Jei įjungta, ši veikla laikoma baigta, kai besimokantysis gauna išlaikymo įvertinimą (kaip nurodyta H5P veiklos nustatymų skiltyje Įvertinimas) arba aukštesnį įvertinimą.';
$string['completionpassdesc'] = 'Norėdami užbaigti šią veiklą, besimokantieji turi gauti išlaikymo įvertį';
$string['confirmdialogbody'] = 'Patvirtinkite, kad norite tęsti. Šis veiksmas nėra gražinamas.';
$string['confirmdialogheader'] = 'Patvirtinti veiksmą';
$string['confirmlabel'] = 'Patvirtinti';
$string['connectionlost'] = 'Nutrūko ryšys. Rezultatai bus saugomi ir išsiųsti, kai vėl prisijungsite.';
$string['connectionreestablished'] = 'Connection reestablished.';
$string['contactperson'] = 'Kontaktinis asmuo';
$string['contactpersondescription'] = 'Jei kils problemų dėl leidėjo bendrinamo turinio, H5P susisieks su kontaktiniu asmeniu. Kontaktinio asmens vardas ir pavardė ar kita informacija nebus skelbiama ar dalijamasi su trečiosiomis šalimis';
$string['contentavailable'] = 'Jūsų turinys paprastai bus pasiekiamas HUB per vieną darbo dieną.';
$string['contentchanged'] = 'Šis turinys pasikeitė nuo paskutinio naudojimo.';
$string['contentcopied'] = 'Turinys nukopijuotas į iškarpinę';
$string['contenthub:changesettings'] = 'Pakeisti paskyros nustatymus <a href="{$a}">čia</a>';
$string['contenthub:licenseagreementdescription'] = 'Prieš tęsdami, perskaitykite šią sutartį';
$string['contenthub:licenseagreementtitle'] = 'Galutinio vartotojo licencijos sutartis (EULA)';
$string['contenthub:register'] = 'Užregistruokite paskyrą H5P Hub <a href="{$a}">čia</a>';
$string['contenthubeditsharing'] = 'Redaguoti bendrinimo informaciją';
$string['contenthubsharinginprogress'] = 'Bendrinama...';
$string['contenthubsyncchanges'] = 'Sinchronizuoti pakeitimus';
$string['contenthubunshare'] = 'Atšaukti bendrinimą';
$string['contentissyncing'] = 'Turinys sinchronizuojamas.';
$string['contentlicensetitle'] = 'Content License Info';
$string['contenttype'] = 'Turinio tipas';
$string['contenttypecacheheader'] = 'Turinio tipo talpykla';
$string['contentupdatesoon'] = 'Jūsų turinys netrukus bus atnaujintas';
$string['copyright'] = 'Naudojimo teisės';
$string['copyrightinfo'] = 'Informacija apie autorines teises';
$string['copyrightstring'] = 'Autorinės teisės';
$string['copyrighttitle'] = 'Peržiūrėti informaciją apie autorines teises';
$string['couldnotcopy'] = 'Nepavyko nukopijuoti failo.';
$string['couldnotparsejsonfromzip'] = 'Nepavyko išanalizuoti JSON iš paketo: %fileName';
$string['couldnotparsepostdata'] = 'Nepavyko išanalizuoti įrašo duomenų.';
$string['couldnotreadfilefromzip'] = 'Nepavyko nuskaityti failo iš paketo: %fileName';
$string['couldnotsave'] = 'Nepavyko išsaugoti failo.';
$string['country'] = 'Country';
$string['create'] = 'Kurti';
$string['creativecommons'] = 'Creative Commons';
$string['ctcachebuttonlabel'] = 'Atnaujinti turinio tipo saugyklą';
$string['ctcachelastupdatelabel'] = 'Paskutinis atnaujinimas';
$string['ctcacheneverupdated'] = 'Niekada';
$string['ctcachesuccess'] = 'Bibliotekos talpykla sėkmingai atnaujinta!';
$string['ctcachetaskname'] = 'Atnaujinti turinio tipo saugyklą';
$string['currentpage'] = '$current puslapis iš $total';
$string['dataviewreportlabel'] = 'Peržiūrėti atsakymus';
$string['date'] = 'Data';
$string['description'] = 'Aprašymas';
$string['disablefileextensioncheck'] = 'Išjungti failo plėtinio patikrinimą';
$string['disablefullscreen'] = 'Išjungti viso ekrano režimą';
$string['displayoptionalwaysshow'] = 'Rodyti visada';
$string['displayoptionauthoroff'] = 'Kontroliuojama autoriaus, numatyta yra išjungta';
$string['displayoptionauthoron'] = 'Kontroliuojama autoriaus, numatyta yra įjungta';
$string['displayoptiondownloadalways'] = 'Visada';
$string['displayoptiondownloadnever'] = 'Niekada';
$string['displayoptiondownloadpermission'] = 'Tik tuomet, jei naudotojas turi teises eksportuoti H5P';
$string['displayoptionnevershow'] = 'Niekada nerodyti';
$string['displayoptionpermissions'] = 'Rodyti tik tada, jei naudotojas turi teisę eksportuoti H5P';
$string['displayoptionpermissionsembed'] = 'Rodyti tik tada, jei naudotojas turi teisę įterpti H5P';
$string['displayoptions'] = 'Rodymo parinktys';
$string['download'] = 'Atsisiųsti';
$string['downloadfailed'] = 'Nepavyko atsisiųsti prašomos bibliotekos.';
$string['downloadtitle'] = 'Atsisiųsti šį turinį kaip H5P failą.';
$string['dropdownbutton'] = 'Išskleidžiamojo meniu mygtukas';
$string['editinfotitle'] = 'Redaguoti <strong>:title</strong> informaciją';
$string['editingfailed'] = 'Redaguoti nepavyko.';
$string['editor'] = 'Redaktorius';
$string['emailaddress'] = 'Elektroninio pašto adresas';
$string['emailconfirmbody'] = 'Sveiki, {$a->username},

Dėkojame, kad pateikėte atsakymus į „{$a->hvpname}“ kurso „{$a->coursename}“ metu.

Šis pranešimas patvirtina, kad jūsų atsakymai buvo išsaugoti.

Šį H5P galite pasiekti adresu {$a->hvpurl}.';
$string['emailconfirmsmall'] = 'Thank you for submitting your answers to \'{$a->hvpname}\'';
$string['emailconfirmsubject'] = 'Pateikimo patvirtinimas: {$a->hvpname}';
$string['emailnotifybody'] = 'Sveiki, {$a->username},

{$a->studentname} baigė \'{$a->hvpname}\' ({$a->hvpurl}) kurse \'{$a->coursename}\'.

Šį bandymą galite peržiūrėti adresu {$a->hvpreporturl}.';
$string['emailnotifysmall'] = '{$a->studentname} baigė {$a->hvpname}. Žr. {$a->hvpreporturl}';
$string['emailnotifysubject'] = '{$a->studentname} baigė {$a->hvpname}';
$string['embed'] = 'Įterptas kodas';
$string['embedloginfailed'] = 'Jūs neturite prieigos prie šio turinio. Pabandykite prisijungti.';
$string['embedtitle'] = 'Peržiūrėkite šio turinio įterptą kodą.';
$string['empty'] = 'Nėra pasiekiamų rezultatų';
$string['enableabout'] = 'Apie H5P mygtukas';
$string['enablecopyright'] = 'Autorinių teisių mygtukas';
$string['enabledlrscontenttypes'] = 'Įgalinti nuo LRS priklausomus turinio tipus';
$string['enabledlrscontenttypes_help'] = 'Galima naudoti turinio tipus, kurie priklauso nuo mokymosi įrašų saugyklos (LRS), pavyzdžiui, klausimyno turinio tipą.';
$string['enabledownload'] = 'Atsisiuntimo mygtukas';
$string['enableembed'] = 'Įterpimo mygtukas';
$string['enableframe'] = 'Rodyti veiksmo juostą ir rėmelį';
$string['enablehublabel'] = 'Naudoti H5P Hub';
$string['enablejavascript'] = 'Įjunkite JavaScript.';
$string['enablesavecontentstate'] = 'Turinio išsaugojimo vieta';
$string['enablesavecontentstate_help'] = 'Automatiškai išsaugoti esamą interaktyvaus turinio būseną kiekvienam naudotojui. Tai reiškia, kad naudotojas gali tęsti ten, kur baigė.';
$string['failedtodownloadh5p'] = 'Nepavyko atsisiųsti prašomo H5P.';
$string['fileexceedsmaxsize'] = 'Vienas iš paketo failų viršija maksimalų leistiną failo dydį. ({$a->%file} {$a->%used} > {$a->%max})';
$string['filenotfoundonserver'] = 'Failas nerastas serveryje. Patikrinkite failų įkėlimo nustatymus.';
$string['filenotimage'] = 'Failas nėra paveikslėlis.';
$string['filetypenotallowed'] = 'Failo tipas neleistinas.';
$string['finished'] = 'Baigta';
$string['fullscreen'] = 'Per visą ekraną';
$string['gpl'] = 'Bendroji Viešoji Licencija v3';
$string['gradeheading'] = 'Rezultatai {$a}';
$string['gradetopassmustbeset'] = 'Įvertinimas negali būti lygus nuliui, nes šios H5P veiklos užbaigimo metodas nustatytas taip, kad reikia išlaikymo įverčio. Nustatykite vertę, kuri nėra nulis.';
$string['gradetopassnotset'] = 'Šiai H5P veiklai dar nėra nustatyto įvertinimo. Jį galima nustatyti H5P veiklos nustatymų skiltyje Įvertinimas.';
$string['h5pfile'] = 'H5P failas';
$string['h5ptitle'] = 'Apsilankykite H5P.org ir sužinokite daugiau šaunaus turinio.';
$string['helpchoosinglicense'] = 'Padėkite man išsirinkti licenciją';
$string['hide'] = 'Slėpti';
$string['hideadvanced'] = 'Slėpti išplėstinius';
$string['hubsettingsheader'] = 'Turinio tipas';
$string['hvp:addinstance'] = 'Kurti naują H5P veiklą';
$string['hvp:emailconfirmsubmission'] = 'Pateikdami gaukite patvirtinimo pranešimą';
$string['hvp:getcachedassets'] = 'Būtina H5P veiklos peržiūrai';
$string['hvp:getembedcode'] = 'Peržiūrėkite H5P įterpimo kodą, kai nustatyta parinktis „valdoma pagal leidimą“.';
$string['hvp:getexport'] = 'Atsisiųskite .h5p failą, kai nustatyta parinktis „valdoma pagal leidimą“.';
$string['hvp:installrecommendedh5plibraries'] = 'Įdiegti naujus saugaus H5P turinio tipus, rekomenduojamus H5P.org';
$string['hvp:manage'] = 'Redaguoti esamą H5P veiklą';
$string['hvp:restrictlibraries'] = 'Apriboti prieigą prie tam tikrų H5P turinio tipų';
$string['hvp:savecontentuserdata'] = 'Išsaugoti naudotojų pažangą H5P veikloje';
$string['hvp:saveresults'] = 'Išsaugoti baigtų H5P veiklų rezultatus';
$string['hvp:updatelibraries'] = 'Įdiegti naujus H5P turinio tipus arba atnaujinti esamus';
$string['hvp:userestrictedlibraries'] = 'Naudoti ribojamus H5P turinio tipus';
$string['hvp:view'] = 'Žiūrėti ir atlikti H5P veiklas';
$string['hvp:viewallresults'] = 'Peržiūrėti visus baigtus H5P veiklų rezultatus';
$string['hvp:viewresults'] = 'Peržiūrėti savo baigtų H5P veiklų rezultatus';
$string['icon'] = 'Ikona';
$string['icondescription'] = '640x480px. Jei nepasirinktas turinys, bus naudojama kategorijos piktograma';
$string['installdenied'] = 'Neturite teisės įdiegti turinio tipų. Kreipkitės į svetainės administratorių.';
$string['installedlibraries'] = 'Įdiegtos bibliotekos';
$string['intro'] = 'Aprašymas';
$string['invalidage'] = 'Netinkamas tipinio amžiaus įvesties formatas. Galimi įvesties formatai, atskirti kableliais: "1, 34-45, -50, -59-".';
$string['invalidaudioformat'] = 'Netinkamas garso failo formatas. Naudokite mp3 arba wav';
$string['invalidcontentfolder'] = 'Netinkamas turinio aplankas';
$string['invalidcontenttype'] = 'Pasirinktas turinio tipas yra netinkamas.';
$string['invalidfieldtype'] = 'Netinkamas lauko tipas.';
$string['invalidfile'] = 'Failas "{$a->%filename}" neleistinas. Leidžiami tik failai su tokiais plėtiniais: {$a->%files-allowed}.';
$string['invalidh5ppost'] = 'Nepavyko gauti paskelbto H5P.';
$string['invalidimageformat'] = 'Netinkamas paveikslėlio failo formatas. Naudokite jpg, png arba gif';
$string['invalidlanguagefile'] = 'Netinkamas kalbos failas {$a->%file} bibliotekoje $a->%library}';
$string['invalidlanguagefile2'] = 'Netinkamas kalbos failas {$a->%languageFile} įtrauktas į biblioteką {$a->%name}';
$string['invalidlibrary'] = 'Netinkama biblioteka';
$string['invalidlibrarydata'] = 'Neteisingi duomenys iš {$a->%property} bibliotekoje {$a->%library}';
$string['invalidlibraryname'] = 'Neteisingas bibliotekos pavadinimas: {$a->%name}';
$string['invalidlibrarynamed'] = 'Naudojama turinyje H5P biblioteka {$a->%library} netinkama.';
$string['invalidlibraryoption'] = 'Neteisėtas pasirinkimas {$a->%option} bibliotekoje {$a->%library}';
$string['invalidlibraryproperty'] = 'Negalima nuskaityti nuosavybės {$a->%property} bibliotekoje {$a->%library}';
$string['invalidmainjson'] = 'Trūksta galiojančio pagrindinio h5p.json failo';
$string['invalidmultiselectoption'] = 'Neteisingai pasirinkta kelių pasirinkimų parinktyse.';
$string['invalidparameters'] = 'Netinkami parametrai';
$string['invalidselectoption'] = 'Pasirinkta parinktis yra netinkama.';
$string['invalidsemanticsjson'] = 'Įtrauktas neteisingas semantics.json failas bibliotekoje {$a->%name}';
$string['invalidsemanticstype'] = 'Vidinė H5P klaida: semantikoje nežinomas turinio tipas "{$a->@type}". Pašalinkite turinį!';
$string['invalidtoken'] = 'Netinkamas saugumo požymis.';
$string['invalidvideoformat'] = 'Netinkamas vaizdo įrašo failo formatas. Naudokite mp4 ar webm';
$string['javascriptloading'] = 'Laukiama JavaScript...';
$string['keywordexists'] = 'Raktažodis jau yra!';
$string['keywords'] = 'Keywords';
$string['keywordsdescription'] = 'Galite pridėti kelis raktinius žodžius, atskirtus kableliais. Norėdami patvirtinti raktinius žodžius, paspauskite „Enter“ arba „Add“.';
$string['keywordsexists'] = 'Raktiniai žodžiai jau yra!';
$string['keywordsplaceholder'] = 'Pridėti raktinių žodžių';
$string['language'] = 'Kalba';
$string['level'] = 'Lygis';
$string['libraries'] = 'H5P bibliotekos';
$string['librarylistactions'] = 'Veiksmai';
$string['librarylistrestricted'] = 'Ribota';
$string['librarylisttitle'] = 'Pavadinimas';
$string['librarynotselected'] = 'Turite pasirinkti turinio tipą.';
$string['license'] = 'Licencija';
$string['licenseCC010'] = 'CC0 1.0 Universali CC0 1.0 Viešojo naudojimo žyma';
$string['licenseCC010U'] = 'CC0 1.0 Universali';
$string['licenseCC10'] = '1.0 Bendrasis';
$string['licenseCC20'] = '2.0 Bendrasis';
$string['licenseCC25'] = '2.5 Bendrasis';
$string['licenseCC30'] = '3.0 Nepritaikyta jurisdikcijai';
$string['licenseCC40'] = '4.0 Tarptautinė';
$string['licenseGPL'] = 'Bendra viešoji licencija';
$string['licenseV1'] = 'Versija 1';
$string['licenseV2'] = 'Versija 2';
$string['licenseV3'] = 'Versija 3';
$string['licensedescription'] = 'Pasirinkite savo turinio licenciją';
$string['licensedetails'] = 'Išsami informacija apie licenciją';
$string['licensedialogdescription'] = 'Spustelėkite konkrečią licenciją, kad gautumėte informacijos apie tinkamą naudojimą';
$string['licensee'] = 'Licencijos turėtojas';
$string['licenseversion'] = 'Licencijos versija';
$string['licenseversiondescription'] = 'Pasirinkite licencijos versiją';
$string['loadingdata'] = 'Įkeliami duomenys.';
$string['logouploadtext'] = 'Organizacijos logotipas arba avataras';
$string['longdescription'] = 'Ilgas aprašymas';
$string['longdescriptionplaceholder'] = 'Ilgas jūsų turinio aprašymas';
$string['lookforupdates'] = 'Ieškoti H5P naujinimų';
$string['maintitle'] = 'Bendrinamas <strong>:title</strong>';
$string['maximumgrade'] = 'Didžiausias įvertis';
$string['maxlength'] = ':length yra didžiausias simbolių skaičius';
$string['maxscore'] = 'Didžiausias balas';
$string['messageprovider:confirmation'] = 'Jūsų pačių H5P pateikimo patvirtinimas';
$string['messageprovider:submission'] = 'Pranešimas apie H5P pateikimus';
$string['missingcontentfolder'] = 'Trūksta tinkamo turinio aplanko';
$string['missingcontentuserdata'] = 'Klaida: nepavyko rasti turinio naudotojo duomenų';
$string['missinglibrary'] = 'Trūksta reikalingos bibliotekos {$a->@library}';
$string['missinglibraryfile'] = 'Trūksta failo "{$a->%file}" bibliotekoje: "{$a->%name}"';
$string['missinglibraryjson'] = 'Nepavyko rasti bibliotekos.json failo su galiojančiu JSON formatu bibliotekai {$a->%name}';
$string['missingparameters'] = 'Trūksta parametrų';
$string['missinguploadpermissions'] = 'Atkreipkite dėmesį, kad bibliotekos gali būti jūsų įkeltame faile, tačiau jums gali būti neleidžiama įkelti naujų bibliotekų. Dėl to susisiekite su svetainės administratoriumi.';
$string['modulename'] = 'Interaktyvus turinys';
$string['modulename_help'] = 'H5P veiklos modulis leidžia kurti interaktyvų turinį, pvz., interaktyvius vaizdo įrašus, klausimų rinkinius, „vilkti ir palikti“ klausimus, kelių pasirinkimų klausimus, pristatymus ir dar daugiau.

Be turtingo turinio kūrimo, H5P leidžia importuoti ir eksportuoti H5P failus veiksmingesniam turinio dalinimuisi ir panaudojimui.

Naudotojo sąveika ir balai yra įtraukiami į MOODLE kurso įverčių knygelę.

Interaktyvų H5P turinį galima pridėti kurianti turinį, naudojant įdiegtą kūrimo įrankį, arba įkeliant H5P failus iš kitų svetainių, kuriose įgalinta H5P.';
$string['modulename_link'] = 'https://h5p.org/moodle-more-help';
$string['modulenameplural'] = 'Interaktyvus turinys';
$string['next'] = 'Kitas';
$string['nextpage'] = 'Kitas puslapis';
$string['noanswersubmitted'] = 'Naudotojas dar nepateikė H5P turinio atsakymo';
$string['nocontent'] = 'Nepavyko rasti ar išanalizuoti content.json failo';
$string['nocontenttype'] = 'Turinio tipas nedetalizuotas';
$string['nocopyright'] = 'Šiame turinyje nėra informacijos apie autorines teises.';
$string['nodata'] = 'Nėra duomenų, kurie atitiktų Jūsų kriterijus.';
$string['noexport'] = 'Trūksta eksporto failo.';
$string['noextension'] = 'Įkeltas failas nėra tinkamas HTML5 paketas (nėra .h5p failo plėtinio).';
$string['noh5ps'] = 'Šiame kurse nėra interaktyvaus turinio.';
$string['nojson'] = 'Klaidingas pagrindinio h5p.json failas';
$string['nombstringexteension'] = 'Mbstring PHP plėtinys neįkeltas. H5P to reikia, kad tinkamai veiktų';
$string['noparameters'] = 'Nėra parametrų';
$string['noparse'] = 'Nepavyko išanalizuoti pagrindinio h5p.json failo';
$string['nopermissiontogettranslations'] = 'Neturite teisių gauti vertimus';
$string['nopermissiontorestrict'] = 'Neturite teisių apriboti bibliotekų.';
$string['nopermissiontosavecontentuserdata'] = 'Neturite teisių išsaugoti turinio naudotojų duomenų.';
$string['nopermissiontosaveresult'] = 'Neturite teisių išsaugoti turinio rezultatų.';
$string['nopermissiontoupgrade'] = 'Neturite teisių atnaujinti bibliotekų.';
$string['nopermissiontouploadcontent'] = 'Neturite teisių įkelti turinį čia.';
$string['nopermissiontouploadfiles'] = 'Neturite teisių įkelti failų čia.';
$string['nopermissiontoviewcontenttypes'] = 'Neturite teisių peržiūrėti turinio tipų.';
$string['nopermissiontoviewresult'] = 'Neturite teisių peržiūrėti turinio rezultatų.';
$string['nosuchlibrary'] = 'Nėra tokios bibliotekos';
$string['notapplicable'] = 'N/A';
$string['nounzip'] = 'Įkeltas failas nėra tinkamas HTML5 paketas (negalima išarchyvuoti)';
$string['noversionattribution'] = 'Priskyrimas';
$string['noversionattributionnc'] = 'Priskyrimas - Nekomercinis naudojimas';
$string['noversionattributionncnd'] = 'Priskyrimas - Nekomercinis naudojimas - Jokių išvestinių kūrinių';
$string['noversionattributionncsa'] = 'Priskyrimas - Nekomercinis naudojimas - Analogiškas platinimas';
$string['noversionattributionnd'] = 'Priskyrimas - Jokių išvestinių kūrinių';
$string['noversionattributionsa'] = 'Priskyrimas - Analogiškas platinimas';
$string['nowriteaccess'] = 'Aptikta serverio rašymo prieigos problema. Įsitikinkite, kad jūsų serveris gali rašyti į jūsų duomenų aplanką.';
$string['noziparchive'] = 'Jūsų PHP versija nepalaiko „ZipArchive“.';
$string['offlinedialogbody'] = 'Negalėjome išsiųsti informacijos apie šios užduoties atlikimą. Patikrinkite interneto ryšį.';
$string['offlinedialogheader'] = 'Jūsų ryšys su serveriu nutrūko';
$string['offlinedialogretrybuttonlabel'] = 'Bandykite dar kartą dabar';
$string['offlinedialogretrymessage'] = 'Bandoma dar kartą :num....';
$string['offlinesuccessfulsubmit'] = 'Rezultatai sėkmingai pateikti.';
$string['oldphpversion'] = 'Jūsų PHP versija pasenusi. Kad H5P tinkamai veiktų, reikalinga 5.2 versija. Rekomenduojama 5.6 ar naujesnė versija.';
$string['onlyupdate'] = 'Atnaujinkite tik esamas bibliotekas';
$string['optionalinfo'] = 'Neprivaloma informacija';
$string['options'] = 'Parinktys';
$string['pd'] = 'Viešasis domenas';
$string['pddl'] = 'Viešojo domeno priskyrimas ir licencija';
$string['pdm'] = 'Viešojo domeno ženklas';
$string['phone'] = 'Telefonas';
$string['pleasewait'] = 'Prašome palaukti...';
$string['pluginadministration'] = 'H5P';
$string['pluginname'] = 'H5P';
$string['previouspage'] = 'Kitas puslapis';
$string['privacy:metadata:core_files'] = 'H5P veikla saugo failus, kurie buvo įkelti kaip H5P turinio dalis.';
$string['privacy:metadata:core_grades'] = 'H5P veikla saugo naudotojų, kurie atsakė į H5P turinį, įvertinimus.';
$string['privacy:metadata:hvp_content_user_data'] = 'Apibūdinama dabartinė naudotojo turinio būsena. Naudojamas turiniui atkurti į ankstesnę būseną.';
$string['privacy:metadata:hvp_content_user_data:data'] = 'Naudotojo duomenys, kurie buvo saugomi.';
$string['privacy:metadata:hvp_content_user_data:data_id'] = 'Duomenų tipo identifikatorius.';
$string['privacy:metadata:hvp_content_user_data:delete_on_content_change'] = 'Žyma, nurodanti, ar duomenys turi būti ištrinti pasikeitus turiniui.';
$string['privacy:metadata:hvp_content_user_data:hvp_id'] = 'H5P turinio, kuriam priklauso duomenys, ID.';
$string['privacy:metadata:hvp_content_user_data:id'] = 'Turinio naudotojo duomenų ryšio ID.';
$string['privacy:metadata:hvp_content_user_data:preloaded'] = 'Žyma, nustatanti, ar duomenys turi būti iš anksto įkelti į turinį.';
$string['privacy:metadata:hvp_content_user_data:sub_content_id'] = 'H5P subturinys, 0, jei tai nėra antrinis turinys.';
$string['privacy:metadata:hvp_content_user_data:user_id'] = 'Naudotojo, kuriam priklauso duomenys, ID.';
$string['privacy:metadata:hvp_events'] = 'Seka užregistruotus H5P įvykius.';
$string['privacy:metadata:hvp_events:content_id'] = 'Turinio ID, su kuriuo buvo atliktas veiksmas, 0, jei turinys naujas arba jo nėra.';
$string['privacy:metadata:hvp_events:content_title'] = 'Turinio pavadinimas.';
$string['privacy:metadata:hvp_events:created_at'] = 'Įvykio sukūrimo laikas.';
$string['privacy:metadata:hvp_events:id'] = 'Unikalus įvykio ID.';
$string['privacy:metadata:hvp_events:library_name'] = 'Įvykis paveikė biblioteką.';
$string['privacy:metadata:hvp_events:library_version'] = 'Įvykio paveikta bibliotekos versija.';
$string['privacy:metadata:hvp_events:sub_type'] = 'Įvykio potipis arba įvykio veiksmas.';
$string['privacy:metadata:hvp_events:type'] = 'Įvykio tipas.';
$string['privacy:metadata:hvp_events:user_id'] = 'Veiksmą atlikusio naudotojo ID.';
$string['privacy:metadata:hvp_xapi_results'] = 'Saugo xAPI įvykius H5P turinyje.';
$string['privacy:metadata:hvp_xapi_results:additionals'] = 'Papildoma informacija, kurią H5P gali siųsti.';
$string['privacy:metadata:hvp_xapi_results:content_id'] = 'Turinio, pagal kurį buvo atliktas įvykis, ID.';
$string['privacy:metadata:hvp_xapi_results:correct_responses_pattern'] = 'Teisingas atsakymo modelis.';
$string['privacy:metadata:hvp_xapi_results:description'] = 'Turinio, su kuriuo buvo atliktas veiksmas, aprašymas, užduotis ar klausimas.';
$string['privacy:metadata:hvp_xapi_results:id'] = 'Unikalus xAPI įvykio ID.';
$string['privacy:metadata:hvp_xapi_results:interaction_type'] = 'Sąveikos tipas.';
$string['privacy:metadata:hvp_xapi_results:max_score'] = 'Maksimalus pasiekiamas balas už įvykį.';
$string['privacy:metadata:hvp_xapi_results:response'] = 'Naudotojo atsiųstas atsakymas.';
$string['privacy:metadata:hvp_xapi_results:user_id'] = 'Veiksmą atlikusio naudotojo ID.';
$string['publisherdescription'] = 'Leidėjo aprašymas';
$string['publisherdescriptiontext'] = 'Tai bus rodoma bendrinamo turinio skiltyje „Leidėjo informacija“.';
$string['publisherfielddescription'] = 'Bendrinamame turinyje tai bus rodoma kaip leidėjo vardas';
$string['publisherfieldtitle'] = 'Leidėjas';
$string['question'] = 'Klausimas';
$string['registeronhub'] = 'Užsiregistruoti „H5P Hub“.';
$string['registrationfailed'] = 'Įvyko klaida';
$string['registrationfaileddescription'] = 'Šiuo metu mums nepavyko sukurti paskyros. Kažkas nutiko. Pabandykite dar kartą vėliau.';
$string['registrationtitle'] = 'H5P Hub registracija';
$string['remove'] = 'Pašalinti';
$string['removechip'] = 'Pašalinti :chip iš sąrašo';
$string['removeimage'] = 'Pašalinti vaizdą';
$string['removeoldlogentries'] = 'Pašalinti senus H5P žurnalo įrašus';
$string['removeoldmobileauthentries'] = 'Pašalinti senus H5P mobiliųjų autentifikavimo įrašus';
$string['removetmpfiles'] = 'Pašalinti senus H5P laikinus failus';
$string['reportingscaledscoredelimiter'] = ',';
$string['reportingscaledscorelabel'] = 'Įverčių knygutėje įvertis:';
$string['reportingscoredelimiter'] = 'iš';
$string['reportingscorelabel'] = 'Įvertis:';
$string['reportnotsupported'] = 'Nepalaikomas';
$string['reportsubmitgradelabel'] = 'Pateikti įvertį';
$string['requiredinfo'] = 'Būtina informacija';
$string['reuse'] = 'Pakartotinis naudojimas';
$string['reusecontent'] = 'Naudoti turinį pakartotinai';
$string['reusedescription'] = 'Pakartotinai naudoti šį turinį.';
$string['reveal'] = 'Atskleisti';
$string['reviewandsave'] = 'Peržiūrėti ir išsaugoti';
$string['reviewandshare'] = 'Peržiūrėkti ir bendrinti';
$string['reviewinfo'] = 'Peržiūros info';
$string['reviewmessage'] = 'Prieš dalindamiesi peržiūrėkite toliau pateiktą informaciją';
$string['savechanges'] = 'Išsaugoti pakeitimus';
$string['score'] = 'Įvertis';
$string['screenshots'] = 'Ekrano nuotraukos';
$string['screenshotsdescription'] = 'Pridėkite iki penkių savo turinio ekrano kopijų';
$string['search'] = 'Paieška';
$string['searchplaceholder'] = 'Įveskite norėdami ieškoti disciplinų';
$string['sendusagestatistics'] = 'Pateikite naudojimo statistiką';
$string['settings'] = 'H5P nustatymai';
$string['share'] = 'Bendrinti';
$string['shared'] = 'Bendrinama';
$string['sharefailed'] = 'Bendrinti nepavyko.';
$string['sharetryagain'] = 'Kažkas ne taip, pabandykite dar kartą bendrinti.';
$string['sharingnote'] = 'Visą informaciją apie turinį galima redaguoti po bendrinimo';
$string['shortdescription'] = 'Trumpas aprašymas';
$string['shortdescriptionplaceholder'] = 'Trumpas jūsų turinio aprašymas';
$string['showadvanced'] = 'Rodyti papildomus';
$string['showless'] = 'Rodyti mažiau';
$string['showmore'] = 'Rodyti daugiau';
$string['sitekey'] = 'Svetainės raktas';
$string['size'] = 'Dydis';
$string['somekeywordsexists'] = 'Kai kurie iš šių raktinių žodžių jau egzistuoja';
$string['source'] = 'Šaltinis';
$string['startingover'] = 'Jūs pradėsite iš naujo.';
$string['sublevel'] = 'Polygis';
$string['submitted'] = 'Pateikta!';
$string['successfullyregisteredwithhub'] = 'Jūsų svetainė sėkmingai užregistruota H5P Hub.';
$string['successfullyregistred'] = 'Sėkmingai užregistravote paskyrą H5P Hub';
$string['successfullyregistreddescription'] = 'Jūsų paskyros duomenys gali būti pakeisti';
$string['successfullyupdated'] = 'Jūsų H5P Hub paskyros nustatymai buvo sėkmingai pakeisti';
$string['thumbnail'] = 'Miniatiūra';
$string['title'] = 'Pavadinimas';
$string['unabletocreatedir'] = 'Nepavyko sukurti katalogo.';
$string['unabletogetfieldtype'] = 'Nepavyko gauti lauko tipo.';
$string['undisclosed'] = 'Nepaskelbtas';
$string['unpackedfilesexceedsmaxsize'] = 'Bendras išpakuotų failų dydis viršija didžiausią leistiną dydį.  (%used > %max)';
$string['updatedlibraries'] = 'Atnaujintos {$a->%old} H5P bibliotekos.';
$string['updatedlibrary'] = 'Atnaujinta {$a->%old} H5P biblioteka.';
$string['updatelibraries'] = 'Atnaujinti visas bibliotekas';
$string['updateregistrationonhub'] = 'Išsaugoti paskyros nustatymus';
$string['upgrade'] = 'Naujinti H5P';
$string['upgradebuttonlabel'] = 'Naujinti';
$string['upgradedone'] = 'Sėkmingai atnaujinote {$a} turinio egzempliorių (-us).';
$string['upgradeerror'] = 'Apdorojant parametrus įvyko klaida:';
$string['upgradeerrorcontent'] = 'Nepavyko atnaujinti turinio %id:';
$string['upgradeerrordata'] = 'Nepavyko įkelti bibliotekos %lib duomenų.';
$string['upgradeerrormissinglibrary'] = 'Trūksta būtinos bibliotekos %lib.';
$string['upgradeerrornotsupported'] = 'Parametruose yra %used, kurie nepalaikomi';
$string['upgradeerrorparamsbroken'] = 'Parametrai sugadinti.';
$string['upgradeerrorscript'] = 'Nepavyko įkelti %lib atnaujinimo scenarijaus.';
$string['upgradeerrortoohighversion'] = 'Parametrai apima %used, o palaikomi tik %supported  arba ankstesni.';
$string['upgradeheading'] = 'Atnaujinti {$a} turinį';
$string['upgradeinprogress'] = 'Atnaujinta į %ver...';
$string['upgradeinvalidtoken'] = 'Klaida: netinkamas saugumo požymis!';
$string['upgradelibrarycontent'] = 'Naujinti bibliotekos turinį';
$string['upgradelibrarymissing'] = 'Klaida: trūksta Jūsų bibliotekos!';
$string['upgrademessage'] = 'Ketinate atnaujinti {$a} turinio vietą(-as). Pasirinkite atnaujinimo versiją.';
$string['upgradenoavailableupgrades'] = 'Šios bibliotekos atnaujinimų nėra.';
$string['upgradenothingtodo'] = 'Nėra naujesnių turinio pavyzdžių.';
$string['upgradereturn'] = 'Grįžti';
$string['upload'] = 'Įkelti';
$string['uploadlibraries'] = 'Įkelti bibliotekas';
$string['user'] = 'Naudotojas';
$string['validatingh5pfailed'] = 'Nepavyko patvirtinti h5p paketo.';
$string['validationfailed'] = 'Prašomas H5P negalioja';
$string['viewreportlabel'] = 'Ataskaita';
$string['welcomecommunity'] = 'Tikimės, kad Jums patiks H5P ir įsitrauksite į mūsų augančią bendruomenę <a {$a->forums}>diskusijų forumuose</a>.';
$string['welcomecontactus'] = 'Jei turite kokių nors atsiliepimų, nedvejodami <a {$a}>susisiekite su mumis</a>. Teikiami atsiliepimai yra svarbūs, siekiant, kad H5P kasdien taptų vis geresnis!';
$string['welcomegettingstarted'] = 'Norėdami pradėti naudotis H5P ir MOODLE, pažiūrėkite <a {$a->moodle_tutorial}> vadovą </a> ir <a {$a->example_content}> turinio pavyzdžių</a> iš H5P. org įdėjoms.';
$string['welcomeheader'] = 'Sveiki atvykę į H5P pasaulį!';
$string['wrongversion'] = 'H5P bibliotekos versija {$a->%machineName}, naudojama šiame turinyje, netinkama. Turinyje yra {$a->%contentLibrary}, bet turėtų būti {$a->%semanticsLibrary}.';
$string['year'] = 'Metai';
$string['years'] = 'Metai';
$string['yearsfrom'] = 'Metai (nuo)';
$string['yearsto'] = 'Metai (iki)';
$string['zip'] = 'Zip';
