<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'pl', version '5.0'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Masz zbliżającą się sesję wideo - BigBlueButton';
$string['bbbduetimeoverstartingtime'] = 'Czas zamknięcia musi być późniejszy niż czas otwarcia.';
$string['bbbdurationwarning'] = 'Maksymalny czas trwania tej sesji wynosi %duration% minut.';
$string['bbbrecordallfromstartwarning'] = 'Ta sesja jest nagrywana od początku.';
$string['bbbrecordwarning'] = 'Ta sesja jest rejestrowana.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Dodaj nowy pokój BigBlueButton';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'Utwórz instancję sesji na żywo';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'Utwórz instancję z nagraniami';
$string['bigbluebuttonbn:deleterecordings'] = 'Usuń nagrania';
$string['bigbluebuttonbn:importrecordings'] = 'Importuj nagrania';
$string['bigbluebuttonbn:join'] = 'Dołącz do pokoju BigBlueButton';
$string['bigbluebuttonbn:managerecordings'] = 'Zarządzaj nagraniami';
$string['bigbluebuttonbn:protectrecordings'] = 'Chroń nagrania';
$string['bigbluebuttonbn:publishrecordings'] = 'Publikuj nagrania';
$string['bigbluebuttonbn:seepresentation'] = 'Zawsze wyświetlaj plik prezentacji na stronie aktywności';
$string['bigbluebuttonbn:unprotectrecordings'] = 'Nie chroń nagrań';
$string['bigbluebuttonbn:unpublishrecordings'] = 'Cofnij publikację nagrań';
$string['bigbluebuttonbn:view'] = 'Zobacz pokój BigBlueButton';
$string['bigbluebuttonbn:viewallrecordingformats'] = 'Zobacz wszystkie formaty nagrań';
$string['cachedef_currentfetch'] = 'Dane do listy ostatnio pobranych nagrań.';
$string['cachedef_recordings'] = 'Nagrywanie metadanych';
$string['cachedef_serverinfo'] = 'Informacje o zdalnym serwerze';
$string['calendarstarts'] = '{$a} jest zaplanowane na';
$string['cannotperformaction'] = 'Nie można wykonać działania - {$a} - na tym nagraniu';
$string['completionattendance'] = 'Wymagaj obecności (minuty)';
$string['completionattendance_desc'] = 'Wejdź do pokoju i pozostań w nim przez co najmniej {$a} minut/y.';
$string['completionattendance_event_desc'] = 'Student wszedł do pokoju i pozostał w tej sesji przez co najmniej {$a} minut/ę/y';
$string['completionattendancegroup'] = 'Wymagaj obecności (minuty)';
$string['completionengagement_desc'] = 'Zaangażuj się w aktywności podczas spotkania.';
$string['completionengagementchats'] = 'Czaty';
$string['completionengagementchats_desc'] = 'Weź udział w {$a} czacie(ach).';
$string['completionengagementchats_event_desc'] = 'Wzięli udział w {$a} czacie(ach).';
$string['completionengagementemojis'] = 'Emotikony';
$string['completionengagementemojis_event_desc'] = 'Zmienili swoje emotikony {$a} raz(y)';
$string['completionengagementgroup'] = 'Wymagaj udziału';
$string['completionengagementpollvotes'] = 'Głosy w ankiecie';
$string['completionengagementpollvotes_desc'] = 'Głosuj w ankietach {$a} raz(y).';
$string['completionengagementpollvotes_event_desc'] = 'Zagłosowali {$a} raz(y) ankietach';
$string['completionengagementraisehand'] = 'Wymagaj podniesionej ręki';
$string['completionengagementraisehand_desc'] = 'Podnieś rękę {$a} raz(y).';
$string['completionengagementraisehand_event_desc'] = 'Podniosła/Podniósł rękę {$a} raz(y)';
$string['completionengagementtalks'] = 'Mów';
$string['completionengagementtalks_desc'] = 'Zabierz głos {$a} raz/y';
$string['completionengagementtalks_event_desc'] = 'Zabrał(a) głos {$a} raz/y';
$string['completionview_event_desc'] = 'Odwiedził pokój.';
$string['config_checksum_algorithm'] = 'Algorytm sumy kontrolnej serwera BigBlueButton';
$string['config_checksum_algorithm_description'] = 'SHA1 jest kompatybilny ze starszymi serwerami. SHA256 i SHA512 są bezpieczniejsze. SHA512 jest zgodny z FIPS 140-2.';
$string['config_default_messages'] = 'Wiadomości domyślne';
$string['config_disablecam_default'] = 'Domyślnie wyłącz kamerę';
$string['config_disablecam_default_description'] = 'Jeśli ta opcja jest włączona, kamery zostaną wyłączone.';
$string['config_disablecam_editable'] = 'Opcja wyłącz kamerę może być edytowana';
$string['config_disablecam_editable_description'] = 'Domyślne wyłączenie kamery można edytować po dodaniu lub aktualizacji instancji.';
$string['config_disablemic_default'] = 'Domyślnie wyłącz mikrofon';
$string['config_disablemic_default_description'] = 'Jeśli ta opcja jest włączona, mikrofon zostanie wyłączony.';
$string['config_disablemic_editable'] = 'Wyłączenie mikrofonu można edytować';
$string['config_disablemic_editable_description'] = 'Domyślne wyłączenie mikrofonu można edytować po dodaniu lub aktualizacji instancji.';
$string['config_disablenote_default'] = 'Domyślnie wyłącz współdzielone notatki';
$string['config_disablenote_default_description'] = 'Jeśli ta opcja jest włączona, współdzielone notatki zostaną wyłączone.';
$string['config_disablenote_editable'] = 'Wyłączenie współdzielonych notatek można edytować';
$string['config_disablenote_editable_description'] = 'Domyślne wyłączenie współdzielonych notatek można edytować po dodaniu lub aktualizacji instancji.';
$string['config_disableprivatechat_default'] = 'Domyślnie wyłącz czat prywatny';
$string['config_disableprivatechat_default_description'] = 'Jeśli ta opcja jest włączona, czat prywatny zostanie wyłączony.';
$string['config_disableprivatechat_editable'] = 'Wyłączenie czatu prywatnego można edytować';
$string['config_disableprivatechat_editable_description'] = 'Domyślne wyłączenie czatu prywatnego można edytować po dodaniu lub aktualizacji instancji.';
$string['config_disablepublicchat_default'] = 'Domyślnie wyłącz czat publiczny';
$string['config_disablepublicchat_default_description'] = 'Jeśli ta opcja jest włączona, czat publiczny zostanie wyłączony.';
$string['config_disablepublicchat_editable'] = 'Wyłączenie czatu publicznego można edytować';
$string['config_disablepublicchat_editable_description'] = 'Domyślne wyłączenie czatu publicznego można edytować po dodaniu lub aktualizacji instancji.';
$string['config_experimental_features'] = 'Funkcje eksperymentalne';
$string['config_experimental_features_description'] = 'Konfiguracja funkcji eksperymentalnych.';
$string['config_extended_capabilities'] = 'Rozszerzone możliwości';
$string['config_extended_capabilities_description'] = 'Konfiguracja rozszerzonych możliwości, gdy oferuje je serwer BigBlueButton.';
$string['config_general'] = 'Ustawienia główne';
$string['config_general_description'] = 'Aby skonfigurować BigBlueButton, możesz użyć własnego serwera i poświadczeń BigBlueButton lub uzyskać poświadczenia poprzez <a href="https://registration-portal.blindsidenetworks.com/" target="_blank">Portal Rejestracyjny Blindside Networks (otwiera się w nowym oknie)</a>.';
$string['config_guestaccess_enabled'] = 'Dostęp gości zewnętrznych';
$string['config_guestaccess_enabled_description'] = 'Zezwól użytkownikom bez konta w Twojej witrynie na dostęp do pokoju.';
$string['config_hideuserlist_default'] = 'Domyślnie ukryj listę użytkowników';
$string['config_hideuserlist_default_description'] = 'Jeśli ta opcja jest włączona, lista użytkowników sesji będzie ukryta.';
$string['config_hideuserlist_editable'] = 'Ukrycie listy użytkowników można edytować';
$string['config_hideuserlist_editable_description'] = 'Domyślne ukrycie listy użytkowników można edytować po dodaniu lub aktualizacji instancji.';
$string['config_importrecordings'] = 'Importuj nagrania';
$string['config_importrecordings_description'] = 'Te ustawienia są specyficzne dla funkcji';
$string['config_importrecordings_enabled'] = 'Importowanie nagrań włączone';
$string['config_importrecordings_enabled_description'] = 'Gdy to i  funkcja nagrywania są włączone, możliwe jest importowanie nagrań z różnych kursów do aktywności.';
$string['config_importrecordings_from_deleted_enabled'] = 'Importuj nagrania z usuniętych aktywności włączone';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Gdy ta funkcja importowania jest włączona, możliwe jest importowanie nagrań z aktywności, które nie są już w tym kursie.';
$string['config_locksettings'] = 'Konfiguracja ustawień blokowania';
$string['config_locksettings_description'] = 'Te ustawienia włączają lub wyłączają ustawienia w interfejsie użytkownika, a także definiują wartości domyślne tych opcji.';
$string['config_meetingevents_enabled'] = 'Zarejestruj sesje na żywo';
$string['config_meetingevents_enabled_description'] = 'Jeśli ta opcja jest włączona, sesje na żywo będą przetwarzane po zakończeniu sesji. Ta funkcja jest wymagana do ukończenia aktywności i będzie działać tylko wtedy, gdy serwer BigBlueButton może przetwarzać skrypty post_events.';
$string['config_muteonstart'] = 'Wycisz przy uruchomieniu';
$string['config_muteonstart_default'] = 'Opcja - wycisz przy uruchomieniu - domyślnie włączona';
$string['config_muteonstart_default_description'] = 'Jeśli ta opcja jest włączona, sesja zostanie wyciszona przy starcie.';
$string['config_muteonstart_description'] = 'Te ustawienia włączają lub wyłączają opcje w interfejsie użytkownika, a także określają wartości domyślne dla tych opcji.';
$string['config_muteonstart_editable'] = 'Opcja - wycisz przy uruchomieniu - możne być edytowalna';
$string['config_muteonstart_editable_description'] = 'Domyślnie wyciszenie przy uruchomieniu można edytować, gdy instancja jest dodawana lub aktualizowana.';
$string['config_participant'] = 'Uczestnicy';
$string['config_participant_description'] = 'Te ustawienia określają domyślną rolę uczestników konferencji.';
$string['config_participant_moderator_default'] = 'Moderator';
$string['config_participant_moderator_default_description'] = 'Ta reguła jest używana domyślnie po dodaniu nowego pokoju.';
$string['config_presentation_default'] = 'Domyślny plik prezentacji';
$string['config_presentation_default_description'] = 'Plik może być używany we wszystkich pokojach.';
$string['config_preuploadpresentation'] = 'Plik prezentacji';
$string['config_preuploadpresentation_description'] = 'Te ustawienia włączają lub wyłączają opcje w interfejsie użytkownika, a także określają wartości domyślne dla tych opcji. Ta funkcja działa tylko wtedy, gdy serwer Moodle jest dostępny dla BigBlueButton .';
$string['config_preuploadpresentation_editable'] = 'Plik prezentacji na stronie aktywności';
$string['config_preuploadpresentation_editable_description'] = 'Funkcję wstępnego przesyłania prezentacji można edytować w interfejsie użytkownika, gdy pokój lub konferencja zostanie dodana lub zaktualizowana.';
$string['config_profile_picture_enabled'] = 'Pokaż zdjęcia profilowe';
$string['config_profile_picture_enabled_description'] = 'Czy zdjęcia profilowe uczestników powinny być wyświetlane w sesjach BigBlueButton?';
$string['config_recording'] = 'Nagrywanie';
$string['config_recording_all_from_start_default'] = 'Rozpocznij nagrywanie od początku spotkania';
$string['config_recording_all_from_start_default_description'] = 'Czy ustawienie „Rozpocznij nagrywanie od początku” powinno być domyślnie włączone podczas dodawania nowego pokoju BigBlueButton?';
$string['config_recording_all_from_start_editable'] = 'Rozpocznij nagrywanie od początku z możliwością edycji';
$string['config_recording_all_from_start_editable_description'] = 'Jeśli zaznaczone, interfejs zawiera opcję włączania i wyłączania funkcji nagrywania od początku.';
$string['config_recording_default'] = 'Funkcja nagrywania domyślnie włączona';
$string['config_recording_default_description'] = 'Jeśli włączone sesje utworzone w BigBlueButton będą miały możliwości nagrywania.';
$string['config_recording_description'] = 'Ustawienia specyficznych właściwości';
$string['config_recording_editable'] = 'Funkcja nagrywania może być edytowana';
$string['config_recording_editable_description'] = 'Jeśli zaznaczone, interfejs zawiera opcję włączania i wyłączania funkcji nagrywania.';
$string['config_recording_hide_button_default'] = 'Ukryj przycisk nagrywania';
$string['config_recording_hide_button_default_description'] = 'Jeśli zaznaczone, przycisk nagrywania zostanie ukryty';
$string['config_recording_hide_button_editable'] = 'Przycisk "Ukryj  nagranie" może być modyfikowany';
$string['config_recording_hide_button_editable_description'] = 'Jeśli zaznaczone, interfejs zawiera opcję włączania i wyłączania funkcji ukrywania przycisku nagrywania.';
$string['config_recording_protect_editable_description'] = 'Jeśli zaznaczono tę opcję, interfejs zawiera opcję zabezpieczania/odbezpieczania nagrań.';
$string['config_recording_refresh_period'] = 'Okres odświeżania nagrywania (w sekundach)';
$string['config_recording_refresh_period_description'] = 'Jak często należy wysyłać zapytania do serwera BigBlueButton w celu odświeżenia zdalnych informacji dotyczących nagrania?';
$string['config_recording_safe_formats'] = 'Formaty nagrań widoczne dla każdego';
$string['config_recordingready_enabled'] = 'Wyślij powiadomienie o dostępności nagrania';
$string['config_recordingready_enabled_description'] = 'Powiadomienia, gdy funkcja gotowości do nagrywania jest włączona.';
$string['config_recordings'] = 'Pokaż nagrania';
$string['config_recordings_asc_sort'] = 'Ustaw nagrania w kolejności chronologicznej';
$string['config_recordings_asc_sort_description'] = 'Nagrania są uporządkowane według daty, chronologicznie lub odwrotnej kolejności chronologicznej (najnowsze nagranie jako pierwsze).';
$string['config_recordings_deleted_default'] = 'Dołączanie nagrań z usuniętych aktywności domyślnie włączone';
$string['config_recordings_deleted_default_description'] = 'Jeśli ta opcja jest włączona, tabela nagrań będzie zawierać nagrania wszelkich aktywności, które zostały usunięte.';
$string['config_recordings_deleted_editable'] = 'Funkcja dołączania nagrań z usuniętych aktywności może być edytowana';
$string['config_recordings_deleted_editable_description'] = 'Domyślnie dołącz nagrania z usuniętych działań można edytować, gdy instancja jest dodawana lub aktualizowana.';
$string['config_recordings_description'] = 'Ustawienia specyficznych właściwości';
$string['config_recordings_general'] = 'Pokaż ustawienia nagrywania';
$string['config_recordings_general_description'] = 'Te ustawienia są używane tylko podczas wyświetlania nagrańTe ustawienia są używane podczas pokazywania nagrąń';
$string['config_recordings_imported_default'] = 'Pokaż tylko domyślnie włączone łącza importowane';
$string['config_recordings_imported_default_description'] = 'Jeśli ta opcja jest włączona, tabela nagrań będzie zawierać tylko importowane łącza do nagrań.';
$string['config_recordings_imported_editable'] = 'Edycja opcji „Pokaż tylko funkcję importowanych łączy”';
$string['config_recordings_imported_editable_description'] = 'Pokaż domyślnie tylko zaimportowane łącza możliwe do edycji gdy instancja jest dodawana lub aktualizowana.';
$string['config_recordings_preview_default'] = 'Podgląd jest domyślnie włączony';
$string['config_recordings_preview_default_description'] = 'Jeśli ta opcja jest włączona, tabela zawiera podgląd prezentacji.';
$string['config_recordings_preview_editable'] = 'Funkcja podglądu może być edytowana';
$string['config_recordings_preview_editable_description'] = 'Funkcja podglądu może być edytowana po dodaniu lub aktualizacji instancji.';
$string['config_scheduled'] = 'Zaplanowane sesje';
$string['config_scheduled_description'] = 'Te ustawienia domyślnie określają niektóre zachowania dla zaplanowanych sesji.';
$string['config_scheduled_pre_opening'] = 'Dostępne przed czasem otwarcia';
$string['config_scheduled_pre_opening_description'] = 'Czas w minutach dla sesji dostępnej przed upływem czasu otwarcia harmonogramów.';
$string['config_server_url'] = 'Adres URL serwera BigBlueButton';
$string['config_server_url_description'] = 'Adres URL Twojego serwera BigBlueButton.';
$string['config_shared_secret'] = 'Cecha bezpieczeństwa BigBlueButton';
$string['config_shared_secret_description'] = 'Cecha bezpieczeństwa Twojego serwera BigBlueButton. (Domyślnie podana cecha jest przeznaczona dla serwera BigBlueButton dostarczonego przez Blindside Networks, którego można użyć do testowania).';
$string['config_showpresentation_default'] = 'Pokaż plik prezentacji na stronie aktywności';
$string['config_showpresentation_default_description'] = 'Czy studenci powinni mieć dostęp do pliku prezentacji przed sesją? To ustawienie nie ma wpływu na użytkowników z opcją „Zawsze wyświetlaj plik prezentacji na stronie aktywności”.';
$string['config_showpresentation_editable'] = 'Opcja \'Pokaż plik prezentacji na stronie aktywności\'';
$string['config_showpresentation_editable_description'] = 'Opcja w ustawieniach aktywności umożliwiająca nauczycielom wybór, czy plik prezentacji ma być widoczny dla studentów.';
$string['config_uidelegation_enabled'] = 'Delegowanie interfejsu użytkownika jest włączone';
$string['config_uidelegation_enabled_description'] = 'Te ustawienia włączają lub wyłączają delegowanie interfejsu użytkownika do serwera BigBlueButton.';
$string['config_userlimit'] = 'Limit użytkowników';
$string['config_userlimit_default'] = 'Limit użytkowników jest domyślnie włączony';
$string['config_userlimit_default_description'] = 'Domyślnie dozwolona liczba użytkowników w sesji po dodaniu nowego pokoju lub konferencji. Jeśli liczba jest ustawiona na 0, limit nie jest ustalany.';
$string['config_userlimit_description'] = 'Te ustawienia włączają lub wyłączają opcje w interfejsie użytkownika, a także definiują wartości domyślne tych opcji.';
$string['config_userlimit_editable'] = 'Funkcję limitu użytkownika można edytować';
$string['config_userlimit_editable_description'] = 'Opcja limitu użytkowników może być edytowana gdy pokój lub konferencja jest dodawana lub edytowana.';
$string['config_voicebridge'] = 'Mostek głosowy';
$string['config_waitformoderator'] = 'Poczekaj na moderatora';
$string['config_waitformoderator_cache_ttl'] = 'Poczekaj na pamięć podręczną TTL moderatora TTL (sekundy)';
$string['config_waitformoderator_cache_ttl_description'] = 'Aby obsłużyć duże obciążenie klientów, ta wtyczka korzysta z pamięci podręcznej. Ten parametr określa czas przechowywania pamięci podręcznej przed wysłaniem następnego żądania do serwera BigBlueButton.';
$string['config_waitformoderator_default'] = 'Czekaj na moderatora -  domyślnie włączony.';
$string['config_waitformoderator_default_description'] = 'Funkcja oczekiwania na moderatora jest domyślnie włączona po dodaniu nowego pokoju lub konferencji.';
$string['config_waitformoderator_description'] = 'Ustawienia specyficznych właściwości';
$string['config_waitformoderator_editable'] = 'Opcja czekaj na moderatora może być edytowana';
$string['config_waitformoderator_editable_description'] = 'Możliwość edycji  wartości „Poczekaj na moderatora”, gdy pokój lub konferencja są dodawane lub aktualizowane.';
$string['config_waitformoderator_ping_interval_description'] = 'Jak często należy pingować serwer, aby sprawdzić, czy moderator wszedł do pokoju?';
$string['config_welcome_default'] = 'Domyślna wiadomość powitalna';
$string['config_welcome_editable'] = 'Domyślna wiadomość powitalna jest edytowalna przez nauczycieli';
$string['config_welcome_editable_description'] = 'Wiadomość powitalną można edytować po dodaniu lub zaktualizowaniu instancji';
$string['end_session_confirm'] = 'Czy na pewno chcesz zakończyć sesję?';
$string['end_session_confirm_title'] = 'Naprawdę zakończyć sesję?';
$string['end_session_notification'] = 'Sesja zakończyła się.';
$string['ends_at'] = 'Kończy się';
$string['event_activity_created'] = 'Utworzono aktywność';
$string['event_activity_deleted'] = 'Aktywność została usunięta';
$string['event_activity_updated'] = 'Aktywność została zaktualizowana';
$string['event_meeting_created'] = 'Utworzono spotkanie';
$string['event_meeting_ended'] = 'Wymuszone zakończenie spotkania';
$string['event_meeting_joined'] = 'Dołączono do spotkania';
$string['event_meeting_left'] = 'Opuszczono spotkanie';
$string['event_recording_deleted'] = 'Nagranie usunięte';
$string['event_recording_edited'] = 'Nagranie edytowane';
$string['event_recording_imported'] = 'Nagranie zaimportowane';
$string['event_recording_protected'] = 'Nagrywanie chronione';
$string['event_recording_published'] = 'Nagrywanie opublikowane';
$string['event_recording_unprotected'] = 'Nagrywanie niechronione';
$string['event_recording_unpublished'] = 'Nagrywanie niepublikowane';
$string['event_recording_viewed'] = 'Nagrywanie wyświetlone';
$string['event_unknown'] = 'Nieznane wydarzenie';
$string['general_error_cannot_create_meeting'] = 'Nie można utworzyć sesji.';
$string['general_error_cannot_get_recordings'] = 'Nie można pobrać nagrań.';
$string['general_error_no_answer'] = 'Pusta odpowiedź. Sprawdź adres URL serwera BigBlueButton ORAZ sprawdź, czy serwer BigBlueButton jest uruchomiony.';
$string['general_error_not_allowed_to_create_instances'] = 'Użytkownik nie może tworzyć żadnego typu instancji.';
$string['general_error_not_found'] = 'Nie można znaleźć aktywności BigBlueButton o identyfikatorze ({$a}).';
$string['general_error_unable_connect'] = 'Nie można połączyć. Sprawdź adres URL serwera BigBlueButton ORAZ sprawdź, czy serwer BigBlueButton jest uruchomiony.
Szczegóły: {$a}';
$string['guest_invitation_full_message'] = '<p>Cześć,
zostałeś zaproszony na sesję BigBlueButton <strong>{$a->name}</strong> w kursie {$a->course_fullname}.</p>
<p>Link: {$a->guestjoinurl}<br/>
<p>Hasło: {$a->guestpassword}</p>
<p>Jeśli potrzebujesz pomocy, skontaktuj się z {$a->sender}.</p>';
$string['guest_invitation_small_message'] = 'Cześć,
zostałeś zaproszony na sesję BigBlueButton {$a->name} w kursie {$a->course_fullname}.

Link: {$a->guestjoinurl}
Hasło: {$a->guestpassword}

Jeśli potrzebujesz pomocy, skontaktuj się z {$a->sender}.';
$string['guest_invitation_subject'] = 'Zaproszenie: sesja {$a->name} w {$a->course_fullname}';
$string['guestaccess_activitynotfound'] = 'Nie znaleziono aktywności.';
$string['guestaccess_add'] = 'Dodaj gości';
$string['guestaccess_add_no_id'] = 'Nie podano identyfikatora instancji BigBlueButton.';
$string['guestaccess_copy_link'] = 'Skopiuj link';
$string['guestaccess_copy_password'] = 'Skopiuj hasło';
$string['guestaccess_emails_help'] = 'Lista adresów e-mail oddzielonych przecinkami.';
$string['guestaccess_emails_invalidemail'] = 'Nieprawidłowy adres e-mail: {$a}';
$string['guestaccess_feature_disabled'] = 'Dostęp dla gości wyłączony.';
$string['guestaccess_invite_failure'] = 'Błąd {$a->errors} podczas zapraszania {$a->emails}.';
$string['guestaccess_invite_success'] = 'Zaproszenie zostanie wysłane na adres {$a->emails}.';
$string['guestaccess_join_meeting'] = 'Dołącz do spotkania';
$string['guestaccess_meeting_invalid_password'] = 'Niepoprawne hasło.';
$string['guestaccess_meeting_link'] = 'Link do spotkania';
$string['guestaccess_meeting_not_started'] = 'Spotkanie jeszcze się nie rozpoczęło. Proszę wrócić później.';
$string['guestaccess_meeting_password'] = 'Hasło spotkania';
$string['guestaccess_password'] = 'Hasło';
$string['guestaccess_title'] = 'Dodaj gości do tego spotkania';
$string['guestaccess_username'] = 'Nazwa użytkownika gościa';
$string['index_confirm_end'] = 'Chcesz zakończyć sesję?';
$string['index_disabled'] = 'wyłączone';
$string['index_enabled'] = 'włączone';
$string['index_ending'] = 'Kończenie sesji ... proszę czekać';
$string['index_error_bbtn'] = 'Identyfikator BigBlueButton {$a} jest niepoprawny';
$string['index_error_checksum'] = 'Błąd sumy kontrolnej. Upewnij się, że wprowadziłeś poprawną "sól"';
$string['index_error_forciblyended'] = 'Nie można dołączyć do tego spotkania, ponieważ zostało ono zakończone przez moderatora.';
$string['index_error_noinstances'] = 'Nie ma instancji pokojów BigBlueButton';
$string['index_error_unable_display'] = 'Nie można wyświetlić spotkania. Proszę sprawdzić adres URL serwera BigBlueButton oraz skontrolować czy serwer BigBlueButton pracuje.';
$string['index_heading'] = 'Pokoje BigBlueButton';
$string['index_heading_actions'] = 'Akcje';
$string['index_heading_group'] = 'Grupy';
$string['index_heading_moderator'] = 'Moderatorzy';
$string['index_heading_name'] = 'Pokój';
$string['index_heading_recording'] = 'Nagrywanie';
$string['index_heading_users'] = 'Użytkownicy';
$string['index_heading_viewer'] = 'Oglądający';
$string['indicator:cognitivedepth'] = 'Poznawczość BigBlueButton';
$string['indicator:cognitivedepth_help'] = 'Ten wskaźnik opiera się na głębi poznawczej osiągniętej przez studenta podczas korzystania z aktywności BigBlueButton.';
$string['indicator:socialbreadth'] = 'Społeczność BigBlueBN';
$string['instance_type_default'] = 'Pokój z nagraniami';
$string['instance_type_recording_only'] = 'Tylko nagrania';
$string['instance_type_room_only'] = 'Tylko pokój';
$string['managebbbextplugins'] = 'Zarządzaj wtyczkami rozszerzeń BigBlueButton';
$string['messageprovider:instance_updated'] = 'Zaktualizowano sesję BigBlueButton';
$string['minute'] = 'minuta';
$string['minutes'] = 'minut';
$string['mod_form_block_general'] = 'Ustawiania ogólne';
$string['mod_form_block_guestaccess'] = 'Dostęp gościa';
$string['mod_form_block_participants'] = 'Uczestnicy';
$string['mod_form_block_presentation'] = 'Zawartość prezentacji';
$string['mod_form_block_presentation_default'] = 'Domyślna zawartość prezentacji';
$string['mod_form_block_record'] = 'Ustawienia nagrania';
$string['mod_form_block_recordings'] = 'Widok nagrań';
$string['mod_form_block_room'] = 'Ustawienia pokoju';
$string['mod_form_block_schedule'] = 'Harmonogram sesji';
$string['mod_form_field_closingtime'] = 'Zamknij';
$string['mod_form_field_conference_name'] = 'Nazwa sesji';
$string['mod_form_field_disablecam'] = 'Wyłącz kamery internetowe';
$string['mod_form_field_disablemic'] = 'Wyłącz mikrofony';
$string['mod_form_field_disablenote'] = 'Wyłącz udostępnione notatki';
$string['mod_form_field_disableprivatechat'] = 'Wyłącz prywatny czat';
$string['mod_form_field_disablepublicchat'] = 'Wyłącz publiczny czat';
$string['mod_form_field_duration'] = 'Czas trwania';
$string['mod_form_field_duration_help'] = 'Ustawienie czasu trwania spotkania określi maksymalny czas, przez jaki spotkanie będzie zachowane przed zakończeniem nagrywania';
$string['mod_form_field_guestallowed'] = 'Zezwól na dostęp dla gości';
$string['mod_form_field_hideuserlist'] = 'Ukryj listę użytkowników';
$string['mod_form_field_instanceprofiles'] = 'Rodzaj aktywności';
$string['mod_form_field_intro'] = 'Opis';
$string['mod_form_field_intro_help'] = 'Krótki opis pokoju.';
$string['mod_form_field_mustapproveuser'] = 'Dołączający goście muszą zostać wpuszczeni przez moderatora';
$string['mod_form_field_muteonstart'] = 'Wycisz na starcie';
$string['mod_form_field_name'] = 'Nazwa pokoju';
$string['mod_form_field_nosettings'] = 'Żadnych ustawień nie można edytować';
$string['mod_form_field_openingtime'] = 'Otwórz';
$string['mod_form_field_participant_add'] = 'Dodaj uczestnika';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Moderator';
$string['mod_form_field_participant_list'] = 'Lista uczestników';
$string['mod_form_field_participant_list_action_add'] = 'Dodaj';
$string['mod_form_field_participant_list_action_remove'] = 'Usuń';
$string['mod_form_field_participant_list_text_as'] = 'jako';
$string['mod_form_field_participant_list_type_all'] = 'Wszyscy zapisani użytkownicy';
$string['mod_form_field_participant_list_type_owner'] = 'Właściciel';
$string['mod_form_field_participant_list_type_role'] = 'Rola';
$string['mod_form_field_participant_list_type_user'] = 'Użytkownik';
$string['mod_form_field_record'] = 'Sesja może być nagrywana';
$string['mod_form_field_recordallfromstart'] = 'Nagrywaj wszystko od początku';
$string['mod_form_field_recordhidebutton'] = 'Ukryj przycisk nagrywania';
$string['mod_form_field_recordings_deleted'] = 'Dołącz nagrania z usuniętych aktywności';
$string['mod_form_field_recordings_html'] = 'Pokaż tabelę w płaskim formacie HTML';
$string['mod_form_field_recordings_imported'] = 'Pokaż tylko zaimportowane linki';
$string['mod_form_field_recordings_preview'] = 'Pokaż podgląd nagrania';
$string['mod_form_field_room_name'] = 'Nazwa pokoju';
$string['mod_form_field_showpresentation'] = 'Pokaż plik prezentacji na stronie aktywności';
$string['mod_form_field_userlimit'] = 'Limit użytkownika';
$string['mod_form_field_userlimit_help'] = 'Maksymalna dozwolona liczba użytkowników w sesji. Ustaw 0, aby zezwolić na nieograniczoną liczbę użytkowników.';
$string['mod_form_field_voicebridge_format_error'] = 'Błąd formatu. Powinieneś wprowadzić liczbę z zakresu od 1 do 9999.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Nie unikalna wartość. Ten numer jest używany przez inny pokój.';
$string['mod_form_field_wait'] = 'Poczekaj na moderatora';
$string['mod_form_field_wait_help'] = 'Czy uczestnicy muszą czekać na moderatora, zanim będą mogli wejść do pokoju?';
$string['mod_form_field_welcome'] = 'Wiadomość powitalna';
$string['mod_form_field_welcome_default'] = 'Witamy w %%CONFNAME%%.';
$string['mod_form_field_welcome_help'] = 'Wiadomość powitalna jest wyświetlana, gdy uczestnicy wchodzą do pokoju. Jeśli pole pozostanie puste, zostanie wyświetlony domyślny komunikat ustawiony w administracji witryny.';
$string['mod_form_locksettings'] = 'Zablokuj ustawienia';
$string['modulename_help'] = 'BigBlueButtonBN pozwala tworzyć z poziomu Moodle odnośniki do klas on-line w czasie rzeczywistym za pomocą BigBlueButton, internetowego systemu konferencyjnego open source do nauczania na odległość.
Za pomocą BigBlueButtonBN możesz określić tytuł, opis, pozycję kalendarza (która określa zakres dat dołączenia do sesji), grupy i szczegóły dotyczące nagrywania sesji on-line.';
$string['modulename_link'] = 'BigBlueButton/view';
$string['new_bigblubuttonbn_activities'] = 'Aktywność BigBlueButton';
$string['nosuchinstance'] = 'Brak takiej instancji {$a->entity} o identyfikatorze {$a->id}';
$string['notification_instance_created_intro'] = 'Pokój <a href="{$a->link}">{$a->name}</a> BigBlueButton został utworzony.';
$string['notification_instance_created_small'] = 'Utworzono nowy pokój BigBlueButton o nazwie {$a->name}.';
$string['notification_instance_created_subject'] = 'Utworzono nowy pokój BigBlueButton';
$string['notification_instance_description'] = 'Opis';
$string['notification_instance_end_date'] = 'Data zakończenia';
$string['notification_instance_name'] = 'Tytuł';
$string['notification_instance_start_date'] = 'Data rozpoczęcia';
$string['notification_instance_updated_intro'] = 'Pokój BigBlueButton <a href="{$a->link}">{$a->name}</a> został zaktualizowany.';
$string['notification_instance_updated_small'] = 'Sesja BigBlueButton {$a->name} została zaktualizowana.';
$string['notification_instance_updated_subject'] = 'Twój pokój BigBlueButton został zaktualizowany';
$string['notification_recording_ready_html'] = 'Nagranie sesji BigBlueButton jest teraz dostępne w pokoju <a href="{$a->link}">{$a->name}</a>.';
$string['notification_recording_ready_plain'] = 'Nagranie sesji BigBlueButton jest już dostępne w pokoju {$a->name}. Przejdź do {$a->link}, aby uzyskać dostęp do łącza nagrywania.';
$string['notification_recording_ready_small'] = 'Nagranie jest dostępne dla pokoju BigBlueButton {$a->name}.';
$string['notification_recording_ready_subject'] = 'Nagrywanie dostępne';
$string['pluginadministration'] = 'Administracja BigBlueButton';
$string['privacy:metadata:bigbluebuttonbn'] = 'Konfiguracja sesji BigBlueButton';
$string['recordingnotfound'] = 'Nagranie nie zostało znalezione.';
$string['recordings_from_deleted_activities'] = 'Nagrania z usuniętych aktywności';
$string['recordingurlnotfound'] = 'Adres URL nagrania jest nieprawidłowy.';
$string['removedevents'] = 'Wydarzenie usunięte';
$string['removedrecordings'] = 'Usunięte nragrania';
$string['removedtags'] = 'Usunięte tagi';
$string['report_join_info'] = '{$a} spotkanie(a)(ń)';
$string['resetevents'] = 'Usuń wydarzenia';
$string['resetrecordings'] = 'Usuń nagrania';
$string['resetrecordings_help'] = 'Usunięcie nagrań sprawi, że będą one niedostępne z każdego miejsca. Tej czynności nie można cofnąć!';
$string['resettags'] = 'Usuń tagi';
$string['search:activity'] = 'BigBlueButtonBN - informacja o aktywności';
$string['sendnotification'] = 'Wyślij powiadomienie';
$string['settings'] = 'Ustawienia BigBlueButton';
$string['started_at'] = 'Rozpoczęło się';
$string['starts_at'] = 'Rozpoczyna się';
$string['userlimitreached'] = 'Osiągnięto dozwoloną liczbę użytkowników w sesji.';
$string['view_conference_action_end'] = 'Zakończ sesję';
$string['view_conference_action_join'] = 'Dołącz do sesji';
$string['view_error_action_not_completed'] = 'Nie można ukończyć działania';
$string['view_error_current_state_not_found'] = 'Nie znaleziono bieżącego stanu. Nagranie mogło zostać usunięte lub serwer BigBlueButton nie jest kompatybilny z wykonywaną czynnością.';
$string['view_error_import_no_courses'] = 'Brak kursów do wyszukania nagrań.';
$string['view_error_import_no_recordings'] = 'Brak nagrań w tym kursie do importowania';
$string['view_error_invalid_session'] = 'Sesja wygasła. Wróć do strony głównej aktywności.';
$string['view_error_max_concurrent'] = 'Osiągnięto dozwoloną liczbę jednoczesnych spotkań.';
$string['view_error_meeting_not_running'] = 'Coś poszło nie tak, spotkanie nie jest uruchomione.';
$string['view_error_no_group'] = 'Nie skonfigurowano jeszcze grup. Proszę ustawić grupy przed próbą dołączenia do spotkania.';
$string['view_error_no_group_student'] = 'Nie zostałaś/eś zapisany do grupy. Proszę skontaktować się z swoim nauczycielem.';
$string['view_error_no_group_teacher'] = 'Brak zdefiniowanych grup. Musisz je utworzyć.';
$string['view_error_unable_join'] = 'Brak możliwości dołączenia do spotkania. Sprawdź adres url serwera BigBlueButton i sprawdź czy ten serwer działa.';
$string['view_error_unable_join_student'] = 'Nie można połączyć się z serwerem BigBlueButton.';
$string['view_error_unable_join_teacher'] = 'Nie można połączyć się z serwerem BigBlueButton. Skontaktuj się z administratorem.';
$string['view_error_url_missing_parameters'] = 'W tym adresie URL brakuje parametrów';
$string['view_error_userlimit_reached'] = 'Osiągnięto dozwoloną liczbę użytkowników na spotkaniu.';
$string['view_groups_nogroups_warning'] = 'Pokój został skonfigurowany do korzystania z grup, ale w kursie ich nie zdefiniowano.';
$string['view_groups_notenrolled_warning'] = 'Pokój został skonfigurowany do korzystania z grup, ale nie jesteś członkiem grupy.';
$string['view_groups_selection'] = 'Wskaż grupę, do której zamierzasz dołączyć potwierdź swoje działanie.';
$string['view_groups_selection_join'] = 'Dołącz';
$string['view_groups_selection_warning'] = 'Dla każdej grupy jest pokój, a Ty masz dostęp do więcej niż niż jednego pokoju. Pamiętaj, aby wybrać właściwy.';
$string['view_login_moderator'] = 'Logujesz się jako moderator';
$string['view_login_viewer'] = 'Logujesz się jako oglądajacy ....';
$string['view_message_and'] = 'i';
$string['view_message_conference_has_ended'] = 'Ta sesja się zakończyła.';
$string['view_message_conference_in_progress'] = 'Sesja jest w toku.';
$string['view_message_conference_not_started'] = 'Sesja jeszcze się nie rozpoczęła.';
$string['view_message_conference_room_ready'] = 'Ten pokój jest gotowy. Już teraz możesz dołączyć do sesji.';
$string['view_message_conference_user_limit_reached'] = 'Osiągnięto limit liczby użytkowników dozwolonych w sesji.';
$string['view_message_conference_wait_for_moderator'] = 'Oczekiwanie na dołączenie moderatora.';
$string['view_message_cron_disabled'] = 'Lista nagrań może być nieaktualna. Skontaktuj się z administratorem witryny, podając następujące informacje: {$a}';
$string['view_message_finished'] = 'Ta aktywność się skończyła.';
$string['view_message_has_joined'] = 'dołączył';
$string['view_message_have_joined'] = 'dołączył';
$string['view_message_hour'] = 'godzina';
$string['view_message_hours'] = 'godzin';
$string['view_message_importrecordings_disabled'] = 'Importowanie łączy do nagrywania jest wyłączone na serwerze.';
$string['view_message_minute'] = 'minuta';
$string['view_message_minutes'] = 'minut';
$string['view_message_moderator'] = 'Moderator';
$string['view_message_moderators'] = 'Moderatorzy';
$string['view_message_norecordings'] = 'Brak dostępnych nagrań.';
$string['view_message_notavailableyet'] = 'Ta sesja nie jest jeszcze dostępna.';
$string['view_message_recordings_disabled'] = 'Nagrania są wyłączone na serwerze. Aktywności BigBlueButton typu „Tylko nagrania” nie mogą być używane.';
$string['view_message_room_closed'] = 'Ten pokój jest zamknięty.';
$string['view_message_room_open'] = 'Ten pokój jest otwarty.';
$string['view_message_room_ready'] = 'Ten pokój jest gotowy.';
$string['view_message_session_for'] = 'sesja dla';
$string['view_message_session_has_user'] = 'Jest';
$string['view_message_session_has_users'] = 'Są';
$string['view_message_session_no_users'] = 'W tej sesji nie ma użytkowników';
$string['view_message_session_running_for'] = 'Ta sesja jest dla';
$string['view_message_session_started_at'] = 'Sesja rozpoczęła się o';
$string['view_message_tab_close'] = 'Ta karta/okno musi zostać zamknięte ręcznie';
$string['view_message_user'] = 'Użytkownik';
$string['view_message_users'] = 'Użytkownicy';
$string['view_message_viewer'] = 'Widz';
$string['view_message_viewers'] = 'Widzowie';
$string['view_mobile_message_groups_not_supported'] = 'Ta instancja obsługuje grupy, ale aplikacja mobilna jeszcze tego nie obsługuje. Prosimy o korzystanie z wersji internetowej.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Przekroczyłeś 45 sekund na tej stronie. Odśwież stronę, aby dołączyć do sesji.';
$string['view_noguests'] = 'Pokój BigBlueButton nie jest otwarty dla gości';
$string['view_nojoin'] = 'Nie masz roli uprawniającej do dołączenia do  sesji.';
$string['view_recording'] = 'nagranie';
$string['view_recording_actionbar'] = 'Narzędzia';
$string['view_recording_activity'] = 'Aktywność';
$string['view_recording_button_return'] = 'Wróć';
$string['view_recording_course'] = 'Kurs';
$string['view_recording_date'] = 'Data';
$string['view_recording_delete_confirmation'] = 'Czy na pewno chcesz usunąć {$a}?';
$string['view_recording_delete_confirmation_warning_p'] = 'To nagranie ma {$a} linki powiązane, które zostały zaimportowane w różnych kursach lub aktywnościach. Jeśli nagranie zostanie usunięte, te linki również zostaną usunięte';
$string['view_recording_delete_confirmation_warning_s'] = 'To nagranie ma powiązany link {$a}, który został zaimportowany w innym kursie lub aktywności. Jeśli nagranie zostanie usunięte, ten link również zostanie usunięty';
$string['view_recording_description'] = 'Opis';
$string['view_recording_description_edithint'] = 'Można dodać opis ułatwiający identyfikację nagrania.';
$string['view_recording_description_editlabel'] = 'Edytuj opis';
$string['view_recording_duration'] = 'Czas trwania';
$string['view_recording_format_notes'] = 'Notatki';
$string['view_recording_format_presentation'] = 'Prezentacja';
$string['view_recording_format_screenshare'] = 'Udostępnianie ekranu';
$string['view_recording_format_statistics'] = 'Statystyka';
$string['view_recording_format_video'] = 'Wideo';
$string['view_recording_import_confirmation'] = 'Czy na pewno chcesz zaimportować to nagranie?';
$string['view_recording_length'] = 'Długość';
$string['view_recording_link'] = 'zaimportowany link';
$string['view_recording_link_warning'] = 'To jest link wskazujący nagranie utworzone w innym kursie lub aktywności';
$string['view_recording_list_action_delete'] = 'Kasowanie';
$string['view_recording_list_action_edit'] = 'Aktualizacja';
$string['view_recording_list_action_play'] = 'Odtwórz';
$string['view_recording_list_action_process'] = 'Przetwarzanie';
$string['view_recording_list_action_protect'] = 'Chroń';
$string['view_recording_list_action_publish'] = 'Publikowanie';
$string['view_recording_list_action_unprotect'] = 'Nie chroń';
$string['view_recording_list_action_unpublish'] = 'Cofanie publikowania.';
$string['view_recording_list_action_update'] = 'Aktualizowanie';
$string['view_recording_list_actionbar'] = 'Pasek narzędzi';
$string['view_recording_list_actionbar_delete'] = 'Usuń';
$string['view_recording_list_actionbar_edit'] = 'Edytuj';
$string['view_recording_list_actionbar_hide'] = 'Ukryj';
$string['view_recording_list_actionbar_import'] = 'Importowanie';
$string['view_recording_list_actionbar_protect'] = 'Uczyń to prywatnym';
$string['view_recording_list_actionbar_publish'] = 'Publikuj';
$string['view_recording_list_actionbar_show'] = 'Pokaż';
$string['view_recording_list_actionbar_unprotect'] = 'Uczyń to publicznym';
$string['view_recording_list_actionbar_unpublish'] = 'Cofnij publikowanie';
$string['view_recording_list_activity'] = 'Aktywność';
$string['view_recording_list_course'] = 'Kurs';
$string['view_recording_list_date'] = 'Data';
$string['view_recording_list_description'] = 'Opis';
$string['view_recording_list_duration'] = 'Czas';
$string['view_recording_list_recording'] = 'Rejestrowanie';
$string['view_recording_meeting'] = 'Spotkanie';
$string['view_recording_modal_button'] = 'Zastosuj';
$string['view_recording_modal_title'] = 'Ustaw wartości dla nagrywania';
$string['view_recording_name'] = 'Nazwa';
$string['view_recording_name_edithint'] = 'Można dodać nazwę, aby pomóc zidentyfikować nagranie.';
$string['view_recording_name_editlabel'] = 'Edytuj nazwę';
$string['view_recording_playback'] = 'Odtwórz ponownie';
$string['view_recording_preview'] = 'Podgląd';
$string['view_recording_preview_help'] = 'Wskaż kursorem zdjęcie, aby wyświetlić je w pełnym rozmiarze';
$string['view_recording_protect_confirmation'] = 'Czy na pewno chcesz chronić: {$a}?';
$string['view_recording_publish_confirmation'] = 'Czy na pewno chcesz opublikować: {$a}?';
$string['view_recording_recording'] = 'Nagrywanie';
$string['view_recording_select_course'] = 'Najpierw wybierz kurs z menu rozwijanego';
$string['view_recording_tags'] = 'Tagi';
$string['view_recording_unprotect_confirmation'] = 'Czy na pewno chcesz wyłączyć ochronę dla: {$a}?';
$string['view_recording_unpublish_confirmation'] = 'Czy na pewno chcesz cofnąć publikację dla: {$a}?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'To nagranie ma {$a} linki powiązane, które zostały zaimportowane w różnych kursach lub aktywnościach. Jeśli nagranie nie zostanie opublikowane, te linki również nie zostaną opublikowane';
$string['view_recording_unpublish_confirmation_warning_s'] = 'To nagranie ma powiązany link {$a}, który został zaimportowany w innym kursie lub aktywności. Jeśli nagranie nie zostanie opublikowane, link również nie zostanie opublikowany';
$string['view_recording_yui_first'] = 'Pierwszy';
$string['view_recording_yui_go'] = 'Idź';
$string['view_recording_yui_last'] = 'Ostatni';
$string['view_recording_yui_next'] = 'Następny';
$string['view_recording_yui_page'] = 'Strona';
$string['view_recording_yui_prev'] = 'Poprzedni';
$string['view_recording_yui_rows'] = 'Wiersze';
$string['view_recording_yui_show_all'] = 'Pokaż wszystko';
$string['view_room'] = 'Zobacz pokój';
$string['view_section_title_presentation'] = 'Plik prezentacji';
$string['view_section_title_recordings'] = 'Nagrania';
$string['waitformoderator'] = 'Poczekaj, aż dołączy moderator.';
