<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'question', language 'no', version '5.0'.
 *
 * @package     question
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Handling';
$string['addanotherhint'] = 'Legg til et hint til';
$string['addcategory'] = 'Legg til kategori';
$string['addmorechoiceblanks'] = 'Sett inn {no} ekstra svaralternativer';
$string['adminreport'] = 'Rapport over mulige problemer i din spørsmålsdatabase.';
$string['advancedsearchoptions'] = 'Søkevalg';
$string['alltries'] = 'Alle forsøk';
$string['alwayslatest'] = 'Alltid siste';
$string['answer'] = 'Svar';
$string['answers'] = 'Svar';
$string['answersaved'] = 'Svar lagret';
$string['answerx'] = 'Svar {$a}';
$string['attemptfinished'] = 'Forsøk avsluttet';
$string['attemptfinishedsubmitting'] = 'Forsøket er fullført: {$a}';
$string['attemptoptions'] = 'Forsøksinnstillinger';
$string['availableq'] = 'Tilgjengelig?';
$string['badbase'] = 'Feil base før **: {$a}**';
$string['banksincourse'] = 'Spørsmålsbank i dette kurset';
$string['behaviour'] = 'Atferd';
$string['behaviourbeingused'] = 'Atferd i bruk: {$a}';
$string['broken'] = 'Dette er en råtten lenke, filen den peker til finnes ikke.';
$string['byandon'] = 'av <em>{$a->user}</em> på <em>{$a->time}</em>';
$string['cannotcopybackup'] = 'Kunne ikke kopiere sikkerhetskopifilen';
$string['cannotcreate'] = 'Kunne ikke opprette en ny oppføring i question_attempts tabellen.';
$string['cannotcreatepath'] = 'Kan ikke opprette stien: {$a}';
$string['cannotdeletebehaviourinuse'] = 'Du kan ikke slette atferden \'{$a}\'. Den brukes av andre spørsmålsforsøk.';
$string['cannotdeletecate'] = 'Du kan ikke slette denne kategorien siden den er standard kategori for denne konteksten.';
$string['cannotdeleteneededbehaviour'] = 'Kan ikke slette spørsmålsatferden \'{$a}\'. Andre installerte atferder er avhengig av den.';
$string['cannotdeleteqtypeinuse'] = 'Du kan ikke slette spørsmålstypen \'{$a}\'. Det finnes spørsmåll av denne typen i testbanken.';
$string['cannotdeleteqtypeneeded'] = 'Du kan ikke slette spørsmålstypen \'{$a}\'. Det er andre installerte spørsmålstyper som er relatert til denne.';
$string['cannotdeletetopcat'] = 'Toppkategorier kan ikke slettes';
$string['cannotedittopcat'] = 'Toppkategorier kan ikke redigeres';
$string['cannotenable'] = 'Spørsmålstypen {$a} kan ikke opprettes direkte.';
$string['cannotenablebehaviour'] = 'Spørsmålsatferden {$a} kan ikke brukes direkte. Den er kun for internt bruk.';
$string['cannotfindcate'] = 'Kan ikke finne oppføring for kategorien';
$string['cannotfindquestionfile'] = 'Kan ikke finne spørsmålsdata i zip-filen.';
$string['cannotgetdsfordependent'] = 'Kan ikke hente det angitte datasettet til det datasett-avhengige spørsmålet! spørsmål: {$a[0]}, datasett-element: {a[1]})';
$string['cannotgetdsforquestion'] = 'Kan ikke hente det angitte datasettet for et beregnet spørsmål!  (spørsmål: {$a})';
$string['cannothidequestion'] = 'Var ikke i stand til å skjule spørsmålet';
$string['cannotimportformat'] = 'Beklager, men import av dette formatet er ikke implementert ennå!';
$string['cannotinsertquestion'] = 'Kunne ikke legge til nytt spørsmål!';
$string['cannotinsertquestioncatecontext'] = 'Kunne ikke legge til den nye spørsmålskategorien {$a->cat} ugyldig kontekst ID {$a->ctx}';
$string['cannotloadquestion'] = 'Kunne ikke laste spørsmålet';
$string['cannotmovequestion'] = 'Du kan ikke bruke dette skriptet til å flytte spørsmål når det har tilknyttet filer fra forskjellige områder.';
$string['cannotopenforwriting'] = 'Kan ikke åpne {$a} for redigering.';
$string['cannotpreview'] = 'Du kan ikke forhåndsvise disse spørsmålene!';
$string['cannotread'] = 'Kan ikke lese importert fil (eller filen er tom)';
$string['cannotregradedifferentqtype'] = 'Kan ikke omgradere med et spørsmål av en annen type.';
$string['cannotretrieveqcat'] = 'Kunne ikke hente spørsmålskategorien';
$string['cannotunhidequestion'] = 'Mislykkes i å vise det skjulte spørsmålet';
$string['cannotunzip'] = 'Kunne ikke pakke ut zipfilen.';
$string['cannotwriteto'] = 'Kan ikke eksportere spørsmålene til {$a}';
$string['categories'] = 'Kategorier';
$string['category'] = 'Kategori';
$string['categorycurrent'] = 'Gjeldende kategori';
$string['categorycurrentuse'] = 'Bruk denne kategorien';
$string['categorydoesnotexist'] = 'Kategorien finne ikke';
$string['categoryinfo'] = 'Kategori-informasjon';
$string['categorymove'] = 'Kategorien \'{$a->name}\' har {$a->count} spørsmål, noen av spørsmålene kan være skjult eller brukt som tilfeldige spørsmål i en quiz som fortsatt er aktiv.  Vennligst velg en annen kategori å flytte dem til.';
$string['categorymoveto'] = 'Lagre i kategori';
$string['categorynamecantbeblank'] = 'Feltet for kategorinavn kan ikke stå tomt';
$string['categorynamewithcount'] = '{$a->name} ({$a->questioncount})';
$string['categorynamewithidnumber'] = '{$a->name} [{$a->idnumber}]';
$string['categorynamewithidnumberandcount'] = '{$a->name} [{$a->idnumber}] ({$a->questioncount})';
$string['changeoptions'] = 'Endre valg';
$string['changepublishstatuscat'] = '<a href="{$a->caturl}">Kategori "{$a->name}"</a> i kurset "{$a->coursename}" will få status endret fra  <strong>{$a->changefrom} til {$a->changeto}</strong>.';
$string['check'] = 'Sjekk';
$string['chooseqtypetoadd'] = 'Velg en spørsmålstype å legge til';
$string['clearwrongparts'] = 'Fjern uriktige svar';
$string['clickflag'] = 'Marker spørsmål';
$string['clicktoflag'] = 'Klikk for å markere dette spørsmålet for å kunne gå tilbake til det senere.';
$string['clicktounflag'] = 'Fjern markering';
$string['clickunflag'] = 'Fjern markering';
$string['closepreview'] = 'Lukk forhåndsvisning';
$string['combinedfeedback'] = 'Kombinert tilbakemelding';
$string['comment'] = 'Kommentér';
$string['commented'] = 'Kommentert: {$a}';
$string['commentormark'] = 'Kommentér eller overstyr karakter';
$string['comments'] = 'Kommentarer';
$string['commentx'] = 'Kommentar: {$a}';
$string['complete'] = 'Fullført';
$string['contexterror'] = 'Du skulle ikke gått hit hvis du ikke flytter en kategori eller annen kontekst.';
$string['copy'] = 'Kopier fra {$a} og endre lenkene.';
$string['correct'] = 'Riktig';
$string['correctfeedback'] = 'For alle riktige svar';
$string['correctfeedbackdefault'] = 'Svaret ditt er riktig.';
$string['courserestore'] = 'Kurs gjenoppretting';
$string['created'] = 'Opprettet';
$string['createdby'] = 'Laget av';
$string['createdefault'] = 'Opprett standard spørsmålsbank';
$string['createdmodifiedheader'] = 'Opprettet / Sist lagret';
$string['createnewquestion'] = 'Lag et nytt spørsmål...';
$string['cwrqpfs'] = 'Tilfeldige spørsmål som velges fra underkategorier.';
$string['cwrqpfsinfo'] = '<p>Ved oppgradering til Moodle 1.9 vil vi dele spørsmålskategoriene i flere kontekster. Noen spørsmålskategorier og spørsmål på portalen din vil kanskje få endret delingsstatus. Dette er nødvendig i de sjeldne tilfeller hvor ett eller flere tilfeldige spørsmål i en quiz er satt opp til å trekkes fra en miks av delte og private kategorier (som er tilfelle her). Dette skjer når et tilfeldig spørsmål er satt til å hentes fra underkategorier med både delt og privat status.</p>
<p>De følgende kategoriene vil få status endret til det samme som overordnet kategori. Dette innvirker ikke på eksisterende quizer før de evt. opprettes på nytt.</p>';
$string['cwrqpfsnoprob'] = 'Ingen spørsmålskategorier på din site berøres av oppgraderingen.';
$string['decimalplacesingrades'] = 'Antall desimaler i karakterer';
$string['defaultbank'] = '{$a->coursename} kurs spørsmålsbank';
$string['defaultcreated'] = 'Standard spørsmålsbank opprettet.';
$string['defaultfor'] = 'Standard for {$a}';
$string['defaultinfofor'] = 'Standard kategori for spørsmål delt i konteksten \'{$a}\'.';
$string['defaultmark'] = 'Standard karakter';
$string['defaultmarkmustbepositive'] = 'Standard karakter må være en positiv verdi';
$string['deletecoursecategorywithquestions'] = 'Det finnes spørsmål i spørsmålsbanken koblet til denne kurskategorien. Hvis du fortsetter vil disse bli slettet. Hvis du ønsker å flytte dem først, vær vennlig å bruk spørsmålsbankbildet.';
$string['deletequestioncheck'] = 'Dette vil slette følgende spørsmål og alle dets versjoner:<br /><br />{$a}';
$string['deletequestionscheck'] = 'Dette vil slette følgende spørsmål og alle deres versjoner:<br /><br />{$a}';
$string['deletequestiontitle'] = 'Slett spørsmål?';
$string['deletequestiontitle_plural'] = 'Slette spørsmål?';
$string['deleteselectedquestioncheck'] = 'Dette vil slette valgte versjoner av følgende spørsmål:<br /><br />{$a}';
$string['deleteversiontitle'] = 'Slette valgte versjon?';
$string['deleteversiontitle_plural'] = 'Slette valgte versjoner?';
$string['deletingbehaviour'] = 'Sletter spørsmålsatferden \'{$a}\'';
$string['deletingqtype'] = 'Sletter spørsmålstypen \'{$a}\'';
$string['didnotmatchanyanswer'] = '[Stemte ikke med noen svar]';
$string['disabled'] = 'Deaktivert';
$string['disabledbanks'] = 'Alle spørsmålsbank modultyper aktivert';
$string['displayoptions'] = 'Visningsinnstillinger';
$string['disterror'] = 'Distribusjonen {$a} lagde problemer.';
$string['donothing'] = 'Ikke kopier eller flytt filer eller endre lenker.';
$string['editcategories'] = 'Endre kategorier';
$string['editcategories_help'] = 'I stedet for å ha alle spørsmålene i en lang liste, kan du opprette kategorier og underkategorier å ordne dem i.

Kategorier blir også brukt for tilfeldig trekking av spørsmål når spørsmål velges fra utvalgte kategorier.';
$string['editcategories_link'] = 'question/category';
$string['editcategory'] = 'Rediger kategori.';
$string['editingcategory'] = 'Rediger en kategori';
$string['editingquestion'] = 'Rediger et spørsmål';
$string['editquestion'] = 'Rediger spørsmål';
$string['editquestions'] = 'Rediger spørsmål';
$string['editthiscategory'] = 'Endre denne kategorien';
$string['emptyxml'] = 'Ukjent feil - tom imsmanifest.xml';
$string['enabled'] = 'Aktivert';
$string['erroraccessingcontext'] = 'Får ikke tilgang til konteksten';
$string['errordeletingquestionsfromcategory'] = 'Feil ved sletting av spørsmål fra kategorien {$a}';
$string['errorduringpost'] = 'Det oppstod en feil under post-prosesseringen!';
$string['errorduringpre'] = 'Det oppstod en feil under pre-prosesseringen!';
$string['errorduringproc'] = 'Det oppstod en feil under prosesseringen!';
$string['errorduringregrade'] = 'Kunne ikke revurdere spørsmålet  {$a->qid}, går til status {$a->stateid}.';
$string['errorfilecannotbecopied'] = 'Feil - kan ikke kopiere filen {$a}.';
$string['errorfilecannotbemoved'] = 'Feil - kan ikke flytte filen {$a}.';
$string['errorfileschanged'] = 'Feil -  filer det er lenket til fra spørsmål er endret etter skjemaet ble vist.';
$string['erroritemappearsmorethanoncewithdifferentweight'] = 'Spørsmålet ({$a}) forekommer mer enn en gang med forskjellig vekting i forskjellige steder i testen. Dette er ikke støttet av den statistiske analysen og vil gjøre statistikkresultatene for dette spørsmålet lite pålitelige.';
$string['errormanualgradeoutofrange'] = 'Karakteren {$a->grade} er ikke mellom 0 og {$a->maxgrade} for spørsmålet {$a->name}. Poeng og kommentar er ikke blitt lagret.';
$string['errormovingquestions'] = 'Feil ved flytting av spørsmål med id\'er {$a}.';
$string['errorpostprocess'] = 'Det oppstod en feil under postprosesseringen!';
$string['errorpreprocess'] = 'Det oppstod en feil under pre-prosesseringen!';
$string['errorprocess'] = 'Det oppstod en feil under prosesseringen!';
$string['errorprocessingresponses'] = 'Det oppstod en feil under behandlingen av dine svar ({$a}). Klikk fortsett for å gå tilbake til siden du var på og prøv igjen.';
$string['errorsavingcomment'] = 'Feil ved lagring av kommentarer for spørsmål {$a->name} i databasen.';
$string['errorsavingflags'] = 'Det oppsto en feil under lagringen av markerte spørsmål';
$string['errorupdatingattempt'] = 'Feil ved oppdatering av forsøk {$a->id} i databasen.';
$string['eventqbankdisabled'] = 'Spørsmålsbank-plugin deaktivert';
$string['eventqbankenabled'] = 'Spørsmålsbank-plugin aktivert';
$string['eventquestioncategorycreated'] = 'Spørsmålskategori opprettet';
$string['eventquestioncategorydeleted'] = 'Spørsmålskategori slettet';
$string['eventquestioncategorymoved'] = 'Spørsmålskategori flyttet';
$string['eventquestioncategoryupdated'] = 'Spørsmålskategori oppdatert';
$string['eventquestioncategoryviewed'] = 'Spørsmålskategori vist';
$string['eventquestioncreated'] = 'Spørsmål opprettet';
$string['eventquestiondeleted'] = 'Spørsmål slettet';
$string['eventquestionmoved'] = 'Spørsmål flyttet';
$string['eventquestionsexported'] = 'Spørsmål eksportert';
$string['eventquestionsimported'] = 'Spørsmål importert';
$string['eventquestionupdated'] = 'Spørsmål oppdatert';
$string['eventquestionviewed'] = 'Spørsmål vist';
$string['export'] = 'Eksport';
$string['exportasxml'] = 'Eksporter som Moodle XML';
$string['exportcategory'] = 'Eksportkategori';
$string['exportcategory_help'] = '<p align="center"><b>Eksportere kategorien</b></p>

<p><b>Kategorien:</b> Listeboksmeny som brukes til å velge kategori som eksporten skal kjøres fra.</p>

<p>Noen importformater, som GIFT og XML-formatet, tillater at kategorien blir tatt med i fila og gjør dermed at kategorien kan gjenopprettes ved import. For at disse dataene skal tas med må du merke av for <b>Skriv kategorien til fil</b>. Dersom dette er gjort kan du også merke av for at konteksten skal skrives til filen. Ikke merk av for disse valgene om du skal bruke fila til import på eldre Moodle-versjoner.</p>';
$string['exporterror'] = 'Det oppstod en feil under eksport!';
$string['exportfilename'] = 'spørsmål';
$string['exportnameformat'] = '%Y%m%d-%H%M';
$string['exportonequestion'] = 'Last ned dette spørsmålet i Moodle XML format';
$string['exportquestions'] = 'Eksporter spørsmål til en fil';
$string['exportquestions_help'] = '<p>Denne funksjonen lar det eksportere en komplett kategori (med underkategorier) med spørsmål til en tekstfil.</p>

<p>Vennligst merk deg at mange filformater kan miste noe informasjon når spørsmål blir eksportert.  Dette er fordi mange formater ikke utnytter alle funksjonene som finnes i Moodle-spørsmål. Du bør derfor ikke forvente at eksport og import av spørsmål gir deg et resultat som er identisk med startpunktet. Du bør derfor ALLTID sjekke eksporterte data før du bruker dem i et produksjonsmiljø.</p>

<p>De formatene som støttes nå er:</p>

<h2>GIFT formatet</h2>

<p>GIFT er det mest avanserte tilgjengelige formatet for import/eksport av Moodle spørsmål til en tekstfil. Det ble opprinnelig laget for å tilby en enkel metode for lærere til å skrive spørsmål som en tekstfil og deretter importere den. GIFT støtter flersvar, sant/usant, kortsvar, sammenfallende og numeriske spørsmål og kan også sette inn ______________ for manglende ord-formatet. Merk at Cloze-spørsmål forelløpig ikke støttes. Forskjellige spørsmålstyper kan blandes i samme tekstfil for formatet støtter linjekommentarer, spørsmålsnavn, tiølbakemeldingstekst og prosentvektede karakterer.   Under finner du noen eksempler:</p>

<pre>
Who\'s buried in Grant\'s tomb?{~Grant ~Jefferson =no one}

Grant is {~buried =entombed ~living} in Grant\'s tomb.

Grant is buried in Grant\'s tomb.{FALSE}

Who\'s buried in Grant\'s tomb?{=no one =nobody}

When was Ulysses S. Grant born?{#1822}
</pre>

<p class="moreinfo"><a href="help.php?file=formatgift.html&amp;module=quiz">Mer om "GIFT" formatet</a></p>

<h2>Moodle XML formatet</h2>

<p>Dette er et Moodle-spesifikt format som eksporterer spørsmål via et enkelt XML-format. Filen kan enten importeres til en annen kategori eller brukes som en del av en XLST-overføring. XML-formatet vil eksportere bildevedlegg til spørsmål via kodesettet base64.</p>

<h2>IMS QTI 2.0</h2>

<p>Eksporterer i standard format for IMS QTI (version 2.0). Merk at dette genererer en rekke filer i en zip-fil.</p>
<p class="moreinfo"><a href="http://www.imsglobal.org/question/" target="_qti">Mer informasjon på IMS QTI-webstedet</a>
 (external site in new window)</p>

<h2>XHTML</h2>

<p>Eksporterer kategorien som en enkelt side via XHTML. Hvert spørsmål blir ordnet med sin egen "div" tagg. Dersom du vil bruke denne siden som den er, må du i det minste redigere "form" taggen i toppen av "body" seksjonen for å legge til en relevant handling for skjemaet, f.eks. "mailto".</p>

<p>Import and Export formatene er ressurser som er lagt til som selvstendige moduler. Andre formater kan være tilgjengelige i moodle.org-databasen over moduler og tilleggsressurser.</p>';
$string['exportquestions_link'] = 'question/export';
$string['feedback'] = 'Tilbakemelding';
$string['fieldinquestion'] = '{$a->fieldname} {$a->questionindentifier}';
$string['fieldinquestionpre'] = '{$a->questionindentifier} {$a->fieldname}';
$string['filecantmovefrom'] = 'Spørsmålsfilene kan ikke flyttes siden du ikke har tillatelse til å lagre der du forsøker å flytte filene til.';
$string['filecantmoveto'] = 'Spørsmålsfilene kan ikke flyttes eller kopieres siden du ikke har tillatelse til å lagre der du forsøker å flytte/kopiere filene til.';
$string['fileformat'] = 'Filformat';
$string['filesareacourse'] = 'Kursets filområde';
$string['filesareasite'] = 'Portalens filområde';
$string['filestomove'] = 'Flytt / kopier filer til {$a}?';
$string['fillincorrect'] = 'Fyll inn riktige svar';
$string['filterbytags'] = 'Filtrer med tagger';
$string['firsttry'] = 'Første forsøk';
$string['flagged'] = 'Markert';
$string['flagthisquestion'] = 'Marker dette spørsmålet';
$string['formquestionnotinids'] = 'Skjemaet inneholder spørsmål som ikke er i spørsmåls ID-ene';
$string['fractionsnomax'] = 'Et av svarene bør ha en score på 100% slik at det er mulig å få toppkarakter for spørsmålet.';
$string['generalfeedback'] = 'Generell tilbakemelding';
$string['generalfeedback_help'] = 'Generell tilbakemelding vises til studenten etter de har fullført spørsmålet. I motsetning til spesifikke tilbakemeldinger, som avhenger av spørsmålstypen og hvilket svar studenten ga, vises den samme generelle tilbakemeldingen til alle studenter.

Du kan bruke den generelle tilbakemeldingen til å gi studenter et fullstendig utarbeidet svar og kanskje en lenke til mer informasjon. Dette kan være nyttig hvis de ikke forstod spørsmålet.';
$string['getcategoryfromfile'] = 'Ta med kategorier fra fil';
$string['getcontextfromfile'] = 'Ta med kontekst fra fil';
$string['hintn'] = 'Hint {no}';
$string['hintnoptions'] = 'Hint {no} valg';
$string['hinttext'] = 'Tekst til hint';
$string['howquestionsbehave'] = 'Hvordan spørsmål oppfører seg';
$string['howquestionsbehave_help'] = 'Studenter kan være interaktive på forskjellige måter i spørsmål i quiz. Det kan for eksempel hende at du ønsker at studentene skal skrive et svar til hvert spørsmål og så sende inn hele quizen før de har fått noen karakterer eller tilbakemeldinger. Denne modusen kalles \'Utsatt tilbakemelding\'.

En annen mulighet er hvis du ønsker at studentene skal sende inn hvert spørsmål etter hvert som de besvarer dem, slik at de kan få tilbakemelding med en gang. Hvis de ikke får riktig på første forsøk, kan de prøve igjen (men få lavere skår). Denne modusen kalles \'Interaktiv med flere forsøk\'.

Disse to modiene er antakeligvis de to mest vanlige.';
$string['howquestionsbehave_link'] = 'question/behaviour';
$string['idnumber'] = 'IDnummer';
$string['idnumber_help'] = 'Dersom brukt må IDnummeret være unikt innenfor hver spørsmålskategori. Det skaper en enkel måte å identifisere spørsmål på, men kan også være tomt.';
$string['ignorebroken'] = 'Ignorer råtne lenker';
$string['import'] = 'Import';
$string['importcategory'] = 'Importer kategori';
$string['importcategory_help'] = '<p><b>Kategori:</b> listeboksen brukes til å velge kategorien de importerte spørsmålene skal plasseres i.</p>

<p>Noen importformater  (GIFT og XML format) tillater at kategorinavn blir angitt i importfila. Dersom denne informasjonen skal tas hensyn til må boksen for  <b>Hent kategorier fra fil</b> være merket av. Hvis ikke vil importerte spørsmål havne i gjeldende kategori uavhengig av instruksjonene i importfila. Deaktiver <b>Hent kontekst fra fil</b> for å tvinge at standard kontekst skal gjelde.</p>

<p>Når kategorier er angitt i en importfil vil de opprettes hvis de ikke finnes fra før.</p>';
$string['importerror'] = 'Det oppstod en feil under behandlingen av importen.';
$string['importerrorquestion'] = 'Det oppstod en feil under import av spørsmålet';
$string['importfromcoursefiles'] = '... eller velg en kursfil for import.';
$string['importfromupload'] = 'Velg en fil å laste opp...';
$string['importingquestions'] = 'Importerer {$a} spørsmål fra fil';
$string['importparseerror'] = 'Fant feil ved gjennomgang av importfila. Ingen spørsmål er importert. For å fullføre importen av spørsmål kan du prøve å endre innstillingen for "Stopp ved feil" til "Nei".';
$string['importquestions'] = 'Importer spørsmål fra en fil';
$string['importquestions_help'] = 'Denne funksjonen aktiverer at spørsmål i forskjellige formater kan importeres via en tekstfil. Merk at filen må bruke UTF-8 tegnsett.';
$string['importquestions_link'] = 'question/import';
$string['importwrongfileencoding'] = 'Filen du valgte bruker ikke UTF-8-tegnkoding. {$a} filer må bruke UTF-8.';
$string['importwrongfiletype'] = 'Den filtypen du valgte ({$a->actualtype}) samsvarer ikke med forventet filtype for dette importformatet ({$a->expectedtype}).';
$string['impossiblechar'] = 'Umulig tegn {$a} oppdaget som parentestegn';
$string['includesubcategories'] = 'Vis også spørsmål fra underkategorier';
$string['incorrect'] = 'Feil';
$string['incorrectfeedback'] = 'Ved alle feil svar';
$string['incorrectfeedbackdefault'] = 'Svaret ditt er feil';
$string['information'] = 'Informasjon';
$string['invalidanswer'] = 'Ufullstendig svar';
$string['invalidarg'] = 'Ingen gyldige argumenter levert eller feil i serverkonfigurasjonen';
$string['invalidcategoryidforparent'] = 'Ugyldig ID for overordnet kategori!';
$string['invalidcategoryidtomove'] = 'Ugyldig kategori ID for flytting!';
$string['invalidconfirm'] = 'Bekreftelsesstrengen var ugyldig';
$string['invalidcontextinhasanyquestions'] = 'Feil kontekst sendt til question_context_has_any_questions.';
$string['invalidgrade'] = 'Karakterene ({$a}) samsvarer ikke med vurderingsmulighetene - spørsmålet er utelatt.';
$string['invalidgradequestion'] = 'Karakter ({$a->grades}) stemmer ikke overens med karaktervalg. Spørsmål \'{$a->question}\' hoppes over.';
$string['invalidpenalty'] = 'Ugyldig poengtrekk';
$string['invalidquestiontype'] = 'Ugyldig spørsmålstype';
$string['invalidwizardpage'] = 'Ugyldig eller ingen oppsettside angitt!';
$string['lastmodifiedby'] = 'Sist endret av';
$string['lasttry'] = 'Siste forsøk';
$string['linkedfiledoesntexist'] = 'Den lenkede filen {$a} eksisterer ikke';
$string['makechildof'] = 'Lag et underpunkt til \'{$a}\'';
$string['makecopy'] = 'Lag en kopi';
$string['maketoplevelitem'] = 'Gå til toppnivå';
$string['manualgradeinvalidformat'] = 'Det er ikke et gyldig tall.';
$string['manualgradeoutofrange'] = 'Denne karakteren er utenfor gyldig skala.';
$string['manuallygraded'] = 'Manuelt vurdert  {$a->mark} med kommentaren: {$a->comment}';
$string['mark'] = 'Karakter';
$string['markedoutof'] = 'Karakter av maks';
$string['markedoutofmax'] = 'Karakter av maks {$a}';
$string['markoutofmax'] = 'Karakter {$a->mark} av en makskarakter på {$a->max}.';
$string['marks'] = 'Karakterer';
$string['matchgrades'] = 'Koble vurderinger';
$string['matchgrades_help'] = '<p>Importerte karakterer <b>må</b> samsvare med følgende gyldige liste over mulige karakterer:</p>

<ul>
  <li>100%</li>
  <li>90%</li>
  <li>80%</li>
  <li>75%</li>
  <li>70%</li>
  <li>66.666%</li>
  <li>60%</li>
  <li>50%</li>
  <li>40%</li>
  <li>33.333</li>
  <li>30%</li>
  <li>25%</li>
  <li>20%</li>
  <li>16.666%</li>
  <li>14.2857</li>
  <li>12.5%</li>
  <li>11.111%</li>
  <li>10%</li>
  <li>5%</li>
  <li>0%</li>
</ul>

<p>Negative verdier av listen over godtas også.</p>

<p>Det er to alternativer for dette valget. De påvirker hvordan importrutinen behandler verdier som ikke samsvarer <strong>eksakt</strong> med en av verdien i listen over.</p>

<ul>
  <li><strong>Feilmelding dersom karakteren ikke finnes på godkjentlista</strong><br />
Dersom et spørsmål inneholder karakterer som ikke finnes i lista vises en feilmelding og spørsmålet blir ikke importert.</li>
  <li><strong>Nærmeste karakter dersom den ikke finnes på godkjentlista.</strong><br />
Hvis en karakter ikke har eksakt samme verdi som en på godkjentlista vil karakteren endres til den som ligger nærmest.</li>
</ul>

<p><i>Merk: noen spesialskrevne importformater skriver rett til databasen og kan derfor gå utenfor denne sjekken.</i></p>';
$string['matchgradeserror'] = 'Feil hvis karakteren ikke vises';
$string['matchgradesnearest'] = 'Nærmeste karakter hvis ikke vist';
$string['missingcourseorcmid'] = 'Du må oppgi courseid eller cmid til print_question.';
$string['missingcourseorcmidtolink'] = 'Du må oppgi  courseid eller cmid til get_question_edit_link.';
$string['missingimportantcode'] = 'Spørsmålstypen mangler en viktig kode: {$a}.';
$string['missingoption'] = 'Cloze-spørsmålet {$a} mangler nødvendige innstillinger';
$string['modified'] = 'Sist lagret';
$string['move'] = 'Flytt fra {$a} og endre lenkene';
$string['movecategory'] = 'Flytt kategori';
$string['movedquestionsandcategories'] = 'Flyttet spørsmål og spørsmålskategorier fra {$a->oldplace} til {$a->newplace}.';
$string['movelinksonly'] = 'Bare endre lenkereferanser, ikke flytt eller kopier filer.';
$string['moveq'] = 'Flytt spørsmål';
$string['moveqtoanothercontext'] = 'Flytt spørsmål til en annen kontekst.';
$string['moveto'] = 'Flytt til';
$string['movingcategory'] = 'Flytter kategori';
$string['movingcategoryandfiles'] = 'Er du sikker på at du vil flytte kategorien {$a->name} og alle underkategorier for "{$a->contextto}"?<br /> Vi har oppdaget {$a->urlcount} filer som er lenket fra {$a->fromareaname}, ønsker du å kopiere eller flytte disse til  {$a->toareaname}?';
$string['movingcategorynofiles'] = 'Er du sikker på at du vil flytte kategorien "{$a->name}" og alle underkategorier for "{$a->contextto}"?';
$string['movingquestions'] = 'Flytter spørsmål og filer';
$string['movingquestionsandfiles'] = 'Er du sikker på at du vil flytte spørsmålene {$a->questions} til konteksten for <strong>"{$a->tocontext}"</strong>?<br /> Vi har oppdaget <strong>{$a->urlcount} filer</strong> lenket fra disse spørsmålene i {$a->fromareaname}, ønsker du å kopiere eller flytte disse til {$a->toareaname}?';
$string['movingquestionsnofiles'] = 'Er du sikker på at du vil flytte spørsmålene {$a->questions} til konteksten for <strong>"{$a->tocontext}"</strong>?<br /> Vi ikke oppdaget <strong>noen filer</strong> lenket fra disse spørsmålene i {$a->fromareaname}.';
$string['needtochoosecat'] = 'Du må velge en kategori å flytte spørsmålene til eller klikke \'Avbryt\'.';
$string['nobanks'] = 'Dette kurset har ingen spørsmålsbanker ennå.';
$string['nocate'] = 'Ingen slik kategori {$a}!';
$string['noconditionspecified'] = 'Vennligst angi en betingelse';
$string['nopermissionadd'] = 'Du har ikke tillatelse til å legge til spørsmål her.';
$string['nopermissionedit'] = 'Du har ikke tillatelse til å redigere spørsmål her.';
$string['noprobs'] = 'Fant ingen problemer i spørsmålsdatabasen.';
$string['noquestionbanks'] = 'Fant ingen modul for spørsmålsbank.';
$string['noquestions'] = 'Ingen spørsmål kunne eksporteres. Sjekk at har valgt en kategori som inneholder spørsmål.';
$string['noquestionsinfile'] = 'Det er ingen spørsmål i importfilen';
$string['noresponse'] = '[Ingen respons]';
$string['notagfiltersapplied'] = 'Ingen taggefiltere i bruk';
$string['notanswered'] = 'Ikke besvart';
$string['notchanged'] = 'Ingenting endret siden forrige forsøk';
$string['notenoughanswers'] = 'Denne spørsmålstypen krever minst {$a} svaralternativer';
$string['notenoughdatatoeditaquestion'] = 'Hverken spørsmålsid, eller kategori-id og spørsmålstype eller blitt angitt.';
$string['notenoughdatatomovequestions'] = 'Du må ta med spørsmålsID på spørsmål du ønsker å flytte.';
$string['notgraded'] = 'Ikke fått karakter';
$string['notshown'] = 'Ikke vist';
$string['notyetanswered'] = 'Ikke besvart ennå';
$string['notyourpreview'] = 'Denne forhåndsvisningen tilhører ikke deg';
$string['novirtualquestiontype'] = 'Ingen virtuell spørsmålstype for spørsmålstypen {$a}';
$string['numqas'] = 'Antall forsøk på spørsmål';
$string['numquestions'] = 'Ingen spørsmål';
$string['numquestionsandhidden'] = '{$a->numquestions} (+{$a->numhidden} skjult +{$a->numdraft} utkast)';
$string['options'] = 'Alternativer';
$string['otherbanks'] = 'Andre aktiviteter med spørsmål';
$string['otherbanksdesc'] = 'Spørsmål i disse aktivitenes spørsmålsbanker kan ikke brukes andre steder';
$string['otherquestionbank'] = 'Alle spørsmålsbanker';
$string['otherquestionbankstoomany'] = 'Mer enn {$a} resultater, vennligst søk på nytt';
$string['page-question-category'] = 'Spørsmålskategoriside';
$string['page-question-edit'] = 'Spørsmålsredigeringsside';
$string['page-question-export'] = 'Spørsmålseksportside';
$string['page-question-import'] = 'Spørsmålsimportside';
$string['page-question-x'] = 'Alle spørsmålssider';
$string['parent'] = 'Overordnet';
$string['parentcategory'] = 'Overordnet kategori';
$string['parentcategory_help'] = '<h2>Overordnet nivå</h2>

<p>Kategorien hvor denne blir plassert. "Topp" betyr at denne kategorien er øverst i hierarkiet.</p>

<p>Vanligvis vil du se mange kategorikontekster (de er merket med uthevet skrift), merk at hver kontekst kan ha sitt eget hierarki av kategorier. Du finner mer informasjon under. Dersom du ikke ser flere kontekster kan det være fordi du ikke har fått rettigheten til andre kategorier.</p>

<p>Dersom det er bare en kategori i en kontekst kan du ikke flytte kategorien - siden det må være minst EN kategori i hver kontekst.</p>

<p>Se også :</p>
<ul>
  <li><a href="help.php?module=question&amp;file=categories.html">Spørsmålskategorier</a></li>
  <li><a href="help.php?module=question&amp;file=categorycontexts.html">Kategorikontekster</a></li>
  <li><a href="help.php?module=question&amp;file=permissions.html">Spørsmålstillatelser</a></li>
</ul>';
$string['parentcategory_link'] = 'question/category';
$string['parenthesisinproperclose'] = 'Parenteser før ** er ikke korrekt avsluttet i {$a}**';
$string['parenthesisinproperstart'] = 'Parenteser før ** er ikke korrekt påbegynt i {$a}**';
$string['parsingquestions'] = 'Gjennomgår spørsmål fra importfila.';
$string['partiallycorrect'] = 'Delvis korrekt';
$string['partiallycorrectfeedback'] = 'For alle delvis korrekte svar';
$string['partiallycorrectfeedbackdefault'] = 'Svaret ditt er delvis korrekt.';
$string['penaltyfactor'] = 'Poengtrekkfaktor';
$string['penaltyfactor_help'] = '<p>Du kan angi hvor mye som skal trekkes fra spørsmålets poengsum hver gang det svares galt. Dette er bare relevant når quizen kjøres i \'Sjekk svar modus\' og studenten har flere forsøk på spørsmålet. Straffefaktoren bør være et tall mellom 0 pg 1. En straffefaktor på 1 betyr at de bare får poeng hvis de svarer rett første gangen. En straffefaktor på 0 betyr at de kan forsøke så mange ganger de vil uten å få reduksjon i poengsummen.</p>';
$string['penaltyforeachincorrecttry'] = 'Poengtrekk for hvert uriktige svar';
$string['penaltyforeachincorrecttry_help'] = 'Når du kjører spørsmålene dine med modiene \'Interaktiv med flere forsøk\' eller \'Tilpasningsmodus\', som gjør at studenten får flere forsøk til å svare riktig, så styrer dette valget hvor stort poengtrekket for hvert uriktige svar skal være.

Poengtrekket er en andel av den totale spørsmålskarakteren, så hvis spørsmålet er verdt tre poeng og poengtrekket er 0,33333333, får studentene 3 poeng hvis de svarer riktig på første forsøk, 2 hvis de får riktig på andre forsøk, og 1 hvis de svarer riktig tredje gang.';
$string['permissionedit'] = 'Endre dette spørsmålet';
$string['permissionmove'] = 'Flytt dette spørsmålet';
$string['permissionsaveasnew'] = 'Lagre som et nytt spørsmål';
$string['permissionto'] = 'Du har tillatelse til:';
$string['previewbank'] = 'Forhåndsvis delt spørsmålsbank';
$string['previewquestion'] = 'Forhåndsvis spørsmål: {$a}';
$string['privacy:metadata:database:question'] = 'Detaljene om et spesifikt spørsmål.';
$string['privacy:metadata:database:question:createdby'] = 'Personen som opprettet spørsmålet';
$string['privacy:metadata:database:question:generalfeedback'] = 'Den generelle tilbakemeldingen for dette spørsmålet.';
$string['privacy:metadata:database:question:modifiedby'] = 'Person som sist oppdaterte dette spørsmålet.';
$string['privacy:metadata:database:question:name'] = 'Navnet på spørsmålet.';
$string['privacy:metadata:database:question:questiontext'] = 'Spørsmålsteksten.';
$string['privacy:metadata:database:question:timecreated'] = 'Når dette spørsmålet ble opprettet.';
$string['privacy:metadata:database:question:timemodified'] = 'Dato og tidspunkt for når spørsmålet ble oppdatert';
$string['privacy:metadata:database:question_attempt_step_data'] = 'Spørsmålsforsøkstrinn kan ha tilleggsinformasjon knyttet til det spesifikke trinnet. Denne informasjonen er lagret i step_data tabellen.';
$string['privacy:metadata:database:question_attempt_step_data:name'] = 'Navnet på dataelementet.';
$string['privacy:metadata:database:question_attempt_step_data:value'] = 'Verdien på dataelementet.';
$string['privacy:metadata:database:question_attempt_steps'] = 'Hvert spørsmålsforsøk har et antall trinn for å skille mellom ulike faser fra begynnelsee til fullføring til karaktersetting. Denne tabellen lagrer informasjon om hvert trinn.';
$string['privacy:metadata:database:question_attempt_steps:fraction'] = 'Karakteren gitt for dette spørsmålet skalert ut fra en maksverdi på 1.';
$string['privacy:metadata:database:question_attempt_steps:state'] = 'Statusen for dette spørsmålsforsøket ved slutten av trinnovergangen.';
$string['privacy:metadata:database:question_attempt_steps:timecreated'] = 'Dato og tid for når trinnovergang be';
$string['privacy:metadata:database:question_attempt_steps:userid'] = 'Brukeren som utførte trinnovergangen';
$string['privacy:metadata:database:question_attempts'] = 'Informasjon om et forsøk på et spesifikt spørsmål.';
$string['privacy:metadata:database:question_attempts:flagged'] = 'En markering av at brukeren har flagget dette spørsmålet under forsøket.';
$string['privacy:metadata:database:question_attempts:responsesummary'] = 'En oppsummering av svarene på spørsmålet.';
$string['privacy:metadata:database:question_attempts:timemodified'] = 'Når spørsmålsforsøket ble oppdatert';
$string['privacy:metadata:database:question_bank_entries'] = 'Detaljene om et spesifikt spørsmål i spørsmålsbanken.';
$string['privacy:metadata:database:question_bank_entries:ownerid'] = 'Brukeren som eier spørsmålsoppføringen i spørsmålsbanken.';
$string['privacy:metadata:link:qbehaviour'] = 'Undersystemet "Spørsmål" bruker modultypen "Spørsmålsoppførsel".';
$string['privacy:metadata:link:qformat'] = 'Spørsmålets undersystem bruker import/eksportformater for å importere og eksportere spørsmål i forskjellige formater.';
$string['privacy:metadata:link:qtype'] = 'Undersystemet "Spørsmål" samhandler med modulen "Spørsmålstype" som inneholder de ulike spørsmålstypene.';
$string['published'] = 'delt';
$string['qbanknotfound'] = 'Modulen for spørsmålsbanken "{$a}" eksisterer ikke eller blir ikke gjenkjent.';
$string['qtypeveryshort'] = 'T';
$string['question_version'] = 'Spørsmålsversjon';
$string['question_versionshort'] = 'v{$a}';
$string['questionaffected'] = '<a href="{$a->qurl}">Spørsmål "{$a->name}" ({$a->qtype})</a> er i denne kategorien, men er også benyttet i <a href="{$a->qurl}">quiz "{$a->quizname}"</a> i kurset  "{$a->coursename}".';
$string['questionbank'] = 'Testbank';
$string['questionbank_plural'] = 'Spørsmålsbanker';
$string['questionbanknavigation'] = 'Spørsmålsbank tertiær navigasjon';
$string['questionbehaviouradminsetting'] = 'Innstillinger for spørsmålsatferd';
$string['questionbehavioursdisabled'] = 'Spørsmålsatferd som kan deaktiveres';
$string['questionbehavioursdisabledexplained'] = 'Skriv inn en kommaseparert liste over atferd du ikke skal vises i nedtrekksmenyen.';
$string['questionbehavioursorder'] = 'Rekkefølgen på spørsmålsatferdene';
$string['questionbehavioursorderexplained'] = 'Skriv inn en kommaseparert liste over atferder i den rekkefølgen du vil de skal vises i nedtrekksmenyen.';
$string['questioncategories'] = 'Spørsmålskategorier';
$string['questioncategory'] = 'Spørsmålskategori';
$string['questioncatsfor'] = 'Spørsmålskategorier for \'{$a}\'';
$string['questiondefaultssave'] = 'Lagre spørsmålsvalg som standard brukerpreferanse';
$string['questiondefaultssave_desc'] = 'Enten spørsmålsalternativer som \'Standard karakter\', \'Ett eller flere svar?\' etc. skal lagres som brukerpreferanser når redigeringsspørsmålsskjemaet sendes inn, for bruk som standard neste gang brukeren åpner skjemaet.';
$string['questiondoesnotexist'] = 'Spørsmålet finnes ikke';
$string['questionediting'] = 'Spørsmålsredigering';
$string['questionediting_desc'] = 'Disse innstillingene gjelder rediger spørsmål.';
$string['questionformtagheader'] = '{$a} tagger';
$string['questionidmismatch'] = 'Spørsmål-IDene stemmer ikke overens';
$string['questionloaderror'] = 'Kunne ikke laste inn spørsmålsalternativene.';
$string['questionname'] = 'Spørsmålsnavn';
$string['questionnameandquestionversion'] = '{$a->name} v{$a->version}';
$string['questionnamecopy'] = '{$a} (copy)';
$string['questionno'] = 'Spørsmål {$a}';
$string['questionpreviewdefaults'] = 'Standarder for forhåndsvisning av spørsmål';
$string['questionpreviewdefaults_desc'] = 'Disse standardene brukes når en bruker forhåndsviser et spørsmål i testbanken for første gang. Når en bruker har forhåndsvist et spørsmål, blir innstillingene lagret som brukerinnstillinger.';
$string['questions'] = 'Spørsmål';
$string['questionsaveerror'] = 'Det oppstod feil under lagring av spørsmål - ({$a})';
$string['questionsinuse'] = '* Angir spørsmål som ikke kan slettes fordi de er i bruk. I stedet vil de skjules i spørsmålsbanken med mindre du velger \'Vis gamle spørsmål\'.';
$string['questionsmovedto'] = 'Spørsmål som er i bruk er flyttet til "{$a}" i overordnet kurskategori';
$string['questionsrescuedfrom'] = 'Spørsmål lagret fra kontekst {$a}';
$string['questionsrescuedfrominfo'] = 'Disse spørsmålene (noen av dem kan være skjult) ble lagret da konteksten {$a} ble slettet, fordi de er fremdeles i bruk av noen quizer eller aktiviteter.';
$string['questiontags'] = 'Spørsmålstagger';
$string['questiontext'] = 'Spørsmålstekst';
$string['questiontype'] = 'Spørsmålstype';
$string['questionuse'] = 'Bruk spørsmål i denne aktiviteten';
$string['questionvariant'] = 'Spørsmålstype';
$string['questionx'] = 'Spørsmål {$a}';
$string['quizquestionbank'] = 'Quizens spørsmålsbank';
$string['recentlyviewedquestionbanks'] = 'Nylig viste spørsmålsbanker';
$string['requiresgrading'] = 'Karaktersetting påkrevet';
$string['responsehistory'] = 'Responshistorikk';
$string['restart'] = 'Prøv på nytt';
$string['restartwiththeseoptions'] = 'Prøv på nytt med disse valgene';
$string['restoremultipletopcats'] = 'Sikkerhetskopifilen inneholder mer en en toppnivåspørsmålskategori for konteksten {$a}';
$string['reviewresponse'] = 'Se over responser';
$string['rightanswer'] = 'Riktig svar';
$string['rightanswer_help'] = 'Et automatisk generert sammendrag av korrekte tilbakemeldinger. Dette kan bli noe snaut, så du vil kanskje heller forklare korrekt svar i den generelle tilbakemeldingen for spørsmålet, og slå dette valget av.';
$string['save'] = 'Lagre';
$string['savechangesandcontinueediting'] = 'Lagre endringer og fortsett redigeringen';
$string['saved'] = 'Lagret: {$a}';
$string['saveflags'] = 'Lagre status for markerte spørsmål';
$string['selectacategory'] = 'Velg en kategori:';
$string['selectaqtypefordescription'] = 'Velg en spørsmålstype for å se beskrivelsen dens.';
$string['selectcategoryabove'] = 'Velg en av kategoriene over';
$string['selectquestionsforbulk'] = 'Velg spørsmål for massehandling';
$string['settingsformultipletries'] = 'Innstillinger for flere forsøk';
$string['shareincontext'] = 'Del i konteksten for {$a}';
$string['shortversioninfo'] = 'v{$a->version} (av {$a->latestversion})';
$string['shortversioninfolatest'] = 'v{$a->version} (latest)';
$string['showhidden'] = 'Vis også skjulte spørsmål';
$string['showmarkandmax'] = 'Vis karakter og makskarakter';
$string['showmaxmarkonly'] = 'Vis kun makskarakter';
$string['shown'] = 'Vist';
$string['shownumpartscorrect'] = 'Vis antall korrekte svar';
$string['shownumpartscorrectwhenfinished'] = 'Vis antall korrekte svar straks spørsmålet er ferdig.';
$string['showquestiontext'] = 'Vis spørsmålsteksten i spørsmålslisten?';
$string['showquestiontext_full'] = 'Ja, med bilder, media etc.';
$string['showquestiontext_off'] = 'Nei';
$string['showquestiontext_plain'] = 'Ja, kun tekst';
$string['specificfeedback'] = 'Spesifikk tilbakemelding';
$string['specificfeedback_help'] = 'Tilbakemelding som avhenger av hvilket svar studenten ga.';
$string['started'] = 'Startet';
$string['state'] = 'Status';
$string['step'] = 'Trinn';
$string['steps'] = 'Steg';
$string['stoponerror'] = 'Stopp ved feil';
$string['stoponerror_help'] = 'Denne innstillingen bestemmer om importprosessen skal stoppe når det oppdages feil, noe som resulterer i ingen import i det hele tatt, eller om spørsmål med feil skal ignoreres og gyldige spørsmål importeres.';
$string['submissionoutofsequence'] = 'Tilgangen er ute av synk. Vennligst ikke klikk på nettleserens tilbakeknapp når du jobber med en quiz.';
$string['submissionoutofsequencefriendlymessage'] = 'Du har skrevet inn data som ikke passer inn den normale sekvensen. Dette kan skje når du bruker nettleserens Tilbake eller Neste-knapper; vennligst ikke bruk disse i løpet av en quiz. Det kan også skje hvis du klikker på noe mens siden lastes. Klikk på <strong>Fortsett</strong> for å fortsette.';
$string['submit'] = 'Send';
$string['submitandfinish'] = 'Send og avslutt';
$string['submitted'] = 'Send: {$a}';
$string['switchbank'] = 'Bytt bank';
$string['systembank'] = 'Globalt delte spørsmålsbanker';
$string['systembankdescription'] = 'Denne spørsmålsbanken ble opprettet automatisk mens portalen ble oppgradert.';
$string['tagarea_question'] = 'Spørsmål';
$string['technicalinfo'] = 'Teknisk informasjon';
$string['technicalinfo_help'] = 'Denne tekniske informasjonen er kanskje nyttig for utviklere som jobber med nye spørsmålstyper. Den kan også være til nytte når du prøver å diagnostisere problemer med spørsmålene.';
$string['technicalinfomaxfraction'] = 'Maksimal brøk: {$a}';
$string['technicalinfominfraction'] = 'Minste brøkdel: {$a}';
$string['technicalinfoquestionsummary'] = 'Spørsmålssammendrag: {$a}';
$string['technicalinforesponsesummary'] = 'Oppsummering av besvarelser';
$string['technicalinforightsummary'] = 'Oppsummering av riktige svar: {$a}';
$string['technicalinfostate'] = 'Spørsmålsstatus: {$a}';
$string['technicalinfovariant'] = 'Spørsmålsvariant: {$a}';
$string['tofilecategory'] = 'Skriv kategorien til fil';
$string['tofilecontext'] = 'Skriv konteksten til fil';
$string['topfor'] = 'Topp for {$a}';
$string['uninstallbehaviour'] = 'Avinstaller denne spørsmålsatferden.';
$string['uninstallqtype'] = 'Avinstaller denne spørsmålstypen';
$string['unknown'] = 'Ukjent';
$string['unknownbehaviour'] = 'Ukjent atferd: {$a}';
$string['unknownorunhandledtype'] = 'Ukjent eller ubehandlet spørsmålstype: {$a}';
$string['unknownquestion'] = 'Ukjent spørsmål: {$a}.';
$string['unknownquestioncatregory'] = 'Ukjent spørsmålskategori: {$a}.';
$string['unknownquestiontype'] = 'Ukjent spørsmålstype: {$a}.';
$string['unknowntolerance'] = 'Ukjent toleransetype {$a}';
$string['unpublished'] = 'privat';
$string['unusedcategorydeleted'] = 'Denne kategorien er slettet fordi, etter sletting av kurset, dets spørsmål ikke lenger er i bruk.';
$string['updatedisplayoptions'] = 'Oppdater visningsinnstillinger';
$string['upgradeproblemcategoryloop'] = 'Problem oppdaget ved oppgradering av spørsmålskategorier. Det er en loop i kategoritreet. De berørte kategori ID-ene er {$a}.';
$string['upgradeproblemcouldnotupdatecategory'] = 'Kunne ikke oppdatere spørsmålskategorien  {$a->name} ({$a->id}).';
$string['upgradeproblemunknowncategory'] = 'Problem oppdaget ved oppgradering av spørsmålskategorier. Kategorien {$a->id} peker til overordnet {$a->parent}, som ikke eksisterer. Overordnet kategori er endret for å fikse problemet.';
$string['version_selection'] = 'Versjon {$a->version}';
$string['versioninfo'] = 'Versjon {$a->version} (av {$a->latestversion})';
$string['versioninfolatest'] = 'Versjon {$a->version} (siste)';
$string['versioninfolatestshort'] = 'v{$a} (siste)';
$string['whethercorrect'] = 'Om svaret er riktig eller ikke';
$string['whethercorrect_help'] = 'Dette omfatter både den tekstlige beskrivelsen "Korrekt", "Delvis korrekt" eller "Feil", og alle fargesymboler som angir samme informasjon.';
$string['whichtries'] = 'Hvilke forsøk';
$string['withselected'] = 'Med valgte';
$string['wrongprefix'] = 'Feil formattert navnprefiks {$a}';
$string['xoutofmax'] = '{$a->mark} av {$a->max}';
$string['yougotnright'] = 'Du har {$a->num} korrekte svar.';
$string['youmustselectaqtype'] = 'Du må velge en spørsmålstype.';
$string['yourfileshoulddownload'] = 'Eksportfilen din blir nå lastet ned. Dersom intet skjer, vennligst <a href="{$a}">klikk her</a>. Overordnet kategori er endret for å fikse problemet.';
