<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'ai', language 'no', version '5.0'.
 *
 * @package     ai
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptai'] = 'Aksepter og fortsett';
$string['action'] = 'Handling';
$string['action_explain_text'] = 'Forklarende tekst';
$string['action_explain_text_desc'] = 'Forklarer tekstinnholdet på en kursside.';
$string['action_explain_text_instruction'] = 'Du vil motta tekstinndata fra brukeren. Din oppgave er å forklare den oppgitte teksten. Følg disse retningslinjene:
1. Utdyp: Utdyp viktige ideer og konsepter, og sørg for at forklaringen gir meningsfull dybde og unngår å gjenta teksten ordrett.
2. Forenkle: Bryt ned komplekse termer eller ideer til enklere komponenter, slik at de blir enkle å forstå for et bredt publikum, inkludert elever.
3. Gi kontekst: Forklar hvorfor noe skjer, hvordan det fungerer, eller hva formålet er. Inkluder relevante eksempler eller analogier for å forbedre forståelsen der det er passende.
4. Organiser logisk: Strukturer forklaringen din slik at den flyter naturlig, og begynn med grunnleggende ideer før du går videre til finere detaljer.

Viktige instruksjoner:
1. Returner sammendraget kun i ren tekst.
2. Ikke inkluder noen form for formatering med nedgraderinger, hilsener eller klisjeer.
3. Fokuser på klarhet, konsisthet og tilgjengelighet.

Sørg for at forklaringen er lettlest og effektivt formidler hovedpoengene i den opprinnelige teksten.';
$string['action_generate_image'] = 'Generer bilde';
$string['action_generate_image_desc'] = 'Generer bilde basert på tekstinput.';
$string['action_generate_text'] = 'Generer tekst';
$string['action_generate_text_desc'] = 'Generer tekst basert på tekstinput.';
$string['action_generate_text_instruction'] = 'Du vil motta en tekst fra brukeren. Oppgaven din er å generere tekst basert på forespørselen. Følg disse viktige instruksjonene:
    1. Returner oppsummeringen i ren tekst.
    2. Ikke inkluder noen form for formatering, kilsjeer eller høflighetsfraser.';
$string['action_summarise_text'] = 'Oppsummer tekst';
$string['action_summarise_text_desc'] = 'Oppsummerer tekstinnholdet på en kursside.';
$string['action_summarise_text_instruction'] = 'Du vil motta tekst fra brukeren. Din oppgave er å oppsummere den oppgitte teksten. Følg disse retningslinjene:
1. Kondenser: Forkort lange avsnitt til hovedpunkter.
2. Forenkle: Gjør kompleks informasjon lettere å forstå, spesielt for elever.

Viktige instruksjoner:
1. Returner sammendraget kun i ren tekst.
2. Ikke inkluder noen form for nedgraderingsformatering, hilsener eller klisjeer.
3. Fokuser på klarhet, konsisthet og tilgjengelighet.

Sørg for at sammendraget er lettlest og effektivt formidler hovedpoengene i originalteksten.';
$string['action_translate_text'] = 'Oversett tekst';
$string['action_translate_text_desc'] = 'Oversett oppgitt tekst fra et språk til et annet';
$string['actionsettingprovider'] = '{$a} handlingsinnstillinger';
$string['actionsettingprovider_desc'] = 'Disse innstillingene kontrollerer hvordan {$a->providername} utfører handlingen {$a->actionname}.';
$string['actionsettings'] = 'Handlingsinnstillinger';
$string['actionsettings_desc'] = 'Disse innstillingene kontrollerer KI-handlingene for denne tilbyderen.';
$string['ai'] = 'KI';
$string['aiactionregister'] = 'KI handlingsregister';
$string['aiplacements'] = 'KI plasseringer';
$string['aipolicyacceptance'] = 'KI-vilkår akseptanse';
$string['aipolicyregister'] = 'KI-vilkårsregister';
$string['aiproviders'] = 'KI tilbydere';
$string['aireports'] = 'KI rapporter';
$string['aiusage'] = 'KI bruk';
$string['aiusagepolicy'] = 'KI brukervilkår';
$string['availableplacements'] = 'Velg hvor KI-handlinger er tilgjengelige';
$string['availableplacements_desc'] = 'Plasseringer definerer hvor og hvordan KI kan brukes på portalen. I innstillingene kan du kan velge hvilke handlinger som skal være tilgjengelige på hver plassering.';
$string['availableproviders'] = 'Administrer KI-tilbyderne koblet til ditt LMS';
$string['availableproviders_desc'] = 'KI-tilbydere legger til KI-funksjonaliet på portalen gjennom handlinger som tekstoppsummering eller bildegenerering.<br/> Du kan administrere handlingene for hver tilbyder i deres innstillinger.';
$string['btninstancecreate'] = 'Opprett instans';
$string['btninstanceupdate'] = 'Oppdater instans';
$string['completiontokens'] = 'Fullføringstokens';
$string['completiontokens_help'] = 'Fullføringstokener er tekstenheter generert av KI-modellen som et svar på inndataene dine. Lengre svar bruker flere tokener, noe som sannsynligvis vil koste mer.';
$string['configureprovider'] = 'Konfigurer tilbyderinstanser';
$string['contentwatermark'] = 'Generert av KI';
$string['createnewprovider'] = 'Opprett ny tilbyderinstans';
$string['dateaccepted'] = 'Dato akseptert';
$string['declineaipolicy'] = 'Avslå';
$string['enableglobalratelimit'] = 'Angi grense for hele nettstedet';
$string['enableglobalratelimit_help'] = 'Begrens antall forespørsler som KI-leverandøren kan motta på tvers av hele nettstedet hver time.';
$string['enableuserratelimit'] = 'Angi brukergrense';
$string['enableuserratelimit_help'] = 'Begrens antall forespørsler hver bruker kan gjøre til KI-tilbyderen hver time.';
$string['error:actionnotfound'] = 'Handling \'{$a}\' ikke støttet';
$string['error:providernotfound'] = 'KI-tilbyderinstansen ikke funnet';
$string['globalratelimit'] = 'Maksimalt antall nettstedsomfattende forespørsler';
$string['globalratelimit_help'] = 'Antall tillatte nettstedomfattende forespørsler per time.';
$string['manageaiplacements'] = 'Administrer KI-plasseringer';
$string['manageaiproviders'] = 'Administrer KI-tilbydere';
$string['noproviders'] = 'Denne handlingen er ikke tilgjengelig. Ingen <a href="{$a}">KI-tilbyder</a> er konfigurert for handlingen.';
$string['placement'] = 'Plassering';
$string['placementactionsettings'] = 'Handlinger';
$string['placementactionsettings_desc'] = 'Tilgjengelige KI-handlinger for denne plasseringen.';
$string['placementsettings'] = 'Plasseringsspesifikke innstillinger';
$string['placementsettings_desc'] = 'Disse innstillingene styrer hvordan denne KI-plasseringen kobles til KI-tjenesten og relaterte operasjoner.';
$string['privacy:metadata:ai_action_explain_text'] = 'En tabell som lagrer forklaringstekstforespørsler fra brukere.';
$string['privacy:metadata:ai_action_explain_text:completiontoken'] = 'Fullføringstokenene som brukes til å forklare teksten.';
$string['privacy:metadata:ai_action_explain_text:fingerprint'] = 'Den unike hashen som representerer statusen/versjonen til modellen og innholdet.';
$string['privacy:metadata:ai_action_explain_text:generatedcontent'] = 'Den faktiske teksten generert av AI-modellen basert på inndataprompten.';
$string['privacy:metadata:ai_action_explain_text:prompt'] = 'Ledeteksten for forespørselen om forklaring.';
$string['privacy:metadata:ai_action_explain_text:prompttokens'] = 'Ledeteksttokenene som brukes til å forklare teksten.';
$string['privacy:metadata:ai_action_explain_text:responseid'] = 'ID-en til svaret.';
$string['privacy:metadata:ai_action_generate_image'] = 'En tabell som lagrer forespørsler om bildegenerering gjort av brukere.';
$string['privacy:metadata:ai_action_generate_image:aspectratio'] = 'Sideforholdet til de genererte bildene.';
$string['privacy:metadata:ai_action_generate_image:numberimages'] = 'Antall genererte bilder.';
$string['privacy:metadata:ai_action_generate_image:prompt'] = 'Ledeteksten for forespørselen om bildegenerering.';
$string['privacy:metadata:ai_action_generate_image:quality'] = 'Kvaliteten på de genererte bildene.';
$string['privacy:metadata:ai_action_generate_image:revisedprompt'] = 'Den reviderte ledeteksten til de genererte bildene.';
$string['privacy:metadata:ai_action_generate_image:sourceurl'] = 'Kilde-URL-en til de genererte bildene.';
$string['privacy:metadata:ai_action_generate_image:style'] = 'Stilen på de genererte bildene.';
$string['privacy:metadata:ai_action_generate_text'] = 'En tabell som lagrer tekstgenereringsforespørsler gjort av brukere.';
$string['privacy:metadata:ai_action_generate_text:completiontoken'] = 'Fullføringstokenene som brukes til å generere teksten.';
$string['privacy:metadata:ai_action_generate_text:fingerprint'] = 'Den unike hashen som representerer statusen/versjonen til modellen og innholdet.';
$string['privacy:metadata:ai_action_generate_text:generatedcontent'] = 'Den faktiske teksten generert av AI-modellen basert på inndataprompten.';
$string['privacy:metadata:ai_action_generate_text:prompt'] = 'Ledeteksten for forespørselen om tekstgenerering.';
$string['privacy:metadata:ai_action_generate_text:prompttokens'] = 'Ledeteksttokenene som brukes til å generere teksten.';
$string['privacy:metadata:ai_action_generate_text:responseid'] = 'ID-en til svaret.';
$string['privacy:metadata:ai_action_register'] = 'En tabell som lagrer handlingsforespørslene som er gjort av brukere.';
$string['privacy:metadata:ai_action_register:actionid'] = 'ID-en til handlingsforespørselen.';
$string['privacy:metadata:ai_action_register:actionname'] = 'Handlingsnavnet på forespørselen.';
$string['privacy:metadata:ai_action_register:model'] = 'Modellen som ble brukt til å generere svaret.';
$string['privacy:metadata:ai_action_register:provider'] = 'Navnet på leverandøren som håndterte forespørselen.';
$string['privacy:metadata:ai_action_register:success'] = 'Status for handlingsforespørselen.';
$string['privacy:metadata:ai_action_register:timecompleted'] = 'Fullført tid for forespørselen.';
$string['privacy:metadata:ai_action_register:timecreated'] = 'Tidspunktet da forespørselen ble opprettet.';
$string['privacy:metadata:ai_action_register:userid'] = 'ID-en til brukeren som sendte forespørselen.';
$string['privacy:metadata:ai_action_summarise_text'] = 'En tabell som lagrer forespørsler om sammendragstekst fra brukere.';
$string['privacy:metadata:ai_action_summarise_text:completiontoken'] = 'Fullføringstokenene som brukes til å oppsummere teksten.';
$string['privacy:metadata:ai_action_summarise_text:fingerprint'] = 'Den unike hashen som representerer statusen/versjonen til modellen og innholdet.';
$string['privacy:metadata:ai_action_summarise_text:generatedcontent'] = 'Den faktiske teksten generert av KI-modellen basert på inndataprompten.';
$string['privacy:metadata:ai_action_summarise_text:prompt'] = 'Ledeteksten for forespørselen om sammendrag av tekst.';
$string['privacy:metadata:ai_action_summarise_text:prompttokens'] = 'Ledeteksttokenene som brukes til å oppsummere teksten.';
$string['privacy:metadata:ai_action_summarise_text:responseid'] = 'ID-en til svaret.';
$string['privacy:metadata:ai_policy_register'] = 'En tabell som lagrer statusen for godkjenning av AI-policyen for hver bruker.';
$string['privacy:metadata:ai_policy_register:contextid'] = 'ID-en til konteksten hvis data ble lagret.';
$string['privacy:metadata:ai_policy_register:timeaccepted'] = 'Tidspunktet brukeren godtok AI-policyen.';
$string['privacy:metadata:ai_policy_register:userid'] = 'ID-en til brukeren hvis data ble lagret.';
$string['prompttokens'] = 'Ledeteksttokens';
$string['prompttokens_help'] = 'Ledeteksttokens er tekstenheter som utgjør inputen du sender til AI-modellen. Lengre input bruker flere tokens, noe som sannsynligvis vil koste mer.';
$string['provider'] = 'Tilbyder';
$string['provideractionsettings'] = 'Handlinger';
$string['provideractionsettings_desc'] = 'Velg og konfigurer handlingene som {$a} kan utføre på portalen.';
$string['providerinstanceactionupdated'] = '{$a} handlingsinnstillinger oppdatert';
$string['providerinstancecreated'] = '{$a} KI-tilbyderinstanser opprettet';
$string['providerinstancedelete'] = 'Slett KI-tilbyderinstans';
$string['providerinstancedeleteconfirm'] = 'Du er i ferd med å slette KI-tilbyderinstansen {$a->name} ({$a->provider}). Er du sikker?';
$string['providerinstancedeleted'] = '{$a} KI-tilbyderinstans slettet';
$string['providerinstancedeletefailed'] = 'Kan ikke slette KI-tilbyderinstansen {$a}. Tilbyderen er enten i bruk, eller det er et problem med databasen. Sjekk om tilbyderen er aktiv, eller kontakt databaseadministratoren for å få hjelp.';
$string['providerinstancedisablefailed'] = 'Kan ikke deaktivere KI-tilbyderinstansen. Tilbyderen er enten i bruk, eller det er et problem med databasen. Sjekk om tilbyderen er aktiv, eller kontakt databaseadministratoren for å få hjelp.';
$string['providerinstanceupdated'] = '{$a} KI-tilbyderinstans oppdatert.';
$string['providermoveddown'] = '{$a} flyttet ned.';
$string['providermovedup'] = '{$a} flyttet opp.';
$string['providername'] = 'Instansen navn';
$string['providers'] = 'Tilbydere';
$string['providersettings'] = 'Innstillinger';
$string['providertype'] = 'Velg KI-tilbydermodul';
$string['timegenerated'] = 'Når generert';
$string['unknownvalue'] = '—';
$string['userpolicy'] = '<h4><strong>Velkommen til den nye KI-funksjonen!</strong></h4>
<p>Denne kunstig intelligens (KI)-funksjonen er utelukkende basert på eksterne store språkmodeller (LLM) for å forbedre lærings- og undervisningsopplevelsen din. Før du begynner å bruke disse KI-tjenestene, vennligst les disse retningslinjene for bruk.</p>
<h4><strong>Nøyaktigheten til KI-generert innhold</strong></h4>
<p>KI kan gi nyttige forslag og informasjon, men nøyaktigheten kan variere. Du bør alltid dobbeltsjekke informasjonen som gis for å sikre at den er nøyaktig, fullstendig og egnet for din spesifikke situasjon.</p>
<h4><strong>Hvordan dataene dine behandles</strong></h4>
<p>Denne KI-funksjonen bruker eksterne store språkmodeller (LLM). Hvis du bruker denne funksjonen, vil all informasjon eller personopplysninger du deler bli håndtert i henhold til personvernreglene til disse LLM-ene. Vi anbefaler at du leser personvernreglene deres for å forstå hvordan de vil håndtere dataene dine. I tillegg kan en oversikt over dine interaksjoner med KI-funksjonene lagres på dette nettstedet.</p>
<p>Hvis du har spørsmål om hvordan dataene dine behandles, kan du kontakte lærerne eller læringsorganisasjonen din.</p>
<p>Ved å fortsette bekrefter du at du forstår og godtar disse retningslinjene.</p>';
$string['userratelimit'] = 'Maks antall forespørsler per bruker.';
$string['userratelimit_help'] = 'Antall tillatte forespørsel per time, per bruker.';
