<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boost_magnific', language 'pt', version '5.0'.
 *
 * @package     theme_boost_magnific
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['background_color'] = 'Cor de Fundo';
$string['background_color_desc'] = 'Cor de fundo do cabeçalho e do rodapé!';
$string['background_color_random'] = 'Tema Aleatório {$a}';
$string['background_text_color'] = 'Cor do Texto';
$string['background_text_color_desc'] = 'Cor do texto do topo e do rodapé!';
$string['choosereadme'] = 'O Boost Magnific é um tema elaborado com cuidado para trazer cores alegres para o Moodle.';
$string['contact_address'] = 'Endereço';
$string['contact_email'] = 'Email';
$string['contact_phone'] = 'Número de Telefone';
$string['content_type_default'] = 'Predefinição Moodle';
$string['content_type_empty'] = '(Sem conteúdo)';
$string['content_type_footer'] = 'Tipo de conteúdo para rodapé';
$string['content_type_footer_desc'] = 'Selecione o tipo de conteúdo que deseja exibir no rodapé.';
$string['content_type_home'] = 'Tipo de conteúdo para página inicial';
$string['content_type_home_desc'] = 'Selecione o tipo de conteúdo que deseja exibir na página inicial.';
$string['content_type_html'] = 'Página a ser criada com o editor';
$string['continuar'] = 'Continuar a estudar';
$string['countlesson'] = 'Lições {$a}';
$string['countlessons'] = '{$a} lições';
$string['course_access'] = 'Aceder à disciplina';
$string['course_moore'] = 'Mais detalhes';
$string['customcss'] = 'CSS Personalizado';
$string['customcss_desc'] = 'Quaisquer regras CSS que adicionar a esta área de texto serão refletidas em todas as páginas, facilitando a personalização deste tema.';
$string['custommenuitems'] = 'Itens de Menu Personalizados';
$string['custommenuitems_desc'] = 'Pode criar um menu personalizado ao lado dos menus principais. O menu raiz deve começar alinhado com a margem, e os submenus devem ser precedidos por um hífen (-). O número de hífens determina a profundidade do item. Assim, itens com um único hífen aparecem num submenu abaixo do item de nível superior anterior, e itens com dois hífens aparecem num submenu abaixo do submenu anterior.
O conteúdo de cada item de menu deve consistir em até três elementos (<strong>etiqueta</strong> | <strong>url</strong> | <strong>dica</strong> | <strong>idioma</strong>), cada um separado pelo caractere "|".
<ul>
<li><strong>etiqueta</strong>: Este é o texto que será exibido dentro do item de menu. Deve especificar uma etiqueta para cada item de menu.</li>
<li><strong>url</strong>: Este é o URL para o qual o utilizador será levado ao clicar no item de menu. Isto é opcional; se não fornecido, o item não será vinculado a nenhum lugar.<br>
Outros atributos como "target" podem ser adicionados ao final do URL.</li>
<li><strong>dica</strong>: Se fornecer um URL, também pode optar por fornecer uma dica para o link criado com o URL. Isto é opcional, e se não for definido, a etiqueta é usada como a dica para o item de menu.</li>
<li><strong>idioma</strong>: Pode adicionar um código de idioma (ou uma lista separada por vírgulas de códigos) como o quarto elemento da linha. A linha será exibida apenas se o utilizador tiver selecionado o(s) idioma(s) listado(s).</li>
</ul>
Aqui está um exemplo de como pode criar um menu personalizado:
<blockquote><pre>
Cursos
-Todos os cursos | /curso/
-Meus cursos
--Curso Exemplo
---Curso Exemplo 7 | /curso/ver.php?id=7
---Curso Exemplo 9 | /curso/ver.php?id=9
--Curso Teste
---Curso Teste 2 | /curso/ver.php?id=2
---Curso Teste 5 | /curso/ver.php?id=5
Google
-Google em qualquer idioma | https://google.com/" target="_blank
-Google no México | https://www.google.com.mx/" target="_blank|Etiqueta do Google|en
-Google em Português | https://google.com.br/" target="_blank|Etiqueta do Google|pt,pt_br,pt_br_kids
Página de Suporte | https://suporte.com/" target="_blank
</pre></blockquote>
Para o Moodle com suporte para vários idiomas, o valor de <strong>etiqueta</strong> deve ser formatado como <strong>"nomedacadeiadeidiomas,nomedocomponente"</strong>.
<blockquote><pre>
perfil,moodle | /utilizador/perfil.php
mensagens,mensagem | /mensagem/index.php
</pre></blockquote>
<a href="https://docs.moodle.org/404/en/Definições_avançadas_do_tema" target="_blank">Mais informações sobre menus</a>';
$string['editor_link_footer'] = 'Editar o bloco do rodapé para o idioma {$a}';
$string['editor_link_footer_all'] = 'Editar o bloco do rodapé para todos os idiomas';
$string['editor_link_home'] = 'Editar a página inicial para o idioma {$a}';
$string['editor_link_home_all'] = 'Editar a página inicial para todos os idiomas';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'O favicon é exibido ao lado do título da página no separador do navegador. Será exibido ofavicon do Moodle se não definir um favicon personalizado.';
$string['fontfamily'] = 'Fontes de Texto do Site';
$string['fontfamily_desc'] = 'Escolha qual fonte deseja utilizar para o texto no seu site Moodle.';
$string['fontfamily_menus'] = 'Fontes de Menu';
$string['fontfamily_menus_desc'] = 'Escolha qual fonte deseja utilizar para os menus no seu site Moodle.';
$string['fontfamily_sitename'] = 'Fonte para o nome do site';
$string['fontfamily_sitename_desc'] = 'A fonte que será aplicada ao nome do site se um logotipo não for fornecido.';
$string['fontfamily_title'] = 'Fontes de Texto de Título';
$string['fontfamily_title_desc'] = 'Escolha qual fonte deseja utilizar para os títulos no seu site Moodle.';
$string['fontpreview'] = 'Pré-visualização da Lista de Fontes';
$string['footer_contact_title'] = 'Título do Bloco de Contacto';
$string['footer_contact_title_default'] = 'Contacte-nos';
$string['footer_contact_title_desc'] = 'Insira o título do bloco que aparecerá no rodapé com os detalhes de contacto.';
$string['footer_description'] = 'Descrição';
$string['footer_description_desc'] = 'Descreva o seu Moodle, o que faz, e estas informações serão exibidas abaixo do logótipo no rodapé do Moodle';
$string['footer_frontpage_blockcourses_instructor'] = 'Mostrar nome do Professor';
$string['footer_frontpage_blockcourses_instructor_desc'] = 'Se ativo, mostra os nomes dos professores na lista de disciplinas!';
$string['footer_frontpage_blockcourses_text'] = 'Texto curto explicando o bloco "{$a}"';
$string['footer_frontpage_blockcourses_text_desc'] = 'Adicione um texto falando sobre "{$a}"!';
$string['footer_links_title'] = 'Título do Bloco de Links';
$string['footer_links_title_default'] = 'Links Importantes';
$string['footer_show_copywriter'] = 'Mostrar Feito com ❤️';
$string['footer_show_copywriter_desc'] = 'Desmarque se deseja ocultar o "Feito com ❤️"';
$string['footer_social_title'] = 'Título do Bloco de Links Sociais';
$string['footer_social_title_default'] = 'Siga-nos nas redes sociais';
$string['footer_social_title_desc'] = 'Insira o título do bloco que aparecerá no rodapé com os dados das suas redes sociais.';
$string['footerblink'] = 'Links do Rodapé';
$string['footerblink_desc'] = 'Pode configurar aqui os Links do Rodapé a serem mostrados pelos temas.<br>Cada linha consiste em algum texto de menu ou chave de idioma ou texto, um URL (opcional), separados por barras verticais. Por exemplo:<br><pre>Suporte Moodle|https://moodle.org/support</pre>';
$string['footerblock_contact'] = 'Bloco de contato';
$string['footerblock_copywriter'] = 'Feito com ❤️';
$string['footerblock_description'] = 'Bloco de descrição';
$string['footerblock_links'] = 'Bloco de links';
$string['footerblock_social'] = 'Bloco social';
$string['free_name'] = 'Grátis';
$string['frontpage_about_description'] = 'Descreva o que você faz';
$string['frontpage_about_description_desc'] = 'Descreva em um máximo de 5 linhas o propósito do seu Moodle';
$string['frontpage_about_enable'] = 'Ativar bloco Sobre';
$string['frontpage_about_enable_desc'] = 'Se selecionado, o Bloco Sobre aparecerá abaixo do Banner!';
$string['frontpage_about_info'] = 'Caixa de dados {$a}';
$string['frontpage_about_logo'] = 'Logotipo diferente a ser exibido aqui';
$string['frontpage_about_logo_desc'] = 'Se definido, este logo será usado aqui em vez do logo principal.<br>Vazio usa o Logo Principal!';
$string['frontpage_about_number'] = 'Quantidade de dados';
$string['frontpage_about_number_desc'] = 'Insira a quantidade de informações mencionadas acima';
$string['frontpage_about_text'] = 'Nome dos dados';
$string['frontpage_about_text_1_defalt'] = 'Disciplinas';
$string['frontpage_about_text_2_defalt'] = 'Professores';
$string['frontpage_about_text_3_defalt'] = 'Alunos';
$string['frontpage_about_text_4_defalt'] = 'Aulas';
$string['frontpage_about_text_desc'] = 'Insira o nome dos dados a serem mostrados na página inicial';
$string['frontpage_about_title'] = 'Título do bloco Sobre';
$string['frontpage_about_title_default'] = 'Nossa Comunidade Global';
$string['heart'] = 'Se gostar deste tema, não se esqueça de clicar ❤️ na página dos temas <a href="{$a}" target="_blank">clicando aqui</a>';
$string['instructor'] = 'Instrutor';
$string['login_backgroundcolor'] = 'Cor de Fundo';
$string['login_backgroundcolor_desc'] = 'Selecione a cor de fundo da página de recuperação de palavra-passe';
$string['login_backgroundfoto'] = 'Imagem de Fundo';
$string['login_backgroundfoto_desc'] = 'Selecione a imagem de fundo para Login/Recuperação de Palavra-passe/Criar Conta. A imagem padrão é: {$a}';
$string['login_forgot_description'] = 'Texto no lado da Tela de Esqueceu a Palavra-passe';
$string['login_forgot_description_desc'] = 'Texto que aparecerá apenas na tela de Esqueceu a Palavra-passe';
$string['login_login_description'] = 'Texto no lado da Tela de Login';
$string['login_login_description_desc'] = 'Texto que aparecerá apenas na tela de Login';
$string['login_signup_description'] = 'Texto no lado da Tela de Criar uma Conta';
$string['login_signup_description_desc'] = 'Texto que aparecerá apenas no ecrã de Criar uma Conta';
$string['login_theme'] = 'Tema do Login';
$string['login_theme_block'] = 'Bloco central branco com fundo opcional';
$string['login_theme_desc'] = 'Escolha qual tema deseja na área de Login';
$string['login_theme_image_login'] = 'Imagem de fundo e login no lado';
$string['login_theme_imagetext_login'] = 'Imagem de fundo, texto sobre a imagem, e login no lado';
$string['login_theme_login'] = 'Apenas ecrã de login, sem imagem lateral';
$string['logo_color'] = 'Logotipo Colorido';
$string['logo_color_desc'] = 'Por favor, faça o upload do seu LOGOTIPO colorido se deseja incluí-lo no topo. Este logotipo será exibido à medida que a página é rolada, e o menu será exibido em um fundo branco.';
$string['logo_write'] = 'Logótipo do menu superior ao fazer scroll';
$string['logo_write_desc'] = 'Por favor, carregue o seu logótipo se desejar incluí-lo no topo. Este logótipo será exibido quando o scroll permanecer no topo e o menu será exibido num fundo colorido.';
$string['matricular'] = 'Matricular';
$string['mycourses_color'] = 'Cor de Fundo do Bloco';
$string['mycourses_color_desc'] = 'A cor de fundo para o bloco.';
$string['mycourses_icon'] = 'Ícone';
$string['mycourses_icon_desc'] = 'Um ícone representativo para o bloco. O tamanho do ícone deve ser de 48x48 pixels.';
$string['mycourses_info'] = 'Bloco {$a}';
$string['mycourses_numblocos'] = 'Sem blocos';
$string['mycourses_numblocos_desc'] = 'Quantas imagens deseja no SlideShow?';
$string['mycourses_numblocos_nenhum'] = 'Sem slides na página inicial';
$string['mycourses_title'] = 'Título Curto do Bloco';
$string['mycourses_title_desc'] = 'Um título curto e descritivo para o bloco.';
$string['mycourses_url'] = 'Link do Bloco';
$string['mycourses_url_desc'] = 'O URL para navegar ao clicar no bloco. Pode ser um link externo ou interno dentro da plataforma.';
$string['pluginname'] = 'Boost Magnific';
$string['privacy:metadata'] = 'O tema Magnific do Boost não armazena nenhum dado pessoal sobre qualquer usuário.';
$string['settings_about_heading'] = 'Sobre o seu Moodle';
$string['settings_css_heading'] = 'Fontes e CSS';
$string['settings_footer_heading'] = 'Bloco do Rodapé';
$string['settings_icons_change_icons'] = 'Alterar o ícone padrão na lista do curso';
$string['settings_login_heading'] = 'Ecrã de Login';
$string['settings_mycourses_heading'] = 'Blocos dos Meus Cursos';
$string['settings_slideshow_heading'] = 'Apresentação de Slides';
$string['settings_theme_heading'] = 'Tema';
$string['settings_top_heading'] = 'Menu Principal';
$string['sitefonts'] = 'Fontes Adicionais do Google';
$string['sitefonts_desc'] = 'Insira o código @import do Google Fonts conforme indicado na imagem abaixo. Após salvar, o campo "Fonte do Site" será atualizado, exibindo estas fontes. Você pode adicionar múltiplos @import conforme necessário.';
$string['slidecaption_desc'] = 'Introduza o texto da legenda a ser utilizado no slide';
$string['slideshow_image'] = 'Imagem do Slide';
$string['slideshow_image_desc'] = 'A imagem deve ter 1250px X 400px.';
$string['slideshow_info'] = 'Slide {$a}';
$string['slideshow_numslides'] = 'Quantas imagens na Apresentação de Slides';
$string['slideshow_numslides_desc'] = 'Quantas imagens deseja na Apresentação de Slides?';
$string['slideshow_numslides_nenhum'] = 'Sem slides na Página Inicial';
$string['slideshow_text'] = 'Texto descritivo curto para o Slide';
$string['slideshow_text_desc'] = 'Insira um texto curto sobre o slide.';
$string['slideshow_url'] = 'Link dos botões dos slides';
$string['slideshow_url_desc'] = 'Inserir o link de destino para o botão de imagem do slide';
$string['social_facebook'] = 'O seu Facebook';
$string['social_facebook_desc'] = 'URL do Facebook da sua organização.';
$string['social_instagram'] = 'O seu Instagram';
$string['social_instagram_desc'] = 'URL do Instagram da sua organização.';
$string['social_linkedin'] = 'O seu Linkedin';
$string['social_linkedin_desc'] = 'URL do Linkedin da sua organização.';
$string['social_twitter'] = 'O seu Twitter';
$string['social_twitter_desc'] = 'URL do Twitter da sua organização.';
$string['social_youtube'] = 'O seu Youtube';
$string['social_youtube_desc'] = 'URL do Youtube da sua organização.';
$string['theme_boost_magnific_about_editbooton'] = 'Editar bloco Sobre';
$string['theme_boost_magnific_frontpage_bloco'] = 'Bloco "{$a}"';
$string['theme_boost_magnific_frontpage_home'] = 'Blocos da página inicial';
$string['theme_boost_magnific_mycourses_editbooton'] = 'Editar Blocos';
$string['theme_boost_magnific_slideshow_editbooton'] = 'Editar SlideShow';
$string['theme_color'] = 'Seleção de Cor';
$string['theme_color-color_buttons'] = 'Cor dos Botões';
$string['theme_color-color_buttons_desc'] = 'A cor usada para botões, adicionando coesão visual e enfatizando ações interativas.';
$string['theme_color-color_primary'] = 'Cor Primária';
$string['theme_color-color_primary_desc'] = 'A cor primária principal do tema, geralmente usada para destacar e enfatizar elementos.';
$string['theme_color-color_secondary'] = 'Cor Secundária';
$string['theme_color-color_secondary_desc'] = 'Uma cor secundária que complementa a cor primária, usada para destacar elementos secundários ou contrastar com a cor primária.';
$string['theme_color_desc'] = 'Selecione as cores dos textos e botões do Moodle ou clique na linha abaixo:';
$string['theme_color_heading'] = 'Seleção de Cor do Ambiente';
$string['theme_color_sugestion'] = 'Sugestão de Cor';
$string['theme_color_sugestion_text'] = 'Clique na linha para aplicar a cor aos campos abaixo:';
$string['theme_login_branco'] = 'Apenas tela de login, sem imagem lateral, com o formulário em fundo branco';
$string['top_color_heading'] = 'Cor do Scroll Top';
$string['top_scroll'] = 'Fixar o menu ao rolar a página';
$string['top_scroll_background_color'] = 'Cor de Fundo do Menu Superior ao Deslizar';
$string['top_scroll_background_color_desc'] = 'Definir a cor de fundo ao deslizar a página.';
$string['top_scroll_desc'] = 'Quando ativado, o menu será fixado no topo da tela enquanto você rola a página, garantindo fácil acesso às opções de menu.';
$string['top_scroll_text_color'] = 'Cor do Texto do Menu ao Deslizar';
$string['top_scroll_text_color_desc'] = 'Definir a cor do texto do menu ao deslizar a página.';
$string['vvveb_footer_contact_title_default'] = 'Contacte-nos';
$string['vvveb_home_access'] = 'Acessar curso';
$string['vvveb_home_automatically_catalogo'] = 'Não edite. Este bloco será automaticamente substituído pelo catálogo de disciplinas.';
$string['vvveb_home_automatically_category'] = 'Não edite. Este bloco será automaticamente substituído pelas categorias de disciplina.';
$string['vvveb_home_automatically_my_course'] = 'Não editar. Este bloco será automaticamente substituído pelos cursos nos quais o aluno está matriculado.';
$string['vvveb_home_automatically_popular'] = 'Não edite. Este bloco será automaticamente substituído pelas disciplinas mais populares.';
$string['vvveb_home_catalogo_heading'] = 'Catálogo de disciplinas';
$string['vvveb_home_category_heading'] = 'Categorias de disciplina';
$string['vvveb_home_mycourses_heading'] = 'Meus Cursos';
$string['vvveb_home_popular_course'] = 'Cursos Populares';
$string['vvveb_home_team_subtitle'] = 'Somos um grupo de profissionais dedicados ao seu trabalho';
$string['vvveb_home_team_title'] = 'Conheça a Nossa Equipe';
