<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_exaport', language 'ja', version '5.0'.
 *
 * @package     block_exaport
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutme'] = '私について';
$string['accessoptions'] = 'アクセスオプション';
$string['add'] = '追加';
$string['addButton'] = '追加';
$string['add_directory_structure'] = 'ディレクトリの構造を追加する';
$string['add_mixed'] = '成果物を追加する';
$string['add_this_file'] = 'このファイルを追加';
$string['addbookmark'] = 'ブックマークを追加';
$string['addcategory'] = 'カテゴリを追加';
$string['addcomment'] = 'コメントを追加';
$string['addposterror'] = 'この投稿をデータベースに追加する際にエラーが発生しました。';
$string['addstdcat'] = '標準カテゴリをインポート';
$string['attachincluded'] = '添付しますか？';
$string['attachment'] = '添付';
$string['autofillview'] = 'すべての利用可能なアーティファクトにもとづいてビューを自動生成';
$string['awaiting'] = '($a 待機)';
$string['back'] = '戻る';
$string['back_to_desp'] = '言語ポートフォリオに戻る';
$string['backtocourse'] = 'コースに戻る';
$string['badges_help'] = 'あなたに付与されたバッジ<br><a href=\'{$a}\' target=\'_blank\' class=\'external-link\'>取得済バッジを確認する</a>';
$string['badsessionkey'] = 'セッションキーに問題があります';
$string['block_exaport_allowcustomlayout_body'] = 'ビューの所有者に対して、カスタムビューレイアウト設定（下記オプション）の使用を許可する';
$string['block_exaport_allowcustomlayout_head'] = 'ビュー所有者向けのビューレイアウトカスタムオプションを有効にする';
$string['block_exaport_app_alloweditdelete_body'] = 'exabisコンピテンシーとdakoraの組み合わせの場合のみ有効';
$string['block_exaport_app_alloweditdelete_head'] = '教師のレビュー後、学生は各アイテムを編集・削除できます。';
$string['block_exaport_app_externaleportfolio_body'] = 'アプリ用';
$string['block_exaport_app_externaleportfolio_head'] = 'チェックすればファイルをMaharaに保存、チェックしなければexaportに保存';
$string['block_exaport_confirm_profilefield_create'] = '必須のプロファイルフィールドを追加しますか？';
$string['block_exaport_confirm_profilefield_exists'] = '信頼できる教師のプロファイルフィールドは既に存在します';
$string['block_exaport_copytomyportfolio'] = '「マイポートフォリオにコピーする」を有効にする';
$string['block_exaport_copytomyportfolio_body'] = '共有カテゴリから成果物をマイポートフォリオにコピーすることができます。';
$string['block_exaport_maxbytes'] = 'Exabis eポートフォリオにアップロードできる最大サイズ';
$string['block_exaport_maxbytes_body'] = 'これはExabis eポートフォリオ全体におけるアップロードファイルの最大サイズを指定します。<br>
サイト全体の値: {$a->sitemaxbytes}. <a href="{$a->settingsurl}">設定はこちら</a>';
$string['block_exaport_multiplefilesinitem'] = 'アーティファクト「ファイル」に複数ファイルを入れる';
$string['block_exaport_multiplefilesinitem_body'] = '上限：10ファイル';
$string['block_exaport_profilefield_created'] = '権限をもつ教師のプロファイルフィールドが追加されました。';
$string['block_exaport_teachercanseeartifactsofstudents_body'] = '教師にこの権限を持たせるかはそれぞれのプロフィールで設定する必要があります。
この機能は、上記のオプションが有効になっている場合のみ動作します。
<br />{$a}権限を持つ教師ごとの生徒リストは、その教師のコース登録に基づいて作成されます。
<br />生徒はこのアクセスを無効にすることはできません。他のユーザへのアクセスは、これまでと同様に与えることができます。';
$string['block_exaport_teachercanseeartifactsofstudents_configurationlink'] = '必須ユーザプロファイルフィールドの追加';
$string['block_exaport_teachercanseeartifactsofstudents_head'] = '教師は自分の生徒のすべての成果物を見ることができる';
$string['block_exaport_used_layout'] = '使用されているレイアウト';
$string['block_exaport_used_layout_body'] = '見た目に問題がある場合はレイアウトを変更してください。現在は、アーティファクトのリストのみに使用されています。';
$string['block_exaport_used_layout_clean_old'] = 'タイル(v4.6.7でサポート終了)';
$string['block_exaport_used_layout_moodle_bootstrap'] = 'カード';
$string['block_exaport_userquota'] = 'ユーザごとのExabis eポートフォリオへの格納最大値';
$string['block_exaport_userquota_body'] = 'ユーザが各自のExabis eポートフォリオに格納できる最大バイト値。<br>サイト全体の値: {$a->bytes}<a href="{$a->settingsurl}">設定はこちら</a>';
$string['blockcontent'] = 'ブロックコンテンツ';
$string['blocktitle'] = 'Exabis eポートフォリオ';
$string['blocktitle2'] = 'ブロックのタイトル';
$string['bookmarknotfound'] = 'ブックマークが見つかりません。';
$string['bookmarksall'] = 'すべてのアイテム';
$string['bookmarksfiles'] = 'ファイル';
$string['bookmarkslinks'] = 'リンク';
$string['bookmarksnotes'] = 'ノート';
$string['browsecategory'] = 'このカテゴリを閲覧する';
$string['browseportfolio'] = 'このポートフォリオを閲覧する';
$string['cancelButton'] = 'キャンセル';
$string['categories'] = 'カテゴリ';
$string['category'] = 'カテゴリ';
$string['category_not_found'] = 'カテゴリが見つかりません。';
$string['category_up'] = '親カテゴリに戻る';
$string['categorydeleted'] = 'カテゴリが削除されました。';
$string['categoryedited'] = 'カテゴリが保存されました。';
$string['categoryhead'] = 'カテゴリ名';
$string['categorynotempty'] = 'カテゴリを選択する必要があります。';
$string['categorysaved'] = 'カテゴリが追加されました。';
$string['change'] = '変更';
$string['change_layout'] = 'レイアウトを変更';
$string['checkall'] = 'すべてをチェック';
$string['chooselayout'] = 'ページにどのように列を配置するかを選択してください。';
$string['clearAllFilers'] = '全てのフィルタをクリア';
$string['clicktodownloadscorm'] = 'SCORMファイルをダウンロードするにはボタンをクリックしてください。';
$string['close'] = '閉じる';
$string['cofigureblock'] = 'ブロックを設定してください。';
$string['cofigureblock_badge'] = 'バッチを選択してください。';
$string['cofigureblock_cvinfo'] = '履歴書情報の選択';
$string['cofigureblock_cvinfo_certif'] = '認証、認定、受賞歴';
$string['cofigureblock_cvinfo_education_history'] = '学歴';
$string['cofigureblock_cvinfo_employment_history'] = '職歴';
$string['cofigureblock_cvinfo_goals'] = '私の目標';
$string['cofigureblock_cvinfo_interests'] = '趣味・関心のあること';
$string['cofigureblock_cvinfo_mbrship'] = '会員資格';
$string['cofigureblock_cvinfo_public'] = '書籍・出版物';
$string['cofigureblock_cvinfo_skills'] = '私のスキル';
$string['cofigureblock_cvinfo_withfiles'] = '添付ファイルあり';
$string['cofigureblock_header'] = 'ヘッドラインを選択してください。';
$string['cofigureblock_item'] = 'アイテムを選択してください。';
$string['cofigureblock_media'] = 'メディアを選択してください。';
$string['cofigureblock_personalinfo'] = '個人情報を選択してください。';
$string['cofigureblock_text'] = 'テキストを選択してください。';
$string['comment'] = 'コメント';
$string['comment_delete_confirmation'] = 'このコメントを本当に削除しますか？';
$string['commentnotfound'] = 'コメントが見つかりません。';
$string['comments'] = 'コメント';
$string['commentshouldnotbeempty'] = 'コメントを入力する必要があります。';
$string['competenceinteraction'] = 'exabis コンピテンシーブロックがインストールされている場合、相互利用を許可します。';
$string['competences'] = 'コンピテンシー';
$string['competences_old_version'] = 'このmoodleにインストールされているExabis eポートフォリオではもはやサポートされないExabisコンピテンシーの旧バージョン';
$string['config_feature_copy_to_course'] = '学生にeポートフォリオファイルをコースへコピーすることを許可します。';
$string['contactcomps'] = 'すべてを縮小';
$string['copycategory'] = '私のポートフォリオにコピーする';
$string['copyitemtocourse'] = 'コースにコピーする';
$string['couldninsertcomment'] = 'コメントを挿入できませんでした。';
$string['couldntcopyfile'] = 'ファイル $a をコピーできませんでした。ファイルはインポートされません。';
$string['couldntcreatedirectory'] = 'ディレクトリを作成できませんでした';
$string['couldntcreatetempdir'] = '一時ディレクトリを作成できませんでした!';
$string['couldntextractscormfile'] = 'SCORMファイルを取り出せませんでした!';
$string['couldntinsert'] = '$a をデータベースに挿入できませんでした!';
$string['couldntinsertcategory'] = 'カテゴリを挿入できませんでした。';
$string['couldntinsertdesc'] = '説明を挿入できませんでした!';
$string['couldntupdatecategory'] = 'カテゴリを更新できませんでした!';
$string['couldntupdatedesc'] = '説明を更新できませんでした!';
$string['course'] = 'コース';
$string['create_as_note'] = 'アーティファクトとして作成';
$string['create_view_content_help_text'] = '<ul>
                <li><strong>レイアウトを設計する：</strong>コンテンツブロックをドラッグアンドドロップして設置し、あなたのストーリーを伝えましょう。列("レイアウト"セクションで設定可能)を設定してポートフォリオを設計しましょう。</li>
                <li><strong>わかりやすく整理する：</strong> ヘッダー、リンク、ノートを使用して効果的な構成にしましょう。</li>
                <li><strong>スタイルをカスタマイズする：</strong> 利用可能なオプションからフォントや色を選択して、あなたらしさを加えましょう。</li>
            </ul>
            <strong>忘れないで： eポートフォリオは、あなた自身とあなたのもつスキルを伝えるものです。わかりやすく、魅力的なものにしましょう！</strong>';
$string['createepxexport'] = 'EPXファイルを作成してください。';
$string['createexport'] = 'SCORMファイルを作成してください。';
$string['createexport_directory'] = 'ディレクトリの階層を作成する';
$string['createpage'] = 'ページをつくるために下のタブからコンテンツブロックをドラッグ＆ドロップしてください。';
$string['current_category'] = '現在のカテゴリ';
$string['cvinformation'] = '履歴書情報';
$string['cvinformation_help'] = 'Exabis e-Portfolioに格納されている履歴書データ(学歴、職歴etc...)<br><a href=\'{$a}\' target=\'_blank\' class=\'external-link\'>履歴書データを確認する</a>';
$string['date'] = '日付';
$string['delete'] = '削除';
$string['delete_all_shareall'] = '全員への共有をすべて削除しますか?';
$string['deletecategoryconfirm'] = '本当にカテゴリ "{$a->name}"を削除してもよろしいですか?　このカテゴリとサブカテゴリ内のすべてのエントリは削除されます!';
$string['deletefileconfirm'] = '本当にこのファイルを削除してもよろしいですか?';
$string['deletelinkconfirm'] = '本当にこのリンクを削除してもよろしいですか?';
$string['deletenoteconfirm'] = '本当にこのノートを削除してもよろしいですか?';
$string['deleteposterror'] = '投稿を削除中にエラーが発生しました。';
$string['descriptionsaved'] = '説明が保存されました。';
$string['deselectall'] = 'すべての選択を解除してください。';
$string['desp_categories'] = 'ストーリー、ロールプレイ、エッセイ、コラーゲン
    履歴書
    芸術作品、展覧会のレビュー
    プロジェクトの報告書と考察
    オーディオクリップ、ビデオクリップ
    他国籍の人々との出会い
    あなたの語学力について
    成績表
    修了証
    謝辞
    リスニング
　　-個人作業
　　-パートナーとの作業
　　-グループでの作業
　リーディング
　　-個人作業
　　-パートナーとの作業
　　-グループでの作業
　会話への参加
　　-個人作業
　　-パートナーとの作業
　　-グループでの作業
　流暢なスピーキング
　　-個人作業
　　-パートナーとの作業
　　-グループでの作業
　筆記
　　-個人作業
　　-パートナーとの作業
　　-グループでの作業';
$string['desp_einleitung'] = 'あなたのポートフォリオです。あなたが自身で達成したことを他の人に表示することができます。';
$string['desp_language'] = '表示言語';
$string['desp_pluginname'] = '履歴書';
$string['details'] = '詳細';
$string['developed'] = 'developed by';
$string['dontincludeurl'] = 'ブックマークのURLとの関連づけを解除する場合あこのボックスをチェックしてください。';
$string['download'] = 'ダウンロード';
$string['download_pdf'] = 'PDFでダウンロード';
$string['duplicatedurl'] = 'すでにこのURLはブックマークされています。';
$string['edit'] = '編集';
$string['editcategories'] = 'カテゴリを編集する';
$string['emailaccess'] = 'メールで共有';
$string['emailaccessdescription'] = '1行につき1つのEメールアドレスを入力してください<br />各Eメールアドレスには、このビューにアクセスできる固有のリンクが送信されます。メールを削除すると、このビューへのアクセスは削除されます。';
$string['emailaccessmessage'] = 'こんにちは！{$a->sendername}さんがあなたとビュー"{$a->viewname}"を共有しました。こちらで見ることができます： {a->url}';
$string['emailaccessmessageHTML'] = 'こんにちは！<br />{$a->sendername}さんがあなたと"{$a->viewname}"ビューを共有しました。<br /><a href="{$a->url}">こちら</a>から見ることができます。';
$string['emailaccessmessagesubject'] = '新しいビューの共有';
$string['endedit'] = '編集を終了する';
$string['enrolled_courses'] = 'コース関連';
$string['exaport:addinstance'] = 'Exabis eポートフォリオをコースに追加する';
$string['exaport:allowposts'] = '投稿を許可';
$string['exaport:competences'] = 'コンピテンシーを許可';
$string['exaport:export'] = 'SCORMファイルのエクスポート';
$string['exaport:import'] = 'SCORMファイルのインポート';
$string['exaport:importfrommoodle'] = 'Moodleからインポートします。';
$string['exaport:myaddinstance'] = 'Exabis eポートフォリオをマイホームに追加する';
$string['exaport:shareextern'] = 'ビューの外部共有';
$string['exaport:shareintern'] = 'ビューの内部共有';
$string['exaport:use'] = '利用が認められています。';
$string['exaport:viewartifactsfromstudents'] = '自分の生徒のポートフォリオの成果物を見ることができる';
$string['expandcomps'] = 'すべてを展開します。';
$string['explaincategories'] = 'カテゴリ: カテゴリの作成と変更ができます。';
$string['explainexport'] = 'あなたのポートフォリオをここでエクスポートしてください。';
$string['explainimport'] = 'ここではSCORMファイルをポートフォリオにインポートすることができます。以前のエクスポートからのマーカーが見つかった場合、インポートは既存のファイルにデータを取り込みます。';
$string['explaining'] = 'ポートフォリオはWebのアドレスやファイル、意見を含むノート、その他書き下ろしたちょっとしたメモなどを蓄えるために用いられます。';
$string['explainingall'] = 'ポートフォリオ内のすべてのアイテム';
$string['explainingfile'] = 'ファイル。これらのファイルは認証済みコースメンバーと共有と共有されます。';
$string['explaininglink'] = 'リンク。これらのリンクは認証済みコースメンバーと共有と共有されます。';
$string['explainingmoredata'] = '<strong>ここは学習の証を集約するためのスペースです。</strong>
            <ul>
                <li><strong>最高の作品を追加する：</strong> ファイル、ウェブリンク、プロジェクト、プレゼンテーションおよびその説明をアップロードします。</li>
                <li><strong>経験を振り返る：</strong> 各作品について、何を学んだか、乗り越えた課題、達成したことを説明します。</li>
            </ul>
            <strong>各項目はあなたのスキルや知識をアピールするストーリーだと考えてください。</strong>';
$string['explainingnote'] = 'ノート。これらのノートは認証済みコースメンバーと共有と共有されます。';
$string['explainingshare'] = '参加者にリンクを先の表示を許可するには、それらの名前をクリックし、変更を保存をクリックしてください。一人以上の参加者を選択することができます。';
$string['explainingshared'] = 'これらの参加者は、すでに外部リンクやファイルやノートを共有しています。';
$string['explainingsharefile'] = '参加者にファイルの表示を許可するには、それらの名前をクリックし、変更を保存をクリックしてください。一人以上の参加者を選択することができます。';
$string['explainingsharenote'] = '参加者にノートの表示を許可するには、それらの名前をクリックし変更後、保存をクリックしてください。一人以上の参加者を選択することができます。';
$string['explainingviews'] = 'あなたのビューを管理する';
$string['explainpersonal'] = '個人情報';
$string['export'] = 'SCORMファイルをエクスポート';
$string['export_directory'] = 'ディレクトリの階層をエクスポートする';
$string['export_short'] = 'エクスポートする';
$string['exportcomment'] = 'これはExabis eポートフォリオからエクスポートされたファイルです。インポート時に必要ですのでコメントを削除しないでください。';
$string['exportepx'] = 'EPXファイルをエクスポート';
$string['exportviewselect'] = '特定のビューのアイテムをエクスポートするにはここを選んでください。';
$string['externaccess'] = '外部のeポートフォリオリンク';
$string['externalaccess'] = '外部アクセス';
$string['externcomment'] = '外部ポートフォリオでコメントを共有します。';
$string['fieldstoshow'] = '表示するフィールド';
$string['file'] = 'ファイル';
$string['filecopiedtocourse'] = 'ファイルがコース $a->coursename に $a->filename という名前でコピーされました';
$string['filenotfound'] = 'ファイルが見つかりません。';
$string['filetypenotdetected'] = '$a->filename のファイル形式  ($a->title) は検出されませんでした。ファイルはインポートされていません。';
$string['filterByTag'] = 'タグでフィルタをかける';
$string['firstname'] = '名';
$string['firstnameshared'] = '名';
$string['forms.item.title'] = 'タイトル';
$string['forms.item.title_help'] = 'タイトルの補助説明';
$string['go'] = 'Go!';
$string['gradeitem'] = '採点';
$string['grouptitle'] = 'グループタイトル';
$string['headertext'] = 'ヘッダーテキスト';
$string['headertext_help'] = 'ヘッダーラインを追加';
$string['height'] = '高さ';
$string['hidesummary'] = '(概要を隠す)';
$string['i_shared'] = '私はあなたとeポートフォリオのビューを共有しました。';
$string['iconfile'] = 'アイコン画像';
$string['iconfile_merge'] = 'このアイコン画像をフォルダアイコンに結合します。';
$string['iconfile_merge_description'] = 'アイコン画像と標準フォルダアイコンとの結合を試みます。(保証外) アイコンは新しい画像に置き換えられます。';
$string['import'] = 'SCORMファイルをインポートする';
$string['import_short'] = 'インポート';
$string['importedcommentsend'] = 'インポートされたコメントの終わり';
$string['importedcommentsstart'] = 'インポートされたコメント:<br /><br />';
$string['importexport'] = 'インポート / エクスポート';
$string['incompatible_video'] = 'このビデオを閲覧するためにはこちらのリンク  を使用してください:{$a->link}';
$string['incorrectlinksid'] = 'リンク投稿IDが正しくありません';
$string['incorrectnoteid'] = 'ノートIDが正しくありません';
$string['internalaccess'] = '内部アクセス';
$string['internalaccessall'] = '<span class=\'block_eportfolio_bold\'>すべて</span>へのアクセス';
$string['internalaccessgroups'] = '以下のグループのみのアクセス';
$string['internalaccessusers'] = '以下のユーザのみのアクセス';
$string['intro'] = 'コンテンツ';
$string['intronotempty'] = 'コンテンツを入力してください。';
$string['invalidassignmentid'] = '無効な課題IDです。';
$string['invalidcourseid'] = '無効なコースIDです。';
$string['invalidfileatthisassignment'] = 'この課題にはファイルが存在しません!';
$string['invalidinstance'] = '無効なインスタンスです。';
$string['item'] = 'アイテム';
$string['itemgrading'] = '採点';
$string['items'] = 'アイテム';
$string['items_help'] = 'あなたの成果物<br><a href=\'{$a}\' target=\'_blank\' class=\'external-link\'>成果物を確認する</a>';
$string['lastname'] = '姓';
$string['layout_settings'] = 'レイアウト設定';
$string['layout_settings_border_width'] = '枠線の幅';
$string['layout_settings_custom_css'] = 'カスタムCSS';
$string['layout_settings_custom_css_description'] = 'ここでは独自のCSSを使用できます。';
$string['layout_settings_description'] = 'ここでは、ビューのレイアウトオプションを変更したり、独自のCSSを使用して、お好みのビューにすることができます。';
$string['layout_settings_font_size'] = 'フォントの大きさ';
$string['layout_settings_font_weight'] = '太字';
$string['layout_settings_view_content'] = 'ビューのコンテンツブロック';
$string['layout_settings_view_headers'] = 'ビューのヘッダーブロック';
$string['link'] = 'リンク';
$string['linkedfilenotfound'] = '$a->url ($a->title) にファイル $a->filename が見つかりません。ファイルはインポートされませんでした。';
$string['list'] = 'リスト';
$string['listofartefacts'] = 'アーティファクトのリスト';
$string['listofbadges'] = 'バッジのリスト';
$string['loginasmode'] = '「...としてログイン」 モードでポートフォリオにアクセスできません。';
$string['mailadress'] = 'メールアドレス';
$string['maincategory'] = 'メインカテゴリ';
$string['make_it_yours'] = 'それをあなたのものにします。';
$string['makeimport'] = 'インポート';
$string['managecategories'] = 'カテゴリを管理する';
$string['mandatoryfields'] = 'フィールド名、カテゴリと説明は必須入力です。　入力してください。';
$string['mandatoryfieldsforcat'] = 'フィールド名は必須入力です。入力してください。';
$string['media'] = 'メディア';
$string['media_allowed_notes'] = '以下のサイトからのURLが利用可能です。';
$string['media_help'] = 'YoutubeやVimeoなどのソースを利用できるメディアデータ';
$string['mediacontent'] = 'URLもしくは埋め込みコード *';
$string['membercount'] = '会員数';
$string['messageprovider:sharing'] = '通知を共有する';
$string['moodleimport'] = 'Moodleの課題からインポート';
$string['moreinfolink'] = 'もっと見る';
$string['movebottom'] = '最後に移動';
$string['movetop'] = '最初に移動';
$string['myfilearea'] = '私のファイル領域';
$string['myportfolio'] = '私の成果物';
$string['myportfoliotitle'] = 'Exabis eポートフォリオモジュール： ここにリンクとファイルを追加してください。';
$string['name'] = '名称';
$string['new'] = '新';
$string['newfile'] = '新しいファイルを追加する';
$string['newlink'] = '新しいリンクを追加する';
$string['newnote'] = '新しいノートを追加する';
$string['newview'] = 'ビューを追加する';
$string['nobookmarksall'] = '(まだアイテムはありません)';
$string['nobookmarksfile'] = '(まだファイルはありません)';
$string['nobookmarkslink'] = '(まだリンクはありません)';
$string['nobookmarksnote'] = '(ノートはまだありません)';
$string['nocategories'] = '(カテゴリはまだありません)';
$string['nocoursetogether'] = 'コースはありません';
$string['noemails'] = '利用可能なメールアドレスはありません';
$string['noentry'] = 'エントリはありません';
$string['nogroupsfound'] = 'グループはありません';
$string['noguestpost'] = 'ゲストはここにアクセスできません';
$string['nomail'] = 'メールはありません。';
$string['nomoodleimportyet'] = 'いまのところ、いずれの課題にも提出がありません。';
$string['nopicture'] = '画像はありません。';
$string['noprofilepicture'] = '利用可能なプロファイル画像はありません。';
$string['note'] = 'ノート';
$string['notetitle'] = 'ノート';
$string['nothingshared'] = '誰もあなたとポートフォリオを共有していません。';
$string['nothingstructureshared'] = '誰もあなたとカテゴリを共有していません。';
$string['notify'] = '通知';
$string['nouserforaccess'] = 'ユーザが見つかりません。(アクセスコード不明)';
$string['nouserforid'] = 'ユーザが見つかりません。(id不明)';
$string['nousersfound'] = 'ユーザが見つかりません。';
$string['noviews'] = '新しいビューを作成してください。';
$string['opencomps'] = 'あなたのコンピテンシーを選んでください。';
$string['other_groups_course'] = '他のコース';
$string['other_users_course'] = 'マイコース内ではないユーザ';
$string['othercourses'] = '他のコース';
$string['pdf_customfont'] = 'カスタムフォントをアップロードする';
$string['pdf_customfont_help'] = '独自の.ttfファイルをアップロードすることができます。
PDF生成のために使用されます。';
$string['pdf_settings'] = 'PDF設定';
$string['pdf_settings_description'] = '特殊な文字や一般的でない文字などを使用すると、生成されるPDFに問題が生じることがあります。その場合、別のフォント設定を試してみてください。<br>
あなたのPDFの設定は、このビューのために保存されます。<br>そのため、あなたのビューを他のユーザーと共有した場合、共有されたユーザはあなたが行った設定でPDFを見ることになります。';
$string['pdf_settings_fontfamily'] = 'フォントの種類';
$string['pdf_settings_fontfamily_customgroup'] = 'アップロードされたカスタムフォント';
$string['pdf_settings_fontfamily_fixedgroup'] = '定義されているフォント';
$string['pdf_settings_fontsize'] = '基本のフォントサイズ';
$string['pdf_settings_pageorient'] = 'ページの向き';
$string['pdf_settings_pageorient.landscape'] = '景観';
$string['pdf_settings_pageorient.portrait'] = 'ポートレート';
$string['pdf_settings_pagesize'] = 'ページサイズ';
$string['pdf_settings_showmetadata'] = 'ビューのメタデータを追加する';
$string['pdf_settings_showuseremail'] = 'メール';
$string['pdf_settings_showusername'] = 'ユーザ名';
$string['pdf_settings_showuserphone'] = '電話番号';
$string['pdf_settings_showuserpicture'] = 'ユーザ写真';
$string['pdf_settings_uploadfont'] = '自分のフォントをアップロードする';
$string['personal'] = '情報';
$string['personalinformation'] = '個人情報';
$string['personalinformation_help'] = '名前やメールアドレスなどの個人情報<br><a href=\'{$a}\' target=\'_blank\' class=\'external-link\'>プロファイルを確認する</a>';
$string['pluginname'] = 'Exabis eポートフォリオ';
$string['privacy:metadata:block_exaportcate'] = 'ユーザカテゴリ';
$string['privacy:metadata:block_exaportcate:courseid'] = 'コースID';
$string['privacy:metadata:block_exaportcate:description'] = '説明';
$string['privacy:metadata:block_exaportcate:internshare'] = '内部共有ですか？';
$string['privacy:metadata:block_exaportcate:name'] = 'タイトル';
$string['privacy:metadata:block_exaportcate:name_short'] = '省略名';
$string['privacy:metadata:block_exaportcate:parent_ids'] = '親IDリスト';
$string['privacy:metadata:block_exaportcate:parent_titles'] = '親タイトルリスト';
$string['privacy:metadata:block_exaportcate:pid'] = '親カテゴリID';
$string['privacy:metadata:block_exaportcate:shareall'] = '全員で共有したか？0-共有しなかった、1-全員で共有した、2-グループで共有した';
$string['privacy:metadata:block_exaportcate:source'] = 'ソース';
$string['privacy:metadata:block_exaportcate:sourceid'] = 'ソースのID';
$string['privacy:metadata:block_exaportcate:sourcemod'] = 'ソースの改造';
$string['privacy:metadata:block_exaportcate:stid'] = '学校別ID';
$string['privacy:metadata:block_exaportcate:structure_share'] = 'カテゴリとして共有されていますか？\'structure_shareall\'も見てください。';
$string['privacy:metadata:block_exaportcate:structure_shareall'] = 'カテゴリとして共有されていますか？
0 - 共有されていない
1 - 全員に共有されている
2 - グループに共有されている';
$string['privacy:metadata:block_exaportcate:subjid'] = '関連科目のID';
$string['privacy:metadata:block_exaportcate:timemodified'] = '最終更新日';
$string['privacy:metadata:block_exaportcate:topicid'] = '関連するトピックID';
$string['privacy:metadata:block_exaportcate:userid'] = 'ユーザID';
$string['privacy:metadata:block_exaportitem'] = 'ユーザのアーティファクト';
$string['privacy:metadata:block_exaportitem:categoryid'] = 'カテゴリID';
$string['privacy:metadata:block_exaportitem:courseid'] = 'コースID';
$string['privacy:metadata:block_exaportitem:exampid'] = '関連する例のID';
$string['privacy:metadata:block_exaportitem:example_url'] = 'アーティファクトの所有者';
$string['privacy:metadata:block_exaportitem:externaccess'] = '外部からのアクセス';
$string['privacy:metadata:block_exaportitem:externcomment'] = '外部からのコメント';
$string['privacy:metadata:block_exaportitem:fileurl'] = 'ファイルのURL';
$string['privacy:metadata:block_exaportitem:intro'] = '入門';
$string['privacy:metadata:block_exaportitem:iseditable'] = '編集可能ですか？';
$string['privacy:metadata:block_exaportitem:langid'] = '言語ID';
$string['privacy:metadata:block_exaportitem:name'] = '名前';
$string['privacy:metadata:block_exaportitem:parentid'] = '親ID';
$string['privacy:metadata:block_exaportitem:shareall'] = '全員に共有しますか？';
$string['privacy:metadata:block_exaportitem:source'] = 'ソース';
$string['privacy:metadata:block_exaportitem:sourceid'] = 'ソースID';
$string['privacy:metadata:block_exaportitem:timemodified'] = '最終更新日時';
$string['privacy:metadata:block_exaportitem:type'] = 'アーティファクトのタイプ';
$string['privacy:metadata:block_exaportitem:url'] = 'URL';
$string['privacy:metadata:block_exaportitem:userid'] = 'アーティファクトの所有者';
$string['privacy:metadata:block_exaportitemcomm'] = '成果物へのコメント';
$string['privacy:metadata:block_exaportitemcomm:entry'] = 'コメント';
$string['privacy:metadata:block_exaportitemcomm:itemid'] = 'アーティファクトのID';
$string['privacy:metadata:block_exaportitemcomm:timemodified'] = '最終更新';
$string['privacy:metadata:block_exaportitemcomm:userid'] = 'コメント投稿者';
$string['privacy:metadata:block_exaportresume'] = 'レジュメデータ';
$string['privacy:metadata:block_exaportresume:courseid'] = 'コースID';
$string['privacy:metadata:block_exaportresume:cover'] = '内容';
$string['privacy:metadata:block_exaportresume:goalsacademic'] = 'アカデミックゴール';
$string['privacy:metadata:block_exaportresume:goalscareers'] = 'キャリアゴール';
$string['privacy:metadata:block_exaportresume:goalspersonal'] = 'パーソナルゴール';
$string['privacy:metadata:block_exaportresume:interests'] = '興味のあること';
$string['privacy:metadata:block_exaportresume:skillsacademic'] = 'アカデミックスキル';
$string['privacy:metadata:block_exaportresume:skillscareers'] = 'キャリアスキル';
$string['privacy:metadata:block_exaportresume:skillspersonal'] = 'パーソナルスキル';
$string['privacy:metadata:block_exaportresume:user_id'] = 'レジュメの所有者';
$string['privacy:metadata:block_exaportuser'] = 'exabis eポートフォリオのユーザーデータ';
$string['privacy:metadata:block_exaportuser:description'] = '説明';
$string['privacy:metadata:block_exaportuser:user_id'] = 'ユーザーID';
$string['privacy:metadata:block_exaportuser:view_items_layout'] = 'ユーザーID';
$string['privacy:metadata:block_exaportview'] = '成果物へのコメント';
$string['privacy:metadata:block_exaportview:autofill_artefacts'] = '成果物からの自動入力を有効にする';
$string['privacy:metadata:block_exaportview:description'] = '説明';
$string['privacy:metadata:block_exaportview:externaccess'] = '外部からのアクセスですか？';
$string['privacy:metadata:block_exaportview:externcomment'] = '外部からのコメントですか？';
$string['privacy:metadata:block_exaportview:langid'] = '言語ID';
$string['privacy:metadata:block_exaportview:layout'] = 'ビューのレイアウト';
$string['privacy:metadata:block_exaportview:name'] = '名前';
$string['privacy:metadata:block_exaportview:shareall'] = '全員で共有しますか？';
$string['privacy:metadata:block_exaportview:sharedemails'] = 'メールで共有しますか？';
$string['privacy:metadata:block_exaportview:timemodified'] = '最終更新';
$string['privacy:metadata:block_exaportview:userid'] = 'ビューの所有者';
$string['privacy:metadata:core_files'] = 'Exabis eポートフォリオに、ユーザーがアップロードした成果物、レジュメ、コメントなどのファイルを保存します。';
$string['profilepicture'] = 'プロファイル画像';
$string['publishedportfolios'] = '発行されたポートフォリオ';
$string['resume_badges'] = 'バッジ';
$string['resume_certif'] = '証明、認定および受賞';
$string['resume_certifdeleted'] = '証明、認定および受賞は削除されました。';
$string['resume_certifsaved'] = '証明、認定および受賞は削除されました。';
$string['resume_collaps'] = 'すべてを折りたたむ';
$string['resume_contribution'] = '貢献';
$string['resume_contributiondetails'] = 'あなたの貢献の詳細';
$string['resume_cover'] = 'カバーレター';
$string['resume_coversaved'] = 'カバーは保存されました';
$string['resume_date'] = '日付';
$string['resume_deletecertifconfirm'] = '本当にこ証明、認定および受賞を削除してもよろしいですか?';
$string['resume_deleteeduconfirm'] = '本当にこの学歴を削除してもよろしいですか?';
$string['resume_deleteemployconfirm'] = '本当にこの職歴を削除してもよろしいですか?';
$string['resume_deletelinkedinconfirm'] = '本当にこの会員歴を削除してもよろしいですか？';
$string['resume_deletembrshipconfirm'] = '本当にこの会員歴を削除してもよろしいですか?';
$string['resume_deletepublicconfirm'] = '本当にこの書籍および出版物を削除してもよろしいですか?';
$string['resume_description'] = '説明';
$string['resume_edu'] = '教育';
$string['resume_edudeleted'] = '学歴は削除されました';
$string['resume_eduhistory'] = '学歴';
$string['resume_edusaved'] = '学歴は削除されました';
$string['resume_employ'] = '職業';
$string['resume_employdeleted'] = '職歴は削除されました';
$string['resume_employer'] = '勤務先';
$string['resume_employeraddress'] = '勤務先住所';
$string['resume_employhistory'] = '職歴';
$string['resume_employsaved'] = '職歴が保存されました。';
$string['resume_enddate'] = '終了日';
$string['resume_expand'] = 'すべてを展開する';
$string['resume_exportto_europass'] = 'Europassにエクスポートする';
$string['resume_exportto_europass_getXML'] = 'XMLをダウンロードする';
$string['resume_exportto_europass_intro'] = '<p>Europassのプロフィールは、学習やキャリア展開を計画する際に役立ちます。このプロフィールは、雇用主、ボランティア団体、採用担当者、ガイダンス実施者、青少年団体、教育・訓練機関などの組織が、人々に提供するサポートやサービスの一環として使用することができます。
        <p>Exabis eポートフォリオの履歴書をユーロパスのプロフィールで使用する方法があります。<br>
            生成されたXMLファイルを<a href="https://europa.eu/europass/eportfolio/screen/cv-editor?lang=en" target="_blank">履歴書を作成する</a><br>ページに挿入する必要があります。
            (Europassにログインしていることが望ましい)<br>
            Europass履歴書の"インポート ボタン"を押してXMLファイルをアップロードします。
 </p>

    注意事項:<br>
    <ul>
        <li>完成した履歴書は必ずチェックしてください。</li>
        <li>個人情報はあなたのMoodleアカウントから取得されます。</li>
        <li>すべての日付、電話番号、住所を確認してください。</li>
        <li>HTMLエディタからの画像はエクスポートされません。</li>
        <li>ほとんどのHTMLエディタからテキストは再度フォーマット設定が必要です。</li>
        <li>添付ファイルは新バージョンのEuropassには実装されていないため、インポートされません。</li>
    </ul>';
$string['resume_files'] = '添付';
$string['resume_goals'] = 'ゴール';
$string['resume_goalsacademic'] = 'アカデミックゴール';
$string['resume_goalsacademicsaved'] = 'アカデミックゴールは保存されました。';
$string['resume_goalscareers'] = 'キャリアゴール';
$string['resume_goalscareerssaved'] = 'キャリアゴールは保存されました。';
$string['resume_goalscomp'] = '教育水準';
$string['resume_goalspersonal'] = 'パーソナルゴール';
$string['resume_goalspersonalsaved'] = 'パーソナルゴールは保存されました。';
$string['resume_institution'] = '機関';
$string['resume_institutionaddress'] = '機関の住所';
$string['resume_interests'] = '興味のあること';
$string['resume_interestssaved'] = '興味のあることは保存されました。';
$string['resume_jobtitle'] = '職名';
$string['resume_linkedin'] = 'LinkedInプロフィール';
$string['resume_linkedindeleted'] = 'LinkedInのプロフィールを削除';
$string['resume_linkedinsaved'] = 'LinkedInのプロフィールを保存';
$string['resume_mbrship'] = '資格';
$string['resume_mbrshipdeleted'] = '会員資格は削除されました。';
$string['resume_mbrshipsaved'] = '会員資格は保存されました。';
$string['resume_my'] = 'マイレジュメ';
$string['resume_mygoals'] = 'マイゴール';
$string['resume_myskills'] = 'マイスキル';
$string['resume_position'] = 'ポジション';
$string['resume_positiondescription'] = 'ポジション説明';
$string['resume_public'] = '書籍および出版物';
$string['resume_publicdeleted'] = '書籍および出版物は削除されました。';
$string['resume_publicsaved'] = '書籍および出版物は保存されました。';
$string['resume_qualdescription'] = '資格説明';
$string['resume_qualification'] = '資格';
$string['resume_qualname'] = '資格名';
$string['resume_qualtype'] = '資格タイプ';
$string['resume_skills'] = 'スキル';
$string['resume_skillsacademic'] = 'アカデミックスキル';
$string['resume_skillsacademicsaved'] = 'アカデミックスキルは保存されました。';
$string['resume_skillscareers'] = 'キャリアスキル';
$string['resume_skillscareerssaved'] = 'キャリアスキルは保存されました。';
$string['resume_skillscomp'] = '教育水準';
$string['resume_skillspersonal'] = 'パーソナルスキル';
$string['resume_skillspersonalsaved'] = 'パーソナルスキルは保存されました。';
$string['resume_startdate'] = '開始日';
$string['resume_template_newresume'] = '<h2>新しいマイレジュメ</h2>';
$string['resume_title'] = 'タイトル';
$string['resume_url'] = 'URL';
$string['role'] = 'ロール';
$string['root_category'] = 'ルートカテゴリ';
$string['saveButton'] = '保存';
$string['saveitem'] = '保存';
$string['scormhastobezip'] = 'SCORMファイルは.zipファイルである必要があります。';
$string['searchByTitle'] = '検索';
$string['selectall'] = 'すべてを選択する';
$string['selectcomps'] = 'あなたがアップロードしたものと関連づけられるコンピテンシーを選んでください。';
$string['selected_competencies'] = '達成されたコンピテンシー';
$string['selectitems'] = 'アイテムを選択してください。';
$string['settings_allow_loginas_head'] = '別のユーザとしてログインすることを許可する';
$string['settings_create_desp_categories_head'] = 'Despカテゴリを作成します。';
$string['settings_disable_externaccess_head'] = 'ビューの共有オプション「外部アクセス」を無効にする';
$string['settings_disable_external_comments_head'] = '外部ビューでコメントの共有を無効にする。';
$string['settings_disable_shareall_body'] = 'グローバル共有を削除するためには<a href="{$a}">ここ</a>,をクリックしてください。';
$string['settings_disable_shareall_head'] = 'すべてのユーザとの共有を無効にする。';
$string['settings_disable_shareemails_head'] = 'ビューの共有オプション「メールで共有」を無効にする';
$string['settings_interaktion_exacomp_body'] = 'exabis コンピテンシーブロックとの相互利用※インストールされている場合';
$string['settings_interaktion_exacomp_head'] = 'exabis eポートフォリオ － exabis コンピテンシー相互利用';
$string['settings_layout_settings_description'] = 'ここでは、ビューのレイアウトオプションを変更したり、独自のCSSを使用して、お好みのビューにすることができます。<br>これらのビューは<strong>すべてのビュー</strong>のデフォルト設定として使用されます。';
$string['settings_layout_settings_heading'] = 'レイアウト設定';
$string['share'] = '共有する';
$string['share_to_other_users'] = 'マイコース内ではない他のユーザと共有します。';
$string['shareallexceptthose'] = '以下のユーザを除く<span class=\'block_eportfolio_bold\'>すべてのユーザ</span> (ここにリストされていないものも含む) のアクセス';
$string['sharedArtefacts'] = 'あなたと共有されたグループポートフォリオ';
$string['shared_categories'] = 'カテゴリの共有';
$string['shared_views'] = 'ビューの共有';
$string['shareditems_category'] = 'あなたと共有されたグループポートフォリオ';
$string['sharedpersons'] = 'ポートフォリオを共有している人々';
$string['sharedwith'] = '共有';
$string['sharedwith_group'] = 'マイグループと共有';
$string['sharedwith_group_cnt'] = '{$a} グループと共有';
$string['sharedwith_onlyme'] = '私とのみ共有';
$string['sharedwith_shareall'] = 'すべてのユーザと共有';
$string['sharedwith_shareexternal'] = '外部と共有';
$string['sharedwith_user_cnt'] = '{$a} と共有';
$string['sharejs'] = '共有';
$string['sharenoneexceptthose'] = '以下のユーザを除く <span class=\'block_eportfolio_bold\'>誰</span> からもアクセスされない';
$string['sharetoteacher'] = 'このコース全ての教師と共有します。';
$string['show'] = '表示します';
$string['show_mystudents'] = '生徒たち';
$string['show_sharedbyuser'] = 'ユーザーによる共有';
$string['showall'] = '他のコースも表示します。';
$string['showallusers'] = 'すべてのマイコースのユーザを表示します。';
$string['showcourse'] = 'このコースのみ表示します。';
$string['showcourseusers'] = 'コースのユーザのみ表示します。';
$string['showsummary'] = '(概要を表示)';
$string['steckbrief'] = 'プロファイル';
$string['strshare'] = '共有';
$string['strunshare'] = '共有しない';
$string['studentcomps'] = 'あなたのアーティファクトからコンピテンシーを獲得したかどうかを自己評価します。';
$string['subcategory'] = 'サブカテゴリ';
$string['submititem'] = '投稿';
$string['success'] = 'ファイルインポートが成功しました。';
$string['summary'] = '概要(オプション)';
$string['supported'] = 'supported by';
$string['tagarea_block_exaportitem'] = '私の成果物';
$string['teachercomps'] = '学生がこのアーティファクトでコンピテンシーを獲得できたかを評価します。';
$string['thiscourse'] = 'このコース';
$string['tiles'] = 'タイル';
$string['title'] = 'タイトル';
$string['titlenotemtpy'] = 'タイトルを入力する必要があります。';
$string['translation:email'] = 'kagoya@gmail.com';
$string['translation:language'] = '日本語';
$string['translation:organisation'] = 'Jindai';
$string['translation:person'] = 'Takahiro KAGOYA';
$string['type'] = 'タイプ';
$string['unknownaction'] = '不明な操作';
$string['updateposterror'] = 'データベースでこの投稿を更新する際にエラーが発生しました。';
$string['updownarrow'] = '上下の矢印';
$string['uploadfailed'] = 'アップロードに失敗しました。';
$string['url'] = 'URL';
$string['urlnotempty'] = 'URLを入力する必要があります。';
$string['userdefinedsort'] = '独自の検索を定義してください。';
$string['view'] = 'ビュー';
$string['view_preview_help'] = 'ビューをプレビューする';
$string['view_preview_help_title'] = 'プレビュー';
$string['view_saved'] = 'ビューを保存する';
$string['view_sharing'] = '共有中';
$string['view_sharing_noaccess'] = 'アクセスがありません';
$string['view_sharing_updated'] = '共有されたビューを更新';
$string['view_specialitem_badge'] = 'バッジ';
$string['view_specialitem_headline'] = 'ヘッドライン';
$string['view_specialitem_headline_defaulttext'] = 'ここにヘッドラインを入力してください。';
$string['view_specialitem_media'] = 'メディア';
$string['view_specialitem_personal'] = '個人情報';
$string['view_specialitem_text'] = 'テキスト';
$string['view_specialitem_text_defaulttext'] = 'ここにテキストを入力してください。';
$string['view_specialitem_text_help'] = 'テキストを必要に応じて追加';
$string['view_specialitems'] = '特別アイテム';
$string['viewand'] = 'と';
$string['viewcategories'] = 'カテゴリを管理';
$string['viewcontent'] = 'コンテンツ';
$string['viewdescription'] = '説明';
$string['viewdesign'] = 'ビューの設計';
$string['viewinformation'] = 'ビュー情報';
$string['viewitem'] = 'アイテム';
$string['viewitems'] = 'あなたのアイテム';
$string['viewlayout'] = 'レイアウト';
$string['viewlayout1'] = '等幅';
$string['viewlayout10'] = '等幅';
$string['viewlayout2'] = '等幅';
$string['viewlayout3'] = '左の列が広い';
$string['viewlayout4'] = '右の列が広い';
$string['viewlayout5'] = '等幅';
$string['viewlayout6'] = '中央の列が広い';
$string['viewlayout7'] = '中央の列がとても広い';
$string['viewlayout8'] = '等幅';
$string['viewlayout9'] = '中央の列が広い';
$string['viewlayoutgroup1'] = '1列';
$string['viewlayoutgroup2'] = '2列';
$string['viewlayoutgroup3'] = '3列';
$string['viewlayoutgroup4'] = '4列';
$string['viewlayoutgroup5'] = '5列';
$string['viewnotfound'] = 'ビューが見つかりませんでした。';
$string['views'] = 'ビュー';
$string['viewshare'] = '共有';
$string['viewtitle'] = 'タイトルと説明';
$string['what_is_embed_code_content'] = '<p>埋め込みコードは、YouTubeやTwitterなどのサードパーティのウェブサイトによって生成されるコードで、ユーザーがコピーして自分のウェブページに貼り付けることができます。この埋め込みコードは、元のソースと同じメディア、アプリケーション、またはフィードをユーザーのウェブページに表示します。</p>
            <p>私たちが提供するのは、YouTube や Vimeo などの最も普及している動画ベンダーのインストラクションです。</p>
            <p><strong>YouTubeで埋め込みコードを見つける：</strong></p>
            <ol>
                <li>YouTubeにアクセスします</a></li>.
                <li>埋め込みたい動画に移動します</li>
                <li>動画の下にある<strong>共有リンク</strong>をクリックし、次に<strong>埋め込みリンク</strong>をクリックします</li>。
                <li>開いたウィンドウのフッターにある<strong>コピー</strong>ボタンを押します</li>。
                <li>埋め込みリンクが青くハイライトされ、クリップボードにコピーされます。</li>
                <li>E-portfolio textareaフィールドにコードを貼り付けます。
            </ol>
            <p><strong>Vimeoで埋め込みコードを見つける:</strong></p>
            <ol>
                <li>Vimeoにアクセスします。</li>
                <li>埋め込みたい動画に移動します。</li>
                <li>動画の右上にある<strong>共有</strong>ボタンをクリックします。</li>
                <li>埋め込みリンク情報のポップアップが表示されます。埋め込みリンクの <strong>&lt;<i>iframe</i>&gt;</strong> 部分のみをコピーする必要があります。
                    例:<br>
                    <ol>
                        <li>
                            埋め込みリンク全体は次のように表示されます:<br>。
                  <textarea disabled=\'true\' style=\'border: none;background-color:white;width:100%;font-size:0.75em;\'>&lt;iframe src=&quote;https://player.vimeo.com/video/1233456789&quote; width=&quote;640&quote; height=&quote;360&quote; frameborder=&quote;0&quote; allow=&quote;autoplay; fullscreen&quote; allowfullscreen&gt;&lt;/iframe&gt;&lt;p&gt;&lt;a href=&quote;https://vimeo.com/1233456789&quote;&gt;1- Automation Opening[2]&lt;/a&gt; from &lt;a href=&quote;https://vimeo.com/user98765432&quote;&gt;R1 Marketing&lt;/a&gt; on &lt;a href=&quote;https://vimeo.com&quote;&gt;Vimeo&lt;/a&gt;.&lt;/p&gt;</textarea>
                        </li>
                        <li>
                            <strong>&lt;<i>iframe</i>&gt;</strong>部分をコピーするだけです:<br>
                            <textarea disabled=\'true\' style=\'border: none;background-color:white;width:100%;font-size:0.75em;\'>&lt;iframe src=&quote;https://player.vimeo.com/video/1233456789&quote; width=&quote;640&quote; height=&quote;360&quote; frameborder=&quote;0&quote; allow=&quote;autoplay; fullscreen&quote; allowfullscreen&gt;&lt;/iframe&gt;</textarea>
                        </li>
                    </ol>
                <li>このコードをポートフォリオのテキストエリア欄に貼り付けてください</li>
            </ol>';
$string['what_is_embed_code_title'] = '埋め込みコードとは？';
$string['whyEportfolio'] = 'eポートフォリオの重要性';
$string['whyEportfolio_description'] = '<h4>あなたの努力を無駄にしないで！デジタルポートフォリオを作成しよう</h4>
                <br>
                <p>課題、プレゼンテーション、プロジェクトに費やした努力。提出した後、それらのが引き出しの中に埋もれてしまっていると感じたことはありませんか？</p>
                <p>しかし、その成果物は <strong>あなたのスキルや知識を証明する重要な資産です。</strong>それをうまく活用すれば、就職活動やクライアントへのアピールに役立ちます</p>
                <p><strong>デジタルポートフォリオを作成することで</strong> これまでの成果物をまとめて一元管理し、自分の強みを簡単に紹介できるようになります。あなたが思うより簡単に始められます！</p>
                <br>
                <h4>ePortfolioとは？</h4>
                <br>
                <p><strong>ePortfolio</strong> (electronic portfolio)とは<strong>スキルや経験</strong> をまとめた<strong>デジタルの作品集です。</strong>.
                    履歴書では学歴や職歴に焦点をあてている一方、ePortfolioは<strong>具体的な成果物</strong>を通じて、あなたの能力をより深く理解してもらうためのツールです。
                    自分が<strong>どんなスキルを持っていてどんな仕事ができるか</strong>を実際の成果物を通じて見せられるため<strong>あなたの強み</strong>をもっと効果的にアピールできます。
                </p>
                <p><strong>応募する職種や役割に応じて見せる内容を変えなければならない</strong>
                    場合もありますが
                    <strong>Exabis ePortfolio</strong>を使用すれば特定の職種や機会に合わせて
<strong>複数のビューを作成する</strong>ことが可能です。
                </p>
                <br>
                <h4>ePortfolioの作り方</h4>
                <br>
                <ol>
                    <li><strong>成果物を集める</strong>: これまでに取り組んだプロジェクト、プレゼンテーション、課題を振り返り、必要な資料を整理します。</li>
                    <li><strong>優れた作品を選ぶ</strong>: 自身のスキルを最もよく示しているものや、高く評価された成果物を選び出します。</li>
                    <li><strong>説明を加える</strong>: 各成果物が示しているスキルや能力について簡潔にまとめた説明文を添え、背景や意図を明確にします。</li>
                    <li><strong>作成と改善を繰り返す</strong>: 最初はシンプルに作成して構いません。成長に合わせて内容を見直し、より洗練されたポートフォリオに仕上げていきましょう。</li>
                </ol>
                <p><strong>Exabis ePortfolio</strong>はこれらのプロセスをサポートし、効率的にeポートフォリオを作成するお手伝いをします。
あなたの努力を最大限に活かし、効果的にアピールできるポートフォリオを作成してみませんか？</p>';
$string['width'] = '幅';
$string['wrongfileid'] = 'ファイルidが正しくありません。';
$string['wrongfilepostid'] = 'ファイルidが正しくありません。';
$string['wronglinkid'] = 'リンクidが正しくありません。';
$string['wrongnoteid'] = 'ノートidが正しくありません。';
$string['wrongnotepostid'] = 'ノートpostidが正しくありません。';
