<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_shoehorn', language 'af', version '4.4'.
 *
 * @package     theme_shoehorn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accordion'] = 'Gebruik konsertina-kantblokareas';
$string['accordion_desc'] = 'Ontsper hierdie opsie om konsetina-funksionaliteit vir die kantareas te gebruik. Let wel: Versper ankering.';
$string['always'] = 'Altyd';
$string['antigravity'] = 'Terug na Bo';
$string['blocktitleunknown'] = 'Bloktitel Onbekend';
$string['cdnfonts'] = 'Netwerkfonte vir inhoudaflewering waar moontlik';
$string['cdnfonts_desc'] = 'Gebruik Netwerkfonte vir inhoudaflewering waar moontlik. Dus is \'n CDN-bron beskikbaar.';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Shoehorn</h2>
<p><img class="img-polaroid" src="shoehorn/pix/Shoehorn_logo.png" /></p>
</div>
<div class="well">
<h3>Inligting oor</h3>
<div class="lead"><p>Shoehorn is \'n Bootstrap w3-gebaseerde tema met vele innoverende funksies:</p>
<ul>
<li>Aangepaste kopieregverklaring.</li>
<li>Aangepaste intekenbladboodskap.</li>
<li>Dinamiese en doelmaakbare onderskrifkieslys.</li>
<li>Dinamiese sosiale ikoontekens met korrekte ikoonkleure.</li>
<li>Voorbladglyer wat op mobiele toestelle / tablette versper kan word om bandwydte te verminder.</li>
<li>Onderskrifblokke.</li>
<li>Prentebank vir die berg van prente wat jy op enige plek op die werf kan gebruik.</li>
<li>Individuele beheer oor: voorbladglyers, bemarkingsplekke en werfbladsye met:</li>
<ul>
<li>\'Proef\' / \'Gepubliseerde\' toestand.</li>
<li>\'voor intekening\', \'ná intekening\' of \'altyd\' sigbaarheid.</li>
<li>Stel slegs spesifieke taal-sigbaarheid.</li>
</ul><li>Bemarkingsplekke.</li>
<li>Bladsyonderkantblokke.</li>
<li>Werfbladsye wat jy met jou eie inhoud kan doelmaak.</li>
<li>Glyernavigasie van kursusinhoud met die \'Een afdeling per bladsy\' kursusuitlegverstelling.</li>
</ul>
<h3>Moeder</h3>
<p>Hierdie tema is op die Bootstrap-tema gebaseer, wat vir Moodle 2.6 geskep is deur: Bas Brands, David Scotson en etlike ander bydraers.</p>
<h3>Temakrediete</h3>
<p>Outeur: G J Barnard - <a href="//about.me/gjbarnard" target="_blank">About.me</a> - <a href="//moodle.org/user/profile.php?id=442195">Moodle-profiel</a> - <a href="//uk.linkedin.com/in/gjbarnard">Linkedin</a></p>
<h3>Borgskappe</h3>
<p>Hierdie tema word gratis aan jou verskaf en as jy jou dankbaarheid vir die gebruik daarvan wil betoon, oorweeg asseblief \'n skenking deur:
<h4>PayPal</h4>
<p>Kontak my asseblief via my <a href="http://moodle.org/user/profile.php?id=442195" target="_blank">\'Moodle-profiel\'</a> vir besonderhede, aangesien ek \'n individu is en dus kragtens hul bepalings kan nie \'koop my nou\'-knoppies hê nie.</p>
<h4>Flattr</h4>
<a href="https://flattr.com/profile/gjb2048" target="_blank">
kliek hier om te borg.
</a>
<br>Borgskappe kan my in staat stel om jou van meer of beter funksies in \'n korter tydperk te verskaf.</p>
<h3>Rapporteer \'n fout:</h3>
<p><a href="//github.com/gjb2048/moodle-theme_shoehorn/issues">Shoehorn-probleme.</a></p>
<h3>Meer inligting</h3>
<p><a href="shoehorn/Readme.md">Hoe om hierdie tema te gebruik.</a></p>
<h3>Doelmaking</h3>
<p>As jy van hierdie tema hou en wil hê dat ek dit doelmaak, funksionaliteit na \'n ander tema transponeer, of \'n nuwe tema van voor af bou, bied ek mededingende tariewe. Kontak my asseblief via \'www.gjbarnard.co.uk/contact/\' of \'gjbarnard at gmail dot com\' of \'about.me/gjbarnard\' om jou vereistes te bespreek.</p>
</div></div>';
$string['compactnavbar'] = 'Kompakte navstafie';
$string['compactnavbar_desc'] = 'Kompakte navigasiestafie';
$string['configtitle'] = 'Shoehorn';
$string['copyright'] = 'Kopiereg';
$string['copyright_desc'] = 'Kopieregstelling, laat blanko vir geen.';
$string['coursecontentsearch'] = 'Kursusinhoudsoektog';
$string['coursecontentsearchdesc'] = 'Ontsper kursusinhoudsoektog op die \'Paneelbord\'-blad. Werk slegs wanneer Shoehorn nie in \'\\$CFG->themedir\' is nie.';
$string['coursetiles'] = 'Gebruik kursusteëls';
$string['coursetiles_desc'] = 'Gebruik kursusteëls vir aktiwiteite en hulpbronne.';
$string['credit'] = 'Die Shoehorn-tema vir Moodle is ontwikkel en word onderhou deur';
$string['customcss'] = 'Doelgemaakte CSS';
$string['customcss_desc'] = 'Watter CSS-reëls jy ook al by hierdie teksarea voeg, sal op elke bladsy weerspieël word, wat die doelmaak van hierdie tema vergemaklik.';
$string['displaymycourses'] = 'Vertoon my kursusse';
$string['displaymycourses_desc'] = 'Vertoon jou kursusse op \'My Tuisblad\'.';
$string['displaymycoursesmenu'] = 'Vertoon my kursusse-kieslys';
$string['displaymycoursesmenu_desc'] = 'Vertoon die my kursusse-kieslys op die navigasiestafie met die gegewe titel.';
$string['docking'] = 'Gebruik ankering';
$string['docking_desc'] = 'Ontsper hierdie opsie om ankering te gebruik.';
$string['draft'] = 'Proef';
$string['editonmainpage'] = 'Wysig asseblief op die hoofkursusblad';
$string['eightyfivepercent'] = '85%';
$string['eightypercent'] = '80%';
$string['enter'] = 'Voer in';
$string['fifteenpercent'] = '15%';
$string['fiftypercent'] = '50%';
$string['fifyfivepercent'] = '55%';
$string['findcoursecontent'] = 'Kursusinhoud:';
$string['fitvids'] = 'Gebruik FitVids';
$string['fitvidsdesc'] = 'Ontsper FitVids (fitvidsjs.com) om jou vasgelegde video\'s responsief te maak. As FitVids aan is en jy wil \'n video laat uitsluit, voeg dan \'class="fitvidsignore"\' by die \'iframe\'-merker in die HTML-modus van die wysiger. Byvoorbeeld: \'iframe class="fitvidsignore" width="420" height="315" src="//www.youtube.com/embed/enmEmym85xc" frameborder="0" allowfullscreen=""></iframe\'.';
$string['fivepercent'] = '5%';
$string['fontawesome'] = 'Gebruik die FontAwesome-ikoonfont';
$string['fontawesome_desc'] = 'Ontsper hierdie opsies om die FontAwesome-ikoonfont te gebruik.';
$string['fontfileeotbody'] = 'Teks EOT fontdokument';
$string['fontfileeotheading'] = 'Opskrif EOT fontdokument';
$string['fontfileotfbody'] = 'Teks OTF fontdokument';
$string['fontfileotfheading'] = 'Opskrif OTF fontdokument';
$string['fontfilesvgbody'] = 'Teks SVG fontdokument';
$string['fontfilesvgheading'] = 'Opskrif SVG fontdokument';
$string['fontfilettfbody'] = 'Teks TTF fontdokument';
$string['fontfilettfheading'] = 'Opskrif TTF fontdokument';
$string['fontfilewoffbody'] = 'Teks WOFF fontdokument';
$string['fontfilewoffheading'] = 'Opskrif WOFF fontdokument';
$string['fontfilewofftwobody'] = 'Teks WOFF2 fontdokument';
$string['fontfilewofftwoheading'] = 'Opskrif WOFF2 fontdokument';
$string['fontheadingdesc'] = 'Kies en voer die fonte in wat jy in jou Moodle-omgewing wil gebruik.';
$string['fontheadingsub'] = 'Fontverstellings';
$string['fontnamebody'] = 'Teksfont';
$string['fontnamebodydesc'] = 'Voer die presiese naam in van die font om vir alle ander teks te gebruik.';
$string['fontnameheading'] = 'Opskriffont';
$string['fontnameheadingdesc'] = 'Voer die presiese naam in van die font om vir opskrifte te gebruik.';
$string['fontsettings'] = 'Font';
$string['footerbottomcolour'] = 'Onderskrif se onderkant';
$string['footerbottomcolourdesc'] = 'Kleur van Onderskrif se onderkant';
$string['footermenu'] = 'Onderskrifkieslys';
$string['footermenu_desc'] = 'Nul of meer lyne wat die skakels voorstel wat in die onderskrifkieslys geplaas moet word.<br>
Vorm van naam|url|titel|taal waar titel en taal opsioneel is.<br>
As die url voorafgegaan word deur [[site]] sal die werfdomein vervang word, d.w.s. [[site]]/about.html word http://mymoodle/about.html of http://mymoodle/subfolder/about.html as Moodle in \'n sublêer op jou domein is.<br>
Die titel is die teks wat vertoon word wanneer daar oor die skakel gesweef word.<br>
Die taal is om slegs in hierdie taal te vertoon.<br>
Byvoorbeeld:<br>
About|http://mywebsite/about.html|About my site<br>
About|[[site]]/about.html|About my site<br>
Anleitung|http://mymoodle/anleitung.html|Wie man mit dieser Website verwenden.|de<br>
Home|//mymoodle/index.php';
$string['footertextcolour'] = 'Onderskrifteks';
$string['footertextcolourdesc'] = 'Kleur van Onderskrifteks';
$string['footertopcolour'] = 'Onderskrif se bokant';
$string['footertopcolourdesc'] = 'Kleur van Onderskrif se bokant';
$string['fortyfivepercent'] = '45%';
$string['fortypercent'] = '40%';
$string['four'] = 'Vier';
$string['frontpagenumberofslides'] = 'Aantal voorbladskyfies';
$string['frontpagenumberofslides_desc'] = 'Aantal skyfies op die voorbladglyer.';
$string['frontpageslidecaptiontext'] = 'Skyfie {$a->slide} byskrifteks';
$string['frontpageslidecaptiontext_desc'] = 'Die opskrifteks van skyfie {$a->slide}';
$string['frontpageslidecaptiontitle'] = 'Skyfie {$a->slide} byskriftitel';
$string['frontpageslidecaptiontitle_desc'] = 'Die byskriftitel vir skyfie {$a->slide}';
$string['frontpageslidedisplay'] = 'Skyfie {$a->slide} status';
$string['frontpageslidedisplay_desc'] = 'Wanneer om skyfie {$a->slide} te vertoon.';
$string['frontpageslideimage'] = 'Skyfie {$a->slide} prent';
$string['frontpageslideimage_desc'] = 'Die prent van skyfie {$a->slide}';
$string['frontpageslidelang'] = 'Skyfie {$a->slide} taal';
$string['frontpageslidelang_desc'] = 'Skyfietaalnommer {$a->slide}. Om meer tale te sien, installeer taalpakkette op \'{$a->url}\'. Stel op \'alle\' vir alle tale.';
$string['frontpagesliderheading'] = 'Voorbladglyer';
$string['frontpagesliderheadingdesc'] = 'Vertoon jou portefeulje met skyfies wat \'n prent, URL en teks bevat. Om die aantal skyfies te verander, verander die \'Aantal voorbladskyfies\' hieronder en berg die bladsy om by te werk. Die beste hoogte vir \'n prent is 500 px, aangesien dit die maksimum spasie teen meer as 1200 px breë vensterresolusie is. Die dimensies word dan bereken gebaseer op die beskikbare spasie- en prent-verhouding.';
$string['frontpagesliderheadingsub'] = 'Vertoon jou portefeulje met skyfies op die voorblad';
$string['frontpageslidermobile'] = 'Vertoon voorbladglyer op mobiele toestelle';
$string['frontpageslidermobile_desc'] = 'Vertoon die voorbladglyer op mobiele toestelle.';
$string['frontpageslidersettingspageheading'] = 'Skyfie {$a->slide}';
$string['frontpagesliderspeed'] = 'Stel die skyfie-oorgangspoed in ms';
$string['frontpagesliderspeed_desc'] = 'Stel die skyfie-oorgangspoed in millisekondes. Stel op 0 vir beheer per hand.';
$string['frontpageslidertablet'] = 'Vertoon voorbladglyer op tablet';
$string['frontpageslidertablet_desc'] = 'Vertoon die voorbladglyer op tablettoestelle.';
$string['frontpageslidestatus'] = 'Skyfie {$a->slide} status';
$string['frontpageslidestatus_desc'] = 'Stel na \'Proef\' wanneer jy die skyfie skep en \'Gepubliseer\' wanneer jy dit sigbaar wil maak. Hou die vertoon- en taalverstellings in gedagte.';
$string['frontpageslideurl'] = 'Skyfie {$a->slide} URL';
$string['frontpageslideurl_desc'] = 'Die URL van skyfie {$a->slide}';
$string['generalsettings'] = 'Algemeen';
$string['gotobottom'] = 'Gaan na onderkant van die bladsy';
$string['iewarning'] = 'Shoehorn vereis Internet Explorer 10+, jy gebruik tans IE{$a->ieversion}, gradeer asseblief op.';
$string['imagebankheading'] = 'Prentebank';
$string['imagebankheadingdesc'] = 'Om die aantal beskikbare prente in die prentebank te verander, verander die \'Aantal prente in die prentebank\' hieronder en berg die bladsy om by te werk.';
$string['imagebankheadingsub'] = 'Gebruik prente op enige plek deur die prentebank te gebruik.';
$string['imagebankimage'] = 'Prent';
$string['imagebankimage_desc'] = 'Prent-URL om te kopieer: \'{$a->imagedesc}\' en gebruik, m.a.w. voeg \'n HTML-wysiger in.';
$string['inversenavbar'] = 'Ruil navstafie om';
$string['inversenavbar_desc'] = 'Ruil teks en agtergrond van die navstafie boaan die bladsy.';
$string['landfallhorizontalquiz'] = 'Horisontale uitleg';
$string['landfallhorizontalquiz_desc'] = 'Stel die vasvra om \'n horisontale uitleg te hê.';
$string['landfallpages'] = 'Alle bladsye';
$string['landfallpages_desc'] = 'Alle bladsye voorkoms-en-gevoelverstellings behalwe die voorkant.';
$string['landfallpagesbackgroundimage'] = 'Alle bladsye agtergrondprent';
$string['landfallpagesbackgroundimage_desc'] = 'Stel alle bladsye agtergrondprent.';
$string['landfallpagescontenttransparency'] = 'Alle bladsye inhouddeursigtigheid';
$string['landfallpagescontenttransparency_desc'] = 'Stel alle bladsye se inhouddeursigtigheid.';
$string['landfcolours'] = 'Kleure';
$string['landfcolours_desc'] = 'Kleurverstellings';
$string['landffontpage'] = 'Voorblad';
$string['landffontpage_desc'] = 'Voorblad voorkoms-en-gevoelverstellings.';
$string['landffrontpagebackgroundimage'] = 'Voorblad agtergrondprent';
$string['landffrontpagebackgroundimage_desc'] = 'Stel die voorblad se agtergrondprent.';
$string['landffrontpagecontenttransparency'] = 'Voorblad inhouddeursigtigheid';
$string['landffrontpagecontenttransparency_desc'] = 'Stel die voorblad se inhouddeursigtigheid.';
$string['landfheading'] = 'Voorkoms-en-gevoelverstellings';
$string['landfheadingdesc'] = 'Verander verskeie aspekte van die voorkoms en gevoel met hierdie verstellings.';
$string['landfheadingsub'] = 'Verander verskeie apsekte met hierdie voorkoms-en-gevoelverstellings.';
$string['landflayout'] = 'Uitleg';
$string['landflayoutbutton'] = 'Blok, Inhoud, Blok';
$string['landflayoutdesc'] = 'Uitlegvolgorde. Tweede blokarea slegs as in \'config.php\' gespesifiseer.';
$string['landflayoutheading_desc'] = 'Uitlegverstellings';
$string['landflayoutstep'] = 'Inhoud, Blok, Blok';
$string['landfquiz'] = 'Vasvra';
$string['landfquiz_desc'] = 'Vasvra voorkoms-en-gevoelverstellings';
$string['langpack_urlname'] = 'Taalpakkette';
$string['linkcolour'] = 'Skakel';
$string['linkcolourdesc'] = 'Skakelkleur';
$string['loggedin'] = 'Ingeteken';
$string['loggedinas'] = 'Jy is ingeteken as \'n \'{$a}\', keer terug na my normale rol';
$string['loggedout'] = 'Uitgeteken';
$string['loginbackgroundchangerfade'] = 'Stel die prentoorgang-doof in ms';
$string['loginbackgroundchangerfade_desc'] = 'Stel die prentoorgang-doof in millisekondes.';
$string['loginbackgroundchangerheading'] = 'Verander die Intekenblad-agtergrondprent';
$string['loginbackgroundchangerheadingdesc'] = 'Om die aantal prente te verander, verander die \'Aantal prente\' hieronder en berg die bladsy om by te werk.';
$string['loginbackgroundchangerheadingsub'] = 'Maak jou intekenblad anders met veranderende agtergrondprente.';
$string['loginbackgroundchangerimage'] = 'Prent {$a->image}';
$string['loginbackgroundchangerimage_desc'] = 'Die prent {$a->image}';
$string['loginbackgroundchangermobile'] = 'Vertoon agtergrondprent-verandering op mobiele toestelle.';
$string['loginbackgroundchangermobile_desc'] = 'Vertoon die agtergrondprent-verandering op mobiele toestelle.';
$string['loginbackgroundchangernumberofimages'] = 'Aantal prente';
$string['loginbackgroundchangernumberofimages_desc'] = 'Aantal prente op die agtergrondprent-verandering.';
$string['loginbackgroundchangerspeed'] = 'Stel die prentoorgangspoed in ms';
$string['loginbackgroundchangerspeed_desc'] = 'Stel die prentoorgangspoed in millisekondes.';
$string['loginbackgroundchangertablet'] = 'Vertoon agtergrondprentverandering op tablet';
$string['loginbackgroundchangertablet_desc'] = 'Vertoon die agtergrondprentverandering op tablettoestelle.';
$string['loginmessage'] = 'Die intekenboodskap';
$string['loginmessage_desc'] = 'Die kort intekenboodskap wat vertoon word. Laat blanko om die \'theloginmessage\'-taalstring wat in die taaldokument is, te gebruik. Maak waar moontlik gebruik van Moodle se veeltalige funksionaliteit.';
$string['loginpage'] = 'Intekenblad';
$string['loginpage_desc'] = 'Intekenbladverstellings.';
$string['logo'] = 'Logo';
$string['logo_desc'] = 'Laai asseblief jou doelgemaakte logo hier op as jy dit by die hofie wil voeg.<br>
Die prent sal verskaal word en responsief wees om in die spasie te pas wat deur die Bootstrap-style in die<br>
\'page_heading()\' metode van \'core_renderer.php\' daaraan toegewys is. As jy die spasie wil vergroot, pas daardie kode aan.';
$string['marketingspotcontent'] = 'Bemarkingsplek {$a->spot} inhoud';
$string['marketingspotcontent_desc'] = 'Bemarkingsplek getal {$a->spot} inhoud.';
$string['marketingspotdisplay'] = 'Bemarkingsplek {$a->spot} status';
$string['marketingspotdisplay_desc'] = 'Wanneer om bemarkingsplek {$a->spot} te vertoon.';
$string['marketingspotheading'] = 'Bemarkingsplek {$a->spot} opskrif';
$string['marketingspotheading_desc'] = 'Bemarkingsplek getal {$a->spot} opskrif.';
$string['marketingspotlang'] = 'Bemarkingsplek {$a->spot} taal';
$string['marketingspotlang_desc'] = 'Bemarkingsplek taalgetal {$a->spot}. Om meer tale te sien, installeer taalpakkette op \'{$a->url}\'. Stel na \'alle\' vir alle tale.';
$string['marketingspotsettingspageheading'] = 'Bemarkingsplek {$a->spot}';
$string['marketingspotsheading'] = 'Bemarkingsplekke';
$string['marketingspotsheadingdesc'] = 'Om die aantal bemarkingsplekke te verander, verander die \'Aantal bemarkingsplekke\' hieronder en berg die bladsy om by te werk.';
$string['marketingspotsheadingsub'] = 'Adverteer jou werf met bemarkingsplekke';
$string['marketingspotstatus'] = 'Bemarkingsplek {$a->spot} status';
$string['marketingspotstatus_desc'] = 'Stel na \'Proef\' wanneer die jy plek skep en \'Gepubliseer\' wanneer jy wil hê dit moet sigbaar gemaak word. Hou die vertoon- en taalverstellings in gedagte.';
$string['myclasses'] = 'My klasse';
$string['mycourses'] = 'My kursusse';
$string['mymodules'] = 'My modules';
$string['mysubjects'] = 'My onderwerpe';
$string['myunits'] = 'My vakke';
$string['navbarbackgroundcolour'] = 'Navstafieagtergrond';
$string['navbarbackgroundcolourdesc'] = 'Kleur van Navstafieagtergrond';
$string['navbarbordercolour'] = 'Navstafierant';
$string['navbarbordercolourdesc'] = 'Kleur van Navstafierant.';
$string['navbarfixedtop'] = 'Navstafie bo vasgestel';
$string['navbarfixedtop_desc'] = 'Heg die navigasiestafie boaan die bladsy vas.';
$string['navbartextcolour'] = 'Navstafieteks';
$string['navbartextcolourdesc'] = 'Tekskleur van navstafie';
$string['ninetyfivepercent'] = '95%';
$string['ninetypercent'] = '90%';
$string['noenrolments'] = 'Geen huidige inskrywings nie';
$string['none'] = 'geen';
$string['nosectionstoshow'] = 'Geen afdelings om te vertoon nie';
$string['numberofimagebankimages'] = 'Aantal prente in die prentebank';
$string['numberofimagebankimages_desc'] = 'Aantal prente wat jy in die prentebank wil hê.';
$string['numberofmarketingspots'] = 'Aantal bemarkingsplekke';
$string['numberofmarketingspots_desc'] = 'Aantal bemarkingsplekke wat jy wil byvoeg.';
$string['numberofsitepages'] = 'Aantal werfbladsye';
$string['numberofsitepages_desc'] = 'Aantal werfbladsye wat jy wil byvoeg. \'n Skakel sal outomaties by die onderskrifkieslys gevoeg word.';
$string['numberofsociallinks'] = 'Aantal sosiale netwerkskakels';
$string['numberofsociallinks_desc'] = 'Aantal sosiale netwerkskakels wat jy wil byvoeg.';
$string['numpagebottomblocks'] = 'Maksimum aantal blokke per ry in die bladsy se onderkant.';
$string['numpagebottomblocks_desc'] = 'Die maksimum blokke per ry onderaan die bladsy.';
$string['one'] = 'Een';
$string['onehundredpercent'] = '100%';
$string['pagebottomcolour'] = 'Onderaan bladsy';
$string['pagebottomcolourdesc'] = 'Kleur onderaan bladsy';
$string['pageheadertextcolour'] = 'Kleur van bladsy se hofieteks';
$string['pageheadertextcolourdesc'] = 'Kleur van bladsy se hofieteks. Het geen effek wanneer daar \'n agtergrondprent is nie.';
$string['pagenotdisplayedcontent'] = 'Werf bladsynommer {$a->pageid} is nie vir die huidige kriteria gestel nie; vra \'n administrateur om die verstellings van die tema te kontroleer.';
$string['pagenotdisplayedcontentnotitle'] = 'Werf bladsynommer {$a->pageid} het geen titel nie; vra \'n administrateur om die verstellings van die tema te kontroleer.';
$string['pagenotdisplayedcontentnotpublished'] = 'Werf bladsynommer {$a->pageid} is nie gepubliseer nie; vra \'n administrateur om die verstellings van die tema te kontroleer.';
$string['pagenotdisplayedtitle'] = 'Werf bladsynommer {$a->pageid} word nie vertoon nie';
$string['pagetopcolour'] = 'Bladsy se bokant';
$string['pagetopcolourdesc'] = 'Kleur van bladsy se bokant';
$string['people'] = 'Mense';
$string['pluginname'] = 'Shoehorn';
$string['published'] = 'Gepubliseer';
$string['readme_desc'] = 'Kliek asseblief op \'{$a->url}\' vir meer inligting oor Shoehorn.';
$string['readme_title'] = 'Shoehorn-leesmy';
$string['region-footer-post'] = 'Onderskrif regs';
$string['region-footer-pre'] = 'Onderskrif links';
$string['region-page-bottom'] = 'Onderkant van bladsy';
$string['region-side-post'] = 'Regs';
$string['region-side-pre'] = 'Links';
$string['returntosection'] = 'Keer terug na afdeling {$a->section}';
$string['seventyfivepercent'] = '75%';
$string['seventypercent'] = '70%';
$string['showloginmessage'] = 'Vertoon intekenboodskap';
$string['showloginmessage_desc'] = 'Vertoon \'n kort intekenboodskap net onder die \'Teken in\'-titel. Dit het nie ten doel om die \' te vervang nie';
$string['showloginmessage_urllink'] = 'http://docs.moodle.org/27/en/admin/setting/manageauths#Instructions';
$string['showloginmessage_urlname'] = 'intekenaanwysings';
$string['showoldmessages'] = 'Vertoon ou boodskappe';
$string['showoldmessagesdesc'] = 'Vertoon ou boodskappe op die boodskapkieslys';
$string['sitepage'] = 'Werfblad';
$string['sitepagecontent'] = 'Werf {$a->pageid} bladsyinhoud';
$string['sitepagecontent_desc'] = 'Werfbladsynommer {$a->pageid} inhoud';
$string['sitepagedisplay'] = 'Werfblad {$a->pageid} status';
$string['sitepagedisplay_desc'] = 'Wanneer om werfblad {$a->pageid} te vertoon.';
$string['sitepageheading'] = 'Werblad {$a->pageid} opskrif';
$string['sitepageheading_desc'] = 'Werf bladsynommer {$a->pageid} opskrif';
$string['sitepagelang'] = 'Werfblad {$a->pageid} taal';
$string['sitepagelang_desc'] = 'Werfblad taalnommer {$a->pageid}. Om meer tale te sien, installeer taalpakkette by \'{$a->url}\'. Stel na \'alle\' vir alle tale.';
$string['sitepagesettingspageheading'] = 'Werfblad {$a->pageid}';
$string['sitepagesheading'] = 'Werfbladsye';
$string['sitepagesheadingdesc'] = 'Om die aantal bladsye te verander, verander die \'Aantal werfbladsye\' hieronder en berg die bladsy om by te werk.';
$string['sitepagesheadingsub'] = 'Beskryf jou werf met werfbladsye';
$string['sitepagestatus'] = 'Werfblad {$a->pageid} status';
$string['sitepagestatus_desc'] = 'Stel op \'Proef\' wanneer jy die bladsy skep en \'Gepubliseer\' wanneer jy dit sigbaar wil maak; hou die vertoon- en taalverstellings in gedagte.';
$string['sitepagetitle'] = 'Werfblad {$a->pageid} titel';
$string['sitepagetitle_desc'] = 'Werfbladsynommer {$a->pageid} titel';
$string['sixtyfivepercent'] = '65%';
$string['sixtypercent'] = '60%';
$string['socialheading'] = 'Sosiale netwerkwerk';
$string['socialheadingdesc'] = 'Verskaf direkte skakels na jou sosiale netwerke. Om die aantal sosiale netwerke te verander, verander die \'Aantal sosiale netwerkskakels\' hieronder en berg die bladsy om by te werk.';
$string['socialheadingsub'] = 'Versamel volgers deur sosiale netwerkwerk';
$string['socialnetworkicon'] = 'Sosiale netwerkikoon';
$string['socialnetworkicon_desc'] = 'Sosiale netwerkikoonnommer';
$string['socialnetworklink'] = 'Sosiale netwerkskakel';
$string['socialnetworklink_desc'] = 'Sosiale netwerkskakelnommer';
$string['socialsignpost'] = 'Gebruik die naamplaat';
$string['socialsignpost_desc'] = 'Ontsper hierdie opsie om die naamplaat te gebruik om die sosiale ikone te omring.';
$string['styleguide'] = 'Stylgids';
$string['styleguidedesc'] = 'Oorspronklike dokumentasiekode \'{$a->origcodelicenseurl}\' gelisensieer. Holder.js is \'{$a->holderlicenseurl}\' gelisensieer. Addisionele kode \'{$a->thiscodelicenseurl}\' gelisensieer, wat \'n \'{$a->compatible}\' lisensie is. Inhoud \'{$a->contentlicenseurl}\' gelisensieer. Die dokumentasie is vir Moodle-afvoer geformatteer, met bykomende FontAwesome-ikone, waar van toepassing. Addisionele CSS kan gevind word in die dokument \'styleguide/beyonddocs.css\'.  Die \'{$a->overview}\' afdeling is verwyder.';
$string['styleguidesub'] = 'Bootstrap W3.3.6 Stylgids';
$string['syntaxhelpfive'] = 'Byvoorbeeld:';
$string['syntaxhelpfour'] = 'Brush alias';
$string['syntaxhelpone'] = 'Voeg die html \'{$a->html}\' by die kursusopsomming in HTML-modus.';
$string['syntaxhelpseven'] = 'Meer inligting oor';
$string['syntaxhelpsix'] = 'word:';
$string['syntaxhelpthree'] = 'Brush name';
$string['syntaxhelptwo'] = 'Wanneer jy dan wysig (soos met \'n etiket), omring jou kode met \'n \'pre\'-merker en voeg class="brush: alias" by, waar \'alias\' een van die volgende is:';
$string['syntaxhighlight'] = 'Aktiewe sintaksisbeligting';
$string['syntaxhighlight_desc'] = 'Aktiewe sintaksisbeligting in kursusse. \'n Hulpblad sal by die onderskrifkieslys van kursusse gevoeg word.';
$string['syntaxhighlightpage'] = 'Sintaksisbeligting hulp';
$string['syntaxsummary'] = '<pre class="sh"></pre>';
$string['tenpercent'] = '10%';
$string['textcolour'] = 'Teks';
$string['textcolourdesc'] = 'Tekskleur';
$string['theloginmessage'] = 'Teken hier in met jou gebruikersnaam en wagwoord';
$string['thirtyfivepercent'] = '35%';
$string['thirtypercent'] = '30%';
$string['thiscourse'] = 'Hierdie kursus';
$string['three'] = 'Drie';
$string['togglenavigation'] = 'Tokkel navigasie';
$string['twentyfivepercent'] = '25%';
$string['twentypercent'] = '20%';
$string['two'] = 'Twee';
$string['unknownrole'] = 'onbekende rol';
$string['unknownsitepage'] = 'Onbekende werfbladsynommer';
$string['unknownsitepagecontent'] = 'Werfbladsynommer {$a->pageid} is onbekend; vra \'n administrateur om die verstellings van die tema te kontroleer.';
$string['unreadnewnotification'] = 'Nuwe kennisgewing';
$string['userload'] = 'Gebruikerlading';
$string['userloaddesc'] = 'Gebruikerladingsgrafiek';
$string['userloadpostfix'] = 'm';
$string['zeropercent'] = '0%';
