<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'tr', version '4.4'.
 *
 * @package     lesson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Erişim kontrolü';
$string['actionaftercorrectanswer'] = 'Doğru cevaptan sonraki işlem';
$string['actionaftercorrectanswer_help'] = 'Soruya doğru cevap verdikten sonra takip eden sayfalarda 3 seçeneğiniz mevcuttur:

* Normal - Dersin akışın takip etmek
* Görülmemiş bir sayfayı göster - Daha önce görülmemiş sayfaları rastgele sırada gösterilir
* Cevaplanmamış sayfa göster - Cevaplanmamış soruları rastgele sırada gösterilir';
$string['actions'] = 'Eylemler';
$string['activitylink'] = 'Sonraki etkinliğe bağlantı';
$string['activitylink_help'] = 'Dersin sonunda başka bir etkinliğe bağlantı kurmak için, aşaıdaki açılan menüden bir etkinlik seçin';
$string['activitylinkname'] = 'Git {$a}';
$string['activityoverview'] = 'Geçmiş tarihli dersleriniz var';
$string['addabranchtable'] = 'İçerik sayfası ekle';
$string['addanendofbranch'] = 'Dal sonu ekle';
$string['addanewpage'] = 'Yeni sayfa ekle';
$string['addaquestionpage'] = 'Soru sayfası ekle';
$string['addaquestionpagehere'] = 'Bu araya soru sayfası ekle';
$string['addbranchtable'] = 'İçerik sayfası ekle';
$string['addcluster'] = 'Küme ekle';
$string['addedabranchtable'] = 'İçerik sayfası eklendi';
$string['addedanendofbranch'] = 'Dal sonu eklendi';
$string['addedaquestionpage'] = 'Soru sayfası eklendi';
$string['addedcluster'] = 'Küme eklendi';
$string['addedendofcluster'] = 'Küme sonu eklendi';
$string['addendofbranch'] = 'Dal sonu ekle';
$string['addendofcluster'] = 'Küme sonu ekle';
$string['addessay'] = 'Yazılı sorusu sayfası oluşturun';
$string['addmatching'] = 'Eşleştirme soru sayfası oluşturun';
$string['addmultichoice'] = 'Çoktan seçmeli soru sayfası oluşturun';
$string['addnewgroupoverride'] = 'Grup geçersiz kılma ekle';
$string['addnewuseroverride'] = 'Kullanıcı geçersiz kıma ekle';
$string['addnumerical'] = 'Sayısal soru sayfası oluşturun';
$string['addpage'] = 'Bir sayfa ekle';
$string['addshortanswer'] = 'Kısa cevap soru sayfası ekle';
$string['addtruefalse'] = 'Doğru yanlış soru sayfası ekle';
$string['allotheranswers'] = 'Tüm diğer cevaplar';
$string['allotheranswersjump'] = 'Tüm diğer cevaplar için gidilecek sayfa';
$string['allotheranswersscore'] = 'Tüm diğer cevaplar için puan';
$string['allowofflineattempts'] = 'Ders mobil uygulama kullanılarak çevrimdışı denenmesine izin verin';
$string['allowofflineattempts_help'] = 'Etkinleştirilirse, bir mobil uygulama kullanıcısı dersi indirebilir ve çevrimdışı deneyebilir.
Tüm olası yanıtlar ve doğru yanıtlar da indirilecektir.
Not: Bir dersin zaman sınırı varsa çevrimdışı denenmesi mümkün değildir.';
$string['anchortitle'] = 'Ana içeriğin başlangıcı';
$string['and'] = 'VE';
$string['answer'] = 'Cevap';
$string['answeredcorrectly'] = 'doğru cevaplandı.';
$string['answersfornumerical'] = 'Sayısal sorulara verilen cevaplar en yüksek ve en düşük değerler olarak eşleştirilmis çiftler halinde olmalıdır';
$string['arrangebuttonshorizontally'] = 'İçerik düğmelerini yatay yerleştir?';
$string['attempt'] = 'Uygulama: {$a}';
$string['attemptheader'] = 'Deneme(Teşebbüs)';
$string['attemptinfonograde'] = '{$a->timestart} ({$a->duration})';
$string['attemptinfowithgrade'] = '{$a->grade}% {$a->timestart} ({$a->duration})';
$string['attempts'] = 'Uygulamalar';
$string['attemptsdeleted'] = 'Silinen uygulamalar';
$string['attemptsremaining'] = '{$a} uygulama hakkınız kaldı';
$string['available'] = 'Erişilebileceği tarih';
$string['averagescore'] = 'Ortalama not';
$string['averagetime'] = 'Ortalama süre';
$string['branch'] = 'İçerik';
$string['branchtable'] = 'İçerik';
$string['cachedef_overrides'] = 'Kullanıcı ve gruplar i geçersiz kılma bilgileri';
$string['cancel'] = 'İptal';
$string['cannotfindanswer'] = 'Hata: cevap bulunamadı';
$string['cannotfindattempt'] = 'Hata: uygulama bulunamadı';
$string['cannotfindessay'] = 'Hata: yazılı bulunamadı';
$string['cannotfindfirstgrade'] = 'Hata: puanlama bulunamadı';
$string['cannotfindfirstpage'] = 'İlk sayfa bulunamadı';
$string['cannotfindgrade'] = 'Hata: puanlama bulunamadı';
$string['cannotfindnewestgrade'] = 'Hata: en yüksek puanlama bulunamadı';
$string['cannotfindnextpage'] = 'Ders yedekleme: Sonraki sayfa bulunamadı!';
$string['cannotfindpagerecord'] = 'Dal sonu ekle: sayfa kaydı bulunamadı';
$string['cannotfindpages'] = 'Ders sayfaları bulunamadı';
$string['cannotfindpagetitle'] = 'Silme Onayı: sayfa başlığı bulunamadı';
$string['cannotfindpreattempt'] = 'Önceki uygulama kaydı bulunamadı!';
$string['cannotfindrecords'] = 'Hata: ders kayıtları bulunamadı';
$string['cannotfindtimer'] = 'Hata: lesson_timers kayıtları bulunamadı';
$string['cannotfinduser'] = 'Hata: kullanıcılar bulunamadı';
$string['canretake'] = '{$a} tekrar alabilir';
$string['casesensitive'] = 'Düzenli İfadeler Kullan';
$string['casesensitive_help'] = 'Cevapları analiz ederken düzenli ifadeler kullanmak için bu onay kutusunu işaretleyin.';
$string['checkbranchtable'] = 'İçerik sayfasını kontrol et';
$string['checkedthisone'] = 'Bu kontrol edildi';
$string['checknavigation'] = 'Dolaşımı kontol et';
$string['checkquestion'] = 'Soruyu kontrol et';
$string['classstats'] = 'Sınıf istatistikleri';
$string['clicktodownload'] = 'Dosyayı indirmek için aşağıdaki bağlantıyı tıklayınız.';
$string['closebeforeopen'] = 'Ders güncellenemedi. Açılış tarihinden önce bir kapanış tarih belirlediniz.';
$string['cluster'] = 'Küme';
$string['clusterjump'] = 'Küme içindeki bakılmamış soru';
$string['clustertitle'] = 'Küme';
$string['collapsed'] = 'Daraltılmış';
$string['comments'] = 'Yorumlarınız';
$string['completed'] = 'Bitirmeli';
$string['completederror'] = 'Dersi tamamla';
$string['completethefollowingconditions'] = 'Devam etmeden önce <b>{$a}</b> dersindeki koşulları yerine getirmelisiniz.';
$string['completiondetail:reachend'] = 'Etkinlikleri sonuna kadar gözden geçirin';
$string['completiondetail:timespent'] = 'Bu etkinlik için en az {$a} harcayın';
$string['completionendreached'] = 'Sona ulaşmayı gerektirir';
$string['completionendreached_desc'] = 'Öğrenci bu etkinliği tamamlamak için ders sayfasının sonuna gelmelidir';
$string['completiontimespent'] = 'Öğrenci bu etkinliği en az şu kere yapmalıdır';
$string['completiontimespentdesc'] = 'Öğrenci bu etkinliği en az {$a} boyunca yapmalı';
$string['completiontimespentgroup'] = 'Zaman harcama gerektirir';
$string['conditionsfordependency'] = 'Bağımlılık için koşullar';
$string['configintro'] = 'Burada ayarlanan değerler, yeni bir ders etkinliği oluştururken ayarlar formunda kullanılan varsayılan değerleri tanımlar. Gelişmiş olarak belirtilen ayarlar yalnızca \'Daha fazla göster...\' bağlantısı tıklandığında gösterilir.';
$string['configmaxanswers'] = 'Her sayfadaki  varsayılan maksimum cevap sayısı';
$string['configmediaclose'] = 'Medya bağlantı dosyasının açılır penceresine bağlı olarak  kapatma düğmesi görüntülenir.';
$string['configmediaheight'] = 'Ortam dosyası bağlantısı için görüntülenen açılır pencere yüksekliğini ayarlar';
$string['configmediawidth'] = 'Ortam dosyası bağlantısı için görüntülenen açılır pencere yüksekliğini ayarlar';
$string['configpassword_desc'] = 'Derse erişmek için bir şifre gerekip gerekmediği.';
$string['configslideshowbgcolor'] = 'Etkinse slayt gösterisi için arka plan rengi';
$string['configslideshowheight'] = 'Etkinleştirilmişse slayt gösterisinin arka plan rengi';
$string['configslideshowwidth'] = 'Etkinleştirilmiş ise slayt genişliğini ayarlar';
$string['configtimelimit_desc'] = 'Bir zaman sınırı ayarlanırsa, dersin başında bir uyarı ve bir geri sayım sayacı görüntülenir. Sıfır olarak ayarlanırsa, zaman sınırlaması yoktur.';
$string['confirmdelete'] = 'Sayfa sil';
$string['confirmdeletionofthispage'] = 'Bu sayfanın silinmesini onayla';
$string['congratulations'] = 'Tebrikler, dersin sonuna geldiniz';
$string['continue'] = 'Devam et';
$string['continuetoanswer'] = 'Cevapları değiştirmeye devam edin.';
$string['continuetonextpage'] = 'Sonraki sayfaya devam et.';
$string['correctanswerjump'] = 'Doğru cevap ilerlemesi';
$string['correctanswerscore'] = 'Doğru cevap puanı';
$string['correctresponse'] = 'Doğru cevap';
$string['createaquestionpage'] = 'Soru sayfası ekle';
$string['credit'] = 'Kredi';
$string['customscoring'] = 'Kişisel puanlama';
$string['customscoring_help'] = 'Etkinleştirilirse, her cevaba sayısal puan değeri (pozitif veya negatif) verilebilir.';
$string['deadline'] = 'Bitiş tarihi';
$string['defaultessayresponse'] = 'Yazılınız öğretmeniniz tarafından değerlendirilecek.';
$string['deleteallattempts'] = 'Tüm ders uygulamalarını sil';
$string['deletedefaults'] = '{$a} x ders varsayılanı silindi';
$string['deletedpage'] = 'Sayfa silindi';
$string['deletepagenamed'] = 'Şu sayfayı sil: {$a}';
$string['deleting'] = 'Siliniyor';
$string['deletingpage'] = 'Sayfa siliniyor: {$a}';
$string['dependencyon'] = 'Bağımlı';
$string['dependencyon_help'] = 'Bu ayar, bir öğrencinin performansını  başka bir derste bağımlı olmasına bağlı olarak  bu derste erişime izin verir. Seçenek olarak belli bir zaman geçirme, tamamlama veya "iyi not" seçenekleri kullanılabilir.';
$string['description'] = 'Açıklama';
$string['deselectallattempts'] = 'Tüm uygulamaların seçimini iptal et';
$string['detailedstats'] = 'Ayrıntılı istatistikler';
$string['didnotanswerquestion'] = 'Bu soruyu cevaplamadı';
$string['didnotreceivecredit'] = 'Krediyi almadı';
$string['disabled'] = 'Devre dışı bırakıldı';
$string['displaydefaultfeedback'] = 'Varsayılan geribildirimi kullan';
$string['displaydefaultfeedback_help'] = 'Etkinleştirilirse soruya cevap verilmediği zaman varsayılan " Bu soru doğrudur" veya "Bu soru yanlıştır" cevabı gösterilir.';
$string['displayinleftmenu'] = 'Menüde göster';
$string['displayleftif'] = 'Menüyü görüntülemek için en düşük not';
$string['displayleftif_help'] = 'Bu ayar,  öğrencinin ders menüsünü görüntülemeden önce belirli bir notu almasının zorunlu olup olmadığını belirler. İlk denemede tüm dersi geçmek zorunla olması öğrenciyi zorlar, Gerekli notu aldıktan sonra öğrenciler gözden geçirmek için menüyü kullanabilirler.';
$string['displayleftmenu'] = 'Menüyü göster';
$string['displayleftmenu_help'] = 'Etkinleştirildiğinde, kullanıcıların sayfa listesinde gezinmesini sağlayan bir menü görüntülenir.';
$string['displaymode'] = 'Görüntüleme modu';
$string['displayofgrade'] = 'Not gösterimi (sadece öğrenciler için)';
$string['displayreview'] = 'Bir soru daha denemek için seçenek sunun';
$string['displayreview_help'] = 'Etkinleştirilirse, bir soru yanlış cevaplandığında, öğrenciye puan almadan tekrar deneme veya derse devam etme seçeneği sunulur.  Öğrenci başka bir soruya geçmek için tıklarsa, seçilen (yanlış) cevap takip edilir.  Varsayılan olarak yanlış cevap "gitleri" bu sayfa" olarak ayarlanmıştır ve 0 puana sahiptir, bu nedenle öğrencilerinizin kafa karışıklığını önlemek için yanlış cevap "git"ini farklı bir sayfaya ayarlamanız önerilir.';
$string['displayscorewithessays'] = '<p>Otomatik olarak, değerlendirilen sorulardan {$a->tempmaxgrade} üzerinden {$a->score} aldınız. <p/>
<p>{$a->essayquestions} yazılı sorusu için notunuz hesaplanacak<br />ve sonraki bir tarihte final notunuza eklenecektir.</p>
<p>Yazılı notlar olmaksızın şu anki notunuz {$a->grade} üzerinden {$a->score}\'dir.</p>';
$string['displayscorewithoutessays'] = 'Notunuz {$a->score} ({$a->grade} üzerinden).';
$string['duplicatepagenamed'] = 'Şu sayfayı çoğalt: {$a}';
$string['edit'] = 'Düzenle';
$string['editbranchtable'] = 'İçerik sayfasını düzenle';
$string['editcluster'] = 'Kümeyi düzenle';
$string['editendofbranch'] = 'Dal sayfası sonunu düzenle';
$string['editendofcluster'] = 'Küme sayfası sonunu düzenle';
$string['editessay'] = 'Yazılı sorusu sayfası düzenleniyor';
$string['editinglesson'] = 'Ders düzenleniyor';
$string['editingquestionpage'] = '{$a} soru sayfası düzenleniyor';
$string['editlesson'] = 'Dersi düzenle';
$string['editlessonsettings'] = 'Ders ayarlarını düzenle';
$string['editmatching'] = 'Eşleştirme soru sayfası düzenleniyor';
$string['editmultichoice'] = 'Çoktan seçmeli soru sayfası düzenleniyor';
$string['editnumerical'] = 'Sayısal soru sayfası düzenleniyor';
$string['editoverride'] = 'Geçersiz kılmayı düzenle';
$string['editpage'] = 'İçerik Sayfası düzenleniyor';
$string['editpagecontent'] = 'Sayfa içeriğini düzenle';
$string['editquestion'] = 'Soru sayfası düzenleniyor';
$string['editshortanswer'] = 'Kısa cevap soru sayfası düzenleniyor';
$string['edittruefalse'] = 'Doğru/Yanlış soru sayfası düzenleniyor';
$string['email'] = 'E-posta';
$string['emailallgradedessays'] = 'değerlendirilen yazılılara bildirim gönder';
$string['emailgradedessays'] = 'Değerlendirilen yazılılara e-bildirim gönder';
$string['emailsuccess'] = 'Bildirim başarıyla gönderildi';
$string['emptypassword'] = 'Şifre boş olamaz';
$string['enabled'] = 'Etkinleştirildi';
$string['endofbranch'] = 'Dal sonu';
$string['endofcluster'] = 'Küme sonu';
$string['endofclustertitle'] = 'Küme sonu';
$string['endoflesson'] = 'Ders sonu';
$string['enteredthis'] = 'bu girildi.';
$string['enterpassword'] = 'Lütfen şifreyi giriniz:';
$string['eolstudentoutoftime'] = 'Dikkat: Bu dersin süresi bitti. Zaman bittikten sonra cevap verildiği takdirde cevabınız değerlendirilmeyecektir.';
$string['eolstudentoutoftimenoanswers'] = 'Hiç bir soruya cevap vermediniz. Bu ders için 0 aldınız.';
$string['essay'] = 'Yazılı';
$string['essayemailmessage2'] = '<p>Yazılı sorusu: <blockquote> {$a->question} </blockquote>; </p><p> Cevabınız: <blockquote> <em>{$a->response}</em> </blockquote></p><p> Değerlendirici geribildiriminde: <blockquote> <em>{$a->comment}</em> </blockquote>yorumunu yapmıştır</p><p> Bu yazılı sorusuna verdiğiniz cevap toplam {$a->outof} üzerinden {$a->earned} puan aldınız. </p><p> Ders puanınız {$a->newgrade}% \'olarak değiştirildi. </p>';
$string['essayemailmessagesmall'] = '<p>Bu kompozisyon sorusu için {$a->outof} üzerinden {$a-> earned}.</p><p>{$a->lesson} dersi notunuz olarak değiştirildi %{$a->newgrade}.</p>';
$string['essayemailsubject'] = 'Ders sorusu için not mevcut';
$string['essaynotgradedyet'] = 'Yazılı henüz değerlendirilmedi';
$string['essayresponses'] = 'Yazılı cevapları';
$string['essays'] = 'Yazılılar';
$string['essayscore'] = 'Yazılı puanı';
$string['eventcontentpageviewed'] = 'İçerik sayfası görüntülendi';
$string['eventessayassessed'] = 'Yazılı değerlendirildi';
$string['eventessayattemptviewed'] = 'Yazılı uygulaması incelendi';
$string['eventhighscoreadded'] = 'Ders yüksek puan eklendi';
$string['eventhighscoresviewed'] = 'Ders yüksek puan incelendi';
$string['eventlessonended'] = 'Ders bitti';
$string['eventlessonrestarted'] = 'Ders tekrar başlatıldı';
$string['eventlessonresumed'] = 'Ders devam etti';
$string['eventlessonstarted'] = 'Ders bitti';
$string['eventoverridecreated'] = 'Ders geçersiz kılma oluşturuldu';
$string['eventoverridedeleted'] = 'Ders geçersiz kılma silindi';
$string['eventoverrideupdated'] = 'Ders geçersiz kılma güncellendi';
$string['eventpagecreated'] = 'Sayfa oluşturuldu';
$string['eventpagedeleted'] = 'Sayfa silindi';
$string['eventpagemoved'] = 'Sayfa taşındı';
$string['eventpageupdated'] = 'Sayfa güncellendi';
$string['eventquestionanswered'] = 'Soru cevapladı';
$string['eventquestionviewed'] = 'Soru görüntülendi';
$string['false'] = 'Yanlış';
$string['fileformat'] = 'Dosya biçimi';
$string['finalwrong'] = 'Tam değil.';
$string['finish'] = 'Bitiş';
$string['firstanswershould'] = 'İlk cevap, \'Doğru Sayfasına" gidecek';
$string['firstwrong'] = 'Yanlış cevap verdiniz. Soruyu tekrar denemek ister misiniz? (Soruyu şimdi doğru cevaplarsanız, nihai puanınıza dahil edilmeyecektir).';
$string['flowcontrol'] = 'Akış kontrolü';
$string['fractionsaddwrong'] = 'Seçtiğiniz pozitif notların toplamı %100\'ü  geçemez.<br/>Notlarınızın toplamı: %{$a}.<br/>Geri dönüp bu soruyu düzeltmek ister misiniz?';
$string['fractionsnomax'] = 'Cevaplardan birinin <br />%100 olduğu belirlenmiştir, böylece bir soruya tam not verebilirsiniz.<br />Geri dönüp bu soruyu düzeltmek ister misiniz?';
$string['full'] = 'Genişletilmiş';
$string['general'] = 'Genel';
$string['gotoendoflesson'] = 'Dersin sonuna git';
$string['grade'] = 'Not';
$string['gradebetterthan'] = 'Bundan daha iyi not (&#37;)';
$string['gradebetterthanerror'] = 'Yüzde {$a}\'den daha iyi bir not alın';
$string['graded'] = 'Not verlidi';
$string['gradeessay'] = 'Yazılıları değerlendir ({$a->notgradedcount} notlandırılmadı ve {$a->notsentcount} gönderilmedi)';
$string['gradeis'] = 'Not: {$a}';
$string['gradeoptions'] = 'Not seçenekleri';
$string['groupoverrides'] = 'Grup geçersiz kılmaları';
$string['groupoverridesdeleted'] = 'Grup geçersiz kılmaları silindi';
$string['groupsnone'] = 'Erişebileceğiniz grup yok.';
$string['handlingofretakes'] = 'Tekrar alındığında';
$string['handlingofretakes_help'] = 'Yeniden almaya izin verilmişse  Bu ayar ders puanlaması için tüm uygulamaların ortalama veya en yüksek puan olup olmayacağını belirler.';
$string['havenotgradedyet'] = 'Henüz notu yok';
$string['here'] = 'bu araya';
$string['highscore'] = 'Yüksek not';
$string['hightime'] = 'Yüksek zaman';
$string['importcount'] = '{$a} soru alınıyor';
$string['importquestions'] = 'Soruları al';
$string['importquestions_help'] = 'Bu özellik  metin dosyası aracılığıyla çeşitli biçimlerdeki soruların alınmasnı sağlar';
$string['inactiveoverridehelp'] = '* Kullanıcının etkinliğe erişimi kısıtlı olduğu için bu geçersiz kılma etkin değildir. Bunun nedeni grup veya rol atamaları, diğer erişim kısıtlamaları veya etkinliğin gizli olması olabilir.';
$string['indicator:cognitivedepth'] = 'Ders bilişsel';
$string['indicator:cognitivedepth_help'] = 'Bu gösterge, öğrencinin bir Ders etkinliğinde ulaştığı bilişsel derinliğe dayanmaktadır.';
$string['indicator:cognitivedepthdef'] = 'Ders bilişsel';
$string['indicator:cognitivedepthdef_help'] = 'Katılımcı, bu analiz aralığı sırasında Ders etkinlikleri tarafından sunulan bilişsel katılımın bu yüzdesine ulaştı (Seviyeler = Görüntüleme Yok, Görüntüle, Gönder, Geri Bildirimi Görüntüle, Geri Bildirime Yorum Yap, Geri Bildirimi Görüntüledikten Sonra Yeniden Gönder)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Ders sosyal';
$string['indicator:socialbreadth_help'] = 'Bu gösterge, öğrencinin bir Ders etkinliğinde ulaştığı sosyal genişliğe dayalıdır.';
$string['indicator:socialbreadthdef'] = 'Ders sosyal';
$string['indicator:socialbreadthdef_help'] = 'Katılımcı, bu analiz aralığı boyunca Ders etkinlikleri tarafından sunulan sosyal katılımın bu yüzdesine ulaşmıştır (Düzeyler = Katılım yok, Yalnızca katılımcı, Diğerleriyle birlikte Katılımcı)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insertedpage'] = 'Sayfa eklendi';
$string['invalidfile'] = 'Geçersiz dosya';
$string['invalidid'] = 'Kursun ID\'s yok veya ders ID\'sine aktarıldı';
$string['invalidlessonid'] = 'Ders ID hatalı';
$string['invalidoverrideid'] = 'Doğru olmayan geçersiz kılma kimliği';
$string['invalidpageid'] = 'Geçersiz sayfa kimliği';
$string['jump'] = 'Git';
$string['jumps'] = 'Gider';
$string['jumps_help'] = 'Her cevap (sorular için) veya açıklama (içerik sayfaları için) buna denk düşen bir sıçrayışa sahiptir. Atlama, bu sayfada veya sonraki sayfada olduğu gibi göreceli olabilir veya dersin herhangi bir sayfasını belirterek mutlak olabilir.';
$string['jumpsto'] = 'Gider: <em>{$a}</em>';
$string['leftduringtimed'] = 'Zamanlı bir dersin süresini aştınız.<br />Dersi tekrar başlatmak için Devam Et butonuna tıklayın.';
$string['leftduringtimednoretake'] = 'Zamanlı bir dersin süresini aştınız.<br />Dersi tekrar alamaz veya derse devam edemezsiniz.';
$string['leftduringtimedsession'] = 'Zamanlanmış bir ders esnasında ayrılmışsın.';
$string['lesson:addinstance'] = 'Yeni ders ekle';
$string['lesson:edit'] = 'Ders etkinliğini düzenle';
$string['lesson:grade'] = 'Ders yazılı sorularını puanla';
$string['lesson:manage'] = 'Ders etkinliğini yönet';
$string['lesson:manageoverrides'] = 'Ders geçersiz kılmaları yönet';
$string['lesson:view'] = 'Ders etkinliklerini görüntüle';
$string['lesson:viewreports'] = 'Ders raporlarını görüntüle';
$string['lessonbeingpreviewed'] = 'Ders şu anda önizleniyor.';
$string['lessonclosed'] = 'Bu ders {$a} tarihinde kapandı.';
$string['lessoncloses'] = 'Ders kapanacak';
$string['lessoneventcloses'] = '{$a} kapanacak';
$string['lessoneventopens'] = '{$a} açılacak';
$string['lessonformating'] = 'Dersin biçimi';
$string['lessonmenu'] = 'Ders menüsü';
$string['lessonnotready'] = 'Bu ders, alınmaya hazır değil. Lütfen {$a} ile iletişim kurun.';
$string['lessonnotready2'] = 'Bu ders, alınmak için hazır değil.';
$string['lessonopen'] = 'Bu ders {$a} tarihinde açılacak.';
$string['lessonopens'] = 'Ders açılacak';
$string['lessonpagelinkingbroken'] = 'İlk sayfa bulunamadı. Ders sayfası bağlantısı kopmuş olmalı. Lütfen bir yöneticiyle iletişim kurun.';
$string['lessonstats'] = 'Ders istatististikleri';
$string['linkedmedia'] = 'Bağlantılı çokluortam';
$string['loginfail'] = 'Giriş hatalı, lütfen tekrar deneyin...';
$string['lowscore'] = 'Düşük puan';
$string['lowtime'] = 'Düşük zaman';
$string['manageoverrides'] = 'Geçersiz kılmaları yönet';
$string['manualgrading'] = 'Yazılıları değerlendir';
$string['matchesanswer'] = 'Cevaplarla eşleşir';
$string['matching'] = 'Eşleşme';
$string['matchingpair'] = 'Eşleşen çift {$a}';
$string['maxgrade'] = 'En yüksek puan';
$string['maxgrade_help'] = 'Bu ayar ders için en yüksek puanı belirler. Eğer ders sayfalarında notların görüntülenmesini istemiyorsanız 0 olarak ayarlayın.';
$string['maximumnumberofanswersbranches'] = 'En fazla cevap  sayısı';
$string['maximumnumberofanswersbranches_help'] = 'Bu ayar, ders kapsamında kullanılabilecek maksimum cevap sayısını belirtir. Yalnızca doğru/yanlış sorular kullanılırsa, 2\'ye ayarlanabilir. Ayar, verileri değil yalnızca öğretmenin gördüklerini etkilediği için herhangi bir zamanda değiştirilebilir.';
$string['maximumnumberofattempts'] = 'Her bir soru için en fazla uygulama sayısı';
$string['maximumnumberofattempts_help'] = 'Bu ayar, her soru için izin verilen maksimum deneme sayısını belirler. Art arda yanlış cevaplardan sonra yeterli başarıya ulaşıldığında, dersin bir sonraki sayfa görüntülenir.';
$string['maximumnumberofattemptsreached'] = 'En fazla uygulama sayısına ulaşıldı - Sonraki sayfaya gidiliyor';
$string['mediaclose'] = 'Kapat düğmesini göster';
$string['mediafile'] = 'Bağlantılı medya';
$string['mediafile_help'] = 'Derste kullanılmak üzere bir medya dosyası yüklenebilir. \'Görmek için buraya tıklayın\' bağlantısı, dersin her bir sayfasında \'Bağlı medya\' adlı bir bloğun içinde görüntülenecektir.';
$string['mediafilepopup'] = 'Bakmak için burayı tıklayın';
$string['mediaheight'] = 'Açılır pencere yüksekliği';
$string['mediawidth'] = 'Açılır pencere genişliği';
$string['messageprovider:graded_essay'] = 'Yazılı değerlendirme bildirimi';
$string['minimumnumberofquestions'] = 'En az soru sayısı';
$string['minimumnumberofquestions_help'] = 'Bu ayar, etkinlik için bir notu hesaplamak için kullanılacak minimum soru sayısını belirtir.';
$string['missingname'] = 'Lütfen bir takma ad girin';
$string['modattempts'] = 'Öğrencinin inceleme izni';
$string['modattempts_help'] = 'Etkisizleştirilirse öğrenciler desi baştan sona kadar tekrar gözde geçireilirler';
$string['modattemptsnoteacher'] = 'Öğrenci değerlendirmesi sadece öğrenciler için çalışır.';
$string['modulename'] = 'Ders';
$string['modulename_help'] = 'Ders etkinliği modülü, bir öğretmenin içerik ve / veya uygulama etkinliklerini ilginç ve esnek şekillerde sunmasını sağlar. Bir öğretmen dersi öğrenciye çeşitli yollar veya seçenekler sunan doğrusal bir içerik sayfası veya öğretim etkinliği seti oluşturmak için kullanabilir. Her iki durumda da, öğretmenler, çoktan seçmeli, eşleştirmeli ve kısa cevap gibi farklı soru tiplerin kullanarak katılımı artırmayı ve kavramayı elde etmeyi seçebilir. Öğrencinin cevap seçimine ve öğretmenin dersi nasıl geliştirdiğine bağlı olarak, öğrenciler bir sonraki sayfaya geçebilir, önceki sayfaya geri dönebilir veya tamamen farklı bir yola yönlendirilebilir.

Ders, not defterie kaydedilen notlarla değerlendirilebilir.

Dersler aşağıdaki durumlarda kullanılabilir

* Yeni bir konunun öz yönetimli öğrenimi için
* Karar verme alıştırmaları için senaryolar veya simülasyonlar
* İlk sorulara verilen cevaplara bağlı olarak farklı düzenlenmiş soru setleri ile Farlılaştırılmış düzenlemeler';
$string['modulename_link'] = 'mod/lesson/view';
$string['modulenameplural'] = 'Dersler';
$string['move'] = 'Sayfa taşı';
$string['movedpage'] = 'Sayfa taşındı';
$string['movepagehere'] = 'Sayfayı buraya taşı';
$string['movepagenamed'] = 'Sayfayı taşı: {$a}';
$string['moving'] = 'Sayfa taşınıyor: {$a}';
$string['multianswer'] = 'Birden çok cevaplı';
$string['multianswer_help'] = 'Birden fazla cevabı doğru olarak kabul edecekseniz onay kutusunu işaretleyin';
$string['multichoice'] = 'Çok seçenekli';
$string['multipleanswer'] = 'Çok cevaplı';
$string['nameapproved'] = 'İsim onaylandı';
$string['namereject'] = 'Üzgünüz, isminiz kurallara uygun olmadığı için reddedildi.<br />Lütfen başka bir isim deneyin.';
$string['new'] = 'yeni';
$string['nextpage'] = 'Sonraki sayfa';
$string['noanswer'] = 'Bir veya daha fazla soruya cevap verilmedi. Lütfen geri dönün ve bir cevap verin.';
$string['noattemptrecordsfound'] = 'Uygulama kaydı bulunamadı: puan verilmedi';
$string['nobranchtablefound'] = 'Konu anlatımı yok';
$string['noclose'] = 'Kapatma tarihi yok';
$string['nocommentyet'] = 'Henüz yorum yok.';
$string['nocoursemods'] = 'Etkinlik bulunamadı';
$string['nocredit'] = 'Kredi yok';
$string['nodeadline'] = 'Teslim tarihsiz';
$string['noessayquestionsfound'] = 'Bu derste yazılı sorusu yok';
$string['nohighscores'] = 'Yüksek not yok';
$string['nolessonattempts'] = 'Bu derste uygulama yapılmadı.';
$string['nolessonattemptsgroup'] = 'Bu derste {$a} grup üyeleri tarafından hiçbir deneme yapılmadı.';
$string['none'] = 'Yok';
$string['nooneansweredcorrectly'] = 'Hiç kimse doğru cevap vermedi.';
$string['nooneansweredthisquestion'] = 'Hiç kimse bu soruyu cevaplamadı.';
$string['noonecheckedthis'] = 'Hiç kimse bunu seçmedi.';
$string['nooneenteredthis'] = 'Hiç kimse bunu girmedi.';
$string['noonehasanswered'] = 'Henüz kimse bir yazılı sorusuna cevap vermedi.';
$string['noonehasansweredgroup'] = '{$a}\'da hiç kimse bir kompozisyon sorusunda henüz cevaplamadı.';
$string['noopen'] = 'Açılma tarihi yok';
$string['nooverridecreated'] = 'Oluşturulmuş geçersiz kılma yok';
$string['nooverridedata'] = 'Ders ayarlarından en az birini geçersiz kılmalısınız.';
$string['noretake'] = 'Bu dersi tekrar almanıza izin verilmiyor.';
$string['normal'] = 'Normal ders akışı';
$string['notcompleted'] = 'Tamamlanmadı';
$string['notcompletedwithdate'] = '({$a}) tamamlanmadı';
$string['notdefined'] = 'Tanımlanmadı';
$string['notenoughsubquestions'] = 'Yeterli sayıda alt-soru tanımlanmadı!<br />Geri dönüp bu soruyu düzeltmek ister misiniz?';
$string['notenoughtimespent'] = 'Bu dersi {$a->timespent} sürede tamamladınız, bu gerekli süre {$a->timerequired}\'ten daha az. Dersi tekrar almanız gerekebilir.';
$string['notgraded'] = 'Puanlanmamış';
$string['notitle'] = 'Başlık yok';
$string['notyetcompleted'] = 'Ders başladı, ancak henüz tamamlanmadı';
$string['numberofcorrectanswers'] = 'Doğru cevap sayısı: {$a}';
$string['numberofcorrectanswersheader'] = 'Doğru cevapların sayısı';
$string['numberofcorrectmatches'] = 'Doğru eşleştirme sayısı: {$a}';
$string['numberofpagestoshow'] = 'Gösterilecek sayfa sayısı';
$string['numberofpagestoshow_help'] = 'Bu ayar, bir derste gösterilen sayfa sayısını belirler. Sayfaları rastgele bir sırayla gösterilen dersler için geçerlidir ("doğru cevap sonraki eylem" , "görülmemiş bir sayfa göster" veya "cevaplanmamış bir sayfa göster" olarak ayarlanabilir). Sıfır olarak ayarlanırsa, tüm sayfaları gösterilir.';
$string['numberofpagesviewed'] = 'Cevaplanan soru sayısı: {$a}';
$string['numberofpagesviewedheader'] = 'Cevaplanan soru sayısı';
$string['numberofpagesviewednotice'] = 'Cevaplanan soru sayısı: {$a->nquestions}; (En az bu kadar cevaplamalısınız: {$a->minquestions})';
$string['numerical'] = 'Sayısal';
$string['numericanswer'] = 'Sayısal cevap';
$string['numericanswer_help'] = 'İki nokta üst üste seçeneğini kullanarak tek bir sayı veya sayı aralığı belirtebilirsiniz. Örneğin 2:5, 2 ile 5 arasında ve 2 ile 5 arasında herhangi bir cevabın doğru olduğu anlamına gelir.';
$string['offlinedatamessage'] = 'Bu gönderi için mobil cihaz kullanarak çalıştınız. Veriler en son {$a} tarihinde bu siteye kaydedildi. Lütfen kaydedilmemiş çalışmsınız olup olmadığını kontrol edin.';
$string['ongoing'] = 'Notu sürekli göster';
$string['ongoing_help'] = 'Etkinleştirilirse, kazanılacak olası puanlar hariç, öğrencinin şu ana kadarki geçerli puanı  her sayfada görüntülenir.';
$string['ongoingcustom'] = 'Şu ana kadar {$a->currenthigh} not üzerinden {$a->score} puan aldınız.';
$string['ongoingnormal'] = '{$a->viewed} uygulamadan {$a->correct} tanesini doğru cevapladınız.';
$string['onpostperpage'] = 'Her not için yalnızca bir gönderi';
$string['openafterclose'] = 'Kapanma tarihinden sonraki bir tarih seçtiniz.';
$string['options'] = 'Seçenekler';
$string['or'] = 'VEYA';
$string['ordered'] = 'Sıralı';
$string['other'] = 'Diğer';
$string['outof'] = '{$a} üzerinden';
$string['override'] = 'Geçersiz kıl';
$string['overridedeletegroupsure'] = '{$a} grubu için geçersiz kılmayı silmek istediğinizden emin misiniz?';
$string['overridedeleteusersure'] = '{$a} kullanıcısı için geçersiz kılmayı silmek istediğinizden emin misiniz?';
$string['overridegroup'] = 'Grubu geçersiz kıl';
$string['overridegroupeventname'] = '{$a->lesson} - {$a->group}';
$string['overrides'] = 'Geçersiz kılmalar';
$string['overrideuser'] = 'Kullanıcıyı geçersiz kıl';
$string['overrideusereventname'] = '{$a->lesson} - Geçersiz kıl';
$string['overview'] = 'Gözden geçir';
$string['overview_help'] = 'Bir ders ve isteğe bağlı olarak içerik sayfalarından vey bir diziden oluşur. Bir sayfa, bazı muhtevaları içerir ve genellikle bir soru ile biter. Her sorunun cevabından sonra başka aşamaya geçilir. Bu aşama mutlak veya göreceli olabilir, örneğin dersin gelişim saflarına göre bir aşama belirtilerek bu sayfada kalınabilir veya diğer sayfaya geçilebilir.  Bir içerik sayfası, diğer sitelere bağlantılar bir dizi ders  içeren bir sayfadır, örneğin içindekiler tablosu';
$string['page'] = 'Sayfa: {$a}';
$string['page-mod-lesson-edit'] = 'Ders sayfasını düzenle';
$string['page-mod-lesson-view'] = 'Ders sayfasını görüntüle veya önizleme yap';
$string['page-mod-lesson-x'] = 'Herhangi bir ders sayfası';
$string['pageanswers'] = 'Sayfa cevapları';
$string['pagecontents'] = 'Sayfa içeriği';
$string['pageresponses'] = 'Sayfa cevapları';
$string['pages'] = 'Sayfalar';
$string['pagetitle'] = 'Sayfa başlığı';
$string['password'] = 'Şifre';
$string['passwordprotectedlesson'] = '{$a} şifre korumalı bir derstir.';
$string['pleasecheckoneanswer'] = 'Lütfen bir cevap seçiniz';
$string['pleasecheckoneormoreanswers'] = 'Lütfen bir veya birden fazla cevap seçiniz';
$string['pleaseenteryouranswerinthebox'] = 'Lütfen cevabınızı kutucuğa yazınız';
$string['pleasematchtheabovepairs'] = 'Lütfen yukarıdaki çiftleri eşleştirin';
$string['pluginadministration'] = 'Ders yönetimi';
$string['pluginname'] = 'Ders';
$string['pointsearned'] = 'Alınan puan';
$string['postprocesserror'] = 'İşlem sonrasında hata oluştu!';
$string['postsuccess'] = 'Gönderme başarılı';
$string['practice'] = 'Pratik dersi';
$string['practice_help'] = 'Pratik dersi, not çizelgesinde gösterilmez.';
$string['preprocesserror'] = 'İşlem öncesinde hata oluştu';
$string['prerequisiteisobsolete'] = 'Önkoşul dersi seçeneğinin kaldırılması planlanıyor. Bunun yerine erişim kısıtlamalarını kullanın.';
$string['prerequisitelesson'] = 'Önkoşullu ders';
$string['preview'] = 'Önizleme';
$string['previewlesson'] = 'Önizleme: {$a}';
$string['previewpagenamed'] = 'Sayfayı önizle: {$a}';
$string['previouspage'] = 'Önceki sayfa';
$string['privacy:metadata:attempts'] = 'Sayfa uygulamaları kaydı';
$string['privacy:metadata:attempts:answerid'] = 'Sorunun kimliği';
$string['privacy:metadata:attempts:correct'] = 'Uygulamanın doğru olup olmadığı';
$string['privacy:metadata:attempts:pageid'] = 'Sayfa kimliği';
$string['privacy:metadata:attempts:retry'] = 'Uygulama numarası';
$string['privacy:metadata:attempts:timeseen'] = 'Uygulamanın hazırlandığı zaman';
$string['privacy:metadata:attempts:useranswer'] = 'Kullanıcının cevabı ile ilgili ayrıntılar';
$string['privacy:metadata:attempts:userid'] = 'Kullanıcı kimliği';
$string['privacy:metadata:branch'] = 'Sayfa görüntüleme kaydı';
$string['privacy:metadata:branch:flag'] = 'Sonraki sayfanın rastgele hesaplanıp hesaplanmadığı';
$string['privacy:metadata:branch:nextpageid'] = 'Sonraki sayfa kimliği';
$string['privacy:metadata:branch:pageid'] = 'Sayfa kimliği';
$string['privacy:metadata:branch:retry'] = 'Uygulama sayısı';
$string['privacy:metadata:branch:timeseen'] = 'Sayfanın görüntülendiği saat';
$string['privacy:metadata:branch:userid'] = 'Kullanıcı kimliği';
$string['privacy:metadata:grades'] = 'Derslerin herbirinin not kayıtları';
$string['privacy:metadata:grades:completed'] = 'Notun verildiği tarih';
$string['privacy:metadata:grades:grade'] = 'Verilen not';
$string['privacy:metadata:grades:userid'] = 'Kullanıcı kimliği';
$string['privacy:metadata:overrides'] = 'Derslerin herbbirinin geçersiz kılınma kaydı';
$string['privacy:metadata:overrides:available'] = 'Dersin kullanılabileceği tarih';
$string['privacy:metadata:overrides:deadline'] = 'Dersin tamamlanması gereken son tarih';
$string['privacy:metadata:overrides:maxattempts'] = 'Uygulama  sayısı';
$string['privacy:metadata:overrides:password'] = 'Derse erişim için gereken şifre';
$string['privacy:metadata:overrides:retake'] = 'Yeniden deneme için izin verilip verilmediği';
$string['privacy:metadata:overrides:review'] = 'Sorunun yeniden cevaplanmasına izin verilip verilmediği';
$string['privacy:metadata:overrides:timelimit'] = 'Dersi tamamlamak için saniye cinsinden süre sınırı.';
$string['privacy:metadata:overrides:userid'] = 'Kullanıcı kimliği';
$string['privacy:metadata:timer'] = 'Ders uygulama';
$string['privacy:metadata:timer:completed'] = 'Uygulamaların tamamlanıp tamamlanmadığı';
$string['privacy:metadata:timer:lessontime'] = 'Etkinliği kaydettiğimiz son an';
$string['privacy:metadata:timer:starttime'] = 'Etkinlik uygulamalarının başladığı tarih';
$string['privacy:metadata:timer:timemodifiedoffline'] = 'Mobil uygulamadan etkinlik kaydettiğimiz son an';
$string['privacy:metadata:timer:userid'] = 'Kullanıcı kimliği';
$string['privacy:metadata:userpref:lessonview'] = 'Dersleri düzenlerken tercih edilen görüntüleme modu';
$string['privacy:path:essayanswers'] = 'Yazılı cevapları';
$string['privacy:path:essayresponses'] = 'Yazılı cevapları';
$string['privacy:path:pages'] = 'Sayfa';
$string['processerror'] = 'İşlem sırasında hata oluştu!';
$string['progressbar'] = 'İlerleme çubuğu';
$string['progressbar_help'] = 'Eğer etkinleştirilirse ders sayfalarının altında yaklaşık tamamlanma yüzdesini gösteren bir çubuk görüntülenir.';
$string['progressbarteacherwarning'] = 'İlerleme çubuğu {$a} için gösterilmiyor';
$string['progressbarteacherwarning2'] = 'Bu dersi düzenlediğiniz için ilerleme çubuğunu göremezsiniz';
$string['progresscompleted'] = 'Dersin {$a} %  tamamladınız';
$string['qtype'] = 'Sayfa tipi';
$string['question'] = 'Soru';
$string['questionoption'] = 'Soru';
$string['questiontype'] = 'Soru tipi';
$string['randombranch'] = 'Rasgele içerik sayfası';
$string['randompageinbranch'] = 'İçerik sayfası içindeki rasgele soru';
$string['rank'] = 'Sıra';
$string['rawgrade'] = 'Ham not';
$string['receivedcredit'] = 'Alınan kredi';
$string['redisplaypage'] = 'Sayfayı tekrar göster';
$string['removeallgroupoverrides'] = 'Tüm grup geçersiz kılmaları sil';
$string['removealluseroverrides'] = 'Tüm kullanıcı geçersiz kılmaları sil';
$string['report'] = 'Rapor';
$string['reports'] = 'Raporlar';
$string['response'] = 'Yanıtına karşılık dönüt';
$string['retakesallowed'] = 'Tekrar alma izni';
$string['retakesallowed_help'] = 'Eğer etkinleştirilirse öğrenciler derste birden fazla uygulama yapabilirler.';
$string['returnto'] = 'Geri dön: {$a}';
$string['returntocourse'] = 'Kursa geri dön';
$string['reverttodefaults'] = 'Ders varsayılanlarına geri dön';
$string['review'] = 'Gözden geçir';
$string['reviewlesson'] = 'Dersi tekrar gözden geçir';
$string['reviewquestionback'] = 'Evet, tekrar deneyeyim';
$string['reviewquestioncontinue'] = 'Hayır, sonraki soruya geçeyim';
$string['sanitycheckfailed'] = 'Uyumluluk hatası: Bu uygulama silindi';
$string['save'] = 'Kaydet';
$string['savechanges'] = 'Değişiklikleri kaydet';
$string['savechangesandeol'] = 'Tüm değişiklikleri kaydet ve dersin sonuna git.';
$string['saveoverrideandstay'] = 'Kaydedin ve başka bir geçersiz kılma girin';
$string['savepage'] = 'Sayfayı kaydet';
$string['score'] = 'Not';
$string['score_help'] = 'Ders ayarlarında özel puanlama etkinleştirilmişse, her cevap için bir tam sayı değeri (pozitif veya negatif) girilebilir.';
$string['scores'] = 'Notlar';
$string['search:activity'] = 'Ders - Etkinlik bilgileri';
$string['secondpluswrong'] = 'Tamamen değil. Tekrar denemek ister misiniz?';
$string['selectallattempts'] = 'Tüm uygulamaları seç';
$string['selectaqtype'] = 'Bir soru tipi seçin';
$string['selectreport'] = 'Rapor seç';
$string['sent'] = 'Gönder';
$string['shortanswer'] = 'Kısa cevap';
$string['showanunansweredpage'] = 'Cevaplanmamış bir sayfa göster';
$string['showanunseenpage'] = 'Görülmemiş bir sayfa göster';
$string['singleanswer'] = 'Tek cevap';
$string['skip'] = 'Gezinmeyi atla';
$string['slideshow'] = 'Slayt Gösterisi';
$string['slideshow_help'] = 'Etkinleştirilirse ders ders sabit genişlik ve yükseklikte slayt olarak görüntelenir.';
$string['slideshowbgcolor'] = 'Slayt arkaplan rengi';
$string['slideshowheight'] = 'Slayt yüksekliği';
$string['slideshowwidth'] = 'Slayt genişliği';
$string['startlesson'] = 'Dersi başlat';
$string['studentattemptlesson'] = '{$a->lastname}, {$a->firstname}\'in uygulama sayısı {$a->attempt}';
$string['studentname'] = '{$a} Adı';
$string['studentoneminwarning'] = 'Dikkat: Dersi bitirmeniz için 1 dk.\'dan daha az bir süreniz kaldı.';
$string['studentoutoftimeforreview'] = 'Dikkat: Bu dersi incelemek için zamanınız kalmadı';
$string['studentresponse'] = '{$a}\'in yanıtı';
$string['submit'] = 'Gönder';
$string['submitname'] = 'Gönderi adı';
$string['teacherjumpwarning'] = 'Bir {$a->cluster} veya {$a->unseen} ilerlemesi bu derste kullanılıyor. Bunun yerine Sonraki sayfa ilerlemesi kullanılacak. Bu ilerlemeleri denemek için öğrenci olarak giriş yapın.';
$string['teacherongoingwarning'] = 'Geri sayım sadece öğrenciler içindir. Devam eden puanlamayı denemek için öğrenci olarak giriş yapın';
$string['teachertimerwarning'] = 'Zamanlayıcı yalnızca öğrenciler için çalışır. Öğrenci olarak giriş yaparak zamanlayıcıyı test edin.';
$string['thatsthecorrectanswer'] = 'Doğru cevap';
$string['thatsthewronganswer'] = 'Yanlış cevap';
$string['thefollowingpagesjumptothispage'] = 'Aşağıdaki sayfalar bu sayfayla bağlantılı';
$string['thispage'] = 'Bu sayfa';
$string['timeisup'] = 'Süreniz doldu';
$string['timelimit'] = 'Zaman sınırı';
$string['timelimit_help'] = 'Etkinleştirilirse, dersin başında zaman sınırıyla ilgili bir uyarı ve bir geri sayım sayacı görüntülenir. Süre dolduktan sonra verilen cevaplara not verlimez.';
$string['timelimitwarning'] = 'Dersi bitirmek için {$a} süreniz var.';
$string['timeremaining'] = 'Kalan süre';
$string['timespenterror'] = 'Bu ders için en az {$a} dakika harcayın';
$string['timespentminutes'] = 'Harcanacak süre (dk)';
$string['timetaken'] = 'Geçen süre';
$string['totalpagesviewedheader'] = 'Görüntülenen sayfa sayısı';
$string['true'] = 'Doğru';
$string['truefalse'] = 'Doğru/yanlış';
$string['unabledtosavefile'] = 'Gönderilen dosya kaydedilemedi';
$string['unknownqtypesnotimported'] = '{$a} soruları desteklenmeyen soru tipi olması nedeniyle alınmadı';
$string['unseenpageinbranch'] = 'Bir içerik sayfasındaki görülmemiş soru';
$string['unsupportedqtype'] = 'Desteklenmeyen soru tipi ({$a})!';
$string['updatedpage'] = 'Sayfa güncellendi';
$string['updatefailed'] = 'Güncelleme başarısız';
$string['updatepagenamed'] = 'Sayfayı güncelle: {$a}';
$string['usemaximum'] = 'En yüksek kullan';
$string['usemean'] = 'Ortalama kullan';
$string['usepassword'] = 'Şifre korumalı ders';
$string['usepassword_help'] = 'Eğer etkinleştirilirse derse katılabilmek için bir şifre gerekecektir.';
$string['useroverrides'] = 'Kullanıcı geçersiz kılmaları';
$string['useroverridesdeleted'] = 'Kullanıcı geçersiz kılmaları silindi';
$string['usersnone'] = 'Hiçbir öğrencinin bu derse erişimi yok';
$string['viewessayanswers'] = 'Yazılı cevaplarını görüntüleyin';
$string['viewgrades'] = 'Notlara bak';
$string['viewreports'] = 'Tamamlanmış {$a->attempts} {$a->student} uygulamasına bak';
$string['viewreports2'] = 'Tamamlanmış {$a} uygulamasını bak';
$string['warning'] = 'Uyarı';
$string['welldone'] = 'Aferin!';
$string['whatdofirst'] = 'İlk önce ne yapmak istersiniz?';
$string['withselectedattempts'] = 'Seçilen uygulamalarla ...';
$string['wronganswerjump'] = 'Yanlış cevaba git';
$string['wronganswerscore'] = 'Yanlış cevap puanı';
$string['wrongresponse'] = 'Yanlış cevap';
$string['youhaveseen'] = 'Bu dersin birden fazla sayfasını zaten gördünüz.
<br />Kaldığınız sayfadan devam etmek ister misiniz?';
$string['youranswer'] = 'Cevabınız';
$string['yourcurrentgradeis'] = 'Şuanki notunuz: {$a}';
$string['yourcurrentgradeisoutof'] = 'Şu anki notunuz {$a->total} üzerinden {$a->grade} dir.';
$string['youshouldview'] = 'En az cevaplamanız gereken: {$a}';
