<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'data', language 'en', branch 'MOODLE_20_STABLE'
 *
 * @package   mod_data
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['action'] = 'Action';
$string['actionsmenu'] = 'Actions menu';
$string['add'] = 'Add entry';
$string['addcomment'] = 'Add comment';
$string['addtemplate'] = 'Add entry template';
$string['advancedsearch'] = 'Advanced search';
$string['allowcomments'] = 'Allow comments on entries';
$string['alttext'] = 'Alternative text';
$string['approvalstatus'] = 'Approval status';
$string['approve'] = 'Approve';
$string['approved'] = 'Approved';
$string['areacontent'] = 'Fields';
$string['ascending'] = 'Ascending';
$string['asearchtemplate'] = 'Advanced search template';
$string['atmaxentry'] = 'You have entered the maximum number of entries allowed!';
$string['authorfirstname'] = 'First name';
$string['authorlastname'] = 'Last name';
$string['autogenallforms'] = 'Generate all default templates';
$string['autolinkurl'] = 'Autolink the URL';
$string['availablefromdate'] = 'Available from';
$string['availabletags'] = 'Available tags';
$string['availabletags_help'] = 'Tags are placeholders in the template, which will be replaced by data or other items, such as an edit icon, when entries are edited or viewed.

Fields have the format [[fieldname]]. All other tags have the format ##sometag##.

Only the tags that are in the "Available tags" list may be used for the current template.';
$string['availabletodate'] = 'Available to';
$string['availabletodatevalidation'] = 'The available to date cannot be before the available from date.';
$string['bynameondate'] = 'by {$a->name} - {$a->date}';
$string['calendarend'] = '{$a} closes';
$string['calendarstart'] = '{$a} opens';
$string['cancel'] = 'Cancel';
$string['cannotaccesspresentsother'] = 'You are not allowed to access presets from other users';
$string['cannotadd'] = 'Can not add entries!';
$string['cannotdeletepreset'] = 'Error deleting preset';
$string['cannotoverwritepreset'] = 'Error overwriting preset';
$string['cannotunziptopreset'] = 'Cannot unzip to the preset directory';
$string['cannotapplypreset'] = 'Error applying the preset.';
$string['closebeforeopen'] = 'You have specified an end date before the start date.';
$string['columns'] = 'columns';
$string['comment'] = 'Comment';
$string['commentdeleted'] = 'Comment deleted';
$string['commentempty'] = 'Comment was empty';
$string['comments'] = 'Comments';
$string['commentsaved'] = 'Comment saved';
$string['commentsn'] = '{$a} comment(s)';
$string['commentsoff'] = 'Comments feature is not enabled';
$string['completiondetail:entries'] = 'Make entries: {$a}';
$string['completionentriescount'] = 'Add entries';
$string['completionentriesdesc'] = 'Minimum number of entries required: {$a}';
$string['configenablerssfeeds'] = 'This switch will enable the possibility of RSS feeds for all databases. You will still need to turn feeds on manually in the settings for each database.';
$string['confirmdeletefield'] = 'You are about to delete this field, are you sure?';
$string['confirmdeleterecord'] = 'Are you sure you want to delete this entry?';
$string['confirmdeleterecords'] = 'Are you sure you want to delete these entries?';
$string['createactivity'] = 'Create your own fields to collect data, or use a preset which includes fields already.';
$string['createfields'] = 'Create fields to collect different types of data.';
$string['createtemplates'] = 'Templates define the interface of your activity. Once you create fields, templates will be created automatically. Alternatively, you can use a preset, which includes fields and templates.';
$string['csstemplate'] = 'Custom CSS';
$string['csvfailed'] = 'Unable to read the raw data from the CSV file';
$string['csvfile'] = 'CSV or ZIP containing a CSV file';
$string['csvimport'] = 'CSV file import';
$string['csvimport_help'] = 'Entries may be imported via a plain text file with a list of field names as the first line, then the data, with one record per line.';
$string['csvwithselecteddelimiter'] = '<abbr title="Comma Separated Values">CSV</abbr>';
$string['data:addinstance'] = 'Add a new database';
$string['data:approve'] = 'Approve and undo approved entries';
$string['data:comment'] = 'Write comments';
$string['data:exportallentries'] = 'Export all database entries';
$string['data:exportentry'] = 'Export a database entry';
$string['data:exportownentry'] = 'Export own database entry';
$string['data:exportuserinfo'] = 'Export user information';
$string['data:managecomments'] = 'Manage comments';
$string['data:manageentries'] = 'Manage entries';
$string['data:managetemplates'] = 'Manage templates';
$string['data:manageuserpresets'] = 'Manage presets';
$string['data:rate'] = 'Rate entries';
$string['data:readentry'] = 'Read entries';
$string['data:viewalluserpresets'] = 'View presets from all users';
$string['data:viewallratings'] = 'View all raw ratings given by individuals';
$string['data:viewanyrating'] = 'View total ratings that anyone received';
$string['data:viewentry'] = 'View entries';
$string['data:viewrating'] = 'View the total rating you received';
$string['data:writeentry'] = 'Write entries';
$string['data:view'] = 'View database activity';
$string['date'] = 'Date';
$string['dateentered'] = 'Date entered';
$string['datemodified'] = 'Last edited:';
$string['defaultfielddelimiter'] = '(default is the comma character)';
$string['defaultfieldenclosure'] = '(default is none)';
$string['defaultsortfield'] = 'Default sort field';
$string['delcheck'] = 'Bulk delete checkbox';
$string['delete'] = 'Delete';
$string['deleteallentries'] = 'Delete all entries';
$string['deletecomment'] = 'Are you sure you want to delete this comment?';
$string['deleteconfirm'] = 'Delete preset {$a}?';
$string['deleted'] = 'deleted';
$string['deleteentry'] = 'Delete entry';
$string['deletefield'] = 'Delete field';
$string['deletenotenrolled'] = 'Delete entries by users not enrolled';
$string['deletewarning'] = 'Deleting a preset removes it from the list of available presets in all courses.';
$string['descending'] = 'Descending';
$string['directorynotapreset'] = '{$a->directory} Not a preset: missing files: {$a->missing_files}';
$string['disapprove'] = 'Undo approval';
$string['download'] = 'Download';
$string['edit'] = 'Edit';
$string['editcomment'] = 'Edit comment';
$string['editentry'] = 'Edit entry';
$string['editfield'] = 'Edit field';
$string['editordisable'] = 'Disable editor';
$string['editorenable'] = 'Enable code editor';
$string['editpreset'] = 'Edit preset';
$string['emptyadd'] = 'The Add template is empty, generating a default form...';
$string['emptyaddform'] = 'You did not fill out any fields!';
$string['enabletemplateeditorcheck'] = 'Are you sure you want to enable the editor? This may result in content being altered when the template is saved.';
$string['eventfieldcreated'] = 'Field created';
$string['eventfielddeleted'] = 'Field deleted';
$string['eventfieldupdated'] = 'Field updated';
$string['eventrecordcreated'] = 'Record created';
$string['eventrecorddeleted'] = 'Record deleted';
$string['eventrecordupdated'] = 'Record updated';
$string['eventtemplateupdated'] = 'Template updated';
$string['eventtemplateviewed'] = 'Templates viewed';
$string['fileencoding'] = 'Encoding';
$string['emptypresetname'] = 'Preset name or file cannot be empty';
$string['entries'] = 'Entries';
$string['entrieslefttoadd'] = 'You must add {$a->entriesleft} more entry/entries to complete this activity.';
$string['entrieslefttoaddtoview'] = 'You must add {$a->entrieslefttoview} more entry/entries before you can view other participants\' entries.';
$string['entry'] = 'Entry';
$string['entrysaved'] = 'Your entry has been saved';
$string['errordatafilenotfound'] = 'The file could not be imported. Accepted file types are CSV or a ZIP containing a CSV file in the format used for exporting entries.';
$string['errormustbeteacher'] = 'You need to be a teacher to use this page!';
$string['errorpresetexists'] = 'A preset with this name already exists.';
$string['errorpresetexistsbutnotoverwrite'] = 'A preset with this name already exists. Choose a different name.';
$string['errormustsupplyvalue'] = 'You must supply a value here.';
$string['errorpresetnotfound'] = 'Preset with name {$a} not found.';
$string['example'] = 'Database module example';
$string['excel'] = 'Excel';
$string['export'] = 'Export';
$string['exportaszip'] = 'Export as zip';
$string['exportaszip_help'] = 'The export as zip feature allows you to save the templates and fields as a preset zip for download. The zip may then be imported to another course.';
$string['exportedtozip'] = 'Exported to temporary zip...';
$string['exportentries'] = 'Export entries';
$string['exportformat'] = 'Export format';
$string['exportoptions'] = 'Export options';
$string['exportownentries'] = 'Export your own entries only? ({$a->mine}/{$a->all})';
$string['exportpreset'] = 'Export preset';
$string['failedpresetdelete'] = 'An error was encountered while trying to delete the preset.';
$string['fieldadded'] = 'Field added';
$string['fieldallowautolink'] = 'Allow autolink';
$string['fielddeleted'] = 'Field deleted';
$string['fielddelimiter'] = 'Field separator';
$string['fielddescription'] = 'Field description';
$string['fieldenclosure'] = 'Field enclosure';
$string['fieldheight'] = 'Height';
$string['fieldheightlistview'] = 'Height (in pixels) in list view';
$string['fieldheightsingleview'] = 'Height (in pixels) in single view';
$string['fieldmappings'] = 'Field mappings';
$string['fieldmappings_help'] = 'This menu allows you to keep the data from the existing database. To preserve the data in a field, you must map it to a new field, where the data will appear. Any field can also be left blank, with no information copied into it. Any old field not mapped to a new one will be lost and all its data removed.
You can only map fields of the same type, so each drop-down menu will have different fields in it. Also, you must be careful not to try and map one old field to more than one new field.';
$string['fieldname'] = 'Field name';
$string['fieldnametype'] = '{$a->name} ({$a->type})';
$string['fieldnotmatched'] = 'The following fields in your file are not known in this database: {$a}';
$string['fieldoptions'] = 'Options (one per line)';
$string['fields'] = 'Fields';
$string['fieldshelp'] = 'Create fields to collect different types of data. Fields define the structure of the entries in your database.';
$string['fieldsinformationtags'] = 'Field information';
$string['fieldsnavigation'] = 'Fields tertiary navigation';
$string['fieldtagdescription'] = '{$a} description';
$string['fieldtagname'] = '{$a} name';
$string['fieldtagid'] = '{$a} ID';
$string['fieldupdated'] = 'Field updated';
$string['fieldwidth'] = 'Width';
$string['fieldwidthlistview'] = 'Width (in pixels) in list view';
$string['fieldwidthsingleview'] = 'Width (in pixels) in single view';
$string['file'] = 'File';
$string['filesnotgenerated'] = 'Not all files were generated: {$a}';
$string['filtername'] = 'Database auto-linking';
$string['footer'] = 'Footer';
$string['forcelinkname'] = 'Forced name for the link';
$string['foundnorecords'] = 'No records found. <a href="{$a->reseturl}">Clear all</a>';
$string['foundrecords'] = 'Found {$a->num} out of {$a->max} records. <a href="{$a->reseturl}">Clear all</a>';
$string['fromfile'] = 'Import from zip file';
$string['fromfile_help'] = 'The import from zip file feature allows you to browse for and upload a preset zip of templates and fields.';
$string['generateerror'] = 'Not all files generated!';
$string['header'] = 'Header';
$string['headeraddtemplate'] = 'Define the interface for adding or editing entries.';
$string['headerasearchtemplate'] = 'Define the interface for the advanced search.';
$string['headercsstemplate'] = 'Add custom CSS to templates.';
$string['headerjstemplate'] = 'Add custom JavaScript for the List, Single or Add entry templates.';
$string['headerlisttemplate'] = 'Define the appearance of List view.';
$string['headerrsstemplate'] = 'Define the appearance of entries in RSS feeds.';
$string['headersingletemplate'] = 'Define the appearance of Single view.';
$string['checkbox'] = 'Checkboxes';
$string['id'] = 'Entry ID';
$string['chooseexportfields'] = 'Choose the fields you wish to export';
$string['chooseexportformat'] = 'Choose the format you wish to export to';
$string['chooseorupload'] = 'Choose file';
$string['choosepreset'] = 'Preset file';
$string['expired'] = 'Sorry, this activity closed on {$a} and is no longer available';
$string['importentries'] = 'Import entries';
$string['importpreset'] = 'Import preset';
$string['importapreset'] = 'Import a preset';
$string['importsuccess'] = 'Preset applied.';
$string['importpresetmissingcapability'] = 'You don\'t have permission to import a preset.';
$string['includeapproval'] = 'Include approval status';
$string['includefiles'] = 'Include files in export';
$string['includetags'] = 'Include tags';
$string['includetime'] = 'Include time added/modified';
$string['includeuserdetails'] = 'Include user details';
$string['indicator:cognitivedepth'] = 'Database cognitive';
$string['indicator:cognitivedepth_help'] = 'This indicator is based on the cognitive depth reached by the student in a Database activity.';
$string['indicator:cognitivedepthdef'] = 'Database cognitive';
$string['indicator:cognitivedepthdef_help'] = 'The participant has reached this percentage of the cognitive engagement offered by the Database activities during this analysis interval (Levels = No view, View, Submit)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Database social';
$string['indicator:socialbreadth_help'] = 'This indicator is based on the social breadth reached by the student in a Database activity.';
$string['indicator:socialbreadthdef'] = 'Database social';
$string['indicator:socialbreadthdef_help'] = 'The participant has reached this percentage of the social engagement offered by the Database activities during this analysis interval (Levels = No participation, Participant alone)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insufficiententries'] = 'more entries needed to view this database';
$string['intro'] = 'Description';
$string['invalidaccess'] = 'This page was not accessed correctly';
$string['invalidfieldid'] = 'Field ID is incorrect';
$string['invalidfieldname'] = 'Please choose another name for this field';
$string['invalidfieldtype'] = 'Field type is incorrect';
$string['invalidid'] = 'Incorrect data ID';
$string['missingfieldtype'] = 'Field type for {$a->name} not found';
$string['missingfieldtypes'] = 'The following fields do not have their corresponding field types installed and will not be included in the Add entry form. You need to check the Add entry template and remove any field names.';
$string['missingfieldtypeimport'] = 'The following fields were not imported because their corresponding field types are not installed:';
$string['unknown'] = 'Unknown field';
$string['invalidpreset'] = '{$a} is not a preset.';
$string['invalidrecord'] = 'Incorrect record';
$string['invalidurl'] = 'The URL you just entered is not valid';
$string['importandapply'] = 'Import preset and apply';
$string['importpreset_desc'] = 'The preset will be applied to this activity, creating fields and templates.
 It won\'t appear in the list of presets.';
$string['jstemplate'] = 'Custom JavaScript';
$string['latitude'] = 'Latitude';
$string['latlong'] = 'Coordinates';
$string['latlongboth'] = 'Both latitude and longitude are required.';
$string['latlongdownloadallhint'] = 'Download link for all entries as KML';
$string['latlongkmllabelling'] = 'How to label items in KML files (Google Earth)';
$string['latlonglinkservicesdisplayed'] = 'Link-out services to display';
$string['latlongotherfields'] = 'Other fields';
$string['list'] = 'View list';
$string['listview'] = 'List view';
$string['listtemplate'] = 'List view template';
$string['longitude'] = 'Longitude';
$string['manageapproved'] = 'Allow editing of approved entries';
$string['manageapproved_help'] = 'Allow students to edit or delete their entries after they’ve been approved. Edited entries will need to be reapproved.';
$string['managefields'] = 'Manage fields';
$string['mapexistingfield'] = 'Map to {$a}';
$string['mapnewfield'] = 'Create a new field';
$string['mappingwarning'] = 'All old fields not mapped to a new field will be lost and all data in that field will be removed.';
$string['mapping:fieldstocreate'] = 'Fields to be created: {$a}';
$string['mapping:fieldstodelete'] = 'Existing fields to be deleted: {$a}';
$string['mapping:warningmessagedeleteandcreate'] = 'If fields to be deleted are of the same type as fields to be created, you may be able to map them in Map fields.';
$string['mapping:warningmessagedelete'] = 'If fields to be deleted are of the same type as new fields in the preset you\'re applying, you may be able to map them in Map fields.';
$string['mapping:mapfields'] = 'Map fields';
$string['mapping:applypresets'] = 'Apply preset';
$string['mapping:dialogtitle:usepreset'] = 'Apply preset {$a}?';
$string['maxentries'] = 'Maximum number of entries';
$string['maxentries_help'] = 'The maximum number of entries a student is allowed to submit for this activity.';
$string['maxsize'] = 'Maximum size';
$string['menu'] = 'Menu';
$string['menuchoose'] = 'Choose...';
$string['missingdata'] = 'Data ID or object must be provided for field class.';
$string['missingfield'] = 'Programmer error: You must specify field and/or data when defining field class.';
$string['modulename'] = 'Database';
$string['modulename_help'] = 'Database enables participants to create, maintain, and search a collection of entries.

The structure of the entries is defined using different types of fields, such as short text, dropdown list, text area, URL, image, or file.

As a teacher, you can comment and rate entries. You can also allow students to rate and comment on entries (peer evaluation). Ratings can be aggregated to form a final grade, which is recorded in the gradebook.

If the Database auto-linking filter is enabled, any entries in a database will be automatically linked where the words or phrases appear within the course.

You can use Database to:

* Create a collaborative collection of links, books, book reviews, journal references, etc.
* Display student-created photos, posters, websites or poems for peer comment and review.';
$string['modulename_link'] = 'mod/data/view';
$string['modulenameplural'] = 'Databases';
$string['more'] = 'More';
$string['moreurl'] = 'More URL';
$string['movezipfailed'] = 'Can\'t move zip';
$string['multientry'] = 'Repeated entry';
$string['multimenu'] = 'Menu (Multi-select)';
$string['multipletags'] = 'Multiple tags found! Template not saved';
$string['newentry'] = 'New entry';
$string['newfield'] = 'Create a field';
$string['newfield_help'] = 'A field allows the input of data. Each entry in a database activity can have multiple fields of multiple types such as a date field, which allows participants to select a day, month and year from a drop-down menu, a picture field, which allows participants to upload an image file, or a checkbox field, which allows participants to select one or more options.

Each field must have a unique field name. The field description is optional.';
$string['noaccess'] = 'You do not have access to this page';
$string['nodefinedfields'] = 'New preset has no defined fields!';
$string['nofieldcontent'] = 'Field content not found';
$string['nofieldindatabase'] = 'There are no fields defined for this database.';
$string['nofields'] = 'No fields yet';
$string['nolisttemplate'] = 'List view template is not yet defined';
$string['nomatch'] = 'No matching entries found!';
$string['nomaximum'] = 'No maximum';
$string['nopreviewavailable'] = 'No preview available for {$a}';
$string['norecords'] = 'No entries yet';
$string['notapproved'] = 'Pending approval';
$string['notapprovederror'] = 'Entry is not approved yet.';
$string['notinjectivemap'] = 'Not an injective map';
$string['notemplates'] = 'No templates yet';
$string['notopenyet'] = 'Sorry, this activity is not available until {$a}';
$string['number'] = 'Number';
$string['numberrssarticles'] = 'Entries in the RSS feed';
$string['numnotapproved'] = 'Pending';
$string['numrecords'] = '{$a} entries';
$string['ods'] = '<abbr title="OpenDocument Spreadsheet">ODS</abbr>&nbsp;(OpenOffice)';
$string['openafterclose'] = 'You have specified an open date after the close date';
$string['optionaldescription'] = 'Short description (optional)';
$string['optionalfilename'] = 'Filename (optional)';
$string['other'] = 'Other';
$string['otherfields'] = 'All other fields';
$string['overwrite'] = 'Overwrite';
$string['overrwritedesc'] = 'Replace existing preset with this name and overwrite its contents';
$string['overwritesettings'] = 'Overwrite current settings such as comments, ratings, etc.';
$string['page-mod-data-x'] = 'Any database activity module page';
$string['pagesize'] = 'Entries per page';
$string['participants'] = 'Participants';
$string['picture'] = 'Picture';
$string['pluginadministration'] = 'Database activity administration';
$string['pluginname'] = 'Database';
$string['portfolionotfile'] = 'Export to a portfolio rather than a file (csv and leap2a only)';
$string['presetdeleted'] = 'Preset deleted.';
$string['presetinfo'] = 'Saving as a preset will publish this template. Other users may be able to use it in their databases.';
$string['presetnotselected'] = 'No preset has been selected.';
$string['presets'] = 'Presets';
$string['presetshelp'] = 'Choose a preset to use as a starting point.';
$string['preview'] = 'Preview of {$a}';
$string['previewaction'] = 'Preview';
$string['privacy:metadata:commentpurpose'] = 'Comments on database records';
$string['privacy:metadata:data_content'] = 'The content of a field';
$string['privacy:metadata:data_content:fieldid'] = 'Field definition ID';
$string['privacy:metadata:data_content:content'] = 'Content';
$string['privacy:metadata:data_content:content1'] = 'Additional content 1';
$string['privacy:metadata:data_content:content2'] = 'Additional content 2';
$string['privacy:metadata:data_content:content3'] = 'Additional content 3';
$string['privacy:metadata:data_content:content4'] = 'Additional content 4';
$string['privacy:metadata:data_records'] = 'Records in the database activity';
$string['privacy:metadata:data_records:userid'] = 'User who created the record';
$string['privacy:metadata:data_records:groupid'] = 'Group';
$string['privacy:metadata:data_records:timecreated'] = 'Time when record was created';
$string['privacy:metadata:data_records:timemodified'] = 'Time when record was last modified';
$string['privacy:metadata:data_records:approved'] = 'Approval status';
$string['privacy:metadata:datafieldnpluginsummary'] = 'Fields for database activity module';
$string['privacy:metadata:filepurpose'] = 'File attached to the database record';
$string['privacy:metadata:tagpurpose'] = 'Tags on database records';
$string['privacy:metadata:ratingpurpose'] = 'Ratings on database records';
$string['radiobutton'] = 'Radio buttons';
$string['recordapproved'] = 'Entry approved';
$string['recorddeleted'] = 'Entry deleted';
$string['recorddisapproved'] = 'Entry unapproved';
$string['recordsnotsaved'] = 'No entry was saved. Please check the format of the uploaded file.';
$string['recordssaved'] = 'entries saved';
$string['removealldatatags'] = 'Remove all database tags';
$string['requireapproval'] = 'Approval required';
$string['requireapproval_help'] = 'A teacher has to approve entries before they’re visible to everyone.';
$string['required'] = 'Required';
$string['requiredentries'] = 'Entries required for completion (old)';
$string['requiredentries_help'] = "If set, a message is displayed stating the number of entries required for completion. Note that this setting is not connected to activity completion.

For entries required for activity completion, the new Activity completion setting 'Require entries' should be used. To remove this setting completely, set to none, then save changes.
Please use the Entries required fields in the Activity completion section instead.";
$string['requiredentrieswarning'] = 'This setting has been replaced by an Activity completion setting "Require entries"';
$string['requiredentriestoview'] = 'Entries required before viewing';
$string['requiredentriestoview_help'] = 'The number of entries a student is required to add before they can view entries from other students.

This is not compatible with the database auto-linking filter.';
$string['requiredfield'] = 'Required field';
$string['resetalltemplates'] = 'Reset all templates';
$string['resetalltemplatesconfirmtitle'] = 'Reset all templates?';
$string['resetalltemplatesconfirm'] = 'You\'re about to remove all templates for your current preset. If you want to restore the templates later, you need to choose the preset again in the \'Presets\' tab.';
$string['resetsettings'] = 'Reset filters';
$string['resettemplate'] = 'Reset current template';
$string['resettemplateconfirmtitle'] = 'Reset template?';
$string['resettemplateconfirm'] = 'This will permanently remove the {$a} for your current preset.';
$string['resizingimages'] = 'Resizing image thumbnails...';
$string['rows'] = 'rows';
$string['rssglobaldisabled'] = 'Disabled. See site configuration variables.';
$string['rsstemplate'] = 'RSS template';
$string['rsstitletemplate'] = 'RSS title template';
$string['rsstype'] = 'RSS feed for this activity';
$string['save'] = 'Save';
$string['saveandadd'] = 'Save and add another';
$string['saveandview'] = 'Save and view';
$string['saveaspreset'] = 'Publish preset on this site';
$string['saveaspreset_help'] = 'The save as preset feature publishes the templates and fields as a preset which others on the site can then use. (You may delete it from the list of presets at any time.)';
$string['savedataaspreset'] = 'Save all fields and templates and publish as preset on this site';
$string['saveaspresetmissingcapability'] = 'The user does not have permission to save the database as a preset.';
$string['savesettings'] = 'Save settings';
$string['savesuccess'] = 'Preset saved. <a href="{$a->url}">Preview preset</a>';
$string['search'] = 'Search';
$string['search:activity'] = 'Database - activity information';
$string['search:entry'] = 'Database - entries';
$string['searchresults'] = 'Entries containing "{$a}"';
$string['selectedrequired'] = 'All selected required';
$string['selectexportoptions'] = 'Select export options';
$string['selectfields'] = 'Select fields';
$string['selectfordeletion'] = 'Select entry for deletion';
$string['showall'] = 'Show all entries';
$string['showmore'] = 'Show more';
$string['single'] = 'View single';
$string['singleview'] = 'Single view';
$string['singletemplate'] = 'Single view template';
$string['startbuilding'] = 'Start building your activity';
$string['subplugintype_datafield'] = 'Database field type';
$string['subplugintype_datafield_plural'] = 'Database field types';
$string['subplugintype_datapreset'] = 'Preset';
$string['subplugintype_datapreset_plural'] = 'Presets';
$string['tagarea_data_records'] = 'Data records';
$string['tags'] = 'Tags';
$string['tagsdeleted'] = 'Database tags have been deleted';
$string['teachersandstudents'] = '{$a->teachers} and {$a->students}';
$string['templates'] = 'Templates';
$string['templatereset'] = 'Template reset';
$string['templateresetall'] = 'All templates reset';
$string['templatesnavigation'] = 'Templates tertiary navigation';
$string['templatesaved'] = 'Template saved';
$string['text'] = 'Text';
$string['textarea'] = 'Text area';
$string['timeadded'] = 'Time added';
$string['timemodified'] = 'Time modified';
$string['type'] = 'Field type';
$string['undefinedprocessactionmethod'] = 'No action method defined in Data_Preset to handle action "{$a}".';
$string['unsupportedfields'] = 'Unsupported fields';
$string['unsupportedfieldslist'] = 'The following fields cannot be exported:';
$string['updatefield'] = 'Update an existing field';
$string['uploadfile'] = 'Upload file';
$string['uploadrecords'] = 'Import entries';
$string['uploadrecords_help'] = 'Import entries that you have exported from another database, either via CSV or a ZIP containing a CSV file (if files are included in the export).

Alternatively, to create a CSV file for importing, add one entry to the database and then export it. Edit the CSV file and add more entries.';
$string['uploadrecords_link'] = 'mod/data/import';
$string['url'] = 'URL';
$string['usedate'] = 'Include in search.';
$string['usepredefinedset'] = 'Use predefined set';
$string['usepreset'] = 'Use this preset';
$string['usestandard'] = 'Use a preset';
$string['usestandard_help'] = 'To use a preset available to the whole site, select it from the list. (If you have added a preset to the list using the save as preset feature then you have the option of deleting it.)';
$string['viewfromdate'] = 'Read only from';
$string['viewnavigation'] = 'View mode tertiary navigation';
$string['viewtemplates'] = 'View templates';
$string['viewtodate'] = 'Read only to';
$string['viewtodatevalidation'] = 'The read only to date cannot be before the read only from date.';
$string['wrongdataid'] = 'Wrong data ID provided';

// Deprecated since Moodle 4.1.
$string['buttons'] = 'Actions';
$string['nolisttemplate'] = 'List view template is not yet defined';
$string['nosingletemplate'] = 'Single view template is not yet defined';
$string['pleaseaddsome'] = 'Please create some below or <a href="{$a}">choose a predefined set</a> to get started.';
$string['blank'] = 'Blank';
$string['savetemplate'] = 'Save template';
$string['addedby'] = 'Added by';
$string['addentries'] = 'Add entries';
$string['todatabase'] = 'to this database.';

// Deprecated since Moodle 4.2.
$string['fieldids'] = 'Field ids';

// Deprecated since Moodle 4.3.
$string['completionentries'] = 'Require entries';

// Deprecated since Moodle 4.4.
