<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'simplecertificate', language 'sr_cr', version '4.4'.
 *
 * @package     simplecertificate
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['awardedto'] = 'Додељује се полазнику';
$string['cantdeleteissue'] = 'Грешка приликом уклањања издатих сертификата';
$string['certificateimage'] = 'Датотека слике сертификата';
$string['certificateimage_help'] = 'Ово је слика која ће се користити на сертификату';
$string['certificatename'] = 'Назив сертификата';
$string['certificatename_help'] = 'Назив сертификата';
$string['certificatetext'] = 'Текст сертификата';
$string['certificatetext_help'] = 'Ово је текст који ће бити искоришћен за сертификат; неке посебне речи ће бити замењене променљивим вредностима, као што су назив курса, име студента, оцена...
То су:

{USERNAME} -> Пуно уме корисника

{COURSENAME} -> Пун назив курса (или дефинисани алтернативни назив курса)

{GRADE} -> Форматирана оцена

{DATE} -> Форматирани датум

{OUTCOME} -> Исходи

{HOURS} -> Дефинисани број часова на курсу

{TEACHERS} -> Списак предавача

Текст може да користи основни html, основне фонтове, табеле,  али избегавајте било какву дефиницију положаја текста';
$string['certificatetextx'] = 'Хоризонтални положај текста сертификата';
$string['certificatetexty'] = 'Вертикалан положај текста сертификата';
$string['certificateverification'] = 'Провера сертификата';
$string['certlifetime'] = 'Чувајте издате сертификате још: (у месецима)';
$string['certlifetime_help'] = 'Ова опција одређује временски период током којег желите да чувате издате сертификате. Сертификати који су старији од наведеног периода аутоматски се бришу.';
$string['code'] = 'Кôд';
$string['completiondate'] = 'Завршетак курса';
$string['coursegrade'] = 'Оцена на курсу';
$string['coursename'] = 'Алтернативни назив курса';
$string['coursename_help'] = 'Алтернативни назив курса';
$string['coursetimereq'] = 'Потребан број минута проведених на курсу';
$string['coursetimereq_help'] = 'Овде унесите минимално време, у минутима, које студенти морају да буде пријављени на систем, тј. да проведу на курсу, пре него што буду могли да добију сертификат.';
$string['datefmt'] = 'Формат датума';
$string['datefmt_help'] = 'Изаберите формат у којем ће бити одштампан датум на сертификату, или, изаберите последњу опцију како би датум био одштампан у формату корисниковог изабраног језика.';
$string['defaultcertificatetextx'] = 'Подразумевани хоризонталан положај текста';
$string['defaultcertificatetexty'] = 'Подразумевани вертикалан положај текста';
$string['defaultheight'] = 'Подразумевана висина';
$string['defaultwidth'] = 'Стандардна ширина';
$string['deletissuedcertificates'] = 'Обриши издате сертификате';
$string['delivery'] = 'Достава сертификата';
$string['delivery_help'] = 'Изаберите овде како желите да ваши студенти добију сертификат.
Отвори у веб читачу: отвара сертификат у новом прозору веб читача.
Обавезно преузимање: отвара прозор читача за преузимање датотеке.
Пошаљи сертификат е-поштом: ако је изабрана ова опција сертификат се шаље студенту као прилог е-поруци. Након што корисник добије свој сертификат, уколико кликне на линк сертификата на насловној страници курса, видеће датум када је добио сертификат и моћи ће да га прегледа.';
$string['designoptions'] = 'Опције за дизајн';
$string['download'] = 'Обавезно преузимање';
$string['emailcertificate'] = 'Пошаљи сертификат е-поштом (такође мора изабрати сачувај!)';
$string['emailfrom'] = 'Име пошиљаоца електронске поруке';
$string['emailfrom_help'] = 'Алтернативно име пошиљаоца електронске поруке';
$string['emailothers'] = 'Пошаљи е-поштом другима';
$string['emailothers_help'] = 'Унесите оведе електронске адресе, раздвојене зарезом, оних које треба обавестити електронско поштом сваки пут када студенти добију сертификат.';
$string['emailstudenttext'] = 'У прилогу је Ваш сертификат за курс {$a->course}.';
$string['emailteachermail'] = '{$a->student} је примио свој сертификат: \'{$a->certificate}\' за курс {$a->course}.

Можете га прегледати овде:

{$a->url}';
$string['emailteachermailhtml'] = '{$a->student} је примио свој сертификат: \'<i>{$a->certificate}</i>\' за курс {$a->course}.

Можете га прегледати овде:

<a href="{$a->url}">Извештај о сертификату</a>.';
$string['emailteachers'] = 'Пошаљи е-пошту предавачима';
$string['emailteachers_help'] = 'Ако је ова опција омогућена, онда ће предавачи бити обавештени е-поштом сваки пут када студенти добију сертификат';
$string['filenotfound'] = 'Датотека није пронађена: {$a}';
$string['getcertificate'] = 'Преузмите свој сертификат';
$string['grade'] = 'Оцена';
$string['gradefmt'] = 'Формат оцене';
$string['gradefmt_help'] = 'Ако желите да на сертификату одштампате оцену постоје три доступна формата:

Процентуална оцена: штампа оцену као проценат.
Бодовна оцена: штампа оцену као број бодова.
Словна оцена: штампа оцену као слово.';
$string['gradeletter'] = 'Словна оцена';
$string['gradepercent'] = 'Процентуална оцена';
$string['gradepoints'] = 'Бодовна оцена';
$string['height'] = 'Висина сертификата';
$string['hours'] = 'часa/ова';
$string['intro'] = 'Увод';
$string['invalidcode'] = 'Неисправан кôд сертификата';
$string['issued'] = 'Издат';
$string['issueddate'] = 'Датум издавања';
$string['issueoptions'] = 'Опције за издавање';
$string['keywords'] = 'сертификат, курс, pdf, moodle';
$string['modulename'] = 'Једноставан сертификат';
$string['modulenameplural'] = 'Једноставни сертификати';
$string['neverdeleteoption'] = 'Никада не бриши';
$string['nocertificatesissued'] = 'Не постоје сертификати који су издати';
$string['openbrowser'] = 'Отвори у новом прозору';
$string['opendownload'] = 'Кликните доње дугме да бисте сачували сертификат на свом рачунару';
$string['openemail'] = 'Кликните доње дугме и сертификат ће Вам бити послат као прилог е-поруци.';
$string['openwindow'] = 'Кликните доње дугме да бисте отворили сертификат у новом прозору веб читача';
$string['pluginadministration'] = 'Администрација сертификата';
$string['pluginname'] = 'Једноставан сертификат';
$string['printdate'] = 'Штампај датум';
$string['printdate_help'] = 'Ово је датум који ће бити одштампан ако изаберете опцију \'Штампај датум\'. У случају да је изабран датум завршетка курса, а студент курс није завршио, биће одштампан датум добијања серtификата. Такође, можете да изаберете да као датум буде одштампан дан када је активност оцењена. Ако се сертификат издаје пре оцењивања активности, биће одштампан датум добијања сертификата.';
$string['printgrade'] = 'Штампај оцену';
$string['printgrade_help'] = 'Можете да изаберете било коју доступну ставку из књиге оцена како бисте ту оцену штампали на сертификату, Ставке оцена поређане су истом редоследом којим се појављују у књизи оцена. Изаберите формат оцене доле.';
$string['printoutcome'] = 'Штампај исход';
$string['printoutcome_help'] = 'Можете да изаберете било који исход курса како бисте на сертификату одштампали назив исхода и резултат који је студент/корисник постигао. На пример: Исход задатака: Одличан (Вешт).';
$string['receiveddate'] = 'Датум добијања';
$string['report'] = 'Извештај';
$string['size'] = 'Величина сертификата';
$string['size_help'] = 'Ово је ширина и висина сертификата (у милиметрима). Стандардна величина је положена страница А4 формата';
$string['summaryofattempts'] = 'Резиме раније добијених сертификата';
$string['textposition'] = 'Положај текста сертификата';
$string['textposition_help'] = 'Ово су xy координате текста сертификата (у милиметрима)';
$string['userdateformat'] = 'Датум у формату језика корисника';
$string['viewcertificateviews'] = 'Погледај {$a} издатa/их сертификата';
$string['width'] = 'Ширина сертификата';
