<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'hu', version '4.4'.
 *
 * @package     forum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actionsforgraderinterface'] = 'Az értékelőfelülethez tartozó műveletek';
$string['actionsforpost'] = 'Üzenethez kapcsolódó lépések';
$string['activitydate:due'] = 'Esedékes:';
$string['activityoverview'] = 'Új fórumüzenetek érkeztek.';
$string['addanewdiscussion'] = 'Új beszélgetéstéma hozzáadása';
$string['addanewquestion'] = 'Új kérdés hozzáadása';
$string['addanewtopic'] = 'Új téma hozzáadása';
$string['addtofavourites'] = 'Beszélgetés megjelölése';
$string['advancedsearch'] = 'Részletes keresés';
$string['alldiscussions'] = 'Minden beszélgetés';
$string['allforums'] = 'Minden fórum';
$string['allowdiscussions'] = 'Egy {$a} hozzászólhat ehhez a fórumhoz?';
$string['allowsallsubscribe'] = 'A fórum bárki részére lehetővé teszi, hogy eldöntse: feliratkozik, avagy sem';
$string['allowsdiscussions'] = 'Ebben a fórumban mindenki egyetlen beszélgetéstémát adhat hozzá.';
$string['allsubscribe'] = 'Feliratkozás minden fórumra';
$string['allunsubscribe'] = 'Leiratkozás minden fórumról';
$string['allusers'] = 'Minden felhasználó';
$string['alreadyfirstpost'] = 'Ez már most is az első hozzászólás a beszélgetésben.';
$string['anyfile'] = 'Bármely állomány';
$string['areaattachment'] = 'Csatolt állományok';
$string['areapost'] = 'Üzenetek';
$string['attachment'] = 'Csatolt állomány';
$string['attachment_help'] = 'A hozzászólásokhoz állományokat csatolhat. Ha képet mellékel, az az üzenet után jelenik meg.';
$string['attachmentname'] = '{$a} csatolmány';
$string['attachmentnameandfilesize'] = '{$a->name} ({$a->size})';
$string['attachmentnopost'] = 'Hozzászólás-azonosító nélkül nem exportálhat csatolt állományokat.';
$string['attachments'] = 'Csatolt állományok';
$string['attachmentswordcount'] = 'Mellékletek és szószám';
$string['authorreplyingprivatelytoauthor'] = '{$a->respondant} magánban válaszol ennek: {$a->author}';
$string['authorreplyingtoauthor'] = '{$a->respondant} válaszol ennek: {$a->author}';
$string['availability'] = 'Elérhetőség';
$string['blockafter'] = 'Hozzászólás határértéke a blokkoláshoz';
$string['blockafter_help'] = 'Beállítja a felhasználók által adott idő alatt elküldött hozzászólások számát. után már nem küldhetnek további hozzászólásokat. A mod/forum:postwithoutthrottling jogosultságú felhasználókra a korlátozás nem vonatkozik.';
$string['blockperiod'] = 'Blokkolás időtartama';
$string['blockperiod_help'] = 'A tanulók adott idő alatt bizonyos számú hozzászólás után már nem küldhetnek további hozzászólásokat. A mod/forum:postwithoutthrottling jogosultságú felhasználókra a korlátozás nem vonatkozik.';
$string['blockperioddisabled'] = 'Ne blokkolja';
$string['blogforum'] = 'Standard fórum blogüzenetszerű megjelenítésben';
$string['bynameondate'] = '{$a->name} írta {$a->date} időpontban';
$string['cachedef_forum_is_tracked'] = 'Felhasználó fórumkövetés állapota';
$string['calendardue'] = '{$a} esedékes';
$string['cancelreply'] = 'Válasz törlése';
$string['cannotadd'] = 'Nem sikerült hozzáadni a beszélgetést a fórumhoz.';
$string['cannotadddiscussion'] = 'Beszélgetések hozzáadásához ehhez a fórumhoz csoporttagságra van szükség.';
$string['cannotadddiscussionall'] = 'Nincs jogosultsága új beszélgetéstémát hozzáadni az összes résztvevő számára.';
$string['cannotadddiscussiongroup'] = 'Nem tud beszélgetést létrehozni, mert Ön nem tagja egy csoportnak sem.';
$string['cannotaddsubscriber'] = 'A(z) {$a} azonosítójú feliratkozót nem adhatja hozzá ehhez a fórumhoz';
$string['cannotaddteacherforumto'] = 'A kurzus 0. szakaszához nem lehetett hozzáadni az átalakított tanári fórumot.';
$string['cannotcreatediscussion'] = 'Nem sikerült új beszélgetést létrehozni.';
$string['cannotcreateinstanceforteacher'] = 'Nem sikerült új kurzusmodult létrehozni a tanári fórumhoz.';
$string['cannotdeletepost'] = 'Nem törölheti ezt a hozzászólást.';
$string['cannoteditposts'] = 'Nem szerkesztheti mások hozzászólását!';
$string['cannotexportforum'] = 'Ezt a fórumot nem exportálhatja';
$string['cannotfavourite'] = 'Nincs jogosultsága beszélgetések megjelölésére.';
$string['cannotfinddiscussion'] = 'A beszélgetés nem található a fórumban';
$string['cannotfindfirstpost'] = 'Nincs meg a fórum első hozzászólása';
$string['cannotfindorcreateforum'] = 'A portálhoz nem található vagy nem hozható létre fő hírfórum';
$string['cannotfindparentpost'] = 'A(z) {$a} hozzászólás legfölső eleme nem található.';
$string['cannotmovefromsingleforum'] = 'A beszélgetés egyetlen egyszerű vitafórumból nem helyezhető át.';
$string['cannotmovenotvisible'] = 'A fórum nem látható.';
$string['cannotmovetonotexist'] = 'A fórumot nem helyezheti át, mert nem létezik!';
$string['cannotmovetonotfound'] = 'A célfórum nem található ebben a kurzusban.';
$string['cannotmovetosingleforum'] = 'A beszélgetés nem helyezhető át egyetlen egyszerű vitafórumba.';
$string['cannotpindiscussions'] = 'Nincs jogosultsága beszélgetések kitűzésére.';
$string['cannotpurgecachedrss'] = 'A gyorsítótárba helyezett RSS-hírek a forrásfórumból és/vagy a célfórumból nem törölhető - ellenőrizze a permissionsforums állományt.';
$string['cannotremovesubscriber'] = 'A(z) {$a} azonosítójú feliratkozót nem távolíthatja el ebből a fórumból';
$string['cannotreply'] = 'Erre a hozzászólásra nem válaszolhat.';
$string['cannotsplit'] = 'A fórum beszélgetései nem oszthatók föl.';
$string['cannotsubscribe'] = 'Feliratkozáshoz csoporttagnak kell lennie.';
$string['cannottrack'] = 'A fórum nyomon követését nem lehetett leállítani.';
$string['cannotunsubscribe'] = 'Kiiratkoztatása a fórumból nem sikerült.';
$string['cannotupdatepost'] = 'A hozzászólást nem frissítheti.';
$string['cannotviewpostyet'] = 'Más tanulók hozzászólásait ebben a megbeszélésben még nem láthatja, mert még nem szólt hozzá.';
$string['cannotviewusersposts'] = 'Ennek a felhasználónak nincs az Ön által megtekinthető hozzászólása';
$string['cleanreadtime'] = 'A régi hozzászólásokat ekkor törölje';
$string['clicktofavourite'] = 'Nem jelölte meg ezt a beszélgetést. Kattintson a megjelöléshez.';
$string['clicktolockdiscussion'] = 'Kattintson a beszélgetés lezárásához';
$string['clicktosubscribe'] = 'Nincs feliratkozva erre a beszélgetésre. Kattintson a feliratkozáshoz.';
$string['clicktounfavourite'] = 'Megjelölte ezt a beszélgetést. Kattintson a megjelölés törléséhez.';
$string['clicktounlockdiscussion'] = 'Kattintson a beszélgetés feloldásához';
$string['clicktounsubscribe'] = 'Feliratkozott a beszélgetésre. Kattintson a leiratkozáshoz.';
$string['close'] = 'Bezárás';
$string['closegrader'] = 'Az értékelő bezárása';
$string['completiondetail:discussions'] = 'Beszélgetések indítása: {$a}';
$string['completiondetail:posts'] = 'Fórumüzenetek létrehozása: {$a}';
$string['completiondetail:replies'] = 'Válaszok beküldése: {$a}';
$string['completiondiscussions'] = 'Beszélgetések indítása';
$string['completiondiscussionsdesc'] = 'A tanulónak legalább {$a} beszélégetést létre kell hoznia';
$string['completiondiscussionsgroup'] = 'Viták előírása';
$string['completiondiscussionshelp'] = 'viták befejezésének előírása';
$string['completionposts'] = 'Beszélgetések indítása vagy hozzászólások közzététele';
$string['completionpostsdesc'] = 'A tanulónak legalább {$a} beszélgetést vagy hozzászólást kell közzétennie';
$string['completionpostsgroup'] = 'Hozzászólások előírása';
$string['completionpostshelp'] = 'beszélgetések vagy hozzászólások közzétételének előírása a teljesítéshez';
$string['completionreplies'] = 'A tanulónak választ kell küldeni:';
$string['completionrepliesdesc'] = 'A tanulónak legalább  {$a} választ be kell küldenie';
$string['completionrepliesgroup'] = 'Válaszok előírása';
$string['completionreplieshelp'] = 'válaszok befejezésének előírása';
$string['configcleanreadtime'] = 'A nap azon órája, amikor a rendszer törli az olvasási táblázatból a régi hozzászólásokat.';
$string['configdigestmailtime'] = 'Azok, akik összesítve kérik az e-mailek kézbesítését, ezt naponta fogják megkapni. Ezzel állítható be, hogy a napi e-mail elküldése hány órakor történjék (az adott óra utáni első cron fogja elküldeni).';
$string['configdisplaymode'] = 'A beszélgetések alapértelmezett megjelenítési módja, ha más nincs megadva';
$string['configenablerssfeeds'] = 'Ezzel kapcsolható be minden fórum esetén az RSS-frissítés. A fórumok beállításai között a frissítések bekapcsolását továbbra is kézzel kell elvégezni.';
$string['configenabletimedposts'] = '\'Igen\'-re állítva lehetséges a megjelenítési időszakok beállítása az új fórumbeszélgetések beküldésekor.';
$string['configlongpost'] = 'Minden ennél hosszabb (HTML karakterek nélkül számított) hozzászólás hosszúnak tekintendő. A portál kezdőoldalán, a fórumformájú kurzusok oldalain és a felhasználói profilokban megjelenő hozzászólások rövidítve láthatók a forum_shortpost és a forum_longpost közötti intervallumban.';
$string['configmanydiscussions'] = 'Az oldalanként megjelenítendő beszélgetések maximális száma';
$string['configmaxattachments'] = 'A hozzászólásonként megengedett csatolt állományok alapbeállítás szerinti maximális száma';
$string['configmaxbytes'] = 'A portálon az összes fórumhoz csatolt állomány alapbeállítás szerinti maximális mérete (a kurzuskorlátok és más helyi beállítások függvényében)';
$string['configoldpostdays'] = 'Ennyi nap elteltével a hozzászólások elolvasottnak tekintendők.';
$string['configreplytouser'] = 'Ha egy hozzászólást postáznak, tartalmazza-e a felhasználó e-mail címét, hogy a címzettek személy szerint válaszolhassanak a fórum helyett? Még \'Igen\' beállítás esetén is dönthet úgy a felhasználó, hogy profiljában titokban tartja e-mail címét.';
$string['configrssarticlesdefault'] = 'Bekapcsolt RSS-hírek esetén beállítja a cikkek (beszélgetések vagy hozzászólások) alapszámát.';
$string['configrsstypedefault'] = 'Bekapcsolt RSS-hírek esetén beállítja az alaptevékenység típusát.';
$string['configshortpost'] = 'Minden ennél rövidebb
(HTML nélküli) hozzászólás rövidnek tekintendő.';
$string['configsubscriptiontype'] = 'Alapbeállítás a jelentkezési módhoz.';
$string['configtrackingtype'] = 'Olvasás figyelésének alapbeállítása';
$string['configtrackreadposts'] = 'Állítsa \'igen\'-re, ha a felhasználók mindegyikénél figyelni kívánja, hogy elolvasta-e a hozzászólást.';
$string['configusermarksread'] = 'Ha \'igen\', a felhasználónak kézzel kell a hozzászólás elolvasását megadni. Ha \'nem\', az üzenet megtekintésekor megkapja az \'elolvasott\' megjelölést.';
$string['confirmsubscribe'] = 'Biztosan feliratkozik a(z) \'{$a}\' fórumra?';
$string['confirmsubscribediscussion'] = 'Biztosan feliratkozik a \'{$a->forum}\' fórum  \'{$a->discussion}\' beszélgetésére?';
$string['confirmunsubscribe'] = 'Biztosan leiratkozik a(z) \'{$a}\' fórumról?';
$string['confirmunsubscribediscussion'] = 'Biztosan leiratkozik a  \'{$a->forum}\' fórum  \'{$a->discussion}\' beszélgetéséről?';
$string['couldnotadd'] = 'Ismeretlen hiba miatt a hozzászólást nem lehetett hozzáadni';
$string['couldnotdeletereplies'] = 'Nem törölhető, már válaszoltak rá';
$string['couldnotupdate'] = 'Ismeretlen hiba miatt a hozzászólását nem lehetett frissíteni';
$string['created'] = 'Létrehozva';
$string['crontask'] = 'Fórum levelezési és karbantartási feladatai';
$string['cutoffdate'] = 'Lezárás időpontja';
$string['cutoffdate_help'] = 'Beállítása esetén ezen időpont után a rendszer nem fogad el fórumüzeneteket.';
$string['cutoffdatereached'] = 'A fórumüzenetek beküldésének határideje lejárt, ezért ide már nem küldhet üzenetet.';
$string['cutoffdatevalidation'] = 'A lezárás időpontja nem lehet korábbi, mint a leadási határidő.';
$string['delete'] = 'Törlés';
$string['deleteddiscussion'] = 'A beszélgetéstéma törölve';
$string['deletedpost'] = 'A hozzászólást törölték';
$string['deletedposts'] = 'A hozzászólásokat törölték';
$string['deleteduser'] = 'Törölt felhasználó';
$string['deletesure'] = 'Biztosan törölni akarja a hozzászólást?';
$string['deletesureplural'] = 'Biztosan törölni akarja a hozzászólást és minden választ? ({$a} hozzászólás)';
$string['digestmailheader'] = 'Ez a(z) {$a->sitename} portál fórumaira érkezett hozzászólásainak napi összesítése. A fórum e-mail beállításainak a módosításához térjen át ide: {$a->userprefs}.';
$string['digestmailpost'] = 'Fórumolvasási beállítások módosítása';
$string['digestmailpostlink'] = 'Összesített fórumüzenetek beállításainak módosítása: {$a}';
$string['digestmailprefs'] = 'az Ön felhasználói profilja';
$string['digestmailsubject'] = '{$a}: fórum összesítése';
$string['digestmailtime'] = 'Összesített e-mailek elküldésének órája';
$string['digestsentusers'] = 'E-mail összesítések sikeresen elküldve {$a} felhasználónak.';
$string['disallowsubscribe'] = 'Feliratkozás nem engedélyezett';
$string['disallowsubscribeteacher'] = 'Feliratkozás nem engedélyezett (a tanárokat kivéve)';
$string['disallowsubscription'] = 'Feliratkozás';
$string['disallowsubscription_help'] = 'A fórum beállításai nem engedélyezik a beszélgetésekre való feliratkozást.';
$string['discussion'] = 'Beszélgetés';
$string['discussionlistsortbycreatedasc'] = 'Rendezés növekvő sorrendben a létrehozási idő alapján';
$string['discussionlistsortbycreateddesc'] = 'Rendezés csökkenő sorrendben a létrehozási idő alapján';
$string['discussionlistsortbydiscussionasc'] = 'Rendezés beszélgetés címe szerint növekvő sorrendben';
$string['discussionlistsortbydiscussiondesc'] = 'Rendezés beszélgetés címe szerint csökkenő sorrendben';
$string['discussionlistsortbygroupasc'] = 'Rendezés csoportonként emelkedő sorrendben';
$string['discussionlistsortbygroupdesc'] = 'Rendezés csoportonként csökkenő sorrendben';
$string['discussionlistsortbylastpostasc'] = 'Rendezés növekvő sorrendben az utolsó bejegyzés létrehozási ideje alapján';
$string['discussionlistsortbylastpostdesc'] = 'Rendezés csökkenő sorrendben az utolsó bejegyzés létrehozási ideje alapján';
$string['discussionlistsortbyrepliesasc'] = 'Rendezés növekvő sorrendben a válaszok száma alapján';
$string['discussionlistsortbyrepliesdesc'] = 'Rendezés csökkenő sorrendben a válaszok száma alapján';
$string['discussionlistsortbystarterasc'] = 'Rendezés a beszélgetést elindító neve szerint növekvő sorrendben';
$string['discussionlistsortbystarterdesc'] = 'Rendezés a beszélgetést elindító neve szerint csökkenő sorrendben';
$string['discussionlocked'] = 'A beszélgetést lezárták, már nem szólhat hozzá.';
$string['discussionlockingdisabled'] = 'Ne zárja le a beszélgetéseket';
$string['discussionlockingheader'] = 'Beszélgetéslezárás';
$string['discussionmoved'] = 'A beszélgetés átkerült ide: \'{$a}\'.';
$string['discussionmovedpost'] = 'A beszélgetés átkerült a(z) <a href="{$a->forumhref}">{$a->forumname}</a> fórumon belül <a href="{$a->discusshref}">ide</a>';
$string['discussionname'] = 'Beszélgetés megnevezése';
$string['discussionnownotsubscribed'] = '{$a->name} NEM értesül a(z) \'{$a->forum}\' fórum \'{$a->discussion}\' beszélgetéséhez küldött új hozzászólásokról';
$string['discussionnowsubscribed'] = 'Értesülni fog a(z) \'{$a->forum}\' fórum \'{$a->discussion}\' beszélgetéséhez küldött új hozzászólásokról.';
$string['discussionpin'] = 'Megjelöl';
$string['discussionpinned'] = 'Megjelölt';
$string['discussionpinned_help'] = 'A kitűzött beszélgetése a fórum tetején jelennek meg.';
$string['discussions'] = 'Beszélgetések';
$string['discussionsplit'] = 'A beszélgetés felosztva';
$string['discussionsstartedby'] = '{$a} által indított beszélgetések';
$string['discussionsstartedbyrecent'] = '{$a} által nemrég indított beszélgetések';
$string['discussionsstartedbyuserincourse'] = '{$a->fullname} {$a->coursename} kurzusban indított beszélgetései';
$string['discussionsstartedincourse'] = '{$a} kurzusban indított beszélgetések';
$string['discussionstartedby'] = '{$a} által indított beszélgetések';
$string['discussionsubscribed'] = 'Mostantól feliratkozott erre a beszélgetésre.';
$string['discussionsubscribestart'] = 'Kérek értesítéseket a beszélgetéshez érkező új hozzászólásokról';
$string['discussionsubscribestop'] = 'Nem kérek értesítéseket a beszélgetéshez érkező új hozzászólásokról';
$string['discussionsubscription'] = 'Beszélgetésfeliratkozás';
$string['discussionsubscription_help'] = 'Egy beszélgetésre feliratkozva értesítéseket fog kapni a beszélgetéshez érkező új hozzászólásokról.';
$string['discussionunpin'] = 'Jelölés törlése';
$string['discussionunsubscribed'] = 'Mostantól leiratkozott erről a beszélgetésről.';
$string['discussthistopic'] = 'Téma megvitatása';
$string['discusstopicname'] = '{$a} téma megvitatása';
$string['displayend'] = 'Megjelenítés vége';
$string['displayend_help'] = '<p>Megadhatja, hogy egy fórumüzenet egy meghatározott naptól legyen látható, egy megadott napon túl már
ne legyen látható, illetve csak egy megadott időszakban legyen látható.</p>

<p>A kijelzés kezdetét/végét a kikapcsoló opció kijelölésének megszüntetésével kapcsolhatja be.</p>

<p>A rendszergazdák az üzeneteket megjelenésük előtt és levételük után is láthatják.</p>';
$string['displayenddate'] = 'Befejezés megjelenítése: {$a}.';
$string['displaymode'] = 'Megjelenítési mód';
$string['displayperiod'] = 'Megjelenítési időtartam';
$string['displaystart'] = 'Megjelenítés kezdete';
$string['displaystart_help'] = '<p>Megadhatja, hogy egy fórumüzenet egy meghatározott naptól legyen látható, egy megadott napon túl már
ne legyen látható, illetve csak egy megadott időszakban legyen látható.</p>

<p>A kijelzés kezdetét/végét a kikapcsoló opció kijelölésének megszüntetésével kapcsolhatja be.</p>

<p>A rendszergazdák az üzeneteket megjelenésük előtt és levételük után is láthatják.</p>';
$string['displaystartdate'] = 'Kezdés megjelenítése: {$a}.';
$string['displaywordcount'] = 'Szószám megjelenítése';
$string['displaywordcount_help'] = 'Megszabja, hogy az egyes üzenetekben szereplő szavak száma látsszon-e.';
$string['duedate'] = 'Határidő';
$string['duedate_help'] = 'Üzenet küldése a fórumra ekkor esedékes. Noha a naptárban ez a dátum szerepel esedékesként, a fórumra küldhet üzenetet ez után is. Ha korlátozni kívánja az üzenetek küldését, állítson be egy végső határidőt.';
$string['duedatetodisplayincalendar'] = 'A naptárban megjelenítendő esedékességi idő';
$string['eachuserforum'] = 'Mindenki egy beszélgetést indít';
$string['edit'] = 'Szerkesztés';
$string['editedby'] = 'Szerkesztette {$a->name} - eredeti leadás ideje: {$a->date}';
$string['editedpostupdated'] = '{$a} hozzászólásának frissítése megtörtént.';
$string['editing'] = 'Szerkesztés';
$string['emaildigestcompleteshort'] = 'Teljes üzenetek';
$string['emaildigestdefault'] = 'Alapbeállítás ({$a})';
$string['emaildigestoffshort'] = 'Ne ömlesztve';
$string['emaildigestsubjectsshort'] = 'Csak a tárgy';
$string['emaildigesttype'] = 'Fórumolvasási lehetőségek';
$string['emaildigesttype_help'] = 'Az egyes fórumokról kapott értesítés típusa

* Alapbeállítás - a felhasználói profiljában szereplő olvasási beállítás. Ha frissíti profilját, az itt is megjelenik;
* Ne ömlesztve - fórumüzenetenként egy e-mailt fog kapni.
* Ömlesztve - teljes üzenetek - naponta egy ömlesztett e-mailt fog kapni az összes fórumüzenet tartalmával;
* Ömlesztve - csak a tárgy -
naponta egy ömlesztett e-mailt fog kapni az összes fórumüzenet tárgyával';
$string['emptymessage'] = 'Hiba a hozzászólásban. Talán üresen hagyta, vagy túl nagy a csatolt állomány. A változásokat a rendszer NEM mentette el.';
$string['errorcannotlock'] = 'Nincs jogosultsága beszélgetések lezárásához';
$string['erroremptymessage'] = 'A hozzászólás szövege nem lehet üres.';
$string['erroremptysubject'] = 'A hozzászólás tárgya nem lehet üres.';
$string['errorenrolmentrequired'] = 'A tartalom eléréséhez fel kell vennie a kurzust.';
$string['errorwhiledelete'] = 'Hiba a rekord törlése közben.';
$string['eventassessableuploaded'] = 'Tartalmat küldtek be';
$string['eventcoursesearched'] = 'Keresett kurzus';
$string['eventdiscussioncreated'] = 'Beszélgetés létrehozva';
$string['eventdiscussiondeleted'] = 'Beszélgetés törölve';
$string['eventdiscussionmoved'] = 'Beszélgetés áthelyezve';
$string['eventdiscussionpinned'] = 'Beszélgetés megjelölve';
$string['eventdiscussionsubscriptioncreated'] = 'Beszélgetésfeliratkozás létrehozva';
$string['eventdiscussionsubscriptiondeleted'] = 'Beszélgetésfeliratkozás törölve';
$string['eventdiscussionunpinned'] = 'Beszélgetés kitűzése törölve';
$string['eventdiscussionupdated'] = 'Beszélgetés frissítve';
$string['eventdiscussionviewed'] = 'Beszélgetés megtekintve';
$string['eventpostcreated'] = 'Hozzászólás létrehozva';
$string['eventpostdeleted'] = 'Hozzászólás törölve';
$string['eventpostupdated'] = 'Hozzászólás frissítve';
$string['eventreadtrackingdisabled'] = 'Olvasás követése kikapcsolva';
$string['eventreadtrackingenabled'] = 'Olvasás követése bekapcsolva';
$string['eventsubscribersviewed'] = 'Megtekintett regisztráló';
$string['eventsubscriptioncreated'] = 'Regisztráció létrehozva';
$string['eventsubscriptiondeleted'] = 'Regisztráció törölve';
$string['eventuserreportviewed'] = 'Felhasználói jelentés megtekintve';
$string['everyonecanchoose'] = 'Mindenki feliratkozhat';
$string['everyonecannowchoose'] = 'Mindenki feliratkozhat most';
$string['everyoneisnowsubscribed'] = 'Erre a fórumra most mindenki feliratkozott';
$string['everyoneissubscribed'] = 'Erre a fórumra mindenki feliratkozott';
$string['existingsubscribers'] = 'Feliratkozottak';
$string['export'] = 'Exportálás';
$string['exportattachmentname'] = '{$a} csatolmány exportálása a portfólióba';
$string['exportdiscussion'] = 'A teljes beszélgetés exportálása portfólióba';
$string['exporthumandates'] = 'Olvasható dátumok';
$string['exporthumandates_help'] = 'A dátumokat olvasható formában vagy időbélyegzőként (számsorként) exportálja.';
$string['exportoptions'] = 'Exportálási lehetőségek';
$string['exportstriphtml'] = 'HTML eltávolítása';
$string['exportstriphtml_help'] = 'A fórumüzenetből törlődjenek-e a HTML-címkéke, pl. a p vagy a br.';
$string['favourites'] = 'Megjelölve';
$string['favouriteupdated'] = 'Megjelölését frissítettük.';
$string['firstpost'] = 'Első üzenet';
$string['forcedreadtracking'] = 'Előírt olvasás nyomon követésének engedélyezése';
$string['forcedreadtracking_desc'] = 'Fórumok előírt olvasás nyomon követésére való beállításának engedélyezése. Egyes felhasználóknál - különösen sok fórum és üzenet esetén - teljesítménycsökkenéssel jár. Kikapcsolása esetén a korábban előírtra beállított fórumokat választhatóként kezeli.';
$string['forcesubscribed'] = 'Ez a fórum mindenkit feliratkoztat';
$string['forcesubscribed_help'] = 'A fórum beállításai nem engedélyezik a beszélgetésekről való leiratkozást.';
$string['forum'] = 'Fórum';
$string['forum:addinstance'] = 'Új fórum hozzáadása';
$string['forum:addnews'] = 'Hírek hozzáadása';
$string['forum:addquestion'] = 'Kérdés hozzáadása';
$string['forum:allowforcesubscribe'] = 'Feliratkoztatás engedélyezése';
$string['forum:canoverridecutoff'] = 'Üzenet küldése a fórumokra beküldési határidejük után';
$string['forum:canoverridediscussionlock'] = 'Hozzászólás lezárt beszélgetésekhez';
$string['forum:canposttomygroups'] = 'Elküldés minden elérhető csoporthoz';
$string['forum:cantogglefavourite'] = 'Beszélgetések megjelölése';
$string['forum:createattachment'] = 'Csatolt állományok létrehozása';
$string['forum:deleteanypost'] = 'Bármely hozzászólás törlése (bármikor)';
$string['forum:deleteownpost'] = 'Saját hozzászólások törlése (határidőn belül)';
$string['forum:editanypost'] = 'Bármely hozzászólás szerkesztése';
$string['forum:exportdiscussion'] = 'A teljes beszélgetés exportálása';
$string['forum:exportforum'] = 'Fórum exportálása';
$string['forum:exportownpost'] = 'Saját hozzászólás exportálása';
$string['forum:exportpost'] = 'Hozzászólás exportálása';
$string['forum:grade'] = 'Fórumhoz tartozó értékelés';
$string['forum:managesubscriptions'] = 'Feliratkozók kezelése';
$string['forum:movediscussions'] = 'Beszélgetések áthelyezése';
$string['forum:pindiscussions'] = 'Beszélgetések kitűzése';
$string['forum:postprivatereply'] = 'Hozzászólásokra válaszadás magánjelleggel';
$string['forum:postwithoutthrottling'] = 'Mentesség az üzenetküldési korlát alól';
$string['forum:rate'] = 'Hozzászólások értékelése';
$string['forum:readprivatereplies'] = 'Magánjellegű válaszok megtekintése';
$string['forum:replynews'] = 'Válasz a hírekre';
$string['forum:replypost'] = 'Válasz a hozzászólásokra';
$string['forum:splitdiscussions'] = 'Beszélgetések felosztása';
$string['forum:startdiscussion'] = 'Új beszélgetések indítása';
$string['forum:viewallratings'] = 'Minden egyénileg készített értékelés megtekintése';
$string['forum:viewanyrating'] = 'Az illetők részére beérkezett összes értékelés megtekintése';
$string['forum:viewdiscussion'] = 'Beszélgetések megtekintése';
$string['forum:viewhiddentimedposts'] = 'Rejtett ütemezett hozzászólások megtekintése';
$string['forum:viewqandawithoutposting'] = 'K/V-hozzászólások folyamatos megjelenítése';
$string['forum:viewrating'] = 'Az általam elért összesített értékelés megtekintése';
$string['forum:viewsubscribers'] = 'Feliratkozottak megtekintése';
$string['forumauthorhidden'] = 'Szerző (rejtett)';
$string['forumblockingalmosttoomanyposts'] = 'Közelíti a hozzászólások határértékét. Az utolsó {$a->blockperiod} alatt {$a->numposts} alkalommal küldött hozzászólást, a határ pedig {$a->blockafter} hozzászólás';
$string['forumbodydeleted'] = 'A fórumüzenet tartalma törlésre került, már nem elérhető.';
$string['forumbodyhidden'] = 'Ez hozzászólás jelenleg rejtve van, feltehetőleg azért, mert még nem szólt hozzá a beszélgetéshez és a fórum hozzászólás-értesítéseit el kell küldeni. Egy másik lehetőség, hogy a jelenlegi időpont kívül esik a hozzászólásnál beállított megjelenítési időszakon.';
$string['forumgrader'] = 'Fórumértékelő';
$string['forumgradingnavigation'] = 'Fórumértékelés navigáció';
$string['forumgradingpanel'] = 'Fórumértékelés panel';
$string['forumintro'] = 'Leírás';
$string['forumname'] = 'Fórum neve';
$string['forumposts'] = 'Fórum hozzászólásai';
$string['forums'] = 'Fórumok';
$string['forumsubjectdeleted'] = 'A fórumüzenet törlésre került';
$string['forumsubjecthidden'] = 'Tárgy (rejtett)';
$string['forumtracked'] = 'Az olvasatlan hozzászólások figyelése';
$string['forumtrackednot'] = 'Az olvasatlan hozzászólások figyelmen kívül hagyása';
$string['forumtype'] = 'Fórum típusa';
$string['forumtype_help'] = 'Ötféle fórumtípus létezik:

* Egyetlen egyszerű beszélgetés - Mindössze egyetlen beszélgetéstéma, amelyre bárki válaszolhat (nem használható külön csoportokkal).
* Mindenki egy beszélgetést indít - Minden tanuló pontosan egy új beszélgetést indíthat, melyre azután bárki válaszolhat.
* Kérdés-felelet fórum - A tanulónak hozzá kell szólnia a tanár által közzétett kérdéshez, mielőtt a többiek hozzászólásait láthatná.
* Általános fórum blogszerű formában - Olyan nyitott fórum, ahol bárki bármikor új témát indíthat. A témák egy oldalon jelennek meg, egy-egy "Téma megbeszélése" hivatkozással.
* Standard általános fórum -  Olyan nyitott fórum, ahol bárki bármikor új témát kezdeményezhet.';
$string['generalforum'] = 'Általános célú fórum';
$string['generalforums'] = 'Általános fórumok';
$string['grade_forum_header'] = 'Teljes fórum értékelése';
$string['grade_forum_name'] = 'A teljes fórum';
$string['grade_forum_title'] = 'Értékelés';
$string['grade_rating_name'] = 'Értékelés';
$string['graded'] = 'Értékelve';
$string['gradedby'] = 'Értékelte';
$string['gradeforrating'] = 'Értékelésekből számított értékelés: {$a->str_long_grade}';
$string['gradeforratinghidden'] = 'Értékelésekből számított értékelés rejtve';
$string['gradeforwholeforum'] = 'Fórumértékelés: {$a->str_long_grade}';
$string['gradeforwholeforumhidden'] = 'Fórumértékelés rejtve';
$string['gradeitem:forum'] = 'Fórum';
$string['gradeitemnameforrating'] = '{$a->name} értékelése';
$string['gradeitemnameforwholeforum'] = '{$a->name} teljes fóruma';
$string['grades:gradesavedfor'] = '{$a->fullname} értékelése elmentve';
$string['grades:gradesavefailed'] = '{$a->fullname} értékelését nem sikerült menteni: {$a->error}';
$string['gradeusers'] = 'Felhasználók értékelése';
$string['grading'] = 'Értékelés';
$string['gradingstatus'] = 'Értékelés állapota:';
$string['hiddenforumpost'] = 'Rejtett fórumüzenet';
$string['hidegraderpanel'] = 'Értékelőpanel elrejtése';
$string['hidepreviousrepliescount'] = 'Korábbi válaszok elrejtése  ({$a})';
$string['hideusersearch'] = 'Felhasználókeresés elrejtése';
$string['indexoutoftotal'] = '{$a->total} / {$a->index}';
$string['indicator:cognitivedepth'] = 'Kognitív fórum';
$string['indicator:cognitivedepth_help'] = 'Ez a jelző a tanuló által a fórum kapcsán elért kognitív mélységen alapul.';
$string['indicator:cognitivedepthdef'] = 'Kognitív fórum';
$string['indicator:cognitivedepthdef_help'] = 'A résztvevő az elemzési időszak alatt a Fórum tevékenységei során kognitív elfoglaltság terén ezt a százalékot érte el (Szintek - Nincs megtekintés, Megtekintés, Leadás, Visszajelzés megtekintése, Visszajelzéshez kapcsolódó megjegyzés, Újbóli leadás visszajelzés megtekintése után)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Társas fórum';
$string['indicator:socialbreadth_help'] = 'Ez a jelző a tanuló által a fórum kapcsán elért társas lefedettségen alapul.';
$string['indicator:socialbreadthdef'] = 'Társas fórum';
$string['indicator:socialbreadthdef_help'] = 'A résztvevő az elemzési időszak alatt a Fórum tevékenységei során társas elfoglaltság terén ezt a százalékot érte el (Szintek - Nincs részvétel, Egyedüli részvétel, Másokkal együtt való részvétel)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['inforum'] = '{$a} fórumban';
$string['inreplyto'] = 'Válasz erre: {$a}';
$string['introblog'] = 'A fórum üzenetei a kurzus felhasználóinak blogjaiból automatikusan kerültek ide, mert a blogüzenetek már nem elérhetők.';
$string['intronews'] = 'Általános hírek és közlemények';
$string['introsocial'] = 'Nyitott fórum, ahol bármit meg lehet beszélni';
$string['introteacher'] = 'Fórum csak a tanárok megjegyzései és beszélgetései számára';
$string['invalidaccess'] = 'Az oldal elérése hibásan történt';
$string['invaliddigestsetting'] = 'Érvénytelen olvasási beállítást adtak meg.';
$string['invaliddiscussionid'] = 'Érvénytelen vagy már nem létező beszélgetés-azonosító';
$string['invalidforcesubscribe'] = 'Érvénytelen feliratkozást előíró mód';
$string['invalidforumid'] = 'Érvénytelen volt a fórumazonosító';
$string['invalidparentpostid'] = 'A fölső hozzászólás-azonosító hibás volt.';
$string['invalidpostid'] = 'Érvénytelen {$a} üzenetazonosító';
$string['lastpost'] = 'Utolsó hozzászólás';
$string['learningforums'] = 'Tanulási fórumok';
$string['lockdiscussion'] = 'Beszélgetés lezárása';
$string['lockdiscussionafter'] = 'Beszélgetések lezárása tétlenség után';
$string['lockdiscussionafter_help'] = 'A beszélgetések automatikusan lezárhatók, ha az utolsó hozzászólás óta eltelik a megadott idő.

Azok a felhasználók, akik jogosultak lezárt beszélgetésekhez hozzászólni, feloldhatnak egy lezárt beszélgetést a hozzászólásukkal.';
$string['locked'] = 'Zárolva';
$string['lockupdated'] = 'Zárolását frissítettük.';
$string['longpost'] = 'Hosszú hozzászólás';
$string['mailnow'] = 'Fórumüzenetek küldése szerkesztési késleltetés nélkül';
$string['managesubscriptionsoff'] = 'Jelentkezések kezelésének lezárása';
$string['managesubscriptionson'] = 'Feliratkozók  kezelése';
$string['manydiscussions'] = 'Oldalankénti beszélgetések';
$string['markalldread'] = 'A beszélgetés minden hozzászólásának megjelölése olvasottként.';
$string['markallread'] = 'Ezen fórum minden hozzászólását olvasottként jelöli meg.';
$string['markasread'] = 'Olvasottként megjelöl';
$string['markasreadonnotification'] = 'Fórumüzenetekről szóló értesítés küldésekor';
$string['markasreadonnotification_help'] = 'Ha fórumüzenetről kap értesítést, eldöntheti, olvasottként legyen-e megjelölve a fórum nyomon követéséhez.';
$string['markasreadonnotificationno'] = 'Ne jelölje meg az üzenetet olvasottként';
$string['markasreadonnotificationyes'] = 'Jelölje meg az üzenetet olvasottként';
$string['markread'] = 'Elolvasottnak jelöl';
$string['markreadbutton'] = 'Elolvasottnak<br />jelöl';
$string['markunread'] = 'Elolvasatlannak jelöl';
$string['markunreadbutton'] = 'Elolvasatlannak<br />jelöl';
$string['maxattachments'] = 'Csatolt állományok max. száma';
$string['maxattachments_help'] = '<p>Itt állíthatja be, hány állomány csatolható a fórumon belül egy-egy hozzászóláshoz.</p>';
$string['maxattachmentsize'] = 'Csatolt állomány maximális mérete';
$string['maxattachmentsize_help'] = '<p>A csatolt állományok mérete bizonyos értékre mérsékelhető, melyet a fórumot
létrehozó személy választhat ki.</p>
<p>Esetenként ennél nagyobb állomány is feltölthető, de az adott állomány nem
tárolódik a szerveren, és esetlegesen hibajelzés jelenhet meg. </p>';
$string['maxtimehaspassed'] = 'A hozzászólás szerkesztéséhez rendelkezésére álló idő ({$a}) lejárt.';
$string['message'] = 'Üzenet';
$string['messageinboundattachmentdisallowed'] = 'A válasz nem küldhető el, mert csatolt állományt tartalmaz, ezt pedig a fórum nem engedélyezi.';
$string['messageinboundfilecountexceeded'] = 'A válasz nem küldhető el, mert a fórumban engedélyezettnél több csatolt állományt tartalmaz ({$a->forum->maxattachments}).';
$string['messageinboundfilesizeexceeded'] = 'A válasz nem küldhető el, mert a fórumban engedélyezett összes csatolt állomány mérete ({$a->filesize}) nagyobb a megengedettnél ({$a->maxbytes}).';
$string['messageinboundforumhidden'] = 'A válasz nem küldhető el, mert a fórum jelenleg nem elérhető.';
$string['messageinboundnopostforum'] = 'A válasz nem küldhető el, mert a(z) {$a->forum->name} fórum ezt nem engedélyezi Önnek.';
$string['messageinboundthresholdhit'] = 'A válasz nem küldhető el, mert túllépte a fórumban engedélyezett mértéket.';
$string['messageprovider:digests'] = 'Járatott fórum összesítései';
$string['messageprovider:posts'] = 'Járatott fórum hozzászólásai';
$string['missingsearchterms'] = 'Az alábbi kereső kifejezések az üzenetnek csak a HTML-kódjában jelennek meg:';
$string['modeflatnewestfirst'] = 'Válaszok egymás után, a legújabbal kezdve';
$string['modeflatoldestfirst'] = 'Válaszok egymás után, a legrégebbivel kezdve';
$string['modenested'] = 'Válaszok beágyazott formában';
$string['modenestedv2'] = 'Válaszok megjelenítése kísérleti beágyazott formában.';
$string['modethreaded'] = 'Válaszok témánkénti formában';
$string['modulename'] = 'Fórum';
$string['modulename_help'] = 'A Fórum tevékenységmodul lehetővé teszi a résztvevők számára, hogy aszinkron módon, azaz hosszabb időn keresztül zajló beszélgetéseket folytassanak.

Többféle fórumtípus közül lehet választani, például lehet ez egy általános fórum, ahol bárki bármikor új témát indíthat; egy fórum, ahol minden tanuló pontosan egy témát hozhat létre; vagy egy kérdezz-felelek típusú fórum, ahol a tanulóknak először saját bejegyzést kell közzétenniük, mielőtt megtekinthetnék mások hozzászólásait. A tanár engedélyezheti fájlok mellékelését a fórumbejegyzésekhez. Ezek a képek közvetlenül megjelennek a bejegyzésben.

A résztvevők feliratkozhatnak a fórumra, hogy értesítést kapjanak az új bejegyzésekről. A tanár beállíthatja a feliratkozás módját választhatóra, kötelezőre vagy automatikusra, illetve teljesen le is tilthatja azt. Szükség esetén korlátozható, hogy a tanulók egy adott időszakon belül legfeljebb hány bejegyzést tehetnek közzé, ez megakadályozhatja, hogy egyesek túlságosan uralják a beszélgetést.

A fórumbejegyzéseket a tanárok vagy akár a tanulók is értékelhetik (társértékelés). Az értékelések összesíthetők, ami egy végső értékelésként kerülhet az értékelésnaplóba.

A fórum sokféleképpen használható, például:

* Közösségi térként, ahol a tanulók megismerhetik egymást
* Kurzusértesítésekhez (például hírfórum kötelező feliratkozással)
* A kurzus tartalmának vagy olvasmányainak megbeszélésére
* Korábban, személyes órán felvetett témák online folytatására
* Csak oktatók számára fenntartott megbeszélésekhez (rejtett fórum használatával)
* Segítőközpontként, ahol oktatók és tanulók tanácsot adhatnak egymásnak
* Egyéni támogatási felületként tanár és tanuló közötti privát kommunikációhoz (külön csoportokat használva, csoportonként egy tanulóval)
* Kiegészítő tevékenységekhez, például fejtörők vagy gondolatébresztő feladatok megosztására, amelyekre a tanulók megoldásokat javasolhatnak';
$string['modulename_link'] = 'mod/forum/view';
$string['modulenameplural'] = 'Fórumok';
$string['more'] = 'tovább';
$string['movedmarker'] = '(Áthelyezve)';
$string['movethisdiscussionlabel'] = 'A jelenlegi beszélgetés mozgatása a megadott fórumba';
$string['movethisdiscussionto'] = 'A beszélgetés áthelyezése ide ...';
$string['mustprovidediscussionorpost'] = 'Exportáláshoz meg kell adnia egy beszélgetés- vagy egy hozzászólásazonosítót';
$string['myprofileotherdis'] = 'Fórumbeszélgetések';
$string['myprofileowndis'] = 'Fórumbeszélgetéseim';
$string['myprofileownpost'] = 'Fórumhozzászólásaim';
$string['namenews'] = 'Közlemények';
$string['namenews_help'] = 'A kurzusközlemények speciális, minden egyes kurzushoz és a portál kezdőoldalához automatikusan létrehozott fórum bejelentések számára. Kurzusonként legfeljebb egy közleményfórumot működtethet. Csak tanár vagy rendszergazda tehet közzé bejelentéseket. A  Legfrissebb közlemények blokkban jelennek meg az új bejelentések';
$string['namesocial'] = 'Társas fórum';
$string['nameteacher'] = 'Tanári fórum';
$string['newforumposts'] = 'A fórum új hozzászólásai';
$string['nextdiscussiona'] = 'Következő beszélgetés:  {$a}';
$string['nextuser'] = 'Módosítások mentése és áttérés a következő felhasználóra';
$string['noattachments'] = 'A hozzászóláshoz nincsenek csatolt állományok';
$string['nodiscussions'] = 'Ebben a fórumban még nincsenek vitatémák';
$string['nodiscussionsstartedby'] = '{$a} még nem indított beszélgetést';
$string['nodiscussionsstartedbyyou'] = 'Ön még nem indított beszélgetést';
$string['noguestpost'] = 'Vendégek nem szólhatnak hozzá.';
$string['noguestsubscribe'] = 'Ez vendégek számára nem elérhető.';
$string['noguesttracking'] = 'Vendégek nyomon követést nem állíthatnak be.';
$string['nomorepostscontaining'] = 'Nincs több \'{$a}\' tartalmú hozzászólás';
$string['nonews'] = 'Nincs még hír';
$string['noonecansubscribenow'] = 'Most nem lehet feliratkozni.';
$string['nopermissiontosubscribe'] = 'A fórumra feliratkozottakat nem tekintheti meg';
$string['nopermissiontoview'] = 'Ezt a hozzászólást nem tekintheti meg.';
$string['nopostforum'] = 'Ön erre a fórumra nem küldhet hozzászólást';
$string['noposts'] = 'Nincs hozzászólás';
$string['nopostsmadebyuser'] = '{$a} felhasználónak nincs hozzászólása';
$string['nopostsmadebyyou'] = 'Önnek még nincs hozzászólása';
$string['noquestions'] = 'Még nincsenek kérdések ezen a fórumon';
$string['nosubscribers'] = 'Még senki nincs feliratkozva erre a fórumra';
$string['notexists'] = 'A beszélgetés már nem létezik.';
$string['notgraded'] = 'Nincs értékelve';
$string['nothingnew'] = 'Semmi új {$a} kapcsán.';
$string['notingroup'] = 'Ennek a fórumnak a megtekintéséhez csoporttagnak kell lennie.';
$string['notinstalled'] = 'A fórummodul nincs telepítve.';
$string['notlocked'] = 'Zárolás';
$string['notpartofdiscussion'] = 'A hozzászólás egy beszélgetésnek sem része!';
$string['notrackforum'] = 'Olvasatlan hozzászólásokat ne kövessen nyomon';
$string['notsubscribed'] = 'Feliratkozás';
$string['nousersmatch'] = 'Az adott feltételekhez nincs felhasználó.';
$string['noviewdiscussionspermission'] = 'Ezen fórum vitáit nem tekintheti meg';
$string['nowallsubscribed'] = '{$a} esetén minden fórumra feliratkozott.';
$string['nowallunsubscribed'] = '{$a} esetén minden fórumról leiratkozott.';
$string['nowgradinguser'] = 'Jelenleg {$a} értékelése zajlik';
$string['nownotsubscribed'] = '{$a->name} NEM kap értesítést a(z) \'{$a->forum}\' fórum új hozzászólásairól.';
$string['nownottracking'] = '{$a->name} már nem követi nyomon a(z) \'{$a->forum}\' fórumot.';
$string['nowsubscribed'] = '{$a->name} kap értesítést a(z) \'{$a->forum}\' fórum új hozzászólásairól:';
$string['nowtracking'] = '{$a->name} már nyomon követi a(z) \'{$a->forum}\' fórumot.';
$string['numberofreplies'] = 'Válaszok szám: {$a}';
$string['numposts'] = '{$a} hozzászólás';
$string['olderdiscussions'] = 'Régebbi beszélgetések';
$string['oldertopics'] = 'Régebbi témák';
$string['oldpostdays'] = 'Ennyi nap után elolvasott';
$string['page-mod-forum-discuss'] = 'Fórum modul beszélgetésfolyam oldala';
$string['page-mod-forum-view'] = 'A fórummodul fő oldala';
$string['page-mod-forum-x'] = 'A fórummodul bármely oldala';
$string['parent'] = 'Előzmény megjelenítése';
$string['parentofthispost'] = 'A hozzászólás előzménye';
$string['permalink'] = 'Permalink';
$string['permanentlinktoparentpost'] = 'Állandó hivatkozás az üzenet szülőjére';
$string['permanentlinktopost'] = 'Állandó hivatkozás az üzenetre';
$string['pindiscussion'] = 'Beszélgetés kitűzése';
$string['pinupdated'] = 'Fölülre helyezését frissítettük.';
$string['pluginadministration'] = 'Fórum kezelése';
$string['pluginname'] = 'Fórum';
$string['postadded'] = 'A hozzászólást sikeresen hozzáadtuk. Van {$a} a javításra, ha változtatni szeretné.';
$string['postaddedsuccess'] = 'Hozzászólását sikeresen hozzáadtuk.';
$string['postaddedtimeleft'] = 'Ha módosításokat kíván végrehajtani, szerkessze ezt: {$a}.';
$string['postbymailsuccess'] = '"{$a->subject}" tárgyú fórumüzenetét sikeresen közzétettük itt: {$a->discussionurl}.';
$string['postbymailsuccess_html'] = '<a href="{$a->discussionurl}">{$a->subject}</a> tárgyú fórumüzenetét sikeresen közzétettük.';
$string['postbyuser'] = '{$a->user} felhasználótól származó {$a->post}';
$string['postincontext'] = 'Nézze ezt a hozzászólást összefüggéseiben.';
$string['postisprivatereply'] = 'A hozzászólás magánjellegű volt. Magánválaszok megtekintésére jogosultakon, pl. tanárokon és vezetőkön kívül  mások nem láthatják.';
$string['postmailinfo'] = 'Ez a(z) {$a} portálon feladott üzenet másolata.';
$string['postmailnow'] = 'Ezt a hozzászólást minden fórumra feliratkozott haladéktalanul megkapja.';
$string['postmailreply'] = 'Válaszadáshoz kattintson erre a hivatkozásra: {$a}';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['postrating1'] = 'Főként elkülönült ismeretet tartalmaz';
$string['postrating2'] = 'Elkülönült és kapcsolt ismeretet is tartalmaz';
$string['postrating3'] = 'Főként kapcsolt ismeretet tartalmaz';
$string['posts'] = 'Hozzászólások';
$string['postsfrom'] = 'Üzenetek feladója';
$string['postsmadebyuser'] = '{$a} hozzászólásai';
$string['postsmadebyuserincourse'] = '{$a->fullname} hozzászólásai a(z) ({$a->coursename} kurzusban';
$string['postsmadeincourse'] = '{$a} keretében létrejött üzenetek';
$string['poststo'] = 'Üzenetek címzettje';
$string['posttoforum'] = 'Hozzászólás a fórumhoz';
$string['posttomygroups'] = 'Minden csoporthoz másolat küldése';
$string['posttomygroups_help'] = 'Minden elérhető csoporthoz másolatot küld az üzenetről. Az elérhetetlen csoportok tagjai az üzenetet nem fogják látni.';
$string['postupdated'] = 'A hozzászólás frissítése megtörtént';
$string['potentialsubscribers'] = 'Lehetséges feliratkozók';
$string['prevdiscussiona'] = 'Előző beszélgetés: {$a}';
$string['previoususer'] = 'Módosítások mentése és áttérés az előző felhasználóra';
$string['privacy:digesttypenone'] = 'A fórum kapcsán nem tárolunk semmilyen adatot a beállított kivonatolási típust illetően.';
$string['privacy:digesttypepreference'] = 'A fórumhoz az alábbi kivonatolási típust választotta:  "{$a->type}".';
$string['privacy:discussionsubscriptionpreference'] = 'A fórumhoz az alábbi beszélgetésfeliratkozási beállítást választotta:  "{$a->preference}"';
$string['privacy:metadata:core_rating'] = 'A fórum az üzenetek besorolásához a besoroló alrendszert veszi igénybe.';
$string['privacy:metadata:core_tag'] = 'A fórum az üzenetek címkézéséhez a címkéző alrendszert veszi igénybe.';
$string['privacy:metadata:forum_digests'] = 'Adatok az egyes fórumok kivonatolási beállításairól.';
$string['privacy:metadata:forum_digests:forum'] = 'Előjegyzett fórum.';
$string['privacy:metadata:forum_digests:maildigest'] = 'A kivonatolási beállítás.';
$string['privacy:metadata:forum_digests:userid'] = 'A kivonatolási beállításhoz tartozó felhasználó azonosítója.';
$string['privacy:metadata:forum_discussion_subs'] = 'Az egyes fórumbeszélgetésekre való feliratkozások adatai';
$string['privacy:metadata:forum_discussion_subs:discussionid'] = 'A beszélgetés azonosítója, amire a feliratkozás történt.';
$string['privacy:metadata:forum_discussion_subs:preference'] = 'Az előjegyzés kezdete.';
$string['privacy:metadata:forum_discussion_subs:userid'] = 'A beszélgetésre feliratkozó felhasználó azonosítója.';
$string['privacy:metadata:forum_discussions'] = 'Felhasználó által létrehozott egyes beszélgetések adatai';
$string['privacy:metadata:forum_discussions:assessed'] = 'TODOD - mit tárol ez a mező';
$string['privacy:metadata:forum_discussions:name'] = 'A beszélgetés szerző által választott megnevezése.';
$string['privacy:metadata:forum_discussions:timemodified'] = 'A beszélgetés utolsó módosításának az időpontja.';
$string['privacy:metadata:forum_discussions:userid'] = 'A beszélgetés létrehozó felhasználó azonosítója';
$string['privacy:metadata:forum_discussions:usermodified'] = 'A beszélgetés utoljára módosító felhasználó azonosítója.';
$string['privacy:metadata:forum_grades'] = 'A fórum értékelési adatai';
$string['privacy:metadata:forum_grades:forum'] = 'A fórum értékelése megtörtént';
$string['privacy:metadata:forum_grades:grade'] = 'Az adott értékelés';
$string['privacy:metadata:forum_grades:userid'] = 'Az értékelt felhasználó';
$string['privacy:metadata:forum_posts'] = 'Az egyes fórumok kivonatolási beállításainak az adatai.';
$string['privacy:metadata:forum_posts:created'] = 'A hozzászólás létrehozásának az időpontja.';
$string['privacy:metadata:forum_posts:discussion'] = 'A hozzászólást tartalmazó beszélgetés.';
$string['privacy:metadata:forum_posts:message'] = 'A fórumhozzászólás szövege.';
$string['privacy:metadata:forum_posts:modified'] = 'A hozzászólás utolsó módosításának az időpontja.';
$string['privacy:metadata:forum_posts:parent'] = 'A hozzászólást kiváltó eredeti hozzászólás.';
$string['privacy:metadata:forum_posts:privatereplyto'] = 'Azon felhasználó azonosítója, akinek a választ küldték.';
$string['privacy:metadata:forum_posts:subject'] = 'A fórumhozzászólás tárgya.';
$string['privacy:metadata:forum_posts:totalscore'] = 'A fórumhozzászólás szövege.';
$string['privacy:metadata:forum_posts:userid'] = 'A fórumhozzászólás szerzőjének felhasználói azonosítója.';
$string['privacy:metadata:forum_queue'] = 'Kivonatolt formában küldendő hozzászólások ideiglenes naplója';
$string['privacy:metadata:forum_queue:discussionid'] = 'A fórumbeszélgetés azonosítója';
$string['privacy:metadata:forum_queue:postid'] = 'A fórumüzenet azonosítója';
$string['privacy:metadata:forum_queue:timemodified'] = 'Az eredeti hozzászólás módosított ideje';
$string['privacy:metadata:forum_queue:userid'] = 'A hozzászólásról értesítendő felhasználó';
$string['privacy:metadata:forum_read'] = 'A felhasználó által elolvasott hozzászólások adatai';
$string['privacy:metadata:forum_read:discussionid'] = 'A hozzászólást tartalmazó beszélgetés.';
$string['privacy:metadata:forum_read:firstread'] = 'A hozzászólást első elolvasásának időpontja.';
$string['privacy:metadata:forum_read:lastread'] = 'A hozzászólást utolsó elolvasásának az időpontja.';
$string['privacy:metadata:forum_read:postid'] = 'Az elolvasott hozzászólás.';
$string['privacy:metadata:forum_read:userid'] = 'A rekordhoz kapcsolódó felhasználói azonosítója.';
$string['privacy:metadata:forum_subscriptions'] = 'A felhasználó által járatott fórumok adatai.';
$string['privacy:metadata:forum_subscriptions:forum'] = 'A járatott fórum.';
$string['privacy:metadata:forum_subscriptions:userid'] = 'A járatott fórum felhasználójának azonosítója..';
$string['privacy:metadata:forum_track_prefs'] = 'A felhasználó által a hozzászólások elolvasásának nyomon követésére kiválasztott fórumok adatai.';
$string['privacy:metadata:forum_track_prefs:forumid'] = 'Az elolvasás nyomon követésére bejelölt fórum.';
$string['privacy:metadata:forum_track_prefs:userid'] = 'A fórum nyomon követési beállításaival kapcsolatos felhasználó azonosítója.';
$string['privacy:metadata:preference:autosubscribe'] = 'Feliratkozzon-e a beszélgetésekre, amikor bennük szereplő hozzászólásokra válaszol.';
$string['privacy:metadata:preference:forum_discussionlistsortorder'] = 'A beszélgetéslista rendezésének kívánt rendezési módja';
$string['privacy:metadata:preference:maildigest'] = 'Az egész portálon érvényes kivonatolási beállítás';
$string['privacy:metadata:preference:markasreadonnotification'] = 'Olvasottként jelöljön-e meg fórumhozzászólásokat, ha azokat üzenetként kapja.';
$string['privacy:metadata:preference:trackforums'] = 'Bekapcsolja-e az olvasás nyomon követését.';
$string['privacy:postwasread'] = 'A hozzászólás első elolvasása {$a->firstread}, a legutolsó {$a->lastread} időpontban történt.';
$string['privacy:readtrackingdisabled'] = 'Úgy döntött, nem követi nyomon, mely üzeneteket olvasta el ezen a fórumon.';
$string['privacy:request:delete:discussion:name'] = 'A szerző kérésére törli';
$string['privacy:request:delete:post:message'] = 'A szerző kérésére a hozzászólás tartalmát töröltük.';
$string['privacy:request:delete:post:subject'] = 'A szerző kérésére törli';
$string['privacy:subscribedtoforum'] = 'Ön feliratkozott erre a fórumra.';
$string['privatereply'] = 'Magánjellegű válaszadás';
$string['privatereply_help'] = 'A magánjellegű választ csak az eredeti hozzászóló, továbbá a magánjellegű válaszok megtekintésére felhatalmazottak tekinthetik meg.';
$string['processingdigest'] = 'Összesített e-mail feldolgozása {$a} számára';
$string['processingpost'] = 'A(z) {$a} hozzászólás feldolgozása';
$string['prune'] = 'Szétvágás';
$string['prunedpost'] = 'A hozzászólásból új beszélgetés lett létrehozva';
$string['pruneheading'] = 'Beszélgetés szétválasztása és a hozzászólás áthelyezése egy új beszélgetés';
$string['qandaforum'] = 'Kérdések és válaszok jellegű fórum';
$string['qandanotify'] = 'Ez egy kérdések és válaszok jellegű fórum. A kérdésekre adott többi tanulói válasz megtekintéséhez előbb saját válaszát kell beküldenie.';
$string['re'] = 'Tárgy:';
$string['readtherest'] = 'A téma további részének olvasása';
$string['removeallforumtags'] = 'Minden fórumcímke törlése';
$string['removefromfavourites'] = 'Beszélgetés megjelölésének törlése';
$string['replies'] = 'Válaszok';
$string['repliesmany'] = 'Eddig {$a} válasz';
$string['repliesone'] = 'Eddig csak {$a} válasz';
$string['reply'] = 'Válasz';
$string['reply_handler'] = 'Fórumüzenetek megválaszolása e-mailben';
$string['reply_handler_name'] = 'Fórumüzenetek megválaszolása';
$string['replyauthorself'] = '{$a} (Ön)';
$string['replyforum'] = 'Válasz a fórumra';
$string['replyingtoauthor'] = 'Válaszol ennek: {$a}...';
$string['replyplaceholder'] = 'Írja meg válaszát...';
$string['replytopostbyemail'] = 'E-mailben válaszolhat.';
$string['replytouser'] = 'A válaszban használjon e-mail címet';
$string['resetdigests'] = 'Összes felhasználónkénti olvasási beállítás törlése';
$string['resetforums'] = 'Innen érkezett hozzászólások törlése';
$string['resetforumsall'] = 'Az összes hozzászólás törlése';
$string['resetsubscriptions'] = 'Összes fórumra való feliratkozás törlése';
$string['resettrackprefs'] = 'A fórum összes nyomon követési beállításának törlése';
$string['rssarticles'] = 'Legfrissebb RSS-hírek száma';
$string['rssarticles_help'] = '<p>Itt kiválaszthatja, hány cikk kerüljön az RSS-hírek közé.</p>

<p>A legtöbb fórum esetén egy 5 és 20 közötti szám megadása elegendő.
Növelje meg a hírek számát, ha a fórumot sűrűn használja.</p>';
$string['rsssubscriberssdiscussions'] = 'Beszélgetések RSS-hírei';
$string['rsssubscriberssposts'] = 'Hozzászólásokhoz kapcsolódó RSS-hírek ';
$string['rsstype'] = 'A tevékenységhez kapcsolódó RSS-hírek';
$string['rsstype_help'] = 'A RSS-hírek bekapcsolásához a tevékenységnél válasszon ki beszélgetéseket vagy hozzászólásokat, amik a hírek közé kerülhetnek.';
$string['rsstypedefault'] = 'RSS-hír típusa';
$string['search'] = 'Keresés';
$string['search:activity'] = 'Fórumtevékenységek';
$string['search:post'] = 'Fórumüzenetek';
$string['searchdatefrom'] = 'A hozzászólásoknak ennél újabbaknak kell lenni';
$string['searchdateto'] = 'A hozzászólásoknak ennél régebbinek kell lenni';
$string['searchforumintro'] = 'Az alábbi mező(k)ben adja meg a kereső kifejezéseket:';
$string['searchforums'] = 'Keresés a fórumokban';
$string['searchfullwords'] = 'Ezek a szavak teljes szavakként jelenjenek meg';
$string['searchnotwords'] = 'Ezeket a szavakat NE tartalmazza';
$string['searcholderposts'] = 'Keresés régebbi hozzászólások között...';
$string['searchphrase'] = 'Ennek a kifejezésnek pontosan így kell szerepelnie a hozzászólásban';
$string['searchresults'] = 'Keresési eredmények';
$string['searchsubject'] = 'Ezek a szavak a tárgysorban szerepeljenek';
$string['searchtags'] = 'Címkézve';
$string['searchuser'] = 'Ennek a névnek a szerzőével kell egyeznie';
$string['searchuserid'] = 'A szerző Moodle-azonosítója';
$string['searchusers'] = 'Felhasználók keresése';
$string['searchwhichforums'] = 'Válassza ki a keresendő fórumot';
$string['searchwords'] = 'Ezek a szavak a hozzászólásban bárhol előfordulhatnak';
$string['seeallposts'] = 'Ezen felhasználó összes hozzászólásainak megmutatása';
$string['sendstudentnotificationsdefault'] = 'A "Tanulók értesítése" alapbeállítása';
$string['sendstudentnotificationsdefault_help'] = 'Állítsa be az értékelő űrlapon a "Tanulók értesítése" jelölőnégyzet alapértékét!';
$string['sendstudentnotificationsno'] = 'Nincs';
$string['sendstudentnotificationsyes'] = 'Igen, küldjön értesítést';
$string['settings'] = 'Beállítások';
$string['shortpost'] = 'Rövid hozzászólás';
$string['showgraderpanel'] = 'Értékelőpanel megjelenítése';
$string['showingcountoftotaldiscussions'] = 'Beszélgetések listája. {$a->total} beszélgetésből {$a->count} megjelenítve';
$string['showmoreusers'] = 'Több felhasználó megjelenítése';
$string['showpreviousrepliescount'] = 'Korábbi válaszok megjelenítése ({$a})';
$string['showsubscribers'] = 'Mostani feliratkozottak megmutatása/szerkesztése';
$string['showusersearch'] = 'Felhasználók keresésének megjelenítése';
$string['singleforum'] = 'Egyetlen egyszerű beszélgetés';
$string['smallmessage'] = '{$a->user} hozzászólt a(z) {$a->forumname} fórumhoz';
$string['smallmessagedigest'] = 'Összegzett fórum  {$a} üzenettel';
$string['starredonly'] = 'Keresés csak a megjelölt beszélgetések között';
$string['startedby'] = 'Indította';
$string['subject'] = 'Téma';
$string['subscribe'] = 'Feliratkozás a fórumra';
$string['subscribeall'] = 'Mindenki feliratkoztatása a fórumra';
$string['subscribed'] = 'Feliratkozott';
$string['subscribediscussion'] = 'Feliratkozás a beszélgetésre';
$string['subscribeenrolledonly'] = 'Csak beiratkozott felhasználók kaphatnak értesítést fórumhozzászólásokról.';
$string['subscribenone'] = 'Mindenki leiratkozása a fórumról';
$string['subscribers'] = 'Feliratkozottak';
$string['subscriberstowithcount'] = 'A(z) "{$a->name}" fórumra feliratkozottak  ({$a->count})';
$string['subscribestart'] = 'Kérek e-mailt a fórum új üzeneteiről';
$string['subscribestop'] = 'Nem kérek e-mailt a fórum új üzeneteiről';
$string['subscription'] = 'Feliratkozás';
$string['subscription_help'] = 'Ha valaki feliratkozik egy fórumra, akkor e-mailben minden fórumra küldött üzenetből kap egy-egy
példányt. A fórumra való feliratkozásról általában saját maga dönthet, bár esetenként a tanár előírhatja a belépést valamely fórumra, ilyenkor a híreket mindenki megkapja.';
$string['subscriptionandtracking'] = 'Feliratkozás és követés';
$string['subscriptionauto'] = 'Automatikus feliratkozás';
$string['subscriptiondisabled'] = 'Feliratkozás kikapcsolva';
$string['subscriptionforced'] = 'Kötelező feliratkozás ';
$string['subscriptionmode'] = 'Feliratkozási mód';
$string['subscriptionmode_help'] = 'Ha valaki feliratkozik egy fórumra, a fórum minden hozzászólásából kap e-mailben egy másolatot.

A fórumra négyféleképpen iratkozhat fel.

* Választható feliratkozás - A résztvevő dönti el, feliratkozik-e
* Kötelező feliratkozás - Mindenki feliratkozik és nem iratkozhat le
* Automatikus feliratkozás - Kezdetben mindenki feliratkozik, de bármikor leiratkozhat
* Feliratkozás kikapcsolva - Nem lehet feliratkozni';
$string['subscriptionmodeconfirm'] = 'Biztosan módosítja a(z) {$a} feliratkozási módját?';
$string['subscriptionoptional'] = 'Választható feliratkozás';
$string['subscriptions'] = 'Feliratkozások';
$string['tagarea_forum_posts'] = 'Fórumüzenetek';
$string['tagsdeleted'] = 'Fórumcímkék törölve';
$string['thisforumhasduedate'] = 'Üzenet fórumra beküldésének esedékességi határideje {$a}.';
$string['thisforumisdue'] = 'Üzenet fórumra beküldésének esedékességi határideje {$a} volt.';
$string['thisforumisthrottled'] = 'A fórumra az Ön által adott idő alatt beküldhető hozzászólások maximálva vannak - jelenleg ez {$a->blockafter} hozzászólás {$a->blockperiod} alatt';
$string['timed'] = 'Időméréses';
$string['timeddiscussion'] = 'Időméréses beszélgetés';
$string['timedhidden'] = 'Időmérés: tanulók elől rejtve';
$string['timedposts'] = 'Időzített hozzászólások';
$string['timedvisible'] = 'Időmérés: tanulóknak látható';
$string['timestartenderror'] = 'A kijelzendő befejezési idő nem lehet a kezdési időnél korábban';
$string['togglediscussionmenu'] = 'Beszélgetés menü átváltása';
$string['togglefullscreen'] = 'Váltás teljes képernyőre';
$string['togglesettingsdrawer'] = 'Beállítási csúszómenü ki-/bekapcsolása';
$string['trackforum'] = 'Elolvasatlan hozzászólások nyomon követése';
$string['tracking'] = 'Nyomon követés';
$string['trackingoff'] = 'Ki';
$string['trackingon'] = 'Előírt';
$string['trackingoptional'] = 'Opcionális';
$string['trackingtype'] = 'Elolvassa a fórum nyomon követését';
$string['trackingtype_help'] = 'Az olvasás nyomon követésével a résztvevők
az esetleges új üzenetek kijelölésével ellenőrizhetik, melyeket nem olvasták még.

A Választható beállítása esetén a résztvevők
az adminisztrációs blokkban lévő hivatkozással maguk állíthatják be a nyomon követést (a fórumbeállításaik között be kell kapcsolniuk a fórum nyomon követését is).

Ha a portálkezelés alatt az Előírt nyomon követés engedélyezése be van kapcsolva, egy további Előírt lehetőség áll rendelkezésre, mely esetén a fórumbeállításoktól függetlenül a nyomon követés mindig be van kapcsolva.';
$string['trackreadposts_header'] = 'Fórum nyomon követése';
$string['unlockdiscussion'] = 'Beszélgetés feloldása';
$string['unpindiscussion'] = 'Beszélgetés kitűzésének törlése';
$string['unread'] = 'Elolvasatlan';
$string['unreadpost'] = 'Olvasatlan üzenet';
$string['unreadposts'] = 'Elolvasatlan hozzászólások';
$string['unreadpostsnumber'] = '{$a} elolvasatlan hozzászólás';
$string['unreadpostsone'] = '1 elolvasatlan hozzászólás';
$string['unsubscribe'] = 'Leiratkozás a fórumról';
$string['unsubscribeall'] = 'Leiratkozás minden fórumról';
$string['unsubscribeallconfirm'] = 'Jelenleg {$a->forums} fórumra és {$a->discussions} beszélgetésre van feliratkozva. Biztosan le akar iratkozni az összes fórumról és beszélgetésről, és kikapcsolja az automatikus feliratkozást?';
$string['unsubscribeallconfirmdiscussions'] = 'Jelenleg {$a->discussions} beszélgetésre van feliratkozva. Biztosan le akar iratkozni az összes beszélgetésről és kikapcsolja az automatikus feliratkozást?';
$string['unsubscribeallconfirmforums'] = 'Jelenleg {$a->forums} fórumra van feliratkozva. Biztosan le akar iratkozni az összes fórumról és kikapcsolja az automatikus feliratkozást?';
$string['unsubscribealldone'] = 'Minden fórumra való feliratkozását töröltük, de a közvetlen feliratkozású fórumoktól még továbbra is kap értesítéseket. Az értesítések kezeléséhez  térjen át profiljának beállításai között az üzenetküldésre';
$string['unsubscribeallempty'] = 'Ön semmilyen fórumra nincs feliratkozva. Ha semmilyen értesítést nem kíván kapni erről a szerverről, térjen át profiljának beállításai között az üzenetküldésre.';
$string['unsubscribed'] = 'Leiratkozott';
$string['unsubscribediscussion'] = 'Leiratkozás a beszélgetésről';
$string['unsubscribediscussionlink'] = 'Leiratkozás erről a beszélgetésről:  {$a}';
$string['unsubscribelink'] = 'Leiratkozás erről a fórumról:  {$a}';
$string['unsubscribeshort'] = 'Leiratkozás';
$string['useexperimentalui'] = 'Kísérleti beágyazott beszélgetésnézet használata';
$string['usermarksread'] = 'Üzenet elolvasásának kézi bejelölése';
$string['usernavigation'] = 'Felhasználó böngészése';
$string['usersforumposts'] = 'Felhasználói fórumüzenetek';
$string['viewalldiscussions'] = 'Az összes beszélgetés megtekintése';
$string['viewconversation'] = 'Beszélgetés megtekintése';
$string['viewgrades'] = 'Értékelések megtekintése';
$string['viewparentpost'] = 'Eredeti hozzászólás megtekintése';
$string['viewthediscussion'] = 'A beszélgetés megtekintése';
$string['warnafter'] = 'Hozzászólás határértéke a figyelmeztetéshez';
$string['warnafter_help'] = 'A tanulók figyelmeztetést kaphatnak, ha közel járnak az adott időszak alatt részükre engedélyezett hozzászólások maximális számához. Ez a beállítás adja meg, hány hozzászólás után kapnak figyelmeztetést. A hozzászólási korlát mod/forum:postwithoutthrottling jogosultságú felhasználókra nem vonatkozik.';
$string['warnformorepost'] = 'Figyelem! A fórumban egynél több beszélgetés zajlik - a legújabb használatára kerül sor';
$string['yournewquestion'] = 'Az Ön új kérdése';
$string['yournewtopic'] = 'Az Ön új beszélgetéstémája';
$string['yourreply'] = 'Az Ön válasza';
