<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_dataprivacy', language 'sk', version '4.4'.
 *
 * @package     tool_dataprivacy
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitiesandresources'] = 'Činnosti a zdroje';
$string['addcategory'] = 'Pridať kategóriu';
$string['addnewdefaults'] = 'Pridať východzí nový modul';
$string['addpurpose'] = 'Pridať účel';
$string['addroleoverride'] = 'Pridať prepísanie role';
$string['approve'] = 'Schváliť';
$string['approvedrequestsubmitted'] = 'Vaša žiadosť bola odoslaná a čoskoro bude spracovaná';
$string['approverequest'] = 'Schváliť žiadosť';
$string['automaticdatadeletionapproval'] = 'Schválenie žiadosti o automatické odstránenie údajov';
$string['automaticdatadeletionapproval_desc'] = 'Ak je táto možnosť povolená, žiadosti o odstránenie údajov sa automaticky schvaľujú.<br/>Upozorňujeme, že automatické schválenie sa bude vzťahovať iba na nové žiadosti o odstránenie údajov s povoleným týmto nastavením. Existujúce žiadosti o vymazanie údajov, ktoré čakajú na schválenie, bude musieť manuálne schváliť osoba pre ochranu osobných údajov.';
$string['automaticdataexportapproval'] = 'Schválenie žiadosti o automatický export údajov';
$string['automaticdataexportapproval_desc'] = 'Ak je táto možnosť povolená, žiadosti o export údajov sa schvaľujú automaticky.<br/>Upozorňujeme, že automatické schválenie sa bude vzťahovať iba na nové žiadosti o export údajov s povoleným týmto nastavením. Existujúce žiadosti o export údajov, ktoré čakajú na schválenie, bude musieť manuálne schváliť osoba pre ochranu osobných údajov.';
$string['automaticdeletionrequests'] = 'Vytvorte automatické požiadavky na odstránenie údajov';
$string['automaticdeletionrequests_desc'] = 'Ak je táto možnosť povolená, automaticky sa vytvorí žiadosť o vymazanie údajov pre všetky používateľské účty, ktoré boli manuálne odstránené.';
$string['bulkapproverequests'] = 'Schváliť požiadavky';
$string['bulkdenyrequests'] = 'Odmietnuť požiadavky';
$string['cachedef_contextlevel'] = 'Kontextové úrovne účelu a kategórie';
$string['cachedef_purpose'] = 'Údajové účely';
$string['cachedef_purpose_overrides'] = 'Prepíše účel v nástroji na ochranu osobných údajov';
$string['cancelrequest'] = 'Zrušiť žiadosť';
$string['cancelrequestconfirmation'] = 'Naozaj chcete zrušiť túto žiadosť o údaje?';
$string['cannotreset'] = 'Túto požiadavku nie je možné resetovať. Obnoviť možno iba zamietnuté žiadosti.';
$string['categories'] = 'Kategórie';
$string['categorieslist'] = 'Zoznam kategórií údajov';
$string['category'] = 'Kategória';
$string['category_help'] = 'Kategória v registri údajov opisuje typ údajov. Je možné pridať novú kategóriu, alebo ak je vybratá možnosť Zdediť, použije sa kategória údajov z vyššieho kontextu. Kontexty sú (od najnižšej po vyššiu): Bloky > Moduly aktivít > Kurzy > Kategórie kurzov > Portál.';
$string['categorycreated'] = 'Kategória bola vytvorená';
$string['categorydefault'] = 'Východzia kategória';
$string['categorydefault_help'] = 'Predvolená kategória je kategória údajov aplikovaná na všetky nové inštancie. Ak je vybratá možnosť Zdediť, použije sa kategória údajov z vyššieho kontextu. Kontexty sú (od najnižšej po vyššiu): Bloky > Moduly aktivít > Kurzy > Kategórie kurzov > Používateľ > Portál.';
$string['categoryupdated'] = 'Kategória bola aktualizovaná';
$string['close'] = 'Zavrieť';
$string['compliant'] = 'V súlade';
$string['confirmapproval'] = 'Naozaj chcete schváliť túto žiadosť o údaje?';
$string['confirmbulkapproval'] = 'Naozaj chcete hromadne schváliť vybraté žiadosti o údaje?';
$string['confirmbulkdenial'] = 'Naozaj chcete hromadne zamietnuť vybrané žiadosti o údaje?';
$string['confirmcompletion'] = 'Naozaj chcete označiť túto žiadosť používateľa ako ukončenú?';
$string['confirmcontextdeletion'] = 'Naozaj chcete potvrdiť odstránenie vybraných kontextov? Tým budú tiež odstránené všetky používateľské údaje pre príslušné kontexty.';
$string['confirmdenial'] = 'Naozaj chcete zamietnuť túto žiadosť o údaje?';
$string['confirmrequestresubmit'] = 'Naozaj chcete zrušiť aktuálnu žiadosť {$a->type} pre {$a->username} a znova ju odoslať?';
$string['contactdataprotectionofficer'] = 'Kontakt na poverenca pre ochranu údajov';
$string['contactdataprotectionofficer_desc'] = 'Ak je táto možnosť povolená, používatelia budú môcť kontaktovať osobu pre ochranu osobných údajov a požiadať o údaje prostredníctvom odkazu na stránke svojho profilu.';
$string['contactdpoviaprivacypolicy'] = 'Kontaktujte prosím zodpovednú osobu, ako je opísané v zásadách ochrany osobných údajov.';
$string['contextlevelname10'] = 'Stránky';
$string['contextlevelname30'] = 'Používatelia';
$string['contextlevelname40'] = 'Kategórie kurzov';
$string['contextlevelname50'] = 'Kurzy';
$string['contextlevelname70'] = 'Zásuvné moduly aktivít';
$string['contextlevelname80'] = 'Bloky';
$string['contextpurposecategorysaved'] = 'Účel a kategórie boli uložené';
$string['createcategory'] = 'Vytvoriť kategóriu údajov';
$string['createdeletedatarequest'] = 'Vytvoriť žiadosť o vymazanie údajov';
$string['createnewdatarequest'] = 'Vytvoriť novú žiadosť o údaje';
$string['createpurpose'] = 'Vytvoriť účel údajov';
$string['creationauto'] = 'Automaticky';
$string['creationmanual'] = 'Manuálne';
$string['datadeletion'] = 'Odstránenie údajov';
$string['datadeletionpagehelp'] = 'Údaje, pre ktoré uplynula lehota uchovávania, sú uvedené tu. Skontrolujte a potvrďte vymazanie údajov, ktoré sa potom vykoná naplánovanou úlohou „Odstrániť kontexty s ukončenou platnosťou“.';
$string['dataprivacy:downloadallrequests'] = 'Stiahnite si exportované údaje pre všetkých';
$string['dataprivacy:downloadownrequest'] = 'Stiahnite si vlastné exportované údaje';
$string['dataprivacy:makedatadeletionrequestsforchildren'] = 'Požiadať o vymazanie údajov pre neplnoletých';
$string['dataprivacy:makedatarequestsforchildren'] = 'Požiadať o údaje neplnoletých';
$string['dataprivacy:managedataregistry'] = 'Správa registra údajov';
$string['dataprivacy:managedatarequests'] = 'Správa žiadostí o údaje';
$string['dataprivacy:requestdelete'] = 'Požiadať o vymazanie vlastných údajov';
$string['dataprivacy:requestdeleteforotheruser'] = 'Požiadať o vymazanie údajov v mene iného používateľa';
$string['dataregistry'] = 'Register údajov';
$string['dataregistryinfo'] = 'Register údajov umožňuje nastaviť kategórie (typy údajov) a účely (dôvody spracovania údajov) pre všetok obsah na stránke - od používateľov a kurzov až po aktivity a bloky. Pre každý účel možno stanoviť obdobie uchovávania. Po uplynutí doby uchovávania sa údaje označia a zobrazia sa na odstránenie, pričom sa čaká na potvrdenie správcu.';
$string['datarequestcreatedforuser'] = 'Žiadosť o údaje bola vytvorená pre {$a}';
$string['datarequestcreatedfromscheduledtask'] = 'Automaticky vytvorené z naplánovanej úlohy (už existujúci odstránený používateľ).';
$string['datarequestcreatedupondelete'] = 'Automaticky vytvorené po odstránení používateľa.';
$string['datarequestemailsubject'] = 'Požiadavka na údaje: {$a}';
$string['datarequests'] = 'Požiadavky na údaje';
$string['dataretentionexplanation'] = 'Tento súhrn zobrazuje predvolené kategórie a účely uchovávania údajov používateľa. Niektoré oblasti môžu mať špecifickejšie kategórie a účely ako tie, ktoré sú tu uvedené.';
$string['dataretentionsummary'] = 'Súhrn uchovávaných údajov';
$string['datecomment'] = '[{$a->date}]:
 {$a->comment}';
$string['daterequested'] = 'Dátum požiadavky';
$string['daterequesteddetail'] = 'Dátum požiadavky:';
$string['defaultexpired'] = 'Údaje pre všetkých používateľov';
$string['defaultexpiredexcept'] = 'Údaje pre všetkých používateľov okrem tých, ktorí majú niektorú z nasledujúcich rolí:<br>
{$a->unexpired}';
$string['defaultsinfo'] = 'Predvolené kategórie a účely sa použijú na všetky nové a existujúce inštancie, kde nie je nastavená hodnota.';
$string['defaultssaved'] = 'Boli uložené východzie hodnoty';
$string['defaultswarninginfo'] = 'Upozornenie: Zmena týchto predvolených nastavení môže ovplyvniť dobu uchovávania existujúcich inštancií.';
$string['defaultunexpired'] = 'Iba údaje pre používateľov s niektorou z nasledujúcich rolí:<br>
{$a->expired}';
$string['defaultunexpiredwithexceptions'] = 'Iba údaje pre používateľov, ktorí majú niektorú z nasledujúcich rolí:<br>
{$a->expired}
Pokiaľ zároveň nezastávajú niektorú z nasledujúcich rolí:<br>
{$a->unexpired}';
$string['deletecategory'] = 'Odstrániť kategóriu';
$string['deletecategorytext'] = 'Naozaj chcete odstrániť kategóriu "{$a}" ?';
$string['deletedefaults'] = 'Odstrániť východzie hodnoty: {$a}';
$string['deletedefaultsconfirmation'] = 'Naozaj chcete odstrániť predvolenú kategóriu a účel pre moduly {$a}?';
$string['deleteexistingdeleteduserstask'] = 'Vytvoriť žiadosť o odstránenie údajov pre už existujúcich odstránených používateľov';
$string['deleteexpiredcontextstask'] = 'Odstrániť kontexty s vypršanou platnosťou';
$string['deleteexpireddatarequeststask'] = 'Odstrániť súbory exportu žiadosti o údaje s vypršanou platnosťou';
$string['deletemyaccount'] = 'Odstrániť môj účet';
$string['deletepurpose'] = 'Odstrániť účel';
$string['deletepurposetext'] = 'Naozaj chcete odstrániť účel "{$a}" ?';
$string['deny'] = 'Odmietnuť';
$string['denyrequest'] = 'Odmietnuť požiadavku';
$string['deprecated'] = 'Zastarané';
$string['deprecatedexplanation'] = 'Tento doplnok používa starú verziu jedného z rozhraní ochrany osobných údajov a mal by sa aktualizovať.';
$string['download'] = 'Stiahnuť';
$string['downloadexpireduser'] = 'Platnosť sťahovania vypršala. Ak chcete exportovať svoje osobné údaje, odošlite novú žiadosť.';
$string['dporolemapping'] = 'Mapovanie roly Poverenca pre ochranu osobných údajov';
$string['dporolemapping_desc'] = 'Vyberte jednu alebo viac rol, ktorá mapujú rolu Poverenca pre ochranu osobných údajov. Používatelia s týmito funkciami budú môcť spravovať požiadavky na údaje. To vyžaduje, aby vybrané role mali oprávnenie \'tool/dataprivacy:managedatarequests\'.';
$string['duplicaterole'] = 'Rola už bola špecifikovaná';
$string['editcategories'] = 'Upraviť kategórie';
$string['editcategory'] = 'Upraviť kategóriu';
$string['editdefaults'] = 'Upraviť východzie hodnoty: {$a}';
$string['editmoduledefaults'] = 'Upraviť východzie nastavenia modulu';
$string['editpurpose'] = 'Upraviť účel';
$string['editpurposes'] = 'Upraviť účely';
$string['effectiveretentionperiodcourse'] = '{$a} (po dátume ukončenia kurzu)';
$string['effectiveretentionperioduser'] = '{$a} (od posledného prístupu používateľa k stránkam)';
$string['emailsalutation'] = 'Vážený {$a},';
$string['errorcannotrequestdeleteforother'] = 'Nemáte oprávnenie na vytvorenie požiadavky na odstránenie tohto používateľa.';
$string['errorcannotrequestdeleteforself'] = 'Nemáte oprávnenie na vytvorenie požiadavky na odstránenie vlastných údajov.';
$string['errorcontactdpodisabled'] = 'Možnosť kontaktovať Poverenca ochrany osobných údajov  je zakázaná..';
$string['errorcontexthasunexpiredchildren'] = 'Kontext "{$a}" má stále podriadené kontexty, ktorým ešte nevypršala platnosť. Neboli označené žiadne kontexty na odstránenie.';
$string['errorinvalidrequestcomments'] = 'Pole komentárov môže obsahovať iba obyčajný text.';
$string['errorinvalidrequestcreationmethod'] = 'Neplatný spôsob vytvorenia požiadavky!';
$string['errorinvalidrequeststatus'] = 'Neplatný stav požiadavky!';
$string['errorinvalidrequesttype'] = 'Neplatný typ požiadavky!';
$string['errornocapabilitytorequestforothers'] = 'Používateľ {$a->requestedby} nemá možnosť požiadať o údaje v mene používateľa {$a->userid}';
$string['errornoexpiredcontexts'] = 'Neexistujú žiadne kontexty s uplynutou platnosťou na spracovanie';
$string['errorrequestalreadyexists'] = 'Už máte podanú žiadosť.';
$string['errorrequestnotfound'] = 'Žiadosť nebola nájdená';
$string['errorrequestnotwaitingforapproval'] = 'Žiadosť neočakáva schválenie. Alebo nie je pripravená alebo už bola spracovaná.';
$string['errorsendingmessagetodpo'] = 'Pri pokuse o odoslanie správy {$a} došlo k chybe.';
$string['exceptionnotificationbody'] = '<p>Pri volaní <b>{$a->fullmethodname}</b> sa vyskytla výnimka.<br>To znamená, že doplnok <b>{$a->component}</b> nedokončil spracovanie údajov . Nasledujúce informácie o výnimkách môžu byť postúpené vývojárovi doplnku:</p><pre>{$a->message}<br>';
$string['exceptionnotificationsubject'] = 'Výnimka nastala pri spracovaní osobných údajov';
$string['expandplugin'] = 'Rozbaliť a zbaliť doplnok.';
$string['expandplugintype'] = 'Rozbaliť a zbaliť typ doplnku.';
$string['expiredretentionperiodtask'] = 'Doba uchovávania uplynula';
$string['expiredrolewithretention'] = '{$a->retention} (platnosť vypršala)';
$string['expiry'] = 'Expirovať';
$string['explanationtitle'] = 'Ikony použité na tejto stránke a ich význam.';
$string['external'] = 'Prídavný';
$string['externalexplanation'] = 'Prídavný zásuvný modul inštalovaný na tomto portáli.';
$string['filteroption'] = '{$a->category}: {$a->name}';
$string['frontpagecourse'] = 'Kurz na titulnej stránke';
$string['gdpr_art_6_1_a_description'] = 'Dotknutá osoba udelila súhlas so spracovaním svojich osobných údajov na jeden alebo viacero konkrétnych účelov';
$string['gdpr_art_6_1_a_name'] = 'Súhlas (GDPR čl. 6.1(a))';
$string['gdpr_art_6_1_b_description'] = 'Spracovanie je nevyhnutné na plnenie zmluvy, ktorej zmluvnou stranou je dotknutá osoba, alebo na vykonanie krokov na žiadosť dotknutej osoby pred uzavretím zmluvy';
$string['gdpr_art_6_1_b_name'] = 'Zmluva (GDPR čl. 6.1(b))';
$string['gdpr_art_6_1_c_description'] = 'Spracúvanie je nevyhnutné na splnenie zákonnej povinnosti, ktorá sa vzťahuje na prevádzkovateľa';
$string['gdpr_art_6_1_c_name'] = 'Zákonná povinnosť (GDPR čl. 6.1(c))';
$string['gdpr_art_6_1_d_description'] = 'Spracúvanie je nevyhnutné na ochranu životne dôležitých záujmov dotknutej osoby alebo inej fyzickej osoby';
$string['gdpr_art_6_1_d_name'] = 'Životne dôležité záujmy (GDPR čl. 6.1(d))';
$string['gdpr_art_6_1_e_description'] = 'Spracúvanie je nevyhnutné na splnenie úlohy vykonávanej vo verejnom záujme alebo pri výkone verejnej moci zverenej prevádzkovateľovi';
$string['gdpr_art_6_1_e_name'] = 'Verejná úloha (GDPR čl. 6.1(e))';
$string['gdpr_art_6_1_f_description'] = 'Spracúvanie je nevyhnutné na účely oprávnených záujmov, ktoré sleduje prevádzkovateľ alebo tretia strana, okrem prípadov, keď nad takýmito záujmami prevažujú záujmy alebo základné práva a slobody dotknutej osoby, ktoré si vyžadujú ochranu osobných údajov, najmä ak subjektom údajov je dieťa';
$string['gdpr_art_6_1_f_name'] = 'Oprávnené záujmy (GDPR čl. 6.1(f))';
$string['gdpr_art_9_2_a_description'] = 'Dotknutá osoba dala výslovný súhlas so spracovaním týchto osobných údajov na jeden alebo viacero špecifikovaných účelov, s výnimkou prípadov, keď právo Únie alebo členského štátu stanovuje, že zákaz uvedený v odseku 1 článku 9 GDPR nesmie dotknutá osoba zrušiť';
$string['gdpr_art_9_2_a_name'] = 'Výslovný súhlas (GDPR čl. 9.2(a))';
$string['gdpr_art_9_2_b_description'] = 'Spracúvanie je nevyhnutné na účely plnenia povinností a uplatňovania osobitných práv prevádzkovateľa alebo dotknutej osoby v oblasti pracovného práva a práva sociálneho zabezpečenia a sociálnej ochrany, pokiaľ je povolené právom Únie alebo členského štátu alebo kolektívnej zmluvy v súlade s právom členského štátu poskytujúce primerané záruky základných práv a záujmov dotknutej osoby';
$string['gdpr_art_9_2_b_name'] = 'Zákon o zamestnanosti a sociálnom zabezpečení/ochrane (GDPR čl. 9.2(b))';
$string['gdpr_art_9_2_c_description'] = 'Spracovanie je nevyhnutné na ochranu životne dôležitých záujmov dotknutej osoby alebo inej fyzickej osoby, ak dotknutá osoba nie je fyzicky alebo právne schopná udeliť súhlas';
$string['gdpr_art_9_2_c_name'] = 'Ochrana životne dôležitých záujmov (GDPR čl. 9.2(c))';
$string['gdpr_art_9_2_d_description'] = 'Spracovanie vykonáva v rámci svojich legitímnych činností s primeranými zárukami nadácia, združenie alebo akýkoľvek iný neziskový orgán s politickým, filozofickým, náboženským alebo odborovým cieľom a za podmienky, že sa spracúvanie týka výlučne členom alebo bývalým členom orgánu alebo osobám, ktoré sú s ním v pravidelnom kontakte v súvislosti s jeho účelmi a aby sa osobné údaje nezverejňovali mimo tohto orgánu bez súhlasu dotknutých osôb';
$string['gdpr_art_9_2_d_name'] = 'Legitímne aktivity týkajúce sa členov/úzkych kontaktov nadácie, združenia alebo iného neziskového orgánu (GDPR čl. 9.2(d))';
$string['gdpr_art_9_2_e_description'] = 'Spracúvanie sa týka osobných údajov, ktoré dotknutá osoba zjavne zverejňuje';
$string['gdpr_art_9_2_e_name'] = 'Údaje zverejnené dotknutou osobou (GDPR čl. 9.2(e))';
$string['gdpr_art_9_2_f_description'] = 'Spracúvanie je nevyhnutné na určenie, výkon alebo obhajobu právnych nárokov alebo vždy, keď súdy konajú v ich súdnej právomoci';
$string['gdpr_art_9_2_f_name'] = 'Právne nároky a súdne žaloby (GDPR čl. 9.2(f))';
$string['gdpr_art_9_2_g_description'] = 'Spracovanie je nevyhnutné z dôvodov závažného verejného záujmu na základe práva Únie alebo členského štátu, ktoré je primerané sledovanému cieľu, rešpektuje podstatu práva na ochranu údajov a poskytuje vhodné a konkrétne opatrenia na ochranu základných práv a záujmy dotknutej osoby';
$string['gdpr_art_9_2_g_name'] = 'Podstatný verejný záujem (GDPR čl. 9.2(g))';
$string['gdpr_art_9_2_h_description'] = 'Spracúvanie je nevyhnutné na účely preventívneho alebo pracovného lekárstva, na posúdenie práceneschopnosti zamestnanca, lekárskej diagnózy, na poskytovanie zdravotnej alebo sociálnej starostlivosti alebo liečby alebo na riadenie systémov a služieb zdravotnej alebo sociálnej starostlivosti na základe Právo Únie alebo členského štátu alebo na základe zmluvy so zdravotníckym pracovníkom a za podmienok a záruk uvedených v odseku 3 článku 9 GDPR';
$string['gdpr_art_9_2_h_name'] = 'Lekárske účely (GDPR čl. 9.2(h))';
$string['gdpr_art_9_2_i_description'] = 'Spracovanie je nevyhnutné z dôvodov verejného záujmu v oblasti verejného zdravia, ako je ochrana pred vážnymi cezhraničnými ohrozeniami zdravia alebo zabezpečenie vysokých štandardov kvality a bezpečnosti zdravotnej starostlivosti a liekov alebo zdravotníckych pomôcok na základe Únie. alebo právo členského štátu, ktoré ustanovuje vhodné a konkrétne opatrenia na ochranu práv a slobôd dotknutej osoby, najmä služobné tajomstvo';
$string['gdpr_art_9_2_i_name'] = 'Verejné zdravie (GDPR čl. 9.2(i))';
$string['gdpr_art_9_2_j_description'] = 'Spracovanie je nevyhnutné na účely archivácie vo verejnom záujme, na účely vedeckého alebo historického výskumu alebo na štatistické účely v súlade s článkom 89 ods. ochranu údajov a zabezpečiť vhodné a konkrétne opatrenia na ochranu základných práv a záujmov dotknutej osoby';
$string['gdpr_art_9_2_j_name'] = 'Verejný záujem alebo vedecký/historický/štatistický výskum (GDPR čl. 9.2(j))';
$string['hide'] = 'Zbaliť všetko';
$string['httpwarning'] = 'Akékoľvek údaje stiahnuté z tejto stránky nemusia byť šifrované. Kontaktujte svojho správcu systému a požiadajte ho, aby nainštaloval SSL na túto stránku.';
$string['inherit'] = 'Zdediť';
$string['lawfulbases'] = 'Zákonné základy';
$string['lawfulbases_help'] = 'Vyberte aspoň jednu možnosť, ktorá bude slúžiť ako zákonný základ pre spracúvanie osobných údajov. Podrobnosti o týchto právnych základoch nájdete v <a href="https://gdpr-info.eu/art-6-gdpr/" target="_blank">článku GDPR. 6.1</a>';
$string['markcomplete'] = 'Označiť ako dokončené';
$string['markedcomplete'] = 'Váš žiadosť bola označená ako dokončená osobou pre ochranu osobných údajov.';
$string['message'] = 'Správa';
$string['messagelabel'] = 'Správa:';
$string['messageprovider:contactdataprotectionofficer'] = 'Žiadosti o údaje';
$string['messageprovider:datarequestprocessingresults'] = 'Výsledky spracovania žiadosti o údaje';
$string['messageprovider:notifyexceptions'] = 'Údaje vyžadujú upozornenia na výnimky';
$string['moduleinstancename'] = '{$a->instancename} ({$a->modulename})';
$string['mypersonaldatarequests'] = 'Moje žiadosti o osobné údaje';
$string['nameandparent'] = '{$a->parent} / {$a->name}';
$string['nameemail'] = '{$a->name} ({$a->email})';
$string['nchildren'] = '{$a} dětí';
$string['newrequest'] = 'Nová žiadosť';
$string['noactivitiestoload'] = 'Žiadne aktivity';
$string['noassignedroles'] = 'V tomto kontexte neboli pridelené roly';
$string['noblockstoload'] = 'Žiadne bloky';
$string['nocategories'] = 'Zatiaľ nie sú žiadne kategórie';
$string['nocoursestoload'] = 'Žiadne aktivity';
$string['nodatarequests'] = 'Neexistujú žiadne žiadosti o údaje';
$string['nodatarequestsmatchingfilter'] = 'Zadanému filtru nezodpovedajú žiadne požiadavky na údaje';
$string['noexpiredcontexts'] = 'Táto kontextová úroveň neobsahuje žiadne údaje, pre ktoré uplynulo obdobie uchovávania.';
$string['nopersonaldatarequests'] = 'Nemáte žiadne žiadosti o osobné údaje';
$string['nopurposes'] = 'Zatiaľ neexistujú žiadne účely';
$string['nosubjectaccessrequests'] = 'Neexistujú žiadne žiadosti o údaje, o ktorých by ste mali jednať';
$string['nosystemdefaults'] = 'Účel a kategória portálu zatiaľ neboli definované.';
$string['notset'] = 'Nie je nastavené (použite východziu hodnotu)';
$string['notyetexpired'] = '{$a} (ešte nevypršala platnosť)';
$string['overrideinstances'] = 'Obnovte inštancie pomocou upravených hodnôt';
$string['pluginname'] = 'Ochrana osobných údajov';
$string['pluginname_help'] = 'Zásuvný modul ochrany osobných údajov';
$string['pluginregistry'] = 'Doplnok zásuvného modulu osobných údajov';
$string['pluginregistrytitle'] = 'Doplnok tegistra dodržiavania pravidiel ochrany osobných údajov';
$string['privacy'] = 'Súkromie';
$string['privacy:metadata:preference:tool_dataprivacy_request-filters'] = 'Filtre aktuálne použité na stránke žiadostí o údaje.';
$string['privacy:metadata:preference:tool_dataprivacy_request-perpage'] = 'Počet žiadostí o údaje, ktoré chce používateľ vidieť na jednej stránke';
$string['privacy:metadata:request'] = 'Informácie z požiadaviek na osobné údaje (požiadavky na prístup a vymazanie) realizované na tomto portáli.';
$string['privacy:metadata:request:comments'] = 'Akékoľvek komentáre používateľov sprevádzajúce túto žiadosť.';
$string['privacy:metadata:request:dpocomment'] = 'Akékoľvek pripomienky, ktoré v súvislosti so žiadosťou vznesie poverenec ochrany osobných údajov portálu.';
$string['privacy:metadata:request:requestedby'] = 'IP používateľa, ktorý odoslal požiadavku, ak bol vykonaný menom iného používateľa.';
$string['privacy:metadata:request:timecreated'] = 'Časové razítko udáva, kedy používateľ zadal požiadavku.';
$string['privacy:metadata:request:userid'] = 'IP používateľa, ktorému patrí žiadosť.';
$string['privacyofficeronly'] = 'K tomuto obsahu majú prístup iba používatelia, ktorí majú priradenú rolu osoby pre ochranu osobných údajov ({$a}).';
$string['privacyrequestexpiry'] = 'Platnosť žiadosti o údaje vyprší';
$string['privacyrequestexpiry_desc'] = 'Čas, počas ktorého budú schválené žiadosti o údaje k dispozícii na stiahnutie pred uplynutím jeho platnosti. Ak je nastavený na nulu, potom neexistuje žiadne časové obmedzenie.';
$string['protected'] = 'Chránené';
$string['protectedlabel'] = 'Uchovávanie týchto údajov má vyšší právny precedens pred žiadosťou používateľa o zabudnutie. Tieto údaje budú vymazané až po uplynutí doby uchovávania.';
$string['purpose'] = 'Účel';
$string['purpose_help'] = 'Účel opisuje dôvod spracovania údajov. Môže sa pridať nový účel, alebo ak je vybratá možnosť Zdediť, použije sa účel z vyššieho kontextu. Kontexty sú (od najnižšieho po najvyšší): Bloky > Moduly aktivít > Kurzy > Kategórie kurzov > Používateľ > Portál.';
$string['purposecreated'] = 'Účel bol vytvorený';
$string['purposedefault'] = 'Východzí účel';
$string['purposedefault_help'] = 'Východzí účel je účel, ktorý sa použije na všetky nové inštancie. Ak je vybratá možnosť Zdediť, použije sa účel z vyššieho kontextu. Kontexty sú (od najnižšieho po najvyšší): Bloky > Moduly aktivít > Kurzy > Kategórie kurzov > Používateľ > Portál.';
$string['purposeoverview'] = 'Účel opisuje zamýšľané použitie a politiku uchovávania uložených údajov. Základ pre ukladanie a uchovávanie týchto údajov je tiež opísaný v účele.';
$string['purposes'] = 'Účely';
$string['purposeslist'] = 'Zoznam účelov údajov';
$string['purposeupdated'] = 'Účel bol aktializovaný';
$string['replyto'] = 'Odpovedať';
$string['requestactions'] = 'Akcie';
$string['requestapproved'] = 'Žiadosť bola schválená';
$string['requestby'] = 'Požadované';
$string['requestbydetail'] = 'Vyžiadané od:';
$string['requestcomments'] = 'Komentáre';
$string['requestcomments_help'] = 'Toto pole vám umožňuje zadať ďalšie podrobnosti o vašej žiadosti o údaje.';
$string['requestcreation'] = 'Vytvorenie';
$string['requestdenied'] = 'Žiadosť bola odmietnutá';
$string['requestemailintro'] = 'Obdržali ste požiadavku o údaje:';
$string['requestfor'] = 'Používateľ';
$string['requestmarkedcomplete'] = 'Žiadosť bola označená ako dokončená';
$string['requestorigin'] = 'Portál';
$string['requestsapproved'] = 'Žiadosti boli schválené';
$string['requestsdenied'] = 'Žiadosti boli odmietnuté';
$string['requeststatus'] = 'Stav';
$string['requestsubmitted'] = 'Vaša žiadosť bola odoslaná Poverencovi pre ochranu osobných údajov';
$string['requesttype'] = 'Typ';
$string['requesttype_help'] = 'Vyberte dôvod, prečo by ste sa chceli obrátiť na Poverenca na ochranu osobných údajov. Uvedomte si, že vymazanie všetkých osobných údajov bude mať za následok, že sa už nebudete môcť prihlásiť na portál.';
$string['requesttypedelete'] = 'Odstrániť všetky moje osobné údaje';
$string['requesttypedeleteshort'] = 'Odstrániť';
$string['requesttypeexport'] = 'Exportovať všetky moje osobné údaje';
$string['requesttypeexportshort'] = 'Exportovať';
$string['requesttypeothers'] = 'Všeobecná otázka';
$string['requesttypeothersshort'] = 'Správa';
$string['requesttypeuser'] = '{$a->typename} ({$a->user})';
$string['requireallenddatesforuserdeletion'] = 'Kurzy bez dátumu ukončenia považujte za aktívne';
$string['requireallenddatesforuserdeletion_desc'] = 'Pri výpočte uplynutia platnosti používateľa sa berie do úvahy niekoľko faktorov:

* čas posledného prihlásenia používateľa sa porovnáva s dobou uchovávania pre používateľov; a
* či je používateľ aktívne zapísaný do nejakých kurzov.

Ak pri kontrole aktívneho zápisu do kurzu kurz nemá dátum ukončenia, toto nastavenie sa použije na určenie, či sa daný kurz považuje za aktívny alebo nie.

Ak kurz nemá dátum ukončenia a toto nastavenie je povolené, používateľa nemožno odstrániť.';
$string['requiresattention'] = 'Vyžaduje pozornosť';
$string['requiresattentionexplanation'] = 'Tento doplnok neimplementuje rozhranie API na ochranu osobných údajov Moodle. Ak tento doplnok uchováva akékoľvek osobné údaje, nebude možné ich exportovať alebo vymazať prostredníctvom systému ochrany osobných údajov Moodle.';
$string['resubmitrequest'] = 'Znova odoslať žiadosť {$a->type} pre {$a->username}';
$string['resubmitrequestasnew'] = 'Znova odoslať ako novú žiadosť';
$string['resubmittedrequest'] = 'Existujúca žiadosť {$a->type} pre {$a->username} bola zrušená a znova odoslaná';
$string['resultdeleted'] = 'Nedávno ste požiadali o vymazanie účtu a osobných údajov v {$a}. Tento proces bol dokončený a už sa nebudete môcť prihlásiť.';
$string['resultdownloadready'] = 'Vaša kópia vašich osobných údajov z {$a}, o ktorú ste nedávno požiadali, je teraz k dispozícii na stiahnutie z nasledujúceho odkazu.';
$string['retentionperiod'] = 'Čas uchovania';
$string['retentionperiod_help'] = 'Obdobie uchovávania určuje dobu, počas ktorej by sa mali údaje uchovávať. Po uplynutí doby uchovávania sa údaje označia a zobrazia sa na odstránenie, pričom sa čaká na potvrdenie správcu.';
$string['retentionperiodnotdefined'] = 'Nebol stanovený žiadny čas uchovania';
$string['retentionperiodzero'] = 'Žiaden čas uchovania';
$string['reviewdata'] = 'Skontrolovať údaje';
$string['role'] = 'Rola';
$string['role_help'] = 'Rola, na ktorú by sa prepísanie malo vzťahovať.';
$string['roleoverride'] = 'Prepísanie roly';
$string['roleoverrideoverview'] = 'Predvolenú politiku uchovávania údajov je možné prepísať pre konkrétne roly používateľa, čo vám umožňuje zadať dlhšiu alebo kratšiu politiku uchovávania údajov. Platnosť používateľa vyprší až vtedy, keď vypršia všetky jeho roly.';
$string['roleoverrides'] = 'Prepísania rolí';
$string['selectbulkaction'] = 'Vyberte hromadnú akciu.';
$string['selectdatarequests'] = 'Vyberte žiadosti o údaje.';
$string['selectuserdatarequest'] = 'Vyberte požiadavku na údaje {$a->requesttype} od {$a->username}.';
$string['send'] = 'Odoslať';
$string['sensitivedatareasons'] = 'Dôvody spracovania citlivých osobných údajov';
$string['sensitivedatareasons_help'] = 'Vyberte jeden alebo viacero uplatniteľných dôvodov, ktoré oslobodzujú od zákazu spracúvania citlivých osobných údajov viazaných na tento účel. Ďalšie informácie nájdete v článku <a href="https://gdpr-info.eu/art-9-gdpr/" target="_blank">GDPR čl. 9.2</a>';
$string['setdefaults'] = 'Nastaviť východzie hodnoty';
$string['showdataretentionsummary'] = 'Zobraziť súhrn uchovávaných údajov';
$string['showdataretentionsummary_desc'] = 'Ak je povolené, zobrazí sa v päte stránky a na stránke profilu používateľa odkaz na súhrn uchovávania údajov.';
$string['statusapproved'] = 'Schválené';
$string['statusawaitingapproval'] = 'Čaká sa na schválenie';
$string['statuscancelled'] = 'Zrušené';
$string['statuscomplete'] = 'Skončené';
$string['statusdeleted'] = 'Vymazané';
$string['statusdetail'] = 'Stav:';
$string['statusexpired'] = 'Platnosť vypršala';
$string['statuspending'] = 'Čakajúce';
$string['statuspreprocessing'] = 'Predbežné spracovanie';
$string['statusprocessing'] = 'Spracovanie';
$string['statusready'] = 'Sťahovanie je pripravené';
$string['statusrejected'] = 'Odmietnuté';
$string['subjectscope'] = 'Rozsah predmetu';
$string['subjectscope_help'] = 'Rozsah predmetu uvádza roly, ktoré môžu byť v tomto kontexte priradené.';
$string['summary'] = 'Súhrn konfigurácie registra';
$string['systemconfignotsetwarning'] = 'Účel a kategória portálu neboli definované. Ak tieto nie sú definované, pri spracovaní žiadostí o vymazanie sa odstránia všetky údaje.';
$string['tobedeleted'] = 'Údaje na vymazanie';
$string['unexpiredrolewithretention'] = '{$a->retention} (Platnosť nevypršala)';
$string['user'] = 'Používateľ';
$string['userlistexplanation'] = 'Tento doplnok má základného poskytovateľa, ale mal by implementovať aj poskytovateľa zoznamu používateľov, aby plne podporoval funkcie ochrany osobných údajov.';
$string['userlistnoncompliant'] = 'Chýba poskytovateľ zoznamu používateľov';
$string['viewrequest'] = 'Zobraziť požiadavku';
$string['visible'] = 'Rozbaliť všetko';
