<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'data', language 'cs', version '4.4'.
 *
 * @package     data
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Akce';
$string['actionsmenu'] = 'Nabídka akcí';
$string['add'] = 'Přidat záznam';
$string['addcomment'] = 'Přidat komentář';
$string['addedby'] = 'Přidal';
$string['addentries'] = 'Přidat záznamy';
$string['addtemplate'] = 'Šablona Přidat záznam';
$string['advancedsearch'] = 'Pokročilé vyhledávání';
$string['allowcomments'] = 'Povolit komentáře k položkám';
$string['alttext'] = 'Alternativní text';
$string['approvalstatus'] = 'Stav schválení';
$string['approve'] = 'Schválit';
$string['approved'] = 'Schváleno';
$string['areacontent'] = 'Pole';
$string['ascending'] = 'Vzestupně';
$string['asearchtemplate'] = 'Šablona pokročilého vyhledávání';
$string['atmaxentry'] = 'Vložili jste maximální povolený počet záznamů!';
$string['authorfirstname'] = 'Křestní jméno';
$string['authorlastname'] = 'Příjmení';
$string['autogenallforms'] = 'Generovat všechny výchozí šablony';
$string['autolinkurl'] = 'Automaticky propojit URL';
$string['availablefromdate'] = 'Dostupné od';
$string['availabletags'] = 'Dostupné značky';
$string['availabletags_help'] = '

<p>Značky jsou zástupné symboly umístěné v šabloně; při zobrazení nebo úpravě
záznamu jsou značky nahrazeny obsahem polí nebo tlačítky.</p>

<p>Značky pro pole mají tento formát: [[názevpole]]</p>

<p>Značky pro tlačítka mají tento formát: ##popistlačítka##</p>

<p>V aktuální šabloně lze použít pouze značky uvedené v seznamu "Dostupné
značky".</p>';
$string['availabletodate'] = 'Dostupné do';
$string['availabletodatevalidation'] = 'Datum dostupné do, nemůže být před tím, než datum zahájení dostupnosti.';
$string['blank'] = 'Prázdný';
$string['buttons'] = 'Akce';
$string['bynameondate'] = '{$a->name} - {$a->date}';
$string['calendarend'] = '{$a} - uzavřeno';
$string['calendarstart'] = '{$a} - otevřeno';
$string['cancel'] = 'Zrušit';
$string['cannotaccesspresentsother'] = 'Nemáte oprávnění používat předlohy ostatních uživatelů';
$string['cannotadd'] = 'Nelze přidat záznamy!';
$string['cannotapplypreset'] = 'Chyba při použití předvolby.';
$string['cannotdeletepreset'] = 'Chyba při odstraňování předlohy';
$string['cannotoverwritepreset'] = 'Chyba při přepisu předlohy';
$string['cannotunziptopreset'] = 'Nelze rozbalit do adresáře s předlohami';
$string['checkbox'] = 'Zaškrtávací pole';
$string['chooseexportfields'] = 'Vyberte pole, které chcete exportovat';
$string['chooseexportformat'] = 'Vyberte formát, do kterého se má exportovat';
$string['chooseorupload'] = 'Vyberte soubor';
$string['choosepreset'] = 'Přednastavený soubor';
$string['closebeforeopen'] = 'Datum ukončení jste zadali před datem zahájení.';
$string['columns'] = 'sloupce';
$string['comment'] = 'Komentář';
$string['commentdeleted'] = 'Komentář byl smazán';
$string['commentempty'] = 'Komentář byl prázdný';
$string['comments'] = 'Komentáře';
$string['commentsaved'] = 'Komentář byl uložen';
$string['commentsn'] = 'Komentáře ({$a})';
$string['commentsoff'] = 'Komentáře jsou zakázané';
$string['completiondetail:entries'] = 'Vytvořit záznam: {$a}';
$string['completionentries'] = 'Povinná položka';
$string['completionentriescount'] = 'Přidat záznamy';
$string['completionentriesdesc'] = 'Minimální počet požadovaných záznamů:  {$a}';
$string['configenablerssfeeds'] = 'Povolit funkci RSS kanálů pro všechny databáze. Budete ještě muset zapnout RSS kanály v nastavení jednotlivých databází.';
$string['confirmdeletefield'] = 'Chcete skutečně odstranit toto pole?';
$string['confirmdeleterecord'] = 'Chcete skutečně odstranit tento záznam?';
$string['confirmdeleterecords'] = 'Jste si jisti, že chcete odstranit tyto položky?';
$string['createactivity'] = 'Vytvořit vlastní pole pro sběr dat nebo použijte předvolbu, která již pole obsahuje.';
$string['createfields'] = 'Vytvořit pole pro sběr různých typů dat.';
$string['createtemplates'] = 'Šablony definují rozhraní vaší aktivity. Jakmile vytvoříte pole, šablony se vytvoří automaticky. Případně můžete použít přednastavení, které zahrnuje pole a šablony.';
$string['csstemplate'] = 'Vlastní CSS';
$string['csvfailed'] = 'Nelze přečíst vstupní data z CSV souboru';
$string['csvfile'] = 'CSV nebo ZIP obsahující soubor CSV';
$string['csvimport'] = 'Import souboru CSV';
$string['csvimport_help'] = 'Na prvním řádku CSV souboru musí být uveden seznam názvů polí. Na dalších řádcích následují data, každý záznam na novém řádku.';
$string['csvwithselecteddelimiter'] = '<abbr title="Comma Separated Values">CSV</abbr>';
$string['data:addinstance'] = 'Přidat novou databázi';
$string['data:approve'] = 'Schvalovat záznamy a rušit schválení záznamů';
$string['data:comment'] = 'Psát komentáře';
$string['data:exportallentries'] = 'Exportovat všechny záznamy';
$string['data:exportentry'] = 'Exportovat jakýkoliv záznam';
$string['data:exportownentry'] = 'Exportovat vlastní záznam';
$string['data:exportuserinfo'] = 'Exportovat informace uživatele';
$string['data:managecomments'] = 'Spravovat komentáře';
$string['data:manageentries'] = 'Spravovat záznamy';
$string['data:managetemplates'] = 'Spravovat šablony';
$string['data:manageuserpresets'] = 'Spravovat předlohy';
$string['data:rate'] = 'Hodnotit záznamy';
$string['data:readentry'] = 'Číst záznamy';
$string['data:view'] = 'Zobrazit činnost databáze';
$string['data:viewallratings'] = 'Zobrazit individuální hodnocení uživatelů';
$string['data:viewalluserpresets'] = 'Prohlížet předlohy všech uživatelů';
$string['data:viewanyrating'] = 'Zobrazit celkové hodnocení libovolného uživatele';
$string['data:viewentry'] = 'Zobrazit záznamy';
$string['data:viewrating'] = 'Zobrazit celkové vlastní hodnocení';
$string['data:writeentry'] = 'Zapisovat záznamy';
$string['date'] = 'Datum';
$string['dateentered'] = 'Datum vložení';
$string['datemodified'] = 'Naposledy upraveno:';
$string['defaultfielddelimiter'] = '(výchozím je čárka)';
$string['defaultfieldenclosure'] = '(výchozím je žádný znak)';
$string['defaultsortfield'] = 'Výchozí kritérium pro řazení';
$string['delcheck'] = 'Zaškrtávací políčko hromadného odstranění';
$string['delete'] = 'Odstranit';
$string['deleteallentries'] = 'Odstranit všechny záznamy';
$string['deletecomment'] = 'Chcete skutečně odstranit tento komentář?';
$string['deleteconfirm'] = 'Odstranit předvolbu {$a}?';
$string['deleted'] = 'smazáno';
$string['deleteentry'] = 'Smazat záznam';
$string['deletefield'] = 'Odstranit pole';
$string['deletenotenrolled'] = 'Odstranit záznamy od uživatelů, kteří zde nejsou zapsáni';
$string['deletewarning'] = 'Odstraněním předvolby ji odeberete ze seznamu dostupných předvoleb ve všech kurzech.';
$string['descending'] = 'Sestupně';
$string['directorynotapreset'] = '{$a->directory} není předlohou: chybějící soubory: {$a->missing_files}';
$string['disapprove'] = 'Odvolat schválení';
$string['download'] = 'Stáhnout';
$string['edit'] = 'Upravit';
$string['editcomment'] = 'Upravit komentář';
$string['editentry'] = 'Upravit záznam';
$string['editfield'] = 'Upravit pole';
$string['editordisable'] = 'Zakázat editor';
$string['editorenable'] = 'Povolit editor kódu';
$string['editpreset'] = 'Upravit předvolbu';
$string['emptyadd'] = 'Šablona pro přidání záznamu je prázdná, generuji výchozí formulář...';
$string['emptyaddform'] = 'Nevyplnili jste žádná pole!';
$string['emptypresetname'] = 'Název předvolby nebo souboru nesmí být prázdný';
$string['enabletemplateeditorcheck'] = 'Jste si jisti, že chcete editor povolit? To může vést ke změně obsahu při ukládání šablony.';
$string['entries'] = 'Záznamy';
$string['entrieslefttoadd'] = 'Chcete-li dokončit tuto aktivitu, musíte přidat {$a->entriesleft} další položky/položky.';
$string['entrieslefttoaddtoview'] = 'Ještě musíte vložit {$a->entrieslefttoview} záznamů(-y), než budete moci vidět záznamy ostatních účastníků.';
$string['entry'] = 'Záznam';
$string['entrysaved'] = 'Záznam byl uložen';
$string['errordatafilenotfound'] = 'Soubor nelze importovat. Přijímané typy souborů jsou CSV nebo ZIP obsahující soubor CSV ve formátu používaném pro export položek.';
$string['errormustbeteacher'] = 'K této stránce mají přístup pouze učitelé!';
$string['errormustsupplyvalue'] = 'Musí obsahovat nějakou hodnotu.';
$string['errorpresetexists'] = 'Předvolba s tímto názvem již existuje.';
$string['errorpresetexistsbutnotoverwrite'] = 'Předvolba s tímto názvem již existuje. Vyberte jiný název.';
$string['errorpresetnotfound'] = 'Předvolba s názvem {$a} nebyla nalezena.';
$string['eventfieldcreated'] = 'Pole vytvořeno';
$string['eventfielddeleted'] = 'Pole odstraněno';
$string['eventfieldupdated'] = 'Pole aktualizováno';
$string['eventrecordcreated'] = 'Záznam vytvořen';
$string['eventrecorddeleted'] = 'Záznam odstraněn';
$string['eventrecordupdated'] = 'Záznam aktualizován';
$string['eventtemplateupdated'] = 'Šablona aktualizována';
$string['eventtemplateviewed'] = 'Šablona zobrazena';
$string['example'] = 'Příklad modulu Databáze';
$string['excel'] = 'Excel';
$string['expired'] = 'Tato činnost byla ukončena {$a} a není již nadále dostupná.';
$string['export'] = 'Exportovat';
$string['exportaszip'] = 'Exportovat jako ZIP';
$string['exportaszip_help'] = '<p>
  Tato volba umožňuje stáhnout šablony ze serveru do počítače a později je
  vložit do jiné databáze Moodlu pomocí funkce Importovat předlohy ze ZIP
  souboru.
</p>';
$string['exportedtozip'] = 'Exportováno do dočasného ZIP souboru ...';
$string['exportentries'] = 'Export záznamů';
$string['exportformat'] = 'Formát exportu';
$string['exportoptions'] = 'Možnosti exportu';
$string['exportownentries'] = 'Exportovat pouze vaše vlastní záznamy? ({$a->mine}/{$a->all})';
$string['exportpreset'] = 'Exportovat předvolbu';
$string['failedpresetdelete'] = 'Při pokusu o odstranění předvolby došlo k chybě.';
$string['fieldadded'] = 'Pole bylo přidáno';
$string['fieldallowautolink'] = 'Povolit automatické propojování';
$string['fielddeleted'] = 'Pole bylo smazáno';
$string['fielddelimiter'] = 'Oddělovač polí';
$string['fielddescription'] = 'Popis pole';
$string['fieldenclosure'] = 'Znak pro uzavření pole';
$string['fieldheight'] = 'Výška';
$string['fieldheightlistview'] = 'Výška (v pixelech) v zobrazení seznamu';
$string['fieldheightsingleview'] = 'Výška (v pixelech) v položkovém zobrazení';
$string['fieldids'] = 'Identifikátory pole';
$string['fieldmappings'] = 'Mapování polí';
$string['fieldmappings_help'] = 'Tato nabídka umožňuje uchovávat data z existující databáze.  Pro uchování
  dat v poli stávající databáze je nutné propojit je (tzv. mapovat) s novým polem. Údaj o novém poli můžete ponechat také nevyplněný, v tom případě bude toto pole odstraněno spolu se všemi záznamy, které  v něm byly uloženy.
  Mapovat lze pouze pole stejného typu, každé rozbalovací menu bude proto
 obsahovat různá pole. Je také třeba vyvarovat se pokusu mapovat jedno pole
 s více než jedním novým polem.';
$string['fieldname'] = 'Název pole';
$string['fieldnametype'] = '{$a->name} ({$a->type})';
$string['fieldnotmatched'] = 'Následující pole ve vašem souboru nemají svůj protějšek v databázi: {$a}';
$string['fieldoptions'] = 'Volby (jedna na řádek)';
$string['fields'] = 'Pole';
$string['fieldshelp'] = 'Vytvořit pole pro shromažďování různých typů dat. Pole definují strukturu záznamů ve vaší databázi.';
$string['fieldsinformationtags'] = 'Informační pole';
$string['fieldsnavigation'] = 'Pole terciární navigace';
$string['fieldtagdescription'] = 'Popis {$a}';
$string['fieldtagid'] = 'ID {$a}';
$string['fieldtagname'] = '{$a} jméno';
$string['fieldupdated'] = 'Pole bylo aktualizováno';
$string['fieldwidth'] = 'Šířka';
$string['fieldwidthlistview'] = 'Šířka  (v pixelech) v zobrazení seznamu';
$string['fieldwidthsingleview'] = 'Šířka (v pixelech) v položkovém zobrazení';
$string['file'] = 'Soubor';
$string['fileencoding'] = 'Kódování';
$string['filesnotgenerated'] = 'Nebyla vytvořena všechna pole: {$a}';
$string['filtername'] = 'Automatické propojování databáze';
$string['footer'] = 'Patička';
$string['forcelinkname'] = 'Namísto adresy zobrazit odkaz s následujícím textem';
$string['foundnorecords'] = 'Nenalezeny žádné záznamy. (<a href="{$a->reseturl}">Vymazat vše</a>)';
$string['foundrecords'] = 'Nalezeno {$a->num} z {$a->max} záznamů. (<a href="{$a->reseturl}">Vymazat vše</a>)';
$string['fromfile'] = 'Importovat ze ZIP souboru';
$string['fromfile_help'] = '<p>
  Zde můžete nahrát předlohy vytvořené pomocí exportní aplikace modulu Databáze.
</p>';
$string['generateerror'] = 'Nebyly vytvořeny všechny soubory!';
$string['header'] = 'Hlavička';
$string['headeraddtemplate'] = 'Definujte rozhraní pro přidávání nebo úpravu záznamů.';
$string['headerasearchtemplate'] = 'Definuje rozhraní pro pokročilé vyhledávání.';
$string['headercsstemplate'] = 'Definuje vlastní styly CSS pro šablony.';
$string['headerjstemplate'] = 'Přidat vlastní JavaScript pro šablony Seznam, Záznam nebo Přidat záznam.';
$string['headerlisttemplate'] = 'Definuje formát pro zobrazení Seznamu záznamů.';
$string['headerrsstemplate'] = 'Definuje formátování záznamů v RSS kanálech.';
$string['headersingletemplate'] = 'Definuje formát pro zobrazení Jednoduché sestavy.';
$string['id'] = 'ID vstupu';
$string['importandapply'] = 'Importovat předvolbu a použít';
$string['importapreset'] = 'Importovat předvolbu';
$string['importentries'] = 'Import záznamů';
$string['importpreset'] = 'Importovat předvolbu';
$string['importpreset_desc'] = 'Přednastavení bude aplikováno na tuto aktivitu a vytvoří se pole a šablony. Nezobrazí se v seznamu předvoleb.';
$string['importpresetmissingcapability'] = 'Nemáte oprávnění importovat předvolbu.';
$string['importsuccess'] = 'Předloha použita';
$string['includeapproval'] = 'Zahrnout stav schválení';
$string['includefiles'] = 'Zahrnout soubory do exportu';
$string['includetags'] = 'Zahrnout štítky';
$string['includetime'] = 'Zahrnout čas přidání/změny';
$string['includeuserdetails'] = 'Zahrnout údaje uživatele';
$string['indicator:cognitivedepth'] = 'Kognitivní Databáze';
$string['indicator:cognitivedepth_help'] = 'Tento ukazatel je založen na studentem získané kognitivní hloubce v aktivitě Databáze.';
$string['indicator:cognitivedepthdef'] = 'Kognitivní Databáze';
$string['indicator:cognitivedepthdef_help'] = 'Během tohoto intervalu analýzy dosáhl účastník tohoto procenta kognitivní angažovanosti nabízené aktivitami Databáze (Úrovně = Bez zobrazení, Zobrazení, Odevzdání)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Sociální Databáze';
$string['indicator:socialbreadth_help'] = 'Tento ukazatel je založen na studentem získané sociální šířce v aktivitě Databáze.';
$string['indicator:socialbreadthdef'] = 'Sociální Databáze';
$string['indicator:socialbreadthdef_help'] = 'Během tohoto intervalu analýzy dosáhl účastník tohoto procenta sociální angažovanosti nabízené aktivitou Databáze (Úrovně = Bez účasti, Účastník sám)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insufficiententries'] = 'pro prohlížení databáze je potřeba více záznamů';
$string['intro'] = 'Popis';
$string['invalidaccess'] = 'Neplatný přístup ke stránce';
$string['invalidfieldid'] = 'Neplatný identifikátor pole';
$string['invalidfieldname'] = 'Zvolte jiný název pro toto pole';
$string['invalidfieldtype'] = 'Neplatný typ pole';
$string['invalidid'] = 'Neplatný identifikátor údajů';
$string['invalidpreset'] = '{$a} není platná předloha';
$string['invalidrecord'] = 'Neplatný záznam';
$string['invalidurl'] = 'Použité URL není platné';
$string['jstemplate'] = 'Vlastní Javascript';
$string['latitude'] = 'Zeměpisná šířka';
$string['latlong'] = 'Souřadnice';
$string['latlongboth'] = 'Je požadována zeměpisná šířka i délka.';
$string['latlongdownloadallhint'] = 'Stáhnout odkaz pro všechny záznamy ve formátu KML';
$string['latlongkmllabelling'] = 'Jak popisovat položky v KML souborech. KML je formát pro zobrazování zeměpisných údajů použitelný např. v Google Earth';
$string['latlonglinkservicesdisplayed'] = 'Zobrazované služby';
$string['latlongotherfields'] = 'Další pole';
$string['list'] = 'Prohlédnout seznam';
$string['listtemplate'] = 'Šablona zobrazení seznamu';
$string['listview'] = 'Zobrazení seznamu';
$string['longitude'] = 'Zeměpisná délka';
$string['manageapproved'] = 'Povolit úpravy schválených záznamů';
$string['manageapproved_help'] = 'Povolit studentům upravovat nebo mazat své záznamy poté, co byly schváleny. Upravené záznamy bude nutné znovu schválit.';
$string['managefields'] = 'Spravovat pole';
$string['mapexistingfield'] = 'Mapovat na {$a}';
$string['mapnewfield'] = 'Vytvořit nové pole';
$string['mapping:applypresets'] = 'Použít předvolbu';
$string['mapping:dialogtitle:usepreset'] = 'Použít předvolbu {$a}?';
$string['mapping:fieldstocreate'] = 'Pole k vytvoření: {$a}';
$string['mapping:fieldstodelete'] = 'Existující pole ke smazání: {$a}';
$string['mapping:mapfields'] = 'Mapová pole';
$string['mapping:warningmessagedelete'] = 'Pokud jsou pole, která mají být odstraněna, stejného typu jako nová pole v předvolbě, kterou používáte, možná je budete moci namapovat  Mapových polích.';
$string['mapping:warningmessagedeleteandcreate'] = 'Pokud jsou pole, která mají být odstraněna, stejného typu jako pole, která mají být vytvořena, můžete je namapovat v Mapových polích.';
$string['mappingwarning'] = 'Všechna stará pole, která nejsou mapována do nových, budou odstraněna a data, která obsahují, budou ztracena.';
$string['maxentries'] = 'Maximální počet záznamů';
$string['maxentries_help'] = '

<p>Maximální počet záznamů, které přispěvatel může vložit do této databáze.</p>';
$string['maxsize'] = 'Maximální velikost';
$string['menu'] = 'Seznam';
$string['menuchoose'] = 'Vybrat...';
$string['missingdata'] = 'Pro třídu pole musí být poskytnuto ID dat nebo objekt.';
$string['missingfield'] = 'Chyba programu: Musíte určit pole a/nebo data při definici třídy pole.';
$string['missingfieldtype'] = 'Typ pole pro {$a->name} nebyl nalezen';
$string['missingfieldtypeimport'] = 'Následující pole nebyla importována, protože jejich odpovídající typy polí nejsou nainstalovány:';
$string['missingfieldtypes'] = 'Následující pole nemají nainstalované odpovídající typy polí a nebudou zahrnuta do formuláře Přidat. Musíte zkontrolovat šablonu Přidat položku a odstranit všechny názvy polí.';
$string['modulename'] = 'Databáze';
$string['modulename_help'] = 'Databáze umožňuje účastníkům vytvářet, udržovat a prohledávat kolekci záznamů.

Struktura položek je definována pomocí různých typů polí, jako je krátký text, rozevírací seznam, textová oblast, adresa URL, obrázek nebo soubor.

Učitel může povolit komentáře k záznamům a hodnotit. Příspěvky je možno hodnotit učitelem nebo studenty (vzájemné hodnocení). Hodnocení se přepočítává na výslednou známku, která může být součástí klasifikace v kurzu.

Databáze má mnoho využití např.

* Vytvořit společnou sbírku odkazů na webové stránky, literaturu, články v odborných časopisech apod.
* Zobrazit fotografie, plakáty, webové stránky nebo básně vytvořené studenty pro poznámky a recenze.';
$string['modulename_link'] = 'mod/data/view';
$string['modulenameplural'] = 'Databáze';
$string['more'] = 'Podrobněji';
$string['moreurl'] = 'Další URL';
$string['movezipfailed'] = 'Nelze přesunout ZIP archív';
$string['multientry'] = 'Podoba jednoho záznamu v seznamu';
$string['multimenu'] = 'Seznam (výběr více voleb)';
$string['multipletags'] = 'Nalezeno více značek! Šablona nebyla uložena.';
$string['newentry'] = 'Nový záznam';
$string['newfield'] = 'Vytvořit pole';
$string['newfield_help'] = 'Pole umožňuje zadávání dat. Každá položka v činnosti databáze může mít více polí různých typů, například pole datum, které účastníkům umožňuje vybrat den, měsíc a rok z rozevírací nabídky, pole obrázku, které umožňuje účastníkům nahrát soubor s obrázkem, nebo zaškrtávací políčko, které účastníkům umožňuje vybrat jednu nebo více možností.

Každé pole musí mít jedinečný název pole. Popis pole je nepovinný.';
$string['noaccess'] = 'K této stránce nemáte přístup.';
$string['nodefinedfields'] = 'Nová předloha nemá definována žádná pole!';
$string['nofieldcontent'] = 'Obsah pole nebyl nalezen';
$string['nofieldindatabase'] = 'Nejsou definována žádná pole v této databázi';
$string['nofields'] = 'Zatím žádná pole';
$string['nolisttemplate'] = 'Šablona zobrazení seznamu zatím není definována';
$string['nomatch'] = 'Nenalezeny žádné záznamy!';
$string['nomaximum'] = 'Není stanoven';
$string['nopreviewavailable'] = 'Pro {$a} není k dispozici žádný náhled';
$string['norecords'] = 'Zatím žádné záznamy';
$string['nosingletemplate'] = 'Šablona zobrazení pro jeden záznam ještě není definována';
$string['notapproved'] = 'Čeká na schválení';
$string['notapprovederror'] = 'Vstup zatím není schválen.';
$string['notemplates'] = 'Zatím žádné šablony';
$string['notinjectivemap'] = 'Není mapa vkládání';
$string['notopenyet'] = 'Tato činnost nebude dostupná až do {$a}';
$string['number'] = 'Číslo';
$string['numberrssarticles'] = 'Záznamy v RSS';
$string['numnotapproved'] = 'Ke schválení';
$string['numrecords'] = '{$a} záznamů';
$string['ods'] = '<abbr title="OpenDocument Spreadsheet">ODS</abbr>&nbsp;(OpenOffice)';
$string['openafterclose'] = 'Datum zahájení jste zadali po datu ukončení.';
$string['optionaldescription'] = 'Krátký popis (nepovinný údaj)';
$string['optionalfilename'] = 'Jméno souboru (nepovinný údaj)';
$string['other'] = 'Jiné';
$string['otherfields'] = 'Všechna ostatní pole';
$string['overrwritedesc'] = 'Nahraďte stávající předvolbu tímto názvem a přepište její obsah';
$string['overwrite'] = 'Přepsat';
$string['overwritesettings'] = 'Přepsat aktuální nastavení, jako jsou komentáře, hodnocení atd.';
$string['page-mod-data-x'] = 'Jakákoliv stránka databáze';
$string['pagesize'] = 'Počet záznamů na stránku';
$string['participants'] = 'Přispěvatelé';
$string['picture'] = 'Obrázek';
$string['pleaseaddsome'] = 'Vedle vytvoření nových polí můžete též <a href="{$a}">použít některou z nadefinovaných předloh</a>.';
$string['pluginadministration'] = 'Správa databáze';
$string['pluginname'] = 'Databáze';
$string['portfolionotfile'] = 'Exportovat do portfolia namísto do souboru (pouze CSV a Leap2A)';
$string['presetdeleted'] = 'Předvolba odstraněna.';
$string['presetinfo'] = 'Pokud uložíte tuto šablonu jako předlohu, budou ji moci ostatní uživatelé na tomto serveru používat ve svých kurzech.';
$string['presetnotselected'] = 'Nebyla vybrána žádná předvolba.';
$string['presets'] = 'Předlohy';
$string['presetshelp'] = 'Vyberte předvolbu, kterou chcete použít jako výchozí bod.';
$string['preview'] = 'Náhled  {$a}';
$string['previewaction'] = 'Náhled';
$string['privacy:metadata:commentpurpose'] = 'Komentáře k databázovým záznamům';
$string['privacy:metadata:data_content'] = 'Obsah pole';
$string['privacy:metadata:data_content:content'] = 'Obsah';
$string['privacy:metadata:data_content:content1'] = 'Další obsah 1';
$string['privacy:metadata:data_content:content2'] = 'Další obsah 2';
$string['privacy:metadata:data_content:content3'] = 'Další obsah 3';
$string['privacy:metadata:data_content:content4'] = 'Další obsah 4';
$string['privacy:metadata:data_content:fieldid'] = 'ID definice pole';
$string['privacy:metadata:data_records'] = 'Záznamy v databázové aktivitě';
$string['privacy:metadata:data_records:approved'] = 'Stav schválení';
$string['privacy:metadata:data_records:groupid'] = 'Skupina';
$string['privacy:metadata:data_records:timecreated'] = 'Čas vytvoření záznamu';
$string['privacy:metadata:data_records:timemodified'] = 'Čas poslední úpravy záznamu';
$string['privacy:metadata:data_records:userid'] = 'Uživatel, který záznam vytvořil';
$string['privacy:metadata:datafieldnpluginsummary'] = 'Pole pro modul činnosti databáze';
$string['privacy:metadata:filepurpose'] = 'Soubor připojený k databázovému záznamu';
$string['privacy:metadata:ratingpurpose'] = 'Hodnocení databázových záznamů';
$string['privacy:metadata:tagpurpose'] = 'Štítky v databázových záznamů';
$string['radiobutton'] = 'Přepínací tlačítka';
$string['recordapproved'] = 'Záznam byl schválen';
$string['recorddeleted'] = 'Záznam byl smazán';
$string['recorddisapproved'] = 'Neschválený záznam';
$string['recordsnotsaved'] = 'Nebyly vloženy žádné záznamy. Zkontrolujte prosím formát vkládaného souboru.';
$string['recordssaved'] = 'vložených záznamů';
$string['removealldatatags'] = 'Odstranit všechny štítky databáze';
$string['requireapproval'] = 'Vyžadovat schválení';
$string['requireapproval_help'] = 'Učitel musí položky schválit, než je dostupný účastníkům kurzu.';
$string['required'] = 'Povinné';
$string['requiredentries'] = 'Počet požadovaných záznamů pro splnění (staré)';
$string['requiredentries_help'] = 'Je-li nastaveno, zobrazí se zpráva s uvedením počtu záznamů, které má přispěvatel vložit pro dokončení. Všimněte si, že toto nastavení není připojeno k ukončení činnosti.

Pro potřebné záznamy pro dokončení činnosti je nové nastavení dokončení činnosti,  měla by být použita volba "Požadovat položky". Chcete-li toto nastavení zcela odebrat, uložte změny.

Namísto Plnění činností použijte Povinné pole.';
$string['requiredentriestoview'] = 'Počet záznamů požadovaných před zpřístupněním databáze';
$string['requiredentriestoview_help'] = 'Počet záznamů, které musí student přidat, než bude moci zobrazit záznamy od ostatních studentů.

 Toto není kompatibilní s filtrem automatického propojení databáze.';
$string['requiredentrieswarning'] = 'Toto nastavení bylo nahrazeno nastavením Plnění činností "Požadovat položky"';
$string['requiredfield'] = 'Povinné pole';
$string['resetalltemplates'] = 'Resetovat všechny šablony';
$string['resetalltemplatesconfirm'] = 'Chystáte se odstranit všechny šablony pro aktuální předvolbu. Pokud budete chtít šablony později obnovit, musíte předvolbu znovu vybrat na kartě „Předvolby“.';
$string['resetalltemplatesconfirmtitle'] = 'Resetovat všechny šablony?';
$string['resetsettings'] = 'Resetovat filtry';
$string['resettemplate'] = 'Obnovit aktuální šablonu';
$string['resettemplateconfirm'] = 'Tím pro vaši aktuální předvolbu trvale odstraníte {$a}.';
$string['resettemplateconfirmtitle'] = 'Resetovat šablonu?';
$string['resizingimages'] = 'Změna velikosti náhledů ...';
$string['rows'] = 'řádky';
$string['rssglobaldisabled'] = 'Není v provozu. Zkontrolujte nastavení.';
$string['rsstemplate'] = 'Šablona RSS zpráv';
$string['rsstitletemplate'] = 'Titulek RSS zpráv';
$string['rsstype'] = 'RSS kanál pro tuto aktivitu';
$string['save'] = 'Uložit';
$string['saveandadd'] = 'Uložit a vložit další';
$string['saveandview'] = 'Uložit a prohlédnout';
$string['saveaspreset'] = 'Publikovat předvolbu na tomto webu';
$string['saveaspreset_help'] = '<p>
  Tímto tlačítkem zveřejníte aktuální šablonu jako předlohu, kterou si může
  prohlédnout a použít jakýkoliv jiný registrovaný uživatel stránek. Jméno
  šablony se bude vypisovat v&nbsp;seznamu dostupných předloh &ndash; na tomto
  místě ji také budete moci kdykoliv později odstranit.
</p>';
$string['saveaspresetmissingcapability'] = 'Uživatel nemá správná oprávnění k uložení databáze jako předvolbu.';
$string['savedataaspreset'] = 'Uložit všechna pole a šablony jako přednastavená';
$string['savesettings'] = 'Uložit nastavení';
$string['savesuccess'] = 'Předvolba uložena. <a href="{$a->url}">Přednastavený náhled</a>';
$string['savetemplate'] = 'Uložit šablonu';
$string['search'] = 'Vyhledat';
$string['search:activity'] = 'Databáze - informace';
$string['search:entry'] = 'Databáze - příspěvky';
$string['searchresults'] = 'Záznamy obsahující „{$a}“';
$string['selectedrequired'] = 'Všechna zvolená povinná';
$string['selectexportoptions'] = 'Vybrat možnosti exportu';
$string['selectfields'] = 'Vybrat pole';
$string['selectfordeletion'] = 'Vybrat záznam pro smazání';
$string['showall'] = 'Ukázat všechny položky';
$string['showmore'] = 'Zobrazit více';
$string['single'] = 'Zobrazit jednotlivě';
$string['singletemplate'] = 'Šablona zobrazení pro jeden záznam';
$string['singleview'] = 'Zobrazit jednotlivě';
$string['startbuilding'] = 'Začněte budovat svou aktivitu';
$string['subplugintype_datafield'] = 'Typ databázového pole';
$string['subplugintype_datafield_plural'] = 'Typy databázových polí';
$string['subplugintype_datapreset'] = 'Šablona';
$string['subplugintype_datapreset_plural'] = 'Předlohy';
$string['tagarea_data_records'] = 'Datové záznamy';
$string['tags'] = 'Štítky';
$string['tagsdeleted'] = 'Štítky databáze byly odstraněny';
$string['teachersandstudents'] = '{$a->teachers} a {$a->students}';
$string['templatereset'] = 'Resetovat šablonu';
$string['templateresetall'] = 'Všechny šablony byly resetovány';
$string['templates'] = 'Šablony';
$string['templatesaved'] = 'Šablona byla uložena';
$string['templatesnavigation'] = 'Šablony terciární navigace';
$string['text'] = 'Text (jednořádkový)';
$string['textarea'] = 'Textová oblast';
$string['timeadded'] = 'Čas vložení';
$string['timemodified'] = 'Čas poslední úpravy';
$string['todatabase'] = 'do této databáze';
$string['type'] = 'Typ pole';
$string['undefinedprocessactionmethod'] = 'V Data_Preset není definována metoda pro zpracování činnosti "{$a}".';
$string['unknown'] = 'Neznámé pole';
$string['unsupportedfields'] = 'Nepodporovaná pole';
$string['unsupportedfieldslist'] = 'Nelze exportovat následující pole:';
$string['updatefield'] = 'Aktualizovat existující pole';
$string['uploadfile'] = 'Vložit soubor';
$string['uploadrecords'] = 'Importovat záznamy';
$string['uploadrecords_help'] = 'Importujte položky, které jste exportovali z jiné databáze, buď prostřednictvím CSV nebo ZIP obsahujícího soubor CSV (pokud jsou v exportu zahrnuty soubory).

Případně pro vytvoření souboru CSV pro import přidejte do databáze jednu položku a poté ji exportujte. Upravte soubor CSV a přidejte další položky.';
$string['uploadrecords_link'] = 'mod/data/import';
$string['url'] = 'URL';
$string['usedate'] = 'Zahrnout do vyhledávání.';
$string['usepredefinedset'] = 'Použít předdefinované nastavení';
$string['usepreset'] = 'Použít tuto předvolbu';
$string['usestandard'] = 'Použít předlohu';
$string['usestandard_help'] = '<p>
  Zde si můžete vybrat šablonu přístupnou všem uživatelům stránek.
</p>
<p>
  Pokud jste dříve zveřejnili některou ze svých šablon pomocí funkce \'Uložit
  jako předlohu\', můžete ji zde ze seznamu zase odstranit.
</p>';
$string['viewfromdate'] = 'Prohlížet lze od';
$string['viewnavigation'] = 'Terciální navigace v režimu zobrazení';
$string['viewtemplates'] = 'Zobrazit šablony';
$string['viewtodate'] = 'Prohlížet lze do';
$string['viewtodatevalidation'] = 'Datum pro ukončení intervalu pro čtení, nemůže být před tím, než datum zahájení čtení.';
$string['wrongdataid'] = 'Bylo zadáno nesprávné ID dat';
