<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'openbook', language 'de', version '4.4'.
 *
 * @package     openbook
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add_uploads'] = 'Dateien hinzufügen';
$string['allfiles'] = 'Dateiuploads';
$string['allowedfiletypes'] = 'Akzeptierte Dateitypen';
$string['allowedfiletypes_err'] = 'Bitte Eingabe überprüfen! Dateitypen enthalten ungültige Sonder- oder Trennzeichen';
$string['allowedfiletypes_help'] = 'Die akzeptierten Dateitypen können Sie hier einschränken. Entweder als kommagetrennte Liste aus Mimetypes, z.B. \'video/mp4, audio/mp3, image/png, image/jpeg\', oder als kommagtrennte Liste aus Dateiendungen, z.B, \'.png, .jpg\'. Falls das Feld leer ist, sind alle Dateitypen erlaubt.';
$string['allowsubmissionsanddescriptionfromdatesummary'] = 'The assignment details and submission form will be available from <strong>{$a}</strong>';
$string['allowsubmissionsfromdate'] = 'Hochladen ab';
$string['allowsubmissionsfromdate_help'] = 'If this option is enabled, participants cannot submit their file submissions before this date. If the option is disabled, participants can start submitting right away.';
$string['allowsubmissionsfromdate_upload'] = 'Hochladen ab';
$string['allowsubmissionsfromdatesummary'] = 'This assignment will accept submissions from <strong>{$a}</strong>';
$string['alwaysshowdescription'] = 'Always show description';
$string['alwaysshowdescription_help'] = 'If disabled, the assignment description above will only become visible to students at the "Upload/Approval from" date.';
$string['approval_required'] = 'Genehmigung ausstehend';
$string['approval_timeover'] = 'Es gibt keine Datei, die auf die Freigabe zum Teilen wartet, oder die Freigabezeit ist abgelaufen.';
$string['approval_timeover_description'] = 'Sharing approval';
$string['approvalchange'] = 'Openbook resource folder status changed';
$string['approvalfromdate'] = 'Freigabe ab';
$string['approvalfromdate_help'] = 'Der Status zum Teilen kann vor diesem Datum nicht geändert werden. Diese Einstellung ist nur relevant, wenn die Genehmigung von Teilnehmer/innen nicht automatisch erfolgt.';
$string['approvalsettings'] = 'Openbook resource folder settings';
$string['approvaltodate'] = 'Freigabe bis';
$string['approvaltodate_help'] = 'Approval status cannot be changed after this date. Diese Einstellung is only relevant when Student approval is not automatic.';
$string['approvaltodatevalidation'] = 'Approval until date must be after the approval from date.';
$string['approved'] = 'Genehmigt';
$string['approveusers'] = 'Genehmigen';
$string['assignment_notfound'] = 'The assignment from which files were imported, could no longer be found.';
$string['assignment_notset'] = 'No assignment has been chosen.';
$string['availability'] = 'Editing period (upload or approval)';
$string['availabilityrestriction'] = 'Voraussetzungen auf Nutzerliste anwenden';
$string['availabilityrestriction_admin'] = 'Standardeinstellung für Voraussetzungen in der Nutzerliste';
$string['availabilityrestriction_admin_desc'] = 'Teilnehmer/innen, die aufgrund von definierten Voraussetzungen nicht auf die Aktivität zugreifen können, werden aus der Liste entfernt.<br>Dazu gehören nur Bedingungen, die auf Nutzerlisten anwendbar sind. Zum Beispiel werden Gruppenbedingungen einbezogen, aber Datumsbedingungen nicht.';
$string['availabilityrestriction_help'] = 'Teilnehmer/innen, die aufgrund von definierten Voraussetzungen nicht auf die Aktivität zugreifen können, werden aus der Liste entfernt.<br>Dazu gehören nur Bedingungen, die auf Nutzerlisten anwendbar sind. Zum Beispiel werden Gruppenbedingungen einbezogen, aber Datumsbedingungen nicht.';
$string['completiondetail:upload'] = 'Eine Datei hochladen';
$string['completionupload'] = 'Teilnehmer/in muss eine Datei hochladen';
$string['configautoimport'] = 'Mit dieser Option legen Sie fest, dass Abgaben von Teilnehmer/innen automatisch in Openbook Ressourcenordner importiert werden. Diese Funktion für jeden Openbook Ressourcenordner separat aktiviert/deaktiviert werden.';
$string['configmaxbytes'] = 'Standardmäßige maximale Dateigröße für Dateien im Openbook Ressourcenordner.';
$string['configmaxfiles'] = 'Standardmäßig maximal zulässige Anzahl von Dateien pro Nutzer/in.';
$string['courseuploadlimit'] = 'Maximale Dateigröße';
$string['currentlynotapproved'] = '* Currently not approved or rejected to publication.';
$string['datalogapprovalstudent'] = '(Students {$a->approving} out of {$a->needed}) {$a->approval}';
$string['details'] = 'Details';
$string['downloadall'] = 'Alle Dateieinreichungen herunterladen';
$string['duedate'] = 'To';
$string['duedate_help'] = 'If this option is enabled, participants cannot submit their file submissions after this date. If the option is disabled, participants can submit forever.';
$string['duedate_upload'] = 'Hochladen bis';
$string['duedatevalidation'] = 'Due date must be after the allow submissions from date.';
$string['edit_teacher_uploads'] = 'Dateien von Trainer/innen bearbeiten/hochladen';
$string['edit_timeover'] = 'Files can be edited/uploaded only during the editing period.';
$string['edit_uploads'] = 'Dateien bearbeiten/hochladen';
$string['email:filechange:footer'] = '</ul><br />Please check if your permission for Openbook resource folder is required.';
$string['email:filechange_import:header'] = 'The following file(s) from Assignment <b>\'{$a->assign}\'</b> was/were imported into <b>\'{$a->openbook}\'</b> on {$a->dayupdated} at {$a->timeupdated}:<br /><ul>';
$string['email:filechange_import:subject'] = 'File(s) imported';
$string['email:filechange_upload:header'] = '<b>{$a->username}</b> has uploaded the following file(s) to <b>\'{$a->openbook}\'</b> on {$a->dayupdated} at {$a->timeupdated}:<br /><ul>';
$string['email:filechange_upload:subject'] = 'File(s) uploaded';
$string['email:statuschange:filename'] = '<li>\'{$a->filename}\' to \'<b>{$a->apstatus}</b>\'</li>';
$string['email:statuschange:footer'] = '</ul>';
$string['email:statuschange:header'] = 'The Openbook resource folder status of the following file(s) for <b>\'{$a->openbook}\'</b> was changed on {$a->dayupdated} at {$a->timeupdated} by <b>{$a->username}</b>:<br /><ul>';
$string['email:statuschange:subject'] = 'Openbook Ressourcenordner-Datei Status geändert';
$string['entiresperpage'] = 'Einträge pro Seite';
$string['eventopenbookapprovalchanged'] = 'Openbook Ressourcenordner-Datei Genehmigung geändert';
$string['eventopenbookduedateextended'] = 'Openbook Ressourcenordner-Datei importiert';
$string['eventopenbookfiledeleted'] = 'Openbook Ressourcenordner-Datei gelöscht';
$string['eventopenbookfileimported'] = 'Openbook Ressourcenordner-Datei importiert';
$string['eventopenbookfileuploaded'] = 'Openbook Ressourcenordner-Datei hochgeladen';
$string['eventoverridecreated'] = 'Openbook resource folder override created';
$string['eventoverridedeleted'] = 'Openbook resource folder override deleted';
$string['eventoverrideupdated'] = 'Openbook resource folder override updated';
$string['extensionto'] = 'Extension to';
$string['filedetails'] = 'Details';
$string['filesarepersonal'] = 'Dateien sind persönlich';
$string['filesarepersonal_admin'] = 'Dateien sind persönlich';
$string['filesarepersonal_admin_desc'] = 'Diese Einstellung legt die Standard-Sichtbarkeitseinstellung für Dateien von Teilnehmer/innen fest.';
$string['filesarepersonal_help'] = 'This option determines if submitted files remain private to the owner: <br><ul><li><strong>Yes</strong> - files are private and personal.</li><li><strong>No</strong> - Files can be shared between students, if they are approved by needed parties.</li></ul>';
$string['filesarepersonal_no'] = 'Nein (Dateien können zwischen Teilnehmer/innen geteilt werden.)';
$string['filesarepersonal_yes'] = 'Ja (Dateien sind persönlich)';
$string['filesofthesetypes'] = 'Dateien dieses Typs können hinzugefügt werden:';
$string['filter'] = 'Filter';
$string['filter:allfiles'] = 'Alle Dateiuploads';
$string['filter:approvalrequired'] = 'Entscheidung ausstehend';
$string['filter:approved'] = 'Approved file submissions';
$string['filter:nofiles'] = 'No file submission';
$string['filter:nofilter'] = 'Kein Filter';
$string['filter:rejected'] = 'Rejected file submissions';
$string['giveapproval'] = 'Give approval';
$string['go'] = 'Go';
$string['grantextension'] = 'Fristverlängerung gewähren';
$string['group_approved'] = 'Freigabe von allen Mitgliedern der Gruppe erteilt';
$string['guideline'] = 'Openbook Ressourcenordner aus Dateiuploads';
$string['hidden'] = 'Nicht veröffentlicht';
$string['maxbytes'] = 'Maximale Dateigröße';
$string['maxbytes_help'] = 'Legt die Größenbegrenzung für hochgeladene Dateien fest.';
$string['maxfiles'] = 'Maximale Anzahl an Dateien';
$string['maxfiles_help'] = 'Jede/r Teilnehmer/in kann bis zu dieser Anzahl von Dateien für sich hochladen.';
$string['messageprovider:openbook_updates'] = 'Openbook resource folder notifications';
$string['modulename'] = 'Openbook Ressourcenordner';
$string['modulename_help'] = 'Der Openbook Ressourcenordner bietet die folgenden Funktionen:<br><ul><li>Teilnehmer/innen können Dateien hochladen. Der Zeitraum kann vom Trainer/innen eingeschränkt werden. </li><li>Die Dateien werden automatisch oder nach Freigabe durch Teilnehmer/innen und/oder Trainer/innen veröffentlicht. Wenn das erlaubt ist, können die Teilnehmer/innen die Datei für alle Teilnehmer/innen sichtbar machen, andernfalls sieht jede/r Teilnehmer/in nur ihre/seine eigenen hochgeladenen Dokumente.</li><li>Teilnehmer/innen und/oder Trainer/innen erhalten eine Benachrichtigung, wenn Teilnehmer/innen eine Datei hochladen oder ändern. Darüber hinaus erhalten Studierende und/oder Trainer/innen eine Benachrichtigung über alle Änderungen des Status des Openbook Ressourcenordner. </li><li>PDF-Dateien im Openbook Ressourcenordner können so eingestellt werden, dass sie in einem PDF.js geöffnet werden. </li><li>Die/der Trainer/in kann einen Zeitraum festlegen, in dem die geöffneten Dokumente in einem sicheren Fenster angezeigt werden, d. h. in einem Fenster ohne Moodle-Navigation usw.</li></li></ul>';
$string['modulenameplural'] = 'Openbook Ressourcenordner';
$string['myfiles'] = 'Eigene Dateien';
$string['mygroupfiles'] = 'My group\'s files';
$string['myownfiles'] = 'Meine eigenen Dateien';
$string['name'] = 'Name';
$string['noentries'] = 'No entries';
$string['nofiles'] = 'Keine Dateien verfügbar';
$string['nofilestodisplay'] = 'Aktuell sind noch keine Dateien vorhanden bzw. noch nicht veröffentlicht.';
$string['nofilestozip'] = 'Keine Dateien zum Zippen';
$string['nonexistentfiletypes'] = 'Die folgenden Dateitypen konnten nicht erkannt werden: {$a}';
$string['noopenbooksincourse'] = 'Es gibt keine Openbook Ressourcenordner-Instanzen in diesem Kurs.';
$string['nothing_to_show_groups'] = 'Nothing to display - no groups available';
$string['nothing_to_show_users'] = 'Nothing to display - no students available';
$string['nothingtodisplay'] = 'Keine Einträge';
$string['notice'] = '<strong>Notice: </strong>';
$string['notice_group_all_teachernotrequired'] = 'The files will only be published for all students with the approval of <strong>ALL group members.</strong>';
$string['notice_group_all_teacherrequired'] = 'The files will only be published for all students with the approval of <strong>ALL group members and the teacher.</strong> Teachers reserve the right to reject the publication of your files at any time.';
$string['notice_group_one_teachernotrequired'] = 'The files will only be published for all students with the approval of <strong>at LEAST ONE group member.</strong>';
$string['notice_group_one_teacherrequired'] = 'The files will only be published for all students with the approval of <strong>at LEAST ONE group member and the teacher.</strong> Teachers reserve the right to reject the publication of your files at any time.';
$string['notice_import_studentnotrequired_teachernotrequired'] = 'The files will be published (will be made visible to everyone) <strong>automatically.</strong>';
$string['notice_import_studentnotrequired_teacherrequired'] = 'The files will be published (will be made visible for everyone) only <strong>nach Genehmigung einer/eines Trainer/in.</strong> Teachers reserve the right to reject the publication of your files at any time.';
$string['notice_import_studentrequired_teachernotrequired'] = 'The files will be published (will be made visible for everyone) after <strong>your approval.</strong>';
$string['notice_import_studentrequired_teacherrequired'] = 'The files will be published (will be made visible for everyone) after <strong>your approval and the approval of teachers.</strong> Teachers reserve the right to reject the publication of your files at any time.';
$string['notice_upload_filesarepersonal_teachernotrequired'] = 'All files you upload here will be personal and visible to you <strong>automatically.</strong>';
$string['notice_upload_filesarepersonal_teacherrequired'] = 'All files you upload here will be personal and visible to you only <strong>after the approval of teachers.</strong> Teachers reserve the right to reject the publication of your files at any time.';
$string['notice_upload_studentnotrequired_teachernotrequired'] = 'All files you upload here will be published (visible to everyone) <strong>automatically.</strong>';
$string['notice_upload_studentnotrequired_teacherrequired'] = 'All files you upload here will be published (visible to all students) only <strong>nach Genehmigung einer/eines Trainer/in.</strong>';
$string['notice_upload_studentrequired_teachernotrequired'] = 'All files you upload here will be visible and accessible only to you. They will only be shared (visible to other students) <strong>after your approval.</strong>';
$string['notice_upload_studentrequired_teacherrequired'] = 'All files you upload here will be visible and accessible only to you, <strong>nach Genehmigung einer/eines Trainer/in</strong>. They will only be shared (visible to other students) <strong>after your approval.</strong>';
$string['notifications'] = 'Benachrichtigungen';
$string['notify:filechange'] = 'Benachrichtigungen über hochgeladene Dateien';
$string['notify:filechange_admin'] = 'Standardeinstellung für Benachrichtigung';
$string['notify:filechange_help'] = 'Wenn diese Option aktiviert ist, erhalten Teilnehmer/innen und/oder Trainer/innen eine Benachrichtigung wenn Teilnehmer/innen in einem Openbook Ressourcenordners eine Datei hochladen oder ändern.';
$string['notify:setting:0'] = 'Keine Benachrichtigungen';
$string['notify:setting:1'] = 'Nur Trainer/innen';
$string['notify:setting:2'] = 'Nur Teilnehmer/innen';
$string['notify:setting:3'] = 'Trainer/innen und Teilnehmer/innen';
$string['notify:statuschange'] = 'Benachrichtigungen über Openbook Ressourcenordner Statusänderungen';
$string['notify:statuschange_admin'] = 'Standardeinstellung für Benachrichtigung bei Änderungen des Status des Openbook Ressourcenordners';
$string['notify:statuschange_help'] = 'Wenn diese Option aktiviert ist, erhalten Teilnehmer/innen und/oder Trainer/innen eine Benachrichtigung wenn der Status einer Datei im Status des Openbook Ressourcenordners geändert wird.';
$string['notifystudents'] = 'Notify students about Openbook resource folder changes';
$string['notifystudents_help'] = 'Wenn diese Option aktiviert ist, students will receive a notification when the Openbook resource folder status of one of their uploaded files changes.';
$string['notifyteacher'] = 'Notify teachers about submitted files';
$string['notifyteacher_help'] = 'Wenn diese Option aktiviert ist, teachers will receive a notification when students upload a file.';
$string['obtainapproval_automatic'] = 'Automatisch';
$string['obtainapproval_required'] = 'Erforderlich';
$string['obtaingroupapproval'] = 'Approval by group';
$string['obtaingroupapproval_admin'] = 'Default group approval setting';
$string['obtaingroupapproval_admin_desc'] = 'Diese Einstellung legt fest, the default approval setting for group members. This setting becomes relevant <strong>only</strong> when the mode is set to "Import files from an assignment activity" and the assignment has group submission.';
$string['obtaingroupapproval_all'] = 'Required from ALL members';
$string['obtaingroupapproval_help'] = 'This option determines how the publication (visibility) of file submissions by groups takes place: <br /><ul><li><strong>Automatic</strong> - no approval from group members is required. In the spirit of copyright law, we ask that you request approval to publish files from students in a separate way.</li><li><strong>Required from at least ONE member</strong> - at least one group member needs to approve</li><li><strong>Required from ALL members</strong> - all group members need to approve</li></ul>';
$string['obtaingroupapproval_single'] = 'Required from at least ONE member';
$string['obtaingroupapproval_title'] = 'Group approval';
$string['obtainstudentapproval'] = 'Freigabe durch Teilnehmer/innen';
$string['obtainstudentapproval_admin'] = 'Standardmäßige Einstellung für die Freigabe durch Teilnehmer/innen';
$string['obtainstudentapproval_admin_desc'] = 'This setting determines the default approval setting for students.';
$string['obtainstudentapproval_help'] = 'This option determines how the Openbook resource folder (visibility) of file submissions by student approval takes place: <br><ul><li><strong>Automatic</strong> - no approval from students is required. In the spirit of copyright law, we ask that you request approval to publish files from students in a separate way.</li><li><strong>Required</strong> - Students need to manually approve the file for Openbook resource folder</li></ul>';
$string['obtainstudentapproval_no'] = 'Automatisch';
$string['obtainstudentapproval_yes'] = 'Erforderlich';
$string['obtainteacherapproval'] = 'Genehmigung durch Trainer/in';
$string['obtainteacherapproval_admin'] = 'Standardmäßige Einstellung für die Freigabe durch Trainer/innen';
$string['obtainteacherapproval_admin_desc'] = 'Diese Einstellung legt die standardmäßige Freigabe durch Trainer/innen fest';
$string['obtainteacherapproval_help'] = 'This option determines how the Openbook resource folder (visibility) of file submissions by teachers approval takes place: <br><ul><li><strong>Automatic</strong> - no approval from teachers is required.</li><li><strong>Required</strong> - Teachers need to manually approve the file for Openbook resource folder</li></ul>';
$string['obtainteacherapproval_no'] = 'Automatisch';
$string['obtainteacherapproval_yes'] = 'Erforderlich';
$string['openbook:addinstance'] = 'Neuen Openbook Ressourcenordner';
$string['openbook:approve'] = 'Decide if files should be published (visible for all participants)';
$string['openbook:grantextension'] = 'Fristverlängerung gewähren';
$string['openbook:manageoverrides'] = 'Manage overrides';
$string['openbook:receiveteachernotification'] = 'Receive notifications for teachers';
$string['openbook:upload'] = 'Dateien in einen Openbook Ressourcenordner hochladen';
$string['openbook:uploadcommonteacherfile'] = 'Upload teacher files that are visible to everybody to a Openbook resource folder';
$string['openbook:view'] = 'Openbook Ressourcenordner anzeigen';
$string['openbookstatus'] = 'Genehigmigungsstatus';
$string['openbookstatus_help'] = 'Der Status dieser Datei repräsentiert die Genehmigung einer/eines Trainer/in: <ul><li><i class="fa fa-check text-success fa-fw"></i><i class="fa fa-share-from-square text-success fa-fw"></i> File is approved, has been shared, and is therefore visible for all participants</li><li><i class="fa fa-check text-success fa-fw"></i><i class="fa fa-user text-success fa-fw"></i> File is approved and is visible for the participant only</li><li><i class="fa fa-times text-danger fa-fw"></i> File is not approved (approval has not yet been given or has been rejected) and therefore not visible</li></ul>';
$string['openpdffilesinpdfjs'] = 'PDF.js aktivieren';
$string['openpdffilesinpdfjs_admin'] = 'PDF-Dateien werden mit dem PDF.js-Viewer angezeigt.';
$string['openpdffilesinpdfjs_admin_desc'] = 'Diese Einstellung legt die Standardeinstellung für die Anzeige von PDF-Dokumenten fest.';
$string['openpdffilesinpdfjs_help'] = 'Diese Einstellung legt fest, ob hochgeladene PDF-Dateien mithilfe der Bibliothek PDF.js angezeigt werden sollen.';
$string['openpdffilesinpdfjs_no'] = 'Nein';
$string['openpdffilesinpdfjs_yes'] = 'Ja';
$string['optionalsettings'] = 'Optionen';
$string['overdue'] = 'Die Frist für das Bearbeiten/das Hochladen ist abgelaufen.';
$string['override:add:group'] = 'Add group override';
$string['override:add:user'] = 'Add user override';
$string['override:approval:from'] = 'Erlaube Freigaben ab {$a->from}';
$string['override:approval:fromto'] = 'Erlaube Freigaben von {$a->from} bis {$a->to}';
$string['override:approval:to'] = 'Erlaube Genehmigungen bis {$a->to}';
$string['override:delete:ask'] = 'Möchten Sie wirklich die Überschreibung für {$a->userorgroup} {$a->fullname} löschen?';
$string['override:delete:success'] = 'Override deleted successfully!';
$string['override:group:choose'] = 'Gruppe wählen';
$string['override:invalidid'] = 'Invalid override ID';
$string['override:nothingtochange'] = 'Es gibt keine Einstellungen, die mit den aktuellen Aktivitätseinstellungen überschrieben werden können!';
$string['override:save:success'] = 'Überschreibung erfolgreich gespeichert';
$string['override:securewindow:from'] = 'Secure window from {$a->from}';
$string['override:securewindow:fromto'] = 'Secure window from {$a->from} until {$a->to}';
$string['override:securewindow:to'] = 'Secure window until {$a->to}';
$string['override:submission:from'] = 'Erlaube Uploads ab {$a->from}';
$string['override:submission:fromto'] = 'Erlaube Uploads von {$a->from} bis {$a->to}';
$string['override:submission:to'] = 'Erlaube Uploads bis {$a->to}';
$string['override:user:choose'] = 'Nutzer/in wählen';
$string['overrides'] = 'Überschreibungen';
$string['overrides:empty'] = 'No overrides';
$string['overview'] = 'Übersicht';
$string['pending'] = 'Ausstehend';
$string['pluginadministration'] = 'Openbook Ressourcenordner administration';
$string['pluginname'] = 'Openbook Ressourcenordner';
$string['privacy:metadata:contenthash'] = 'SHA1 hash of the file\'s content, used to determine if the file changed.';
$string['privacy:metadata:fileid'] = 'Identifier of the file.';
$string['privacy:metadata:filename'] = 'The file\'s name.';
$string['privacy:metadata:files'] = 'Stores information (identifier, whom it belongs, where it came from, hash of content, file name and if approved by teacher and/or student) about the files uploaded/imported into mod_openbook.';
$string['privacy:metadata:openbookperpage'] = 'How many entries should be displayed on a single table page!';
$string['privacy:metadata:studentapproval'] = 'Whether the student has approved or rejected the publication of a file.';
$string['privacy:metadata:teacherapproval'] = 'Whether the teacher has approved or rejected the publication of a file.';
$string['privacy:metadata:timecreated'] = 'The time and date the data record was created.';
$string['privacy:metadata:timemodified'] = 'The most recent time and date the data record got updated/modified.';
$string['privacy:metadata:userid'] = 'Identifier of the user.';
$string['privacy:path:files'] = 'Files';
$string['publicfiles'] = 'Geteilte Dateien';
$string['published_aftercheck'] = 'Genehmigung durch Trainer/in erforderlich';
$string['published_immediately'] = 'Automatisch';
$string['rejected'] = 'Abgelehnt';
$string['rejectusers'] = 'Zurückweisen';
$string['reset'] = 'Rückgängig machen';
$string['reset_userdata'] = 'All data';
$string['resetstudentapproval'] = 'Revert student approval';
$string['save_changes'] = 'Änderungen speichern';
$string['saveapproval'] = 'Änderungen speichern';
$string['savestudentapprovalwarning'] = 'Are you sure you want to save these changes? The publication status cannot be changed once it is set.';
$string['saveteacherapproval'] = 'Änderungen speichern';
$string['search:activity'] = 'Openbook Ressourcenordner - activity information';
$string['securewindowfromdate'] = 'Sicheres Browserfenster ab';
$string['securewindowfromdate_help'] = 'If this option is enabled, the activity will open in a secure window that hides navigation and offers no links to other parts of Moodle. So, for example, only links to the allowed files will be visible during the a quiz attempt. Secure window starts at the given date.';
$string['securewindowsettings'] = 'Einstellungen für sicheres Browserfenster';
$string['securewindowtodate'] = 'Sicheres Browserfenster bis';
$string['securewindowtodate_help'] = 'If this option is enabled, the activity will open in a secure window that hides navigation and offers no links access to other parts of Moodle. So, for example, only links to the allowed files will be visible during the a quiz attempt. Secure window ends at the given date.';
$string['securewindowtodatevalidation'] = 'End date must be after secure window start date.';
$string['show_details'] = 'Details anzeigen';
$string['status'] = 'Status';
$string['status:approved'] = 'Genehmigt';
$string['status:approvedautomatic'] = 'Automatisch';
$string['status:approvednot'] = 'Abgelehnt';
$string['status:approvedrevoke'] = 'Zurückgezogen';
$string['student_approve'] = 'Teilen';
$string['student_approved'] = 'Teilen von der Teilnehmerin / dem Teilnehmer freigegeben.';
$string['student_approved_automatically'] = 'Teilen von der Teilnehmerin / dem Teilnehmer automatisch freigegeben.';
$string['student_pending'] = 'Die Entscheidung der Teilnehmerin / des Teilnehmers steht noch aus.';
$string['student_reject'] = 'Nicht teilen';
$string['student_rejected'] = 'Teilen von der Teilnehmerin / dem Teilnehmer abgelehnt';
$string['studentapproval'] = 'Freigabe (Teilnehmer/innen)';
$string['studentapproval_help'] = 'In the column "Approval (students)" the feedback of the students is displayed:<br><ul><li><i class="fa fa-question fa-fw text-warning"></i> - Decision pending</li><li><i class="fa fa-check text-success fa-fw"></i> - Approval given</li><li><i class="fa fa-times text-danger fa-fw"></i> - Approval rejected</li></ul>';
$string['studentswhosubmitted'] = 'Students who submitted';
$string['submissionsettings'] = 'Submission settings';
$string['teacher_approve'] = 'Genehmigen';
$string['teacher_approved'] = 'Von der/m Trainer/in genehmigt';
$string['teacher_approved_automatically'] = 'Von der/m Trainer/in automatisch genehmigt';
$string['teacher_files'] = 'Dateien von Trainer/innen';
$string['teacher_pending'] = 'Die Entscheidung der/s Trainer/in steht noch aus.';
$string['teacher_reject'] = 'Zurückweisen';
$string['teacher_rejected'] = 'Von der/m Trainer/in zurückgewiesen';
$string['teacherapproval'] = 'Approval';
$string['teacherapproval_help'] = 'Current approval/rejection of files, i.e. whether they are visible to all participants: <br><ul><li><strong>Choose...</strong> - decision pending/no approval given or rejected, these files are not visible.</li><li><strong>Approve</strong> - approval granted, these files are published and therefore visible to all.</li><li><strong>Reject</strong> - no approval given, these files are not published and therefore not visible.</li></ul>';
$string['teacherfiles'] = 'Dateien von Trainer/innen, die für alle sichtbar sind';
$string['total'] = 'Total';
$string['updatefiles'] = 'Update files';
$string['updatefileswarning'] = 'Already imported files will be replaced or deleted if the original files in the assignment were refreshed or deleted. The student\'s settings like the approval for publishing remain as they are.';
$string['uploaded'] = 'Uploaded';
$string['uploadnotopen'] = 'Der Dateiupload ist geschlossen!';
$string['uselegacyviewer'] = 'Legacy PDF.js-Viewer verwenden';
$string['uselegacyviewer_help'] = 'Wenn diese Option aktiviert ist, wird der Legagy PDF.js-Viewer verwendet. Andernfalls wird der moderne PDF.js-Viewer verwendet. Der alte Viewer wird benötigt, wenn alte Browserversionen verwendet werden, die Probleme mit der Anzeige von PDF-Dateien mit dem modernen PDF.js-Viewer haben.';
$string['uselegacyviewer_no'] = 'Nein';
$string['uselegacyviewer_yes'] = 'Ja';
$string['viewallxsubmissions'] = 'View all {$a} submissions';
$string['visibility'] = 'Veröffentlicht';
$string['visible'] = 'Veröffentlicht';
$string['visibleforstudents'] = 'Veröffentlicht';
$string['visibleforstudents_no'] = 'This file is not published (not visible for students).';
$string['visibleforstudents_yes'] = 'This file is published (visible for students).';
$string['withselected'] = 'Mit Auswahl ...';
$string['zipusers'] = 'Ausgewählte Dateiuploads herunterladen';
