<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'competency', language 'ar', version '4.4'.
 *
 * @package     competency
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allchildrenarecomplete'] = 'كل الفروع قد اكتملت';
$string['competencies'] = 'الكفاءات';
$string['competenciesarenotenabled'] = 'الكفاءات معطلة.';
$string['competenciessettings'] = 'إعدادات الكفاءات';
$string['completeplanstask'] = 'إكمال خطط التعلم المستحقة';
$string['coursecompetencyoutcome_complete'] = 'أكمل الكفاءة';
$string['coursecompetencyoutcome_evidence'] = 'إرفق دليلاً';
$string['coursecompetencyoutcome_none'] = 'لا تفعل شيئاً';
$string['coursecompetencyoutcome_recommend'] = 'أرسل للمراجعة';
$string['coursemodulecompetencyoutcome_complete'] = 'أكمل الكفاءة';
$string['coursemodulecompetencyoutcome_evidence'] = 'إرفق دليلاً';
$string['coursemodulecompetencyoutcome_none'] = 'لا تفعل شيئاً';
$string['coursemodulecompetencyoutcome_recommend'] = 'أرسل للمراجعة';
$string['deletecompetencyratings'] = 'حذف تقييمات الكفاءة';
$string['duplicateditemname'] = '{$a} (نسخة)';
$string['enablecompetencies'] = 'تمكين الكفاءات';
$string['enablecompetencies_desc'] = 'الكفاءات تسمح بتقييم المستخدمين وفقاً لخطط التعلم.';
$string['errorcannotchangeapastduedate'] = 'موعد الاستحقاق قد انقضى؛ لا يمكن تغييره حالياً.';
$string['errorcannotsetduedateinthepast'] = 'لا يمكن أن يكون تاريخ الاستحقاق في الماضي.';
$string['errorcannotsetduedatetoosoon'] = 'موعد الاستحقاق قريب جداً.';
$string['errorcompetencyrule'] = 'قاعدة كفاءة المساق \'{$a}\' مجهولة';
$string['errorcoursecompetencyrule'] = 'قاعدة كفاءة المساق \'{$a}\' مجهولة';
$string['errorinvalidcourse'] = 'مساق غير صحيح.';
$string['errornocompetency'] = 'تعذر العثور على كفاءة \'{$a}\'';
$string['errorplanstatus'] = 'حالة خطط التعلم \'{$a}\' غير معلومة';
$string['errorscalealreadyused'] = 'تعذر تغيير المقياس نظراً لكونه قيد الاستعمال حالياً.';
$string['errorscaleconfiguration'] = 'المقياس بحاجة إلى تهيئة عبر اختيار العنصر الافتراضي وعناصر الخبرة.';
$string['errorusercomptencystatus'] = 'حالة كفاءة المستخدم \'{$a}\' غير معروفة';
$string['eventcompetencycreated'] = 'كفاءة تم إنشاؤها';
$string['eventcompetencydeleted'] = 'كفاءة تم حذفها';
$string['eventcompetencyframeworkcreated'] = 'إطار عمل الكفاءة تم إنشاؤه';
$string['eventcompetencyframeworkdeleted'] = 'إطار عمل الكفاءة تم حذفه';
$string['eventcompetencyframeworkupdated'] = 'إطار عمل الكفاءة تم تحديثه';
$string['eventcompetencyframeworkviewed'] = 'إطار عمل الكفاءة تمت معاينته';
$string['eventcompetencyupdated'] = 'كفاءة تم تحديثها';
$string['eventcompetencyviewed'] = 'كفاءة تمت معاينتها';
$string['eventevidencecreated'] = 'دليل تم إنشاؤه';
$string['eventplanapproved'] = 'خطة تعلم تمت الموافقة عليها';
$string['eventplancompleted'] = 'خطة تعلم تم إكمالها';
$string['eventplancreated'] = 'خطة تعلم تم إنشاؤها';
$string['eventplandeleted'] = 'خطة تعلم تم حذفها';
$string['eventplanreopened'] = 'خطة تعلم أُعيد فتحها';
$string['eventplanreviewrequestcancelled'] = 'إلتماس تنقيح خطة تعلم تم إلغاؤه';
$string['eventplanreviewrequested'] = 'تنقيح خطة تعلم تم إلتماسه';
$string['eventplanreviewstarted'] = 'تنقيح خطة تعلم تمت المباشرة به';
$string['eventplanreviewstopped'] = 'تنقيح خطة تعلم تم التوقف عنه';
$string['eventplanunapproved'] = 'خطة تعلم تم رفضها';
$string['eventplanunlinked'] = 'خطة تعلم تم فك ارتباطها';
$string['eventplanupdated'] = 'خطة تعلم تم تحديثها';
$string['eventplanviewed'] = 'خطة تعلم تمت معاينتها';
$string['eventtemplatecreated'] = 'قالب خطة تعلم تم إنشاؤه';
$string['eventtemplatedeleted'] = 'قالب خطة تعلم تم حذفه';
$string['eventtemplateupdated'] = 'قالب خطة تعلم تم تحديثه';
$string['eventtemplateviewed'] = 'قالب خطة تعلم تمت معاينته';
$string['eventusercompetencyplanviewed'] = 'خطة كفاءة مستخدم تمت معاينتها';
$string['eventusercompetencyrated'] = 'كفاءة مستخدم تم تقييمها';
$string['eventusercompetencyratedincourse'] = 'كفاءة مستخدم تم تقييمها في المساق';
$string['eventusercompetencyratedinplan'] = 'كفاءة مستخدم في خطة التعلم تم تقييمها';
$string['eventusercompetencyreviewrequestcancelled'] = 'إلتماس مراجعة كفاءة المستخدم تم إلغاؤه';
$string['eventusercompetencyreviewrequested'] = 'مراجعة كفاءة مستخدم تم إلتماسها';
$string['eventusercompetencyreviewstarted'] = 'مراجعة كفاءة مستخدم تمت المباشرة بها';
$string['eventusercompetencyreviewstopped'] = 'مراجعة كفاءة مستخدم تم التوقف عنها';
$string['eventusercompetencyviewed'] = 'كفاءة مستخدم تمت معاينتها';
$string['eventusercompetencyviewedincourse'] = 'كفاءة مستخدم في مساق تمت معاينتها';
$string['eventusercompetencyviewedinplan'] = 'كفاءة مستخدم في خطة تعلم تمت معاينتها';
$string['eventuserevidencecreated'] = 'دليل على تعلم سابق تم إنشاؤه';
$string['eventuserevidencedeleted'] = 'دليل على تعلم سابق تم حذفه';
$string['eventuserevidenceupdated'] = 'دليل على تعلم السابق تم تحديثه';
$string['evidence_competencyrule'] = 'تمت تلبية قاعدة الكفاءة.';
$string['evidence_coursecompleted'] = 'تم إكمال المساق \'{$a}\'.';
$string['evidence_coursemodulecompleted'] = 'تم إكمال النشاط \'{$a}\'.';
$string['evidence_courserestored'] = 'تمت استعادة التقييم مع المساق \'{$a}\'.';
$string['evidence_evidenceofpriorlearninglinked'] = 'تم ربط الدليل على التعلم السابق \'{$a}\'.';
$string['evidence_evidenceofpriorlearningunlinked'] = 'تم فك ارتباط الدليل على التعلم السابق \'{$a}\'.';
$string['evidence_manualoverride'] = 'تقييم الكفاءة تم وضعه يدوياً.';
$string['evidence_manualoverrideincourse'] = 'تقييم الكفاءة تم وضعه يدوياً للمساق \'{$a}\'.';
$string['evidence_manualoverrideinplan'] = 'تقييم الكفاءة تم وضعه يدوياً لخطة التعلم \'{$a}\'.';
$string['invalidevidencedesc'] = 'وصف الدليل غير صحيح.';
$string['invalidgrade'] = 'تقييم غير صحيح';
$string['invalidplan'] = 'خطة تعلم غير صحيحة';
$string['invalidtaxonomy'] = 'تصنيف غير صحيح: {$a}';
$string['invalidurl'] = 'الرابط غير صحيح. تأكد من أنه يبدأ بـ \'http://\' أو \'https://\'.';
$string['nouserplanswithcompetency'] = 'ليست هناك خطة تعلم تحتوي هذه الكفاءة.';
$string['planstatusactive'] = 'نشطة';
$string['planstatuscomplete'] = 'مكتملة';
$string['planstatusdraft'] = 'مسودة';
$string['planstatusinreview'] = 'قيد التقييم';
$string['planstatuswaitingforreview'] = 'تنتظر المراجعة';
$string['pointsrequiredaremet'] = 'تمت تلبية النقاط المطلوبة';
$string['privacy:evidence:action:complete'] = 'أكمل الكفاءة إن كانت غير مقيَّمة';
$string['privacy:evidence:action:log'] = 'إجراء سجل الوقوعات';
$string['privacy:evidence:action:override'] = 'تجاوز تقييم الكفاءة';
$string['privacy:metadata:competency'] = 'سِجل عن الكفاءات';
$string['privacy:metadata:competency_coursecomp'] = 'سِجل عن الكفاءات المرتبطة بمساق';
$string['privacy:metadata:competency_coursecompsetting'] = 'سِجل عن إعدادات الكفاءة في مساق';
$string['privacy:metadata:competency_evidence'] = 'سِجل عن الدليل المؤثر على حالة الكفاءة';
$string['privacy:metadata:competency_framework'] = 'سِجل عن إطار عمل الكفاءة';
$string['privacy:metadata:competency_modulecomp'] = 'سِجل عن الكفاءات المرتبطة بوحدة';
$string['privacy:metadata:competency_plan'] = 'سِجل عن خطط التعلم';
$string['privacy:metadata:competency_plancomp'] = 'سِجل عن الكفاءات في خطة تعلم';
$string['privacy:metadata:competency_relatedcomp'] = 'سِجل عن العلاقة ما بين الكفاءات';
$string['privacy:metadata:competency_template'] = 'سِجل عن قوالب خطة التعلم';
$string['privacy:metadata:competency_templatecohort'] = 'سِجل عن الدفعات ذات الصلة بمظهر خطة التعلم';
$string['privacy:metadata:competency_templatecomp'] = 'سِجل عن الكفاءات في مظهر خطة التعلم';
$string['privacy:metadata:competency_usercomp'] = 'سِجل عن حالة كفاءات المستخدم';
$string['privacy:metadata:competency_usercompcourse'] = 'سِجل عن حالة كفاءات المستخدم في مساق';
$string['privacy:metadata:competency_usercompplan'] = 'سِجل عن حالة كفاءات المستخدم في خطة تعلم';
$string['privacy:metadata:competency_userevidence'] = 'سِجل عن الدليل على التعلم السابق';
$string['privacy:metadata:competency_userevidencecomp'] = 'سِجل عن الكفاءات ذات الصلة بالدليل على التعلم السابق';
$string['privacy:metadata:core_comments'] = 'التعليقات بشأن خطط التعلم والكفاءات';
$string['privacy:metadata:evidence:action'] = 'نوع الإجراء المتخذ مع الدليل';
$string['privacy:metadata:evidence:actionuserid'] = 'المستخدم المنفذ للإجراء';
$string['privacy:metadata:evidence:desca'] = 'العوامل الاختيارية لوصف الدليل القابل للترجمة';
$string['privacy:metadata:evidence:desccomponent'] = 'مُكون وصف الدليل القابل للترجمة';
$string['privacy:metadata:evidence:descidentifier'] = 'مُعرَّف لوصف الدليل القابل للترجمة';
$string['privacy:metadata:evidence:grade'] = 'الدرجة ذات الصلة بالدليل';
$string['privacy:metadata:evidence:note'] = 'ملاحظة (بغير اللغة المحلية) مرفقة مع الدليل';
$string['privacy:metadata:evidence:url'] = 'رابط ذو صلة بالدليل';
$string['privacy:metadata:plan:description'] = 'وصف خطة التعلم';
$string['privacy:metadata:plan:duedate'] = 'موعد استحقاق خطة التعلم';
$string['privacy:metadata:plan:name'] = 'اسم خطة التعلم';
$string['privacy:metadata:plan:reviewerid'] = 'مُعرَّف من قام بمراجعة خطة التعلم';
$string['privacy:metadata:plan:status'] = 'حالة خطة التعلم';
$string['privacy:metadata:plan:userid'] = 'مُعرَّف المستخدم العائدة إليه خطة التعلم';
$string['privacy:metadata:timecreated'] = 'وقت إنشاء السجل';
$string['privacy:metadata:timemodified'] = 'وقت تعديل السجل';
$string['privacy:metadata:usercomp:grade'] = 'الدرجة المعطاة للكفاءة';
$string['privacy:metadata:usercomp:proficiency'] = 'فيما إذا تحققت الخبرة';
$string['privacy:metadata:usercomp:reviewerid'] = 'مُعرَّف من قام بالمراجعة';
$string['privacy:metadata:usercomp:status'] = 'حالة الكفاءة';
$string['privacy:metadata:usercomp:userid'] = 'مُعرَّف المستخدم العائدة إليه الكفاءة';
$string['privacy:metadata:userevidence:description'] = 'وصف الدليل';
$string['privacy:metadata:userevidence:name'] = 'اسم الدليل على التعلم السابق';
$string['privacy:metadata:userevidence:url'] = 'الرابط ذو الصلة بالدليل';
$string['privacy:metadata:usermodified'] = 'المستخدم الذي أنشأ السجل أو عدله';
$string['privacy:path:plans'] = 'خطط التعلم';
$string['privacy:path:relatedtome'] = 'عائد لي';
$string['privacy:path:userevidence'] = 'الدليل على التعلم السابق';
$string['pushcourseratingstouserplans'] = 'أقحِم تقييمات المساق في خطط التعلم الفردي';
$string['pushcourseratingstouserplans_desc'] = 'القيمة الافتراضية في إعدادات المساق لتحديث خطط التعلم الفردي عند تقييم كفاءات المساق';
$string['syncplanscohorts'] = 'مزامنة الخطط من دفعات مظهر خطة التعلم';
$string['taxonomy_behaviour'] = 'سلوك';
$string['taxonomy_competency'] = 'كفاءة';
$string['taxonomy_concept'] = 'مفهوم';
$string['taxonomy_domain'] = 'المجال';
$string['taxonomy_indicator'] = 'مؤشر';
$string['taxonomy_level'] = 'مستوى';
$string['taxonomy_outcome'] = 'حاصل';
$string['taxonomy_practice'] = 'ممارسة';
$string['taxonomy_proficiency'] = 'خبرة';
$string['taxonomy_skill'] = 'مهارة';
$string['taxonomy_value'] = 'قيمة';
$string['usercommentedonacompetency'] = '{$a->fullname} أعطى تعليقاً عن الكفاءة "{$a->competency}":

{$a->comment}

أنظر: {$a->url}';
$string['usercommentedonacompetencyhtml'] = '<p>{$a->fullname} أعطى تعليقاً عن الكفاءة "{$a->competency}":</p>
<div>{$a->comment}</div>
<p>أنظر: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonacompetencysmall'] = '{$a->fullname} أعطى تعليقاً عن الكفاءة "{$a->competency}".';
$string['usercommentedonacompetencysubject'] = '{$a} أعطى تعليقاً عن كفاءة.';
$string['usercommentedonaplan'] = '{$a->fullname} أعطى تعليقاً عن خطة التعلم "{$a->plan}":

{$a->comment}

أنظر: {$a->url}';
$string['usercommentedonaplanhtml'] = '<p>{$a->fullname} أعطى تعليقاً عن خطة التعلم "{$a->plan}":</p>
<div>{$a->comment}</div>
<p>أنظر: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonaplansmall'] = '{$a->fullname} أعطى تعليقاً عن خطة التعلم "{$a->plan}".';
$string['usercommentedonaplansubject'] = '{$a} أعطى تعليقاً عن خطة تعلم.';
$string['usercompetencystatus_idle'] = 'خاملة';
$string['usercompetencystatus_inreview'] = 'قيد التقييم';
$string['usercompetencystatus_waitingforreview'] = 'بانتظار التقييم';
$string['userplans'] = 'خطط التعلم';
