<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'ro', version '4.4'.
 *
 * @package     forum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actionsforgraderinterface'] = 'Acțiuni pentru interfața utilizatorului care notează';
$string['actionsforpost'] = 'Acțiuni pentru postare';
$string['activitydate:due'] = 'Termen limită:';
$string['activityoverview'] = 'Sunt postări noi în forum';
$string['addanewdiscussion'] = 'Adăugă un nou subiect de discuții';
$string['addanewquestion'] = 'Adaugă o întrebare nouă';
$string['addanewtopic'] = 'Adaugă un nou topic';
$string['addreply'] = 'Adaugă răspuns';
$string['addtofavourites'] = 'Evidențiați această discuție';
$string['advancedsearch'] = 'Căutare avansată';
$string['alldiscussions'] = 'Toate discuțiile';
$string['allforums'] = 'Toate forumurile';
$string['allowdiscussions'] = 'Poate un {$a} să publice la acest subiect';
$string['allowsallsubscribe'] = 'Acest forum permite tuturor să decidă dacă se înscriu sau nu';
$string['allowsdiscussions'] = 'Acest forum permite fiecărui student să publice un singur subiect de discuţie.';
$string['allsubscribe'] = 'Înscriere la toate forumurile';
$string['allunsubscribe'] = 'Anulare subscriere la toate forumurile';
$string['allusers'] = 'Toți utilizatorii';
$string['alreadyfirstpost'] = 'Aceasta este deja prima postare în discuție';
$string['announcementsettings'] = 'Setări implicite ale forumului de anunțuri';
$string['announcementsettings_help'] = 'Aceste setări definesc acțiunile implicite ale tuturor forumurilor de anunțuri.';
$string['anyfile'] = 'Orice fişier';
$string['areaattachment'] = 'Atașamente';
$string['areapost'] = 'Mesaje';
$string['attachment'] = 'Fişier ataşat';
$string['attachment_help'] = 'Aveţi posibilitatea să ataşaţi opţional, unul sau mai multe fişiere la post pe forum. Dacă ataşaţi o imagine, aceasta va fi afişată după mesaj.';
$string['attachmentname'] = 'Atașament {$a}';
$string['attachmentnameandfilesize'] = '{$a->name} ({$a->size})';
$string['attachmentnopost'] = 'Nu puteți exporta atașamente fără un ID de postare';
$string['attachments'] = 'Atașamente';
$string['attachmentswordcount'] = 'Atașamentele și numărul de cuvinte';
$string['authorreplyingprivatelytoauthor'] = '{$a->respondant} răspunzând privat către {$a->author}';
$string['authorreplyingtoauthor'] = '{$a->respondant} răspunzând către {$a->author}';
$string['availability'] = 'Disponibilitate';
$string['blockafter'] = 'Număr maxim de postări permise';
$string['blockafter_help'] = 'Această setare specifică numărul maxim de postări pe care le poate face un student în perioada de timp dată. Utilizatorii cu permisiunea mod/forum:postwithoutthrottling sunt scutiți de aceste limitări.';
$string['blockperiod'] = 'Interval de timp pentru blocare';
$string['blockperiod_help'] = 'Cursanții pot fi blocați de la postare, pentru a nu întrece un număr de postări limită, într-o perioadă de timp anume. Utilizatorii cu permisiunea mod/forum:postwithoutthrottling sunt scutiți de aceste limitări.';
$string['blockperioddisabled'] = 'Nu bloca';
$string['blogforum'] = 'Forum standard afișat într-un format asemănător unui blog';
$string['bynameondate'] = 'de către {$a->name}- {$a->date}';
$string['cachedef_forum_count_discussions'] = 'Numărul de discuții de pe forum';
$string['cachedef_forum_is_tracked'] = 'Starea de urmărire a forumului pentru utilizator';
$string['calendardue'] = '{$a} este scadent';
$string['cancelreply'] = 'Anulează răspunsul';
$string['cannotadd'] = 'Nu se poate adăuga discuția în acest forum';
$string['cannotadddiscussion'] = 'Pentru a putea discuta pe acest forum trebuie să fiţi membru al unui grup.';
$string['cannotadddiscussionall'] = 'Nu aveţi permisiunea de a adăuga o temă de discuţii pentru toţi participanţii.';
$string['cannotadddiscussiongroup'] = 'Nu puteți crea o discuție deoarece nu sunteți membru al niciunui grup.';
$string['cannotaddsubscriber'] = 'Nu s-a putut adăuga un abonat cu Id-ul {$a} la acest forum!';
$string['cannotaddteacherforumto'] = 'Nu s-a putut adăuga instanța forumului profesorului în secțiunea 0 din curs';
$string['cannotcreatediscussion'] = 'Nu se poate crea discuție nouă';
$string['cannotcreateinstanceforteacher'] = 'Nu s-a putut crea o nouă instanță de modul de curs pentru forumul profesorului';
$string['cannotdeletepost'] = 'Nu puteți șterge acest post!';
$string['cannoteditposts'] = 'Nu puteți edita postările altor utilizatori!';
$string['cannotexportforum'] = 'Nu puteți exporta acest forum';
$string['cannotfavourite'] = 'Ne pare rău, dar nu aveți permisiunea de a marca discuțiile.';
$string['cannotfinddiscussion'] = 'Nu s-a putut găsi discuția în acest forum';
$string['cannotfindfirstpost'] = 'Nu am găsit prima postare pe acest forum';
$string['cannotfindorcreateforum'] = 'Nu am putut găsi sau crea un forum principal de anunțuri pentru site';
$string['cannotfindparentpost'] = 'Nu s-a putut găsi părintele principal al postării {$a}';
$string['cannotmovefromsingleforum'] = 'Nu se poate muta discuția dintr-un singur forum de discuții simplu';
$string['cannotmovenotvisible'] = 'Forumul nu este vizibil';
$string['cannotmovetonotexist'] = 'Nu se poate muta în acel forum - forumul nu există!';
$string['cannotmovetonotfound'] = 'Forumul țintă nu a fost găsit în acest curs.';
$string['cannotmovetosingleforum'] = 'Nu se poate muta discuția într-un forum simplu de discuții';
$string['cannotpindiscussions'] = 'Ne pare rău, nu aveți permisiunea de a fixa discuții.';
$string['cannotpurgecachedrss'] = 'Nu s-au putut curăța fluxurile RSS stocate în cache pentru forul (sursele) și / sau destinația - verificați permisiunile de fișiere pentru forumuri';
$string['cannotremovesubscriber'] = 'Nu s-a putut elimina abonatul cu id-ul {$a} din acest forum!';
$string['cannotreply'] = 'Nu puteți să răspundeți la această postare';
$string['cannotsplit'] = 'Discuțiile din acest forum nu pot fi împărțite';
$string['cannotsubscribe'] = 'Ne pare rău, dar trebuie să fii membru al grupului pentru a te abona.';
$string['cannottrack'] = 'Nu am putut opri urmărirea acelui forum';
$string['cannotunsubscribe'] = 'Nu v-am putut dezabona de la acel forum';
$string['cannotupdatepost'] = 'Nu puteți actualiza această postare';
$string['cannotuseseperategroupsandsingletopic'] = 'Setarea Grupuri separate nu poate fi folosită cu tipul de forum O singură discuție.';
$string['cannotusesingletopicandseperategroups'] = 'O singură discuție nu poate fi folosită cu grupuri separate.';
$string['cannotviewpostyet'] = 'Nu poți citi incă comentariile altor cursanți în această discuție pentru că nu ai postări.';
$string['cannotviewusersposts'] = 'Nu există postări făcute de acest utilizator pe care să le puteți vizualiza.';
$string['cleanreadtime'] = 'Marcați postările vechi ca ora citită';
$string['clicktofavourite'] = 'Nu ați marcat ca favorită această discuție. Faceți clic pentru a o marca  favorită.';
$string['clicktolockdiscussion'] = 'Faceți clic pentru a bloca această discuție';
$string['clicktosubscribe'] = 'Nu sunteți abonat la această discuție. Faceți clic pentru a vă abona.';
$string['clicktounfavourite'] = 'Ați marcat ca favorită această discuție. Faceți clic pentru a o scoate din favorite.';
$string['clicktounlockdiscussion'] = 'Faceți clic pentru a debloca această discuție';
$string['clicktounsubscribe'] = 'Sunteți abonat la această discuție. Faceți clic pentru a vă dezabona.';
$string['close'] = 'Închis';
$string['closegrader'] = 'Închide notarea';
$string['completiondetail:discussions'] = 'Începeți {$a} discuții';
$string['completiondetail:posts'] = 'Faceți {$a} postări pe forum';
$string['completiondetail:replies'] = 'Postează {$a} replici';
$string['completiondiscussions'] = 'Începerea discuțiilor';
$string['completiondiscussionsdesc'] = 'Cursantul trebuie să creeze cel puțin {$a} discuții';
$string['completiondiscussionsgroup'] = 'Necesită discuții';
$string['completiondiscussionshelp'] = 'se solicită discuții pentru a finaliza activitatea';
$string['completionposts'] = 'Începe discuția sau postează replici';
$string['completionpostsdesc'] = 'Cursantul trebuie să posteze cel puțin {$a} discuții sau răspuns/ răspunsuri';
$string['completionpostsgroup'] = 'Trebuie să existe postări';
$string['completionpostshelp'] = 'se solicită discuții sau răspunsuri pentru a finaliza activitatea';
$string['completionpostsinforums'] = 'Postare în forumuri';
$string['completionreplies'] = 'Postare replici';
$string['completionrepliesdesc'] = 'Cursantul trebuie să posteze cel puțin {$a} răspuns / răspunsuri';
$string['completionrepliesgroup'] = 'Trebuie să existe răspunsuri';
$string['completionreplieshelp'] = 'se solicită răspunsuri pentru a finaliza activitatea';
$string['configcleanreadtime'] = 'Ora la care se şterg intervenţiile vechi aflate în tabela "citite"';
$string['configdigestmailtime'] = 'Utilizatorii care doresc să primească email-uri în formă prescurtată vor primi aceste mesaje zilnic. Acest parametru stabileşte la ce oră din zi se trimit aceste mesaje (mesajele vor fi trimise de primul script cron care porneşte după ora setată de dumneavoastră).';
$string['configdisplaymode'] = 'Modul implicit de afişare al discuţiilor dacă nu se selectează explicit un mod de afişare';
$string['configenablerssfeeds'] = 'Acest parametru permite activarea posibilităţii ca fluxul RSS să fie afişat în cadrul tuturor forumurilor. Însă pentru ca fluxul RSS să fie afişat în cadrul fluxurilor va trebui să activaţi manual această opţiune pentru fiecare forum.';
$string['configenabletimedposts'] = 'Setați „da” dacă doriți să permiteți setarea perioadelor de afișare atunci când postați o nouă discuție pe forum.';
$string['configlongpost'] = 'Orice postare cu această lungime (în caractere fără HTML) este considerată lungă. Postările afișate pe pagina principală a site-ului, paginile de curs în format social sau profilurile de utilizator sunt scurtate la o pauză naturală undeva între valorile forum_shortpost și forum_longpost.';
$string['configmanydiscussions'] = 'Numărul maxim de intervenţii afişate pe o pagină a forumului';
$string['configmaxattachments'] = 'Numărul maxim de atașamente permise per postare.';
$string['configmaxbytes'] = 'Dimensiunea maximă implicită pentru ataşamentele încărcate pe forumurile din cadrul acestui sit. (poate să difere în funcţie de limitele impuse în cadrul fiecărui curs şi alte setări locale)';
$string['configoldpostdays'] = 'Numărul de zile după care o postare este automat considerată ca fiind citită.';
$string['configreplytouser'] = 'Atunci când o postare pe forum este trimisă participanţilor la forum, se include şi adresa de email a autorului postării (pentru a putea primi răspuns individual de la fiecare participant)? Chiar dacă selectaţi "Da" utilizatorii pot alege din cadrul propriului profil să-şi păstreze secretă adresa de email.';
$string['configrssarticlesdefault'] = 'Dacă fluxurile RSS sunt activate, setează numărul implicit de articole (fie discuții, fie postări).';
$string['configrsstypedefault'] = 'Dacă fluxurile RSS sunt activate, setează tipul implicit de activitate.';
$string['configshortpost'] = 'Orice postare cu dimensiuni mai mici (care conţine mai puţine caractere, exclusiv HTML) ca valoarea completată aici este considerată "postare de dimensiuni reduse" (vezi mai jos)';
$string['configsubscriptiontype'] = 'Setare implicită pentru modul de abonare.';
$string['configtrackingtype'] = 'Setare implicită pentru urmărirea citirii.';
$string['configtrackreadposts'] = 'Selectaţi "Da" pentru acest parametru dacă doriţi să urmăriţi status-ul citit/necitit pentru fiecare utilizator.';
$string['configusermarksread'] = 'Dacă selectaţi "Da" utilizatorul va trebui să marcheze ca "citită" fiecare postare. Dacă alegeţi "Nu", postarea va fi automat marcată ca "citită" la vizualizare.';
$string['confirmsubscribe'] = 'Sunteți sigur(ă) că doriți să vă abonați la forumul \'{$a}\'?';
$string['confirmsubscribediscussion'] = 'Sigur doriți să vă abonați la discuția „{$a->discussion}” din forumul „{$a->forum}”?';
$string['confirmunsubscribe'] = 'Sunteți sigur(ă) că doriți să vă dez-abonați la forumul \'{$a}\'?';
$string['confirmunsubscribediscussion'] = 'Sigur doriți să vă dezabonați de la discuția „{$a->discussion}” din forumul „{$a->forum}”?';
$string['couldnotadd'] = 'Intervenţia ta nu a fost publicată datorită unei erori necunoscute';
$string['couldnotdeletereplies'] = 'Îmi pare rău, ştergerea nu este posibilă deoarece la această intervenţie s-au publicat răspunsuri';
$string['couldnotupdate'] = 'Intervenţia ta nu a putut fi actualizată datorită unei erori necunoscute';
$string['created'] = 'Creat';
$string['crontask'] = 'Lucrări de întreținere trimitere a mesajelor din forum';
$string['cutoffdate'] = 'Postările sunt permise doar până la data de';
$string['cutoffdate_help'] = 'Dacă este setat, forumul nu va accepta postări după această dată.';
$string['cutoffdatereached'] = 'A fost atinsă data limită pentru postarea pe acest forum, astfel încât nu mai puteți posta în acesta.';
$string['cutoffdatevalidation'] = 'Data limită nu poate fi mai devreme decât data scadentă.';
$string['delete'] = 'Şterge';
$string['deleteddiscussion'] = 'Subiectul de discuţie a fost şters';
$string['deletedpost'] = 'Intervenţia a fost ştearsă';
$string['deletedposts'] = 'Acele intervenţii au fost şterse';
$string['deleteduser'] = 'Utilizator șters';
$string['deletesure'] = 'Eşti sigur că vrei să ştergi această intervenţie?';
$string['deletesureplural'] = 'Sunteţi sigur că doriţi să ştergeţi această intervenţie şi toate răspunsurile la aceasta? (în total {$a} intervenţii)';
$string['digestmailheader'] = 'Acesta este rezumatul dvs. zilnic de postări noi din forumurile din {$a->sitename}. Pentru a modifica preferințele implicite de e-mail ale forumului, accesați {$a->userprefs}.';
$string['digestmailpost'] = 'Schimbați preferințele pentru rezumatul forumului';
$string['digestmailpostlink'] = 'Modificați preferințele pentru rezumatul forumului: {$a}';
$string['digestmailprefs'] = 'profilul dumneavoastră de utilizator';
$string['digestmailsubject'] = '{$a}: rezumat postări forum';
$string['digestmailtime'] = 'Ora la care se trimit email-uri cu rezumate';
$string['digestsentusers'] = 'Rezumat postări forum trimis cu succes la {$a} utilizatori.';
$string['disallowsubscribe'] = 'Nu se permit înscrieri';
$string['disallowsubscribeteacher'] = 'Nu se permit înscrieri (cu excepţia profesorilor)';
$string['disallowsubscription'] = 'Abonament';
$string['disallowsubscription_help'] = 'Acest forum a fost configurat astfel încât să nu vă puteți abona la discuții.';
$string['discussion'] = 'Discuție';
$string['discussionlistsortbycreatedasc'] = 'Sortați după data creării în ordine crescătoare';
$string['discussionlistsortbycreateddesc'] = 'Sortați după data creării în ordine descrescătoare';
$string['discussionlistsortbydiscussionasc'] = 'Sortați după denumirea discuției în ordine crescătoare';
$string['discussionlistsortbydiscussiondesc'] = 'Sortați după denumirea discuției în ordine descrescătoare';
$string['discussionlistsortbygroupasc'] = 'Sortați după grup în ordine crescătoare';
$string['discussionlistsortbygroupdesc'] = 'Sortați după grup în ordine descrescătoare';
$string['discussionlistsortbylastpostasc'] = 'Sortați după data creării ultimei postări în ordine crescătoare';
$string['discussionlistsortbylastpostdesc'] = 'Sortați după data creării ultimei postări în ordine descendentă';
$string['discussionlistsortbyrepliesasc'] = 'Sortați după numărul de răspunsuri în ordine crescătoare';
$string['discussionlistsortbyrepliesdesc'] = 'Sortați după numărul de răspunsuri în ordine descrescătoare';
$string['discussionlistsortbystarterasc'] = 'Sortați după numele inițiatorului discuției în ordine crescătoare';
$string['discussionlistsortbystarterdesc'] = 'Sortați după numele inițiatorului discuției în ordine descrescătoare';
$string['discussionlocked'] = 'Această discuție a fost blocată, astfel încât să nu mai puteți răspunde la ea.';
$string['discussionlockingdisabled'] = 'Nu blocați discuțiile';
$string['discussionlockingheader'] = 'Închiderea discuțiilor din forum';
$string['discussionmoved'] = 'Această discuţie a fost mutată în {$a}\'.';
$string['discussionmovedpost'] = 'Această discuţie a fost mutată aici <a href="{$a->discusshref}"></a> în cadrul forumului <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Nume discuţie';
$string['discussionnownotsubscribed'] = '{$a->name} NU va fi notificat despre postările noi din „{$a->discussion}” din „{$a->forum}”';
$string['discussionnowsubscribed'] = 'Vei fi notificat despre noile postări în \'{$a->discussion}\' în forumul \'{$a->forum}\'.';
$string['discussionpin'] = 'Fixează';
$string['discussionpinned'] = 'Fixat';
$string['discussionpinned_help'] = 'Discuțiile fixate vor apărea în partea de sus a unui forum.';
$string['discussions'] = 'Discuţii';
$string['discussionsplit'] = 'Discuția a fost despărțită';
$string['discussionsstartedby'] = 'Discuţie lansată de {$a}';
$string['discussionsstartedbyrecent'] = 'Discuţii lansate recent de {$a}';
$string['discussionsstartedbyuserincourse'] = 'Discuţie lansată de {$a} în {$a->coursename}';
$string['discussionsstartedincourse'] = 'Discuție începută în {$a}';
$string['discussionstartedby'] = 'Discuție începută de {$a}';
$string['discussionsubscribed'] = 'Sunteți abonat la această discuție.';
$string['discussionsubscribestart'] = 'Trimite-mi notificări despre postările noi în această discuție';
$string['discussionsubscribestop'] = 'Nu vreau să fiu informat despre postările noi din această discuție';
$string['discussionsubscription'] = 'Abonament la discuții';
$string['discussionsubscription_help'] = 'Abonarea la o discuție înseamnă că veți primi notificări de postări noi la acea discuție.';
$string['discussionunpin'] = 'Desprinde';
$string['discussionunsubscribed'] = 'Acum sunteți dezabonat de la această discuție.';
$string['discussthistopic'] = 'Discută acest subiect';
$string['discusstopicname'] = 'Discutați subiectul: {$a}';
$string['displayend'] = 'Până la data de';
$string['displayend_help'] = 'Această setare specifică dacă un post pe forum ar trebui să fie ascuns după o dată anume. Reţineţi că administratorii pot vizualiza întotdeauna mesajele postate. ';
$string['displayenddate'] = 'Afișare final: {$a}.';
$string['displaymode'] = 'Afişează mod';
$string['displayperiod'] = 'Afişează perioadă';
$string['displaystart'] = 'Începând cu data de';
$string['displaystart_help'] = 'Această setare specifică dacă un post pe forum ar trebui să fie afişat de la o anumită dată. Reţineţi că administratorii pot vizualiza întotdeauna mesajele postate. ';
$string['displaystartdate'] = 'Afișare început: {$a}.';
$string['displaywordcount'] = 'Afișați numărul de cuvinte';
$string['displaywordcount_help'] = 'Această setare specifică dacă numărul de cuvinte pentru fiecare postare trebuie afișat sau nu.';
$string['duedate'] = 'Postările să fie făcute până la data de';
$string['duedate_help'] = 'Acest lucru se întâmplă atunci când postarea pe forum este închisă. Deși această dată este afișată în calendar ca dată scadentă pentru postări forum, postarea va fi permisă în continuare după această dată. Setați o dată de limită a forumului pentru a împiedica postarea pe forum după o anumită dată.';
$string['duedatetodisplayincalendar'] = 'Data scadentă de afișat în calendar';
$string['eachuserforum'] = 'Fiecare student publică o singură intervenţie';
$string['edit'] = 'Modifică';
$string['editdiscussion'] = 'Editați discuția';
$string['editdiscussiontopic'] = 'Editați subiectul discuției';
$string['editedby'] = 'Modificat de {$a->name} - trimis iniţial de {$a->date}';
$string['editedpostupdated'] = 'Postarea lui {$a} a fost actualizată';
$string['editing'] = 'Modificare';
$string['emaildigestcompleteshort'] = 'Postări complete';
$string['emaildigestdefault'] = 'Implicit ({$a})';
$string['emaildigestoffshort'] = 'Fără rezumat';
$string['emaildigestsubjectsshort'] = 'Doar subiectele';
$string['emaildigesttype'] = 'Opțiuni de rezumat prin e-mail';
$string['emaildigesttype_help'] = 'Tipul de notificare pe care îl veți primi pentru fiecare forum.

* Implicit - urmați setările de rezumat găsite în profilul dvs. de utilizator. Dacă vă actualizați profilul, atunci această modificare va fi reflectată și aici;
* Fără rezumat - veți primi un e-mail pentru fiecare postare pe forum;
* Rezumat - mesaje complete - veți primi un e-mail de rezumat pe zi care conține conținutul complet al fiecărei postări pe forum;
* Rezumat - numai subiecte - veți primi un e-mail de rezumat pe zi care conține doar subiectul fiecărei postări pe forum.';
$string['emptymessage'] = 'Ceva nu era în regulă cu postarea ta. Poate că l-ați lăsat necompletat sau atașamentul a fost prea mare. Modificările dvs. NU au fost salvate.';
$string['errorcannotlock'] = 'Nu aveți permisiunea de a bloca discuțiile.';
$string['errordiscussionnotfound'] = 'Discuția nu a fost găsită';
$string['erroremptymessage'] = 'Mesajul nu poate fi necompletat';
$string['erroremptysubject'] = 'Subiectul nu poate fi necompletat';
$string['errorenrolmentrequired'] = 'Trebuie să fiți înscris la curs pentru a avea acces la conținut';
$string['errorforumnotfound'] = 'Forumul căruia îi aparține această discuție nu a fost găsit';
$string['errorwhiledelete'] = 'A apărut o eroare la ștergerea înregistrării.';
$string['eventassessableuploaded'] = 'A fost postat conținut';
$string['eventcoursesearched'] = 'S-a căutat în curs';
$string['eventdiscussioncreated'] = 'Discuție creată';
$string['eventdiscussiondeleted'] = 'Discuție ștearsă';
$string['eventdiscussionlockupdated'] = 'Blocarea discuției a fost actualizată';
$string['eventdiscussionmoved'] = 'Discuția a fost mutată';
$string['eventdiscussionpinned'] = 'Discuția a fost fixată';
$string['eventdiscussionsubscriptioncreated'] = 'Abonamentul pentru discuții a fost creat';
$string['eventdiscussionsubscriptiondeleted'] = 'Abonamentul la discuție a fost șters';
$string['eventdiscussionunpinned'] = 'Discuția nu a fost fixată';
$string['eventdiscussionupdated'] = 'Discuție actualizată';
$string['eventdiscussionviewed'] = 'Discuție vizualizată';
$string['eventforumsubscriptionupdated'] = 'Modul de subscripție a fost actualizat';
$string['eventpostcreated'] = 'Postare creată';
$string['eventpostdeleted'] = 'Postare ștearsă';
$string['eventpostupdated'] = 'Postare actualizată';
$string['eventreadtrackingdisabled'] = 'Urmărirea citirii este dezactivată';
$string['eventreadtrackingenabled'] = 'Urmărirea citirii este activată';
$string['eventsubscribersviewed'] = 'Abonații vizualizați';
$string['eventsubscriptioncreated'] = 'Abonament a fost creat';
$string['eventsubscriptiondeleted'] = 'Abonamentul a fost șters';
$string['eventuserreportviewed'] = 'Raport utilizator vizualizat';
$string['everyonecanchoose'] = 'Fiecare poate alege să fie înscris';
$string['everyonecannowchoose'] = 'Toţi utilizatorii se pot înscrie';
$string['everyoneisnowsubscribed'] = 'Toţi utilizatorii sunt înscrişi acum la acest forum';
$string['everyoneissubscribed'] = 'Toţi utilizatorii sunt înscrişi la acest forum';
$string['existingsubscribers'] = 'Utilizatori înscrişi';
$string['export'] = 'Export';
$string['exportattachmentname'] = 'Exportați atașamentul {$a} în portofoliu';
$string['exportdiscussion'] = 'Exportați întreaga discuție în portofoliu';
$string['exporthumandates'] = 'Date citite în format uman';
$string['exporthumandates_help'] = 'Dacă datele trebuie exportate într-un format care poate fi citit de om sau ca un timestamp (succesiune de numere).';
$string['exportoptions'] = 'Opțiuni de export';
$string['exportstriphtml'] = 'Eliminați HTML';
$string['exportstriphtml_help'] = 'Dacă etichetele HTML, cum ar fi p și br, trebuie eliminate din mesajul de postare pe forum.';
$string['favourites'] = 'Favorite';
$string['favouriteupdated'] = 'Opțiunea dvs. de favorite a fost actualizată.';
$string['firstpost'] = 'Prima postare';
$string['forcedreadtracking'] = 'Permiteți urmărirea forțată a citirii';
$string['forcedreadtracking_desc'] = 'Permite setarea forumurilor la status urmărire forțată a citirii. Va duce la scăderea performanței pentru unii utilizatori, în special la cursurile cu multe forumuri și postări. Când este dezactivat, orice forum setat anterior la Forțat este tratat ca opțional.';
$string['forcesubscribed'] = 'Pentru a putea participa la acest forum participanţii sunt obligaţi să se înscrie';
$string['forcesubscribed_help'] = 'Acest forum a fost configurat astfel încât să nu vă puteți dezabona de la discuții.';
$string['forum'] = 'Forum';
$string['forum:addinstance'] = 'Adaugă un nou forum';
$string['forum:addnews'] = 'Adăugați anunțuri';
$string['forum:addquestion'] = 'Adaugă întrebare';
$string['forum:allowforcesubscribe'] = 'Permiteți abonarea forțată';
$string['forum:canmailnow'] = 'Poate posta pe forumul Q & A fără întârziere de editare';
$string['forum:canoverridecutoff'] = 'Postare în forumuri după data limită';
$string['forum:canoverridediscussionlock'] = 'Răspuns la discuțiile blocate';
$string['forum:canposttomygroups'] = 'Postați în toate grupurile la care aveți acces';
$string['forum:cantogglefavourite'] = 'Discuții favorite';
$string['forum:createattachment'] = 'Creează ataşamente';
$string['forum:deleteanypost'] = 'Şterge orice intervenţii (realizate oricând)';
$string['forum:deleteownpost'] = 'Şterge propriile intervenţii (până la data limită)';
$string['forum:editanypost'] = 'Modifică orice intervenţie';
$string['forum:exportdiscussion'] = 'Exportați toată discuția';
$string['forum:exportforum'] = 'Export forum';
$string['forum:exportownpost'] = 'Exportați propriul post';
$string['forum:exportpost'] = 'Exportați postul';
$string['forum:grade'] = 'Evaluare forum';
$string['forum:managesubscriptions'] = 'Gestionați abonații';
$string['forum:movediscussions'] = 'Mută discuţii';
$string['forum:pindiscussions'] = 'Fixează discuții';
$string['forum:postprivatereply'] = 'Răspundeți în mod privat la postări';
$string['forum:postwithoutthrottling'] = 'Exclus din pragul de postare';
$string['forum:rate'] = 'Notează discuţii';
$string['forum:readprivatereplies'] = 'Vedeți răspunsurile private';
$string['forum:replynews'] = 'Răspuns la anunțuri';
$string['forum:replypost'] = 'Răspunde la postări';
$string['forum:splitdiscussions'] = 'Separă discuţii';
$string['forum:startdiscussion'] = 'Începe discuţii noi';
$string['forum:viewallratings'] = 'Vedeți toate aprecierile brute acordate de utilizatori';
$string['forum:viewanyrating'] = 'Vedeți aprecierile totale pe care le-au primit toți utilizatorii';
$string['forum:viewdiscussion'] = 'Vizualizează discuţii';
$string['forum:viewhiddentimedposts'] = 'Vizualizează intervenţiile ascunse cu etichetă orară';
$string['forum:viewqandawithoutposting'] = 'Vizualizează întotdeauna intervenţiile de tip Întrebare şi Răspuns';
$string['forum:viewrating'] = 'Vedeți evaluarea totală pe care ați primit-o';
$string['forum:viewsubscribers'] = 'Vizualizează utilizatori înscrişi';
$string['forumauthorhidden'] = 'Autor (ascuns)';
$string['forumblockingalmosttoomanyposts'] = 'Vă apropiaţi de numărul maxim de intervenţii admise. În ultimele {$a->blockperiod} aţi trimis {$a->numposts} intervenţii şi numărul maxim de intervenţii admise este de {$a->blockafter}.';
$string['forumbodydeleted'] = 'Conținutul acestei postări a fost eliminat și nu mai poate fi accesat.';
$string['forumbodyhidden'] = 'Această postare nu poate fi vizualizată de dvs., probabil pentru că nu ați postat în discuție, timpul maxim de editare nu a trecut încă, discuția nu a început sau discuția a expirat.';
$string['forumgrader'] = 'Evaluator de forum';
$string['forumgradingnavigation'] = 'Navigare de evaluare a forumului';
$string['forumgradingpanel'] = 'Panou de evaluare a forumului';
$string['forumintro'] = 'Descriere';
$string['forumname'] = 'Denumire forum';
$string['forumposts'] = 'Intervenţii forum';
$string['forums'] = 'Forumuri';
$string['forumsubjectdeleted'] = 'Această postare pe forum a fost eliminată';
$string['forumsubjecthidden'] = 'Subiect (ascuns)';
$string['forumtracked'] = 'Se urmăresc intervenţiile necitite';
$string['forumtrackednot'] = 'Nu se urmăresc intervenţiile necitite';
$string['forumtype'] = 'Tip forum';
$string['forumtype_help'] = 'Există 5 tipuri de forumuri:

* O singură discuție simplă - Un singur subiect de discuție la care toată lumea poate răspunde (nu poate fi utilizat cu grupuri separate)
* Fiecare persoană postează o discuție - Fiecare cursant poate posta doar un subiect nou de discuții, la care toată lumea poate răspunde
* Forum Q și A - Un cursant trebuie să posteze prima dată un răspuns la o întrebare postată de profesor înainte de a vedea postările altor cursanți
* Forum standard afișat într-un format asemănător unui blog - Un forum deschis în care oricine poate începe o nouă discuție în orice moment și în care subiectele de discuție sunt afișate pe o pagină cu link-uri „Discutați acest subiect”
* Forum standard de uz general - Un forum deschis în care oricine poate începe o nouă discuție în orice moment';
$string['generalforum'] = 'Forum standard pentru uz general';
$string['generalforums'] = 'Forumuri generale';
$string['grade_forum_header'] = 'Notă pentru activitatea din forum';
$string['grade_forum_name'] = 'Întreg forumul';
$string['grade_forum_title'] = 'Evaluează';
$string['grade_rating_name'] = 'Evaluare';
$string['graded'] = 'Evaluat';
$string['gradedby'] = 'Evaluat de';
$string['gradeforrating'] = 'Nota pentru evaluare: {$a->str_long_grade}';
$string['gradeforratinghidden'] = 'Nota pentru evaluarea ascunsă';
$string['gradeforwholeforum'] = 'Nota pentru forum: {$a->str_long_grade}';
$string['gradeforwholeforumhidden'] = 'Nota pentru forum ascunsă';
$string['gradeitem:forum'] = 'Forum';
$string['gradeitemnameforrating'] = 'Apreciere {$a->name}';
$string['gradeitemnameforwholeforum'] = 'Notarea activității {$a->name} pentru întreg forumul';
$string['grades:gradesavedfor'] = 'Nota salvată pentru {$a->fullname}';
$string['grades:gradesavefailed'] = 'Nu se poate salva nota pentru {$a->fullname}: {$a->error}';
$string['gradeusers'] = 'Evaluați participanții';
$string['grading'] = 'Evaluați';
$string['gradingstatus'] = 'Starea evaluării:';
$string['hiddenforumpost'] = 'Postare ascunsă în forum';
$string['hidegraderpanel'] = 'Ascundeți panoul de evaluare';
$string['hidepreviousrepliescount'] = 'Ascundeți răspunsurile anterioare ({$a})';
$string['hideusersearch'] = 'Ascundeți căutarea utilizatorului';
$string['indexoutoftotal'] = '{$a->index} din {$a->total}';
$string['indicator:cognitivedepth'] = 'Informații cognitive despre forum';
$string['indicator:cognitivedepth_help'] = 'Acest indicator se bazează pe profunzimea cognitivă atinsă de cursant într-o activitate a Forumului.';
$string['indicator:cognitivedepthdef'] = 'Informații cognitive despre forum';
$string['indicator:cognitivedepthdef_help'] = 'Participantul a atins acest procent din implicarea cognitivă oferită de activitățile Forumului în timpul acestui interval de analiză (Nivele = Fără vizualizare, Vizualizare, Trimitere, Vizualizare feedback, Comentariu la feedback, Retrimitere după vizualizare feedback)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Informații sociale despre forum';
$string['indicator:socialbreadth_help'] = 'Acest indicator se bazează pe angajamentul social la care a ajuns cursantul într-o activitate a Forumului.';
$string['indicator:socialbreadthdef'] = 'Informații sociale despre forum';
$string['indicator:socialbreadthdef_help'] = 'Participantul a atins acest procent din angajamentul social oferit de activitățile Forumului în timpul acestui interval de analiză (Nivele = Fără participare, Participant singur, Participant cu alții)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['inforum'] = 'în {$a}';
$string['inreplyto'] = 'Ca răspuns la {$a}';
$string['introblog'] = 'Postările din acest forum au fost copiate aici automat de pe blogurile utilizatorilor din acest curs, deoarece acele intrări de blog nu mai sunt disponibile';
$string['intronews'] = 'Anunţuri şi ştiri cu caracter general';
$string['introsocial'] = 'Un forum deschis pentru orice subiect de discuţie';
$string['introteacher'] = 'Un forum doar pentru profesori';
$string['invalidaccess'] = 'Pagina nu a fost accesată corect';
$string['invaliddigestsetting'] = 'A fost furnizată o setare care nu este validă pentru rezumatul mesajelor e-mailului';
$string['invaliddiscussionid'] = 'ID-ul discuției a fost incorect sau nu mai există';
$string['invalidforcesubscribe'] = 'Modul de abonament forțat nu este valid';
$string['invalidforumid'] = 'ID-ul forumului a fost incorect';
$string['invalidparentpostid'] = 'ID-ul postării părinte a fost incorect';
$string['invalidpostid'] = 'ID-ul postării nu este valid - {$a}';
$string['lastpost'] = 'Ultima intervenţie';
$string['learningforums'] = 'Forum pentru învăţare';
$string['lockdiscussion'] = 'Blochează această discuție';
$string['lockdiscussionafter'] = 'Închideți discuțiile din forum după o perioadă de inactivitate';
$string['lockdiscussionafter_help'] = 'Discuțiile pot fi blocate automat după ce a trecut un timp specificat de la ultimul răspuns.

Utilizatorii cu capacitatea de a răspunde la discuțiile blocate pot debloca o discuție răspunzând la aceasta.';
$string['locked'] = 'Blocat';
$string['lockupdated'] = 'Opțiunea de blocare a fost actualizată.';
$string['longpost'] = 'Intervenţie lungă';
$string['mailnow'] = 'Trimiteți notificări de postări pe forum fără întârziere de editare';
$string['managesubscriptionsoff'] = 'Finalizați administrarea abonamentelor';
$string['managesubscriptionson'] = 'Gestionați utilizatorii abonați';
$string['manydiscussions'] = 'Discuţii pe pagină';
$string['markalldread'] = 'Marchează ca "citite" toate intervenţiile din această discuţie.';
$string['markallread'] = 'Marchează ca "citite" toate intervenţiile din cadrul acestui forum.';
$string['markasread'] = 'Marchează citit';
$string['markasreadonnotification'] = 'Când trimiteți notificări de postare pe forum';
$string['markasreadonnotification_help'] = 'Când sunteți informat despre o postare pe forum, puteți alege dacă aceasta ar trebui să marcheze postarea ca citită în scopul urmăririi forumului.';
$string['markasreadonnotificationno'] = 'Nu marcați postarea ca fiind citită';
$string['markasreadonnotificationyes'] = 'Marcați postarea ca fiind citită';
$string['markread'] = 'Marchează ca "citit"';
$string['markreadbutton'] = 'Marchează<br />citit';
$string['markunread'] = 'Marchează ca "necitit"';
$string['markunreadbutton'] = 'Marchează<br />necitit';
$string['maxattachments'] = 'Numărul maxim de atașamente';
$string['maxattachments_help'] = 'Această setare specifică numărul maxim de fişiere care pot fi ataşate la un post pe forum.';
$string['maxattachmentsize'] = 'Dimensiune maximă ataşament';
$string['maxattachmentsize_help'] = 'Această setare specifică dimensiunea maximă a fişierului care poate fi ataşat la un post pe forum.';
$string['maxtimehaspassed'] = 'Îmi pare rău, dar intervalul de timp alocat modificării intervenţiei ({$a}) a expirat!';
$string['message'] = 'Mesaj';
$string['messageinboundattachmentdisallowed'] = 'Imposibil de postat răspunsul dvs., deoarece include un atașament, iar forumul nu permite atașamente.';
$string['messageinboundfilecountexceeded'] = 'Imposibil de postat răspunsul dvs., deoarece include mai mult decât numărul maxim de atașamente permise pentru forum ({$a->forum->maxattachments}).';
$string['messageinboundfilesizeexceeded'] = 'Imposibil de postat răspunsul dvs., deoarece dimensiunea atașamentului total ({$a->filesize}) este mai mare decât dimensiunea maximă permisă pentru forum ({$a->maxbytes}).';
$string['messageinboundforumhidden'] = 'Imposibil de postat răspunsul dvs., deoarece forumul nu este disponibil în prezent.';
$string['messageinboundnopostforum'] = 'Imposibil de postat răspunsul dumneavoastră, deoarece nu aveți permisiunea de a posta în forumul {$a->forum->name}.';
$string['messageinboundthresholdhit'] = 'Imposibil de postat răspunsul dvs. Ați depășit pragul de postare stabilit pentru acest forum';
$string['messageprovider:digests'] = 'Rezumat din forumurile la care sunteți abonat';
$string['messageprovider:posts'] = 'Postări din forumurile la care sunteți abonat';
$string['missingsearchterms'] = 'Următoarele criterii de căutare apar doar în markup-ul HTML al acestui mesaj:';
$string['modeflatnewestfirst'] = 'Arată replicile liniar, mai întâi cele recente';
$string['modeflatoldestfirst'] = 'Arată replicile liniar, mai întâi cele vechi';
$string['modenested'] = 'Arată replicile într-o formă de arbore';
$string['modenestedv2'] = 'Afișați răspunsurile într-o formă experimentală imbricată';
$string['modethreaded'] = 'Arată replicile într-o formă întreţesută';
$string['modulename'] = 'Forum';
$string['modulename_help'] = 'Activitatea de tip forum permite participanților să aibă discuții asincrone, adică discuții care au loc pe o perioadă mai lungă de timp.

Există mai multe tipuri de forumuri, cum ar fi un forum standard în care oricine poate începe o nouă discuție în orice moment; un forum în care fiecare cursant poate posta doar o discuție; sau un forum de întrebări și răspunsuri în care cursanții trebuie să posteze înainte de a putea vizualiza postările altor cursanți. Un profesor poate permite atașarea fișierelor la postările de pe forum. Imaginile atașate sunt afișate în postarea pe forum.

Participanții se pot abona la un forum pentru a primi notificări de noi postări pe forum. Un profesor poate seta modul abonament la opțional, forțat sau automat sau poate preveni complet abonarea cursanților la forum. Dacă este necesar, cursanților li se poate impune să nu posteze mai mult decât un anumit număr de postări într-o anumită perioadă de timp; acest lucru poate împiedica cursanții să domine discuțiile.

Postările de pe forum pot fi evaluate de către profesori sau cursanți. Evaluările pot fi agregate pentru a forma o notă finală care este înregistrată în carnetul de note.

Forumurile au multe utilizări, cum ar fi

* Un spațiu social pentru ca participanții să se cunoască
* Pentru anunțuri de curs (folosind un forum de știri cu abonament forțat)
* Pentru discutarea conținutului cursului sau a materialelor de lectură
* Pentru continuarea online a unei probleme ridicate anterior într-o sesiune față în față
* Pentru discuții numai pentru profesori (folosind un forum ascuns)
* Un centru de ajutor unde tutorii și cursanții pot oferi sfaturi
* O zonă de asistență individuală pentru comunicări private student-profesor (folosind un forum cu grupuri separate și cu un cursant pe grup)
* Pentru activități de extindere, de exemplu „brain teasers” pentru care cursanții să mediteze și să sugereze soluții.';
$string['modulename_link'] = 'mod/forum/view';
$string['modulenameplural'] = 'Forumuri';
$string['more'] = 'mai mult';
$string['movedmarker'] = '(Mutat)';
$string['movethisdiscussionlabel'] = 'Mutați discuția actuală pe forumul specificat';
$string['movethisdiscussionto'] = 'Mută această discuţie în...';
$string['mustprovidediscussionorpost'] = 'Trebuie să furnizați fie un ID de discuție, fie un ID de postare pentru a exporta.';
$string['myprofileotherdis'] = 'Discuții pe forum';
$string['myprofileowndis'] = 'Discuțiile mele pe forum';
$string['myprofileownpost'] = 'Postările mele pe forum';
$string['namenews'] = 'Anunțuri';
$string['namenews_help'] = 'Forumul de anunțuri de curs este un forum special pentru anunțuri și este creat automat atunci când este creat un curs. Un curs poate avea un singur forum de anunțuri. Doar profesorii și administratorii pot posta anunțuri. Blocul „Ultimele anunțuri” va afișa cele mai recente anunțuri.';
$string['namesocial'] = 'Forum social';
$string['nameteacher'] = 'Forum profesori';
$string['newforumposts'] = 'Intervenţii noi';
$string['nextdiscussiona'] = 'Următoarea discuție: {$a}';
$string['nextuser'] = 'Salvați modificările și treceți la următorul utilizator';
$string['noattachments'] = 'Această postare nu are atașamente';
$string['nodiscussions'] = 'Nici o intervenţie nu a fost publicată la acest subiect';
$string['nodiscussionsstartedby'] = '{$a} nu a început nicio discuție';
$string['nodiscussionsstartedbyyou'] = 'Încă nu ați început nicio discuție';
$string['noguestpost'] = 'Doar utilizatorii logați pot să posteze pe acest forum.';
$string['noguestpost:title'] = 'Loghează-te pentru a continua';
$string['noguestsubscribe'] = 'Ne pare rău, oaspeții nu au voie să se aboneze.';
$string['noguesttracking'] = 'Ne pare rău, utilizatorii vizitatori nu au permisiunea de a seta opţiuni de urmărire.';
$string['nomorepostscontaining'] = 'Nu s-au mai găsit alte intervenţii care să conţină {$a}.';
$string['nonews'] = 'Nu au fost încă publicate anunțuri.';
$string['noonecansubscribenow'] = 'Abonamentele sunt acum dezactivate';
$string['nopermissiontosubscribe'] = 'Nu aveți permisiunea de a vizualiza abonații forumului';
$string['nopermissiontoview'] = 'Nu aveți permisiunea să vedeți această postare';
$string['nopostforum'] = 'Ne pare rău, nu aveţi permisiunea să interveniţi în cadrul acestui forum';
$string['noposts'] = 'Nici o intervenţie';
$string['nopostsmadebyuser'] = '{$a} nu are postări';
$string['nopostsmadebyyou'] = 'Încă nu aveți postări';
$string['noquestions'] = 'Nu există încă întrebări în cadrul acestui forum';
$string['nosubscribers'] = 'Nu există încă studenţi înregistraţi pentru acest subiect de discuţie';
$string['notexists'] = 'Discuția nu mai există';
$string['notgraded'] = 'Nu a fost evaluat';
$string['nothingnew'] = 'Nimic nou pentru {$a}';
$string['notingroup'] = 'Ne pare rău, pentru a putea vizualiza acest forum trebuie să fiţi membru al unui grup.';
$string['notinstalled'] = 'Modulul forum nu este instalat';
$string['notlocked'] = 'Blochează';
$string['notpartofdiscussion'] = 'Această postare nu face parte dintr-o discuție!';
$string['notrackforum'] = 'Nu se urmăresc intervenţiile necitite';
$string['notsubscribed'] = 'Abonare';
$string['nousersmatch'] = 'Nu s-au găsit utilizatori pentru criteriile date';
$string['noviewdiscussionspermission'] = 'Nu aveţi permisiunea de a vizualiza discuţiile din cadrul acestui forum.';
$string['nowallsubscribed'] = 'Sunteți abonat acum la toate forumurile din {$a}.';
$string['nowallunsubscribed'] = 'Acum sunteți dezabonat de la toate forumurile din {$a}.';
$string['nowgradinguser'] = 'Acum se notează {$a}';
$string['nownotsubscribed'] = '{$a->name} NU va fi notificat despre postările noi din „{$a->forum}”';
$string['nownottracking'] = '{$a->name} nu mai urmăreşte forumul \'{$a->forum}\'';
$string['nowsubscribed'] = 'Vei fi notificat despre postările noi din forumul „{$a->forum}”.';
$string['nowtracking'] = '{$a->name} urmăreşte în prezent forumul \'{$a->forum}\'.';
$string['numberofreplies'] = 'Număr de răspunsuri: {$a}';
$string['numposts'] = '{$a} intervenţii';
$string['olderdiscussions'] = 'Discuții mai vechi';
$string['oldertopics'] = 'Teme mai vechi';
$string['oldpostdays'] = 'Marchează ca "citit" după număr de zile';
$string['page-mod-forum-discuss'] = 'Pagina subiectului de discuții al forumului';
$string['page-mod-forum-view'] = 'Pagina principală a forumului';
$string['page-mod-forum-x'] = 'Orice pagină de forum';
$string['parent'] = 'Arată părinte';
$string['parentofthispost'] = 'Părintele acestei intervenţii';
$string['permalink'] = 'Permalink';
$string['permanentlinktoparentpost'] = 'Link permanent către părintele acestei postări';
$string['permanentlinktopost'] = 'Link permanent către această postare';
$string['pindiscussion'] = 'Fixați această discuție';
$string['pinupdated'] = 'Opțiunea de fixare a fost actualizată.';
$string['pluginadministration'] = 'Administrare forum';
$string['pluginname'] = 'Forum';
$string['postadded'] = 'Intervenţia ta a fost publicată.<br />Ai la dispoziţie {$a} pentru o eventuală modificare a intervenţiei.';
$string['postaddedsuccess'] = 'Intervenţia dumneavoastră a fost adăugată.';
$string['postaddedtimeleft'] = 'Dacă mai doriţi să mai faceţi modificări, aveţi la dispoziţie .';
$string['postbymailsuccess'] = 'Răspunsul dvs. „{$a->subject}” a fost postat cu succes: {$a->discussionurl}';
$string['postbymailsuccess_html'] = 'Răspunsul dvs. <a href="{$a->discussionurl} "> {$a->subject} </a> a fost postat cu succes.';
$string['postbyuser'] = '{$a->post} de către {$a->user}';
$string['postincontext'] = 'Citeşte această intervenţie în context';
$string['postisprivatereply'] = 'Acesta este un răspuns privat. (Îl pot vedea și profesorii și alți utilizatori cu capacitatea de a vizualiza răspunsurile private.)';
$string['postmailinfo'] = 'Aceasta este o copie a mesajului postat în {$a}.';
$string['postmailnow'] = '<p>Această intervenţie va fi trimisă automat la toţi utilizatorii care s-au înscris la acest forum.</p>';
$string['postmailreply'] = 'Pentru a răspunde dați click pe acest link: {$a}';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['postrating1'] = 'Cunoașterea separată';
$string['postrating2'] = 'Atât separată cât şi legată';
$string['postrating3'] = 'Cunoașterea legată';
$string['posts'] = 'Intervenţii';
$string['postsfrom'] = 'Postări de la';
$string['postsmadebyuser'] = 'Postările lui {$a}';
$string['postsmadebyuserincourse'] = 'Postări făcute de {$a->fullname} în {$a->coursename}';
$string['postsmadeincourse'] = 'Postări făcute în {$a}';
$string['poststo'] = 'Postări până la';
$string['posttoforum'] = 'Trimite intervenția în forum';
$string['posttomygroups'] = 'Postează o copie în toate grupurile';
$string['posttomygroups_help'] = 'Postează o copie a acestui mesaj tuturor grupurilor la care aveți acces. Participanții din grupurile la care nu aveți acces nu vor vedea această postare';
$string['postupdated'] = 'Intervenţia dumneavoastră fost actualizată';
$string['potentialsubscribers'] = 'Utilizatori care ar putea să se înscrie';
$string['prevdiscussiona'] = 'Discuții precedente: {$a}';
$string['previoususer'] = 'Salvați modificările și treceți la utilizatorul anterior';
$string['privacy:digesttypenone'] = 'Nu deținem date referitoare la un tip preferat de rezumat al forumului pentru acest forum.';
$string['privacy:digesttypepreference'] = 'Ați ales să primiți următorul tip de rezumat de forum: „{$a->type}”.';
$string['privacy:discussionsubscriptionpreference'] = 'Ați ales următoarea preferință de abonament pentru discuții în acest forum: „{$a->preferință}”';
$string['privacy:metadata:core_rating'] = 'Forumul folosește subsistemul de evaluare pentru a susține evaluarea postărilor.';
$string['privacy:metadata:core_tag'] = 'Forumul folosește subsistemul de etichete pentru a sprijini etichetarea postărilor.';
$string['privacy:metadata:forum_digests'] = 'Informații despre preferințele de rezumat pentru fiecare forum.';
$string['privacy:metadata:forum_digests:forum'] = 'Forumul abonat.';
$string['privacy:metadata:forum_digests:maildigest'] = 'Preferința de rezumat mesaje.';
$string['privacy:metadata:forum_digests:userid'] = 'ID-ul utilizatorului cu preferința de rezumat.';
$string['privacy:metadata:forum_discussion_subs'] = 'Informații despre abonamentele la discuții individuale de forum';
$string['privacy:metadata:forum_discussion_subs:discussionid'] = 'ID-ul discuției la care a fost abonat.';
$string['privacy:metadata:forum_discussion_subs:preference'] = 'Ora de începere a abonamentului.';
$string['privacy:metadata:forum_discussion_subs:userid'] = 'ID-ul utilizatorului cu abonamentul la discuție.';
$string['privacy:metadata:forum_discussions'] = 'Informații despre discuțiile individuale pe forum create de un utilizator';
$string['privacy:metadata:forum_discussions:assessed'] = 'TODOD - ce stochează acest câmp';
$string['privacy:metadata:forum_discussions:name'] = 'Numele discuției, așa cum a fost ales de autor.';
$string['privacy:metadata:forum_discussions:timemodified'] = 'Ora modificării ultimei discuții.';
$string['privacy:metadata:forum_discussions:userid'] = 'ID-ul utilizatorului care a creat discuția';
$string['privacy:metadata:forum_discussions:usermodified'] = 'ID-ul utilizatorului care a modificat ultima oară discuția.';
$string['privacy:metadata:forum_grades'] = 'Date de evaluare pentru forum';
$string['privacy:metadata:forum_grades:forum'] = 'Forumul care a fost evaluat';
$string['privacy:metadata:forum_grades:grade'] = 'Evaluare acordată';
$string['privacy:metadata:forum_grades:userid'] = 'Utilizatorul care a fost evaluat';
$string['privacy:metadata:forum_posts'] = 'Informații despre preferințele de rezumat pentru fiecare forum.';
$string['privacy:metadata:forum_posts:created'] = 'Ora de creare a postării.';
$string['privacy:metadata:forum_posts:discussion'] = 'Discuția în care se află postarea.';
$string['privacy:metadata:forum_posts:message'] = 'Mesajul postării pe forum.';
$string['privacy:metadata:forum_posts:modified'] = 'Ora modificării ultimei postări.';
$string['privacy:metadata:forum_posts:parent'] = 'Postarea părinte la care a fost răspuns.';
$string['privacy:metadata:forum_posts:privatereplyto'] = 'ID-ul utilizatorului către care a fost trimis acest răspuns.';
$string['privacy:metadata:forum_posts:subject'] = 'Subiectul postării pe forum.';
$string['privacy:metadata:forum_posts:totalscore'] = 'Mesajul postării pe forum.';
$string['privacy:metadata:forum_posts:userid'] = 'ID-ul utilizatorului care a scris postarea pe forum.';
$string['privacy:metadata:forum_queue'] = 'Jurnal temporar al postărilor care vor fi trimise prin poștă sub formă de rezumat';
$string['privacy:metadata:forum_queue:discussionid'] = 'ID-ul discuției forumului';
$string['privacy:metadata:forum_queue:postid'] = 'ID-ul postării pe forum';
$string['privacy:metadata:forum_queue:timemodified'] = 'Ora modificată a postării originale';
$string['privacy:metadata:forum_queue:userid'] = 'Utilizator care trebuie să fie informat despre postare';
$string['privacy:metadata:forum_read'] = 'Informații despre postările care au fost citite de utilizator.';
$string['privacy:metadata:forum_read:discussionid'] = 'Discuția în care se află postarea.';
$string['privacy:metadata:forum_read:firstread'] = 'Prima dată când a fost citită postarea.';
$string['privacy:metadata:forum_read:lastread'] = 'Cea mai recentă dată când a fost citită postarea.';
$string['privacy:metadata:forum_read:postid'] = 'Postarea care a fost citită.';
$string['privacy:metadata:forum_read:userid'] = 'ID-ul utilizatorului la care se referă această înregistrare.';
$string['privacy:metadata:forum_subscriptions'] = 'Informații despre forumurile la care s-a abonat utilizatorul.';
$string['privacy:metadata:forum_subscriptions:forum'] = 'Forumul la care a fost abonat.';
$string['privacy:metadata:forum_subscriptions:userid'] = 'ID-ul utilizatorului la care se referă acest abonament la forum.';
$string['privacy:metadata:forum_track_prefs'] = 'Informații despre forumurile pe care utilizatorul le-a ales să urmărească postările citite.';
$string['privacy:metadata:forum_track_prefs:forumid'] = 'Forumul care are urmărirea citirii mesajelor activată.';
$string['privacy:metadata:forum_track_prefs:userid'] = 'ID-ul utilizatorului la care se referă această preferință de urmărire a forumului.';
$string['privacy:metadata:preference:autosubscribe'] = 'Dacă să vă abonați la discuții atunci când răspundeți la postările din cadrul acestora.';
$string['privacy:metadata:preference:forum_discussionlistsortorder'] = 'Ordinea de sortare preferată a listei de discuții';
$string['privacy:metadata:preference:maildigest'] = 'Preferința de rezumat a e-mailului la nivel de site';
$string['privacy:metadata:preference:markasreadonnotification'] = 'Dacă trebuie să marcați postările de pe forum ca citite atunci când le primiți ca mesaje.';
$string['privacy:metadata:preference:trackforums'] = 'Dacă se activează urmărirea citirii mesajelor.';
$string['privacy:postwasread'] = 'Această postare a fost citită prima dată pe {$a->firstread} și cea mai recentă citită pe {$a->lastread}';
$string['privacy:readtrackingdisabled'] = 'Ați ales să nu urmăriți postările pe care le-ați citit în cadrul acestui forum.';
$string['privacy:request:delete:discussion:name'] = 'Ștergeți la cererea autorului';
$string['privacy:request:delete:post:message'] = 'Conținutul acestei postări a fost șters la cererea autorului său.';
$string['privacy:request:delete:post:subject'] = 'Ștergeți la cererea autorului';
$string['privacy:subscribedtoforum'] = 'Sunteți abonat la acest forum.';
$string['privatereply'] = 'Răspundeți în privat';
$string['privatereply_help'] = 'Când răspunzi în privat, postarea ta va fi vizibilă și pentru utilizatorii care au capabilitatea de a vedea mesaje private, de ex. profesorii.';
$string['processingdigest'] = 'Se procesează rezumatul ce va fi trimis prin email către utilizatorul {$a}';
$string['processingpost'] = 'Procesare intervenţie {$a}';
$string['prune'] = 'Separare';
$string['prunediscussion'] = 'Separați discuția';
$string['prunedpost'] = 'S-a creat o nouă discuţie din acea intervenţie';
$string['pruneheading'] = 'Separă discuţia iniţială şi transferă această întervenţie într-o discuţie nouă';
$string['qandaforum'] = 'Forum Întrebare şi Răspuns';
$string['qandanotify'] = 'Acesta este un forum de întrebări și răspunsuri. Pentru a vedea alte răspunsuri, trebuie mai întâi să postați un răspuns';
$string['re'] = 'Re:';
$string['readtherest'] = 'Citeşte continuarea acestui subiect';
$string['removeallforumtags'] = 'Eliminați toate etichetele forumului';
$string['removefromfavourites'] = 'Scoateți această discuție de la favorite';
$string['replies'] = 'Răspunsuri';
$string['repliesmany'] = '{$a} replici în total';
$string['repliesone'] = '{$a} replică în total';
$string['reply'] = 'Răspunde';
$string['reply_handler'] = 'Răspundeți la mesajele din forum prin e-mail';
$string['reply_handler_name'] = 'Răspundeți la postările de pe forum';
$string['replyauthorself'] = '{$a} (tu)';
$string['replyforum'] = 'Răspunde la forum';
$string['replyingtoauthor'] = 'Răspunzând la {$a} ...';
$string['replyplaceholder'] = 'Scrie răspunsul tău ...';
$string['replypostdiscussion'] = 'Răspunde la discuție';
$string['replytopostbyemail'] = 'Puteți răspunde prin email';
$string['replytouser'] = 'Foloseşte adresa de email în răspuns';
$string['resetdigests'] = 'Ștergeți toate preferințele de rezumat pentru fiecare utilizator pe forum';
$string['resetforums'] = 'Şterge intervenţii din';
$string['resetforumsall'] = 'Şterge toate intervenţiile';
$string['resetsubscriptions'] = 'Şterge toate intervenţiile din forum';
$string['resettrackprefs'] = 'Şterge toate preferinţele de urmărire a forumului';
$string['rssarticles'] = 'Număr de articole RSS recente';
$string['rssarticles_help'] = 'Această setare specifică numărul de articole (fie discuţii sau postări) incluse în flux-ul RSS. Sunt acceptabile, în general, între 5 şi 20. ';
$string['rsssubscriberssdiscussions'] = 'Feed RSS de discuții';
$string['rsssubscriberssposts'] = 'Flux RSS al postărilor';
$string['rsstype'] = 'Flux RSS pentru această activitate';
$string['rsstype_help'] = 'Pentru a activa fluxul RSS pentru această activitate, selectaţi fie discuţii sau postări care urmează să fie incluse în flux.';
$string['rsstypedefault'] = 'Tipul de flux RSS';
$string['search'] = 'Caută în Forum';
$string['search:activity'] = 'Forum - informații despre activitate';
$string['search:post'] = 'Forum - postări';
$string['searchdatefrom'] = 'Intervenţiile trebuie să fie mai recente de';
$string['searchdateto'] = 'Intervenţiile trebuie să fie ulterioare datei';
$string['searchforumintro'] = 'Vă rugăm completaţi criterii de căutare în unul sau mai multe din următoarele câmpuri';
$string['searchforums'] = 'Caută';
$string['searchfullwords'] = 'Aceste cuvinte trebuie să se regăsească întregi în cadrul intervenţiilor';
$string['searchnotwords'] = 'Aceste cuvinte NU trebuie incluse';
$string['searcholderposts'] = 'Caută în intervenţii mai vechi...';
$string['searchphrase'] = 'Caută doar această frază în intervenţii';
$string['searchresults'] = 'Rezultatele căutării';
$string['searchsubject'] = 'Aceste cuvinte trebuie să se regăsească la Subiect';
$string['searchtags'] = 'Este etichetat cu';
$string['searchuser'] = 'Acest nume trebuie să corespundă cu numele autorului';
$string['searchuserid'] = 'ID Moodle al autorului';
$string['searchusers'] = 'Căutați utilizatori';
$string['searchwhichforums'] = 'Selectaţi forumurile în care se va realiza căutarea';
$string['searchwords'] = 'Aceste cuvinte pot să apară oriunde în corpul mesajului';
$string['seeallposts'] = 'Vizualizează toate intervenţiile realizate de acest utilizator';
$string['sendstudentnotificationsdefault'] = 'Notificare cursanți';
$string['sendstudentnotificationsdefault_help'] = 'Setați valoarea implicită pentru caseta de selectare „Notificați cursanții” din formularul de evaluare.';
$string['sendstudentnotificationsno'] = 'Nu';
$string['sendstudentnotificationsyes'] = 'Da, trimiteți o notificare cursantului';
$string['settings'] = 'Setări';
$string['shortpost'] = 'Intervenţie scurtă';
$string['showgraderpanel'] = 'Afișați panoul de evaluare';
$string['showingcountoftotaldiscussions'] = 'Lista discuțiilor. Se afișează {$a->count} din {$a->total} discuții';
$string['showmoreusers'] = 'Afișați mai mulți utilizatori';
$string['showpreviousrepliescount'] = 'Afișați răspunsurile anterioare ({$a})';
$string['showsubscribers'] = 'Arată studenţii înscrişi';
$string['showusersearch'] = 'Afișați căutarea utilizatorului';
$string['singleforum'] = 'O singură intervenţie simplă';
$string['smallmessage'] = '{$a->user} postat în {$a->forumname}';
$string['smallmessagedigest'] = 'Rezumatul forumului conținând {$a} mesaje';
$string['starredonly'] = 'Căutați numai în discuțiile favorite';
$string['startedby'] = 'Iniţiat de';
$string['subject'] = 'Subiect';
$string['subplugintype_forumreport'] = 'Raport forum';
$string['subplugintype_forumreport_plural'] = 'Rapoarte forum';
$string['subscribe'] = 'Abonează-te la acest forum';
$string['subscribeall'] = 'Înscrie toţi utilizatorii la acest forum';
$string['subscribed'] = 'Înscris';
$string['subscribediscussion'] = 'Bifează dacă vrei să primești notificări de la această discuție';
$string['subscribeenrolledonly'] = 'Ne pare rău, numai utilizatorii înscriși au permisiunea de a se abona la notificările postărilor pe forum.';
$string['subscribenone'] = 'Anulează înscrierea tuturor utilizatorilor la acest forum';
$string['subscribers'] = 'Studenţi înscrişi';
$string['subscriberstowithcount'] = 'Abonați la „{$a->name}” ({$a->count})';
$string['subscribestart'] = 'Trimiteți-mi notificări de postări noi în acest forum';
$string['subscribestop'] = 'Nu vreau să fiu anunțat de postările noi pe acest forum';
$string['subscription'] = 'Înscriere';
$string['subscription_help'] = 'Dacă sunteți abonat la un forum înseamnă că veți primi notificări despre noile postări pe forum. De obicei, puteți alege dacă doriți să fiți abonați, deși uneori abonamentul este forțat astfel încât toată lumea să primească notificări.';
$string['subscriptionandtracking'] = 'Abonament și urmărire';
$string['subscriptionauto'] = 'Abonament automat';
$string['subscriptiondisabled'] = 'Abonamentul este dezactivat';
$string['subscriptionforced'] = 'Abonament obligatoriu';
$string['subscriptionmode'] = 'Modalitate de abonare';
$string['subscriptionmode_help'] = 'Atunci când un participant este abonat la un forum înseamnă că va primi notificări de postare pe forum. Există 4 opțiuni pentru modul abonament:

* Abonament opțional - Participanții pot alege dacă vor fi abonați
* Abonament forțat - Toată lumea este abonată și nu se poate dezabona
* Abonament automat - Toată lumea este abonată inițial, dar poate alege să se dezaboneze în orice moment
* Abonament dezactivat - Abonamentele nu sunt permise';
$string['subscriptionmodeconfirm'] = 'Sunteți sigur că doriți să ștergeți modul de subscripție în {$a}?';
$string['subscriptionoptional'] = 'Abonament opțional';
$string['subscriptions'] = 'Înscrieri';
$string['tagarea_forum_posts'] = 'Postări pe forum';
$string['tagsdeleted'] = 'Etichetele forumului au fost șterse';
$string['thisforumhasduedate'] = 'Data limită pentru postarea pe acest forum este {$a}.';
$string['thisforumisdue'] = 'Data limită pentru postarea pe acest forum a fost {$a}.';
$string['thisforumisthrottled'] = 'Acest forum limitează numărul de intervenţii pe care le puteţi realiza într-un interval de timp - în prezent această limitare este de {$a->blockafter} intervenţii în interval de {$a->blockperiod}';
$string['timed'] = 'Contorizat';
$string['timeddiscussion'] = 'Discuție contorizată';
$string['timedhidden'] = 'Stare contorizată: Ascunsă cursanților';
$string['timedposts'] = 'Intervenţii cu etichetă orară';
$string['timedvisible'] = 'Stare contorizată: vizibilă pentru toți utilizatorii';
$string['timestartenderror'] = 'Data de sfârşit nu poate fi anterioară datei de început';
$string['togglediscussionmenu'] = 'Comutați meniul de discuții';
$string['togglefullscreen'] = 'Comutare la ecran complet';
$string['togglesettingsdrawer'] = 'Comutați sertarul de setări';
$string['trackforum'] = 'Urmăreşte intervenţii necitite';
$string['tracking'] = 'Urmărire';
$string['trackingoff'] = 'Dezactivat';
$string['trackingon'] = 'Forţat';
$string['trackingoptional'] = 'Opţional';
$string['trackingtype'] = 'Se urmăreşte citirea intervenţiilor pe acest forum';
$string['trackingtype_help'] = 'Urmărirea citirii le permite participanților să verifice ce postări nu au văzut încă prin evidențierea postărilor noi.

Dacă este setată la opțional, participanții pot alege dacă să activeze sau să dezactiveze urmărirea pentru forum. (Utilizatorii trebuie să activeze și urmărirea forumului în preferințele lor de forum.)

Dacă „Permite urmărirea citirii forțate” este activată de un administrator de site, atunci este disponibilă o altă opțiune - forțată. Aceasta înseamnă că urmărirea este întotdeauna activată, indiferent de preferințele utilizatorilor pe forum.';
$string['trackreadposts_header'] = 'Se urmăreşte citirea intervenţiilor pe acest forum';
$string['unlockdiscussion'] = 'Deblocați această discuție';
$string['unpindiscussion'] = 'Scoateți această discuție de la favorite';
$string['unread'] = 'Necitit';
$string['unreadpost'] = 'Marchează postare ca fiind necitită';
$string['unreadposts'] = 'Intervenţii necitite';
$string['unreadpostsnumber'] = '{$a} intervenţii necitite';
$string['unreadpostsone'] = 'O intervenţie necitită';
$string['unsubscribe'] = 'Dezabonează-te de la acest forum';
$string['unsubscribeall'] = 'Anulează înscrierile la toate forumurile';
$string['unsubscribeallconfirm'] = 'În prezent sunteți abonat la forumurile {$a->forums} și la discuțiile {$a->discussions}. Sigur doriți să vă dezabonați de la toate forumurile și discuțiile și să dezactivați abonamentul automat la discuții?';
$string['unsubscribeallconfirmdiscussions'] = 'În prezent sunteți abonat la discuțiile {$a->discussions}. Sigur doriți să vă dezabonați de la toate discuțiile și să dezactivați abonamentul automat la discuții?';
$string['unsubscribeallconfirmforums'] = 'Sunteți abonat în prezent la forumurile {$a->forums}. Sigur doriți să vă dezabonați de la toate forumurile și să dezactivați abonamentul automat la discuții?';
$string['unsubscribealldone'] = 'Toate abonamentele opționale la forum au fost eliminate. Veți primi în continuare notificări de pe forumuri cu abonament forțat. Pentru a gestiona notificările forumului, accesați Mesaje din Setările profilului meu.';
$string['unsubscribeallempty'] = 'Nu ești abonat la niciun forum. Pentru a dezactiva toate notificările de pe acest server accesează Mesaje din Setările profilului meu.';
$string['unsubscribed'] = 'Înscriere anulată';
$string['unsubscribediscussion'] = 'Bifează dacă vrei să primești notificări din această discuție';
$string['unsubscribediscussionlink'] = 'Dezabonează-te de la această discuție: {$a}';
$string['unsubscribelink'] = 'Dezabonează-te de la acest forum: {$a}';
$string['unsubscribeshort'] = 'Anulează înscriere';
$string['useexperimentalui'] = 'Utilizați vizualizarea experimentală a discuției imbricate';
$string['usermarksread'] = 'Marcarea manuală a mesajelor ca "citit"';
$string['usernavigation'] = 'Navigare utilizator';
$string['usersforumposts'] = 'Postările forumului utilizatorului';
$string['viewalldiscussions'] = 'Vezi toate discuțiile';
$string['viewconversation'] = 'Vezi discuția';
$string['viewgrades'] = 'Vizualizați notele';
$string['viewparentpost'] = 'Vezi postarea părintelui';
$string['viewthediscussion'] = 'Vezi discuția';
$string['warnafter'] = 'După câte postări se va trimite atenționarea';
$string['warnafter_help'] = 'Cursanții pot fi avertizați că aceștia se apropie de numărul maxim de postări permise pentru o anumită perioadă de timp. Această setare specifică după câte postări să se trimită un avertisment către cursanți. Utilizatorii cu permisiunea mod/forum:postwithoutthrottling sunt scutiți de aceste limitări.';
$string['warnformorepost'] = 'Avertizare! Există mai multe discuții în acest forum - folosind cea mai recentă';
$string['yournewquestion'] = 'Noua întrebare';
$string['yournewtopic'] = 'Noua temă de discuţie propusă de dumneavoastră';
$string['yourreply'] = 'Răspunsul dumneavoastră';
