<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'eu', version '4.4'.
 *
 * @package     quiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Galdetegi hau aurreikusi dezakezu, baina benetako saiakera baldin bada blokeatu egingo da arrazoi honegatik:';
$string['action'] = 'Ekintza';
$string['activityoverview'] = 'Egin gabeko galdetegiak dituzu';
$string['adaptive'] = 'Egokitze modua';
$string['adaptive_help'] = 'Gaituz gero, galdetegiaren saiakera berean galdera bakoitzerako erantzun bat baino gehiago onartuko da. Horrela, adibidez, erantzun bat okertzat ematen bada, ikasleak berehala berriro erantzun ahalko du. Dena den, "Ezarri penalizazioak" ezarpenaren arabera, saiakera oker bakoitzari penalizazioa ezarriko zaio.';
$string['add'] = 'Gehitu';
$string['addaquestion'] = 'galdera berria';
$string['addarandomquestion'] = 'ausazko galdera';
$string['addarandomquestion_help'] = 'Ausazko galdera bat gehituz gero, galdetegian hautatutako kategoriatik galdera bat ausaz aukeratuko da. Honek esan nahi du ikasle bakoitzari seguruenik galdera desberdinak agertuko zaizkiola eta, galdetegiak hainbat saiakera baimentzen badu, saiakera bakoitzak seguruenik galdera desberdinak izango dituela.';
$string['addarandomquestion_success'] = 'Ausazko galderak gehitu dira';
$string['addarandomselectedquestion'] = 'Gehitu ausaz aukeratutako galdera...';
$string['addasection'] = 'atal berriaren goiburua';
$string['adddescriptionlabel'] = 'Gehitu deskribapen-elementua';
$string['addingquestion'] = 'Galdera bat gehitzen';
$string['addingquestions'] = '<p>Orriaren alde honetan zure galderen datu-basea kudeatuko duzu. Galderak kategoriaka gordetzen dira antolaketa errazteko eta horrela gainera galdetegi batean baino gehiagotan erabil daitezke edo ikastaro ezberdinetan, \'argitaratu\' aukeratzen baduzu.</p>
<p>Galdera-kategoria bat aukeratu edo sortutakoan galderak sortu edo editatu ahal izango dituzu. Orri honen beste aldean agertzen diren galderetako bat aukera dezakezu zure galdetegira gehitzeko.</p>';
$string['addmoreoverallfeedbacks'] = 'Gehitu feedbacketarako {no} eremu gehiago';
$string['addnewgroupoverride'] = 'Gehitu talde batentzako salbuespena';
$string['addnewpagesafterselected'] = 'Gehitu beste orri batzuk aukeratutako galderen ondoren';
$string['addnewquestionsqbank'] = 'Gehitu galderak kategoria honetara {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Gehitu erabiltzaile batentzako salbuespena';
$string['addpagebreak'] = 'Gehitu orri-jauzia';
$string['addpagehere'] = 'Gehitu orria hemen';
$string['addquestion'] = 'Gehitu galdera';
$string['addquestionfrombankatend'] = 'Gehitu galdera-bankutik amaieran';
$string['addquestionfrombanktopage'] = 'Gehitu galdera-bankutik {$a}. orrira';
$string['addquestions'] = 'Gehitu galderak';
$string['addquestionstoquiz'] = 'Gehitu galderak oraingo galdetegiari';
$string['addrandom'] = 'Gehitu ausazko {$a} galdera';
$string['addrandom1'] = '<< Gehitu';
$string['addrandom2'] = 'ausazko galderak';
$string['addrandomfromcategory'] = 'Gehitu ausazko galderak kategoria honetatik:';
$string['addrandomquestion'] = 'Gehitu ausazko galdera';
$string['addrandomquestionatend'] = 'Gehitu ausazko galdera amaieran';
$string['addrandomquestiontopage'] = 'Gehitu ausazko galdera {$a}. orrian';
$string['addrandomquestiontoquiz'] = 'Gehitu ausazko galdera {$a} galdetegira';
$string['addselectedquestionstoquiz'] = 'Gehitu aukeratutako galderak galdetegian';
$string['addselectedtoquiz'] = 'Gehitu galdetegira aukeratutakoak';
$string['addtoquiz'] = 'Gehitu galdetegira';
$string['affectedstudents'] = '{$a} inplikatu';
$string['aftereachquestion'] = 'Galdera bakoitza gehitu ondoren';
$string['afternquestions'] = '{$a} galdera gehitu ondoren';
$string['age'] = 'adina';
$string['allattempts'] = 'Saiakera guztiak';
$string['allinone'] = 'Mugarik gabe';
$string['allowreview'] = 'Baimendu berrikusketa';
$string['alreadysubmitted'] = 'Saiakera hau dagoeneko bidali duzula ematen du';
$string['alternativeunits'] = 'Ordezko unitateak';
$string['alwaysavailable'] = 'Beti eskuragarri';
$string['alwayslatest'] = 'Beti berriena';
$string['analysisoptions'] = 'Analisirako aukerak';
$string['analysistitle'] = 'Elementuen analisirako taula';
$string['answer'] = 'Erantzuna';
$string['answered'] = 'Erantzuna emanda';
$string['answerhowmany'] = 'Erantzun bakarra edo anizkoitzak?';
$string['answers'] = 'Erantzunak';
$string['answersingleno'] = 'Erantzun bat baino gehiago baimentzen dira';
$string['answersingleyes'] = 'Erantzun bakarra';
$string['answertoolong'] = '{$a} lerrotik aurrera erantzuna luzeegi bihurtu da (gehienez 255 karakt.)';
$string['anytags'] = 'Edozein etiketa';
$string['aon'] = 'AON formatua';
$string['areyousureremoveselected'] = 'Ziur zaude aukeratutako galdera guztiak ezabatu nahi dituzula?';
$string['asshownoneditscreen'] = 'Edizio-pantailan erakusten den bezala';
$string['attempt'] = '{$a}. saiakera';
$string['attemptalreadyclosed'] = 'Saiakera hau dagoeneko amaituta dago.';
$string['attemptclosed'] = 'Saiakera oraindik ez da itxi.';
$string['attemptduration'] = 'Iraupena';
$string['attemptedon'] = 'Saiakera-data';
$string['attempterror'] = 'Ez duzu baimenik galdetegi hau egiten orain saiatzeko. Arrazoia: {$a}';
$string['attempterrorcontentchange'] = 'Galdetegiaren aurreikuspen hau jadanik ez da existitzen. Galdetegi bat editatzen denean, aurreikuspen guztiak automatikoki ezabatzen dira.';
$string['attempterrorcontentchangeforuser'] = 'Galdetegi-saiakera hau jadanik ez da existitzen.';
$string['attempterrorinvalid'] = 'Galdetegi-saiakeraren ID baliogabea';
$string['attemptfirst'] = 'Lehenengo saiakera';
$string['attemptgradeddelay'] = 'Kalifikatutako saiakeraren jakinarazpenen atzerapena';
$string['attemptgradeddelay_desc'] = 'Saiakera kalifikatua izan denaren jakinarazpenari atzerapen bat aplikatzen zaio irakasleari kalifikazioa editatzeko denbora emateko.';
$string['attemptincomplete'] = '{$a}(r)en saiakera oraindik ez da osatu.';
$string['attemptlast'] = 'Azken saiakera';
$string['attemptnumber'] = 'Saiakera';
$string['attemptquiz'] = 'Saiatu galdetegia egiten';
$string['attemptquiznow'] = 'Saiatu orain galdetegia egiten';
$string['attemptreviewtitle'] = '{$a}: Saiakeraren berrikuspena';
$string['attemptreviewtitlepaged'] = '{$a->name}: Saiakeraren berrikuspena ({$a->currentpage}. orria {$a->totalpages}(e)tik)';
$string['attempts'] = 'Saiakerak';
$string['attempts_help'] = 'Onartutako saiakera-kopuru osoa (aparteko saiakerak kontuan hartu gabe).';
$string['attemptsallowed'] = 'Baimendutako saiakerak';
$string['attemptsdeleted'] = 'Galdetegiaren saiakerak ezabatu dira';
$string['attemptselection'] = 'Aukeratu zein saiakera aztertu erabiltzaileko:';
$string['attemptsexist'] = 'Dagoeneko ezin duzu galderarik gehitu edo ezabatu';
$string['attemptsnum'] = 'Saiakerak: {$a}';
$string['attemptsnumthisgroup'] = 'Saiakerak: {$a->total} ({$a->group} talde honetan)';
$string['attemptsnumyourgroups'] = 'Saiakerak: {$a->total} ({$a->group} zure taldeetan)';
$string['attemptsonly'] = 'Erakutsi soilik saiakerak egin dituzten ikasleak';
$string['attemptstate'] = 'Egoera';
$string['attemptstillinprogress'] = 'Saiakera egiten ari da oraindik';
$string['attemptsummarytitle'] = '{$a}: Saiakeraren laburpena';
$string['attemptsunlimited'] = 'Saiakera-kopuru mugagabea';
$string['attempttitle'] = '{$a}';
$string['attempttitlepaged'] = '{$a->name} ({$a->currentpage}. orria {$a->totalpages}(e)tik)';
$string['autosaveperiod'] = 'Automatikoki gordetzeko denbora-tartea';
$string['autosaveperiod_desc'] = 'Saiakera egin den bitartean erantzunak automatikoki gorde daitezke. Erantzunak aldatzen direnean gordetzen dira, eta bestela denbora-tarte hau igarotzean. Aukera honek zeharkako eragin bat dauka: denbora-tarte txiki batek zerbitzariaren karga handitu dezake, baina ikasleen erantzunak galtzeko arriskua txikitzen du. Denbora-tartea asko txikitu nahi baduzu, hobe duzu gutxika jaisten joatea eta bitartean zerbitzariaren karga ikustea. Karga asko igotzen bada, denbora-tartea luzatu ezazu. Denbora-tartean 0 jarriz gero gordetze automatikoa desgaituko da.';
$string['back'] = 'Itzuli aurreko galderara';
$string['backtocourse'] = 'Itzuli ikastarora';
$string['backtoquestionlist'] = 'Itzuli galdera-zerrendara';
$string['backtoquiz'] = 'Itzuli galdetegia editatzera';
$string['bestgrade'] = 'Kalifikaziorik onena';
$string['bothattempts'] = 'Erakutsi saiakerak egin dituzten eta egin ez dituzten ikasleak';
$string['browsersecurity'] = 'Nabigatzailearen segurtasuna';
$string['browsersecurity_help'] = '"JavaScript segurtasuna duen pantaila osoko popup" aukera gaituta badago:

* Galdetegia soilik hasiko da ikaslearen nabigatzaileak JavaScript-a gaituta badauka
* Galdetegia pantaila osoko popup leihoan zabalduko da, eta ez du nabigazio-kontrolik izango
* Ahal den neurrian, ikasleei ez zaie utziko copy paste moduko laguntza tresnarik erabiltzea.';
$string['cachedef_overrides'] = 'Erabiltzaile eta talde-salbuespenen informazioa';
$string['calculated'] = 'Kalkulatutakoa';
$string['calculatedquestion'] = 'Kalkulatutako galdera ezin erabili ondorengo lerroan: {$a}. Galdera ez da kontuan hartuko.';
$string['cannotcreatepath'] = 'Ezin da bidea sortu ({$a})';
$string['cannoteditafterattempts'] = 'Ezin dituzu galderak gehitu edo ezabatu galdetegi honetan dagoeneko saiakerak egin direlako. ({$a})';
$string['cannotfindprevattempt'] = 'Ez da lehenagoko saiakerarik aurkitu saiakera hau horretan oinarritzeko.';
$string['cannotfindquestionregard'] = 'Errorea berriro kalifikatzeko galderak lortzean!';
$string['cannotinsert'] = 'Ezin da galderarik txertatu';
$string['cannotinsertrandomquestion'] = 'Ezin izan da ausazko galdera berririk txertatu!';
$string['cannotloadquestion'] = 'Ezin izan dira kargatu galderaren aukerak';
$string['cannotloadtypeinfo'] = 'Ezin izan da galdera-mota jakin honi buruzko informazioa kargatu';
$string['cannotopen'] = 'Ezin da fitxategia esportatu ({$a})';
$string['cannotremoveallsectionslots'] = '\'{$a}\' atalaren barruko galdera guztiak aukeratu dituzu. Atal bateko galdera guztiak ezabatzea ez dago baimenduta.';
$string['cannotremoveslots'] = 'Ezin dira galderak ezabatu';
$string['cannotrestore'] = 'Ezin izan dira galdera-saioak berreskuratu';
$string['cannotreviewopen'] = 'Ezin duzu saiakera hau berrikusi, oraindik irekita baitago.';
$string['cannotsavelayout'] = 'Ezin izan da nabigazioa gorde';
$string['cannotsavenumberofquestion'] = 'Ezin izan da orriko galdera-kopurua gorde';
$string['cannotsavequestion'] = 'Ezin da galdera-zerrenda gorde';
$string['cannotsetgrade'] = 'Ezin izan da galdetegirako gehieneko kalifikazio berria ezarri.';
$string['cannotsetsumgrades'] = 'Ezin izan da kalifikazioen batura ezarri';
$string['cannotstartgradesmismatch'] = 'Ezin da hasi saiakera galdetegian. Galdetegia gehieneko {$a->grade} punturen gainean ebaluatzeko konfiguratuta dago, baina galdetegiak ez du kalifikazioa duen galderarik. Arazo hau \'Editatu galdetegia\' orrian konpondu daiteke.';
$string['cannotstartmissingquestion'] = 'Ezin da saiakerarik hasi galdetegi honetan. Galdetegiak existitzen ez den galdera bat dauka .';
$string['cannotstartnoquestions'] = 'Ezin da saiakerarik hasi galdetegi honetan. Galdetegia ez da oraindik prestatu; oraindik ez dauka galderarik.';
$string['cannotwrite'] = 'Ezin da esportatutako fitxategia idatzi ({$a})';
$string['canredoquestions'] = 'Baimendu berriz saiatzea saiakera barruan';
$string['canredoquestions_desc'] = 'Gaituz gero, ikasleak galdera bat erantzuten saiatzen amaitu ondoren \'Saiatu honen moduko beste galdera bat erantzuten\' botoi bat ikusiko du. Honek antzeko beste galdera bat (ausaz aukeratutakoa) edo galdera bera berriz erantzuten saiatzea ahalbidetzen du, galdetegia osorik bidali eta beste saiakera bat hasi behar izan gabe. Aukera hau praktikarako galdetegietan da erabilgarria.

Ezarpen honek galdetegiaren saiakera bidali baino lehen amaitu daitezkeen galdera eta portaerei eragiten die soilik (hala nola berehalako feedbacka edo interaktiboa hainbat saiakerarekin).';
$string['canredoquestions_help'] = 'Gaituz gero, ikasleak galdera bat erantzuten saiatzen amaitu ondoren \'Saiatu honen moduko beste galdera bat erantzuten\' botoi bat ikusiko du. Honek antzeko beste galdera bat (ausaz aukeratutakoa) edo galdera bera berriz erantzuten saiatzea ahalbidetzen du, galdetegia osorik bidali eta beste saiakera bat hasi behar izan gabe. Aukera hau praktikarako galdetegietan da erabilgarria.

Ezarpen honek galdetegiaren saiakera bidali baino lehen amaitu daitezkeen galdera eta portaerei eragiten die soilik (hala nola berehalako feedbacka edo interaktiboa hainbat saiakerarekin).';
$string['canredoquestionsyes'] = 'Bai, eman beste galdera bat erantzuten saiatzeko aukera';
$string['caseno'] = 'Ez, letra larriak eta xeheak ez dira bereiziko';
$string['casesensitive'] = 'Letra larriak eta xeheak bereiziz';
$string['caseyes'] = 'Bai, letra larriak eta xeheak bereizi egingo dira';
$string['categoryadded'] = '\'{$a}\' kategoria gehitu da';
$string['categorydeleted'] = '\'{$a}\' kategoria ezabatu da';
$string['categorynoedit'] = 'Ez duzu kategoria hau editatzeko baimenik: \'{$a}\'';
$string['categoryupdated'] = 'Kategoria hau ondo eguneratu da';
$string['close'] = 'Itxi leihoa';
$string['closebeforeopen'] = 'Itxiera-data hasiera-data baino beranduagokoa izan behar da.';
$string['closed'] = 'Itxita';
$string['closepreview'] = 'Itxi aurrebista';
$string['closereview'] = 'Itxi berrikusketa';
$string['comment'] = 'Iruzkina';
$string['commentorgrade'] = 'Egin iruzkina edo aldatu kalifikazioa';
$string['comments'] = 'Iruzkinak';
$string['completedon'] = 'Noiz osatuta';
$string['completionattemptsexhausted'] = 'Gainditzeko kalifikazioa edo saiakera guztiak osatuta';
$string['completionattemptsexhausted_help'] = 'Markatu galdetegia osatu gisa ikasleak gehieneko saiakera kopurua agortzen duenean.';
$string['completiondetail:minattempts'] = 'Saiakerak egitea: {$a}';
$string['completiondetail:passorexhaust'] = 'Gainditzeko kalifikazio bat jasotzea edo baimendutako saiakera guztiak osatzea';
$string['completionminattempts'] = 'Gutxieneko saiakerak';
$string['completionminattemptsdesc'] = 'Beharrezko gutxieneko saiakera-kopurua: {$a}';
$string['completionminattemptserror'] = 'Gutxieneko saiakera kopurua baimendutako saiakeren berdina edo txikiagoa izan behar du.';
$string['completionminattemptsgroup'] = 'Saiakerak egon behar dira';
$string['completionpassorattemptsexhausteddesc'] = 'Ikasleak gainditzeko kalifikazio bat jaso behar du, edo bestela jarduera honetan baimendutako saiakera guztiak agortu behar ditu.';
$string['configadaptive'] = 'Aukera honetan Bai ezarriz gero, ikasleak galdetegiaren saiakera berean galdera bati hainbat aldiz erantzuteko aukera izango du.';
$string['configattemptsallowed'] = 'Ikasleek galdetegian egin dezaketen saiakera-kopuruaren muga';
$string['configdecimaldigits'] = 'Kalifikazioak erakustean azalduko diren hamartar kopurua.';
$string['configdecimalplaces'] = 'Galdetegiaren kalifikazioak erakustean azalduko den hamartar kopurua.';
$string['configdecimalplacesquestion'] = 'Galdera bakoitzaren puntuazioa erakustean azalduko den hamartar kopurua.';
$string['configdelay1'] = 'Denbora-tartea ezartzen baduzu, ikasleak lehenengo saiakera egin ondoren berriz erantzun ahal izateko tarte hori utzi beharko du.';
$string['configdelay1st2nd'] = 'Hemen denbora-tartea ezartzen baduzu, ikasleak ezin izango dio bigarren saiakerari ekin lehenengo saiakera amaitu duenetik denbora-tarte hori iragan arte.';
$string['configdelay2'] = 'Hemen denbora-tartea ezartzen baduzu, ikasleak ezin izango dio hirugarren edo hortik aurrerako saiakerei ekin aurreko saiakera amaitu duenetik denbora-tarte hori iragan arte.';
$string['configdelaylater'] = 'Hemen denbora-tartea ezartzen baduzu, ikasleak ezin izango du hirugarren, laugarren... saiakera hasi aurreko saiakera amaitu duenetik denbora-tarte hori iragan arte.';
$string['configeachattemptbuildsonthelast'] = 'Hainbat saiakera baimentzen bada, saiakera berri bakoitzak aurrekoaren emaitzak izango ditu.';
$string['configgrademethod'] = 'Hainbat saiakera baimentzen bada, zein metodo erabili beharko den galdetegian ikaslearen azken kalifikazioa kalkulatzeko.';
$string['configintro'] = 'Hemen ezartzen dituzun balioek definituko dituzte ezarpenen formularioan erabiliko diren lehenetsitako balioak galdetegi berria sortzen duzunean. Galdetegiaren zein ezarpen hartzen den aurreratutzat ere zehaztu dezakezu.';
$string['configmaximumgrade'] = 'Galdetegiak izango duen lehenetsitako gehieneko kalifikazioa.';
$string['confignavmethod'] = 'Nabigazio librean, galderak edozein ordenatan erantzun daitezke. Sekuentzialean, galderak ordena hertsian erantzun behar dira.';
$string['confignewpageevery'] = 'Galderak galdetegira gehitzeko unean, orri-jauziak hemen aukeratutakoaren arabera sartuko dira.';
$string['configoutcomesadvanced'] = 'Aukera hau gaituta badago, Ikas-emaitzak azalduko dira galdetegiaren edizio-formularioaren ezarpen aurreratuetan.';
$string['configpenaltyscheme'] = 'Egokitze-moduan erantzun okerrei ezarritako penalizazioa.';
$string['configpopup'] = 'Behartu saiakera popup leiho batean irekitzera, eta, galdetegiaren saiakeretan, erabili JavaScript trikimailuak kopiatu, itsatsi eta antzeko ekintzen erabilera murrizteko.';
$string['configrequirepassword'] = 'Ikasleek pasahitz hau idatzi behar dute galdetegiari erantzuten hasi ahal izateko.';
$string['configrequiresubnet'] = 'Ikasleek soilik ordenagailu hauetatik erantzun diezaiokete galdetegiari.';
$string['configreviewoptions'] = 'Aukera hauen bidez erabiltzaileek galdetegiaren berrikuspenean edo galdetegiaren txostenean ikus dezaketen informazioa kontrolatzen da.';
$string['configshowblocks'] = 'Erakutsi blokeak galdetegiari erantzun bitartean';
$string['configshowuserpicture'] = 'Erakutsi erabiltzaileen irudia pantailan galdetegiari erantzun bitartean.';
$string['configshufflewithin'] = 'Aukera hau gaituz gero, ikasleak saiakera bat egiten duen bakoitzean, galderen osagaiak ausaz nahastuko dira; kontuan izan galderaren ezarpenetan ere aukera berdinak gaituta egon behar duela.';
$string['configtimelimit'] = 'Lehenetsitako denbora-muga galdetegietarako minututan. 0 konfiguratuz gero ez da denbora-mugarik egongo.';
$string['configtimelimitsec'] = 'Lehenetsitako denbora-muga galdetegietarako (segundoetan). 0 konfiguratuz gero ez da denbora-mugarik egongo.';
$string['configurerandomquestion'] = 'Konfiguratu galdera';
$string['confirmclose'] = 'Behin zure erantzunak bidalitakoan ezingo duzu aldaketarik egin.';
$string['confirmremovequestion'] = 'Ziur zaude {$a} galdera ezabatu nahi duzula?';
$string['confirmremovesectionheading'] = 'Ziur zaude \'{$a}\' atalaren goiburua ezabatu nahi duzula?';
$string['confirmserverdelete'] = 'Ziur zaude <b>{$a}</b> zerbitzaria zerrendatik kendu nahi duzula?';
$string['connectionerror'] = 'Sarearen konexioa galdu egin da (Gordetze automatikoak huts egin du)

Gorde idatziz azken minutuetan orri honetan egin dituzun erantzunak eta ondoren saiatu berriz konektatzen.

Konexioa berreskuratzen denean, zure erantzunak gorde beharko lirateke eta mezu hau desagertu egingo da.';
$string['connectionok'] = 'Sare-konexioa berreskuratu da. Arazorik gabe jarraitu dezakezu.';
$string['containercategorycreated'] = 'Kategoria hau beherago zehazten diren arrazoiengatik gunera bildu diren jatorrizko kategoria guztiak biltzeko sortu da.';
$string['continueattemptquiz'] = 'Jarraitu zure saiakerarekin';
$string['continuepreview'] = 'Jarraitu azken aurrebistarekin';
$string['copyingfrom'] = '\'{$a}\' galderaren kopia sortzen';
$string['copyingquestion'] = 'Galdera kopiatzen';
$string['correct'] = 'Zuzena';
$string['correctanswer'] = 'Erantzun zuzena';
$string['correctanswerformula'] = 'Erantzun zuzenerako formula';
$string['correctansweris'] = 'Erantzun zuzena: {$a}';
$string['correctanswerlength'] = 'Zifra esanguratsuak';
$string['correctanswers'] = 'Erantzun zuzenak';
$string['correctanswershows'] = 'Erantzun zuzena erakusten du';
$string['corrresp'] = 'Erantzun zuzena';
$string['countdown'] = 'Denbora-muga';
$string['countdownfinished'] = 'Galdetegia ixtear dago, erantzunak lehen bai lehen bidali beharko zenituzke.';
$string['countdowntenminutes'] = 'Galdetegia hamar minutu barru itxiko da.';
$string['coursetestmanager'] = 'Course Test Manager formatua';
$string['createcategoryandaddrandomquestion'] = 'Sortu kategoria eta gehitu ausazko galdera';
$string['createfirst'] = 'Aurrena erantzun laburreko zenbait galderaren bat sortu behar dituzu.';
$string['createmultiple'] = 'Gehitu ausazko galdera batzuk galdetegiari';
$string['createnewquestion'] = 'Sortu galdera berria';
$string['createquestionandadd'] = 'Sortu galdera berria eta gehitu galdetegira.';
$string['custom'] = 'Formatu pertsonalizatua';
$string['dataitemneed'] = 'Gutxienez item-multzo bat gehitu behar duzu baliozko galdera bat izateko';
$string['datasetdefinitions'] = 'Berriz erabiltzeko moduko datu-multzorako definizioak ondorengo kategoriarako: {$a}';
$string['datasetnumber'] = 'Zenbakia';
$string['daysavailable'] = 'Egun eskuragarriak';
$string['decimaldigits'] = 'Hamartar kopurua kalifikazioetan';
$string['decimalplaces'] = 'Hamartar-kopurua kalifikazioetan';
$string['decimalplaces_help'] = 'Ezarpen honek zehazten du kalifikazioak erakustean koma ondoren erakutsiko den digitu-kopurua. Soilik hartuko da kontuan kalifikazioa erakusteko unean, ez ordea kalifikazioa datu-basean gordetzean edo barne kalkuluak egiterakoan. Eragiketa hauek zehaztasunez egingo dira.';
$string['decimalplacesquestion'] = 'Hamartar-kopurua galderen puntuazioetan';
$string['decimalplacesquestion_help'] = 'Galdera bakoitzaren puntuazioak erakustean, komaren ondoren erakutsiko den digitu-kopurua.';
$string['decimalpoints'] = 'Hamartar-kopurua';
$string['default'] = 'Lehenetsia';
$string['defaultgrade'] = 'Galderaren kalifikazio lehenetsia';
$string['defaultinfo'] = 'Galderetarako lehenetsitako kategoria.';
$string['delay1'] = 'Lehen eta bigarren saiakeren arteko denbora-tartea';
$string['delay1st2nd'] = 'Behartutako denbora-tartea 1. eta 2. saiakeren artean.';
$string['delay1st2nd_help'] = 'Gaituz gero, ikasleak zehaztutako denbora-tartea itxaron egin beharko du bigarren saiakera egin ahal izateko.';
$string['delay2'] = 'Ondorengo saiakeren arteko denbora-tartea';
$string['delaylater'] = 'Behartutako denbora-tartea ondorengo saiakeren artean.';
$string['delaylater_help'] = 'Gaituz gero, ikasleak zehaztutako denbora-tartea itxaron egin beharko du hirugarren eta hurrengo saiakerak egin ahal izateko.';
$string['deleteattemptcheck'] = 'Ziur zaude saiakera hauek erabat ezabatu nahi dituzula?';
$string['deleteselected'] = 'Ezabatu aukeratutakoa(k)';
$string['deletingquestionattempts'] = 'Galderaren saiakerak ezabatzen';
$string['description'] = 'Deskribapena';
$string['disabled'] = 'Desgaituta';
$string['displayoptions'] = 'Erakusteko aukerak';
$string['donotuseautosave'] = 'Ez erabili gordetze automatikoa';
$string['download'] = 'Egin klik esportatutako kategoria-fitxategia deskargatzeko';
$string['downloadextra'] = '(fitxategia ikastaroko fitxategien eremuko /backupdata/quiz karpetan ere gordetzen da)';
$string['dragtoafter'] = '{$a}(r)en ondoren';
$string['dragtostart'] = 'Hasierara';
$string['duplicateresponse'] = 'Orain dela gutxi antzeko erantzun bat eman duzu eta, beraz, bidalketa hau ez da kontuan hartuko.';
$string['eachattemptbuildsonthelast'] = 'Saiakera bakoitza azkenengoan oinarritzen da';
$string['eachattemptbuildsonthelast_help'] = 'Hainbat saiakera baimendu eta aukera hau gaitzen bada, saiakera berri bakoitzean aurrekoaren emaitzak agertuko dira. Honek galderari saiakera anitz eginez erantzutea ahalbidetzen du.';
$string['edit_slotdisplaynumber_hint'] = 'Editatu galderaren zenbakia (16 karaktere gehienez)';
$string['edit_slotdisplaynumber_label'] = '{$a}(r)entzako balio berria';
$string['editcategories'] = 'Editatu kategoriak';
$string['editcategory'] = 'Editatu kategoria';
$string['editcatquestions'] = 'Editatu kategoriako galderak';
$string['editingquestion'] = 'Galdera bat editatzen';
$string['editingquiz'] = 'Galdetegia editatzen';
$string['editingquiz_help'] = 'Galdetegi bat sortzean, hauek dira kontuan hartu beharreko oinarrizko kontzeptuak:

* Galdetegia, galderak dituena orri batean edo gehiagotan
* Galdera-bankua, galdera guztien kopiak gordetzen dituena, kategorietan sailkatuta.
* Ausazko galderak: ikasleek galdetegiari erantzuten dioten bakoitzean, ikasle bakoitzari galdera ezberdinak agertu ahal zaizkio';
$string['editingquiz_link'] = 'mod/quiz/edit';
$string['editingquizx'] = 'Galdetegia editatzen: {$a}';
$string['editmaxmark'] = 'Editatu gehieneko puntuazioa';
$string['editoverride'] = 'Editatu salbuespena';
$string['editqcats'] = 'Editatu galdera-kategoriak';
$string['editquestion'] = 'Editatu galdera';
$string['editquestions'] = 'Editatu galderak';
$string['editquiz'] = 'Editatu galdetegia';
$string['editquizquestions'] = 'Editatu galdetegiko galderak';
$string['emailconfirmautosubmitsmall'] = 'Eskerrik asko zure \'{$a->quizname}\' galdetegiaren erantzunak bidaltzeagatik';
$string['emailconfirmbody'] = 'Kaixo, {$a->username}:

Eskerrik asko \'{$a->coursename}\' ikastaroko \'{$a->quizname}\' galdetegiaren erantzunak bidaltzeagatik {$a->submissiontime} denbora-tartean.

Mezu honen bidez zure erantzunak jaso ditugula ziurtatu nahi dizugu.

Ondoko helbidean galdetegia iksui dezakezu {$a->quizurl}.';
$string['emailconfirmbodyautosubmit'] = 'Kaixo {$a->username},

\'{$a->coursename}\' ikastaroko \'{$a->quizname}\' galdetegia erantzuteko denbora amaitu da. Zure erantzunak automatikoki bidali dira {$a->submissiontime}.

Mezu honek zure erantzunak gorde direla baieztatzen du.

Galdetegira hemendik sartu zaitezke: {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Eskerrik asko \'{$a->quizname}\' galdetegiaren erantzunak bidaltzeagatik';
$string['emailconfirmsubject'] = 'Bidalketaren berrespena: {$a->quizname}';
$string['emailmanualgradedbody'] = 'Kaixo {$a->studentname},

\'{$a->coursename}\' ikastaroko \'{$a->quizname}\' galdetegian zuk {$a->attempttimefinish}e(t)an emandako erantzunak kalifikatuak izan dira.

Zure emaitza eta feedbacka ikusi eta zure saiakera berrikusteko \'{$a->quizurl}\' estekan klik egin ezazu.';
$string['emailmanualgradedsubject'] = '{$a->quizname} galdetegiko zure saiakera kalifikatua izan da';
$string['emailnotifybody'] = 'Kaixo, {$a->username}:

{$a->studentname} -k \'{$a->quizname}\' ({$a->quizurl}) galdetegia osatu du \'{$a->coursename}\' ikastaroan.

Saiakera hau hemen berrikusi ahal duzu: {$a->quizreviewurl}';
$string['emailnotifysmall'] = '{$a->studentname}(e)k {$a->quizname} osatu du. Ikusi {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname}(e)k {$a->quizname} osatu du';
$string['emailoverduebody'] = 'Kaixo, {$a->studentname}:

Saiakera bat hasi zenuen \'{$a->coursename}\' ikastaroko \'{$a->quizname}\' galdetegian, baina ez zenuen bidali. Bidalita egon beharko litzateke {$a->attemptduedate}-rako.

Oraindik saiakera hau bidali nahi baduzu, mesedez joan {$a->attemptsummaryurl}-ra eta egin klik bidali botoian. Hau {$a->attemptgraceend} baino lehen egin behar duzu, bestela zure saiakera ez da aintzat hartuko.';
$string['emailoverduesmall'] = 'Ez duzu bidali zure saiakera {$a->quizname} galdetegian. Oraindik bidali nahi baduzu, mesedez, joan {$a->attemptsummaryurl}-ra {$a->attemptgraceend} baino lehen.';
$string['emailoverduesubject'] = 'Epez kanpoko saiakera:  {$a->quizname}';
$string['empty'] = 'Hutsik';
$string['enabled'] = 'Gaituta';
$string['endtest'] = 'Amaitu saiakera...';
$string['erroraccessingreport'] = 'Ez duzu sarbiderik txosten honetara';
$string['errorinquestion'] = 'Errorea galderan';
$string['errormissingquestion'] = 'Errorea: sistemak {$a} id-a duen galdera galdu du';
$string['errornotnumbers'] = 'Errorea: erantzunak zenbakitan eman behar dira';
$string['errorunexpectedevent'] = 'Espero ez zen errore-kodea ({$a->event}) aurkitu da {{$a->attemptid} saiakerako $a->questionid} galderan.';
$string['essay'] = 'Entsegua';
$string['essayquestions'] = 'Galderak';
$string['eventattemptautosaved'] = 'Galdetegi-saiakera automatikoki gorde da';
$string['eventattemptdeleted'] = 'Galdetegiaren saiakera ezabatu da';
$string['eventattemptmanualgradingcomplete'] = 'Galdetegi-saiakerako eskuzko kalifikazioa osatuta';
$string['eventattemptpreviewstarted'] = 'Galdetegiaren saiakeraren aurrebista hasi da';
$string['eventattemptquestionrestarted'] = 'Galdetegi-saiakeraren galdera berrabiarazi da';
$string['eventattemptreviewed'] = 'Galdetegiaren saiakera berrikusi da';
$string['eventattemptsummaryviewed'] = 'Galdetegiaren saiakeren laburpena ikusi da';
$string['eventattemptupdated'] = 'Galdetegi-saiakera eguneratu da';
$string['eventattemptviewed'] = 'Galdetegiaren saiakera ikusi da';
$string['eventeditpageviewed'] = 'Galdetegia editatzeko orria ikusi da';
$string['eventoverridecreated'] = 'Galdetegi-salbuespena sortu da';
$string['eventoverridedeleted'] = 'Galdetegi-salbuespena ezabatu da';
$string['eventoverrideupdated'] = 'Galdetegi-salbuespena eguneratu da';
$string['eventpagebreakcreated'] = 'Orri-jauzia sortu da';
$string['eventpagebreakdeleted'] = 'Orri-jauzia ezabatu da';
$string['eventquestionmanuallygraded'] = 'Galdera eskuz kalifikatu da';
$string['eventquizattemptabandoned'] = 'Galdetegi-saiakera bertan behera utzi da';
$string['eventquizattemptregraded'] = 'Galdetegi-saiakera berriro kalifikatu da';
$string['eventquizattemptreopened'] = 'Galdetegi saiakera berriz irekita';
$string['eventquizattemptstarted'] = 'Galdetegi-saiakera hasi da';
$string['eventquizattemptsubmitted'] = 'Galdetegi-saiakera bidali da';
$string['eventquizattempttimelimitexceeded'] = 'Galdetegiko saiakeraren denbora-muga gainditu egin duzu';
$string['eventquizgradeitemcreated'] = 'Galdetegiko kalifikazio-elementua sortu da';
$string['eventquizgradeitemdeleted'] = 'Galdetegiko kalifikazio-elementua ezabatu da';
$string['eventquizgradeitemorderchanged'] = 'Galdetegiko kalifikazio-elementuaren ordena aldatu da';
$string['eventquizgradeitemupdated'] = 'Galdetegiko kalifikazio-elementua eguneratu da';
$string['eventquizgradeupdated'] = 'Galdetegiaren kalifikazioa eguneratu da';
$string['eventquizrepaginated'] = 'Galdetegia berriz orrikatu da';
$string['eventreportviewed'] = 'Galdetegiaren txostena ikusi da';
$string['eventsectionbreakcreated'] = 'Atal-jauzia sortu da';
$string['eventsectionbreakdeleted'] = 'Atal-jauzia ezabatu da';
$string['eventsectionshuffleupdated'] = 'Ataleko galderen nahasketa eguneratu da';
$string['eventsectiontitleupdated'] = 'Atalaren izenburua eguneratu da';
$string['eventslotcreated'] = 'Galdera-tartea sortu da';
$string['eventslotdeleted'] = 'Galdera-tartea ezabatu da';
$string['eventslotdisplayedquestionnumberupdated'] = 'Galdera-tartea erakutsitako galderaren zenbakia eguneratuta';
$string['eventslotgradeitemupdated'] = 'Galdetegiko kalifikazio-elementuaren galdera-tartea eguneratu da';
$string['eventslotmarkupdated'] = 'Galdera-tartearen kalifikazioa eguneratu da';
$string['eventslotmoved'] = 'Galdera-tartea mugitu da';
$string['eventslotrequirepreviousupdated'] = 'Galdera-tarteak aurretiko behar izatea eguneratu da';
$string['everynquestions'] = '{$a} galderatik behin';
$string['everyquestion'] = 'Galdera bakoitzean';
$string['everythingon'] = 'Guztia hemen';
$string['existingcategory'] = 'Existitzen den kategoria';
$string['exportcategory'] = 'esportatu kategoria';
$string['exporterror'] = 'Errorea gertatu da esportazio-prozesamenduan';
$string['exportingquestions'] = 'Fitxategiko galderak esportatzen ari dira';
$string['exportname'] = 'Fitxategiaren izena';
$string['exportquestions'] = 'Esportatu galderak fitxategi batera';
$string['extraattemptrestrictions'] = 'Murrizketa gehigarriak saiakeretarako';
$string['false'] = 'Gezurra';
$string['feedback'] = 'Feedbacka';
$string['feedbackerrorboundaryformat'] = 'Feedbackaren kalifikazio-muga ehunekoa edo zenbakia izan behar du. {$a} eremuan sartu dea ez da baliozkoa.';
$string['feedbackerrorboundaryoutofrange'] = 'Feedbackaren kalifikazio-mugek %0 eta %100en artean egon behar dute. {$a} eremuan sartu den muga ez dago horien artean.';
$string['feedbackerrorjunkinboundary'] = 'Feedbackaren kalifikazio-mugaren eremuak hutsunerik gabe bete behar dituzu.';
$string['feedbackerrorjunkinfeedback'] = 'Feedbackaren eremuak hutsunerik gabe bete behar dituzu.';
$string['feedbackerrororder'] = 'Feedbackaren kalifikazio-mugek ordenatuta joan behar dute, altuenetik hasita. {$a} eremuan sartutako balioa ez dago ordenean.';
$string['file'] = 'Fitxategia';
$string['fileformat'] = 'Fitxategiaren formatua';
$string['fillcorrect'] = 'Eman erantzun zuzena';
$string['filloutnumericalanswer'] = 'Gutxienez aukerako erantzun bat eta tolerantzia bat eman behar duzu. Lotutako lehen erantzuna puntuazioa ezartzeko eta feedbackerako erabiliko da. Bukaeran erantzunik gabeko feedbacken bat ematen baduzu beste erantzunekin lotu gabeko erantzunak eman dituzten ikasleei erakutsiko zaie.';
$string['filloutoneanswer'] = 'Gutxienez erantzun posible bat bete behar duzu. Hutsik utzitako erantzunak ez dira erabiliko. \'*\' erabiliko da komodin gisa beste edozein karakteretarako. Bat datorren lehen erantzuna erabiliko da puntuazioa eta feedbacka zehazteko.';
$string['filloutthreequestions'] = 'Gutxienez hiru galdera eta dagozkien erantzunak bete behar dituzu. Erantzun oker gehiago sortzeko erantzunaren eremua bete eta galdera hutsik utzi ezazu. Galdera eta erantzuna hutsik duten sarrerak ez dira kontuan hartuko.';
$string['fillouttwochoices'] = 'Gutxienez bi aukera bete behar dituzu. Hutsik utzitako erantzunak ez dira erabiliko.';
$string['finishattemptdots'] = 'Amaitu saiakera...';
$string['finishreview'] = 'Amaitu berrikusketa';
$string['forceregeneration'] = 'Behartu birsorkuntza';
$string['formatnotfound'] = 'Esportazio/inportazio {$a} formatua ez da aurkitzen';
$string['formulaerror'] = 'Erroreak formulan!';
$string['fractionsaddwrong'] = 'Aukeratutako puntuazio positiboen batura ez da % 100<br />Batura %{$a} baino ez da.<br/>Atzera jo eta galdera hau zuzendu nahi duzu?';
$string['fractionsnomax'] = 'Erantzunetako batek %100 izan beharko luke<br/>erantzun honentzako gehieneko kalifikazioa lortzea posible izan dadin.<br/>Atzera bueltatu nahi duzu arazoa konpontzeko?';
$string['fromfile'] = 'fitxategi honetatik:';
$string['functiondisabledbysecuremode'] = 'Funtzionalitate hau une honetan desgaituta dago';
$string['generalfeedback'] = 'Galderaren feedbacka';
$string['generalfeedback_help'] = 'Galderaren feedbacka galderari erantzun ondoren ikasleei erakutsiko zaien testua da. Ikasleak galdera bati emandako erantzunaren araberako feedbackean ez bezala, galderaren feedbackean ikasle guztiei testu bera erakusten zaie.';
$string['gobacktoquiz'] = 'Joan atzera';
$string['graceperiod'] = 'Bidalketaren graziazko epea';
$string['graceperiod_desc'] = 'Epea iraungitzen denean egin beharrekoa \'Denbora agortzean hasitako saiakerak bidaltzeko epe gehigarria...\' aukeran ezarrita badago, hau da emandako aparteko denborarako balio lehenetsia.';
$string['graceperiod_help'] = 'Epea iraungitzen denean egin beharrekoa \'Denbora agortzean hasitako saiakerak bidaltzeko epe gehigarria...\' aukeran ezarrita badago, hau da emandako aparteko denbora.';
$string['graceperiodmin'] = 'Azken bidalketaren graziazko epea';
$string['graceperiodmin_desc'] = 'Arazo bat gerta daiteke galdetegia ixterakoan. Alde batetik, ikasleei utzi nahi diegu lanean azkeneko segundora arte eta kronometro bati esker, galdetegia automatikoki bidaliko da denbora agortzen denean. Beste aldetik, zerbitzarian gainkarga gerta daiteke eta denbora tarte bat beharko du erantzunak prozesatzeko. Beraz, denbora amaitu ondoren, erantzunak onartuko dira segundo-kopuru honetan eta zerbitzaria motela izateak ez dio inori kalte egingo. Dena dela, ikasleek tranpa egin lezakete eta segundo hauetan galdetegia bidali. Erabaki zenbateko tarte gehigarria emango duzun zure zerbitzariak galdetegietan emandako errendimenduaren arabera.';
$string['graceperiodtoosmall'] = 'Graziazko epeak {$a} baino handiagoa izan behar du.';
$string['grade'] = 'Kalifikazioa';
$string['gradeall'] = 'Kalifikatu guztia';
$string['gradeaverage'] = 'Batez besteko kalifikazioa';
$string['gradeboundary'] = 'Kalifikazio-muga';
$string['gradeessays'] = 'Kalifikatu entseguak';
$string['gradehighest'] = 'Kalifikazio altuena';
$string['gradeitemdefaultname'] = 'Galdetegiko kalifikazio-elementu berria {$a}';
$string['gradeitemdelete'] = 'Ezabatu galdetegiko kalifikazio-elementua {$a}';
$string['gradeitemedit'] = 'Editatu galdetegiko kalifikazio-elementuaren izena {$a}';
$string['gradeitemmarkscheme'] = 'Esleitu kalifikazio-elementuak';
$string['gradeitemnewname'] = '{$a} kalifikazio-elementuarentzako izen berria';
$string['gradeitemnoneselected'] = '[bat ere ez]';
$string['gradeitemnoslots'] = 'Galdetegi honek oraindik ez dauka galderarik. Lehenik eta behin galderak gehitu itzazu, eta ondoren hona itzuli zaitez kalifikazio-elementuak konfiguratzeko.';
$string['gradeitems'] = 'Kalifikazio-elementuak';
$string['gradeitemsautosetup'] = 'Konfiguratu atal bakoitzerako kalifikazio bana';
$string['gradeitemsetup'] = 'Kalifikazio-elementuen konfigurazioa';
$string['gradeitemsnoneyet'] = 'Sortu kalifikazio-elementuak zure galdetegiaren barruan. Esleitu galderak edo galdetegi-atalak kalifikazio-elementu hauei galdetegiaren emaitzak arlo ezberdinetan sailkatzeko.';
$string['gradeitemsremoveall'] = 'Berrabiarazi konfigurazioa';
$string['gradeitemsremoveallconfirm'] = 'Berrabiarazi kalifikazio-elementuen konfigurazioa?';
$string['gradeitemsremoveallmessage'] = 'Ekintza honek kalifikazio-elementu guztiak ezabatu eta galderek eta atalek eurekin dituzten loturak kenduko ditu.<br><br>Ekintza honek ez die galderei eta atalei eragingo, ezta galdetegian egindako saiakerei ere.';
$string['gradeitemsremovealltitle'] = 'Berrabiarazi kalifikazio-elementuen konfigurazioa';
$string['grademethod'] = 'Kalifikazio-metodoa';
$string['grademethod_help'] = 'Hainbat saiakera baimentzen bada, ikaslearen amaierako kalifikazioa kalkulatzeko hurrengo kalifikazio-metodoak erabili daitezke:

* Saiakera guztietako kalifikaziorik altuena
* Saiakera guztien batez besteko kalifikazioa
* Lehen saiakeraren kalifikazioa (gainerako saiakera guztiak ez dira kontuan hartzen)
* Azken saiakeraren kalifikazioa (gainerako saiakera guztiak ez dira kontuan hartzen)';
$string['gradesdeleted'] = 'Galdetegiaren kalifikazioak ezabatu dira';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradetopassmustbeset'] = 'Gainditzeko kalifikazioa ezin da 0 izan galdetegi honek gainditzeko baldintza duen osaketa-metodoa erabiltzen duelako. Mesedez 0 ez den balio bat zehaztu ezazu.';
$string['gradetopassoutof'] = 'Gainditzeko kalifikazioa: {$a->grade}/{$a->maxgrade}';
$string['gradingdetails'] = 'Bidalketa honetarako puntuak: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Aurretiko penalizazioak aplikatuta emaitza <strong>{$a->cur}/{$a->max}</strong> da.';
$string['gradingdetailspenalty'] = 'Bidalketa honek {$a}-ko penalizazioa izan du.';
$string['gradingdetailszeropenalty'] = 'Bidalketa honek ez du penalizaziorik izan.';
$string['gradingmethod'] = 'Kalifikazio-metodoa: {$a}';
$string['groupoverrides'] = 'Talde-salbuespenak';
$string['groupoverridesdeleted'] = 'Talde-salbuespenak ezabatu dira';
$string['groupsnone'] = 'Ez dago sarbidea duzun talderik.';
$string['guestsno'] = 'Sentitzen dugu, baina gonbidatuek ezin dute galdetegirik ikusi edo erantzun';
$string['hidebreaks'] = 'Ezkutatu orri-jauziak';
$string['hidereordertool'] = 'Ezkutatu berrantolaketarako tresna';
$string['history'] = 'Erantzunen historia:';
$string['howquestionsbehave_desc'] = 'Galderek galdetegietan duten jokaerarako lehenetsitako ezarpena.';
$string['imagedisplay'] = 'Erakusteko irudia';
$string['import_help'] = 'Funtzionalitate honen bidez kanpoko fitxategien bitartez galderak esporta eta inporta ditzakezu.

Zure fitxategiak ascii ez diren karaktereak baditu, UTF-8 kodifikazioa erabili beharko du. Arreta berezia izan Microsoft Office-ko aplikazioekin sortutako fitxategiei, ondo inportatzen ez diren kodifikazio berezia erabili ohi dutelako.

Inportazio eta esportazio-formatuak pluginen bidez tratatzen dira. Moduluak eta pluginak izeneko datu-basean formatu gehiago egon daitezke.';
$string['import_link'] = 'question/import';
$string['importcategory'] = 'inportatu kategoria';
$string['importerror'] = 'Errorea gertatu da inportatze-prozesamenduan';
$string['importfilearea'] = 'Inportatu ikastaroaren fitxategietan dagoen fitxategi batetik';
$string['importfileupload'] = 'Inportatu igotako fitxategi batetik';
$string['importfromthisfile'] = 'Inportatu fitxategi honetatik';
$string['importingquestions'] = 'Fitxategitik {$a} galdera inportatzen';
$string['importmax10error'] = 'Galderan errore bat dago. Ezin duzu hamar erantzun baino gehiago izan.';
$string['importmaxerror'] = 'Galderan errore bat dago. Erantzun gehiegi dago.';
$string['importquestions'] = 'Inportatu galderak fitxategi batetik';
$string['inactiveoverridehelp'] = '* Salbuespen hau ez-aktibo dago erabiltzailearen jarduerarako sarbidea murriztuta dagoelako. Honen arrazoia taldeko edo rol-esleipena izan daiteke, bestelako eskuragarritasun murrizketak edo jarduera ezkutuan egotea.';
$string['incorrect'] = 'Ez zuzena';
$string['indicator:cognitivedepth'] = 'Gaitasun kognitiboa galdetegietan';
$string['indicator:cognitivedepth_help'] = 'Adierazle hau ikasleak Galdetegia motako jardueretan lortutako sakonera kognitiboan oinarrituta dago.';
$string['indicator:cognitivedepthdef'] = 'Gaitasun kognitiboa galdetegietan';
$string['indicator:cognitivedepthdef_help'] = 'Partaide honek Galdetegia jarduerak eskaintzen duen gaitasun kognitiboaren ehuneko hau lortu du analisi-tarte honetan (Mailak = Ikusi gabe, Ikusi da, Bidali da, Feedbacka ikusi da, Feedbackari iruzkina egin da, Feedback ikusi ondoren berriz bidali da)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Gaitasun soziala galdetegietan';
$string['indicator:socialbreadth_help'] = 'Helburu hau ikasleak Galdetegia motako jardueretan lortutako zabalera sozialean oinarrituta dago.';
$string['indicator:socialbreadthdef'] = 'Gaitasun soziala galdetegietan';
$string['indicator:socialbreadthdef_help'] = 'Partaide honek Galdetegia jarduerak eskaintzen duen gaitasun sozialaren ehuneko hau lortu du analisi-tarte honetan';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indivresp'] = 'Elementu bakoitzari norberak emandako erantzunak';
$string['info'] = 'Informazioa';
$string['infoshort'] = 'i';
$string['initialnumfeedbacks'] = 'Feedbackerako hasierako eremu-kopurua';
$string['initialnumfeedbacks_desc'] = 'Galdetegi berri bat sortzean feedbackerako eremu huts kopuru hau emango da. Behin galdetegia sortu denean, formularioak galdetegiko feedback kopururako behar diren eremu-kopurua erakutsiko du. Ezarpen honen balio minimoa 1 da.';
$string['inprogress'] = 'Abian';
$string['introduction'] = 'Deskribapena';
$string['invalidattemptid'] = 'Saiakera ID hori ez da existitzen';
$string['invalidcategory'] = 'Kategoriaren IDa baliogabea da';
$string['invalidoverrideid'] = 'Salbuespen ID baliogabea.';
$string['invalidquestionid'] = 'Galderaren ID baliogabea';
$string['invalidquizid'] = 'Galdetegiaren ID baliogabea';
$string['invalidrandomslot'] = 'Ausazko galdera-tartearen ID baliogabea.';
$string['invalidsource'] = 'Jatorria ez da onargarria';
$string['invalidsourcetype'] = 'Jatorri mota ez onargarria';
$string['invalidstateid'] = 'Egoeraren ID baliogabea';
$string['lastanswer'] = 'Zure azken erantzuna izan zen';
$string['lastautosave'] = 'Gordetako azkena: {$a}';
$string['layout'] = 'Nabigazioa';
$string['layoutasshown'] = 'Orri-nabigazioa erakusten den bezala.';
$string['layoutasshownwithpages'] = 'Orri-nabigazioa erakusten den bezala. <small>(Automatikoki orri berria {$a} galdera bakoitzeko.)</small>';
$string['layoutshuffledandpaged'] = 'Ausaz nahastutako galderak, orriko {$a} galderarekin.';
$string['layoutshuffledsinglepage'] = 'Ausaz nahastutako galderak, guztiak orri batean.';
$string['link'] = 'Esteka';
$string['listitems'] = 'Galdetegiaren elementuak zerrendatzen';
$string['literal'] = 'Literala';
$string['loadingquestionsfailed'] = 'Galderak kargatzeak huts egin du: {$a}';
$string['makecopy'] = 'Gorde galdera berri gisa';
$string['managetypes'] = 'Kudeatu galdera motak eta zerbitzariak';
$string['manualgradequestion'] = 'Eskuz kalifikatu {$a->quiz} galdetegiko {$a->user} erabiltzailearen {$a->question} galdera';
$string['manualgrading'] = 'Kalifikazioa';
$string['mark'] = 'Bidali';
$string['markall'] = 'Bidali orria';
$string['marks'] = 'Puntuazioak';
$string['marks_help'] = 'Galdera bakoitzean lortutako puntuazioa eta saiakeraren kalifikazio orokorra. Puntuazioa soilik aukeratu ahalko dituzu \'Gehieneko puntuazioak\' aukeratuta badago.';
$string['match'] = 'Lotu enuntziatuak';
$string['matchanswer'] = 'Lotutako erantzuna';
$string['matchanswerno'] = 'Lotutako erantzuna {$a}';
$string['max'] = 'Gehienez';
$string['maxmark'] = 'Gehieneko puntuazioa';
$string['maxmarks'] = 'Gehieneko puntuazioak';
$string['maxmarks_help'] = 'Galdera bakoitzarentzat eskuragarri egongo den gehieneko puntuazioa.';
$string['messageprovider:attempt_grading_complete'] = 'Zure saiakera kalifikatua izan denaren jakinarazpena';
$string['messageprovider:attempt_overdue'] = 'Zure galdetegi-saiakera epez kanpo geratzen denaren jakinarazpena.';
$string['messageprovider:confirmation'] = 'Galdetegiari erantzun izanaren berrespena';
$string['messageprovider:submission'] = 'Zure ikasleen galdetegi-bidalketen jakinarazpena';
$string['min'] = 'Gutxienez';
$string['minutes'] = 'Minutu(ak)';
$string['missingcategory'] = 'Galdera-kategoria falta da';
$string['missingcorrectanswer'] = 'Erantzun zuzena zehaztu behar da';
$string['missingitemtypename'] = 'Izena falta da';
$string['missingquestion'] = 'Itxuraz, galdera hau dagoeneko ez da existitzen';
$string['modulename'] = 'Galdetegia';
$string['modulename_help'] = 'Galdetegiari esker, irakasleak hainbat motetako galderez (aukera anizkoitzekoak, aukerak lotu, erantzun laburrak, zenbakizkoak...) osatutako galdetegiak diseinatu eta pasatu ahal ditu.

Irakasleak galdetegian egin daitekeen saiakera-kopurua ezar dezake, galderak nahastuz edo galderak galdera-bankutik ausaz aukeratuta. Denbora muga bat ere ezar daiteke.

Ahalegin bakoitza automatikoki kalifikatzen da, entsegu motako galderak izan ezik, eta kalifikazioa kalifikazio-liburuan gordetzen da.

Irakasleak iruzkinak egiteko aukera du, baita feedbackak zein erantzun zuzenak ikasleei noiz erakutsiko zaizkien ere.

Galdetegiak erabil daitezke

* Ikastaroko azterketak egiteko
* Test txikien moduan irakurketa zereginetan edo klase-amaieretan
* Azterketarako entrenamendu bezala, aurreko azterketen galderak erabiliz
* Errendimenduaren berehalako feedbacka lortzeko
* Auto-ebaluaziorako';
$string['modulename_link'] = 'mod/quiz/view';
$string['modulenameplural'] = 'Galdetegiak';
$string['moveselectedonpage'] = 'Mugitu aukeratutako galderak orri honetara: {$a}';
$string['multichoice'] = 'Aukera anizkoitza';
$string['multipleanswers'] = 'Aukeratu erantzun bat gutxienez';
$string['mustbesubmittedby'] = 'Saiakera hau bidaltzeko epearen amaiera: {$a}';
$string['name'] = 'Izena';
$string['navigatenext'] = 'Hurrengo orria';
$string['navigateprevious'] = 'Aurreko orria';
$string['navmethod'] = 'Nabigazio-metodoa';
$string['navmethod_free'] = 'Librea';
$string['navmethod_help'] = 'Nabigazio sekuentziala gaituta dagoenean ikasleek galdetegiaren ordena jarraitu behar dute, eta ezin dute aurreko orrira itzuli edo hurrengora joan.';
$string['navmethod_seq'] = 'Sekuentziala';
$string['navnojswarning'] = 'Kontuz: esteka horrek ez ditu gordeko zure erantzunak. Erabili hurrengoa botoia orriaren beheko aldean.';
$string['neverallononepage'] = 'Inoiz ez, galdera guztiak orri batean.';
$string['newattemptfail'] = 'Errorea: ezin izan da beste saiakera bat hasi galdetegian';
$string['newcategory'] = 'Kategoria berria';
$string['newpage'] = 'Orri berria';
$string['newpage_help'] = 'Galdetegi luzeenetan zentzuzkoa izan daiteke galdetegia hainbat orritan jartzea, orri bakoitzeko galdera-kopurua mugatuta. Galdetegiari galderak gehitzerakoan orri-jauziak automatikoki jarriko dira hemen zehaztutakoaren arabera. Halere beranduago ere orri-jauziak edizio-orrian eskuz alda daitezke.';
$string['newpageevery'] = 'Automatikoki hasi orri berria';
$string['newsectionheading'] = 'Goiburu berria';
$string['noanswers'] = 'Ez duzu erantzunik aukeratu!';
$string['noattempts'] = 'Galdetegi honetan ez da saiakerarik egin';
$string['noattemptsfound'] = 'Ez da saiakerarik aurkitu.';
$string['noattemptstoshow'] = 'Ez dago erakusteko saiakerarik';
$string['nocategory'] = 'Kategoria ezegokia edo zehaztu gabea';
$string['noclose'] = 'Ez dago itxiera-datarik';
$string['nocommentsyet'] = 'Oraindik ez dago iruzkinik';
$string['noconnection'] = 'Oraindik ez dago galdera hau prozesa dezakeen web-zerbitzuarekiko konexiorik. Mesedez, jarri harremanetan zure administratzailearekin.';
$string['nodataset'] = 'Ezer ez - hau ez da komodin bat';
$string['nodatasubmitted'] = 'Ez da daturik bidali.';
$string['noessayquestionsfound'] = 'Ez da aurkitu eskuz kalifikatutako galderarik';
$string['nogradewarning'] = 'Galdetegi honek ez du kalifikaziorik, beraz, ezin duzu ezarri kalifikazioen araberako feedbacka.';
$string['nomoreattempts'] = 'Ezin da saiakera gehiago egin';
$string['none'] = 'Bat ere ez';
$string['noopen'] = 'Ez dago hasiera-datarik';
$string['nooverridedata'] = 'Gutxienez, galdetegiaren ezarpen baten salbuespena egin behar duzu.';
$string['nopossibledatasets'] = 'Datu-multzo posiblerik ez';
$string['noquestionintext'] = 'Testuak ez du txertatutako galderarik';
$string['noquestions'] = 'Ez da galderarik gehitu oraindik';
$string['noquestionsfound'] = 'Ez da galderarik aurkitu';
$string['noquestionsinquiz'] = 'Ez dago galderarik galdetegi honetan.';
$string['noquestionsnotinuse'] = 'Ausazko galdera hau ez da erabili, bere kategoria hutsik dago-eta.';
$string['noquestionsonpage'] = 'Orri hutsa';
$string['noresponse'] = 'Erantzunik ez';
$string['noreview'] = 'Ez duzu galdetegi hau berrikusteko baimenik';
$string['noreviewattempt'] = 'Ez duzu saiakera hau berrikusteko baimenik.';
$string['noreviewshort'] = 'Berrikusketa ez dago baimenduta';
$string['noreviewuntil'] = '{$a} arte ez duzu galdetegi hau berrikusteko baimenik';
$string['noreviewuntilshort'] = 'Eskuragarri: {$a}';
$string['noscript'] = 'JavaScripta gaituta egon behar da aurrera jarraitzeko';
$string['notavailabletostudents'] = 'Oharra: galdetegi hau ez dago une honetan eskuragarri zure ikasleentzat.';
$string['notenoughrandomquestions'] = 'Ez dago behar adina galdera {$a->category} kategorian {$a->name} ({$a->id}) galdera sortzeko.';
$string['notenoughsubquestions'] = 'Azpigaldera nahikorik ez duzu definitu!<br />Atzera joan nahi duzu arazoa konpontzeko?';
$string['notifyattemptsgradedtask'] = 'Bidali kalifikatutako galdetegi-saiakeren jakinarazpenak';
$string['notimedependentitems'] = 'Une honetan Galdetegia moduluak ez du onartzen denbora mugatuko itemik. Horren ordez, zehaztu ezazu galdetegi osorako denbora muga. Beste item bat aukeratu ala oraingoa erabili nahi duzu?';
$string['notyetgraded'] = 'Ez da oraindik kalifikatu';
$string['notyetviewed'] = 'Ez da oraindik ikusi';
$string['notyourattempt'] = 'Hau ez da zure saiakera!';
$string['noview'] = 'Identifikatutako erabiltzaileek ez dute baimenik galdetegi hau ikusteko.';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} {$a->attemptnum} saiakera egin du';
$string['numberabbr'] = '#';
$string['numerical'] = 'Zenbakizkoa';
$string['numquestionsx'] = 'Galderak: {$a}';
$string['oneminute'] = 'Minutu bat';
$string['onlyteachersexport'] = 'Irakasleek baino ezin ditzakete galderak esportatu';
$string['onlyteachersimport'] = 'Edizio baimena duten irakasleek baino ezin dute galderak inportatu';
$string['onthispage'] = 'Orri hau';
$string['open'] = 'Erantzunik gabe';
$string['openafterclose'] = 'Ezin izan da galdetegia eguneratu. Zehaztu duzun hasiera-data itxiera-data baino beranduagokoa da.';
$string['openclosedatesupdated'] = 'Galdetegia hasiera eta itxiera-datak eguneratu dira';
$string['optional'] = 'hautazkoa';
$string['orderandpaging'] = 'Ordena eta orrikatzea';
$string['orderandpaging_help'] = 'Galderen ondoan dauden 10, 20, 30... zenbakiek galderen ordena adierazten dute. Zenbakiak hamarnaka igotzen dira, galdera berriak tartekatu behar badira, lekua izateko. Galderak berrantolatu behar badira, egin klik "Galderak berrantolatu" botoian.

Orri-jauziak ezartzeko galdera jakin baten ondoren, galderen aldamenean dauden karratutxoak markatu, eta egin klik "Gehitu beste orri batzuk aukeratutako galderen ondoren" botoian.

Galderak orri-kopuru jakin baten artean banatzeko, egin klik "Berriz orrikatu" botoian eta aukeratu orri bakoitzeko nahi den galdera-kopurua.';
$string['orderingquiz'] = 'Ordena eta orrikatzea';
$string['orderingquizx'] = 'Ordena eta orrikatzea: {$a}';
$string['outcomesadvanced'] = 'Ikaste-emaitzak ezarpen aurreratuak dira';
$string['outof'] = '{$a->grade} gehieneko {$a->maxgrade}(e)tik';
$string['outofpercent'] = '{$a->grade} gehieneko {$a->maxgrade}(e)tik (%{$a->percent})';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Galdetegiko feedback orokorra';
$string['overallfeedback_help'] = 'Galdetegiko feedback orokorra galdetegiaren saiakera bat osatu ondoren ikasleari erakutsiko zaion testua da. Kalifikazio-muga gehiago zehaztuta (zenbakia edo ehunekoa adieraziz), erakutsitako testua ikasleak lortutako kalifikazioaren araberakoa izan daiteke.';
$string['overdue'] = 'Atzeratuta';
$string['overduehandling'] = 'Epea iraungitzen denean';
$string['overduehandling_desc'] = 'Ikasle batek galdetegia garaiz bidaltzen ez badu, gertatu beharko litzatekeenerako lehenetsitako balioa.';
$string['overduehandling_help'] = 'Ezarpen honek kontrolatzen du zer gertatzen den ikasle batek denbora agortu aurretik galdetegiaren saiakera bidaltzea lortzen ez badu. Momentu horretan ikaslea saiakeran lanean ari bada, atzerako kontaketa kronometroak automatikoki bidaliko du saiakera, baina ikaslea plataformatik atera bada, ezarpen honek kontrolatzen du zer gertatuko den.';
$string['overduehandling_link'] = 'mod/quiz/timing';
$string['overduehandlingautoabandon'] = 'Saiakerak denbora agortu aurretik bidali behar dira; bestela, ez dira aintzat hartuko';
$string['overduehandlingautosubmit'] = 'Denbora agortzean saiakera irekiak automatikoki bidaltzen dira.';
$string['overduehandlinggraceperiod'] = 'Denbora agortzean hasitako saiakerak bidaltzeko epe gehigarria dago, baina epe horretan ezin da galdera gehiago erantzun';
$string['overduemustbesubmittedby'] = 'Saiakera hau epez kanpo dago. Dagoeneko bidalita egon beharko luke. Galdetegia kalifikatua izatea nahi baduzu, {$a}(e)rako bidali behar duzu. Ez baduzu data horretarako bidaltzen, saiakera hau ez da aintzat hartuko.';
$string['override'] = 'Gehitu salbuespena';
$string['overridecannotchange'] = 'Erabiltzailea ala taldea ezin da aldatu baliogabetze bat sortu ondoren.';
$string['overridecannotsetbothgroupanduser'] = 'Ezin da aldi berean taldea eta erabiltzailea zehaztu.';
$string['overridedeletegroupsure'] = 'Ziur zaude {$a} talderako talde-salbuespena ezabatu nahi duzula?';
$string['overridedeleteusersure'] = 'Ziur zaude {$a} erabiltzailearentzako salbuespena ezabatu nahi duzula?';
$string['overridegroup'] = 'Salbuetsitako taldea';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrideinvalidattempts'] = 'Saiakerak balioa zero baino handiagoa izan behar da.';
$string['overrideinvalidexistingid'] = 'Lehendik zegoen baliogabetzea jada ez da existitzen.';
$string['overrideinvalidgroup'] = 'Emandako taldea ez da existitzen.';
$string['overrideinvalidquiz'] = 'Galdetegiaren IDa ez da existitzen.';
$string['overrideinvalidtimelimit'] = 'Denbora-muga zero baino handiagoa izan behar da.';
$string['overrideinvaliduser'] = 'Emandako erabiltzailea ez da existitzen.';
$string['overridemissingdelete'] = '{$a} baliogabetze-IDak ezin izan dira ezabatu ez direlako existitzen edo ez dutelako emandako galdetegian parte hartzen.';
$string['overridemultiplerecordsexist'] = 'Ezin da erabiltzaile/talde berarentzat baliogabetze bat baino gehiago egin.';
$string['overridemustsetuserorgroup'] = 'Erabiltzailea ala taldea zehaztu behar da.';
$string['overrides'] = 'Salbuespenak';
$string['overridesforquiz'] = 'Ezarpen-salbuespenak';
$string['overridesnoneforgroups'] = 'Ez da talde-salbuespenik sortu galdetegi honetan.';
$string['overridesnoneforusers'] = 'Ez da erabiltzaile-salbuespenik sortu galdetegi honetan.';
$string['overridessummary'] = 'Ezarpen-salbuespenak daude ({$a})';
$string['overridessummarygroup'] = 'Taldeak: {$a}';
$string['overridessummarythisgroup'] = 'Ezarpen-salbuespenak daude ({$a}) talde honentzako';
$string['overridessummaryuser'] = 'Erabiltzaileak: {$a}';
$string['overridessummaryyourgroups'] = 'Ezarpen-salbuespenak daude ({$a}) zure taldeentzako';
$string['overrideuser'] = 'Salbuetsitako erabiltzailea';
$string['overrideusereventname'] = '{$a->quiz} - Salbuespena';
$string['page-mod-quiz-attempt'] = 'Galdetegiaren saiakera-orria';
$string['page-mod-quiz-edit'] = 'Editatu galdetegiaren orria';
$string['page-mod-quiz-report'] = 'Edozein galdetegi-txosten orri';
$string['page-mod-quiz-review'] = 'Berrikusi galdetegiaren saiakera-orria';
$string['page-mod-quiz-summary'] = 'Galdetegiaren saiakeraren laburpen-orria';
$string['page-mod-quiz-view'] = 'Galdetegiaren informazio-orria';
$string['page-mod-quiz-x'] = 'Galdetegiaren edozein orri';
$string['pageshort'] = 'P';
$string['pagesize'] = 'Orriaren tamaina';
$string['parent'] = 'Goragokoa';
$string['parentcategory'] = 'Goragoko kategoria';
$string['parsingquestions'] = 'Inportazio-fitxategiko galderak aztertzen';
$string['partiallycorrect'] = 'Partzialki zuzena';
$string['penalty'] = 'Penalizazioa';
$string['penaltyscheme'] = 'Ezarri penalizazioak';
$string['penaltyscheme_help'] = 'Gaituz gero, erantzun oker bakoitzak galderaren behin-betiko kalifikazioan penalizazio bat ezarriko du. Penalizazioaren neurria galdera bakoitzaren ezarpenetan zehazten da. Ezarpen honek galdetegia egokitze moduan dagoenean soilik du eragina.';
$string['percentcorrect'] = 'Ehuneko zuzena';
$string['pleaseclose'] = 'Zure eskaria prozesatu da. Orain leihoa itxi dezakezu';
$string['pluginadministration'] = 'Galdetegiaren kudeaketa';
$string['pluginname'] = 'Galdetegia';
$string['popup'] = 'Erakutsi galdetegia leiho \'seguru\' batean';
$string['popupblockerwarning'] = 'Galdetegiaren zati hau modu seguruan dago eta horrek esan nahi du leiho seguru batean osatu behar duzula galdetegia. Mesedez, desaktibatu popup leihoen blokeoa. Eskerrik asko.';
$string['popupnotice'] = 'Ikasleek galdetegi hau modu seguruan ikusiko dute';
$string['preprocesserror'] = 'Errorea gertatu da prozesamenduaren aurretik!';
$string['preview'] = 'Aurreikusi';
$string['previewquestion'] = 'Aurreikusi galdera';
$string['previewquiz'] = 'Aurreikusi {$a}';
$string['previewquiznow'] = 'Aurreikusi galdetegia orain';
$string['previewquizstart'] = 'Aurreikusi galdetegia';
$string['previous'] = 'Aurreko egoera';
$string['privacy:metadata:core_question'] = 'Galdetegia jarduerak galderen erabileraren informazioa gordetzen du muineko galderen azpisisteman.';
$string['privacy:metadata:quiz'] = 'Galdetegia jarduerak galdetegi-txostenen erabilera egiten du.';
$string['privacy:metadata:quiz_attempts'] = 'Galdetegi bateko saiakera bakoitzaren inguruko xehetasunak.';
$string['privacy:metadata:quiz_attempts:attempt'] = 'Saiakera-zenbakia.';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'Erabiltzean une honetan dagoen orria.';
$string['privacy:metadata:quiz_attempts:gradednotificationsenttime'] = 'Erabiltzaileari bere saiakeraren eskuzko kalifikazioa osatu dela jakinarazi zitzaion unea';
$string['privacy:metadata:quiz_attempts:preview'] = 'Galdetegiaren aurrebista bat den edo ez.';
$string['privacy:metadata:quiz_attempts:state'] = 'Saiakeraren une honetako egoera';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'Saiakerako kalifikazioen batuketa.';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = 'Egoera konprobatu zeneko unea.';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'Saiakera osatu zeneko unea.';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'Saiakera eguneratu zeneko unea.';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = 'Saiakera lineaz kanpoko eguneratze baten bitartez eguneratu zeneko unea.';
$string['privacy:metadata:quiz_attempts:timestart'] = 'Saiakera hasi zeneko unea.';
$string['privacy:metadata:quiz_grades'] = 'Galdetegi honetako kalifikazio orokorraren inguruko xehetasunak.';
$string['privacy:metadata:quiz_grades:grade'] = 'Galdetegi honetako kalifikazio orokorra.';
$string['privacy:metadata:quiz_grades:quiz'] = 'Kalifikatutako galdetegia.';
$string['privacy:metadata:quiz_grades:timemodified'] = 'Kalifikazioa aldatu zeneko unea.';
$string['privacy:metadata:quiz_grades:userid'] = 'Kalifikatutako erabiltzailea.';
$string['privacy:metadata:quiz_overrides'] = 'Galdetegi honetako salbuespenen inguruko xehetasunak';
$string['privacy:metadata:quiz_overrides:quiz'] = 'Salbuespenak dituen galdetegia';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'Galdetegirako itxiera-data berria.';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'Galdetegirako denbora-muga berria.';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'Galdetegirako hasiera-data berria.';
$string['privacy:metadata:quiz_overrides:userid'] = 'Baliogabetzen ari den erabiltzailea';
$string['privacy:metadata:quizaccess'] = 'Galdetegia jarduerak galdetegien sarbide-arauen erabilera egiten du.';
$string['publish'] = 'Argitaratu';
$string['publishedit'] = 'Argitaratzeko erabaki den ikastaroan kategoria honetan galderak editatu edo gehitzeko baimena behar duzu';
$string['qbrief'] = 'G. {$a}';
$string['qname'] = 'izena';
$string['qti'] = 'IMS QTI formatua';
$string['qtypename'] = 'mota, izena';
$string['question'] = 'Galdera';
$string['questionbank'] = 'galdera-bankutik';
$string['questionbankmanagement'] = 'Galdera-bankuaren kudeaketa';
$string['questionbehaviour'] = 'Galderen jokaera';
$string['questioncats'] = 'Galdera-kategoriak';
$string['questiondeleted'] = 'Galdera hau ezabatu egin da. Mesedez, jarri harremanetan irakaslearekin.';
$string['questiondependencyadd'] = 'Ez dago {$a->thisq} galdera erantzuten saiatzeko murrizketarik • Egin klik aldatzeko';
$string['questiondependencyfree'] = 'Ez dago murrizketarik galdera honetan';
$string['questiondependencyremove'] = '{$a->thisq} galderari ezin da aurretiko {$a->previousq} galdera osatu arte erantzun • Egin klik aldatzeko';
$string['questiondependsonprevious'] = 'Ezin da galdera hau erantzuteko saiakerarik egin aurreko galdera osatu bitartean.';
$string['questiondraftonly'] = '{$a} galdera zirriborro egoeran dago. Galdera hau galdetegian erabiltzeko joan galdera-bankura eta prest dagoela zehaztu ezazu.';
$string['questiondraftwillnotwork'] = 'Galdera hau zirriborro egoeran dago. Galdera hau galdetegian erabiltzeko joan galdera-bankura eta prest dagoela zehaztu ezazu.';
$string['questioninuse'] = '\'{$a->questionname}\' galdera oraintxe erabiltzen ari da hemen: <br />{$a->quiznames}<br /> Galdera ez da ezabatuko galdetegietatik baina bai kategoria-zerrendatik.';
$string['questionmissing'] = 'Saio honetarako galdera falta da';
$string['questionname'] = 'Galderaren izena';
$string['questionnonav'] = '<span class="accesshide">Galdera </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Informazioa </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = '{$a} galdera ez da aurkitu datu-basean.';
$string['questionorder'] = 'Galderen ordena';
$string['questionposition'] = 'Kokaleku berria {$a} galderarentzat';
$string['questions'] = 'Galderak';
$string['questionsetpreview'] = 'Galdera-multzoaren aurrebista';
$string['questionsinclhidden'] = 'Galderak (ezkutukoak barne)';
$string['questionsinthisquiz'] = 'Galderak galdetegi honetan';
$string['questionsmatchingfilter'] = 'Iragazki hau betetzen duten galderak: {$a}';
$string['questionsperpage'] = 'Galderak orriko';
$string['questionsperpageselected'] = 'Orri bakoitzeko galdera-kopurua finkatu da, beraz, orrikatzea finkatua dago. Ondorioz, orrikatze-kontrolak desgaitu dira. {$a}-n alda dezakezu hau.';
$string['questionsperpagex'] = 'Galderak orriko: {$a}';
$string['questiontext'] = 'Galderaren testua';
$string['questiontextisempty'] = '[Galderaren testua hutsik]';
$string['questiontype'] = '{$a} motako galdera';
$string['questiontypesetupoptions'] = 'Galdera-motetarako aukerak';
$string['questionversion'] = '{$a}. bertsioa';
$string['questionversionlatest'] = '{$a}. bertsioa (berriena)';
$string['quiz:addinstance'] = 'Gehitu galdetegi berria';
$string['quiz:attempt'] = 'Erantzun galdetegiei';
$string['quiz:deleteattempts'] = 'Ezabatu galdetegiaren saiakerak';
$string['quiz:emailconfirmsubmission'] = 'Jaso zure galdetegi-bidalketen berreste-mezua';
$string['quiz:emailnotifyattemptgraded'] = 'Jaso jakinarazpenak zure saiakera kalifikatua izan denean';
$string['quiz:emailnotifysubmission'] = 'Jaso zure ikasleen galdetegi-bidalketen jakinarazpena';
$string['quiz:emailwarnoverdue'] = 'Jaso jakinarazpen-mezu bat zure galdetegi-saiakera epez kanpo geratzen denean.';
$string['quiz:grade'] = 'Kalifikatu galdetegiak eskuz';
$string['quiz:ignoretimelimits'] = 'Ez egin jaramonik denbora-mugari';
$string['quiz:manage'] = 'Kudeatu galdetegiak';
$string['quiz:manageoverrides'] = 'Kudeatu galdetegi-ezarpenen salbuespenak';
$string['quiz:preview'] = 'Aurreikusi galdetegiak';
$string['quiz:regrade'] = 'Berriro kalifikatu galdetegiaren saiakerak';
$string['quiz:reopenattempts'] = 'Berriz ireki bidali gabeko galdetegi saiakerak.';
$string['quiz:reviewmyattempts'] = 'Berrikusi zure saiakerak';
$string['quiz:view'] = 'Ikusi galdetegiaren informazioa';
$string['quiz:viewoverrides'] = 'Ikusi galdetegi-ezarpenen salbuespenak';
$string['quiz:viewreports'] = 'Ikusi galdetegiaren txostenak';
$string['quizavailable'] = 'Galdetegia eskuragarri egongo da {$a} arte';
$string['quizclose'] = 'Galdetegiaren itxiera-data';
$string['quizclosed'] = 'Galdetegi hau {$a} itxi zen';
$string['quizcloses'] = 'Galdetegia itxiko da';
$string['quizcloseson'] = 'Galdetegi hau {$a} itxiko da.';
$string['quizeventcloses'] = '{$a}(r)en itxiera-data:';
$string['quizeventopens'] = '{$a}(r)en hasiera-data:';
$string['quizisclosed'] = 'Galdetegi hau itxita dago';
$string['quizisclosedwillopen'] = 'Galdetegia itxita dago (hasiera-data: {$a})';
$string['quizisopen'] = 'Galdetegi hau irekita dago';
$string['quizisopenwillclose'] = 'Galdetegia irekita dago (itxiera-data: {$a})';
$string['quiznavigation'] = 'Galdetegiaren nabigazioa';
$string['quizopen'] = 'Galdetegiaren hasiera-data';
$string['quizopenclose'] = 'Galdetegiaren hasiera eta itxiera-datak';
$string['quizopenclose_help'] = 'Ikasleek soilik hasiera-data baino beranduago hasi dezakete bere saiakera(k), eta itxiera-dataren aurretik amaitu behar dute.';
$string['quizopenclose_link'] = 'mod/quiz/timing';
$string['quizopened'] = 'Galdetegi hau irekita dago.';
$string['quizopenedon'] = 'Galdetegi hau {$a} ireki zen';
$string['quizopens'] = 'Galdetegia irekiko da';
$string['quizopenwillclose'] = 'Galdetegi hau irekita dago, {$a} itxiko da';
$string['quizordernotrandom'] = 'Galdetegiaren ordena ez da ausazkoa';
$string['quizorderrandom'] = '* Galdetegiaren ordena ausazkoa da';
$string['quizreport'] = 'Galdetegi-txostena';
$string['quizsettings'] = 'Galdetegiaren ezarpenak';
$string['quizsetupnavigation'] = 'Galdetegiaren konfigurazioaren nabigazioa';
$string['quiztimer'] = 'Galdetegiaren kronometroa';
$string['quizwillopen'] = 'Galdetegi hau {$a} irekiko da';
$string['random'] = 'Ausazko galdera';
$string['randomcatwithsubcat'] = '{$a} eta azpi-kategoriak';
$string['randomcoursecatwithsubcat'] = '{$a} ikastaro-kategoriaren barruko edozein kategoria';
$string['randomcoursewithsubcat'] = 'Ikastaro honetako edozein kategoria';
$string['randomcreate'] = 'Sortu ausazko galderak';
$string['randomediting'] = 'Ausazko galdera editatzen';
$string['randomfaultynosubcat'] = 'Galdera baliogabea';
$string['randomfromcategory'] = 'Ausazko galdera kategoria honetatik:';
$string['randomfromexistingcategory'] = 'Ausazko galdera existitzen den kategoria batetik';
$string['randomfromunavailabletag'] = '{$a} (ez eskuragarri)';
$string['randommodulewithsubcat'] = 'Galdetegi honetako edozein kategoria';
$string['randomnosubcat'] = 'Soilik kategoria honetako galderak, ez azpikategorietatik.';
$string['randomnumber'] = 'Ausazko galdera kopurua';
$string['randomqname'] = 'Ausazko galdera iragazkiaren baldintzetan oinarrituta';
$string['randomqnamecat'] = 'Ausazko galdera ({$a->category}) iragazkiaren baldintzetan oinarrituta';
$string['randomqnamecattags'] = 'Ausazko galdera ({$a->category}) iragazkiaren baldintzetan oinarrituta hurrengo etiketekin: {$a}';
$string['randomqnametags'] = 'Ausazko galdera iragazkiaren baldintzetan oinarrituta hurrengo etiketekin: {$a}';
$string['randomquestion'] = 'Ausazko galdera';
$string['randomquestion_help'] = 'Ausazko galderak kategoria zehatz batetik edo etiketa konkretua duen ausazko galderak jarduera batean txertatzeko modua da.';
$string['randomquestiontags'] = 'Etiketak';
$string['randomquestiontags_help'] = 'Aukeratzeko irizpideak hemen galdera-etiketa batzuk zehaztuz murriztu daitezke.

Ausazko galderak etiketa horiek guztiak dituzten galderen artean hartuko dira.';
$string['randomquestionusinganewcategory'] = 'Ausazko galdera kategoria berri bat erabiliz';
$string['randomsystemwithsubcat'] = 'Sistema-mailako edozein kategoria';
$string['randomwithsubcat'] = 'Kategoria honetako galderak eta bere azpikategorietakoak.';
$string['readytosend'] = 'Galdetegi osoa bidaliko duzu kalifikatua izan dadin. Ziur zaude jarraitu nahi duzula?';
$string['reattemptquiz'] = 'Saiatu berriro galdetegia egiten';
$string['recentlyaddedquestion'] = 'Duela gutxi gehitutako galdera!';
$string['recurse'] = 'Gehitu baita azpikategorietako galderak  ere';
$string['redoesofthisquestion'] = 'Saiatutako beste galderak hemen: {$a}';
$string['redoquestion'] = 'Saiatu honen moduko beste galdera bat erantzuten';
$string['regrade'] = 'Berriro kalifikatu saiakera guztiak';
$string['regradecomplete'] = 'Saiakera guztiak berriro kalifikatu dira';
$string['regradecount'] = '{$a->attempt} saiakeratik {$a->changed} aldatu dira';
$string['regradedisplayexplanation'] = 'Berriro kalifikatu bitartean aldatzen diren saiakerak galderak berrikusteko leihorako esteka gisa agertzen dira';
$string['regradenotallowed'] = 'Ez duzu galdetegi hau berriro kalifikatzeko baimenik';
$string['regradingquestion'] = '"{$a}" berriro kalifikatzen';
$string['regradingquiz'] = '"{$a}" galdetegia berriro kalifikatzen';
$string['remove'] = 'Ezabatu';
$string['removeallgroupoverrides'] = 'Ezabatu talde-salbuespen guztiak';
$string['removeallquizattempts'] = 'Ezabatu galdetegietako saiakera guztiak';
$string['removealluseroverrides'] = 'Ezabatu erabiltzaile-salbuespen guztiak';
$string['removeemptypage'] = 'Ezabatu hutsik dagoen orria';
$string['removepagebreak'] = 'Ezabatu orri-jauzia';
$string['removeselected'] = 'Ezabatu aukeratutakoa(k)';
$string['rename'] = 'Aldatu izena';
$string['renderingserverconnectfailed'] = '{$a} zerbitzariak ezin izan du RQP eskaria prozesatu. Egiaztatu URLa zuzena dela.';
$string['reopenattempt'] = 'Berriz ireki';
$string['reopenattemptareyousuremessage'] = 'Ekintza honek {$a->attemptuser} erabiltzailearen {$a->attemptnumber} galdetegi-saiakera berriz irekiko du.';
$string['reopenattemptareyousuretitle'] = 'Berriz ireki saiakera?';
$string['reopenattemptwrongstate'] = '{$a->attemptid} saiakerak berriz ireki ahal izateko egoera okerra dauka ({$a->state}).';
$string['reopenedattemptwillbeinprogress'] = 'Saiakera irekita utziko da berarekin jarraitu ahal izateko.';
$string['reopenedattemptwillbeinprogressuntil'] = 'Saiakera irekita utziko da berarekin jarraitu ahal izateko galdetegiaren itxiera-data heldu arte ({$a}).';
$string['reopenedattemptwillbesubmitted'] = 'Saiakera berehala kalifikatzeko bidaliko da.';
$string['reorderquestions'] = 'Berrantolatu galderak';
$string['reordertool'] = 'Erakutsi berrantolaketarako tresna';
$string['repaginate'] = 'Berriz orrikatu {$a} galderarekin orri bakoitzeko';
$string['repaginatecommand'] = 'Berriz orrikatu';
$string['repaginatenow'] = 'Berriz orrikatu orain';
$string['replace'] = 'Ordezkatu';
$string['replacementoptions'] = 'Ordezkatzeko aukerak';
$string['report'] = 'Txostenak';
$string['reportanalysis'] = 'Elementuen analisia';
$string['reportattemptsfrom'] = 'Noren saiakerak?';
$string['reportattemptsthatare'] = 'Egoera hauetan dauden saiakerak:';
$string['reportdisplayoptions'] = 'Erakusteko aukerak';
$string['reportfullstat'] = 'Estatistika zehatzak';
$string['reportmulti_percent'] = 'Ehuneko anizkoitzak';
$string['reportmulti_q_x_student'] = 'Ikasle anizkoitzeko aukerak';
$string['reportmulti_resp'] = 'Banakako erantzunak';
$string['reportmustselectstate'] = 'Gutxienez egoera bat aukeratu behar duzu.';
$string['reportnotfound'] = 'Txosten ezezaguna ({$a})';
$string['reportoverview'] = 'Ikuspegi orokorra';
$string['reportregrade'] = 'Berriro kalifikatu saiakerak';
$string['reportresponses'] = 'Erantzun zehatzak';
$string['reports'] = 'Txostenak';
$string['reportshowonly'] = 'Erakutsi soilik saiakera hauek:';
$string['reportshowonlyfinished'] = 'Erakutsi gehienez amaitutako saiakera bat erabiltzaileko ({$a})';
$string['reportsimplestat'] = 'Oinarrizko estatistikak';
$string['reportusersall'] = 'galdetegiari erantzuten saiatu diren erabiltzaile guztiak';
$string['reportuserswith'] = 'galdetegiari erantzuten saiatu diren matrikulatutako erabiltzaileak';
$string['reportuserswithorwithout'] = 'galdetegiari erantzuten saiatu diren eta saiatu ez diren matrikulatutako erabiltzaileak';
$string['reportuserswithout'] = 'galdetegiari erantzuten saiatu ez diren matrikulatutako erabiltzaileak';
$string['reportwhattoinclude'] = 'Zer jaso behar du txosten honek?';
$string['requirepassword'] = 'Eskatu pasahitza';
$string['requirepassword_help'] = 'Pasahitza zehazten badugu, ikasleek pasahitz hori idatzi beharko dute galdetegiari erantzun ahal izateko';
$string['requiresubnet'] = 'Behartu sare-helbide zehatza';
$string['requiresubnet_help'] = 'Galdetegia soilik tokiko sare bateko (LAN) edo Interneteko azpisare zehatz batean eskuragarri egoteko konfiguratu daiteke, komaz banatutako IP helbide oso edo partzialen zerrenda bat zehaztuta. Hau erabilgarria izan daiteke zaindutako (gainbegiratutako) galdetegi baterako, galdetegira soilik kokapen zehatz bateko jendeak sarbidea duela bermatu aldera.';
$string['response'] = 'Erantzuna';
$string['responses'] = 'Erantzunak';
$string['results'] = 'Emaitzak';
$string['returnattempt'] = 'Itzuli saiakerara';
$string['reuseifpossible'] = 'berriz erabili aurretik ezabatutakoa';
$string['reverttodefaults'] = 'Itzuli galdetegiaren balio lehenetsietara';
$string['review'] = 'Berrikusi';
$string['reviewafter'] = 'Baimendu berrikusketa galdetegia itxi ondoren';
$string['reviewalways'] = 'Baimendu berrikusketa edozein unetan';
$string['reviewattempt'] = 'Berrikusi saiakera';
$string['reviewbefore'] = 'Baimendu berrikusketa galdetegia irekita dagoen bitartean';
$string['reviewclosed'] = 'Galdetegia itxi ondoren';
$string['reviewduring'] = 'Saiakera egin bitartean';
$string['reviewimmediately'] = 'Saiakera bakoitzaren ondoren';
$string['reviewnever'] = 'Inoiz ez baimendu berrikusketa';
$string['reviewofquestion'] = 'Berrikusi {$a->quiz} galdetegiko {$a->user} erabiltzailearen {$a->question} galdera';
$string['reviewopen'] = 'Beranduago, irekita dagoen bitartean';
$string['reviewoptions'] = 'Ikasleek berrikusketa egin dezakete';
$string['reviewoptionsheading'] = 'Berrikusketen aukerak';
$string['reviewoptionsheading_help'] = 'Aukera hauek ikasleek galdetegi baten saiakera bat berrikustean edo galdetegi baten txostenetan ikus dezaketen informazioa kontrolatzen dute.

**Saiakera egin bitartean** aukera soilik jokaera zehatz batzuetan erabiltzen da, \'Interaktiboa hainbat saiakerarekin\' kasuan adibidez, saiakera egin bitartean feedbackak erakusteko aukera dutelako.

**Saiakera bakoitzaren ondoren** aukera soilik \'Bidali dena eta amaitu\' botoian klik egin ondorengo bi minutuetan aplikatzen da.

**Beranduago, irekita dagoen bitartean** aukera aurrekoaren ondoren aplikatzen da, galdetegiaren itxiera-data heldu arte.

**Galdetegia itxi ondoren** aukera galdetegiaren itxiera-data igaro ondoren aplikatzen da. Galdetegiak ez badu itxiera-datarik galdetegia ez da inoiz egoera honetara heltzen.';
$string['reviewoverallfeedback'] = 'Galdetegiko feedback orokorra';
$string['reviewoverallfeedback_help'] = 'Saiakeraren amaieran emandako feedbacka, ikasleak denera jasotako kalifikazio orokorraren araberakoa.';
$string['reviewresponse'] = 'Berrikusi erantzuna';
$string['reviewresponsetoq'] = 'Berrikusi erantzuna ({$a} galdera)';
$string['reviewthisattempt'] = 'Berrikusi zure saiakera honetako erantzunak';
$string['rqp'] = 'Urrutiko galdera';
$string['rqps'] = 'Urrutiko galderak';
$string['sameasoverall'] = 'Kalifikazio orokorretan erabilitako bera';
$string['save'] = 'Gorde';
$string['saveandedit'] = 'Gorde aldaketak eta editatu galderak';
$string['saveattemptfailed'] = 'Oraingo galdetegi-saiakera gordetzeak huts egin du.';
$string['savedfromdeletedcourse'] = '"{$a}" ezabatuko ikastarotik gordeta';
$string['savegrades'] = 'Gorde kalifikazioak';
$string['savemanualgradingfailed'] = 'Aldaketa ez da gorde. Egiaztatu mesedez azpiko mezua eta saiatu berriro.';
$string['savemyanswers'] = 'Gorde nire erantzunak';
$string['savenosubmit'] = 'Gorde bidali gabe';
$string['saveoverrideandstay'] = 'Gorde eta sartu beste salbuespen bat';
$string['savequiz'] = 'Gorde galdetegi oso hau';
$string['saving'] = 'Gordetzen';
$string['savingnewgradeforquestion'] = 'Kalifikazio berria gordetzen id {$a} galderarentzat.';
$string['savingnewmaximumgrade'] = 'Gehieneko kalifikazio berria gordetzen';
$string['score'] = 'Puntuazio gordina';
$string['scores'] = 'Puntuazioak';
$string['search:activity'] = 'Galdetegia - jardueraren informazioa';
$string['sectionheadingedit'] = 'Editatu \'{$a}\' goiburua';
$string['sectionheadingremove'] = 'Ezabatu \'{$a}\' goiburua';
$string['sectionnoname'] = 'Izenik gabeko atala';
$string['seequestions'] = '(Ikusi galderak)';
$string['select'] = 'Aukeratu';
$string['selectall'] = 'Aukeratu denak';
$string['selectattempt'] = 'Aukeratu saiakera';
$string['selectcategory'] = 'Aukeratu kategoria';
$string['selectedattempts'] = 'Aukeratutako saiakerak...';
$string['selectmultipleitems'] = 'Aukeratu elementu bat baino gehiago';
$string['selectmultipletoolbar'] = 'Aukeratu erreminta-barra bat baino gehiago';
$string['selectnone'] = 'Desmarkatu guztiak';
$string['selectquestionslot'] = 'Aukeratu {$a}. galdera';
$string['selectquestiontype'] = '-- Aukeratu galdera mota --';
$string['serveradded'] = 'Zerbitzaria gehitu da';
$string['serveridentifier'] = 'Identifikatzailea';
$string['serverinfo'] = 'Zerbitzariaren informazioa';
$string['servers'] = 'Zerbitzariak';
$string['serverurl'] = 'Zerbitzariaren URLa';
$string['shortanswer'] = 'Erantzun laburra';
$string['show'] = 'Erakutsi';
$string['showall'] = 'Erakutsi galdera guztiak orri bakarrean';
$string['showblocks'] = 'Erakutsi blokeak galdetegiari erantzun bitartean';
$string['showblocks_help'] = 'Bai aukeratuz gero, galdetegiari erantzun bitartean ohiko blokeak erakutsiko dira';
$string['showbreaks'] = 'Erakutsi orri-jauziak';
$string['showcategorycontents'] = 'Erakutsi kategoriaren edukiak: {$a->arrow}';
$string['showcorrectanswer'] = 'Feedbackean erantzun zuzenak erakutsi?';
$string['showdetailedmarks'] = 'Erakutsi oharraren zehaztasunak';
$string['showeachpage'] = 'Erakutsi orri bat aldi bakoitzean';
$string['showfeedback'] = 'Erantzun ondoren feedbacka erakutsi?';
$string['showinsecurepopup'] = 'Erabili popup leiho \'seguru\' bat saiakeretan';
$string['showlargeimage'] = 'Irudi handia';
$string['shownoattempts'] = 'Erakutsi saiakerarik egin ez duten ikasleak';
$string['shownoattemptsonly'] = 'Erakutsi soilik saiakerarik egin ez duten ikasleak';
$string['shownoimage'] = 'Irudirik ez';
$string['showreport'] = 'Erakutsi txostena';
$string['showsmallimage'] = 'Irudi txikia';
$string['showteacherattempts'] = 'Erakutsi irakasleen saiakerak';
$string['showuserpicture'] = 'Erakutsi erabiltzailearen irudia';
$string['showuserpicture_help'] = 'Gaituz gero, ikaslearen izena eta irudia pantailan eta berrikuste-pantailan erakutsiko dira saiakerak irauten duen bitartean; modu honetan, zaindutako azterketa batean zehar, errazagoa izango da ikaslea bere izenarekin sartu dela egiaztatzea.';
$string['shuffle'] = 'Nahastu';
$string['shuffleanswers'] = 'Nahastu erantzunak';
$string['shuffledrandomly'] = 'Ausaz nahastuta';
$string['shufflequestions'] = 'Nahastu';
$string['shufflequestions_help'] = 'Gaituz gero, galdetegia erantzuteko saiakera bakoitzean atal honetako galderak ausaz nahastu eta ordena berri batean erakutsiko dira.

Honek ikasleek galdera trukatzea zaildu dezake, baina ikasleek irakaslearekin galdera zehatz bati buruz jardutea ere zailtzen du.';
$string['shufflewithin'] = 'Nahastu galderen barruan';
$string['shufflewithin_help'] = 'Gaituz gero, galderen atalak ausaz nahastuko dira ikasle batek galdetegian saiakera bat egiten duen bakoitzean, galdetegiaren ezarpenetan ere gaituta badago. Ezarpen honek galderak atal anitz dituenean du eragina, hala nola aukera anizkoitzezkoak edo lotu galderetan.';
$string['singleanswer'] = 'Aukeratu erantzun bat';
$string['sortage'] = 'Ordenatu dataren arabera';
$string['sortalpha'] = 'Ordenatu izenaren arabera';
$string['sortquestionsbyx'] = 'Ordenatu galderak honen arabera: {$a}';
$string['sortsubmit'] = 'Ordenatu galderak';
$string['sorttypealpha'] = 'Ordenatu motaren eta izenaren arabera';
$string['specificapathnotonquestion'] = 'Zehaztutako fitxategiaren bidea ez dago zehaztutako galderan';
$string['specificquestionnotonquiz'] = 'Zehaztutako galdera ez dago zehaztutako galdetegian';
$string['startagain'] = 'Hasi berriro';
$string['startattempt'] = 'Hasi saiakera';
$string['startedon'] = 'Hasiera-unea';
$string['startnewpreview'] = 'Hasi berrikusketa berri bat';
$string['stateabandoned'] = 'Bidali gabea';
$string['statefinished'] = 'Amaituta';
$string['statefinisheddetails'] = '{$a} bidali da';
$string['stateinprogress'] = 'Abian';
$string['statenotloaded'] = '{$a} galderaren egoera ez da datu-basetik kargatu';
$string['stateoverdue'] = 'Atzeratuta';
$string['stateoverduedetails'] = '{$a}(e)rako bidali behar da';
$string['status'] = 'Egoera';
$string['stoponerror'] = 'Gelditu errorea gertatzen bada';
$string['submission_confirmation'] = 'Bidali zure erantzun guztiak eta amaitu?';
$string['submission_confirmation_unanswered'] = 'Erantzunik gabeko galdera kopurua: {$a}';
$string['submitallandfinish'] = 'Bidali dena eta amaitu';
$string['subneterror'] = 'Sentitzen dugu, baina galdetegi hau soilik helbide jakin batzuetatik egiteko konfiguratu da. Une honetan zure ordenagailuak ez du baimenik galdetegi hau erabiltzeko.';
$string['subnetnotice'] = 'Galdetegi hau soilik helbide jakin batzuetatik egiteko konfiguratu da. Zure ordenagailua ez dago baimendutako azpi-sarean. Irakasle gisa, aurreikusi dezakezu, hala ere.';
$string['subplugintype_quiz'] = 'Txostena';
$string['subplugintype_quiz_plural'] = 'Txostenak';
$string['subplugintype_quizaccess'] = 'Sarbide-araua';
$string['subplugintype_quizaccess_plural'] = 'Sarbide-arauak';
$string['substitutedby'] = 'zerk ordezkatuko duen:';
$string['summaryofattempt'] = 'Saiakeren laburpena';
$string['summaryofattempts'] = 'Zure saiakerak';
$string['temporaryblocked'] = 'Denbora tarte batez ez duzu <br /> galdetegia berriz egiten saiatzeko baimenik. Berriz egin ahal izateko data:';
$string['theattempt'] = 'Saiakera';
$string['theattempt_help'] = 'Ea ikasleak egindako saiakera berrikusi dezakeen ala ez.';
$string['time'] = 'Denbora';
$string['timecompleted'] = 'Amaitze-unea';
$string['timedelay'] = 'Ezin duzu galdetegia egin oraindik ez delako igaro galdetegia berriz egiten saiatzeko nahiko denbora .';
$string['timeleft'] = 'Geratzen den denbora';
$string['timelimit'] = 'Denbora-muga';
$string['timelimit_help'] = 'Gaituz gero, denbora-muga galdetegiaren hasiera orrian ezartzen da eta atzerako kontaketa kronometroa erakusten da galdetegiaren nabigazio-blokean.';
$string['timelimit_link'] = 'mod/quiz/timing';
$string['timelimitexeeded'] = 'Sentitzen dugu, baina galdetegiaren denbora-muga gainditu duzu!';
$string['timestr'] = '%H:%M:%S on %d/%m/%y';
$string['timesup'] = 'Denbora amaitu egin da!';
$string['timetaken'] = 'Hartutako denbora';
$string['timing'] = 'Eskuragarritasuna';
$string['tofile'] = 'fitxategi honetara';
$string['tolerance'] = 'Tolerantzia';
$string['toomanyrandom'] = 'Beharrezko den galdera-kopurua kategoria honek duena baino handiagoa da.';
$string['top'] = 'Gora';
$string['totalmarks'] = 'Puntuazio kopurua';
$string['totalmarksx'] = 'Kalifikazioak denera: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Denera {$a} galdera kategorian';
$string['true'] = 'Egia';
$string['truefalse'] = 'Egia/gezurra';
$string['type'] = 'Mota';
$string['unfinished'] = 'irekita';
$string['ungraded'] = 'Kalifikatu gabe';
$string['unit'] = 'Unitatea';
$string['unknowntype'] = 'Onartu gabeko galdera mota {$a} lerroan. Galdera ez da kontuan izango.';
$string['updatefilterconditon'] = 'Eguneratu iragazkiaren baldintzak';
$string['updatefilterconditon_success'] = 'Iragazkiaren baldintzak ondo eguneratu dira';
$string['updateoverdueattemptstask'] = 'Epez-kanpoko galdetegi-saiakerak eguneratzen';
$string['updatequizslotswithrandomxofy'] = 'Ausazko galdera-datuak dituzten galdera-tarteak eguneratzen ({$a->done}/{$a->total})';
$string['updatesettings'] = 'Eguneratu galdetegiaren ezarpenak';
$string['updatingatttemptgrades'] = 'Saiakeren kalifikazioak eguneratzen.';
$string['updatingfinalgrades'] = 'Azken kalifikazioak eguneratzen.';
$string['updatingthegradebook'] = 'Kalifikazio-liburua eguneratzen.';
$string['upgradesure'] = '<div>Galdetegia moduluak zehazki galdetegiaren tauletan aldaketa handia egingo du eta eguneraketa hau ez da oraindik nahikoa probatu. Jarraitu aurretik egin ezazu, mesedez, datu-basearen taulen segurtasun-kopia.</div>';
$string['upgradingquizattempts'] = 'Galdetegien saiakerak eguneratzen: {$a->done}/{$a->outof} galdetegi (Quiz id {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Galdetegi-saiakera oso zaharrak eguneratzen: {$a->done}/{$a->outof}';
$string['url'] = 'URLa';
$string['usedcategorymoved'] = 'Kategoria hau gorde eta gunera eraman da. Izan ere, ikastaroa ezabatutakoan, zerbitzariaren beste ikastaro batean/batzuetan erabiltzen ari ziren galderak.';
$string['useroverrides'] = 'Erabiltzaile-salbuespenak';
$string['useroverridesdeleted'] = 'Erabiltzaile-salbuespenak ezabatu dira';
$string['usersnone'] = 'Ez dago ikaslerik galdetegi honetarako sarbidea duenik';
$string['validate'] = 'Balioztatu';
$string['viewallanswers'] = 'Ikusi {$a} galdetegi saiakera';
$string['viewallreports'] = 'Ikusi {$a} saiakeren txostenak';
$string['viewed'] = 'Ikusi da';
$string['warningmissingtype'] = '<b>Galdera hau oraindik ere zure Moodlen instalatu gabeko mota batekoa da.<br />Mesedez, ohartu ezazu zure kudeatzailea.</b>';
$string['wheregrade'] = 'Non dago nire kalifikazioa?';
$string['wildcard'] = 'Komodina';
$string['windowclosing'] = 'Leiho hau laster itxiko da.';
$string['withsummary'] = 'laburpenaren estatistikekin';
$string['wronguse'] = 'Zuk ezin duzu orri hau horrela erabili';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Galdetegi honi erantzun ahal izateko ikastaro honetan matrikulatu behar duzu';
$string['yourfinalgradeis'] = 'Galdetegi honetan zure azken kalifikazioa {$a} da.';
