<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_ordering', language 'no', version '4.4'.
 *
 * @package     qtype_ordering
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['absoluteposition'] = 'Absolutt posisjon';
$string['addmultipleanswers'] = 'Legg til {$a} fler elementer';
$string['addsingleanswer'] = 'Legg til ett element';
$string['allornothing'] = 'Alt eller ingenting';
$string['answer'] = 'Elementtekst';
$string['correctitemsnumber'] = 'Korrekte elementer: {$a}';
$string['correctorder'] = 'Korrekt rekkefølge for disse elementene er som følger:';
$string['defaultanswerformat'] = 'Standard svarformat';
$string['defaultquestionname'] = 'Plasser følgende elementer i korrekt rekkefølge';
$string['draggableitemno'] = 'Dragbart element {no}';
$string['draggableitems'] = 'Drabare elementer';
$string['duplicatesnotallowed'] = 'Duplisering av drabare elementer er ikke tillatt. Strengen «{$a->text}» brukes allerede i {$a->item}.';
$string['editingordering'] = 'Rediger sorteringsspørsmål';
$string['gradedetails'] = 'Karakterdetaljer';
$string['gradingtype'] = 'Vurderingstype';
$string['gradingtype_help'] = '**Alt eller ingenting**
&nbsp; Hvis alle elementene er i riktig posisjon, gis full poengsum. Ellers er poengsummen null.

**Absolutt posisjon**
&nbsp; Et element anses som riktig hvis det er i samme posisjon som i det riktige svaret. Den høyeste mulige poengsummen for spørsmålet er **den samme som** antall elementer som vises til studenten.

**Relativt til riktig posisjon**
&nbsp; Et element anses som riktig hvis det er i samme posisjon som i det riktige svaret. Riktige elementer får en poengsum lik antall elementer som vises minus én. Feil elementer får en poengsum lik antall elementer som vises minus én og minus avstanden til elementet fra riktig posisjon. Hvis ***n*** elementer vises til studenten, er antall poeng tilgjengelig for hvert element ***(n - 1)***, og den høyeste poengsummen tilgjengelig for spørsmålet er ***n x (n - 1)***, som er det samme som ***(n² - n)***.

**Relativt til neste element (unntatt siste)**
&nbsp; Et element anses som riktig hvis det etterfølges av det samme elementet som det er i det riktige svaret. Elementet på siste posisjon blir ikke sjekket. Dermed er den høyest mulige poengsummen for spørsmålet **én mindre enn** antallet elementer som vises til studenten.

**I forhold til både forrige og neste element**
&nbsp; Et element anses som riktig hvis både forrige og neste element er de samme som i det riktige svaret. Det første elementet skal ikke ha noe forrige element, og det siste elementet skal ikke ha noe neste element. Dermed er det to mulige poeng for hvert element, og den høyeste mulige poengsummen for spørsmålet er **dobbelt** så mange elementer som vises til studenten.

**I forhold til ALLE forrige og neste elementer**
&nbsp; Et element anses som riktig hvis det innledes av alle de samme elementene som det er i det riktige svaret, og det etterfølges av alle de samme elementene som det er i det riktige svaret. Rekkefølgen på de forrige elementene spiller ingen rolle, og det gjør heller ikke rekkefølgen på de følgende elementene. Hvis ***n*** elementer vises til studenten, er antall poeng tilgjengelig for hvert element ***(n - 1)***, og den høyeste poengsummen tilgjengelig for spørsmålet er ***n x (n - 1)***, som er det samme som ***(n² - n)***.

**Lengst ordnede delmengde**
Karakteren er antall elementer i det lengst ordnede delmengden av elementer. Den høyest mulige karakteren er den samme som antall elementer som vises. Et delmengde må ha minst to elementer. Delmengder trenger ikke å starte med det første elementet (men de kan), og de trenger ikke å være sammenhengende (men de kan være det). Der det er flere delmengder med samme lengde, vil elementer i delmengden som blir funnet først, når du søker fra venstre til høyre, vises som riktige. Andre elementer vil bli merket som feil.

**Lengste sammenhengende delmengde**
Karakteren er antall elementer i det lengste sammenhengende delmengden av elementer. Den høyest mulige karakteren er den samme som antall elementer som vises. Et delmengde må ha minst to elementer. Delmengder trenger ikke å starte med det første elementet (men de kan), og de MÅ VÆRE SAMMENHENGIGE. Der det er flere delmengder med samme lengde, vil elementer i delmengden som finnes først, når du søker fra venstre til høyre, vises som riktige. Andre elementer vil bli merket som feil.';
$string['highlightresponse'] = 'Merk svar som korrekt eller feil';
$string['horizontal'] = 'Horisontalt';
$string['incorrectitemsnumber'] = 'Feil elementer: {$a}';
$string['layouttype'] = 'Plassering av elementer';
$string['layouttype_help'] = 'Om elementene skal vises horisontalt eller vertikalt';
$string['longestcontiguoussubset'] = 'Lengste sammenhengende delmengde';
$string['longestorderedsubset'] = 'Lengste sorterte delmengde';
$string['moved'] = '{$a->item} flyttet. Ny posisjon: {$a->position} av {$a->total}.';
$string['moveleft'] = 'Flytt til venstre';
$string['moveright'] = 'Flytt til høyre';
$string['noresponsedetails'] = 'Beklager, ingen svardetaljer for dette spørsmålet er tilgjengelig';
$string['noscore'] = 'Intet resultat';
$string['notenoughanswers'] = 'Sorteringsspørsmål må ha mer enn {$a} svar.';
$string['notenoughsubsetitems'] = 'En delmengde må ha minste {$a} elementer.';
$string['numberingstyle'] = 'Numrer valgene?';
$string['numberingstyle123'] = '1., 2., 3., ...';
$string['numberingstyleABCD'] = 'A., B., C., ...';
$string['numberingstyleIIII'] = 'I., II., III., ...';
$string['numberingstyle_desc'] = 'Standard numrering';
$string['numberingstyle_help'] = 'Velg nummereringsstil for drabare elementer i dette spørsmålet.';
$string['numberingstyleabc'] = 'a., b., c., ...';
$string['numberingstyleiii'] = 'i., ii., iii., ...';
$string['numberingstylenone'] = 'Ingen numrering';
$string['partialitemsnumber'] = 'Delvis riktige elementer: {$a}';
$string['pluginname'] = 'Sortering';
$string['pluginname_help'] = 'Flere elementer vises i en rotete rekkefølge. Elementene kan dras til riktig rekkefølge.';
$string['pluginname_link'] = 'question/type/ordering';
$string['pluginnameadding'] = 'Legger til sorteringsspørsmål';
$string['pluginnameediting'] = 'Redigerer sorteringsspørsmål';
$string['pluginnamesummary'] = 'Plasser elementene i korrekt rekkefølge.';
$string['positionx'] = 'Posisjon {$a}';
$string['privacy:preference:gradingtype'] = 'Vurderingstype';
$string['privacy:preference:layouttype'] = 'Elementoppsett';
$string['privacy:preference:numberingstyle'] = 'Numreringsstil for alternativer';
$string['privacy:preference:selectcount'] = 'Antall valgte';
$string['privacy:preference:selecttype'] = 'Elementsvalgtype';
$string['privacy:preference:showgrading'] = 'Om karakterdetaljer skal vises';
$string['regradeissuenumitemschanged'] = 'Antall dragbare elementer er endret.';
$string['relativeallpreviousandnext'] = 'Relativt til alle tidligere og kommende elementer';
$string['relativenextexcludelast'] = 'Relativt til neste element (unntatt siste)';
$string['relativenextincludelast'] = 'Relativt til neste element (inkludert siste)';
$string['relativeonepreviousandnext'] = 'Relativt til både forrige og neste element';
$string['relativetocorrect'] = 'Relativt til korrekt posisjon';
$string['removeeditor'] = 'Fjern HTML-editor';
$string['removeitem'] = 'Fjern dragbart element';
$string['scoredetails'] = 'Her er poengsummene for hvert element i dette svaret:';
$string['selectall'] = 'Velg alle';
$string['selectcontiguous'] = 'Velg en sammenhengde delmengde med elementer';
$string['selectcount'] = 'Størrelse av delmengde';
$string['selectcount_help'] = 'Antall elementer som skal vises når spørsmålet er med i en quiz.';
$string['selectrandom'] = 'Velg en tilfeldig delmengde med elementer';
$string['selecttype'] = 'Elementvalgtype';
$string['selecttype_help'] = 'Velg om alle elementer skal vises eller bare en delmengde.';
$string['showgrading'] = 'Vurderingsdetaljer';
$string['showgrading_help'] = 'Velg om du vil vise eller skjule detaljer om poengsumberegningen når en student gjennomgår et svar på dette sorteringsspørsmålet.';
$string['vertical'] = 'Vertikalt';
