<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'ja', version '4.4'.
 *
 * @package     grades
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = '活動';
$string['addcategory'] = 'カテゴリを追加する';
$string['addcategoryerror'] = 'カテゴリを追加できませんでした。';
$string['addexceptionerror'] = 'userid:gradeitemの例外追加中にエラーが発生しました。';
$string['addfeedback'] = 'フィードバックを追加する';
$string['addgradeletter'] = '評定文字を追加する';
$string['addidnumbers'] = 'IDナンバを追加する';
$string['additem'] = '評定項目を追加する';
$string['additionalfeedback'] = '追加フィードバック';
$string['addoutcome'] = 'アウトカムを追加する';
$string['addoutcomeitem'] = 'アウトカム項目を追加する';
$string['addscale'] = '評価尺度を追加する';
$string['adjustedweight'] = '加重調整';
$string['aggregateextracreditmean'] = '評点の平均値 (追加点扱い)';
$string['aggregatemax'] = '評点の最大値';
$string['aggregatemean'] = '評点の平均値';
$string['aggregatemedian'] = '評点の中央値';
$string['aggregatemin'] = '評点の最小値';
$string['aggregatemode'] = '評点の最頻値';
$string['aggregatenotonlygraded'] = '空白の評点を含む';
$string['aggregateonlygraded'] = '空白の評点を除く';
$string['aggregateonlygraded_help'] = '空白の評点は評定表に存在しない評点です。これにはまだ評定されていない送信済み課題、または受験されていない小テスト等が考えられます。

この設定では空白の評点が総計に含まれるか、または最小評点としてカウントされるか決定します。例えば課題のゼロは0から100の間で評定されます。';
$string['aggregateoutcomes'] = '総計にアウトカムを含む';
$string['aggregateoutcomes_help'] = 'この設定を有効にした場合、アウトカムが総計に含まれます。これで望ましいカテゴリ合計にならない場合があります。';
$string['aggregatesonly'] = '総計のみ表示する';
$string['aggregatesubcatsupgradedgrades'] = '注意: 総計設定「総計にサブカテゴリを含む」はサイトアップグレードの一環として削除されました。以前このコースで「総計にサブカテゴリを含む」が使用されていたため、評定表内でのこの変更を確認お勧めします。';
$string['aggregatesum'] = '自然';
$string['aggregateweightedmean'] = '評点の加重平均値';
$string['aggregateweightedmean2'] = '評点の単純加重平均値';
$string['aggregation'] = '総計';
$string['aggregation_help'] = '総計ではカテゴリ内の評点がどのように組み合わされるか以下のように決定します。

* 評点の平均値 - すべての評点の合計が評点の合計数で除算されます。
* 評点の中央値 - 評点が大きさの順で並べられる場合の中央の評点です。
* 評点の最小値
* 評点の最大値
* 評点の最頻値 - 最も頻繁に発生する評点です。
* 自然 - 加重により調整された評点すべての合計です。';
$string['aggregation_link'] = 'grade/aggregation';
$string['aggregationcoef'] = '総計係数';
$string['aggregationcoefextra'] = '追加点';
$string['aggregationcoefextra_help'] = '総計において「自然」または「評点の単純加重平均」および追加点チェックボックスがチェックされた場合、評定項目の最大評点はカテゴリの最大評点に追加されません。結果として、すべての評定項目の最大評点に到達することなくカテゴリの最大評点に到達できるようになります。 サイト管理者が最大評点を超えた評点を有効にした場合、評点は最大評点を越す可能性があります。

総計において「評点の単純平均 (追加点扱い)」および追加点にゼロより大きな値が設定された場合、平均計算の後、合計に追加される前、追加点は評点に掛けられる因数となります。';
$string['aggregationcoefextra_link'] = 'grade/aggregation';
$string['aggregationcoefextrasum'] = '追加点';
$string['aggregationcoefextrasum_help'] = '追加点チェックボックスがチェックされた場合、評定項目の最大評点はカテゴリの最大評点に追加されません。結果として、すべての評定項目の最大評点に到達達することなくカテゴリの最大評点 (またはサイト管理者が有効にした場合、最大評点を超えた値) に到達できるようになります。';
$string['aggregationcoefextrasum_link'] = 'grade/aggregation';
$string['aggregationcoefextrasumabbr'] = '+';
$string['aggregationcoefextraweight'] = '追加点加重';
$string['aggregationcoefextraweight_help'] = '追加点加重にゼロより大きな値が設定された場合、評点は総計中に追加点として動作します。数値は平均計算の合計に追加される前に評点が乗算される場合の倍数です。';
$string['aggregationcoefextraweight_link'] = 'grade/aggregation';
$string['aggregationcoefweight'] = '評定項目の加重';
$string['aggregationcoefweight_help'] = '評定項目の加重は同一カテゴリ内での他の評定項目に対する評価項目の重要性に影響を与えるためにカテゴリ総計で使用されます。';
$string['aggregationcoefweight_link'] = 'grade/aggregation';
$string['aggregationhintdropped'] = '( 除外)';
$string['aggregationhintexcluded'] = '( 除外)';
$string['aggregationhintextra'] = '(追加点扱い)';
$string['aggregationhintnovalue'] = '( 空白 )';
$string['aggregationofa'] = '{$a} の総計';
$string['aggregationposition'] = '総計の位置';
$string['aggregationposition_help'] = 'この設定ではカテゴリおよびコース合計カラムが評定表レポートの最初に表示されるか、最後に表示されるか決定します。';
$string['aggregationsvisible'] = '利用可能な総計タイプ';
$string['aggregationsvisiblehelp'] = 'すべての利用可能な総計タイプを選択してください。複数アイテムを選択するにはCTRLキーを押したままにしてください。';
$string['allgrades'] = 'すべてのカテゴリごとの評点';
$string['allstudents'] = 'すべての学生';
$string['allusers'] = 'すべてのユーザ';
$string['aria-toggledropdown'] = '以下のドロップダウンを切り替える';
$string['aria:dropdowngrades'] = '評定項目が見つかりました。';
$string['autosort'] = '自動並べ替え';
$string['availableidnumbers'] = '利用可能なIDナンバ';
$string['average'] = '平均';
$string['averagesdecimalpoints'] = 'カラム平均の小数点以下桁数';
$string['averagesdecimalpoints_help'] = 'この設定ではそれぞれの平均点に表示される小数位以下桁数、または全体のカテゴリ設定または評定項目で全体の小数位設定を使用 (継承) するかどうか決定します。';
$string['averagesdisplaytype'] = 'カラム平均の表示タイプ';
$string['averagesdisplaytype_help'] = 'この設定では実評点、パーセンテージまたは評価文字として平均が表示されるか、またはカテゴリまたは評定項目の表示タイプを使用 (継承) するかどうか決定します。';
$string['backupwithoutgradebook'] = 'バックアップには評定表設定を含みません。';
$string['badgrade'] = '提供された評定は有効ではありません。';
$string['badlyformattedscale'] = 'カンマ区切りの値のリストを入力してください (少なくと2つの設定値が必要です)。';
$string['baduser'] = '提供されたユーザは有効ではありません。';
$string['bonuspoints'] = 'ボーナスポイント';
$string['bulkcheckboxes'] = 'バルクチェックボックス';
$string['calculatedgrade'] = '計算済み評定';
$string['calculation'] = '計算';
$string['calculation_help'] = '評定計算は評定の決定に使用される公式です。公式は等号 (=) で始まり、max、minおよびsumのような一般的な数学演算子が使用されます。必要であれば、2重角括弧に入れたIDナンバを使用して他の評定項目を計算に含むことができます。';
$string['calculation_link'] = 'grade/calculation';
$string['calculationadd'] = '計算を追加する';
$string['calculationedit'] = '計算を編集する';
$string['calculationsaved'] = '計算が保存されました。';
$string['calculationview'] = '計算を表示する';
$string['calculationwarning'] = 'このカテゴリは総計ではなくカテゴリ合計に評点計算を使用します。';
$string['cannotaccessgroup'] = '申し訳ございません、選択したグループの評定にアクセスできません。';
$string['categories'] = 'カテゴリ';
$string['category'] = 'カテゴリ';
$string['categoryedit'] = 'カテゴリを編集する';
$string['categoryname'] = 'カテゴリ名';
$string['categorytotal'] = 'カテゴリ合計';
$string['categorytotalfull'] = '{$a->category} 合計';
$string['categorytotalname'] = 'カテゴリ合計名';
$string['changedefaults'] = 'デフォルトを変更する';
$string['changereportdefaults'] = 'レポートデフォルトを変更する';
$string['chooseaction'] = '処理を選択する ...';
$string['choosecategory'] = 'カテゴリを選択する';
$string['collapsecriterion'] = 'クライテリアを折りたたむ';
$string['compact'] = 'コンパクト';
$string['componentcontrolsvisibility'] = 'この評定項目を秘匿するかどうか活動設定によりコントロールされます。';
$string['contract'] = 'カテゴリを縮小する';
$string['contributiontocoursetotal'] = 'コース合計への寄与';
$string['controls'] = 'コントロール';
$string['courseavg'] = 'コース平均';
$string['coursegradecategory'] = 'コース評定カテゴリ';
$string['coursegradedisplaytype'] = 'コース評定表示タイプ';
$string['coursegradedisplayupdated'] = 'コース評定表示タイプが更新されました。';
$string['coursegradesettings'] = 'コース評定設定';
$string['coursename'] = 'コース名';
$string['coursescales'] = 'コース評価尺度';
$string['coursesettings'] = 'コース設定';
$string['coursesettingsexplanation'] = 'コース評定設定ではすべての参加者に対して評定表がどのように表示されるか決定します。';
$string['coursesiamtaking'] = '私が受講しているコース';
$string['coursesiamteaching'] = '私が教えているコース';
$string['coursetotal'] = 'コース合計';
$string['createcategory'] = 'カテゴリを作成する';
$string['createcategoryerror'] = '新しいカテゴリを作成できませんでした。';
$string['creatinggradebooksettings'] = '評定表設定の作成';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = '現在の親の総計';
$string['curveto'] = 'みなし満点';
$string['decimalpoints'] = '全体の小数位';
$string['decimalpoints_help'] = 'この設定ではそれぞれの評定に表示する小数位以下桁数を決定します。小数位5桁の精度の評定計算に影響はありません。';
$string['default'] = 'デフォルト';
$string['defaultprev'] = 'デフォルト ({$a})';
$string['deletecategory'] = 'カテゴリを削除する';
$string['deletescale'] = '尺度を削除する';
$string['disablegradehistory'] = '評定履歴を無効にする';
$string['disablegradehistory_help'] = '評定関連テーブルの変更履歴のトラッキングを無効にします。この設定によりサーバの速度を少しだけ向上させて、データベースの使用量を節約できます。';
$string['displaylettergrade'] = '評定文字を表示する';
$string['displaypercent'] = 'パーセントを表示する';
$string['displaypoints'] = '評点を表示する';
$string['displayweighted'] = '加重評点を表示する';
$string['droplow'] = '最低評点の除外件数';
$string['droplow_help'] = 'この設定を有効にした場合、指定した件数の最低評点が総計から除外されます。';
$string['droplowestvalue'] = '最低評点の除外件数を設定する';
$string['droplowestvalues'] = '{$a} 件の最低評点を除外する';
$string['dropped'] = '件除外';
$string['dropxlowest'] = '下位X件の除外';
$string['dropxlowestwarning'] = '注意: 「下位X件の除外」を使用する場合、カテゴリ内のすべての評定項目は同じ最大評点を持つとみなされます。カテゴリ内のそれぞれの評定項目の最大評点が異なる場合、結果は保証されません。';
$string['duplicatedgradeitem'] = '{$a} (コピー)';
$string['duplicatescale'] = '尺度の複製';
$string['edit'] = '編集';
$string['editcalculation'] = '計算を編集する';
$string['editcalculationverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname} の計算を編集する';
$string['editfeedback'] = 'フィードバックを編集する';
$string['editgrade'] = '評定を編集する';
$string['editgradeletters'] = '評定文字を編集する';
$string['editoutcome'] = 'アウトカムを編集する';
$string['editoutcomes'] = 'アウトカムを編集する';
$string['editscale'] = '評価尺度を編集する';
$string['edittree'] = '設定';
$string['editverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname} を編集する';
$string['enableajax'] = 'AJAXを有効にする';
$string['enableajax_help'] = '一般的な操作を単純化および高速化するAJAX機能のレイヤを評定者レポートに追加します。ユーザのブラウザレベルでJavaScriptが有効にされているかどうかに依存します。';
$string['enableoutcomes'] = 'アウトカムを有効にする';
$string['enableoutcomes_help'] = 'この設定を有効にした場合、アウトカム記述に関する１つ以上の評価尺度を使用して評定項目を評定できます。';
$string['encoding'] = 'エンコーディング';
$string['encoding_help'] = 'データの使用する文字エンコーディングを選択してください (標準的なエンコーディングはUTF-8です)。間違って正しくないエンコーディングが選択された場合、インポートデータのプレビュー時に簡単に確認できます。';
$string['errorcalculationbroken'] = '評定項目 {$a} の計算にエラーが発生しました。';
$string['errorcalculationnoequal'] = '式は等号 (=1+2) で開始してください。';
$string['errorcalculationunknown'] = '式が正しくありません。';
$string['errorgradevaluenonnumeric'] = '上限または下限の評点が数値ではありません:';
$string['errornocalculationallowed'] = 'この項目の計算は許可されていません。';
$string['errornocategorisedid'] = 'カテゴリなしIDを取得できませんでした!';
$string['errornocourse'] = 'コース情報を取得できませんでした。';
$string['erroroverweight'] = '加重合計が100%を超えています。';
$string['errorreprintheadersnonnumeric'] = 'ヘッダ再表示の値が数値ではありません:';
$string['errorsavegrade'] = '申し訳ございません、評定を保存できませんでした。';
$string['errorsettinggrade'] = 'ユーザID「 {$a->userid} 」の「 {$a->itemname} 」評点保存中にエラーが発生しました。';
$string['errorunderweight'] = '加重合計が100%未満です。';
$string['errorupdatinggradecategoryaggregateonlygraded'] = '評定カテゴリID {$a->id} の「空白ではない評点のみ総計する」設定更新中にエラーが発生しました。';
$string['errorupdatinggradecategoryaggregateoutcomes'] = '評定カテゴリID {$a->id} の「総計にアウトカムを含む」設定更新中にエラーが発生しました。';
$string['errorupdatinggradecategoryaggregation'] = '評定カテゴリID {$a->id} の総計タイプ更新中にエラーが発生しました。';
$string['errorupdatinggradeitemaggregationcoef'] = '評定カテゴリID {$a->id} の総計係数 (加重または追加点) 更新中にエラーが発生しました。';
$string['eventgradedeleted'] = '評定が削除されました。';
$string['eventgradeexported'] = '評定がエクスポートされました。';
$string['eventgradeitemcreated'] = '評定項目が作成されました。';
$string['eventgradeitemdeleted'] = '評定項目が削除されました。';
$string['eventgradeitemupdated'] = '評定項目が更新されました。';
$string['eventgradelettercreated'] = '評定文字が作成されました。';
$string['eventgradeletterdeleted'] = '評定文字が削除されました。';
$string['eventgradeletterupdated'] = '評定文字が更新されました。';
$string['eventgradeviewed'] = '評定表の評定が閲覧されました。';
$string['eventscalecreated'] = '尺度が作成されました。';
$string['eventscaledeleted'] = '尺度が削除されました。';
$string['eventscaleupdated'] = '尺度が更新されました。';
$string['eventusergraded'] = 'ユーザが評定されました。';
$string['excluded'] = '除外';
$string['excluded_help'] = 'この設定が有効にされた場合、評点はすべての総計から除外されます。';
$string['expand'] = 'カテゴリを展開する';
$string['expandcriterion'] = 'クライテリアを展開する';
$string['export'] = 'エクスポート';
$string['exportalloutcomes'] = 'すべてのアウトカムをエクスポートする';
$string['exportas'] = 'エクスポート形式:';
$string['exportfeedback'] = 'エクスポートにフィードバックを含む';
$string['exportfeedback_desc'] = 'これはエクスポート中にオーバーライドできます。';
$string['exportformatoptions'] = 'エクスポートフォーマットオプション';
$string['exportonlyactive'] = '一時停止ユーザを除く';
$string['exportonlyactive_help'] = '登録が有効で一時停止されていない学生のみエクスポートに含めます。';
$string['exportplugins'] = 'プラグインをエクスポートする';
$string['exportsettings'] = 'エクスポート設定';
$string['exportto'] = 'エクスポート先';
$string['externalurl'] = '外部URL';
$string['externalurl_desc'] = '外部評定表を使用する場合、URLをここに指定する必要があります。';
$string['extracreditvalue'] = '{$a} の追加点';
$string['extracreditwarning'] = 'メモ: カテゴリ内すべての評定項目を追加点扱いにすることで評定計算から評定項目を効果的に除外できます。以後、評点合計は計算されません。';
$string['fail'] = '不合格';
$string['feedback'] = 'フィードバック';
$string['feedback_help'] = 'このボックスに評定に関するコメントを追加できます。';
$string['feedbackadd'] = 'フィードバックを追加する';
$string['feedbackedit'] = 'フィードバックを編集する';
$string['feedbackfiles'] = 'フィードバックファイル';
$string['feedbackforgradeitems'] = '{$a} のフィードバック';
$string['feedbackhistoryfiles'] = 'フィードバック履歴ファイル';
$string['feedbackprovided'] = 'フィードバック提供';
$string['feedbacks'] = 'フィードバック';
$string['feedbacksaved'] = 'フィードバックが保存されました。';
$string['feedbackview'] = 'フィードバックを表示する';
$string['filterbothactive'] = '姓 ({$a->last}) 名 ({$a->first})';
$string['filterbyname'] = '氏名でフィルタする';
$string['filterfirstactive'] = '名 ({$a->first})';
$string['filterlastactive'] = '姓 ({$a->last})';
$string['finalgrade'] = '最終評点';
$string['finalgrade_help'] = 'オーバーライドチェックボックスがチェックされた場合、評点を追加または修正できます。';
$string['fixedstudents'] = '固定学生カラム';
$string['fixedstudents_help'] = '学生カラムを見失わないようにするため、評定を固定して横方向にスクロールできるようにします。';
$string['forceimport'] = 'インポートを強制する';
$string['forceimport_help'] = 'インポートファイルのエクスポート後に評点が更新された場合でも、評点を強制的にインポートします。';
$string['forceoff'] = '強制: Off';
$string['forceon'] = '強制: On';
$string['forelementtypes'] = '作成対象: {$a}';
$string['forstudents'] = '学生に対して';
$string['full'] = 'フル';
$string['fullmode'] = '評点および総計を表示する';
$string['generalsettings'] = '一般設定';
$string['grade'] = '評定';
$string['grade_help'] = 'この学生の取り組みに与えられた評点です。';
$string['gradeadministration'] = '評定管理';
$string['gradealreadyupdated'] = 'インポートファイルの評定が評定者レポートより古いため、{$a} の評定はインポートされませんでした。どうしても評定インポートを続行したい場合、強制インポートオプションを使用してください。';
$string['gradeanalysis'] = '評定分析';
$string['gradebook'] = '評定表';
$string['gradebookcalculationsfixbutton'] = '評点変更を受け入れて計算エラーを修正する';
$string['gradebookcalculationsuptodate'] = '評定表の計算は最新です。変更を表示するにはあなたはこのページをリロードする必要があります。';
$string['gradebookcalculationswarning'] = '注意: 評定表に表示されている評点の計算にエラーが検出されました。あなたのコースが開始していない場合または進行中の場合、結果としていくつかの評点が変更されることになりますが、以下のボタンをクリックしてエラーの修正をお勧めします。コースがすでに終了して評点が送信されている場合、あなたは恐らくこの問題を修正したくないことでしょう。

新しいバージョンは {$a->currentversion} です。あなたはバージョン {$a->gradebookversion} の評定表を使用しています。あなたは<a href="{$a->url}">評定表計算変更</a>で変更一覧を確認できます。';
$string['gradebookhiddenerror'] = '現在、評定表は学生からすべて秘匿するよう設定されています。';
$string['gradebookhistories'] = '評定履歴';
$string['gradebooknavigationmenu'] = '評定表ナビゲーションメニュー';
$string['gradebooksetup'] = '評定表セットアップ';
$string['gradeboundary'] = '評定文字の境界';
$string['gradeboundary_help'] = 'この設定では評定文字に割り当てる評点の最小パーセンテージを決定します。';
$string['gradecategories'] = '評定カテゴリ';
$string['gradecategory'] = '評定カテゴリ';
$string['gradecategoryonmodform'] = '評定カテゴリ';
$string['gradecategoryonmodform_help'] = 'この設定ではこの活動の評定が掲載される評定表内のカテゴリを管理します。';
$string['gradecategorysettings'] = '評定カテゴリ設定';
$string['gradedisplay'] = '評定表示';
$string['gradedisplaytype'] = '評定表示タイプ';
$string['gradedisplaytype_help'] = 'この設定では評定者およびユーザレポートにおいて評点がどのように表示されるか決定します。

* 文字 - 評定表セットアップで定義された「文字」の評定の範囲を示す文字または言葉です。
* パーセンテージ - 最大および最小評点間の相対値です。
* 実 - 実際の評点または尺度値です。';
$string['gradedon'] = '評定日時: {$a}';
$string['gradeexport'] = '評定エクスポート';
$string['gradeexportcolumntype'] = '{$a->name} ({$a->extra})';
$string['gradeexportcustomprofilefields'] = '評定エクスポート - カスタムプロファイルフィールド';
$string['gradeexportcustomprofilefields_desc'] = 'これらのカスタムプロファイルフィールド (カンマ区切り) を評定エクスポートに含めます。';
$string['gradeexportdecimalpoints'] = '評定エクスポート - 小数位';
$string['gradeexportdecimalpoints_desc'] = 'エクスポートに表示する小数位以下桁数です。この値はエクスポート時にオーバーライドすることができます。';
$string['gradeexportdisplaytype'] = '評定エクスポート - 表示タイプ';
$string['gradeexportdisplaytype_desc'] = '評定を実データ、パーセンテージ (最小および最大評点に関して) または文字 (A、B、C等..) で表示できます。この値はエクスポート時にオーバーライドできます。';
$string['gradeexportdisplaytypes'] = '評定エクスポート表示タイプ';
$string['gradeexportuserprofilefields'] = '評定エクスポート - ユーザプロファイルフィールド';
$string['gradeexportuserprofilefields_desc'] = 'これらのユーザプロファイルフィールド (カンマ区切り) を評定エクスポートに含めます。';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}$a->feedback';
$string['gradegrademinmax'] = '初期最小および最大評点';
$string['gradehelp'] = '評定ヘルプ';
$string['gradehistorylifetime'] = '評定履歴保存期間';
$string['gradehistorylifetime_help'] = 'ここでは評定に関連するテーブル履歴の保存期間を指定します。可能な限り長い期間の保存をお勧めします。あなたがパフォーマンスに関する問題を経験した場合、またはデータベース領域が制限されている場合、この値を小さくしてください。';
$string['gradeimport'] = '評定インポート';
$string['gradeimportfailed'] = '実行中に評定インポートに失敗しました。詳細:';
$string['gradeitem'] = '評定項目';
$string['gradeitemaddusers'] = '評定から除外する';
$string['gradeitemadvanced'] = '高度な評定項目オプション';
$string['gradeitemadvanced_help'] = '評定項目編集時に詳細項目として表示されるすべての構成要素を選択してください。';
$string['gradeitemislocked'] = 'この活動は評定表でロックされています。評定表のロックが解除されるまで、この活動の評定変更は評定表にコピーされません。';
$string['gradeitemlocked'] = '評定ロック中';
$string['gradeitemmembersselected'] = '評定から除外する';
$string['gradeitemminmax'] = '評定項目設定で指定された最小および最大評点';
$string['gradeitemnonmembers'] = '評定対象とする';
$string['gradeitemremovemembers'] = '評定対象とする';
$string['gradeitems'] = '評定項目';
$string['gradeitemsettings'] = '評定項目設定';
$string['gradeitemsinc'] = 'エクスポートに含まれる評定項目';
$string['gradeletter'] = '評定文字';
$string['gradeletter_help'] = '評定文字は評点の範囲を表す文字「A, B, C, ..., 」または単語 (例 優, 良, 可, ...,) です。';
$string['gradeletternote'] = '評定文字を削除するにはテキストエリアの文字を<br />空白にして「変更を保存する」をクリックしてください。';
$string['gradeletteroverridden'] = '現在、デフォルト評定文字はオーバーライドされています。';
$string['gradeletters'] = '評定文字';
$string['gradelocked'] = '評定はロックされています。';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = '最大評点';
$string['grademax_help'] = 'この設定では評定タイプ「値」使用する場合の最大評点を決定します。活動ベースの評定項目の最大評点は活動設定ページで設定します。';
$string['grademin'] = '最小評点';
$string['grademin_help'] = 'この設定では評定タイプ「値」を使用する場合の最小評点を決定します。';
$string['gradenotificationmessage'] = 'あなたの「 {$a} 」に新しいフィードバックがあります。';
$string['gradenotificationsubject'] = 'あなたは評定されました。';
$string['gradeoutcomeitem'] = '評定アウトカム項目';
$string['gradeoutcomes'] = 'アウトカム';
$string['gradeoutcomescourses'] = 'コースアウトカム';
$string['gradepass'] = '合格点';
$string['gradepass_help'] = 'この設定では合格に必要な最小評点を決定します。値は活動、コース完了および評定表で使用されます。また合格は緑色、不合格は赤色にハイライトされます。';
$string['gradepassgreaterthangrade'] = '合格点は最大可能評点 {$a} を超えることはできません。';
$string['gradepointdefault'] = '評点デフォルト';
$string['gradepointdefault_help'] = 'この設定では評定項目で利用できる評点デフォルト値を決定します。';
$string['gradepointdefault_validateerror'] = 'この設定は1から最大評点までの整数にする必要があります。';
$string['gradepointmax'] = '最大評点';
$string['gradepointmax_help'] = 'この設定は活動内で利用できる最大評点を決定します。';
$string['gradepointmax_validateerror'] = 'この設定は1から10000までの整数である必要があります。';
$string['gradepreferences'] = '評定プレファレンス';
$string['gradepreferenceshelp'] = '評定プレファレンスヘルプ';
$string['gradepublishing'] = '公開を有効にする';
$string['gradepublishing_help'] = '評定公開はMoodleにログインせずにURL経由で評定をインポートおよびエクスポートする方法です。この設定を有効にした場合、管理者および評定を公開できるパーミッションのあるユーザ (デフォルトではマネージャロールのユーザのみ) にはそれぞれのコースの評定表に評定エクスポート公開設定が提供されます。';
$string['gradepublishinglink'] = 'ダウンロード: {$a}';
$string['gradereport'] = '評定レポート';
$string['graderreport'] = '評定者レポート';
$string['grades'] = '評定';
$string['gradesforuser'] = '{$a->user} の評点';
$string['gradesmoduledeletionpendingwarning'] = '警告: 活動の削除中です! いくつかの評定が削除されます。';
$string['gradesmoduledeletionprefix'] = '[削除中]';
$string['gradesonly'] = '評点のみ表示する';
$string['gradessettings'] = '評定設定';
$string['gradetype'] = '評定タイプ';
$string['gradetype_help'] = '4種類の評定タイプがあります:

* なし - 評定不可
* 値 - 最大および最小の数値
* 尺度 - リスト内の項目
* テキスト - フィードバックのみ

値および尺度評定タイプのみ合計できます。活動ベースの評定項目は活動の更新ページで設定します。';
$string['gradevaluetoobig'] = '許可された最大評点  {$a} を評点の1つが超えています。';
$string['gradevaluetoosmall'] = '評定値のいずれかが許可される {$a} の評点最小値より小さくなっています。';
$string['gradeview'] = '評定を表示する';
$string['gradewasmodifiedduringediting'] = '最近他のユーザにより更新されたため、入力された {$a->itemname} に関する {$a->username} の評点は無視されました。';
$string['gradeweighthelp'] = '評定加重ヘルプ';
$string['gradingmodulename'] = '評定 ({$a})';
$string['groupavg'] = 'グループ平均';
$string['hidden'] = '隠す';
$string['hidden_help'] = 'この設定を有効にした場合、学生から評定が秘匿されます。評定完了後に評定を公開するため、必要に応じて「次の日時まで隠す」を設定できます。';
$string['hiddenasdate'] = '隠し評定項目の登録日時を表示する';
$string['hiddenasdate_help'] = '隠し評定項目をユーザが閲覧できない場合、「-」の代わりに評定登録日時を表示します。';
$string['hiddenuntil'] = '次の日時まで隠す';
$string['hiddenuntildate'] = '次の日時まで隠す: {$a}';
$string['hideadvanced'] = '拡張機能を隠す';
$string['hideaverages'] = '平均を隠す';
$string['hidecalculations'] = '計算を隠す';
$string['hidecategory'] = '隠す';
$string['hideeyecons'] = '表示/非表示アイコンを隠す';
$string['hidefeedback'] = 'フィードバックを隠す';
$string['hideforcedsettings'] = '強制設定を隠す';
$string['hideforcedsettings_help'] = '強制設定を評定UIに表示しません。';
$string['hidegroups'] = 'グループを隠す';
$string['hidelocks'] = 'ロックを隠す';
$string['hidenooutcomes'] = 'アウトカムを表示する';
$string['hidequickfeedback'] = 'クイックフィードバックを隠す';
$string['hideranges'] = '範囲を隠す';
$string['hidetotalifhiddenitems'] = '隠し評定項目が含まれている場合、合計を隠す';
$string['hidetotalifhiddenitems_help'] = 'この設定では隠し評定項目が含まれている場合、学生に合計を表示するか、ハイフン (-) で置換するか指定します。表示する場合、合計に隠し評定項目を含めて計算することも、除外して計算することもできます。

隠し評定項目を除外する場合、表示または非表示に係わらず教師は常に項目すべての計算された合計を閲覧できるため、この場合、教師に表示される評定者レポート内の合計とは異なります。隠し評定項目を含める場合、学生は隠し評定項目を計算できるかもしれません。';
$string['hidetotalshowexhiddenitems'] = '隠し評定項目を除外して合計を表示する';
$string['hidetotalshowinchiddenitems'] = '隠し評定項目を含めて合計を表示する';
$string['hideverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname} を隠す';
$string['highgradeascending'] = '高評点の昇順で並べ替える';
$string['highgradedescending'] = '高評点の降順で並べ替える';
$string['highgradeletter'] = '上限';
$string['identifier'] = 'ユーザ識別方法:';
$string['idnumbers'] = 'IDナンバ';
$string['ignore'] = '無視';
$string['import'] = 'インポート';
$string['importas'] = 'インポート形式:';
$string['importcsv'] = 'CSVをインポートする';
$string['importcsv_help'] = '以下のフォーマットのCSVファイルを使用して評定をインポートできます:

* ファイルのそれぞれの行には1レコードを含めてださい。
* それぞれのレコードは選択されたセパレータで区切られた一連のデータです。
* 先頭レコードにはファイルの残りのフォーマットを定義するフィールド名一覧を含みます。
* ユーザ識別データを含むフィールド名 (ユーザ名、IDナンバまたはメールアドレス) は必須です。

最初に評定をエクスポートして正しいフォーマットのファイルを取得できます。そのファイルを編集してCSVファイルとして保存できます。';
$string['importcsv_link'] = 'grade/import/csv/index';
$string['importcustom'] = 'カスタムアウトカムとしてインポートする (このコースのみ)';
$string['importdata'] = 'データ';
$string['importdata_help'] = '評定はOpenDocumentまたはExcelスプレッドシートから直接貼り付けることができます。

* 少なくとも1つの列にはユーザ名、メールアドレス、IDナンバ等のユーザ識別データを含む必要があります。
* その他の列には既存の活動または評定項目に応じた見出しを付ける必要があります。

正しいフォーマットのスプレッドシートは最初にいくつかの評定をエクスポートして入手できます。次にスプレッドシートを編集して成績を追加および保存できます。

あなたがスプレッドシートからインポートしたい列を選択およびコピーしてこのフィールドに貼り付けてください。';
$string['importerror'] = 'エラーが発生しました。このスクリプトは適正なパラメータでコールされていません。';
$string['importfailed'] = 'インポートに失敗しました。データはインポートされませんでした。';
$string['importfeedback'] = 'フィードバックをインポートする';
$string['importfile'] = 'ファイルをインポートする';
$string['importfilemissing'] = 'ファイルが受け取られていません。フォームに戻って有効なファイルをアップロードしてください。';
$string['importfrom'] = 'インポート元';
$string['importoutcomenofile'] = 'アップロードされたファイルが空または破損しています。このファイルが有効かどうかご確認ください。問題は {$a} 行目で検出されました。これは最初の行 (ヘッダ行) のカラムと同数のカラムがデータ行に含まれていないか、インポートファイルに必要なヘッダ行が含まれていなことが原因です。有効なヘッダのあるファイルの例として、エクスポートされたファイルをご覧ください。';
$string['importoutcomes'] = 'アウトカムインポート';
$string['importoutcomes_help'] = 'アウトカムはエクスポートアウトカムCSVファイルと同じフォーマットでCSVファイルを使用してインポートできます。';
$string['importoutcomes_link'] = 'grade/outcome';
$string['importoutcomesuccess'] = 'インポートされたアウトカム「 {$a->name} 」 ID #{$a->id}';
$string['importplugins'] = 'プラグインインポート';
$string['importpreview'] = 'インポートプレビュー';
$string['importsettings'] = 'インポート設定';
$string['importskippednomanagescale'] = 'あなたには新しい評価尺度を追加するためのパーミッションがありません。新しい尺度を作成する必要があるため、アウトカム「 {$a} 」はスキップされました。';
$string['importskippedoutcome'] = 'このコンテクスト内で省略名「 {$a} 」のアウトカムはすでに登録されています。インポートファイルのアウトカムがスキップされました。';
$string['importstandard'] = '標準アウトカムとしてインポートする';
$string['importsuccess'] = '評定インポートが正常に完了しました。';
$string['importxml'] = 'XMLをインポートする';
$string['includescalesinaggregation'] = '総計に評価尺度を含む';
$string['includescalesinaggregation_help'] = 'あなたはすべてのコースのすべての評定表を通して、評価尺度がすべての総合評点に数値として含めるかどうか変更できます。注意: この設定を変更することですべての総合評点が強制的に再計算されます。';
$string['incorrectcourseid'] = 'コースIDが正しくありません。';
$string['incorrectcustomscale'] = '(カスタム評価尺度が正しくありません、修正してください)';
$string['incorrectminmax'] = '最小評点は最大評点より低くする必要があります。';
$string['inherit'] = '継承';
$string['intersectioninfo'] = '学生/評定情報';
$string['invalidgradeexporteddate'] = '日付が1年以上前または未来であるため、またはフォーマットが無効であるため、エクスポート日付が正しくありません。';
$string['item'] = '項目';
$string['iteminfo'] = '項目情報';
$string['iteminfo_help'] = 'この設定では評定項目に関する情報を入力するスペースを提供します。入力されたテキストは他の場所で表示されることはありません。';
$string['itemname'] = '項目名';
$string['itemnamehelp'] = 'モジュールから提供されるこの項目の名称です。';
$string['items'] = '項目';
$string['itemsedit'] = '評定項目を編集する';
$string['keephigh'] = '最大評点の保持件数';
$string['keephigh_help'] = 'このオプションを設定した場合、X件の最大評点のみ保持されます。Xはこのオプションで選択された値です。';
$string['keephighestvalues'] = '最高評点 {$a} 件を保持する';
$string['keymanager'] = 'キーマネージャ';
$string['lessthanmin'] = '{$a->itemname} に入力された {$a->username} の評点は許可された最小評点に達していません。';
$string['letter'] = '文字';
$string['lettergrade'] = '評定文字';
$string['lettergradenonnumber'] = '上限または下限の評点が数値ではありません:';
$string['letterpercentage'] = '文字 (パーセンテージ)';
$string['letterreal'] = '文字 (実データ)';
$string['letters'] = '文字';
$string['linkedactivity'] = 'リンクされる活動';
$string['linkedactivity_help'] = 'この設定ではこのアウトカム項目がリンクされる活動を指定します。これは活動評定により評定されないクライテリアに関する学生のパフォーマンスを測定するために使用できます。';
$string['linktoactivity'] = '{$a->name} 活動 {$a->title}';
$string['lock'] = 'ロック';
$string['locked'] = 'ロック';
$string['locked_help'] = 'この設定を有効にした場合、関連する活動の評定が自動更新されないようになります。';
$string['locktime'] = '次の日時以後ロックする';
$string['locktimedate'] = '次の日時以後ロックする: {$a}';
$string['lockverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname} をロックする';
$string['lowest'] = '下位';
$string['lowgradeletter'] = '下限';
$string['manageoutcomes'] = 'アウトカムを管理する';
$string['manualitem'] = '手動項目';
$string['mapfrom'] = 'マップ元';
$string['mapfrom_help'] = 'ユーザ名、ユーザIDまたはメールアドレス等、スプレッドシート内でユーザを識別するためのデータを含むカラムを選択してください。';
$string['mappings'] = '評定項目マッピング';
$string['mappings_help'] = 'スプレッドシートのそれぞれの評定カラムに関して、評定をインポートする対応評定項目を選択してください。';
$string['mapto'] = 'マップ先';
$string['mapto_help'] = '「マップ元」で選択されたものと同じ識別データを選択してください。';
$string['max'] = '最大';
$string['maxgrade'] = '満点';
$string['meanall'] = 'すべての評点';
$string['meangraded'] = '空白ではない評点';
$string['meanselection'] = 'カラム平均に使用する評点';
$string['meanselection_help'] = 'この設定ではそれぞれのカラム平均を計算する場合に評点のないセルを含めるかどうか決定します。';
$string['median'] = '中央値';
$string['min'] = '最低';
$string['minimum_show'] = '最小評点を表示する';
$string['minimum_show_help'] = '評点および加重の計算に最小評点が使用されます。表示されない場合、最小評点のデフォルトはゼロとなり編集できません。';
$string['minmaxtouse'] = '計算に使用される最小および最大評点';
$string['minmaxtouse_desc'] = 'この設定では評定時に「初期最小および最大評点」を使用するか、または評定表に表示される評点の計算時に「評定項目設定で指定された最小および最大評点」を使用するか決定します。結果としてすべての評点が再計算されることでサーバの負荷が高くなるため、この設定の変更は混雑していない時期での実施をお勧めします。';
$string['minmaxtouse_help'] = 'この設定では評定時に「初期最小および最大評点」を使用するか、または評定表に表示される評点の計算時に「評定項目設定で指定された最小および最大評点」を使用するか決定します。';
$string['minmaxtouse_link'] = 'Grades_min_max';
$string['minmaxupgradedgrades'] = '注意: 表示される評点の計算時に使用される最小および最大評点の変更による不一致を解消するため、いくつかの評点が変更されました。変更のレビューおよび承認をお勧めします。';
$string['minmaxupgradefixbutton'] = '不一致を解消する';
$string['minmaxupgradewarning'] = '注意: 表示される評点の計算時に使用される最小および最大評点の変更による不一致が検出されました。結果としていくつかの評点が変更されることになりますが下のボタンをクリックして不一致を解消することをお勧めします。';
$string['missingitemtypeoreid'] = '配列キー (itemtypeまたはeid) がありません。';
$string['missingscale'] = '評価尺度を選択してください。';
$string['mode'] = '最頻値';
$string['modgrade'] = '評点';
$string['modgrade_help'] = 'この活動で使用される評定タイプを選択してください。「尺度」が選択された場合、あなたは「尺度」ドロップダウンメニューから尺度を選択できます。「評点」評定が使用される場合、あなたはこの活動で利用できる最大評点を入力できます。';
$string['modgradecantchangegradetype'] = 'すでにこのアイテムのための評点が存在するため、あなたはタイプを変更できません。';
$string['modgradecantchangegradetypemsg'] = 'すでに評点が与えられているため、評定タイプを変更できません。最大評点を変更したい場合、あなたは最初に既存の評点を変更するかどうか選択する必要があります。';
$string['modgradecantchangegradetyporscalemsg'] = 'すでに評点が与えられているため、評定タイプおよび評価尺度を変更できません。';
$string['modgradecantchangeratingmaxgrade'] = '活動の評価のためにすでに評点が存在するため、あなたは最大評点を変更できません。';
$string['modgradecantchangescale'] = 'すでにこのアイテムのための評点が存在するため、あなたは評価尺度を変更できません。';
$string['modgradecategorycantchangegradetypemsg'] = 'このカテゴリはオーバーライドされた評定項目に関連付けられています。いくつかはすでに評定済みのため、評定タイプは変更できません。最大評点を変更したい場合、あなたは最初に既存の評点を再計算するかどうか選択する必要があります。';
$string['modgradecategorycantchangegradetyporscalemsg'] = 'このカテゴリはオーバーライドされた評定項目に関連付けられています。いくつかはすでに評定済みのため、評定タイプおよび評価尺度は変更できません。';
$string['modgradecategoryrescalegrades'] = 'オーバーライド済み評点を再計算する';
$string['modgradecategoryrescalegrades_help'] = '評定表内の最大評点を変更した場合、あなたは既存の評点のパーセンテージ評点も変更するかどうか指定する必要があります。

この設定を有効にした場合、既存のオーバーライド済み評点はパーセンテージ評点が同じになるよう変更されます。

例えばこのオプションが有効にされて項目の最大評点が10から20に変更された場合、評点6/10 (60%) は12/20 (60%) に再計算されます。この設定を無効にした場合、評点は変更されないままになるため、評定項目が正しい評点になるよう手動での調整が必要となります。';
$string['modgradedonotmodify'] = '既存の評点を変更しない';
$string['modgradeerrorbadpoint'] = '無効な評定値です。評点は 1 から {$a} までの整数にする必要があります。';
$string['modgradeerrorbadscale'] = '無効な尺度が選択されました。あなたが以下の選択肢から尺度を選択したことをご確認ください。';
$string['modgrademaxgrade'] = '最大評点';
$string['modgraderescalegrades'] = '既存の評点を再計算する';
$string['modgraderescalegrades_help'] = '評定表アイテムの最大評点を変更する場合、あなたは同様に既存のパーセントの評点を変更するかどうか指定する必要があります。

「Yes」が設定された場合、既存の評点はパーセンテージの評点が同じになるよう変更されます。

例えばこのオプションが有効にされて項目の最大評点が10から20に変更された場合、評点6/10 (60%) は12/20 (60%) に再計算されます。このオプションを「No」にした場合、評点は6/10 (60%) から6/20 (30%) に変更されるため、評定項目が正しい評点になるよう手動での調整が必要となります。';
$string['modgradetype'] = 'タイプ';
$string['modgradetypenone'] = 'なし';
$string['modgradetypepoint'] = '評点';
$string['modgradetypescale'] = '尺度';
$string['morethanmax'] = '{$a->itemname} に入力された {$a->username} の評点は許可された最大評点を超えています。';
$string['moveselectedto'] = '選択したアイテムを移動する:';
$string['movesitems'] = 'アイテムを移動する';
$string['movingelement'] = '{$a} に移動する';
$string['multfactor'] = '乗数';
$string['multfactor_help'] = '乗数は最大評点の最大値を上限として、この評定項目のすべての評点に掛けられる要素です。例えば乗数が2、最大評点が100点の場合、50点未満の評点すべてに2が掛けられます。また、50点以上のすべての評点は100点に変更されます。';
$string['multfactorvalue'] = '{$a} の乗数';
$string['mustchooserescaleyesorno'] = 'あなたは既存の評点を変更するかどうか選択する必要があります。';
$string['mygrades'] = 'ユーザメニュー評点リンク';
$string['mygrades_desc'] = 'この設定によりユーザメニューから外部評定表にリンクできるようにします。';
$string['mypreferences'] = 'マイプレファレンス';
$string['myreportpreferences'] = 'マイレポートプレファレンス';
$string['myself'] = '私自身';
$string['neverdeletehistory'] = '履歴を削除しない';
$string['newcategory'] = '新しいカテゴリ';
$string['newitem'] = '新しい評定項目';
$string['newoutcomeitem'] = '新しいアウトカム項目';
$string['no'] = 'No';
$string['nocategories'] = 'このコースに評定カテゴリを追加できなかったか、見つかりませんでした';
$string['nocategoryname'] = 'カテゴリ名が入力されていません。';
$string['nocategoryview'] = '表示するカテゴリがありません。';
$string['nocourses'] = 'まだコースがありません。';
$string['noexistingoutcomes'] = '既存のアウトカムはありません。';
$string['noexistingscales'] = '既存の尺度はありません。';
$string['noforce'] = '強制しない';
$string['nogradeletters'] = '評定文字が設定されていません。';
$string['nogradesreturned'] = '評点がありません。';
$string['noidnumber'] = 'IDナンバなし';
$string['nolettergrade'] = '評定文字がありません:';
$string['nomode'] = 'NA';
$string['nonnumericweight'] = '数値ではありません:';
$string['nonunhideableverbose'] = 'この評定の非表示を解除したい場合、あなたは {$a->itemname} の非表示を解除する必要があります。';
$string['nonunlockableverbose'] = 'この評定のロックを解除したい場合、あなたは {$a->itemname} のロックを解除する必要があります。';
$string['nonweightedpct'] = '加重なし%';
$string['nooutcome'] = 'アウトカムなし';
$string['nooutcomes'] = 'アウトカム項目はコースアウトカムにリンクされる必要がありますが、このコースにはアウトカムがありません。アウトカムを追加しますか?';
$string['nopermissiontoresetweights'] = '加重をリセットするためのパーミッションがありません。';
$string['nopublish'] = '公開しない';
$string['noreports'] = 'あなたがこのサイトで登録しているコースはありません。また、教えているコースもありません。';
$string['norolesdefined'] = '「管理 > 評定 > 一般設定 > 評定ロール」で定義されたロールがありません。';
$string['noscales'] = 'アウトカムはコース評価尺度または標準評価尺度にリンクされる必要がありますが、評価尺度が登録されていないようです。評価尺度を追加しますか?';
$string['noselectedcategories'] = 'カテゴリが選択されていません。';
$string['noselecteditems'] = '項目が選択されていません。';
$string['notenrolled'] = 'あなたは現在どのコースにも登録されていません。';
$string['notteachererror'] = 'この機能を使用する場合、あなたは教師である必要があります。';
$string['nousersloaded'] = 'ユーザが読み込まれていません。';
$string['nouserstograde'] = '評定対象ユーザなし';
$string['numberofgrades'] = '評定数';
$string['onascaleof'] = '尺度の適用範囲: {$a->grademin} - {$a->grademax}';
$string['operations'] = '操作';
$string['options'] = 'オプション';
$string['others'] = 'その他';
$string['otheruser'] = 'ユーザ';
$string['outcome'] = 'アウトカム';
$string['outcome_help'] = 'この設定はこの評定項目が評定表で表すアウトカムを決定します。';
$string['outcomeassigntocourse'] = 'このコースに別のアウトカムを割り当てる';
$string['outcomecategory'] = 'カテゴリでアウトカムを作成する';
$string['outcomecategorynew'] = '新しいカテゴリ';
$string['outcomeconfirmdelete'] = '本当にアウトカム「 {$a} 」を削除してもよろしいですか?';
$string['outcomecreate'] = '新しいアウトカムを追加する';
$string['outcomedelete'] = 'アウトカムを削除する';
$string['outcomefullname'] = 'フルネーム';
$string['outcomeitem'] = 'アウトカム項目';
$string['outcomeitemsedit'] = 'アウトカム項目を編集する';
$string['outcomereport'] = 'アウトカムレポート';
$string['outcomes'] = 'アウトカム';
$string['outcomescourse'] = 'コースで使用されるアウトカム';
$string['outcomescoursecustom'] = '使用されているカスタム (削除不可)';
$string['outcomescoursenotused'] = '使用されていない標準';
$string['outcomescourseused'] = '使用されている標準 (削除不可)';
$string['outcomescustom'] = 'カスタムアウトカム';
$string['outcomesdisabled'] = 'アウトカムは有効にされていません。';
$string['outcomeshortname'] = '省略名';
$string['outcomesstandard'] = '標準アウトカム';
$string['outcomesstandardavailable'] = '利用可能な標準アウトカム';
$string['outcomestandard'] = '標準アウトカム';
$string['outcomestandard_help'] = '標準アウトカムはサイト全体およびすべてのコースで利用可能です。';
$string['overallaverage'] = '全平均';
$string['overridden'] = 'オーバーライド';
$string['overridden_help'] = 'この設定が有効にされた場合、関連した活動内で評点を変更できないようになります。

評定者レポート内で評点が変更された場合、自動的にチェックボックスがチェックされます。関連した活動経由での評点の変更を許可したい場合、チェックを外してください。';
$string['overriddennotice'] = 'この活動に関するあなたの評点は手動で調整されました。';
$string['overridecat'] = 'カテゴリ評点の手動オーバーライドを許可する';
$string['overridecat_help'] = 'この設定を無効にした場合、ユーザがカテゴリ評点をオーバーライドできなくなります。';
$string['overridesitedefaultgradedisplaytype'] = 'サイトデフォルトをオーバーライドする';
$string['overridesitedefaultgradedisplaytype_help'] = 'この設定を有効にした場合、サイトデフォルトではなく、コースの評定文字および境界を設定できます。';
$string['overrideweightofa'] = '{$a} の加重をオーバーライドする';
$string['parentcategory'] = '親カテゴリ';
$string['pass'] = '合格';
$string['pctoftotalgrade'] = '評点合計の%';
$string['percent'] = 'パーセント';
$string['percentage'] = 'パーセンテージ';
$string['percentageletter'] = 'パーセンテージ (文字)';
$string['percentagereal'] = 'パーセンテージ (実データ)';
$string['percentascending'] = 'パーセントの昇順で並べ替える';
$string['percentdescending'] = 'パーセントの降順で並べ替える';
$string['percentshort'] = '%';
$string['plusfactor'] = '補正値';
$string['plusfactor_help'] = '補正値は乗数が適用された後、この評定項目すべての評点に追加される数値です。';
$string['plusfactorvalue'] = '{$a} の補正値';
$string['points'] = '評点';
$string['pointsascending'] = '評点の昇順で並べ替え';
$string['pointsdescending'] = '評点の降順で並べ替え';
$string['positionfirst'] = '最初';
$string['positionlast'] = '最後';
$string['preferences'] = 'プレファレンス';
$string['prefgeneral'] = '一般設定';
$string['prefletters'] = '評定文字および境界';
$string['prefrows'] = '特別行';
$string['prefshow'] = 'トグルを表示/非表示にする';
$string['previewrows'] = 'プレビュー行';
$string['privacy:metadata:categorieshistory'] = '前のバージョンの評定カテゴリのレコードです。';
$string['privacy:metadata:filepurpose'] = '評定表に保存されるユーザのフィードバックファイルです。';
$string['privacy:metadata:grade_import_newitem'] = '評定インポートから新しいgrade_item名を保存する一時テーブルです。';
$string['privacy:metadata:grade_import_newitem:importcode'] = 'インポートのバッチからバッチを識別するためのユニークなバッチコードです。';
$string['privacy:metadata:grade_import_newitem:importer'] = 'データをインポートするユーザです。';
$string['privacy:metadata:grade_import_newitem:itemname'] = '新しい評定項目名です。';
$string['privacy:metadata:grade_import_values'] = '評定をインポートする一時テーブルです。';
$string['privacy:metadata:grade_import_values:feedback'] = '評定フィードバックです。';
$string['privacy:metadata:grade_import_values:finalgrade'] = '生評定値です。';
$string['privacy:metadata:grade_import_values:importcode'] = 'インポートのバッチからバッチを識別するためのユニークなバッチコードです。';
$string['privacy:metadata:grade_import_values:importer'] = 'データをインポートするユーザです。';
$string['privacy:metadata:grade_import_values:importonlyfeedback'] = 'フィードバックがインポートされた場合のみフラグ付けされます。';
$string['privacy:metadata:grade_import_values:userid'] = '評定がインポートされたユーザです。';
$string['privacy:metadata:grades'] = '評定レコードです。';
$string['privacy:metadata:grades:aggregationstatus'] = '総計ステータスです。';
$string['privacy:metadata:grades:aggregationweight'] = '総計の加重です。';
$string['privacy:metadata:grades:feedback'] = 'フィードバックです。';
$string['privacy:metadata:grades:finalgrade'] = '評定です。';
$string['privacy:metadata:grades:information'] = '評定に関する情報です。';
$string['privacy:metadata:grades:timemodified'] = '最後に評定が修正された日時です。';
$string['privacy:metadata:grades:userid'] = '評定のユーザのIDです。';
$string['privacy:metadata:grades:usermodified'] = '最後に評定を修正したユーザのIDです。';
$string['privacy:metadata:gradeshistory'] = '前の評定のレコードです。';
$string['privacy:metadata:history:loggeduser'] = 'バージョニング発生時にログインしたユーザのIDです。';
$string['privacy:metadata:history:timemodified'] = '評定バージョニングが発生した日時です。';
$string['privacy:metadata:itemshistory'] = '前のバージョンの評定項目のレコードです。';
$string['privacy:metadata:outcomes'] = 'アウトカムのレコードです。';
$string['privacy:metadata:outcomes:timemodified'] = 'レコードが修正された日時です。';
$string['privacy:metadata:outcomes:usermodified'] = '最後にレコードを修正したユーザです。';
$string['privacy:metadata:outcomeshistory'] = '前のバージョンのアウトカムのレコードです。';
$string['privacy:metadata:scale'] = '尺度のレコードです。';
$string['privacy:metadata:scale:timemodified'] = 'レコードが最後に修正された日時です。';
$string['privacy:metadata:scale:userid'] = 'レコードを最後に修正したユーザです。';
$string['privacy:metadata:scalehistory'] = '前のバージョンの尺度のレコードです。';
$string['privacy:path:relatedtome'] = '私に関連します。';
$string['privacy:request:historyactiondelete'] = '削除';
$string['privacy:request:historyactioninsert'] = '挿入';
$string['privacy:request:historyactionupdate'] = '更新';
$string['privacy:request:unknowndeletedgradeitem'] = '不明 (評定項目が削除されました)';
$string['profilereport'] = 'ユーザプロファイルレポート';
$string['profilereport_help'] = 'ユーザプロファイルページで使用される評定レポートです。';
$string['publishing'] = '公開';
$string['publishingoptions'] = '評定公開オプション';
$string['quickfeedback'] = 'クイックフィードバック';
$string['quickgrading'] = 'クイック評定';
$string['quickgrading_help'] = 'この設定を有効にした場合、編集モード有効時に多くの評定を同時に編集できるようにするため、それぞれの評定にテキスト入力欄が表示されます。更新ボタンクリック時に変更は保存およびハイライトされます。

評定者レポート内で評定が編集された場合、オーバーライドフラグが設定されて関連する活動内で評定を変更できなくなることに留意してください。';
$string['range'] = '範囲';
$string['rangedecimals'] = '小数位の範囲';
$string['rangedecimals_help'] = '表示する小数位の範囲です。';
$string['rangesdecimalpoints'] = '範囲で表示する小数点以下桁数';
$string['rangesdecimalpoints_help'] = 'この設定ではそれぞれの範囲に表示する小数位以下桁数、またはカテゴリ全体の小数位以下桁数または評定項目を使用 (継承) するか決定します。';
$string['rangesdisplaytype'] = '範囲表示タイプ';
$string['rangesdisplaytype_help'] = 'この設定では範囲を実評点、パーセンテージまたは文字として表示するか、またはカテゴリ全体の表示タイプまたは評定項目を使用 (継承) するか決定します。';
$string['rank'] = 'ランク';
$string['rawpct'] = '実%';
$string['real'] = '実データ';
$string['realletter'] = '実データ (文字)';
$string['realpercentage'] = '実データ (パーセンテージ)';
$string['recalculatinggrades'] = '評定を再計算する';
$string['recovergradesdefault'] = '評定デフォルトに戻す';
$string['recovergradesdefault_help'] = 'デフォルトではユーザがコースに再度登録される時点で古い評定が戻されます。';
$string['refreshpreview'] = 'プレビューをリフレッシュする';
$string['regradeanyway'] = 'とにかく再評定する';
$string['removeallcoursegrades'] = 'すべての評定を削除する';
$string['removeallcoursegrades_help'] = 'この設定を有効にした場合、評定表に手動追加されたすべての評定項目および評点が削除されます。同時に上書きされた評定、除外された評定、非表示にされた評定およびロックされた評定のデータも削除されます。活動に関連する評定項目および評定のみ保持されます。';
$string['removeallcourseitems'] = 'すべての評定項目およびカテゴリを削除する';
$string['removeallcourseitems_help'] = 'この設定を有効にした場合、オーバーライドされた評点およびデータ、除外、非表示およびロックされた評点と共に評定表に手動追加されたカテゴリおよび評定項目すべてが削除されます。活動に関連する評定のみ保持されます。';
$string['report'] = 'レポート';
$string['reportdefault'] = 'レポートデフォルト ({$a})';
$string['reportplugins'] = 'レポートプラグイン';
$string['reportsettings'] = 'レポート設定';
$string['reprintheaders'] = 'ヘッダを再表示する';
$string['resetweights'] = '{$a->itemname} の加重をリセットする';
$string['resetweightsshort'] = '加重をリセットする';
$string['respectingcurrentdata'] = '現在の設定をそのままにします。';
$string['rowpreviewnum'] = 'プレビュー行数';
$string['rowpreviewnum_help'] = 'インポートするデータはインポート承認前にプレビューできます。この設定ではプレビュー時に何行表示するか決定します。';
$string['savechanges'] = '変更を保存する';
$string['savepreferences'] = 'プレファレンスを保存する';
$string['scaleconfirmdelete'] = '本当に尺度「 {$a} 」を削除してもよろしいですか?';
$string['scaledpct'] = '伸縮%';
$string['searchcollapsedcolumns'] = '折りたたまれたカラムを検索する';
$string['seeallcoursegrades'] = 'すべてのコース評定を表示する';
$string['select'] = '{$a} を選択する';
$string['selectalloroneuser'] = 'すべてまたは1ユーザを選択する';
$string['selectauser'] = 'ユーザを選択する';
$string['selectdestination'] = '{$a} の移動先を選択する';
$string['selectgrouplink'] = 'グループを選択する';
$string['selectuserlink'] = 'ユーザを選択する';
$string['separator'] = 'セパレータ';
$string['separator_help'] = 'CSVファイルで使用されるセパレータを選択してください (通常、これはカンマです)。';
$string['sepcolon'] = 'コロン';
$string['sepcomma'] = 'カンマ';
$string['sepsemicolon'] = 'セミコロン';
$string['septab'] = 'タブ';
$string['setcategories'] = 'カテゴリを設定する';
$string['setcategorieserror'] = 'あなたは加重を与える前にコースにカテゴリを設定する必要があります。';
$string['setgradeletters'] = '評定文字を設定する';
$string['setpreferences'] = 'プレファレンスを設定する';
$string['setting'] = '設定';
$string['settings'] = '設定';
$string['setup'] = 'セットアップ';
$string['setweights'] = '加重を設定する';
$string['showactivityicons'] = '活動アイコンを表示する';
$string['showactivityicons_help'] = 'この設定を有効にした場合、活動名の横に活動アイコンが表示されます。';
$string['showallgrades'] = 'すべての評定を表示する';
$string['showallhidden'] = '隠し評定項目を表示する';
$string['showallstudents'] = 'すべての学生を表示する';
$string['showanalysisicon'] = '評定分析アイコンを表示する';
$string['showanalysisicon_desc'] = 'デフォルトで評定分析アイコンを表示するかどうか指定します。活動モジュールがサポートしている場合、評定および評定の取得に関する詳細説明ページへ評定分析アイコンがリンクされます。';
$string['showanalysisicon_help'] = '活動モジュールがサポートしている場合、評定および評定の取得に関する詳細説明ページへ評定分析アイコンがリンクされます。';
$string['showaverage'] = '平均を表示する';
$string['showaverage_help'] = '平均カラムを表示するかどうか決定します。少数の評点から平均を算出した場合、参加者は他の人の評点を推定できる可能性があることに留意してください。隠し評定項目が存在する場合、パフォーマンスの理由から平均は概算となります。';
$string['showaverages'] = '平均を表示する';
$string['showaverages_help'] = 'この設定を有効にした場合、評定者レポートにはそれぞれのカテゴリおよび評定項目の平均を表示するための追加行が含まれます。';
$string['showcalculations'] = '計算を表示する';
$string['showcalculations_help'] = 'この設定を有効にした場合、編集時、それぞれの評定項目およびカテゴリに評定項目計算のビジュアルインジケータと共に計算アイコンが表示されます。';
$string['showcontributiontocoursetotal'] = 'コース合計への寄与を表示する';
$string['showcontributiontocoursetotal_help'] = 'それぞれの評定項目が (加重適用後) ユーザのコース合計にどのくらい寄与しているかを示すパーセンテージのカラムを表示します。';
$string['showeyecons'] = '表示/非表示アイコンを表示する';
$string['showeyecons_help'] = 'この設定を有効にした場合、編集モード有効時に学生に対する可視性をコントロールするためそれぞれの評定に表示/非表示アイコンが表示されます。';
$string['showfeedback'] = 'フィードバックを表示する';
$string['showfeedback_help'] = 'フィードバックカラムを表示するかどうか指定してください。';
$string['showgrade'] = '評定を表示する';
$string['showgrade_help'] = '評定カラムを表示するかどうか指定してください。';
$string['showgroups'] = 'グループを表示する';
$string['showhiddenitems'] = '隠し評定項目を表示する';
$string['showhiddenitems_help'] = '隠し評定項目を完全に隠すか、隠し評定項目名を学生に表示するか設定してください。

* 隠し評定項目を表示する - 隠し評定項目名は表示されますが、学生には評定が隠されます。
* 設定された日時まで評定項目を隠す - 「次の日時まで隠す」日時が設定された評定項目は完全に隠されますが、設定日時以後、すべての評定項目が表示されます。
* 隠し評定項目を表示しない - すべての評定項目を完全に隠します。';
$string['showhiddenuntilonly'] = '設定された日時まで評定項目を隠す';
$string['showingaggregatesonly'] = '総計を表示する';
$string['showingfullmode'] = '評点および総計を表示する';
$string['showinggradesonly'] = '評点のみを表示する';
$string['showlettergrade'] = '評定文字を表示する';
$string['showlettergrade_help'] = '評定文字カラムを表示するかどうか指定してください。';
$string['showlocks'] = 'ロックを表示する';
$string['showlocks_help'] = 'この設定を有効にした場合、編集モード有効時に関連した活動により評定が自動的に更新されるかコントロールするためロック/ロック解除アイコンがそれぞれの評定に表示されます。';
$string['shownohidden'] = '表示しない';
$string['shownooutcomes'] = 'アウトカムを隠す';
$string['shownumberofgrades'] = '平均に評定数を表示する';
$string['shownumberofgrades_help'] = 'この設定を有効にした場合、平均計算時に使用された評定数がそれぞれの平均の隣の大括弧内に表示されます。';
$string['showonlyactiveenrol'] = '有効な登録のみ表示する';
$string['showonlyactiveenrol_help'] = 'この設定では評定表レポート内で有効な登録済みユーザのみを表示するかどうか決定します。この設定を有効にした場合、一時停止したユーザは評定表内に表示されません。';
$string['showpercentage'] = 'パーセンテージを表示する';
$string['showpercentage_help'] = 'それぞれの評定項目にパーセンテージを表示するかどうか指定してください。';
$string['showquickfeedback'] = 'クイックフィードバックを表示する';
$string['showquickfeedback_help'] = 'この設定を有効にした場合、編集モード有効時に多くの評定のフィードバックを同時に編集できるようにするため、それぞれの評定にドット枠線のフィードバックテキスト入力欄が表示されます。更新ボタンクリック時に変更が保存され、ハイライトされます。

評定者レポート内でフィードバックが編集された場合、オーバーライドフラグが設定され、関連する活動でフィードバックを変更できないようになることに留意してください。';
$string['showrange'] = '範囲を表示する';
$string['showrange_help'] = '範囲カラムを表示するかどうか指定してください。';
$string['showranges'] = '範囲を表示する';
$string['showranges_help'] = 'この設定を有効にした場合、それぞれのカテゴリおよび評定項目の範囲を表示するための追加行が評定者レポートに含まれます。';
$string['showrank'] = 'ランクを表示する';
$string['showrank_help'] = 'それぞれの評定項目に関してクラス内のユーザの位置を表示するかどうか指定してください。';
$string['showuserimage'] = 'ユーザプロファイルイメージを表示する';
$string['showuserimage_help'] = '評定者レポートで名前の隣にプロファイルイメージを表示するかどうか指定してください。';
$string['showverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname} を表示する';
$string['showweight'] = '加重を表示する';
$string['showweight_help'] = '加重カラムを表示するかどうか指定してください。';
$string['simpleview'] = 'シングルビュー';
$string['sitewide'] = 'サイト全体';
$string['sort'] = '並べ替え';
$string['sortasc'] = '昇順で並べ替える';
$string['sortbyfirstname'] = '名で並べ替える';
$string['sortbylastname'] = '姓で並べ替える';
$string['sortdesc'] = '降順で並べ替える';
$string['standarddeviation'] = '標準偏差';
$string['stats'] = '統計';
$string['statslink'] = '統計';
$string['student'] = '学生';
$string['studentsperpage'] = '1ページあたりの学生数';
$string['studentsperpage_help'] = 'この設定では評定者レポートの1ページあたりに表示される学生数を指定します。';
$string['studentsperpagereduced'] = '1ページあたりの学生数を {$a->originalstudentsperpage} から {$a->studentsperpage} に減らしました。PHP設定「max_input_vars」を {$a->maxinputvars} から増やすことをお考えください。';
$string['subcategory'] = 'ノーマルカテゴリ';
$string['submissions'] = '提出';
$string['submittedon'] = '評定登録日時: {$a}';
$string['sumofgradesupgradedgrades'] = '注意: 総計方法「評点の合計」はサイトアップグレードの一環として「自然」に変更されました。このコース内で前に「評点の合計」が使用されていたことが理由です。この変更に関する評定表内でのレビューをお勧めします。';
$string['switchtofullview'] = 'フルビューに切り替える';
$string['switchtosimpleview'] = 'シンプルビューに切り替える';
$string['topcategory'] = 'スーパーカテゴリ';
$string['total'] = '合計';
$string['totalweight100'] = '加重の合計は100です。';
$string['totalweightnot100'] = '加重の合計は100ではありません。';
$string['turnfeedbackoff'] = 'フィードバックモードを終了する';
$string['turnfeedbackon'] = 'フィードバックモードを開始する';
$string['typenone'] = 'なし';
$string['typescale'] = '尺度';
$string['typescale_help'] = 'この設定では「尺度」評定タイプを使用する場合の評価尺度を指定します。活動ベースの評価尺度は活動の更新ページで設定します。';
$string['typetext'] = 'テキスト';
$string['typevalue'] = '値';
$string['uncategorised'] = 'カテゴリなし';
$string['unchangedgrade'] = '評点変更なし';
$string['unenrolledusersinimport'] = 'このインポートには現在コースに登録されていない次のユーザの評点が含まれています: {$a}';
$string['unlimitedgrades'] = '無制限の評点';
$string['unlimitedgrades_help'] = 'デフォルトでは評定項目の最大値および最小値により評点は制限されています。この設定を有効にすることでこの制限を取り除き100%を超える評点を評定表に直接入力できるようにします。';
$string['unlock'] = 'ロック解除';
$string['unlockverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname} をロック解除する';
$string['unused'] = '未使用';
$string['updatedgradesonly'] = '新しいまたは更新された評点のみエクスポートする';
$string['upgradedgradeshidemessage'] = '通知を取り消す';
$string['upgradedminmaxrevertmessage'] = '変更を元に戻す';
$string['uploadgrades'] = '評定をアップロードする';
$string['useadvanced'] = '拡張機能を使用する';
$string['usedcourses'] = '使用済みコース';
$string['usedgradeitem'] = '使用済み評定項目';
$string['usenooutcome'] = '結果を使用しない';
$string['usenoscale'] = '評価尺度を使用しない';
$string['usepercent'] = 'パーセントを使用する';
$string['user'] = 'ユーザ';
$string['userenrolmentsuspended'] = 'ユーザ登録停止中';
$string['userfields_show'] = 'ユーザフィールドを表示する';
$string['userfields_show_help'] = 'メールアドレスのような追加ユーザフィールドを評定者レポートに表示します。表示される特定フィールドは「showuseridentity」サイト設定でコントロールされます。';
$string['usergrade'] = '評定項目 {$a->gradeidnumber} のユーザ {$a->fullname} ({$a->useridnumber})';
$string['userid'] = 'ユーザID';
$string['useridnumberwarning'] = 'インポートできないため、IDナンバのないユーザはエクスポートから除外されます。';
$string['usermappingerror'] = 'ユーザマッピングエラー: 「 {$a->field} 」が「 {$a->value} 」のユーザを見つけることができませんでした。';
$string['usermappingerrorcurrentgroup'] = 'ユーザは現在のグループのメンバではありません。';
$string['usermappingerrormultipleusersfound'] = 'ユーザマッピングエラー: 「 {$a->value} 」の {$a->field} に複数のユーザが見つかりました。さらにユニークなマッピングフィールドを使用してください。';
$string['usermappingerrorusernotfound'] = 'ユーザマッピングエラー: ユーザを見つけることができませんでした。';
$string['userpreferences'] = 'ユーザプレファレンス';
$string['useweighted'] = '加重を使用する';
$string['verbosescales'] = '詳細尺度';
$string['verbosescales_help'] = '詳細尺度には数字ではなく単語を使用します。数字および詳細尺度をインポートする場合、この設定を有効にしてください。数字尺度のみインポートする場合、この設定を無効にしてください。';
$string['viewas'] = '次のユーザとして表示する';
$string['viewbygroup'] = 'グループ';
$string['viewfeedback'] = 'フィードバックを表示する';
$string['viewgrades'] = '評定を表示する';
$string['weight'] = '加重';
$string['weight_help'] = 'カテゴリまたはコース内での複数評定項目の相対値を決定するために使用される値です。';
$string['weightcourse'] = '評定項目の加重をコースに使用する';
$string['weightedascending'] = '加重パーセントの昇順で並べ替える';
$string['weighteddescending'] = '加重パーセントの降順で並べ替える';
$string['weightedpct'] = '加重%';
$string['weightedpctcontribution'] = '加重%内訳';
$string['weightofa'] = '{$a} の加重';
$string['weightorextracredit'] = '加重または追加点';
$string['weightoverride'] = '加重調整';
$string['weightoverride_help'] = 'この設定を無効にした場合、評定項目の加重により自動計算された値をリセットします。この設定を有効にした場合、加重が自動調整されなくなります。';
$string['weights'] = '加重';
$string['weightsadjusted'] = 'あなたの加重が合計100に調整されました。';
$string['weightsedit'] = '加重および追加点を編集する';
$string['weightuc'] = '計算済み加重';
$string['writinggradebookinfo'] = '評定表設定の書き出し';
$string['xml'] = 'XML';
$string['yes'] = 'Yes';
$string['yourgrade'] = 'あなたの評定';
