<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_generator', language 'da', version '4.4'.
 *
 * @package     tool_generator
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['additionalmodules'] = 'Yderligere aktiviteter';
$string['additionalmodules_help'] = 'Vælg flere aktiviteter, der implementerer funktionen course_backend_generator_create_activity, til at inkludere i testkurset.';
$string['bigfile'] = 'Stor fil {$a}';
$string['courseexplanation'] = 'Dette værktøj opretter standard testkurser der indeholder mange sektioner, aktiviteter og filer.

Meningen er at tilvejebringe et standardiseret mål til tjek af pålidelighed og ydelse på forskellige systemkomponenter (såsom backup og gendannelse).

Denne test er vigtig da der tidligere har været mange tilfælde hvor systemet ikke har virket (f.eks. kurser med 1000 aktiviteter).

Kurser oprettet med denne funktion kan fylde en stor database og optage masser af plads på filsystemet (tusinder af gigabytes). Du vil skulle slette kurser (og vente på forskellige oprydningskørsler) for at frigive denne plads igen.

**Brug ikke denne funktion på et system i drift**. Brug kun en udviklerserver. (For at undgå utilsigtet brug er denne funktion deaktiveret med mindre du også har valgt UDVIKLER fejlsøgningsniveau.)';
$string['coursesize_0'] = 'XS (~10KB; oprettet på ~1 sekund)';
$string['coursesize_1'] = 'S (~10MB; oprettet på ~30 sekunder)';
$string['coursesize_2'] = 'M (~100MB; oprettet på ~2 minutter)';
$string['coursesize_3'] = 'L (~1GB; oprettet på ~30 minutter)';
$string['coursesize_4'] = 'XL (~10GB; oprettet på ~2 timer)';
$string['coursesize_5'] = 'XXL (~20GB; oprettet på ~4 timer)';
$string['coursewithoutusers'] = 'Det valgte kursus har ingen deltagere';
$string['createcourse'] = 'Opret kursus';
$string['createtestplan'] = 'Opret en testplan';
$string['creating'] = 'Opretter kursus';
$string['done'] = 'færdig ({$a}s)';
$string['downloadtestplan'] = 'Download testplan';
$string['downloadusersfile'] = 'Download brugerfil';
$string['error_nocourses'] = 'Der er ingen kurser til at generere testplanen';
$string['error_noforumdiscussions'] = 'Det valgte kursus har ingen forumdiskussioner';
$string['error_noforuminstances'] = 'Det valgte kursus har ingen forumforekomster';
$string['error_noforumreplies'] = 'Det valgte kursus indeholder ingen forumsvar';
$string['error_nonexistingcourse'] = 'Det valgte kursus eksisterer ikke';
$string['error_nopageinstances'] = 'Det valgte kursus har ingen forekomster af sidemodulet';
$string['error_notdebugging'] = 'Ikke tilgængelig på denne server da debugging ikke står som UDVIKLER';
$string['error_nouserspassword'] = 'Du skal angive $CFG->tool_generator_users_password i config.php for at generere en testplan';
$string['fullname'] = 'Testkursus: {$a->size}';
$string['maketestcourse'] = 'Opret testkursus';
$string['maketestplan'] = 'Opret en JMeter-testplan';
$string['notenoughusers'] = 'Det valgte kursus har ikke tilstrækkeligt mange brugere';
$string['pluginname'] = 'Udviklingsdatagenerator';
$string['privacy:metadata'] = 'Plugin\'et Udviklingsdatagenerator gemmer ingen personlige data.';
$string['progress_checkaccounts'] = 'Tjekker brugerkonti ({$a})';
$string['progress_coursecompleted'] = 'Kursus færdiggjort ({$a}\'er)';
$string['progress_createaccounts'] = 'Opretter brugerkonti ({$a->from} - {$a->to})
Hjælp til dette indeholder en pladsholder';
$string['progress_createassignments'] = 'Opretter opgaver ({$a})';
$string['progress_createbigfiles'] = 'Opretter store filer ({$a})';
$string['progress_createcourse'] = 'Opretter kursus {$a}';
$string['progress_createforum'] = 'Opretter forum ({$a} indlæg)';
$string['progress_createpages'] = 'Opretter websider ({$a})';
$string['progress_createsmallfiles'] = 'Opretter små filer ({$a})';
$string['progress_createusers'] = 'Oprettelse af brugerkonti ({$a})';
$string['progress_enrol'] = 'Melder brugere på kurset ({$a})';
$string['progress_sitecompleted'] = 'Site fuldendt ({$a}s)';
$string['shortsize_0'] = 'XS';
$string['shortsize_1'] = 'S';
$string['shortsize_2'] = 'M';
$string['shortsize_3'] = 'L';
$string['shortsize_4'] = 'XL';
$string['shortsize_5'] = 'XXL';
$string['sitesize_0'] = 'XS (~10MB; 3 kurser, oprettet på ~30 sekunder)';
$string['sitesize_1'] = 'S (~50MB; 8 kurser, oprettet på ~2 minutter)';
$string['sitesize_2'] = 'M (~200MB; 73 kurser, oprettet på ~10 minutter)';
$string['sitesize_3'] = 'L (~1\'5GB; 277 kurser, oprettet på ~1\'5 timer)';
$string['sitesize_4'] = 'XL (~10GB; 1065 kurser, oprettet på ~5 timer)';
$string['sitesize_5'] = 'XXL (~20GB; 4177 kurser, oprettet på ~10 timer)';
$string['size'] = 'Størrelse på kursus';
$string['smallfiles'] = 'Små filer';
$string['targetcourse'] = 'Test destinationskursus';
$string['testplanexplanation'] = 'Dette værktøj opretter en fil med en JMeter-testplan og en fil med brugeroplysninger.

Denne testplan er designet til at køre sammen med {$a}, som gør det lettere at køre testplanen i et specifikt Moodlemiljø, samle information om kørslerne og sammenligne resultaterne, så du skal downloade den og bruge dens script, test_runner.sh, eller følge installationen og brugsanvisningerne.

Du skal oprette en adgangskode til kursusbrugere i config.php (f.eks. $CFG->tool_generator_users_password = \'moodle\';). For at undgå utilsigtet brug af værktøjet, findes der er ingen standardværdi til denne kode. Du skal bruge indstillingen "opdater adgangskoder" i fald dine kursusbrugere har andre adgangskoder eller de var genreret af tool_generator men uden at sætte en værdi på
$CFG->tool_generator_users_password.

Det er en det af tool_generator, så det kører fint med kurser oprettet af generatorerne til kurser og site, det kan også bruges med andre kurser der indeholder mindst:

* Tilstrækkeligt mange tilmeldte brugere (afhængig af den størrelse testplan du vælger) med adgangskoden nulstillet som "moodle"
* En forekomst af sidemodulet
* En forekomst af forummodulet med mindst en tråd og et svar

Det vil være en god idé at overveje din servers kapacitet når du kører store testplaner da JMeters belastning på serveren kan være meget høj. Perioden med stigende belastning er blevet justeret ud fra antal tråde (brugere) for at reducere den slags problemstillinger, men belastningen er stadig enorm.

**Kør ikke testplanen på en installation i drift**. Funktionen opretter kun filer til brug for JMeter, så den er ikke i sig selv risikabel, men du skal **ALDRIG** køre testplanen på en installation i drift.';
$string['testplansize_0'] = 'XS ({$a->users} brugere, {$a->loops} loops og {$a->rampup} periode med stigende belastning)';
$string['testplansize_1'] = 'S ({$a->users} brugere, {$a->loops} loops og {$a->rampup} periode med stigende belastning)';
$string['testplansize_2'] = 'M ({$a->users} brugere, {$a->loops} loops og {$a->rampup} periode med stigende belastning)';
$string['testplansize_3'] = 'L ({$a->users} brugere, {$a->loops} loops og {$a->rampup} periode med stigende belastning)';
$string['testplansize_4'] = 'XL ({$a->users} brugere, {$a->loops} loops og {$a->rampup} periode med stigende belastning)';
$string['testplansize_5'] = 'XXL ({$a->users} brugere, {$a->loops} loops og {$a->rampup} periode med stigende belastning)';
$string['testscenario'] = 'Opret testscenarier';
$string['testscenario_description'] = 'Oprettelse af testscenarier bruger en begrænset syntaks for funktionsfiler til at skabe alle nødvendige elementer til at udføre en manuel test.';
$string['testscenario_errorparsing'] = 'Fejl ved parsing af funktionsfil: {$a}';
$string['testscenario_file'] = 'Funktionsfil';
$string['testscenario_invalidfile'] = 'Filformatet er ikke gyldigt eller indeholder ugyldige trin.';
$string['testscenario_invalidstep'] = 'Ukendt trin. Opret testscenarier accepterer kun generatortrin.';
$string['testscenario_nosteps'] = 'Der er ingen trin at udføre i filen.';
$string['testscenario_notready'] = 'Composer- og Behat-bibliotekerne er endnu ikke installeret.<br><br>Udfør denne kommando for at aktivere dette værktøj: <strong>php admin/tool/generator/cli/runtestscenario.php</strong>';
$string['testscenario_outline'] = 'Scenarieoversigter understøttes ikke.';
$string['testscenario_scenarionosteps'] = 'Dette scenarie har ikke nogen trin.';
$string['testscenario_steps'] = 'Testscenarie trin:';
$string['updateuserspassword'] = 'Opdater kursusdeltageres adgangskoder';
$string['updateuserspassword_help'] = 'JMeter skal kunne logge ind som kursusdeltager, du kan sætte brugeres adgangskode med $CFG->tool_generator_users_password i config.php; denne indstilling opdaterer kursusdeltagernes adgangskoder ifølge $CFG->tool_generator_users_password. Det kan være egnet hvis du bruger et kursus der ikke er oprettet af tool_generator eller $CFG->tool_generator_users_password ikke blev defineret da du oprettede testkurserne.';
