<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_catalogue', language 'da', version '4.4'.
 *
 * @package     tool_catalogue
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutthiscourse'] = 'Om dette kursus.';
$string['aboutthisprogram'] = 'Om dette program.';
$string['all'] = 'Alle.';
$string['allavailablecourses'] = 'Alle tilgængelige kurser.';
$string['allowhtmltags'] = 'Tillad HTML tags.';
$string['aria:courseactions'] = 'Kursushandlinger.';
$string['cachedef_filters'] = 'Søgeresultater og filtre i læringskataloget.';
$string['catalogue'] = 'Katalog.';
$string['catalogue:config'] = 'Konfigurer læringskatalog.';
$string['catalogueisdisabled'] = 'Læringskatalog er deaktiveret.';
$string['cataloguesettings'] = 'Mine program- og kursuskatalogindstillinger.';
$string['categories'] = 'Kategorier.';
$string['categoriesdepthlimit'] = 'Maksimalt antal niveauer for indlejrede kategorier.';
$string['categoriesdepthlimit_desc'] = 'Maksimalt antal niveauer for indlejrede kategorier i kategorivælgeren. Kurser på dybere niveauer vil stadig vises i søgeresultaterne';
$string['categorieslimit'] = 'Maksimalt antal kategorier på samme niveau.';
$string['categorieslimit_desc'] = 'Maksimalt antal kategorier på samme niveau i kategorivælgeren. Kategorier vises i samme rækkefølge, som de er defineret på siden Kursusadministration. Hvis der er flere kategorier på ét niveau, vises kategorierne ikke i vælgeren, men alle kurserne vil være synlige i søgeresultaterne';
$string['certifications'] = 'Certificeringer.';
$string['certificationstatuscertified'] = 'Certificeringen \'<strong>{$a->name}</strong>\' er fuldført';
$string['certificationstatuscertifiedwithdate'] = 'Certificeringen \'<strong>{$a->name}</strong>\' er fuldført. Den udløber \'<strong>{$a->date}</strong>\'';
$string['certificationstatusexpired'] = 'Certificeringen \'<strong>{$a->name}</strong>\' udløb den {$a->date}';
$string['certificationstatusopen'] = 'Certificeringen \'<strong>{$a->name}</strong>\' har ingen forfaldsdato';
$string['certificationstatusopenwithdate'] = 'Gennemfør dette program senest \'<strong>{$a->date}</strong>\' for at få certificeringen \'<strong>{$a->name}</strong>\'';
$string['certificationstatusoverdue'] = 'Certificeringen \'<strong>{$a->name}</strong>\' forfaldt den \'<strong>{$a->date}</strong>\'';
$string['clearall'] = 'Ryd alt.';
$string['complete'] = 'Gennemført.';
$string['completeatleast'] = 'Gennemfør mindst {$a}.';
$string['coursecoverhelp'] = 'Dette kursus er en del af "{$a}" program.';
$string['coursecoverhelpmultiprogram'] = 'Dette kurus er en del af nogle programmer.';
$string['coursecoverhelptext'] = '<ul><li>Dette er blot ét kursus inden for større programmer</li><li>Nye kurser kan være tilgængelige efter fuldførelsen af dette</li></ul>.';
$string['coursedisplayduelimit'] = 'Vis resterende dage for kurser.';
$string['coursedisplayduelimit_desc'] = 'Antal dage før kurset afsluttes, hvor brugerne vil se en lille påmindelse ("X dage tilbage") ved siden af kursusnavnet. Hvis dette f.eks. er sat til 14, vil påmindelsen være synlig i de 14 dage, før kurset når sin afslutningsdato. I tilfælde af mange forskellige afslutningsdatoer vil systemet vurdere, hvilken der er den næste. Sæt til 0 for at deaktivere denne funktion';
$string['coursefiles'] = 'Kursus filer.';
$string['courseimage_help'] = 'Kursusbilledet';
$string['coursenotavailable'] = 'Kurset er ikke tilgængelig.';
$string['courses'] = 'Kurser.';
$string['coursesperpage_frontpage'] = 'Antal kurser pr. side, startside.';
$string['coursesperpage_frontpage_desc'] = 'Antal kurser, der skal vises på startsiden, når "Liste over kurser" er inkluderet i indstillingen Elementer på startsiden';
$string['coursesperpage_main'] = 'Antal kurser pr. side, hovedkatalogside.';
$string['coursesperpage_main_desc'] = 'Antal kurser, der skal vises på hovedkatalogsiden, før en kategori er valgt eller en søgeforespørgsel er angivet, og før der er anvendt filtre';
$string['coursesperpage_search'] = 'Antal kurser pr. side, søgeresultater.';
$string['coursesperpage_search_desc'] = 'Antal kurser, der skal vises i kursussøgeresultaterne, eller når en kategori er valgt';
$string['dates'] = 'Datoer.';
$string['daysleft'] = '{$a} dage tilbage.';
$string['defaultsortorder'] = 'Standard sorteringsrækkefølge.';
$string['display'] = 'Visning.';
$string['displaycourseinfomodal'] = 'Vis kursusinfo-modal.';
$string['displayfieldlabel'] = 'Vis feltnavn.';
$string['displayfields_desc'] = 'Vælg alle de felter, der skal vises som filtre, og arranger dem i den ønskede rækkefølge. Ikke alle typer brugerdefinerede felter kan bruges i filtre.<br>Ændringer i tabellen ovenfor gemmes automatisk';
$string['displayfields_list'] = 'Felter, der skal vises i \'liste\'-visningen (detaljeret visning) af læringskataloget.';
$string['displayfields_tiles'] = 'Felter, der skal vises i \'flise\'-visningen (kompakt visning) af læringskataloget.';
$string['displayfieldscard_desc'] = 'Vælg alle de felter, der skal vises på kursuskortet, og arranger dem i den ønskede rækkefølge.<br>Ændringer i tabellen ovenfor gemmes automatisk';
$string['displayforeverybody'] = 'Vis for alle.';
$string['displayfornotadmin'] = 'Vis kun for brugere, der ikke er administratorer.';
$string['displayforstudentsandguests'] = 'Vis kun under gæsteadgang og for studerende.';
$string['displaynever'] = 'Vis aldrig.';
$string['displayprogramcoverpage'] = 'Vis programforside.';
$string['displaysummaryasis'] = 'Vis som den er.';
$string['displaysummarynohtml'] = 'Vis uden HTML.';
$string['displaysummarynone'] = 'Vis ikke.';
$string['dontshowagain'] = 'Vis ikke den besked igen.';
$string['duedate'] = 'Sortér efter afslutningsdato.';
$string['duedateinfo'] = 'Forfalder om 1 dag.';
$string['duedateinfodays'] = 'Forfalder om  {$a} dage.';
$string['duedatex'] = '<strong>Forfaldsdato:</strong> {$a}.';
$string['editlabel'] = 'Rediger etiket.';
$string['enablelearningcatalogue'] = 'Aktiver læringskataloget.';
$string['enablelearningcatalogue_desc'] = 'Aktivér denne indstilling for at give alle brugere adgang til \'Kataloget\' i hovednavigationen. Dette giver dem mulighed for nemt at finde, filtrere og tilmelde sig kurser. Moodle Workplace-kataloget vil erstatte standardsiden for kurser for alle brugere.
<br><br>For yderligere oplysninger, se <a href="{$a}">dokumentationssiden</a>';
$string['enddate'] = 'Slutdato.';
$string['enddatex'] = '<strong>Slutdato:</strong> {$a}.';
$string['errornopermissionviewcoursecover'] = 'Ingen tilladelse til at se kursets forside.';
$string['errornopermissionviewprogram'] = 'Ingen tilladelse til at se programmet.';
$string['featuredcustomfield'] = 'Fremhævet brugerdefineret felt.';
$string['featuredcustomfield_desc'] = 'Hvis det valgte brugerdefinerede felt er markeret som \'afkrydset\' i et kursus, vil kurset blive fremhævet på katalogets hovedside';
$string['featuredlearning'] = 'Fremhævet læring.';
$string['featuredlearningdisabled'] = 'Fremhævet læring er deaktiveret';
$string['featuredlearningsectionsummary'] = 'Beskrivelse af fremhævet sektion.';
$string['featuredlearningsectionsummary_desc'] = 'Denne tekst vil blive vist sammen med fremhævede kurser i \'Fremhævet\'-sektionen på katalogets hovedside';
$string['featuredlearningsectiontitle'] = 'Titel på fremhævet sektion.';
$string['featuredlearningsectiontitle_default'] = 'Fremhævet.';
$string['featuredlearningsectiontitle_desc'] = 'Overskriv titlen på \'Fremhævet\'-sektionen i kataloget. Hvis feltet efterlades tomt, vil standardtitlen \'Fremhævet\' blive vist';
$string['fieldlabel'] = 'Feltnavn.';
$string['fieldonlyvisibleincatalogue'] = 'Dette felt har begrænset synlighed på kursusinformations- og tilmeldingssiderne, men det kan stadig gøres tilgængeligt i læringskataloget. Hvis det er aktiveret her, vil feltet være synligt for alle';
$string['filterfields'] = 'Felter, der skal vises i læringskatalogets filter.';
$string['hiddenfromlearners'] = 'Skjult for kursister.';
$string['htmltagsall'] = 'Tillad alle HTML-tags.';
$string['htmltagsnone'] = 'Fjern alle HTML-tags.';
$string['htmltagssafe'] = 'Kun sikre HTML tags.';
$string['incomplete'] = 'Ikke gennemført.';
$string['information'] = 'Information.';
$string['iunderstand'] = 'Forstået.';
$string['lastaccess'] = 'Sortér efter sidst besøgt.';
$string['learningcataloguesettings'] = 'Indstillinger for læringskatalog.';
$string['moreinfo'] = 'Mere information.';
$string['mycourses'] = 'Mine kurser.';
$string['name'] = 'Sortér efter navn.';
$string['noresultsfor'] = '\'Ingen resultater for {$a}\'.';
$string['notavailableunless'] = 'Ikke tilgængelig medmindre  \'<strong>{$a}</strong>\'  er tilgængelig';
$string['notavailableuntil'] = 'Ikke tilgængelig før \'{$a}\' er fuldført.';
$string['notnow'] = 'Ikke nu.';
$string['notset'] = 'Ikke angivet.';
$string['overdue'] = 'Overskredet.';
$string['pagealastpage'] = 'Side  {$a}, sidste side';
$string['pageamorepagesahead'] = 'Side  {$a}, flere sider forude';
$string['pagination'] = 'sideinddeling';
$string['pluginname'] = 'Læringskatalog.';
$string['privacy:metadata:preference:tool_catalogue_collapse_recently_accessed_courses'] = 'Om sektionen "Senest tilgåede kurser" skal skjules som standard.';
$string['privacy:metadata:preference:tool_catalogue_hide_program_cover_help'] = 'Om hjælpen til programforsiden skal vises.';
$string['privacy:metadata:preference:tool_catalogue_my_courses_filter'] = 'Om programmerne/kurserne skal filtreres efter alle/kurser/programmer/fuldført/ikke-fuldført.';
$string['privacy:metadata:preference:tool_catalogue_my_courses_sort'] = 'Om programmerne/kurserne skal sorteres efter navn/forfaldsdato/seneste adgang.';
$string['privacy:metadata:showprogramcoverhelp'] = 'Om hjælpen til programforsiden skal vises.';
$string['privacy:request:preference:set'] = 'Værdien af indstillingen \'{$a->name}\' var \'{$a->value}\'.';
$string['proceedtocourse'] = 'Fortsæt til kursusindhold.';
$string['proceedtoprogram'] = 'Fortsæt til programindhold.';
$string['program'] = 'Program.';
$string['programdisplayduelimit'] = 'Vis antal dage tilbage, indtil programmet forfalder.';
$string['programdisplayduelimit_desc'] = 'Antal dage før programmet forfalder, hvor brugerne vil se en lille påmindelse ("Forfalder om X dage") ved siden af programnavnet. Hvis dette f.eks. er sat til 14, vil påmindelsen være synlig i de 14 dage, før programmet når sin forfaldsdato. Sæt til 0 for at deaktivere denne funktion';
$string['programempty'] = 'Der er ingen kurser i dette program.';
$string['programhelptext'] = '<ul><li>Programmer kan indeholde forskellige kurser</li><li>Fuldfør kurserne for at fuldføre programmet</li></ul>.';
$string['programhelptitle'] = 'Hvad er et program?.';
$string['programimage_help'] = 'Programbilledet.';
$string['programlink'] = 'Se "{$a}" detaljer.';
$string['programlinksingle'] = 'Se programdetaljer.';
$string['programs'] = 'Programmer.';
$string['programstructure'] = 'Programstruktur.';
$string['progress'] = '{$a}% gennemført.';
$string['progresscompleted'] = '{$a->completed} ud af {$a->total} gennemført.';
$string['recentlyaccessedcourses'] = 'Nyligt besøgte kurser.';
$string['reg_wpcatalogueashome'] = 'Kataloget er aktiveret og tilføjet til startsiden ({$a}).';
$string['reg_wpcatalogueenabled'] = 'Kataloget er aktiveret ({$a}).';
$string['reg_wpcataloguepublic'] = 'Kataloget er aktiveret og tilgængeligt for gæster ({$a}).';
$string['reindextaskname'] = 'Regelmæssig genindeksering af kurser til kataloget.';
$string['resultsfor'] = '{$a->count} resultater for \'{$a->keywords}\'.';
$string['safehtmltags'] = 'Sikre HTML-tags i resume- og tekstfelter.';
$string['safehtmltags_desc'] = 'Liste over de HTML-tags, der skal bevares, når kursoversigter eller brugerdefinerede kursusfelter vises i læringskataloget. Alle andre tags fjernes for at sikre, at kursoversigterne ikke ødelægger katalogets layout.<br>Bemærk, at HTML-tags for kursoversigter muligvis ikke fungerer godt sammen med indstillingen \'Afkort\'';
$string['searchfields'] = 'Felter der skal søges i efter nøgleord.';
$string['searchfields_desc'] = 'Vælg alle kursusfelter hvor søgeordet skal søges efter, og arranger dem i prioritetsrækkefølge.<br>Ændringer i tabellen ovenfor gemmes automatisk';
$string['searchmethod'] = 'Kursussøgningsmetode.';
$string['searchmethod_desc'] = 'Vælg en metode, der skal bruges til kurssøgning. Nogle metoder kan kræve regelmæssig genindeksering og/eller yderligere konfiguration';
$string['searchmethod_extended'] = 'Udvidet søgning.';
$string['searchmethod_simple'] = 'Simpel søgning.';
$string['searchplaceholder'] = 'Søg kurser eller programmer.';
$string['selectenrolmentmethod'] = 'Vælg en tilmeldingsmetode.';
$string['showcataloguecoursecategory'] = 'Vis kursuskategori i kursuskort.';
$string['showcataloguecoursecategory_desc'] = 'Kursuskategorien vil være synlig i hvert kursuskort, der findes i ‘Dashboard’, ‘Mine kurser’ og nogle blokke';
$string['showcoursedates'] = 'Vis kursusdatoer i kursusmodal.';
$string['showcoursedates_desc'] = 'Kursusdatoerne vil være synlige i kursusmodalen og i kursusinformationsfanen';
$string['showfeaturedsection'] = 'Vis fremhævet sektion i kataloget.';
$string['showfeaturedsection_desc'] = 'Hvis aktiveret, vil fremhævede kurser blive vist i en selvstændig sektion øverst på katalogets hovedside';
$string['showmore'] = 'Vis {$a} mere..';
$string['startdate'] = 'Startdato.';
$string['startdatex'] = '<strong>Startdato:</strong> {$a}.';
$string['todo'] = 'To-do:.';
$string['trainers'] = 'Instruktører.';
$string['truncatesummary'] = 'Afkort kursoversigt.';
$string['truncatesummary_desc'] = 'Maksimalt antal tegn, der skal vises i kursets resumé, når det vises. Sæt til 0 for ikke at afkorte på serversiden. Resuméet kan stadig forkortes med CSS-stile på skærmen.<br>Denne indstilling styrer den tekst, der sendes fra serveren til browseren. Du kan også vælge at afkorte individuelle felter direkte i browseren ved hjælp af brugerdefineret CSS';
$string['trydifferentskeyword'] = 'Prøv at bruge andre nøgleord eller filterkonfiguration.';
$string['xcourses'] = '{$a} kurser.';
