<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'workshop', language 'sk', version '4.4'.
 *
 * @package     workshop
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitydate:assessmentsclose'] = 'Uzavretie hodnotenia';
$string['activitydate:assessmentsclosed'] = 'Uzavreté hodnotenia:';
$string['activitydate:assessmentsopen'] = 'Otvorenie hodnotenia:';
$string['activitydate:assessmentsopened'] = 'Otvorené hodnotenia:';
$string['activitydate:submissionsclose'] = 'Uzavretie odovzdaných prác:';
$string['activitydate:submissionsclosed'] = 'Uzavreté odovzdané práce:';
$string['activitydate:submissionsopen'] = 'Otvorenie odovzdaných prác:';
$string['activitydate:submissionsopened'] = 'Otvorené odovzdané práce';
$string['aggregategrades'] = 'Prepočítať známky';
$string['aggregation'] = 'Výpočet súhrnných známok';
$string['allocate'] = 'Prideliť práce na hodnotenie';
$string['allocatedetails'] = 'očakávané: {$a->expected}<br />vložené: {$a->submitted}<br />na rozdelenie: {$a->allocate}';
$string['allocation'] = 'Prideľovanie odovzdaných prác na hodnotenie';
$string['allocationconfigured'] = 'Pridelenie nastavené';
$string['allocationdone'] = 'Prideľovanie bolo ukončené';
$string['allocationerror'] = 'Chyba pri prideľovaní prác';
$string['allowedfiletypesforoverallfeedback'] = 'Prílohy komentára povoľujú súbory typu';
$string['allowedfiletypesforoverallfeedback_help'] = 'Prílohy komentáre povoľujú typy súborov - tieto môžu byť obmedzené poskytnutím zoznamu povolených typov súborov. Ak je pole prázdne, sú povolené všetky.';
$string['allowedfiletypesforoverallfeedback_link'] = 'admin/tool/filetypes/index';
$string['allowedfiletypesforsubmission'] = 'Prílohy odovzdaných prác povoľujú súbory typu';
$string['allowedfiletypesforsubmission_help'] = 'Prílohy odovzdaných prác povoľujú typy súborov - tieto môžu byť obmedzené poskytnutím zoznamu povolených typov súborov. Ak je pole prázdne, sú povolené všetky.';
$string['allowedfiletypesforsubmission_link'] = 'admin/tool/filetypes/index';
$string['allsubmissions'] = 'Všetky odovzdané práce ({$a})';
$string['alreadygraded'] = 'Ohodnotené';
$string['areaconclusion'] = 'Text zhrnutia';
$string['areainstructauthors'] = 'Pokyny k vypracovaniu odovzdávaných prác';
$string['areainstructreviewers'] = 'Pokyny pre hodnotenie';
$string['areaoverallfeedbackattachment'] = 'Prílohy celkovej spätnej väzby';
$string['areaoverallfeedbackcontent'] = 'Texty celkovej spätnej väzby';
$string['areasubmissionattachment'] = 'Prílohy odovzdaných prác';
$string['areasubmissioncontent'] = 'Texty odovzdaných prác';
$string['assess'] = 'Hodnotiť';
$string['assessedexample'] = 'Ohodnotená ukážka práce';
$string['assessedsubmission'] = 'Ohodnotená odovzdaná práca';
$string['assessingexample'] = 'Hodnotenie ukážok prác';
$string['assessingsubmission'] = 'Hodnotenie odovzdanej práce';
$string['assessment'] = 'Hodnotenia';
$string['assessmentby'] = 'od <a href="{$a->url}">{$a->name}</a>';
$string['assessmentbyfullname'] = 'Hodnotenie od {$a}';
$string['assessmentbyyourself'] = 'Vaše hodnotenie';
$string['assessmentdeleted'] = 'Zrušené pridelenie práce k hodnoteniu';
$string['assessmentend'] = 'Koniec hodnotenia';
$string['assessmentendbeforestart'] = 'Uzávierku hodnotenia nemožno určiť pred dňom začiatku hodnotenia';
$string['assessmentenddatetime'] = 'Termín pre hodnotenie: {$a->daydatetime} ({$a->distanceday})';
$string['assessmentendevent'] = '{$a} uzávierka hodnotenia';
$string['assessmentform'] = 'Hodnotiaci formulár';
$string['assessmentofsubmission'] = '<a href="{$a->assessmenturl}">Hodnotenie</a> práce <a href="{$a->submissionurl}">{$a->submissiontitle}</a>';
$string['assessmentreference'] = 'Referenčné hodnotenie';
$string['assessmentreferenceconflict'] = 'Nie je možné hodnotiť ukážku práce, pre ktorú ste poskytli  referenčné hodnotenie.';
$string['assessmentreferenceneeded'] = 'Teraz musíte túto ukážku práce objektívne ohodnotiť a poskytnúť tak tzv. referenčné hodnotenie. Pre hodnotenie kliknite na tlačidlo \'Pokračovať';
$string['assessments'] = 'Hodnotenia';
$string['assessmentsettings'] = 'Nastavenia hodnotenia';
$string['assessmentstart'] = 'Začiatok hodnotenia';
$string['assessmentstartdatetime'] = 'Hodnotenie je dostupné od {$a->daydatetime} ({$a->distanceday})';
$string['assessmentstartevent'] = '{$a} zahájenie hodnotenia';
$string['assessmentweight'] = 'Váha hodnotenia';
$string['assignedassessments'] = 'Pridelené práce na hodnotenie';
$string['assignedassessmentsnone'] = 'Neboli vám pridelené žiadne práce na hodnotenie';
$string['backtoeditform'] = 'Späť k úpravám formulára';
$string['byfullname'] = 'od <a href="{$a->url}">{$a->name}</a>';
$string['byfullnamewithoutlink'] = 'od {$a}';
$string['calculategradinggrades'] = 'Vypočítať známku za hodnotenie';
$string['calculategradinggradesdetails'] = 'očakávané: {$a->expected}<br />vypočítané: {$a->calculated}';
$string['calculatesubmissiongrades'] = 'Vypočítať známku za odovzdanú prácu';
$string['calculatesubmissiongradesdetails'] = 'očakávané: {$a->expected}<br />vypočítané: {$a->calculated}';
$string['chooseuser'] = 'Vyberte si používateľa ...';
$string['clearaggregatedgrades'] = 'Vymazať všetky vypočítané súhrnné známky';
$string['clearaggregatedgrades_help'] = 'Súhrnné hodnotenia za odovzdané práce a za ohodnotenia budú vynulované. Vo fáze evaluácie hodnotenia môžete tieto hodnotenia znovu vypočítať od začiatku.';
$string['clearaggregatedgradesconfirm'] = 'Naozaj chcete vymazať všetky vypočítané súhrnné známky za odovzdané práce a známky za hodnotenia?';
$string['clearassessments'] = 'Vymazať hodnotenie';
$string['clearassessments_help'] = 'Vypočítané hodnotenia za odovzdané práce  a za ohodnotenia budú vynulované.  Informácie o tom, ako sú formuláre hodnotenia vyplnené, sa stále uchováva, ale všetci hodnotitelia musia znovu otvoriť svoje formuláre hodnotenia a potom ich uložiť, aby sa znovu vypočítali.';
$string['clearassessmentsconfirm'] = 'Skutočne si želáte vyčistiť všetky hodnotenia? Túto informáciu nebudete môcť sám obnoviť - hodnotitelia budú musieť pridelené predložené práce ohodnotiť znovu.';
$string['conclusion'] = 'Zhrnutie';
$string['conclusion_help'] = 'Text záverečného zhrnutia sa zobrazí účastníkom na konci aktivity.';
$string['configexamplesmode'] = 'Východzí spôsob hodnotenia príkladov vo workshopoch';
$string['configgrade'] = 'Východzia maximálna známka za odovzdanú prácu vo workshopoch';
$string['configgradedecimals'] = 'Východzí počet desatinných miest pri zobrazovaní známok';
$string['configgradinggrade'] = 'Východzia maximálna známka pre hodnotenie vo workshopoch';
$string['configmaxbytes'] = 'Východzia veľkosť súborov pre všetky workshopy na portáli (ďalšie obmedzenia sú dané nastaveniami kurzov a inými lokálnymi zmenami)';
$string['configstrategy'] = 'Východzia stratégia hodnotenia vo workshopoch';
$string['createsubmission'] = 'Pridať svoju prácu';
$string['crontask'] = 'Spracovanie pre modul workshop na pozadí';
$string['daysago'] = 'pred {$a} dňami';
$string['daysleft'] = 'ostáva {$a} dní';
$string['daystoday'] = 'dnes';
$string['daystomorrow'] = 'zajtra';
$string['daysyesterday'] = 'včera';
$string['deadlinesignored'] = 'Časové obmedzenia sa na vás nevzťahujú';
$string['deletesubmission'] = 'Odstrániť riešenie zadania';
$string['editassessmentform'] = 'Upraviť hodnotiaci formulár';
$string['editassessmentformstrategy'] = 'Upraviť hodnotiaci formulár ({$a})';
$string['editingassessmentform'] = 'Úprava hodnotiaceho formulára';
$string['editingsubmission'] = 'Úprava odovzdanej práce';
$string['editsubmission'] = 'Upraviť odovzdanú prácu';
$string['err_multiplesubmissions'] = 'Počas úpravy tohto formulára bola uložená iná verzia tejto práce. Nie je povolené viacero vložení pre jedného používateľa.';
$string['err_removegrademappings'] = 'Chyba pri odstraňovaní nepoužitého mapovania známok';
$string['evaluategradeswait'] = 'Prosím počkajte, kým budú vyhodnotené hodnotenia a vypočítané známky';
$string['evaluation'] = 'Evaluácia hodnotenia';
$string['evaluationmethod'] = 'Metóda evaluácie hodnotenia';
$string['evaluationmethod_help'] = 'Metóda evaluácie hodnotenia určuje, ako sa vypočítavajú ohodnotenia z hodnotení hodnotiteľov. Môžete ich nechať prepočítať opakovane s rôznymi nastaveniami, kým nie ste s výsledkom spokojný.';
$string['evaluationsettings'] = 'Nastavenia evaluácie';
$string['eventassessableuploaded'] = 'Práca bola odovzdaná.';
$string['eventassessmentevaluated'] = 'Hodnotenie evaluované';
$string['eventassessmentevaluationsreset'] = 'Evaluácie hodnotenia vynulované';
$string['eventassessmentreevaluated'] = 'Hodnotenie znovu evaluované';
$string['eventphaseautomaticallyswitched'] = 'Fáza sa automaticky prepne';
$string['eventphaseswitched'] = 'Fáza prepnutá';
$string['eventsubmissionassessed'] = 'Príspevok hodnotený';
$string['eventsubmissionassessmentsreset'] = 'Hodnotenie príspevkov odstránené';
$string['eventsubmissioncreated'] = 'Príspevok vytvorený';
$string['eventsubmissiondeleted'] = 'Odovzdaná práca bola vymazaná';
$string['eventsubmissionreassessed'] = 'Príspevok znovu hodnotený';
$string['eventsubmissionupdated'] = 'Príspevok aktualizovaný';
$string['eventsubmissionviewed'] = 'Príspevok prezeraný';
$string['example'] = 'Ukážka práce';
$string['exampleadd'] = 'Pridať ukážku práce';
$string['exampleassess'] = 'Hodnotiť ukážku práce';
$string['exampleassessments'] = 'Ukážky prác k hodnoteniu';
$string['exampleassesstask'] = 'Hodnotiť ukážky prác';
$string['exampleassesstaskdetails'] = 'očakávané: {$a->expected}<br />hodnotené: {$a->assessed}';
$string['examplecomparing'] = 'Porovnanie hodnotenia tejto ukážkovej práce';
$string['exampledelete'] = 'Odstrániť ukážku práce';
$string['exampledeleteconfirm'] = 'Naozaj chcete vymazať nasledovnú ukážkovú prácu? Ak áno, kliknite na tlačidlo \'Pokračovať\'.';
$string['exampleedit'] = 'Upraviť ukážku práce';
$string['exampleediting'] = 'Úprava ukážky práce';
$string['exampleneedassessed'] = 'Najprv musíte ohodnotiť všetky ukážky prác';
$string['exampleneedsubmission'] = 'Musíte najprv vložiť svoje zadanie a ohodnotiť všetky ukážky prác';
$string['examplesbeforeassessment'] = 'Ukážky prác sú dostupné potom, čo vložíte vlastné zadanie a musia byť ohodnotené pred samotným hodnotením ostatných.';
$string['examplesbeforesubmission'] = 'Ukážky prác musia byť ohodnotené pred vlastným zadaním.';
$string['examplesmode'] = 'Spôsob hodnotenia ukážok prác';
$string['examplesubmissions'] = 'Ukážky prác';
$string['examplesvoluntary'] = 'Ohodnotenie ukážky práce je dobrovoľné.';
$string['exportsubmission'] = 'Exportovať túto stránku';
$string['feedbackauthor'] = 'Spätná väzba pre autora práce';
$string['feedbackauthorattachment'] = 'Príloha';
$string['feedbackby'] = 'Spätná väzba od {$a}';
$string['feedbackreviewer'] = 'Spätná väzba pre hodnotiteľa';
$string['feedbacksettings'] = 'Komentár';
$string['formataggregatedgrade'] = '{$a->grade}';
$string['formataggregatedgradeover'] = '<del>{$a->grade}</del><br /><ins>{$a->over}</ins>';
$string['formatpeergrade'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span>';
$string['formatpeergradeover'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span>';
$string['formatpeergradeoverweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span> @ <span class="weight">{$a->weight}</span>';
$string['formatpeergradeweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span> @ <span class="weight">{$a->weight}</span>';
$string['givengrades'] = 'Zadané známky';
$string['grade_grading_name'] = 'Hodnotenie';
$string['grade_submission_name'] = 'Odovzdaná práca';
$string['gradecalculated'] = 'Vypočítaná známka za odovzdanú prácu';
$string['gradedecimals'] = 'Počet desatinných miest v známkach';
$string['gradegivento'] = '&gt;';
$string['gradeinfo'] = 'Známka: {$a->received} z {$a->max}';
$string['gradeitemassessment'] = '{$a->workshopname} (hodnotenie)';
$string['gradeitemsubmission'] = '{$a->workshopname} (práca)';
$string['gradeover'] = 'Prepísať vypočítanú známku za odovzdanú prácu';
$string['gradereceivedfrom'] = '&lt;';
$string['gradesreport'] = 'Prehľad známok';
$string['gradetopassgrading'] = 'Požadované hodnotenie úlohy na absolvovanie';
$string['gradetopasssubmission'] = 'Požadované hodnotenie odovzdanej úlohy na absolvovanie';
$string['gradinggrade'] = 'Známka za hodnotenie';
$string['gradinggrade_help'] = 'Toto nastavenie určuje maximálne ohodnotenie, ktoré je možné získať sa hodnotenie príspevku.';
$string['gradinggradecalculated'] = 'Vypočítaná známka za hodnotenie';
$string['gradinggradeof'] = 'Vypočítaná známka za hodnotenie (z {$a})';
$string['gradinggradeover'] = 'Prepísať známku za hodnotenie';
$string['gradingsettings'] = 'Nastavenie známkovania';
$string['groupnoallowed'] = 'Nemáte povolené pristupovať k akejkoľvek skupine v tomto workshope';
$string['iamsure'] = 'Áno som si istý';
$string['indicator:cognitivedepth'] = 'Kognitívny Workshop';
$string['indicator:cognitivedepth_help'] = 'Tento indikátor je založený na študentom získanej kognitívnej hĺbke v aktivite Pracovná dielňa.';
$string['indicator:cognitivedepthdef'] = 'Kognitivny Workshop';
$string['indicator:cognitivedepthdef_help'] = 'Počas tohto intervalu analýzy dosiahol účastník toto percento kognitívnej angažovanosti ponúkanej aktivitami Pracovná dielňa (Úrovne = Bez zobrazenia, Zobrazenie, Príspevok, Zobrazenie spätnej väzby, Komentár k spätnej väzbe, Nový príspevok po zobrazení spätnej väzby)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Sociálny Workshop';
$string['indicator:socialbreadth_help'] = 'Tento indikátor je založený na študentom získanej sociálnej šírke v aktivite Pracovná dielňa.';
$string['indicator:socialbreadthdef'] = 'Sociálny Workshop';
$string['indicator:socialbreadthdef_help'] = 'Počas tohto intervalu analýzy dosiahol účastník toto percento sociálnej angažovanosti ponúkanej aktivitami Pracovná dielňa (Úrovne = Bez účasti, Účastník sám, Účastník s ostatnými)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['info'] = 'Informácia';
$string['instructauthors'] = 'Pokyny pre vypracovanie odovzdávaných prác';
$string['instructreviewers'] = 'Pokyny pre hodnotenie pridelených prác';
$string['introduction'] = 'Opis';
$string['latesubmissions'] = 'Oneskorené odovzdanie';
$string['latesubmissions_desc'] = 'Povoliť odovzdávanie prác po termíne';
$string['latesubmissions_help'] = 'Ak je táto možnosť aktivovaná, autor môže poslať svoju prácu po termíne uzávierky príspevkov alebo počas fázy hodnotenia. Tieto neskoré príspevky ale už nie je možné editovať.';
$string['latesubmissionsallowed'] = 'Oneskorené odovzdanie je povolené';
$string['maxbytes'] = 'Maximálna veľkosť prílohy na odoslanie';
$string['modulename'] = 'Workshop';
$string['modulename_help'] = 'Modul Workshop umožňuje zber, posudzovanie a vzájomné hodnotenie práce študentov.

Študenti môžu odovzdávať akýkoľvek digitálny obsah (súbory), ako napríklad textové dokumenty, súbory tabuľkového procesora a môžu takisto text napísať priamo do poľa použitím textového editora.

Odovzdané príspevky sú hodnotené použitím formulára pre viackritériové hodnotenie, ktorý definuje lektor. Proces vzájomného hodnotenia a pochopenia hodnotiaceho formulára je možné precvičovať vopred s ukážkami príspevkov, ktoré poskytol lektor spolu s referenčným hodnotením. Študenti dostanú možnosť hodnotiť jeden alebo viac príspevkov svojich spolužiakov. Príspevky a hodnotitelia môžu byť podľa potreby anonymní.

Študenti získajú v modulu Workshop dve hodnotenia - jedno za svoj vlastný príspevok a druhé za hodnotenie príspevkov spolužiakov. Obe hodnotenia sa zapíšu do hodnotiaceho záznamu.';
$string['modulename_link'] = 'mod/workshop/view';
$string['modulenameplural'] = 'Workshopy';
$string['myassessments'] = 'Moje hodnotenia';
$string['mysubmission'] = 'Moja práca';
$string['nattachments'] = 'Maximálny počet priložených súborov';
$string['noexamples'] = 'Tento workshop zatiaľ neobsahuje žiadne ukážky prác';
$string['noexamplesformready'] = 'Pred vložením ukážok prác musíte najprv definovať hodnotiaci formulár';
$string['nogradeyet'] = 'Zatiaľ žiadna známka';
$string['nosubmissionfound'] = 'Tento používateľ zatiaľ neodovzdal svoju prácu';
$string['nosubmissions'] = 'Tento workshop zatiaľ neobsahuje žiadne odovzdané práce';
$string['nosubmissiontype'] = 'Musí byť k dispozícii aspoň jeden typ príspevku';
$string['notassessed'] = 'Ešte nehodnotené';
$string['nothingfound'] = 'Nič na zobrazenie';
$string['nothingtoreview'] = 'Nič na preskúmanie';
$string['notoverridden'] = 'Neprepisované';
$string['noworkshops'] = 'Tento kurz neobsahuje žiadne workshopy';
$string['noyoursubmission'] = 'Zatiaľ ste neodovzdali svoju prácu';
$string['nullgrade'] = '-';
$string['overallfeedback'] = 'Celková spätná väzba';
$string['overallfeedbackfiles'] = 'Maximálny počet príloh celkového komentára';
$string['overallfeedbackmaxbytes'] = 'Maximálna celková veľkosť pripomienok';
$string['overallfeedbackmode'] = 'Režim celkového komentára';
$string['overallfeedbackmode_0'] = 'Deaktivované';
$string['overallfeedbackmode_1'] = 'Aktivované a voliteľné';
$string['overallfeedbackmode_2'] = 'Aktivované a povinné';
$string['overallfeedbackmode_help'] = 'Ak je táto možnosť aktivovaná, v spodnej časti hodnotiaceho formulára sa zobrazí textové pole. Hodnotitelia sem môžu vložiť celkové hodnotenie príspevku, alebo poskytnúť dodatočné vysvetlenie ich hodnotenia.';
$string['page-mod-workshop-x'] = 'Akákoľvek stránka workshopu';
$string['participant'] = 'Účastník';
$string['participantrevierof'] = 'Účastník bude hodnotiť';
$string['participantreviewedby'] = 'Účastník bude hodnotený';
$string['phaseassessment'] = 'Hodnotenie';
$string['phaseclosed'] = 'Zatvorené';
$string['phaseevaluation'] = 'Hodnotiaca fáza';
$string['phasesetup'] = 'Nastavenie';
$string['phasesoverlap'] = 'Fázy príspevku a hodnotenia sa nemôžu prekrývať';
$string['phasesubmission'] = 'Odovzdávanie';
$string['pluginadministration'] = 'Správa workshopu';
$string['pluginname'] = 'Workshop';
$string['prepareexamples'] = 'Pripraviť ukážky prác';
$string['previewassessmentform'] = 'Náhľad';
$string['privacy:metadata:aggregatedgradinggrade'] = 'Súhrnná známka pre všetky hodnotenia vykonaná používateľom v danej aktivite Workshop';
$string['privacy:metadata:assessmentgrade'] = 'Súhrnná známka odovzdanej práce navrhnutá týmto hodnotením';
$string['privacy:metadata:assessmentgradinggrade'] = 'Známka získaná z hodnotenia';
$string['privacy:metadata:assessmentgradinggradeover'] = 'Ručne prepisovaná hodnota známky získaná z hodnotenia';
$string['privacy:metadata:assessmentid'] = 'ID hodnotenia';
$string['privacy:metadata:authorid'] = 'ID odosielateľa';
$string['privacy:metadata:dimensiongrade'] = 'Známka v danom rozmere hodnotenia';
$string['privacy:metadata:dimensionid'] = 'ID rozmeru hodnotenia';
$string['privacy:metadata:example'] = 'Či tento záznam predstavuje príklad riešenia';
$string['privacy:metadata:feedbackauthor'] = 'Spätná väzba pre autora';
$string['privacy:metadata:feedbackauthorformat'] = 'Textový formát spätnej väzby pre autora';
$string['privacy:metadata:feedbackreviewer'] = 'Spätná väzba pre používateľa poskytujúceho hodnotenie';
$string['privacy:metadata:feedbackreviewerformat'] = 'Textový formát spätnej väzby pre používateľov poskytujúcich hodnotenie';
$string['privacy:metadata:late'] = 'Či bolo vypracované zadanie po uzávierke';
$string['privacy:metadata:peercomment'] = 'Komentár k danému hodnoteniu používateľom, ktorý poskytuje hodnotenie';
$string['privacy:metadata:peercommentformat'] = 'Textový formát komentára k danej známke';
$string['privacy:metadata:preference:perpage'] = 'Počet príspevkov, ktoré používateľ uprednostňuje vidieť na jednej stránke';
$string['privacy:metadata:preference:viewlet-allexamples-collapsed'] = 'Zbalené/rozbalené zobrazenie "Príklad odovzdanej práce".';
$string['privacy:metadata:preference:viewlet-allsubmissions-collapsed'] = 'Zbalené/rozbalené zobrazenie "Správa o odovzdaných prácach".';
$string['privacy:metadata:preference:viewlet-assessmentform-collapsed'] = 'Zbalené/rozbalené zobrazenie "Hodnotiaci formulár".';
$string['privacy:metadata:preference:viewlet-assignedassessments-collapsed'] = 'Zbalené/rozbalené zobrazenie "Odovzdané zadania na hodnotenie".';
$string['privacy:metadata:preference:viewlet-cleargrades-collapsed'] = 'Zbalené/rozbalené zobrazenie "Nástroje workshopu".';
$string['privacy:metadata:preference:viewlet-conclusion-collapsed'] = 'Zbalené/rozbalené zobrazenie "Záver".';
$string['privacy:metadata:preference:viewlet-examples-collapsed'] = 'Zbalené/rozbalené zobrazenie "Príklad odovzdanej práce na hodnotenie".';
$string['privacy:metadata:preference:viewlet-examplesfail-collapsed'] = 'Zbalené/rozbalené zobrazenie "Príklad odovzdanej práce na hodnotenie".';
$string['privacy:metadata:preference:viewlet-gradereport-collapsed'] = 'Zbalené/rozbalené zobrazenie "Prehľad známok".';
$string['privacy:metadata:preference:viewlet-instructauthors-collapsed'] = 'Zbalené/rozbalené zobrazenie "Pokyny pre odovzdanie".';
$string['privacy:metadata:preference:viewlet-instructreviewers-collapsed'] = 'Zbalené/rozbalené zobrazenie "Pokyny pre hodnotenie".';
$string['privacy:metadata:preference:viewlet-intro-collapsed'] = 'Zbalené/rozbalené zobrazenie "Úvod".';
$string['privacy:metadata:preference:viewlet-overallfeedback-collapsed'] = 'Zbalené/rozbalené zobrazenie "Celková spätná väzba".';
$string['privacy:metadata:preference:viewlet-ownsubmission-collapsed'] = 'Zbalené/rozbalené zobrazenie "Vaše odovzdané zadanie".';
$string['privacy:metadata:preference:viewlet-publicsubmissions-collapsed'] = 'Zbalené/rozbalené zobrazenie "Zverejnené zadania".';
$string['privacy:metadata:preference:viewlet-yourgrades-collapsed'] = 'Zbalené/rozbalené zobrazenie "Vaše známky".';
$string['privacy:metadata:published'] = 'Či má byť riešenie zverejnené všetkým účastníkom po uzavrení workshopu';
$string['privacy:metadata:reviewerid'] = 'ID používateľa poskytujúceho hodnotenie';
$string['privacy:metadata:strategy'] = 'Názov podprocesu stratégie hodnotenia, ktorý interpretuje hodnoty záznamu';
$string['privacy:metadata:submissioncontent'] = 'Obsah príspevku';
$string['privacy:metadata:submissioncontentformat'] = 'Textový formát obsahu riešenia';
$string['privacy:metadata:submissiongrade'] = 'Súhrnná známka riešenia napísaná ako desatinné číslo z intervalu 0..100';
$string['privacy:metadata:submissiongradeover'] = 'Manuálne prepisovaná hodnota celkovej známky';
$string['privacy:metadata:submissionid'] = 'ID odovzdanej práce';
$string['privacy:metadata:submissiontitle'] = 'Názov odovzdanej práce';
$string['privacy:metadata:subsystem:corefiles'] = 'Modul Workshop ukladá súbory vložené do / pripojené k textu riešenia';
$string['privacy:metadata:subsystem:coreplagiarism'] = 'Modul Workshop má zabudovanú podporu systémov prevencie plagiátorstva';
$string['privacy:metadata:timeaggregated'] = 'Kedy bola naposledy vypočítaná súhrnná známka';
$string['privacy:metadata:timecreated'] = 'Kedy bol vytvorený tento záznam v databáze';
$string['privacy:metadata:timemodified'] = 'Kedy bol zmenený tento záznam v databáze';
$string['privacy:metadata:userid'] = 'ID používateľa, pre ktorého je vypočítavaná súhrnná známka';
$string['privacy:metadata:weight'] = 'Váha hodnotenia';
$string['privacy:metadata:workshopaggregations'] = 'Uchováva súhrnné známky pre hodnotenie';
$string['privacy:metadata:workshopassessments'] = 'Uchováva informácie o priradených hodnoteniach riešenia modulu workshop';
$string['privacy:metadata:workshopgrades'] = 'Uchováva informácie o tom, ako boli formuláre vyplnené známkami a komentármi';
$string['privacy:metadata:workshopid'] = 'ID aktivity Workshop';
$string['privacy:metadata:workshopsubmissions'] = 'Uchováva informácie o riešeniach modulu workshop';
$string['privacy:request:delete:content'] = 'Obsah bol odstránený (na žiadosť používateľa alebo mu skončila platnosť)';
$string['privacy:request:delete:title'] = '[Vymazané]';
$string['publishedsubmissions'] = 'Zverejnené práce';
$string['publishsubmission'] = 'Zverejniť prácu';
$string['publishsubmission_help'] = 'Zverejnené práce sú ostatným účastníkom dostupné potom, ako je workshop uzavrený.';
$string['reassess'] = 'Prehodnotiť';
$string['receivedgrades'] = 'Obdržané známky';
$string['recentassessments'] = 'Hodnotenia vo workshopoch:';
$string['recentsubmissions'] = 'Odovzdané práce vo workshopoch';
$string['resetassessments'] = 'Odstrániť všetky hodnotenia';
$string['resetassessments_help'] = 'Môžete si vybrať, či odstránite práve pridelené hodnotenia bez ovplyvnenia odovzdaných príspevkov. Ak majú byť príspevky odstránené, implicitne budú odstránené aj ich hodnotenia a táto voľba sa ignoruje. Poznámka: Sem patria aj hodnotenia ukážok príspevkov.';
$string['resetphase'] = 'Prepnúť do fázy nastavenia';
$string['resetphase_help'] = 'Ak je táto možnosť aktivovaná, všetky workshopy budú dané do fázy počiatočného nastavenia.';
$string['resetsubmissions'] = 'Odstrániť všetky príspevky';
$string['resetsubmissions_help'] = 'Všetky odovzdané práce a ich hodnotenia budú odstránené. Toto nemá vplyv na ukážky prác.';
$string['saveandclose'] = 'Uložiť a zavrieť';
$string['saveandcontinue'] = 'Uložiť a pokračovať v úpravách';
$string['saveandpreview'] = 'Uložiť a zobraziť náhľad';
$string['saveandshownext'] = 'Uložiť a zobraziť ďalší';
$string['search:activity'] = 'Workshop - informácia o aktivitách';
$string['selfassessmentdisabled'] = 'Sebahodnotenie nie je povolené';
$string['showingperpage'] = 'Zobrazuje sa {$a} položiek na strane';
$string['showingperpagechange'] = 'Zmeniť...';
$string['someuserswosubmission'] = 'Najmenej jeden používateľ ešte neodovzdal svoju prácu';
$string['sortasc'] = 'Vzostupne';
$string['sortdesc'] = 'Zostupne';
$string['strategy'] = 'Stratégia hodnotenia';
$string['strategy_help'] = 'Stratégia hodnotenia ovplyvňuje použitý hodnotiaci formulár a metódu ohodnotenia odovzdaných prác. Dostupné sú nasledujúce 4 možnosti:

* Kumulatívne hodnotenie - vkladajú sa komentáre a hodnotenia podľa stanovených aspektov
* Komentáre - vkladajú sa komentáre podľa stanovených aspektov, ale nemožno dať žiadne výsledné hodnotenie
* Počet chýb - vkladajú sa komentáre a hodnotenie pravdivosti odpovedí na stanovené výroky
* Rubrika - úroveň hodnotenia je určená podľa stanovených kritérií';
$string['strategyhaschanged'] = 'Stratégia hodnotenia workshopu sa od otvorenia formulára na úpravu zmenila.';
$string['submission'] = 'Odovzdaná práca';
$string['submissionattachment'] = 'Príloha';
$string['submissionby'] = 'Odovzdaná práca od {$a}';
$string['submissioncontent'] = 'Obsah práce';
$string['submissiondeleteconfirm'] = 'Ste si istí, že chcete odstrániť nasledujúci príspevok?';
$string['submissiondeleteconfirmassess'] = 'Naozaj chcete odstrániť nasledujúci príspevok? Upozorňujeme, že sa tým odstránia aj hodnotenia ({$a->count}) spojené s týmto príspevkom, čo môže ovplyvniť známky hodnotiteľov.';
$string['submissionend'] = 'Koniec odovzdávania';
$string['submissionendbeforestart'] = 'Uzávierku odovzdávania prác nemožno určiť pred dňom začiatku odovzdávania';
$string['submissionenddatetime'] = 'Koniec odovzdávania: {$a->daydatetime} ({$a->distanceday})';
$string['submissionendevent'] = '{$a} (uzávierka odovzdávania zadaní)';
$string['submissionendswitch'] = 'Prepnúť do ďalšej fázy po termíne odovzdávania';
$string['submissionendswitch_help'] = 'Ak je nastavená uzávierka termínu odovzdávania prác a toto políčko je zaškrtnuté, po termíne uzávierky sa workshop automaticky prepne do fázy hodnotenia.

Ak túto vlastnosť aktivujete, odporúča sa tiež nastaviť metódu plánovaného prideľovania odovzdaných prác. Ak nie sú odovzdané práce pridelené, nie je možné uskutočniť žiadne hodnotenie, aj keď workshop samotný je vo fáze hodnotenia.';
$string['submissiongrade'] = 'Známka za odovzdanú prácu';
$string['submissiongrade_help'] = 'Toto nastavenie určuje maximálne ohodnotenie, ktoré je možné získať sa odovzdanú prácu.';
$string['submissiongradeof'] = 'Známka za odovzdanú prácu (z {$a})';
$string['submissionlastmodified'] = 'Naposledy zmenené';
$string['submissionrequiredcontent'] = 'Musíte zadať nejaký text alebo pridať súbor.';
$string['submissionrequiredfile'] = 'Musíte pridať súbor alebo zadať nejaký text';
$string['submissionsallocation'] = 'Prideľovanie zadaní';
$string['submissionsettings'] = 'Nastavenie odovzdávania';
$string['submissionsreport'] = 'Prehľad odovzdaných zadaní';
$string['submissionstart'] = 'Začiatok odovzdávania';
$string['submissionstartdatetime'] = 'Začiatok odovzdávania {$a->daydatetime} ({$a->distanceday})';
$string['submissionstartevent'] = '{$a} začiatok odovzdávania prác';
$string['submissiontitle'] = 'Názov';
$string['submissiontypedisabled'] = 'Tento typ práce je pre tento workshop zakázaný';
$string['submissiontypefileavailable'] = 'Súbor príloh<span class="accesshide"> povolený</span>';
$string['submissiontypefilerequired'] = 'Súbor príloh<span class="accesshide"> požadovaný</span>';
$string['submissiontypes'] = 'Typy odovzdaných prác';
$string['submissiontypetextavailable'] = 'Online text<span class="accesshide"> dostupný</span>';
$string['submissiontypetextrequired'] = 'Online text<span class="accesshide"> povinný</span>';
$string['submittednotsubmitted'] = 'Odovzdané ({$a->submitted}) / neodovzdané ({$a->notsubmitted})';
$string['subplugintype_workshopallocation'] = 'Metóda prideľovania odovzdaných prác na hodnotenie';
$string['subplugintype_workshopallocation_plural'] = 'Metóda prideľovania odovzdaných prác na hodnotenie';
$string['subplugintype_workshopeval'] = 'Metóda evaluácie hodnotenia';
$string['subplugintype_workshopeval_plural'] = 'Metódy evaluácie hodnotenia';
$string['subplugintype_workshopform'] = 'Stratégia hodnotenia';
$string['subplugintype_workshopform_plural'] = 'Stratégie hodnotenia';
$string['switchingphase'] = 'Prepínanie fázy workshopu';
$string['switchphase'] = 'Prepnúť fázu workshopu';
$string['switchphase10'] = 'Prepnúť do fázy nastavenia';
$string['switchphase10info'] = 'Chystáte sa prepnúť workshop do fázy <strong>Nastavenie</strong>. V tejto fáze nemôžu študenti modifikovať svoje práce ani hodnotenia. Učitelia používajú túto fázu na zmenu nastavení workshopu, zmenu hodnotiacej stratégie či hodnotiacich formulárov.';
$string['switchphase20'] = 'Prepnúť do fázy odovzdávania';
$string['switchphase20info'] = 'Chystáte sa prepnúť workshop do fázy <strong>Odovzdávanie</strong>. V tejto fáze môžu študenti vkladať svoje práce (v určenom termíne, ak je nastavený). Učitelia rozdeľujú práce na hodnotenie.';
$string['switchphase30'] = 'Prepnúť do fázy hodnotenia';
$string['switchphase30auto'] = 'Workshop sa automaticky prepne do fázy hodnotenia po  {$a->daydatetime} ({$a->distanceday})';
$string['switchphase30info'] = 'Chystáte sa prepnúť workshop do fázy <strong>Hodnotenie</strong>. V tejto fáze majú hodnotitelia prístup k prácam, ktoré im boli pridelené (v určenom termíne, ak je nastavený).';
$string['switchphase40'] = 'Prepnúť do fázy evaluácie';
$string['switchphase40info'] = 'Chystáte sa prepnúť workshop do fázy <strong>Evaluácia</strong>. V tejto fáze nemôžu študenti modifikovať svoje práce ani hodnotenia. Učitelia využívajú nástroje hodnotenia na výpočet finálnych známok a vkladajú spätnú väzbu pre študentov.';
$string['switchphase50'] = 'Zavrieť workshop';
$string['switchphase50info'] = 'Chystáte sa uzavrieť workshop. Výsledkom toho bude zápis vypočítaných hodnotení do klasifikačného záznamu kurzu. Študenti si môžu prezerať svoje príspevky a ich hodnotenia.';
$string['switchphaseauto'] = 'Bolo naplánované prepnutie';
$string['switchphasenext'] = 'Prepnúť do ďalšej fázy';
$string['taskassesspeers'] = 'Ohodnotiť pridelené práce';
$string['taskassesspeersdetails'] = 'celkom: {$a->total}<br />ostáva: {$a->todo}';
$string['taskassessself'] = 'Ohodnotiť sám seba';
$string['taskconclusion'] = 'Poskytnúť záverečné zhrnutie aktivity';
$string['taskdone'] = 'Úloha splnená';
$string['taskfail'] = 'Úloha nesplnená';
$string['taskinfo'] = 'Informácia o úlohe';
$string['taskinstructauthors'] = 'Poskytnúť pokyny na vypracovanie';
$string['taskinstructreviewers'] = 'Poskytnúť pokyny na hodnotenie';
$string['taskintro'] = 'Nastaviť opis workshopu';
$string['tasksubmit'] = 'Odovzdať vlastnú prácu';
$string['tasktodo'] = 'Plánované úlohy';
$string['toolbox'] = 'Nástroje workshopu';
$string['undersetup'] = 'Tento workshop je práve vo fáze nastavovania. Prosím počkajte, kým nebude prepnutý do ďalšej fázy.';
$string['useexamples'] = 'Používať ukážky';
$string['useexamples_desc'] = 'Ukážky prác sa dajú využiť k nácviku hodnotenia nanečisto';
$string['useexamples_help'] = 'Ak je povolené, študenti budú môcť vyskúšať hodnotiť ukážky rôznych prác a porovnať svoje hodnotenie s tzv. referenčným. Hodnotenie ukážok nijako neovplyvňuje výsledné známky za hodnotenie.';
$string['usepeerassessment'] = 'Používať vzájomné hodnotenie';
$string['usepeerassessment_desc'] = 'Študenti môžu hodnotiť prácu druhých';
$string['usepeerassessment_help'] = 'Ak je povolené, študenti môžu mať pridelené práce ostatných k vzájomnému hodnoteniu. Okrem známky za ich vlastnú odovzdanú prácu získajú vo workshope aj známku za kvalitu hodnotenia prác ostatných.';
$string['userdatecreated'] = 'odovzdané dňa <span>{$a}</span>';
$string['userdatemodified'] = 'upravené dňa <span>{$a}</span>';
$string['userplan'] = 'Plán workshopu';
$string['userplan_help'] = 'Plánovač workshopu zobrazuje všetky fázy aktivity a zoznamy úloh pre každú fázu. Aktuálna fáza je zvýraznená a stav dokončenia úlohy je indikovaný príslušným symbolom.';
$string['userplanaccessibilityskip'] = 'Preskočiť na aktuálne úlohy';
$string['userplanaccessibilitytitle'] = 'Časová os Workshopu s {$a} fázami';
$string['userplancurrentphase'] = 'Aktuálna fáza';
$string['useselfassessment'] = 'Používať sebahodnotenie';
$string['useselfassessment_desc'] = 'Študenti môžu hodnotiť svoju vlastnú prácu';
$string['useselfassessment_help'] = 'Ak je táto možnosť aktivovaná, používateľovi môže byť pridelená na hodnotenie jeho vlastná práca a okrem hodnotenia svojho príspevku bude ohodnotený aj za svoje hodnotenie.';
$string['viewworkshopsummary'] = 'Zobraziť sumár Wokrshopu';
$string['weightinfo'] = 'Váha: {$a}';
$string['withoutsubmission'] = 'Hodnotiteľ bez vlastnej odovzdanej práce';
$string['workshop:addinstance'] = 'Pridať nový workshop';
$string['workshop:allocate'] = 'Prideľovať práce na hodnotenie';
$string['workshop:deletesubmissions'] = 'Odstrániť odovzdané práce';
$string['workshop:editdimensions'] = 'Upraviť hodnotiaci formulár';
$string['workshop:exportsubmissions'] = 'Export odovzdaných prác';
$string['workshop:ignoredeadlines'] = 'Ignorovať časové obmedzenia';
$string['workshop:manageexamples'] = 'Spravovať ukážky prác';
$string['workshop:overridegrades'] = 'Prepísať vypočítané známky';
$string['workshop:peerassess'] = 'Hodnotiť pridelené práce';
$string['workshop:publishsubmissions'] = 'Zverejňovať odovzdané práce';
$string['workshop:submit'] = 'Odovzdať vlastnú prácu';
$string['workshop:switchphase'] = 'Prepnúť fázu workshopu';
$string['workshop:view'] = 'Vidieť workshop';
$string['workshop:viewallassessments'] = 'Vidieť všetky hodnotenia';
$string['workshop:viewallsubmissions'] = 'Vidieť všetky odovzdané práce';
$string['workshop:viewauthornames'] = 'Vidieť mená autorov';
$string['workshop:viewauthorpublished'] = 'Vidieť autorov odovzdaných prác';
$string['workshop:viewpublishedsubmissions'] = 'Vidieť zverejnené práce';
$string['workshop:viewreviewernames'] = 'Vidieť mená hodnotiteľov';
$string['workshopname'] = 'Názov workshopu';
$string['yourassessmentfor'] = 'Vaše hodnotenie pre {$a}';
$string['yourgrades'] = 'Vaše hodnotenia';
$string['yoursubmission'] = 'Vaša práca';
$string['yoursubmissionwithassessments'] = 'Vaša odovzdaná práca s hodnoteniami';
