<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'attendance', language 'uk', version '4.4'.
 *
 * @package     attendance
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['Aacronym'] = 'H';
$string['Afull'] = 'Не був';
$string['Eacronym'] = 'В';
$string['Efull'] = 'Поважна причина';
$string['Lacronym'] = 'З';
$string['Lfull'] = 'Запізнення';
$string['Pacronym'] = 'П';
$string['Pfull'] = 'Присутній';
$string['absenteereport'] = 'Звіт про відсутніх';
$string['acronym'] = 'Скороч.';
$string['add'] = 'Додати';
$string['addedrecip'] = 'Додано нового {$a} нового користувача';
$string['addedrecips'] = 'Додано нового {$a} нового користувача';
$string['addmultiplesessions'] = 'Додати декілька занять';
$string['addsession'] = 'Додати заняття';
$string['adduser'] = 'Додати користувача';
$string['addwarning'] = 'Додати попередження';
$string['all'] = 'Все';
$string['allcourses'] = 'Всі курси';
$string['allpast'] = 'Всі пройшовші';
$string['allsessions'] = 'Всі заняття';
$string['attendance:addinstance'] = 'Добавити новий елемент курсу "Відвідуваність"';
$string['attendance:canbelisted'] = 'Відображається в реєстрі';
$string['attendance:changeattendances'] = 'Редагування відвідуванності';
$string['attendance:changepreferences'] = 'Зміна налаштувань';
$string['attendance:export'] = 'Експорт звітів';
$string['attendance:manageattendances'] = 'Керування відвідуванністю';
$string['attendance:managetemporaryusers'] = 'Керування тимчасовими користувачами';
$string['attendance:takeattendances'] = 'Відмітка відвідуванності';
$string['attendance:view'] = 'Перегляд присутності';
$string['attendance:viewreports'] = 'Перегляд звітів';
$string['attendance:viewsummaryreports'] = 'Переглядати зведені звіти по курсу';
$string['attendance:warningemails'] = 'Може бути підписаним на листи електронної пошти з відсутнім користувачем';
$string['attendance_already_submitted'] = 'Ви не можете самостійно відмітити свою відвідуваність, яка уже була відмічена';
$string['attendance_no_status'] = 'Статус не доступний - можлоиво ви запізнилися з відміткою відвідуванності';
$string['attendancedata'] = 'Інформація про відвідуваність';
$string['attendancegrade'] = 'Оцінка відвідуванності';
$string['attendancenotset'] = 'Ви повинні відмітити свою відвідуванність';
$string['attendancenotstarted'] = 'Поки що немає відміток про відвідуванність в даному курсі';
$string['attendancepercent'] = 'Відсоток відвідуванності';
$string['attendancereport'] = 'Звіт по відвідуванність';
$string['attendanceslogged'] = 'Відмітки про відвідуванність  внесені в журнал';
$string['attendancestaken'] = 'Відвідуванність відмічена';
$string['attendancesuccess'] = 'Інформація про присутність успішно збережена';
$string['attendanceupdated'] = 'Інформація про присутність успішно оновлена';
$string['attforblockdirstillexists'] = 'старий каталог mod/attforblock ще існує -ви повинні видалити його на сервері перед запуском цього оновлення';
$string['attrecords'] = 'Відміток про відвідуванність';
$string['autoassignstatus'] = 'Автоматичноо вибрати самий високий доступний статус';
$string['autoassignstatus_help'] = 'Якщо параметр увімкнений, студентам автоматично ставиться самий високий доступний статус';
$string['automark'] = 'Автоматична відмітка';
$string['automark_help'] = 'Дозволяє автоматично виконувати позначення відвідуваності.
«Так» - студенти будуть автоматично позначені, виходячи з їх першого входу в курс.
«Позначати не позначені в кінці заняття» - всім студентам, які не відмітили свою присутність на занятті, буде проставлено статус, обраний в якості статусу «не відмічений».';
$string['automarkall'] = 'Так';
$string['automarkclose'] = 'Відмічати не відміченими в кінці заняття';
$string['automarktask'] = 'Відмінити для занять, які потребують автоматичної відмітки відвідуванності';
$string['autorecorded'] = 'автоматично записаний системою';
$string['averageattendance'] = 'Середня відвідуванність';
$string['averageattendancegraded'] = 'Середня відвідуванність';
$string['backtoparticipants'] = 'Назад до списку учасників';
$string['below'] = 'Менше {$a}%';
$string['calclose'] = 'Закрити';
$string['calendarevent'] = 'Створити подію в календарі для заняття';
$string['calendarevent_help'] = 'Якщо включений, в календарі буде створено подія для цього заняття.
Якщо відключений, всі існуючі події в календарі для цього заняття будуть видалені.';
$string['caleventcreated'] = 'Подія в календарі для заняття успішно створена';
$string['caleventdeleted'] = 'Подія в календарі для заняття успішно видалена';
$string['calmonths'] = 'Січень, Лютий, Березень, Квітень, Травень, Червень, Липень, Серпень, Вересень, Жовтень, Листопад, Грудень';
$string['calshow'] = 'Вибрати дату';
$string['calweekdays'] = 'Нд,Пн,Вт,Ср,Чт,Пт,Сб';
$string['cannottakeforgroup'] = 'Ви не можете відмічати відвідуванність для групи «{$a}»';
$string['cantaddstatus'] = 'Ви повинні задати абревіатуру і опис при додаванні нового статусу.';
$string['categoryreport'] = 'Звіт по категорії курсів';
$string['changeattendance'] = 'Змінити відвідуванність';
$string['changeduration'] = 'Змінити тривалість';
$string['changesession'] = 'Змінити заняття';
$string['checkweekdays'] = 'Виберіть дні тижня, які потрапляють в обраний вами діапазон дат занять.';
$string['closed'] = 'Це заняття зараз не є доступним для самостійної відмітки відвідуваності';
$string['column'] = 'колонка';
$string['columns'] = 'колонок';
$string['commonsession'] = 'Загальне';
$string['commonsessions'] = 'Загальні';
$string['confirm'] = 'Підтвердити';
$string['confirmcolumnmappings'] = 'Підтвердити відповідність колонок';
$string['confirmdeletehiddensessions'] = 'Ви впевнені, що хочете видалити заняття ({$a->count}), заплановані до дати початку курсу ({$a->date})?';
$string['confirmdeleteuser'] = 'Ви впевнені, що хочете видалити користувача «{$a->fullname}» ({$a->email})? <br/> Всі записи про його відвідуваності будуть видалені безповоротно.';
$string['copyfrom'] = 'Копіюваи дані відвідуванності із заняття';
$string['countofselected'] = 'Вибрано занять';
$string['course'] = 'Курс';
$string['coursemessage'] = 'Відправити повідомлення учасникам курсу';
$string['courseshortname'] = 'Коротка назва курсу';
$string['coursesummary'] = 'Зведений звіт по курсу';
$string['createmultiplesessions'] = 'Створити декілька занять';
$string['createmultiplesessions_help'] = 'Ця функція дозволяє створити кілька занять за один крок.

  * <Strong> Дата початку занять </ strong>: Виберіть дату початку вашого курсу (перший день занять)
  * <Strong> Дата завершення занять </ strong>: Виберіть останній день занять (останній день позначки вами відвідуваності занять).
  * <Strong> Дні занять </ strong>: Виберіть дні тижня, коли будуть проходити заняття (наприклад, понеділок / середа / п\'ятниця).
  * <Strong> Періодичність </ strong>: Дозволяє задати частоту занять. Якщо ваші заняття будуть проходити щотижня, виберіть 1; якщо раз на два тижні - виберіть 2; раз в три тижні - виберіть 3 і т.д.';
$string['createonesession'] = 'Створити одне заняття для курсу';
$string['csvdelimiter'] = 'Роздільник CSV';
$string['currentlyselectedusers'] = 'Вибрані користувачі';
$string['date'] = 'Дата';
$string['days'] = 'День';
$string['defaultdisplaymode'] = 'Режим відображення по замовчуванню';
$string['defaults'] = 'По замовчуванню';
$string['defaultsessionsettings'] = 'Налаштування заняття  по замовчуванню';
$string['defaultsessionsettings_help'] = 'Ці установки визначають значення за замовчуванням для всіх нових занять';
$string['defaultsettings'] = 'Налаштування відвідуванності по замовчуванню';
$string['defaultsettings_help'] = 'Ці установки визначають значення за замовчуванням для всіх нових відміток відвідуваності';
$string['defaultstatus'] = 'Набір статусів по замовчуванню';
$string['defaultsubnet'] = 'Мережева адреса по замовчуванню';
$string['defaultsubnet_help'] = 'ЦІ установки визначаються значення за замовчуванню для всіх Нових відміток відвідуваності';
$string['defaultview'] = 'Перегляд за умовчанням для входу';
$string['defaultview_desc'] = 'Це перегляд за умовчанням, який показується вчителям після першого входу.';
$string['defaultwarnings'] = 'Стандартний набір попереджень';
$string['defaultwarningsettings'] = 'Стандартні налаштування попереджень';
$string['defaultwarningsettings_help'] = 'Ці параметри визначають типові значення для всіх нових попереджень';
$string['delete'] = 'Видалити';
$string['deletecheckfull'] = 'Ви абсолютно впевнені, що хочете повністю видалити {$a}, включаючи всі дані користувачів?';
$string['deletedgroup'] = 'Пов\'язана з даним завданням група була видалена';
$string['deletehiddensessions'] = 'Видалити усі приховані заняття';
$string['deletelogs'] = 'Видалити інформацію про відвідуваннясть';
$string['deleteselected'] = 'Видалити вибране';
$string['deletesession'] = 'Видалити заняття';
$string['deletesessions'] = 'Видалити всі заняття';
$string['deleteuser'] = 'Видалити користувача';
$string['deletewarningconfirm'] = 'Ви впевнені, що хочете видалити це попередження?';
$string['deletingsession'] = 'Видалення заняття із курсу';
$string['deletingstatus'] = 'Видалення статусу із курсу';
$string['description'] = 'Опис';
$string['display'] = 'Відображати';
$string['displaymode'] = 'Режим відображення';
$string['donotusepaging'] = 'Не розбивати на сторінки';
$string['downloadexcel'] = 'Скачати в форматі Excel';
$string['downloadooo'] = 'Скачати в форматі OpenOffice';
$string['downloadtext'] = 'Скачати в текстовому форматі';
$string['duration'] = 'Тривалість';
$string['editsession'] = 'Редагувати заняття';
$string['edituser'] = 'Редагувати користувача';
$string['emailcontent'] = 'Зміст електронної пошти';
$string['emailcontent_default'] = 'Вітаємо %userfirstname%,
Ваша відвідуваність у %coursename% %attendancename% знизилася нижче %warningpercent% і наразі становить %percent% - ми сподіваємося, що з Вами все добре!

Щоб максимально використати цей курс, Ви повинні поліпшити свою відвідуваність, будь ласка, зв\'яжіться з нами, якщо Вам потрібна додаткова підтримка.';
$string['emailcontent_help'] = 'Коли студенту надсилається попередження, він приймає вміст електронної пошти з цього поля. Можна використовувати такі символи:
<ul>
<li>%coursename%</li>
<li>%userfirstname%</li>
<li>%userlastname%</li>
<li>%userid%</li>
<li>%warningpercent%</li>
<li>%attendancename%</li>
<li>%cmid%</li>
<li>%numtakensessions%</li>
<li>%points%</li>
<li>%maxpoints%</li>
<li>%percent%</li>
</ul>';
$string['emailsubject'] = 'Тема електронної пошти';
$string['emailsubject_default'] = 'Попередження відвідування';
$string['emailsubject_help'] = 'З цього поля береться тема листа при відправленні попередження студенту.';
$string['emailuser'] = 'Користувач електронної пошти';
$string['emailuser_help'] = 'Якщо вибрано, повідомлення буде надіслано користувачеві';
$string['emptyacronym'] = 'Порожні абревіатури не допусаються. Стрічка статусу не оновлена';
$string['emptydescription'] = 'Порожні описи не допусаються. Стрічка статусу не оновлена';
$string['enablecalendar'] = 'Створити подію календаря';
$string['enablecalendar_desc'] = 'Якщо включений, для кожного заняття буде створено подія в календарі. Після зміни цієї настройки ви повинні виконати скидання календарного звіту';
$string['enablewarnings'] = 'Увімкнути попередження';
$string['enablewarnings_desc'] = 'Дозволяє визначити набір попереджень для відвідуваності і відправляти користувачам повідомлення електронною поштою, коли відвідуваність падає нижче заданого порогу. <br/> <strong> УВАГА: Це нова функція, вона не була всебічно протестована. Будь ласка, використовуйте її на свій страх і ризик і залиште відгук в форумах на moodle.org, якщо зможете підтвердити, що вона працює правильно. </strong>';
$string['encoding'] = 'Кодування';
$string['endofperiod'] = 'Кінець періоду';
$string['endtime'] = 'Час завершення заняття';
$string['enrolmentend'] = 'Підписка на курс завершується {$a}';
$string['enrolmentstart'] = 'Підписка на курс починається{$a}';
$string['enrolmentsuspended'] = 'Підписка на курс призупинена';
$string['enterpassword'] = 'Введіть пароль';
$string['error:coursehasnoattendance'] = 'В курсі з коротким іменем {$a}  немає елементів "Відвідуванність"';
$string['error:coursenotfound'] = 'Не вдається знайти курс з коротким іменем  {$a}';
$string['error:qrcode'] = 'Дозволити учням записувати власні відвідування, потрібно використовувати QR-код! Пропуск.';
$string['error:sessioncourseinvalid'] = 'Заняття курсу не вірне! Пропущено';
$string['error:sessiondateinvalid'] = 'Дата заняття курсу не вірна! Пропущено';
$string['error:sessionendinvalid'] = 'Час  завершення заняття курсу не вірний! Пропущено';
$string['error:sessionstartinvalid'] = 'Час початку заняття  не вірний! Пропущено';
$string['errorgroupsnotselected'] = 'Виберіть одну або більше груп';
$string['errorinaddingsession'] = 'Помтлка при добавленні заняття';
$string['erroringeneratingsessions'] = 'Помилка при створенні заняття';
$string['eventdurationupdated'] = 'Тривалість заняття змінена';
$string['eventreportviewed'] = 'Звіт переглянуто';
$string['eventscreated'] = 'Подія календаря створена';
$string['eventsdeleted'] = 'Подія календаря видалена';
$string['eventsessionadded'] = 'Заняття добавлено';
$string['eventsessiondeleted'] = 'Заняття видалено';
$string['eventsessionipshared'] = 'Конфлікт ІР адреси при самостійній відмітці відвідуванності';
$string['eventsessionsimported'] = 'Заняття імпортовано';
$string['eventsessionupdated'] = 'Заняття оновлено';
$string['eventstatusadded'] = 'Заняття добавлено';
$string['eventstatusupdated'] = 'Заняття оновлено';
$string['eventstudentattendancesessionsviewed'] = 'Переглянуто звіт про заняття';
$string['eventtaken'] = 'Відвідування відмічено';
$string['eventtakenbystudent'] = 'Відвідування відмічено студентом';
$string['export'] = 'Експорт';
$string['extrarestrictions'] = 'Додаткові обмеження';
$string['formattexttype'] = 'Форматування';
$string['from'] = 'з:';
$string['gradebookexplanation'] = 'Оцінка в журналі оцінок';
$string['gradebookexplanation_help'] = 'Ваша оцінка в модулі «Відвідуваність» розраховується як відношення кількості балів, отриманих за відвідуваність до поточної дати, до максимальної кількості балів, які ви могли отримати за відвідуваність до поточної дати; майбутні заняття в цій оцінці не враховуються. У журналі оцінок ваша оцінка ґрунтується на частці балів, отриманих за відвідуваність, і максимальній кількості балів, які ви можете отримати за відвідуваність за весь курс, включаючи майбутні заняття. Таким чином, оцінки відвідуваності в балах, які відображаються в модулі «Відвідуваність» і в журналі оцінок можуть відрізнятися, однак частка (відсоток) буде збігатися.

Наприклад, якщо ви на поточний момент заробили 8 балів з 10 (80% відвідуваності) і максимальний бал за відвідуваність всього курсу в журналі оцінок - 50, то в модулі «Відвідуваність» відобразиться оцінка «8/10», а в журналі оцінок - « 40/50 ». Ви ще не заробили 40 балів, але на даний момент ваш відсоток відвідуваності (80%) відповідає цим балам. Ваші бали в модулі «Відвідуваність» ніколи не можуть зменшуватися, тому що вони залежать тільки від відвідуваності на поточну дату; однак, оцінка в журналі оцінок може збільшуватися і зменшуватися, в залежності від вашої майбутньої успішності, тому що ця оцінка залежить від відвідуваності протягом усього курсу.';
$string['graded'] = 'Заняття оцінено';
$string['gridcolumns'] = 'Колонки сітки';
$string['group'] = 'Група';
$string['groups'] = 'Групи';
$string['groupsession'] = 'Група студентів';
$string['hiddensessions'] = 'Прихованих занять';
$string['hiddensessions_help'] = 'Заняття ховаються, якщо їх дата є ранішою дати початку курсу. Щоб відобразити ці заняття, змініть дату початку курсу.

Цю можливість можна використовувати для приховування старих занять, замість їх видалення. Майте на увазі, що для підрахунку оцінки в журналі оцінок використовуються тільки видимі заняття.';
$string['hiddensessionsdeleted'] = 'Всі приховані заняття будуть видалені';
$string['hideextrauserdetails'] = 'Приховати додаткові дані користувача';
$string['hidensessiondetails'] = 'Приховати деталі заняття';
$string['identifyby'] = 'Ідентифікувати студента по';
$string['import'] = 'Імпорт';
$string['importfile'] = 'Файл імпорту';
$string['importfile_help'] = 'Файл імпорту';
$string['importsessions'] = 'Імпорт заняття';
$string['includeabsentee'] = 'Включити заняття при розрахунку звіту відсутності';
$string['includeabsentee_help'] = 'Якщо вибрано для заняття буде включено обчислення звіту відсутності';
$string['includeall'] = 'Включити всі заняття';
$string['includenottaken'] = 'Включити всі заняття, що пройшли';
$string['includeqrcode'] = 'Включити QR-код';
$string['includeremarks'] = 'Включити примітки';
$string['incorrectpassword'] = 'Ви ввели неправильний пароль, тому Ваші відвідини заняття не було відзначено. Будь ласка, введіть правильний пароль.';
$string['incorrectpasswordshort'] = 'Неправильний пароль, відвідування не відмічено!';
$string['indetail'] = 'Детальніше...';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['invalidaction'] = 'Ви повинні вибрати дію';
$string['invalidemails'] = 'Необхідно вказати адреси існуючих облікових записів користувачів, не вдалося знайти:  {$a}';
$string['invalidimportfile'] = 'Формат файлу помилковий';
$string['invalidsessionenddate'] = 'Дата завершення заняття не може бути ранішою дати його початку';
$string['invalidsessionendtime'] = 'Час завершення повинен бути більшим часу початку';
$string['invalidstatus'] = 'Ви вибрали недійсний статус. Повторіть спробу';
$string['iptimemissing'] = 'Неправильна кількість хвилин для роз\'єднання';
$string['jumpto'] = 'Перейти до заняття';
$string['keepsearching'] = 'Продовжувати пошук';
$string['maxpossible'] = 'Максимально можливий';
$string['maxpossible_help'] = 'Показує бал, який кожен користувач може отримати, якщо він отримає максимальні бали за всі не відмічені заняття (минулі і майбутні):
<ul>
<li> <strong> Бали </strong>: максимальний бал, який кожен користувач може отримати за все заняття.
</li>
<li>
<strong> відсоток </strong>: максимальний відсоток, який кожен користувач може отримати за все заняття.
</li>
</ul>';
$string['maxpossiblepercentage'] = 'Максиамльно можливий відсоток';
$string['maxpossiblepoints'] = 'Максимально можливі бали';
$string['maxwarn'] = 'Максимальна кількість попереджень на електронну пошту';
$string['maxwarn_help'] = 'Максимальна кількість разів для відправки попередження (за кожне заняття відправляється тільки одне попередження)';
$string['mergeuser'] = 'Об\'єднати користувача';
$string['mobilesessionfrom'] = 'Показати заняття, старші за останні';
$string['mobilesessionfrom_help'] = 'Дозволяє обмежувати список занять під час позначення в програмі - показує лише заняття, розпочаті з цього значення';
$string['mobilesessionto'] = 'Показати майбутні заняття';
$string['mobilesessionto_help'] = 'Дозволяє обмежувати список занять, показуючи лише невелику кількість майбутніх занять.';
$string['mobilesettings'] = 'Налаштування мобільного додатку';
$string['mobilesettings_help'] = 'Ці налаштування керують поведінкою мобільних додатків Moodle';
$string['modulename'] = 'Відвідування';
$string['modulename_help'] = 'Модуль «Відвідуваність» дозволяє викладачеві вести облік відвідуваності занять, а студентам бачити інформацію про їх власної відвідуваності.

Викладач може створити декілька занять і відзначати відвідуваність як статуси «Був присутній», «Не був», «Запізнився», «Поважна причина» або змінити ці статуси так, щоб вони відповідали потребам викладача.

У модулі доступні звіти по всім студентам або по кожному студенту окремо.';
$string['modulenameplural'] = 'Відвідування';
$string['months'] = 'Місяці';
$string['moreattendance'] = 'Відвідуванність відмічена на цій сторінці';
$string['moveleft'] = 'Перемістити в ліво';
$string['moveright'] = 'Перемістити в право';
$string['multisessionexpanded'] = 'Розгорнути декілька занять';
$string['multisessionexpanded_desc'] = 'Показувати за замовчуванням «Кілька занять» в розгорнутому вигляді при створенні нових занять.';
$string['mustselectusers'] = 'Необхідно вибрати користувача для експорту';
$string['newdate'] = 'Нова дата';
$string['newduration'] = 'Нова тривалість';
$string['newstatusset'] = 'Новий набір статусів';
$string['noabsentstatusset'] = 'Використовуваний набір статусів не містить статус, який потрібно використовувати, коли відвідування не відзначено.';
$string['noattendanceusers'] = 'Неможливо експортувати дані, оскільки немає записаних на курс студентів';
$string['noattforuser'] = 'Немає відміток відвідуванності для цього користувача';
$string['noautomark'] = 'Вимкнено';
$string['nodescription'] = 'Звичайне заняття';
$string['noeventstoreset'] = 'Немає подій в календарі, які потребують оновлення';
$string['nogroups'] = 'Ви не можете додавати групові заняття. В курсі не визначено групи.';
$string['noguest'] = 'Гість не може бачити інформацію про відвідуваність';
$string['noofdaysabsent'] = 'Днів пропусків';
$string['noofdaysexcused'] = 'Днів пропусків по поважній причині';
$string['noofdayslate'] = 'Днів запізнень';
$string['noofdayspresent'] = 'Днів присутності';
$string['nosessiondayselected'] = 'Не вибрано день заняття';
$string['nosessionexists'] = 'В даному курсі відсутні заняття';
$string['nosessionsselected'] = 'Не вибрано жодного заняття';
$string['notfound'] = 'Елемент курсу «Відвідуваність» не знайдений в даному курсі!';
$string['notifytask'] = 'Відправити попередження користувачеві';
$string['notmember'] = 'не &nbsp;член';
$string['noupgradefromthisversion'] = 'Модуль «Відвідуваність» не може бути оновлений з встановленої у вас версії attforblock. - Видаліть attforblock або поновіть його до останньої версії перед установкою нового модуля відвідування';
$string['numsessions'] = 'Кількість занять';
$string['olddate'] = 'Стара дата';
$string['onlyselectedusers'] = 'Експортувати конкретних користувачів';
$string['overallsessions'] = 'Протягом усіх занять';
$string['overallsessions_help'] = 'Показує статистику по всіх занятттях, включаючи ще не відмічені (минулі і майбутні): <ul> <li> <strong> Заняття </strong>: загальне число занять. </li> <li> <strong> Бали </strong> : бали, набрані за відвідуваність на заняттях. </li> <li> <strong> Відсоток </strong>: частка набраних балів від максимально можливої кількості балів за всі заняття. </li> </ul>';
$string['oversessionstaken'] = 'По  відмічених заняттях';
$string['oversessionstaken_help'] = 'Показує статистику по заняттях, на яких відмічалася відвідуваність:
<ul>
<li>
<strong> Заняття </strong>: число занять, на яких відзначалася відвідуваність. </li> <li> <strong> Бали </ strong>: бали , набрані за відвідуваність на зазначених заняттях. </li> <li> <strong> Відсоток </strong>: частка набраних балів від максимально можливої кількості балів за заняття, на яких відзначалася відвідуваність. </li> </ul>';
$string['pageof'] = 'Сторінка {$a->page} з {$a->numpages}';
$string['participant'] = 'Учасник';
$string['password'] = 'Пароль';
$string['passwordgrp'] = 'Пароль студента';
$string['passwordgrp_help'] = 'Якщо заданий, студенти повинні будуть ввести пароль перед тим, як вони зможуть відмітити свою присутність на занятті. Якщо поле пусте, пароль не потрібен.';
$string['passwordrequired'] = 'Ви повинні ввести пароль перед тим як відмітити своє відвідування цього заняття.';
$string['percentage'] = 'Відсоток';
$string['percentageallsessions'] = 'Відсоток по всіх заняттях';
$string['percentagesessionscompleted'] = 'Відсоток по всіх відвіданих заняттях';
$string['pluginadministration'] = 'Керування модулем "Відвідуванність"';
$string['pluginname'] = 'Відвідування';
$string['points'] = 'Бали';
$string['pointsallsessions'] = 'Бали по всіх заняттях';
$string['pointssessionscompleted'] = 'Бали по всіх відвіданих заняттях';
$string['preferences_desc'] = 'Зміни в наборі статусів вплинуть на всі існуючі позначки відвідуваності занять і можуть вплинути на оцінку за курсом.';
$string['preventsharederror'] = 'Самостійна відмітка відвідуваності для заняття була відключена, так як цей пристрій, схоже, вже було використано для оцінки відвідуваності іншим студентом.';
$string['preventsharedip'] = 'Заборонити студентам використовувати загальну P-адресу';
$string['preventsharedip_help'] = 'Заборонити студентам використовувати один і той же пристрій (визначається за IP-адресою) для відмітки відвідуваності іншими студентами.';
$string['preventsharediptime'] = 'Час, через який IP-адреса може бути повторно використана (хвилини)';
$string['preventsharediptime_help'] = 'Дозволити повторне використання IP-адреси для відмітки відвідування в цьому занятті автоматично через певний час.';
$string['priorto'] = 'Дата заняття вказана раніше дати початку курсу ({$a}), тому нові заняття, заплановані до цієї дати, будуть приховані (не доступні). Ви можете змінити дату початку курсу в будь-який момент (дивіться настройки курсу) для того, щоб отримати доступ до більш ранніх занять. <br> <br> Будь ласка, поміняйте дату заняття або просто клацніть знову на кнопці «Додати заняття» для підтвердження.';
$string['privacy:metadata:attendancelog'] = 'Журнал відміток про відвідуванність учасників';
$string['privacy:metadata:attendancesessions'] = 'Заняття для яких буде записуватись відвідуванність';
$string['privacy:metadata:attendancewarningdone'] = 'Журнал попереджень, відправлених користувачам по записах про їх відвідуванність';
$string['privacy:metadata:duration'] = 'Тривалість заняття в секундах';
$string['privacy:metadata:groupid'] = 'ID групи, пов\'язаної із заняттям';
$string['privacy:metadata:ipaddress'] = 'IP-адрес,';
$string['privacy:metadata:lasttaken'] = 'Момент часу останньої відмітки відвідуванності';
$string['privacy:metadata:lasttakenby'] = 'ID останнього користувача, відвідуваність якого була відзначена в цьому занятті';
$string['privacy:metadata:notifyid'] = 'ID позначки відвідуваності заняття, з якою пов\'язано попередження.';
$string['privacy:metadata:remarks'] = 'Коментарі про відвідуваність користувача.';
$string['privacy:metadata:sessdate'] = 'Момент часу, коли заняття закінчилося';
$string['privacy:metadata:sessionid'] = 'ID заняття з відміткою про відвідуванність';
$string['privacy:metadata:statusid'] = 'ID статусу відвідування учасника';
$string['privacy:metadata:statusset'] = 'Набір статусів, до якого відноситься ID статусу.';
$string['privacy:metadata:studentid'] = 'ID студента, чия відвідуванність була відмічена';
$string['privacy:metadata:takenby'] = 'ID  користувача, який відмічав відвідуванність учасника';
$string['privacy:metadata:timemodified'] = 'Момент часу, коли заняття останній раз корегуавлося';
$string['privacy:metadata:timesent'] = 'Момент часу, коли було відправлено попередження';
$string['privacy:metadata:timetaken'] = 'Момент часу відмічання відвідуванності учасника';
$string['privacy:metadata:userid'] = 'ID користувача, якому було відправлено попередження';
$string['processingfile'] = 'Обробка файлу';
$string['qr_cookie_error'] = 'QR-сесія закінчилась.';
$string['qr_pass_wrong'] = 'QR-пароль неправильний або закінчився.';
$string['qrcode'] = 'QR-код';
$string['randompassword'] = 'Випадковий пароль';
$string['remark'] = 'Примітка для: {$a}';
$string['remarks'] = 'Примітка';
$string['repeatasfollows'] = 'Повторити заняття вище наступним способом';
$string['repeatevery'] = 'Повторяти кожне';
$string['repeaton'] = 'Повторяти по';
$string['repeatuntil'] = 'Повторяти до';
$string['report'] = 'Звіт';
$string['required'] = 'Необхідний*';
$string['requiredentries'] = 'Тимчасові записи заміняють записи про відвідування учасника';
$string['requiredentry'] = 'Керівництво по об\'єднанню тимчасових користувачів';
$string['requiredentry_help'] = '<p align = "center"> <b> Відвідуваність </b> </p>
<p align = "left"> <strong> Об\'єднати облікові записи </strong> </p>
<p align = "left">
<table border = "2" cellpadding = "4">
<tr>
<th> Користувач Moodle </th>
<th> Тимчасовий користувач </th>
<th> Дія </th>
</tr>
<tr>
<td> Дані про відвідуваність </ td>
<td> Дані про відвідуваність </ td>
<td> Тимчасовий користувач замінить користувача Moodle </td>
</tr>
<tr>
<td> Немає даних про відвідування </td>
<td> Дані про відвідуваність </ td>
<td> Відвідуваність тимчасового користувача буде передана користувачеві Moodle </td>
</tr>
<tr>
<td> Дані про відвідуваність </td>
<td> Немає даних про відвідування </td>
<td> Тимчасовий користувач буде видалений </td>
</tr>
<tr>
<td> Немає даних про відвідування </td>
<td> Немає даних про відвідування < td>
<td> Тимчасовий користувач буде видалений </td>
</tr>
</ table>

</t>
<t align = "left"> <strong> Тимчасовий користувач буде видалений в усіх випадках після операції об\'єднання </strong> </p>';
$string['requiresubnet'] = 'Необхідна мережева адреса';
$string['requiresubnet_help'] = 'Відмітка відвідуваності може бути обмежена для конкретних підмереж шляхом зазначення переліку часткових або повних IP-адрес, що розділяються комами.';
$string['resetcaledarcreate'] = 'Події в календарі були включені, але деякі існуючі заняття не мають відповідних подій. Ви хочете створити події в календарі для всіх існуючих занять?';
$string['resetcaledardelete'] = 'Події в календарі були відключені, але деякі існуючі заняття мають відповідні події, які слід видалити. Ви хочете видалити всі існуючі події?';
$string['resetcalendar'] = 'Скинути календар';
$string['resetdescription'] = 'Увага! Чистка даних відвідуваності видаляє інформацію з БД. Ви можете просто приховати старі заняття, змінивши дату початку курсу!';
$string['resetstatuses'] = 'Відновити набір статусів за замовчуванням';
$string['restoredefaults'] = 'Відновити значення за замовчуванням';
$string['resultsperpage'] = 'Результатів на сторінку';
$string['resultsperpage_desc'] = 'Кількість студентів що відображаються на сторінці';
$string['rotateqrcode'] = 'Змінити QR код';
$string['rotateqrcode_cleartemppass_task'] = 'Завдання очистити тимчасові паролі, породжені функцією зміниQR-коду.';
$string['rotateqrcodeexpirymargin'] = 'Змінити QR-код / термін дії пароля (секунди)';
$string['rotateqrcodeexpirymargin_desc'] = 'Інтервал часу (секунди), щоб дозволити термін дії QR-коду / пароля, що минув';
$string['rotateqrcodeinterval'] = 'Зміна інтервалу QR-коду / пароля (секунди)';
$string['rotateqrcodeinterval_desc'] = 'Інтервал часу (секунди) для зміни QR-коду / пароля на.';
$string['save'] = 'Зберегти відвідуваність';
$string['search:activity'] = 'Відвідуваність - інформація про діяльність';
$string['session'] = 'Заняття';
$string['session_help'] = 'Заняття';
$string['sessionadded'] = 'Заняття успішно добавлено';
$string['sessionalreadyexists'] = 'В цей день заняття уже існує';
$string['sessiondate'] = 'Дата';
$string['sessiondays'] = 'Дні занять';
$string['sessiondeleted'] = 'Заняття успішно видалено';
$string['sessionduplicate'] = 'Заняття-дублер існує в курсі «{$a->course}» для елементу «Відвідуванність» з назвою «{$a->activity}»';
$string['sessionexist'] = 'Заняття не добавлено (уже існує)!';
$string['sessiongenerated'] = 'Одне заняття було успішно згенероване';
$string['sessions'] = 'Заняття';
$string['sessionscompleted'] = 'Відвідуванність заняття';
$string['sessionsgenerated'] = '{$a} Заняття успішно створені';
$string['sessionsids'] = 'Ідентифікатори занять';
$string['sessionsnotfound'] = 'В вибраний діапазон часу не попадає жодного заняття';
$string['sessionstartdate'] = 'Дата початку занять';
$string['sessionstotal'] = 'Загальна кількість занять';
$string['sessiontype'] = 'Тип';
$string['sessiontype_help'] = 'Існує 2 типу занять: загальні та групові. Можливість додавати заняття різних типів залежить від групового режиму елемента курсу.

* У груповому режимі «Ні груп» можна додавати тільки спільні заняття.
* У груповому режимі «Видимі групи» можна додавати і загальні, і групові заняття.
* У груповому режимі «Ізольовані групи» можна додавати тільки групові заняття.';
$string['sessiontypeshort'] = 'Тип';
$string['sessionunknowngroup'] = 'Заняття містить невідомі групи: {$a}';
$string['sessionupdated'] = 'Заняття успішно змінено';
$string['set_by_student'] = 'Самозапис';
$string['setallstatuses'] = 'Задати статус усім користувачам';
$string['setallstatusesto'] = 'Встановити статус  «{$a}» для всіх учасників';
$string['setperiod'] = 'Дозволити автоматично через певний час в хвилинах';
$string['settings'] = 'Налаштування';
$string['setunmarked'] = 'Автоматично задавати, якщо відвідування не відмічено';
$string['setunmarked_help'] = 'Якщо включено, цей статус буде проставлено в занятті, якщо учасник залишив поза увагою свої відвідини.';
$string['showdefaults'] = 'Показати по замовчуванню';
$string['showduration'] = 'Показувати тривалість';
$string['showextrauserdetails'] = 'Показати додаткову інформацію про користувача';
$string['showqrcode'] = 'Показати QR-код';
$string['showsessiondescriptiononreport'] = 'Показати опис заняття в звіті';
$string['showsessiondescriptiononreport_desc'] = 'Показувати опис заняття в звітах про відвідуваність.';
$string['showsessiondetails'] = 'Показувати інформацію про заняття';
$string['somedisabledstatus'] = '(Деякі параметри були видалені після початку заняття.)';
$string['sortedgrid'] = 'Таблиця';
$string['sortedlist'] = 'Список';
$string['startofperiod'] = 'Початок періоду';
$string['starttime'] = 'Час початку';
$string['status'] = 'Статус';
$string['statusall'] = 'всі';
$string['statusdeleted'] = 'Статус видалено';
$string['statuses'] = 'Статуси';
$string['statusset'] = 'Статус встановлено  {$a}';
$string['statussetsettings'] = 'Статус встановлено';
$string['statusunselected'] = 'не вибрано';
$string['strftimedm'] = '%b %d';
$string['strftimedmy'] = '%d %b %Y';
$string['strftimedmyhm'] = '%d %b %Y %I.%M%p';
$string['strftimedmyw'] = '<nobr>%a %d %b %Y</nobr>';
$string['strftimeh'] = '%I%p';
$string['strftimehm'] = '%H:%M%p';
$string['strftimeshortdate'] = '%d.%m.%Y';
$string['studentid'] = 'ID студента';
$string['studentmarked'] = 'Ваша відвідуваність на цьому занятті була відмічена.';
$string['studentmarking'] = 'Запис студента';
$string['studentpassword'] = 'Пароль студента';
$string['studentrecordingexpanded'] = 'Розширення студентського запису';
$string['studentrecordingexpanded_desc'] = 'Показувати за замовчуванням «Відмітка студентом» в розгорнутому вигляді при створенні нових занять.';
$string['studentscanmark'] = 'Дозволити студентам фіксувати власну відвідуваність';
$string['studentscanmark_desc'] = 'Якщо прапорець встановлений, вчителі зможуть дозволити студентам, щоб відзначити свою власну присутність.';
$string['studentscanmark_help'] = 'Якщо включено, то студенти зможуть змінювати змінювати статус своєї відвідуваності занять.';
$string['studentscanmarksessiontime'] = 'Студенти відзначають відвідуваність протягом заняття';
$string['studentscanmarksessiontime_desc'] = 'Якщо включено, то студенти можуть відмітити свої відвідини тільки під час заняття.';
$string['studentscanmarksessiontimeend'] = 'Кінець відмітки відвідування заняття (хвилини)';
$string['studentscanmarksessiontimeend_desc'] = 'Якщо для заняття не вказано час закінчення, то протягом скількох хвилин студенти можуть відмітити свої відвідини заняття.';
$string['submit'] = 'Відправити';
$string['submitattendance'] = 'Відправити відвідуваність';
$string['submitpassword'] = 'Відправити пароль';
$string['subnet'] = 'Підмережа';
$string['subnetactivitylevel'] = 'Дозволити налаштовувати підмережу на рівні елемента';
$string['subnetactivitylevel_desc'] = 'Якщо включено, то вчителі можуть перевизначати підмережу за замовчуванням на рівні елемента при створенні елементу «Відвідуваність». Інакше при створенні заняття буде використано значення за замовчуванням для сайту.';
$string['subnetwrong'] = 'Відвідуваність може бути відмічена тільки з певних місць, цей комп\'ютер не входить в список дозволених.';
$string['summary'] = 'Огляд';
$string['tablerenamefailed'] = 'Перейменування старої таблиці attforblock в attendance не вдалося';
$string['tactions'] = 'Дія';
$string['takeattendance'] = 'Беруть участь';
$string['takensessions'] = 'Відвідані заняття';
$string['tcreated'] = 'Створено';
$string['tempaddform'] = 'Добавити тимчасового користувача';
$string['tempexists'] = 'Уже існує тимчасовий користувач  з такою адресою електронної пошти';
$string['temptable'] = 'Список тимчасових користувачіів';
$string['tempuser'] = 'Тимчасовий користувач';
$string['tempusermerge'] = 'Об\'єднання тимчасового користувача';
$string['tempusers'] = 'Тимчасові користувачі';
$string['tempusersedit'] = 'Редагувати тимчасових користувачів';
$string['tempuserslist'] = 'Тимчасові користувачі';
$string['thirdpartyemails'] = 'Повідомити інших користувачів';
$string['thirdpartyemails_help'] = 'Список інших користувачів, які будуть повідомлені (потрібна наявність прав mod/attendance:viewreports).';
$string['thirdpartyemailsubject'] = 'Попередження про відвідуванність';
$string['thirdpartyemailtext'] = 'Відвідуванність користувача «{$a->firstname} {$a->lastname}» в курсі «{$a->coursename}» (елемент відвідуванності«{$a->aname}») нижче, чим {$a->warningpercent} ({$a->percent})';
$string['thirdpartyemailtextfooter'] = 'Ви отримали це повідомлення, оскільки вчитель цього курсу додав Вашу електронну адресу електронної пошти в список одержувачів';
$string['thiscourse'] = 'Цей курс';
$string['time'] = 'Час';
$string['timeahead'] = 'Неможливо створити кілька занять, що перевищують один рік. Будь ласка, виправте дати початку і закінчення.';
$string['to'] = 'до:';
$string['triggered'] = 'Перше повідомлення';
$string['tuseremail'] = 'Ел.пошта';
$string['tusername'] = 'Повне ім\'я';
$string['ungraded'] = 'Заняття без оцінки';
$string['unknowngroup'] = 'Невідома група';
$string['update'] = 'Оновлено';
$string['usedefaultsubnet'] = 'Використання по замовчуванню';
$string['usemessageform'] = 'або використовувати форму нижче для відправки повідомлення обраним студентам';
$string['userexists'] = 'Вже існує реальний користувач з такою адресою електронної пошти';
$string['users'] = 'Користувачі для експорту';
$string['usestatusset'] = 'Використовувати задання статусу';
$string['variable'] = 'змінна';
$string['variablesupdated'] = 'Змінні кспішно оновлені';
$string['versionforprinting'] = 'версія для друку';
$string['viewmode'] = 'Режим перегляду';
$string['warnafter'] = 'Кількість відмічених занять для відправки попередження';
$string['warnafter_help'] = 'Попередження будуть відправлятися тільки в тому випадку, якщо відвідуваність користувачів буде відзначена як мінімум для зазначеного тут кількості занять.';
$string['warningdeleted'] = 'Попередження видалено';
$string['warningdesc'] = 'Ці попередження автоматично будуть додані до всіх нових елементів «Відвідуваність». Якщо одночасно спрацює кілька попереджень, то буде відправлено тільки одне попередження з найнижчим рівнем порогу.';
$string['warningdesc_course'] = 'Задані тут пороги попереджень впливають на звіт про прогули і дозволяють повідомляти про це студентів і третіх осіб. Якщо одночасно спрацює кілька попереджень, то буде відправлено тільки одне попередження з найнижчим рівнем порога.';
$string['warningfailed'] = 'Ви не можете створити попередження, що використовує такий же поріг і число занять.';
$string['warningpercent'] = 'Попереджати, якщо відсоток впаде нижче';
$string['warningpercent_help'] = 'Попередження буде спрацьовувати, коли загальний відсоток впаде нижче цього числа.';
$string['warnings'] = 'Попередження встановлено';
$string['warningthreshold'] = 'попередження';
$string['warningupdated'] = 'попередженя оновленно';
$string['week'] = 'тиждень(тижні)';
$string['weeks'] = 'Тижні';
$string['youcantdo'] = 'Ви нічого не можете зробити';
