<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hvp', language 'it', version '4.4'.
 *
 * @package     hvp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Azione';
$string['addedandupdatedpp'] = 'Aggiunte {$a->%new} nuove librerie H5P e aggiornate {$a->%old} vecchie.';
$string['addedandupdatedps'] = 'Aggiunte {$a->%new} nuove librerie H5P e aggiornata {$a->%old} vecchia.';
$string['addedandupdatedsp'] = 'Aggiunta {$a->%new} nuova libreria H5P e aggiornate {$a->%old} vecchie.';
$string['addedandupdatedss'] = 'Aggiunta {$a->%new} nuova libreria H5P e aggiornata {$a->%old} vecchia.';
$string['addednewlibraries'] = '{$a->%new} nuove librerie H5P aggiunte.';
$string['addednewlibrary'] = '{$a->%new} nuova libreria H5P aggiunta.';
$string['additionalinfo'] = 'Informazioni aggiuntive';
$string['additionallicenseinfo'] = 'Informazioni aggiuntive sulla licenza';
$string['addlibraries'] = 'Aggiungi librerie';
$string['ajaxfailed'] = 'Caricamento di dati fallito.';
$string['anunexpectedsave'] = 'È accaduto qualcosa di inatteso. Non è stato possibile salvare il contenuto.';
$string['attribution'] = 'Attribuzione 4.0';
$string['attributionnc'] = 'Attribuzione - Non commerciale 4.0';
$string['attributionncnd'] = 'Attribuzione - Non commerciale - Non opere derivate 4.0';
$string['attributionncsa'] = 'Attribuzione - Non commerciale - Condividi allo stesso modo 4.0';
$string['attributionnd'] = 'Attribuzione - Non opere derivate 4.0';
$string['attributionsa'] = 'Attribuzione - Condividi allo stesso modo 4.0';
$string['author'] = 'Autore';
$string['authorcomments'] = 'Commenti dell\'autore';
$string['authorcommentsdescription'] = 'Commenti per l\'editore del contenuto (il testo non sarà pubblicato come parte delle informazioni sul copyright)';
$string['authorname'] = 'Nome dell\'autore';
$string['authorrole'] = 'Ruolo dell\'autore';
$string['by'] = 'di';
$string['cancellabel'] = 'Annulla';
$string['ccattribution'] = 'Attribuzione (CC BY)';
$string['ccattributionnc'] = 'Attribuzione - Non commerciale (CC BY-NC)';
$string['ccattributionncnd'] = 'Attribuzione - Non commerciale - Non opere derivate (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Attribuzione - Non commerciale - Condividi allo stesso modo (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Attribuzione - Non opere derivate (CC BY-ND)';
$string['ccattributionsa'] = 'Attribuzione - Condividi allo stesso modo (CC BY-SA)';
$string['ccpdd'] = 'Donazione al pubblico dominio (CC0)';
$string['ccpdm'] = 'Marchio di pubblico dominio (PDM)';
$string['changedby'] = 'Modificato da';
$string['changedescription'] = 'Descrizione delle modifiche';
$string['changelog'] = 'Log delle modifiche';
$string['changeplaceholder'] = 'Foto ritagliata, testo modificato ecc.';
$string['close'] = 'Chiudi';
$string['confirmdialogbody'] = 'Per favore conferma che vuoi proseguire. L\'azione non è reversibile.';
$string['confirmdialogheader'] = 'Conferma azione';
$string['confirmlabel'] = 'Conferma';
$string['connectionlost'] = 'Connessione perduta. I risultati saranno memorizzati e inviati quando la connessione sarà ristabilita.';
$string['connectionreestablished'] = 'Connessione ristabilita.';
$string['contentchanged'] = 'Questo contenuto è cambiato dall\'ultimo utilizzo.';
$string['contentcopied'] = 'Il contenuto è stato copiato negli appunti';
$string['contentstatefrequency'] = 'Frequenza dello stato di salvataggio del contenuto';
$string['contentstatefrequency_help'] = 'Intervallo in secondi per il salvataggio automatico dello stato di avanzamento dell\'utente. Aumentare il valore in caso di problemi con molte richieste ajax.';
$string['contenttype'] = 'Tipo di contenuto';
$string['contenttypecacheheader'] = 'Cache del tipo di contenuto';
$string['copyright'] = 'Diritti di utilizzo';
$string['copyrightinfo'] = 'Informazioni sul copyright';
$string['copyrightstring'] = 'Copyright';
$string['copyrighttitle'] = 'Visualizza informazioni sul copyright per questo contenuto.';
$string['couldnotcopy'] = 'Impossibile copiare il file.';
$string['couldnotparsejsonfromzip'] = 'Impossibile analizzare JSON nel pacchetto: %fileName';
$string['couldnotparsepostdata'] = 'Impossibile analizzare i dati del post.';
$string['couldnotreadfilefromzip'] = 'impossibile leggere il file dal pacchetto: %fileName';
$string['couldnotsave'] = 'Impossibile salvare il file.';
$string['create'] = 'Crea';
$string['creativecommons'] = 'Creative Commons';
$string['ctcachebuttonlabel'] = 'Aggiorna la cache del tipo di contenuto';
$string['ctcacheconnectionfailed'] = 'Impossibile comunicare con l\'hub H5P. Per favore riprova più tardi.';
$string['ctcachedescription'] = 'Mantenere aggiornata la cache del tipo di contenuto garantisce la possibilità di visualizzare, scaricare ed utilizzare le librerie più recenti. L\'operazione è diversa dall\'aggiornamento delle sole librerie.';
$string['ctcachelastupdatelabel'] = 'Ultimo aggiornamento';
$string['ctcacheneverupdated'] = 'Mai';
$string['ctcachenolibraries'] = 'Nessun tipo di contenuto è stato ricevuto dall\'hub H5P. Per favore riprova più tardi.';
$string['ctcachesuccess'] = 'Cache della libreria aggiornata con successo!';
$string['ctcachetaskname'] = 'Aggiorna la cache del tipo di contenuto';
$string['currentpage'] = 'Pagina $current di $total';
$string['dataviewreportlabel'] = 'Visualizza risposte';
$string['date'] = 'Data';
$string['disablefileextensioncheck'] = 'Disabilita il controllo dell\'estensione dei file';
$string['disablefileextensioncheckwarning'] = 'Attenzione! Disabilitare il controllo dell\'estensione dei file può avere conseguenze sulla sicurezza poiché consente di caricare file php. Ciò potrebbe a sua volta permettere a malintenzionati di eseguire codice dannoso nel  sito. Accertarsi di conoscere con precisione ciò che si sta caricando.';
$string['disablefullscreen'] = 'Disabilita schermo intero';
$string['disablehubconfirmationmsg'] = 'Vuoi ancora abilitare l\'hub?';
$string['disablehubdescription'] = 'Si raccomanda fortemente di tenere questa opzione abilitata. L\'hub H5P offre un\'interfaccia semplice per ottenere nuovi tipi di contenuti e mantenere aggiornati i tipi di contenuto esistenti. In futuro, sarà resa più semplice la condivisione e il riutilizzo dei contenuti. Se questa opzione è disabilitata, dovrai installare e aggiornare i tipi di contenuti tramite i moduli di caricamento dei file.';
$string['displayoptionalwaysshow'] = 'Visualizza sempre';
$string['displayoptionauthoroff'] = 'Gestita dall\'autore, il default è off';
$string['displayoptionauthoron'] = 'Gestita dall\'autore, il default è on';
$string['displayoptiondownloadalways'] = 'Sempre';
$string['displayoptiondownloadnever'] = 'Mai';
$string['displayoptiondownloadpermission'] = 'Solo se l\'utente ha i privilegi per esportare H5P';
$string['displayoptionnevershow'] = 'Non visualizzare mai';
$string['displayoptionpermissions'] = 'Visualizza solo se l\'utente ha l\'autorizzazione a esportare H5P';
$string['displayoptionpermissionsembed'] = 'Visualizza solo se l\'utente ha l\'autorizzazione a incorporare H5P';
$string['displayoptions'] = 'Visualizza opzioni';
$string['download'] = 'Scarica';
$string['downloadfailed'] = 'Scaricamento della libreria richiesta non riuscito';
$string['downloadtitle'] = 'Scarica questo contenuto come file H5P.';
$string['editor'] = 'Editor';
$string['emailconfirmbody'] = 'Gentile {$a->username},

grazie per aver inviato le risposte dell\'attività \'{$a->hvpname}\' presente nel corso \'{$a->coursename}\'.

Questo messaggio conferma che le risposte sono state salvate.

Puoi accedere all\'attività H5P in argomento visualizzando la pagina {$a->hvpurl}.';
$string['emailconfirmsmall'] = 'Grazie per aver inviato le risposte dell\'attività \'{$a->hvpname}\\';
$string['emailconfirmsubject'] = 'Conferma di invio: {$a->hvpname}';
$string['emailnotifybody'] = 'Gentile {$a->username},

{$a->studentname} ha completato l\'attività \'{$a->hvpname}\' ({$a->hvpurl}) presente nel corso \'{$a->coursename}\'.

E\' possibile rivedere il tentativo andando alla pagina {$a->hvpreporturl}.';
$string['emailnotifysmall'] = '{$a->studentname} ha completato l\'attività {$a->hvpname}. Per visualizzare: {$a->hvpreporturl}';
$string['emailnotifysubject'] = '{$a->studentname} ha completato l\'attività {$a->hvpname}';
$string['embed'] = 'Incorpora';
$string['embedloginfailed'] = 'Non hai accesso a questo contenuto. Prova ad autenticarti.';
$string['embedtitle'] = 'Visualizza il codice incorporato per questo contenuto.';
$string['empty'] = 'Nessun risultato disponibile';
$string['enableabout'] = 'Pulsante informazioni su H5P';
$string['enablecopyright'] = 'Pulsante copyright';
$string['enabledlrscontenttypes'] = 'Abilita i tipi di contenuto dipendenti da LRS';
$string['enabledlrscontenttypes_help'] = 'Rende possibile l\'utilizzo di tipi di contenuto che si basano su un Learning Record Store per funzionare correttamente, come il tipo di contenuto di Questionnaire.';
$string['enabledownload'] = 'Consenti download';
$string['enableembed'] = 'Pulsante per incorporare';
$string['enableframe'] = 'Mostra action bar e frame';
$string['enablehublabel'] = 'Utilizza l\'hub H5P';
$string['enablejavascript'] = 'Per favore abilita JavaScript.';
$string['enablesavecontentstate'] = 'Salva lo stato del contenuto';
$string['enablesavecontentstate_help'] = 'Salva automaticamente lo stato attuale del contenuto interattivo per ogni utente. Questo permette all\'utente di ritornare al punto in cui ha interrotto la navigazione.';
$string['failedtodownloadh5p'] = 'Scaricamento dell\'H5P richiesto fallito.';
$string['fileexceedsmaxsize'] = 'Uno dei file all\'interno del pacchetto supera la dimensione massima consentita (%file %used > %max).';
$string['filenotfoundonserver'] = 'File non trovato sul server. Verifica le impostazioni di caricamento del file.';
$string['filenotimage'] = 'Il file non è un\'immagine.';
$string['filetypenotallowed'] = 'Tipo di file non consentito.';
$string['finished'] = 'Completato';
$string['fullscreen'] = 'Schermo intero';
$string['gpl'] = 'General Public License v3';
$string['h5pfile'] = 'File H5P';
$string['h5ptitle'] = 'Vai su H5P.org a vedere altri fantastici contenuti.';
$string['hide'] = 'Nascondi';
$string['hideadvanced'] = 'Nascondi avanzate';
$string['hubcommunicationdisabled'] = 'La comunicazione dell\'hub di H5P è stata disabilitata per mancanza di uno o più requisiti.';
$string['hubisdisabled'] = 'L\'Hub è disabilitato. Puoi abilitarlo nuovamente nelle impostazioni di H5P.';
$string['hubisdisableduploadlibraries'] = 'L\'hub H5P rimane disabilitato fino a quando questo problema sarà stato risolto. Puoi comunque caricare delle librerie dalla pagina "Librerie H5P".';
$string['hubsettingsheader'] = 'Tipi di contenuto';
$string['hvp:addinstance'] = 'Aggiungere nuove attività H5P';
$string['hvp:emailconfirmsubmission'] = 'Ricevere un messaggio di conferma dopo l\'invio';
$string['hvp:emailnotifysubmission'] = 'Ricevere un messaggio di notifica quanto un tentativo è stato inviato';
$string['hvp:getcachedassets'] = 'Visualizzare attività H5P';
$string['hvp:getembedcode'] = 'Visualizzare il codice H5P incorporato quando è impostata l\'opzione \'controllato da autorizzazione\'';
$string['hvp:getexport'] = 'Scaricare il file .h5p quando è impostata l\'opzione \'Gestito da autorizzazione\'';
$string['hvp:installrecommendedh5plibraries'] = 'Installare nuovi tipi di contenuto H5P sicuri consigliati da H5P.org';
$string['hvp:manage'] = 'Modificare le attività H5P esistenti';
$string['hvp:restrictlibraries'] = 'Restringere l\'uso a determinati tipi di contenuto H5P';
$string['hvp:savecontentuserdata'] = 'Salvare l\'avanzamento degli utenti nelle attività H5P';
$string['hvp:saveresults'] = 'Salvare i risultati delle attività H5P completate';
$string['hvp:updatelibraries'] = 'Installare nuovi tipi di contenuto H5P o aggiorna quelli esistenti';
$string['hvp:userestrictedlibraries'] = 'Utilizzare tipi di contenuto H5P soggetti a restrizioni';
$string['hvp:view'] = 'Visualizzare ed interagire con attività di H5P';
$string['hvp:viewallresults'] = 'Visualizzare i risultati di tutte le attività H5P completate';
$string['hvp:viewresults'] = 'Visualizza i risultati delle proprie attività H5P completate';
$string['installdenied'] = 'Non sei autorizzato a installare tipi di contenuto. Contatta l\'amministratore di questo sito.';
$string['installedlibraries'] = 'Librerie installate';
$string['intro'] = 'Introduzione';
$string['invalidaudioformat'] = 'Il formato del file audio non è valido. Utilizzare mp3 o wav.';
$string['invalidcontentfolder'] = 'Contenuto della cartella non valido';
$string['invalidcontenttype'] = 'Il tipo di contenuto selezionato non è valido.';
$string['invalidfieldtype'] = 'Tipo di campo non valido.';
$string['invalidfile'] = 'Il file "{$a->%filename}" non è consentito. Sono consentiti soltanto file con le seguenti estensioni: {$a->%files-allowed}.';
$string['invalidh5ppost'] = 'Non è stato possibile pubblicare H5P.';
$string['invalidimageformat'] = 'Il formato dell\'immagine non è valido. Utilizzare jpg, png o gif.';
$string['invalidlanguagefile'] = 'Il file della lingua {$a->%file} nella libreria {$a->%library} non è valido';
$string['invalidlanguagefile2'] = 'E\' stato incluso nella libreria {$a->%library} il file della lingua {$a->%file} che non è valido.';
$string['invalidlibrary'] = 'Libreria non valida';
$string['invalidlibrarydata'] = 'Sono stati forniti dati non validi per {$a->%property} in {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Sono stati forniti dati non validi per {$a->%property} in {$a->%library}. Era atteso un valore booleano.';
$string['invalidlibraryname'] = 'Il nome della libreria non è valido: {$a->%name}';
$string['invalidlibrarynamed'] = 'La libreria H5P {$a->%library} utilizzata dal contenuto non è valida';
$string['invalidlibraryoption'] = 'Opzione illegale {$a->%option} in {$a->%library}';
$string['invalidlibraryproperty'] = 'Impossibile leggere la proprietà {$a->%property} in {$a->%library}';
$string['invalidmainjson'] = 'Manca un file principale h5p.json valido';
$string['invalidmultiselectoption'] = 'L\'opzione scelta tramite selezione multipla non è valida.';
$string['invalidparameters'] = 'Parametri non validi';
$string['invalidselectoption'] = 'L\'opzione selezionata non è valida.';
$string['invalidsemanticsjson'] = 'Un file semantics.json non valido è stato incluso nella libreria {$a->%name}';
$string['invalidsemanticstype'] = 'Errore interno H5P: tipo di contenuto sconosciuto "{$a->@type}" in semantics. Contenuto in eliminazione!';
$string['invalidstring'] = 'La stringa inserita non è valida secondo l\'espressione regolare in semantics. (valore: "{$a->%value}", espressione regolare: "{$a->%regexp}")';
$string['invalidtoken'] = 'Token di sicurezza non valido.';
$string['invalidvideoformat'] = 'Il formato del file video non valido. Utilizzare mp4 o webm.';
$string['invalidxapiresult'] = 'Non sono stati trovati risultati xAPI per la combinazione di contenuto e ID utente';
$string['javascriptloading'] = 'Caricamento di JavaScript...';
$string['libraries'] = 'Librerie H5P';
$string['librarydirectoryerror'] = 'Il nome della cartella della libreria deve coincidere con il machineName o con il machineName-majorVersion.minorVersion (dalla library.json). (Cartella: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['librarylistactions'] = 'Azioni';
$string['librarylistinstancedependencies'] = 'Dipendenze dell\'istanza';
$string['librarylistinstances'] = 'Istanze';
$string['librarylistlibrarydependencies'] = 'Dipendenze della libreria';
$string['librarylistrestricted'] = 'Limitata';
$string['librarylisttitle'] = 'Titolo';
$string['librarynotselected'] = 'Devi selezionare un tipo di contenuto.';
$string['license'] = 'Licenza';
$string['licenseCC010'] = 'CC0 1.0 Universal (CC0 1.0) Donazione al dominio pubblico';
$string['licenseCC010U'] = 'CC0 1.0 Universal';
$string['licenseCC10'] = '1.0 Generico';
$string['licenseCC20'] = '2.0 Generico';
$string['licenseCC25'] = '2.5 Generico';
$string['licenseCC30'] = '3.0 Unported';
$string['licenseCC40'] = '4.0 Internazionale';
$string['licenseGPL'] = 'GNU General Public License';
$string['licenseV1'] = 'Versione 1';
$string['licenseV2'] = 'Versione 2';
$string['licenseV3'] = 'Versione 3';
$string['licensee'] = 'Licenziatario';
$string['licenseextras'] = 'Extra di licenza';
$string['licenseversion'] = 'Versione della licenza';
$string['loadingdata'] = 'Dati in caricamento.';
$string['lookforupdates'] = 'Cerca aggiornamenti di H5P';
$string['maximumgrade'] = 'Voto massimo';
$string['maximumgradeerror'] = 'Inserisci un numero intero positivo valido da utilizzare come punteggio massimo dell\'attività';
$string['maxpostsizetoosmall'] = 'La dimensione massima del post è limitata dalla configurazione del PHP. Con la configurazione attuale non sarà possibile caricare file più grandi di {$a->%number} MB. Potrebbe diventare un problema quando si caricano H5P, immagini e video. Si consiglia di aumentare tale valore oltre i 5MB';
$string['maxscore'] = 'Punteggio massimo';
$string['maxuploadsizetoosmall'] = 'La dimensione massima di caricamento de dei file è limitata dalla configurazione del PHP. Con la configurazione attuale non sarà possibile caricare file più grandi di {$a->%number} MB. Potrebbe diventare un problema quando si caricano H5P, immagini e video. Si consiglia di aumentare tale valore oltre i 5MB';
$string['messageprovider:confirmation'] = 'Conferma dei propri invii di risposte H5P';
$string['messageprovider:submission'] = 'Notifica degli invii di risposte H5P';
$string['missingcontentfolder'] = 'Manca una cartella di contenuto valida';
$string['missingcontentuserdata'] = 'Errore: impossibile trovare dati dell\'utente';
$string['missingcoreversion'] = 'Il sistema non è risucito ad installare il componente <em>{$a->%component}</em> perché è richiesta una versione più aggiornata del plugin H5P. Il sito attualmente sta utilizzando la versione  {$a->%current}, mentre la versione richiesta è {$a->%required} o superiore. Si consiglia di eseguire un aggiornamento e riprovare in seguito.';
$string['missingdependency'] = 'Manca la dipendenza {$a->@dep} richiesta da {$a->@lib}.';
$string['missinglibrary'] = 'Manca la libreria obbligatoria {$a->@library}';
$string['missinglibraryfile'] = 'Manca il file "{$a->%file}" dalla libreria: "{$a->%name}"';
$string['missinglibraryjson'] = 'Impossibile trovare il file library.json in un formato JSON valido per la libreria {$a->%name}';
$string['missinglibraryproperty'] = 'La proprietà obbligatoria {$a->%property} manca da {$a->%library}';
$string['missingmbstring'] = 'L\'estensione PHP mbstring non è presente. H5P ne ha bisogno per funzionare correttamente';
$string['missingparameters'] = 'Parametri mancanti';
$string['missinguploadpermissions'] = 'Le librerie possono esistere nel file che hai caricato, ma non ti è permesso caricare nuove librerie. Contatta l\'amministratore del sito.';
$string['modulename'] = 'Contenuto Interattivo';
$string['modulename_help'] = 'L\'attività H5P consente di creare contenuto interattivo come video interattivi, serie o insiemi di domande, quiz e test, domande di tipo drag and drop, domande a scelta multipla, presentazioni e molto altro.

Oltre ad essere uno strumento per la creazione di contenuto, H5P consente di riutilizzare e condividere contenuto grazie alla possibilità di importare ed esportare file in formato H5P.

Le interazioni con l\'utente e le valutazioni sono tracciate utilizzando xAPI e sono rese disponibili nel Registro Valutatore di Moodle.

È possibile aggiungere contenuto H5P effettuando il caricamento di un file .h5p.
È possibile creare e scaricare file .h5p su h5p.org';
$string['modulename_link'] = 'https://h5p.org/moodle-more-help';
$string['modulenameplural'] = 'Contenuto interattivo';
$string['nextpage'] = 'Pagina successiva';
$string['noanswersubmitted'] = 'Questo utente non ha ancora inviato una risposta per l\'attività H5P';
$string['nocontent'] = 'Non è stato possibile analizzare il file content.json';
$string['nocontenttype'] = 'Nessun tipo di contenuto specificato';
$string['nocopyright'] = 'Nessuna informazione sul copyright disponibile per questo contenuto.';
$string['nodata'] = 'Non ci sono dati disponibili che corrispondono ai tuoi criteri.';
$string['noextension'] = 'Il file caricato non è un pacchetto HTML5 valido (il file non ha l\'estensione .h5p)';
$string['noh5ps'] = 'Nessun contenuto interattivo disponibile in questo corso.';
$string['nojson'] = 'Il file h5p.json principale non è valido';
$string['nombstringexteension'] = 'L\'estensione PHP mbstring non è stata caricata, ma è necessaria ad H5P per funzionare correttamente.';
$string['noparameters'] = 'Nessun parametro';
$string['noparse'] = 'Non è stato possibile analizzare il file h5p.json principale';
$string['nopermissiontogettranslations'] = 'Non hai i permessi per consultare le traduzioni';
$string['nopermissiontorestrict'] = 'Non hai i permessi per limitare le librerie.';
$string['nopermissiontosavecontentuserdata'] = 'Non hai i permessi per salvare i dati del contenuto dell\'utente.';
$string['nopermissiontosaveresult'] = 'Non hai i permessi per salvare i risultati di questo contenuto.';
$string['nopermissiontoupgrade'] = 'Non hai i permessi per aggiornare le librerie.';
$string['nopermissiontouploadcontent'] = 'Non hai i permessi per caricare contenuto in questa posizione.';
$string['nopermissiontouploadfiles'] = 'Non hai i permessi per caricare file in questa posizione.';
$string['nopermissiontoviewcontenttypes'] = 'Non hai i permessi per visualizzare i tipi di contenuto.';
$string['nopermissiontoviewresult'] = 'Non hai i permessi per visualizzare i risultati di questo contenuto.';
$string['nosuchlibrary'] = 'Libreria non esistente';
$string['notapplicable'] = 'N/D';
$string['nounzip'] = 'Il file caricato non è un pacchetto HTML5 valido (non è stato possibile scompattarlo)';
$string['noversionattribution'] = 'Attribuzione';
$string['noversionattributionnc'] = 'Attribuzione - Non commerciale';
$string['noversionattributionncnd'] = 'Attribuzione - Non commerciale - Non opere derivate';
$string['noversionattributionncsa'] = 'Attribuzione - Non commerciale - Condividi allo stesso modo';
$string['noversionattributionnd'] = 'Attribuzione - Non opere derivate';
$string['noversionattributionsa'] = 'Attribuzione - Condividi allo stesso modo';
$string['nowriteaccess'] = 'È stato rilevato un problema con l\'accesso al server in scrittura. Si prega di verificare che il proprio server possa scrivere sulla cartella data.';
$string['noziparchive'] = 'La tua versione di PHP non supporta ZipArchive.';
$string['offlinedialogbody'] = 'Impossibile inviare informazioni sul completamento di questa attività. Verifica la connessione a internet.';
$string['offlinedialogheader'] = 'La connessione al server si è interrotta';
$string['offlinedialogretrybuttonlabel'] = 'Riprova ora';
$string['offlinedialogretrymessage'] = 'Riprovare tra :num...';
$string['offlinesuccessfulsubmit'] = 'Risultati inviati correttamente.';
$string['oldphpversion'] = 'La versione del PHP è obsoleta. H5P richiede che la versione 5.2 funzioni correttamente. Si consiglia la versione 5.6 o successiva.';
$string['olduploadoldcontent'] = 'Stai provando a caricare del contenuto di una versione precedente di H5P. Aggiornare il contenuto sul server da cui proviene e provare a caricarlo di nuovo oppure attivare l\'Hub H5P per fare in modo che questo server lo aggiorni automaticamente.';
$string['onlyupdate'] = 'Aggiorna solo le librerie esistenti';
$string['options'] = 'Opzioni';
$string['originator'] = 'Ideatore';
$string['pd'] = 'Pubblico dominio';
$string['pddl'] = 'Donazione al pubblico dominio e relativa licenza';
$string['pdm'] = 'Marchio di pubblico dominio';
$string['pluginadministration'] = 'H5P';
$string['pluginname'] = 'H5P';
$string['postmessagerequired'] = 'Un messaggio di tipo POST è necessario per raggiungere l\'endpoint';
$string['previouspage'] = 'Pagina precedente';
$string['privacy:metadata:core_files'] = 'L\'attività H5P memorizza i file che sono stati caricati come parte del contenuto H5P.';
$string['privacy:metadata:core_grades'] = 'L\'attività H5P memorizza i risultati degli utenti che hanno risposto ai contenuti H5P.';
$string['privacy:metadata:hvp_content_user_data'] = 'Descrive lo stato corrente in cui si trova un utente per questo contenuto. Serve a ripristinare il contenuto ad uno stato precedente.';
$string['privacy:metadata:hvp_content_user_data:data'] = 'I dati dell\'utente che sono stati salvati.';
$string['privacy:metadata:hvp_content_user_data:data_id'] = 'Identificativo del tipo di dati.';
$string['privacy:metadata:hvp_content_user_data:delete_on_content_change'] = 'Flag che determina se i dati devono essere eliminati quando i contenuti vengono modificati.';
$string['privacy:metadata:hvp_content_user_data:hvp_id'] = 'L\'ID del contenuto H5P a cui i dati appartengono.';
$string['privacy:metadata:hvp_content_user_data:id'] = 'L\'ID della relazione dei dati tra utente e contenuti.';
$string['privacy:metadata:hvp_content_user_data:preloaded'] = 'Indicatore che determina se i dati devono essere precaricati nel contenuto.';
$string['privacy:metadata:hvp_content_user_data:sub_content_id'] = 'Sottocontenuto di H5P. 0 se non si tratta di sottocontenuto.';
$string['privacy:metadata:hvp_content_user_data:user_id'] = 'L\'ID dell\'utente a cui appartengono i dati.';
$string['privacy:metadata:hvp_events'] = 'Tiene traccia degli eventi H5P memorizzati.';
$string['privacy:metadata:hvp_events:content_id'] = 'L\'ID del contenuto a cui l\'azione si riferisce, 0 se nuova o nessun contenuto.';
$string['privacy:metadata:hvp_events:content_title'] = 'Titolo del contenuto.';
$string['privacy:metadata:hvp_events:created_at'] = 'Il momento in cui l\'evento è stato creato.';
$string['privacy:metadata:hvp_events:id'] = 'L\'ID univoco dell\'evento.';
$string['privacy:metadata:hvp_events:library_name'] = 'La libreria sulla quale l\'evento ha avuto effetto.';
$string['privacy:metadata:hvp_events:library_version'] = 'La versione della libreria sulla quale l\'evento ha avuto effetto.';
$string['privacy:metadata:hvp_events:sub_type'] = 'Il sottotipo dell\'evento o l\'azione dell\'evento.';
$string['privacy:metadata:hvp_events:type'] = 'Il tipo di evento.';
$string['privacy:metadata:hvp_events:user_id'] = 'L\'ID dell\'utente che ha effettuato l\'azione.';
$string['privacy:metadata:hvp_xapi_results'] = 'Memorizza gli eventi xAPI dei contenuti H5P.';
$string['privacy:metadata:hvp_xapi_results:additionals'] = 'Informazioni aggiuntive che H5P può inviare.';
$string['privacy:metadata:hvp_xapi_results:content_id'] = 'L\'ID del contenuto sul quale è stata effettuato l\'evento.';
$string['privacy:metadata:hvp_xapi_results:correct_responses_pattern'] = 'Formato della risposta corretta.';
$string['privacy:metadata:hvp_xapi_results:description'] = 'La descrizione, compito o domanda del contenuto sul quale l\'azione è stata effettuata.';
$string['privacy:metadata:hvp_xapi_results:id'] = 'L\'ID univoco dell\'evento xAPI.';
$string['privacy:metadata:hvp_xapi_results:interaction_type'] = 'Il tipo di interazione.';
$string['privacy:metadata:hvp_xapi_results:max_score'] = 'Punteggio massimo ottenibile per l\'evento.';
$string['privacy:metadata:hvp_xapi_results:parent_id'] = 'L\'ID dell\'elemento genitore del contenuto sul quale l\'evento è stato effettuato. Nullo se non esiste un elemento genitore.';
$string['privacy:metadata:hvp_xapi_results:raw_score'] = 'Punteggio ottenuto per questo evento.';
$string['privacy:metadata:hvp_xapi_results:response'] = 'La risposta che l\'utente ha inviato.';
$string['privacy:metadata:hvp_xapi_results:user_id'] = 'L\'ID dell\'utente che ha effettuato l\'azione.';
$string['question'] = 'Domanda';
$string['removeoldlogentries'] = 'Rimuovi vecchi log di H5P';
$string['removeoldmobileauthentries'] = 'Rimuovere le vecchie voci di autorizzazione mobile H5P';
$string['removetmpfiles'] = 'Rimuovi vecchi file temporanei di H5P';
$string['reportingquestionsremaininglabel'] = 'domande mancanti prima della valutazione';
$string['reportingscaledscoredelimiter'] = ',';
$string['reportingscaledscorelabel'] = 'Punteggio del Registro valutatore:';
$string['reportingscoredelimiter'] = 'su';
$string['reportingscorelabel'] = 'Punteggio:';
$string['reportnotsupported'] = 'Non supportato';
$string['reportsubmitgradelabel'] = 'Invia valutazione';
$string['resizescript'] = 'Includi questo script nel tuo sito se vuoi il ridimensionamento dinamico del contenuto incorporato:';
$string['resubmitscores'] = 'Tentativo di inviare risultati memorizzati.';
$string['reuse'] = 'Riutilizza';
$string['reusecontent'] = 'Riutilizza contenuto';
$string['reusedescription'] = 'Riutilizza questo contenuto.';
$string['reveal'] = 'Rivela';
$string['reviseserversetupandretry'] = 'Una volta modificata la configurazione del server, è possibile riattivare la comunicazione dell\'hub H5P nelle impostazioni H5P.';
$string['score'] = 'Punteggio';
$string['search'] = 'Cerca';
$string['sendusagestatistics'] = 'Contribuisci alle statistiche di utilizzo';
$string['sendusagestatistics_help'] = 'I numeri delle statistiche di utilizzo verranno automaticamente segnalati per aiutare gli sviluppatori a capire meglio come viene utilizzato H5P e per determinare potenziali aree di miglioramento. Leggi di più su quali <a {$a}> dati vengono raccolti da h5p.org</a>';
$string['settings'] = 'Impostazioni H5P';
$string['showadvanced'] = 'Mostra avanzate';
$string['showless'] = 'Visualizza di meno';
$string['showmore'] = 'Visualizza di più';
$string['sitecouldnotberegistered'] = 'Il sito non può essere registrato con l\'hub. Si prega di contattare l\'amministratore del sito.';
$string['sitekey'] = 'Chiave del sito';
$string['sitekeydescription'] = 'La chiave del sito è un valore segreto che identifica univocamente questo sito con l\'Hub.';
$string['sitekeyregistered'] = 'È stata fornita una chiave univoca che ti identifica con l\'Hub quando ricevi nuovi aggiornamenti. È possibile visualizzare la chiave nella pagina "Impostazioni H5P".';
$string['size'] = 'Dimensione';
$string['source'] = 'Fonte';
$string['sslnotenabled'] = 'Il server non ha SSL abilitato. SSL deve essere abilitato per garantire una connessione sicura con l\'hub H5P.';
$string['startingover'] = 'Ricomincia da capo.';
$string['sublevel'] = 'Sottolivello';
$string['successfullyregisteredwithhub'] = 'Il sito è stato registrato correttamente con l\'hub H5P.';
$string['thumbnail'] = 'Anteprima';
$string['title'] = 'Titolo';
$string['unabletocreatedir'] = 'Impossibile creare la directory.';
$string['unabletogetfieldtype'] = 'Impossibile ottenere il tipo di campo.';
$string['undisclosed'] = 'Non dichiarato';
$string['unpackedfilesexceedsmaxsize'] = 'La dimensione totale dei file decompressi supera la dimensione massima consentita (%used > %max).';
$string['updatedlibraries'] = '{$a->%old} librerie H5P aggiornate.';
$string['updatedlibrary'] = '{$a->%old} libreria H5P aggiornata.';
$string['updatelibraries'] = 'Aggiorna tutte le Librerie';
$string['upgrade'] = 'Aggiorna H5P';
$string['upgradebuttonlabel'] = 'Aggiorna';
$string['upgradedone'] = 'Sono state correttamente aggiornate {$a} istanze di contenuto.';
$string['upgradeerror'] = 'Si è verificato un errore durante l\'elaborazione dei parametri:';
$string['upgradeerrorcontent'] = 'Impossibile aggiornare il contenuto %id:';
$string['upgradeerrordata'] = 'Impossibile caricare i dati per la libreria %lib.';
$string['upgradeerrormissinglibrary'] = 'Manca la libreria obbligatoria %lib.';
$string['upgradeerrornotsupported'] = 'I parametri contengono %used, che non è supportato.';
$string['upgradeerrorparamsbroken'] = 'I parametri non sono corretti.';
$string['upgradeerrorscript'] = 'Impossibile caricare script di aggiornamento per la libreria %lib.';
$string['upgradeerrortoohighversion'] = 'I parametri contengono %used mentre soltanto %supported o precedenti sono supportati.';
$string['upgradeheading'] = 'Aggiorna {$a} contenuto';
$string['upgradeinprogress'] = 'Aggiornamento alla versione %ver...';
$string['upgradeinvalidtoken'] = 'Errore: token di sicurezza non valido!';
$string['upgradelibrarycontent'] = 'Aggiorna contenuto della libreria';
$string['upgradelibrarymissing'] = 'Errore: libreria mancante!';
$string['upgrademessage'] = 'Stai per effettuare l\'aggiornamento di {$a} istanza/e di contenuto. Prego selezionare la versione dell\'aggiornamento.';
$string['upgradenoavailableupgrades'] = 'Non ci sono aggiornamenti per questa libreria.';
$string['upgradenothingtodo'] = 'Non ci sono istanze di contenuto da aggiornare.';
$string['upgradereturn'] = 'Invio';
$string['upload'] = 'Carica';
$string['uploadlibraries'] = 'Carica librerie';
$string['uploadsizelargerthanpostsize'] = 'La dimensione massima di caricamento in è più grande della dimensione massima del post. Questa configurazione può causare problemi.';
$string['user'] = 'Utente';
$string['validatingh5pfailed'] = 'La convalida del pacchetto H5P non è andata a buon fine.';
$string['validationfailed'] = 'L\'H5P richiesto non è valido';
$string['viewreportlabel'] = 'Report';
$string['welcomecommunity'] = 'Ci auguriamo che H5P ti piaccia e di coinvolgerti nella nostra community attraverso i nostri <a {$a->forums}>forum</a> </a>';
$string['welcomecontactus'] = 'Non esitare a <a {$a}>contattarci</a> per inviarci un feedback. Prendiamo molto seriamente i feedback e ci impegniamo a migliorare H5P ogni giorno!';
$string['welcomegettingstarted'] = 'Prima di iniziare con H5P e Moodle dai un\'occhiata al nostro <a {$a->moodle_tutorial}>tutorial</a> e ai nostri <a {$a->example_content}>esempi di contenuto</a> su H5P.org per trovare l\'ispirazione.<br>I contenuti più popolari sono già stati installati per tua comodità!';
$string['welcomeheader'] = 'Benvenuto nel mondo H5P!';
$string['wrongversion'] = 'La versione della libreria H5P {$a->%machineName} utilizzata in questo contenuto non è valida. Esso contiene {$a->%contentLibrary}, mentre dovrebbe essere {$a->%semanticsLibrary}.';
$string['year'] = 'Anno';
$string['years'] = 'Anno/i';
$string['yearsfrom'] = 'Anni (da)';
$string['yearsto'] = 'Anni (fino a)';
