<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'lt', version '4.4'.
 *
 * @package     lesson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Prieigos valdymas';
$string['actionaftercorrectanswer'] = 'Veiksmas atsakius teisingai';
$string['actionaftercorrectanswer_help'] = 'Atsakius į klausimą teisingai šiame puslapyje pateikiamos 3 parinktys: * Įprasta – atidaryti pamokos kelią * Rodyti nematytą puslapį – puslapiai rodomi atsitiktine tvarka, nė vienas iš jų nerodomas dukart * Rodyti neatsakytų klausimų turintį puslapį – puslapiai rodomi atsitiktine tvarka, o turintys neatsakytų klausimų rodomi dar kartą';
$string['actions'] = 'Veiksmai';
$string['activitylink'] = 'Saitas su veikla';
$string['activitylink_help'] = 'Norėdami pamokos pabaigoje pateikti nuorodą į kitą kurso veiklą, išskleidžiamajame meniu pasirinkite veiklą.';
$string['activitylinkname'] = 'Eiti į: {$a}';
$string['activityoverview'] = 'Jūs turite laukiamų pamokų';
$string['addabranchtable'] = 'Įtraukti turinio puslapį';
$string['addanendofbranch'] = 'Įtraukti šakos pabaigą';
$string['addanewpage'] = 'Įtraukti naują puslapį';
$string['addaquestionpage'] = 'Įtraukti klausimų puslapį';
$string['addaquestionpagehere'] = 'Įtraukti klausimų puslapį čia';
$string['addbranchtable'] = 'Įtraukti turinio puslapį';
$string['addcluster'] = 'Įtraukti telkinį';
$string['addedabranchtable'] = 'Įtraukė turinio puslapį';
$string['addedanendofbranch'] = 'Įtraukė šakos pabaigą';
$string['addedaquestionpage'] = 'Įtraukė klausimų puslapį';
$string['addedcluster'] = 'Įtraukė telkinį';
$string['addedendofcluster'] = 'Įtraukė telkinio pabaigą';
$string['addendofbranch'] = 'Pridėti šakos pabaigą';
$string['addendofcluster'] = 'Įtraukti telkinio pabaigą';
$string['addessay'] = 'Sukurti "Esė" klausimo puslapį';
$string['addmatching'] = 'Sukurti "Atitikimas" klausimo puslapį';
$string['addmultichoice'] = 'Sukurti "Keli pasirinkimai" klausimo puslapį';
$string['addnewgroupoverride'] = 'Įtraukti grupės keitimą';
$string['addnewuseroverride'] = 'Įtraukti naudotojo keitimą';
$string['addnumerical'] = 'Sukurti "Skaitinis" klausimo puslapį';
$string['addpage'] = 'Įtraukti puslapį';
$string['addshortanswer'] = 'Sukurti "Trumpas atsakymas" klausimo puslapį';
$string['addtruefalse'] = 'Sukurti "Teisingas/Klaidingas" klausimo puslapį';
$string['allotheranswers'] = 'Visi kiti atsakymai';
$string['allotheranswersjump'] = 'Visų kitų atsakymų šuoliai';
$string['allotheranswersscore'] = 'Visų kitų įvertinimų balai';
$string['allowofflineattempts'] = 'Leisti bandyti pamoką neprisijungus, naudojant mobiliąją programėlę';
$string['allowofflineattempts_help'] = 'Jei įgalinta, mobiliosios programėlės naudotojai gali atsisiųsti pamoką ir bandyti ją neprisijungus. Visi galimi ir teisingi atsakymai taip pat bus atsisiunčiami.
Pastaba: pamoka negali būti bandoma neprisijungus, jei yra nustatytas laiko limitas.';
$string['anchortitle'] = 'Pagrindinio turinio pradžia';
$string['and'] = 'IR';
$string['answer'] = 'Atsakymas';
$string['answeredcorrectly'] = 'atsakyta teisingai.';
$string['answersfornumerical'] = 'Sunumeruotų klausimų atsakymai turi atitikti minimalių ir maksimalių reikšmių poras';
$string['arrangebuttonshorizontally'] = 'Ar išdėstyti turinio mygtukus horizontaliai?';
$string['attempt'] = 'Bandymas: {$a}';
$string['attemptheader'] = 'Bandymas';
$string['attemptinfonograde'] = '{$a->timestart} ({$a->duration})';
$string['attemptinfowithgrade'] = '{$a->grade}% {$a->timestart} ({$a->duration})';
$string['attempts'] = 'Bandymai';
$string['attemptsdeleted'] = 'Panaikinti bandymai';
$string['attemptsremaining'] = 'Turite likusių bandymų: {$a}';
$string['available'] = 'Galima nuo';
$string['averagescore'] = 'Vidutinis balas';
$string['averagetime'] = 'Vidutinis laikas';
$string['branch'] = 'Turinys';
$string['branchtable'] = 'Turinys';
$string['cachedef_overrides'] = 'Naudotojo ir grupės perrašymo informacija';
$string['cancel'] = 'Atšaukti';
$string['cannotfindanswer'] = 'Klaida: nepavyko rasti atsakymo';
$string['cannotfindattempt'] = 'Klaida: nepavyko rasti bandymo';
$string['cannotfindessay'] = 'Klaida: nepavyko rasti esė';
$string['cannotfindfirstgrade'] = 'Klaida: nepavyko rasti įvertinimų';
$string['cannotfindfirstpage'] = 'Nepavyko rasti pirmo puslapio';
$string['cannotfindgrade'] = 'Klaida: nepavyko rasti įvertinimų';
$string['cannotfindnewestgrade'] = 'Klaida: nepavyko rasti naujausio įvertinimo';
$string['cannotfindnextpage'] = 'Pamokos atsarginė kopija: nerasta paskesnio puslapio!';
$string['cannotfindpagerecord'] = 'Įtraukti šakos pabaigą: nerasta puslapio įrašo';
$string['cannotfindpages'] = 'Nepavyko rasti pamokos puslapių';
$string['cannotfindpagetitle'] = 'Patvirtinti naikinimą: nerasta puslapio pavadinimo';
$string['cannotfindpreattempt'] = 'Ankstesnio bandymo įrašo nepavyko rasti';
$string['cannotfindrecords'] = 'Klaida: nepavyko rasti pamokų įrašų';
$string['cannotfindtimer'] = 'Klaida: nepavyko rasti lesson_timer įrašų';
$string['cannotfinduser'] = 'Klaida: nepavyko rasti naudotojų';
$string['canretake'] = '{$a} gali bandyti dar kartą';
$string['casesensitive'] = 'Naudoti reguliariąsias išraiškas';
$string['casesensitive_help'] = 'Pažymėti žymės langelį norint naudoti reguliariąsias išraiškas atsakymams analizuoti.';
$string['checkbranchtable'] = 'Patikrinti turinio puslapį';
$string['checkedthisone'] = 'Patikrintas šis.';
$string['checknavigation'] = 'Patikrinti naršymą';
$string['checkquestion'] = 'Patikrinti klausimą';
$string['classstats'] = 'Klasės statistiniai duomenys';
$string['clicktodownload'] = 'Norėdami atsisiųsti failą, spustelėkite šį saitą.';
$string['closebeforeopen'] = 'Nepavyko atnaujinti pamokos. Uždarymo data nurodyta ankstesnė nei atidarymo data.';
$string['cluster'] = 'Klasteris';
$string['clusterjump'] = 'Telkinyje nematomas klausimas';
$string['clustertitle'] = 'Klasteris';
$string['collapsed'] = 'Sutraukta';
$string['comments'] = 'Jūsų komentarai';
$string['completed'] = 'Baigta';
$string['completederror'] = 'Baigti pamoką';
$string['completethefollowingconditions'] = 'Norėdami tęsti turite išpildyti šias pamokos <b>{$a}</b> sąlygą (-as).';
$string['completiondetail:reachend'] = 'Pereiti veiklą iki pabaigos';
$string['completiondetail:timespent'] = 'Praleisti mažiausiai {$a} šioje veikloje';
$string['completionendreached'] = 'Reikalauti pabaigos';
$string['completionendreached_desc'] = 'Besimokantysis turi užbaigti pamokos puslapį veiklos užbaigimui';
$string['completiontimespent'] = 'Besimokantysis turi atlikti BENT šią veiklą';
$string['completiontimespentdesc'] = 'Studentas turi atlikti šią veiklą mažiausiai {$a}';
$string['completiontimespentgroup'] = 'Privalomas laiko praleidimas';
$string['conditionsfordependency'] = 'Priklausomybės sąlyga (-os)';
$string['configintro'] = 'Čia nustatytos reikšmės apibrėžia numatytąsias reikšmes, kurios naudojamos nustatymų formoje kuriant naują pamokos veiklą. Nustatymai, nurodyti kaip išplėstiniai, rodomi tik spustelėjus nuorodą „Rodyti daugiau...“.';
$string['configmaxanswers'] = 'Numatytasis maksimalus atsakymų skaičius puslapyje';
$string['configmediaclose'] = 'Rodo uždarymo mygtuką kaip dalį iššokančiojo lango, sugeneruoto pagal susijusį medijos failą';
$string['configmediaheight'] = 'Nustato susijusiam medijos failui skirto rodomo iššokančiojo lango aukštį';
$string['configmediawidth'] = 'Nustato susijusiam medijos failui skirto rodomo iššokančiojo lango plotį';
$string['configpassword_desc'] = 'Ar reikalingas slaptažodis norint patekti į pamoką.';
$string['configslideshowbgcolor'] = 'Skaidrių fono spalva, jei ji įjungta';
$string['configslideshowheight'] = 'Nustato skaidrių demonstravimo (jei įjungtas) aukštį';
$string['configslideshowwidth'] = 'Nustato skaidrių demonstravimo (jei įjungtas) plotį';
$string['configtimelimit_desc'] = 'Jei nustatytas laiko limitas, pamokos pradžioje rodomas įspėjimas ir yra atgalinės atskaitos laikmatis. Jei nustatyta į nulį, laiko limito nėra.';
$string['confirmdelete'] = 'Naikinti puslapį';
$string['confirmdeletionofthispage'] = 'Patvirtinti šio puslapio naikinimą';
$string['congratulations'] = 'Sveikiname. Pasiekta pamokos pabaiga.';
$string['continue'] = 'Tęsti';
$string['continuetoanswer'] = 'Toliau keisti atsakymus.';
$string['continuetonextpage'] = 'Toliau į sekantį puslapį.';
$string['correctanswerjump'] = 'Teisingo atsakymo saitas';
$string['correctanswerscore'] = 'Teisingo atsakymo balas';
$string['correctresponse'] = 'Teisingas atsakymas';
$string['createaquestionpage'] = 'Sukurti klausimo puslapį';
$string['credit'] = 'Kreditas';
$string['customscoring'] = 'Pasirinktinis vertinimas balais';
$string['customscoring_help'] = 'Jei įjungta, prie kiekvieno atsakymo galima įvesti sveikojo skaičiaus reikšmę (teigiamą arba neigiamą).';
$string['deadline'] = 'Terminas';
$string['defaultessayresponse'] = 'Jūsų esė įvertins kurų dėstytojas.';
$string['deleteallattempts'] = 'Naikinti visus pamokos bandymus';
$string['deletedefaults'] = 'Panaikinta {$a} x pamokos numatytųjų';
$string['deletedpage'] = 'Panaikinti puslapiai';
$string['deletepagenamed'] = 'Naikinti puslapį: {$a}';
$string['deleting'] = 'Naikinama';
$string['deletingpage'] = 'Naikinamas puslapis: {$a}';
$string['dependencyon'] = 'Priklauso nuo';
$string['dependencyon_help'] = 'Šis nustatymas leidžia pasiekti šią pamoką priklausomai nuo besimokančiojo pasirodymo kitoje to paties kurso pamokoje. Gali būti naudojamas bet koks derinys: Praleistas laikas, Baigta arba „Geresnis įvertinimas nei“.';
$string['description'] = 'Aprašas';
$string['deselectallattempts'] = 'Atšaukti visų bandymų pasirinkimą';
$string['detailedstats'] = 'Išsamūs statistiniai duomenys';
$string['didnotanswerquestion'] = 'Neatsakė į šį klausimą.';
$string['didnotreceivecredit'] = 'Negavo kredito';
$string['disabled'] = 'Išjungtas';
$string['displaydefaultfeedback'] = 'Rodyti numatytąjį atsiliepimą';
$string['displaydefaultfeedback_help'] = 'Jei įjungta, neradus atsakymo į tam tikrą klausimą, rodomas numatytasis atsakymas „Teisingas atsakymas“ arba „Klaidingas atsakymas“.';
$string['displayinleftmenu'] = 'Ar rodyti meniu?';
$string['displayleftif'] = 'Rodyti kairįjį meniu tik kai įvertinimas didesnis nei';
$string['displayleftif_help'] = 'Šis parametras apibrėžia, ar besimokantysis turi gauti tam tikrą įvertį, kad galėtų peržiūrėti pamokos meniu. Todėl per pirmąjį bandymą besimokantieji privalo peržvelgti visą pamoką, kad gavę reikiamą įvertį galėtų naudoti peržiūros meniu.';
$string['displayleftmenu'] = 'Rodyti meniu';
$string['displayleftmenu_help'] = 'Jei įjungta, rodomas meniu, kuriuo naudotojai gali naršyti per puslapių sąrašą.';
$string['displaymode'] = 'Rodymo rėžimas';
$string['displayofgrade'] = 'Įvertinimų rodymas (tik besimokantiesiems)';
$string['displayreview'] = 'Pateikti parinktį dar kartą bandyti atsakyti į klausimą';
$string['displayreview_help'] = 'Jei įjungta, kai į klausimą atsakoma neteisingai, besimokančiąjam suteikiama galimybė bandyti jį dar kartą ir negauti taškų, arba tęsti pamoką. Jei besimokantysis spragteli, kad pereitų prie kito klausimo, bus sekamas pasirinktas (neteisingas) atsakymas. Pagal numatytuosius nustatymus klaidingų atsakymų šuoliai nustatomi kaip „šis puslapis“ ir turi 0 balų, todėl rekomenduojama neteisingą atsakymą nustatyti kitame puslapyje, kad išvengtumėte painiavos su besimokančiaisiais.';
$string['displayscorewithessays'] = 'Surinkote {$a->score} iš {$a->tempmaxgrade} už automatiškai vertinamus klausimus.<br />Vėliau jūsų {$a->essayquestions} esė klausimas (-ai) bus įvertintas (-i) ir įtrauktas (-i) <br />į galutinį balą.<br /><br />Dabartinis jūsų įvertinimas be esė klausimo (-ų) yra {$a->score} iš {$a->grade}.';
$string['displayscorewithoutessays'] = 'Jūsų balas yra {$a->score} (iš {$a->grade}).';
$string['duplicatepagenamed'] = 'Dubliuoti puslapį: {$a}';
$string['edit'] = 'Redaguoti';
$string['editbranchtable'] = 'Turinio puslapio redagavimas';
$string['editcluster'] = 'Grupės redagavimas';
$string['editendofbranch'] = 'Šakos pabaigos puslapio redagavimas';
$string['editendofcluster'] = 'Grupės pabaigos puslapio redagavimas';
$string['editessay'] = 'Klausimo "Esė" puslapio redagavimas';
$string['editinglesson'] = 'Redaguojama pamoka';
$string['editingquestionpage'] = 'Redaguojamas {$a} klausimų puslapis';
$string['editlesson'] = 'Redaguoti pamoką';
$string['editlessonsettings'] = 'Redaguoti pamokos parametrus';
$string['editmatching'] = 'Klausimo "Atitikimas" puslapio redagavimas';
$string['editmultichoice'] = 'Klausimo "Keli pasirinkimai" puslapio redagavimas';
$string['editnumerical'] = 'Klausimo "Skaitinis" puslapio redagavimas';
$string['editoverride'] = 'Redaguoti keitimus';
$string['editpage'] = 'Redaguoti puslapio turinį';
$string['editpagecontent'] = 'Redaguoti puslapio turinį';
$string['editquestion'] = 'Klausimo puslapio redagavimas';
$string['editshortanswer'] = 'Klausimo "Trumpas atsakymas" puslapio redagavimas';
$string['edittruefalse'] = 'Klausimo  "Teisingas/Klaidingas" puslapio redagavimas';
$string['email'] = 'El. laiškas';
$string['emailallgradedessays'] = 'Siųsti pranešimus apie įvertintus esė';
$string['emailgradedessays'] = 'Siųsti pranešimus apie įvertintus esė';
$string['emailsuccess'] = 'Pranešimai sėkmingai išsiųsti';
$string['emptypassword'] = 'Slaptažodis negali būti tuščias';
$string['enabled'] = 'Įjungtas';
$string['endofbranch'] = 'Šakos pabaiga';
$string['endofcluster'] = 'Telkinio pabaiga';
$string['endofclustertitle'] = 'Telkinio pabaiga';
$string['endoflesson'] = 'Pamokos pabaiga';
$string['enteredthis'] = 'įvesta tai.';
$string['enterpassword'] = 'Įveskite slaptažodį:';
$string['eolstudentoutoftime'] = 'Dėmesio: baigėsi šios pamokos skirtasis laikas. Jei jūsų paskutinis atsakymas buvo pateiktas šiam laikui pasibaigus, jis gali būti neįskaičiuotas.';
$string['eolstudentoutoftimenoanswers'] = 'Neatsakėte nė į vieną klausimą. Už šią pamoką surinkote 0 balų.';
$string['essay'] = 'Esė';
$string['essayemailmessage2'] = '<p>Esė raginimas:{$a->question}</p><p>Jūsų atsakymas:<em>{$a->response}</em></p><p>Vertintojo komentarai:<em>{$a->comment}</em></p><p>Gavote {$a->earned} iš {$a->outof} už šį esė klausimą.</p><p>Jūsų įvertinimas pamokai {$a->lesson} pakeistas į {$a->newgrade} %.</p>';
$string['essayemailmessagesmall'] = '<p>Gavote {$a->earned} iš {$a->outof} už šį esė klausimą.</p><p>Jūsų įvertinimas už {$a->lesson} pamoką buvo pakeistas į{$a->newgrade}%.</p>';
$string['essayemailsubject'] = 'Galimas įvertinimas pamokos klausimui';
$string['essaynotgradedyet'] = 'Šis esė dar neįvertintas';
$string['essayresponses'] = 'Esė atsakymai';
$string['essays'] = 'Esė';
$string['essayscore'] = 'Esė balas';
$string['eventcontentpageviewed'] = 'Turinio puslapis peržiūrėtas';
$string['eventessayassessed'] = 'Esė įvertinta';
$string['eventessayattemptviewed'] = 'Esė bandymas peržiūrėtas';
$string['eventhighscoreadded'] = 'Pridėtas aukščiausias pamokos balas';
$string['eventhighscoresviewed'] = 'Peržiūrėtas aukščiausias pamokos balas';
$string['eventlessonended'] = 'Pamoka baigėsi';
$string['eventlessonrestarted'] = 'Pamoka paleista iš naujo';
$string['eventlessonresumed'] = 'Pamoka tęsiama';
$string['eventlessonstarted'] = 'Pamoka prasidėjo';
$string['eventoverridecreated'] = 'Pamokos keitimai sukurti';
$string['eventoverridedeleted'] = 'Pamokos keitimas ištrintas';
$string['eventoverrideupdated'] = 'Pamokos keitimai atnaujinti';
$string['eventpagecreated'] = 'Puslapis sukurtas';
$string['eventpagedeleted'] = 'Puslapis ištrintas';
$string['eventpagemoved'] = 'Puslapis perkeltas';
$string['eventpageupdated'] = 'Puslapis atnaujintas';
$string['eventquestionanswered'] = 'Klausimas atsakytas';
$string['eventquestionviewed'] = 'Klausimas peržiūrėtas';
$string['false'] = 'Netiesa';
$string['fileformat'] = 'Failo formatas';
$string['finalwrong'] = 'Ne visai.';
$string['finish'] = 'Pabaigti';
$string['firstanswershould'] = 'Pirmasis atsakymas turi nukreipti į puslapį Teisinga';
$string['firstwrong'] = 'Jūs atsakėte neteisingai. Ar norėtumėte dar kartą bandyti klausimą? (Jei dabar jūs teisingai atsakysite į klausimą, tai galutinio rezultato nepakeis.)';
$string['flowcontrol'] = 'Srauto valdymas';
$string['fractionsaddwrong'] = 'Teigiami įvertinimai, kuriuos pasirinkote neudaro 100% <br />Jie siekia tik {$a}%<br />Ar norėtumėte sugryžti ir ištaisyti šį klausimą?';
$string['fractionsnomax'] = 'Vienas iš atsakymų turi sudaryti 100%, <br />kad būtų teigiamai įvertintas šis klausimas.<br />Ar norėtumėte sugryžti ir ištaisyti šį klausimą?';
$string['full'] = 'Išplėsta';
$string['general'] = 'Bendra';
$string['gotoendoflesson'] = 'Eiti į pamokos pabaigą';
$string['grade'] = 'Įvertinimas';
$string['gradebetterthan'] = 'Įvertinimas geresnis nei (%)';
$string['gradebetterthanerror'] = 'Gauti geresnį nei {$a} proc. įvertinimą';
$string['graded'] = 'Įvertinta';
$string['gradeessay'] = 'Esė klausimai ({$a->notgradedcount} neįvertinti ir {$a->notsentcount} neišsiųsti)';
$string['gradeis'] = 'Įvertinimas yra {$a}';
$string['gradeoptions'] = 'Įvertinimų parinktys';
$string['groupoverrides'] = 'Grupės keitimai';
$string['groupoverridesdeleted'] = 'Grupės keitimai ištrinti';
$string['groupsnone'] = 'Nėra grupių, kurias galėtumėte pasiekti.';
$string['handlingofretakes'] = 'Atliktų iš naujo bandymų tvarkymas';
$string['handlingofretakes_help'] = 'Jei leidžiama atIikti iš naujo, šis parametras nurodo, ar pamokos įvertinimas yra vidutinis ar didžiausias iš visų bandymų.';
$string['havenotgradedyet'] = 'Dar neįvertinta.';
$string['here'] = 'čia';
$string['highscore'] = 'Aukštas balas';
$string['hightime'] = 'Ilga trukmė';
$string['importcount'] = 'Importuojami {$a} klausimai';
$string['importquestions'] = 'Importuoti klausimus';
$string['importquestions_help'] = 'Ši funkcija leidžia naudojant tekstinį failą importuoti įvairiais formatais pateiktus klausimus.';
$string['inactiveoverridehelp'] = '* Šis nepaisymas neaktyvus, nes naudotojo prieiga prie veiklos yra apribota. Taip gali nutikti dėl grupės ar vaidmenų priskyrimo, kitų prieigos apribojimų arba paslėptos veiklos.';
$string['indicator:cognitivedepth'] = 'Kognityvinė pamoka';
$string['indicator:cognitivedepth_help'] = 'Šis rodiklis pagrįstas pažinimo gyliu, kurį besimokantysis pasiekia Pamokos veikloje.';
$string['indicator:cognitivedepthdef'] = 'Kognityvinė pamoka';
$string['indicator:cognitivedepthdef_help'] = 'Dalyvis per šį analizės intervalą pasiekė šį kognityvinio įsitraukimo procentą, kurį siūlo Pamokos veikla (Lygiai = Neperžiūrėta, Peržiūrėta, Pateikta, Peržiūrėtas atsiliepimas, Pakomentuotas atsiliepimas, Pateikta iš naujo po peržiūros)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Socialinė pamoka';
$string['indicator:socialbreadth_help'] = 'Šis rodiklis pagrįstas socialiniu platumu, kurį besimokantysis pasiekia pamokos veikloje.';
$string['indicator:socialbreadthdef'] = 'Socialinė pamoka';
$string['indicator:socialbreadthdef_help'] = 'Dalyvis per šį analizės intervalą pasiekė šį socialinio įsitraukimo procentą, kurį siūlo Pamokos veikla (Lygiai = Nedalyvauja, Dalyvis vienas, Dalyvis su kitais)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insertedpage'] = 'Įterptas puslapis';
$string['invalidfile'] = 'Netinkamas failas';
$string['invalidid'] = 'Neperduotas kursų modulio arba pamokos ID';
$string['invalidlessonid'] = 'pamokos ID klaidingas';
$string['invalidoverrideid'] = 'Netinkamas keitimų id';
$string['invalidpageid'] = 'Puslapio ID klaidingas';
$string['jump'] = 'Saitas';
$string['jumps'] = 'Saitai';
$string['jumps_help'] = 'Kiekvienas atsakymas (į klausimus) arba aprašas (turinio puslapių) turi atitinkamą saitą. Saitas gali būti susijęs, pvz., šis puslapis arba kitas puslapis, arba nurodantis tik kurį nors iš pamokos puslapių.';
$string['jumpsto'] = 'Saitai su<em>{$a}</em>';
$string['leftduringtimed'] = 'Išėjote vykstant nustatyto laiko pamokai.<br />Spustelėkite Tęsti ir pradėkite pamoką iš naujo.';
$string['leftduringtimednoretake'] = 'Išėjote vykstant nustatyto laiko pamokai. Jums <br />neleidžiama bandyti iš naujo arba tęsti pamokos.';
$string['leftduringtimedsession'] = 'Laiku baigėte pamoką.';
$string['lesson:addinstance'] = 'Pridėti naują pamoką';
$string['lesson:edit'] = 'Redaguoti pamokos veiklą';
$string['lesson:grade'] = 'Vertinti pamokos esė klausimus';
$string['lesson:manage'] = 'Tvarkyti pamokos veiklą';
$string['lesson:manageoverrides'] = 'Tvarkyti pamokos keitimus';
$string['lesson:view'] = 'Peržiūrėti pamokos veiklą';
$string['lesson:viewreports'] = 'Peržiūrėti pamokos ataskaitas';
$string['lessonbeingpreviewed'] = 'Šiuo metu vyksta pamokos peržiūra.';
$string['lessonclosed'] = 'Ši pamoka uždaryta {$a}.';
$string['lessoncloses'] = 'Pamoka uždaroma';
$string['lessoneventcloses'] = '{$a} uždaroma';
$string['lessoneventopens'] = '{$a} atidaroma';
$string['lessonformating'] = 'Pamokos formatavimas';
$string['lessonmenu'] = 'Pamokos meniu';
$string['lessonnotready'] = 'Ši pamoka neparengta naudoti. Kreipkitės į savo {$a}.';
$string['lessonnotready2'] = 'Ši pamoka neparengta naudoti.';
$string['lessonopen'] = 'Ši pamoka bus atidaryta {$a}.';
$string['lessonopens'] = 'Pamoka atidaroma';
$string['lessonpagelinkingbroken'] = 'Nerasta pirmojo puslapio. Pamokos puslapio susiejimas turi būti nutrauktas. Kreipkitės į administratorių.';
$string['lessonstats'] = 'Pamokų statistiniai duomenys';
$string['linkedmedia'] = 'Susietoji medija';
$string['loginfail'] = 'Nepavyko prisijungti, bandykite dar kartą.';
$string['lowscore'] = 'Žemas balas';
$string['lowtime'] = 'Trumpa trukmė';
$string['manageoverrides'] = 'Tvarkyti keitimus';
$string['manualgrading'] = 'Vertinti esė';
$string['matchesanswer'] = 'Atitinka atsakymą';
$string['matching'] = 'Atitikimas';
$string['matchingpair'] = 'Atitinkanti pora {$a}';
$string['maxgrade'] = 'Didžiausias įvertinimas';
$string['maxgrade_help'] = 'Šis parametras nurodo didžiausią pamokos įvertinimą. Jei jis nustatytas kaip 0, pamoka nebus matoma įvertinimų puslapiuose.';
$string['maximumnumberofanswersbranches'] = 'Maksimalus atsakymų skaičius';
$string['maximumnumberofanswersbranches_help'] = 'Šis parametras nurodo maksimalų pamokoje naudojamų atsakymų skaičių. Jei naudojami tik teisinga / klaidinga tipo klausimai, jis gali būti nustatytas kaip 2. Parametrą galima keisti bet kuriuo metu, nes jis paveikia ne duomenis, o tik tai, ką mato dėstytojas.';
$string['maximumnumberofattempts'] = 'Maksimalus bandymų skaičius vienam klausimui';
$string['maximumnumberofattempts_help'] = 'Šis parametras nurodo maksimalų leidžiamų bandymų atsakyti į kiekvieną klausimą skaičių. Jei pasiekus maksimalų skaičių keliskart atsakoma klaidingai, rodomas kitas pamokos puslapis.';
$string['maximumnumberofattemptsreached'] = 'Pasiektas maksimalus bandymų skaičius. Perkeliama į kitą puslapį.';
$string['mediaclose'] = 'Rodyti uždarymo mygtuką';
$string['mediafile'] = 'Susietos medijos';
$string['mediafile_help'] = 'Medijos failas gali būti įkeltas pamokai. Nuoroda "Norėdami peržiūrėti, spustelėkite čia" bus rodoma kiekviename pamokos puslapyje bloke "Susietos medijos".';
$string['mediafilepopup'] = 'Norėdami peržiūrėti spustelėkite čia';
$string['mediaheight'] = 'Iššokančiojo lango aukštis';
$string['mediawidth'] = 'Iššokančiojo lango plotis';
$string['messageprovider:graded_essay'] = 'Pranešimas apie įvertintą pamokos esė';
$string['minimumnumberofquestions'] = 'Minimalus klausimų skaičius';
$string['minimumnumberofquestions_help'] = 'Šis parametras nurodo minimalų klausimų skaičių, pagal kurį bus skaičiuojamas veiklos įvertinimas.';
$string['missingname'] = 'Įveskite slapyvardį';
$string['modattempts'] = 'Leisti besimokančiųjų peržiūrą';
$string['modattempts_help'] = 'Jei įjungta, besimokantieji gali naršyti pamoką vėl nuo pradžios.';
$string['modattemptsnoteacher'] = 'Besimokančiųjų peržiūrą gali naudoti tik besimokantieji.';
$string['modulename'] = 'Pamoka';
$string['modulename_help'] = 'Pamokų modulis leidžia dėstytojams dėstyti adaptyviai, pateikiant klausimų turinčius puslapius.';
$string['modulename_link'] = 'mod/lesson/view';
$string['modulenameplural'] = 'Pamokos';
$string['move'] = 'Perkelti puslapį';
$string['movedpage'] = 'Perkeltas puslapis';
$string['movepagehere'] = 'Perkelti puslapį čia';
$string['movepagenamed'] = 'Perkelti puslapį: {$a}';
$string['moving'] = 'Perkeliamas puslapis: {$a}';
$string['multianswer'] = 'Keli atsakymai';
$string['multianswer_help'] = 'Pažymėkite žymės langelį, jei teisingi yra keli atsakymai.';
$string['multichoice'] = 'Keli pasirinkimai';
$string['multipleanswer'] = 'Keli atsakymai';
$string['nameapproved'] = 'Patvirtintas vardas';
$string['namereject'] = 'Atsiprašome, jūsų vardą atmetė filtras.<br />Pabandykite įvesti kitą vardą.';
$string['new'] = 'nauja';
$string['nextpage'] = 'Kitas puslapis';
$string['noanswer'] = 'Nepateiktas atsakymas. Grįžkite atgal ir pateikite atsakymą.';
$string['noattemptrecordsfound'] = 'Nerasta bandymų įrašų: negauta įvertinimų';
$string['nobranchtablefound'] = 'Nerasta turinio puslapio';
$string['noclose'] = 'Nėra užvėrimo datos';
$string['nocommentyet'] = 'Komentaro dar nėra.';
$string['nocoursemods'] = 'Nerasta veiklų.';
$string['nocredit'] = 'Nėra kredito';
$string['nodeadline'] = 'Nėra termino';
$string['noessayquestionsfound'] = 'Šioje pamokoje nerasta esė klausimų.';
$string['nohighscores'] = 'Nėra aukštų balų';
$string['nolessonattempts'] = 'Šioje pamokoje dar nebuvo bandymų.';
$string['nolessonattemptsgroup'] = '{$a} grupės nariai/ių šioje pamokoje nieko nebandė atlikti.';
$string['none'] = 'Nei vienas';
$string['nooneansweredcorrectly'] = 'Nė vienas neatsakė teisingai.';
$string['nooneansweredthisquestion'] = 'Nė vienas neatsakė į šį klausimą.';
$string['noonecheckedthis'] = 'Nė vienas to nepažymėjo.';
$string['nooneenteredthis'] = 'Nė vienas to neįvedė.';
$string['noonehasanswered'] = 'Nė vienas dar neatsakė į esė klausimą.';
$string['noonehasansweredgroup'] = 'Niekas iš {$a} dar neatsakė į esė klausimus.';
$string['noopen'] = 'Nėra atvėrimo datos';
$string['nooverridecreated'] = 'Keitimų nesukurta.';
$string['nooverridedata'] = 'Turite keisti bent vieną pamokos nustatymą.';
$string['noretake'] = 'Jums neleidžiama iš naujo pradėti šios pamokos.';
$string['normal'] = 'Įprasta – atidaryti pamokos kelią';
$string['notcompleted'] = 'Nebaigta';
$string['notcompletedwithdate'] = 'Nebaigta ({$a})';
$string['notdefined'] = 'Neapibrėžta';
$string['notenoughsubquestions'] = 'Nepakankamai įvesta subklausimų! Ar norite sugrįžti ir ištaisyti šį klausimą.';
$string['notenoughtimespent'] = 'Šią pamoką baigėte per {$a->timespent}, o tai yra mažiau nei reikalaujamas laikas {$a->timerequired}. Jums gali tekti pamėginti pamoką dar kartą.';
$string['notgraded'] = 'Neįvertinta';
$string['notitle'] = 'Nėra pavadinimo';
$string['notyetcompleted'] = 'Pamoka buvo pradėta, tačiau dar nėra baigta';
$string['numberofcorrectanswers'] = 'Teisingų atsakymų skaičius: {$a}';
$string['numberofcorrectanswersheader'] = 'Teisingų atsakymų skaičius';
$string['numberofcorrectmatches'] = 'Teisingų atitikčių skaičius: {$a}';
$string['numberofpagestoshow'] = 'Rodytinas puslapių skaičius';
$string['numberofpagestoshow_help'] = 'Šis parametras apibrėžia pamokoje rodomų puslapių skaičių. Jis taikomas tik pamokoms, kuriose puslapiai rodomi atsitiktine tvarka (kai parametras Veiksmas atsakius teisingai nustatytas kaip Rodyti nematytą  puslapį arba Rodyti neatsakytų klausimų turintį puslapį). Jei jis nustatytas kaip nulinis, rodomi visi puslapiai.';
$string['numberofpagesviewed'] = 'Atsakytų klausimų skaičius: {$a}';
$string['numberofpagesviewedheader'] = 'Atsakytų klausimų skaičius';
$string['numberofpagesviewednotice'] = 'Atsakytų klausimų skaičius: {$a->nquestions} (Turite atsakyti ne mažiau kaip {$a->minquestions})';
$string['numerical'] = 'Skaitinis';
$string['numericanswer'] = 'Skaitinis atsakymas';
$string['numericanswer_help'] = 'Galite nurodyti vieną skaičių arba skaičių diapazoną naudodami dvitaškį. Pavyzdžiui, 2:5 reiškia, kad bet koks atsakymas nuo 2 iki 5 ir įskaitant 2 ir 5 yra teisingas.';
$string['offlinedatamessage'] = 'Šį bandymą atlikote naudodami mobilųjį įrenginį. Paskutinį kartą duomenys šioje svetainėje buvo išsaugoti prieš {$a}. Patikrinkite, ar neturite neišsaugotų darbų.';
$string['ongoing'] = 'Rodyti esamą balą';
$string['ongoing_help'] = 'Jei įjungta, kiekviename puslapyje bus rodomi besimokančiojo dabar esami iki šio iš visų galimų surinkti taškai.';
$string['ongoingcustom'] = 'Iki šiol esate surinkę taškų: {$a->score} iš {$a->currenthigh}.';
$string['ongoingnormal'] = 'Teisingai atsakėte {$a->correct} iš {$a->viewed} bandymų.';
$string['onpostperpage'] = 'Tik vienas kiekvieno įvertinimo skelbimas';
$string['openafterclose'] = 'Atidarymo data nurodyta po uždarymo datos';
$string['options'] = 'Parinktys';
$string['or'] = 'ARBA';
$string['ordered'] = 'Surikiuota';
$string['other'] = 'Kita';
$string['outof'] = 'Iš {$a}';
$string['override'] = 'Keisti';
$string['overridedeletegroupsure'] = 'Ar tikrai norite naikinti grupės {$a} keitimą?';
$string['overridedeleteusersure'] = 'Ar tikrai norite naikinti naudotojo {$a} keitimą?';
$string['overridegroup'] = 'Keisti grupę';
$string['overridegroupeventname'] = '{$a->lesson} - {$a->group}';
$string['overrides'] = 'Keitimai';
$string['overrideuser'] = 'Keisti naudotoją';
$string['overrideusereventname'] = '{$a->lesson} - keitimas';
$string['overview'] = 'Apžvalga';
$string['overview_help'] = 'Pamoką sudaro tam tikras puslapių skaičius ir pasirinktinai turinio puslapiai. Tam tikro turinio turinčio puslapio pabaigoje paprastai pateikiamas klausimas. Su kiekvienu klausimo atsakymu susietas saitas. Saitas gali būti susijęs, pvz., šis puslapis arba kitas puslapis, arba nurodantis tik kurį nors iš pamokos puslapių. Turinio puslapyje pateikiami saitai su kitais pamokos puslapiais, pvz., turiniu.';
$string['page'] = 'Puslapis: {$a}';
$string['page-mod-lesson-edit'] = 'Redaguoti pamokos puslapį';
$string['page-mod-lesson-view'] = 'Peržiūrėti pamokos puslapį';
$string['page-mod-lesson-x'] = 'Bet kuri pamokos puslapis';
$string['pageanswers'] = 'Puslapio atsakymai';
$string['pagecontents'] = 'Puslapio turinys';
$string['pageresponses'] = 'Puslapio atsakymai';
$string['pages'] = 'Puslapiai';
$string['pagetitle'] = 'Puslapio pavadinimas';
$string['password'] = 'Slaptažodis';
$string['passwordprotectedlesson'] = '{$a} yra slaptažodžiu apsaugota pamoka.';
$string['pleasecheckoneanswer'] = 'Patikrinkite vieną atsakymą';
$string['pleasecheckoneormoreanswers'] = 'Patikrinkite vieną arba daugiau atsakymų';
$string['pleaseenteryouranswerinthebox'] = 'Lauke įveskite savo atsakymą';
$string['pleasematchtheabovepairs'] = 'Sugretinkite aukščiau esančias poras';
$string['pluginadministration'] = 'Pamokos administravimas';
$string['pluginname'] = 'Pamoka';
$string['pointsearned'] = 'Surinkta taškų';
$string['postprocesserror'] = 'Įvyko klaida atliekant baigiamąjį apdorojimą!';
$string['postsuccess'] = 'Skelbimas sėkmingas';
$string['practice'] = 'Praktinė pamoka';
$string['practice_help'] = 'Įvertinimų knygelėje nėra praktinės pamokos.';
$string['preprocesserror'] = 'Atliekant išankstinį apdorojimą įvyko klaida!';
$string['prerequisiteisobsolete'] = 'Būtinos pamokos parinktis turi būti pašalinta. Vietoj to naudokite prieigos apribojimus.';
$string['prerequisitelesson'] = 'Išankstinė pamokos sąlyga';
$string['preview'] = 'Peržiūra';
$string['previewlesson'] = 'Peržiūrėti {$a}';
$string['previewpagenamed'] = 'Peržiūros puslapis: {$a}';
$string['previouspage'] = 'Ankstesnis puslapis';
$string['privacy:metadata:attempts'] = 'Puslapio bandymų įrašas';
$string['privacy:metadata:attempts:answerid'] = 'Atsakymo ID';
$string['privacy:metadata:attempts:correct'] = 'Ar bandymas buvo teisingas';
$string['privacy:metadata:attempts:pageid'] = 'Puslapio ID';
$string['privacy:metadata:attempts:retry'] = 'Bandymo numeris';
$string['privacy:metadata:attempts:timeseen'] = 'Laikas, kada buvo atliktas bandymas';
$string['privacy:metadata:attempts:useranswer'] = 'Išsami informacija apie naudotojo atsakymą';
$string['privacy:metadata:attempts:userid'] = 'Naudotojo ID';
$string['privacy:metadata:branch'] = 'Įrašas apie peržiūrėtus puslapius';
$string['privacy:metadata:branch:flag'] = 'Ar kitas puslapis buvo apskaičiuotas atsitiktinai';
$string['privacy:metadata:branch:nextpageid'] = 'Sekančio puslapio ID';
$string['privacy:metadata:branch:pageid'] = 'Puslapio ID';
$string['privacy:metadata:branch:retry'] = 'Bandymo numeris';
$string['privacy:metadata:branch:timeseen'] = 'Laikas, kai puslapis buvo peržiūrėtas';
$string['privacy:metadata:branch:userid'] = 'Naudotojo ID';
$string['privacy:metadata:grades'] = 'Kiekvienos pamokos įvertinimų įrašas';
$string['privacy:metadata:grades:completed'] = 'Data, kada buvo suteiktas įvertinimas';
$string['privacy:metadata:grades:grade'] = 'Suteiktas įvertinimas';
$string['privacy:metadata:grades:userid'] = 'Naudotojo ID';
$string['privacy:metadata:overrides'] = 'Keitimų pamokoje įrašas';
$string['privacy:metadata:overrides:available'] = 'Laikas, kada galima bandyti pamoką';
$string['privacy:metadata:overrides:deadline'] = 'Pamokos baigimo terminas.';
$string['privacy:metadata:overrides:maxattempts'] = 'Maksimalus bandymų skaičius';
$string['privacy:metadata:overrides:password'] = 'Slaptažodis, norint patekti į pamoką';
$string['privacy:metadata:overrides:retake'] = 'Ar leidžiama pakartotinai atlikti';
$string['privacy:metadata:overrides:review'] = 'Leidžiama bandyti klausimą dar kartą';
$string['privacy:metadata:overrides:timelimit'] = 'Laiko limitas pamokai užbaigti sekundėmis.';
$string['privacy:metadata:overrides:userid'] = 'Naudotojo ID';
$string['privacy:metadata:timer'] = 'Pamokos bandymo įrašas';
$string['privacy:metadata:timer:completed'] = 'Nesvarbu, ar bandymas baigtas';
$string['privacy:metadata:timer:lessontime'] = 'Paskutinė akimirka, kai užfiksavome veiklą';
$string['privacy:metadata:timer:starttime'] = 'Bandymo pradžios data';
$string['privacy:metadata:timer:timemodifiedoffline'] = 'Paskutinė akimirka, kai įrašėme veiklą iš mobiliosios programėlės';
$string['privacy:metadata:timer:userid'] = 'Naudotojo ID';
$string['privacy:metadata:userpref:lessonview'] = 'Pageidaujamas rodymo režimas redaguojant pamokas';
$string['privacy:path:essayanswers'] = 'Esė atsakymai';
$string['privacy:path:essayresponses'] = 'Esė atsakymai';
$string['privacy:path:pages'] = 'Puslapiai';
$string['processerror'] = 'Apdorojant įvyko klaida!';
$string['progressbar'] = 'Eigos juosta';
$string['progressbar_help'] = 'Jei įjungta, juosta yra pamokos puslapių apačioje ir rodo apytikslį baigimo procentą.';
$string['progressbarteacherwarning'] = 'Nerodoma {$a} eigos juosta';
$string['progressbarteacherwarning2'] = 'Eigos juostos nematysite, kadangi galite redaguoti šią pamoką.';
$string['progresscompleted'] = 'Jūs užbaigėte {$a}% pamokos';
$string['qtype'] = 'Puslapio tipas';
$string['question'] = 'Klausimas';
$string['questionoption'] = 'Klausimas';
$string['questiontype'] = 'Klausimo tipas';
$string['randombranch'] = 'Atsitiktinis turinio puslapis';
$string['randompageinbranch'] = 'Atsitiktinis klausimas turinio puslapyje';
$string['rank'] = 'Rangas';
$string['rawgrade'] = 'Neapdorotas įvertinimas';
$string['receivedcredit'] = 'Gautas kreditas';
$string['redisplaypage'] = 'Iš naujo rodyti puslapį';
$string['removeallgroupoverrides'] = 'Ištrinti visus grupės keitimus';
$string['removealluseroverrides'] = 'Ištrinti visus naudotojo keitimus';
$string['report'] = 'Ataskaita';
$string['reports'] = 'Ataskaitos';
$string['response'] = 'Grįžtamasis ryšys';
$string['retakesallowed'] = 'Leidžiama atlikti iš naujo';
$string['retakesallowed_help'] = 'Jei įjungta, besimokantieji gali bandyti atlikti pamokos užduotis kelis kartus.';
$string['returnto'] = 'Grįžti į {$a}';
$string['returntocourse'] = 'Grįžti į kursus';
$string['reverttodefaults'] = 'Atkurti numatytąsias pamokos reikšmes';
$string['review'] = 'Peržiūrėti';
$string['reviewlesson'] = 'Peržiūrėti pamoką';
$string['reviewquestionback'] = 'Taip, norėčiau bandyti dar kartą';
$string['reviewquestioncontinue'] = 'Ne, norėčiau pereiti prie kito klausimo';
$string['sanitycheckfailed'] = 'Paviršinis patikrinimas nepavyko: šis bandymas ištrintas';
$string['save'] = 'Įrašyti';
$string['savechanges'] = 'Įrašyti keitimus';
$string['savechangesandeol'] = 'Įrašyti visus keitimus ir eiti į pamokos pabaigą.';
$string['saveoverrideandstay'] = 'Įrašyti ir įvesti kitą keitimą';
$string['savepage'] = 'Įrašyti puslapį';
$string['score'] = 'Balas';
$string['score_help'] = 'Jei pamokos nustatymuose įjungtas pasirinktinis vertinimas, prie kiekvieno atsakymo galima įrašyti sveiko skaičiaus reikšmę (teigiamą arba neigiamą).';
$string['scores'] = 'Balai';
$string['search:activity'] = 'Pamoka - veiklos informacija';
$string['secondpluswrong'] = 'Ne visai. Ar norėtumėte bandyti dar kartą?';
$string['selectallattempts'] = 'Pasirinkti visus bandymus';
$string['selectaqtype'] = 'Pasirinkti klausimo tipą';
$string['selectreport'] = 'Pasirinkti ataskaitą';
$string['sent'] = 'Išsiųsta';
$string['shortanswer'] = 'Trumpas atsakymas';
$string['showanunansweredpage'] = 'Rodyti neatsakytų klausimų turintį puslapį';
$string['showanunseenpage'] = 'Rodyti nematytą puslapį';
$string['singleanswer'] = 'Vienas atsakymas';
$string['skip'] = 'Praleisti naršymą';
$string['slideshow'] = 'Skaidrių demonstravimas';
$string['slideshow_help'] = 'Jei įjungta, pamoka rodoma kaip fiksuoto aukščio ir pločio skaidrių demonstravimas.';
$string['slideshowbgcolor'] = 'Skaidrių demonstravimo fono spalva';
$string['slideshowheight'] = 'Skaidrių demonstravimo aukštis';
$string['slideshowwidth'] = 'Skaidrių demonstravimo plotis';
$string['startlesson'] = 'Pradėti pamoką';
$string['studentattemptlesson'] = '{$a->lastname} {$a->firstname} bandymo numeris {$a->attempt}';
$string['studentname'] = '{$a} vardas';
$string['studentoneminwarning'] = 'Įspėjimas: pamokai užbaigti turite 1 minutę arba mažiau.';
$string['studentoutoftimeforreview'] = 'Dėmesio: šios pamokos peržiūros laikas baigėsi';
$string['studentresponse'] = '{$a} atsakymas';
$string['submit'] = 'Pateikti';
$string['submitname'] = 'Pateikti vardą';
$string['teacherjumpwarning'] = 'Šioje pamokoje naudojamas { $a->cluster} šuolis arba {$a->unseen} šuolis. Vietoj jo bus naudojamas kito puslapio šuolis. Prisijunkite kaip besimokantysis ir patikrinkite juos.';
$string['teacherongoingwarning'] = 'Esamas balas rodomas tik besimokančiajam. Prisijunkite kaip besimokantysis, kad patikrintumėte esamą balą.';
$string['teachertimerwarning'] = 'Laikmatį gali naudoti tik besimokantieji. Prisijunkite kaip besimokantysis ir patikrinkite laikmatį.';
$string['thatsthecorrectanswer'] = 'Tai yra teisingas atsakymas';
$string['thatsthewronganswer'] = 'Tai yra klaidingas atsakymas';
$string['thefollowingpagesjumptothispage'] = 'Toliau pateikti puslapiai nukreipia į šį puslapį';
$string['thispage'] = 'Šis puslapis';
$string['timeisup'] = 'Laikas baigėsi';
$string['timelimit'] = 'Laiko limitas';
$string['timelimit_help'] = 'Jei įjungta, pamokos pradžioje rodomas įspėjimas apie terminą ir rodomas atgalinės atskaitos laikmatis. Visi atsakymai pateikti pasibaigus laikui nėra vertinami.';
$string['timelimitwarning'] = 'Jūs turite {$a}, kad užbaigtumėte pamoką.';
$string['timeremaining'] = 'Liko laiko';
$string['timespenterror'] = 'Praleiskite bent {$a} min. šioje pamokoje';
$string['timespentminutes'] = 'Sugaištas laikas (minutėmis)';
$string['timetaken'] = 'Sugaišta laiko';
$string['totalpagesviewedheader'] = 'Puslapių skaičius peržiūrėtas';
$string['true'] = 'Tiesa';
$string['truefalse'] = 'Teisinga / klaidinga';
$string['unabledtosavefile'] = 'Jūsų įkelto failo nepavyko įrašyti';
$string['unknownqtypesnotimported'] = 'Nepalaikomų tipų {$a} klausimai neimportuoti';
$string['unseenpageinbranch'] = 'Nematytas klausimas turinio puslapyje';
$string['unsupportedqtype'] = 'Nepalaikomas klausimo tipas ({$a})!';
$string['updatedpage'] = 'Atnaujintas puslapis';
$string['updatefailed'] = 'Atnaujinti nepavyko';
$string['updatepagenamed'] = 'Atnaujinti puslapį: {$a}';
$string['usemaximum'] = 'Naudoti maksimalų';
$string['usemean'] = 'Naudoti vidutinį';
$string['usepassword'] = 'Slaptažodžiu apsaugota pamoka';
$string['usepassword_help'] = 'Jei įjungta, norint pasiekti pamoką būtina įvesti slaptažodį.';
$string['useroverrides'] = 'Naudotojo keitimai';
$string['useroverridesdeleted'] = 'Naudotojo keitimai ištrinti';
$string['usersnone'] = 'Besimokantieji neturi prieigos prie šios pamokos';
$string['viewessayanswers'] = 'Žiūrėti esė atsakymus';
$string['viewgrades'] = 'Peržiūrėti įvertinimus';
$string['viewreports'] = 'Peržiūrėti {$a->attempts} užbaigtus {$a->student} bandymus';
$string['viewreports2'] = 'Peržiūrėti {$a} užbaigtus bandymus';
$string['warning'] = 'Įspėjimas';
$string['welldone'] = 'Gerai!';
$string['whatdofirst'] = 'Ką pirma norėtumėte daryti?';
$string['withselectedattempts'] = 'Su pasirinktais bandymais...';
$string['wronganswerjump'] = 'Klaidingo atsakymo saitas';
$string['wronganswerscore'] = 'Klaidingo atsakymo balas';
$string['wrongresponse'] = 'Klaidingas atsakymas';
$string['youhaveseen'] = 'Jau matėte kelis šios pamokos puslapius.<br />Ar norite pradėti nuo paskutinio jūsų matyto puslapio?';
$string['youranswer'] = 'Jūsų atsakymas';
$string['yourcurrentgradeis'] = 'Dabartinis jūsų įvertinimas yra {$a}';
$string['yourcurrentgradeisoutof'] = 'Dabartinis jūsų įvertinimas yra {$a->grade} iš {$a->total}';
$string['youshouldview'] = 'Mažiausiai turite atsakyti: {$a}';
