<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lti', language 'mn', version '4.4'.
 *
 * @package     lti
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Зөвшөөрөх';
$string['accept_grades'] = 'Хэрэгслээс дүнг зөвшөөрөх';
$string['accept_grades_admin'] = 'Хэрэгслээс дүнг зөвшөөрөх';
$string['accept_grades_admin_help'] = 'Хэрэгслийн үйлчилгээ үзүүлэгч нь энэ хэрэгслийн хүсэлттэй холбоотой үнэлгээг нэмэх, шинэчлэх, унших, устгах боломжтой эсэхийг зааж өгнө.

Зарим хэрэгслийн үйлчилгээ үзүүлэгчид уг хэрэглүүрийн хүрээнд хийсэн үйлдлүүд дээр үндэслэн Moodle систем рүү дүнг буцаан тайлагнах боломжийг олгож, илүү нэгдсэн туршлагыг бий болгодог.';
$string['accept_grades_help'] = 'Хэрэгслийн үйлчилгээ үзүүлэгч нь энэ хэрэгслийн хүсэлттэй холбоотой үнэлгээг нэмэх, шинэчлэх, унших, устгах боломжтой эсэхийг зааж өгнө.

Зарим хэрэгслийн үйлчилгээ үзүүлэгчид уг хэрэгслийн хүрээнд хийсэн үйлдлүүд дээр үндэслэн Moodle систем рүү дүнг буцаан тайлагнах боломжийг олгож, илүү нэгдсэн туршлагыг бий болгодог.

Энэ тохиргоо нь хэрэгслийн тохиргоог хүчингүй болгож магадгүйг санаарай.';
$string['accepted'] = 'Зөвшөөрсөн';
$string['action'] = 'Үйлдэл';
$string['activate'] = 'Идэвхжүүлэх';
$string['activatetoadddescription'] = 'Тайлбар нэмэхээс өмнө энэ хэрэгслийг идэвхжүүлэх хэрэгтэй.';
$string['active'] = 'Идэвхтэй';
$string['activity'] = 'Үйл ажиллагаа';
$string['add_ltiadv'] = 'LTI Давуу тал нэмэх';
$string['add_ltilegacy'] = 'Уламжлалт LTI нэмэх';
$string['addnewapp'] = 'Гадаад аппликейшныг идэвхжүүлэх';
$string['addserver'] = 'Шинэ итгэмжлэгдсэн сервер нэмэх';
$string['addtype'] = 'Урьдчилан тохируулсан хэрэгсэл нэмэх';
$string['allow'] = 'Зөвшөөрөх';
$string['allowsetting'] = 'Moodle системд 8К тохиргоог хадгалахыг энэ хэрэгсэлд зөвшөөрөх';
$string['always'] = 'Үргэлж';
$string['autoaddtype'] = 'Хэрэгсэл нэмэх';
$string['automatic'] = 'Хэрэгслийн URL дээр үндэслэн автоматаар';
$string['baseurl'] = 'Үндсэн URL/хэрэгслийн бүртгэлийн нэр';
$string['basiclti'] = 'LTI';
$string['basiclti_base_string'] = 'LTI OAuth үндсэн тэмдэгт мөр';
$string['basiclti_endpoint'] = 'LTI-ийг эхлүүлэх төгсгөлийн цэг';
$string['basiclti_in_new_window'] = 'Таны үйл ажиллагааг шинэ цонхонд нээсэн';
$string['basiclti_in_new_window_open'] = 'Шинэ цонхонд нээх';
$string['basiclti_parameters'] = 'LTI-ийг эхлүүлэх параметр';
$string['basicltiactivities'] = 'LTI үйл ажиллагаа';
$string['basicltifieldset'] = 'Тусгай жишээний талбарын багц';
$string['basicltiintro'] = 'Үйл ажиллагааны тайлбар';
$string['basicltiname'] = 'Үйл ажиллагааны нэр';
$string['basicltisettings'] = 'Үндсэн Сургалтын Хэрэгслийн Харилцан ажиллах чадвар (LTI)-ийн тохиргоо';
$string['cachedef_keyset'] = 'Хэрэгслийн түлхүүрийн багцын мэдээллийг кэшлэх';
$string['cancel'] = 'Цуцлах';
$string['cancelled'] = 'Цуцалсан';
$string['cannot_delete'] = 'Та энэ хэрэгслийн тохиргоог устгаж болохгүй.';
$string['cannot_edit'] = 'Та энэ хэрэгслийн тохиргоог засварлаж болохгүй.';
$string['capabilities'] = 'Боломжууд';
$string['capabilities_help'] = 'Хэрэгслийн үйлчилгээ үзүүлэгчид санал болгохыг хүсэж буй чадвараа сонгоно. Нэгээс олон чадварыг сонгох боломжтой.';
$string['capabilitiesrequired'] = 'Энэ хэрэгслийг идэвхжүүлэхийн тулд дараах өгөгдөлд хандах шаардлагатай:';
$string['cleanaccesstokens'] = 'Хугацаа нь дууссан хандалтын токенуудыг арилгах гадаад хэрэгсэл';
$string['click_to_continue'] = '<a href="{$a->link}" target="_top">Үргэлжлүүлэх</a>';
$string['clientidadmin'] = 'Клиентийн ID';
$string['clientidadmin_help'] = 'Клиентийн ID нь хэрэгслийг танихад ашиглах дахин давагдахгүй утга юм. Үүнийг LTI 1.3-д нэвтрүүлсэн JWT хувийн мэдээллийн аюулгүй байдлын JWT-ийг ашигладаг хэрэгсэл бүрийн хувьд автоматаар үүсгэдэг. Хэрэгсэлтэй холбох холболтыг тохируулахын тулд хэрэгслийн үйлчилгээ үзүүлэгчид дамжуулах дэлгэрэнгүй мэдээлэлд Клиентийн ID оруулах ёстой.';
$string['comment'] = 'Тайлбар';
$string['configpassword'] = 'Өгөгдмөл зайн хэрэгслийн нууц үг';
$string['configpreferheight'] = 'Өгөгдмөл урьдчилан тохируулсан өндөр';
$string['configpreferwidget'] = 'Виджэтийг өгөгдмөлөөр эхэлдэг байхаар тохируулах';
$string['configpreferwidth'] = 'Өгөгдмөл урьдчилан тохируулсан өргөн';
$string['configresourceurl'] = 'Өгөгдмөл судлах материалын URL';
$string['configtoolurl'] = 'Өгөгдмөл зайн хэрэгслийн URL';
$string['configtypes'] = 'LTI аппликейшныг идэвхжүүлэх';
$string['configured'] = 'Тохируулсан';
$string['confirmtoolactivation'] = 'Та энэ хэрэгслийг идэвхжүүлэхдээ итгэлтэй байна уу?';
$string['contentitem_deeplinking'] = 'Гүн холбоосыг дэмжих (Агуулгын-Зүйл зурвас)';
$string['contentitem_deeplinking_help'] = 'Хэрэв тэмдэглэсэн бол гадны хэрэгсэл нэмэх үед "Агуулга сонгох" сонголт боломжтой болно.';
$string['contentitem_multiple_description'] = 'Дараах зүйлсийг таны хичээлд нэмэх болно:';
$string['contentitem_multiple_graded'] = 'Дүгнэсэн үйл ажиллагаа (Хамгийн өндөр дүн: {$a})';
$string['course_tool_types'] = 'Хичээлийн хэрэгсэл';
$string['courseactivitiesorresources'] = 'Хичээлийн үйл ажиллагаа эсвэл судлах материалууд';
$string['courseid'] = 'Хичээлийн ID дугаар';
$string['courseinformation'] = 'Хичээлийн мэдээлэл';
$string['courselink'] = 'Хичээл рүү очих';
$string['coursemisconf'] = 'Хичээлийг буруу тохируулсан байна';
$string['createdon'] = 'Үүсгэсэн:';
$string['curllibrarymissing'] = 'Гадаа хэрэгсэлд PHP cURL өргөтгөл шаардлагатай';
$string['custom'] = 'Тусгай параметрүүд';
$string['custom_config'] = 'Тусгай хэрэгслийн тохиргоог ашиглах.';
$string['custom_help'] = 'Тусгай параметрүүд нь хэрэгслийн үйлчилгээ үзүүлэгчийн ашигладаг тохиргоо юм. Жишээлбэл, үйлчилгээ үзүүлэгчээс тодорхой судлах материалыг харуулахын тулд өөрчлөн тохируулсан параметрийг ашиглаж болно. Параметр бүрийг "нэр=утга" (жишээ нь, "бүлэг = 3") форматыг ашиглан тусдаа мөрөнд оруулах ёстой.';
$string['custominstr'] = 'Тусгай параметрүүд';
$string['debuglaunch'] = 'Алдааг шалгах тохиргоо';
$string['debuglaunchoff'] = 'Энгийнээр эхлүүлэх';
$string['debuglaunchon'] = 'Алдааг шалгаж эхлүүлэх';
$string['default'] = 'Өгөгдмөл';
$string['default_launch_container'] = 'Өгөгдмөл эхлүүлэх тохиргоо';
$string['default_launch_container_help'] = 'Эхлүүлэх тохиргоо нь хичээлээс хэрэгслийг эхлүүлэх үед хэрхэн харагдахыг тодорхойлдог. Зарим эхлүүлэх тохиргоо нь нэмэлт цонх шаарддаг бол зарим нь Moodle системийн орчинтой илүү нэгдсэн мэдрэмжийг өгдөг.

* **Өгөгдмөл** - Хэрэгслийн тохиргоонд заасан эхлүүлэх тохиргоог ашиглана.
* **Эмбэд** - Энэ хэрэглүүрийг одоо байгаа Moodle цонхонд бусад үйл ажиллагааны төрлүүдтэй төстэй байдлаар харуулдаг.
* **Блокгүй эмбэд хийх** - Энэ хэрэгсэл нь одоо байгаа Moodle цонхонд гарч ирэх ба хуудасны дээд хэсэгт байрлах удирдлагын мөрөөр удирдах боломжтой.
* **Шинэ цонх** - Хэрэгсэл нь аль болох том хэмжээтэй шинэ цонхонд нээгдэнэ. Веб хөтчөөс хамааран энэ нь шинэ таб эсвэл нэмэлт цонхонд нээгдэнэ. Веб хөтчүүд шинэ цонх нээхээс сэргийлсэн байх магадлалтай.';
$string['delegate'] = 'Багшид төлөөлөх';
$string['delegate_tool'] = 'Гүн холболтын тодорхойлолт эсвэл багшид төлөөлөх хэсэгт заасны дагуу';
$string['delete'] = 'Устгах';
$string['delete_confirmation'] = 'Та энэ урьдчилан тохируулсан хэрэгслийг устгахдаа итгэлтэй байна уу?';
$string['deletetype'] = 'Урьдчилан тохируулсан хэрэгслийг устгах';
$string['display_description'] = 'Эхлүүлэх үед үйл ажиллагааны тайлбарыг харуулах';
$string['display_description_help'] = 'Сонгосон тохиолдолд үйл ажиллагааны тайлбар (дээр заасан) хэрэгслийн үйлчилгээ үзүүлэгчийн агуулга дээр гарч ирнэ.

Тодорхойлолтыг хэрэгслийг эхлүүлэгчдэд нэмэлт зааварчилгаа өгөхөд ашиглаж болох боловч энэ нь шаардлагагүй.

Хэрэгслийг эхлүүлэх тохиргоог нь шинэ цонхонд гэж тохируулсан үед тайлбар харагдахгүй.';
$string['display_name'] = 'Эхлүүлэх үед үйл ажиллагааны нэрийг харуулах';
$string['display_name_help'] = 'Сонгосон тохиолдолд үйл ажиллагааны нэр (дээр заасан) хэрэгслийн үйлчилгээ үзүүлэгчийн агуулга дээр гарч ирнэ.

Хэрэгслийн үйлчилгээ үзүүлэгч гарчгийг харуулах боломжтой. Энэ сонголт нь үйл ажиллагааны гарчгийг хоёр удаа харуулахаас сэргийлж чадна.

Хэрэгслийг эхлүүлэх тохиргоог нь шинэ цонхонд гэж тохируулсан үед гарчиг харагдахгүй.';
$string['domain_mismatch'] = 'Хэрэгслийн URL-ийн домэйн хэрэгслийн тохиргоотой таарахгүй байна.';
$string['donot'] = 'Илгээхгүй';
$string['donotaccept'] = 'Зөвшөөрөхгүй';
$string['donotallow'] = 'Зөвшөөрөхгүй';
$string['duplicateregurl'] = 'Энэ бүртгэлийн URL-ийг аль хэдийн ашиглаж байна';
$string['dynreg_update_btn_new'] = 'Шинэ гадаад хэрэгсэл болгон бүртгэх';
$string['dynreg_update_btn_update'] = 'Шинэчлэх';
$string['dynreg_update_name'] = 'Хэрэгслийн нэр';
$string['dynreg_update_notools'] = 'Агуулгад хэрэгсэл байхгүй.';
$string['dynreg_update_text'] = 'Бүртгэлийн домэйнд хавсаргасан хэрэгслүүд байна. Та аль хэдийн суулгасан гадаад хэрэгслийг шинэчлэх эсвэл шинэ гадаад хэрэгсэл үүсгэхийг хүсэж байна уу?';
$string['dynreg_update_url'] = 'Үндсэн URL';
$string['dynreg_update_version'] = 'LTI Хувилбар';
$string['dynreg_update_warn_dupdomain'] = 'Нэг домэйн дор олон гадаад хэрэгслийг ашиглахыг зөвлөдөггүй.';
$string['editdescription'] = 'Энэ хэрэгсэлд тайлбар өгөхийн тулд энд дарна уу';
$string['edittype'] = 'Урьдчилан тохируулсан хэрэгслийг засварлах';
$string['embed'] = 'Эмбэд';
$string['embed_no_blocks'] = 'Блокгүй эмбэд хийх';
$string['enableemailnotification'] = 'Мэдэгдлийн цахим шуудан илгээх';
$string['enableemailnotification_help'] = 'Идэвхжүүлсэн тохиолдолд суралцагчдын хэрэгслийн мэдүүлгийг дүгнэхэд суралцагч цахим шуудангаар мэдэгдэл хүлээн авна.';
$string['enterkeyandsecret'] = 'Хэрэглэгчийн түлхүүр болон хуваалцсан нууцаа оруулна уу';
$string['enterkeyandsecret_help'] = 'Хэрэв танд хэрэглэгчийн түлхүүр болон/эсвэл хуваалцсан нууц өгсөн бол энд оруулна уу';
$string['errorbadurl'] = 'URL нь хүчинтэй хэрэгслийн URL эсвэл бортого биш байна.';
$string['errorincorrectconsumerkey'] = 'Хэрэглэгчийн түлхүүр буруу байна.';
$string['errorinvaliddata'] = 'Хүчингүй өгөгдөл: {$a}';
$string['errorinvalidmediatype'] = 'Хүчингүй медиа төрөл: {$a}';
$string['errorinvalidresponseformat'] = 'Агуулга-Зүйл хариултын формат буруу байна.';
$string['errormisconfig'] = 'Буруу тохируулсан хэрэгсэл. Энэ хэрэгслийн тохиргоог засахыг Moodle системийн администратораас хүснэ үү.';
$string['errortooltypenotfound'] = 'LTI хэрэгслийн төрөл олдсонгүй';
$string['existing_window'] = 'Одоо байгаа цонх';
$string['extensions'] = 'LTI өргөтгөл үйлчилгээнүүд';
$string['external_tool_type'] = 'Урьдчилан тохируулсан хэрэгсэл';
$string['external_tool_type_help'] = '* **Хэрэгслийн URL дээр суурилан автоматаар** - Хэрэгслийн хамгийн сайн тохиргоог автоматаар сонгоно. Хэрэв багажийн URL-ийг танихгүй бол багажийн тохиргооны дэлгэрэнгүйг гараар оруулах шаардлагатай.
* **Урьдчилан тохируулсан тусгай хэрэгсэл** - Гадаад хэрэгслийн үйлчилгээ үзүүлэгчтэй холбогдох үед заасан хэрэгсэлд зориулсан хэрэгслийн тохиргоог ашиглана. Хэрэв хэрэгслийн URL нь хэрэгслийн үйлчилгээ үзүүлэгчид хамаарахгүй бол анхааруулга харагдах болно. Хэрэгслийн URL-ийг үргэлж оруулах шаардлагагүй.
* **Тусгай тохиргоо** - Хэрэглэгчийн түлхүүр болон хуваалцсан нууцыг гараар оруулах шаардлагатай. Хэрэглээний түлхүүр болон хуваалцсан нууцыг хэрэгслийн үйлчилгээ үзүүлэгчээс авч болно. Гэсэн хэдий ч бүх хэрэгсэлд хэрэглэгчийн түлхүүр болон хуваалцсан нууцыг шаарддаггүй бөгөөд энэ тохиолдолд талбаруудыг хоосон орхиж болно.

### Урьдчилан тохируулсан хэрэгсэл засварлах

Урьдчилан тохируулсан хэрэгслийн нээгдэх цэсийн дараа гурван дүрст тэмдэг гарч ирнэ:

* **Нэмэх** - Хичээлийн түвшинд хэрэгслийн тохиргоог үүсгэх. Энэ хичээлийн бүх гадаад хэрэгслийн тохиолдол нь хэрэгслийн тохиргоог ашиглаж болно.
* **Засварлах** - Нээгдэх цэсээс хичээлийн түвшний хэрэгслийг сонгоод, энэ дүрс дээр дарна уу. Хэрэгслийн тохиргооны дэлгэрэнгүйг засварлаж болно.
* **Устгах** - Хичээлийн түвшний сонгосон хэрэгслийг устгана.';
$string['external_tool_types'] = 'Урьдчилан тохируулсан хэрэгсэл';
$string['failedtoconnect'] = 'Moodle "{$a}" системтэй холбогдох боломжгүй байна';
$string['failedtocreatetooltype'] = 'Шинэ хэрэгсэл үүсгэхэд алдаа гарлаа. URL-ийг шалгаад дахин оролдоно уу.';
$string['failedtodeletetoolproxy'] = 'Хэрэгслийн бүртгэлийг устгахад алдаа гарлаа. Та "Гадаад хэрэгслийн бүртгэлийг удирдах" хэсгээс гараар устгах хэрэгтэй.';
$string['filter_basiclti_configlink'] = 'Илүүд үзэх сайтууд болон тэдгээрийн нууц үгийг тохируулах';
$string['filter_basiclti_password'] = 'Нууц үгийг заавал шаардана';
$string['filterconfig'] = 'LTI удирдлага';
$string['filtername'] = 'LTI';
$string['fixexistingconf'] = 'Буруу тохируулсан жишээнд одоо байгаа тохиргоог ашиглах';
$string['fixnew'] = 'Шинэ тохиргоо';
$string['fixnewconf'] = 'Буруу тохируулсан жишээнд шинэ тохиргоо үүсгэх';
$string['fixold'] = 'Одоо байгааг ашиглах';
$string['force_ssl'] = 'Албадмал SSL';
$string['force_ssl_help'] = 'Энэ сонголтыг сонгосноор тухайн хэрэгслийн үйлчилгээ үзүүлэгчийг бүх программуудыг SSL-г ашиглан эхлүүлэхийг албаддаг.

Мөн хэрэгслийн үйлчилгээ үзүүлэгчээс ирсэн бүх хүсэлтүүд SSL-г ашиглах болно.

Хэрэв энэ сонголтыг ашиглах бол Moodle сайт болон хэрэгслийн үйлчилгээ үзүүлэгч нь SSL-г дэмждэг эсэхийг шалгана уу.';
$string['forced_help'] = 'Энэ тохиргоог хичээл эсвэл сайтын түвшний хэрэгслийн тохиргоонд албадсан. Энэ хэсэгт тус тохиргоог өөрчлөх боломжгүй.';
$string['generaltool'] = 'Ерөнхий хэрэгсэл';
$string['global_tool_types'] = 'Урьдчилан тохируулсан хэрэгсэл';
$string['grading'] = 'Дүн чиглүүлэгч';
$string['icon_url'] = 'URL дүрст тэмдэг';
$string['icon_url_help'] = 'URL дүрст тэмдэг нь энэ үйл ажиллагааны хичээлийн жагсаалтад харагдах дүрст тэмдгийг өөрчлөх боломжийг олгодог. Өгөгдмөл LTI дүрст тэмдгийг ашиглахын оронд үйл ажиллагааны төрлийг илэрхийлэх дүрст тэмдгийг зааж өгч болно.';
$string['id'] = 'ID';
$string['indicator:cognitivedepth'] = 'LTI танин мэдэхүй';
$string['indicator:cognitivedepth_help'] = 'Энэ үзүүлэлт нь суралцагчийн LTI үйл ажиллагаанд олж авсан танин мэдэхүйн гүнд тулгуурладаг.';
$string['indicator:cognitivedepthdef'] = 'LTI танин мэдэхүй';
$string['indicator:cognitivedepthdef_help'] = 'Энэхүү шинжилгээний интервалын хугацаанд LTI үйл ажиллагаанаас санал болгож буй танин мэдэхүйн оролцоонд оролцогчийн хүрсэн хувь (Түвшин = Харагдахгүй, Харах, Илгээх, Санал хүсэлтийг харах)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'LTI нийгмийн хүрээ';
$string['indicator:socialbreadth_help'] = 'Энэ үзүүлэлт нь суралцагчийн LTI үйл ажиллагаанд олж авсан нийгмийн хүрээнд тулгуурладаг.';
$string['indicator:socialbreadthdef'] = 'LTI нийгмийн хүрээ';
$string['indicator:socialbreadthdef_help'] = 'Энэхүү шинжилгээний интервалын хугацаанд LTI үйл ажиллагаанаас санал болгож буй нийгмийн оролцоонд оролцогчийн хүрсэн хувь (Түвшин = Оролцоогүй, Ганцаар оролцох, Бусадтай оролцох)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['initiatelogin'] = 'Нэвтрэлтийг эхлүүлэх URL';
$string['initiatelogin_help'] = 'Нэвтрэх хүсэлтийг илгээх хэрэгслийн URL. Энэ URL нь тухайн хэрэгсэл рүү зурвас амжилттай илгээхэд шаардлагатай.';
$string['invalidid'] = 'LTI ID буруу байна';
$string['jwtsecurity'] = 'LTI 1.3';
$string['keytype'] = 'Нийтийн түлхүүрийн төрөл';
$string['keytype_help'] = 'Хэрэгслийг баталгаажуулахад ашиглах баталгаажуулалтын арга.';
$string['keytype_keyset'] = 'Түлхүүрийн багцын URL';
$string['keytype_rsa'] = 'RSA түлхүүр';
$string['launch_in_moodle'] = 'Moodle системд хэрэгслийг эхлүүлэх';
$string['launch_in_popup'] = 'Нэмэлт цонхонд хэрэгслийг эхлүүлэх';
$string['launch_url'] = 'Хэрэгслийн URL';
$string['launch_url_help'] = 'Хэрэгслийн URL нь Гадаад хэрэгслийн веб хаягийг заах бөгөөд харуулах нөөц гэх мэт нэмэлт мэдээллийг агуулж болно.
Хэрэв та хэрэгслийн URL-д юу оруулахаа мэдэхгүй байгаа бол хэрэгслийн үйлчилгээ үзүүлэгчээс нэмэлт мэдээлэл авна уу.

Бортогоны URL (хэрэв танд байгаа бол) оруулах боломжтой бөгөөд энэ тохиолдолд маягтын бусад мэдээлэл автоматаар бөглөгдөнө.

Хэрэв та урьдчилан тохируулсан хэрэгслийг сонгосон бол хэрэгслийн URL оруулах шаардлагагүй байж магадгүй. Энэ нь хэрэгслийн холбоосыг тусгай нөөцөд хандахгүйгээр зөвхөн хэрэгслийн үйлчилгээ үзүүлэгчийн системд эхлүүлэхэд ашиглаж байгаа бол тохиолдох магадлалтай.';
$string['launchinpopup'] = 'Эхлүүлэх тохиргоо';
$string['launchinpopup_help'] = 'Эхлүүлэх тохиргоо нь хичээлээс хэрэгслийг эхлүүлэх үед хэрхэн харагдахыг тодорхойлдог. Зарим эхлүүлэх тохиргоо нь нэмэлт цонх шаарддаг бол зарим нь Moodle системийн орчинтой илүү нэгдсэн мэдрэмжийг өгдөг.

* **Өгөгдмөл** - Хэрэгслийн тохиргоонд заасан эхлүүлэх тохиргоог ашиглана.
* **Эмбэд** - Энэ хэрэглүүрийг одоо байгаа Moodle цонхонд бусад үйл ажиллагааны төрлүүдтэй төстэй байдлаар харуулдаг.
* **Блокгүй эмбэд хийх** - Энэ хэрэгсэл нь одоо байгаа Moodle цонхонд гарч ирэх ба хуудасны дээд хэсэгт байрлах удирдлагын мөрөөр удирдах боломжтой.
* **Шинэ цонх** - Хэрэгсэл нь аль болох том хэмжээтэй шинэ цонхонд нээгдэнэ. Веб хөтчөөс хамааран энэ нь шинэ таб эсвэл нэмэлт цонхонд нээгдэнэ. Веб хөтчүүд шинэ цонх нээхээс сэргийлсэн байх магадлалтай.';
$string['launchoptions'] = 'Эхлүүлэх сонголтууд';
$string['lti'] = 'LTI';
$string['lti:addcoursetool'] = 'Хичээлийн-тусгай хэрэгслийн тохиргоо нэмэх';
$string['lti:addinstance'] = 'Шинэ гадаад хэрэгсэл нэмэх';
$string['lti:addmanualinstance'] = 'Гараар тохируулсан хэрэгсэл нэмэх';
$string['lti:addpreconfiguredinstance'] = 'Урьдчилан тохируулсан хэрэгсэл нэмэх';
$string['lti:admin'] = 'Хэрэгслийг эхлүүлсэн үед администратор болох';
$string['lti:grade'] = 'Гадаад хэрэгслээс ирсэн дүнг харах';
$string['lti:manage'] = 'Хэрэгслийг эхлүүлсэн үед зааварлагч болох';
$string['lti:requesttooladd'] = 'Хэрэгслийн хүсэлтийн сайтын хэмжээнд тохируулсан';
$string['lti:view'] = 'Гадаад хэрэгслийн үйл ажиллагааг эхлүүлэх';
$string['lti_administration'] = 'Урьдчилан тохируулсан хэрэгсэл';
$string['lti_errormsg'] = 'Хэрэгсэл дараах алдааны зурвасыг буцаалаа: {$a}';
$string['lti_launch_error'] = 'Гадаад хэрэгслийг эхлүүлэх үед алдаа гарлаа:';
$string['lti_launch_error_tool_request'] = '<p>
Администраторт тохиргоог бүрэн болгох хүсэлт илгээх бол <a href="{$a->admin_request_url}" target="_top">энд дарна уу</a>.
</p>';
$string['lti_launch_error_unsigned_help'] = '<p>Хэрэглэгчийн түлхүүр болон хэрэгслийн үйлчилгээ үзүүлэгчийн хуваалцсан нууцаас үүдэн алдаа гарсан байж магадгүй</p>
<p>Хэрэв танд хэрэглэгчийн түлхүүр, хуваалцсан нууц байгаа бол гадаад хэрэглүүрийн жишээг засахдаа үүнийг оруулж болно (нарийвчилсан тохиргоо харагдаж буй эсэхийг шалгаарай).</p>
<p>Эсвэл <a href="{$a->course_tool_editor}">хичээлийн түвшний хэрэгслийн үйлчилгээ үзүүлэгчийн тохиргоог үүсгэж</a> болно.</p>';
$string['lti_tool_request_added'] = 'Хэрэгслийг тохируулах хүсэлтийг амжилттай илгээлээ. Та тохиргоог дуусгахын тулд администратортай холбогдох шаардлагатай байж магадгүй.';
$string['lti_tool_request_existing'] = 'Хэрэгслийн домэйнд зориулсан хэрэгслийн тохиргоог аль хэдийн илгээсэн байна.';
$string['ltisettings'] = 'LTI тохиргоо';
$string['ltiunknownserviceapicall'] = 'LTI үл мэдэгдэх үйлчилгээний API дуудлага';
$string['ltiversion'] = 'LTI хувилбар';
$string['ltiversion_help'] = 'Зурваст гарын үсэг зурах болон үйлчилгээний хүсэлтэд ашиглаж буй LTI хувилбар: LTI 1.0/1.1 болон LTI 2.0O нь хувийн мэдээллийн аюулгүй байдлын Auth 1.0A-ийг ашигладаг;  LTI 1.3.0 нь JWTs-ийг ашигладаг.';
$string['main_admin'] = 'Ерөнхий тусламж';
$string['main_admin_help'] = 'Гадаад хэрэгслүүд нь Moodle системийн хэрэглэгчдэд алсад байршуулсан сургалтын нөөцтэй харилцах боломжийг олгодог. Тусгай эхлүүлэх протоколоор дамжуулан алсын хэрэгсэл нь эхлүүлсэн хэрэглэгчийн талаарх ерөнхий мэдээлэлд ханддаг. Жишээлбэл, байгууллагын нэр, хичээлийн ID, хэрэглэгчийн ID болон хэрэглэгчийн нэр эсвэл цахим шуудангийн хаяг гэх мэт бусад мэдээлэл.

Энэ хуудсанд жагсаасан хэрэгслүүдийг гурван ангилалд хуваадаг:

* **Идэвхтэй** - Администраторын зөвшөөрч, тохируулсан хэрэгслийн үйлчилгээ үзүүлэгч. Тэдгээрийг энэ сайтын аль ч хичээлээс ашиглаж болно. Хэрэглэгчийн түлхүүр болон хуваалцсан нууцыг оруулснаар энэ сайт болон алсын хэрэгслийн хооронд найдвартай холбоо бий болж, аюулгүй харилцааны сувгийг хангана.
* **Хүлээгдэж байна** - Эдгээр хэрэгслийн үйлчилгээ үзүүлэгчдийг багцаар импортолсон боловч администратор тохируулаагүй байгаа. Багш нар хэрэглэгчийн түлхүүр, хуваалцсан нууцтай эсвэл эсвэл эдгээрийг шаарддаггүй бол эдгээр үйлчилгээ үзүүлэгчийн хэрэгслийг ашиглаж болно.
* **Татгалзсан** - Эдгээр хэрэгслийн үйлчилгээ үзүүлэгчийг администратор сайт дээр ашиглахыг хүсэхгүй байна гэж тэмдэглэсэн. Багш нар хэрэглэгчийн түлхүүр, хуваалцсан нууцтай эсвэл эсвэл эдгээрийг шаарддаггүй бол эдгээр үйлчилгээ үзүүлэгчийн хэрэгслийг ашиглаж болно.';
$string['manage_external_tools'] = 'Хэрэгслүүдийг удирдах';
$string['manage_tool_proxies'] = 'Гадаад хэрэгслийн бүртгэлийг удирдах';
$string['manage_tools'] = 'Урьдчилан тохируулсан хэрэгслүүдийг удирдах';
$string['manuallyaddtype'] = 'Эсвэл та <a href="{$a}">хэрэгслийг гараар тохируулах</a> боломжтой.';
$string['miscellaneous'] = 'Төрөл бүрийн зүйлс';
$string['misconfiguredtools'] = 'Буруу тохируулсан хэрэгслийн жишээ олдлоо';
$string['missingparameterserror'] = 'Энэ хуудсыг буруу тохируулсан байна: "{$a}"';
$string['module_class_type'] = 'Moodle системийн модулийн төрөл';
$string['modulename'] = 'Гадаад хэрэгсэл';
$string['modulename_help'] = 'Гадаад хэрэгслийн үйл ажиллагааны модуль нь суралцагчдад бусад веб сайт дээрх сургалтын нөөц, үйл ажиллагаатай харилцах боломжийг олгодог. Жишээлбэл, гадаад хэрэгсэл нь шинэ үйл ажиллагааны төрөл эсвэл нийтлэгчийн сургалтын материалд хандах боломжийг олгодог.

Гадаад хэрэгслийн үйл ажиллагаа үүсгэхийн тулд LTI (Сургалтын хэрэгслүүдийн харилцан ажиллах чадвар)-ыг дэмждэг хэрэгслийн үйлчилгээ үзүүлэгч шаардлагатай. Багш нь гадаад хэрэгслийн үйл ажиллагаа үүсгэх эсвэл сайтын администраторын тохируулсан хэрэгслийг ашиглах боломжтой.

Гадаад хэрэгслийн үйл ажиллагаа нь URL нөөцөөс дараах зүйлсээр ялгаатай:

* Гадаад хэрэгслүүд нь хам сэдвийг мэддэг. Өөрөөр хэлбэл тухайн хэрэгслийг эхлүүлсэн хэрэглэгчийн мэдээлэлд (байгууллага, хичээл, нэр гэх мэт мэдээлэлд) хандах боломжтой.
* Гадаад хэрэгслүүд нь үйл ажиллагааны жишээтэй холбоотой үнэлгээг унших, шинэчлэх, устгахыг дэмждэг
* Гадаад хэрэгслийн тохиргоо нь таны сайт болон хэрэгслийн үйлчилгээ үзүүлэгчийн хооронд итгэлцлийн харилцааг бий болгож, тэдгээрийн хооронд аюулгүй харилцах боломжийг олгодог';
$string['modulename_link'] = 'mod/lti/view';
$string['modulenameplural'] = 'Гадаад хэрэгсэл';
$string['modulenamepluralformatted'] = 'LTI Жишээ';
$string['name'] = 'Нэр';
$string['never'] = 'Хэзээ ч';
$string['new_window'] = 'Шинэ цонх';
$string['no_lti_configured'] = 'Тохируулсан идэвхтэй гадаад хэрэгсэл байхгүй байна.';
$string['no_lti_pending'] = 'Хүлээж буй гадаад хэрэгсэл байхгүй байна.';
$string['no_lti_rejected'] = 'Татгалзсан гадаад хэрэгсэл байхгүй байна.';
$string['no_lti_tools'] = 'Тохиргоо хийсэн гадаад хэрэгсэл байхгүй байна.';
$string['no_tp_accepted'] = 'Зөвшөөрсөн гадаад хэрэгслийн бүртгэл байхгүй байна.';
$string['no_tp_cancelled'] = 'Цуцалсан гадаад хэрэгслийн бүртгэл байхгүй байна.';
$string['no_tp_configured'] = 'Тохиргоо хийсэн бүртгэлгүй гадаад хэрэгслийн бүртгэл байхгүй байна.';
$string['no_tp_pending'] = 'Хүлээж буй гадаад хэрэгслийн бүртгэл байхгүй байна.';
$string['no_tp_rejected'] = 'Татгалзсан гадаад хэрэгслийн бүртгэл байхгүй байна.';
$string['noattempts'] = 'Энэ хэрэгслийн жишээнд ородлого хийгээгүй байна';
$string['noltis'] = 'Гадаад хэрэгслийн жишээ олдсонгүй';
$string['noprofileservice'] = 'Хувийн мэдээллийн үйлчилгээ олдсонгүй';
$string['noservers'] = 'Сервер олдсонгүй';
$string['notypes'] = 'Moodle системд тохируулсан LTI хэрэгсэл одоогоор байхгүй байна. Суулгах холбоос дээр дарж хэрэгсэл нэмнэ.';
$string['noviewusers'] = 'Энэ хэрэгслийг ашиглах эрхтэй хэрэглэгч олдсонгүй';
$string['oauthsecurity'] = 'LTI 1.0/1.1';
$string['opensslconfiginvalid'] = 'LTI 1.3 нь веб серверт хүчинтэй openssl.cnf-г тохируулан, бэлэн байлгахыг шаарддаг. Энэ сайтын openssl-г тохируулж идэвхжүүлэхийн тулд сайтын администратортай холбогдоно уу.';
$string['optionalsettings'] = 'Нэмэлт тохиргоо';
$string['organization'] = 'Байгууллагын дэлгэрэнгүй';
$string['organizationdescr'] = 'Байгууллагын тайлбар';
$string['organizationid_default'] = 'Байгууллагын өгөгдмөл ID';
$string['organizationid_default_help'] = 'Байгууллагын ID-д ашиглах өгөгдмөл утга. Сайтын ID нь Moodle системийн суулгацыг тодорхойлдог.';
$string['organizationidguid'] = 'Байгууллагын ID';
$string['organizationidguid_help'] = 'Уг хэрэгсэлд Платформын Жишээний GUID болгон дамжуулсан Moodle системийн жишээний давтагдахгүй танигч.

Хоосон орхивол өгөгдмөл утгыг ашиглана.

Энэ талбарыг хоосон үлдээсэн тохиолдолд өгөгдмөл утгыг ашиглах болно.';
$string['organizationurl'] = 'Байгууллагын URL';
$string['organizationurl_help'] = 'Энэ Moodle системийн жишээний үндсэн URL.

Энэ талбарыг хоосон үлдээсэн тохиолдолд сайтын тохиргоонд үндэслэн өгөгдмөл утгыг ашиглах болно.';
$string['pagesize'] = 'Нэг хуудсанд харуулах мэдүүлэг';
$string['parameter'] = 'Хэрэгслийн параметрүүд';
$string['parameter_help'] = 'Хэрэгслийн параметрүүд нь зөвшөөрөгдсөн хэрэгслийн проксид хэрэгслийн үйлчилгээ үзүүлэгчээр дамжуулахыг хүссэн тохиргоо юм.';
$string['password'] = 'Хуваалцсан нууц';
$string['password_admin'] = 'Хуваалцсан нууц';
$string['password_admin_help'] = 'Хуваалцсан нууц гэдэг нь уг хэрэгсэлд хандахад ашигладаг нууц үг. Үүнийг хэрэгслийн үйлчилгээ үзүүлэгчийн хэрэглэгчийн түлхүүртэй хамт өгөх ёстой.

Moodle системээс аюулгүй холбоо шаарддаггүй, нэмэлт үйлчилгээ үзүүлдэггүй (дүнгийн тайлан гэх мэт) хэрэгслүүд нь хуваалцсан нууцыг шаарддаггүй.';
$string['password_help'] = 'Тохиргооны үйл явцад хуваалцсан нууцаар хангадаг тул урьдчилан тохируулсан хэрэгслүүдийн хувьд хуваалцсан нууцыг оруулах шаардлагагүй.

Энэ талбарыг тохируулаагүй байгаа хэрэгслийн үйлчилгээ үзүүлэгчийн холбоосыг үүсгэсэн тохиолдолд энэ талбарт хуваалцсан нууцыг оруулах ёстой.
Хэрэв хэрэгслийн үйлчилгээ үзүүлэгчийг энэ хичээлд нэгээс олон удаа ашиглах бол хичээлийн хэрэгслийн тохиргоог нэмэх нь зүйтэй.

Хуваалцсан нууц гэдэг нь уг хэрэгсэлд хандахад ашигладаг нууц үг. Үүнийг хэрэгслийн үйлчилгээ үзүүлэгчийн хэрэглэгчийн түлхүүртэй хамт өгөх ёстой.

Moodle системээс аюулгүй холбоо шаарддаггүй, нэмэлт үйлчилгээ үзүүлдэггүй (дүнгийн тайлан гэх мэт) хэрэгслүүд нь хуваалцсан нууцыг шаарддаггүй.';
$string['pending'] = 'Хүлээж буй';
$string['pluginadministration'] = 'Гадаад хэрэгслийн удирдлага';
$string['pluginname'] = 'Гадаад хэрэгсэл';
$string['preferheight'] = 'Сонгосон өндөр';
$string['preferwidget'] = 'Эхлүүлэх виджэт сонгох';
$string['preferwidth'] = 'Сонгосон өргөн';
$string['press_to_submit'] = 'Энэ үйл ажиллагааг эхлүүлэхийг дарна уу';
$string['privacy'] = 'Хувийн нууц';
$string['privacy:metadata:coursefullname'] = '...-аас LTI Үйлчлүүлэгч рүү хандаж буй хичээлийн хэрэглэгчийн бүтэн нэр:';
$string['privacy:metadata:courseid'] = '...-аас LTI Үйлчлүүлэгч рүү хандаж буй хичээлийн хэрэглэгчийн ID:';
$string['privacy:metadata:courseidnumber'] = '...-аас LTI Үйлчлүүлэгч рүү хандаж буй хичээлийн хэрэглэгчийн ID дугаар:';
$string['privacy:metadata:courseshortname'] = '...-аас LTI Үйлчлүүлэгч рүү хандаж буй хичээлийн хэрэглэгчийн богино нэр:';
$string['privacy:metadata:createdby'] = 'Бичлэг үүсгэсэн хэрэглэгч';
$string['privacy:metadata:email'] = 'LTI Үйлчлүүлэгч рүү хандаж буй хичээлийн хэрэглэгчийн цахим шуудангийн хаяг';
$string['privacy:metadata:externalpurpose'] = 'LTI Үйлчлүүлэгч нь LTI Хэрэгслийн Үйлчилгээ Үзүүлэгчийг хэрэглэгчийн мэдээлэл болон хам сэдвээр хангадаг.';
$string['privacy:metadata:firstname'] = 'LTI Үйлчлүүлэгчид хандсан хэрэглэгчийн нэр';
$string['privacy:metadata:fullname'] = 'LTI Үйлчлүүлэгчид хандсан хэрэглэгчийн бүтэн нэр';
$string['privacy:metadata:lastname'] = 'LTI Үйлчлүүлэгчид хандсан хэрэглэгчийн овог';
$string['privacy:metadata:lti_submission'] = 'LTI мэдүүлэг';
$string['privacy:metadata:lti_submission:datesubmitted'] = 'Хэзээ мэдүүлснийг илтгэх хугацааны-тамга';
$string['privacy:metadata:lti_submission:dateupdated'] = 'Мэдүүлгийг хэзээ өөрчилснийг илтгэх хугацааны-тамга';
$string['privacy:metadata:lti_submission:gradepercent'] = 'Хувиар илэрхийлсэн хэрэглэгчийн дүн';
$string['privacy:metadata:lti_submission:originalgrade'] = 'Хэрэглэгчийн үндсэн дүн';
$string['privacy:metadata:lti_submission:userid'] = 'LTI  үйл ажиллагаанд мэдүүлсэн хэрэглэгчийн ID';
$string['privacy:metadata:lti_tool_proxies'] = 'LTI прокси';
$string['privacy:metadata:lti_tool_proxies:name'] = 'LTI проксигийн нэр';
$string['privacy:metadata:lti_types'] = 'LTI төрөл';
$string['privacy:metadata:lti_types:name'] = 'LTI төрлийн нэр';
$string['privacy:metadata:role'] = 'LTI Хэрэглэгчид хандах хэрэглэгчийн хичээл дэх үүрэг';
$string['privacy:metadata:timecreated'] = 'Бичлэгийг үүсгэсэн цаг';
$string['privacy:metadata:timemodified'] = 'Бичлэгийг өөрчилсөн цаг';
$string['privacy:metadata:userid'] = 'LTI Хэрэглэгчид хандах хэрэглэгчийн ID';
$string['privacy:metadata:useridnumber'] = 'LTI Хэрэглэгчид хандах хэрэглэгчийн ID дугаар';
$string['privacy:metadata:username'] = 'LTI Хэрэглэгчид хандах хэрэглэгчийн хэрэглэгчийн нэр';
$string['publickey'] = 'Нийтийн түлхүүр';
$string['publickey_help'] = 'Ирсэн зурвас болон үйлчилгээний хүсэлтийг (гарын үсгийг) баталгаажуулах боломжийг олгох нийтийн түлхүүр (PEM форматаар).';
$string['publickeyset'] = 'Нийтийн түлхүүрийн багц';
$string['publickeyset_help'] = 'Ирсэн зурвас болон үйлчилгээний хүсэлтийг (гарын үсгийг) баталгаажуулах нийтийн түлхүүрийг агуулж буй нийтийн түлхүүрийн багц.';
$string['quickgrade'] = 'Түргэвчилсэн үнэлгээг зөвшөөрөх';
$string['quickgrade_help'] = 'Идэвхжүүлсэн тохиолдолд нэг хуудсанд олон хэрэгслийг үнэлэх боломжтой болно. Дүнгүүд болон сэтгэгдлийг оруулсны дараа "Миний бүх хариуг хадгалах" дээр дарж бүх өөрчлөлтийг хадгална.';
$string['redirect'] = 'Таныг хэдхэн секундийн дотор дахин чиглүүлэх болно. Хэрэв дахин чиглүүлэхгүй байвал товчлуурыг дарна уу.';
$string['redirectionuris'] = 'Дахин чиглүүлэх URI';
$string['redirectionuris_help'] = 'Зөвшөөрлийн хүсэлт гаргахдаа хэрэгслийн ашигладаг URI-н жагсаалт (мөр бүрд нэг URI). Хэрэгсэл рүү зурвас амжилттай илгээхийн тулд дор хаяж нэг URI бүртгүүлсэн байх ёстой.';
$string['register'] = 'Бүртгүүлэх';
$string['register_warning'] = 'Бүртгэлийн хуудсыг нээхэд удаж байна. Хэрэв нээгдэхгүй удвал тохируулахдаа URL-ийг зөв оруулсан эсэхээ шалгана уу. Хэрэв Moodle систем нь https ашиглаж байгаа бол таны тохируулж буй хэрэгсэл https-г дэмжих эсэх болон та https URL-д ашиглаж байгаа эсэхээ шалгаарай.';
$string['registertype'] = 'Шинэ гадаад хэрэгслийн бүртгэлийг тохируулах';
$string['registration_options'] = 'Бүртгэлийн тохиргоо';
$string['registrationname'] = 'Хэрэгслийн үйлчилгээ үзүүлэгчийн нэр';
$string['registrationname_help'] = 'Бүртгэж байгаа хэрэгслийн үйлчилгээ үзүүлэгчийн нэрийг оруулна уу.';
$string['registrationurl'] = 'Бүртгэлийн URL';
$string['registrationurl_help'] = 'Бүртгэлийн URL нь хэрэгслийн үйлчилгээ үзүүлэгчийн бүртгүүлэх хүсэлт илгээх байршил байна.';
$string['reject'] = 'Татгалзах';
$string['rejected'] = 'Татгалзсан';
$string['resource'] = 'Нөөц';
$string['resourcekey'] = 'Хэрэглэгчийн түлхүүр';
$string['resourcekey_admin'] = 'Хэрэглэгчийн түлхүүр';
$string['resourcekey_admin_help'] = 'Хэрэглэгчийн түлхүүрийг тухайн хэрэгсэлд хандах эрхийг баталгаажуулахад ашигладаг хэрэглэгчийн нэр гэж ойлгож болно.
Үүнийг хэрэгслийг эхлүүлэх Moodle сайтыг дахин давтагдахгүйгээр тодорхойлохын тулд хэрэгслийн үйлчилгээ үзүүлэгч ашиглах боломжтой.

Хэрэгслийн үйлчилгээ үзүүлэгч хэрэглэгчийн түлхүүрээр хангадаг. Хэрэгслийн үйлчилгээ үзүүлэгчээс хэрэглэгчийн түлхүүрийг авахдаа автоматжуулсан үйл явцыг ашиглаж авч болох бол зарим тохиолдолд хэрэгслийн үйлчилгээ үзүүлэгчтэй харилцах шаардлагатай байдаг.

Moodle системээс аюулгүй холболт шаарддаггүй, нэмэлт үйлчилгээ үзүүлдэггүй (дүнгийн тайлан гэх мэт) хэрэгслүүдэд нөөцийн түлхүүр шаардлагагүй байж болно.';
$string['resourcekey_help'] = 'Урьдчилан тохируулсан хэрэгслүүдийг тохируулах үйл явцад хэрэглэгчийн түлхүүрээр хангасан байдаг тул энд нөөцийн түлхүүр оруулах шаардлагагүй.

Тохируулаагүй байгаа хэрэгслийн үйлчилгээ үзүүлэгчтэй холбоос үүсгэх тохиолдолд энэ талбарт утгыг оруулах ёстой.
Хэрэв энэ хичээлд хэрэгслийг дахин дахин ашиглах бол хичээлийн хэрэгслийн тохиргоог нэмэх нь зүйтэй.

Хэрэглэгчийн түлхүүрийг тухайн хэрэгсэлд хандах эрхийг баталгаажуулахад ашигладаг хэрэглэгчийн нэр гэж ойлгож болно.
Үүнийг хэрэгслийг эхлүүлэх Moodle сайтыг дахин давтагдахгүйгээр тодорхойлохын тулд хэрэгслийн үйлчилгээ үзүүлэгч ашиглах боломжтой.

Хэрэгслийн үйлчилгээ үзүүлэгч хэрэглэгчийн түлхүүрээр хангадаг. Хэрэгслийн үйлчилгээ үзүүлэгчээс хэрэглэгчийн түлхүүрийг авахдаа автоматжуулсан үйл явцыг ашиглаж авч болох бол зарим тохиолдолд хэрэгслийн үйлчилгээ үзүүлэгчтэй харилцах шаардлагатай байдаг.

Moodle системээс аюулгүй холболт шаарддаггүй, нэмэлт үйлчилгээ үзүүлдэггүй (дүнгийн тайлан гэх мэт) хэрэгслүүдэд нөөцийн түлхүүр шаардлагагүй байж болно.';
$string['resourceurl'] = 'Нөөцийн URL';
$string['return_to_course'] = 'Хичээл рүү буцах бол <a href="{$a->link}" target="_top">энд</a> дарна уу.';
$string['saveallfeedback'] = 'Миний бүх хариуг хадгалах';
$string['search:activity'] = 'Гадаа хэрэгсэл - үйл ажиллагааны мэдээлэл';
$string['secure_icon_url'] = 'Хамгаалалтын дүрст зурган URL';
$string['secure_icon_url_help'] = 'Дүрст зурган URL-тай төстэй боловч сайт руу SSL ашиглан аюулгүй хандалт хийхэд ашигладаг. Энэ талбар нь хөтчийг аюултай зургийн талаар анхааруулга харуулахаас сэргийлэх зорилготой юм.';
$string['secure_launch_url'] = 'Аюулгүй хэрэгслийн URL';
$string['secure_launch_url_help'] = 'Хэрэгслийн URL-тай төстэй боловч өндөр хамгаалалт  шаардлагатай үед ашигладаг. Хэрэв Moodle сайтад SSL ашиглан хандах эсвэл хэрэгслийн тохиргоог үргэлж SSL ашиглан ажиллуулж байхаар тохируулсан бол Moodle систем аюулгүй хэрэгслийн URL-ийг ашиглана.

Хэрэгслийн URL-ийг SSL ашиглан хүчээр эхлүүлэхийн тулд https хаягаар тохируулах бөгөөд энэ талбарыг хоосон орхиж болно.';
$string['selectcontent'] = 'Агуулгыг сонгох';
$string['send'] = 'Илгээх';
$string['services'] = 'Үйлчилгээ';
$string['services_help'] = 'Хэрэгслийн үйлчилгээ үзүүлэгчид санал болгохыг хүссэн үйлчилгээгээ сонгоно уу. Нэгээс олон үйлчилгээ сонгох боломжтой.';
$string['setupoptions'] = 'Тохируулах сонголтууд';
$string['share_email'] = 'Эхлүүлэгчийн цахим шуудангийн хаягийг хэрэгсэлтэй хуваалцах';
$string['share_email_admin'] = 'Эхлүүлэгчийн цахим шуудангийн хаягийг хэрэгсэлтэй хуваалцах';
$string['share_email_admin_help'] = 'Хэрэгслийг эхлүүлж буй хэрэглэгчийн цахим шуудангийн хаягийг хэрэгслийн үйлчилгээ үзүүлэгчтэй хуваалцах эсэхийг зааж өгнө үү.
Хэрэгслийн үйлчилгээ үзүүлэгч нь UI дээр ижил нэртэй хэрэглэгчдийг ялгахын тулд эсвэл хэрэглүүр дээрх хийсэн үйлдлүүдэд хэрэглэгчид цахим шуудан илгээх үед хэрэгслийг эхлүүлсэн хэрэглэгчийн цахим шуудангийн хаягийг хэрэглэгдэг.';
$string['share_email_help'] = 'Хэрэгслийг эхлүүлж буй хэрэглэгчийн цахим шуудангийн хаягийг хэрэгслийн үйлчилгээ үзүүлэгчтэй хуваалцах эсэхийг зааж өгнө үү.

Хэрэгслийн үйлчилгээ үзүүлэгч нь ижил нэртэй хэрэглэгчдийг ялгахын тулд эсвэл хэрэглүүр дээрх хийсэн үйлдлүүдэд хэрэглэгчид цахим шуудан илгээх үед хэрэгслийг эхлүүлсэн хэрэглэгчийн цахим шуудангийн хаягийг хэрэглэгдэг.

Энэ тохиргоо нь хэрэгслийн тохиргоог хүчингүй болгохыг санаарай.';
$string['share_name'] = 'Эхлүүлэгчийн нэрийг хэрэгсэлтэй хуваалцах';
$string['share_name_admin'] = 'Эхлүүлэгчийн нэрийг хэрэгсэлтэй хуваалцах';
$string['share_name_admin_help'] = 'Хэрэгслийг эхлүүлж буй хэрэглэгчийн бүтэн нэрийг  хэрэгслийн үйлчилгээ үзүүлэгчтэй хуваалцах эсэхийг зааж өгнө үү.
Хэрэгслийн үйлчилгээ үзүүлэгч нь хэрэглүүрийн доторх ач холбогдолтой чухал мэдээллийг харуулахын тулд эхлүүлэгчийн нэрийг хэрэглэдэг.';
$string['share_name_help'] = 'Хэрэгслийг эхлүүлж буй хэрэглэгчийн бүтэн нэрийг  хэрэгслийн үйлчилгээ үзүүлэгчтэй хуваалцах эсэхийг зааж өгнө үү.

Хэрэгслийн үйлчилгээ үзүүлэгч нь хэрэглүүрийн доторх ач холбогдолтой чухал мэдээллийг харуулахын тулд эхлүүлэгчийн нэрийг хэрэглэдэг.

Энэ тохиргоо нь хэрэгслийн тохиргоог хүчингүй болгохыг санаарай.';
$string['share_roster'] = 'Энэ хичээлд бүртгэлтэй хэрэглэгчдийн жагсаалтад хандахыг хэрэгсэлд зөвшөөрөх';
$string['share_roster_admin'] = 'Хэрэгсэл нь хичээлд бүртгэлтэй хэрэглэгчдийн жагсаалтад хандах боломжтой';
$string['share_roster_admin_help'] = 'Уг хэрэгсэл нь энэ хэрэгслийг эхлүүлсэн хичээлүүдэд бүртгүүлсэн хэрэглэгчдийн жагсаалтад хандах боломжтой эсэхийг зааж өгнө үү.';
$string['share_roster_help'] = 'Уг хэрэгсэл нь энэ хичээлд бүртгүүлсэн хэрэглэгчдийн жагсаалтад хандах боломжтой эсэхийг зааж өгнө үү.

Энэ тохиргоо нь хэрэгслийн тохиргоог хүчингүй болгохыг санаарай.';
$string['show_in_course_activity_chooser'] = 'Үйл ажиллагааны сонгогч дотор урьдчилан тохируулсан хэрэгсэл болгон харуулах';
$string['show_in_course_lti1'] = 'Хэрэгслийн тохиргооны хэрэглээ';
$string['show_in_course_lti1_help'] = 'Энэ хэрэгслийг хичээлд нэмэх үйл ажиллагааг сонгогч дотор харуулах боломжтой. Эсвэл хичээлд гадаад хэрэгсэл нэмэх үед урьдчилан тохируулсан хэрэгслийн нээгдэх цэсэд харуулж болно. Өөр нэг сонголт бол хичээлийн хэрэгсэлд гадаад хэрэгсэл нэмэх үед URL зөв хаягийг оруулсан тохиолдолд л хэрэглүүрийн тохиргоог ашиглаж болно.';
$string['show_in_course_lti2'] = 'Хэрэгслийн тохиргооны хэрэглээ';
$string['show_in_course_lti2_help'] = 'Энэ хэрэгслийг хичээлд нэмэх үйл ажиллагааг сонгогч дотор эсвэл хичээлд гадаад хэрэгсэл нэмэх үед урьдчилан тохируулсан хэрэгслийн нээгдэх цэсэд  харуулах боломжтой.';
$string['show_in_course_no'] = 'Харуулахгүй; тохирох хэрэгслийн URL-г оруулсан үед л хэрэглэнэ';
$string['show_in_course_preconfigured'] = 'Шинээр нэмсэн гадаад хэрэгслийг урьдчилан тохируулсан хэрэгсэл болгон харуулах';
$string['sitehost'] = 'Сайтын хостын нэр';
$string['siteid'] = 'Сайтын ID';
$string['size'] = 'Хэмжээний параметрүүд';
$string['submission'] = 'Мэдүүлэг';
$string['submissions'] = 'Мэдүүлэг';
$string['submissionsfor'] = '{$a}-ийн мэдүүлэг';
$string['subplugintype_ltiresource'] = 'LTI үйлчилгээний нөөц';
$string['subplugintype_ltiresource_plural'] = 'LTI үйлчилгээний нөөц';
$string['subplugintype_ltiservice'] = 'LTI үйлчилгээ';
$string['subplugintype_ltiservice_plural'] = 'LTI үйлчилгээ';
$string['subplugintype_ltisource'] = 'LTI нөөц';
$string['subplugintype_ltisource_plural'] = 'LTI нөөц';
$string['successfullycreatedtooltype'] = 'Шинэ хэрэгслийг амжилттай үүсгэлээ!';
$string['successfullyfetchedtoolconfigurationfromcontent'] = 'Сонгосон агуулгаас хэрэгслийн тохиргоог амжилттай татаж авлаа.';
$string['toggle_debug_data'] = 'Алдаа шалгах өгөгдлийг сэлгэх';
$string['tool_config_not_found'] = 'Энэ URL-д зориулсан хэрэгслийн тохиргоо олдсонгүй.';
$string['tool_settings'] = 'Хэрэгслийн тохиргоо';
$string['tooldescription'] = 'Хэрэгслийн тайлбар';
$string['tooldescription_help'] = 'Хэрэгслийн тайлбарыг үйл ажиллагааны жагсаалт дотор харуулдаг.

Энэ мэдээлэлд тухайн хэрэгсэл ямар зориулалттай, юу хийдэг талаар болон багш мэдэх хэрэгтэй бусад нэмэлт мэдээллийг оруулна.';
$string['tooldetailsaccesstokenurl'] = 'Хандалтын токений URL';
$string['tooldetailsauthrequesturl'] = 'Баталгаажуулах хүсэлтийн URL';
$string['tooldetailsclientid'] = 'Клиентийн ID';
$string['tooldetailsdeploymentid'] = 'Байршуулалтын ID';
$string['tooldetailsmailtosubject'] = 'LTI хэрэгслийг тохиргоо';
$string['tooldetailsmodalemail'] = 'Цахим шуудан';
$string['tooldetailsmodallink'] = 'Тохиргооны дэлгэрэнгүйг харах';
$string['tooldetailsmodaltitle'] = 'Хэрэгслийн тохиргооны дэлгэрэнгүй';
$string['tooldetailsplatformid'] = 'Платформын ID';
$string['tooldetailspublickeyseturl'] = 'Нийтийн түлхүүрийн багцын URL';
$string['toolisbeingused'] = 'Энэ хэрэгслийг {$a} удаа ашиглаж байна';
$string['toolisnotbeingused'] = 'Энэ хэрэгслийг хараахан ашиглаагүй байна';
$string['toolproxy'] = 'Гадаад хэрэгслийн бүртгэл';
$string['toolproxy_help'] = 'Гадаад хэрэгслийн бүртгэл нь Moodle сайтын администраторт LTI 2.0-ийг дэмждэг хэрэгслийн үйлчилгээ үзүүлэгчээс авсан хэрэгслийн проксигоос гадаад хэрэгслүүдийг тохируулах боломжийг олгодог. Үйл явцыг эхлүүлэхэд хэрэгслийн үйлчилгээ үзүүлэгчээс өгсөн бүртгэлийн URL байхад л хангалттай. Шинэ бүртгэлийг тохируулах үед хэрэгслийн үйлчилгээ үзүүлэгчид санал болгож буй чадвар, үйлчилгээг сонгоно.

Энэ хуудсан хэрэгслийн бүртгэлийг дөрвөн ангилалд хуваан жагсаасан:

* **Тохируулсан** - Эдгээр хэрэгслийн бүртгэлийг тохируулсан боловч бүртгэх үйл явц хараахан эхлээгүй.
* **Хүлээгдэж байна** - Эдгээр хэрэгслийн бүртгэлийг бүртгэх үйл явц эхэлсэн боловч бүрэн дуусаагүй байна. Тохиргоог нээж, хадгалаад "Тохируулсан" ангилал руу буцаана уу.
* **Зөвшөөрсөн** - Эдгээр хэрэгслийн бүртгэлийг зөвшөөрсөн; хэрэгслийн проксид тодорхойлсон нөөцүүд нь урьдчилан тохируулсан хэрэгслийн хуудсан дээр "Хүлээж байна" гэсэн анхны төлөвтэй гарч ирнэ.
* **Татгалзсан** - Эдгээр хэрэгслийн бүртгэлийг бүртгэх үед татгалзсан. Бүртгэлийг дахин эхлүүлэх боломжтой "Тохируулсан" ангилал руу буцаан шилжүүлэхийн тулд тохиргоог нээж хадгална уу.';
$string['toolproxyregistration'] = 'Гадаад хэрэгслийн бүртгэл';
$string['toolregistration'] = 'Гадаад хэрэгслийн бүртгэл';
$string['toolsetup'] = 'Гадаад хэрэгслийн тохируулга';
$string['tooltypeadded'] = 'Урьдчилан тохируулсан хэрэгслийг нэмсэн';
$string['tooltypedeleted'] = 'Урьдчилан тохируулсан хэрэгслийг устгасан';
$string['tooltypenotdeleted'] = 'Урьдчилан тохируулсан хэрэгслийг устгаж чадсангүй';
$string['tooltypes'] = 'Хэрэгсэл';
$string['tooltypeupdated'] = 'Урьдчилан тохируулсан хэрэгслийг шинэчилсэн';
$string['toolurl'] = 'Хэрэгслийн URL';
$string['toolurl_contentitemselectionrequest'] = 'Агуулга Сонгох URL';
$string['toolurl_contentitemselectionrequest_help'] = 'Хэрэгслийн үйлчилгээ үзүүлэгчээс агуулга сонгох хуудсыг нээхэд Агуулга Сонгох URL-ийг ашигладаг. Хоосон орхисон тохиолдолд Хэрэгслийн URL-ийг ашиглана.';
$string['toolurl_help'] = 'Хэрэгслийн URL нь зөвөөр тохируулсан хэрэгсэлтэй тохирч байгаа эсэхийг харьцуулахад хэрэгслийн URL-ийг ашигладаг. URL нь http(s) эхэлж болно.

Нэмж дурдахад, хэрэгслийн URL-ийг гадаад хэрэгслийн жишээнд тодорхойлоогүй бол үндсэн URL-ийг хэрэгслийн URL болгон ашигладаг.

Жишээлбэл, *tool.com*-ийн үндсэн URL нь дараах хэлбэртэй байна:

* tool.com
* tool.com/quizzes
* tool.com/quizzes/quiz.php?id=10
* www.tool.com/quizzes

*www.tool.com/quizzes*-ийн үндсэн URL нь дараах хэлбэртэй байна:

* www.tool.com/quizzes
* tool.com/quizzes
* tool.com/quizzes/take.php?id=10

*quiz.tool.com*ийн үндсэн URL нь дараах хэлбэртэй байна:

* quiz.tool.com
* quiz.tool.com/take.php?id=10

Хэрэв хоёр өөр хэрэгслийн тохиргоо нь нэг домэйнтэй бол хамгийн сайн тохирохыг ашиглана.

Хэрэв танд бортогоны URL байгаа бол оруулах боломжтой бөгөөд энэ тохиолдолд хэрэгслийн дэлгэрэнгүй мэдээлэл автоматаар бөглөгдөх болно.';
$string['toolurlplaceholder'] = 'Хэрэгслийн URL...';
$string['typename'] = 'Хэрэгслийн нэр';
$string['typename_help'] = 'Moodle системээс хэрэгслийн үйлчилгээ үзүүлэгчийг танихад хэрэгслийн нэрийг ашигладаг. Хичээлд гадаад хэрэгсэл нэмэх үед хэрэгслийн оруулсан нэр багшид харагдах болно.';
$string['types'] = 'Төрөл';
$string['unabletocreatetooltype'] = 'Хэрэгсэл үүсгэх боломжгүй';
$string['unabletofindtooltype'] = '{$a->id}-д зориулсан хэрэгслийг хайх боломжгүй';
$string['unknownstate'] = 'Үл таних төлөв';
$string['update'] = 'Шинэчлэх';
$string['useraccountinformation'] = 'Хэрэглэгчийн бүртгэлийн мэдээлэл';
$string['userpersonalinformation'] = 'Хэрэглэгчийн хувийн мэдээлэл';
$string['using_tool_cartridge'] = 'Хэрэгслийн бортого ашиглах';
$string['using_tool_configuration'] = 'Хэрэгслийн тохируулга ашиглах';
$string['validurl'] = 'Хүчинтэй URL нь http(s):// гэж эхлэх ёстой';
$string['viewsubmissions'] = 'Мэдүүлэг болон дүгнэх дэлгэцийг харах';
