<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_brickfield', language 'ar', version '4.4'.
 *
 * @package     tool_brickfield
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessibility'] = 'إمكانية الوصول';
$string['accessibilitydisabled'] = 'أدوات Brickfield لإمكانية الوصول غير مُمَكَّنة في هذا الموقع. تواصل مع مشرف موقعك لتمكينها';
$string['accessibilityreport'] = 'أدوات إمكانية الوصول';
$string['accessibilitytool'] = 'أداة Brickfield لإمكانية الوصول';
$string['accessibilitytools'] = 'أدوات Brickfield لإمكانية الوصول';
$string['activate'] = 'تفعيل';
$string['activated'] = 'الإضافة مفعلة وجاهزة للعمل.';
$string['activationform'] = 'تسجيل Brickfield';
$string['activationheader'] = 'تفعيل Brickfield';
$string['activationinfo'] = '<p>من أجل استعمال هذه الإضافة، ينبغي عليك تقديم مفاتيح صحيحة لهذا الموقع في هذا النموذج.</p><p>يرجى <a href="{$a}" data-action="send_info" target="_blank">التسجيل في بوابة Brickfield (يُفتح بنافذة جديدة)</a> لتلقي تلك المفاتيح إن لم تكن لديك مسبقًا.</p><p>بمجرد التفعيل، سيتم التحقق من مفاتيحك بواسطة مهام مجدولة في مشغل الوظائف الدورية.</p>';
$string['activityresults:pluginname'] = 'تقرير إنهيار النشاط لأداة إمكانية الوصول';
$string['activityresults:toolname'] = 'ملخص إنهيار النشاط';
$string['activityresults:toolshortname'] = 'إنهيار النشاط';
$string['advanced:pluginname'] = 'تقرير أداة إمكانية الوصول المتقدم';
$string['advanced:toolname'] = 'ملخص متقدم';
$string['advanced:toolshortname'] = 'متقدم';
$string['allcourses'] = 'كل المقررات الدراسية التي تمت مراجعتها ({$a})';
$string['allcoursescat'] = 'كل المقررات الدراسية التي تمت مراجعتها في التصنيف {$a->catname} ({$a->count})';
$string['analysis:byrequest'] = 'حسب الطلب';
$string['analysis:disabled'] = 'مُعطَّل';
$string['analysistype'] = 'تمكين طلبات التحليل';
$string['analysistype_desc'] = 'السماح بطلبات تحليل إمكانية الوصول إلى المحتوى';
$string['analysistypedisabled'] = 'تحليل المحتوى مُعطَّل';
$string['bannercontentone'] = 'تمتلك أدوات إمكانية الوصول للمؤسسة طيف كامل من المزايا لمساعدة مؤسستك في تحسين إمكانية الوصول إلى مساقاتك. <a href="{$a}">تواصل مع مختبرات Brickfield التعليمية
</a> لتحجز لك عرض تجريبي مجاني للمزايا المتقدمة.';
$string['bannercontenttwo'] = 'بناء منصة تعليم فاعلة وشاملة عبر العثور على المحتوى الذي لا يتوافق مع الإرشادات، ومعالجة المشاكل والتدقيق المستقبلي في محتوى المقررات الدراسية مع ملفات إمكانية الوصول، المحرر والمزايا المحسنة.';
$string['bannerheadingone'] = 'الترقية إلى أدوات إمكانية الوصول للمؤسسة';
$string['batch'] = 'حد الحزمة';
$string['brickfield'] = 'أدوات Brickfield';
$string['brickfield:viewcoursetools'] = 'معاينة التقارير حسب المقررات الدراسية';
$string['brickfield:viewsystemtools'] = 'معاينة التقارير لكل المقررات الدراسية';
$string['bulkprocesscaches'] = 'معالجة التخبئة بالجملة';
$string['bulkprocesscourses'] = 'التحقق من معالجة التخبئة بالجملة لإمكانية الوصول';
$string['buttonone'] = 'الحصول إلى عرض تجريبي مجاني';
$string['cachepending'] = 'يتم تجميع بيانات الملخص';
$string['checkdesc:alinksdontopennewwindow'] = 'الروابط التي تُفتح بنافذة جديدة ينبغي أن تنبه المستخدمين بشكل مسبق.';
$string['checkdesc:amustcontaintext'] = 'ينبغي أن يتضمن الرابط نصًا ليكون مفهومًا.';
$string['checkdesc:areadontopennewwindow'] = 'المناطق، مستعملة في تعيين مواضع الصور وتُفتح بنافذة جديدة، ينبغي لها تنبيه المستخدمين مسبقًا.';
$string['checkdesc:areahasaltvalue'] = 'المناطق، مستعملة في تعيين مواضع الصور ينبغي أن لا تخلو من النص البديل "alt" (البديل)، كما في الصور.';
$string['checkdesc:asuspiciouslinktext'] = 'نص الرابط ينبغي أن يكون وصفيًا ويعطي فكرة عن مقصده.';
$string['checkdesc:basefontisnotused'] = 'عناصر نوع الخط الأساسي (المستعملة بشكل تقليدي في تنسيق النصوص) غير قابلة للوصول وينبغي تجنب استعمالها.';
$string['checkdesc:blinkisnotused'] = 'العناصر الوامضة، التي تطرف بالظهور والإخفاء، ليست قابلة للوصول وينبغي تجنب استعمالها.';
$string['checkdesc:boldisnotused'] = 'ينبغي عدم استعمال عناصر "Bold" (b)؛ يفضل استعمال عناصر "strong" بدلاً منها.';
$string['checkdesc:contenttoolong'] = 'طول محتوى الصفحة إجمالاً ينبغي أن لا يزيد على 500 كلمة..';
$string['checkdesc:csstexthascontrast'] = 'التباين اللوني ما بين النص والخلفية قليل جدًا.';
$string['checkdesc:embedhasassociatednoembed'] = 'عناصر التضمين (لتضمين متعددات الوسائط) ينبغي أن لا تفتقر إلى عناصر "noembed" العائدة لها.';
$string['checkdesc:headerh3'] = 'العناوين التي تأتي بعد وسوم H3 (خيار العنوان الكبير في المحرر) ينبغي أن لا يكسر التشكيلة الهرمية لعنوان الصفحة.';
$string['checkdesc:headershavetext'] = 'يحتاج العنوان إلى تواجد نص فيه ليكون مفهومًا.';
$string['checkdesc:iisnotused'] = 'لا ينبغي استعمال عناصر "Italic" (i)، ينبغي استعمال "em" بدلاً منها.';
$string['checkdesc:imgaltisdifferent'] = 'النص البديل للصورة ينبغي أن لا يكون هو نفسه اسم ملف الصورة.';
$string['checkdesc:imgaltistoolong'] = 'تأكد من أن النص البديل للصورة موجز بما يكفي لوصفها.';
$string['checkdesc:imgaltnotemptyinanchor'] = 'النص البديل للصورة ينبغي أن لا يكون خاليًا، وخاصة عندما تكون الصورة رابطًا يذهب إلى موضع آخر.';
$string['checkdesc:imgaltnotplaceholder'] = 'النص البديل للصورة ينبغي أن لا يكون نص لعنصر نائب بسيط، مثل "image".';
$string['checkdesc:imghasalt'] = 'النص البديل للصورة ينبغي أن لا يكون مفقودًا لعناصر الصور، ما لم تكن الصورة لمجرد التزيين وبلا أي معنى.';
$string['checkdesc:imgwithmaphasusemap'] = 'مواضع الصور ذات المناطق القابلة للنقر بحاجة إلى عناصر تقابلها من وسمي "usemap" و "map".';
$string['checkdesc:legendtextnotempty'] = 'عناصر "Legend" المستعملة في التسميات التوضيحية لعناصر مجاميع الحقول، ينبغي أن تتضمن نصًا.';
$string['checkdesc:marqueeisnotused'] = 'عناصر "Marquee" (التمرير الذاتي) ليست قابلة للوصول وينبغي تجنب استعمالها.';
$string['checkdesc:noheadings'] = 'عدم وجود العناوين يجعل المحتوى أقل تنظيمًا وأصعب عند القراءة.';
$string['checkdesc:objectmusthaveembed'] = 'عناصر المكونات (لتضمين الموارد الخارجية) ينبغي أن لا تفتقر إلى وسوم "embed" العائدة لها.';
$string['checkdesc:objectmusthavetitle'] = 'عناصر المكونات (لتضمين الموارد الخارجية) ينبغي أن لا تفتقر إلى واصفات "title" العائدة لها.';
$string['checkdesc:objectmusthavevalidtitle'] = 'عناصر المكونات (لتضمين الموارد الخارجية) ينبغي أن يكون لها وسوم "title" ذات نص.';
$string['checkdesc:strikeisnotused'] = 'عناصر "Strike" (شطبة خلال النص) ينبغي تجنب استعمالها، استعمل "del" (محذوف) بدلاً منها.';
$string['checkdesc:tabledatashouldhaveth'] = 'ينبغي للجداول بشكل نموذجي أن لا ينقصها رأس العناوين.';
$string['checkdesc:tablesummarydoesnotduplicatecaption'] = 'مسميات "summaries" و "captions" في الجداول ينبغي أن لا تكون متطابقة.';
$string['checkdesc:tabletdshouldnotmerge'] = 'ينبغي للجداول بشكل نموذجي أن لا تتضمن أي خلايا مدمجة.';
$string['checkdesc:tablethshouldhavescope'] = 'ينبغي التعريف بالمديات لصف الجدول أو عموده (المستعملة لتعيين صف كل خلية وعمودها).';
$string['checkidvalidation'] = 'مهمة التحقق من أي مُعرَّفات فحوص غير صحيحة';
$string['checkscompleted'] = 'الفحوص المكتملة: {$a}';
$string['checktype'] = 'مجموعة الفحص';
$string['checktype:form'] = 'نموذج';
$string['checktype:image'] = 'صورة';
$string['checktype:layout'] = 'تخطيط صفحة';
$string['checktype:link'] = 'رابط';
$string['checktype:media'] = 'وسائط';
$string['checktype:table'] = 'جدول';
$string['checktype:text'] = 'نص';
$string['checktyperesults:pluginname'] = 'تقرير إمكانية الوصول لأنواع المحتوى';
$string['checktyperesults:toolname'] = 'ملخص نوع المحتوى';
$string['checktyperesults:toolshortname'] = 'أنواع المحتوى';
$string['cmpercent'] = 'النسبة المئوية للنشاطات إجمالاً';
$string['cmpercenterrors'] = 'النسبة المئوية للأخطاء إجمالاً';
$string['cmpercenttitle'] = 'النسبة المئوية الإجمالية لانهيار النشاطات مقابل الأخطاء';
$string['confirmationmessage'] = 'تمت جدولة هذا المساق للفحص. ستظهر باكورة التحليل في {$a}. تحقق منه بعدها.';
$string['contactadmin'] = 'يرجى التواصل مع مشرفك لإكمال التسجيل.';
$string['contactus'] = 'تواصل معنا';
$string['contentfive'] = 'إصلاح وسوم HTML القديمة تلقائيًا.';
$string['contentfour'] = 'تحديد النشاطات الأكثر من حيث مشاكل إمكانية الوصول لتقرير أولوية الجهود.';
$string['contentone'] = 'التقييم التلقائي لمحتوى مقررك الدراسي من حيث مشاكل إمكانية الوصول.';
$string['contentsix'] = 'تزويد المعلمين بتلميحات فورية تساعدهم في إنشاء محتوى أفضل.';
$string['contentthree'] = 'تزيد طلابك بمحتوى ذي شكل قابل للوصول بما في ذلك الصوت، ePub ولغة بريل بشكلها الالكتروني.';
$string['contenttwo'] = 'التحديث بالجملة للنصوص غير الواضحة أو المفقودة في روابط الويب، أوصاف الصور وترجمات الفيديوهات.';
$string['contenttypeerrors'] = 'إجمالي نتائج فحوص محتوى النشاطات لكل مساق ولكل نوع محتوى.';
$string['contentyperesults'] = 'إجمالي الاجتياز/الفشل لمناطق المحتوى لكل مساق.';
$string['contextid'] = 'مُعرَّف السياق';
$string['core_course'] = 'المساق';
$string['core_question'] = 'بنوك الأسئلة';
$string['count'] = 'العدد';
$string['country'] = 'البلد';
$string['country_help'] = 'بلد الموقع';
$string['coursecount'] = 'عدد المقررات الدراسية';
$string['deletehistoricaldata'] = 'حذف نتائج ماضي الفحوص';
$string['dependency'] = 'يعتمد على';
$string['emptycategory'] = 'لم يتم العثور على مساقات في التصنيف {$a}';
$string['emptytagcourses'] = 'لم يتم العثور على نتائج للمساقات الدراسية ذات الوسوم المحددة';
$string['enableaccessibilitytools'] = 'تمكين إدوات إمكانية الوصول';
$string['enableaccessibilitytools_desc'] = 'أدوات إمكانية الوصول تساعد في تشخيص مشاكل الوصول في المقررات الدراسية.';
$string['error:nocoursespecified'] = '<p>يتطلب هذا التقرير الملخص مُعرَّف صالح للمساق الدراسي. يرجى الوصول إلى أدوات إمكانية الوصول من داخل المساق، عبر استعمال رابط قائمة الإجراءات، والذي سيقدم حينها مُعرَّف المساق المطلوب.';
$string['errorlink'] = 'تحرير عيِّنة الخطأ لـ {$a}';
$string['errors'] = 'الأخطاء: {$a}';
$string['errors:pluginname'] = 'أداة قائمة الأخطاء لإمكانية الوصول';
$string['errors:toolname'] = 'ملخص قائمة الأخطاء';
$string['errors:toolshortname'] = 'قائمة الأخطاء';
$string['eventanalysis_requested'] = 'تحليل المحتوى تم طلبه';
$string['eventanalysis_requesteddesc'] = 'تحليل المحتوى تم طلبه للمساق الدراسي {$a}';
$string['eventreport_downloaded'] = 'ملخص إمكانية الوصول تم تنزيله';
$string['eventreport_downloadeddesc'] = 'ملخص إمكانية الوصول تم تنزيله للمساق الدراسي ذي المُعرَّف {$a}';
$string['eventreport_viewed'] = 'تقرير إمكانية الوصول تمت معاينته';
$string['eventreport_vieweddesc'] = 'تقرير إمكانية الوصول تمت معاينته للمساق الدراسي ذي المُعرَّف {$a->course}،
مُعرَّف التصنيف {$a->category}، التبويب {$a->tab}.';
$string['failed'] = 'فشل';
$string['failedcount'] = 'فشل: {$a}';
$string['footerheading'] = 'مقطع تذييل الصفحة';
$string['fullcachedone'] = 'التعطيل لإعادة تنفيذ التخبئة';
$string['hashcorrect'] = 'الرمز المُدخل صحيح.';
$string['hashincorrect'] = 'الرمز المُدخل غير صحيح.';
$string['headingfive'] = 'إصلاحات HTML';
$string['headingfour'] = 'تركيز الجهد';
$string['headingone'] = 'تقييم المحتوى';
$string['headingsix'] = 'دعم الأداء';
$string['headingthree'] = 'صيغ الملفات القابلة للوصول';
$string['headingtwo'] = 'العلاج';
$string['hideshow'] = 'إخفاء/إظهار';
$string['icon:analytics-custom'] = 'أيقونة التحليلات';
$string['icon:file-edit-custom'] = 'تحرير أيقونة الملف';
$string['icon:hands-helping-custom'] = 'أيقونة يد المساعدة';
$string['icon:search-plus-custom'] = 'أيقونة البحث';
$string['icon:tools-custom'] = 'أيقونة الأدوات';
$string['icon:wand-magic-custom'] = 'أيقونة العصى السحرية';
$string['inactive'] = 'الإضافة مُعطَّلة ولا يمكن استعمالها. الرجاء، إدخال مفاتيح تسجيل صحيحة، ثم النقر على "تفعيل".';
$string['innercontextid'] = 'مُعرَّف السياق الداخلي';
$string['installed'] = 'تم تنصيب الإضافة';
$string['installedcli'] = 'تم تنصيب الإضافة عبر سطر الأوامر';
$string['installeddescription'] = 'تم تنصيب الإضافة، إعادة التوجيه إلى نموذج التفعيل.';
$string['invalidaccessibilitytool'] = 'تم طلب ملحق فرعي غير صالح لإمكانية الوصول';
$string['invalidcategoryid'] = 'تصنيف غير صحيح، يرجى التحقق مما أدخلته';
$string['invalidcourseid'] = 'مساق غير صحيح، يرجى التحقق مما أدخلته';
$string['invalidlinkphrases'] = 'أنقر|أنقر هنا|هنا|المزيد|المزيد هنا|معلومات|المعلومات هنا|معلومات|معلومات هنا|إقرأ المزيد|إقرأ المزيد هنا|قراءة المزيد|قراءة المزيد هنا|معلومات إضافية|معلومات إضافية هنا|تفاصيل إضافية|تفاصيل إضافية هنا';
$string['language'] = 'اللغة';
$string['language_help'] = 'لغة الموقع';
$string['messageprovider:warningcheckid'] = 'تحذير من مُعرَّفات الفحص غير الصحيحة';
$string['mobileservice'] = 'تم تمكين خدمات الجوال ({$a})';
$string['module'] = 'الوحدة';
$string['modulename'] = 'الاسم';
$string['moreinfo'] = 'مزيد من المعلومات';
$string['newwindowphrases'] = 'نافذة_جديدة|نافذة-جديدة|نافذة جديدة';
$string['noerrorsfound'] = 'لم يتم العثور على أخطاء إمكانية الوصول الشائعة لمعايير البحث الخاصة بك. تهانينا!';
$string['norecords'] = 'لم يتم العثور على سجلات ذات صلة لعوامل البحث الخاصة بك.';
$string['notregistered'] = 'أدوات إمكانية الوصول العائدة لك بحاجة إلى تسجيل.';
$string['notvalidated'] = 'أدوات إمكانية الوصول العائدة لك شغالة ريثما يتم التحقق منها.';
$string['numcourses'] = 'عدد المقررات الدراسية ({$a})';
$string['numfactivities'] = 'عدد النشاطات ({$a})';
$string['numfiles'] = 'عدد الملفات ({$a})';
$string['numinstances'] = 'عدد العيِّنات ({$a})';
$string['numusers'] = 'عدد المستخدمين ({$a})';
$string['pagedesc:checktype'] = '<p>من أجل تلخيص وتحليل نتائج الفحوصات المختلفة التي تم إجراؤها، نقوم بتجميع تلك الفحوص في أنواع محتوى مختلفة. لذلك، فكل فحوص إمكانية الوصول المتعلقة بالصور توجد في مجموعة نوع المحتوى "صورة"، كل فحوص إمكانية الوصول المتعلقة بتخطيط الصفحة توجد في مجموعة نوع المحتوى "تخطيط الصفحة"، وهكذا.</p><p>يتم تضمين النشاطات إما بشكل نشاطات أو موارد أو مناطق محتوى عائدة للمساقات الدراسية نفسها.</p><p>صفحة نشرة أنواع المحتوى تعرض حالات الأخطاء لكل مجموعة من أنواع المحتوى: الصور، تخطيط الصفحة، الروابط، الوسائط، الجداول، والنصوص.</p>';
$string['pagedesc:pertarget'] = '<p>من أجل تلخيص وتحليل نتائج الفحوصات حسب النشاطات، نقوم بتجميع تلك الفحوص حسب النشاطات التي تم الكشف عنها.</p><p>يتم تضمين النشاطات إما بشكل نشاطات أو موارد أو مناطق محتوى عائدة للمساقات الدراسية نفسها. كل نشاط لا يُعثر فيه على أخطاء يعتبر مجتازًا، كل نشاط ذي خطأ واحد أو أكثر يعتبر فاشلاً. يتم عندها عرض نسبة النشاطات المجتازة إلى الفاشلة.</p><p>صفحة نشرة أنواع المحتوى تعرض نسبة العيِّنات المجتازة إلى الفاشلة إجمالاً لكل نوع من أنواع النشاطات، مثل الواجب، المنتدى، الملصق، إلخ.</p>';
$string['pagedesctitle:checktype'] = 'أنواع المحتوى الموضحة';
$string['pagedesctitle:pertarget'] = 'إنهيار النشاط الموضح';
$string['passed'] = 'مجتاز';
$string['passedcount'] = 'المجتاز: {$a}';
$string['passrate'] = 'نسبة المجتاز: {$a} %';
$string['pdf:filename'] = 'تقرير_ملخص_المساق_الدراسي_لإمكانية_الوصول-{$a}';
$string['percheckerrors'] = 'عدد الفحوص المحددة وأخطائها لكل عملية فحص ولكل مساق.';
$string['perpage'] = 'عدد العناصر الظاهرة لكل صفحة';
$string['pluginname'] = 'أدوات إمكانية الوصول';
$string['printable:downloadpdf'] = 'تنزيل PDF';
$string['printable:pluginname'] = 'تقرير ملخص لأداة إمكانية الوصول';
$string['printable:printreport'] = 'تقرير قابل للطباعة';
$string['printable:toolname'] = 'تقرير ملخص';
$string['printable:toolshortname'] = 'تقرير ملخص';
$string['privacy:metadata'] = 'إن ملحق تقرير فحوص إمكانية الوصول لا يخزن أي بيانات شخصية.';
$string['processanalysisrequests'] = 'معالجة طلبات تحليل المحتوى';
$string['registernow'] = 'يرجى التسجيل الآن.';
$string['registration'] = 'نموذج التسجيل';
$string['registrationinfo'] = '<p>عملية التسجيل هذه تسمح لك باستعمال الإصدار المجاني من أدوات Brickfield لإمكانية الوصول في موقع مودل المسجل الخاص بك.</p><p>هذا الاستعمال خاضع لهذه <a href="{$a}" target="_blank">أحكام وشروط مختبرات Brickfield التعليمية (تُفتح بنافذة جديدة)</a> والتي توافق عليها عند استعمال هذا المُنتج.</p>';
$string['release'] = 'إصدار مودل ({$a})';
$string['remaining'] = '({$a} من الأخطاء بقيت)';
$string['response:0'] = 'عنوان الرابط هذا لا يشير إلى أي مكان';
$string['response:404'] = 'تعذر العثور على صفحة عنوان الرابط هذا';
$string['schedule:blocknotscheduled'] = '<p>لم تتم جدولة هذا المساق للتحليل بعد للعثور على المشاكل الشائعة في إمكانية الوصول.</p>';
$string['schedule:notscheduled'] = '<p>لم تتم جدولة هذا المساق للتحليل بعد للعثور على المشاكل الشائعة في إمكانية الوصول.</p><p>عبر النقر على زر "التقديم للتحليل"، فأنت تؤكد رغبتك في جدولة كل محتوى HTML المتعلق بمساقك الدراسي، مثل أوصاف مقاطع المساق، أوصاف النشاطات، الأسئلة، الصفحات، وغير ذلك، جدولتها لتخضع للتحليل.</p><p>هذا التحليل سيجري فحوص متعددة ومختلفة لإمكانية الوصول في محتوى HTML للمساق، والتي ستُعرض نتائجها لاحقًا في صفحات تقارير أدوات إمكانية الوصول.ستتم معالجة هذا التحليل في الخلفية من قبل المهام المجدولة في مودل، ولذلك ستعتمد سرعة إكماله على توقيتات المهام ومواعيد جدولتها.</p>';
$string['schedule:requestanalysis'] = 'التقديم للتحليل';
$string['schedule:scheduled'] = 'تمت جدولة هذا المساق للتحليل.';
$string['schedule:sitenotscheduled'] = 'لم تتم جدولة المحتوى العمومي (مستقل عن المقررات الدراسية) للتحليل بعد للعثور على المشاكل الشائعة في إمكانية الوصول.</p><p>عبر النقر على زر "التقديم للتحليل"، فأنت تؤكد رغبتك في جدولة كل المحتوى العمومي (مستقل عن المقررات الدراسية) للتحليل.</p><p>هذا التحليل سيجري فحوص متعددة ومختلفة لإمكانية الوصول في المحتوى، والتي ستُعرض نتائجها لاحقًا في صفحات تقارير أدوات إمكانية الوصول. ستتم معالجة هذا التحليل في الخلفية من قبل المهام المجدولة في مودل، ولذلك ستعتمد سرعة إكماله على توقيتات المهام ومواعيد جدولتها.</p>';
$string['schedule:sitescheduled'] = 'المحتوى العمومي (مستقل عن المقررات الدراسية) تمت جدولته للتحليل.';
$string['secretkey'] = 'مفتاح واجهة برمجة التطبيق';
$string['secretkey_help'] = 'هذا الرمز يتم تلقيه عبر البريد الالكتروني بعد التسجيل.';
$string['sendfollowinginfo'] = '<p>سيتم إرسال المعلومات الآتية دوريًا للمساهمة في الإحصائيات العامة فقط. لن تتم إتاحتها بشكل عام ضمن أي قائمة مركزية.</p> {$a}';
$string['settings'] = 'إعدادات أدوات إمكانية الوصول';
$string['sitehash'] = 'مفتاح السر';
$string['sitehash_help'] = 'هذا الرمز يتم تلقيه عبر البريد الالكتروني بعد التسجيل.';
$string['taberrors'] = 'فحص الأخطاء';
$string['targetavetitle'] = 'متوسط الأخطاء لكل نشاط';
$string['targetpercentage'] = 'النسبة المئوية للعيِّنات المجتازة/الفاشلة لكل نشاط';
$string['targetratio'] = 'نسبة إجتياز النشاط';
$string['tblcheck'] = 'إفحص';
$string['tblcheckexample'] = 'مثال';
$string['tblcheckfailed'] = 'الفحوص الفاشلة';
$string['tblchecksummary'] = 'الملخص';
$string['tbledit'] = 'تحرير';
$string['tblerrorcount'] = 'الأخطاء';
$string['tblhtmlcode'] = 'رموز HTML الموجودة';
$string['tblinstance'] = 'العيِّنة';
$string['tblline'] = 'السطر';
$string['tbloverallpercentage'] = 'إجمالي الأخطاء %';
$string['tblpercentage'] = 'النسبة المئوية';
$string['tblpreview'] = 'استعراض';
$string['tbltarget'] = 'النشاط';
$string['tblupdateto'] = 'التحديث إلى';
$string['titleactivityresultsall'] = 'النتائج لكل نشاط: كل المقررات الدراسية التي تمت مراجعتها ({$a->count} مساق)';
$string['titleactivityresultspartial'] = 'النتائج لكل نشاط: المساق {$a->name}';
$string['titleall'] = 'تفاصيل الأخطاء: كل المقررات الدراسية التي تمت مراجعتها ({$a->count} مساق)';
$string['titlechecktyperesultsall'] = 'النتائج لكل نوع محتوى: كل المقررات الدراسية التي تمت مراجعتها ({$a->count} مساق)';
$string['titlechecktyperesultspartial'] = 'النتائج لكل نوع محتوى: المساق {$a->name}';
$string['titleerrorsall'] = 'تفاصيل الأخطاء: كل المقررات الدراسية التي تمت مراجعتها ({$a->count} مساق)';
$string['titleerrorscount'] = 'تفاصيل الأخطاء: (إظهار أول {$a} من تلك الأخطاء)';
$string['titleerrorspartial'] = 'تفاصيل الخطأ: المساق {$a->name}';
$string['titlepartial'] = 'تفاصيل الخطأ: المساق {$a->name}';
$string['titleprintableall'] = 'المساق {$a->name}';
$string['titleprintablepartial'] = 'المساق {$a->name}';
$string['tools'] = 'التقارير';
$string['toperrors'] = 'أعلى الأخطاء';
$string['toptargets'] = 'النشاطات الفاشلة';
$string['totalactivities'] = 'إجمالي النشاطات';
$string['totalactivitiescount'] = 'إجمالي النشاطات: {$a}';
$string['totalareas'] = 'إجمالي المناطق';
$string['totalerrors'] = 'إجمالي الأخطاء';
$string['totalgrouperrors'] = 'إجمالي (مجموع) الأخطاء لكل نوع محتوى';
$string['updatesummarydata'] = 'تحديث بيانات ملخص الموقع';
$string['usersmobileregistered'] = 'عدد المستخدمين الذين لديهم أجهزة جوال مسجلة ({$a})';
$string['validationerror'] = 'فشلت عملية التحقق من مفتاح التسجيل. تأكد من كون عنوان رابط موقعك المسجل ومفاتيحه صحيحة.';
$string['warningcheckidbody'] = 'هناك مشكلة في فحص Brickfield لا يزال فعالاً ولكنه غير مدرج في قاعدة البيانات. يرجى التحري عنه.';
$string['warningcheckidsubject'] = 'تنبيه مُعرَّف فحص أداة Brickfield';
