<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boost_union', language 'ru', version '4.4'.
 *
 * @package     theme_boost_union
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutuscontentsetting'] = 'Содержимое страницы «О нас».';
$string['aboutuscontentsetting_desc'] = 'В этом параметре вы можете добавить форматированный текстовый контент, который будет отображаться на странице «О нас».';
$string['aboutusdisabled'] = 'Страница «О нас» на этом сайте отключена. Здесь не на что смотреть.';
$string['aboutusheading'] = 'О нас';
$string['aboutuslinkpositionboth'] = 'Добавить ссылку на страницу «О нас» в сноску и к значку нижнего колонтитула (вопросительный знак).';
$string['aboutuslinkpositionfooter'] = 'Добавить ссылку на страницу «О нас» к значку нижнего нижнего колонтитула (вопросительный знак).';
$string['aboutuslinkpositionfootnote'] = 'Добавить ссылку на страницу «О нас» в сноску';
$string['aboutuslinkpositionnone'] = 'Не показывать автоматически ссылку на страницу «О нас»';
$string['aboutuslinkpositionsetting'] = 'Расположение ссылки «О нас».';
$string['aboutuslinkpositionsetting_desc'] = 'В этом параметре вы можете настроить, должна ли ссылка на страницу «О нас» автоматически добавляться на страницу Moodle. Если вы не хотите, чтобы ссылка отображалась автоматически, вы можете вручную добавить ссылку на {$a->url} из любого места Moodle.';
$string['aboutuspagetitledefault'] = 'О нас';
$string['aboutuspagetitlesetting'] = 'Заголовок страницы «О нас»';
$string['aboutuspagetitlesetting_desc'] = 'В этой настройке вы можете задать заголовок страницы «О нас». Этот текст также будет использоваться в качестве текста ссылки на страницу «О нас», если вы соответствующим образом настроите «Расположение ссылки о нас».';
$string['accessibilitydeclarationcontentsetting'] = 'Содержание страницы декларации доступности';
$string['accessibilitydeclarationcontentsetting_desc'] = 'В этом параметре вы можете добавить расширенный текст, который будет отображаться на странице декларации доступности.';
$string['accessibilitydeclarationdisabled'] = 'Страница декларации доступности для этого сайта отключена. Здесь не на что смотреть.';
$string['accessibilitydeclarationheading'] = 'Декларация доступности';
$string['accessibilitydeclarationlinkpositionboth'] = 'Добавить ссылку на страницу декларации доступности в колонтитул и к значку нижнего колонтитула (вопросительный знак)';
$string['accessibilitydeclarationlinkpositionfooter'] = 'Добавить ссылку на страницу декларации доступности к значку нижнего колонтитула (вопросительный знак)';
$string['accessibilitydeclarationlinkpositionfootnote'] = 'Добавить ссылку на страницу декларации доступности в колонтитул';
$string['accessibilitydeclarationlinkpositionnone'] = 'Не показывать автоматически ссылку на страницу декларации доступности';
$string['accessibilitydeclarationlinkpositionsetting'] = 'Позиция ссылки на декларацию доступности';
$string['accessibilitydeclarationlinkpositionsetting_desc'] = 'В этом параметре вы можете указать, должна ли ссылка на страницу декларации доступности автоматически добавляться на страницы Moodle. Если не хотите показывать ссылку автоматически, вы можете вручную добавить ссылку на {$a->url} из любого места в Moodle.';
$string['accessibilitydeclarationpagetitledefault'] = 'Декларация доступности';
$string['accessibilitydeclarationpagetitlesetting'] = 'Заголовок страницы декларации доступности';
$string['accessibilitydeclarationpagetitlesetting_desc'] = 'В этой настройке вы можете задать заголовок страницы «Декларация доступности». Этот текст также будет использоваться в качестве текста ссылки на страницу «Декларации доступности», если вы соответствующим образом настроите «Позиция ссылки на декларацию доступности».';
$string['accessibilitydeclarationtab'] = 'Декларация';
$string['accessibilitysupportanonymouscheckbox'] = 'Я предпочитаю отправлять запрос в службу поддержки анонимно';
$string['accessibilitysupportanonymousemail'] = 'anonymous@email.invalid';
$string['accessibilitysupportanonymoususer'] = 'Анонимный пользователь';
$string['accessibilitysupportcontentdefault'] = '<p>Если у вас есть какие-либо пожелания по поводу доступности или вы хотите сообщить о препятствии, пожалуйста, заполните форму ниже.</p><p>Работаете ли вы с такими вспомогательными технологиями, как программы чтения с экрана, увеличители, голосовое управление или программное обеспечение для распознавания речи? Если да, пожалуйста, укажите, с какими именно. Чтобы помочь нам обработать ваш запрос, вы можете разрешить форме вместе с вашим сообщением автоматически отправлять следующую информацию: URL-адрес, на котором вы находились, когда открывали эту форму поддержки (это называется «ссылка»[\'referrer\']), и некоторую информацию о вашем браузере.</p>';
$string['accessibilitysupportcontentsetting'] = 'Содержание страницы поддержки специальных возможностей';
$string['accessibilitysupportcontentsetting_desc'] = 'В этом параметре вы можете добавить расширенный текст, который будет отображаться на странице поддержки специальных возможностей, а также на форме для отправки отзыва о специальных возможностях или в сообщениях о препятствии в доступе.';
$string['accessibilitysupportdefaultsubject'] = 'Отзыв о доступности';
$string['accessibilitysupportdisabled'] = 'Страница поддержки доступности на этом сайте отключена. Здесь не на что смотреть.';
$string['accessibilitysupportheading'] = 'Страница поддержки доступности';
$string['accessibilitysupportlinkpositionboth'] = 'Добавить ссылку на страницу поддержки доступности в сноску и к значку нижнего колонтитула (вопросительный знак)';
$string['accessibilitysupportlinkpositionfooter'] = 'Добавить ссылку на страницу поддержки доступности к значку нижнего колонтитула (вопросительный знак)';
$string['accessibilitysupportlinkpositionfootnote'] = 'Добавить ссылку на страницу поддержки доступности в сноску';
$string['accessibilitysupportlinkpositionnone'] = 'Не показывать автоматически ссылку на страницу поддержки доступности';
$string['accessibilitysupportlinkpositionsetting'] = 'Позиция ссылки на страницу поддержки доступности';
$string['accessibilitysupportlinkpositionsetting_desc'] = 'С помощью этого параметра вы можете настроить, должна ли ссылка на страницу поддержки специальных возможностей автоматически добавляться на страницу Moodle. Если вы не хотите, чтобы ссылка отображалась автоматически, вы можете добавить ссылку на {$a->url} из любого места в Moodle вручную.';
$string['accessibilitysupportmessagenotsent'] = 'К сожалению, не удалось отправить ваш запрос в службу поддержки доступности.';
$string['accessibilitysupportmessagesent'] = 'Ваш запрос в службу поддержки доступности был отправлен.';
$string['accessibilitysupportmessagetryagain'] = 'Пожалуйста, повторите попытку позже.';
$string['accessibilitysupportmessagetryalternative'] = 'Пожалуйста, попробуйте еще раз позже или отправьте электронное письмо непосредственно в службу поддержки <a href="mailto:{$to}">{$to}</a>.';
$string['accessibilitysupportpagesrlinktitledefault'] = 'Получить поддержку доступности';
$string['accessibilitysupportpagesrlinktitlesetting'] = 'Заголовок ссылки на страницу поддержки доступности для экранного диктора';
$string['accessibilitysupportpagesrlinktitlesetting_desc'] = 'С помощью этого параметра вы можете задать заголовок ссылки на страницу поддержки доступности для экранного диктора. Этот текст будет использоваться в качестве текста ссылки, который доступен только для программ чтения с экрана.';
$string['accessibilitysupportpagetitledefault'] = 'Поддержка доступности';
$string['accessibilitysupportpagetitlesetting'] = 'Заголовок страницы поддержки доступности';
$string['accessibilitysupportpagetitlesetting_desc'] = 'С помощью этого параметра вы можете задать заголовок страницы поддержки доступности. Этот текст также будет использоваться в качестве названия ссылки на страницу поддержки доступности, если вы соответствующим образом настроите параметр «Позиция ссылки на страницу поддержки доступности».';
$string['accessibilitysupportrecaptcha'] = 'Добавлять reCAPTCHA на страницу поддержки доступности';
$string['accessibilitysupportrecaptcha_desc'] = 'С помощью этого параметра вы можете настроить, будет ли добавлена reCAPTCHA на страницу поддержки доступности. Это делается для предотвращения спама и злоупотребления формой поддержки доступности, точно так же, как это делается в <a href="{$a->support}">форме службы поддержки сайта из ядра Moodle</a>. Однако добавление reCAPTCHA создает дополнительный барьер доступности для пользователей, использующих программы для чтения с экрана или другие вспомогательные технологии, что в данном случае может оказаться неэффективным. Поэтому выбирайте обдуманно, если хотите включить этот параметр. Также обратите внимание, что, даже если функция включена, reCAPTCHA не отображается до тех пор, пока вы не зададите необходимые <a href="{$a->settings}">API-ключи в настройках аутентификации</a>.';
$string['accessibilitysupportsentforanonymoususer'] = 'Пользователь попросил отправить этот отзыв о доступности анонимно.';
$string['accessibilitysupportsubmit'] = 'Отправить';
$string['accessibilitysupporttab'] = 'Страница поддержки';
$string['accessibilitysupporttechinfo'] = 'Техническая информация';
$string['accessibilitysupporttechinfocheckbox'] = 'Я согласен отправить следующую техническую информацию вместе с моим сообщением';
$string['accessibilitysupporttechinfolabel'] = 'Техническая информация для совместной отправки';
$string['accessibilitysupporttechinforeferrer'] = 'Страница обращения';
$string['accessibilitysupporttechinfosysinfo'] = 'Информация о системе';
$string['accessibilitysupportuserfirstname'] = 'Доступность';
$string['accessibilitysupportuserlastname'] = 'поддержка';
$string['accessibilitysupportusermail'] = 'Электронная почта поддержки доступности';
$string['accessibilitysupportusermail_desc'] = 'Здесь вы указываете адрес электронной почты, на который следует отправлять запросы в службу поддержки доступности. Если вы оставите это поле пустым, запросы будут отправляться на адрес из настройки <a href="{$a->url}">«контакты службы поддержки»</a>.';
$string['accessibilitysupportusermailsubject'] = 'Запрос в поддержку доступности';
$string['activitiesheading'] = 'Блок «Элементы курса»';
$string['activitiestintenabled'] = 'Тонировка значков в блоке «Элементы курса»';
$string['activitiestintenabled_desc'] = 'С помощью этой настройки вы можете окрашивать значки в блоке «Элементы курса» в зависимости от целей деятельности. По умолчанию Moodle отображает их просто как черные значки.';
$string['activitybrandingtab'] = 'Фирменный стиль элементов курсов';
$string['activityiconcoloradministrationsetting'] = 'Цвет для «Управление»';
$string['activityiconcoloradministrationsetting_desc'] = 'Цвет значка действия «Управление»';
$string['activityiconcolorassessmentsetting'] = 'Цвет для «Оценка»';
$string['activityiconcolorassessmentsetting_desc'] = 'Цвет значка действия «Оценка»';
$string['activityiconcolorcollaborationsetting'] = 'Цвет для «Сотрудничество»';
$string['activityiconcolorcollaborationsetting_desc'] = 'Цвет значка действия «Сотрудничество»';
$string['activityiconcolorcommunicationsetting'] = 'Цвет для «Коммуникация»';
$string['activityiconcolorcommunicationsetting_desc'] = 'Цвет значка действия «Коммуникация»';
$string['activityiconcolorcontentsetting'] = 'Цвет для «Контент»';
$string['activityiconcolorcontentsetting_desc'] = 'Цвет значка действия «Контент»';
$string['activityiconcolorfidelity_detailled'] = 'Детальное исследование (до 100 итераций)';
$string['activityiconcolorfidelity_insane'] = 'Безумный поиск (до 500 итераций)';
$string['activityiconcolorfidelity_oneshot'] = 'Один снимок (1 итерация)';
$string['activityiconcolorfidelity_sometries'] = 'Несколько попыток (до 10 итераций)';
$string['activityiconcolorfidelitysetting'] = 'Точность цветопередачи значка активного элемента';
$string['activityiconcolorfidelitysetting_desc'] = 'С помощью приведенных выше настроек вы задаете шестнадцатеричный цвет, который будет использоваться для окрашивания значка конкретного активного элемента. Однако технически значок активного элемента окрашивается с помощью CSS-фильтра. Boost Union использует сложный алгоритм для определения CSS-фильтра, который визуально соответствует заданному шестнадцатеричному цвету, но этот алгоритм основан на случайном поиске и может дать неоптимальные результаты, если его запустить всего один раз. С помощью этой настройки вы можете разрешить Boost Union запускать алгоритм несколько раз и в конце выбрать фильтр, который меньше всего отклоняется от шестнадцатеричного цвета. Обратите внимание, что эта настройка влияет на время очистки кэша (чем больше итераций разрешено, тем дольше Moodle будет очищать кэш тем), но не влияет на время загрузки страницы.';
$string['activityiconcolorinteractivecontentsetting'] = 'Цвет для «Интерактивный контент»';
$string['activityiconcolorinteractivecontentsetting_desc'] = 'Цвет значка активного элемента «Интерактивный контент»';
$string['activityiconcolorinterfacesetting'] = 'Цвет для «Интерфейс»';
$string['activityiconcolorinterfacesetting_desc'] = 'Цвет значка действия «Интерфейс»';
$string['activityiconcolorsheading'] = 'Цвета значков для действий';
$string['activitynavigationsetting'] = 'Навигация по элементам и разделам курса';
$string['activitynavigationsetting_desc'] = 'При включении отображаются элементы для перехода к предыдущему и следующему элементу(ресурсу) курса, а также раскрывающееся меню для перехода к конкретному элементу или ресурсу. Кроме того, в курсах, использующих режим «один раздел на страницу», также отображаются аналогичные элементы для предыдущего и следующего раздела. Подобные элементы пользовательского интерфейса уже существовали в Boost в ядре Moodle до версии 3.11, но были удалены в версии 4.0. С помощью Boost Union вы можете вернуть их.';
$string['activitypurposeadministration'] = 'Управление';
$string['activitypurposeassessment'] = 'Оценивание';
$string['activitypurposecollaboration'] = 'Сотрудничество';
$string['activitypurposecommunication'] = 'Коммуникация';
$string['activitypurposecontent'] = 'Контент';
$string['activitypurposeheading'] = 'Назначение значка активного элемента';
$string['activitypurposeheading_desc'] = 'Здесь вы можете переопределить цвет фона иконки элементов курсов, который определяется назначением элемента. (Назначение является жестко закодированным свойством каждого элемента).';
$string['activitypurposeheadingtechnote'] = 'Техническое примечание: Из-за того, как ядро Moodle реализует назначения элементов курсов и их цвета, назначения могут быть переопределены с помощью CSS только в Boost Union. В настоящее время все области в ядре Moodle, которые показывают цветные иконки, должны быть покрыты. Если вы обнаружили какую-то область или сторонний плагин, который продолжает показывать неизменные цвета назначений, пожалуйста, сообщите об этом на {$a}.';
$string['activitypurposeinteractivecontent'] = 'Интерактивный контент';
$string['activitypurposeinterface'] = 'Интерфейс';
$string['activitypurposeother'] = 'Прочее';
$string['additionalresourcesfileurlpersistent'] = 'URL (постоянный)';
$string['additionalresourcesfileurlrevisioned'] = 'URL (обновляемый)';
$string['additionalresourcesheading'] = 'Дополнительные ресурсы';
$string['additionalresourceslistsetting'] = 'Список дополнительных ресурсов';
$string['additionalresourceslistsetting_desc'] = 'Это список файлов, которые вы загрузили в область файлов дополнительных ресурсов. Указанные URL могут быть использованы для ссылки на эти файлы из вашего пользовательского CSS, из сноски или в любом другом месте, где вам нужно использовать загруженные файлы, но вы не можете загрузить файлы на месте.';
$string['additionalresourcessetting'] = 'Дополнительные ресурсы';
$string['additionalresourcessetting_desc'] = 'С помощью этой настройки вы можете загружать в тему дополнительные ресурсы. Преимущество загрузки файлов в эту файловую область заключается в том, что эти файлы могут быть доставлены без проверки, вошел ли пользователь в систему. По этой же причине следует добавлять только те файлы, которые некритичны, к которым может быть разрешен доступ всем и которые не нуждаются в защите. Как только вы загрузите хотя бы один файл в эту область файлов и сохраните настройки, под ним появится список, в котором будет указан URL, который вы можете использовать для ссылки на конкретный файл.';
$string['addpreferredlangsetting'] = 'Добавить ссылку на предпочтительный язык в меню языков';
$string['addpreferredlangsetting_desc'] = 'С помощью этой настройки можно добавить параметр «Установить предпочтительный язык» в языковое меню в пользовательском меню. Понятно, что эта настройка будет обрабатываться только в том случае, если включена настройка <a href="{$a->url1}">Отображать меню языков</a>, а также если установлен хотя бы  <a href="{$a->url2}">второй языковой пакет</a> и <a href="{$a->url3}">предложен выбор языков</a>.';
$string['administrationtab'] = 'Администрирование';
$string['allowaccessibilitysupportwithoutlogin'] = 'Разрешить доступ к странице поддержки доступности без входа в систему';
$string['allowaccessibilitysupportwithoutlogin_desc'] = 'Если этот параметр включен, страница поддержки доступности будет показана пользователям, которые не вошли в систему. Если этот параметр отключен, доступ к странице поддержки доступности будет разрешен только зарегистрированным пользователям.';
$string['allowanonymoussubmitssetting'] = 'Разрешить анонимную отправку сообщений на страницу поддержки';
$string['allowanonymoussubmitssetting_desc'] = 'С помощью этой настройки вы можете разрешить пользователю отправлять анонимные отзывы о доступности через страницу поддержки доступности. Пользователи смогут самостоятельно решить, хотят ли они отправлять отзывы анонимно (без указания логина и адреса электронной почты) или нет.';
$string['allowsendtechinfoalongsetting'] = 'Разрешить отправку технической информации';
$string['allowsendtechinfoalongsetting_desc'] = 'С помощью этой настройки вы можете разрешить пользователю отправлять техническую информацию на страницу поддержки доступности. Пользователи смогут самостоятельно решить, отправлять ли им техническую информацию или нет.';
$string['alternativelogolinkurlsetting'] = 'URL-адрес альтернативный ссылки на логотипе';
$string['alternativelogolinkurlsetting_desc'] = 'С помощью этой настройки вы можете задать URL альтернативной ссылки, которая будет использоваться в качестве ссылки на логотипе в панели навигации. Вы можете использовать эту настройку, например, для ссылки на веб-сайт вашей организации вместо главной страницы Moodle, чтобы сохранить однородную панель навигации во всех системах вашей организации.';
$string['always'] = 'Всегда';
$string['auto'] = 'Автоматически';
$string['backgroundimagepositionsetting'] = 'Положение фонового рисунка';
$string['backgroundimagepositionsetting_desc'] = 'Здесь вы можете задать позиционирование фонового изображения в окне браузера. Первое значение - горизонтальное положение, второе - вертикальное.';
$string['backgroundimagesetting'] = 'Фоновый рисунок';
$string['backgroundimagesetting_desc'] = 'Здесь вы можете загрузить пользовательское изображение для отображения в качестве фона сайта. Загруженное здесь фоновое изображение будет заменять фоновое изображение в файлах предустановок вашей темы.';
$string['backgroundimagesheading'] = 'Общие фоновые изображения';
$string['backtotop'] = 'Вернуться к началу';
$string['backtotopbuttonsetting'] = 'Кнопка возврата к началу';
$string['backtotopbuttonsetting_desc'] = 'При включенном параметре кнопка «Вернуться к началу» появится в правом нижнем углу страницы, как только пользователь прокрутит страницу вниз. Подобная кнопка уже существовала в Boost до версии Moodle 3.11, но была удалена в версии 4.0. С помощью Boost Union вы можете вернуть её обратно.';
$string['blockdrawerwidthsetting'] = 'Ширина боковой панели';
$string['blockdrawerwidthsetting_desc'] = 'С помощью этой настройки вы можете изменить ширину боковой панели без ручного изменения SCSS. По умолчанию Moodle использует максимальную ширину среднего контента в 315px. Вы можете ввести другие значения в пикселях, например 400px. Значения с другими единицами измерения, такие как процентные значения или значение ширины экрана, не будут работать.';
$string['blockregionfooterwidth'] = 'Ширина блока для области «Нижний колонтитул»';
$string['blockregionfooterwidth_desc'] = 'С помощью этого параметра можно задать ширину блока области «Нижний колонтитул». Вы можете выбрать между полной шириной, шириной контента курса и шириной блока.';
$string['blockregionoutsidebottomwidth'] = 'Ширина блока для области «Внешняя (снизу)»';
$string['blockregionoutsidebottomwidth_desc'] = 'С помощью этого параметра можно задать ширину блока области «Внешняя (снизу)», который отображается под основным контентом. Вы можете выбрать между полной шириной, шириной контента курса и шириной блока.';
$string['blockregionoutsideleftwidth'] = 'Ширина блока для области «Внешняя (слева)»';
$string['blockregionoutsideleftwidth_desc'] = 'С помощью этого параметра можно задать ширину блока области «Внешняя (слева)», который отображается слева от области основного контента. По умолчанию Boost Union использует ширину 300px. Вы можете ввести другие значения, основанные на пикселях, например, 200px, а также значение в процентах, например, 10% или значение viewport-width, например, 10vw.';
$string['blockregionoutsiderightwidth'] = 'Ширина блока для области «Внешняя (справа)»';
$string['blockregionoutsiderightwidth_desc'] = 'С помощью этого параметра можно задать ширину блока области «Внешняя (справа)», который отображается справа от области основного контента. По умолчанию Boost Union использует ширину 300px. Вы можете ввести другие значения, основанные на пикселях, например, 200px, а также значение в процентах, например, 10% или значение viewport-width, например, 10vw.';
$string['blockregionoutsidetopwidth'] = 'Ширина блока для области «Внешняя (сверху)»';
$string['blockregionoutsidetopwidth_desc'] = 'С помощью этого параметра можно задать ширину блока области «Внешняя (сверху)», который отображается в самом верху страницы. Вы можете выбрать между полной шириной, шириной еонтента курса и шириной блока.';
$string['blockregionsforlayout'] = 'Дополнительные области для макета «{$a}»';
$string['blockregionsforlayout_desc'] = 'С помощью этого параметра можно включить дополнительные области для макета «{$a}».';
$string['blockregionsheading'] = 'Дополнительные области блоков';
$string['blockregionsheading_desc'] = '<p>Boost Union предоставляет большое количество дополнительных областей, которые можно использовать для добавления и отображения блоков на всей странице Moodle:</p>
<ul><li><em>Внешние области</em> размещаются на всех четырех сторонах страницы Moodle. Они могут быть использованы для показа блоков, которые сопровождают отображаемую страницу Moodle, но не относятся непосредственно к основному содержимому.</li>
<li><em>Область заголовка</em> расположена между внешней (верхней) областью и основным содержимым. Её можно использовать для отображения блока в качестве заголовка курса.</li>
<li><em>Область блоков контента</em> размещается непосредственно над и под основным содержимым в области основного контента. Их можно использовать для добавления блоков в текущие материалы курса.</li>
<li><em>Область колонтитула</em> размещаются в нижней части страницы между внешней (нижней) областью и подвалом. В вашем распоряжении три области колонтитулов, из которых при необходимости можно построить колонки.</li>
<li><em>Область вне страницы</em> является особенной, поскольку она нависает над всей страницей Moodle в виде выпадающей панели. Панель открывается значком с 9 точками в самом правом углу навигационной панели. В вашем распоряжении три области вне страницы, из которых при необходимости можно построить колонки.</li></ul>
<p>Обратите внимание:</p>
<ul><li>По умолчанию все дополнительные области блоков отключены. Включите те или иные области блоков на конкретных макетах страниц в соответствии с вашими потребностями. Старайтесь быть как можно более сфокусированными - слишком большое количество областей может ошеломить часть пользователей.</li>
<li>Как только дополнительная область блока включена, она становится видимой для всех аутентифицированных пользователей и может редактироваться преподавателями и управляющими (конечно, в зависимости от того, разрешено ли данному пользователю редактировать конкретную страницу Moodle). Но существуют также разрешения theme/boost_union:viewregion* и theme/boost_union:editregion*, которые позволяют вам тонко настроить использование каждой области в соответствии со своими потребностями.</li>
<li>Блоки областей «Внешняя (слева)», «Внешняя (справа)», «Содержимое (вверху)», «Содержимое (внизу» и «Заголовок» доступны не для всех макетов страниц.</li></ul>';
$string['blockregionsheading_experimental'] = 'Пожалуйста, обратите внимание: <em>блоки областей «Внешняя (слева)» и «Внешняя (справа)»</em> полностью работоспособны в текущем состоянии реализации, но должны рассматриваться как экспериментальные, поскольку они еще не отображаются должным образом на экранах средней ширины. Поэтому используйте их с осторожностью. Эта проблема будет исправлена в одном из ближайших выпусков.';
$string['blocksgeneralheading'] = 'Основные блоки';
$string['blockstab'] = 'Блоки';
$string['boost_union:configure'] = 'Возможность настраивать тему не в роли администратора';
$string['boost_union:editregioncontentlower'] = 'Возможность редактировать область блоков Контент (снизу)';
$string['boost_union:editregioncontentupper'] = 'Возможность редактировать область блоков Контент (сверху)';
$string['boost_union:editregionfootercenter'] = 'Возможность редактировать область блоков «Нижний колонтитул (по центру)»';
$string['boost_union:editregionfooterleft'] = 'Возможность редактировать область блоков «Нижний колонтитул (слева)»';
$string['boost_union:editregionfooterright'] = 'Возможность редактировать область блоков «Нижний колонтитул (справа)»';
$string['boost_union:editregionheader'] = 'Возможность редактировать область блоков «Заголовок»';
$string['boost_union:editregionoffcanvascenter'] = 'Возможность редактировать область блоков «Вне страницы (по центру)»';
$string['boost_union:editregionoffcanvasleft'] = 'Возможность редактировать область блоков «Вне страницы (слева)»';
$string['boost_union:editregionoffcanvasright'] = 'Возможность редактировать область блоков «Вне страницы (справа)»';
$string['boost_union:editregionoutsidebottom'] = 'Возможность редактировать область блоков «Внешняя (снизу)»';
$string['boost_union:editregionoutsideleft'] = 'Возможность редактировать область блоков «Внешняя (слева)»';
$string['boost_union:editregionoutsideright'] = 'Возможность редактировать область блоков «Внешняя (справа)»';
$string['boost_union:editregionoutsidetop'] = 'Возможность редактировать область блоков «Внешняя (сверху)»';
$string['boost_union:viewhintcourseselfenrol'] = 'Возможность видеть подсказку о разрешенной самостоятельной записи на видимый курс.';
$string['boost_union:viewhintinhiddencourse'] = 'Возможность видеть подсказку о скрытом курсе.';
$string['boost_union:viewregioncontentlower'] = 'Возможность видеть область блоков Контент (снизу)';
$string['boost_union:viewregioncontentupper'] = 'Возможность видеть область блоков Контент (сверху)';
$string['boost_union:viewregionfootercenter'] = 'Возможность видеть область блоков «Нижний колонтитул (по центру)»';
$string['boost_union:viewregionfooterleft'] = 'Возможность видеть область блоков «Нижний колонтитул (слева)»';
$string['boost_union:viewregionfooterright'] = 'Возможность видеть область блоков «Нижний колонтитул (справа)»';
$string['boost_union:viewregionheader'] = 'Возможность видеть область блоков «Заголовок»';
$string['boost_union:viewregionoffcanvascenter'] = 'Возможность видеть область блоков «Вне страницы (по центру)»';
$string['boost_union:viewregionoffcanvasleft'] = 'Возможность видеть область блоков «Вне страницы (слева)»';
$string['boost_union:viewregionoffcanvasright'] = 'Возможность видеть область блоков «Вне страницы (справа)»';
$string['boost_union:viewregionoutsidebottom'] = 'Возможность видеть область блоков «Внешняя (снизу)»';
$string['boost_union:viewregionoutsideleft'] = 'Возможность видеть область блоков «Внешняя (слева)»';
$string['boost_union:viewregionoutsideright'] = 'Возможность видеть область блоков «Внешняя (справа)»';
$string['boost_union:viewregionoutsidetop'] = 'Возможность видеть область блоков «Внешняя (сверху)»';
$string['bootstrapcolordangersetting'] = 'Цвет «Опасности»';
$string['bootstrapcolordangersetting_desc'] = 'Цвет Bootstrap для «Опасности»';
$string['bootstrapcolorinfosetting'] = 'Цвет «Информации»';
$string['bootstrapcolorinfosetting_desc'] = 'Цвет Bootstrap для «Информации»';
$string['bootstrapcolorsheading'] = 'Цвета Bootstrap';
$string['bootstrapcolorsuccesssetting'] = 'Цвет «Успеха»';
$string['bootstrapcolorsuccesssetting_desc'] = 'Цвет Bootstrap для «Успеха»';
$string['bootstrapcolorwarningsetting'] = 'Цвет «Предупреждения»';
$string['bootstrapcolorwarningsetting_desc'] = 'Цвет Bootstrap для «Предупреждения»';
$string['bootstrapdangercolor'] = 'Цвет опасности';
$string['bootstrapdarkcolor'] = 'Тёмный цвет';
$string['bootstrapinfocolor'] = 'Цвет информации';
$string['bootstraplightcolor'] = 'Светлый цвет';
$string['bootstrapnone'] = 'Без цвета Bootstrap';
$string['bootstrapprimarycolor'] = 'Основной цвет';
$string['bootstrapsecondarycolor'] = 'Вторичный цвет';
$string['bootstrapsuccesscolor'] = 'Цвет завершения';
$string['bootstrapwarningcolor'] = 'Цвет предупреждения';
$string['brandcolorsheading'] = 'Фирменные цвета';
$string['breadcrumbsheading'] = 'Навигационная цепочка';
$string['cachedef_flavours'] = 'Стили, которые применяются к данному идентификатору категории страницы для текущего пользователя';
$string['cachedef_hookoverrides'] = 'Переопределения хуков';
$string['cachedef_smartmenu_items'] = 'Элементы умного меню';
$string['cachedef_smartmenus'] = 'Умные меню';
$string['cachedef_touchiconsios'] = 'Файлы сенсорных значков для iOS';
$string['categorybreadcrumbs'] = 'Отображать категории в заголовке курса';
$string['categorybreadcrumbs_desc'] = 'По умолчанию категории курса не отображаются в навигационной цепочке на страницах курса. С помощью этой настройки вы можете показать категории курса в навигационной цепочке в заголовке курса над его названием.';
$string['categoryindextab'] = 'Список категорий / Главная страница сайта';
$string['categorylistingheading'] = 'Список категорий';
$string['categorylistingpresentation'] = 'Представление списка категорий';
$string['categorylistingpresentation_boxlist'] = 'Перечень полей';
$string['categorylistingpresentation_desc'] = 'С помощью этой настройки вы можете изменить внешний вид списка категорий на странице перечня категорий и на главной странице сайта. В качестве альтернативы тому, как это реализовано в ядре Moodle, вы можете представить список категорий в виде обновленного перечня полей.';
$string['categorylistingpresentation_nochange'] = 'Кошмар дизайнера (без изменений, как представлено в ядре Moodle)';
$string['categorylistingpresentation_note'] = 'Обратите внимание: если выше вы включили параметр «Представление списка курсов», рекомендуем включить и этот параметр. Они разработаны для совместной работы.';
$string['choosereadme'] = '<p>Тема Boost Union - это усовершенствованная дочерняя тема Boost, которая призвана сделать Boost более настраиваемой и предоставить полезные дополнительные функции для ежедневной работы в Moodle администраторам, преподавателям и студентам.</p><p>Boost Union поддерживается<br />Moodle an Hochschulen e.V.,</p><p>в сотрудничестве с<br />lern.link GmbH</p><p>вместе с<br />bdecent GmbH</p>';
$string['closeoffcanvas'] = 'Закрыть панель «Вне страницы»';
$string['configtitle'] = 'Boost Union';
$string['configtitleaccessibility'] = 'Доступность';
$string['configtitlecontent'] = 'Содержимое';
$string['configtitlefeel'] = 'Восприятие';
$string['configtitleflavours'] = 'Стили';
$string['configtitlefunctionality'] = 'Функциональные особенности';
$string['configtitlelook'] = 'Вид';
$string['contactcontentsetting'] = 'Содержимое страницы контактов';
$string['contactcontentsetting_desc'] = 'В этом параметре вы можете добавить расширенный текстовый контент, который будет отображаться на странице контактов (это не то же самое, что встроенная страница Moodle «Контакты поддержки сайта»).';
$string['contactdisabled'] = 'Страница контактов отключена для этого сайта. Здесь не на что смотреть.';
$string['contactheading'] = 'Контакты';
$string['contactlinkpositionboth'] = 'Добавить ссылку на страницу контактов в сноске и на иконку «Знак вопроса» в нижнем колонтитуле';
$string['contactlinkpositionfooter'] = 'Добавить ссылку на страницу контактов на иконку «Знак вопроса» в нижнем колонтитуле';
$string['contactlinkpositionfootnote'] = 'Добавить ссылку на страницу контактов в колонтитул';
$string['contactlinkpositionnone'] = 'Не показывать автоматически ссылку на страницу контактов';
$string['contactlinkpositionsetting'] = 'Расположение ссылки на страницу контактов';
$string['contactlinkpositionsetting_desc'] = 'В этом параметре вы можете указать, должна ли ссылка на страницу контактов автоматически добавляться на страницы Moodle. Если вы не хотите показывать ссылку автоматически, вы можете добавить ссылку на {$a->url} из любого места в Moodle вручную.';
$string['contactpagetitledefault'] = 'Контакты';
$string['contactpagetitlesetting'] = 'Заголовок страницы контактов';
$string['contactpagetitlesetting_desc'] = 'Этот параметр определяет заголовок страницы контактов. Этот текст будет использоваться в качестве текста ссылки на страницу контактов, если вы соответствующим образом настроите «Расположение ссылки на страницу контактов».';
$string['contentwidthheading'] = 'Ширина контента';
$string['coursecardscolumncount'] = 'Количество столбцов в карточке курса';
$string['coursecardscolumncount_desc'] = 'Сетка карточек курса будет отображаться адаптивно, а её столбцы будут сворачиваться на маленьких экранах. С помощью этой настройки вы можете управлять максимальным количеством столбцов в сетке карточек курса на больших экранах. Установка максимального количества столбцов 2 вместо 3 может сделать карточки курса более просторными и менее перегруженными. Также можно установить максимальное количество столбцов 1, что фактически превратит список курсов в вертикальный перечень карточек.';
$string['coursecontentmaxwidthsetting'] = 'Максимальная ширина контента курса';
$string['coursecontentmaxwidthsetting_desc'] = 'С помощью этой настройки вы можете изменить ширину контента курса без ручного изменения SCSS. Эта ширина используется в качестве ширины страниц курса и в некоторых видах элементов курса. По умолчанию Moodle использует максимальную ширину контента курса 830px. Вы можете ввести другие значения, основанные на пикселях, например 1200px, но вы также можете ввести значение, основанное на процентах, например 100%, или значение viewport-width, например 90vw.';
$string['courseheaderheading'] = 'Заголовок курса';
$string['courseheaderimageenabled'] = 'Отображать изображение курса в заголовке курса';
$string['courseheaderimageenabled_desc'] = 'Если эта функция включена, изображение курса (которое можно добавить в настройках курса) отображается в заголовке курса. Изображения курсов отображаются там в дополнение к странице "Мои курсы", где они отображаются всегда.';
$string['courseheaderimagefallback'] = 'Резервное изображение заголовка курса';
$string['courseheaderimagefallback_desc'] = 'Загруженное в этом параметре изображение используется в качестве резервного и будет отображено в заголовке курса, если в настройках курса не загружено изображение. Если вы не загрузите изображение здесь, то изображение в заголовке курса будет отображаться в конкретном курсе только в том случае, если в настройках этого конкретного курса загружено изображение.';
$string['courseheaderimageheight'] = 'Высота изображения заголовка курса';
$string['courseheaderimageheight_desc'] = 'С помощью этого параметра вы управляете высотой  изображения, представленного в заголовке курса.';
$string['courseheaderimagelayout'] = 'Расположение изображения в заголовке курса';
$string['courseheaderimagelayout_desc'] = 'Этот параметр позволяет управлять взаимным расположением изображения и названия курса в его заголовке.';
$string['courseheaderimagelayoutheadingabove'] = 'Название курса над изображением курса';
$string['courseheaderimagelayoutstackeddark'] = 'Название курса накладывается на изображение курса (белый цвет шрифта для темных фоновых изображений)';
$string['courseheaderimagelayoutstackedlight'] = 'Название курса накладывается на изображение курса (черный цвет шрифта для светлых фоновых изображений)';
$string['courseheaderimageposition'] = 'Позиция изображения заголовка курса';
$string['courseheaderimageposition_desc'] = 'С помощью этого параметра вы управляете расположением изображения заголовка курса в контейнере изображения заголовка курса. Первое значение — горизонтальное положение, второе значение — вертикальное положение.';
$string['courseindexcompletioninfoposition'] = 'Позиция индикатора выполнения элемента';
$string['courseindexcompletioninfoposition_desc'] = 'Выберите позицию, в которой будет отображаться индикатор выполнения. <em>Конец строки</em> -  стандартный индикатор выполнения отображается в конце строки оглавления курса. <em>Начало строки</em> - стандартный индикатор выполнения отображается в начале строки оглавления курса.  <em>Цвет значка</em> - не отображает стандартный индикатор выполнения, а информирует о выполнении в виде фона значка модуля курса.';
$string['courseindexcompletioninfopositionendofline'] = 'Конец строки';
$string['courseindexcompletioninfopositioniconcolor'] = 'Цвет значка';
$string['courseindexcompletioninfopositionstartofline'] = 'Начало строки';
$string['courseindexdrawerwidthsetting'] = 'Ширина области оглавления курса';
$string['courseindexdrawerwidthsetting_desc'] = 'С помощью этой настройки вы можете изменить ширину области оглавления курса без ручного изменения SCSS. По умолчанию Moodle использует ширину 285px. Вы можете ввести другие значения в пикселях, например 320px. Значения с другими единицами измерения, такие как процентные значения или значение ширины экрана, не будут работать.';
$string['courseindexheading'] = 'Оглавление курса';
$string['courseindexmodiconenabled'] = 'Отображать значки типов деятельности в оглавлении курса';
$string['courseindexmodiconenabled_desc'] = 'Когда эта функция включена, перед строкой оглавления с названием элемента курса отображается значок соответствующего типа деятельности. При этом тип деятельности либо заменяет индикатор завершения, который перемещается из передней части в конец строки, либо окрашивается в цвет состояния завершения.';
$string['courselistingcontacts'] = 'Контакты курса';
$string['courselistingfields'] = 'Классификация курса';
$string['courselistinggoto'] = 'Перейти к курсу';
$string['courselistingheading'] = 'Список курсов';
$string['courselistinghowcategory'] = 'Показывать категорию курса в списке курсов';
$string['courselistinghowcategory_desc'] = 'С помощью этой настройки вы можете контролировать, будет ли категория курса отображаться в списке курсов или нет.';
$string['courselistinghowenrolicons'] = 'Показывать значки зачисления на курс в списке курсов';
$string['courselistinghowenrolicons_desc'] = 'С помощью этой настройки вы можете контролировать, будут ли отображаться значки записи на курс в списке курсов или нет.';
$string['courselistinghowgoto'] = 'Показывать кнопку перехода к курсу в списке курсов';
$string['courselistinghowgoto_desc'] = 'С помощью этой настройки вы можете контролировать, будет ли отображаться кнопка «Перейти к курсу» в списке курсов или нет. Если эта настройка отключена, пользователь все равно сможет перейти к курсу, щелкнув по названию курса или его изображению.';
$string['courselistinghowimage'] = 'Показывать изображение курса в списке курсов';
$string['courselistinghowimage_desc'] = 'С помощью этой настройки вы можете контролировать, будет ли отображаться изображение курса в списке курсов или нет.';
$string['courselistinghowpopup'] = 'Показывать всплывающее окно с подробностями о курсе в списке курсов';
$string['courselistinghowpopup_desc'] = 'С помощью этой настройки вы можете контролировать, будет ли отображаться кнопка «Подробнее» в списке курсов или нет. С помощью этой кнопки пользователь может открыть всплывающее окно с подробной информацией, содержащее краткое содержание курса, контакты и поля курса. Всплывающее окно будет содержать эту информацию независимо от того, включена ли она на самой карточке/строке курса или нет.';
$string['courselistinghowprogress'] = 'Показывать ход завершения курса в списке курса';
$string['courselistinghowprogress_desc'] = 'С помощью этой настройки вы можете контролировать, будет ли отображаться прогресс завершения курса в списке курсов или нет.';
$string['courselistinghowshortname'] = 'Показывать краткое название курса в списке курсов';
$string['courselistinghowshortname_desc'] = 'С помощью этой настройки вы можете контролировать, будет ли отображаться краткое название курса в списке курсов или нет.';
$string['courselistingnosummary'] = 'Курс не содержит описания';
$string['courselistingpopup'] = 'Подробнее';
$string['courselistingpresentation'] = 'Представление списка курсов';
$string['courselistingpresentation_cards'] = 'Карточки курсов';
$string['courselistingpresentation_desc'] = 'С помощью этой настройки вы можете изменить внешний вид списка курсов на странице списка категорий и на главной странице сайта. В качестве альтернативы тому, как они представлены в ядре Moodle, вы можете представить список курсов в виде карточек курсов (аналогично карточкам курсов на странице «Мои курсы») или в виде списка курсов (аналогично списку курсов на странице «Мои курсы» ).';
$string['courselistingpresentation_list'] = 'Список курсов';
$string['courselistingpresentation_nochange'] = 'Кошмар дизайнера (без изменений, как сделано в ядре Moodle)';
$string['courselistingpresentation_note'] = 'Обратите внимание: если вы включите карточки курсов или списки курсов, настройка <a href="{$a->url1}">«курсов на странице»</a> по-прежнему будет соблюдаться и будет определять, сколько карточек/строк будет отображаться. Однако настройка <a href="{$a->url2}">«Максимальное количество курсов с описанием»</a> больше не действует — все курсы будут показаны с полной информацией. Не устанавливайте слишком высокое значение <a href="{$a->url1}">«курсов на странице»</a>, чтобы избежать длительной загрузки страниц с большим количеством курсов.';
$string['courselistingshowcontacts'] = 'Показывать контакты курса в списке курсов';
$string['courselistingshowcontacts_desc'] = 'С помощью этой настройки вы можете контролировать, будут ли отображаться фотографии контактов курса в списке курсов или нет. Обратите внимание: фотографии контактов отображаются вместе с изображением курса, поэтому представление контактов курса без представления изображения курса невозможно.';
$string['courselistingummary'] = 'Описание курса';
$string['courselistingviewprofile'] = 'Просмотреть профиль';
$string['coursemanagementheading'] = 'Управление курсами';
$string['courseoverviewheading'] = 'Блок обзора курсов';
$string['courseoverviewshowcourseimagessetting'] = 'Показывать изображения курса';
$string['courseoverviewshowcourseimagessetting_desc'] = 'С помощью этой настройки вы можете контролировать, будет ли изображение курса видно в блоке обзора курсов или нет. Можно выбрать разные настройки для вида «Карточка», вида «Сводка» и вида «Список».';
$string['courseoverviewshowprogresssetting'] = 'Показывать прогресс завершения курса';
$string['courseoverviewshowprogresssetting_desc'] = 'С помощью этой настройки вы можете контролировать, будет ли прогресс завершения курса виден в блоке обзора курсов или нет.';
$string['courserelatedhintsheading'] = 'Подсказки, связанные с курсом';
$string['coursestab'] = 'Курсы';
$string['coursetab'] = 'Курс';
$string['cssh5pheading'] = 'Сырой CSS для H5P';
$string['cssh5psetting'] = 'Сырой CSS для H5P';
$string['cssh5psetting_desc'] = 'Используйте это поле для указания кода CSS, который будет применяться к представлению содержимого H5P с помощью mod_h5p и mod_hvp. Пожалуйста, ознакомьтесь с типами содержимого H5P, чтобы найти необходимые селекторы CSS.';
$string['customfontsfileurlpersistent'] = 'URL (постоянный)';
$string['customfontsfileurlrevisioned'] = 'URL (обновляемый)';
$string['customfontsheading'] = 'Пользовательские шрифты';
$string['customfontslistsetting'] = 'Список пользовательских шрифтов';
$string['customfontslistsetting_desc'] = 'Это список шрифтов, которые вы загрузили в область файлов пользовательских шрифтов. Приведенные фрагменты CSS можно использовать для добавления этих шрифтов в ваш пользовательский SCSS. Обратите внимание, что вам придется самостоятельно позаботиться о значении формата шрифта, а также о свойствах font-family, font-style и font-weight CSS, поскольку Boost Union еще не умеет анализировать файлы шрифтов.';
$string['customfontssetting'] = 'Пользовательские шрифты';
$string['customfontssetting_desc'] = 'С помощью этой настройки вы можете загрузить в тему пользовательские шрифты. Преимущество загрузки шрифтов в эту область файлов заключается в том, что эти шрифты могут быть доставлены без проверки, что пользователь вошел в систему, и могут быть использованы как локально установленные шрифты везде на сайте. Как только вы загрузите хотя бы один шрифт в эту область файлов и сохраните настройки, под ними появится список, в котором будут приведены фрагменты кода CSS, которые вы можете использовать в качестве шаблона для ссылок на определенные шрифты в вашем пользовательском SCSS.';
$string['dashboardtab'] = 'Личный кабинет / Мои курсы';
$string['dontchange'] = 'Ничего не менять';
$string['drawerwidthheading'] = 'Ширина боковой панели';
$string['emailbrandinghtmldemobody'] = '<p>Тело электронного письма начинается здесь.</p><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p><p>Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.</p><p>Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.</p><p>Тело электронного письма заканчивается здесь.</p>';
$string['emailbrandinghtmlheading'] = 'Предварительный просмотр письма HTML';
$string['emailbrandinghtmlintro'] = 'Это предварительный просмотр электронного письма HTML, основанного на префиксах и суффиксах фирменного стиля, которые в настоящее время установлены в языковом пакете.';
$string['emailbrandinghtmlnopreview'] = 'До сих пор электронная почта HTML не была настроена с учетом этой функции. Электронная почта будет составляться и рассылаться в обычном режиме.';
$string['emailbrandinginstruction'] = 'Как это сделать';
$string['emailbrandinginstruction0'] = 'С помощью этой функции Boost Union вы можете применить фирменный стиль ко всем электронным письмам, которые рассылает Moodle.';
$string['emailbrandinginstructionli1'] = 'Перейдите на страницу <a href="{$a->url}" target="_blank">настроек языковых параметров</a>, чтобы открыть языковой пакет <em>{$a->lang}</em> для редактирования.';
$string['emailbrandinginstructionli2'] = 'Найдите и измените эти строки в языковом пакете <code>theme_boost_union</code>:';
$string['emailbrandinginstructionli2li1'] = '<code>templateemailhtmlprefix</code>: Этот фрагмент будет добавлен <em>в начало / перед телом</em> всех <em>электронных писем HTML</em>, которые рассылает Moodle.';
$string['emailbrandinginstructionli2li2'] = '<code>templateemailhtmlsuffix</code>: Этот фрагмент будет добавлен <em>в конце / после тела</em> всех <em>электронных писем HTML</em>, которые рассылает Moodle.';
$string['emailbrandinginstructionli2li3'] = '<code>templateemailtextprefix</code>: Этот фрагмент будет добавлен <em>в начало / перед телом</em> всех <em>электронных писем с простым текстом</em>, которые рассылает Moodle.';
$string['emailbrandinginstructionli2li4'] = '<code>templateemailtextsuffix</code>: Этот фрагмент будет добавлен <em>в конце / после тела</em> всех <em>электронных писем с простым текстом</em>, которые рассылает Moodle.';
$string['emailbrandinginstructionli3'] = 'Сохраните изменения в языковом пакете.';
$string['emailbrandinginstructionli4'] = 'Вернитесь на эту страницу и ниже посмотрите предварительный текст электронного письма.';
$string['emailbrandingintroheading'] = 'Вводная часть';
$string['emailbrandingintronote'] = 'Обратите внимание: это расширенная функциональность, которая использует некоторые обходные пути для обеспечения возможностей фирменного стиля электронной почты. Пожалуйста, внимательно следуйте инструкциям.';
$string['emailbrandingpitfalls'] = 'Подводные камни';
$string['emailbrandingpitfalls0'] = 'При использовании этой функции есть некоторые подводные камни, о которых вы должны знать:';
$string['emailbrandingpitfallsli1'] = 'Обязательным условием является изменение строк языкового пакета <em>текущего языка по умолчанию</em> этого сайта. Даже если у вас установлено несколько языковых пакетов, эффект будет иметь только изменение языка по умолчанию.';
$string['emailbrandingpitfallsli2'] = 'Учесть язык получателя невозможно. Поэтому в фрагментах фирменного стиля электронной почты следует использовать термины, не зависящие от языка.';
$string['emailbrandingpitfallsli3'] = 'Если в будущем вы измените язык сайта по умолчанию, вам придется перенести измененные строки языкового пакета в новый языковой пакет по умолчанию.';
$string['emailbrandingpitfallsli4'] = 'В обычной электронной почте после префикса и перед суффиксным фрагментом автоматически добавляется разрыв строки и пустая строка. Это делается для того, чтобы суффикс и префикс не приклеивались непосредственно к телу электронной почты.';
$string['emailbrandingpitfallsli5'] = 'В электронной почте HTML префикс и суффикс добавляются непосредственно перед и над телом электронной почты. Это делается для того, чтобы вы могли легко работать с HTML-тегами, однако вам придется самостоятельно обрабатывать все интервалы вокруг тела письма.';
$string['emailbrandingpitfallsli6'] = 'В HTML-почте вы можете без проблем открыть HTML-тег в префиксном фрагменте и закрыть его в суффиксном фрагменте. Только не забудьте создать правильный HTML в результирующем письме.';
$string['emailbrandingtab'] = 'Фирменный стиль эл. почты';
$string['emailbrandingtextdemobody'] = 'Тело электронного письма начинается здесь.

Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.

Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.

Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.

Тело электронного письма заканчивается здесь.';
$string['emailbrandingtextheading'] = 'Предварительный просмотр электронного письма с простым текстом';
$string['emailbrandingtextintro'] = 'Это предварительный просмотр электронной почты, основанной на префиксах и суффиксах фирменного стиля, которые в настоящее время установлены в языковом пакете.';
$string['emailbrandingtextnopreview'] = 'До сих пор обычные текстовые электронные письма не были настроены с учетом этой функции. Электронная почта будет составляться и отправляться в обычном режиме.';
$string['enableaboutussetting'] = 'Включить страницу «О нас»';
$string['enableaccessibilitydeclarationsetting'] = 'Включить страницу декларации доступности';
$string['enableaccessibilitydeclarationsetting_desc'] = 'С помощью этого параметра вы можете включить страницу декларации доступности. Она будет вести себя точно так же, как <a href="{$a->url}">другие статические страницы</a> в Boost Union.';
$string['enableaccessibilitysupportfooterbuttonsetting'] = 'Включить кнопку поддержки доступности';
$string['enableaccessibilitysupportfooterbuttonsetting_desc'] = 'С помощью этого параметра вы можете добавить ссылку на страницу поддержки доступности в виде плавающего значка специальных возможностей над нижним колонтитулом (вопросительный знак).';
$string['enableaccessibilitysupportsetting'] = 'Включить страницу поддержки доступности';
$string['enableaccessibilitysupportsetting_desc'] = 'С помощью этого параметра вы можете включить страницу поддержки доступности. Она будет вести себя точно так же, как <a href="{$a->url}">другие статические страницы</a> в Boost Union.';
$string['enablecontactsetting'] = 'Включить страницу контактов';
$string['enablefooterbutton'] = 'Включить кнопку нижнего колонтитула';
$string['enablefooterbutton_desc'] = 'Под «кнопкой в нижнем колонтитуле» подразумевается круг в нижней части страницы, содержащий вопросительный знак.<br />После нажатия на него на странице появляется наложенное поле. В зависимости от конфигурации сайта Moodle в этой накладке отображается несколько ссылок (например, «Справка и документация» или «Сводка о сохранении данных»).<br /> С помощью этой настройки вы можете управлять тем, показывать или не показывать кнопку нижнего колонтитула внизу страницы.';
$string['enablefooterbuttonboth'] = 'Включить на компьютере, планшете и мобильном';
$string['enablefooterbuttondesktop'] = 'Включить только на компьютере и планшете, скрыть на мобильном (без изменений, как задано в ядре Moodle)';
$string['enablefooterbuttonhidden'] = 'Скрыть на всех устройствах';
$string['enablefooterbuttonmobile'] = 'Включить только на мобильном, скрыть на компьютере и планшете';
$string['enablehelpsetting'] = 'Включить страницу справки';
$string['enableimprintsetting'] = 'Включить выходные данные';
$string['enablemaintenancesetting'] = 'Включить страницу с информацией о техническом обслуживании';
$string['enableofferssetting'] = 'Включить страницу предложений';
$string['enablepage1setting'] = 'Включить общую страницу 1';
$string['enablepage2setting'] = 'Включить общую страницу 2';
$string['enablepage3setting'] = 'Включить общую страницу 3';
$string['error:infobannerdismissnonotdismissible'] = 'Данный информационный баннер не может быть закрыт';
$string['error:infobannerdismissnonotvalid'] = 'Номер информационного баннера не действителен';
$string['error:smartmenusmenuitemnotfound'] = 'Элемент умного меню не найден';
$string['error:smartmenusmenunotfound'] = 'Умное меню не найдено';
$string['extscssgithubfilepath_example'] = 'Пример: Если вы видите файл в своем аккаунте Github по адресу https://github.com/moodle-an-hochschulen/moodle-theme_boost_union-extscsstest/blob/main/extscss.scss, то путь к нему будет <em>/extscss.scss</em>.';
$string['extscssgithubpostfilepath'] = 'Путь к файлу внешнего завершающего SCSS на Github';
$string['extscssgithubpostfilepath_desc'] = 'Путь в частном репозитории Github, где находится файл завершающего SCSS.';
$string['extscssgithubprefilepath'] = 'Путь к файлу внешнего начального SCSS на Github';
$string['extscssgithubprefilepath_desc'] = 'Путь в частном репозитории Github, где находится файл начального SCSS.';
$string['extscssgithubrepo'] = 'Репозиторий Github API внешнего SCSS';
$string['extscssgithubrepo_desc'] = 'Частный репозиторий Github, в котором содержатся файлы SCSS.';
$string['extscssgithubrepo_example'] = 'Пример: Если вы видите файл в своем аккаунте Github по адресу https://github.com/moodle-an-hochschulen/moodle-theme_boost_union-extscsstest/blob/main/extscss.scss, то репозиторий будет <em>moodle-theme_boost_union-extscsstest</em>.';
$string['extscssgithubtoken'] = 'API-токен Github внешнего SCSS';
$string['extscssgithubtoken_desc'] = 'API-токен Github, который будет использоваться для получения кода SCSS из данного частного репозитория Github.';
$string['extscssgithubtoken_docs'] = 'Перейдите на <a href="https://github.com/settings/tokens">вашу страницу персональных токенов Github</a> чтобы сгенерировать API-токен и ознакомиться с официальной документацией.';
$string['extscssgithubuser'] = 'Пользователь Github API внешнего SCSS';
$string['extscssgithubuser_desc'] = 'Пользователь Github API или организация, владеющая частным репозиторием Github.';
$string['extscssgithubuser_example'] = 'Пример: Если вы видите файл в своем аккаунте Github по адресу https://github.com/moodle-an-hochschulen/moodle-theme_boost_union-extscsstest/blob/main/extscss.scss, то пользователем будет <em>moodle-an-hochschulen</em>.';
$string['extscssheading'] = 'Внешний SCSS';
$string['extscssheading_desc'] = 'В дополнение к вышеуказанным настройкам необработанного SCSS, Boost Union может загружать SCSS из внешнего источника. Он включается перед SCSS-кодом, который определен выше, что означает, что вы можете управлять централизованной внешней кодовой базой SCSS и по-прежнему вносить в нее локальные SCSS-дополнения.';
$string['extscssheading_drop'] = 'Если Boost Union по каким-либо причинам не может получить внешний SCSS-файл, он просто проигнорирует его, чтобы избежать проблем с компиляцией SCSS и поломки отображения.';
$string['extscssheading_instr'] = 'Инструкции:';
$string['extscssheading_prepost'] = 'Как и настройки необработанного SCSS, приведенные выше, внешний SCSS разделен на две части: начальный и завершающий SCSS. Начальный SCSS может использоваться для инициализации переменных SCSS, а завершающий SCSS используется для вашего фактического кода SCSS.';
$string['extscssheading_sources'] = 'Вы можете настроить Boost Union на получение внешнего SCSS-файла либо из публичного URL-адреса загрузки (доступ к которому будет получен с помощью неаутентифицированного запроса cURL), либо из частного репозитория Github (доступ к которому будет получен с помощью API-токена Github).';
$string['extscssheading_structure'] = 'Внешний SCSS должен быть предоставлен в виде файла с простым текстом, без заголовков и колонтитулов, содержащего только SCSS-код.';
$string['extscssheading_task'] = 'Существует <a href="{$a}">запланированная задача theme_boost_union\\task\\purge_cache</a>, которая отключена по умолчанию, но которую можно включить, если вы хотите, чтобы Boost Union периодически получал и компилировал внешний SCSS-код.';
$string['extscsssource'] = 'Источник внешнего SCSS';
$string['extscsssource_desc'] = 'Выберите тип источника, из которого вы хотите получить внешний SCSS.';
$string['extscsssourcedownload'] = 'Публичный URL-адрес для загрузки';
$string['extscsssourcegithub'] = 'Частный репозиторий Github';
$string['extscsssourcenone'] = 'Нет';
$string['extscssurlpost'] = 'URL-адрес загрузки внешнего завершающего SCSS';
$string['extscssurlpost_desc'] = 'Публичный URL-адрес загрузки, с которого должен быть получен внешний завершающий SCSS.';
$string['extscssurlpre'] = 'URL-адрес загрузки внешнего начального SCSS';
$string['extscssurlpre_desc'] = 'Публичный URL-адрес загрузки, с которого должен быть получен внешний начальный SCSS.';
$string['extscssvalidationsetting'] = 'Проверка внешнего SCSS';
$string['extscssvalidationsetting_desc'] = 'Если эта настройка включена, внешний SCSS проверяется на возможность компиляции перед добавлением в стек SCSS. Внешний SCSS-код, который не может быть скомпилирован, молча игнорируется и не используется. Однако эта проверка выполняется только для внешнего SCSS-кода, она не выполняется для объединенного стека SCSS, который будет результатом интеграции внешних SCSS. Это означает, что как только вы используете переменные SCSS из ядра Moodle или Bootstrap в вашем внешнем SCSS, вы должны отключить проверку и самостоятельно убедиться в том, что код SCSS является корректным, чтобы избежать поломки интерфейса.';
$string['faviconheading'] = 'Фавикон';
$string['faviconheading_desc'] = 'Обратите внимание: Boost Union имеет свой собственный загружаемый фавикон, а не использует из <a href="{$a}">настройки фавикон ядра Moodle</a>.<br />Boost Union позволяет вам переопределять загруженный фавикон с учетом своих стилей.';
$string['faviconsetting'] = 'Фавикон';
$string['faviconsetting_desc'] = 'Здесь вы можете загрузить пользовательское изображение (в формате .ico или .png), которое будет отображаться в браузере в качестве фавикон вашего сайта Moodle. Если пользовательский favicon не загружен, будет использоваться стандартный фавикон Moodle.';
$string['flavoursactivityiconcoloradministration'] = 'Цвет значка для назначения «Управление»';
$string['flavoursactivityiconcoloradministration_help'] = 'Эта настройка переопределит цвет значка назначения «Управление», заданный в настройках внешнего вида Boost Union.';
$string['flavoursactivityiconcolorassessment'] = 'Цвет значка для назначения «Оценивание»';
$string['flavoursactivityiconcolorassessment_help'] = 'Эта настройка переопределит цвет значка назначения «Оценивание», заданный в настройках внешнего вида Boost Union.';
$string['flavoursactivityiconcolorcollaboration'] = 'Цвет значка для назначения «Сотрудничество»';
$string['flavoursactivityiconcolorcollaboration_help'] = 'Эта настройка переопределит цвет значка назначения «Сотрудничество», заданный в настройках внешнего вида Boost Union.';
$string['flavoursactivityiconcolorcommunication'] = 'Цвет значка для назначения «Коммуникация»';
$string['flavoursactivityiconcolorcommunication_help'] = 'Эта настройка переопределит цвет значка назначения «Коммуникация», заданный в настройках внешнего вида Boost Union.';
$string['flavoursactivityiconcolorcontent'] = 'Цвет значка для назначения «Контент»';
$string['flavoursactivityiconcolorcontent_help'] = 'Эта настройка переопределит цвет значка назначения «Контент», заданный в настройках внешнего вида Boost Union.';
$string['flavoursactivityiconcolorinteractivecontent'] = 'Цвет значка для назначения «Интерактивный контент»';
$string['flavoursactivityiconcolorinteractivecontent_help'] = 'Эта настройка переопределит цвет значка назначения «Интерактивный контент», заданный в настройках внешнего вида Boost Union.';
$string['flavoursactivityiconcolorinterface'] = 'Цвет значка для назначения «Интерфейс»';
$string['flavoursactivityiconcolorinterface_help'] = 'Эта настройка переопределит цвет значка назначения «Интерфейс», заданный в настройках внешнего вида Boost Union.';
$string['flavoursappliesto'] = 'Применить к';
$string['flavoursapplytocategories'] = 'Применить к категории курсов';
$string['flavoursapplytocategories_help'] = 'Здесь вы определяете, следует ли применять этот стиль к категориям курсов.';
$string['flavoursapplytocategories_ids'] = 'Категории курсов';
$string['flavoursapplytocategories_ids_help'] = 'Здесь вы определяете одну или несколько конкретных категорий курсов, к которым будет применяться данный стиль. Когда отображаемая страница Moodle будет находиться в одной из указанных категорий курса, стиль будет применен.';
$string['flavoursapplytocohorts'] = 'Применить к глобальной группе';
$string['flavoursapplytocohorts_help'] = 'Здесь вы определяете, следует ли применять этот стиль к глобальным группам.';
$string['flavoursapplytocohorts_ids'] = 'Глобальные группы';
$string['flavoursapplytocohorts_ids_help'] = 'Здесь вы определяете одну или несколько конкретных глобальных групп, к которым следует применить этот стиль. Как только пользователь становится членом одной из настроенных глобальных групп, стиль применяется.<br /><br />Обратите внимание, что если вы указываете более одной глобальной группы, пользователю не нужно быть членом всех их одновременно.<br /><br />Пожалуйста, обратите внимание, что на текущем этапе внедрения группы категорий обрабатываются так же, как если бы они были системными глобальными группами.';
$string['flavoursbackgroundimage'] = 'Фоновое изображение';
$string['flavoursbackgroundimage_help'] = 'С помощью этого параметра стиль будет переопределять фоновое изображение, которое задано в настройках внешнего вида Boost Union.';
$string['flavoursbackgroundimageposition'] = 'Положение фонового изображения';
$string['flavoursbackgroundimageposition_help'] = 'Этот параметр переопределит положение фонового изображения, заданное в настройках внешнего вида Boost Union.';
$string['flavoursbacktooverview'] = 'Вернуться к списку стилей';
$string['flavoursbootstrapcolordanger'] = 'Цвет Bootstrap для «Опасности»';
$string['flavoursbootstrapcolordanger_help'] = 'Этот параметр переопределит цвет Bootstrap для «Опасности», заданный в настройках внешнего вида Boost Union.';
$string['flavoursbootstrapcolorinfo'] = 'Цвет Bootstrap для «Информации»';
$string['flavoursbootstrapcolorinfo_help'] = 'Этот параметр переопределит цвет Bootstrap для «Информации», заданный в настройках внешнего вида Boost Union.';
$string['flavoursbootstrapcolorsuccess'] = 'Цвет Bootstrap для «Успеха»';
$string['flavoursbootstrapcolorsuccess_help'] = 'Этот параметр переопределит цвет Bootstrap для «Успеха», заданный в настройках внешнего вида Boost Union.';
$string['flavoursbootstrapcolorwarning'] = 'Цвет Bootstrap для «Предупреждения»';
$string['flavoursbootstrapcolorwarning_help'] = 'Этот параметр переопределит цвет Bootstrap для «Предупреждения», заданный в настройках внешнего вида Boost Union.';
$string['flavoursbrandcolor'] = 'Фирменный цвет';
$string['flavoursbrandcolor_help'] = 'Этот параметр переопределит фирменный цвет, заданный в настройках внешнего вида Boost Union.';
$string['flavourscreateflavour'] = 'Создать стиль';
$string['flavourscustomscss'] = 'Необработанный SCSS';
$string['flavourscustomscss_help'] = 'С помощью этой настройки вы можете написать собственный SCSS-код для дополнения. Он будет добавлен в стек CSS-кода, который отправляется браузеру сразу после применения дополнения.';
$string['flavoursdelete'] = 'Удалить';
$string['flavoursdeleteconfirmation'] = 'Вы действительно хотите удалить стиль <em>{$a}</em>?';
$string['flavoursdeleteflavour'] = 'Удалить стиль';
$string['flavoursdescription'] = 'Описание';
$string['flavoursdescription_help'] = 'Описание стиля используется только для того, чтобы вы могли узнать конкретный стиль в списке стилей.';
$string['flavoursedit'] = 'Редактировать';
$string['flavourseditflavour'] = 'Редактировать стиль';
$string['flavoursfavicon'] = 'Фавикон';
$string['flavoursfavicon_help'] = 'С помощью этой настройки стиль будет переопределять фавикон, который определен в настройках внешнего вида Boost Union.';
$string['flavoursflavours'] = 'Стили';
$string['flavoursgeneralsettings'] = 'Общее';
$string['flavoursincludesubcategories'] = 'Включить подкатегории';
$string['flavoursincludesubcategories_help'] = 'При включенном параметре стиль будет также применен к подкатегориям выбранных категорий.';
$string['flavourslogo'] = 'Логотип';
$string['flavourslogo_help'] = 'С помощью этой настройки стиль будет переопределять логотип, который задан в настройках внешнего вида Boost Union.';
$string['flavourslogocompact'] = 'Компактный логотип';
$string['flavourslogocompact_help'] = 'С помощью этой настройки стиль будет переопределять компактный логотип, который задан в настройках внешнего вида Boost Union.';
$string['flavoursnothingtodisplay'] = 'Еще не создано ни одного стиля. Пожалуйста, создайте свой первый стиль, чтобы начать работу.';
$string['flavoursnotificationcreated'] = 'Стиль создан';
$string['flavoursnotificationdeleted'] = 'Стиль удален';
$string['flavoursnotificationedited'] = 'Стиль изменен';
$string['flavoursoverview_desc'] = '<p>Стили Boost Union дают возможность переопределять определенные настройки внешнего вида и настроек Moodle в определенных контекстах. На этой странице вы можете создавать стили и управлять ими.</p><p>В рамках каждого стиля вы определяете, должен ли он применяться к определенным категориям курсов или определенным глобальным группам. Затем, во время отображения каждой страницы Moodle, Boost Union проверяет, применяется ли какой-либо стиль. Обратите внимание, что при каждом отображении страницы Moodle применяется только первый подходящий стиль в списке, а остальные стили игнорируются. Таким образом, порядок расположения стилей на этой странице является ключевым.</p><p>Обратите внимание, что после каждого изменения, которое вы вносите в набор стилей, кэш темы очищается. Это необходимо для того, чтобы убедиться, что все объекты поставляются в браузер правильно и в актуальном состоянии.</p>';
$string['flavourspreview'] = 'Предварительный просмотр';
$string['flavourspreviewblindtext'] = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Nunc id cursus metus aliquam eleifend mi in nulla. Felis imperdiet proin fermentum leo vel orci porta. Sed nisi lacus sed viverra tellus in hac habitasse. Vivamus arcu felis bibendum ut. Nisi porta lorem mollis aliquam ut porttitor. Odio euismod lacinia at quis risus sed vulputate odio. Sed felis eget velit aliquet sagittis id consectetur purus. Nec ullamcorper sit amet risus nullam eget. Pellentesque sit amet porttitor eget dolor. Cursus mattis molestie a iaculis at erat pellentesque.';
$string['flavourspreviewflavour'] = 'Предварительный просмотр стиля';
$string['flavourstitle'] = 'Название';
$string['flavourstitle_help'] = 'Название стиля используется только для того, чтобы вы могли найти конкретный стиль в списке стилей.';
$string['footerheading'] = 'Нижний колонтитул';
$string['footersuppresschatsetting'] = 'Убрать ссылку «Общение с участниками курса»';
$string['footersuppresschatsetting_desc'] = 'С помощью этой настройки можно полностью убрать ссылку «Общение с участниками курса» в нижнем колонтитуле. В противном случае эта ссылка будет появляться в курсах, как только в настройках курса будет добавлена комната общения.';
$string['footersuppresscontactsetting'] = 'Убрать ссылку «Служба поддержки сайта»';
$string['footersuppresscontactsetting_desc'] = 'С помощью этой настройки вы можете полностью убрать ссылку «Служба поддержки сайта» в нижнем колонтитуле. В противном случае эта ссылка будет отображаться, если установлен параметр <a href="{$a->url}">Контакты службы поддержки</a>.';
$string['footersuppresshelpsetting'] = 'Убрать ссылку «Документация для этой страницы»';
$string['footersuppresshelpsetting_desc'] = 'С помощью этой настройки вы можете полностью убрать ссылку «Документация для этой страницы» в нижнем колонтитуле. В противном случае эта ссылка будет появляться, если установлен <a href="{$a->url}">адрес документации Moodle</a>.';
$string['footersuppressiconssetting'] = 'Убрать иконки перед ссылками в нижнем колонтитуле';
$string['footersuppressiconssetting_desc'] = 'С помощью этой настройки вы можете полностью убрать иконки перед ссылками нижнего колонтитула. Для ссылки «Документация для этой страницы» используется значок книги, для ссылки «Услуги и поддержка» - спасательный круг и т. д.';
$string['footersuppresslogininfosetting'] = 'Убрать информацию о входе в систему';
$string['footersuppresslogininfosetting_desc'] = 'С помощью этой настройки можно полностью отключить в нижнем колонтитуле отображение информации о входе в систему. В противном случае эта информация будет отображать ссылки на профиль пользователя и на страницу выхода из системы.';
$string['footersuppresspoweredsetting'] = 'Убрать ссылку «На платформе Moodle»';
$string['footersuppresspoweredsetting_desc'] = 'С помощью этой настройки вы можете полностью убрать ссылку «На платформе Moodle» в нижнем колонтитуле. В противном случае это сообщение будет отображать информацию о том, что на этом сайте используется Moodle, и предоставлять ссылку на Moodle HQ.';
$string['footersuppressservicessetting'] = 'Убрать ссылку «Услуги и поддержка»';
$string['footersuppressservicessetting_desc'] = 'С помощью этой настройки можно полностью убрать ссылку «Услуги и поддержка» в нижнем колонтитуле. В противном случае эта ссылка будет отображать администраторам ссылку на <a href="{$a->url}">Контакты службы поддержки</a>.';
$string['footersuppressstandardfooter'] = 'Подавление вывода плагина «{$a}» в нижний колонтитул';
$string['footersuppressstandardfooter_desc'] = 'С помощью этой настройки вы можете полностью подавить вывод плагина «{$a}» в нижний колонтитул. Плагины (даже если они поставляются с ядром Moodle, но технически все равно являются плагинами) могут добавлять дополнительное содержимое в нижний колонтитул, реализуя определенный хук или функцию. Плагин реализовал этот хук/функцию и может добавлять содержимое в нижний колонтитул при определенных обстоятельствах.';
$string['footersuppressstandardfootercore'] = 'Подавление вывода компонента ядра «{$a}» в нижний колонтитул';
$string['footersuppressstandardfootercore_desc'] = 'С помощью этой настройки вы можете полностью подавить вывод компонента ядра «{$a}» в нижний колонтитул. Компоненты ядра могут добавлять дополнительное содержимое в нижний колонтитул, реализуя определенный хук или функцию. Компонент реализовал этот хук/функцию и может добавлять содержимое в нижний колонтитул при определенных обстоятельствах.';
$string['footersuppressthemeswitchsetting'] = 'Убрать ссылки на переключатель тем';
$string['footersuppressthemeswitchsetting_desc'] = 'С помощью этой настройки вы можете полностью убрать ссылки на переключатель тем в нижнем колонтитуле. Система, лежащая в основе тем для конкретных устройств, была удалена в Moodle 4.3, но процедуры вывода все еще существуют, так что лучше перестраховаться, чем потом жалеть.';
$string['footersuppressusertoursetting'] = 'Убрать ссылку «Начать тур для пользователя на этой странице».';
$string['footersuppressusertoursetting_desc'] = 'С помощью этой настройки вы можете полностью убрать ссылку «Начать тур для пользователя на этой странице» в нижнем колонтитуле. В противном случае эта ссылка предоставит возможность начать пользовательский тур на конкретной странице.';
$string['footertab'] = 'Нижний колонтитул';
$string['footnoteheading'] = 'Сноска';
$string['footnotesetting'] = 'Сноска';
$string['footnotesetting_desc'] = 'Все, что вы добавите в эту текстовую область, будет отображаться в конце страницы, в нижнем колонтитуле (не в плавающем колонтитуле) на каждой странице, которая использует макеты "drawers", "columns2" или "login". Содержание в этой области может быть, например, авторским правом, условиями использования или названием вашей организации.<br/>Если вы хотите снова удалить текст колонтитула, просто освободите текстовую область.';
$string['githubissueslink'] = '<a href="https://github.com/moodle-an-hochschulen/moodle-theme_boost_union/issues">Проблемы на Github</a>';
$string['h5pcontentmaxwidthsetting'] = 'Максимальная ширина банка контента H5P';
$string['h5pcontentmaxwidthsetting_desc'] = 'С помощью этой настройки вы можете изменить ширину банка контента H5P в Moodle без ручной модификации SCSS. Эта ширина используется для редактора H5P внутри банка контента. Она <em>не</em> используется для ширины элемента H5P. По умолчанию Moodle использует максимальную ширину банка контента H5P, равную 960px. Вы можете ввести другие значения, основанные на пикселях, например 1200px, но вы также можете ввести значение, основанное на процентах, например 100% или значение viewport-width, например 90vw.';
$string['h5ptab'] = 'H5P';
$string['helpcontentsetting'] = 'Содержание страницы справки';
$string['helpcontentsetting_desc'] = 'В этом параметре вы можете добавить расширенный текстовый контент, который будет отображаться на странице справки.';
$string['helpdisabled'] = 'Страница справки отключена для этого сайта. Здесь не на что смотреть.';
$string['helpheading'] = 'Справка';
$string['helplinkpositionboth'] = 'Добавить ссылку на страницу справки в сноске и на иконку «Знак вопроса» в нижнем колонтитуле';
$string['helplinkpositionfooter'] = 'Добавить ссылку на страницу справки на иконку «Знак вопроса» в нижнем колонтитуле';
$string['helplinkpositionfootnote'] = 'Добавить ссылку на страницу справки в колонтитул';
$string['helplinkpositionnone'] = 'Не показывать автоматически ссылку на страницу справки';
$string['helplinkpositionsetting'] = 'Расположение ссылки на страницу справки';
$string['helplinkpositionsetting_desc'] = 'В этом параметре вы можете указать, должна ли ссылка на страницу справки автоматически добавляться на страницы Moodle. Если вы не хотите показывать ссылку автоматически, вы можете добавить ссылку на {$a->url} из любого места в Moodle вручную.';
$string['helppagetitledefault'] = 'Справка';
$string['helppagetitlesetting'] = 'Заголовок страницы справки';
$string['helppagetitlesetting_desc'] = 'Этот параметр позволяет задать заголовок страницы справки. Этот текст также будет использоваться в качестве текста ссылки на страницу справки, если параметр «Расположение ссылки на страницу справки» настроен соответствующим образом.';
$string['hidenodesprimarynavigationsetting'] = 'Скрыть узлы в основной навигации';
$string['hidenodesprimarynavigationsetting_desc'] = 'С помощью этого параметра можно скрыть один или несколько узлов из основной навигации.<br /><br />
Обратите внимание: здесь вы можете просто удалить узлы навигации. Но если вы хотите добавить собственные узлы навигации, рассмотрите возможность использования <a href="{$a->url}">функций умного меню Boost Union</a>.';
$string['imprintcontentsetting'] = 'Выходные данные';
$string['imprintcontentsetting_desc'] = 'В этом параметре вы можете добавить расширенный текстовый контент, который будет отображаться на странице выходных данных.';
$string['imprintdisabled'] = 'Страница выходных данных отключена для этого сайта. Здесь не на что смотреть.';
$string['imprintheading'] = 'Выходные данные';
$string['imprintlinkpositionboth'] = 'Добавить ссылку на страницу выходных данных в колонтитул и на значок нижнего колонтитула (знак вопроса)';
$string['imprintlinkpositionfooter'] = 'Добавить ссылку на страницу выходных данных на значок нижнего колонтитула (знак вопроса)';
$string['imprintlinkpositionfootnote'] = 'Добавить ссылку на страницу выходных данных в колонтитул';
$string['imprintlinkpositionnone'] = 'Не показывать автоматически ссылку на страницу выходных данных';
$string['imprintlinkpositionsetting'] = 'Позиция ссылки на выходные данные';
$string['imprintlinkpositionsetting_desc'] = 'В этом параметре вы можете указать, должна ли ссылка на страницу выходных данных автоматически добавляться на страницы Moodle. Если вы не хотите показывать ссылку автоматически, вы можете добавить ссылку на {$a->url} из любого места в Moodle вручную.';
$string['imprintpagetitledefault'] = 'Выходные данные';
$string['imprintpagetitlesetting'] = 'Заголовок страницы выходных данных';
$string['imprintpagetitlesetting_desc'] = 'Этот параметр позволяет задать название страницы выходных данных. Этот текст также будет использоваться в качестве текста ссылки на страницу выходных данных, если параметр «Позиция ссылки на выходные данные» настроен соответствующим образом.';
$string['infobannerbsclasssetting'] = 'Класс Bootstrap информационного баннера {$a->no}';
$string['infobannerbsclasssetting_desc'] = 'С помощью этой настройки вы можете выбрать класс Bootstrap,который будет применен к информационному баннеру {$a->no}. Если вы выберете опцию «Без цвета Bootstrap», то информационный баннер будет выводиться без какого-либо определенного цвета Bootstrap, что даст вам свободу стилизовать баннер самостоятельно в текстовом редакторе.';
$string['infobannerclose'] = 'Закрыть';
$string['infobannercontentsetting'] = 'Содержимое информационного банера {$a->no}';
$string['infobannercontentsetting_desc'] = 'Здесь можно ввести информацию, которая должна отображаться в информационном баннере {$a->no}.';
$string['infobannerdismissconfirm'] = 'Вы действительно хотите сбросить видимость информационного баннера {$a->no} и снова показать его всем пользователям, которые его закрыли?';
$string['infobannerdismissfail'] = 'Сброс видимости информационного баннера {$a->no} не удался по крайней мере для одного пользователя';
$string['infobannerdismissiblesetting'] = 'Информационный баннер {$a->no} можно закрыть';
$string['infobannerdismissiblesetting_desc'] = 'С помощью этой настройки вы можете сделать информационный баннер {$a->no} неудаляемым. Если пользователь нажмет на кнопку Х в информационном баннере, то он будет скрыт для этого пользователя навсегда. Видимость не сбрасывается автоматически, даже если вы меняете содержимое информационного баннера. Если вы хотите сбросить видимость информационного баннера, нажмите ниже кнопку «Сбросить видимость».';
$string['infobannerdismissreset'] = 'Сделать видимым закрытый информационный баннер';
$string['infobannerdismissresetbutton'] = 'Сбросить видимость информационного баннера {$a->no}';
$string['infobannerdismisssuccess'] = 'Видимость информационного баннера {$a->no} была сброшена.';
$string['infobannerenabledsetting'] = 'Включить информационный банер {$a->no}';
$string['infobannerenabledsetting_desc'] = 'Этот параметр включает информационный баннер {$a->no}.';
$string['infobannerendsetting'] = 'Время окончания показа информационного баннера {$a->no}';
$string['infobannerendsetting_desc'] = 'С помощью этого параметра вы можете определить, до какого момента должен отображаться информационный баннер {$a->no}. Настроенное время интерпретируется как время сервера, а не как время пользователя.';
$string['infobannerheading'] = 'Информационный баннер {$a->no}';
$string['infobannermodeperpetual'] = 'Постоянный';
$string['infobannermodesetting'] = 'Режим отображения информационного баннера {$a->no}';
$string['infobannermodesetting_desc'] = 'С помощью этого параметра вы можете определить, должен ли информационный баннер {$a->no} быть постоянным баннером (отображается всегда) или баннером, управляемым по времени (отображается только в течение заданного интервала времени).';
$string['infobannermodetimebased'] = 'Управление по времени';
$string['infobannerordersetting'] = 'Порядок размещения информационного баннера {$a->no}';
$string['infobannerordersetting_desc'] = 'С помощью этого параметра вы определяете порядковый номер информационного баннера {$a->no}. По умолчанию информационные баннеры упорядочены сверху вниз, как вы видите их на этой странице настроек. Однако с помощью этой настройки вы можете назначить другую позицию. Если вы назначите одну и ту же позицию двум или более информационным баннерам, они будут снова упорядочены в соответствии с порядком на этой странице.';
$string['infobannerpageloginpage'] = 'Страница авторизации';
$string['infobannerpagessetting'] = 'Макеты страниц для отображения информационного баннера {$a->no}';
$string['infobannerpagessetting_desc'] = 'Этот параметр позволяет выбрать макеты страниц, на которых должен отображаться информационный баннер {$a->no}.';
$string['infobannerstartsetting'] = 'Время начала показа информационного баннера {$a->no}';
$string['infobannerstartsetting_desc'] = 'С помощью этого параметра вы можете определить, с какого момента должен отображаться информационный баннер {$a->no}. Заданное время интерпретируется как время сервера, а не как время пользователя.';
$string['infobannertab'] = 'Информационный баннер';
$string['invalidurl'] = 'Указанный URL-адрес недействителен';
$string['javascriptdisabledhint'] = 'Подсказка о выключенном JavaScript';
$string['javascriptdisabledhint_desc'] = 'С помощью этой настройки в верхней части страницы Moodle появится подсказка, если JavaScript не включен. Это особенно полезно, поскольку некоторые функции Moodle не работают без JavaScript.';
$string['javascriptdisabledhinttext'] = 'JavaScript отключен в вашем браузере.<br />Многие функции Moodle будут недоступны или будут выглядеть нерабочими.<br />Пожалуйста, включите JavaScript для полноценной работы с Moodle.';
$string['javascriptheading'] = 'JavaScript';
$string['linkstab'] = 'Ссылки';
$string['loginbackgroundimage'] = 'Фоновые рисунки страницы авторизации';
$string['loginbackgroundimage_desc'] = 'Изображения для отображения в качестве фона страницы входа в систему. Одно из этих изображений будет выбрано случайным образом и показано при посещении пользователем страницы входа в систему. Пожалуйста, убедитесь, что в имени файла не используются символы, отличные от ASCII, если вы хотите отобразить текст для фоновых изображений входа в систему.';
$string['loginbackgroundimagepositionsetting'] = 'Положение фонового изображения страницы авторизации';
$string['loginbackgroundimagepositionsetting_desc'] = 'Здесь вы можете задать позиционирование фонового изображения страницы авторизации в окне браузера. Первое значение - горизонтальное положение, второе - вертикальное.';
$string['loginbackgroundimagesheading'] = 'Фоновые рисунки страницы авторизации';
$string['loginbackgroundimagetextsetting'] = 'Отображение текста для фоновых изображений страницы авторизации';
$string['loginbackgroundimagetextsetting_desc'] = 'С помощью этого дополнительного параметра вы можете добавить текст, например, уведомление об авторских правах, к загруженным фоновым изображениям. Этот текст появится в верхней части нижнего колонтитула на странице входа в систему. Однако из соображений экономии площади экрана он отображается только на экранах больших размеров.<br/>
Каждая строка состоит из идентификатора файла (имя файла), текста, который должен быть отображен, и цвета текста, разделенных символом вертикальной черты. Каждое объявление должно быть записано в новой строке. <br/>
Например:<br/>
background-image-1.jpg|Copyright: CC0|dark<br/>
В качестве цвета текста можно использовать значения "dark"(темный) или "light"(светлый).<br />
Вы можете объявить тексты для произвольного количества загруженных фоновых изображений. Тексты будут добавлены только к тем изображениям, имя файла которых совпадает с идентификатором, объявленным в этом параметре.';
$string['loginformheading'] = 'Форма входа';
$string['loginformpositionsetting'] = 'Положение формы входа';
$string['loginformpositionsetting_center'] = 'По центру';
$string['loginformpositionsetting_desc'] = 'С помощью этой настройки вы можете переместить форму входа в систему, чтобы она подходила к большему числу фоновых изображений. По умолчанию форма входа отображается по центру страницы входа. В качестве альтернативы вы можете переместить ее влево или вправо, чтобы другие части фонового изображения были видны. Конечно, вы также можете изменить этот параметр даже если фоновые изображения вообще не загружены.';
$string['loginformpositionsetting_left'] = 'Выравнивание по левому краю';
$string['loginformpositionsetting_right'] = 'Выравнивание по правому краю';
$string['loginformtransparencysetting'] = 'Прозрачность формы входа';
$string['loginformtransparencysetting_desc'] = 'С помощью этой настройки можно сделать форму входа в систему слегка прозрачной, чтобы лучше показать фоновое изображение.';
$string['loginidpshowintrosetting'] = 'Вступление для внешних провайдеров идентификации';
$string['loginidpshowintrosetting_desc'] = 'С помощью этого параметра вы контролируете, будет ли отображаться вступление <em>\'{$a}\'</em> над кнопками входа внешних провайдеров идентификации или нет. По умолчанию вступление отображается, и пользователи быстро получают информацию о том, что представляют собой кнопки внешних провайдеров идентификации. Если вы отключите эту настройку, вступление внешних провайдеров идентификации будет скрыто. Это позволит вам обеспечить чистый интерфейс входа пользователей, если вы используете только внешних провайдеров идентификации, таких как OAuth2 или OIDC.';
$string['loginlocalintro'] = 'Войдите в систему, используя свою учетную запись Moodle';
$string['loginlocalloginenablesetting'] = 'Локальный вход';
$string['loginlocalloginenablesetting_desc'] = 'С помощью этого параметра вы контролируете, будет ли форма локального входа отображаться на странице входа или нет. По умолчанию форма локального входа отображается, и пользователи могут войти на сайт в обычном режиме. Если отключить эту настройку, форма локального входа будет скрыта. Это позволяет вам просто предоставлять кнопки входа для внешних провайдеров идентификации, таких как OAuth2 или OIDC.';
$string['loginlocalloginenablesetting_note'] = 'Обратите внимание: скрыв форму локального входа, вы рискуете тем, что администраторы больше не смогут войти в систему под локальной учетной записью, если возникнут проблемы с внешним провайдером идентификации. Чтобы разрешить локальные входы в таких случаях, предусмотрена <a href="{$a->url}">страница локального входа</a>. На этой странице локального входа применяются все меры безопасности входа в систему Moodle.';
$string['loginlocalloginformhead'] = 'Локальный вход';
$string['loginlocalloginlocalnotdisabled'] = 'Локальный вход включен на стандартной форме входа. Поэтому нет необходимости входить в систему на этой странице локального входа. Для входа используйте <a href="{$a->url}">стандартную страницу входа</a>.';
$string['loginlocalshowintrosetting'] = 'Вступление для локального входа';
$string['loginlocalshowintrosetting_desc'] = 'С помощью этого параметра вы можете контролировать, будет ли отображаться вступление <em>\'{$a}\'</em> над формой локального входа или нет. По умолчанию вступление не отображается. Но если вы включите его, вступление поможет пользователям понять, какие учетные данные нужно использовать в форме локального входа, особенно если вы предоставляете более одного метода входа или изменили порядок методов входа.';
$string['loginorderfirsttimesignupsetting'] = 'Информация для впервые пришедших и самостоятельная регистрация';
$string['loginorderguestsetting'] = 'Гостевой вход';
$string['loginorderheading'] = 'Упорядочивание входов';
$string['loginorderheading_desc'] = 'С помощью этих настроек вы контролируете порядок методов входа на форме входа. Представленный порядок будет определен от наименьшего до наибольшего порядкового номера, пропуская все методы входа и элементы формы входа, которые отключены в Moodle.';
$string['loginorderheading_note'] = 'Техническое примечание: представленный порядок будет реализован с помощью CSS flexbox, а не путем перестановки виджетов входа в HTML DOM. Это должно быть нормально на всех современных браузерах, но может не работать на очень старых браузерах.';
$string['loginorderidpsetting'] = 'Вход через внешних провайдеров идентификации';
$string['loginorderlocalsetting'] = 'Локальный вход';
$string['loginpagetab'] = 'Страница авторизации';
$string['loginprovidersheading'] = 'Провайдеры входа';
$string['logocompactsetting'] = 'Компактный логотип';
$string['logocompactsetting_desc'] = 'Здесь вы можете загрузить компактную версию того же логотипа, что и выше, например, эмблему, щит или значок. Это изображение особенно часто используется в навигационной панели в верхней части каждой страницы Moodle. Изображение должно быть четким даже при небольших размерах.';
$string['logosetting'] = 'Логотип';
$string['logosetting_desc'] = 'Здесь вы можете загрузить полный логотип для использования в качестве украшения. Это изображение особенно часто используется на странице входа в систему. Это изображение должно быть с высоким разрешением, поскольку оно будет уменьшено при использовании.';
$string['logosheading'] = 'Логотипы';
$string['logosheading_desc'] = 'Обратите внимание: Boost Union имеет свою собственную загрузку логотипа и не использует логотип из <a href="{$a}">настроек логотипа ядра Moodle</a>.<br />Boost Union позволяет загружать больше форматов изображений, чем позволяет ядро Moodle, и позволяет переопределять загруженные логотипы с учетом своих стилей.';
$string['maintenancecontentsetting'] = 'Содержимое страницы с информацией о техническом обслуживании';
$string['maintenancecontentsetting_desc'] = 'В этом параметре вы можете добавить расширенный текстовый контент, который будет отображаться на странице информации о техническом обслуживании (отличается от встроенной в  Moodle страницы режима обслуживания).';
$string['maintenancedisabled'] = 'Страница  с информацией о техническом обслуживании отключена для этого сайта. Здесь не на что смотреть.';
$string['maintenanceheading'] = 'Обслуживание';
$string['maintenancelinkpositionboth'] = 'Добавить ссылку на страницу с информацией о техническом обслуживании в сноску и на иконку «Знак вопроса» в нижнем колонтитуле';
$string['maintenancelinkpositionfooter'] = 'Добавить ссылку на страницу с информацией о техническом обслуживании на иконку «Знак вопроса» в нижнем колонтитуле';
$string['maintenancelinkpositionfootnote'] = 'Добавить ссылку на страницу с информацией о техническом обслуживании в колонтитул';
$string['maintenancelinkpositionnone'] = 'Не показывать автоматически ссылку на страницу с информацией о техническом обслуживании';
$string['maintenancelinkpositionsetting'] = 'Расположение ссылки на страницу с информацией о техническом обслуживании';
$string['maintenancelinkpositionsetting_desc'] = 'В этом параметре вы можете указать, должна ли ссылка на страницу с информацией о техническом обслуживании автоматически добавляться на страницы Moodle. Если вы не хотите показывать ссылку автоматически, вы можете добавить ссылку на {$a->url} из любого места в Moodle вручную.';
$string['maintenancepagetitledefault'] = 'Информация о техническом обслуживании';
$string['maintenancepagetitlesetting'] = 'Заголовок страницы с информацией о техническом обслуживании';
$string['maintenancepagetitlesetting_desc'] = 'Этот параметр позволяет задать заголовок страницы с информацией о техобслуживании. Этот текст также будет использоваться в качестве текста ссылки на такую страницу, если параметр «Расположение ссылки на страницу с информацией о техобслуживании» настроен соответствующим образом.';
$string['markbrokenlinkssetting'] = 'Отмечать битые ссылки';
$string['markbrokenlinkssetting_desc'] = 'Добавляет значок «разорванной цепи» перед битыми ссылками (которые ведут к загруженным черновым файлам, не обработанным должным образом) и помечает ссылку цветом bootstrap для обозначения «опасности». В отличие от настроек «Отмечать внешние ссылки» и «Отмечать ссылки mailto», здесь нет возможности ограничить область действия этой настройки, так как пометка битых ссылок - это индикатор того, что что-то сломалось и должно быть исправлено вручную.';
$string['markexternallinksscopesetting'] = 'Область действия пометки внешних ссылок';
$string['markexternallinksscopesetting_desc'] = 'С помощью этого параметра вы контролируете область, в которой Boost Union должен отмечать внешние ссылки. По умолчанию Boost Union отмечает внешние ссылки на всей странице Moodle и делает все возможное, чтобы охватить некоторые крайние случаи, когда добавление значка внешней ссылки не имеет особого смысла. Однако вы можете ограничить область действия, чтобы избежать крайних случаев.';
$string['markexternallinkssetting'] = 'Отмечать внешние ссылки';
$string['markexternallinkssetting_desc'] = 'Добавляет значок "внешняя ссылка" после внешних ссылок (которые ведут пользователя к цели за пределы Moodle).';
$string['marklinksscopesetting_coursemain'] = 'Только в области контента основных страниц курса';
$string['marklinksscopesetting_wholepage'] = 'На всей странице';
$string['markmailtolinksscopesetting'] = 'Область действия пометки ссылок mailto';
$string['markmailtolinksscopesetting_desc'] = 'С помощью этого параметра вы контролируете область, в которой Boost Union должен отмечать mailto-ссылки. По умолчанию Boost Union помечает mailto-ссылки на всей странице Moodle. Однако вы можете ограничить область действия, чтобы избежать крайних случаев.';
$string['markmailtolinkssetting'] = 'Отмечать ссылки mailto';
$string['markmailtolinkssetting_desc'] = 'Добавляет значок «конверта» перед ссылками mailto.';
$string['maxlogowidth'] = 'Максимальная ширина логотипа в панели навигации';
$string['maxlogowidth_desc'] = 'На панели навигации загруженный компактный логотип обычно отображается со 100%-ной высотой и пропорциональной шириной. Однако, если логотип слишком широкий или имеет другое особое соотношение сторон, вы можете установить здесь максимальную ширину логотипа на панели навигации. Вы можете ввести значения в пикселях (например, 120px), но также можете ввести значение в процентах (например, 10%) или значение ширины экрана (например, 5vw). Если вы не введете никакого значения, логотип будет отображаться в формате по умолчанию.';
$string['mediumcontentmaxwidthsetting'] = 'Максимальная ширина среднего контента';
$string['mediumcontentmaxwidthsetting_desc'] = 'С помощью этой настройки вы можете переопределить ширину контента в средней колонке Moodle без ручных изменений SCSS. Эта ширина страницы используется некоторыми элементами курса, например, - Базой данных. По умолчанию Moodle использует максимальную ширину средней колонки 1120 пикселей. Вы можете ввести другие значения в пикселях, например 1200 пикселей, но вы также можете ввести значение в процентах, например 100%, или значение ширины области просмотра, например 90vw.';
$string['misctab'] = 'Разное';
$string['mobileappearanceheading'] = 'Мобильный вид';
$string['mobileappheading'] = 'Мобильное приложение';
$string['mobilecss'] = 'Дополнительный CSS для мобильного приложения';
$string['mobilecss_desc'] = 'С помощью этого параметра вы можете написать собственный код CSS для настройки интерфейса вашего мобильного приложения. Код CSS будет добавлен только к стилям этого экземпляра Moodle в мобильном приложении и не будет отображаться в версии для веб-браузера. Подробнее об этой функции читайте в <a href="https://moodledev.io/general/app/customisation/remote-themes#how-do-remote-themes-work">Документации разработчика Moodle</a>.';
$string['mobilecss_donotchange'] = 'Этот шаг необходим для отправки кода CSS в мобильное приложение. Не изменяйте URL-адрес, если только вы действительно не хотите снова удалить CSS-код из мобильного приложения.';
$string['mobilecss_overwrite'] = 'Как только вы добавите какой-либо код CSS в этот параметр и сохраните его, <a href="{$a->url}">основной параметр Moodle <em>mobilecssurl</em></a> будет автоматически перезаписан URL-адресом темы Boost Union. Текущее значение <a href="{$a->value}">{$a->value}</a>.';
$string['mobilecss_set'] = 'Как только вы добавите какой-либо код CSS в этот параметр и сохраните его, <a href="{$a->url}">параметр ядра Moodle <em>mobilecssurl</em></a> будет автоматически установлен в значение URL-адреса темы Boost Union.';
$string['mobiletab'] = 'Мобильное приложение';
$string['modiconactivity'] = 'Элемент курса';
$string['modiconactivityunknown'] = 'Неизвестно';
$string['modicongtmoodle4'] = 'Иконки Moodle 4';
$string['modiconlistsetting'] = 'Список пользовательских иконок элементов курса';
$string['modiconlistsetting_desc'] = 'Это список файлов пользовательских иконок, которые вы выше загрузили в раздел файлов пользовательских иконок. Здесь перечислены все допустимые файлы иконок. Кроме того, другие файлы, которые вы могли загрузить, но которые не являются действительными файлами иконок, также показаны как неработающие файлы.';
$string['modiconltmoodle311'] = 'Иконка, оставшаяся от Moodle 3';
$string['modiconnamefail'] = 'Этот файл был загружен в правильную папку для модуля <em>{$a}</em>, но имя файла не соответствует требованиям. Измените имя файла либо на <em>monologo.svg</em> / <em>monologo.png</em> (для иконок Moodle 4) либо на <em>icon.svg</em> / <em>icon.png</em> (для иконок, оставшихся от Moodle 3).';
$string['modiconnotexist'] = 'Этот файл был загружен в неподходящее место, так как по пути к файлу <em>{$a}</em> невозможно определить конкретный плагин.';
$string['modiconsenablesetting'] = 'Разрешить пользовательские иконки для элементов и ресурсов курсов';
$string['modiconsenablesetting_desc'] = 'Эта настройка позволяет изменить иконки для элементов и ресурсов курсов , которые используются на страницах курса и в средстве их выбора.';
$string['modiconserrorcreatingpath'] = 'Каталог pix_plugins/mod не может быть создан в каталоге moodledata.<br /> Сообщение об исключении: {$a}.';
$string['modiconsfiles'] = 'Файлы пользовательских иконок';
$string['modiconsfiles_desc'] = 'Здесь вы можете загрузить пользовательские иконки для всех или только некоторых элементов курса, установленных в данном экземпляре Moodle.';
$string['modiconsfileshowto'] = 'Чтобы загрузить иконку конкретного элемента, создайте папку с внутренним именем элемента, например <em>assign</em> для задания. В эту папку вы загружаете иконку в виде SVG-файла monologo.svg и, если возможно, в виде резервного PNG-файла monologo.png. Если вы хотите настроить цветные иконки, которые использовались до Moodle 3 и которые все еще могут использоваться старыми плагинами, вы также можете загрузить их в виде файлов icon.svg и icon.png. Однако, пожалуйста, придерживайтесь однотонных SVG-иконок, если это возможно, для достижения наилучших результатов. Затем сохраните страницу настроек. Как только вы сохраните настройки хотя бы с одним файлом, ниже появится список файлов, который поможет вам проверить, правильно ли были загружены пользовательские иконки.';
$string['modiconsfilestech'] = 'Техническое примечание: После сохранения настроек загруженная структура папок и файлы иконок будут скопированы в папку pix_plugins/mod в вашем каталоге moodledata. Это место, где ядро Moodle ищет пользовательские иконки элементов курса. Все файлы иконок, которые могут уже существовать в этом месте, будут перезаписаны при сохранении этой настройки.';
$string['modiconsheading'] = 'Иконки элементов курса';
$string['modiconsuccess3x'] = 'Эта иконка используется модулем <em>{$a}</em> как устаревшая иконка Moodle 3.';
$string['modiconsuccess4x'] = 'Эта иконка используется модулем <em>{$a}</em> как иконка Moodle 4.';
$string['modiconversion'] = 'Версия иконки';
$string['navbarcolorsetting'] = 'Цвет панели навигации';
$string['navbarcolorsetting_dark'] = 'Темная панель навигации со светлым цветом шрифта';
$string['navbarcolorsetting_desc'] = 'С помощью этого параметра можно изменить цвет навигационной панели со светлого по умолчанию на темный или цветной.';
$string['navbarcolorsetting_light'] = 'Светлая панель навигации с темным цветом шрифта (без изменений, как представлено в ядре Moodle)';
$string['navbarcolorsetting_primarydark'] = 'Навигационная панель основного цвета со светлым цветом шрифта';
$string['navbarcolorsetting_primarylight'] = 'Навигационная панель основного цвета с темным цветом шрифта';
$string['navbarheading'] = 'Панель навигации';
$string['navigationheading'] = 'Навигация';
$string['navigationtab'] = 'Навигация';
$string['offerscontentsetting'] = 'Содержимое страницы предложений';
$string['offerscontentsetting_desc'] = 'Этот параметр позволяет добавить форматированный текстовый контент, который будет отображаться на странице предложений.';
$string['offersdisabled'] = 'Страница предложений отключена для этого сайта. Здесь не на что смотреть.';
$string['offersheading'] = 'Предложения';
$string['offerslinkpositionboth'] = 'Добавить ссылку на страницу предложений в сноску и в значок нижнего колонтитула (знак вопроса)';
$string['offerslinkpositionfooter'] = 'Добавить ссылку на страницу предложений в значок нижнего колонтитула (знак вопроса)';
$string['offerslinkpositionfootnote'] = 'Добавить ссылку на страницу предложений в сноску';
$string['offerslinkpositionnone'] = 'Не показывать автоматически ссылку на страницу предложений';
$string['offerslinkpositionsetting'] = 'Расположение ссылки на предложения';
$string['offerslinkpositionsetting_desc'] = 'В этом параметре вы можете указать, должна ли ссылка на страницу предложений автоматически добавляться на страницу Moodle. Если вы не хотите, чтобы ссылка отображалась автоматически, вы можете вручную добавить ссылку на {$a->url} из любого места Moodle.';
$string['offerspagetitledefault'] = 'Предложения';
$string['offerspagetitlesetting'] = 'Заголовок страницы предложений';
$string['offerspagetitlesetting_desc'] = 'В этой настройке вы можете определить заголовок страницы предложений. Этот текст также будет использоваться в качестве текста ссылки на страницу предложений, если вы соответствующим образом настроите «Расположение ссылки на предложения».';
$string['openoffcanvas'] = 'Открыть панель «Вне страницы»';
$string['outsideregionsheading'] = 'Внешние области';
$string['outsideregionsheading_desc'] = 'Внешние области можно не только включить с помощью указанных выше настроек макета, но и настроить их внешний вид.';
$string['outsideregionsplacement'] = 'Горизонтальное размещение внешних областей';
$string['outsideregionsplacement_desc'] = 'С помощью этой настройки вы можете контролировать, должны ли на больших экранах области «Внешняя (слева)» и «Внешняя (справа)» располагаться рядом с областью основного контента или ближе к краям окна.';
$string['outsideregionsplacementnearwindowedges'] = 'Отображать области «Внешняя (слева)» и «Внешняя (справа)» у краев окна';
$string['outsideregionsplacementnextmaincontent'] = 'Отображать области «Внешняя (слева)» и «Внешняя (справа)» рядом с областью основного контента';
$string['outsideregionswidthcoursecontentwidth'] = 'Ширина колонки контента курса';
$string['outsideregionswidthfullwidth'] = 'Полная ширина';
$string['outsideregionswidthherowidth'] = 'Ширина блока';
$string['page1contentsetting'] = 'Содержимое общей страницы 1';
$string['page1contentsetting_desc'] = 'В этом параметре вы можете добавить расширенный текстовый контент, который будет отображаться на общей странице 1.';
$string['page1disabled'] = 'Общая страница 1 отключена для этого сайта. Здесь не на что смотреть.';
$string['page1heading'] = 'Общая страница 1';
$string['page1linkpositionboth'] = 'Добавить ссылку на общую страницу 1 в колонтитул и в значок нижнего колонтитула (знак вопроса)';
$string['page1linkpositionfooter'] = 'Добавить ссылку на общую страницу 1 в значок нижнего колонтитула (знак вопроса)';
$string['page1linkpositionfootnote'] = 'Добавить ссылку на общую страницу 1 в колонтитул';
$string['page1linkpositionnone'] = 'Не показывать автоматически ссылку на общую страницу 1';
$string['page1linkpositionsetting'] = 'Расположение ссылки на общую страницу 1';
$string['page1linkpositionsetting_desc'] = 'В этом параметре вы можете указать, должна ли ссылка на общую страницу 1 автоматически добавляться на страницы Moodle. Если вы не хотите показывать ссылку автоматически, вы можете вручную добавить ссылку на {$a->url} из любого места в Moodle.';
$string['page1pagetitledefault'] = 'Общая страница 1';
$string['page1pagetitlesetting'] = 'Заголовок общей страницы 1';
$string['page1pagetitlesetting_desc'] = 'Этот параметр определяет заголовок общей страницы 1. Этот текст будет использоваться в качестве текста ссылки на общую страницу 1, если вы соответствующим образом настроите «Расположение ссылки на общую страницу 1».';
$string['page2contentsetting'] = 'Содержимое общей страницы 2';
$string['page2contentsetting_desc'] = 'В этом параметре вы можете добавить расширенный текстовый контент, который будет отображаться на общей странице 2.';
$string['page2disabled'] = 'Общая страница 2 отключена для этого сайта. Здесь не на что смотреть.';
$string['page2heading'] = 'Общая страница 2';
$string['page2linkpositionboth'] = 'Добавить ссылку на общую страницу 2 в колонтитул и в значок нижнего колонтитула (знак вопроса)';
$string['page2linkpositionfooter'] = 'Добавить ссылку на общую страницу 2 в значок нижнего колонтитула (знак вопроса)';
$string['page2linkpositionfootnote'] = 'Добавить ссылку на общую страницу 2 в колонтитул';
$string['page2linkpositionnone'] = 'Не показывать автоматически ссылку на общую страницу 2';
$string['page2linkpositionsetting'] = 'Расположение ссылки на общую страницу 2';
$string['page2linkpositionsetting_desc'] = 'В этом параметре вы можете указать, должна ли ссылка на общую страницу 2 автоматически добавляться на страницы Moodle. Если вы не хотите показывать ссылку автоматически, вы можете вручную добавить ссылку на {$a->url} из любого места в Moodle.';
$string['page2pagetitledefault'] = 'Общая страница 2';
$string['page2pagetitlesetting'] = 'Заголовок общей страницы 2';
$string['page2pagetitlesetting_desc'] = 'Этот параметр определяет заголовок общей страницы 2. Этот текст будет использоваться в качестве текста ссылки на общую страницу 2, если вы соответствующим образом настроите «Расположение ссылки на общую страницу 2».';
$string['page3contentsetting'] = 'Содержимое общей страницы 3';
$string['page3contentsetting_desc'] = 'В этом параметре вы можете добавить расширенный текстовый контент, который будет отображаться на общей странице 3.';
$string['page3disabled'] = 'Общая страница 3 отключена для этого сайта. Здесь не на что смотреть.';
$string['page3heading'] = 'Общая страница 3';
$string['page3linkpositionboth'] = 'Добавить ссылку на общую страницу 3 в колонтитул и в значок нижнего колонтитула (знак вопроса)';
$string['page3linkpositionfooter'] = 'Добавить ссылку на общую страницу 3 в значок нижнего колонтитула (знак вопроса)';
$string['page3linkpositionfootnote'] = 'Добавить ссылку на общую страницу 3 в колонтитул';
$string['page3linkpositionnone'] = 'Не показывать автоматически ссылку на общую страницу 3';
$string['page3linkpositionsetting'] = 'Расположение ссылки на общую страницу 3';
$string['page3linkpositionsetting_desc'] = 'В этом параметре вы можете указать, должна ли ссылка на общую страницу 3 автоматически добавляться на страницы Moodle. Если вы не хотите показывать ссылку автоматически, вы можете вручную добавить ссылку на {$a->url} из любого места в Moodle.';
$string['page3pagetitledefault'] = 'Общая страница 3';
$string['page3pagetitlesetting'] = 'Заголовок общей страницы 3';
$string['page3pagetitlesetting_desc'] = 'Этот параметр определяет заголовок общей страницы 3. Этот текст будет использоваться в качестве текста ссылки на общую страницу 3, если вы соответствующим образом настроите «Расположение ссылки на общую страницу 3».';
$string['pagelayoutstab'] = 'Макеты страниц';
$string['pagetab'] = 'Страница';
$string['pagewidthheading'] = 'Ширина страницы';
$string['pluginname'] = 'Boost Union';
$string['policyheading'] = 'Политики';
$string['policyoverviewnavigationsetting'] = 'Показывать навигацию на странице обзора политики';
$string['policyoverviewnavigationsetting_desc'] = 'По умолчанию на странице <a href="{$a->url}">обзора политики (предоставляемой tool_policy)</a> не отображается меню навигации и нижний колонтитул. С помощью этой настройки вы можете отобразить основную навигацию и нижний колонтитул на этой странице.';
$string['presetbutton'] = 'Установить предустановку темы в Boost';
$string['presetheading'] = 'Предустановки тем';
$string['presetheading_desc'] = 'Предустановки темы могут быть использованы для кардинального изменения внешнего вида темы. В Boost Union не реализована настройка предустановок тем. Если вы хотите использовать предустановки тем, задайте их непосредственно в Boost. Boost Union унаследует и будет использовать настроенную тему.';
$string['primarynavigationheading'] = 'Основная навигация';
$string['privacy:metadata'] = 'Тема Boost Union не хранит никаких личных данных ни о каком пользователе.';
$string['recentlyaccesseditemsheading'] = 'Блок недавно просмотренных элементов';
$string['recentlyaccesseditemstintenabled'] = 'Тонировка значков недавно просмотренных элементов';
$string['recentlyaccesseditemstintenabled_desc'] = 'С помощью этой настройки вы можете окрашивать значки элементов в блоке недавно просмотренных элементов в зависимости от целей деятельности. По умолчанию Moodle отображает их просто как черные значки.';
$string['region-content-lower'] = 'Контент (снизу)';
$string['region-content-upper'] = 'Контент (сверху)';
$string['region-footer-center'] = 'Нижний колонтитул (по центру)';
$string['region-footer-left'] = 'Нижний колонтитул (слева)';
$string['region-footer-right'] = 'Нижний колонтитул (справа)';
$string['region-header'] = 'Заголовок';
$string['region-none'] = 'Нет';
$string['region-offcanvas-center'] = 'Вне страницы (по центру)';
$string['region-offcanvas-left'] = 'Вне страницы (слева)';
$string['region-offcanvas-right'] = 'Вне страницы (справа)';
$string['region-outside-bottom'] = 'Внешняя (снизу)';
$string['region-outside-left'] = 'Внешняя (слева)';
$string['region-outside-right'] = 'Внешняя (справа)';
$string['region-outside-top'] = 'Внешняя (сверху)';
$string['resourcescachecontrolnote'] = 'Обратите внимание, что файлы отправляются в браузер с заголовком \'Cache-Control\', который указывает браузеру кэшировать файл. Если вы уверены, что не будете изменять файл в ближайшем будущем, вы можете использовать постоянный URL для ссылки на файл. Однако, если вы планируете изменять файл, но время от времени сохранять то же имя файла, вам лучше использовать обновляемый URL.  При этом каждый раз при обновлении файла заново ссылаться на файл там, где вы его использовали, чтобы браузеры не показывали кэшированные устаревшие версии файла.';
$string['resourcestab'] = 'Ресурсы';
$string['scrollspysetting'] = 'Отслеживание прокрутки';
$string['scrollspysetting_desc'] = 'С этой настройкой при включении и выключении режима редактирования сохраняется позиция прокрутки, в которой находился пользователь в момент переключения.';
$string['scssheading'] = 'Необработанный SCSS';
$string['scsstab'] = 'SCSS';
$string['setpreferredlanglink'] = 'Установить предпочитаемый язык';
$string['settingsoverview'] = 'Обзор настроек';
$string['settingsoverview_accessibility_desc'] = 'Здесь находятся настройки функций, связанных с доступностью на вашем сайте Moodle.';
$string['settingsoverview_all'] = 'Все настройки на одной странице';
$string['settingsoverview_all_desc'] = 'Здесь вы можете открыть стандартную страницу настроек Moodle для Boost Union, которая показывает все настройки на одной странице. Но будьте готовы к тому, что в действительности она переполнена.';
$string['settingsoverview_content_desc'] = 'Здесь находятся настройки для глобального содержимого вашего сайта Moodle: нижний колонтитул, статические страницы, информационные баннеры, рекламные плитки и слайдеры.';
$string['settingsoverview_feel_desc'] = 'Здесь находятся настройки общего поведения вашего сайта Moodle: элементы навигации, помощники навигации, блоки и ссылки.';
$string['settingsoverview_flavours_desc'] = 'С помощью стилей вы можете разнообразить внешний вид вашего сайта Moodle для разных глобальных групп и/или категорий курсов.';
$string['settingsoverview_functionality_desc'] = 'Здесь находятся настройки для дополнительных полезных глобальных или связанных с курсом функций на вашем сайте Moodle.';
$string['settingsoverview_look_desc'] = 'Здесь находятся настройки для корпоративного стиля вашего сайта Moodle: цвета, иконки, изображения, размеры и, конечно же, пользовательский SCSS.';
$string['settingsoverview_smartmenus_desc'] = 'С помощью умных меню вы можете расширить навигационные элементы своего сайта Moodle в главном меню и меню пользователей, а также добавить нижнее или верхнее меню.';
$string['settingsoverview_title'] = 'Обзор настроек Boost Union';
$string['showfullnameinusermenussetting'] = 'Показывать полное имя в меню пользователя';
$string['showfullnameinusermenussetting_desc'] = 'С помощью этой настройки вы можете показывать полное имя вошедшего в систему пользователя в верхней части пользовательского меню. Это может быть особенно полезно на экзамене, когда учителю нужно проверить, что пользователь вошел в систему под своей учетной записью, но это может быть полезно и для самого пользователя. В отличие от классической темы, в которой полное имя пользователя отображается в навигационной панели рядом с аватаром, здесь такой подход не занимает дефицитное дополнительное место в навигационной панели.';
$string['showfullnameinusermenussetting_loggedinas'] = 'Вы вошли в систему как:';
$string['showhintcourseguestaccessgeneral'] = 'В настоящее время вы просматриваете этот курс как <strong>{$a->role}</strong>.';
$string['showhintcourseguestaccesslink'] = 'Чтобы получить полный доступ к курсу, вы можете <a href="{$a->url}">самостоятельно записаться на этот курс</a>.';
$string['showhintcourseguestaccesssetting_desc'] = 'При включенном параметре в заголовке курса появляется подсказка, если пользователь получает доступ к курсу с помощью гостевого доступа. Если в курсе разрешена самостоятельная запись, пользователю также будет представлена ссылка на соответствующую страницу.';
$string['showhintcoursehiddengeneral'] = 'В настоящее время этот курс <strong>скрыт</strong>. Только зарегистрированные преподаватели могут получить доступ к этому курсу, когда он скрыт.';
$string['showhintcoursehiddensetting'] = 'Отображать подсказку о скрытых курсах';
$string['showhintcoursehiddensetting_desc'] = 'При включенном параметре в заголовке скрытого курса будет появляться подсказка. Это помогает определить состояние видимости курса с первого взгляда без необходимости просматривать настройки курса.';
$string['showhintcoursehiddensettingslink'] = 'Вы можете изменить видимость в <a href="{$a->url}">настройках курса</a>.';
$string['showhintcourseselfenrolfrom'] = 'Способ зачисления на курс <strong>{$a->name}</strong> позволяет неограниченную самостоятельную запись после {$a->from}.';
$string['showhintcourseselfenrolfromuntil'] = 'Способ зачисления на курс <strong>{$a->name}</strong> позволяет неограниченную самостоятельную запись с {$a->from} по {$a->until}.';
$string['showhintcourseselfenrolinstancecallforaction'] = 'Если вы не хотите, чтобы любой пользователь Moodle имел свободный доступ к этому курсу, ограничьте настройки самостоятельной записи.';
$string['showhintcourseselfenrolsetting'] = 'Отображать подсказку для самостоятельной записи без ключа';
$string['showhintcourseselfenrolsetting_desc'] = 'При включенном параметре в заголовке видимого курса появится подсказка о возможности записи без ключа.';
$string['showhintcourseselfenrolsince'] = 'Способ зачисления на курс <strong>{$a->name}</strong> позволяет неограниченную самостоятельную запись в текущий момент.';
$string['showhintcourseselfenrolsinceuntil'] = 'Способ зачисления на курс <strong>{$a->name}</strong> позволяет неограниченную самостоятельную запись до {$a->until}.';
$string['showhintcourseselfenrolstartcurrently'] = 'В настоящее время этот курс доступен для всех и возможна <strong>самостоятельная запись без регистрационного ключа</strong>.';
$string['showhintcourseselfenrolstartfuture'] = 'В настоящее время этот курс доступен для всех и планируется разрешить <strong>самостоятельную запись без регистрационного ключа</strong>.';
$string['showhintcourseselfenrolunlimited'] = 'Способ зачисления на курс <strong>{$a->name}</strong> позволяет неограниченную самостоятельную запись в любой момент.';
$string['showhintcourseselfenroluntil'] = 'Способ зачисления на курс <strong>{$a->name}</strong> позволяет неограниченную самостоятельную запись до {$a->until}.';
$string['showhintcoursguestaccesssetting'] = 'Отображать подсказку о гостевом входе';
$string['showhintforumnotifications'] = 'Этот курс в настоящее время <strong>скрыт</strong>. Это означает, что <strong>студенты не будут уведомлены</strong> на сайте или по электронной почте о любых сообщениях, которые вы публикуете на этом форуме.';
$string['showhintforumnotificationssetting'] = 'Показывать подсказку об уведомлениях форума в скрытых курсах';
$string['showhintforumnotificationssetting_desc'] = 'При такой настройке подсказка будет отображаться не только в заголовке, но и на форумах курса, пока курс скрыт. Это делается для того, чтобы помочь преподавателям понять, что уведомления в форуме не отправляются студентам.';
$string['shownavbarstarredcourses_config'] = 'Добавить избранные курсы на страницу «Мои курсы».';
$string['shownavbarstarredcourses_label'] = 'Избранные курсы';
$string['shownavbarstarredcoursessetting'] = 'Показывать всплывающее меню избранных курсов на панели навигации';
$string['shownavbarstarredcoursessetting_desc'] = 'С помощью этого параметра можно отображать всплывающее меню со ссылками на курсы, отмеченные звездами, рядом с меню сообщений и уведомлений.';
$string['showsitehomerighthandblockdraweronfirstloginsetting'] = 'Показывать правую боковую панель на домашней странице сайта при первом входе в систему';
$string['showsitehomerighthandblockdraweronfirstloginsetting_desc'] = 'С помощью этой настройки правая боковая панель главной страницы сайта по умолчанию будет отображаться в развернутом состоянии. Это относится только к пользователям, которые входят в систему в первый раз, и не переписывает состояние переключения для каждого отдельного пользователя.';
$string['showsitehomerighthandblockdraweronguestloginsetting'] = 'Показывать правую боковую панель на домашней странице сайта при входе гостем';
$string['showsitehomerighthandblockdraweronguestloginsetting_desc'] = 'С помощью этой настройки правая боковая панель главной страницы сайта по умолчанию будет отображаться в развернутом состоянии. Это относится только к пользователям, которые вошли в систему как гость.';
$string['showsitehomerighthandblockdraweronvisitsetting'] = 'Показывать правую боковую панель  при посещении домашней страницы сайта';
$string['showsitehomerighthandblockdraweronvisitsetting_desc'] = 'С помощью этой настройки правая боковая панель главной страницы сайта по умолчанию будет отображаться в развернутом состоянии. Это относится только к пользователям, не вошедшим в систему, и не перезаписывает состояние переключения для каждого отдельного пользователя.';
$string['showswitchedroleincoursesetting'] = 'Отображать подсказку о переключенной роли';
$string['showswitchedroleincoursesetting_desc'] = 'При включенном параметре в заголовке курса появится подсказка, если пользователь сменил роль в курсе. По умолчанию эта информация отображается только рядом с аватаром пользователя в меню пользователя. Включив эту опцию, вы сможете показывать эту информацию (вместе со ссылкой для переключения обратно) также и на странице курса.';
$string['showviewcourseiconincoursemgntsesetting_desc'] = 'По умолчанию <a href="{$a}">на странице управления курсами</a> Moodle требует, чтобы вы открыли сведения о курсе либо настройки курса, прежде чем вы сможете щелкнуть дополнительный элемент пользовательского интерфейса для просмотра курса. Включив этот параметр, вы можете добавить значок «Просмотреть курс» непосредственно в списке категорий на странице управления курсами.';
$string['showviewcourseiconincoursemgntsetting'] = 'Показать значок просмотра курса';
$string['sitebrandingtab'] = 'Фирменный стиль сайта';
$string['sitehomerighthandblockdrawerbehaviour'] = 'Правая боковая панель на домашней странице сайта';
$string['slidebackgroundimagealtsetting'] = 'Атрибут «alt» фонового изображения слайда {$a->no}';
$string['slidebackgroundimagealtsetting_desc'] = 'Здесь вы можете задать атрибут «alt» для изображения слайда {$a->no}. Это необязательный параметр, слайд будет показан, даже если вы не зададите атрибут «alt». Обратите внимание, что отсутствие атрибута «alt» снижает доступность.';
$string['slidebackgroundimagesetting'] = 'Фоновое изображение слайда {$a->no}';
$string['slidebackgroundimagesetting_desc'] = 'Здесь вы можете загрузить файл изображения, который будет отображаться в качестве фонового рисунка за содержимым слайда {$a->no}. Пожалуйста, проверьте, что содержимое читаемо на фоновом изображении. Также постарайтесь, чтобы соотношение сторон фоновых изображений всех слайдов было одинаковым (поскольку соотношение сторон фонового изображения контролирует высоту слайда, и вы сможете избежать дерганья при смене слайдов). Это обязательная настройка, слайд не будет показан, если вы не загрузите какое-либо фоновое изображение.';
$string['slidecaptionsetting'] = 'Заголовок слайда {$a->no}';
$string['slidecaptionsetting_desc'] = 'Здесь вы вводите надпись, которая должна отображаться на слайде {$a->no} в его нижней центральной части. Это необязательная настройка, слайд будет показан, даже если вы не зададите заголовок.';
$string['slidecontentsetting'] = 'Содержимое слайда {$a->no}';
$string['slidecontentsetting_desc'] = 'Здесь вы вводите содержимое, которое должно отображаться на слайде {$a->no}. Содержимое отображается в нижней центральной части слайда. Если задан заголовок, то содержимое отображается под ним. Обратите внимание, что по умолчанию редактор выравнивает текст по левому краю, но вы можете изменить его на выровненный по центру, чтобы он выглядел более красиво. Также воздержитесь от добавления слишком большого количества контента на слайд и протестируйте его на маленьких устройствах, так как контент, который переполняет слайд, будет просто скрыт. Это необязательная настройка, слайд будет показан, даже если вы не зададите никакого содержимого.';
$string['slidecontentstylesetting'] = 'Стиль содержимого слайда {$a->no}';
$string['slidecontentstylesetting_dark'] = 'Темный (черный цвет шрифта для светлых фоновых изображений)';
$string['slidecontentstylesetting_darkshadow'] = 'Темный и тень (черный цвет шрифта с легкой тенью для светлых фоновых изображений)';
$string['slidecontentstylesetting_desc'] = 'Здесь вы можете изменить стиль содержимого слайда {$a->no}. По умолчанию стиль содержимого - это белый цвет шрифта для темных фоновых изображений. Однако, чтобы обеспечить единообразие и простоту оформления для всех видов фоновых изображений, вы можете переопределить стиль здесь. Обратите внимание, что эта настройка в любом случае отменяет цвет шрифта, который выше вы задали в редакторе.';
$string['slidecontentstylesetting_light'] = 'Светлый (белый цвет шрифта для темных фоновых изображений)';
$string['slidecontentstylesetting_lightshadow'] = 'Свет и тень (белый цвет шрифта с темной тенью для темных фоновых изображений)';
$string['slideenabledsetting'] = 'Включить слайд {$a->no}';
$string['slideenabledsetting_desc'] = 'С помощью этой настройки вы можете включить слайд {$a->no}';
$string['slideheading'] = 'Слайд {$a->no}';
$string['slidelinksetting'] = 'URL-адрес ссылки слайда {$a->no}';
$string['slidelinksetting_desc'] = 'Здесь вы можете задать (внутренний или внешний) URL, на который будет ссылаться содержимое слайда {$a->no}. Это необязательный параметр, слайд будет показан, даже если вы не зададите URL ссылки.';
$string['slidelinksourcesetting'] = 'Источник ссылки слайда {$a->no}';
$string['slidelinksourcesetting_both'] = 'Фоновое изображение и текстовые элементы';
$string['slidelinksourcesetting_desc'] = 'Здесь вы можете управлять тем, какие элементы слайдера будут ссылаться на заданный URL-адрес ссылки. Вы можете связать ссылку только с фоновым изображением или только с текстовыми элементами слайда (заголовок и содержимое) или связать ссылку с обоими этими элементами.';
$string['slidelinksourcesetting_image'] = 'Только фоновое изображение';
$string['slidelinksourcesetting_text'] = 'Только текстовые элементы';
$string['slidelinktargetsetting'] = 'Цель ссылки слайда {$a->no}';
$string['slidelinktargetsetting_desc'] = 'Здесь вы можете задать цель ссылки, которая устанавливается для ссылки слайда, как только вы зададите URL ссылки в слайде {$a->no}.';
$string['slidelinktargetsetting_newtab'] = 'Новая вкладка';
$string['slidelinktargetsetting_samewindow'] = 'Это окно';
$string['slidelinktitlesetting'] = 'Заголовок ссылки слайда {$a->no}';
$string['slidelinktitlesetting_desc'] = 'Здесь вы можете задать заголовок ссылки, который будет представлен в виде всплывающей подсказки, как только пользователь наведет курсор на слайд {$a->no}. Это необязательный параметр, ссылка будет создана, даже если вы не зададите заголовок ссылки. Обратите внимание, что отсутствие заголовка ссылки снижает доступность.';
$string['slideordersetting'] = 'Порядковый номер слайда {$a->no}';
$string['slideordersetting_desc'] = 'С помощью этой настройки вы определяете порядок представления слайдов. По умолчанию слайды упорядочены так, как вы видите их на этой странице настроек. Однако с помощью этого параметра вы можете назначить другую последовательность. Если вы назначите одну и ту же позицию двум или более слайдам, они будут упорядочены в соответствии с расположением на этой странице.';
$string['slideranimationsetting'] = 'Тип анимации слайдера';
$string['slideranimationsetting_desc'] = 'С помощью этого параметра вы управляете анимацией слайдера. Возможно скольжение, затухание или отсутствие анимации.';
$string['slideranimationsetting_fade'] = 'Затухание';
$string['slideranimationsetting_none'] = 'Нет';
$string['slideranimationsetting_slide'] = 'Скольжение';
$string['sliderarrownavsetting'] = 'Включить навигацию стрелками';
$string['sliderarrownavsetting_desc'] = 'С помощью этой настройки вы можете добавить навигационные стрелки с обеих сторон слайдера.';
$string['sliderfrontpagepositionsetting'] = 'Позиция слайдера на главной странице';
$string['sliderfrontpagepositionsetting_afterafter'] = 'После основного содержимого сайта (и после рекламных плиток)';
$string['sliderfrontpagepositionsetting_afterbefore'] = 'После основного содержимого сайта (но перед рекламными плитками)';
$string['sliderfrontpagepositionsetting_beforeafter'] = 'Перед основным содержимым сайта (и после рекламных плиток)';
$string['sliderfrontpagepositionsetting_beforebefore'] = 'Перед основным содержимым сайта (но перед рекламными плитками)';
$string['sliderfrontpagepositionsetting_desc'] = 'Слайдер отображается только на главной странице сайта. С помощью этой настройки вы контролируете, будет ли слайдер отображаться перед содержимым главной страницы сайта или после него. Если вы хотите показывать только слайдер на главной странице сайта и ничего больше, все остальное содержимое главной страницы сайта можно удалить, изменив <a href="{$a->url}">настройки главной страницы сайта</a>.';
$string['slidergeneralheading'] = 'Общие настройки слайдеров';
$string['sliderindicatornavsetting'] = 'Включите навигацию по меткам слайдера';
$string['sliderindicatornavsetting_desc'] = 'С помощью этой настройки вы можете добавить навигационные метки в нижней части слайдера.';
$string['sliderintervalsetting'] = 'Скорость слайдера';
$string['sliderintervalsetting_desc'] = 'С помощью этого параметра вы управляете продолжительностью показа слайда в миллисекундах. Минимальное значение - 1000 (одна секунда), максимальное - 10000 (10 секунд).';
$string['sliderkeyboardsetting'] = 'Разрешить взаимодействие слайдера с клавиатурой';
$string['sliderkeyboardsetting_desc'] = 'С помощью этой настройки вы разрешаете использовать клавиатуру (клавиши со стрелками) для управления слайдером. Обратите внимание, что отключение этого параметра снижает доступность.';
$string['sliderpausesetting'] = 'Пауза слайдера при наведении курсора';
$string['sliderpausesetting_desc'] = 'С помощью этой настройки вы запрещаете слайдеру циклически переходить по слайдам, когда пользователь наводит курсор на слайд. Обратите внимание, что отключение этого параметра снижает доступность.';
$string['sliderridesetting'] = 'Переключение слайдов';
$string['sliderridesetting_afterinteraction'] = 'После взаимодействия';
$string['sliderridesetting_desc'] = 'С помощью этой настройки вы управляете поведением слайдера. «При загрузке страницы» - переключение слайдов начинается после завершения загрузки страницы. «После взаимодействия» - переключение начинается после того, как пользователь взаимодействовал со слайдером. «Никогда» - вообще отключает автоматическую смену слайдов, требуя от пользователя ручного переключения слайдов.';
$string['sliderridesetting_never'] = 'Никогда';
$string['sliderridesetting_onpageload'] = 'При загрузке страницы';
$string['slidertab'] = 'Слайдер';
$string['sliderwrapsetting'] = 'Непрерывный цикл просмотра слайдов';
$string['sliderwrapsetting_desc'] = 'С помощью этой настройки вы заставите слайдер циклически перемещаться по всем слайдам. Если отключить эту настройку, он остановится на последнем слайде.';
$string['smartmenus'] = 'Умные меню';
$string['smartmenus_desc'] = '<p>Умные меню позволяют администраторам сайта создавать настраиваемые меню, которые можно размещать в разных местах сайта, например в главном меню сайта, нижнем мобильном меню и меню пользователя. Меню можно настроить на отображение различных типов контента, включая ссылки на другие страницы или ресурсы, ссылки на категории или профили пользователей.</p><p>Администраторы сайта могут создать новое меню, указать пункты меню и настройки отображения. Администратор также может выбрать, где будет отображаться меню на сайте и должно ли оно быть видно всем пользователям или только  пользователям с определенными ролями.</p> <p>';
$string['smartmenusbycohort'] = 'По глобальной группе';
$string['smartmenusbycohort_help'] = 'Ограничить видимость на основе глобальных групп пользователей.';
$string['smartmenusbydate'] = 'По дате';
$string['smartmenusbydate_help'] = 'Ограничить видимость на основе даты.';
$string['smartmenusbydatefrom'] = 'С';
$string['smartmenusbydatefrom_help'] = 'Ограничить видимость до достижения заданной даты';
$string['smartmenusbydateuntil'] = 'По';
$string['smartmenusbydateuntil_help'] = 'Ограничить видимость после достижения заданной даты';
$string['smartmenusbylanguage'] = 'По языку';
$string['smartmenusbylanguage_help'] = 'Ограничить видимость на основе языка пользователя';
$string['smartmenusbyrole'] = 'По роли';
$string['smartmenusbyrole_help'] = 'Ограничить видимость на основе ролей пользователей.';
$string['smartmenusdynamiccoursescompletionstatus'] = 'Статус завершения';
$string['smartmenusdynamiccoursescompletionstatus_help'] = 'Список пунктов меню динамических курсов будет содержать все курсы пользователя, соответствующие выбранному статусу завершения. Например, если в качестве статуса завершения выбрать "В процессе", список пунктов меню будет содержать только те курсы, над которыми пользователь в данный момент работает.';
$string['smartmenusdynamiccoursescompletionstatuscompleted'] = 'Завершен';
$string['smartmenusdynamiccoursescompletionstatusenrolled'] = 'Зачислен';
$string['smartmenusdynamiccoursescompletionstatusinprogress'] = 'В процессе';
$string['smartmenusdynamiccoursescoursecategory'] = 'Категория курса';
$string['smartmenusdynamiccoursescoursecategory_help'] = 'Список пунктов меню динамических курсов будет содержать все курсы из выбранных категорий курсов.';
$string['smartmenusdynamiccoursescoursecategorysubcats'] = 'Включить подкатегории';
$string['smartmenusdynamiccoursescoursecategorysubcats_help'] = 'При установленном флажке динамическое меню курсов также будет содержать все курсы из подкатегорий выбранных категорий курсов.';
$string['smartmenusdynamiccoursesdaterange'] = 'Диапазон дат';
$string['smartmenusdynamiccoursesdaterange_help'] = 'Список пунктов меню динамических курсов будет содержать все курсы, которые попадают в выбранный диапазон дат.';
$string['smartmenusdynamiccoursesdaterangefuture'] = 'Будущее';
$string['smartmenusdynamiccoursesdaterangepast'] = 'Прошлое';
$string['smartmenusdynamiccoursesdaterangepresent'] = 'Настоящее время';
$string['smartmenusdynamiccoursesenrolmentrole'] = 'Роль при зачислении';
$string['smartmenusdynamiccoursesenrolmentrole_help'] = 'Список пунктов меню динамических курсов будет содержать все курсы, на которые зачислен пользователь с выбранной ролью.';
$string['smartmenusexperimental'] = 'Обратите внимание: функционал умных меню полностью готов к использованию в текущей реализации, но она должна рассматриваться как <em>экспериментальная</em> из-за большого числа комбинаций настроек, могущих вызвать неожиданные проблемы. В связи с этим тщательно протестируйте свои индивидуальные настройки умных меню. Если вы столкнулись с какими-либо проблемами, сообщите о них на <a href="https://github.com/moodle-an-hochschulen/moodle-theme_boost_union/issues">Github</a> с четким описанием проблемы.';
$string['smartmenusgeneralsectionheader'] = 'Общие настройки';
$string['smartmenusmenuaddnewitem'] = 'Добавить элемент меню';
$string['smartmenusmenucardform'] = 'Форма карточки';
$string['smartmenusmenucardform_help'] = 'Выберите форму карточки для меню, выбрав квадратную, книжную, альбомную или во всю ширину.';
$string['smartmenusmenucardformfullwidth'] = 'Во всю ширину';
$string['smartmenusmenucardformlandscape'] = 'Альбомная';
$string['smartmenusmenucardformportrait'] = 'Книжная';
$string['smartmenusmenucardformsquare'] = 'Квадратная';
$string['smartmenusmenucardoverflowbehavior'] = 'Поведение карточки при переполнении';
$string['smartmenusmenucardoverflowbehavior_help'] = 'Выберите, как себя должно вести меню при переполнении контейнера, выбирая между отображением полосы прокрутки или переносом «лишних» пунктов на другую строку.';
$string['smartmenusmenucardoverflowbehaviornowrap'] = 'Не переносить';
$string['smartmenusmenucardoverflowbehaviorwrap'] = 'Перенести';
$string['smartmenusmenucardsize'] = 'Размер карточки';
$string['smartmenusmenucardsize_help'] = 'Выберите размер карточки для карточного меню, выбирая между крошечным, маленьким, средним или большим.';
$string['smartmenusmenucardsizelarge'] = 'Большой';
$string['smartmenusmenucardsizemedium'] = 'Средний';
$string['smartmenusmenucardsizesmall'] = 'Маленький';
$string['smartmenusmenucardsizetiny'] = 'Крошечный';
$string['smartmenusmenucreate'] = 'Создать меню';
$string['smartmenusmenucreatesuccess'] = 'Умное меню успешно создано';
$string['smartmenusmenucssclass'] = 'Класс CSS';
$string['smartmenusmenucssclass_help'] = 'Введите CSS-класс для меню. С его помощью можно применить к меню пользовательский стиль.';
$string['smartmenusmenudeleteconfirm'] = 'Вы уверены, что хотите удалить это меню из умных меню?';
$string['smartmenusmenudeletesuccess'] = 'Умное меню успешно удалено';
$string['smartmenusmenudescription'] = 'Описание';
$string['smartmenusmenudescription_help'] = 'Описание меню. Оно будет использоваться в основном как внутренняя документация, но вы также можете показать его в меню с помощью опции "Показать описание".';
$string['smartmenusmenuduplicate'] = 'Дублировать меню и его элементы';
$string['smartmenusmenuduplicatesuccess'] = 'Меню и его элементы успешно продублированы';
$string['smartmenusmenuedit'] = 'Редактировать меню';
$string['smartmenusmenueditsuccess'] = 'Умное меню успешно обновлено';
$string['smartmenusmenuitemcardappearanceheader'] = 'Внешний вид карточки';
$string['smartmenusmenuitemcardbackgroundcolor'] = 'Цвет фона карточки';
$string['smartmenusmenuitemcardbackgroundcolor_help'] = 'Выберите цвет фона для карточки пункта меню';
$string['smartmenusmenuitemcardimage'] = 'Изображение карточки';
$string['smartmenusmenuitemcardimage_help'] = 'Выберите изображение, которое будет отображаться рядом с названием пункта меню на карточке.';
$string['smartmenusmenuitemcardtextcolor'] = 'Цвет текста на карточке';
$string['smartmenusmenuitemcardtextcolor_help'] = 'Выберите цвет пункта меню карточки.';
$string['smartmenusmenuitemcreate'] = 'Создать пункт меню';
$string['smartmenusmenuitemcreatesuccess'] = 'Пункт умного меню создан';
$string['smartmenusmenuitemcssclass'] = 'Класс CSS';
$string['smartmenusmenuitemcssclass_help'] = 'Введите класс CSS для пункта меню. Это можно использовать для применения индивидуального стиля к пункту меню.';
$string['smartmenusmenuitemdeleteconfirm'] = 'Вы уверены, что хотите удалить этот пункт из умного меню?';
$string['smartmenusmenuitemdeletesuccess'] = 'Пункт умного меню удален';
$string['smartmenusmenuitemdisplayfield'] = 'Представление названия курса';
$string['smartmenusmenuitemdisplayfield_help'] = 'Название курса, которое будет использоваться в качестве заголовка пунктов меню динамических курсов. Выберите  полное или краткое название курса.';
$string['smartmenusmenuitemdisplayfieldcoursefullname'] = 'Полное название курса';
$string['smartmenusmenuitemdisplayfieldcourseshortname'] = 'Короткое название курса';
$string['smartmenusmenuitemdisplayoptions'] = 'Представление заголовка';
$string['smartmenusmenuitemdisplayoptions_help'] = 'Выберите, как будет отображаться заголовок пункта меню.';
$string['smartmenusmenuitemdisplayoptionshidetitle'] = 'Скрыть текст заголовка и показать только иконку (на всех устройствах)';
$string['smartmenusmenuitemdisplayoptionshidetitlemobile'] = 'Скрыть текст заголовка и показать только иконку (на мобильных устройствах)';
$string['smartmenusmenuitemdisplayoptionsshowtitleicon'] = 'Показать текст и значок заголовка';
$string['smartmenusmenuitemduplicate'] = 'Дублировать пункт меню';
$string['smartmenusmenuitemduplicatesuccess'] = 'Пункт меню успешно продублирован';
$string['smartmenusmenuitemedit'] = 'Редактировать элемент меню';
$string['smartmenusmenuitemeditsuccess'] = 'Элемент умного меню успешно обновлен';
$string['smartmenusmenuitemicon'] = 'Иконка';
$string['smartmenusmenuitemicon_help'] = 'Значок, который будет отображаться рядом с заголовком пункта меню.';
$string['smartmenusmenuitemlinktarget'] = 'Цель ссылки';
$string['smartmenusmenuitemlinktarget_help'] = 'Цель для ссылки пункта меню. При нажатии на ссылку пункта меню она будет открываться в этой цели (т. е. в том же окне или в новой вкладке).';
$string['smartmenusmenuitemlinktargetnewtab'] = 'Новая вкладка';
$string['smartmenusmenuitemlinktargetsamewindow'] = 'То же окно';
$string['smartmenusmenuitemlistsort'] = 'Сортировка списка курсов';
$string['smartmenusmenuitemlistsort_help'] = 'Список курсов будет отсортирован по выбранным критериям и порядку сортировки. Выберите между полным названием, кратким названием, ID курса и номером идентификатора курса в качестве критериев в сочетании с порядком сортировки по возрастанию или убыванию.';
$string['smartmenusmenuitemlistsortcourseidasc'] = 'ID курса - по возрастанию';
$string['smartmenusmenuitemlistsortcourseiddesc'] = 'ID курса - по убыванию';
$string['smartmenusmenuitemlistsortcourseidnumberasc'] = 'Идентификационный номер курса - по возрастанию';
$string['smartmenusmenuitemlistsortcourseidnumberdesc'] = 'Идентификационный номер курса - по убыванию';
$string['smartmenusmenuitemlistsortfullnameasc'] = 'Полное название курса - по возрастанию';
$string['smartmenusmenuitemlistsortfullnamedesc'] = 'Полное название курса - по убыванию';
$string['smartmenusmenuitemlistsortshortnameasc'] = 'Краткое название курса - по возрастанию';
$string['smartmenusmenuitemlistsortshortnamedesc'] = 'Краткое название курса - по убыванию';
$string['smartmenusmenuitemmode'] = 'Режим пункта меню';
$string['smartmenusmenuitemmode_help'] = '<p>Выберите режим отображения пункта в меню.</p><ul><li>Линейный: пункт меню отображается как обычный пункт внутри меню. Это опция по умолчанию.</li><li>Подменю: пункт меню отображается как элемент подменю, который можно развернуть или свернуть, щелкнув родительский элемент. Этот режим полезен для построения третьего уровня навигации, а также для  пунктов меню динамических курсов, где списки курсов могут отображаться как пункты подменю этого пункта меню. Название такого пункта меню используется в качестве текста пункта подменю.</li></ul>';
$string['smartmenusmenuitemnothingtodisplay'] = 'В это умное меню пока не добавлено ни одного пункта. Добавьте пункт в это меню.';
$string['smartmenusmenuitemorder'] = 'Порядок';
$string['smartmenusmenuitemorder_help'] = 'При необходимости измените положение элемента. Все пункты в меню будут отсортированы в этом порядке.';
$string['smartmenusmenuitempresentationheader'] = 'Представление пункта меню';
$string['smartmenusmenuitemresponsive'] = 'Скрыть пункт меню';
$string['smartmenusmenuitemresponsive_help'] = 'При установке любого из этих флажков пункт меню будет скрыт на устройствах с указанным размером дисплея.';
$string['smartmenusmenuitemresponsivedesktop'] = 'Компьютер';
$string['smartmenusmenuitemresponsivemobile'] = 'Мобильный';
$string['smartmenusmenuitemresponsivetablet'] = 'Планшет';
$string['smartmenusmenuitemrestriction'] = 'Правила доступа';
$string['smartmenusmenuitems'] = 'Пункты меню';
$string['smartmenusmenuitemstructureheader'] = 'Структура пунктов меню';
$string['smartmenusmenuitemtextcount'] = 'Количество слов';
$string['smartmenusmenuitemtextcount_help'] = 'Укажите максимальное количество слов, которые будут отображаться в качестве заголовка в пунктах меню динамических курсов. Если вы оставите это поле пустым, заголовок будет отображаться полностью.';
$string['smartmenusmenuitemtextposition'] = 'Положение текста карточки';
$string['smartmenusmenuitemtextposition_help'] = '';
$string['smartmenusmenuitemtextpositionbelowimage'] = 'Ниже изображения';
$string['smartmenusmenuitemtextpositionoverlaybottom'] = 'Нижнее наложение';
$string['smartmenusmenuitemtextpositionoverlaytop'] = 'Верхнее наложение';
$string['smartmenusmenuitemtitle'] = 'Заголовок';
$string['smartmenusmenuitemtitle_help'] = 'Заголовок меню. Он будет использоваться в качестве метки этого пункта меню. Если вы хотите отобразить разделитель в меню, выберите тип "Заголовок", а в качестве заголовка используйте хэш-знаки (###).';
$string['smartmenusmenuitemtooltip'] = 'Всплывающая подсказка';
$string['smartmenusmenuitemtooltip_help'] = 'Подсказка, которая будет отображаться при наведении курсора на пункт меню.';
$string['smartmenusmenuitemtype'] = 'Тип пункта меню';
$string['smartmenusmenuitemtype_help'] = '<p>Выберите тип пункта меню, который вы хотите создать, выбрав между статическим, заголовочным или динамическими курсами.</p><ul><li>Статический: статический пункт меню — это просто ссылка на фиксированный URL-адрес, который не изменяется.</li><li>Заголовок: пункт меню заголовка используется для группирования связанных пунктов меню под общим заголовком. Он не имеет ссылки и не доступен для кликов.</li><li>Динамические курсы: пункт меню динамических курсов используется для отображения списка курсов на основе определенных критериев, таких как категория курса, роль участника в курсе, состояние завершения курса или диапазон дат. Содержимое, отображаемое в пункте меню динамических курсов, будет обновляться автоматически при изменении критериев.</li></ul>';
$string['smartmenusmenuitemtypedynamiccourses'] = 'Динамические курсы';
$string['smartmenusmenuitemtypeheading'] = 'Заголовок';
$string['smartmenusmenuitemtypestatic'] = 'Статический';
$string['smartmenusmenuitemurl'] = 'URL-адрес пункта меню';
$string['smartmenusmenuitemurl_help'] = 'Статический URL-адрес пункта меню. Это ссылка, по которой будет переход при выборе пункта меню.';
$string['smartmenusmenulocation'] = 'Положение(я) меню';
$string['smartmenusmenulocation_help'] = '<p>Выберите место(а) отображения меню на странице:</p><ul><li>Основная навигация находится в верхней части страницы, где отображаются  элементы навигации по администрированию сайта и «В начало», «Личный кабинет», «Мои курсы».</li><li>Строка меню расположена над основной навигацией в верхней части страницы.</li><li>Доступ к меню пользователя можно получить, щелкнув пользователя или его аватар на панели навигации.</li><li>Нижняя панель расположена в нижней части экрана и может использоваться для навигации с помощью большого пальца для быстрого доступа к важным областям, таким как «В начало», «Личный кабинет», «Мои курсы».</li></ul><p>Обратите внимание, что после включения нижней панели значок гамбургера будет заменен логотипом вашего сайта, поскольку пользователи смогут перейти к основной навигации, используя нижнюю панель.</li></ul><p>Обратите внимание, что при включении нижней панели значок «гамбургера» будет заменен логотипом вашего сайта, поскольку пользователи смогут перейти к основной навигации, используя нижнюю панель.</ р>';
$string['smartmenusmenulocationbottom'] = 'Нижняя панель';
$string['smartmenusmenulocationmain'] = 'Панель навигации';
$string['smartmenusmenulocationmenu'] = 'Строка меню';
$string['smartmenusmenulocationuser'] = 'Меню пользователя';
$string['smartmenusmenumode'] = 'Режим меню';
$string['smartmenusmenumode_help'] = '<p>Выберите режим отображения пунктов меню.</p><ul><li>
Подменю: Элементы меню отображаются в виде подменю с заголовком меню в качестве родительского узла. Это вариант по умолчанию.</li><li>
Линейный: Элементы меню отображаются непосредственно в навигации, один за другим. Обратите внимание, что эта опция не поддерживается для меню типа карточки.</li></ul>';
$string['smartmenusmenumoremenubehavior'] = 'Дополнительное поведение меню';
$string['smartmenusmenumoremenubehavior_help'] = '<p>Выберите, что должно произойти, если меню слишком большое, чтобы поместиться в заданном расположении.</p><ul><li>Ничего не менять: Никакого особого поведения не будет, лишние меню будут автоматически перемещены в меню «Дополнительно».</li><li>Переместить в меню «Дополнительно»: Этот режим перемещает меню непосредственно в меню «Дополнительно», даже если еще есть свободное место.</li><li>Держать вне меню «Дополнительно»: Этот режим позволяет удерживать меню вне меню «Дополнительно» как можно дольше — при необходимости перемещая другие последующие меню в меню «Дополнительно».</li></ul><p>Обратите внимание, что эта настройка влияет только на меню, которые расположены в основной навигации или в области строки меню.</p>';
$string['smartmenusmenumoremenubehaviorforceinto'] = 'Переместить в меню «Дополнительно»';
$string['smartmenusmenumoremenubehaviorkeepoutside'] = 'Держать вне меню «Дополнительно»';
$string['smartmenusmenunothingtodisplay'] = 'Еще не создано ни одного умного меню. Пожалуйста, создайте свое первое умное меню, чтобы начать работу.';
$string['smartmenusmenupresentationheader'] = 'Представление меню';
$string['smartmenusmenushowdescription'] = 'Показать описание';
$string['smartmenusmenushowdescription_help'] = '<p>Выберите, должно ли в меню отображаться описание. Варианты: «Никогда», «Выше», «Ниже» и «Помощь».</p><ul><li>Никогда: Не показывать описание в меню и использовать его только для внутренних целей. Это вариант по умолчанию.</li><li>Выше: Показывать описание выше списка пунктов меню.</li><li>Ниже: Показывать описание ниже списка пунктов меню.</li><li>Помощь: Показать описание в виде значка помощи рядом со списком пунктов меню.</li></ul>';
$string['smartmenusmenushowdescriptionabove'] = 'Выше';
$string['smartmenusmenushowdescriptionbelow'] = 'Ниже';
$string['smartmenusmenushowdescriptionhelp'] = 'Помощь';
$string['smartmenusmenushowdescriptionnever'] = 'Никогда';
$string['smartmenusmenustructureheader'] = 'Структура меню';
$string['smartmenusmenutitle'] = 'Заголовок';
$string['smartmenusmenutitle_help'] = 'Заголовок меню. Он будет использоваться в качестве метки родительского узла этого меню.';
$string['smartmenusmenutype'] = 'Тип представления';
$string['smartmenusmenutype_help'] = '<p>Выберите тип представления меню, выбирая между списком и карточкой.</p><ul><li>Список: Меню состоит из простых текстовых ссылок. Это вариант по умолчанию.</li><li>Карточки: Меню состоит из карточек.</li></ul>';
$string['smartmenusmenutypecard'] = 'Карточки';
$string['smartmenusmenutypelist'] = 'Список';
$string['smartmenusmodeinline'] = 'Линейный';
$string['smartmenusmodesubmenu'] = 'Подменю';
$string['smartmenusnorestrict'] = 'Без ограничений';
$string['smartmenusoperator'] = 'Оператор';
$string['smartmenusoperator_help'] = 'Выберите оператор для условия глобальной группы (Любой или Все)';
$string['smartmenusrestrictbycohortsheader'] = 'Ограничить видимость по глобальным группам';
$string['smartmenusrestrictbydateheader'] = 'Ограничить видимость по дате';
$string['smartmenusrestrictbylanguageheader'] = 'Ограничить видимость по языку';
$string['smartmenusrestrictbyrolesheader'] = 'Ограничить видимость по ролям';
$string['smartmenusrolecontext'] = 'Контекст';
$string['smartmenusrolecontext_help'] = 'Выберите контекст, для которого необходимо проверить роль пользователя (Любой контекст или только уровень системы).';
$string['smartmenussavechangesandconfigure'] = 'Сохранить и настроить элементы';
$string['smartmenussettings'] = 'Настройки умного меню';
$string['speciallinksmarkupheading'] = 'Разметка специальных ссылок';
$string['staticpagestab'] = 'Статические страницы';
$string['switchedroleto'] = 'В настоящий момент вы просматриваете этот курс с ролью: <strong>{$a->role}</strong>';
$string['task_purgecache'] = 'Очистить кэш темы';
$string['tilebackgroundimagepositionsetting'] = 'Расположение фонового рисунка рекламной плитки {$a->no}';
$string['tilebackgroundimagepositionsetting_desc'] = 'Этот параметр управляет позиционированием фонового изображения внутри контейнера рекламной плитки {$a->no}. Первое значение - положение по горизонтали, второе - по вертикали.';
$string['tilebackgroundimagesetting'] = 'Фоновое изображение рекламной плитки {$a->no}';
$string['tilebackgroundimagesetting_desc'] = 'Здесь вы можете загрузить файл изображения, который будет использоваться в качестве фонового изображения за содержимым рекламной плитки {$a->no}. Проверьте, что содержимое читаемо на фоновом изображении. Это необязательная настройка, рекламная плитка будет работать, даже если вы не загрузите никакого фонового изображения.';
$string['tilecolumnssetting'] = 'Количество колонок рекламных плиток в ряду';
$string['tilecolumnssetting_desc'] = 'Здесь вы определяете количество колонок в ряду в представленной сетке рекламных плиток. Обратите внимание, что это количество столбцов относится к настольному компьютеру / большим экранам. На маленьких и мобильных экранах колонки рекламных плиток автоматически сворачиваются.';
$string['tilecontentsetting'] = 'Содержимое рекламной плитки {$a->no}';
$string['tilecontentsetting_desc'] = 'Здесь вы вводите содержимое, которое должно отображаться в рекламной плитке {$a->no}. Содержимое отображается в центре плитки. Это необязательный параметр, рекламная плитка будет отображаться, даже если вы не зададите никакого содержимого.';
$string['tilecontentstylesetting'] = 'Стиль содержимого рекламной плитки {$a->no}';
$string['tilecontentstylesetting_dark'] = 'Темный (черный цвет шрифта для светлых фоновых изображений)';
$string['tilecontentstylesetting_darkshadow'] = 'Темный и тень (черный цвет шрифта с легкой тенью для светлых фоновых изображений)';
$string['tilecontentstylesetting_desc'] = 'Здесь вы можете изменить стиль содержимого рекламной плитки {$a->no}. По умолчанию стиль содержимого соответствует стилю, который выше вы задали в редакторе. Однако, для обеспечения единообразия и простоты оформления, особенно при использовании текста на фоновых изображениях, вы можете переопределить стиль здесь.';
$string['tilecontentstylesetting_light'] = 'Светлый (белый цвет шрифта для темных фоновых изображений)';
$string['tilecontentstylesetting_lightshadow'] = 'Светлый и тень (белый цвет шрифта с темной тенью для темных фоновых изображений)';
$string['tilecontentstylesetting_nochange'] = 'Без изменений (управление всеми стилями в текстовом редакторе)';
$string['tileenabledsetting'] = 'Включить рекламную плитку {$a->no}';
$string['tileenabledsetting_desc'] = 'Эта настройка включает рекламную плитку {$a->no}';
$string['tilefrontpagepositionsetting'] = 'Размещение рекламных плиток на главной странице';
$string['tilefrontpagepositionsetting_after'] = 'После содержимого главной страницы';
$string['tilefrontpagepositionsetting_before'] = 'До содержимого главной страницы';
$string['tilefrontpagepositionsetting_desc'] = 'Рекламные плитки отображаются только на главной странице. Этот параметр определяет, будут ли рекламные плитки отображаться перед содержимым главной страницы сайта или после него. Если вы хотите показывать на главной странице сайта только рекламные плитки и ничего больше, всё остальное содержимое главной страницы сайта можно удалить, изменив <a href="{$a->url}">настройки главной страницы</a>.';
$string['tileheading'] = 'Рекламная плитка {$a->no}';
$string['tileheightsetting'] = 'Высота рекламной плитки';
$string['tileheightsetting_desc'] = 'С помощью этой настройки вы контролируете высоту рекламных плиток. Настроенная высота - это минимальная высота каждой плитки. Если содержимое плитки больше этой настроенной высоты, весь ряд плиток будет автоматически увеличен по мере необходимости.';
$string['tilelinksetting'] = 'URL ссылки рекламной плитки {$a->no}';
$string['tilelinksetting_desc'] = 'Здесь вы можете задать внутренний или внешний URL-адрес, который будет добавлен в качестве кнопки ссылки в конце рекламной плитки {$a->no}. Это необязательный параметр, рекламная плитка будет работать, даже если вы не зададите URL ссылки.';
$string['tilelinktargetsetting'] = 'Цель ссылки рекламной плитки {$a->no}';
$string['tilelinktargetsetting_desc'] = 'Здесь вы можете задать цель ссылки, которая устанавливается для кнопки ссылки, как только вы зададите URL ссылки в рекламной плитке {$a->no}.';
$string['tilelinktargetsetting_newtab'] = 'Новая вкладка';
$string['tilelinktargetsetting_samewindow'] = 'То же окно';
$string['tilelinktitlefallback'] = 'Ссылка';
$string['tilelinktitlesetting'] = 'Заголовок ссылки рекламной плитки {$a->no}';
$string['tilelinktitlesetting_desc'] = 'Здесь вы можете задать заголовок ссылки, который будет использоваться в качестве текста кнопки ссылки, если вы зададите URL ссылки в рекламной плитке {$a->no}. Обратите внимание, что если вы зададите URL ссылки, но не зададите заголовок ссылки, то кнопка ссылки будет обозначена как «Ссылка».';
$string['tileordersetting'] = 'Порядок сортировки рекламной плитки {$a->no}';
$string['tileordersetting_desc'] = 'С помощью этой настройки вы определяете порядок расположения рекламной плитки {$a->no}. По умолчанию рекламные плитки упорядочены сверху вниз и слева направо, как вы видите на этой странице настроек. Однако вы можете назначить другую позицию с помощью этой настройки. Если вы назначите одинаковое положение для двух или более рекламных плиток, они будут упорядочены в соответствии с порядком, указанным на этой странице настроек.';
$string['tilesgeneralheading'] = 'Общие настройка рекламных плиток';
$string['tilestab'] = 'Рекламные плитки';
$string['tiletitlesetting'] = 'Заголовок рекламной плитки {$a->no}';
$string['tiletitlesetting_desc'] = 'Здесь вы вводите заголовок, который должен отображаться в рекламной плитке {$a->no}. Это необязательный параметр, рекламная плитка будет показана, даже если вы не зададите заголовок.';
$string['timelineheading'] = 'Блок шкалы времени';
$string['timelinetintenabled'] = 'Тонировка значков элементов на шкале времени';
$string['timelinetintenabled_desc'] = 'С помощью этой настройки вы можете окрашивать значки элементов в блоке шкалы времени в зависимости от целей деятельности. По умолчанию  Moodle отображает их просто как черные значки.';
$string['touchiconfilesios'] = 'Файлы сенсорных значков для iOS';
$string['touchiconfilesios_desc'] = 'В этом разделе вы можете загрузить файлы, которые будут использоваться в качестве иконок на домашнем экране, как только сайт Moodle будет добавлен на домашний экран iOS в качестве закладки.';
$string['touchiconfilesios_example'] = 'Пример имени файла: apple-icon-152x152.png';
$string['touchiconfilesios_note'] = 'Рекомендуемые файлы имеют хороший размер для корректного отображения на современных устройствах iOS и должны быть предоставлены. Необязательные файлы также поддерживаются (или поддерживались ранее) устройствами iOS, но их следует рассматривать как необязательные, если только у вас нет конкретного устройства, которое необходимо поддерживать.';
$string['touchiconfilesios_optional'] = 'Дополнительные файлы для iOS:';
$string['touchiconfilesios_recommended'] = 'Рекомендованные файлы для iOS:';
$string['touchiconfilesioslist'] = 'Список файлов сенсорных значков для iOS';
$string['touchiconfilesioslist_desc'] = 'Это список файлов, которые вы загрузили в файловый раздел «Файлы сенсорных иконок для iOS».';
$string['touchiconlistiosoptionalmissing'] = 'Это дополнительный файл для использования в качестве сенсорного значка на устройствах iOS, и он не был загружен.';
$string['touchiconlistiosoptionaluploaded'] = 'Это дополнительный файл для использования в качестве сенсорного значка на устройствах iOS, и он был загружен.';
$string['touchiconlistiosrecommendedmissing'] = 'Это рекомендуемый файл для использования в качестве сенсорного значка на устройствах iOS, но он не был загружен должным образом.';
$string['touchiconlistiosrecommendeduploaded'] = 'Это рекомендуемый файл для использования в качестве сенсорного значка на устройствах iOS, и он был загружен.';
$string['upcomingeventsheading'] = 'Блок предстоящих событий';
$string['upcomingeventstintenabled'] = 'Тонировка значков предстоящих событий';
$string['upcomingeventstintenabled_desc'] = 'С помощью этой настройки вы можете окрашивать значки элементов в блоке предстоящих событий в зависимости от целей деятельности. По умолчанию Moodle отображает их просто как черные иконки.';
$string['upgradenotice_2022080922'] = 'Начиная с этого выпуска, Boost Union имеет настройки своего логотипа (и компактного логотипа) и больше не использует эти файлы из ядра Moodle';
$string['upgradenotice_2022080922_copied'] = 'Во время этого обновления значение параметра <strong>{$a}</strong> из настроек ядра Moodle было скопировано в параметр {$a} Boost Union. Пожалуйста, перепроверьте результат.';
$string['upgradenotice_2022080922_logo'] = 'логотип';
$string['upgradenotice_2022080922_logocompact'] = 'компактный логотип';
$string['upgradenotice_2022080922_notcopied'] = 'Параметр <strong>{$a}</strong> в Boost Union сейчас пуст. Если вы хотите использовать {$a} в Boost Union, просто задайте {$a} в настройках Boost Union позже.';
$string['usermenuheading'] = 'Меню пользователя';
