<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_aigne', language 'af', version '4.4'.
 *
 * @package     theme_aigne
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessibility'] = 'Toeganklikheid';
$string['accessibilitydesc'] = 'Toeganklikheidsinligting';
$string['accessibilitypage'] = '<h2 style="text-align: center">Hierdie is \'n voorbeeldbladsy</h2>
<p>&nbsp;</p>
<h2>Toeganklikheid/h2>
<p>Hier kan jy die hulpmiddels invoer wat op die webwerf geïnstalleer is
   vir maklike navigasie deur mense met gesiggestremdhede of beperkte beweeglikheid.</p>
<h2>Gegewe parameters::</h2>
  <ul>{$a->supportemail}</ul>
  <ul>{$a->sendemailtitle}</ul>
  <p>&nbsp;</p>';
$string['aco5alt1'] = 'Skryf die alternatiewe teks vir die bellows 1-prent hier';
$string['aco5alt2'] = 'Skryf die alternatiewe teks vir die bellows 2-prent hier';
$string['aco5alt3'] = 'Skryf die alternatiewe teks vir die bellows 3-prent hier';
$string['aco5alt4'] = 'Skryf die alternatiewe teks vir die bellows 4-prent hier';
$string['aco5alt5'] = 'Skryf die alternatiewe teks vir die bellows 5-prent hier';
$string['aco5cap1'] = 'Raia venenosa _ Teks van bellows 1';
$string['aco5cap2'] = 'Tubarão _ Teks van bellows 2';
$string['aco5cap3'] = 'Polvo _ Teks van bellows 3';
$string['aco5cap4'] = 'Peixe _ Teks van bellows 4';
$string['aco5cap5'] = 'Mergulho _ Teks van bellows 5';
$string['acoaalt1'] = 'Skryf die alternatiewe teks vir die bellows 1-prent hier';
$string['acoaalt2'] = 'Skryf die alternatiewe teks vir die bellows 2-prent hier';
$string['acoaalt3'] = 'Skryf die alternatiewe teks vir die bellows 3-prent hier';
$string['acoaalt4'] = 'Skryf die alternatiewe teks vir die bellows 4-prent hier';
$string['acoaalt5'] = 'Skryf die alternatiewe teks vir die bellows 5-prent hier';
$string['acoacap1'] = 'Pastenague _ Teks van bellows 1';
$string['acoacap2'] = 'Requin _ Teks van bellows 2';
$string['acoacap3'] = 'Pieuvre _ Teks van bellows 3';
$string['acoacap4'] = 'Poisson _ Teks van bellows 4';
$string['acoacap5'] = 'Bouteilles _ Teks van bellows 5';
$string['acoainfo1'] = 'Stel interessante inligting om in bellows 1 te vertoon, hier bekend';
$string['acoainfo2'] = 'Stel interessante inligting om in bellows 2 te vertoon, hier bekend';
$string['acoainfo3'] = 'Stel interessante inligting om in bellows 3 te vertoon, hier bekend';
$string['acoainfo4'] = 'Stel interessante inligting om in bellows 4 te vertoon, hier bekend';
$string['acoainfo5'] = 'Stel interessante inligting om in bellows 5 te vertoon, hier bekend';
$string['afternoon_greeting'] = 'Goeiemiddag!';
$string['aim'] = 'AIM-URL';
$string['aimdesc'] = 'Voer die URL van jou AIM-profiel in.
<a href="http://www.aim.com/" target="_blank"> (www.aim.com) .</a>';
$string['aletters'] = 'Letterspasiëring-effek';
$string['alettersdesc'] = 'Wanneer \'n skakel gesweef word, kan \'n letterspasiëring-effek daarvoor gestel word.
Kies die interval tussen die letters hier, en as jy daarmee verveeld is, kies die eerste opsie.
Let daarop dat \'n paar skakels by verstek geen letterspasiëring het nie.';
$string['alettersno'] = 'Geen letterspasiëring';
$string['backbody'] = 'Bladsyagtergrond';
$string['backbodydesc'] = 'As jy \'n prent wil byvoeg wat onderaan elke bladsy verskyn. <br />
Hierdie prent moet \'n JPG / PNG / GIF wees, minstens 775 px breed. Hou ook in gedagte wat in die Y-as (vertikaal) herhaal sal word.';
$string['backcolor'] = 'Agtergrondkleur';
$string['backcolordesc'] = 'As jy wil, kan jy \'n agtergrondkleur stel, eerder as om \'n prent te plaas. <br />
As jy die oorspronklike kleur wil behou, kies wit of tik # FFFFFF.';
$string['backlogo'] = 'Agtergrondprent van logo';
$string['backlogodesc'] = 'As jy wil, kan jy \'n agtergrondprent vir die logo insit. <br />
Hierdie prent moet \'n JPG / PNG / GIF met 200 px breed by 75 px hoog wees.';
$string['banner1alt'] = 'Skryf die alternatiewe teks vir die banierprent hier';
$string['banner1ttl'] = 'Skryf die baniertitel hier';
$string['banner1txt'] = 'Skryf die teks om in die banier te publiseer, hier';
$string['bcsep'] = 'Breadcrumb-spasieerder';
$string['bcsep1'] = 'Konvensionele Pyl ( ► )';
$string['bcsep2'] = 'Reghoekige aanhalingsteken ( » )';
$string['bcsep3'] = 'Vertikale staaf ( | )';
$string['bcsep4'] = 'Vorentoeskuinsstreep ( / )';
$string['bcsep5'] = 'Onderstreepteken ( _ )';
$string['bcsep6'] = 'Etlike dubbelpunte ( ::: )';
$string['bcsep7'] = 'Leë Spasie ( &nbsp; )';
$string['bcsepdesc'] = 'Kies die tipe skeier om in die Navigasiestafie te gebruik (Breadcrumb).';
$string['bgposition'] = 'Posisie van bladsyagtergrond';
$string['bgposition00'] = 'In koördinaat 0.0';
$string['bgposition01'] = 'bo';
$string['bgposition02'] = 'middel';
$string['bgposition03'] = 'onder';
$string['bgposition04'] = 'links';
$string['bgposition05'] = 'regs';
$string['bgposition06'] = 'links bo';
$string['bgposition07'] = 'middel bo';
$string['bgposition08'] = 'regs bo';
$string['bgposition09'] = 'middel-links';
$string['bgposition10'] = 'middel-middel';
$string['bgposition11'] = 'middel-regs';
$string['bgposition12'] = 'links onder';
$string['bgposition13'] = 'middel onder';
$string['bgposition14'] = 'regs onder';
$string['bgposition15'] = 'In die middel van die skerm';
$string['bgpositiondesc'] = 'Jy kan die oorsprongpunt vir daardie prent konfigureer, afhangend van die prenttipe.';
$string['bgrepeat'] = 'Herhaling van Bladsyagtergrond';
$string['bgrepeat01'] = 'Geen herhaling';
$string['bgrepeat02'] = 'Mosaïek';
$string['bgrepeat03'] = 'Herhaal oor X';
$string['bgrepeat04'] = 'Herhaal oor Y';
$string['bgrepeatdesc'] = 'Wanneer jy die vorige opsie stel, afhangend van die prenttipe, kan jy die gedrag daarvan konfigureer, kies of dit herhaal moet word en in watter rigting dit moet plaasvind.';
$string['blogger'] = 'Blogger-URL';
$string['bloggerdesc'] = 'Voer die URL van jou Blogblad in.
<a href="http://www.blogger.com/" target="_blank"> (www.blogger.com) .</a>';
$string['bodyfont'] = 'Fontgrootte';
$string['bodyfontdesc'] = 'As jy wil, kan jy \'n fontgrootteverwysing stel. Dit is bekend daarvoor dat dit vertoonprobleme met sekere blokke veroorsaak as jy die grootste fontgrootte gebruik. Probeer en besluit daaroor.';
$string['bottomphead'] = 'Onderskrifelemente';
$string['breadcrumbhead'] = 'Breadcrumb-stafie-opsies';
$string['browser_1'] = 'Microsoft Internet Explorer';
$string['browser_2'] = 'Firefox (Mozilla)';
$string['browser_3'] = 'Chrome (Webkit)';
$string['browser_4'] = 'Opera (Webkit)';
$string['catstyle'] = 'Kategorielysstyl';
$string['catstyle1'] = 'Standaard Moodle-styl';
$string['catstyle2'] = 'Roosterprentstyl';
$string['catstyle3'] = 'Lys met 32x32 ikone';
$string['catstyledesc'] = 'Kategorielysstyl.<br />
<br />';
$string['choosereadme'] = '<div class="clearfix">
  <div class="theme_screenshot">
    <h2>aigne</h2>
    <img src="aigne/pix/screenshot.jpg" />

    <h3>Temabesprekingsforum:</h3>
    <p><a href="http://moodle.org/mod/forum/view.php?id=46">http://moodle.org/mod/forum/view.php?id=46</a></p>

    <h3>Temadokumentasie:</h3>
    <p><a href="http://docs.moodle.org/all/es/admin/setting/themesettingaigne">Tema Aigne Dokumentasieblad</a></p>

    <h3>Rapporteer \'n fout:</h3>
    <p>Stuur \'n e-pos aan francpombal@hotmail.com</p>
  </div>

  <div class="theme_description">
    <h3>Inligting oor:</h3>
    <p>Moodle 2.x tema _ Hoofeienskappe:</p>
    <ul>
      <li>Eenvoudige ontwerp en volledige CSS-voldoening, kan by etlike skermgroottes aanpas.
      <li>Gebruik slegs 5 tinte van die hoofkleur, met \'n Kleurskemahulpmiddel.
      <li>@font-face css-opsies (3 tipes ingesluit)
      <li>Verpersoonlikte logo, leuse en agtergrondlogoprent.
      <li>Nuwe en veelsydige hofie-Meta Tags-opsies.
      <li>\'n Voorblad met banier, bemarkingsinligting en prent-doelgemaakte spasies.
      <li>Gebruikerinligtingsarea, om in hoof- of navigasieblok te vertoon.
      <li>NavHulp-onderskrifafdeling met alle nodige administratiewe skakels na verpersoonlikte en taalsensitiewe bladsye.
      (webkaart, hulp, soek, stats, vrywaring, beleide, privaatheid, sekuriteit en toeganklikheid)
      <li>Kontakafdeling met ongeveer 30 Sosiale Netwerk-skakels
      <li>Kopieregafdeling en Krediete-inligtingsafdeling, met nuwe opsies oor eksterne w3c-validatorbedieners
      <br />
      <li>Meer as 100 doelmaakopsies by Werfadmin -> Voorkoms -> Temas -> aigne
    </ul>
    <h3>Krediete:</h3>
    <p>Ontwerp geskep deur Franc Pombal (www.aigne.com), ná verbetering van die AfterBurner-tema in die Moodle-kern.</p>
    <h3>Lisensie:</h3>
    <p>Hierdie en alle ander temas wat in die Moodle-kern ingesluit is, is onder die  <a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a> gelisensieer.</p>
  </div>
</div>';
$string['colorsch'] = 'Kleurskema van werf';
$string['colorschdesc'] = 'Kies die werf se verstek Kleurskema. [ ::: under construction ::: ] <br />
    <table class="headerop" Style="width: 325px; border: 2px solid #322C65;">
        <tr Style="height:25px">
            <td Style="background-color:#322C65">&nbsp;</td>
            <td Style="background-color:#007EBA">&nbsp;</td>
            <td Style="background-color:#CCDDEE">&nbsp;</td>
            <td Style="background-color:#F3F7FF">&nbsp;</td>
            <td Style="background-color:#FFFFFF">{$a->css_color1}</td>
            <td Style="background-color:#FFFFFF; color:#3C3C3C">A</td>
        </tr>
        <tr Style="height:25px">
            <td Style="background-color:#001A1A">&nbsp;</td>
            <td Style="background-color:#004040">&nbsp;</td>
            <td Style="background-color:#4CA9BC">&nbsp;</td>
            <td Style="background-color:#F2FFEB">&nbsp;</td>
            <td Style="background-color:#FFFFFF">{$a->css_color2}</td>
            <td Style="background-color:#FFFFFF; color:#3C3C3C">A</td>
        </tr>
        <tr Style="height:25px">
            <td Style="background-color:#522500">&nbsp;</td>
            <td Style="background-color:#EB8324">&nbsp;</td>
            <td Style="background-color:#F6CC87">&nbsp;</td>
            <td Style="background-color:#FFFFCC">&nbsp;</td>
            <td Style="background-color:#FFFFFF">{$a->css_color3}</td>
            <td Style="background-color:#FFFFFF; color:#3C3C3C">A</td>
        </tr>
        <tr Style="height:25px">
            <td Style="background-color:#520000">&nbsp;</td>
            <td Style="background-color:#AA0000">&nbsp;</td>
            <td Style="background-color:#F1A78E">&nbsp;</td>
            <td Style="background-color:#FFF2F2">&nbsp;</td>
            <td Style="background-color:#FFFFFF">{$a->css_color4}</td>
            <td Style="background-color:#FFFFFF; color:#3C3C3C">A</td>
        </tr>
        <tr Style="height:25px">
            <td Style="background-color:#520000">&nbsp;</td>
            <td Style="background-color:#AA0000">&nbsp;</td>
            <td Style="background-color:#F1A78E">&nbsp;</td>
            <td Style="background-color:#FFF2F2">&nbsp;</td>
            <td Style="background-color:#FFFFFF">{$a->css_color5}</td>
            <td Style="background-color:#FFFFFF; color:#3C3C3C">A</td>
        </tr>
        <tr Style="height:25px">
            <td Style="background-color:#222222">&nbsp;</td>
            <td Style="background-color:#666666">&nbsp;</td>
            <td Style="background-color:#AAAAAA">&nbsp;</td>
            <td Style="background-color:#F0F0F0">&nbsp;</td>
            <td Style="background-color:#FBFBFB">{$a->css_color6}</td>
            <td Style="background-color:#FFFFFF; color:#000000">A</td>
        </tr>
        <tr Style="height:25px">
            <td Style="width:25px; background-color:#F3F7FF">&nbsp;</td>
            <td Style="width:25px; background-color:#CCDDEE">&nbsp;</td>
            <td Style="width:25px; background-color:#322C65">&nbsp;</td>
            <td Style="width:25px; background-color:#000033">&nbsp;</td>
            <td Style="width:200px; background-color:#FFFFFF">{$a->css_color7}</td>
            <td Style="width:25px; background-color:#000033; color:#FFFFFF">A</td>
        </tr>
    </table>';
$string['compatbrowser'] = 'Blaaiers';
$string['compatbrowserdesc'] = 'Blaaiers';
$string['compatcredit'] = 'Versoenbaarhede';
$string['compatcreditdesc'] = 'Indien ontsper, vertoon daar \'n lys op die onderskrif met die logo\'s van die verskillende suksesvolle versoenbaarhedevalidasies';
$string['compatdevice'] = 'Beproefde toestelle';
$string['compatdevicedesc'] = 'Beproefde toestelle';
$string['compatnotedesc'] = 'In hierdie afdeling kan jy die ooreenkomste aktiveer wat jou werf suksesvol valideer. <br /> Hou aan jy het gewen ...';
$string['compatos'] = 'Bedryfstelsels';
$string['compatosdesc'] = 'Bedryfstelsels';
$string['compatsocial'] = 'Sosiale beleide';
$string['compatsocialdesc'] = 'Sosiale beleide';
$string['compattested'] = 'Versoenbaarhede Getoets';
$string['compattesteddesc'] = 'Kies die ooreenkomstelogo wat jy wil vertoon, hou in gedagte dat jy op jou eie risiko getoets het.';
$string['compatwai'] = 'Toeganklikheid Getoets';
$string['compatwai1'] = 'nog nie getoets nie';
$string['compatwai2'] = 'Vlak A';
$string['compatwai3'] = 'Vlak AA';
$string['compatwai4'] = 'Vlak AAA';
$string['compatwaidesc'] = 'Kies die toeganklikheidslogo wat jy wil vertoon, hou in gedagte dat jy op jou eie risiko getoets het
<a href="http://www.w3.org/WAI/WCAG1AAA-Conformance" target="_blank"> (WAI WCAG AAA) .</a>';
$string['configtitle'] = 'aigne Doelgemaakte Verstellings';
$string['contacthead'] = 'Kontakopsies';
$string['contactlink'] = 'Kontak ons:';
$string['contactnote'] = 'Kontaknota';
$string['contactnotedesc'] = 'Wat jy ook al by hierdie teksarea voeg, word in die middel van die kontakafdeling in die onderskrif van elke bladsy vertoon.';
$string['contentact'] = 'Inhoud slegs in Aktiwiteitsblad';
$string['contentactdesc'] = 'Indien ontsper, sal slegs die inhoud van die aktiwiteite vertoon word, sonder laterale blokke, om meer spasie aan die aktiwiteit te verleen.';
$string['contentcur'] = 'Inhoud slegs in Kursusblad';
$string['contentcurdesc'] = 'Indien ontsper, sal slegs die inhoud van die kursusse vertoon word, sonder laterale blokke, om meer spasie aan die kursus te verleen.';
$string['copyrightstg'] = 'Eiendomboodskap';
$string['copyrightstgdesc'] = 'Hier kan jy \'n boodskap skryf wat aan die einde van die onderskrif verskyn, wat Webwerfeienaarskap beskryf.
As jy dit leeg laat, sal \'n kort boodskap met die naam van die werf en die huidige jaar saamgestel word.
Onthou dat jy enige van die internasionaal erkende modelle kan gebruik: <br />
&nbsp;&nbsp;&nbsp; ► KOPIEREG © JAAR MAATSKAPPY &nbsp;&nbsp;&nbsp; ► MAAKSKAPPY © JAAR &nbsp;&nbsp;&nbsp; ► JAAR © MAATSKAPPY';
$string['corpweb'] = 'Webwerf-URL';
$string['corpwebdesc'] = 'Voer die URL van jou Instelling / Organisasie / Korporatiewe Webwerf in (d.w.s. http://www.company_domain.com/) <br />
Hierdie skakel het geen koppeling met daardie www root in config.php nie.';
$string['cortesyhead'] = 'Opsies: Vergunningsplasings';
$string['creditshead'] = 'Opsies: Kredietplasings';
$string['csocial_1'] = 'Kinderbeskerming & -Versorging';
$string['csocial_2'] = 'Gelykheid + Vrou';
$string['csocial_3'] = 'Multikulturele Nakoming';
$string['css_color1'] = 'Ligblou';
$string['css_color2'] = 'Blougroen';
$string['css_color3'] = 'Oranje _ Lente';
$string['css_color4'] = 'Robynrooi _ Somer';
$string['css_color5'] = 'Bruin _ Herfs';
$string['css_color6'] = 'Grys _ Winter';
$string['css_color7'] = 'Kontrasterende Blou';
$string['csshead'] = 'CSS-ontwerpopsies';
$string['ctested_1'] = 'WIA CSS-Valideerder is getoets <a href="http://jigsaw.w3.org/css-validator/#validate_by_upload" target="_blank"> (WIA CSS) .</a>';
$string['ctested_2'] = 'WIA HTML5.0 of 4.0 Valideerder is getoets <a href="http://validator.w3.org/check?uri=referer" target="_blank"> (WIA HTML 4.0) .</a>';
$string['ctested_3'] = 'WIA XHTML 1.0 Valideerder is getoets <a href="http://validator.w3.org/check?uri=referer" target="_blank"> (WIA HTML 4.0) .</a>';
$string['ctested_4'] = 'gereserveer _ Cynthia Valideerder <a href="http://www.cynthiasays.com/" target="_blank"> (Cynthia) .</a>';
$string['ctested_5'] = 'gereserveer _ Kinders Gratis Valideerder <a href="http://www.w3.org/WAI/WCAG1AAA-Conformance" target="_blank"> (WAI WCAG AAA) .</a>';
$string['customcss'] = 'Doelgemaakte CSS';
$string['customcssdesc'] = 'Watter CSS-reëls jy ook al by hierdie teksarea voeg, sal op elke bladsy weerspieël word, wat die doelmaak van hierdie tema vergemaklik.';
$string['custommenudesc'] = 'Om \'n doelgemaakte kieslys te ontwerp, behoort dit op Werfadministrasie ► Voorkoms ► Temas ► <a href="settings.php?section=themesettings">"Verstellings"</a> ►  "doelgemaaktekieslysitems" opgestel te word.<br />';
$string['custommenuhead'] = 'Doelgemaakte Kieslysopsies';
$string['custommtag'] = 'Doelgemaakte Metamerkers';
$string['custommtagdesc'] = 'Voeg asseblief jou doelgemaakte Metamerkers by.<br />
Wees asseblief noukeurig met die formaat en inhoud, en skryf die hele kode - soos on \'n Webwysiger - soos die volgende voorbeeld:<br />
<pre>
&lt;META name="distribution" content="global" /&gt;
&lt;META name="revisit-after" content="31 Days" /&gt;
&lt;META name="robots" content="index,nofollow" /&gt;
</pre>';
$string['dailymotion'] = 'DailyMotion-URL';
$string['dailymotiondesc'] = 'Voer die URL van jou DailyMotion-kanaal in.
<a href="http://www.dailymotion.com/" target="_blank"> (www.dailymotion.com) .</a>';
$string['datemessage'] = 'Spesiale boodskap';
$string['datemessage1'] = 'Voorspoedige Nuwejaar!';
$string['datemessage2'] = 'Geniet die Karnaval!';
$string['datemessage3'] = 'Geseënde Paasfees en \'n vreugdevolle Heilige Week!';
$string['datemessage4'] = 'Geniet die Spaanse dag!';
$string['datemessage5'] = 'Gelukkige Halloween en Allerheiligedagvieringe';
$string['datemessage6'] = 'Geseënde Kersfees!';
$string['datemessage7'] = 'Geniet die brug van ...';
$string['datemessage8'] = 'Geniet die somervakansie!';
$string['datemessage9'] = 'Geniet die wintervakansie!';
$string['datemessagedesc'] = 'Definieer die boodskap wat jy vir \'n spesifieke tydperk wil vertoon <br />
Jy kan byvoorbeeld \'n begroeting vir \'n seisoen of fees ("Geseënde Kersfees") plaas. <br />
Dui \'n spesiale geleentheid op die platform aan (bv. "Ons is besig om \'n nuwe webontwerp in te stel ...") <br />
of jy kan ook \'n nuwe soort kursus ("Kyk na ons nuwe taalkursusse") aankondig <br />';
$string['datemessagefinis'] = 'Einddatum';
$string['datemessagestart'] = 'Aanvangsdatum';
$string['dayviews'] = 'DayViews-URL';
$string['dayviewsdesc'] = 'Voer die URL van jou DayViews-blad in.
<a href="http://dayviews.com/" target="_blank"> (dayviews.com) .</a>';
$string['decfontsizetxt'] = 'Druk om die fontgrootte te verklein. (Verklein teksgrootte om toeganklikheid te verbeter)';
$string['defaultfontsizetxt'] = 'Druk om die fontgrootte te herstel. (Keer terug na normale grootte van webontwerp)';
$string['defaultstyletxt'] = 'Druk om die oorspronklike voorkoms van die webontwerp te herstel';
$string['deviantart'] = 'DeviantART-URL';
$string['deviantartdesc'] = 'Voer die URL van jou DeviantART-rekening in.
<a href="http://www.deviantart.com/" target="_blank"> (www.deviantart.com) .</a>';
$string['device_1'] = 'HDTV & SmartTV';
$string['device_2'] = 'Werkskerm & Werkstasie & Bedieners';
$string['device_3'] = 'Skootrekenaar & Notaboek & Netboek';
$string['device_4'] = 'Tablet';
$string['device_5'] = 'Mobiele- & Slimfoon';
$string['disclaimer'] = 'vrywaring';
$string['disclaimerdesc'] = 'Verpligte regskennisgewing';
$string['disclaimerpage'] = '<h2 style="text-align: center">Hierdie is \'n voorbeeldblad</h2>
<p>&nbsp;</p>
<h2>Regskennisgewing:</h2>
<p>Hierdie dokument beheer die gebruik van Webwerwe wat aan Internetdomein
   "{$a->sitenamelow}.com"... of so voorts geheg is.</p>
<h2>Gegewe parameters::</h2>
  <ul>{$a->sitenamelow}</ul>
  <ul>{$a->sitename}</ul>
  <ul>{$a->supportemail}</ul>
  <ul>{$a->sendemailtitle}</ul>
  <p>&nbsp;</p>';
$string['dropbox'] = 'DropBox-URL';
$string['dropboxdesc'] = 'Voer die URL van jou DropBox-blad in.
<a href="http://www.dropbox.com" target="_blank"> (www.dropbox.com) .</a>';
$string['dublinmtag'] = 'Dublin Core Metamerkers';
$string['dublinmtagdesc'] = 'Indien ontsper, vertoon VERSOENBAARHEID MET "Dublin Core Metadata Initiative" METAMERKERS.';
$string['emailimg'] = 'E-pos antispam-prent';
$string['emailimgdesc'] = 'Hier kan jy \'n prent by die e-posadres voeg. Dit sal verhoed dat kwaadwillige spamhulpmiddels die e-posadres vaslê.<br />
Stel hierdie e-posadres op Werfadministrasie ► Bediener ► <a href="settings.php?section=supportcontact">"Ondersteuningskontak"</a> ► "supportemail" .
Oorweeg die ontwerp se verhoudings en voeg \'n prent van 32 px hoog in.';
$string['facebook'] = 'Facebook-URL';
$string['facebookdesc'] = 'Voer die URL van jou Facebook-blad in.
<a href="http://www.facebook.com/" target="_blank"> (www.facebook.com) .</a>';
$string['fisicallink'] = 'Besoek ons by:';
$string['flickr'] = 'Flickr-URL';
$string['flickrdesc'] = 'Voer die URL van jou Flickr-blad in.
<a href="http://www.flickr.com" target="_blank"> (www.flickr.com) .</a>';
$string['fontfam'] = 'Fontfamilie';
$string['fontfam1'] = 'Eras Bk Bt';
$string['fontfam2'] = 'eras';
$string['fontfam3'] = 'afta';
$string['fontfam4'] = 'Arial';
$string['fontfam5'] = 'Tahoma';
$string['fontfamdesc'] = 'As jy wil, kan jy \'n fontfamilieverwysing stel';
$string['footnote'] = 'Voetnoot';
$string['footnotedesc'] = 'Wat jy ook al by hierdie teksarea voeg, sal in die onderskrif van elke bladsy vertoon word.';
$string['footnoteshow'] = 'Vertoon Voetnoot';
$string['footnoteshowdesc'] = 'Indien ontsper, vertoon die inhoud van die "voetnoot" op die onderskrif onder.';
$string['footsearch'] = 'soek';
$string['footsearchdesc'] = 'Algehele soektog';
$string['footsearchpage'] = '<h2 style="text-align: center">Hierdie is \'n voorbeeldblad</h2>
<p>&nbsp;</p>
<h2>Soek:</h2>
  <p>Hier kan jy algemene soekhulpmiddels invoer.</p>
  <p>&nbsp;</p>';
$string['fotolog'] = 'FotoLog-URL';
$string['fotologdesc'] = 'Voer die URL van jou FotoLog-blad in.
<a href="http://www.fotolog.com/" target="_blank"> (www.fotolog.com) .</a>';
$string['frontmsgttl'] = 'Skryf die boodskaptitel hier';
$string['frontmsgtxt'] = 'Plaas \'n bondige en interessante welkomboodskap hier<br />
Skryf in jou gunsteling HTML-wysiger, soek dan die taaldokument /theme/aigne/lang/ xx /theme_aigne.php op en plak dit in $string[frontmsgtxt]<br />
<strong>Jy kan die dokument aigne_style.css vir jou CSS-formaatvoorkeure gebruik</strong>';
$string['general_greeting'] = 'Hallo!';
$string['generalhead'] = 'Algemene voorkoms';
$string['googleplus'] = 'Google+ URL';
$string['googleplusdesc'] = 'Voer die URL van jou Google+ profiel in.
<a href="http://plus.google.com/" target="_blank"> (plus.google.com) .</a>';
$string['headactivity'] = 'Vertoon hofie in "Aktiwiteite"';
$string['headactivitydesc'] = 'Indien ja, vertoon die nuwe hofie in "Aktiwiteite" (Slegs op Moodle-weergawe 2.7.xx)';
$string['headbanner'] = 'Hofiebanier';
$string['headbannerdesc'] = 'Kies die tipe inligting om in die hofie van die voorblad te vertoon.';
$string['headerhead'] = 'Hofie-elemente';
$string['headerinfo'] = 'Hofiebanier';
$string['headerinfodesc'] = 'As jy wil, kan jy \'n vasgestelde prent in die hofie van die voorblad byvoeg. <br />
Hierdie prent moet \'n JPG / PNG / GIF wees van minimum 1000 px breed en maksimum 150 px hoog.';
$string['help'] = 'hulp';
$string['helpdesc'] = 'Algemene ondersteuning';
$string['helppage'] = '<h2 style="text-align: center">Hierdie is \'n voorbeeldblad</h2>
<p>&nbsp;</p>
<h2>Navigasiehulp:</h2>
  <p>Hier kan jy alle vereiste besonderhede invoer om navigasie in kursusse
     te vergemaklik. Jy kan ook \'n afdeling skep om na die
     "Student se Handboek" of gebruikersgidse te skakel.</p>
<h2>Moodle:</h2>
  <p>Ons leerplatform is op Moodle gebaseer. As jy inligting
     oor die bruikbaarheid van Moodle wil bied, kan jy die
     <a href="http://docs.moodle.org">amptelike ondersteuningsdokumente</a> verkry.</p>
<h2>Gegewe parameters:</h2>
  <ul>{$a->link}</ul>
  <ul>{$a->supportemail}</ul>
  <ul>{$a->sendemailtitle}</ul>
  <p>&nbsp;</p>';
$string['incfontsizetxt'] = 'Druk om die fontgrootte te vergroot. (Vergroot teksgrootte om toeganklikheid te verbeter)';
$string['infobanner'] = 'Inligtingsarea';
$string['infobanner0'] = 'Geen inligtingsbanier';
$string['infobanner1'] = 'Vertoon een statiese boks met \'n teksboodskap';
$string['infobanner10'] = '';
$string['infobanner2'] = 'Vertoon een statiese beeld';
$string['infobanner3'] = 'Vertoon drie statiese bokse met verskillende tipes inhoud';
$string['infobanner4'] = 'Vertoon een inligtingsboks, in horisontale konsertinastyl';
$string['infobanner5'] = 'Vertoon een vertikale, outomatiese glyeraanbieding';
$string['infobanner6'] = 'Vertoon een horisontale, outomatiese glyeraanbieding';
$string['infobanner7'] = 'Vertoon standaard intekenvorm';
$string['infobannerdesc'] = 'Kies die tipe inligting om in die inhoud van die voorblad te vertoon.<br />';
$string['instagram'] = 'Instagram-URL';
$string['instagramdesc'] = 'Voer die URL van jou Instagram-blad in.
<a href="http://instagram.com/" target="_blank"> (instagram.com) .</a>';
$string['lastmodifiedmsg'] = 'Laaste Bygewerk-Boodskap';
$string['lastmodifiedmsgdesc'] = 'Indien ontsper, vertoon aan die einde van die onderskrif opdateringsinligting oor die blad.';
$string['lastpageupdate'] = 'Laaste bladbywerking op';
$string['linkedin'] = 'LinkedIn-URL';
$string['linkedindesc'] = 'Voer die URL van jou LinkedIn-profiel in.
<a href="http://www.linkedin.com/" target="_blank"> (www.linkedin.com) .</a>';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Voeg asseblief jou doelgemaakte logo in as jy die verstek logo vir hierdie tema wil vervang.<br />
Ter inligting: die verstek logo is \'n JPG-prent van 150 px breed en 55 px hoog';
$string['logohead'] = 'Logo-opsies';
$string['maplink'] = 'Kaartbediener-URL';
$string['maplinkdesc'] = 'Voer die URL van \'n kaartbediener met die ligging van die organisasie in (d.w.s. Google Maps / Bing Maps).';
$string['marketinghead'] = 'Uitlegopsies vir die werf se voorblad';
$string['marketingheaddesc'] = 'In hierdie afdeling kan jy die elemente wat op die voorblad vertoon word voordat gebruikers inteken, doelmaak.
Jy kan inligting oor jou instelling bied, of die lansering van nuwe kursusse.<br />
Dit kan geprogrammeer word om enige inligting oor die werf of kursusse te vertoon, in die uitleg "frontinfo.php" en in die lêer theme\\aigne\\pix\\carroussel.';
$string['menucolor'] = 'Hoofkleur van Doelgemaakte Kieslys';
$string['menucolordesc'] = 'Kies die agtergrondkleur vir die doelgemaakte kieslys. Ander opsies behoort direk in die css-dokumente (aigne_menu.css) gestel te word.';
$string['menucolorhl'] = 'Kontraskleur van Doelgemaakte Kieslys';
$string['menucolorhldesc'] = 'Stel die kontraskleur vir die agtergrond van die doelgemaakte kieslys. Wees versigtig met agtergrondkleurkombinasies om \'n mooi ontwerp te verkry.';
$string['menulogout'] = 'Uittekenskakel';
$string['menulogoutdesc'] = 'Indien ontsper, word \'n teken uit-/in-skakel aan die begin van die doelgemaakte kieslys vertoon.';
$string['metadescription'] = 'Welkom {$a->sitename}.';
$string['metakeywords'] = 'aigne, onderwys, leer, didaktiek, pedagogie';
$string['microsoftid'] = 'Microsoft Live-URL';
$string['microsoftiddesc'] = 'Voer die URL van jou Microsoft Live-profiel in.
<a href="http://profile.live.com/" target="_blank"> (profile.live.com) .</a>';
$string['moodlecredit'] = 'Krediete aan Moodle';
$string['moodlecreditdesc'] = 'Indien ontsper, word daar \'n kredietboodskap en \'n skakel na die oorspronklike <a href="http://moodle.org/" target="_blank">moodle.org.</a> op die onderskrif vertoon.';
$string['moodledocsdesc'] = 'Hulpskakel na die oorspronklike bladsye (MoodleDokumente) by <a href="http://docs.moodle.org/" target="_blank">docs.moodle.org.</a>';
$string['moodlehead'] = 'Moodle-elemente opsies';
$string['moreinfo'] = 'Lees meer ...';
$string['morning_greeting'] = 'Goeiemôre!';
$string['mtaghead'] = 'Metamerkers opsies';
$string['mtagheaddesc'] = '';
$string['mtdescription'] = 'Beskrywing Metamerker';
$string['mtdescriptiondesc'] = 'Voeg asseblief die doelgemaakte inhoud vir "beskrywing" Metamerker by.<br />
Wees asseblief noukeurig met die formaat en inhoud, en voeg tot 250 karakters in.<br />
Indien hierdie opsie leeg gelaat word, sal \'n welkomboodskap outomaties gegenereer word.';
$string['mtkeywords'] = 'Sleutelwoorde Metamerker';
$string['mtkeywordsdesc'] = 'Voeg asseblief die doelgemaakte inhoud vir "sleutelwoorde" Metamerker in.<br />
Wees asseblief noukeurig met die formaat en inhoud, woorde met \'n komma geskei en tot 25 woorde lank.<br />
Indien hierdie opsie leeg gelaat word, sal \'n outomatiese uitdrukking met 5 woorde gegenereer word.';
$string['myspace'] = 'MySpace-URL';
$string['myspacedesc'] = 'Voer die URL van jou MySpace-profiel in.
<a href="http://www.myspace.com/" target="_blank"> (www.myspace.com) .</a>';
$string['navhelp'] = 'Navigasiehulp-bladsyskakel';
$string['navhelpdesc'] = 'Webbladadres van die navigasiehulp';
$string['navhelphead'] = 'Navigasiehulp opsies';
$string['navhelplinks'] = 'Aktiewe skakels';
$string['navhelplinksdesc'] = 'Aktiveer die skakels om in die navigasiehulpspasie in die onderskrif te verskyn.';
$string['navhelppage'] = 'Navigasiehulpblad';
$string['navhelppagetitle'] = 'Navigasiehulp';
$string['newsinfo'] = 'Akademiese Inligting';
$string['newsinfo1'] = '<h2 style="text-align: center">Hierdie is \'n voorbeeldblad</h2>
<p>&nbsp;</p>
<p>Hier kan jy \'n inligtingsblad skep.</p>
<p>&nbsp;</p>';
$string['newsinfo2'] = '<h2 style="text-align: center">Hierdie is \'n voorbeeldblad</h2>
<p>&nbsp;</p>
<p>Hier kan jy \'n inligtingsblad skep.</p>
<p>&nbsp;</p>';
$string['newsinfo3'] = '<h2 style="text-align: center">Hierdie is \'n voorbeeldblad</h2>
<p>&nbsp;</p>
<p>Hier kan jy \'n inligtingsblad skep.</p>
<p>&nbsp;</p>';
$string['newsinfo4'] = '<h2 style="text-align: center">Hierdie is \'n voorbeeldblad</h2>
<p>&nbsp;</p>
<p>Hier kan jy \'n inligtingsblad skep.</p>
<p>&nbsp;</p>';
$string['newsinfo5'] = '<h2 style="text-align: center">Hierdie is \'n voorbeeldblad</h2>
<p>&nbsp;</p>
<p>Hier kan jy \'n inligtingsblad skep.</p>
<p>&nbsp;</p>';
$string['night_greeting'] = 'Goeienaand!';
$string['nocontentdrag'] = 'Weens kopieregbeskerming van ons kursusse is die sleep (sleep & laat los) van sommige inhoud versper.';
$string['nocontentprint'] = '<h2 style="text-align: center">Drukvoorkoming</h2>
<h3><b>Kopiereg:</b></h3>
  <p>Alle inhoud op {$a->sitename} word gedek deur die bestaande wetgewing wat kopiereg beskerm. Vir meer inligting, besoek ons oorsigblad{$a->disclaimer}.</p>
  <p>&nbsp;</p>

<h3><b>Druk:</b></h3>
  <p>Om bedrog in die gebruik van die inhoud van ons kursusse te verhoed, het ons \'n aantal basiese hulpmiddels geïnstalleer om te verhoed dat daardie inhoud gedruk word, en dat die kopiereg daarvan beskerm word.</p>
  <p>&nbsp;</p>

<h3><b>Verkry \'n afskrif:</b></h3>
  <p>As jy vir een van ons kursusse ingeskryf is en jy \'n afskrif van die inhoud benodig
     wat nie in die kursus ingesluit is nie, kontak jou onderwyser of die
     Werfadministrateur om hulp daarmee.</p>
  <p>&nbsp;</p>
<hr>
  <p style="text-align: center">Jammer oor die ongemak</p>
  <p>&nbsp;</p>';
$string['nocontentselect'] = 'Weens kopieregbeskerming van ons kursusse, is die selekteer (kopieer & plak) van sommige inhoud versper.';
$string['noimplemented'] = 'Dit is nog nie geïmplementeer nie, jammer.';
$string['notes'] = 'aigne-temanotas';
$string['notesdesc'] = 'Om enige verstellings toe te pas, druk eenvoudig "Berg Veranderinge" onderaan hierdie bladsy. As jy nie "Temaontwerpermodus" ontsper het nie, kan dit nodig wees dat jy Werfadministrasie ► Ontwikkeling ► <a href="purgecaches.php">Skrap alle Kasgeheue</a> besoek om die verfris te dwing.';
$string['openid'] = 'Open ID-URL';
$string['openiddesc'] = 'Voer die URL van jou Open ID-profiel in.
<a href="http://openid.net/" target="_blank"> (openid.net) .</a>';
$string['optionalmtag'] = 'Opsionele Metamerkers';
$string['optionalmtagdesc'] = 'Indien ontsper, genereer Opsionele Metamerkers met outomatiese inligting oor hierdie werf.';
$string['original_theme'] = 'Uitleg is geïnspireer deur oorspronklike tema deur Mary Evans';
$string['orkut'] = 'Orkut-URL';
$string['orkutdesc'] = 'Voer die URL van jou Orkut-profiel in.
<a href="http://www.orkut.com/" target="_blank"> (www.orkut.com) .</a>';
$string['osystem_1'] = 'Windows';
$string['osystem_2'] = 'Linux';
$string['osystem_3'] = 'Mac / Apple';
$string['osystem_4'] = 'Android';
$string['osystem_5'] = 'BlackBerry';
$string['outbutton'] = 'Uitteken-opsie in knoppiestyl';
$string['outmoodle'] = 'Uitteken-opsie in moodle-hiperskakelstyl';
$string['outnone'] = 'Geen uitteken-opsie';
$string['panoramio'] = 'Panoramio-URL';
$string['panoramiodesc'] = 'Voer die URL van jou Panoramio-blad in.
<a href="http://www.panoramio.com" target="_blank"> (www.panoramio.com) .</a>';
$string['photobucket'] = 'Photobucket-URL';
$string['photobucketdesc'] = 'Voer die URL van jou Photobucket-blad in.
<a href="http://www.photobucket.com/" target="_blank"> (www.photobucket.com) .</a>';
$string['picasa'] = 'Picasa-URL';
$string['picasadesc'] = 'Voer die URL van jou Picasa-blad in.
<a href="http://picasaweb.google.com/" target="_blank"> (picasaweb.google.com) .</a>';
$string['pinterest'] = 'Pinterest-URL';
$string['pinterestdesc'] = 'Voer die URL van jou Pinterest-blad in.
<a href="http://pinterest.com/" target="_blank"> (pinterest.com) .</a>';
$string['pixabay'] = 'PixaBay-URL';
$string['pixabaydesc'] = 'Voer die URL van jou PixaBay-blad in.
<a href="http://pixabay.com/" target="_blank"> (pixabay.com) .</a>';
$string['pluginname'] = 'aigne';
$string['policies'] = 'werfbeleide';
$string['policiesdesc'] = 'Werfbeleide';
$string['policiespage'] = '<h2 style="text-align: center">Hierdie is \'n voorbeeldblad</h2>
<p>&nbsp;</p>
<h2>Werfbeleide:</h2>
  <p>Hier kan jy webwerfgebruikbeleide, pligte en regte van studente, ens. invoer</p>
  <p>&nbsp;</p>';
$string['powered'] = 'Aangedryf deur:';
$string['privacy'] = 'privaatheid';
$string['privacydesc'] = 'Blaaiprivaatheidinligting';
$string['privacypage'] = '<h2 style="text-align: center">Hierdie is \'n voorbeeldblad</h2>
<p>&nbsp;</p>
<h2>Privaatheid van gebruiker- en studentedata:</h2>
<p>Hier kan jy inligting invoer oor die privaatheid van data in die webwerfnavigasie, asook verskillende verpligte regsklousules.</p>
<h2>Gegewe parameters::</h2>
  <ul>{$a->sitenamelow}</ul>
  <ul>{$a->supportemail}</ul>
  <ul>{$a->sendemailtitle}</ul>
  <ul>{$a->remoteaddr}</ul>
  <ul>{$a->remotehost}</ul>
  <ul>{$a->remoteuser}</ul>
  <ul>{$a->language}</ul>
  <ul>{$a->useragent}</ul>
  <ul>{$a->referer}</ul>
  <p>&nbsp;</p>';
$string['quadro1alt'] = 'Skryf die alternatiewe teks vir die boks 1-prent hier';
$string['quadro1ttl'] = 'Skryf die boks 1-titel hier';
$string['quadro1txt'] = '<h2>Teksbokse:<h2>
Stel \'n bondige en interessante paragraaf hier<br />
Skryf die teks in jou gunsteling HTML-wysiger, soek dan die taaldokument
<MARQUEE>/theme/aigne/lang/ xx /theme_aigne.php</MARQUEE> en plak dit in $string[quadro1txt]<br />
<strong>Jy kan die dokument aigne_style.css vir jou CSS-formaatvoorkeure gebruik</strong>';
$string['quadro2alt'] = 'Skryf die alternatiewe teks vir die boks 2-prent hier';
$string['quadro2ttl'] = 'Skryf die boks 2-titel hier';
$string['quadro2txt'] = '<h2>Teksbokse:</h2>
Stel \'n bondige en interessante paragraaf hier<br />
Skryf die teks in jou gunsteling HTML-wysiger, soek dan die taaldokument
<MARQUEE>/theme/aigne/lang/ xx /theme_aigne.php</MARQUEE> en plak dit in $string[quadro2txt]<br />
<strong>Jy kan die dokument vir jou CSS-formaatvoorkeure gebruik</strong>';
$string['quadro3alt'] = 'Skryf die alternatiewe teks vir die boks 3-prent hier';
$string['quadro3ttl'] = 'Skryf die boks 3-titel hier';
$string['quadro3txt'] = '<h2>Teksbokse:</h2>
Stel \'n bondige en interessante paragraaf hier<br />
Skryf die teks in jou gunsteling HTML-wysiger, soek dan die taaldokument
<MARQUEE>/theme/aigne/lang/ xx /theme_aigne.php</MARQUEE> en plak dit in $string[quadro3txt]<br />
<strong>Jy kan die dokument vir jou CSS-formaatvoorkeure gebruik</strong>';
$string['region-side-post'] = 'Regs';
$string['region-side-pre'] = 'Links';
$string['reservedrights'] = 'Alle regte voorbehou';
$string['schooltube'] = 'SchoolTube-URL';
$string['schooltubedesc'] = 'Voer die URL van jou SchoolTube-kanaal in.
<a href="https://www.schooltube.com/" target="_blank"> (www.schooltube.com) .</a>';
$string['security'] = 'sekuriteit';
$string['securitydesc'] = 'Blaai sekuriteitinligting';
$string['securitypage'] = '<h2 style="text-align: center">Hierdie is \'n voorbeeldblad</h2>
<p>&nbsp;</p>
<h2>Sekuriteit:</h2>
<p>Hier kan jy die veiligheidsmaatreëls wat gebruik word om SPAM te verhoed, die antivirushulpmiddels en rugsteunprosedures invoer.</p>
  <p>&nbsp;</p>';
$string['sendemailsubj'] = 'Inligting oor {$a}';
$string['sendemailtitle'] = '::: stuur \'n e-pos na Webwerfadministrateur :::';
$string['sep_bhr'] = '<br /><hr>';
$string['sep_br'] = '<br />';
$string['sep_hr'] = '<hr>';
$string['sep_hr2'] = '<hr width="50%" align="center">';
$string['sitelicensemsg'] = 'Lisensietipe Boodskap';
$string['sitelicensemsgdesc'] = 'Indien ontsper, word aan die einde van die onderskrif die lisensietipe vertoon wat die inhoud van hierdie webwerf beheer.<br />
Die lisensietipe kan gestel word in Werfadministrasie ► Uitbreidings ► Lisensies ► <a href="settings.php?section=managelicenses">"Lisensieadministrasie"</a> ► "werfversteklisensie"  .';
$string['sitenewsi'] = 'Vertoon outeurinligting & opsies in "Nuus"';
$string['sitenewsidesc'] = 'Indien ja, vertoon outeurinligting in hofie en die ryopsies in onderskrif van enige "Werfnuus" (Forum)';
$string['skype'] = 'Skype-Gebruikersnaam';
$string['skypedesc'] = 'Voer die Instelling / Organisasie / Korporatiewe gebruikersnaam in die Skype-netwerk in.';
$string['sli5alt1'] = 'Skryf die alternatiewe teks vir die glyer 1-prent hier';
$string['sli5alt2'] = 'Skryf die alternatiewe teks vir die glyer 2-prent hier';
$string['sli5alt3'] = 'Skryf die alternatiewe teks vir die glyer 3-prent hier';
$string['sli5alt4'] = 'Skryf die alternatiewe teks vir die glyer 4-prent hier';
$string['sli5alt5'] = 'Skryf die alternatiewe teks vir die glyer 5-prent hier';
$string['sli5cap1'] = 'Byskrif 1';
$string['sli5cap2'] = 'Byskrif 2';
$string['sli5cap3'] = 'Byskrif 3';
$string['sli5cap4'] = 'Byskrif 4';
$string['sli5cap5'] = 'Byskrif 5';
$string['slogan'] = 'Motto / Leuse';
$string['sloganaigne'] = '... voer \'n leuse hier in ...';
$string['slogandesc'] = 'As jy graag \'n kort frase wil invoer wat onder die logo verskyn, in die vorm van \'n leuse/motto. <br />
Oorweeg asseblief die grootte van die frase om die ontwerp van die hofie te behou.';
$string['social1ico'] = 'Ikoon vir die doelgemaakte Sosiale Net';
$string['social1icodesc'] = 'Voer die naam van die ikoon vir daardie Sosiale Netwerk in. <br />
Onthou om \'n 32x32 ikoonprent in die lêertema/aigne/pix/handelsname/ te kopieer met dieselfde naam ingevoeg.';
$string['social1url'] = 'Doelgemaakte Sosiale Net-URL';
$string['social1urldesc'] = 'Voer die (volledige) URL van \'n Sosiale Netwerk in wat nie in die lys is nie.';
$string['socialcontenthead'] = 'Sosiale netwerke skakelopsies (met kursus mediainhoud)';
$string['socialhead'] = 'Sosiale Netwerke-skakelopsies';
$string['sociallinks'] = '... asook in die Sosiale Netwerke:';
$string['stats'] = 'statistieke';
$string['statsdesc'] = 'Gebruikstatistieke';
$string['statspage'] = '<h2 style="text-align: center">Hierdie is \'n voorbeeldblad</h2>
<p>&nbsp;</p>
<h2>Statistieke:</h2>
  <p>Hier kan jy die blaaistatistiekuitslae of
     \'n evaluasieverslag van opleiding binne jou organisasie invoer.</p>
  <p>&nbsp;</p>';
$string['styletxt'] = 'Druk om \'n ander kleurskema oor die webontwerp toe te pas';
$string['thanksvisit'] = 'Dankie vir jou vertroue';
$string['thanksvisitmsg'] = 'Boodskap van waardering';
$string['thanksvisitmsgdesc'] = 'Indien ontsper, vertoon daar aan die einde van die onderskrif \'n boodskap van waardering aan blaaiende gebruikers';
$string['tumblr'] = 'Tumblr-URL';
$string['tumblrdesc'] = 'Voer die URL van jou Tumblr-blad in.
<a href="http://tumblr.com/" target="_blank"> (tumblr.com) .</a>';
$string['twitter'] = 'Twitter-URL';
$string['twitterdesc'] = 'Voer die URL van jou Twitter-voer in.
<a href="http://twitter.com/" target="_blank"> (twitter.com) .</a>';
$string['useraigne'] = 'Op die Hofie, in aigne-styl (inteken + begroeting + gebruikersnaam + prent + uitteken)';
$string['usermenu'] = 'Op die Hofie, in nuwe gebruiker-kieslysstyl (begroeting + nuwe aftrekkieslys)';
$string['usermoodle'] = 'Op die Hofie, in outydse moodle-styl (inteken + begroeting + gebruikersnaam + uitteken)';
$string['usernav'] = 'Gebruikerinligtingarea';
$string['usernavdesc'] = 'Kies die tipe gebruikerinligting om te vertoon, in die hofiearea, in die navigasieblok, of geen gebruikerinligting nie.
Die tweede opsie (nuwe gebruiker-kieslysstyl) sal slegs vanaf die 2.8-weergawe van Moodle of hoër loop.';
$string['usernavhead'] = 'Gebruikerinligtingarea opsies';
$string['usernavheaddesc'] = 'Die volgende opsies moet in die Gebruikernavigasie-hofiearea in aigne-styl vertoon word.
Onthou die Gebruikernavigasiearea in moodle-styl het \'n standaard, geslote formaat.';
$string['usernavinfo'] = 'Gebruikernaam';
$string['usernavinfodesc'] = 'Indien ontsper, vertoon enige gebruikersinligting op die Gebruikersinligting-hofiearea.';
$string['usernavout'] = 'Uitteken-opsie';
$string['usernavoutdesc'] = 'Indien ontsper, vertoon \'n uitteken-opsie op die Gebruikersinligting-hofiearea.';
$string['usernavpic'] = 'Gebruikerprent';
$string['usernavpicdesc'] = 'Indien ontsper, vertoon die gebruikerprent op die Gebruikersinligting-hofiearea.';
$string['usernavsalut'] = 'Begroeting & Verwelkoming';
$string['usernavsalutdesc'] = 'Indien ontsper, vertoon \'n begroeting of boodskap in Gebruikerinligting-hofiearea.<br />
Indien die Verwelkomingsboodskappe leeg gelaat word, vertoon \'n voorwaardelike begroeting, volgens die tyd van die dag.<br />
Voeg \'n vasgestelde kommunikasie in die verwelkomingsboodskap in.<br />
Voeg \'n datum-ooreenkomstige kommunikasie in die begroetingsboodskap.';
$string['usernone'] = 'Geen Gebruikersinligting';
$string['usersalut'] = 'Vertoon slegs \'n begroeting op die Hofie';
$string['videolog'] = 'VideoLog-URL';
$string['videologdesc'] = 'Voer die URL van jou VideoLog-kanaal in.
<a href="http://videolog.tv/" target="_blank"> (videolog.tv) .</a>';
$string['vimeo'] = 'Vimeo-URL';
$string['vimeodesc'] = 'Voer die URL van jou Vimeo-kanaal in.
<a href="http://www.vimeo.com/" target="_blank"> (www.vimeo.com) .</a>';
$string['vkontakte'] = 'VKontakte-URL';
$string['vkontaktedesc'] = 'Voer die URL van jou Vkontakte-blad in.
<a href="http://www.vk.com/" target="_blank"> (www.vk.com) .</a>';
$string['webmap'] = 'webkaart';
$string['webmapdesc'] = 'Skemabladsye op die Webwerf, wat die Webkaart sal vorm';
$string['webmappage'] = '<h2 style="text-align: center">Hierdie is \'n voorbeeldblad</h2>
<p>&nbsp;</p>
<p>Hier kan jy \'n kaart skep met die struktuur van bladsye wat nodig is
   om bewustheid van jou organisasie te skep, asook van die kennis en span
   waaruit jou onderrigprojek bestaan.</p>
<h2>Gegewe parameters::</h2>
  <ul>{$a->sitename}</ul>
<p>&nbsp;</p>';
$string['welcomemsg'] = 'Verwelkomingsboodskap';
$string['welcomemsgdesc'] = 'Stel \'n doelgemaakte Verwelkomingsboodskap wat in Gebruikersinligting-hofiearea vertoon sal word.';
$string['xing'] = 'Xing-URL';
$string['xingdesc'] = 'Voer die URL van jou Xing-profiel in.
<a href="http://www.xing.com/" target="_blank"> (www.xing.com) .</a>';
$string['yahooid'] = 'Yahoo-URL';
$string['yahooiddesc'] = 'Voer die URL van jou Yahoo-profiel in.
<a href="http://profile.yahoo.com/" target="_blank"> (profile.yahoo.com) .</a>';
$string['yelp'] = 'Yelp-URL';
$string['yelpdesc'] = 'Voer die URL van jou Yelp-profiel in.
<a href="http://www.yelp.com/" target="_blank"> (www.yelp.com) .</a>';
$string['youtube'] = 'YouTube-URL';
$string['youtubedesc'] = 'Voer die URL van jou YouTube-kanaal in.
<a href="http://www.youtube.com/" target="_blank"> (www.youtube.com) .</a>';
