<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_brickfield', language 'no', version '4.3'.
 *
 * @package     tool_brickfield
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessibility'] = 'Tilgjengelighet';
$string['accessibilitydisabled'] = 'Brickfield tilgjengelighetsverktøysett er ikke aktivert på denne portalen. Kontakt nettstedsadministratoren for å aktivere.';
$string['accessibilityreport'] = 'Tilgjengelighetsverktøy';
$string['accessibilitytool'] = 'Brickfield tilgjengelighetsverktøy';
$string['accessibilitytools'] = 'Brickfield tilgjengelighetsverktøy';
$string['activate'] = 'Aktivér';
$string['activated'] = 'Modulen er aktivert og klar til bruk';
$string['activationform'] = 'Brickfield-registrering';
$string['activationheader'] = 'Brickfield-aktivering';
$string['activationinfo'] = '<p> For å kunne bruke denne modulen må du oppgi gyldige nøkler for denne portalen i dette skjemaet. </p> <p> Vennligst <a href="{$a}" data-action="send_info" target="_blank"> registrer deg på Brickfield Portal (åpnes i nytt vindu)</a> for å motta disse nøklene hvis du ikke allerede har dem. </p> <p> Når de er aktivert, blir nøklene dine validert via planlagte cron-oppgaver. </p>';
$string['activityresults:pluginname'] = 'Aktivitetsrapport for tilgjengelighetsverktøy';
$string['activityresults:toolname'] = 'Sammendrag av aktivitet';
$string['activityresults:toolshortname'] = 'Detaljert aktivitet';
$string['advanced:pluginname'] = 'Avansert rapport om tilgjengelighetsverktøy';
$string['advanced:toolname'] = 'Avansert sammendrag';
$string['advanced:toolshortname'] = 'Avansert';
$string['allcourses'] = 'Alle gjennomgåtte kurs ({$a})';
$string['allcoursescat'] = 'Alle gjennomgåtte kurs for kategori {$a->catname} ({$a->count})';
$string['analysis:byrequest'] = 'På forespørsel';
$string['analysis:disabled'] = 'Deaktivert';
$string['analysistype'] = 'Aktivér analyseforespørsler';
$string['analysistype_desc'] = 'Tillat innholdstilgjengelighetsanalyse å bli forespurt';
$string['analysistypedisabled'] = 'Innholdsanalyse er deaktivert';
$string['bannercontentone'] = 'Enterprise Accessibility Toolkit har et komplett sett med funksjoner som hjelper organisasjonen din med å forbedre tilgjengeligheten til dine kurs. <a href="{$a}"> Kontakt Brickfield Education Labs </a> for å bestille en gratis demo av de avanserte funksjonene.';
$string['bannercontenttwo'] = 'Bygg en effektiv og inkluderende undervisnings- og læringsplattform ved å finne innhold som ikke oppfyller retningslinjene, fikse problemene og fremtidssikre Moodle-kursinnholdet ditt med tilgjengelige filer, redigeringsprogrammer og forbedrede funksjoner.';
$string['bannerheadingone'] = 'Oppgrader til Enterprise Accessibility Toolkit';
$string['batch'] = 'Batchgrense';
$string['brickfield'] = 'Brickfield verktøysett';
$string['brickfield:viewcoursetools'] = 'Se rapporter pr kurs';
$string['brickfield:viewsystemtools'] = 'Se rapporter for alle kurs';
$string['bulkprocesscaches'] = 'Prosess bulkbufring';
$string['bulkprocesscourses'] = 'Behandle tilgjengelighetssjekking i bulk';
$string['buttonone'] = 'Få en gratis demonstrasjon';
$string['cachepending'] = 'The summary data is being compiled';
$string['checkdesc:alinksdontopennewwindow'] = 'Lenker som åpnes i et nytt vindu, bør advare brukere på forhånd.';
$string['checkdesc:amustcontaintext'] = 'En lenke må inneholde tekst for å kunne oppfattes.';
$string['checkdesc:areadontopennewwindow'] = 'Klikkbare områder, brukt i bildekart, som åpnes i et nytt vindu, bør advare brukere på forhånd.';
$string['checkdesc:areahasaltvalue'] = 'Klikkbare områder som brukes i bildekart, bør ikke mangle alt (alternativ) tekst, lik bilder.';
$string['checkdesc:asuspiciouslinktext'] = 'Lenketekst skal være beskrivende og være i sammenheng med destinasjonen.';
$string['checkdesc:basefontisnotused'] = 'Basefont-elementer (tradisjonelt brukt til formatering) er ikke universelt utformet og bør ikke brukes.';
$string['checkdesc:blinkisnotused'] = 'Blinkeelementer, som blinker av og på, er ikke universelt utformet og bør ikke brukes.';
$string['checkdesc:boldisnotused'] = 'Bold (b) elementer bør ikke brukes; "strong" bør brukes i stedet.';
$string['checkdesc:contenttoolong'] = 'Sidens innhold bør ikke overstige 500 ord.';
$string['checkdesc:csstexthascontrast'] = 'Fargekontrasten mellom teksten og bakgrunnen er for lav.';
$string['checkdesc:embedhasassociatednoembed'] = 'Integrerte elementer (for å legge inn multimedia) bør ikke mangle de tilsvarende "noembed" -elementene.';
$string['checkdesc:headerh3'] = 'Overskrifter som følger etter H3-overskrifter (redigeringsalternativet for store overskrifter) bør ikke bryte sideoverskriften.';
$string['checkdesc:headershavetext'] = 'En topptekst må inneholde tekst for å kunne oppfattes.';
$string['checkdesc:iisnotused'] = 'Kursiv (i) elementer skal ikke brukes; "em" bør brukes i stedet.';
$string['checkdesc:imgaltisdifferent'] = 'Bildet-alt (alternativ) tekst bør ikke være likt bildets filnavn.';
$string['checkdesc:imgaltistoolong'] = 'Bilde-alt (alternativ) tekst bør ikke være mer enn maksimalt tillatte (125) tegn.';
$string['checkdesc:imgaltnotemptyinanchor'] = 'Bilde-alt (alternativ) tekst bør ikke være tomt, spesielt når bildet har en lenke som går andre steder.';
$string['checkdesc:imgaltnotplaceholder'] = 'Bilde ALT (alternativ tekst) tekst skal ikke være en enkel plassholder som f.eks. «Bilde».';
$string['checkdesc:imghasalt'] = 'Bilde ALT (alternativ tekst) skal ikke utelates for bilde-elementer, så sant de ikke utelukkende er der som dekorasjon med null mening.';
$string['checkdesc:imgwithmaphasusemap'] = 'Bilde-kart, med klikkbart områder, skal ha matchende «usemap» og «map» elementer.';
$string['checkdesc:legendtextnotempty'] = 'Forklaringselementer, som brukes til teksting av feltsettelementer, skal inneholde tekst.';
$string['checkdesc:marqueeisnotused'] = 'Markeringselementer (automatisk rulling) er ikke tilgjengelige og bør ikke brukes.';
$string['checkdesc:noheadings'] = 'Ingen overskrifter gjør innholdet mindre strukturert og vanskeligere å lese.';
$string['checkdesc:objectmusthaveembed'] = 'Objektelementer (for å bygge inn eksterne ressurser) bør ikke mangle de tilsvarende "innebygde" elementene.';
$string['checkdesc:objectmusthavetitle'] = 'Objektelementer (for å legge inn eksterne ressurser) skal ikke mangle de tilsvarende "tittelbeskrivelsene".';
$string['checkdesc:objectmusthavevalidtitle'] = 'Objektelementer (for å legge inn eksterne ressurser) skal ha tilsvarende "titler" med tekst.';
$string['checkdesc:strikeisnotused'] = 'Strengeelementer (gjennomstrekk) må ikke brukes; "del" (slettet) skal brukes i stedet.';
$string['checkdesc:tabledatashouldhaveth'] = 'Tabeller burde ideelt sett ikke mangle overskrifter.';
$string['checkdesc:tablesummarydoesnotduplicatecaption'] = 'Tabellsammendrag og bildetekster bør ikke være identiske.';
$string['checkdesc:tabletdshouldnotmerge'] = 'Tabeller bør ideelt sett ikke ha noen sammenslåtte celler.';
$string['checkdesc:tablethshouldhavescope'] = 'Tabellrad eller kolonneomfang (brukes til å kartlegge rad og kolonne til hver celle) skal deklareres.';
$string['checkidvalidation'] = 'Oppgave å sjekke for ugyldige kontroll ID-er';
$string['checkscompleted'] = 'Sjekk fullført: {$a}';
$string['checktype'] = 'Sjekk gruppe';
$string['checktype:form'] = 'Skjema';
$string['checktype:image'] = 'Bilde';
$string['checktype:layout'] = 'Sideoppsett';
$string['checktype:link'] = 'Lenke';
$string['checktype:media'] = 'Media';
$string['checktype:table'] = 'Tabell';
$string['checktype:text'] = 'Tekst';
$string['checktyperesults:pluginname'] = 'Rapport om innholdstyper i verktøy for universell utforming';
$string['checktyperesults:toolname'] = 'Sammendrag over innholdstyper';
$string['checktyperesults:toolshortname'] = 'Innholdstyper';
$string['cmpercent'] = 'Prosentandel aktiviteter samlet';
$string['cmpercenterrors'] = 'Prosentandel feil samlet';
$string['cmpercenttitle'] = 'Samlet %-fordeling av aktiviteter kontra feil';
$string['confirmationmessage'] = 'Dette kurset er planlagt for analyse. Analysen vil bli fullført tidligst av {$a}. Kom tilbake etter det.';
$string['contactadmin'] = 'Vennligst kontakt administrator for å fullføre registreringen.';
$string['contactus'] = 'Kontakt oss';
$string['contentfive'] = 'Reparer utdaterte HTML-tagger automatisk.';
$string['contentfour'] = 'Identifiser hvilke aktiviteter som har flest tilgjengelighetsproblemer for å prioritere innsats.';
$string['contentone'] = 'Evaluer kursinnholdet og vurderingene dine automatisk for problemer med universell utforming.';
$string['contentsix'] = 'Gi lærerne tips underveis for å skape bedre innhold';
$string['contentthree'] = 'Gi studentene innhold i tilgjengelige formater, inkludert lyd, ePub og elektronisk punktskrift.';
$string['contenttwo'] = 'Masseoppdatering er uklar eller mangler tekst for nettkoblinger, bildebeskrivelser og video-undertekster.';
$string['contenttypeerrors'] = 'Totale resultater av aktivitetsinnholdstester pr kurs og pr innholdstype.';
$string['contentyperesults'] = 'Totalt bestått / ikke bestått for innholdsområder pr kurs.';
$string['contextid'] = 'Kontekst-ID';
$string['core_course'] = 'Kurs';
$string['core_question'] = 'Spørsmålsbanker';
$string['count'] = 'Telle';
$string['country'] = 'Land';
$string['country_help'] = 'Land for portalen';
$string['coursecount'] = 'Antall kurs';
$string['deletehistoricaldata'] = 'Slett historiske sjekkresultater';
$string['dependency'] = 'Avhengig av';
$string['emptycategory'] = 'Fant ingen kurs for kategorien {$a}';
$string['emptytagcourses'] = 'Ingen resultater funnet for kurs med konfigurerte tagger';
$string['enableaccessibilitytools'] = 'Aktivér verktøy for universell utforming';
$string['enableaccessibilitytools_desc'] = 'Verktøy for universell utforming hjelper til med å identifisere universell utformingsproblemer i kurs.';
$string['error:nocoursespecified'] = 'Oppsummeringsrapporten krever gyldig kurs-ID. Vennligst få tilgang til tilgjengelighetsverktøysettet fra et kurs.';
$string['errorlink'] = 'Rediger feilforekomst for {$a}';
$string['errors'] = 'Feil: {$a}';
$string['errors:pluginname'] = 'Feiloversikt universell utforming';
$string['errors:toolname'] = 'Feiloversikt';
$string['errors:toolshortname'] = 'Feiloversikt';
$string['eventanalysis_requested'] = 'Innholdsanalyse forespurt';
$string['eventanalysis_requesteddesc'] = 'En innholdsanalyse er forespurt for kurset {$a}';
$string['eventreport_downloaded'] = 'Oppsummering av Universell utforming er lasted ned';
$string['eventreport_downloadeddesc'] = 'Oppsummering av Universell utforming nedlastet for kursID {$a}.';
$string['eventreport_viewed'] = 'Statusrapport over Universell utforming vist';
$string['eventreport_vieweddesc'] = 'Tilgjengelighetsrapporten ble vist for kurs-ID {$a->course}, kategori-ID {$a->category}, fane {$a->tab}.';
$string['failed'] = 'Mislyktes';
$string['failedcount'] = 'Mislyktes: {$a}';
$string['footerheading'] = 'Seksjon for bunntekst';
$string['fullcachedone'] = 'Deaktiver gjentatt caching';
$string['hashcorrect'] = 'Den angitte koden er riktig.';
$string['hashincorrect'] = 'Den angitte koden er feil.';
$string['headingfive'] = 'HTML-fikser';
$string['headingfour'] = 'Fokusér innsats';
$string['headingone'] = 'Evaluér innhold';
$string['headingsix'] = 'Ytelsesstøtte';
$string['headingthree'] = 'Tilgjengelige filformater';
$string['headingtwo'] = 'Utbedring';
$string['hideshow'] = 'Vis/Skjul';
$string['icon:analytics-custom'] = 'Analyseikon';
$string['icon:file-edit-custom'] = 'Rediger fil ikon';
$string['icon:hands-helping-custom'] = 'Hjelpende hender ikon';
$string['icon:search-plus-custom'] = 'Søkeikon';
$string['icon:tools-custom'] = 'Verktøyikon';
$string['icon:wand-magic-custom'] = 'Tryllestavikon';
$string['inactive'] = 'Modulen er inaktiv og kan ikke brukes. Vennligst legg inn en gyldig registeringskode og klikk "Aktivér".';
$string['innercontextid'] = 'Indre kontekst-ID';
$string['installed'] = 'Modul installert';
$string['installedcli'] = 'Modul installert via kommandolinje';
$string['installeddescription'] = 'Modulen er blitt installert, fortsett til aktiveringsskjema.';
$string['invalidaccessibilitytool'] = 'Du ba om tilgang til en ugyldig submodul for universell utforming.';
$string['invalidcategoryid'] = 'Ugyldig kategori, vennligst sjekk informasjonen du oppga.';
$string['invalidcourseid'] = 'Ugyldig kurs, vennligst sjekk informasjonen du oppga.';
$string['invalidlinkphrases'] = 'klikk|klikk her|her|mer|mer her|info|info her|informasjon|informasjon her|les mer|les mer her|ytterligere informasjon|ytterligere informasjon her|ytterligere detaljer|ytterligere detaljer her';
$string['language'] = 'Språk';
$string['language_help'] = 'Portalens språk';
$string['messageprovider:warningcheckid'] = 'Advarsel om ugyldige sjekk-IDer';
$string['mobileservice'] = 'Støtte for Moodle mobile aktivert ({$a})';
$string['module'] = 'Modul';
$string['modulename'] = 'Navn';
$string['moreinfo'] = 'Mer informasjon';
$string['newwindowphrases'] = 'new window|new-window|new_window';
$string['noerrorsfound'] = 'Ingen vanlige feil ved universell utforming ble funnet etter de parametrene du la inn. Gratulerer!';
$string['norecords'] = 'Fant ingen relevante resultater for dine søkeparametre.';
$string['notregistered'] = 'Du må registrere verktøyet for universell utforming.';
$string['notvalidated'] = 'Verktøyet for universell utforming er fungerende mens den valideres.';
$string['numcourses'] = 'Antall kurs ({$a})';
$string['numfactivities'] = 'Antall aktiviteter ({$a})';
$string['numfiles'] = 'Antall filer ({$a})';
$string['numinstances'] = 'Antall instanser';
$string['numusers'] = 'Antall brukere ({$a})';
$string['pagedesc:checktype'] = '<p> For å oppsummere og analysere resultatene av de forskjellige kontrollene, grupperer vi disse kontrollene i forskjellige innholdstyper. Derfor er alle bilderelaterte tilgjengelighetssjekkresultater i "Image" -innholdstypegruppen, alle layoutrelaterte tilgjengelighetssjekkresultater er i "Layout" -innholdstypegruppen og så videre. </p> <p> Aktiviteter er inkludert som aktiviteter, ressurser eller innholdsområder knyttet til selve kursene. </p> <p> Innholdstypekartet viser feiloppdelingen per innholdstypegruppe: bilde, layout, lenke, media, tabell og tekst. </ p>';
$string['pagedesc:pertarget'] = '<p> For å oppsummere og analysere sjekkresultatene per aktivitet grupperer vi disse sjekkresultatene i de forskjellige aktivitetene som er oppdaget. </p> <p> Aktiviteter er inkludert som aktiviteter, ressurser eller andre innholdsområder knyttet til kursene dem selv. Hver aktivitet uten oppdagede feil telles som bestått, hver aktivitet med en eller flere oppdagede feil telles som mislykket. Forholdet mellom bestått til mislykkede aktiviteter vises deretter. </p> <p> Tabellen over aktivitetsoversikt viser forholdet mellom bestått til mislykkede forekomster totalt, per aktivitet, for eksempel oppgave, kurs, etikett osv. </p>';
$string['pagedesctitle:checktype'] = 'Innholdstyper forklart';
$string['pagedesctitle:pertarget'] = 'Aktivitetsfordeling forklart';
$string['passed'] = 'Godkjent';
$string['passedcount'] = 'Bestått: {$a}';
$string['passrate'] = 'Bestått rate: {$a}%';
$string['pdf:filename'] = 'Brickfield_Summaryreport_CourseID-{$a}';
$string['percheckerrors'] = 'Antakk av spesifiserte tester og feil pr. sjekk pr. kurs.';
$string['perpage'] = 'Antall elementer pr. side';
$string['pluginname'] = 'Verktøy for universell utforming';
$string['printable:downloadpdf'] = 'Last ned som PDF';
$string['printable:pluginname'] = 'Oversiktsrapport for universell utforming';
$string['printable:printreport'] = 'Rapport for utskrift';
$string['printable:toolname'] = 'Sammendragsrapport';
$string['printable:toolshortname'] = 'Sammendragsrapport';
$string['privacy:metadata'] = 'Rapport for universell utforming lagrer ingen personlige data.';
$string['processanalysisrequests'] = 'Behandle forespørsler om innholdsanalyse';
$string['registernow'] = 'Vennligst registrer nå';
$string['registration'] = 'Registreringsskjema';
$string['registrationinfo'] = '<p> Denne registreringsprosessen lar deg bruke startversjonen av Brickfield verktøysett for Universell utforming for den registrerte Moodle-portalen. </p> <p> Denne bruken er underlagt <a href = "{$a}" target = "_ blank"> Vilkår og betingelser for Brickfield Education Labs (åpnes i nytt vindu) </a> og som du godtar ved å bruke dette produktet. </p>';
$string['release'] = 'Moodle versjon ({$a})';
$string['remaining'] = '({$a} feil gjenstår)';
$string['response:0'] = 'Denne URL-en peker ikke noen steds';
$string['response:404'] = 'URL-en for denne siden ble ikke funnet';
$string['schedule:blocknotscheduled'] = '<p> Dette kurset er foreløpig ikke planlagt for analyse for å finne vanlige problemer med universell utforming. </p>';
$string['schedule:notscheduled'] = '<p> Dette kurset er foreløpig ikke planlagt for analyse for å finne vanlige problemer med universell utforming. </p> <p> Ved å klikke på "Send til analyse" -knappen, bekrefter du at du vil ha alt ditt relevante kurs-HTML-innhold, for eksempel emnebeskrivelser, aktivitetsbeskrivelser, spørsmål, sider og mer, som skal planlegges for analyse. </p> <p> Denne analysen vil utføre flere vanlige tilgjengelighetssjekker på kursets HTML-innhold, og disse resultatene vises da på dette verktøyets rapportsider. Analysen vil bli behandlet i bakgrunnen, etter planlagte oppgaver, så fullføringshastigheten vil avhenge av tidsoppgavene for timene og oppgavene. </p>';
$string['schedule:requestanalysis'] = 'Send inn til analyse';
$string['schedule:scheduled'] = 'Kurset er planlagt for analyse.';
$string['schedule:sitenotscheduled'] = '<p> Det globale (kursuavhengige) innholdet er ennå ikke planlagt for analyse for å finne vanlige tilgjengelighetsproblemer. </p> <p> Ved å klikke på "Send for analyse" -knappen, bekrefter du at du vil ha alle dine relevante globale (kursuavhengig) innhold som skal planlegges for analyse. </p> <p> Denne analysen vil utføre flere vanlige tilgjengelighetskontroller av dette innholdet, og disse resultatene vil da vises på disse sidene for verktøyet for universell utforming. Analysen vil bli behandlet i bakgrunnen, etter planlagte oppgaver, så fullføringshastigheten vil avhenge av tidsoppgavene for timene og oppgavene. </p>';
$string['schedule:sitescheduled'] = 'Det globale (kursuavhengige) innholdet er planlagt for analyse.';
$string['secretkey'] = 'API-nøkkel';
$string['secretkey_help'] = 'Denne koden mottas via e-post etter registrering.';
$string['sendfollowinginfo'] = '<p> Følgende informasjon vil med jevne mellomrom bli sendt for kun å bidra til samlet statistikk. Den blir ikke offentliggjort på noen sentral oppføring. </p> {$a}';
$string['settings'] = 'Innstillinger for verktøy for Universell utforming';
$string['sitehash'] = 'Hemmelig nøkkel';
$string['sitehash_help'] = 'Denne koden mottas via e-post etter registrering.';
$string['taberrors'] = 'Sjekk feil';
$string['targetavetitle'] = 'Gjennomsnittlig antall feil pr. aktivitet';
$string['targetpercentage'] = 'Prosent av instanser godkjent/ikke godkjent pr. aktivitet';
$string['targetratio'] = 'Grad av godkjente aktiviteter';
$string['tblcheck'] = 'Sjekk';
$string['tblcheckexample'] = 'Eksempel';
$string['tblcheckfailed'] = 'Sjekker feilet';
$string['tblchecksummary'] = 'Sammendrag';
$string['tbledit'] = 'Rediger';
$string['tblerrorcount'] = 'Feil';
$string['tblhtmlcode'] = 'Eksisterende HTML-kode';
$string['tblinstance'] = 'Instans';
$string['tblline'] = 'Linje';
$string['tbloverallpercentage'] = 'Total feil %';
$string['tblpercentage'] = 'Prosent';
$string['tblpreview'] = 'Forhåndsvis';
$string['tbltarget'] = 'Aktivitet';
$string['tblupdateto'] = 'Oppdater til';
$string['titleactivityresultsall'] = 'Resultater per aktivitet: alle gjennomgåtte kurs ({$a->count} kurs)';
$string['titleactivityresultspartial'] = 'Resultater pr. aktivitet: Kurs {$a->name}';
$string['titleall'] = 'Feildetaljer: alle gjennomgåtte kurs ({$a->count} kurs)';
$string['titlechecktyperesultsall'] = 'Resultater per innholdstype: alle gjennomgåtte kurs ({$a->count} kurs)';
$string['titlechecktyperesultspartial'] = 'Resultater per innholdstype: kurs {$a->name}';
$string['titleerrorsall'] = 'Feildetaljer: Alle viste kurs ({$a->count} kurs)';
$string['titleerrorscount'] = 'Feildetaljer: (Viser første {$a} feil)';
$string['titleerrorspartial'] = 'Feildetaljer: kurs {$a->name}';
$string['titlepartial'] = 'Feildetaljer: kurs {$a->name}';
$string['titleprintableall'] = 'Kurs {$a->name}';
$string['titleprintablepartial'] = 'Kurs {$a->name}';
$string['tools'] = 'Rapporter';
$string['toperrors'] = 'Vanligste feil';
$string['toptargets'] = 'Feilede aktiviteter';
$string['totalactivities'] = 'Aktivitetstotal';
$string['totalactivitiescount'] = 'Aktivitetstotal: {$a}';
$string['totalareas'] = 'Totalt antall arealer';
$string['totalerrors'] = 'Totalt antall feil';
$string['totalgrouperrors'] = 'Totale (sum) feil per innholdstype';
$string['updatesummarydata'] = 'Oppdater sammendragsdata';
$string['usersmobileregistered'] = 'Antall brukere med registrerte mobile enheter ({$a})';
$string['validationerror'] = 'Valideringen av registreringsnøkkelen mislyktes. Kontroller at den registrerte nettadressen og nøklene er riktige.';
$string['warningcheckidbody'] = 'Det er et problem med en Brickfield-sjekk som er aktiv, men ikke oppført i databasen. Vennligst undersøk.';
$string['warningcheckidsubject'] = 'Brickfield Toolkit checkID advarsel';
