<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'factor_totp', language 'ru', version '4.3'.
 *
 * @package     factor_totp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:revoke'] = 'Отозвать аутентификатор одноразового пароля на основе времени (TOTP)';
$string['devicename'] = 'Метка устройства';
$string['devicename_help'] = 'На этом устройстве установлено приложение для аутентификации. Вы можете настроить несколько устройств, чтобы эта метка помогала отслеживать, какие из них используются. Вам следует настроить для каждого устройства свой уникальный код, чтобы их можно было отозвать отдельно.';
$string['devicenameexample'] = 'например: «iPhone 11 на работе»';
$string['error:alreadyregistered'] = 'Этот секретный одноразовый пароль (TOTP) уже зарегистрирован.';
$string['error:codealreadyused'] = 'Этот код уже использовался для аутентификации. Пожалуйста, подождите, пока будет сгенерирован новый код, и повторите попытку.';
$string['error:futurecode'] = 'Этот код недействителен. Пожалуйста, проверьте правильность времени на вашем устройстве аутентификации и повторите попытку.
     Текущее системное время: {$a}.';
$string['error:oldcode'] = 'Этот код слишком старый. Пожалуйста, проверьте правильность времени на вашем устройстве аутентификации и повторите попытку.
     Текущее системное время: {$a}.';
$string['error:wrongverification'] = 'Неправильный код подтверждения.';
$string['factorsetup'] = 'Настройка приложения';
$string['info'] = '<p>Использовать любое приложение аутентификации для одноразового пароля на основе времени (TOTP) на своем устройстве, чтобы сгенерировать код подтверждения, даже если оно не в сети.</p>

<p>Например, <a href="https://2fas.com/">2FAS Auth</a>, <a href="https://freeotp.github.io/">FreeOTP</a>, Google Authenticator, Microsoft Authenticator или Twilio Authy.</p>

<p>Примечание. Убедитесь, что время и дата вашего устройства установлены на «Авто» или «Предоставляется сетью».</p>';
$string['logindesc'] = 'Использовать приложение аутентификации на своем мобильном устройстве, чтобы сгенерировать код.';
$string['loginoption'] = 'Использовать приложение аутентификации';
$string['loginskip'] = 'у меня нет устройства';
$string['loginsubmit'] = 'Продолжить';
$string['logintitle'] = 'Подтвердить свою личность с помощью мобильного приложения';
$string['pluginname'] = 'Аутентификатор приложения';
$string['privacy:metadata'] = 'Плагин Фактора «Аутентификатор приложения» не хранит никаких личных данных.';
$string['settings:totplink'] = 'Показать ссылку для настройки мобильного приложения';
$string['settings:totplink_help'] = 'Если этот параметр включен, пользователь увидит третий вариант настройки с прямой ссылкой otpauth://';
$string['settings:window'] = 'Окно проверки TOTP';
$string['settings:window_help'] = 'Как долго действителен каждый код. Вы можете установить более высокое значение в качестве обходного пути, если часы устройств ваших пользователей часто немного ошибаются.
     Округляется до ближайших 30 секунд, что соответствует времени между новыми генерируемыми кодами.';
$string['setupfactor'] = 'Настройка TOTP-аутентификатора';
$string['setupfactor:account'] = 'Учетная запись:';
$string['setupfactor:enter'] = 'Введите данные вручную:';
$string['setupfactor:key'] = 'Секретный ключ:';
$string['setupfactor:link'] = '<b> ИЛИ </b> открыть мобильное приложение:';
$string['setupfactor:link_help'] = 'Если вы используете мобильное устройство и у вас уже установлено приложение для аутентификации, эта ссылка может работать. Обратите внимание, что использование TOTP на том же устройстве, на котором вы входите в систему, может ослабить преимущества MФA.';
$string['setupfactor:linklabel'] = 'Открыть приложение, уже установленное на этом устройстве.';
$string['setupfactor:mode'] = 'Режим:';
$string['setupfactor:mode:timebased'] = 'На основе времени';
$string['setupfactor:scan'] = 'Сканировать QR-код:';
$string['setupfactor:scanfail'] = 'Не можете отсканировать?';
$string['setupfactor:scanwithapp'] = 'Отсканировать QR-код с помощью выбранного приложения для аутентификации.';
$string['summarycondition'] = 'с помощью приложения TOTP';
$string['verificationcode'] = 'Введите свой 6-значный код подтверждения';
$string['verificationcode_help'] = 'Откройте приложение для аутентификации, например Google Authenticator, и найдите 6-значный код, соответствующий этому сайту и имени пользователя.';
