<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_shibboleth', language 'sr_cr', version '4.3'.
 *
 * @package     auth_shibboleth
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_shib_auth_logo'] = 'Лого метода провере идентитета';
$string['auth_shib_auth_logo_description'] = 'Наведите лого за Shibboleth методу провере идентитета који је познат вашим корисницима. То може бити лого ваше Shibboleth федерације, нпр. <tt>SWITCHaai Login</tt> или <tt>InCommon Login</tt> или слично.';
$string['auth_shib_auth_method'] = 'Назив метода за проверу идентитета';
$string['auth_shib_auth_method_description'] = 'Наведите назив за Shibboleth методу провере идентитета који је познат вашим корисницима. То може бити назив ваше Shibboleth федерације, нпр. <tt>SWITCHaai Login</tt> или <tt>InCommon Login</tt> или слично.';
$string['auth_shib_changepasswordurl'] = 'URL за промену лозинке';
$string['auth_shib_contact_administrator'] = 'У случају да нисте повезани са наведеним организацијама а треба да приступите курсу на овом серверу, молимо контактирајте <a href="mailto:{$a}">Moodle администратора</a>.';
$string['auth_shib_convert_data'] = 'API за модификације података';
$string['auth_shib_convert_data_description'] = 'Можете да користите овај API за даљу модификацију података добијених од Shibboletha. Прочитајте <a href="{$a}">README</a> за додатна упутства.';
$string['auth_shib_convert_data_filepath_warning'] = 'Не можете користити датотеку која се налази у текућем директоријуму података сајта ($CFG->dataroot) као API за модификацију података.';
$string['auth_shib_convert_data_warning'] = 'Датотека не постоји или процес веб сервера не може да је прочита';
$string['auth_shib_idp_list'] = 'Даваоци идентитета';
$string['auth_shib_idp_list_description'] = 'Обезбедите списак entityID ознака провајдера идентитета (Identity Provider – IdP) како бисте омогућили корисницима да изаберу на страници за пријаву.<br />У сваком реду мора да буде по један дублет података, који се састоји од ID ознаке и назива IdP (погледајте Shibboleth метадата датотеку), онако као што ће то бити приказано у падајућој листи.<br /> Као трећи опциони параметар можете да додате локацију иницијатора Shibboleth сесије која ће се користити у случају да је Ваша инсталација Moodlea део више-федерацијског подешавања.';
$string['auth_shib_instructions'] = 'Користите <a href="{$a}">Shibboleth приступ систему</a> да бисте приступили преко Shibboletha, ако га ваша институција подржава. У супротном, користите стандардан образац за пријаву приказан овде.';
$string['auth_shib_instructions_help'] = 'Овде треба да унесете упутство за Ваше кориснике како бисте им објаснили Shibboleth. Оно ће бити приказано на страници за пријављивање. Упутство мора да садржи линк ка "<b>{$a}</b>" на који ће  корисници кликнути када буду хтели да се пријаве на систем.';
$string['auth_shib_instructions_key'] = 'Упутство за пријаву на систем';
$string['auth_shib_integrated_wayf'] = 'Moodle WAYF сервис';
$string['auth_shib_integrated_wayf_description'] = 'Ако омогућите ову опцију, Moodle ће користити свој WAYF сервис уместо оног који је конфигурисан за Shibboleth. Moodle ће приказати падајућу листу на овој алтернативној страници за пријаву на систем где ће корисник моћи да изабере свог даваоца идентитета.';
$string['auth_shib_logout_return_url'] = 'Алтернативни УРЛ након одјаве';
$string['auth_shib_logout_return_url_description'] = 'Обезбедите URL на који ће Shibboleth корисници бити преусмерени након одјаве са система<br />Ако је остављено празно, корисници ће бити преусмерени на локацију на коју се иначе преусмеравају Moodle корисници';
$string['auth_shib_logout_url'] = 'URL након одјаве (Shibboleth SP)';
$string['auth_shib_logout_url_description'] = 'Обезбедите URL након одјаве са Shibboleth Service Providera. Ово је обично <tt>/Shibboleth.sso/Logout</tt>';
$string['auth_shib_no_organizations_warning'] = 'Уколико желите да користите интегрисани WAYF сервис, морате да дате листу Провајдера идентитета (Identity Provider entityIDs) раздвојену зарезом, њихова имена и опционо покретача сесије.';
$string['auth_shib_only'] = 'Само Shibboleth';
$string['auth_shib_only_description'] = 'Потврдите ову опцију уколико желите да провера идентитета помоћу Shibboletha буде наметнута.';
$string['auth_shib_username_description'] = 'Назив веб сервера променљиве Shibboleth окружења која ће се користити као Moodle корисничко име';
$string['auth_shibboleth_errormsg'] = 'Изаберите организацију чији сте члан?';
$string['auth_shibboleth_login'] = 'Shibboleth пријава на систем';
$string['auth_shibboleth_login_long'] = 'Пријава на Moodle преко Shibboletha';
$string['auth_shibboleth_manual_login'] = 'Ручна пријава на систем';
$string['auth_shibboleth_select_member'] = 'Ја сам члан...';
$string['auth_shibboleth_select_organization'] = 'За проверу идентитета путем Shibboletha молимо вас да изаберете своју организацију из падајућег менија:';
$string['auth_shibbolethdescription'] = 'Помоћу овог метода корисници се креирају и њихов идентитет проверава користећи Shibboleth. За више информација о подешавању погледајте <a href="{$a}">Shibboleth README</a>.';
$string['pluginname'] = 'Shibboleth';
$string['privacy:metadata'] = 'Додатак за проверу идентитета Shibboleth не чува никакве личне податке.';
$string['shib_invalid_account_error'] = 'Чини се да вас је Shibboleth ауторизовао али Moodle нема важећи налог за ваше корисничко име. Ваш налог можда не постоји или постоји могућност да је суспенодаван.';
$string['shib_no_attributes_error'] = 'Изгледа да је Shibboleth потврдио Ваш идентитет али Moodle није добио корисничке атрибуте. Проверите да ли је Ваш Давалац идентитета издао потребне атрибуте ({$a})  или обавестите администратора овог сервера.';
$string['shib_not_all_attributes_error'] = 'Moodle тражи одређене Shibboleth атрибуте који у вашем случају нису присутни. Тражени су следећи атрибути: {$a}<br />Молимо вас да контактирате вебмастера овог сервера или Даваоца идентитета.';
$string['shib_not_set_up_error'] = 'Изгледа да Shibboleth провера идентитета није исправно подешена зато што нису присутне варијабле Shibboleth окружења за ову страницу. Молимо вас да прочитате <a href="{$a}">README</a> за да даља упутства о подешавању Shibboleth провере идентитета или се обратите администратору ове Moodle инсталације.';
