<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'report_security', language 'lo', version '4.3'.
 *
 * @package     report_security
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['check_antivirus_details'] = 'ສະຖານະນີ້ກວດເບິ່ງວ່າ ມີຂໍ້ຜິດພາດທີ່ກວດພົບເມື່ອບໍ່ດົນມານີ້ຫຼືບໍ່ ໂດຍອີງໃສ່ເກນທີ່ກໍານົດໄວ້ໃນການຕັ້ງຄ່າຕ້ານໄວຣັສຕົ້ນຕໍ.';
$string['check_antivirus_error'] = '{$a->errors} ຂໍ້ຜິດພາດໄດ້ຖືກກວດພົບພາຍໃນ {$a->lookback} ຫຼ້າສຸດ';
$string['check_antivirus_info'] = 'ບໍ່ມີເຄື່ອງສະແກນຕ້ານໄວຣັສຖືກເປີດໃຊ້ໃນປັດຈຸບັນ';
$string['check_antivirus_logstore_not_supported'] = 'ບໍ່ສາມາດກວດສອບສະຖານະຂອງເຄື່ອງສະແກນຕ້ານໄວຣັສໄດ້ເນື່ອງຈາກປະເພດຂອງຮ້ານບັນທຶກທີ່ເລືອກ';
$string['check_antivirus_name'] = 'ຕ້ານໄວຣັສ';
$string['check_antivirus_ok'] = '{$a->scanners} ເປີດໃຊ້ຕົວສະແກນຕ້ານໄວຣັສ, ບໍ່ມີບັນຫາໃດໄດ້ຖືກກວດພົບໃນໄລຍະສຸດທ້າຍ {$a->lookback}';
$string['check_configrw_details'] = '<p>ຂໍແນະນຳໃຫ້ມີການປ່ຽນສິດອະນຸຍາດໄຟລ໌ຂອງ <code>config.php</code> ຫຼັງຈາກການຕິດຕັ້ງເພື່ອບໍ່ໃຫ້ໄຟລ໌ເວັບເຊີບເວີຖືກດັດແກ້.
ກະລຸນາຮັບຊາບວ່າ ມາດຕະການນີ້ບໍ່ໄດ້ປັບປຸງຄວາມປອດໄພຂອງເຊີບເວີຢ່າງຫຼວງຫຼາຍ, ເຖິງແມ່ນວ່າ ມັນອາດຈະຊ້າລົງ ຫຼື ຈໍາກັດການຂູດຮີດທົ່ວໄປ.</p>';
$string['check_configrw_name'] = 'config.php ສາມາດຂຽນໄດ້';
$string['check_configrw_ok'] = 'config.php ບໍ່ສາມາດຖືດດັດແປງໂດຍສະຄຣິບ PHP.';
$string['check_configrw_warning'] = 'ສະຄຣິບ PHP ອາດດັດແປງ config.php.';
$string['check_cookiesecure_details'] = '<p>ຖ້າການສື່ສານ https ຖືກເປີດໃຊ້ງານ, ຂໍແນະນຳໃຫ້ເປີດການສົ່ງຄຸກກີ້ທີ່ປອດໄພ. ທ່ານຄວນມີການປ່ຽນເສັ້ນທາງຖາວອນຈາກ http ໄປຫາ https ແລະ ເໝາະສົມໃຫ້ບໍລິການສ່ວນຫົວ HSTS ເຊັ່ນກັນ.</p>';
$string['check_cookiesecure_error'] = 'ກະລຸນາເປີດໃຊ້ງານຄຸກກີ້ທີ່ປອດໄພ';
$string['check_cookiesecure_http'] = 'ທ່ານຕ້ອງເປີດ http ເພື່ອນຳໃຊ້ຄຸກກີ້ທີ່ປອດໄພ';
$string['check_cookiesecure_name'] = 'ຄຸກກີ້ທີ່ປອດໄພ';
$string['check_cookiesecure_ok'] = 'ເປີດໃຊ້ງານຄຸກກີ້ທີ່ປອດໄພ';
$string['check_crawlers_details'] = '<p>ການຕັ້ງຄ່າ "ເປີດໄປຫາເຄື່ອງຈັກຊອກຫາ" ຊ່ວຍໃຫ້ເຄື່ອງຈັກຊອກຫາສາມາດເຂົ້າຫຼັກສູດທີ່ມີການເຂົ້າເຖິງແຂກ. ບໍ່ມີຈຸດໃດໃນການເປີດໃຊ້ງານການຕັ້ງຄ່ານີ້ ຖ້າຫາກວ່າ ການເຂົ້າສູ່ລະບົບຂອງແຂກບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້.</p>';
$string['check_crawlers_error'] = 'ການເຂົ້າເຖິງເຄື່ອງຈັກຊອກຫາໄດ້ອະນຸຍາດແຕ່ການເຂົ້າຫາແຂກແມ່ນຖືກປິດໃຊ້ງານ.';
$string['check_crawlers_info'] = 'ເຄື່ອງຈັກຊອກຫາອາດເຂົ້າໄປເປັນແຂກ.';
$string['check_crawlers_name'] = 'ເປີດຫາເຄື່ອງຈັກຊອກຫາ';
$string['check_crawlers_ok'] = 'ການເຂົ້າຫາເຄື່ອງຈັກຊອກຫາແມ່ນບໍ່ໄດ້ເປີດໃຊ້ງານ.';
$string['check_defaultuserrole_details'] = '<p>ຜູ້ໃຊ້ທີ່ເຂົ້າສູ່ລະບົບທັງໝົດ ແມ່ນໄດ້ຮັບຄວາມສາມາດຂອງບົດບາດຜູ້ໃຊ້ເລີ່ມຕົ້ນ. ກະລຸນາເຮັດໃຫ້ແນ່ໃຈວ່າ ບໍ່ມີຄວາມສາມາດທີ່ມີຄວາມສ່ຽງທີ່ໄດ້ຮັບອະນຸຍາດໃຫ້ໃນໜ້າທີ່ນີ້.</p>
<p>ປະເພດເດີມທີ່ຮອງຮັບສະເພາະສຳລັບບົດບາດຜູ້ໃຊ້ເລີ່ມຕົ້ນແມ່ນ <em>ຜູ້ໃຊ້ທີ່ຮັບຮອງຄວາມຖືກຕ້ອງ</em>. ຄວາມສາມາດເບິ່ງຫຼັກສູດຈະຕ້ອງບໍ່ຖືກເປີດໃຊ້ງານ.</p>';
$string['check_defaultuserrole_error'] = 'ບົດບາດຜູ້ໃຊ້ເລີ່ມຕົ້ນ "{$a}" ຖືກກຳນົດບໍ່ຖືກຕ້ອງ!';
$string['check_defaultuserrole_name'] = 'ໜ້າທີ່ເລີ່ມຕົ້ນສຳລັບຜູ້ໃຊ້ທຸກຄົນ';
$string['check_defaultuserrole_notset'] = 'ໜ້າທີ່ເລີ່ມຕົ້ນບໍ່ໄດ້ຖືກຕັ້ງ.';
$string['check_defaultuserrole_ok'] = 'ຄຳນິຍາມໜ້າທີ່ເລີ່ມຕົ້ນສຳລັບຜູ້ໃຊ້ທຸກຄົນແມ່ນຕົກລົງ.';
$string['check_dirindex_info'] = 'ດັດຊະນີບັນຊີລາຍຊື່ບໍ່ຄວນຖືກເປີດໃຊ້';
$string['check_displayerrors_details'] = '<p>ການເປີດໃຊ້ການຕັ້ງຄ່າ PHP <code>display_errors</code> ແມ່ນບໍ່ແນະນໍາໃນເວັບໄຊທ໌ການຜະລິດເພາະວ່າຂໍ້ຄວາມສະແດງຂໍ້ຜິດພາດສາມາດເປີດເຜີຍຂໍ້ມູນທີ່ລະອຽດອ່ອນກ່ຽວກັບເຄື່ອງແມ່ຂ່າຍຂອງທ່ານ.</p>';
$string['check_displayerrors_error'] = 'ການຕັ້ງຄ່າ PHP ເພື່ອສະແດງຂໍ້ຜິດພາດຖືກເປີດໃຊ້. ມັນໄດ້ຖືກແນະນໍາໃຫ້ປິດການໃຊ້ງານ.';
$string['check_displayerrors_name'] = 'ກຳລັງສະແດງຄວາມຜິດພາດ PHP';
$string['check_displayerrors_ok'] = 'ປິດໃຊ້ງານການສະແດງຄວາມຜິດພາດ PHP.';
$string['check_dotfiles_info'] = 'dotfiles ທັງໝົດຍົກເວັ້ນ /.well-known/* ບໍ່ຄວນເປີດເຜີຍຕໍ່ສາທາລະນະ';
$string['check_emailchangeconfirmation_details'] = '<p>ຂໍແນະນຳວ່າ ຕ້ອງມີຂັ້ນຕອນການຢືນຢັນອີເມລ ເມື່ອຜູ້ໃຊ້ປ່ຽນທີ່ຢູ່ອີເມລໃນໂປຼໄຟລ໌ຂອງເຂົາທ່ານ. ຖ້າປິດໃຊ້ງານ, ຕົວສະແປມ ອາດຈະພະຍາຍາມຂຸດຄົ້ນເຄື່ອງແມ່ຂ່າຍເພື່ອສົ່ງສະແປມ.</p>
<p>ຊ່ອງອີເມລອາດຖືກລັອກຈາກປລັກອິນການກວດສອບ, ຄວາມເປັນໄປໄດ້ນີ້ ບໍ່ໄດ້ຖືກພິຈາລະນາຢູ່ທີ່ນີ້.</p>';
$string['check_emailchangeconfirmation_error'] = 'ຜູ້ໃຊ້ອາດເຂົ້າໄປທີ່ຢູ່ອີເມລໃດໜຶ່ງ.';
$string['check_emailchangeconfirmation_info'] = 'ຜູ້ໃຊ້ອາດເຂົ້າໄປທີ່ຢູ່ອີເມລຕ່າງໆຈາກໂດເມນທີ່ອະນຸຍາດເທົ່ານັ້ນ.';
$string['check_emailchangeconfirmation_name'] = 'ການຢືນຢັນປ່ຽນແປງອີເມລ';
$string['check_emailchangeconfirmation_ok'] = 'ການຢືນຢັນການປ່ຽນແປງທີ່ຢູ່ອີເມລໃນໂປຼໄຟລ໌ຜູ້ໃຊ້.';
$string['check_embed_details'] = '<p>ການຝັງວັດຖຸທີ່ບໍ່ຈຳກັດແມ່ນອັນຕະລາຍຫຼາຍ - ຜູ້ໃຊ້ທີ່ລົງທະບຽນແລ້ວອາດຈະເປີດການໂຈມຕີ XSS ຕໍ່ຜູ້ໃຊ້ເຊີບເວີອື່ນ. ການຕັ້ງຄ່ານີ້ ຄວນຈະຖືກປິດໃຊ້ງານຢູ່ໃນເຊີບເວີການຜະລິດ.</p>';
$string['check_embed_error'] = 'ເປີດໃຊ້ການຝັງວັດຖຸທີ່ບໍ່ຈໍາກັດ - ສິ່ງນີ້ເປັນອັນຕະລາຍຫຼາຍສໍາລັບເຊີບເວີສ່ວນໃຫຍ່.';
$string['check_embed_name'] = 'ອະນຸຍາດ EMBED ແລະ OBJECT';
$string['check_embed_ok'] = 'ບໍ່ອະນຸຍາດໃຫ້ຝັງວັດຖຸທີ່ບໍ່ຈຳກັດ.';
$string['check_frontpagerole_details'] = '<p>ບົດບາດໜ້າຫຼັກເວັບໄຊທ໌ແມ່ນມອບໃຫ້ກັບຜູ້ໃຊ້ທີ່ລົງທະບຽນທັງໝົດສຳລັບກິດຈະກຳໜ້າໜ້າຫຼັກເວັບໄຊທ໌. ກະລຸນາກວດສອບໃຫ້ແນ່ໃຈວ່າ ບໍ່ມີຄວາມສາມາດທີ່ມີຄວາມສ່ຽງຕໍ່ບົດບາດນີ້.</p>
<p>ຂໍແນະນຳໃຫ້ສ້າງບົດບາດພິເສດເພື່ອຈຸດປະສົງນີ້ ແລະ ບໍ່ໄດ້ນຳໃຊ້ບົດບາດປະເພດເກົ່າ.</p>';
$string['check_frontpagerole_error'] = 'ກວດພົບບົດບາດໜ້າຫຼັກເວັບໄຊທ໌ທີ່ກຳນົດບໍ່ຖືກຕ້ອງ "{$a}"!';
$string['check_frontpagerole_name'] = 'ໜ້າທີ່ໜ້າຫຼັກເວັບໄຊທ໌ຢູ່ດ້ານໜ້າ';
$string['check_frontpagerole_notset'] = 'ໜ້າທີ່ໜ້າຫຼັກເວັບໄຊທ໌ບໍ່ໄດ້ຕັ້ງ.';
$string['check_frontpagerole_ok'] = 'ຄຳນິຍາມໜ້າທີ່ໜ້າຫຼັກເວັບໄຊທ໌ແມ່ນຕົກລົງ';
$string['check_guestrole_details'] = '<p>ບົດບາດແຂກຖືກໃຊ້ສຳລັບແຂກ, ບໍ່ໄດ້ເຂົ້າສູ່ລະບົບຜູ້ໃຊ້ ແລະ ການເຂົ້າເຖິງຫຼັກສູດແຂກຊົ່ວຄາວ. ກະລຸນາເຮັດໃຫ້ແນ່ໃຈວ່າ ບໍ່ມີຄວາມສາມາດທີ່ມີຄວາມສ່ຽງທີ່ໄດ້ຮັບອະນຸຍາດໃຫ້ໃນໜ້າທີ່ນີ້.</p>
<p>ປະເພດມໍລະດົກທີ່ຮອງຮັບສະເພາະສຳລັບບົດບາດແຂກແມ່ນ <em>ແຂກ</em>.</p>';
$string['check_guestrole_error'] = 'ບົດບາດແຂກ "{$a}" ຖືກກຳນົດບໍ່ຖືກຕ້ອງ!';
$string['check_guestrole_name'] = 'ໜ້າທີ່ແຂກ';
$string['check_guestrole_notset'] = 'ໜ້າທີ່ແຂກບໍ່ໄດ້ຕັ້ງ.';
$string['check_guestrole_ok'] = 'ຄຳນິຍາມໜ້າທີ່ແຂກແມ່ນຕົກລົງ.';
$string['check_mediafilterswf_details'] = '<p>ການຝັງ swf ອັດຕະໂນມັດແມ່ນອັນຕະລາຍຫຼາຍ - ຜູ້ໃຊ້ທີ່ລົງທະບຽນອາດຈະເປີດການໂຈມຕີ XSS ຕໍ່ຜູ້ໃຊ້ເຊີບເວີອື່ນ. ກະລຸນາປິດການນຳໃຊ້ມັນຢູ່ໃນເຊີບເວີການຜະລິດ.</p>';
$string['check_mediafilterswf_error'] = 'ການກັ່ນຕອງສື່ມວນຊົນ Flash ຖືກເປີດໃຊ້ - ສິ່ງນີ້ແມ່ນອັນຕະລາຍຫຼາຍສໍາລັບເຄື່ອງແມ່ຂ່າຍສ່ວນໃຫຍ່.';
$string['check_mediafilterswf_name'] = 'ຕົວກັ່ນຕອງສື່ .swf ຖືກຝັງໄວ້';
$string['check_mediafilterswf_ok'] = 'ຕົວກັ່ນຕອງສື່ Flash ບໍ່ໄດ້ເປີດໃຊ້ງານ.';
$string['check_nodemodules_details'] = '<p>ບັນຊີລາຍການ <code>{$a->path}</code> ປະກອບມີຊຸດ Node.js ແລະ ຄວາມເພິ່ງພາອາໄສຂອງພວກມັນ, ໂດຍປົກກະຕິແລ້ວແມ່ນຕິດຕັ້ງໂດຍຄຸນປະໂຫຍດ NPM. ຊຸດເຫຼົ່ານີ້ອາດຈະຈໍາເປັນສໍາລັບການພັດທະນາ Moodle ທ້ອງຖິ່ນ, ເຊັ່ນ: ສໍາລັບການນໍາໃຊ້ກອບ grunt. ພວກມັນບໍ່ຈຳເປັນໃນການແລ່ນເວັບໄຊທ໌ Moodle ໃນການຜະລິດ ແລະ ພວກມັນສາມາດບັນຈຸລະຫັດອັນຕະລາຍທີ່ອາດຈະເຮັດໃຫ້ເວັບໄຊທ໌ຂອງທ່ານ ຖືກໂຈມຕີຈາກໄລຍະໄກໄດ້.</p><p>ແນະນຳຢ່າງຍິ່ງໃຫ້ລຶບບັນຊີລາຍຊື່ ຖ້າເວັບໄຊທ໌ມີຢູ່ຜ່ານ URL ສາທາລະນະ, ຫຼື ຢ່າງໜ້ອຍຫ້າມການເຂົ້າຫາເວັບໃນການຕັ້ງຄ່າເວັບເຊີບເວີຂອງທ່ານ.</p>';
$string['check_nodemodules_info'] = 'ລາຍການ node_modules ຄວນບໍ່ຖືກສະແດງໃນເວັບໄຊທ໌ສາທາລະນະ.';
$string['check_nodemodules_name'] = 'ລາຍການຊຸດ Node.js';
$string['check_openprofiles_details'] = 'ເປີດໂປຼໄຟລ໌ຜູ້ໃຊ້ສາມາດຖືກລ່ວງລະເມີດໂດຍຕົວສະແປມ. ຂໍແນະນຳບໍ່ວ່າທັງສອງ <code>ການບັງຄັບໃຫ້ຜູ້ໃຊ້ເຂົ້າສູ່ລະບົບໂປຼໄຟລ໌</code> ຫຼື <code>ບັງຄັບໃຫ້ຜູ້ໃຊ້ເຂົ້າສູ່ລະບົບ</code> ແມ່ນຖືກເປີດໃຊ້ງານ.';
$string['check_openprofiles_error'] = 'ທຸກຄົນສາມາດເບິ່ງໂປຼໄຟລ໌ຜູ້ໃຊ້ໂດຍບໍ່ມີການລົງຊື່ເຂົ້າໃຊ້.';
$string['check_openprofiles_name'] = 'ເປີດໂປຼໄຟລ໌ຜູ້ໃຊ້';
$string['check_openprofiles_ok'] = 'ຕ້ອງເຂົ້າສູ່ລະບົບກ່ອນທີ່ຈະເບິ່ງໂປຼໄຟລ໌ຜູ້ໃຊ້.';
$string['check_passwordpolicy_details'] = '<p>ແນະນຳໃຫ້ຕັ້ງນະໂຍບາຍລະຫັດຜ່ານ, ເພາະວ່າ ການຄາດເດົາລະຫັດຜ່ານແມ່ນເປັນວິທີທີ່ງ່າຍທີ່ສຸດທີ່ຈະເຂົ້າເຖິງໂດຍບໍ່ໄດ້ຮັບອະນຸຍາດ.
ຢ່າເຮັດໃຫ້ຄວາມຕ້ອງການເຄັ່ງຄັດເກີນໄປ, ເພາະວ່າ ອັນນີ້ອາດສົ່ງຜົນໃຫ້ຜູ້ໃຊ້ບໍ່ສາມາດຈື່ລະຫັດຜ່ານຂອງເຂົາເຈົ້າໄດ້ ແລະ ອາດຈະລືມ ຫຼື ຂຽນລົງ.</p>';
$string['check_passwordpolicy_error'] = 'ນະໂຍບາຍລະຫັດຜ່ານບໍ່ໄດ້ຕັ້ງ.';
$string['check_passwordpolicy_name'] = 'ນະໂຍບາຍລະຫັດຜ່ານ';
$string['check_passwordpolicy_ok'] = 'ເປີດໃຊ້ງານນະໂຍບາຍລະຫັດຜ່ານແລ້ວ.';
$string['check_preventexecpath_details'] = '<p>ການອະນຸຍາດໃຫ້ກຳນົດເສັ້ນທາງປະຕິບັດໄດ້ຜ່ານ Admin GUI ເປັນເສັ້ນສົມມຸດສຳລັບການເພີ່ມສິດທິພິເສດ. ສິ່ງນີ້ຕ້ອງຖືກບັງຄັບໃນ config.php:</p><p><code>$CFG->preventexecpath = true;</code></p>';
$string['check_preventexecpath_name'] = 'ເສັ້ນທາງທີ່ປະຕິບັດໄດ້';
$string['check_preventexecpath_ok'] = 'ເສັ້ນທາງທີ່ປະຕິບັດໄດ້ສາມາດແກ້ໄຂໃນ config.php ເທົ່ານັ້ນ.';
$string['check_preventexecpath_warning'] = 'ເສັ້ນທາງທີ່ສາມາດປະຕິບັດໄດ້ສາມາດຖືກກໍານົດໄວ້ໃນ Admin GUI.';
$string['check_publicpaths_403'] = '(ສົ່ງຄືນເປັນ 403, ໂດຍສະເພາະຄວນຈະເປັນ 404)';
$string['check_publicpaths_generic'] = 'ໄຟລ໌ {$a} ບໍ່ຄວນເປີດເຜີຍຕໍ່ສາທາລະນະ';
$string['check_publicpaths_name'] = 'ກວດສອບເສັ້ນທາງສາທາລະນະ / ສ່ວນຕົວທັງໝົດ';
$string['check_publicpaths_ok'] = 'ເສັ້ນທາງພາຍໃນທັງໝົດແມ່ນບໍ່ສາມາດເຂົ້າຫາແບບສາທາລະນະ';
$string['check_publicpaths_warning'] = 'ບາງເສັ້ນທາງພາຍໃນແມ່ນບໍ່ສາມາດເຂົ້າຫາແບບສາທາລະນະ';
$string['check_riskadmin_detailsok'] = '<p>ກະລຸນາກວດສອບລາຍຊື່ຜູ້ເບິ່ງແຍງລະບົບຕໍ່ໄປນີ້:</p>{$a}';
$string['check_riskadmin_detailswarning'] = '<p>ກະລຸນາກວດສອບລາຍຊື່ຜູ້ເບິ່ງແຍງລະບົບຕໍ່ໄປນີ້:</p>{$a->admins}
<p>ແນະນຳໃຫ້ກຳນົດບົດບາດຜູ້ເບິ່ງແຍງລະບົບໃນບໍລິບົດຂອງລະບົບເທົ່ານັ້ນ. ຜູ້ໃຊ້ຕໍ່ໄປນີ້ມີ (ບໍ່ຮອງຮັບ) ການມອບໝາຍໜ້າທີ່ຜູ້ບໍລິຫານໃນສະພາບການອື່ນ:</p>{$a->unsupported}';
$string['check_riskadmin_name'] = 'ຜູ້ຄວບຄຸມລະບົບ';
$string['check_riskadmin_ok'] = 'ພົບເຊີບເວີ {$a} ຜູ້ຄວບຄຸມລະບົບ.';
$string['check_riskadmin_unassign'] = '<a href="{$a->url}">{$a->fullname} ({$a->email}) ທົບທວນການມອບໝາຍ</a>';
$string['check_riskadmin_warning'] = 'ພົບຜູ້ເບິ່ງແຍງເຊີບເວີ {$a->admincount} ແລະ {$a->unsupcount} ການມອບໝາຍໜ້າທີ່ບໍລິຫານທີ່ບໍ່ຮອງຮັບ.';
$string['check_riskbackup_details_overriddenroles'] = '<p>ການລົບລ້າງເຄື່ອນໄຫວເຫຼົ່ານີ້ ໃຫ້ຜູ້ໃຊ້ສາມາດລວມເອົາຂໍ້ມູນຜູ້ໃຊ້ເຂົ້າໃນການສໍາຮອງຂໍ້ມູນ. ກະລຸນາໃຫ້ແນ່ໃຈວ່າ ການອະນຸຍາດນີ້ ເປັນສິ່ງຈໍາເປັນ.</p> {$a}';
$string['check_riskbackup_details_systemroles'] = '<p>ບົດບາດຂອງລະບົບຕໍ່ໄປນີ້ ໃນປັດຈຸບັນອະນຸຍາດໃຫ້ຜູ້ໃຊ້ລວມເອົາຂໍ້ມູນຜູ້ໃຊ້ເຂົ້າໃນການສຳຮອງຂໍ້ມູນ. ກະລຸນາໃຫ້ແນ່ໃຈວ່າ ການອະນຸຍາດນີ້ ເປັນສິ່ງຈໍາເປັນ.</p> {$a}';
$string['check_riskbackup_details_users'] = '<p>ເນື່ອງຈາກບົດບາດຂ້າງເທິງ ຫຼື ການຍົກເລີກທ້ອງຖິ່ນ, ບັນຊີຜູ້ໃຊ້ຕໍ່ໄປນີ້ ໃນປັດຈຸບັນມີການອະນຸຍາດໃຫ້ເຮັດການສໍາຮອງທີ່ມີຂໍ້ມູນສ່ວນຕົວຈາກຜູ້ໃຊ້ທີ່ລົງທະບຽນໃນຫຼັກສູດຂອງເຂົາເຈົ້າ. ໃຫ້ແນ່ໃຈວ່າເຂົາເຈົ້າ (ກ) ເຊື່ອຖືໄດ້ ແລະ (ຂ) ປ້ອງກັນໂດຍລະຫັດຜ່ານທີ່ເຂັ້ມແຂງ:</p> {$a}';
$string['check_riskbackup_detailsok'] = 'ບໍ່ມີພາລະບົດບາດຢ່າງຊັດເຈນອະນຸຍາດໃຫ້ສໍາຮອງຂໍ້ມູນຂອງຂໍ້ມູນຜູ້ໃຊ້. ຢ່າງໃດກໍຕາມ, ໃຫ້ສັງເກດວ່າ ຜູ້ເບິ່ງແຍງທີ່ມີຄວາມສາມາດ "ເຮັດໄດ້" ຍັງມີແນວໂນ້ມທີ່ຈະສາມາດເຮັດສິ່ງນີ້ໄດ້.';
$string['check_riskbackup_editoverride'] = '<a href="{$a->url}">{$a->name} ໃນ {$a->contextname}</a>';
$string['check_riskbackup_editrole'] = '<a href="{$a->url}">{$a->name}</a>';
$string['check_riskbackup_name'] = 'ການສຳຮອງຂໍ້ມູນຂອງຂໍ້ມູນຜູ້ໃຊ້';
$string['check_riskbackup_ok'] = 'ບໍ່ມີພາລະບົດບາດຢ່າງຊັດເຈນອະນຸຍາດໃຫ້ສໍາຮອງຂໍ້ມູນຂອງຂໍ້ມູນຜູ້ໃຊ້';
$string['check_riskbackup_unassign'] = '<a href="{$a->url}">{$a->fullname} ({$a->email}) ໃນ {$a->contextname}</a>';
$string['check_riskbackup_warning'] = 'ພົບ {$a->rolecount} ບົດບາດ, {$a->overridecount} overrides ແລະຜູ້ໃຊ້ {$a->usercount} ທີ່ມີຄວາມສາມາດໃນການສໍາຮອງຂໍ້ມູນຜູ້ໃຊ້.';
$string['check_riskxss_details'] = '<p>RISK_XSS ສະແດງເຖິງຄວາມສາມາດອັນຕະລາຍທັງໝົດທີ່ມີພຽງແຕ່ຜູ້ໃຊ້ທີ່ເຊື່ອຖືໄດ້ເທົ່ານັ້ນສາມາດໃຊ້.</p>
<p>ກະລຸນາກວດສອບລາຍຊື່ຜູ້ໃຊ້ຕໍ່ໄປນີ້ ແລະ ໃຫ້ແນ່ໃຈວ່າ ທ່ານເຊື່ອໝັ້ນເຂົາເຈົ້າຢ່າງສົມບູນໃນເຊີບເວີນີ້:</p><p>{$a}</p>';
$string['check_riskxss_name'] = 'XSS ຜູ້ໃຊ້ທີ່ເຊື່ອຖືໄດ້';
$string['check_riskxss_warning'] = 'RISK_XSS - ພົບຜູ້ໃຊ້ {$a} ທີ່ຕ້ອງໄດ້ເຊື່ອຖື.';
$string['check_unsecuredataroot_details'] = '<p>ບັນຊີລາຍການຮາກຂໍ້ມູນ ຈະຕ້ອງບໍ່ສາມາດເຂົ້າເຖິງໄດ້ຜ່ານທາງເວັບ. ວິທີທີ່ດີທີ່ສຸດເພື່ອໃຫ້ແນ່ໃຈວ່າບັນຊີລາຍການບໍ່ສາມາດເຂົ້າເຖິງໄດ້ ແມ່ນການໃຊ້ບັນຊີລາຍການທີ່ຢູ່ນອກບັນຊີລາຍການເວັບສາທາລະນະ.</p>
<p>ຖ້າທ່ານຍ້າຍບັນຊີລາຍການ, ທ່ານຕ້ອງອັບເດດການຕັ້ງຄ່າ <code>$CFG->dataroot</code> ໃນ <code>config.php</code> ຕາມຄວາມເໝາະສົມ.</p>';
$string['check_unsecuredataroot_error'] = 'ບັນຊີລາຍການຮາກຂໍ້ມູນຂອງທ່ານ <code>{$a}</code> ຢູ່ໃນບ່ອນທີ່ບໍ່ຖືກຕ້ອງ ແລະ ຖືກເປີດເຜີຍກັບເວັບ!';
$string['check_unsecuredataroot_name'] = 'ຮາກຂໍ້ມູນບໍ່ປອດໄພ';
$string['check_unsecuredataroot_ok'] = 'ບັນຊີລາຍການຮາກຂໍ້ມູນ ຈະຕ້ອງບໍ່ສາມາດເຂົ້າເຖິງໄດ້ຜ່ານທາງເວັບ.';
$string['check_unsecuredataroot_warning'] = 'ບັນຊີລາຍການຮາກຂໍ້ມູນຂອງທ່ານ <code>{$a}</code> ຢູ່ໃນບ່ອນທີ່ບໍ່ຖືກຕ້ອງ ແລະອາດຈະຖືກເປີດເຜີຍກັບເວັບ.';
$string['check_vendordir_details'] = '<p>ບັນຊີລາຍການ <code>{$a->path}</code> ປະກອບດ້ວຍຫ້ອງສະໝຸດພາກສ່ວນທີສາມຕ່າງໆ ແລະ ຄວາມເພິ່ງພາອາໄສຂອງພວກມັນ, ໂດຍປົກກະຕິຕິດຕັ້ງໂດຍນັກຂຽນ PHP. ຫ້ອງສະໝຸດເຫຼົ່ານີ້ ອາດຈະຈໍາເປັນສໍາລັບການພັດທະນາ Moodle ທ້ອງຖິ່ນ, ເຊັ່ນ: ສໍາລັບການຕິດຕັ້ງກອບວຽກ PHPUnit. ພວກມັນບໍ່ຈໍາເປັນເພື່ອດໍາເນີນການເວັບໄຊທ໌ Moodle ໃນການຜະລິດ ແລະ ພວກເຂົາສາມາດບັນຈຸລະຫັດອັນຕະລາຍທີ່ອາດຈະເປີດເຜີຍເວັບໄຊທ໌ຂອງທ່ານຕໍ່ກັບການໂຈມຕີທາງໄກ.</p><p>ຂໍແນະນຳຢ່າງຍິ່ງໃຫ້ລຶບບັນຊີລາຍການອອກ ຖ້າເວັບໄຊທ໌ດັ່ງກ່າວມີຢູ່ຜ່ານ URL ສາທາລະນະ, ຫຼື ຢ່າງໜ້ອຍກໍ່ຫ້າມບໍ່ໃຫ້ເຂົ້າເຖິງມັນຢູ່ໃນການຕັ້ງຄ່າເວັບເຊີບເວີຂອງທ່ານ.</p>';
$string['check_vendordir_info'] = 'ລາຍຊື່ຜູ້ຂາຍບໍ່ຄວນມີຢູ່ໃນສະຖານທີ່ສາທາລະນະ.';
$string['check_vendordir_name'] = 'ລາຍຊື່ຜູ້ຂາຍ';
$string['check_webcron_details'] = '<p>ການແລ່ນ cron ຈາກຕົວທ່ອງເວັບສາມາດເປີດເຜີຍຂໍ້ມູນສິດທິພິເສດໃຫ້ກັບຜູ້ໃຊ້ທີ່ບໍ່ເປີດເຜີຍຊື່. ແນະນຳໃຫ້ແລ່ນ cron ຈາກແຖວຄຳສັ່ງ ຫຼື ຕັ້ງລະຫັດຜ່ານ cron ສຳລັບການເຂົ້າເຖິງທາງໄກເທົ່ານັ້ນ.</p>';
$string['check_webcron_name'] = 'ເວັບ cron';
$string['check_webcron_ok'] = 'ຜູ້ໃຊ້ທີ່ບໍ່ເປີດເຜີຍຊື່ບໍ່ສາມາດເຂົ້າເຖິງ cron.';
$string['check_webcron_warning'] = 'ຜູ້ໃຊ້ທີ່ບໍ່ເປີດເຜີຍຊື່ສາມາດເຂົ້າເຖິງ cron.';
$string['configuration'] = 'ການກຳນົດຄ່າ';
$string['description'] = 'ຄຳອະທິບາຍ';
$string['details'] = 'ລາຍລະອຽດ';
$string['eventreportviewed'] = 'ເບິ່ງລາຍງານກວດສອບຄວາມປອດໄພແລ້ວ';
$string['issue'] = 'ບັນຫາ';
$string['pluginname'] = 'ກວດສອບຄວາມປອດໄພ';
$string['privacy:metadata'] = 'ປລັກອິນພາບລວມຄວາມປອດໄພບໍ່ໄດ້ເກັບຮັກສາຂໍ້ມູນສ່ວນຕົວໃດໆ.';
$string['security:view'] = 'ເບິ່ງລາຍງານຄວາມປອດໄພ';
$string['timewarning'] = 'ການປະມວນຜົນຂໍ້ມູນອາດໃຊ້ເວລາດົນ, ກະລຸນາອົດທົນ...';
