<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'filter_multilang2', language 'sr_lt', version '4.3'.
 *
 * @package     filter_multilang2
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['filtername'] = 'Višejezički sadržaj (v2)';
$string['parentlangalwaysen'] = 'Uvek koristite nadređene jezike, uključujući \'en\'.';
$string['parentlangbehaviour'] = 'Ponašanje nadređenih jezika';
$string['parentlangbehaviour_desc'] = '<p>
 Filter određuje da li treba prikazati jezički tag (oznaku)
 na osnovu jezika navedenih u samom tagu i trenutnog
 jezika koji korisnik upotrebljava. Ovaj postupak poklapanja
 može da prati tri različita pristupa, koji su poznati kao      <em>ponašanje nadređenih jezika </em>":
</p>
<ol>
  <li>
<b>Uvek koristite nadređene jezike, isključujući \'en\'.</b>
    <ul>
      <li>
        Ovo je podrazumevano podešavanje. Filter uzima u obzir
        jezike navedene u okviru jezičkog taga <code>{mlang
        ...}</code>, i sve njihove nadređene jezičke pakete (sve do,
        ali ne i sam engleski <code>en</code> jezički paket).
      </li>
        <li>
        Primer: Ako je kao jezička oznaka naveden <code>{mlang
        en_us_k12}</code>, tekst će biti prikazan samo ako je
        korisnik kao tekući jezik izabrao <code>en_us_k12</code>
        ili <code>en_us</code> ali ne i <code>en</code>.
      </li>
        <li>
        Napomena: engleski se i dalje može koristiti ukoliko je
        eksplicitno navedeno. Na primer, <code>{mlang en} Ovaj
        tekst će biti prikazan ako korisnik trenutno koristi
        \'en\'.{mlang}</code>, biće prikazan samo ako polaznik trenutno
        koristi engleski jezički paket.
      </li>
    </ul>
  </li>
  <li>
    <b>Uvek koristi nadređene jezike, uključujući \'en\'.</b>
    <ul>
      <li>
        Ovo podešavanje funkcioniše kao i prethodno, ali uključuje
        <code>en</code> jezički paket kao nadređeni.
      </li>
      <li>
        Primer: Ako je kao jezička oznaka naveden <code>{mlang
        en_us_k12}</code>, tekst će biti prikazan samo ako je korisnik kao
        tekući jezik izabrao bilo <code>en_us_k12</code>,
        <code>en_us</code> ili <code>en</code>.
      </li>
    </ul>
  </li>
  <li>
    <b>Nikada ne koristite nadređene jezike.</b>
    <ul>
      <li>
        Kao što naziv govori, nadređeni jezici se ne koriste
        Filter će omogućiti prikaz samo onih jezika koji su
        eksplicitno navedni u jezičkoj oznaci, ne uzimajući u obzir
        nadređene jezike.
      </li>
      <li>
        Primer : Ako je kao jezička oznaka naveden <code>{mlang
        en_us_k12}</code>, tekst će biti prikazan samo ako je
        korisnik kao tekući jezik izabrao <code>en_us_k12</code>
        ali ne i <code>en_us</code> ili <code>en</code>.
      </li>
    </ul>
  </li>
</ol>';
$string['parentlangdefault'] = 'Uvek koristite nadređene jezike, isključujući \'en\' (uobičajeno ponašanje).';
$string['parentlangnever'] = 'Nikada ne koristite nadređene jezike.';
$string['pluginname'] = 'Filter za višejezički sadržaj (v2)';
$string['privacy:metadata'] = 'Dodatak Filter za višejezički sadržaj (v2) ne čuva nikakve lične podatke.';
