<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'es_mx', version '4.3'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.block_myoverview.browseallcourses'] = 'Mirar todos los cursos';
$string['addon.block_myoverview.nocoursesenrolled'] = 'Usted aun no está inscrito en ningún curso.';
$string['addon.block_myoverview.nocoursesenrolleddescription'] = 'Mirar todos los cursos disponibles y comenzar a aprender.';
$string['addon.block_myoverview.noresult'] = 'Su búsqueda no coincidió con ningún curso.';
$string['addon.block_myoverview.noresultdescription'] = 'Intente ajustar sus filtros o mire todos los cursos debajo.';
$string['addon.blog.errorloadentries'] = 'Error al cargar entradas de bitácoras.';
$string['addon.blog.showonlyyourentries'] = 'Mostrar solamente entradas propias';
$string['addon.calendar.calendarevent'] = 'Evento del calendario';
$string['addon.calendar.calendarevents'] = 'Eventos del calendario';
$string['addon.calendar.calendarreminders'] = 'Recordatorios de calendario';
$string['addon.calendar.currentmonth'] = 'Mes Actual';
$string['addon.calendar.defaultnotificationtime'] = 'Hora de notificación por defecto';
$string['addon.calendar.errorloadevent'] = 'Error al cargar evento.';
$string['addon.calendar.errorloadevents'] = 'Error al cargar eventos.';
$string['addon.calendar.monthlyview'] = 'Vista mensual';
$string['addon.calendar.noevents'] = 'No hay eventos';
$string['addon.calendar.reminders'] = 'Recordatorios';
$string['addon.calendar.setnewreminder'] = 'Configurar un nuevo recordatorio';
$string['addon.calendar.timebefore'] = '{{value}} {{units}} antes de';
$string['addon.competency.errornocompetenciesfound'] = 'No se encontraron competencias';
$string['addon.competency.nocompetencies'] = 'Sin competencias';
$string['addon.coursecompletion.complete'] = 'Completo';
$string['addon.coursecompletion.couldnotloadreport'] = 'No pudo cargarse el reporte de finalización del curso. Por favor inténtelo nuevamente más tarde.';
$string['addon.enrol_self.confirmselfenrol'] = '¿Está seguro de querer inscribirse usted mismo en este curso?';
$string['addon.enrol_self.errorselfenrol'] = 'Ocurrió un error al auto inscribirse.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Configurar dispositivos';
$string['addon.messageoutput_airnotifier.pushdisabledwarning'] = 'Sus usuarios no están recibiendo ninguna notificación de este sitio en sus dispositivos móviles. Habilite notificaciones mobile en la página de Ajustes de notificación.';
$string['addon.messages.contactlistempty'] = 'La lista de contactos está vacía';
$string['addon.messages.contactname'] = 'Nombre del contacto';
$string['addon.messages.deletemessage'] = 'Eliminar mensaje';
$string['addon.messages.deletemessageconfirmation'] = '¿Está seguro de querer eliminar este mensaje? Será eliminado solamente de su historial de mensajes y todavía será visible por el usuario que envió o recibió el mensaje.';
$string['addon.messages.errordeletemessage'] = 'Error al eliminar el mensaje';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Error al recuperar los contactos del servidor.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Error al recuperar las discusiones del servidor.';
$string['addon.messages.errorwhileretrievingmessages'] = 'Error al recuperar mensajes del servidor.';
$string['addon.messages.errorwhileretrievingusers'] = 'Error al recuperar usuarios del servidor.';
$string['addon.messages.messagenotsent'] = 'El mensaje no fue enviado. Por favor inténtelo nuevamente después.';
$string['addon.messages.newmessages'] = 'Nuevos mensajes';
$string['addon.messages.nousersfound'] = 'No se encontraron usuarios';
$string['addon.messages.showdeletemessages'] = 'Mostrar eliminar mensajes';
$string['addon.messages.type_blocked'] = 'Bloqueado';
$string['addon.messages.type_offline'] = 'Fuera-de-línea';
$string['addon.messages.type_online'] = 'En-línea';
$string['addon.messages.type_search'] = 'Resultados de la búsqueda';
$string['addon.messages.type_strangers'] = 'Otros';
$string['addon.messages.useentertosenddescdesktop'] = 'Si se deshabilita, Usted puede usar Ctrl + Enter para enviar el mensaje.';
$string['addon.messages.useentertosenddescmac'] = 'Si se deshabilita, Usted puede usar Cmd + Enter para enviar el mensaje.';
$string['addon.messages.warningconversationmessagenotsent'] = 'No se pudo enviar mensaje(s) a conversación {{conversation}}. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'No se pudo enviar mensaje(s) al usuario {{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Por favor acepte la declaratoria de envío.';
$string['addon.mod_assign.allowsubmissionsanddescriptionfromdatesummary'] = 'El formato de envío y detalles de la Tarea estará disponible desde <strong>{{$a}}</strong>';
$string['addon.mod_assign.allowsubmissionsfromdatesummary'] = 'esta Tarea aceptará envíos desde <strong>{{$a}}</strong>';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Usted no puede añadir o editar un envío en la App porque no pudimos recuperar la declaratoria de envío del sitio.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Algunos métodos para calificar aun no están soportados por la App y no pueden ser modificados.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Usted no puede hacer un envío en la App porque no pudimos recuperar la declaratoria de envío del sitio.';
$string['addon.mod_assign.duedateno'] = 'Sin fecha límite';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Usted no puede añadir o editar un envío en la App porque algunos plugins aun no están soportados para editar.';
$string['addon.mod_assign.errorshowinginformation'] = 'No se puede mostrar la información del envío.';
$string['addon.mod_assign.feedbacknotsupported'] = 'La retroalimentación no está soportada por la App y es posible que no contenga toda la información.';
$string['addon.mod_assign.gradenotsynced'] = 'Calificación no sincronizada';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Los participantes que no hayan hecho un envío no son mostrados.';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = 'Hay {{count}} borradores.';
$string['addon.mod_assign.numberofparticipantscountdescription'] = 'Hay {{count}} participantes.';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = 'Hay {{count}} envíos que necesitan ser calificados.';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = 'Hay {{count}} tareas enviadas.';
$string['addon.mod_assign.numberofteamscountdescription'] = 'Hay {{count}} equipos.';
$string['addon.mod_assign.submissionnotsupported'] = 'Este envío no es soportado por la App y es posible que no contenga toda la información';
$string['addon.mod_assign.syncblockedusercomponent'] = 'calificación del usuario';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'La calificación por el envío fue modificada en el sitio.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'El envío del usuario fue modificado en el sitio.';
$string['addon.mod_chat.confirmloss'] = '¿Está seguro? La historia del chat podría perderse.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Error al conectarse al chat.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Error al obtener datos del chat.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Error al obtener usuarios del chat.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Error al recuperar mensajes del servidor.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Error al enviar el mensaje.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Usted debe de estar en-línea para enviar mensajes.';
$string['addon.mod_chat.nosessionsfound'] = 'No se encontraron sesiones';
$string['addon.mod_chat.showincompletesessions'] = 'Mostrar sesiones incompletas';
$string['addon.mod_choice.errorgetchoice'] = 'Error al obtener datos de elección.';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% de los usuarios eligió la opción: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'Su última respuesta debe ser sincronizada antes de que sea incluida en los resultados.';
$string['addon.mod_data.edittagsnotsupported'] = 'Lo sentimos, las marcas de edición no están soportadas por el App.';
$string['addon.mod_data.errorapproving'] = 'Error al aprobar o des_aprobar entrada.';
$string['addon.mod_data.errordeleting'] = 'Error al eliminar entrada.';
$string['addon.mod_data.gettinglocation'] = 'Obteniendo ubicación';
$string['addon.mod_data.locationnotenabled'] = 'Ubicación no está habilitada';
$string['addon.mod_data.locationpermissiondenied'] = 'Se ha negado el permiso para acceder a su ubicación';
$string['addon.mod_data.mylocation'] = 'Mi ubicación';
$string['addon.mod_data.searchbytagsnotsupported'] = 'Lo sentimos, el buscar por marcas no está soportado por la App.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'La retroalimentación con CAPTCHA no puede ser completada fuera de línea, o cuando no está configurada, ni con el servidor caído.';
$string['addon.mod_feedback.completedfeedbackscountdescription'] = 'Hay {{count}} respuestas enviadas.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Esta retroalimentación ha sido guardada para enviarse más tarde.';
$string['addon.mod_feedback.questionscountdescription'] = 'Hay {{count}} preguntas.';
$string['addon.mod_folder.emptyfilelist'] = 'No hay archivos para mostrar.';
$string['addon.mod_forum.errorgetforum'] = 'Error al obtener datos del foro.';
$string['addon.mod_forum.errorgetgroups'] = 'Error al obtener configuraciones del grupo.';
$string['addon.mod_forum.errorloadingsortingorder'] = 'Foro no disponible en este orden de ordenamiento';
$string['addon.mod_forum.errorloadingsortingorderdetails'] = 'Intente cambiar el orden de ordenamiento o ir en línea para ver este foro.';
$string['addon.mod_forum.errorposttoallgroups'] = 'No se pudo crear nueva discusión en todos los grupos.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'Todavía no hay discusiones en este foro.';
$string['addon.mod_forum.group'] = 'Grupo';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} discusiones';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} respuestas';
$string['addon.mod_forum.postingroup'] = 'Publicando en grupo "{{groupname}}".';
$string['addon.mod_forum.refreshposts'] = 'Refrescar publicaciones';
$string['addon.mod_glossary.browsemode'] = 'Mirar entradas';
$string['addon.mod_glossary.byalphabet'] = 'Alfabéticamente';
$string['addon.mod_glossary.byauthor'] = 'Agrupar por autor';
$string['addon.mod_glossary.bycategory'] = 'Agrupar por categoría';
$string['addon.mod_glossary.bynewestfirst'] = 'El más nuevo primero';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Recientemente actualizado';
$string['addon.mod_glossary.bysearch'] = 'Buscar';
$string['addon.mod_glossary.cannoteditentry'] = 'No puede editarse entrada';
$string['addon.mod_glossary.entriestobesynced'] = 'Entradas pendientes de ser sincronizadas';
$string['addon.mod_glossary.entrypendingapproval'] = 'Esta entrada está pendiente de aprobación.';
$string['addon.mod_glossary.errordeleting'] = 'Error al eliminar entrada.';
$string['addon.mod_glossary.errorloadingentries'] = 'Ocurrió un error al cargar entradas.';
$string['addon.mod_glossary.errorloadingentry'] = 'Ocurrió un error al cargar la entrada.';
$string['addon.mod_glossary.errorloadingglossary'] = 'Ocurrió un error al cargar el glosario.';
$string['addon.mod_glossary.noentriesfound'] = 'No se encontraron entradas.';
$string['addon.mod_glossary.searchquery'] = 'Consulta de búsqueda';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'Descargar archivo H5P';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'Error al obtener datos de actividad H5P';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'El paquete H5P no está descargado. Usted necesita descargarlo para poder usarlo.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'El paquete H5P ha sido modificado desde la última descarga. Usted necesita descargarlo nuevamente para poder usarlo.';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'Usted necesita estar en línea para ver el paquete H5P.';
$string['addon.mod_h5pactivity.viewattempt'] = 'Ver intento {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = 'Mostrar descripción';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Esta lección contiene un salto hacia una página aleatoria de contenido. No puede ser intentada en la App hasta que haya sido comenzada en un navegador web.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Este intento ya no puede ser revisado más porque se ha terminado otro intento.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Este intento fue terminado fuera-de-línea.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Un intento fuera de línea fue sincronizado.¿Quiere revisarlo?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'Este intento fue terminado en el sitio.';
$string['addon.mod_lti.errorgetlti'] = 'Error al obtener datos del módulo';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'La URL a lanzar no es válida.';
$string['addon.mod_lti.launchactivity'] = 'Lanzar la actividad';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Error al cargar el contenido de la página.';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'Usted puede intentar este examen en la App, pero Usted necesita enviar el intento en un navegador de internet por las razones siguientes :';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Este intento de examen no puede enviarse por las siguientes razones:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'ESte intento no se ha sincronizado desde {{$a}}. Si Usted ha continuado este intento en otro dispositivo después de esta hora, Usted podría perder datos.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Ocurrió un error al guardar las respuestas. ¿Está seguro de querer abandonar el examen?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Este examen no puede intentarse en la App porque el comportamiento de pregunta no está soportado por la App:';
$string['addon.mod_quiz.errordownloading'] = 'Error al descargar datos necesarios.';
$string['addon.mod_quiz.errorgetattempt'] = 'Error al obtener datos del intento.';
$string['addon.mod_quiz.errorgetquestions'] = 'Error al obtener preguntas';
$string['addon.mod_quiz.errorgetquiz'] = 'Error al obtener datos del examen';
$string['addon.mod_quiz.errorparsequestions'] = 'Ocurrió un error al leer las preguntas. Por favor intente este examen en un navegador web.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Este examen no puede intentarse en la App porque solamente contiene preguntas no soportadas por la App:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Este examen no puede intentarse en la App porque tiene reglas de acceso no soportadas por la App:';
$string['addon.mod_quiz.errorsaveattempt'] = 'Ocurrió un error al guardar los datos del intento.';
$string['addon.mod_quiz.finishedofflinenotice'] = 'Su intento ha sido recibido y guardado. Será enviado al sitio cuando usted vuelva a estar en línea.';
$string['addon.mod_quiz.finishnotsynced'] = 'Terminado pero no sincronizado';
$string['addon.mod_quiz.opentoc'] = 'Abrir ventanilla de navegación.';
$string['addon.mod_quiz.warningattemptfinished'] = 'El intento fuera de línea fue descartado porque fue terminado en el sitio o no fue encontrado.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Algunas respuestas fuera de línea fueron descartas porque las preguntas fueron modificadas en línea.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'El intento no fue terminado porque algunas respuestas fuera de línea fueron descartadas. Por favor, revise sus respuestas y entonces envíe el intento nuevamente.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'Este examen contiene preguntas no soportadas por la App:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Error al cargar el contenido.';
$string['addon.mod_resource.openthefile'] = 'Abrir';
$string['addon.mod_resource.resourcestatusoutdated'] = 'Este archivo ha cambiado desde la última vez que usted lo abrió.';
$string['addon.mod_resource.resourcestatusoutdatedconfirm'] = 'Hay una versión más nueva de este archivo. Para verla, por favor conecte su dispositivo al internet.';
$string['addon.mod_scorm.cannotcalculategrade'] = 'No pudo calcularse la calificación.';
$string['addon.mod_scorm.dataattemptshown'] = 'Estos datos pertenecen al intento número {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Ocurrió un error al crear un nuevo intento fuera de línea. Por favor, inténtelo nuevamente.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Error al descargar SCORM: "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'Error al obtener datos del SCORM';
$string['addon.mod_scorm.errorinvalidversion'] = 'Lo sentimos, la aplicación solamente soporta SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'Su escuela o proveedor de aprendizaje ha deshabilitado la descarga de paquetes SCORM..';
$string['addon.mod_scorm.errornovalidsco'] = 'Este paquete SCORM no tiene un SCO visible para cargar.';
$string['addon.mod_scorm.errorpackagefile'] = 'Lo sentimos, la aplicación solamente soporta paquetes ZIP.';
$string['addon.mod_scorm.errorsyncscorm'] = 'Ocurrió un error al sincronizar. Por favor, inténtelo nuevamente.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Este intento tiene datos que no han sido sincronizados.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Este itento no puede enviarse porque Usted sobrepasó el número máximo de intentos.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Este paquete SCORM no está descargado. Será descargado automáticamente cuando Usted lo abra.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Este paquete SCORM ha sido modificado desde la última descarga. Será descargado automáticamente cuando Usted lo abra.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Algunos datos fuera-de-línea del intento {{number}} han sido descartados porque no pudo contarse como un nuevo intento.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Algunos intentos no pudieron ser sincronizados con el sitio debido a que el último intento en línea todavía no está terminado. Por favor, termine primeramente el intento en línea.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Lo sentimos, hubo un problema al enviar su encuesta. Por favor, inténtelo nuevamente.';
$string['addon.mod_survey.errorgetsurvey'] = 'Error al obtener datos de la encuesta.';
$string['addon.mod_survey.results'] = 'Resultados';
$string['addon.mod_url.accessurl'] = 'Acceder a la URL';
$string['addon.mod_url.pointingtourl'] = 'URL a donde apunta este recurso.';
$string['addon.mod_wiki.errorloadingpage'] = 'Ocurrió un error al cargar la página.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Este wiki todavía no tiene ningún contenido.';
$string['addon.mod_wiki.gowikihome'] = 'Ir a la primera página del wiki';
$string['addon.mod_wiki.subwiki'] = 'Sub-wiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'El título no debería estar vacío';
$string['addon.mod_wiki.viewpage'] = 'Ver página';
$string['addon.mod_wiki.wikipage'] = 'Página de wiki';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Estrategia de evaluación {{$a}} no soportada';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Usted necesita ingresar un título.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'El envío fue modificado en el sitio.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'La evaluación fue modificada en el sitio.';
$string['addon.notes.warningnotenotsent'] = 'No se pudo añadir ni eliminar anotación(es) al curso. {{error}}';
$string['addon.notifications.allownotifications'] = 'Permitir notificaciones';
$string['addon.notifications.errorgetnotifications'] = 'Error al obtener notificaciones.';
$string['addon.notifications.notifications'] = 'Notificaciones';
$string['addon.notifications.playsound'] = 'Reproducir sonido';
$string['addon.notifications.therearentnotificationsyet'] = 'No hay notificaciones.';
$string['addon.notifications.typeofnotification'] = 'Tipo de notificación';
$string['addon.privatefiles.couldnotloadfiles'] = 'La lista de archivos no pudo cargarse.';
$string['addon.privatefiles.emptyfilelist'] = 'No hay archivos para mostrar.';
$string['addon.privatefiles.erroruploadnotworking'] = 'Desafortunadamente, actualmente no es posible subir archivos a su sitio.';
$string['addon.storagemanager.confirmdeleteallsitedata'] = '¿Eliminar todos los datos descargados?';
$string['addon.storagemanager.confirmdeletecourses'] = '¿Eliminar los datos descargados de todos los cursos?';
$string['addon.storagemanager.confirmdeletedatafrom'] = '¿Eliminar los datos descargados de \'{{name}}\'?';
$string['addon.storagemanager.coursedownloads'] = 'Descargas del curso';
$string['addon.storagemanager.courseinfo'] = 'Descargar contenido del curso para trabajar fuera de línea. Su actividad se sincronizará automáticamente cuando su dispositivo vuelva a estar en línea.';
$string['addon.storagemanager.deleteallsitedata'] = 'Eliminar todos los datos descargados del sitio';
$string['addon.storagemanager.deleteallsitedatainfo'] = 'Esto eliminará todos los datos descargados de \'{{name}}\', incluyendo todos los cursos descargados y los datos que le permiten a usted trabajar fuera de línea.';
$string['addon.storagemanager.deletecourses'] = 'Eliminar datos descargados de todos los cursos';
$string['addon.storagemanager.deletedata'] = 'Eliminar datos descargados';
$string['addon.storagemanager.deletedatafrom'] = 'Eliminar todos los datos descargados de {{name}}';
$string['addon.storagemanager.downloaddatafrom'] = 'Descargar {{name}}';
$string['addon.storagemanager.downloadedcourses'] = 'Cursos descargados';
$string['addon.storagemanager.downloads'] = 'Descargas';
$string['addon.storagemanager.errordeletedownloadeddata'] = 'Error al eliminar datos descargados.';
$string['addon.storagemanager.managedownloads'] = 'Gestionar descargas';
$string['addon.storagemanager.totaldownloads'] = 'Total de descargas';
$string['addon.storagemanager.totalspaceusage'] = 'Total de espacio usado';
$string['appstoredescription'] = 'NOTA: Esta App official Moodle Mobile SOLAMENTE funcionará con sitios Moodle que hayan sido configurados para permitirlo. Por favor hable con su administrador de Moodle si Usted tuviera problemas para conectarse.

Si su sitio Moodle ha sido configurado crrectamente, Usted puede usar esta App para:

- mirar el contenido de sus cursos, aun estando fuera-de-línea
- recibir notificación instantánea de mensajes y otros eventos
- encontrar rápidamente y contactar a otras personas en sus cursos
- subir imágenes, audio, videos y otros archivos desde su dispositivo móvil
- ver las calificaciones de su curso
- ¡y más!

Por favor vea http://docs.moodle.org/en/Mobile_app para la más reciente información.

¡Nosotros realmente apreciaríamos una buena revisión acerca de la funcionalidad hasta el momento, y sus sugerencias sobre qué más quiere Usted que haga esta App!

La App requiere los siguientes permisos:
Grabar audio - Para grabar el audio para subirlo a Moodle
Leer y modificar los contenidos de su tarjeta SD - Los contenidos son descargados a la tarjeta SD para que Usted pueda verlos fuera-de-línea
Acceso a la red - Para poder conectarse con su sitio Moodle y revisar si Usted está conectado o no para cambiar al modo fuera-de-línea
Correr al inicio - Para que Usted reciba notificaciones locales aun y cuando la App esté corriendo en segundo plano
Impedirle al teléfono que se duerma - Para que Usted pueda recibir notificaciones push en cualquier momento';
$string['assets.mimetypes.application/vnd.apple.keynote'] = 'Presentación Apple Keynote';
$string['assets.mimetypes.application/vnd.apple.numbers'] = 'Hoja de cálculo Apple Numbers';
$string['assets.mimetypes.application/vnd.apple.pages'] = 'Documento Apple Pages';
$string['assets.mimetypes.application/vnd.google-apps.audio'] = 'Audio de Google Drive';
$string['assets.mimetypes.application/vnd.google-apps.document'] = 'Google Docs';
$string['assets.mimetypes.application/vnd.google-apps.drawing'] = 'Google Drawing';
$string['assets.mimetypes.application/vnd.google-apps.file'] = 'Archivo de Google Drive';
$string['assets.mimetypes.application/vnd.google-apps.folder'] = 'Carpeta de Google Drive';
$string['assets.mimetypes.application/vnd.google-apps.form'] = 'Google Forms';
$string['assets.mimetypes.application/vnd.google-apps.fusiontable'] = 'Tablas de Google Fusion';
$string['assets.mimetypes.application/vnd.google-apps.presentation'] = 'Google Slides';
$string['assets.mimetypes.application/vnd.google-apps.script'] = 'Google Apps Scripts';
$string['assets.mimetypes.application/vnd.google-apps.site'] = 'Sitios Google';
$string['assets.mimetypes.application/vnd.google-apps.spreadsheet'] = 'Google Sheets';
$string['assets.mimetypes.application/vnd.google-apps.video'] = 'Video de Google Drive';
$string['core.ajaxendpointnotfound'] = '<p>AJAX endpoint no encontrado. Esto puede pasar si el sitio Moodle es muy antiguo o si bloquea el acceso a este endpoint. La App Moodle solamente soporta sistemas Moodle de {{$a}} en adelante.';
$string['core.browser'] = 'Navegador';
$string['core.calculating'] = 'Calculando';
$string['core.cannotconnect'] = 'No se puede conectar al sitio';
$string['core.cannotdownloadfiles'] = 'Su escuela o proveedor de aprendizaje ha deshabilitado la descarga de archivos.';
$string['core.cannotinstallapk'] = 'No se pueden instalar archivos .apk';
$string['core.cannotinstallapkinfo'] = 'Por razones de seguridad, usted no puede instalar apps desconocidas en su dispositivo desde esta App. Si usted todavía quiere proceder con la instalación, necesitará abrirla en un navegador.';
$string['core.cannotlogoutpageblocks'] = 'Por favor guarde o descarte sus cambios antes de continuar';
$string['core.cannotopeninapp'] = 'Este archivo podría no funcionar como se espera en este dispositivo. ¿De cualquier modo quiere abrirlo?';
$string['core.cannotopeninappdownload'] = 'Este archivo podría no funcionar como se espera en este dispositivo. ¿De cualquier modo quiere descargarlo?';
$string['core.captureaudio'] = 'Grabar audio';
$string['core.capturedimage'] = 'Foto tomada.';
$string['core.captureimage'] = 'Tomar foto';
$string['core.capturevideo'] = 'Grabar video';
$string['core.certificaterror'] = '<p>El certificado de este sitio no puede ser considerado como confiable por su dispositivo: {{details}}';
$string['core.clearsearch'] = 'Limpiar búsqueda';
$string['core.clearstoreddata'] = 'Limpiar almacenamiento {{$a}}';
$string['core.clicktoseefull'] = 'Hacer clic para ver los contenidos completos.';
$string['core.comments.commentsnotworking'] = 'Los comentarios no pueden ser recuperados';
$string['core.comments.warningcommentsnotsent'] = 'No se pudo sincronizar comentarios. {{error}}';
$string['core.confirmcanceledit'] = '¿Está Usted seguro de que quiere abandonar esta página? Se perderán todos los cambios.';
$string['core.confirmleaveunknownchanges'] = '¿Está seguro de querer abandonar esta página? Si tiene algunos cambios no guardados, se perderán.';
$string['core.confirmloss'] = '¿Está seguro? Se perderán todos los cambios.';
$string['core.confirmopeninbrowser'] = '¿Desea abrirla en un navegador web?';
$string['core.confirmremoveselectedfile'] = 'Esto eliminará permanentemente \'{{filename}}\'. Usted no lo podrá deshacer.';
$string['core.confirmremoveselectedfiles'] = 'Esto eliminará permanentemente los archivos seleccionados. Usted no lo podrá deshacer.';
$string['core.connectionlost'] = 'Conexión ala sitio perdida';
$string['core.contactsupport'] = 'Ponerse en contacto con soporte';
$string['core.contactverb'] = 'Contacto';
$string['core.contenteditingsynced'] = 'El contenido que está editando ha sido sincronizado.';
$string['core.contentlinks.chooseaccount'] = 'Elegir cuenta';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Elegir una cuenta con la cual abrir el enlace.';
$string['core.contentlinks.confirmurlothersite'] = 'Este enlace pertenece a otro sitio. ¿Quiere abrirlo?';
$string['core.contentlinks.errornoactions'] = 'No pudo encontrase una acción a realizar con este enlace.';
$string['core.contentlinks.errornosites'] = 'No pudo encontrase ningún sitio para manejar éste enlace.';
$string['core.contentlinks.errorredirectothersite'] = 'La URL redirigida no puede apuntar a un sitio diferente.';
$string['core.copiedtoclipboard'] = 'Texto copiado al portapapeles';
$string['core.copytoclipboard'] = 'Copiar al portapapeles';
$string['core.course.activitydisabled'] = 'Su  organización ha deshabilitado esta actividad en la App mobile.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Su organización instaló un plugin que todavía no está soportado.';
$string['core.course.allsections'] = 'Todas las secciones';
$string['core.course.aria:sectionprogress'] = 'Progreso de sección:';
$string['core.course.availablespace'] = 'Usted tiene actualmente {{available}} de espacio libre.';
$string['core.course.cannotdeletewhiledownloading'] = 'Los archivos no pueden ser eliminados mientras la actividad está siendo descargada. Por favor espere a que termine la descarga.';
$string['core.course.confirmdownload'] = 'Usted está a punto de descargar {{size}}.{{availableSpace}} . ¿Está seguro de querer continuar?';
$string['core.course.confirmdownloadunknownsize'] = 'No pudimos calcular el tamaño de la descarga. {{availableSpace}} ¿Está seguro de querer continuar?';
$string['core.course.confirmdownloadzerosize'] = 'Usted está a punto de comenzar a descargar .{{availableSpace}} ¿Está seguro de querer continuar?';
$string['core.course.confirmlimiteddownload'] = 'Actualmente Usted no está conectado a Wi-Fi.';
$string['core.course.confirmpartialdownloadsize'] = 'Usted está a punto de descargar <strong>al menos</strong> {{size}}.{{availableSpace}} . ¿Está seguro de querer continuar?';
$string['core.course.couldnotloadsectioncontent'] = 'No pudo cargarse el contenido de la sección. Por favor inténtelo nuevamente después.';
$string['core.course.couldnotloadsections'] = 'No pudieron cargarse las secciones. Por favor inténtelo nuevamente después.';
$string['core.course.downloadcoursesprogressdescription'] = 'Descargando cursos: descargados {{count}} de un total de {{total}}.';
$string['core.course.downloadsectionprogressdescription'] = 'Descargando sección: descargadas {{count}} de un total de {{total}}.';
$string['core.course.errordownloadingcourse'] = 'Error al descargar curso.';
$string['core.course.errordownloadingsection'] = 'Error al descargar sección.';
$string['core.course.errorgetmodule'] = 'Error al obtener datos de la actividad.';
$string['core.course.insufficientavailablequota'] = 'Su dispositivo no pudo asignar espacio para guardar esta descarga. Podría estar reservando espacio para actualizaciones del sistema y de la App. Por favor primeramente libere espacio de almacenamiento.';
$string['core.course.insufficientavailablespace'] = 'Usted está tratando de descargar {{size}}. Esto dejará a su dispositivo con espacio insuficiente para operar normalmente. Por favor primeramente libere espacio de almacenamiento.';
$string['core.course.lastaccessedactivity'] = 'Última actividad accedida';
$string['core.course.manualcompletionnotsynced'] = 'Finalización manual no sincronizada.';
$string['core.course.modulenotfound'] = 'Recurso o actividad no encontrado; por favor asegúrese de que está en línea y que todavía está disponible.';
$string['core.course.nextactivity'] = 'Actividad siguiente';
$string['core.course.nextactivitynotfound'] = 'Actividad siguiente no encontrada. es posible que haya sido ocultada o eliminada.';
$string['core.course.nocontentavailable'] = 'Sin contenido disponible al momento.';
$string['core.course.previousactivity'] = 'Actividad anterior';
$string['core.course.previousactivitynotfound'] = 'Actividad anterior no encontrada. es posible que haya sido ocultada o eliminada.';
$string['core.course.refreshcourse'] = 'Refrescar curso';
$string['core.course.useactivityonbrowser'] = 'Usted todavía puede usarla si emplea el navegador web de su dispositivo.';
$string['core.course.warningmanualcompletionmodified'] = 'La finalización manual de una actividad fue modificada en el sitio.';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'Una parte de la finalización manual del curso \'{{name}}\' ha sido eliminada. {{error}}';
$string['core.coursenogroups'] = 'Usted no es un miembro de ningún grupo en  este curso.';
$string['core.courses.browserenrolinstructions'] = 'Lo llevaremos al navegador de su dispositivo. Una vez que haya completado su inscripción, por favor regrese a esta App.';
$string['core.courses.cannotretrievemorecategories'] = 'No se pueden recuperar categorías más profundas que el nivel {{$a}}.';
$string['core.courses.completeenrolmentbrowser'] = 'Complete inscripción en el navegador';
$string['core.courses.confirmselfenrol'] = '¿Está seguro de querer inscribirse Usted mismo en este curso?';
$string['core.courses.downloadcourses'] = 'Descargar todos los cursos';
$string['core.courses.enrolme'] = 'Inscribirme';
$string['core.courses.errorloadcategories'] = 'Ocurrió un error al cargar categorías.';
$string['core.courses.errorloadcourses'] = 'Ocurrió un error al cargar los cursos.';
$string['core.courses.errorloadplugins'] = 'Los plugins necesarios para este curso no se pudieron cargar correctamente. Por favor vuelva a cargar la App e inténtelo nuevamente.';
$string['core.courses.errorsearching'] = 'Ocurrio un error al buscar.';
$string['core.courses.errorselfenrol'] = 'Ocurrio un error al auto-inscribir.';
$string['core.courses.filtermycourses'] = 'Filtrar mis cursos';
$string['core.courses.notenrollable'] = 'Usted no puede inscribirse Usted mismo en este curso.';
$string['core.courses.otherenrolments'] = 'Otras inscripciones';
$string['core.courses.password'] = 'Clave de inscripción';
$string['core.courses.refreshcourses'] = 'Refrescar cursos';
$string['core.courses.searchcoursesadvice'] = 'Usted puede usar el botón de \'buscar cursos\' para encontrar cursos a los cuales acceder como un invitado o para inscribirse Usted mismo en los cursos que lo permitan.';
$string['core.courses.selfenrolment'] = 'Auto-inscripción';
$string['core.courses.showonlyenrolled'] = 'Mostrar solamente mis cursos';
$string['core.courses.totalcoursesearchresults'] = 'Total de cursos: {{$a}}';
$string['core.currentdevice'] = 'Dispositivo actual';
$string['core.datastoredoffline'] = 'Los datos se almacenaron en el dispositivo debido a que no se pudieron enviar. Serán enviados automáticamente más tarde.';
$string['core.deletedoffline'] = 'Eliminado fuera-de-línea';
$string['core.deleting'] = 'Eliminando';
$string['core.desktop'] = 'Escritorio';
$string['core.dfdaymonthyear'] = 'MM-DD-AAAA';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'dddd, D MMMM AAAA h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = 'Descartar';
$string['core.dismiss'] = 'Descartar';
$string['core.dontshowagain'] = 'No mostrar nuevamente.';
$string['core.downloaded'] = 'Descargado';
$string['core.downloading'] = 'Descargando';
$string['core.editor.hidetoolbar'] = 'Ocultar barra de herramientas';
$string['core.editor.toggle'] = 'Alternar editor';
$string['core.emptysplit'] = 'Esta página aparecerá en blanco si el panel izquierdo está vacío o si está cargando.';
$string['core.endingtime'] = 'Hora final: {{$a}}';
$string['core.errorchangecompletion'] = 'Ocurrió un error al cambiar el estatus de finalización. Por favor inténtelo nuevamente.';
$string['core.errorcode'] = 'Código de error: {{errorCode}}';
$string['core.errordeletefile'] = 'Error al eliminar el archivo. Por favor inténtelo nuevamente.';
$string['core.errordetailshide'] = 'Ocultar detalles del error';
$string['core.errordetailsshow'] = 'Mostrar detalles del error';
$string['core.errordownloading'] = 'Error al descargar archivo';
$string['core.errordownloadingsomefiles'] = 'Error al descargar archivos. Pueden faltar algunos archivos.';
$string['core.errorfileexistssamename'] = 'Ya existe un archivo con este nombre.';
$string['core.errorinvalidform'] = 'Por favor, asegúrese que todos los campos solicitados sean llenados y que los datos ingresados estén en el formato correcto.';
$string['core.errorinvalidresponse'] = 'Respuesta inesperada para servicio web  {{method}}.';
$string['core.errorloadingcontent'] = 'Error al cargar contenido.';
$string['core.errorofflinedisabled'] = 'La navegación fuera de línea está deshabilitada en su sitio. Usted necesita reconectarse a Internet para usar la App.';
$string['core.erroropenfiledownloading'] = 'Error al abrir archivo: usted necesita esperar a que se complete la descarga.';
$string['core.erroropenfilenoapp'] = 'Error al abrir el archivo. No se encontró App para abrir este tipo de archivo.';
$string['core.erroropenfilenoextension'] = 'Error al abrir el archivo: el archivo no tiene una extensión.';
$string['core.erroropenpopup'] = 'Esta actividad está tratando de abrir una ventana emergente. Esto no está soportado en la App.';
$string['core.errorrenamefile'] = 'Error al renombrar el archivo. Por favor inténtelo nuevamente.';
$string['core.errorsitesupport'] = 'Si el problema persiste, póngase en contacto con el soporte del sitio.';
$string['core.errorsomedatanotdownloaded'] = 'Si Usted descarga esta actividad, por favor tenga en cuenta que algunos datos no son descargados durante el proceso de descarga por razones de desempeño y uso de datos.';
$string['core.errorsomethingwrong'] = 'Algo salió mal. Por favor inténtelo de nuevo.';
$string['core.errorsync'] = 'Ocurrió un error al sincronizar. Por favor inténtelo nuevamente.';
$string['core.errorsyncblocked'] = 'Este/a {{$a}} no puede sincronizarse ahorita porque hay un proceso trabajando. Por favor inténtelo nuevamente más tarde. Si el problema persiste, intente reiniciar la App.';
$string['core.errorurlschemeinvalidscheme'] = 'Esta URL está diseñada para ser usada en otra App: {{$a}}.';
$string['core.errorurlschemeinvalidsite'] = 'La URL del sitio no puede ser abierta en esta App.';
$string['core.exactalarmsturnedoff'] = 'Las notificaciones en tiempo real están desactivadas.';
$string['core.exactalarmsturnedoffmessage'] = 'Para asegurarse que no se pierda de alertas importantes, active \'Alarmas y recordatorios\' en las configuraciones de su dispositivo.';
$string['core.filedeletedsuccessfully'] = 'Usted ha eliminado \'{{filename}}\' exitosamente';
$string['core.filenameexist'] = 'El nombre del archivo ya existe: {{$a}}';
$string['core.fileuploader.audio'] = 'Audio';
$string['core.fileuploader.camera'] = 'Cámara';
$string['core.fileuploader.confirmuploadfile'] = 'Usted está a punto de subir {{size}}. ¿Está seguro de querer continuar?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'No se pudo calcular el tamaño de la subida. ¿Está seguro de querer continuar?';
$string['core.fileuploader.discardrecording'] = 'Descartar grabación';
$string['core.fileuploader.errorcapturingaudio'] = 'Error al capturar audio.';
$string['core.fileuploader.errorcapturingimage'] = 'Error al capturar imagen.';
$string['core.fileuploader.errorcapturingvideo'] = 'Error al capturar video.';
$string['core.fileuploader.errorgettingimagealbum'] = 'Error al obtener imagen del album.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Usted tiene que estar en línea para subir archivos.';
$string['core.fileuploader.errornoapp'] = 'Usted no tiene una App instalada para realizar esta acción.';
$string['core.fileuploader.errorreadingfile'] = 'Error al leer archivo.';
$string['core.fileuploader.errorwhileuploading'] = 'Ocurrió un error durante la subida del archivo.';
$string['core.fileuploader.file'] = 'Archivo';
$string['core.fileuploader.fileuploaded'] = 'El archivo fue subido exitosamente.';
$string['core.fileuploader.maxbytesfile'] = 'El archivo {{$a.file}} es demasido grande. El tamaño máximo que Usted puede subir es {{$a.size}}.';
$string['core.fileuploader.microphonepermissiondenied'] = 'Ha sido negado el permiso para acceder al micrófono.';
$string['core.fileuploader.microphonepermissionrestricted'] = 'El acceso al micrófono está restringido.';
$string['core.fileuploader.pauserecording'] = 'Pausar grabación';
$string['core.fileuploader.photoalbums'] = 'Álbumes de fotos';
$string['core.fileuploader.readingfile'] = 'Leyendo archivo';
$string['core.fileuploader.readingfileperc'] = 'Leyendo archivo: {{$a}}%';
$string['core.fileuploader.resumerecording'] = 'Continuar grabación';
$string['core.fileuploader.selectafile'] = 'Seleccionar un archivo';
$string['core.fileuploader.startrecordinginstructions'] = 'Tocar para iniciar grabación';
$string['core.fileuploader.uploadafile'] = 'Subir un archivo';
$string['core.fileuploader.uploading'] = 'Subiendo';
$string['core.fileuploader.uploadingperc'] = 'Subiendo: {{$a}}%';
$string['core.fileuploader.video'] = 'Video';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.goto'] = 'Ir a {{$a}}';
$string['core.h5p.errorgetemail'] = 'Error al obtener el Email del usuario. Por favor revise su conexión e inténtelo nuevamente.';
$string['core.h5p.offlinedisabled'] = 'El sitio no permite descargar paquetes H5P.';
$string['core.h5p.play'] = 'Reproducir H5P';
$string['core.hasdatatosync'] = 'Este/a {{$a}} tiene datos fuera-de-línea para sincronizarse.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.iframehelp'] = '¿No está funcionando este contenido?';
$string['core.image'] = 'Imagen';
$string['core.imageviewer'] = 'Visor de imágenes';
$string['core.ioscookieshelp'] = 'El contenido incrustado podría necesitar cookies para funcionar. Por favor, vaya a las configuraciones de iOS de la App, habilite \'Permitir Monitoreo Cross-Website\' e inténtelo nuevamente.';
$string['core.lastdownloaded'] = 'Última descarga';
$string['core.lastsync'] = 'Última sincronización';
$string['core.loadmore'] = 'Cargar más';
$string['core.login.authenticating'] = 'Autenticando';
$string['core.login.changepasswordbutton'] = 'Cambiar contraseña';
$string['core.login.changepasswordhelp'] = 'Si Usted tiene problemas para cambiar su contraseña, por favor inténtelo nuevamente más tarde o póngase en contacto con su escuela o proveedor de aprendizaje.';
$string['core.login.changepasswordinstructions'] = 'Usted no puede cambiar su contraseña en la App. Por favor elija el botón siguiente para abrir el sitio en un navegador web para cambiar su contraseña. Considere que Usted necesita cerrar el navegador después de cambiar la contraseña, ya que Usted no será redirigido a la App.';
$string['core.login.changepasswordlogoutinstructions'] = 'Si prefiere cambiar de sitio o salirse, por favor elija el botón siguiente:';
$string['core.login.changepasswordreconnectinstructions'] = 'Si usted no cambió correctamente su contraseña, se le pedirá que lo vuelva a hacer.';
$string['core.login.changepasswordsupportsubject'] = 'Necesito ayuda para cambiar mi contraseña';
$string['core.login.confirmdeletesite'] = '¿Está seguro de querer eliminar la cuenta en {{sitename}}?';
$string['core.login.connect'] = '¡Conectar!';
$string['core.login.connecttomoodle'] = 'Conectar a Moodle';
$string['core.login.connecttomoodleapp'] = 'Usted está intentando conectarse a un sitio Moodle regular. Por favor descargue la App oficial Moodle para acceder a este sitio.';
$string['core.login.connecttoworkplaceapp'] = 'Usted está intentando conectarse a un sitio Moodle Workplace. Por favor descargue la App oficial Moodle Workplace para acceder a este sitio.';
$string['core.login.contactyouradministrator'] = 'Póngase en contacto con su administrador del sitio para más ayuda.';
$string['core.login.contactyouradministratorissue'] = 'Por favor, pídale al administrador que revise el siguiente problema: {{$a}}';
$string['core.login.credentialsdescription'] = 'Por favor proporcione su nombre_de_usuario y contraseña para ingresar.';
$string['core.login.credentialshelp'] = 'Si usted tiene problemas para ingresar, inténtelo nuevamente más tarde o póngase en contacto con su escuela o su proveedor de aprendizaje.';
$string['core.login.credentialssupportsubject'] = 'Necesito ayuda para ingresar';
$string['core.login.emailconfirmsentnoemail'] = '<p>Un Email debería de haberse enviado a su dirección.</p><p>Contiene instrucciones fáciles para completar su registro.</p>';
$string['core.login.emailnotmatch'] = 'No coinciden los Emails';
$string['core.login.erroraccesscontrolalloworigin'] = 'La llamada de Orígen Cruzado (\'\'Cross-Origin\'\') que Usted está tratando de realizar ha sido rechazada. Por favor revise https://moodledev.io/general/app/development/setup/app-in-browser';
$string['core.login.errordeletesite'] = 'Ocurrió un error al eliminar esta cuenta. Por favor inténtelo nuevamente.';
$string['core.login.errorexampleurl'] = 'La URL https://campus.example.edu es solamente un ejemplo de URL. No es un sitio real. <strong>Por favor, use la URL del sitio de su escuela o su organización.</strong>';
$string['core.login.errorqrnoscheme'] = 'Esta URL no es una URL válida para ingresar.';
$string['core.login.errorupdatesite'] = 'Ocurrió un error al actualizar la ficha (\'\'token\'\') del sitio';
$string['core.login.exceededloginattempts'] = '¿Necesita ayuda para ingresar? Intente {{recoverPassword}} opóngase en contacto con el soporte de su sitio.';
$string['core.login.exceededloginattemptsrecoverpassword'] = 'recuperar su contraseña';
$string['core.login.exceededloginattemptssupportsubject'] = 'No puedo ingresar';
$string['core.login.exceededloginattemptswithoutpassword'] = '¿Necesita ayuda para ingresar? Intente ponderse en contacto con el soporte de su sitio.';
$string['core.login.exceededloginattemptswithoutsupport'] = '¿Necesita ayuda para ingresar? Intente {{recoverPassword}}.';
$string['core.login.exceededpasswordresetattempts'] = 'Al parecer usted tiene problemas para acceder a su cuenta. Usted puede ponerse en contacto con su escuela o proveedor de aprendizaje o intentarlo nuevamente más tarde.';
$string['core.login.exceededpasswordresetattemptssupportsubject'] = 'No puedo reiniciar mi contraseña';
$string['core.login.faqcannotconnectanswer'] = 'Por favor, póngase en contacto con su administrador del sitio.';
$string['core.login.faqcannotconnectquestion'] = 'Yo escribí correctamente la dirección de mi sitio, pero aún no me puedo conectar.';
$string['core.login.faqcannotfindmysiteanswer'] = 'Si usted intentó buscar por dirección URL y aun no puede encontrar su sitio Moodle, por favor póngase en contacto con la persona que se encarga de Moodle en su escuela o su organización educativa';
$string['core.login.faqcannotfindmysitequestion'] = 'No puedo encontrar mi sitio por la dirección URL.';
$string['core.login.faqcantloginanswer'] = '<p>Una vez que se haya conectado a su sitio Moodle, usted debería poder ingresar con su nombre_de_usuario y contraseña usuales.</p><br><p>Si se le olvidó su nombre_de_usuario o contraseña, seleccione la opción <strong>¿Contraseña olvidado?</strong>. Si aun así tiene problemas para ingresar o no puede ver ninguna opción para recuperar su nombre_de_usuario o contraseña, por favor póngase en contacto con la persona que se encarga de Moodle en su escuela o institución educativa.</p>';
$string['core.login.faqcantloginquestion'] = 'No puedo ingresar al sitio.';
$string['core.login.faqmore'] = 'Vea <a href="https://docs.moodle.org/en/Moodle_app_FAQ#toc" target="_blank">nuestro FAQ</a> para más respuestas.';
$string['core.login.faqsetupsiteanswer'] = 'Visitar {{$link}} para revisar las diferentes opciones que tiene para crear su propio sitio Moodle.';
$string['core.login.faqsetupsitelinktitle'] = 'Comenzar.';
$string['core.login.faqsetupsitequestion'] = 'Deseo configurar mi propio sitio Moodle.';
$string['core.login.faqtestappanswer'] = 'Para probar la App en un sitio Moodle Demo, escriba "teacher" o "student" en el campo para <strong> "Su sitio"</strong> y elija el botón para <strong>"Conectar a su sitio"</strong> .';
$string['core.login.faqtestappquestion'] = '¿Puedo probar la App en un sitio demo?';
$string['core.login.faqwhatisurlanswer'] = '<p>Si usted no puede encontrar su sitio por nombre, intente buscarlo por dirección URL.</p><p>Para encontrar la dirección de su sitio:</p><ol><li> Abra un navegador web y vaya a la página para ingresar su sitio Moodle</li><li>En la parte superior de la página, en la barra de dirección, Usted verá la dirección URL de su sitio Moodle. Por ejemplo "campus.example.edu".<br>{{$image}}</li><li>Copie la URL (no copie la parte de  /login ni lo que sigue después), péguelo en la App Moodle y haga clic en  "Conectar a su sitio"</li><li>Ahora Usted puede ingresar a su sitio, usando su nombre_de_usuario y contraseña.</li></ol><p>Si usted intentó buscar por dirección URL y aun así no pudo encontrar su sitio Moodle, por favor póngase en contacto con la persona que se encarga de Moodle en su escuela o institución educativa.</p>';
$string['core.login.faqwhatisurlquestion'] = '¿Cómo puedo encontrar mi sitio?';
$string['core.login.faqwhereisqrcode'] = '¿Donde puedo encontrar el código QR?';
$string['core.login.faqwhereisqrcodeanswer'] = '<p>Si su escuela o proveedor de aprendizaje lo ha habilitado, Usted encontrará un código QR en el sitio web al fondo de su página del perfil del usuario.</p>{{$image}}';
$string['core.login.findyoursite'] = 'Encuentre su sitio';
$string['core.login.helpmelogin'] = '<p>Existen muchos miles de sitios Moodle en el mundo. Esta App solamente puede conectar a sitios Moodle que tengan específicamente habilitado el acceso  por la App Mobile.</p><p>Si Usted no puede conectarse a su sitio Moodle, entonces Usted necesita ponerse en contacto con su administrador del sitio y pedirle que lea <a href="http://docs.moodle.org/en/Mobile_app" target="_blank">http://docs.moodle.org/en/Mobile_app</a></p><p>Para probar la App en un sitio Moodle demostrativo, escriba <i>teacher</i> o <i>student</i> en el campo de la <i>Dirección del sitio</i> y haga click en el <b>Botón Conectar</b>.</p>';
$string['core.login.invalidaccount'] = 'Por favor, verifique sus datos de acceso e inténtelo de nuevo.';
$string['core.login.invalidmoodleversion'] = 'La versión inválida de este sitio Moodle es demasiado antigua. La App Moodle solamente funciona con sitios que usan {{$a}} o más nuevos.';
$string['core.login.invalidsite'] = 'La URL del sitio es inválida.';
$string['core.login.invalidtime'] = 'Hora inválida';
$string['core.login.invalidvaluemax'] = 'El valor máximo es {{$a}}';
$string['core.login.invalidvaluemin'] = 'El valor mínimo es {{$a}}';
$string['core.login.loggedoutssodescription'] = 'Usted tiene que autenticarse nuevamente. Usted necesita ingresar al sitio en una ventana del navegador.';
$string['core.login.loginbutton'] = 'Ingresar';
$string['core.login.logininsiterequired'] = 'Usted necesita ingresar al sitio en una ventana del navegador.';
$string['core.login.mobileservicesnotenabled'] = 'Servicios Mobile no están habilitados en el sitio.';
$string['core.login.notloggedin'] = 'Usted necesita estar ingresado.';
$string['core.login.onboardingcreatemanagecourses'] = 'Crear y gestionar sus cursos';
$string['core.login.onboardingenrolmanagestudents'] = 'Inscribir y gestionar a sus estudiantes';
$string['core.login.onboardinggetstarted'] = 'Empezar con Moodle';
$string['core.login.onboardingialreadyhaveasite'] = 'Yo ya tengo un sitio Moodle';
$string['core.login.onboardingimalearner'] = 'Soy un estudiante';
$string['core.login.onboardingimaneducator'] = 'Soy un educador';
$string['core.login.onboardingineedasite'] = 'Necesito un sitio Moodle';
$string['core.login.onboardingprovidefeedback'] = 'Proporcionar retroalimentación oportuna';
$string['core.login.onboardingtoconnect'] = 'Para conectarse a la App Moodle Usted necesitará un sitio Moodle';
$string['core.login.onboardingwelcome'] = '¡BienVenido a la App Moodle!';
$string['core.login.or'] = 'O';
$string['core.login.passwordrequired'] = 'Contraseña obligatoria';
$string['core.login.policyacceptmandatory'] = 'Yo comprendo y estoy de acuerdo con las políticas obligatorias del sitio';
$string['core.login.recaptchachallengeimage'] = 'Imagen del desafío reCAPTCHA';
$string['core.login.recaptchaexpired'] = 'Verificación expiró. Conteste nuevamente la pregunta de seguridad.';
$string['core.login.recaptchaincorrect'] = 'La respuesta a la pregunta de seguridad es incorrecta.';
$string['core.login.reconnect'] = 'Reconectar';
$string['core.login.reconnecthelp'] = 'Si usted tiene problemas para reconectarse, inténtelo nuevamente más tarde o póngase en contacto con su escuela o su proveedor de aprendizaje.';
$string['core.login.reconnectssodescription'] = 'Su sesión ha expirado. Por favor ingrese al sitio nuevamente en una ventana del navegador para continuar.';
$string['core.login.reconnectsupportsubject'] = 'Necesito ayuda para reconectarme';
$string['core.login.reconnecttosite'] = 'Reconectar al sitio';
$string['core.login.removeaccount'] = 'Eliminar cuenta';
$string['core.login.searchby'] = 'Buscar por:';
$string['core.login.selectsite'] = 'Por favor seleccione su cuenta:';
$string['core.login.signupplugindisabled'] = '{{$a}} no está habilitado/a.';
$string['core.login.signuprequiredfieldnotsupported'] = 'El formato para apuntarse contiene un campo personalizado necesario que no está soportado en la App. Por favor cree su cuenta usando un navegador web.';
$string['core.login.siteaddress'] = 'Su sitio';
$string['core.login.siteaddressplaceholder'] = 'https://campus.ejemplo.edu';
$string['core.login.sitebadgedescription'] = 'Hay {{count}} notificaciones sin leer.';
$string['core.login.sitehasredirect'] = 'Su sitio contiene al menos una redirección HTTP. La App no puede seguir redirecciones; esto podría ser el problema que está impidiéndole a la App que se conecte a su sitio.';
$string['core.login.siteinmaintenance'] = 'Su sitio está en modo de mantenimiento';
$string['core.login.sitenotallowed'] = 'Este sitio ya no está disponible.';
$string['core.login.sitepolicynotagreederror'] = 'No se aceptó la política del sitio.';
$string['core.login.siteurl'] = 'URL del sitio';
$string['core.login.siteurlrequired'] = 'La URL del sitio es obligatoria, por ejemplo <i>https://www.susitiomoodle.mx</i>';
$string['core.login.stillcantconnect'] = '¿Todavía no puede conectarse?';
$string['core.login.toggleremove'] = 'Editar lista de cuentas';
$string['core.login.unsupportedsite'] = 'Sitio no accesible mediante la App';
$string['core.login.unsupportedsitemessage'] = '{{site}} no puede ser accedido mediante esta app.<br><br>Usted todavía puede acceder a este sitio usando un navegador web.';
$string['core.login.usernamerequired'] = 'Nombre_de_usuario obligatorio';
$string['core.login.visitchangepassword'] = '¿Desea visitar el sitio para cambiar la contraseña?';
$string['core.login.webservicesnotenabled'] = 'Los servicios web no están habilitados en el sitio.';
$string['core.login.youcanstillconnectwithcredentials'] = 'Usted todavía puede conectarse al sitio al ingresar su nombre_de_usuario y contraseña';
$string['core.login.yourenteredsite'] = 'Conectarse a su sitio';
$string['core.lostconnection'] = 'Su sesión ha expirado. Por favor ingrese al sitio nuevamente para continuar.';
$string['core.mainmenu.switchaccount'] = 'Cambiar de cuenta';
$string['core.mainmenu.usermenutourdescription'] = 'El lugar para comprobar sus calificaciones, cambiar sus preferencias o cambiar de cuentas.';
$string['core.mainmenu.usermenutourtitle'] = 'Explore su área personal';
$string['core.needhelp'] = '¿Necesita ayuda?';
$string['core.networkerroriframemsg'] = 'El contenido no está disponible fuera de línea. Por favor conéctese a Internet e inténtelo de nuevo.';
$string['core.networkerrormsg'] = 'Hubo un problema para conectarse al sitio. Por favor revise su conexión e inténtelo nuevamente.';
$string['core.nooptionavailable'] = 'Sin opción disponible';
$string['core.nopasswordchangeforced'] = 'Usted no puede proceder sin cambiar su contraseña.';
$string['core.nopermissionerror'] = 'Lo sentimos, pero Usted actualmente no tiene permisos para hacer eso';
$string['core.notapplicable'] = 'no disp.';
$string['core.notdownloadable'] = 'No descargable';
$string['core.notnow'] = 'Ahora no';
$string['core.notsent'] = 'No enviado';
$string['core.nummore'] = '{{$a}} más';
$string['core.openfile'] = 'Abrir archivo';
$string['core.openfilewithextension'] = 'Abrir archivo {{extension}}';
$string['core.openfullimage'] = 'Hacer clic aquí para mostrar la imagen a tamaño completo';
$string['core.openinbrowser'] = 'Abrir en navegador';
$string['core.openinbrowserdescription'] = 'Usted será llevado a un navegador web';
$string['core.openmodinbrowser'] = 'Abrir {{$a}} en navegador';
$string['core.opensecurityquestion'] = 'Abrir pregunta de seguridad';
$string['core.opensettings'] = 'Abrir configuraciones';
$string['core.openwith'] = 'Abrir con ...';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.play'] = 'Reproducir';
$string['core.policy.havereadandagreepolicy'] = 'He leído y estoy de acuerdo con {{policyname}}';
$string['core.policy.nopoliciesyet'] = 'Aun sin políticas ni acuerdos.';
$string['core.policy.policyacceptmandatory'] = 'Comprendo y estoy de acuerdo con las políticas obligatorias del sitio';
$string['core.policy.sitepolicynotagreederror'] = 'Política del sitio NO acordada';
$string['core.policy.viewpolicy'] = 'Ver política {{policyname}}.';
$string['core.pulltorefresh'] = '\'\'Pull\'\' para refrescar';
$string['core.qrscanner'] = 'Escanner QR';
$string['core.question.cannotdeterminestatus'] = 'No pudo determinarse el estado';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'Su sitio aun no soporta anexar archivos a respuestas.';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = 'Su sitio aun no soporta editar archivos incrustados.';
$string['core.question.errorquestionnotsupported'] = 'Este tipo de pregunta no está soportada por la App: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Tocar para seleccionar y tocar para soltar.';
$string['core.question.questionmessage'] = 'Pregunta {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Usted será redireccionado al sitio.';
$string['core.reminders.atthetime'] = 'Al momento del evento';
$string['core.reminders.custom'] = 'Personalizado...';
$string['core.reminders.customreminder'] = 'Recordatorio personalizado';
$string['core.reminders.delete'] = 'Eliminar recordatorio';
$string['core.reminders.reminderset'] = 'Recordatorio configurado para {{$a}}';
$string['core.reminders.reminderunset'] = 'Recordatorio eliminado';
$string['core.reminders.setareminder'] = 'Configurar un recordatorio';
$string['core.reminders.setareminderfor'] = 'Configurar un recordatorio para "{{title}}" ({{label}})';
$string['core.reminders.setreminder'] = 'Configurar recordatorio';
$string['core.reminders.timebefore'] = '{{value}} {{units}} antes de';
$string['core.reminders.value'] = 'Valor';
$string['core.removedownloadeddata'] = 'Quitar datos descargados';
$string['core.removefiles'] = 'Quitar archivos {{$a}}';
$string['core.reportbuilder.filtersapplied'] = 'Puede haber filtros aplicados a esta vista. Para editar filtros o cambiar el orden de ordenamiento,, <a href="{{$a}}">abra este reporte en su navegador.</a>';
$string['core.reportbuilder.hidecolumns'] = 'Ocultar columnas';
$string['core.reportbuilder.showcolumns'] = 'Mostrar columnas';
$string['core.requireduserdatamissing'] = 'A este usuario le faltan algunos datos requeridos del perfil. Por favor, llene estos datos en su sitio e inténtelo nuevamente.<br>{{$a}}';
$string['core.resume'] = 'Continuar';
$string['core.retry'] = 'Reintentar';
$string['core.scanqr'] = 'Escanear código QR';
$string['core.scrollbackward'] = 'Desplazar hacia atrás';
$string['core.scrollforward'] = 'Desplazar hacia adelante';
$string['core.search.allcategories'] = 'Todas las categorías';
$string['core.search.empty'] = '¿Qué está buscando?';
$string['core.search.filtercategories'] = 'filtrar resultados por';
$string['core.search.filtercourses'] = 'Buscar en';
$string['core.search.noresults'] = 'Sin resultados para "{{$a}}"';
$string['core.search.noresultshelp'] = 'Revise errores tipográficos o intente usar diferentes palabras clave';
$string['core.search.resultby'] = 'Por {{$a}}';
$string['core.searching'] = 'Buscando';
$string['core.serverconnection'] = 'Error al conectarse al servidor: {{details}}';
$string['core.settings.about'] = 'Acerca de';
$string['core.settings.appsettings'] = 'Configuraciones de la App';
$string['core.settings.appversion'] = 'Versión de App';
$string['core.settings.cannotsyncloggedout'] = 'Este sitio no puede ser sincronizado porque Usted se ha salido. Por favor inténtelo nuevamente cuando esté ingresado nuevamente en el sitio.';
$string['core.settings.cannotsyncoffline'] = 'Falló la sincronización con el sitio porque su dispositivo no está conectado al internet.';
$string['core.settings.cannotsyncwithoutwifi'] = 'Su dispositivo no está conectado a Wi-Fi. Conéctese a una red Wi-Fi o desactive el Ahorrador de Datos en las configuraciones de la App.';
$string['core.settings.changelanguage'] = 'Cambiar a {{$a}}';
$string['core.settings.changelanguagealert'] = 'Al cambiar el idioma se reiniciará la App.';
$string['core.settings.colorscheme'] = 'Esquema de Colores';
$string['core.settings.colorscheme-dark'] = 'Oscuro';
$string['core.settings.colorscheme-light'] = 'Claro';
$string['core.settings.colorscheme-system'] = 'Predeterminado del sistema';
$string['core.settings.colorscheme-system-notice'] = 'El modo predeterminado del sistema dependerá del soporte para su dispositivo.';
$string['core.settings.compilationinfo'] = 'Información de compilación';
$string['core.settings.connecttosync'] = 'Su dispositivo está fuera de línea. Conéctese al internet para sincronizar sitios.';
$string['core.settings.connectwifitosync'] = 'Conectar a una red Wi-Fi o desactivar el guardador de Datos para sincronizar sitios.';
$string['core.settings.copyinfo'] = 'Copiar información del dispositivo al portapapeles';
$string['core.settings.cordovadevicemodel'] = 'Modelo de Dispositivo Cordova';
$string['core.settings.cordovadeviceosversion'] = 'Versión de OS de Dispositivo Cordova';
$string['core.settings.cordovadeviceplatform'] = 'Plataforma de Dispositivo Cordova';
$string['core.settings.cordovadeviceuuid'] = 'UUID del Dispositivo Cordova';
$string['core.settings.cordovaversion'] = 'Versión Cordova';
$string['core.settings.debugdisplaydescription'] = 'Si se habilita, errores modales mostrará más datos acerca del error si fuese posible,';
$string['core.settings.developeroptions'] = 'Opciones del desarrollador';
$string['core.settings.deviceinfo'] = 'Información del dispositivo';
$string['core.settings.deviceos'] = 'Sistema Operativo del dispositivo';
$string['core.settings.displayformat'] = 'Formato de visualización';
$string['core.settings.enableanalytics'] = 'Habilitar Analítica';
$string['core.settings.enableanalyticsdescription'] = 'Si se habilita, la App colectará datos anónimos de uso.';
$string['core.settings.enabledownloadsection'] = 'Habilitar descargar secciones';
$string['core.settings.enablefirebaseanalytics'] = 'Habilitar Analítica Firebase';
$string['core.settings.enablefirebaseanalyticsdescription'] = 'Si se habilita, la App colectará uso anónimo de datos .';
$string['core.settings.enablerichtexteditor'] = 'Habilitar editor de texto';
$string['core.settings.enablerichtexteditordescription'] = 'Si se habilita, un editor de texto estará disponible al ingresar contenido.';
$string['core.settings.enablesyncwifi'] = 'Permitir sincronización solamente cuando tenga Wi-Fi';
$string['core.settings.encryptedpushsupported'] = 'Notificaciones push encriptadas soportadas';
$string['core.settings.entriesincache'] = '{{$a}} entradas en caché';
$string['core.settings.errorsyncsite'] = 'Error al sincronizar los datos del sitio; por favor revise su conexión de Internet e inténtelo de nuevo.';
$string['core.settings.estimatedfreespace'] = 'Espacio libre estimado';
$string['core.settings.filesystemroot'] = 'Raíz del sistema-de-archivos';
$string['core.settings.fontsize'] = 'Tamaño del texto';
$string['core.settings.forcedsetting'] = 'Esta configuración ha sido  forzada por su configuración del sitio.';
$string['core.settings.helpusimprove'] = 'Ayúdenos a mejorar esta App';
$string['core.settings.ioscookies'] = 'Monitoreo Cross-Website';
$string['core.settings.ioscookiesdescription'] = 'El contenido incrustado de este sitio podría necesitar cookies cross-site para funcionar. Para habilitarlas, vaya a las configuraciones de iOS de la App y habilite \'Permitir Monitoreo Cross-Website\'.';
$string['core.settings.legaldisclaimer'] = 'Declaratoria legal';
$string['core.settings.localnotifavailable'] = 'Notificaciones locales disponibles';
$string['core.settings.locationhref'] = 'URL Vista Web';
$string['core.settings.logintosync'] = 'Ingresar al sitio para sincronizar';
$string['core.settings.navigatorlanguage'] = 'Idioma del Navegador';
$string['core.settings.navigatoruseragent'] = 'Agente del usuario del Navegador';
$string['core.settings.networkstatus'] = 'Estado de conexión a Internet';
$string['core.settings.opensourcelicenses'] = 'Licencias de Código Abierto';
$string['core.settings.privacypolicy'] = 'Política de privacidad';
$string['core.settings.publisher'] = 'Publicador/Editor';
$string['core.settings.pushid'] = 'ID notificaciones push';
$string['core.settings.reportinbackground'] = 'Reportar errores automáticamente';
$string['core.settings.screen'] = 'Información de pantalla';
$string['core.settings.showdownloadoptions'] = 'Mostrar opciones para descarga';
$string['core.settings.siteinfo'] = 'Información del sitio';
$string['core.settings.sitesynccompleted'] = 'Sincronización del sitio completada.';
$string['core.settings.sitesyncfailed'] = 'Falló la sincronización al sitio';
$string['core.settings.spaceusage'] = 'Espacio usado';
$string['core.settings.syncdatasaver'] = 'Grabador de datos: Sincronizar solamente cuando está en Wi-Fi';
$string['core.settings.synchronization'] = 'Sincronización';
$string['core.settings.synchronizenow'] = 'Sincronizar ahorita';
$string['core.settings.synchronizenowhelp'] = 'Al sincronizar con un sitio se enviarán cambios pendientes y toda la actividad fuera de línea almacenada en el dispositivo y se sincronizarán algunos datos como mensajes y  notificaciones.';
$string['core.settings.syncsettings'] = 'Configuraciones de la sincronización';
$string['core.settings.wificonnection'] = 'Conexión Wi-Fi';
$string['core.settings.youradev'] = 'Usted ahora es un desarrollador';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Elija una cuenta en la cual almacenar el archivo.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Ya existe un archivo con este nombre. ¿Desea reemplazar el archivo existente o renombrarlo a "{{$a}}"?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'No hay sitios almacenados. Por favor, añada un sitio antes de compartir un archivo con la Appp.';
$string['core.sharedfiles.nosharedfiles'] = 'No hay archivos compartidos almacenados en este sitio.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'Usted no tiene archivos para subir aquí. Si desea subir un archivo desde otra App, localice ese archivo y haga clic en el botón para \'Abrir en\'.';
$string['core.sharedfiles.rename'] = 'Renombrar';
$string['core.sharedfiles.replace'] = 'Reemplazar';
$string['core.sharedfiles.sharedfiles'] = 'Archivos compartidos';
$string['core.sharedfiles.successstorefile'] = 'Archivo almacenado exitosamente. Seleccione el archivo a subir a sus archivos privados o para usar en una actividad.';
$string['core.sitenotfound'] = 'Sitio no encontrado';
$string['core.sitenotfoundhelp'] = 'No pudimos encontrar el sitio que escribió. Por favor revise que no haya errores de teclado o inténtelo nuevamente después . Si sigue viendo este mensaje, póngase en contacto con su escuela o proveedor de aprendizaje.';
$string['core.siteunavailablehelp'] = 'El sitio "{{site}}" no está disponible ahorita. Por favor inténtelo nuevamente más tarde o póngase en contacto con su escuela o proveedor de aprendizaje.';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Lo siento...';
$string['core.start'] = 'Comenzar';
$string['core.startingtime'] = 'Hora de inicio: {{$a}}';
$string['core.storingfiles'] = 'Almacenando archivos';
$string['core.submittedoffline'] = 'Enviado (Fuera de línea)';
$string['core.swipenavigationtourdescription'] = 'Deslizar a izquierda o derecha para navegar.';
$string['core.tablet'] = 'Tableta';
$string['core.tag.errorareanotsupported'] = 'Esta área de marca no está soportada por la App.';
$string['core.tag.tagareabadgedescription'] = 'Hay {{count}} elementos.';
$string['core.tag.warningareasnotsupported'] = 'Algunas de las áreas de marca no son mostradas porque no están soportadas por la App.';
$string['core.thereisdatatosync'] = 'Existen {{$a}} fuera de línea para ser sincronizados/as.';
$string['core.toggledelete'] = 'Alternar botones eliminar';
$string['core.tryagain'] = 'Intentar nuevamente';
$string['core.turnon'] = 'Activar';
$string['core.turnonexactalarms'] = 'Activar alertas en tiempo real';
$string['core.turnonnotifications'] = 'Activar notificaciones';
$string['core.turnonnotificationsmessage'] = '¿Le gustaría recibir notificaciones acerca de actividades y tareas?';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = '¡Órale!';
$string['core.unexpectederror'] = 'Error inesperado. Por favor cierre y vuelva a abrir la aplicación  y entonces inténtelo de nuevo';
$string['core.unicodenotsupported'] = 'Algunos emojis no están soportado en este sitio. Esos caracteres serán quitados cuando el mensaje sea enviado.';
$string['core.unicodenotsupportedcleanerror'] = 'Se encontró texto vacío al limpiar caracteres Unicode.';
$string['core.unknown'] = 'Desconocido';
$string['core.unzipping'] = 'Descomprimiendo ZIP';
$string['core.updaterequired'] = 'Se necesita actualizar App';
$string['core.updaterequireddesc'] = 'Por favor actualice su App a la versión {{$a}}';
$string['core.user.completeprofile'] = 'Completar perfil';
$string['core.user.completeprofilehelp'] = 'Si tiene problemas para completar su perfil, inténtelo nuevamente mas tarde o póngase en contacto con su escuela o proveedor de aprendizaje.';
$string['core.user.completeprofilenotice'] = 'Antes de continuar, por favor llene los campos requeridos en su perfil de usuario.';
$string['core.user.completeprofilereconnectinstructions'] = 'Si usted no completó correctamente su perfil del usuario se le pedirá que lo haga de nuevo.';
$string['core.user.completeprofilesupportsubject'] = 'Necesito ayuda para completar mi perfil';
$string['core.user.completeyourprofile'] = 'Completar su perfil';
$string['core.user.contact'] = 'Contacto';
$string['core.user.detailsnotavailable'] = 'Los detalles de este usuario no están disponibles para Usted.';
$string['core.user.errorloaduser'] = 'Error al cargar usuario.';
$string['core.user.sendemail'] = 'Email';
$string['core.user.support'] = 'Ponerse en contacto con soporte del sitio';
$string['core.user.supportsubject'] = '[App] {{subject}}';
$string['core.user.userwithid'] = 'Usuario con ID {{id}}';
$string['core.usernologin'] = 'La autenticación ha sido revocada de esta cuenta';
$string['core.viewcode'] = 'Ver código';
$string['core.vieweditor'] = 'Ver editor';
$string['core.viewembeddedcontent'] = 'Ver contenido incrustado';
$string['core.wanttochangesite'] = '¿Quiere cambiar de sitio o salirse?';
$string['core.warningofflinedatadeleted'] = 'Los cambios fuera-de-línea a {{component}} \'{{name}}\' han sido borrados. {{error}}';
$string['core.warningofflinedatadeletedreason'] = 'Los cambios más nuevos a esta actividad han sido hechos desde un dispositivo diferente.';
$string['core.warnopeninbrowser'] = '<p>Usted está a punto de dejar la App para abrir la siguiente URL en el navegador de su dispositivo. ¿Desea continuar?</p>
<p><b>{{url}}</b></p>';
$string['core.whoissiteadmin'] = '"Administradores del sitio" son las personas que administran el Moodle en su escuela/universidad/compañía o su organización educativa. Si Usted no sabe como ponerse en contacto con ellos, por favor póngase en contacto con sus profesores/entrenadores.';
$string['core.whyisthishappening'] = '¿Porqué está pasando esto?';
$string['core.wsfunctionnotavailable'] = 'La función servicio web no está disponible.';
$string['core.youreoffline'] = 'Su dspositivo está desconectado';
$string['core.youreonline'] = 'Su dispositivo está conectado nuevamente';
$string['core.zoomin'] = 'Ver de cerca';
$string['core.zoomout'] = 'Ver de lejos';
$string['freemium.autologoutclosingtheapp'] = 'Inmediatamente después de abandonar la App';
$string['freemium.autologoutcustomtime'] = 'Tiempo personalizado después de abandonar la App';
$string['freemium.autologoutdefault'] = 'Predeterminado';
$string['freemium.autologouttitle'] = 'Automáticamente salirse de este dispositivo';
$string['freemium.biometriclogin'] = 'Ingreso biométrico';
$string['freemium.biometriclogindescription'] = 'Ponga su dedo en el lector de huella digital';
$string['freemium.biometricloginenablefaceid'] = 'Habilitar FaceID';
$string['freemium.biometricloginenablefingerprint'] = 'HAbilitar huella digital';
$string['freemium.biometricloginenabletouchid'] = 'HAbilitar TouchID';
$string['freemium.biometricloginloginwithfaceid'] = 'Ingresar con FAceID';
$string['freemium.biometricloginloginwithfingerprint'] = 'Ingresar con huella digital';
$string['freemium.biometricloginloginwithtouchid'] = 'Ingresar con TouchID';
$string['freemium.biometricloginskip'] = 'Saltar por ahora';
$string['freemium.biometricloginsuccessfullyenabled'] = '{{ biometricMethod }} habilitado.';
$string['freemium.biometricloginturnoff'] = 'Usted puede activar o desactivar esta característica en cualquier momento desde Configuraciones.';
$string['freemium.biometriclogintypefaceid'] = 'FaceID';
$string['freemium.biometriclogintypefingerprint'] = 'Huella digital';
$string['freemium.biometriclogintypetouchid'] = 'TouchID';
$string['freemium.biometricloginwithfingerorface'] = 'Usar ingreso  biométrico con su huella digital o con su cara.';
$string['freemium.change'] = 'Cmbiar';
$string['freemium.coursesbatchdownloaddisabled'] = 'Descargar cursos masivamente no está habilitado para este sitio.';
$string['freemium.coursesdownloadlimitreached'] = '¡Se ha alcanzado el límite para descarga de cursos! Usted solamente puede tener {{limit}} cursos descargados. Pongase en contacto con su administrador para aumentar este límite o quite algunos de los cursos descargados de su dispositivo.';
$string['freemium.downloadmainapplicationrequired'] = 'Usted solamente puede conectarse a este sitio usando a App dedicada.';
$string['freemium.downloadmainapplicationsuggestion'] = 'El sitio al que está intentando conectarse tiene una App dedicada que usted podría querer intentar usar.';
$string['freemium.feature_autologout'] = 'Auto ingreso';
$string['freemium.feature_biometriclogin'] = 'Ingreso biométrico';
$string['freemium.feature_coursesdownload'] = 'Cursos descargados';
$string['freemium.feature_multimediapushnotifications'] = 'Notificaciones push multimedia';
$string['freemium.feature_pushnotificationsdevices'] = 'Dispositivos notificacines ush';
$string['freemium.feature_qrlogin'] = 'Autenticar usando un código QR';
$string['freemium.feature_remotethemes'] = 'Temas remotos';
$string['freemium.feature_sitelogo'] = 'Logo del sitio';
$string['freemium.notallowed'] = 'No permitido';
$string['freemium.nottoday'] = 'Hoy no';
$string['freemium.qrlogindisabled'] = 'La autenticación en la App usando un código QR no está habilitada para el sitio:<br><br>{{url}}';
$string['freemium.qrloginexpiredkey'] = 'El código QR ha expirado. Por favor refresque la página con el código QR y escanéeela nuevamente.';
$string['freemium.qrloginipmismatch'] = 'El dispositivo que está usando para conectarse no parece estar en la misma red que el dispositivo que muestra el código QR. Por favor asegúrese que ambos dispositivos estén conectados a la misma red (por ejemplo, red WiFi).<br><br>Si el error persiste póngase en contacto con su administrador.';
$string['freemium.ratetheapp'] = '¿Está usted disfrutando nuestra App?';
$string['freemium.ratetheapp_feedbackko'] = 'Díganos lo que salió mal';
$string['freemium.ratetheapp_feedbackmessage'] = 'Su retralimentación será anónima';
$string['freemium.ratetheapp_feedbackok'] = 'Enviar retralimentación';
$string['freemium.ratetheapp_feedbackplaceholder'] = 'escriba algo aquí';
$string['freemium.ratetheapp_feedbacksent'] = '¡Gracias! Su retroalimentación fue enviada exitosamente';
$string['freemium.ratetheapp_sendtostore'] = '¿Podría tomarse un momento para valorar nuestra App? Nos ayudará a mejorar la App.';
$string['freemium.remindmelater'] = 'Recordarme más tarde';
$string['freemium.settingsoptions_autologout'] = 'Auto salida';
$string['freemium.settingsoptionsfacial'] = 'Habilitar ingreso facial';
$string['freemium.settingsoptionsfingerprint'] = 'Habilitar ingreso por huella digital';
$string['freemium.subscription'] = 'Suscripción al sitio';
$string['freemium.subscriptiondetails'] = 'Detallles de suscripción';
$string['freemium.subscriptionfeature_exceeded_customlanguagestrings'] = '{{ overflowCount }} cadenas de texto de idioma personalizadas están siendo ignoradas';
$string['freemium.subscriptionfeature_exceeded_custommenuitems'] = '{{ overflowCount }} {{ overflowCount }} elementos personalizados de menú están siendo ignorados';
$string['freemium.subscriptionfeature_exceeded_disabledfeatures'] = '{{ overflowCount }} características deshabilitadas configuradas todavía están habilitadas';
$string['freemium.subscriptionfeature_exceeded_remotethemes'] = 'Su tema personalizado no está siendo aplicado';
$string['freemium.subscriptionfeature_exceeded_sitelogo'] = 'Su logo del sitio no está siendo aplicado';
$string['freemium.subscriptionfeature_limited'] = 'Limitado a {{ limit }}';
$string['freemium.subscriptionfeature_unlimited'] = 'Ilimitado';
$string['freemium.subscriptionplan'] = 'Plan de suscripción';
$string['freemium.subscriptionplan_bma'] = 'BMA';
$string['freemium.subscriptionplan_expired'] = 'expirado';
$string['freemium.subscriptionplan_free'] = 'Gratuito';
$string['freemium.subscriptionplan_premium'] = 'Premium';
$string['freemium.subscriptionplan_pro'] = 'Pro';
$string['freemium.subscriptionplan_upgrade'] = 'Actualice su plan';
$string['freemium.subscriptionplan_validuntil'] = 'Válido hasta {{ date }}';
$string['freemium.subscriptionplandescription'] = 'Los planes de suscripción indican cuales restricciones aplican para este sitio.';
$string['freemium.subscriptionplanlearnmore'] = 'Aprender más';
$string['freemium.upsell_renewexpired'] = 'Su suscripción ha expirado';
$string['freemium.upsell_renewexpiring'] = 'Su suscripción expirará en {{ days }} días';
$string['freemium.upsell_renewtitle'] = 'Renovar su suscripción';
$string['freemium.upsell_upgradefreeaccept'] = 'Mejorar';
$string['freemium.upsell_upgradefreemessage'] = 'Usted actualmente está en el plan gratuito; actualice para desbloquear más características.';
$string['freemium.upsell_upgradefreepostpone'] = 'Más tarde';
$string['freemium.upsell_upgradefreetitle'] = 'Mejorar su plan';
$string['pluginname'] = 'Cadenas de idioma de App Moodle';
$string['privacy_metadata'] = 'Este plugin no almacena ningún dato del usuario.';
$string['workplace.teams.isoverdue'] = 'Tiene elementos caducos o expirados';
