<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'analytics', language 'da', version '4.3'.
 *
 * @package     analytics
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['analysablenotused'] = 'Analyserbar {$a->analysableid} ikke brugt: {$a->errors}';
$string['analysablenotvalidfortarget'] = 'Analyserbar {$a->analysableid} er ikke gyldig til denne destination: {$a->result}';
$string['analysisinprogress'] = 'Bliver stadig analyseret af en tidligere kørsel';
$string['analytics'] = 'Analyser';
$string['analyticsdisabled'] = 'Analyser er deaktiveret. Du kan aktivere det under "Siteadministration > Avancerede funktoner".';
$string['analyticslogstore'] = 'Loglager brugt til analyser';
$string['analyticslogstore_help'] = 'Det loglager der vil blive brugt af analyse-API til læsning af brugeres aktivitet.';
$string['analyticssettings'] = 'Analyseindstillinger';
$string['analyticssiteinfo'] = 'Site-information';
$string['calclifetime'] = 'Behold analyseberegninger i';
$string['configlcalclifetime'] = 'Dette angiver, hvor lang tid du vil beholde beregningsdata - dette vil ikke slette forudsigelser, men sletter de data, der blev brugt til at generere forudsigelserne. At bruge standardindstillingen her er bedst, da det holder dit diskforbrug under kontrol, men hvis du bruger beregningstabeller til andre formål, kan du ønske at øge denne værdi.';
$string['defaultpredictionsprocessor'] = 'Standard forudsigelsesprosessor';
$string['defaultpredictoroption'] = 'Standard processor ({$a})';
$string['defaulttimesplittingmethods'] = 'Standard analyseinterval for modellens evaluering';
$string['defaulttimesplittingmethods_help'] = 'Analyseintervallet definerer hvornår systemet beregner forudsigelser og de aktivitetslogs der vil tages i betragtning til disse forudsigelser. Modellens evalueringsproces vil gentages gennem disse analyseintervaller med mindre et specifikt analyseinterval er angivet.';
$string['disabledmodel'] = 'Deaktiveret model';
$string['erroralreadypredict'] = 'Filen {$a} er allerede blevet brugt til generering af forudsigelser.';
$string['errorcannotreaddataset'] = 'Datasætfilen {$a} kan ikke læses.';
$string['errorcannotusetimesplitting'] = 'Det givne analyseinterval kan ikke bruges på denne model.';
$string['errorcannotwritedataset'] = 'Der kan ikke skrives i datasætfilen {$a}.';
$string['errorexportmodelresult'] = 'Maskinlærings-modellen kan ikke eksporteres.';
$string['errorimport'] = 'Fejl under import af den leverede JSON-fil.';
$string['errorimportmissingclasses'] = 'Følgende analysekomponenter er ikke tilgængelige på dette websted: {$a->missingclasses}.';
$string['errorimportmissingcomponents'] = 'Den leverede model kræver at følgende plugins installeres: {$a}. Bemærk at versionerne ikke nødvendigvis skal svare til dem der er installeret på dit websted. Installation af samme eller nyere version af plugin\'et vil i de fleste situationer være fint.';
$string['errorimportversionmismatches'] = 'Versionen af følgende komponenter er ikke den samme som dem på dit websted: {$a}. Du kan bruge indstillingen "Ignorer inkonsistens på version" til ignorering af disse forskelle.';
$string['errorinvalidcontexts'] = 'Nogle af de valgte kontekster kan ikke bruges i dette mål.';
$string['errorinvalidindicator'] = 'Ugyldig {$a} indikator';
$string['errorinvalidtarget'] = 'Ugyldig {$a} destination';
$string['errorinvalidtimesplitting'] = 'Ugyldigt analyseinterval. Kontroller at du har tilføjet det fulde klassenavn.';
$string['errornocontextrestrictions'] = 'Den valgte destination understøtter ikke restriktioner på kontekster';
$string['errornoexportconfig'] = 'Der opstod et problem under eksport af modellens konfiguration.';
$string['errornoexportconfigrequirements'] = 'Kun ikke-statiske modeller med et analyseinterval kan eksporteres';
$string['errornoindicators'] = 'Denne model har ingen indikatorer.';
$string['errornopredictresults'] = 'Ingen resultater returneret fra forudsigelsesprocessoren. Tjek output-mappens indhold for mere information.';
$string['errornoroles'] = 'Roller på studerende eller lærer er ikke defineret. Definer dem på siden med analyseindstillinger.';
$string['errornotarget'] = 'Denne model har ikke nogen destination.';
$string['errornotimesplittings'] = 'Denne model har ikke et analyseinterval.';
$string['errorpredictioncontextnotavailable'] = 'Denne forudsigelseskontekst er ikke længere tilgængelig';
$string['errorpredictionformat'] = 'Forkert format på forudsigelsesberegninger';
$string['errorpredictionnotfound'] = 'Ingen forudsigelse fundet';
$string['errorpredictionsprocessor'] = 'Fejl i forudsigelsesprocessor: {$a}';
$string['errorpredictwrongformat'] = 'Returneringen fra forudsigelsesprocessoren kan ikke dekodes: "{$a}"';
$string['errorprocessornotready'] = 'Den valgte forudsigelsesprocessor er ikke klar: {$a}';
$string['errorsamplenotavailable'] = 'Den forudsagte prøve er ikke længere tilgængelig.';
$string['errorunexistingmodel'] = 'Ikke-eksisterende model {$a}';
$string['errorunexistingtimesplitting'] = 'Det valgte analyseinterval er ikke tilgængeligt.';
$string['errorunknownaction'] = 'Ukendt handling';
$string['eventinsightsviewed'] = 'Indblik vist';
$string['eventpredictionactionstarted'] = 'Forudsigelsesprocessen startet';
$string['fixedack'] = 'Godkend';
$string['incorrectlyflagged'] = 'Forkert markeret';
$string['insightinfomessageaction'] = '{$a->text}: {$a->url}';
$string['insightinfomessagehtml'] = 'Systemet har genereret en indsigt til dig.';
$string['insightinfomessageplain'] = 'Systemet har genereret en indsigt til dig: {$a}';
$string['insightmessagesubject'] = 'Ny indsigt for "{$a}"';
$string['invalidanalysablefortimesplitting'] = 'Det kan ikke analyseres ved hjælp af {$a} analyseinterval.';
$string['invalidtimesplitting'] = 'Model med ID {$a} har brug for et analyseinterval, før den kan bruges til træning.';
$string['levelinstitution'] = 'Uddannelsesniveau';
$string['levelinstitutionisced0'] = 'Førskoleundervisning (\'mindre end primært\' for uddannelsesresultater)';
$string['levelinstitutionisced1'] = 'Primær uddannelse';
$string['levelinstitutionisced2'] = 'Ungdomsuddannelse';
$string['levelinstitutionisced3'] = 'Videregående ungdomsuddannelse';
$string['levelinstitutionisced4'] = 'Eftersekundær ikke-tertiær uddannelse (kan omfatte virksomhedstræning eller træning fra fællesskaber/NGOer)';
$string['levelinstitutionisced5'] = 'Kort-cyklus tertiær uddannelse (kan omfatte virksomhedstræning eller træning fra fællesskaber/NGOer)';
$string['levelinstitutionisced6'] = 'Bachelor- eller tilsvarende niveau';
$string['levelinstitutionisced7'] = 'Master- eller tilsvarende niveau';
$string['levelinstitutionisced8'] = 'Doktor- eller tilsvarende niveau';
$string['modeinstruction'] = 'Instruktionsmåder';
$string['modeinstructionblendedhybrid'] = 'Blandet eller hybrid';
$string['modeinstructionfacetoface'] = 'Ansigt til ansigt';
$string['modeinstructionfullyonline'] = 'Helt online';
$string['modeloutputdir'] = 'Output-mappe for modeller';
$string['modeloutputdirwithdefaultinfo'] = 'Bibliotek hvor forudsigelsesprocessorerne gemmer alle evalueringer info. Nyttig til fejlretning og forskning. Hvis tomt, så bruges {$a} som standard.';
$string['modeltimelimit'] = 'Grænse for analysetid per model';
$string['modeltimelimitinfo'] = 'Indstillingen begrænser hvor længe modellen kan bruge til at analysere webstedets indhold.';
$string['neutral'] = 'Neutral';
$string['neverdelete'] = 'Slet aldrig beregninger';
$string['nocourses'] = 'Ingen kurser at analysere';
$string['nodata'] = 'Ingen data at analysere';
$string['noevaluationbasedassumptions'] = 'Modeller baseret på antagelser kan ikke evalueres.';
$string['noinsights'] = 'Ingen indsigter rapporteret';
$string['noinsightsmodel'] = 'Denne model genererer ikke indsigter';
$string['nonewdata'] = 'Der foreligger ingen nye data. Modellen vil blive analyseret efter det næste analyseinterval.';
$string['nonewranges'] = 'Ingen nye forudsigelser endnu. Modellen vil blive analyseret efter det næste analyseinterval.';
$string['nopredictionsyet'] = 'Ingen forudsigelser tilgængelige endnu';
$string['noranges'] = 'Ingen forudsigelser endnu';
$string['notapplicable'] = 'Ikke relevant';
$string['notrainingbasedassumptions'] = 'Modeller baseret på antagelser behøver ikke træning';
$string['notuseful'] = 'Ikke brugbar';
$string['novaliddata'] = 'Ingen gyldige data til rådighed';
$string['novalidsamples'] = 'Ingen gyldige prøver tilgængelige';
$string['onlycli'] = 'Kørsel af analyseprocesser kun via kommandolinje';
$string['onlycliinfo'] = 'Analyseprocesser såsom evalueringsmodeller, algoritmer til maskinlærings-træning eller få forudsigelser kan tage sin tid. De kan køre som cron-jobs eller kan startes via en kommandolinje. Er indstillingen deaktiveret, kan analyseprocesser kun køres fra web-interfacet.';
$string['percentonline'] = 'Procent online';
$string['percentonline_help'] = 'Hvis din organisation tilbyder blandede eller hybride kurser, hvor mange procent af de studerendes arbejde udføres da online i Moodle? Skriv et tal mellem 0 og 100.';
$string['predictionsprocessor'] = 'Forudsigelsesprocessor';
$string['predictionsprocessor_help'] = 'En forudsigelsesprocessor er den maskinlærings-backend, der bearbejder de datasæt der generes af beregningsmodellernes indikatorer og destination. Modellerne kan bruge forskellige processorer. Den der er specificeret her, vil være standard.';
$string['privacy:metadata:analytics:analyticsmodels'] = 'Analysemodeller';
$string['privacy:metadata:analytics:analyticsmodels:usermodified'] = 'Brugeren, der modificerede modellen';
$string['privacy:metadata:analytics:analyticsmodelslog'] = 'Log brugt til analysemodeller';
$string['privacy:metadata:analytics:analyticsmodelslog:usermodified'] = 'Brugeren, der modificerede loggen';
$string['privacy:metadata:analytics:indicatorcalc'] = 'Indikatorberegninger';
$string['privacy:metadata:analytics:indicatorcalc:contextid'] = 'Konteksten';
$string['privacy:metadata:analytics:indicatorcalc:endtime'] = 'Beregning sluttidspunkt';
$string['privacy:metadata:analytics:indicatorcalc:indicator'] = 'Indikatorberegner klasse';
$string['privacy:metadata:analytics:indicatorcalc:sampleid'] = 'Prøve-ID';
$string['privacy:metadata:analytics:indicatorcalc:sampleorigin'] = 'Prøvens oprindelsestabel';
$string['privacy:metadata:analytics:indicatorcalc:starttime'] = 'Beregning starttidspunkt';
$string['privacy:metadata:analytics:indicatorcalc:timecreated'] = 'Hvornår forudsigelsen blev foretaget';
$string['privacy:metadata:analytics:indicatorcalc:value'] = 'Den beregnede værdi';
$string['privacy:metadata:analytics:predictionactions'] = 'Forudsigelseshandlinger';
$string['privacy:metadata:analytics:predictionactions:actionname'] = 'Handlingens navn';
$string['privacy:metadata:analytics:predictionactions:predictionid'] = 'Forudsigelses-ID';
$string['privacy:metadata:analytics:predictionactions:timecreated'] = 'Hvornår forudsigelseshandlingen blev udført';
$string['privacy:metadata:analytics:predictionactions:userid'] = 'Brugeren, der foretog handlingen';
$string['privacy:metadata:analytics:predictions'] = 'Forudsigelser';
$string['privacy:metadata:analytics:predictions:calculations'] = 'Indikatorberegninger';
$string['privacy:metadata:analytics:predictions:contextid'] = 'Konteksten';
$string['privacy:metadata:analytics:predictions:modelid'] = 'Model-ID';
$string['privacy:metadata:analytics:predictions:prediction'] = 'Forudsigelsen';
$string['privacy:metadata:analytics:predictions:predictionscore'] = 'Forudsigelsesscore';
$string['privacy:metadata:analytics:predictions:rangeindex'] = 'Indeks for analyseintervallet';
$string['privacy:metadata:analytics:predictions:sampleid'] = 'Prøve-ID';
$string['privacy:metadata:analytics:predictions:timecreated'] = 'Hvornår forudsigelsen blev foretaget';
$string['privacy:metadata:analytics:predictions:timeend'] = 'Beregning sluttidspunkt';
$string['privacy:metadata:analytics:predictions:timestart'] = 'Beregning starttidspunkt';
$string['processingsitecontents'] = 'Behandler sitets indhold';
$string['successfullyanalysed'] = 'Succesfuldt analyseret';
$string['timesplittingmethod'] = 'Analyseinterval';
$string['timesplittingmethod_help'] = 'Analyseintervallet definerer, hvornår systemet vil beregne forudsigelserne og den del af aktivitetsloggene, der vil blive betragtet for disse forudsigelser. For eksempel kan kursets varighed opdeles i dele, med en forudsigelse genereret i slutningen af hver del.';
$string['timesplittingmethod_link'] = 'Time_splitting_methods';
$string['typeinstitution'] = 'Type institution';
$string['typeinstitutionacademic'] = 'Akademisk';
$string['typeinstitutionngo'] = 'Ikke-statslig organisation (NGO)';
$string['typeinstitutiontraining'] = 'Virksomhedstræning';
$string['useful'] = 'Brugbar';
$string['viewdetails'] = 'Vis detaljer';
$string['viewinsight'] = 'Vis indsigt';
$string['viewinsightdetails'] = 'Vis indsigt detaljer';
$string['viewprediction'] = 'Vis forudsigelsesdetaljer';
$string['washelpful'] = 'Var dette nyttigt?';
