<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'it', version '4.3'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Accesso negato';
$string['accountlocked'] = 'Il tuo account è bloccato. Via email è stato inviato un llink di sblocco.';
$string['accounts'] = 'Profili';
$string['accountunlocked'] = 'Il tuo account è sbloccato. Puoi autenticarti.';
$string['addcategory'] = 'Aggiungi categoria';
$string['additionalhtml'] = 'HTML aggiuntivo';
$string['additionalhtml_desc'] = 'Le seguenti impostazioni consentono di aggiungere del codice HTML da includere in tutte le pagine. È possibile specificare del codice HTML da inserire all\'interno del tag HEAD, all\'interno del corpo pagina dopo l\'apertura del tag BODY, oppure subito prima della chiusura del tag BODY.<br/>Le impostazioni consentono di aggiungere intestazioni o note a piè di pagina personalizzate su tutte le pagine, oppure di aggiungere servizi quali Google Analytics con facilità ed indipendentemente dal tema utilizzato.';
$string['additionalhtml_heading'] = 'Il codice HTML da aggiungere in tutte le pagine.';
$string['additionalhtmlfooter'] = 'Prima della chiusura del tag BODY';
$string['additionalhtmlfooter_desc'] = 'Il codice HTML verrà aggiunto in tutte le pagine prima della chiusura del tag BODY.';
$string['additionalhtmlhead'] = 'All\'interno del tag HEAD';
$string['additionalhtmlhead_desc'] = 'Il codice HTML verrà aggiunto in tutte le pagine al termine del tag HEAD.';
$string['additionalhtmltopofbody'] = 'All\'apertura del tag BODY';
$string['additionalhtmltopofbody_desc'] = 'Il codice HTML verrà aggiunto in tutte le pagine subito dopo l\'apertura del tag BODY.';
$string['admincategory'] = 'Categoria: {$a}';
$string['adminseesall'] = 'Gli amministratori visualizzano qualsiasi evento';
$string['adminseesallevents'] = 'Gli amministratori visualizzano tutti gli eventi';
$string['adminseesownevents'] = 'Gli amministratori visualizzano solo i propri eventi';
$string['advancedfeatures'] = 'Funzionalità avanzate';
$string['agedigitalconsentverification'] = 'Verifica dell’età del consenso digitale';
$string['agedigitalconsentverification_desc'] = 'Abilita la verifica dell’età del consenso digitale prima di visualizzare la pagina di creazione account. È utile per prevenire la creazione di account da parte di minori senza l’autorizzazione dei genitori o di chi ne fa le veci. Per supporto verrà visualizzato il <a target="_blank" href="{$a}">Contatto di supporto</a>.';
$string['ageofdigitalconsentmap'] = 'Età del consenso digitale';
$string['ageofdigitalconsentmap_desc'] = 'E’ possibile specificare il valore di default dell’età del consenso digitale e l’età del consenso per tutte le nazioni dove tale valore è diverso dal default. Inserire ciascuna età in una linea diversa con il seguente formato: “codice nazione, età”. L’età di default è indicata da un asterisco “*” al posto del codice della nazione. I codici delle nazioni devono essere indicati nel formato ISO 3166-2.';
$string['allcountrycodes'] = 'Elenco codici nazione';
$string['allowattachments'] = 'Consenti allegati';
$string['allowbeforeblock'] = 'Elabora per primo l\'elenco degli IP autorizzati';
$string['allowbeforeblockdesc'] = 'Di default l\'elenco degli IP bloccati verrà elaborato per primo. Abilitando questa opzione, sarà elaborato per primo l\'elenco degli IP autorizzati.';
$string['allowcategorythemes'] = 'Consenti la scelta dei temi per le categorie';
$string['allowcohortthemes'] = 'Consenti temi dei gruppi globali';
$string['allowcoursethemes'] = 'Consenti la scelta dei temi per i corsi';
$string['allowedemaildomains'] = 'Domini di posta consentiti';
$string['allowediplist'] = 'Elenco degli IP autorizzati';
$string['allowemailaddresses'] = 'Domini di posta autorizzati';
$string['allowemojipicker'] = 'Selettore emoji';
$string['allowframembedding'] = 'Consenti l\'embed in frame';
$string['allowframembedding_help'] = 'Consente di incorporare il sito dentro frame di altri siti, come suggerito dal plugin di iscrizione \'Pubblicazione come tool LTI\'. Se non si usa il plugin, per motivi di sicurezza si sconsiglia l\'uso di questa impostazione. Da notare che in caso di utilizzo della App Mobile, l\'impostazione verrà ignorata poiché in tl caso l\'incorporamento tramite iframe è sempre consentito.';
$string['allowguestmymoodle'] = 'Consenti agli ospiti l\'accesso alla dashboard';
$string['allowindexing'] = 'Consenti indicizzazione dei motori di ricerca';
$string['allowindexing_desc'] = 'Consente l’indicizzazione del sito da parte dei motori di ricerca. “Qualsiasi parte” consentirà ai motori di ricerca di cercare dappertutto includendo anche la pagina di autenticazione e di creazione account, cosa che consentirà l’indicizzazione anche dei siti con l’impostazione ‘Autenticazione obbligatoria’ attiva. Per evitare il rischio di spam che può generarsi a fronte dell’indicizzazione dlla pagina di autenticazione e di creazione account, è possibile impostare “Qualsiasi parte eccetto le pagine di autenticazione e di creazione account”. “Nessuna parte” chiederà ai motori di ricerca di non indicizzare nessuna pagina. Da notare che l’impostazione si rifletterà sui tag dell’header ma è responsabilità dei motori di ricerca rispettare l’impostazione.';
$string['allowindexingeverywhere'] = 'Qualsiasi parte';
$string['allowindexingexceptlogin'] = 'Qualsiasi parte eccetto le pagine di autenticazione e di creazione
account';
$string['allowindexingnowhere'] = 'Nessuna parte';
$string['allowobjectembed'] = 'Consenti i tag EMBED e OBJECT';
$string['allowthemechangeonurl'] = 'Consenti il cambio del tema tramite URL';
$string['allowuserblockhiding'] = 'Consenti agli utenti di nascondere i blocchi';
$string['allowusermailcharset'] = 'Consenti agli utenti di scegliere il set di caratteri';
$string['allowuserswitchrolestheycantassign'] = 'Consenti agli utenti che non hanno il privilegio di attribuire ruoli di cambiare ruolo.';
$string['allowuserthemes'] = 'Consenti agli utenti di scegliere il tema';
$string['alternativefullnameformat'] = 'Formato alternativo del nome completo';
$string['alternativefullnameformat_desc'] = 'Imposta la visualizzazione del nome completo per i ruoli che hanno il privilegio "viewfullnames" (di default i ruoli manager, docente e docente non editor). I segnaposto utilizzabili sono gli stessi dell\'impostazione "Formato del nome completo".';
$string['always'] = 'Sempre';
$string['appearance'] = 'Aspetto';
$string['aspellpath'] = 'Percorso di aspell';
$string['asyncbackupdisabled'] = 'Il sito è attualmente configurato per utilizzare backup sincroni. I backup asincroni offrono un\'esperienza utente migliore.
I backup asincroni saranno abilitati per tutti i siti da Moodle LMS 4.5 LTS.
I backup sincroni verranno rimossi da Moodle LMS nella versione successiva alla 4.5 LTS';
$string['authentication'] = 'Autenticazione';
$string['authpreventaccountcreation'] = 'Evita la creazione di account durante l\'autenticazione';
$string['authpreventaccountcreation_help'] = 'Un utente privo di account che si autentica tramite sistemi esterni (ad esempio LDAP), vedrà il suo account creato automaticamente. L\'impostazione è utile per impedire che gli account vengano creati automaticamente, consentendo l\'accesso solo agli account già esistenti. Sarà necessario creare gli account manualmente o caricarli tramite la funzione Importa utenti. L\'impostazione non ha effetto sulla autenticazione MNet';
$string['authsettings'] = 'Gestione autenticazione';
$string['autolang'] = 'Rilevazione automatica della lingua';
$string['autolangusercreation'] = 'Durante la creazione di utenti, la lingua da impostare sarà rilevata automaticamente dal browser in uso.';
$string['autologinguests'] = 'Login automatico per gli ospiti';
$string['availableto'] = 'Disponibile per';
$string['availabletoanyone'] = 'Qualsiasi utente, inclusi i visitatori';
$string['availabletoauthenticated'] = 'Solo utenti autenicati';
$string['backgroundcolour'] = 'Colore trasparente';
$string['backup_shortname'] = 'Utilizza il titolo del corso nel nome del file di backup';
$string['backup_shortnamehelp'] = 'Utilizza il titolo del corso come parte del nome del file di backup.';
$string['backups'] = 'Backup';
$string['badwordsconfig'] = 'Inserire l\'elenco personalizzato delle parole da censurare. Ciascuna parola deve essere separata dalle altre con una virgola.';
$string['badwordsdefault'] = 'In mancanza dell\'elenco personalizzato verrà utilizzato l\'elenco di default preso dal Language Pack.';
$string['badwordslist'] = 'Elenco personalizzato delle parole da censurare';
$string['blockediplist'] = 'Elenco degli IP bloccati';
$string['blockinstances'] = 'Istanze';
$string['blockmultiple'] = 'Multiplo';
$string['blockprotect'] = 'Proteggi istanze';
$string['blockprotect_help'] = 'Il bloccaggio impedisce l\'aggiunta o l\'eliminazione delle istanze dei blocchi. (Puoi sbloccare il tipo se devi modificare un\'istanza).

Lo scopo è quello di evitare l\'eliminazione accidentale di quei blocchi difficili da ripristinare, come il blocco Navigazione ed il blocco Impostazioni.';
$string['blockprotectblock'] = 'Proteggi istanze di {$a}';
$string['blockprotected'] = 'Sono state protette {$a} istanze del blocco';
$string['blocksettings'] = 'Gestione blocchi';
$string['blockunprotect'] = 'Rimuovi protezione';
$string['blockunprotectblock'] = 'Rimuovi protezione delle istanze di {$a}';
$string['blockunprotected'] = 'È stata rimossa la protezione a {$a} istanze del blocco';
$string['bloglevel'] = 'Visibilità del Blog';
$string['bookmarkadded'] = 'Segnalibro aggiunto.';
$string['bookmarkalreadyexists'] = 'Questa pagina è già presente nei tuoi segnalibri.';
$string['bookmarkdeleted'] = 'Segnalibro eliminato.';
$string['bookmarkthispage'] = 'Aggiungi pagina nei segnalibri';
$string['cacheapplication'] = 'Cache applicazione';
$string['cacheapplicationhelp'] = 'Gli elementi presenti in cache sono condivisi tra tutti gli utenti e scadono dopo un determinato "time to live" (ttl)';
$string['cachejs'] = 'Cache Javascript';
$string['cachejs_help'] = 'La cache e la compressione dei Javascript velocizza notevolmente il caricamento delle pagine ed è fortemente consigliato per i siti in produzione. Per gli sviluppatori è preferibile disabilitare l\'impostazione.';
$string['cacherequest'] = 'Request cache';
$string['cacherequesthelp'] = 'Cache specifiche dell\'utente che scadono al completamento del request. Utili per rimpiazzare aree dove vengono usati store statici';
$string['cachesession'] = 'Cache sessioni';
$string['cachesessionhelp'] = 'Cache specifiche dell\'utente che scadono al termine della sessione. Utili per ridurre problemi di sessione.';
$string['cachesettings'] = 'Impostazioni cache';
$string['cachetemplates'] = 'Cache modelli';
$string['cachetemplates_help'] = 'L\'inserimento in cache dei modelli velocizza notevolmente il caricamento delle pagine e ne è raccomandato l\'utilizzo su siti in produzione. Per i siti di sviluppo può essere preferibile non attivare tali cache.';
$string['caching'] = 'Caching';
$string['calendar_weekend'] = 'Giorni del weekend';
$string['calendarexportsalt'] = 'Seme per l\'esportazione del calendario';
$string['calendarsettings'] = 'Calendario';
$string['calendartype'] = 'Tipo di calendario';
$string['calendartype_desc'] = 'Il calendario di default per il sito. Questa impostazione può essere modificata nelle impostazioni del corso oppure da ciascun utente nel proprio profilo.';
$string['campaign'] = 'Campagna';
$string['cannotdeletemodfilter'] = 'Non puoi disinstallare \'{$a->filter}\' in quanto fa parte del modulo \'{$a->module}\'.';
$string['cannotuninstall'] = 'Non è possibile disinstallare {$a}';
$string['categoryemail'] = 'Email';
$string['cfgwwwrootslashwarning'] = 'Nel file config.php la variabile $CFG->wwwroot è stata impostata in modo errato. È presente alla fine il carattere \'/\' che deve essere rimosso.';
$string['cfgwwwrootwarning'] = 'Nel file config.php la variabile $CFG->wwwroot è stata impostata in modo errato. Deve corrisponde all\'URL utilizzato per accedere a questa pagina.';
$string['change'] = 'cambia';
$string['checkboxno'] = 'No';
$string['checkboxyes'] = 'Si';
$string['checkupgradepending'] = 'Aggiorna';
$string['choosefiletoedit'] = 'Scegli un file da modificare';
$string['cleanup'] = 'Operazioni di pulizia';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 's';
$string['cliexitgraceful'] = 'Uscendo con grazia, attendere prego ...';
$string['cliexitnow'] = 'Uscendo proprio ORA';
$string['cliincorrectvalueerror'] = 'Errore, il valore "{$a->value}" non è corretto per "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Valore non corretto, per favore riprova';
$string['clistatusdisabled'] = 'Stato: disabilitato';
$string['clistatusenabled'] = 'Stato: abilitato';
$string['clistatusenabledlater'] = 'stato: la modalità manutenzione CLI sarà attivata su {$a}';
$string['clitypevalue'] = 'inserisci valore';
$string['clitypevaluedefault'] = 'inserisci un valore oppure premi Invio per usare il valore di default ({$a})';
$string['cliunknowoption'] = 'Opzioni non riconosciute:
{$a}
. Per favore utilizza l\'opzione --help.';
$string['cliupgradecompletenomaintenanceupgrade'] = 'Per svuotare le cache residue dopo il passaggio del traffico utente al nuovo codice:

   php admin/cli/purge_caches.php --muc
   php admin/cli/purge_caches.php --js
   php admin/cli/purge_caches.php --filter
   php admin/cli/purge_caches.php --other

È necessario eseguire i comandi in modo isolato, con un intervallo tra l\'uno e l\'altro, al fine di ridurre i picchi di carico sul server web.';
$string['cliupgradedefault'] = 'Nuova impostazione: {$a}';
$string['cliupgradedefaultheading'] = 'Valorizzazione di default delle nuove impostazioni';
$string['cliupgradedefaultverbose'] = 'Nuova impostazione: {$a->name}, Valore predefenito: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'L\'aggiornamento via linea di comando da {$a->oldversion} a {$a->newversion} è stato completato correttamente.';
$string['cliupgrademaintenancenotrequired'] = 'Questo aggiornamento NON attiverà la modalità manutenzione';
$string['cliupgrademaintenancerequired'] = 'Questo aggiornamento attiverà la modalità manutenzione';
$string['cliupgradenoneed'] = 'Non sono necessari aggiornamenti per la versione installata: {$a}. Grazie comunque per la verifica!';
$string['cliupgradepending'] = 'Aggiornamento in attesa';
$string['cliupgradesetlock'] = 'L\'aggiornamento è stato bloccato solo per l\'esecuzione da CLI.';
$string['cliupgradeunsetlock'] = 'Il blocco dell\'aggiornamento per \'esecuzione da CLI è stato rimosso.';
$string['cliyesnoprompt'] = 'inserisci s (per Si) o n (per No)';
$string['close'] = 'Chiudi';
$string['cohort_customfield'] = 'Campi personalizzati dei gruppi globali';
$string['commentsperpage'] = 'Commenti visualizzati per pagina';
$string['commonactivitysettings'] = 'Impostazioni comuni';
$string['commonfiltersettings'] = 'Impostazioni comuni dei filtri';
$string['commonsettings'] = 'Impostazioni comuni';
$string['componentinstalled'] = 'Componente installato';
$string['computedfromlogs'] = 'Calcolato dal log a partire da {$a}';
$string['condifmodeditdefaults'] = 'I valori di default verranno utilizzati durante la creazione di attività o risorse';
$string['confeditorhidebuttons'] = 'Seleziona i pulsanti dell\'editor HTML da nascondere.';
$string['configallcountrycodes'] = 'L\'elenco dei codici nazione che possono essere selezionati, ad esempio nel profilo dell\'utente. È possibile inserire un elenco di codici separati da virgola: \'GB,FR,ES\'. Se l\'elenco viene lasciato vuoto (default), verrà utilizzato l\'elenco presente in countries.php del language pack inglese standard, coincidente con l\'elenco ISO 3166-1. Se vengono inseriti codici non standard, è anche necessario  aggiunge tali codici al file countries.php del proprio language pack e nel language pack inglese.';
$string['configallowassign'] = 'Per ciascun ruolo sulla sinistra, selezionare i ruoli che potrà assegnare.';
$string['configallowattachments'] = 'Consente di allegare file alle email generate dal sito,ad esempio i badge.';
$string['configallowcategorythemes'] = 'Abilitando questa opzione, i temi potranno essere impostati a livello di categoria. L\'impostazione influenzerà tutte le sotto categorie ed i relativi corsi a meno che gli stessi non abbiano  impostato esplicitamente il tema da utilizzare. ATTENZIONE: L\'abilitazione dei temi di categoria può influenzare le prestazioni.';
$string['configallowcohortthemes'] = 'Consente di impostare temi per i gruppi globali. L\'impostazione ha effetto per tutti gli utenti che appartengono ad uno o più gruppi globali purché il tema impostato sia il medesimo.';
$string['configallowcoursethemes'] = 'Se abilitato, sarà  possibile impostare un tema diverso per ogni corso. Il tema del corso avrà precedenza su ogni altra preferenza (tema del sito, tema dell\'utente, tema di sessione).';
$string['configallowedemaildomains'] = 'Elenco dei domini di posta che è possibile rivelare nella sezione "From" delle email in uscita. Il valore "Vuoto" di default utilizzerà l\'indirizzo no-reply per tutte le mail in uscita. È consentito l\'utilizzo dei caratteri jolly,  ad esempio *.example.com consentirà l\'invio di email da qualsiasi sotto dominio di example.com, ma non da example.com, che eventualmente può essere aggiunto all\'elenco.';
$string['configallowemailaddresses'] = 'Se si desidera che le email utilizzabili appartengano solo a determinati domini, è possibile elencare i domini autorizzati in questa impostazione, avendo cura di separare i domini tra loro con uno spazio. Le email che non appartengono ai domini elencati non saranno accettate. Per autorizzare anche i sotto domini, elencare il dominio precedendolo con \'.\'. Per autorizzare un dominio e i suoi sotto domini, inserire il dominio una volta col punto ed una volta senza, ad esempio  .ourcollege.edu.au ourcollege.edu.au.';
$string['configallowemojipicker'] = 'Il selettore di emoji consente di aggiungere emoji ai testi ed ai messaggi, come ad esempio gli smiley, tramite la barra degli strumenti Atto.';
$string['configallowemojipickerincompatible'] = 'La configurazione del database non supporta correttamente le emoji. Per abilitare il selettore di emoji è necessario<a href="https://docs.moodle.org/en/MySQL_full_unicode_support">aggiornare il database per supportare unicode completamente</a>.';
$string['configallowguestmymoodle'] = 'Consente l\'accesso alla Dashboard agli ospiti. Se l\'impostazione è disabilitata gli ospiti saranno reindirizzati alla pagina home del sito.';
$string['configallowobjectembed'] = 'Come misura standard di sicurezza, gli utenti con il ruolo studente non possono incorporare oggetti multimediali utilizzando esplicitamente i tag EMBED e OBJECT nei testi HTML (possono sempre utilizzare il filtro Plugin multimediali). Se si preferisce consentire l\'utilizzo di questi tag, allora si deve abilitare questa opzione.';
$string['configallowoverride'] = 'È possibile consentire ai ruoli elencati a sinistra di modificare i ruoli riportati nelle colonne';
$string['configallowoverride2'] = 'Per ciascun ruolo sulla sinistra, selezionare i ruoli che potrà modificare.<br />Da notare che l\'utente deve anche possedere il privilegio moodle/role:override o moodle/role:safeoverride.';
$string['configallowswitch'] = 'Per ciascun ruolo sulla sinistra, selezionare i ruoli nei quali potrà cambiare. <br />Da notare che l\'utente deve anche possedere il privilegio moodle/role:switchroles.';
$string['configallowthemechangeonurl'] = 'L\'impostazione consente di cambiare il tema, utilizzando in alternativa:  <br />?theme=nomedeltema posposto a qualsiasi URL di Moodle (esempio: mymoodlesite.com/?theme=afterburner ) oppure <br />&theme=nomedeltema posposto a qualsiasi URL interno di Moodle, (esempio: mymoodlesite.com/course/view.php?id=2&theme=afterburner ).';
$string['configallowuserblockhiding'] = 'Èpossibile consentire agli utenti di espandere e minimizzare i blocchi laterali del sito. <br>Questa caratteristica utilizza Javascript e i cookie per ricordare lo stato di ogni blocco, influenzando pertanto solo la vista personale dell\'utente.';
$string['configallowusermailcharset'] = 'Consente agli utenti di impostare il set di caratteri preferito delle email.';
$string['configallowuserswitchrolestheycantassign'] = 'Per cambiare ruolo gli utenti devono possedere il privilegio moodle/role:assign. Abilitando questa impostazione si rimuove la necessità di avere questo privilegio e i ruoli disponibili nel menù a discesa "Cambia ruolo in.." saranno controllati solamente dalle impostazioni della tabella "Autorizzati ad attribuire ruoli".
Si raccomanda che nella tabella "Autorizzati ad attribuire ruoli" non ci siano impostazioni tali da consentire agli utenti di cambiare il proprio ruolo con un ruolo che ha maggiori privilegi.';
$string['configallowuserthemes'] = 'Gli utenti potranno scegliere il loro tema personale. I temi personali hanno la precedenza sui temi del sito, ma non sui temi di corso.';
$string['configallowview'] = 'Per ciascun ruolo sulla sinistra, selezionare i ruoli che potrà visualizzare cercare e filtrare.';
$string['configallusersaresitestudents'] = 'Ai fini delle attività della pagina home del sito, tutti gli utenti devono essere considerati studenti? Selezionando \'Si\', tutti gli account utente confermati saranno abilitati a partecipare come studente a queste attività. Selezionando \'No\', solo gli utenti che sono anche studenti iscritti almeno ad un corso saranno abilitati a partecipare alle attività presenti nella pagina home. Solo gli amministratori e gli utenti assegnati espressamente come trainer potranno gestire le attività della pagina home.';
$string['configauthenticationplugins'] = 'Nella tabella soprastante puoi abilitare i plugin di autenticazione ed ordinarli secondo la priorità di esecuzione desiderata.';
$string['configautolang'] = 'Rileva la lingua di default dalle impostazioni del browser.  Se l\'opzione è disabilitata sarà usata la lingua default del sito.';
$string['configautolangusercreation'] = 'Quando l\'account di un utente viene automaticamente creato al primo accesso (ad esempio utilizzando l\'autenticazione LDAP o OAuth 2), verrà impostata come lingua preferita dell\'utente la lingua rilevata dal browser. Se la lingua del browser non viene rilevata, verrà impostata come lingua preferita la lingua di default del sito.';
$string['configautologinguests'] = 'Selezionando questa opzione, i visitatori potranno accedere direttamente ai corsi che consentono l\'accesso agli ospiti';
$string['configbloglevel'] = 'L\'impostazione consente di regolare la visibilità dei blog degli utenti. L\'impostazione regola la visibilità del blog per colui che legge i blog degli utenti ma non altera il privilegio degli utenti di scrivere nel proprio blog. Se non desiderati, i blog possono essere disabilitati.';
$string['configcalendarcustomexport'] = 'Abilita intervallo di date personalizzato per l\'esportazione del calendario';
$string['configcalendarexportsalt'] = 'Il seme generato casualmente viene utilizzato per rendere più sicuri i token di autenticazione usati per l\'esportazione dei calendari. Puoi cambiare il seme ma tutti i token di autenticazione al momento attivi non saranno più validi.';
$string['configcookiesecure'] = 'Se il server accetta solamente connessioni https, allora è opportuno abilitare l\'invio di cookie sicuri. Se abiliti questa impostazione, accertatati che il server web non accetti connessioni http://, oppure imposta un reindirizzamento permanente al protocollo https://.';
$string['configcountry'] = 'Il Paese che comparirà di default nelle pagine di creazione di un account utente. Se non si imposta un Paese di default, il campo diventerà a compilazione obbligatoria.';
$string['configcoursegraceperiodafter'] = 'Numero di giorni successivi alla data di fine corso durante i quali considerare "in svolgimento" i corsi.';
$string['configcoursegraceperiodbefore'] = 'Numero di giorni antecedenti alla data di inizio corso durante i quali considerare "in svolgimento" i corsi.';
$string['configcourseoverviewfilesext'] = 'Elenco separato da virgola delle estensioni consentite per le immagini del corso';
$string['configcourseoverviewfileslimit'] = 'Il numero massimo di file che  possono essere visualizzati assieme all\'introduzione nella pagina con l\'elenco dei corsi. Il primo file di tipo immagine che verrà caricato sarà utilizzato anche come immagine del corso nella panoramica corsi della dashboard. Ulteriori file saranno visualizzati solamente  nella pagina con l\'elenco dei corsi.';
$string['configcourserequestnotify'] = 'È possibile indicare lo username dell\'utente da avvertire in presenza di richieste di nuovi corsi.';
$string['configcourserequestnotify2'] = 'Gli utenti da avvertire in presenza di domande per Corsi a richiesta. L\'elenco riporta solo gli utenti che hanno il privilegio di approvare Corsi a richiesta.';
$string['configcoursesperpage'] = 'Numero di corsi da visualizzare nelle pagine contenenti elenchi di corsi.';
$string['configcourseswithsummarieslimit'] = 'Il numero massimo di corsi da visualizzare negli elenchi di corsi che includono l\'introduzione prima di utilizzare un elenco più semplice.';
$string['configcronclionly'] = 'Lanciare il cron via web può rivelare informazioni sensibili ad utenti anonimi. Si raccomanda di lanciare il cron solo via linea di comando oppure di impostare una password per l\'elaborazione del cron via web.';
$string['configcronremotepassword'] = 'Lo script cron.php potrà essere eseguito da un browser web solo fornendo la password, usando il seguente formato per l\'URL:<pre>
http://site.example.com/admin/cron.php?password=opensesame</pre>In assenza di impostazione, non sarà necessaria nessuna password.';
$string['configcurlcache'] = 'Time-to-live, espresso in secondi, della cache cURL';
$string['configcustommenuitems'] = 'È possibile configurare un menu orizzontale personalizzato. Ciascuna linea è composta da testo, un URL (opzionale, non disponibile per un menu di primo livello con sotto voci), un testo per il tooltip (opzionale) e un codice lingua o elenco di codici lingua separati da virgola (opzionale, per visualizzare il testo in base alla lingua dell\'utente). Ciascun elemento è separato dal carattere “|” (pipe). Le linee che iniziano con il segno meno \'-\' saranno visualizzate come voci di menù del menu di primo livello precedente e ### genererà un divisorio. Esempio:
<pre>
Courses
-All courses|/course/
-Course search|/course/search.php
-###
-FAQ|https://someurl.xyz/faq
-Preguntas más frecuentes|https://someurl.xyz/pmf||es
Mobile app|https://someurl.xyz/app|Download our app
</pre>';
$string['configcustomusermenuitems'] = 'È  possibile configurare i contenuti del menu utente (ad eccezione del link di logout che verrà inserito automaticamente). Gli elementi su ciascuna linea devono essere separati dal carattere | e contengono 1) una stringa del tipo "langstringname, componentname" oppure una stringa di testo semplice, 2) un URL. È anche possibile utilizzare separatori aggiungendo una linea con uno più caratteri #.';
$string['configdbsessions'] = 'È possibile memorizzare le informazioni delle sessioni nel database. L\'impostazione è particolarmente utile per siti molto grandi, con molto traffico o per siti in cluster. Attenzione: cambiare questa impostazione provoca il logout dal sito di tutti gli utenti collegati, tu compreso.
Se viene utilizzato MySQL, accertarsi di impostare \'max_allowed_packet\' in my.cnf (o in my.ini) ad almeno 4M. È anche possibile configurare altri driver di sessione direttamente nel file config.php. Per maggiori informazioni vedere il file config-dist.php. Questa impostazione scompare se vengono specificati driver di sessione nel file config.php,';
$string['configdebug'] = 'L\'impostazione regola il dettaglio della reportistica del PHP. Èutile esclusivamente per gli sviluppatori.';
$string['configdebugdisplay'] = 'Consente di indirizzare il report degli errori nella pagina HTML. Sebbene l\'opzione sia particolarmente comoda, va tenuto presente che l\'invio di messaggi di errore nella pagina HTML altererà l\'XHTML, i JS, i cookie e gli header HTTP. Se non si seleziona l\'opzione, il report sarà inviato nel log del  server, consentendo un debugging più facile. Il nome del log di destinazione è controllato dall\'impostazione PHP error_log.';
$string['configdebugpageinfo'] = 'Selezionare l\'opzione se si desidera visualizzare le informazione nel piè di pagina.';
$string['configdebugvalidators'] = 'Selezionare l\'opzione se si desidera visualizzare i link ai validator esterni. Per il corretto funzionamento è necessario creare un utente con username <em>w3cvalidator</em> ed abilitare l\'accesso agli ospiti. Tali impostazioni possono consentire accessi non autorizzati al  server, pertanto non va utilizzata su siti in produzione.';
$string['configdefaulthomepage'] = 'Imposta la pagina che gli utenti visualizzeranno dopo essersi autenticati, Imposta anche il primo link della navigazione nei temi basati su Calssic.';
$string['configdefaultrequestcategory'] = 'I corsi a richiesta, se approvati, saranno automaticamente inseriti nella categoria specificata.';
$string['configdefaultrequestedcategory'] = 'Categoria in cui inserire i corsi a richiesta, una volta approvati.';
$string['configdefaultuserroleid'] = 'A tutti gli utenti autenticati, nel contesto del sito, sarà assegnato il ruolo qui indicato. Tale ruolo viene assegnato in aggiunta ai ruoli che gli utenti già possiedono nel sito. Il valore di default è Utente autenticato. Il ruolo di Utente autenticato non entra in conflitto con nessun altro ruolo: il suo scopo è quello di garantire agli utenti autenticati alcuni privilegi, indipendenti dal fatto di essere iscritti ad un corso, come ad esempio inserire un intervento nel blog, gestire il proprio calendario, eccetera.';
$string['configdeleteincompleteusers'] = 'Tempo limite oltre il quale verrà eliminato qualsiasi account privo di nome, cognome o email.';
$string['configdeleteunconfirmed'] = 'In alcuni metodi di autenticazione, ad esempio l\'autenticazione via e-mail, gli utenti devono confermare l\'account entro un certo periodo di tempo. Trascorso il periodo, gli utenti non confermati verranno eliminati.';
$string['configdenyemailaddresses'] = 'Se si desidera impedire l\'uso di email appartenenti a taluni domini, in questa impostazione è possibile elencare i domini indesiderati . Le email appartenenti a domini non presenti nell\'elenco potranno invece essere utilizzate. Per includere anche i sotto domini, elencare il dominio precedendolo con \'.\'. Ad esempio, <strong>hotmail.com .yahoo.co.uk.live</strong>';
$string['configdisableuserimages'] = 'Gli utenti non potranno  cambiare l\' immagine del proprio profilo.';
$string['configdisplayloginfailures'] = 'Abilita la visualizzazione dei tentativi errati di login.';
$string['configdndallowtextandlinks'] = 'Abilita o disabilita il caricamento di testi e link tramite trascina e rilascia. Da notare che trascinare e rilasciare testi in Firefox o tra browser differenti potrebbe risultare in nessun caricamento o in un caricamento parziale.';
$string['configdoclang'] = 'La lingua da utilizzare nei link che portano alle pagine della documentazione.';
$string['configdocroot'] = 'Imposta il percorso per aprire Moodle Docs in base al contesto, tramite il link \'Documentazione Moodle di questa pagina\' presente nei piè di pagina. Non impostando il percorso, il link nel piè di pagina non sarà visualizzato.';
$string['configdoctonewwindow'] = 'Abilitando questa opzione, i collegamenti a Moodle Docs verranno visualizzati in una nuova finestra.';
$string['configduration_high'] = 'Il valore è troppo alto. Il valore massimo è {$a}.';
$string['configduration_low'] = 'Il valore è troppo basso. Il valore minimo è {$a}.';
$string['configeditordictionary'] = 'Questo valore sarà utilizzato se lo spell checker aspell non dispone del dizionario corrispondente alla lingua degli utenti.';
$string['configeditorfontlist'] = 'Scegli i font che appariranno nella lista drop-down dell\'editor.';
$string['configemailchangeconfirmation'] = 'Obbliga gli utenti a confermare il cambio di email quando modificano l\'indirizzo di posta elettronica nel proprio profilo.';
$string['configemaildkimselector'] = 'Il selettore DKIM è a scelta ma deve coincidere con quanto presente nel record DNS.';
$string['configemailfromvia'] = 'Consente di aggiungere le informazioni del sito di provenienza nella sezione "From" della email. È utile per rendere nota ai destinatari la provenienza dell\'email ed aiuta a prevenire risposte accidentali ad indirizzi no-reply.';
$string['configemailheaders'] = 'Intestazioni email da inserire sulle email in uscita.';
$string['configemailsubjectprefix'] = 'Testo da utilizzare come prefisso dell\'oggetto delle email in uscita.';
$string['configenableanalytics'] = 'I modelli analitici come \'Studenti a rischio di abbandono\' oppure \'Prossime attività da svolgere\' possono formulare pronostici, inviare notifiche e proporre azioni come ad esempio inviare un messaggio agli utenti.';
$string['configenableblogs'] = 'L\'impostazione attiva  blog personali per tutti gli utenti del sito.';
$string['configenablecalendarexport'] = 'Abilita l\'esportazione o la sottoscrizione ai calendari.';
$string['configenablecomments'] = 'Abilita commenti';
$string['configenablecourserequests'] = 'L\'impostazione consentirà la richiesta di corsi da parte degli utenti che posseggono il privilegio (moodle/course:request). Tale privilegio non è posseduto da nessun ruolo di default e può essere concesso nel contesto di sistema o di categoria.';
$string['configenabledevicedetection'] = 'Abilita il riconoscimento di dispositivi mobili, smartphone, tablet, oppure dispositivi tradizionali (PC desktop, laptop, eccetera) per l\'impostazione dei temi ed altre funzionalità';
$string['configenablemobilewebservice'] = 'Abilita il servizio mobile per la app ufficiale Moodle o per altre app. Per maggiori informazioni leggere {$a}';
$string['configenablerssfeeds'] = 'Attiva il generatore RSS (RSS Feed) del sito. Per poter utilizzare i feed RSS è necessario attivare anche il generatore RSS nei singoli moduli di attività.';
$string['configenablerssfeedsdisabled'] = 'Non è disponibile poiché il generatore RSS è disabilitato a livello di sito. Per attivarlo, andate in \'configura variabili\' nel pannello di Amministrazione.';
$string['configenablerssfeedsdisabled2'] = 'I feed RSS sono disabilitati a livello di sito. Possono essere abilitati nelle funzionalità avanzate da un amministratore del sito.';
$string['configenablestats'] = 'Attivando le statistiche, Moodle elaborerà il log con cadenza giornaliera. La durata dell\'elaborazione dipenderà dal traffico del sito. Le statistiche consentono di visualizzare graficamente dati sui corsi e sul sito.';
$string['configenabletrusttext'] = 'Di default Moodle ripulisce con cura tutti i testi inseriti dagli utenti, al fine di rimuovere ogni possibile script malevolo, oggetto multimediale od altro che possa mettere a repentaglio la sicurezza. Il sistema di Contenuto Affidabile è un modo per dare ad  utenti degni di fiducia la possibilità di usare funzioni evolute nei loro contenuti senza alcuna interferenza. Per attivare il sistema è necessario abilitare l\'impostazione e poi attribuire il privilegio Contenuto Affidabile ad uno specifico ruolo. I testi creati o caricati dagli utenti che hanno tale ruolo saranno contrassegnati come "affidabili" e non saranno ripuliti prima della visualizzazione.';
$string['configenablewebservices'] = 'I Web service consentono ad altri sistemi di collegarsi a Moodle e di effettuare varie operazioni, come ad esempio l\'App Mobile Moodle. Per maggiore sicurezza, abilitare i Web service solo se si ha realmente bisogno di usarli.';
$string['configenablewsdocumentation'] = 'Abilita la generazione automatica della documentazione web service. Un utente web service può accedere alla propria documentazione nella pagina delle chiavi. La documentazione visualizzata è relativa solamente ai protocolli abilitati.';
$string['configerrorlevel'] = 'Imposta il numero di messaggi di errore di PHP che si desidera visualizzare. \'Normale\' è solitamente l\'opzione migliore.';
$string['configexportlookahead'] = 'Giorni futuri da esportare:';
$string['configexportlookback'] = 'Giorni passati da esportare:';
$string['configextendedusernamechars'] = 'Gli utenti potranno utilizzare qualsiasi carattere per il proprio username. L\'impostazione di default consente l\'uso dei soli caratteri alfanumerici minuscoli, carattere di sottolineatura (_), segno meno (-), punto (.) e il simbolo "at" (@).';
$string['configextramemorylimit'] = 'Alcuni script, come la ricerca globale, il backup/ripristino o il cron, richiedono maggiore memoria. Aumentare questo valore per siti di grandi dimensioni.';
$string['configfilterall'] = 'Filtra tutte le stringhe, incluse le intestazioni, titoli, barre di navigazione ecc.
È utile solo se si usa il filtro multilingua, in mancanza del quale si creerà solo carico supplementare sul sito senza vantaggi apprezzabili.';
$string['configfiltermatchoneperpage'] = 'Il filtro di creazione automatica dei link (auto-link) genererà solo il collegamento alla prima occorrenza del testo trovato nella pagina. Tutte le altre saranno ignorate.';
$string['configfiltermatchonepertext'] = 'Il filtro di creazione automatica dei link (auto-link) genererà un solo il collegamento corrispondente alla prima occorrenza di testo trovata (es. risorsa, blocco) nella pagina. Tutte le altre saranno ignorate. L\'impostazione non viene tenuta in considerazione se Filtra occorrenze una volta per pagina è impostato a <i>si</i>.';
$string['configfilternavigationwithsystemcontext'] = 'L\'uso dei filtri è legato al contesto in cui vengono utilizzati (ad es. contesto del corso), tuttavia per migliorare la navigazione del sito quando si filtra l\'intero contesto del sito si suggerisce di impostare il filtraggio a "Contenuto ed intestazioni".';
$string['configfilteruploadedfiles'] = 'Imposta il filtraggio antecedente alla visualizzazione dei file caricati: Tutti i file, Solo file HTML oppure Nessuno.';
$string['configforcelogin'] = 'L\'elenco dei corsi e la pagina home del sito di default sono visibili senza doversi autenticare. Se si desidera obbligare i visitatori ad autenticarsi  prima che possano vedere la pagina home o svolgere una qualsiasi attività sul sito, abilitare questa opzione.';
$string['configforceloginforprofiles'] = 'Rende obbligatoria l\'autenticazione con credenziali valide (non ospite) per  visualizzare i profili di altri utenti. Disabilitando questa impostazione, alcuni utenti potrebbero usare il proprio profilo, visibile pubblicamente, per inserire pubblicità (spam) o altri tipi di contenuti inappropriati.';
$string['configfrontpage'] = 'Gli elementi selezionati sopra saranno visualizzati nella pagina home del sito.';
$string['configfrontpagecourselimit'] = 'Numero massimo di corsi';
$string['configfrontpagecourselimithelp'] = 'Il numero massimo di corsi presenti negli elenchi di corsi visualizzati nella pagina home del sito.';
$string['configfrontpageloggedin'] = 'Gli elementi selezionati sopra saranno visualizzati nella pagina home del sito dopo l\'autenticazione degli utenti,';
$string['configfullnamedisplay'] = 'Imposta la modalità di visualizzazione dei nomi quando vengono visualizzati in forma completa. Il valore di default "language" delega la modalità di visualizzazione alla stringa "fullnamedisplay" contenuta nel language pack in uso. Lingue diverse possono avere convenzioni diverse

Per la maggioranza dei siti mono lingua l\'impostazione preferibile è "firstname lastname", tuttavia è possibile scegliere di nascondere il cognome. I segnaposto che possono essere usati sono: firstname, lastname, firstnamephonetic, lastnamephonetic, middlename, e alternatename.';
$string['configgeoipfile'] = 'La posizione del file binario GeoLite2 City. Questo file non fa parte della distribuzione di Moodle e deve essere scaricato manualmente da <a href="https://www.maxmind.com/">MaxMind</a>. È possibile acquistare la versione commerciale o utilizzare la versione gratuita. Per il download è necessario registrarsi e scaricare il file del database City, cosa che può essere fatta su <a href="https://dev.maxmind.com/geoip/geoip2/geolite2/" >https://dev.maxmind.com/geoip/geoip2/geolite2/</a>. Una volta registrati e scaricato il file, estrarlo nella cartella "{$a}" del proprio server.';
$string['configgetremoteaddrconf'] = 'Se il server si trova dietro un reverse proxy,  tramite questa  impostazione è possibile indicare quali header HTTP possano ritenersi affidabili per gli indirizzi IP remoti. Gli header vengono letti sequenzialmente a partire dal primo disponibile.';
$string['configgradebookroles'] = 'Consente di indicare i ruoli che figureranno nel registro valutatore. È necessario che un utente possegga almeno uno di questi ruoli per figurare nel registro valutatore di un corso.';
$string['configgradeexport'] = 'È possibile scegliere i formati preferiti  da usare per l\'esportazione delle valutazioni. I formati scelti durante l\'esportazione imposteranno il campo "Formati utilizzati recentemente" per ciascun Registro valutatore. Questo aspetto potrebbe far apparire le valutazioni esportate come "nuove" oppure come "aggiornate". Se non si è più che sicuri di come impostare i formati, allora non selezionare nulla.';
$string['confighiddenuserfields'] = 'È possibile nascondere alla vista degli utenti che non abbiano il ruolo di docente/amministratore alcuni dei campi presenti nel profilo utente. Lo scopo è quello di aumentare la privacy degli utenti. Per selezionare più campi tenere premuto il tasto CTRL.';
$string['configidnumber'] = 'L\'opzione imposta se a) non viene richiesto all\'utente il codice identificativo, b) viene richiesto all\'utente il codice identificativo ma può non compilarlo, c) viene richiesto all\'utente il codice identificativo e deve compilarlo obbligatoriamente. Se compilato, il codice identificativo sarà visualizzato nel profilo utente.';
$string['configintro'] = 'In questa pagina si possono specificare un numero di variabili di configurazione che aiutano Moodle a lavorare al meglio.
Non ti preoccupare troppo a riguardo, i valori predefiniti in genere svolgono bene il loro compito e puoi sempre tornare su questa pagina in un secondo momento per modificare le impostazioni.';
$string['configintroadmin'] = 'In questa pagina devi configurare l\'account dell\'Amministratore primario che avrà  il controllo completo sul sito. Assicurati di fornire uno username e una password sicuri, così come un indirizzo email valido. In seguito sarà possibile assegnare il ruolo di amministratore ad  altri account.';
$string['configintrosite'] = 'Questa pagina consente di configurare la pagina home e il nome di questo sito.
In un secondo momento sarà possibile tornare su questa pagina e modificare le impostazioni tramite il menu Amministrazione';
$string['configiplookup'] = 'Quando si clicca su un indirizzo IP (come per es. 34.12.222.93), come riportato nei log, viene visualizzata una mappa con la localizzazione più probabile di quel IP. Ci sono diversi plugin che si possono scegliere per ottenere questo, ciascuno con i suoi pro e contro.';
$string['configkeeptagnamecase'] = 'I tag inseriti manterranno i caratteri maiuscoli/minuscoli.';
$string['configlang'] = 'La lingua di default del sito. Gli utenti che lo desiderano potranno modificare l\'impostazione nel proprio profilo.';
$string['configlanglist'] = 'Lasciare vuoto se si desidera consentire agli utenti di scegliere tra tutte le lingue installate. In alternativa è possibile abbreviare il menu delle lingue inserendo un elenco dei codici lingua separati da virgole, Per esempio: en, es_es, it, fr. È anche possibile visualizzare un nome diverso del language pack utilizzando il seguente formato:  language code|language name, come ad esempio en_kids|English,de_kids|Deutsch.';
$string['configlangmenu'] = 'È possibile scegliere se pubblicare o meno il menù delle lingue generico sulla pagina home, nella pagina di Login, ecc.
La scelta non influisce sulla possibilità  da parte dell\'utente di selezionare la lingua preferita all\'interno del proprio profilo personale.';
$string['configlangstringcache'] = 'Esegue il caching delle stringhe delle lingue in file compilati nella cartella dati, migliorando le prestazioni. Se stai traducendo Moodle o modificando stringhe nel codice sorgente, è preferibile disabilitare il caching. ';
$string['configlatinexcelexport'] = 'Scegli la codifica per le esportazioni Excel.';
$string['configlocale'] = 'Scegli la localizzazione del sito - L\'impostazione avrà  effetto sulla visualizzazione delle date. È necessario avere la stessa localizzazione del server installata sul sistema operativo del proprio computer. (Per esempio: it_IT.UTF-8).
Se non sai come impostare, lascia il campo vuoto.';
$string['configlockrequestcategory'] = 'Se abilitato, gli utenti con la possibilità di richiedere nuovi corsi nel contesto del sistema non potranno selezionare una categoria nel modulo di richiesta di un nuovo corso. Un modo alternativo per limitare gli utenti alla richiesta di un nuovo corso in una sola categoria consiste nell\'applicare la capacità di richiedere nuovi corsi nel contesto della categoria.';
$string['configloglifetime'] = 'L\'impostazione specifica la durata di conservazione dei log dell\'attività degli utenti. I log più vecchi del numero di giorni impostato verranno eliminati automaticamente.
Sebbene sia desiderabile conservare i log il più a lungo possibile, se si dispone di un server sovraccarico o in presenza di problemi di performance, è preferibile abbreviare la durata di conservazione. Impostazioni di 30 giorni o meno non sono consigliate in quanto le statistiche non funzionerebbero correttamente.';
$string['configlookahead'] = 'Giorni futuri da controllare';
$string['configmailnewline'] = 'I caratteri Newline (salto riga) usati nei messaggi di posta. Secondo il RFC 822bis è richiesto il carattere CRLF. Alcuni server di posta convertono automaticamente il carattere LF in CRLF, altri convertono in modo non corretto da CRLF a CRCRLF, altri ancora rifiutano mail con solo LF (qmail per esempio). Se si riscontrano problemi con messaggi non spediti o doppi salti riga, provare a cambiare questa impostazione.';
$string['configmaxbytes'] = 'Imposta la dimensione massima per il caricamento di file. Il valore massimo è limitato dalla variabile PHP  \'upload_max_filesize\' e \'post_max_size\'  e dal valore della variabile \'LimitRequestBody\' di Apache. L\'impostazione a sua volta limita la dimensione massima dei caricamenti nei corsi e nei moduli. Impostando \'Limite server\', sarà usato il valore di caricamento massimo consentito.';
$string['configmaxconsecutiveidentchars'] = 'Le password non devono contenere un numero di caratteri identici e consecutivi maggiori del valore specificato. Per disabilitare questa verifica inserite il valore 0.';
$string['configmaxeditingtime'] = 'Questo parametro specifica il tempo massimo a disposizione degli utenti per per modificare i loro interventi su forum, commenti del glossario, eccetera. Normalmente 30 minuti è un valore adeguato.';
$string['configmaxevents'] = 'Eventi da anticipare';
$string['configmaxusersperpage'] = 'Il numero massimo di utenti visualizzati nelle selezioni di utenti relative a corsi, gruppi, gruppi globali, webservice, eccetera.';
$string['configmessaging'] = 'Abilita il sistema di messaggistica interna';
$string['configmessagingallowemailoverride'] = 'Gli utenti potranno modificare l\'indirizzo email sul quale ricevere le notifiche impostando un indirizzo  diverso rispetto a quello memorizzato nel proprio profilo utente.';
$string['configmessagingallusers'] = 'Gli utenti porranno visualizzare l\'elenco degli utenti del sito e scegliere a chi inviare un messaggio così come potranno impostare le proprie preferenze per ricevere messaggi da tutti gli utenti del sito. Disabilitando l\'impostazione, gli utenti potranno visualizzare solamente i partecipanti ai corsi dove sono iscritti e le preferenze dei messaggi offriranno solo due possibilità, accettare messaggi solamente dai propri contatti oppure da tutti i partecipanti ai corsi.';
$string['configmessagingdefaultpressenter'] = 'Nelle preferenze utente della messaggistica sarà abilitato per default la spedizione del messaggio premendo il tasto invio';
$string['configmessagingdeleteallnotificationsdelay'] = 'Le notifiche lette o non lette possono essere eliminate per ridurre lo spazio occupato. Èpossibile specificare per quanto tempo conservare le notifiche dopo la creazione.';
$string['configmessagingdeletereadnotificationsdelay'] = 'Le notifiche lette possono essere eliminate per ridurre lo spazio occupato. È possibile specificare per quanto tempo conservare le notifiche lette prima di eliminarle.';
$string['configminpassworddigits'] = 'Le password devono avere almeno questo numero di caratteri numerici.';
$string['configminpasswordlength'] = 'Le password devono essere lunghe almeno questo numero di caratteri.';
$string['configminpasswordlower'] = 'Le password devono avere almeno questo numero di lettere minuscole.';
$string['configminpasswordnonalphanum'] = 'Le password devono avere almeno questo numero di caratteri non alfanumerici.';
$string['configminpasswordupper'] = 'Le password devono avere almeno questo numero di lettere maiuscole.';
$string['configmycoursesperpage'] = 'Numero massimo di corsi presenti nell\'elenco dei corsi ai quali si è iscritti.';
$string['configmymoodleredirect'] = 'L\'impostazione reindirizza gli utenti non amministratori a /my dopo il login, sostituendo anche la navigazione verso la pagina home con /my';
$string['configmypagelocked'] = 'L\'impostazione impedisce la modifica della pagina di default da parte di utenti che non abbiamo il ruolo di amministratori';
$string['confignavcourselimit'] = 'Limita il numero di corsi visibili agli utenti nella navigazione.';
$string['confignavshowallcourses'] = 'L\'impostazione stabilisce se gli utenti iscritti ad almeno un corso possano visualizzare la voce Corsi (elenco di tutti corsi) nella Navigazione. Tale voce sarà visualizzata in aggiunta alla voce I miei corsi (elenco dei corsi ai quali l\'utente è iscritto).';
$string['confignavshowcategories'] = 'Visualizza le categorie di corso nelle briciole e nella Navigazione. Le categorie non saranno visualizzate nei corsi dove l\'utente è iscritto, che saranno elencati nel link I miei corsi.';
$string['confignoreplyaddress'] = 'In genere le email vengono spedite a nome di un utente (ad esempio, gli interventi nei forum). L\'indirizzo di email No-reply verrà  utilizzato come mittente del messaggio nei casi in cui il destinatario non può rispondere direttamente al mittente (ad esempio quando un utente decide di non visualizzare il proprio indirizzo email).';
$string['confignotifyloginfailures'] = 'È possibile inviare avvisi sui login errati agli utenti selezionati. Prerequisito è l\'abilitazione di un log store interno (Ad esempio il log store standard)';
$string['confignotifyloginthreshold'] = 'Se è stata attivata la notifica dei login errati, l\'impostazione consente di definire il numero di login errati raggiunto il quale sarà inviata la mail di avviso.';
$string['confignotloggedinroleid'] = 'Ai visitatori (utenti non autenticati nel contesto del sito) sarà attribuito il ruolo indicato. Per i visitatori non dovreste scegliere nulla di diverso dal ruolo di Ospite, in ogni caso avete la possibilità di creare nuovi ruoli per i visitatori, con autorizzazioni diverse. Alcune attività, come ad esempio intervenire in un forum, richiederanno comunque all\'utente di autenticarsi.';
$string['configopentowebcrawlers'] = 'Google potrà entrare nel tuo sito come Ospite. Inoltre, coloro che tramite Google raggiungeranno il sito saranno autenticati automaticamente come Ospite. Da notare che l\'impostazione fornisce un accesso trasparente solo a quei corsi che già consentono l\'accesso agli ospiti.';
$string['configoverride'] = 'Definito in config.php';
$string['configpasswordpolicy'] = 'Le password degli utenti dovranno soddisfare alle regole impostate. L\'abilitazione delle regole password non influenzerà gli utenti già esistenti fin quando non decideranno o saranno obbligati a cambiare la propria password, oppure dopo l\'abilitazione dell\'impostazione \'Verifica password durante l\'autenticazione\'.';
$string['configpasswordpolicycheckonlogin'] = 'Durante l\'autenticazione le password degli utenti saranno controllate per verificare la rispondenza alle regole password. Se il controllo non dovesse andare a buon fine, l\'utente sarà obbligato a cambiare la propria password. L\'impostazione è particolarmente utile dopo una modifica delle regole password.';
$string['configpasswordresettime'] = 'Il tempo massimo entro il quale deve essere validata la richiesta di recupero password. In genere 30 minuti è un valore adeguato.';
$string['configpathtodu'] = 'Percorso di du, in genere /usr/bin/du. Impostando il percorso, le pagine che visualizzano il contenuto delle cartelle con molti file verranno elaborate più velocemente.';
$string['configpathtophp'] = 'Percorso del CLI PHP, ad esempio /usr/bin/php. Impostando il percorso gli script del cron potranno essere lanciati dall\'interfaccia amministrativa.';
$string['configperfdebug'] = 'Consente la visualizzazione di informazioni sulle prestazioni nel piè di pagina del tema standard';
$string['configprofileroles'] = 'Ruoli elencati nelle pagine del profilo utente e della partecipazione.';
$string['configprofilesforenrolledusersonly'] = 'Per evitare abusi da parte di spammer, non verranno visualizzate le descrizioni dei profili degli utenti non iscritti a corsi. I nuovi utenti potranno aggiungere la  descrizione nel profilo solo dopo essere stati iscritti ad almeno un corso.';
$string['configprotectusernames'] = 'La pagina di recupero password di default non visualizza elementi che possano aiutare ad indovinare username o email di utenti.';
$string['configproxybypass'] = 'Elenco separato da virgole dei nomi degli host o degli IP (anche parziali) che possono evitare il proxy (ad esempio, 192.168., .mydomain.com)';
$string['configproxyfixunsafe_help'] = 'Questo tenta di correggere le chiamate interne che non passano attraverso il proxy aggiungendo lo user agent MoodleBot e utilizzando il proxy.';
$string['configproxyhost'] = 'Se questo <b>server</b> ha bisogno di un  di un proxy (o di un firewall) per accedere a Internet, specificate il nome del proxy. Se non usate proxy, non compilate questo campo.';
$string['configproxylogunsafe_help'] = 'Questo tenta di registrare le chiamate interne che non passano attraverso il proxy e che invece dovrebbero farlo.';
$string['configproxypassword'] = 'Password per accedere a internet attraverso il proxy, lasciare vuoto se non utilizzata (è necessaria l\'estensione PHP cURL).';
$string['configproxyport'] = 'Specificate la porta usata dal proxy per accedere ad Internet';
$string['configproxytype'] = 'Tipo di proxy (per il supporto SOCKS5 sono necessari il PHP5 e l\'estensione cURL ).';
$string['configproxyuser'] = 'Username abilitato ad accedere ad internet attraverso il proxy, lasciare vuoto se non utilizzato (è necessaria l\'estensione PHP cURL).';
$string['configrecaptchaprivatekey'] = 'Stringa di caratteri (chiave privata) usata per la comunicazione tra il proprio server Moodle e il server recaptcha. È possibile richiedere le chiavi reCAPTCHA visitando il sito <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrecaptchapublickey'] = 'Stringa di caratteri (chiave del sito) usata per visualizzare l\'elemento reCAPTCHA nella pagina di creazione account e nella pagina di supporto. È possibile richiedere le chiavi reCAPTCHA visitando il sito <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrequestedstudentname'] = 'Termine per \'studente\' da utilizzare nel corsi richiesti';
$string['configrequestedstudentsname'] = 'Termine per \'studenti\' da utilizzare nel corsi richiesti';
$string['configrequestedteachername'] = 'Termine per \'docente\' da utilizzare nel corsi richiesti';
$string['configrequestedteachersname'] = 'Termine per \'docenti\' da utilizzare nel corsi richiesti';
$string['configreverseproxyignore'] = 'Qualora il server si trovi dietro uno o più reverse proxy che aggiungono l\'header  X-Forwarded-For, allora è necessario inserire l\'elenco degli indirizzi ip o delle subnet dei reverse proxy che dovranno essere ignorati al fine di individuare correttamente l\'indirizzo IP degli utenti.';
$string['configsectioninterface'] = 'Interfaccia';
$string['configsectionmail'] = 'Posta';
$string['configsectionmaintenance'] = 'Manutenzione';
$string['configsectionmisc'] = 'Miscellanea';
$string['configsectionoperatingsystem'] = 'Sistema operativo';
$string['configsectionpermissions'] = 'Permessi';
$string['configsectionrequestedcourse'] = 'Richieste di corsi';
$string['configsectionsecurity'] = 'Sicurezza';
$string['configsectionstats'] = 'Statistiche';
$string['configsectionuser'] = 'Utente';
$string['configsecureforms'] = 'Moodle può utilizzare un livello aggiuntivo di sicurezza nell\'accettazione di dati provenienti da form web. Se attivata, la variabile HTTP_REFERER del browser è confrontata con l\'indirizzo del form in uso. In alcuni rari casi questo può causare problemi se l\'utente sta utilizzando un firewall (ad esempio Zonealarm) configurato per rimuovere HTTP_REFERER dal suo traffico web. Uno dei sintomi è rimanere \'bloccato\' su di un form. Ad esempio, se gli utenti dovessero avere problemi con la pagina di login , è possibile disabilitare questa impostazione, anche se ciò potrebbe esporre il  sito ad attacchi con forzature di password. In caso di dubbio, lasciare l\'impostazione a \'Si\'.';
$string['configservicespage'] = 'Inserire l\'URL di una pagina di servizi e assistenza o lasciare vuoto per collegarsi ai servizi Moodle su moodle.com. Il link viene visualizzato solo agli amministratori.';
$string['configsessioncookie'] = 'È possibile personalizzare il prefisso del cookie usato per identificare le sessioni di Moodle. Questa impostazione è opzionale ma è indispensabile se più istanze di Moodle girano sul medesimo sito web.';
$string['configsessioncookiedomain'] = 'Consente di cambiare il dominio dal quale provengono i cookie di Moodle. È utile per alcune personalizzazioni di Moodle (ad esempio plugin di autenticazione o di iscrizione) per le quali si rende necessario scambiare le informazioni di sessione con applicazioni web o con sotto domini. <strong>ATTENZIONE: si consiglia di lasciare l\'impostazione al suo default (vuoto) - valori errati potrebbero impedire qualsiasi login al sito.</strong>';
$string['configsessioncookiepath'] = 'È possibile personalizzare dove i browser inviano i cookie di Moodle specificando una sotto cartella del sito web. In genere il default \'/\' dovrebbe andare bene.';
$string['configsessiontimeout'] = 'la sessione degli utenti autenticati che non svolgono attività per un dato periodo di tempo (ad esempio caricare pagine), viene conclusa automaticamente. Questa variabile specifica il tempo massimo di inattività oltre la quale la sessione sarà considerata conclusa.';
$string['configsessiontimeoutwarning'] = 'Le persone autenticate che rimangono inattive per un lungo periodo (senza caricare pagine), dopo un certo tempo verranno avvisate che la loro sessione sta per terminare . Questa variabile definisce l\'intervallo di tempo di inattività che dovrà trascorrere prima dell’avviso.';
$string['configsessiontimeoutwarningcheck'] = 'L\'avviso di timeout della sessione deve essere inferiore al timeout della sessione';
$string['configshowcommentscount'] = 'Visualizza il numero di commenti. Richiederà una query supplementare per visualizzare i link ai commenti.';
$string['configshowicalsource'] = 'Visualizza informazioni sull\'origine degli eventi iCal';
$string['configshowsiteparticipantslist'] = 'Tutti gli studenti di questo sito e i docenti del sito saranno visualizzati nell\'elenco dei partecipanti. Chi è abilitato a visualizzare la lista dei partecipanti di questo sito?';
$string['configsitedefaultlicense'] = 'Licenza di default del sito';
$string['configsitedefaultlicensehelp'] = 'La licenza di default sarà quella usata per pubblicare contenuti in questo sito';
$string['configsitemailcharset'] = 'Tutte le email generate dal sito saranno inviate utilizzando il set di caratteri impostato. In ogni caso abilitando l\'impostazione seguente, ciascun utente potrà impostare il set di caratteri preferito.';
$string['configsitemaxcategorydepth'] = 'Numero max. sotto categorie';
$string['configsitemaxcategorydepthhelp'] = 'La profondità massima di sotto categorie visualizzate aperte nelle pagine contenenti elenchi di categorie o  elenchi combinati. Le sotto categorie nidificate più profondamente del valore impostato saranno visualizzate come link e potranno essere aperte tramite richieste AJAX.';
$string['configslasharguments'] = 'L\'impostazione \'slash arguments\' (che utilizza <em>PATH_INFO</em>) è necessaria per eseguire pacchetti SCORM e per visualizzare correttamente risorse con più file. Qualora il web server dove è installato Moodle non supporti gli \'slash arguments\' è possibile disabilitare l\'impostazione sebbene questo comporterà il mancato funzionamento di alcuni elementi.<br />Nota: l\'impostazione \'slash arguments\' diventerà obbligatoria in future versioni di Moodle.';
$string['configsmartpix'] = 'Con questa impostazione, le icone sono gestite tramite uno script PHP che le cerca prima nel tema grafico corrente, poi in tutti i temi a livello superiore i quindi nella cartella di Moodle /pix. Questo riduce il bisogno di duplicare le immagini all\'interno dei temi, anche se con un piccolo costo di performance.';
$string['configsmtpauthtype'] = 'Il tipo di autenticazione utilizzata dal server SMTP.';
$string['configsmtphosts'] = 'È possibile impostare il nome di uno o più server SMTP che Moodle potrà utilizzare per inviare mail (ad esempio \'mail.a.com\' oppure \'mail.a.com;mail.b.com\'). Per configurare una porta non di default (diversa dalla 25) è possibile utilizzare la sintassi [server]:[port] (ad esempio \'mail.a.com:587\'). Per connessioni sicure, in genere viene utilizzata la porta 465 con SSL e la porta 587 con TLS. Se necessario è possibile specificare il protocollo utilizzato.  In mancanza di informazioni sul server SMTP, Moodle utilizzerà  il metodo di spedizione mail predefinito in PHP.';
$string['configsmtpmaxbulk'] = 'Massimo numero di messaggi inviati per sessione SMTP. Raggruppare i messaggi può velocizzare l\'invio delle email. Valori inferiori a 2 forzano la creazione di una nuova sessione SMTP per ogni email.';
$string['configsmtpoauthservice'] = 'Selezionare il servizio OAuth2 autorizzato a comunicare con il server SMTP. È necessario aver già configurato tale servizio. Da notare che l’autenticazione SMTP dovrà essere impostata a XOAUTH2.';
$string['configsmtpsecure'] = 'Se il server smtp richiede connessioni sicure, è necessario specificare il protocollo corretto.';
$string['configsmtpuser'] = 'Se è stato impostato un server SMTP che richiede l\'autenticazione, è possibile indicare lo username e la password.';
$string['configstartwday'] = 'Inizio settimana';
$string['configstatsfirstrun'] = 'Questa impostazione definisce, per la <b>prima elaborazione</b> delle statistiche dei log, da quanto indietro nel tempo devono essere elaborati i log. Se avete molto traffico e non avete un server dedicato, probabilmente non è una buona idea tornare troppo indietro nel tempo, l\'elaborazione potrebbe essere abbastanza lunga ed esosa in termini di risorse necessarie. (Notare che nell\'impostazione , 1 mese = 28 giorni. Nei grafici e nei report generati, 1 mese = 1 mese del calendario.)';
$string['configstatsmaxruntime'] = 'L\'elaborazione delle statistiche può essere abbastanza lunga. Utilizzate una combinazione di questo e del prossimo campo per definire quando farla partire e per quanto tempo.';
$string['configstatsmaxruntime2'] = 'L\'elaborazione delle statistiche può essere molto onerosa. Puoi specificare il tempo massimo consentito per accumulare un giorno di statistiche. Il numero massimo di giorni elaborati nell\'esecuzione di un cron è 31.';
$string['configstatsmaxruntime3'] = 'Definisce il tempo massimo consentito per l\'elaborazione delle statistiche di un giorno. Va tenuto presente che l\'elaborazione delle statistiche è molto onerosa per il server. Il numero massimo di giorni da elaborare tramite cron può essere impostato sotto.';
$string['configstatsruntimedays'] = 'Definisce il numero massimo di giorni da elaborare. Se le statistiche sono aggiornate, viene elaborato solamente un giorno. Devi impstare questo parametro in funzione del carico sul server ed eventualmente ridurlo se sono preferibili elaborazioni più brevi.';
$string['configstatsruntimestart'] = 'Orario di avvio dell\'elaborazione tramite cron. Se nello stesso server sono installate più istanze Moodle, si suggerisce di specificare orari di avvio diversi per ciascuna istanza.';
$string['configstatsuserthreshold'] = 'Specifica il numero minimo di utenti necessario per includere il corso nel computo delle statistiche.';
$string['configstrictformsrequired'] = 'Nelle maschere con campi obbligatori gli utenti non potranno inserire spazi bianchi o interruzioni di linea.';
$string['configstripalltitletags'] = 'Per consentire l\'uso di tag HTML nei nomi delle risorse e delle attività è necessario deselezionare questa opzione.';
$string['configsupportavailability'] = 'Imposta l\'accesso al form i supporto tramite il piè di pagina.';
$string['configsupportemail'] = 'Se è stato configurato un SMTP e la pagina di supporto non è impostata, questo indirizzo email riceverà i messaggi spediti attraverso il form di supporto. Qualora l\'invio del messaggio dovesse fallire, agli utenti autenticati email sarà visualizzato questo indirizzo email.';
$string['configsupportname'] = 'Il nome della persona o della organizzazione che fornisce supporto tramite un form o una pagina.';
$string['configsupportpage'] = 'Inserire l\'URL di una pagina di supporto, lasciare bianco per collegare al form di contatto. Il link viene visualizzato nel piè di pagina.';
$string['configtempdatafoldercleanup'] = 'Elimina dalla cartella \'moodledata\' i file temporanei più vecchi del periodo di tempo impostato';
$string['configthemedesignermode'] = 'Le immagini ed i CSS appartenenti al tema sono conservati nella cache del browser e del server per un periodo di tempo molto lungo. Se stai sviluppando od ottimizzando un tema, attiva questa impostazione utile anche per gli sviluppatori di codice. È anche possibile annullare manualmente la cache del tema nella pagina di selezione temi. ATTENZIONE: la modalità theme designer ha un impatto negativo sulle performance del server!';
$string['configthemelist'] = 'Consente di abbreviare il menu di selezione dei temi specificando i nomi dei temi separati da virgole.Lasciando il campo vuoto sarà possibile selezionare qualsiasi tema installato. Esempio: standard,orangewhite.';
$string['configtimezone'] = 'È possibile impostare il fuso orario di default da utilizzare per la visualizzazione delle date. Ciascun utente nel proprio profilo potrà poi scegliere il fuso orario preferito. È necessario modificare l\'impostazione se viene visualizzato "Fuso orario non valido"';
$string['configuseblogassociations'] = 'Consente agli utenti di organizzare i propri blog associandoli ai cori ed ai moduli di attività.';
$string['configusesitenameforsitepages'] = 'Consente di usare il nome abbreviato del sito per il nodo pagine del sito nella Navigazione. Il nome del sito sostituirà la stringa "Pagine del sito"';
$string['configusetags'] = 'Abilita la funzionalità Tag nel sito.';
$string['configvariables'] = 'Variabili';
$string['configverifychangedemail'] = 'Abilita la funzione di verifica degli indirizzi di posta elettronica quando gli utenti nel loro profilo modificano l\'email. La verifica viene effettuata sulla base delle liste di domini presenti nelle impostazioni Domini di posta autorizzati e Domini di posta non autorizzati. Se questa impostazione è disabilitata, la verifica dei domini autorizzati verrà operata solo durante la creazione di nuovi account.';
$string['configvisiblecourses'] = 'Consente la visualizzazione e l\'accesso ai corsi presenti in categorie di corso nascoste.';
$string['configwarning'] = 'Fate attenzione a modificare queste impostazioni, valori anomali potrebbero causare problemi.';
$string['configyuicomboloading'] = 'L\'impostazione abilita il caricamento combinato ottimizzato dei file delle librerie YUI. Per motivi di performace l\'impostazione dovrebbe essere attiva nei siti in produzione.';
$string['confirmation'] = 'Conferma';
$string['confirmcontextlock'] = 'Il contesto {$a->contextname} è scongelato. Congelandolo, diventerà a sola lettura e gli utenti non potranno apportare modifiche. Sei sicuro di continuare?';
$string['confirmcontextunlock'] = 'Il contesto {$a->contextname} è congelato. Scongelandolo, gli utenti potranno apportare modifiche. Sei sicuro di continuare?';
$string['confirmdeletecomments'] = 'Sei sicuro di eliminare i commenti selezionanti?';
$string['confirmed'] = 'Confermato';
$string['contactsitesupport'] = 'Contatta il supporto';
$string['contenttypeuninstalling'] = 'Sono presenti {$a->count} contenuti supportati da {$a->type}, Saranno eliminati. Sei sicuro di continuare?';
$string['contextlockappliestoadmin'] = 'Applica congelamento contesti agli amministratori';
$string['contextlockappliestoadmin_desc'] = 'Disabilitando l\'impostazione, gli amministratori manterranno l\'accesso in scrittura sui contesti congelati.';
$string['contextlocking'] = 'Congelamento contesti';
$string['contextlocking_desc'] = 'Abilita l\'accesso in sola lettura per specifiche categorie, corsi, attività e blocchi.';
$string['cookiesecure'] = 'Solo cookie sicuri';
$string['country'] = 'Paese di default';
$string['course_customfield'] = 'Campi personalizzati del corso';
$string['coursecolor'] = 'Colore {$a}';
$string['coursecolorheading_desc'] = 'I corsi dove nelle impostazioni non è stata caricata un\'immagine, verranno visualizzati nella dashboard con un riquadro contenete un motivo. In questa pagina è possibile impostare i colori che saranno utilizzati per creare il motivo.';
$string['coursecolorsettings'] = 'Colori del riquadro dei corsi';
$string['coursecontact'] = 'Gestori dei corsi';
$string['coursecontact_desc'] = 'È possibile indicare quali ruoli far comparire nella descrizione dei corsi. Affinché il nome di un utente compaia nella descrizione di un corso, l\'utente dovrà avere almeno uno dei ruoli qui impostati.';
$string['coursecontactduplicates'] = 'Visualizza tutti i gestori dei corsi';
$string['coursecontactduplicates_desc'] = 'Gli utenti che posseggono più di uno dei ruoli impostati come gestori dei corsi saranno visualizzati nelle descrizione dei corsi con ciascuno dei ruoli posseduti. Diversamente saranno elencati con il ruolo posseduto che è posizionato più in alto nella Gestione ruoli.';
$string['coursecreationguide'] = 'URL della guida della creazione corso Moodle';
$string['coursecreationguide_help'] = 'Definisce il percorso di una guida rapida con brevi video e consigli generali per creare corsi. Un link alla guida viene visualizzato nella pagina I miei corsi quando non ci sono corsi da visualizzare. Solo gli utenti con il privilegio di creare corsi vedranno il link.';
$string['coursegraceperiodafter'] = 'Periodo di tolleranza per i corsi passati';
$string['coursegraceperiodbefore'] = 'Periodo di tolleranza per i corsi futuri';
$string['courselistshortnames'] = 'Visualizza titoli dei corsi estesi';
$string['courselistshortnames_desc'] = 'Consente la visualizzazione del titolo del corso assieme al titolo abbreviato del corso sia nella visualizzazione degli elenchi dei corsi sia nella pagine di amministrazione dove sono presenti titoli di corsi. Se l\'impostazione è attiva, la visualizzazione dei titoli dei corsi utilizzerà la stringa \'courseextendednamedisplay\', che può essere modificata secondo necessità personalizzando il language pack.';
$string['coursemgmt'] = 'Gestione corsi e categorie';
$string['courseoverview'] = 'Panoramica sui corsi';
$string['coursepage'] = 'Pagina del corso';
$string['courserequestnotify'] = 'Avvertire in caso di richieste';
$string['courserequestnotifyemail'] = 'L\'utente {$a->user} ha presentato richiesta per il corso <a href="{$a>link}">{$a->link}</a>';
$string['courserequests'] = 'Corsi che sono stati richiesti';
$string['courserequestspending'] = 'Richieste di nuovi corsi da approvare';
$string['courses'] = 'Corsi';
$string['coursesperpage'] = 'Corsi per pagina';
$string['courseswithsummarieslimit'] = 'Numero limite di corsi visualizzati in presenza di  introduzione';
$string['creatornewroleid'] = 'Ruolo del creatore di corsi nei nuovi corsi';
$string['creatornewroleid_help'] = 'Se l\'utente non ha il privilegio di gestire nuovi corsi, allora verrà iscritto al corso con questo ruolo.';
$string['cron'] = 'Cron';
$string['cron_enabled'] = 'Abilita cron';
$string['cron_enabled_desc'] = 'Consente di interrompere le elaborazioni pianificate. Da utilizzare solo temporaneamente, ad esempio per un riavvio. Interrompere troppo a lungo il funzionamento del cron  impedirà il buon funzionamento del sito ed è da evitare per non compromettere funzionalità fondamentali.';
$string['cron_help'] = 'Lo script con.php esegue una serie di operazioni ad intervalli regolari, come ad esempio inviare mail dei nuovi interventi sui forum. È indispensabile che lo script giri automaticamente e con regolarità, possibilmente ogni minuto.';
$string['cron_keepalive'] = 'Keep alive';
$string['cron_keepalive_desc'] = 'Il periodo di tempo per mantenere il polling per elaborazioni aggiuntive. Questa impostazione serve a garantire che cron sia sempre in esecuzione. Se si usano task runner dedicati, impostarlo a 0. Altrimenti, impostarlo a un valore simile a quello del limite di concorrenza dei task adhoc. Evitare tempi più lunghi. Il tempo massimo è di 15 minuti.';
$string['cron_link'] = 'admin/cron';
$string['cronclionly'] = 'Esecuzione cron solamente da linea comando';
$string['cronerrorclionly'] = 'Spiacente, l\'accesso via internet a questa pagina web è stato disabilitato dall\'amministratore.';
$string['cronerrorpassword'] = 'Spiacente, non è stata fornita una password valida per accedere a questa pagina.';
$string['croninfrequent'] = 'Sono trascorsi {$a->actual} tra le ultime elaborazioni del cron che invece dovrebbe girare ogni {$a->expected}. Si raccomanda di configurare il cron affinché giri più frequentemente.';
$string['cronremotepassword'] = 'Cron password per accesso remoto';
$string['cronwarning'] = 'Lo script <a href="{$a->url}">admin/cron.php</a> non è stato eseguito da {$a->actual} e dovrebbe girare ogni {$a->expected}.';
$string['cronwarningcli'] = 'Lo script code>admin/cli/cron.php</code> non è stato eseguito da {$a->actual} e dovrebbe girare ogni {$a->expected}.';
$string['cronwarningnever'] = 'Lo script code>admin/cli/cron.php</code> non è stato mai eseguito e dovrebbe girare ogni {$a->expected}.';
$string['cronwarningneverweb'] = 'Lo script <a href="{$a->url}">admin/cron.php</a> nonha mai girato, dovrebbe girare ogni {$a->expected}.';
$string['ctyperequired'] = 'L\'estensione ctype PHP è richiesta da Moodle, per migliorare le performance del sito e offrire compatibilità multilingua.';
$string['curlcache'] = 'cURL cache TTL';
$string['curlrequired'] = 'L\'estensione PHP cURL è ora necessaria a Moodle per comunicare  con i repostory Moodle.';
$string['curlsecurityallowedport'] = 'Elenco porte consentite per cURL';
$string['curlsecurityallowedportsyntax'] = 'Elenco delle porte alle quali cURL può collegarsi. Le voci valide sono solo numeri interi. Inserire ogni voce su una nuova riga. Se l\'impostazione viene lasciata vuota, il collegamento sarà consentito su tutte le porte Se l’impostazione viene compilata, in quasi tutti i casi dovranno essere specificate sia la porta 443 sia la 80 affinché cURL si colleghi alle porte standard HTTPS e HTTP .';
$string['curlsecurityblockedhosts'] = 'Elenco host bloccati per cURL';
$string['curlsecurityblockedhostssyntax'] = 'Inserire un IP per ogni linea. Èpossibile inserire un indirizzo IPv4 o IPv6 completo (ad esempio 192.168.10.1, 0:0:0:0:0:0:0:1, ::1, fe80::) di un singolo host, oppure una notazione CIDR (ad esempio 231.54.211.0/20 o fe80::/64), oppure un intervallo di IP (ad esempio 231.3.56.10-20 o fe80::1111-bbbb) dove l\'intervallo si riferisce all\'ultimo gruppo di indirizzi, oppure nomi di dominio (ad esempio localhost o example.com), oppure domini contenenti caratteri jolly (ad esempio *.example.com o *.sub.example.com). Linee vuote non sono consentite.';
$string['curlsecurityurlblocked'] = 'L\'URL è bloccata.';
$string['curltimeoutkbitrate'] = 'Bitrate da usare per calcolare il timeout del cURL (kbps)';
$string['curltimeoutkbitrate_help'] = 'L\'impostazione è utilizzata per calcolare il  timeout appropriato durante richieste cURL molto grandi. Il calcolo viene effettuato effettuando una request HTTP HEAD per conoscere la dimensione del contenuto. Impostando il valore a 0 , la request non verrà effettuata.';
$string['currenttheme'] = 'Tema in uso';
$string['customcheck'] = 'Altri controlli';
$string['custommenu'] = 'Menu personalizzato';
$string['custommenuitems'] = 'Elementi menu personalizzato';
$string['customusermenuitems'] = 'Elementi menu utente';
$string['datarootsecurityerror'] = '<p><strong>AVVISO PER LA SICUREZZA!</strong></p><p>La tua cartella dataroot directory è in una posizione sbagliata ed è esposta al web. Questo significa che tutti i tuoi file privati sono accessibili da chiunque nel mondo, e qualcuno di questi potrebbe essere usato da un cracker per ottenere un accesso non autorizzato come amministratore del tuo sito!</p>
<p><em>Devi</em> spostare la cartella dataroot ({$a}) in un\'altra posizione che non sia nella cartella pubblica per il web, e aggiornare di conseguenza l\'impostazione <code>$CFG->dataroot</code> nel tuo config.php.</p>';
$string['datarootsecuritywarning'] = 'La configurazione del tuo sito potrebbe non essere al sicuro. Accertati che la tua cartella dataroot ({$a}) non sia direttamente accessibile via web.';
$string['dbprefixtoolong'] = 'Il prefisso del database del sito ($CFG->prefisso) è troppo lungo ({$a->current} caratteri). Il numero massimo di caratteri consentiti è {$a->maximum}.';
$string['dbsessions'] = 'Usa il database per le informazioni di sessione';
$string['debug'] = 'Livello di debug';
$string['debugall'] = 'TUTTI: Visualizza i più significativi messaggi di debug del PHP';
$string['debugdeveloper'] = 'SVILUPPATORE: messaggi extra di debug per sviluppatori Moodle';
$string['debugdisplay'] = 'Visualizza messaggi di debug';
$string['debugging'] = 'Debugging';
$string['debugminimal'] = 'MINIMO: Visualizza solo gli errori irreversibili';
$string['debugnone'] = 'NESSUNO: Non visualizzare errori né warning';
$string['debugnormal'] = 'NORMALE: Visualizza errori, warning e notice';
$string['debugpageinfo'] = 'Visualizza le informazioni di pagina';
$string['debugsqltrace'] = 'Visualizza fonte delle chiamate SQL';
$string['debugsqltrace1'] = 'Visualizza una singola linea di chiamata';
$string['debugsqltrace100'] = 'Visualizza full stack trace';
$string['debugsqltrace2'] = 'Visualizza 2 linee full stack trace';
$string['debugsqltrace_desc'] = 'Consento di aggiungere al commento SQL uno stack trace PHP completo o parziale.';
$string['debugstringids'] = 'Visualizza la provenienza delle stringhe della lingua';
$string['debugstringids_desc'] = 'Consente la facilitazione del lavoro dei traduttori: attivando l\'impostazione e posponendo all\'URL il parametro &strings=1 o ?strings=1, verrà visualizzata la provenienza di ciascuna  stringa della lingua.';
$string['debugtemplateinfo'] = 'Visualizza informazioni sul modlello';
$string['debugtemplateinfo_desc'] = 'Consente di visualizzare i modelli usati per il rendering come commenti nell\'HTML della pagina. Dopo aver modificato l\'impostazione, è necessario eliminare le cacheUtilizzare solo per il debug temporaneo poiché produrrà errori di validazione dell\'HTML e potrebbe interrompere alcuni script della pagina.';
$string['debugvalidators'] = 'Visualizza i link ai validator';
$string['defaultcity'] = 'Città di default';
$string['defaultcity_help'] = 'La città utilizzata di default durante la creazione di nuovi account.';
$string['defaultformatnotset'] = 'Si è verificato un errore durante l\'individuazione del formato di corso di default. Per favore controlla le impostazioni del sito.';
$string['defaulthomepage'] = 'Pagina iniziale degli utenti';
$string['defaultrequestcategory'] = 'Categoria per i corsi a richiesta';
$string['defaultsettinginfo'] = 'Default: {$a}';
$string['defaultuserroleid'] = 'Ruolo di default per tutti gli utenti';
$string['deleteincompleteusers'] = 'Elimina gli utenti con profilo non completato dopo';
$string['deleteunconfirmed'] = 'Elimina gli utenti non confermati dopo';
$string['deleteuser'] = 'Elimina l\'utente';
$string['density'] = 'Densità';
$string['denyemailaddresses'] = 'Domini di posta non autorizzati';
$string['development'] = 'Sviluppo';
$string['devicedetectregex'] = 'Regular expression per il riconoscimento del dispositivo';
$string['devicedetectregex_desc'] = '<p>Di default Moodle è in grado di riconoscere dispositivi tradizionali (PC desktop, laptop, ecc.), dispositivi mobili (telefoni e palmari), tablet (iPad e tablet Android) e dispositivi obsoleti (utenti di Internet Explorer 6). Il selettore tema può essere utilizzato per scegliere quale tema utilizzare in base al dispositivo riconosciuto. L\'impostazione consente l\'uso di regular expression per l\'individuazione di ulteriori dispositivi (che avranno la precedenza rispetto ai dispositivi di default).</p>
<p>Per esempio puoi utilizzare la regular expression \'/(MIDP-1.0|Maemo|Windows CE)/\' per riconoscere alcuni dispositivi di uso frequente e riportare il valore "featurephone". Tale impostazione farà comparire "featurephone" nel Selettore tema consentendoti di usare il tema appropriato al dispositivo. Gli altri telefoni useranno il tema scelto per i dispositivi Mobili.</p>';
$string['devicedetectregexexpression'] = 'Regular expression';
$string['devicedetectregexvalue'] = 'Valore di ritorno';
$string['devicetype'] = 'Tipo di dispositivo';
$string['devlibdirpresent'] = 'Cartelle con librerie di sviluppo come <em>vendor</em> oppure <em>node_modules</em> non devono essere presenti su siti pubblici. Per ulteriori informazioni, consultare il <a href="{$a->moreinfourl}">report sulla sicurezza</a>.';
$string['disabled'] = 'Disabilitato';
$string['disableplugin'] = 'Disabilita {$a}';
$string['disableuserimages'] = 'Disabilita immagini profilo utente';
$string['displayerrorswarning'] = 'Abilitare l\'impostazione PHP <em>display_errors</em> non è raccomandato sui siti di produzione perché alcuni messaggi di errore potrebbero rivelare informazioni sensibili del tuo server.';
$string['displayloginfailures'] = 'Visualizza login errati';
$string['divertallemails'] = 'Deviazione email';
$string['divertallemailsdetail'] = 'Utile in ambienti di test per provare le email. Da non utilizzare in produzione.';
$string['divertallemailsexcept'] = 'Eccezioni alle deviazione email';
$string['divertallemailsexcept_desc'] = 'Elenco di eccezioni email in forma di regole separate da virgola o da a capo. Ciascuna regola verrà interpretata come espressione regolare, ad esempio:
<pre>simone@acme.com
.*@acme.com
fred(\\+.*)?@acme.com
</pre>';
$string['divertallemailsto'] = 'Devia tutte le email';
$string['divertallemailsto_desc'] = 'Consente di deviare tutte le email verso lo stesso indirizzo.';
$string['dndallowtextandlinks'] = 'Caricamento testi/link via trascina e rilascia';
$string['doclang'] = 'Lingua per la documentazione';
$string['docroot'] = 'URL del sito di documentazione di Moodle';
$string['doctonewwindow'] = 'Apri in una nuova finestra';
$string['doesnotfit'] = 'Impostazioni visualizzazione email';
$string['doesnotfitdetail'] = 'Impostazioni visualizzazione delle email in uscita da Moodle';
$string['download'] = 'Scarica';
$string['downloadcoursecontentallowed'] = 'Abilita scaricamento contenuti del corso';
$string['downloadcoursecontentallowed_desc'] = '';
$string['durationunits'] = 'unità di durata';
$string['edithelpdocs'] = 'Modifica documenti di Help';
$string['editlang'] = '<b>Modifica</b>';
$string['editorbackgroundcolor'] = 'Colore di sfondo';
$string['editordictionary'] = 'Dizionario per editor';
$string['editorfontfamily'] = 'Famiglia di font';
$string['editorfontlist'] = 'Elenco di font';
$string['editorfontsize'] = 'Dimensione font';
$string['editorhidebuttons'] = 'Pulsanti nascosti';
$string['editorkillword'] = 'Filtro Word';
$string['editorspelling'] = 'Spelling per editor';
$string['editorspellinghelp'] = 'Abilita o disabilita lo spell-checking. Se abilitato <strong>aspell</strong> deve essere installato sul server.';
$string['editstrings'] = 'Modifica parole o frasi';
$string['emailchangeconfirmation'] = 'Conferma cambio email';
$string['emaildkim'] = 'Firma DomainKeys Identified Mail (DKIM)';
$string['emaildkiminfo'] = 'Se entrambi i selettori DKIM sono impostati e viene trovato un certificato privato che corrisponde al dominio dell\'indirizzo "Da" dell\'e-mail in $CFG->dataroot/dkim /[domain] /[selector].private, allora l\'e-mail verrà firmata. Nella maggior parte dei casi (ad esempio se allowemaildomains è vuoto) è necessario un solo certificato in <pre>{$a->path}</pre>. Per ulteriori dettagli sulla configurazione, vedere la documentazione <a href={$a->docs}">Configurazione della posta</a>.';
$string['emaildkimselector'] = 'Selettore DKIM';
$string['emailfromvia'] = 'Informazione provenienza email';
$string['emailheaders'] = 'Intestazioni email';
$string['emailsubjectprefix'] = 'Prefisso oggetto email';
$string['emoticonalt'] = 'Testo alternativo';
$string['emoticoncomponent'] = 'Componente immagine';
$string['emoticonimagename'] = 'Nome immagine';
$string['emoticons'] = 'Emoticon (faccine)';
$string['emoticons_desc'] = 'Il form presenta le faccine (emoticon) in uso nel sito. Per eliminare una riga, salva il form con il campo vuoto. Per aggiungere una faccina, inseriscila sull\'ultimo campo vuoto disponibile. Per reimpostare tutte le faccine, usa il link soprastante.

* Testo (obbligatorio) - Il testo sarà sostituito con la faccina. Il testo deve essere lungo almeno due caratteri.
* Nome immagine (obbligatorio) - Il nome del file contenente l\'immagine della faccina, senza estensione, relativo al folder pix del componente.
* Componente immagine (obbligatorio) - Il componente che fornisce l\'icona
* Testo alternativo (opzionale) - Identificativo della stringa e del componente del testo alternativo alla faccina.';
$string['emoticonsreset'] = 'Ripristina le impostazioni delle faccine ai valori di default';
$string['emoticontext'] = 'Testo';
$string['emptysettingvalue'] = 'Vuoto';
$string['enableanalytics'] = 'Analitica';
$string['enableblogs'] = 'Abilita blog';
$string['enablecalendarexport'] = 'Abilita l\'esportazione del calendario';
$string['enablecomments'] = 'Abilita commenti';
$string['enablecommunicationsubsystem'] = 'Abilita provider di comunicazione';
$string['enablecommunicationsubsystem_desc'] = 'Consente l\'integrazione con provider di comunicazione come ad esempio Matrix. In questo modo docenti e studenti potranno comunicare più facilmente. È possibile gestire queste integrazioni nei <a href="settings.php?section=managecommunicationproviders">Plugin</a>.';
$string['enablecourserelativedates'] = 'Abilita date relative dei corsi';
$string['enablecourserelativedates_desc'] = 'I corsi potranno essere impostati visualizzando date relative alla data di inizio del corso dell\'utente.';
$string['enablecourserequests'] = 'Abilita Corsi a richiesta';
$string['enabled'] = 'Abilitato';
$string['enabledashboard'] = 'Abilita dashboard';
$string['enabledashboard_help'] = 'La dashboard di default visualizza';
$string['enabledevicedetection'] = 'Abilita riconoscimento dispositivo';
$string['enableglobalsearch'] = 'Abilita ricerca globale';
$string['enableglobalsearch_desc'] = 'Consente di indicizzare e sincronizzare i dati tramite elaborazione pianificata.';
$string['enablegravatar'] = 'Abilita Gravatar';
$string['enablegravatar_help'] = 'Nel caso in cui l\'utente non abbia caricato la propria immagine nel profilo, Moodle tenterà di recuperarla da Gravatar';
$string['enablemobilewebservice'] = 'Abilita web service per dispositivi mobili';
$string['enablepdfexportfont'] = 'Abilita font PDF';
$string['enablepdfexportfont_desc'] = 'Se il sito ha corsi in diverse  lingue che richiedono altri font per generare file PDF, è possibile fornire l\'opzione di impostare il font nelle impostazioni del corso. È necessario specificare i font disponibili in $CFG->pdfexportfont in config.php.';
$string['enableplugin'] = 'Abilita {$a}';
$string['enablerecordcache'] = 'Abilita cache dei record';
$string['enablerssfeeds'] = 'Abilita feed RSS';
$string['enablesearchareas'] = 'Abilita aree per la ricerca';
$string['enablesharingtomoodlenet'] = 'Abilita condivisione su MoodleNet (in uscita)';
$string['enablesharingtomoodlenet_desc'] = 'Consente agli utenti di condividere i contenuti del corso su un\'istanza MoodleNet configurata, se dispongono dei privilegi necessari.';
$string['enablestats'] = 'Abilita statistiche';
$string['enabletrusttext'] = 'Abilita contenuto affidabile';
$string['enableuserfeedback'] = 'Abilita feedback su questo software';
$string['enableuserfeedback_desc'] = 'Se abilitato, nel piè di pagina verrà visualizzato il collegamento "Invia feedback su questo software" per consentire agli utenti di fornire feedback sul software Moodle. Se l\'impostazione "Prossimo promemoria feedback" è attiva, all\'utente verrà anche visualizzato un promemoria sulla Dashboard trascorso l\'intervallo specificato. L\'impostazione di "Prossimo promemoria feedback" su "Mai" disattiva il promemoria della Dashboard, lasciando visibile il collegamento "Invia feedback su questo software" nel piè di pagina.';
$string['enablewebservices'] = 'Abilita Web service';
$string['enablewsdocumentation'] = 'Documentazione web service';
$string['encryptedpassword_edit'] = 'Immettere il nuovo valore';
$string['encryptedpassword_set'] = '(Impostato e crittografato)';
$string['enroladminnewcourse'] = 'Iscrivi automaticamente gli amministratori nei nuovi corsi';
$string['enroladminnewcourse_help'] = 'Consente di iscrivere gli amministratori nei corsi che creano.';
$string['enrolinstancedefaults'] = 'Default per le istanze del plugin di iscrizione';
$string['enrolinstancedefaults_desc'] = 'Le impostazioni di default del plugin di iscrizione quando si creano nuovi corsi.';
$string['enrolmultipleusers'] = 'Iscrivi gli utenti';
$string['entitytasklog'] = 'Log elaborazioni';
$string['environment'] = 'Ambiente';
$string['environmenterrortodo'] = 'Devi risolvere tutti i problemi ed errori riscontrati prima di procedere con l\'installazione della versione di Moodle selezionata.';
$string['environmenterrorupgrade'] = 'Attenzione: devono essere risolti tutti i problemi ambientali (errori) individuati prima di procedere con l\'aggiornamento della versione di Moodle! L\'aggiornamento senza la soluzione di questi problemi può causare problemi come la perdita di dati. Sei sicuro di continuare comunque con l\'aggiornamento?';
$string['environmentmariadbwrongdbtype'] = '$CFG->dbtype errato: deve essere cambiato nel file config.php>, modificando \'mysqli\' in \'mariadb\'.';
$string['environmentmustfixsetting'] = 'Le impostazioni del PHP devono essere modificate.';
$string['environmentok'] = 'Il server possiede tutti i requisiti minimi necessari.';
$string['environmentrecommendcustomcheck'] = 'Se questo test non ha successo, esiste un potenziale problema.';
$string['environmentrecommendinstall'] = 'Consigliata installazione e attivazione per ottenere migliori risultati';
$string['environmentrecommendversion'] = 'Versione minima consigliata: {$a->needed}.  Versione in uso: {$a->current}';
$string['environmentrequirecustomcheck'] = 'questo test deve passare con successo';
$string['environmentrequireinstall'] = 'Installazione e attivazione obbligatoria';
$string['environmentrequireversion'] = 'Versione minima necessaria: {$a->needed}. Versione in uso: {$a->current}';
$string['environmentsettingok'] = 'Sono state riscontrate le impostazioni consigliate';
$string['environmentshouldfixcustomcheck'] = 'abilitare per ottenere risultati migliori';
$string['environmentshouldfixsetting'] = 'Le impostazioni del PHP dovrebbero essere modificate.';
$string['environmentxmlerror'] = 'Errore durante la lettura dei dati dell\'ambiente ({$a->error_code})';
$string['errordeletingconfig'] = 'Si è verificato un errore durante l\'eliminazione del record di configurazioni del plugin \'{$a}\'.';
$string['errorsetting'] = 'Non è possibile salvare l\'impostazione:';
$string['errorwithsettings'] = 'Alcune impostazioni non sono state cambiate a causa di un errore.';
$string['eventshandlersinuse'] = 'I seguenti plugin installati nel sistema utilizzano handler deprecati con API Event 1: \'{$a}\'. Per favore aggiornare i plugin per utilizzare API Events 2. Per maggiori informazioni: https://docs.moodle.org/dev/Events_API#Event_dispatching_and_observers.';
$string['everyonewhocan'] = 'Chiunque possa \'{$a}\'';
$string['exceptions'] = 'eccezioni';
$string['execpathnotallowed'] = 'Disabilitazione dei percorsi locali e degli eseguibili in config.php';
$string['experimental'] = 'Sperimentale';
$string['experimentalsettings'] = 'Impostazioni sperimentali';
$string['extendedusernamechars'] = 'Consenti l\'uso di caratteri speciali negli username';
$string['extramemorylimit'] = 'Extra PHP memory limit';
$string['fatalsessionautostart'] = '<p>È stato rilevato un grave errore di configurazione, per favore avvertire l\'amministratore del server.</p><p> Per funzionare correttamente, Moodle ha bisogno che l\'amministratore modifichi le impostazioni del PHP..</p><p><code>session.auto_start</code> deve essere impostato ad <code>off</code>.</p><p>È possibile modificare questa impostazione nel file <code>php.ini</code>, nella configurazione di Apache/IIS <br /> oppure usando file <code>.htaccess</code>.</p>';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'La favicon viene visualizzata nella scheda del browser a fianco del titolo della pagina. In assenza di favicon personalizzata, sarà visualizzata la favicon di Moodle.';
$string['feedbacksettings'] = 'Impostazioni feedback';
$string['fileconversioncleanuptask'] = 'Pulizia record temporanei della conversione file.';
$string['filecreated'] = 'Nuovo file creato';
$string['filescleanupperiod'] = 'Pulizia file eliminati';
$string['filescleanupperiod_help'] = 'La frequenza della pulizia dei file eliminati. Si tratta di file associati a contesti non più esistenti, ad esempio un corso che è stato eliminato. Nota: l\'impostazione può provocare la perdita di file in quei corsi che sono stati oggetto di backup, poi eliminati ed infine ripristinati dal backup dopo l\'eliminazione nel caso in cui l\'impostazione \'Includi file\' (backup_auto_files) sia stata disabilitata nelle impostazioni di backup automatico.';
$string['filesizeunits'] = 'unità dimensione file';
$string['filestoredin'] = 'Salva il file nella cartella:';
$string['filestoredinhelp'] = 'Dove sarà memorizzato il file';
$string['filterall'] = 'Filtra tutte le stringhe';
$string['filtermatchoneperpage'] = 'Filtra occorrenze una volta per pagina';
$string['filtermatchonepertext'] = 'Filtra occorrenze una volta per testo';
$string['filternavigationwithsystemcontext'] = 'Filtra navigazione in base al contesto';
$string['filters'] = 'Filtri';
$string['filtersettings'] = 'Gestione filtri';
$string['filtersettingsgeneral'] = 'Impostazioni generali filtro';
$string['filteruploadedfiles'] = 'Applica filtro sui file inviati';
$string['forceclean'] = 'Pulizia ovunque del contenuto';
$string['forceclean_desc'] = 'Il contenuto inserito nel sito di solito viene ripulito prima di essere visualizzato per rimuovere eventuali minacce di sicurezza. Il contenuto tuttavia non viene pulito in alcuni punti come ad esempio nella descrizione della attività, nelle risorse di tipo pagina e neii blocchi HTML al fine di consentire la visualizzazione di script e di oggetti incorporati. Abilitando l\'impostazione, il contenuto verrà ripulito ovunque, con il risultato che alcuni contenuti non potranno più essere visualizzati correttamente.';
$string['forcelogin'] = 'Autenticazione obbligatoria';
$string['forceloginforprofileimage'] = 'Autenticazione obbligatoria per  visualizzare le immagini utente';
$string['forceloginforprofileimage_help'] = 'Gli utenti dovranno autenticarsi per poter visualizzare le immagini contenute nel profilo personale di altri utenti. Nei messaggi email al posto dell\'immagine dell\'utente verrà utilizzata l\'immagine di default.';
$string['forceloginforprofiles'] = 'Autenticazione obbligatoria per accedere ai profili';
$string['forcetimezone'] = 'Forza il fuso orario';
$string['formatuninstallwithcourses'] = 'Sono presenti {$a->count} corsi che usano il formato  {$a->format}. Il formato di questi corsi sarà cambiato con il formato di default del sito,  {$a->defaultformat}. Alcuni dati specifici del formato potrebbero andare perduti. Sei sicuro di proseguire ?';
$string['frontpage'] = 'Pagina home del sito';
$string['frontpagebackup'] = 'Backup pagina home del sito';
$string['frontpagedefaultrole'] = 'Ruolo di default per la pagina home del sito';
$string['frontpagefilters'] = 'Filtri della pagina home del sito';
$string['frontpageloggedin'] = 'Elementi della pagina home del sito dopo il login';
$string['frontpageoverrides'] = 'Modifiche ai privilegi della pagina home del sito';
$string['frontpagequestions'] = 'Domande della pagina home del sito';
$string['frontpagerestore'] = 'Ripristino pagina home del sito';
$string['frontpageroles'] = 'Ruoli pagina home del sito';
$string['frontpagesettings'] = 'Impostazioni pagina home del sito';
$string['fullnamedisplay'] = 'Formato del nome completo';
$string['fullnamedisplayprivate'] = 'Formato del nome completo - privato';
$string['gdrequired'] = 'L\'estensione GD è ora necessaria a Moodle per la conversione delle immagini.';
$string['generalsettings'] = 'Impostazioni generali';
$string['geoipfile'] = 'GeoLite2 City MaxMind DB';
$string['getremoteaddrconf'] = 'Sorgente degli indirizzi IP logged';
$string['globalsearch'] = 'Ricerca globale';
$string['globalsearchmanage'] = 'Gestione ricerca globale';
$string['googlemapkey3'] = 'Google Maps API V3 key';
$string['googlemapkey3_help'] = 'Per visualizzare con Google Maps le località corrispondenti agli indirizzi IP, è necessario inserire una chiave che può essere ottenuta gratuitamente su <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Vai alla prima stringa mancante';
$string['gradebook'] = 'Registro valutatore';
$string['gradebookroles'] = 'Ruoli riportati nel registro';
$string['gradeexport'] = 'Formati preferiti per l\'esportazione delle valutazioni';
$string['gravatardefaulturl'] = 'URL di default per l\'immagine Gravatar';
$string['gravatardefaulturl_help'] = 'Il servizio Gravatar ha bisogno di un URL di un\'immagine di default nel caso in cui non riesca a reperire l\'immagine dell\'utente. È necessario inserire l\'URL completa dell\'immagine. Non impostando l\'URL di default, Moodle tenterà di usare l\'immagine più appropriata in relazione alla pagina visualizzata. Da notare che Gravatar consente di usare diversi codici per <a href="https://en.gravatar.com/site/implement/images/#default-image">generare immagini di default.</a>.';
$string['group_customfield'] = 'Campi personalizzati del gruppo';
$string['groupenrolmentkeypolicy'] = 'Regole chiavi iscrizione ai gruppi';
$string['groupenrolmentkeypolicy_desc'] = 'Attiva le stesse regole delle password per le chiavi di iscrizione ai gruppi.';
$string['grouping_customfield'] = 'Campi personalizzati del raggruppamento';
$string['guestroleid'] = 'Ruolo per gli ospiti';
$string['guestroleid_help'] = 'Questo ruolo viene assegnato automaticamente agli ospiti. Viene anche assegnato temporaneamente a quegli utenti che pur non iscritti ad un corso vi accedono tramite il plugin iscrizione ospiti.';
$string['h5pgetcontenttypestask'] = 'Scaricamento contenuti H5P da h5p.org';
$string['helpadminseesall'] = 'Gli amministratori potranno visualizzare nel calendario tutti gli eventi anziché i soli eventi che li riguardano. Da notare che indipendentemente dall\'impostazione selezionata gli amministratori potranno gestire qualsisia evento di calendario accedendo prima al corso e poi al calendario.';
$string['helpcalendarcustomexport'] = 'Consente la configurazione di intervalli di date personalizzate per l\'esportazione del calendario. L\'impostazione funziona solo se è abilitata anche l\'esportazione del calendario';
$string['helpexportlookahead'] = 'Il numero di giorni futuri da includere nell\'esportazione:';
$string['helpexportlookback'] = 'Il numero di passati futuri da includere nell\'esportazione:';
$string['helpforcetimezone'] = 'È possibile autorizzare gli utenti a selezionare il proprio fuso orario, oppure imporre a tutti gli utenti l\'uso dello stesso fuso orario.';
$string['helpshowicalsource'] = 'Consente la visualizzazione del nome della sottoscrizione e del relativo link per gli eventi importati da iCal.';
$string['helpsitemaintenance'] = 'Per aggiornamenti e altro lavoro.';
$string['helpstartofweek'] = 'Il giorno con cui inizia la settimana';
$string['helpupcominglookahead'] = 'Valore predefinito del numero di giorni futuri dove il calendario cercherà i prossimi eventi.';
$string['helpupcomingmaxevents'] = 'Valore predefinito del numero massimo di eventi prossimi da visualizzare.';
$string['helpweekenddays'] = 'I giorni del weekend saranno visualizzati nel calendario con un colore diverso.';
$string['hiddenuserfields'] = 'Nascondi i campi utente';
$string['hidefromall'] = 'Nascondi a tutti gli utenti';
$string['hidefromnone'] = 'Non nascondere a nessuno';
$string['hidefromstudents'] = 'Nascondi agli studenti';
$string['hookcallbacknotcallable'] = 'Questo callback non può essere chiamato. Può avvenire se la classe o il metodo non esistono oppure il metodo non è pubblico.';
$string['hookcallbacks'] = 'Callback';
$string['hookcallbacks_help'] = 'L\'elenco di callback che verranno chiamati quando l\'hook viene inviato.

L\'ordine visualizzato è l\'ordine in cui vengono chiamati i callback.

Un callback con priorità più alta verrà chiamato prima di uno con priorità più bassa.';
$string['hookclassmissing'] = 'La classe dell\'hook non è stata trovata';
$string['hookclassmissing_desc'] = 'L\'agente di individuazione dell\'hook ha riportato una classe che non esiste.';
$string['hookconfigoverride'] = 'Sovrascritto';
$string['hookconfigoverride_help'] = 'La definizione di questo callback è stata sovrascritta nel file di configurazione del sito, config.php';
$string['hookdeprecates'] = 'Callback deprecate a lib.php';
$string['hookdescription'] = 'Descrizione';
$string['hookdescriptionmissing'] = 'L\'hook non ha un metodo di descrizione';
$string['hookname'] = 'Hook';
$string['hooksoverview'] = 'Panoramica hook';
$string['hookunknown'] = 'l\'hook non è stato trovato';
$string['hookunknown_desc'] = 'L\'oggetto ascoltato da questo callback non esiste. È possibile che sia stato rimosso o rinominato, oppure non  disponibile nella corrente versione di Moodle in uso.';
$string['hostname'] = 'Nome host';
$string['htmleditor'] = 'Editor HTML';
$string['htmleditorsettings'] = 'Impostazioni editor HTML';
$string['htmlsettings'] = 'Impostazioni HTML';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'Sicurezza HTTP';
$string['iconvrequired'] = 'È necessario installare l\'estensione ICONV.';
$string['igbinary322buggyversion'] = 'L\'estensione php-igbinary installata sul sito può causare problemi quando viene eseguita con PHP 7.2. Si consiglia di aggiornare a php-igbinary 3.2.5 o successivo, o in alternativa di aggiornare a PHP 7.3 o successivo.';
$string['ignore'] = 'Ignora';
$string['includemoduleuserdata'] = 'Includi i dati utente presenti nei moduli';
$string['incompatibleblocks'] = 'Blocchi non compatibili';
$string['incompleteunicodesupport'] = 'MySQL e MariaDB sono impostati per utilizzare \'utf8\'. Questo set di caratteri non supporta i caratteri a quattro byte dove sono incluse alcune emoticon ed il suo utilizzo provocherà errori duranti il salvataggio nel database, con conseguente perdita di dati. Per favore modifica il set di caratteri in \'utf8mb4\'. Per maggiori informazioni consultare la documentazione.';
$string['indexdata'] = 'Indicizza dati';
$string['indexinginfo'] = 'Si raccomanda di indicizzare i contenuti del sito tramite l\'elaborazione pianificata "Indicizzazione della ricerca globale"';
$string['installhijacked'] = 'Spiacente, l\'installazione deve essere completata dallo stesso indirizzo IP dal quale è stata avviata.';
$string['installsessionerror'] = 'Non è possibile inizializzare la sessione PHP, per favore verificare che il browser accetti i cookie.';
$string['intlrecommended'] = 'L\'estensione intl migliora il supporto all\'internazionalizzazione, come l\'ordinamento in accordo alle impostazioni locali';
$string['intlrequired'] = 'È necessario installare l\'estensione Intl per migliorare l\'internazionalizzazione, come ordinamenti in funzioni della lingua e nomi di dominio internazionali.';
$string['invalidagedigitalconsent'] = 'L’età del consenso digitale non è valida: {$a}';
$string['invalidforgottenpasswordurl'] = 'L\'URL di recupero password non è un URL valido.';
$string['invalidsection'] = 'Sezione non valida';
$string['invalidthemepreset'] = 'La preimpostazione selezionata non è compatibile con il tema. Errore SCSS: "{$a}"';
$string['invaliduserchangeme'] = 'Il nome utente "changeme" è riservato - non è possibile creare utenti con quel nome utente.';
$string['ipblocked'] = 'Questo sito non è al momento disponibile.';
$string['ipblocker'] = 'Blocco IP';
$string['ipblockersyntax'] = 'Inserire un valore per ogni linea. È possibile inserire un indirizzo IP completo (ad esempio <b>192.168.10.1</b>) di un singolo host, oppure un indirizzo IP parziale (ad esempio <b>192.168</b>) per includere tutti gli indirizzi che iniziano con tali numeri. È anche possibile usare la notazione CIDR (ad esempio <b>231.54.211.0/20</b>) oppure un intervallo (ad esempio <b>231.3.56.10-20</b>) dove l\'intervallo è definito dalle ultime quattro cifre. I nomi di dominio come ad esempio "example.com" non sono supportati. Le linee lasciate vuote ed eventuali linee precedete da "#" non saranno tenute in considerazione.';
$string['iplookup'] = 'Ricerca indirizzo IP';
$string['iplookupgeoplugin'] = 'Per ricavare le informazioni geografiche viene utilizzato il servizio <a href="http://www.geoplugin.com">geoPlugin</a>. Per informazioni più accurate si raccomanda di installare una copia locale del database MaxMind GeoLite.';
$string['iplookupinfo'] = 'Per cercare le località corrispondenti agli indirizzi IP, di default Moodle utilizza il server online gratuito NetGeo. Sfortunatamente questo server non è più aggiornato e fornisce dati non corretti. Si raccomanda di installare localmente una copia del database gratuito GeoLite2 City di MaxMind.<br/>
In alternativa, fornendo una chiave API V3 di Google Maps, sarà possible visualizzare la localizzazione degli IP tramite Google Maps Map, cosa ceh richiede un account Google tramite il quale richiedere la chiave API. Nel caso non venga fornita uan chiave API V3 di Google Maps, la localizzazione degli IP sarà visualizzata tramite OpenStreetMaps.';
$string['iplookupmaxmindnote'] = 'Questo prodotto include dati GeoLite2 creati da MaxMind, disponibili su <a href="https://www.maxmind.com/">https://www.maxmind.com/</a>.';
$string['iscustomadminwarnings'] = 'È stato rilevato che questo sito utilizza una cartella admin personalizzata. Questa funzionalità non è iù supportata e sarà rimossa a partere da Moodle 4.2.';
$string['ishttpswarning'] = 'Il sito non utilizza il protocollo sicuro HTTPS. Si raccomanda caldamente di configurare il sito in HTTPS per aumentarne la sicurezza e facilitare l\'integrazione con altri sistemi.';
$string['keeptagnamecase'] = 'Mantieni maiuscole/minuscole nei tag';
$string['lang'] = 'Lingua di default';
$string['langcache'] = 'Cache del menu delle lingue';
$string['langcache_desc'] = 'Cache del menu del lingue. Consente di avere in cache l\'elenco delle traduzioni disponibili. La cache viene aggiornata tutte le volte che si installa o si elimina in language pack tramite il gestore dei language pack di Moodle. Se installi un language pack a mano, per aggiornare la cache dovrai ricordarti di usare la funzione "Svuota tutte le cache".';
$string['langlist'] = 'Lingue sul menu delle lingue';
$string['langmenu'] = 'Visualizza il menu delle lingue';
$string['langmenuinsecurelayout'] = 'Visualizza menu delle lingue in impaginazioni sicure';
$string['langmenuinsecurelayout_desc'] = 'Gli utenti potranno cambiare lingua quando svolgono un quiz o altra attività che usano impaginazioni sicure.';
$string['langpackwillbeupdated'] = 'NOTA: Durante l\'aggiornamento, Moodle cercherà di aggiornare il language pack in uso.';
$string['langstringcache'] = 'Usa la cache per tutte le stringhe delle lingue';
$string['languagesettings'] = 'Impostazioni lingua';
$string['latinexcelexport'] = 'Codifica Excel';
$string['legacyfilesaddallowed'] = 'Consenti utilizzo dei file legacy del corso';
$string['legacyfilesaddallowed_help'] = 'Consente di aggiungere file e cartelle usando i file legacy del corso.';
$string['legacyfilesinnewcourses'] = 'File del corso legacy per i nuovi corsi';
$string['legacyfilesinnewcourses_help'] = 'Di default l\'area file del corso legacy è disponibile solamente nei corsi migrati da versioni precedenti. Si precisa che alcune funzionalità, ad esempio il backup/ripristino di singole attività non sono compatibili con questa impostazione.';
$string['libcurlwarning'] = 'È stato rilevato che la libreria libcurl non ha il supporto CURLOPT_PROTOCOL. Per motivi di sicurezza si raccomanda di aggiornare la libreria libcurl.';
$string['licensesettings'] = 'Impostazioni licenze';
$string['linkadmincategories'] = 'Visualizza link alle categorie di amministrazione';
$string['linkadmincategories_help'] = 'Consente di visualizzare nel blocco navigazione i link alle pagine con le categorie della amministrazione del sito';
$string['linkcoursesections'] = 'Collega sempre le sezioni del corso';
$string['linkcoursesections_help'] = 'Verrà fornito un link alle sezioni del corso. Di solito le sezioni del corso sono visualizzate come link se il formato del corso è impostato per visualizzare una sezione per pagina. Abilitando questa impostazione le sezioni avranno sempre un link.';
$string['loading'] = 'Caricamento in corso';
$string['localetext'] = 'Localizzazione del sito';
$string['localstringcustomization'] = 'Personalizzazione locale stringhe';
$string['location'] = 'Localizzazione';
$string['locationsettings'] = 'Impostazioni';
$string['locked'] = 'Bloccato';
$string['lockoutduration'] = 'Durata del blocco del profilo utente';
$string['lockoutduration_desc'] = 'I profili utente bloccati saranno sbloccati automaticamente non appena trascorso il tempo impostato.';
$string['lockoutemailbody'] = 'Il tuo profilo utente {$a->username} sul server \'{$a->sitename}\' è stato bloccato a causa di ripetuti tentativi di autenticazione falliti.

Per sbloccare il profilo puoi usare il seguente indirizzo:

{$a->link}

Nella maggioranza dei programmi di posta elettronica il link di solito appare colorato di blu ed è possibile fare click per utilizzarlo. Se il link non funziona, copialo ed incollalo nella barra degli indirizzi del browser.

Se hai bisogno di aiuto, contatta l\'amministratore del sito: {$a->admin}';
$string['lockoutemailsubject'] = 'Il tuo profilo utente su {$a} è stato bloccato';
$string['lockouterrorunlock'] = 'Sono state fornite informazioni non valide per lo sblocco del profilo utente.';
$string['lockoutthreshold'] = 'Soglia per il blocco del profilo utente';
$string['lockoutthreshold_desc'] = 'È possibile impostare la soglia di login errati oltre la quale il profilo utente sarà bloccato. Un attacco Denial of Service potrebbe abusare di questa impostazione.';
$string['lockoutwindow'] = 'Finestra temporale di osservazione per il blocco del profilo utente';
$string['lockoutwindow_desc'] = 'Il tempo di osservazione per la soglia di blocco, in assenza di login errati il contatore della soglia viene azzerato non appena trascorso il tempo impostato';
$string['lockrequestcategory'] = 'Evita la selezione delle categorie';
$string['log'] = 'Log';
$string['logguests'] = 'Log accesso ospite';
$string['logguests_help'] = 'L\'impostazione abilita il log delle azioni svolte dall\'account ospite e dagli utenti non autenticati. Siti molto trafficati possono disabilitare il log di queste azioni per motivi di performance. Nei siti di produzione si raccomanda di mantenere log accesso ospite abilitato.';
$string['logininfoinsecurelayout'] = 'Visualizza utente autenticato nelle impaginazioni sicure';
$string['logininfoinsecurelayout_desc'] = 'L\'utente autenticto potrà visualizzare il proprio nome nella barra di navigazione quando svolge un quiz o altra attività che usano impaginazioni sicure.';
$string['loginpageautofocus'] = 'Focus automatico nella maschera di autenticazione';
$string['loginpageautofocus_help'] = 'L\'impostazione migliora l\'usabilità della maschera di autenticazione, tuttavia il focus automatico dei campi può essere considerato un problema per l\'accessibilità.';
$string['loglifetime'] = 'Conserva il log per';
$string['logo'] = 'Logo';
$string['logo_desc'] = 'Un logo completo da utilizzare come decorazione di alcuni temi (come i temi core). L\'immagine può avere una risoluzione piuttosto elevata perché verrà ridimensionata per lo scopo (e memorizzata nella cache per le prestazioni). I loghi più larghi che alti di solito danno risultati migliori.';
$string['logocompact'] = 'Logo piccolo';
$string['logocompact_desc'] = 'Una versione più piccola del logo. Si raccomanda che l\'immagine sia riconoscibile anche se di piccole dimensioni.';
$string['logossettings'] = 'Logo';
$string['logstorenotrequired'] = 'Log store non richiesto';
$string['logstoressupported'] = 'Log store che supportato il report';
$string['longtimewarning'] = '<b>Da notare che questo processo può durare molto tempo.</b>';
$string['mailnewline'] = 'Caratteri Newline nelle email';
$string['maintenancemode'] = 'In modalità manutenzione';
$string['maintenancemodeisscheduled'] = 'Il sito sarà posto in modalità manutenzione tra {$a->min} minuti e  {$a->sec} secondi';
$string['maintenancemodeisscheduledlong'] = 'Il sito sarà posto in modalità manutenzione tra {$a->hour} ore {$a->min} minuti e {$a->sec} secondi';
$string['maintfileopenerror'] = 'Errore aprendo i file di manutenzione!';
$string['maintinprogress'] = 'Manutenzione in corso...';
$string['managecontextlock'] = 'Congela il contesto';
$string['managecontextlocklocked'] = '{$a->contextname} ed i suoi sotto contesti sono stati congelati.';
$string['managecontextlockunlocked'] = '{$a->contextname} ed i suoi sotto contesti sono stati scongelati.';
$string['managecontextunlock'] = 'Scongela il contesto';
$string['managecustomfields'] = 'Gestione tipi di campo personalizzato';
$string['manageformats'] = 'Gestione formati dei corsi';
$string['manageformatsgotosettings'] = 'Il formato di default può essere cambiato in {$a}';
$string['managelang'] = 'Gestione';
$string['manageqbanks'] = 'Gestione plugin deposito domande';
$string['manageqbehaviours'] = 'Gestione comportamenti domande';
$string['manageqtypes'] = 'Gestione tipi domande';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Release candidate';
$string['maturity200'] = 'Versione stabile';
$string['maturity50'] = 'Alfa';
$string['maturityallowunstable'] = 'Suggerimento: se desideri eseguire questo script, usa l\'opzione -allow-unstable';
$string['maturitycoreinfo'] = 'Il tuo sito gira con codice di sviluppo non stabile "{$a}".';
$string['maturitycorewarning'] = 'Si sta per installare o aggiornare Moodle alla versione "{$a}". Non trattandosi di una versione pronta per andare in produzione, accertarsi di voler effettivamente installare/aggiornare questa versione e di aver effettuato il checkout della versione desiderata del codice sorgente di Moodle.';
$string['maxbytes'] = 'Dimensione massima file caricabili';
$string['maxconsecutiveidentchars'] = 'Caratteri identici consecutivi';
$string['maxeditingtime'] = 'Tempo massimo per l\'editing dei messaggi';
$string['maxsizeperdownloadcoursefile'] = 'Dimensione massima di ciascun file';
$string['maxsizeperdownloadcoursefile_desc'] = 'La dimensione massima di ciascun file per lo scaricamento dei contenuti dei corsi. I file più grandi di questa dimensione non saranno inclusi nello scaricamento.';
$string['maxtimelimit'] = 'Tempo massimo';
$string['maxtimelimit_desc'] = 'È possibile impostare il tempo massimo di elaborazione, espresso in secondi, che Moodle potrà attenderà in assenza di elementi da visualizzare. Con un valore pari a zero, Moodle userà i valori di default. In presenza di server di front end con propri limiti di tempo massimo, impostare questo valore ad un limite più basso per ricevere gli errori PHP nel log. Il valore non influenza gli script CLI.';
$string['maxusersperpage'] = 'Numero max. utenti per pagina';
$string['mbstringrecommended'] = 'Installare la libreria opzionale MBSTRING è fortemente consigliato per migliorare le prestazioni, in particolare se il sito usa lingue non latine.';
$string['mbstringrequired'] = 'L\'installazione della libreria MBSTRING è necessaria per migliorare le prestazioni del sito, in particolare se il sito utilizza lingue non latine.';
$string['mediapluginavi'] = 'Abilita filtro .avi';
$string['mediapluginflv'] = 'Abilita filtro .flv';
$string['mediapluginimg'] = 'Abilita incorporazione automatica di immagini collegate';
$string['mediapluginmov'] = 'Abilita filtro .mov';
$string['mediapluginmp3'] = 'Abilita filtro .mp3';
$string['mediapluginmpg'] = 'Abilita filtro .mpg';
$string['mediapluginogg'] = 'Abilita filtro .ogg';
$string['mediapluginogv'] = 'Abilita filtro .ogv';
$string['mediapluginram'] = 'Abilita filtro .ram';
$string['mediapluginrm'] = 'Abilita filtro .rm';
$string['mediapluginrpm'] = 'Abilita filtro .rpm';
$string['mediapluginswf'] = 'Abilita filtro .swf';
$string['mediapluginswfnote'] = 'Come misura di sicurezza, gli utenti normali non dovrebbero essere autorizzati ad includere file swf flash';
$string['mediapluginwmv'] = 'Abilita filtro .wmv';
$string['mediapluginyoutube'] = 'Abilita filtro link YouTube';
$string['messaging'] = 'Abilita il sistema di messaggistica';
$string['messagingallowemailoverride'] = 'Consenti modifica email notifiche';
$string['messagingallusers'] = 'Consenti messaggistica a livello di sito';
$string['messagingcategory'] = 'Messaggistica';
$string['messagingdefaultpressenter'] = 'Abilita di default la spedizione del messaggio premendo il tasto invio';
$string['messagingdeleteallnotificationsdelay'] = 'Elimina tutte le notifiche';
$string['messagingdeletereadnotificationsdelay'] = 'Elimina notifiche lette';
$string['messagingssettings'] = 'Impostazioni messaggistica';
$string['minpassworddigits'] = 'Cifre';
$string['minpasswordlength'] = 'Lunghezza password';
$string['minpasswordlower'] = 'Lettere minuscole';
$string['minpasswordnonalphanum'] = 'Caratteri non alfanumerici';
$string['minpasswordupper'] = 'Lettere maiuscole';
$string['misc'] = 'Generale';
$string['mlbackendsettings'] = 'Impostazioni backend di machine learning';
$string['mnetrestore_extusers'] = '<strong>Nota:</strong> Questo file di backup contiene registrazioni di utenti di Moodle remoti in rete che saranno restorate come parte del processo.';
$string['mnetrestore_extusers_admin'] = '<strong>Nota:</strong> Questo file di backup sembra essere stato generato da un\'altra installazione di Moodle e contiene account di utenti Moodle Network. Il processo di ripristino tenterà di associare gli host Moodle Network a ciascun utente da creare. Gli utenti per i quali non sarà possibile l\'associazione, saranno configurati con l\'autenticazione interna al posto della autenticazione mnet. I log del ripristino conterrà informazioni al riguardo.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Nota:</strong> Questo file di backup sembra essere stato generato da un\'altra installazione di Moodle e contiene account di utenti Moodle Network il cui ripristino potrebbe non andare a buon fine. Questa operazione non è supportata. Se sei sicuro che il backup sia stato creato da questa installazione di Moodle, o sei certi che tutti gli host Moodle Network sono configurati, allora è possibile provare ad eseguire il ripristino.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Nota:</strong> Questo file di backup sembra essere stato generato da un\'altra installazione di Moodle e contiene account di utenti Moodle Network. Non sei autorizzato ad eseguire questo tipo di ripristino. Contatta l\'amministratore del sito oppure ripristina il corso senza informazioni sugli utenti (moduli, file...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Il metodo di autenticazione dell\'utente remoto {$a->username} (proveniente da {$a->mnethosturl}) è stato cambiato in autenticazione {$a->auth} locale.';
$string['mobilenotconfiguredwarning'] = 'L\'app Moodle Mobile non è abilitata.';
$string['modassignmentinuse'] = 'Il sito utilizza ancora il plugin Compito 2.2. Prima di effettuare l\'aggiornamento, è necessario 1) eseguire il backup delle attività Compito 2.2 che si desidera conservare e ripristinarle come attività Compito e 2) eliminare tutti i dati del Compito 2.2 dal database.';
$string['modassignmentsubpluginsexist'] = 'Assignment 2.2. subplugins may be present. The mod/assignment folder and all of its subplugins need to be removed before upgrading.';
$string['modeditdefaults'] = 'Valori di default dell\'attività';
$string['modsettings'] = 'Gestione attività';
$string['modulesecurity'] = 'Restrizioni sui Moduli';
$string['moodleapp'] = 'Moodle app';
$string['moodleapp_help'] = '<p>L\'app Moodle gratuita consente agli utenti di accedere ai propri corsi su dispositivi mobili. Funzionalità aggiuntive dell\'app sono disponibili con un piano Pro o Premium.</p>
<a href="https://moodle.com/mobile-app">Scarica l\'app Moodle</a><br />
<a href="https://apps.moodle.com">Portale dell\'app Moodle</a>';
$string['moodlebrandedapp'] = 'Moodle app pesonalizzata';
$string['moodlebrandedapp_help'] = '<p>La Moodle app personalizzata ha le stesse funzionalità dell\'app gratuita ma riporta logo e colori a scelta.</p>
<a href="https://moodle.com/branded-app">Ulteriori informazioni sulla Moodle app personalizzata</a>';
$string['moodlebrandedappreference'] = 'È anche possibile avere la <a href="https://moodle.com/branded-app/">Branded Moodle app</a> con il proprio logo e colori.';
$string['moodlepartners'] = 'Moodle Partner';
$string['moodlepartners_help'] = '<p>I Moodle Partner sono aziende che forniscono servizi di alta qualità su Moodle, certificati dal Moodle HQ.</p>
<a href="https://moodle.com/about-partners/">I nostri Partner</a><br />
<a href="https://moodle.com/partners">Trova un Partner</a>';
$string['moodleservices'] = 'Servizi Moodle';
$string['moodleservices_help'] = 'Assicurati la migliore esperienza su Moodle utilizzando i seguenti servizi:';
$string['multilangforceold'] = 'Forza la vecchia sintassi multilingua: &lt;span&gt; senza la class="multilang" e &lt;lang&gt;';
$string['mustenablestats'] = 'Le statistiche non sono state abilitate su questo sito';
$string['mycourses'] = 'I miei corsi';
$string['mycoursesperpage'] = 'Numero di corsi';
$string['mydashboard'] = 'Dashboard di sistema di default';
$string['mymoodle'] = 'Dashboard';
$string['mymoodleredirect'] = 'Obbliga gli utenti a usare My Moodle';
$string['mypage'] = 'Dashboard di default';
$string['mypagelocked'] = 'Blocca pagina di default';
$string['myprofile'] = 'Pagina profilo di default';
$string['navadduserpostslinks'] = 'Aggiungi link per visualizzare gli interventi dell\'utente';
$string['navadduserpostslinks_help'] = 'Consente di aggiungere due link per ciascun utente utili per visualizzare i suoi interventi e  discussioni nei forum a livello di sito o di corso';
$string['navcourselimit'] = 'Max. corsi';
$string['navigationupgrade'] = 'Questo aggiornamento introduce due nuovi blocchi per la navigazione che andranno a sostituire i seguenti blocchi: Amministrazione, Corsi, Attività e Partecipanti. Se hai configurato questi blocchi con privilegi particolari, dovrai verificare che tutto funzioni come atteso.';
$string['navshowallcourses'] = 'Visualizza tutti i corsi';
$string['navshowcategories'] = 'Visualizza categorie di corso';
$string['navshowfrontpagemods'] = 'Visualizza le attività della pagina home del sito nella navigazione';
$string['navshowfrontpagemods_help'] = 'Consente di visualizzare le attività presenti nella pagina home del sito nella navigazione, sotto le pagine del sito. L\'impostazione verrà utilizzata solo nei temi basati su Classic.';
$string['navshowfullcoursenames'] = 'Visualizza i titoli dei corsi in forma non abbreviata';
$string['navshowfullcoursenames_help'] = 'Nella navigazione saranno visualizzati i titoli dei corsi al posto dei titoli abbreviati.';
$string['navshowmycoursecategories'] = 'Visualizza le categorie ne I miei corsi';
$string['navshowmycoursecategories_help'] = 'Consente la visualizzazione del nome delle categorie nel link \'I miei corsi\' del blocco navigazione (solo per temi basati su Classic).';
$string['navsortmycourseshiddenlast'] = 'Ordina i miei corsi nascosti per ultimi';
$string['navsortmycourseshiddenlast_help'] = 'Se abilitato, tutti i corsi nascosti verranno elencati dopo i corsi visibili (per gli utenti che possono visualizzare i corsi nascosti). In caso contrario, tutti i corsi, indipendentemente dalla loro visibilità, verranno elencati in base all\'impostazione "Ordina i miei corsi".';
$string['navsortmycoursessort'] = 'Ordinamento dei corsi nel blocco navigazione';
$string['navsortmycoursessort_help'] = 'Imposta la visualizzazione dei corsi nel ramo I Miei corsi in base all\'ordinamento impostato in Amministrazione del sito > Corsi > Gestione corsi e categorie oppure alfabeticamente in base alle impostazioni del corso. L\'impostazione ha effetto solo su temi basati su Classic.';
$string['never'] = 'Mai';
$string['neverdeleteruns'] = 'Non eliminare i run';
$string['newestdocindexed'] = 'Documento più recentemente indicizzato';
$string['nobookmarksforuser'] = 'Non hai alcun segnalibro';
$string['nodatabase'] = 'Nessun database';
$string['noemaileverwarning'] = '<strong>Nota:</strong> Sono state disabilitate tutte le email in uscita';
$string['nohttpsformobilewarning'] = 'Si consiglia vivamente di abilitare HTTPS con un certificato valido, la app Moodle al primo tentativo di collegamento cercherà sempre di utilizzare una connessione sicura.';
$string['nomissingstrings'] = 'Non ci sono stringhe mancanti';
$string['none'] = 'Nessuno';
$string['nonewsettings'] = 'Questo aggiornamento non include nuove impostazioni';
$string['nonexistentbookmark'] = 'Il segnalibro richiesto non esiste';
$string['noreplyaddress'] = 'Indirizzo No-reply';
$string['noreplydomain'] = 'No-reply e dominio';
$string['noreplydomaindetail'] = 'Impostazioni no-reply e domini configurati';
$string['noresults'] = 'Nessun risultato';
$string['noroles'] = 'Nessun ruolo';
$string['nosupportedlogstore'] = 'Non sono presenti log store supportati';
$string['noteunneededblocks'] = 'Nota: i blocchi impostati per la visualizzazione non verranno elencati nel menu \'Aggiungi un blocco\' se sono specificati nell\'impostazione del tema come \'Blocchi non necessari\'.';
$string['notifications'] = 'Avvisi';
$string['notifyloginfailures'] = 'Destinatari degli avvisi sui login errati';
$string['notifyloginthreshold'] = 'Soglia per l\'invio di avvisi tramite email';
$string['notloggedinroleid'] = 'Ruolo per i visitatori';
$string['numberofmissingstrings'] = 'Numero stringhe mancanti: {$a}';
$string['numberofstrings'] = 'Totale stringhe: {$a->strings}<br />Mancanti: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['oauthrefreshtokenexpired'] = 'Il token di rinnovo per i servizi OAuth {$a->issuer} sul sito {$a->siteurl} è scaduto. Questo limiterà la funzionalità dei plugin che utilizzano questo servizio. Per risolvere il problema, visitare la pagina di configurazione dei Servizi OAuth 2 e cliccare sull\'icona "Collega ad un account di sistema" nella riga della tabella per questo servizio. Assicurarsi di fare login ogni volta con lo stesso account di servizio per il sistema OAuth.';
$string['oauthrefreshtokenexpiredshort'] = 'Il token di rinnovo è scaduto per {$a->issuer} sul sito {$a->siteurl}.';
$string['onlynoreply'] = 'Solo se da indirizzo no-reply';
$string['opcacherecommended'] = 'La cache PHP opcode migliora le prestazioni e riduce la memoria utilizzata. L\'estensione OPcache è sia consigliata sia supportata.';
$string['opensslrecommended'] = 'È fortemente raccomandata l\'installazione della libreria opzionale OpenSSL -- questa abilita la funzionalità Moodle Networking.';
$string['opensslrequired'] = 'Per fornire servizi di crittografia forte, l\'estensione PHP OPenSSL è diventata un requisito necessario.';
$string['opentowebcrawlers'] = 'Aperto a Google';
$string['optionalmaintenancemessage'] = 'Messaggio opzionale per la  modalità manutenzione';
$string['oracledatabaseinuse'] = 'Il supporto Oracle DB sarà rimosso. Moodle 4.5 sarà l\'ultima versione con supporto Oracle DB. Per i dettagli, vedere l\'annuncio su moodle.org <a href="https://moodle.org/mod/forum/discuss.php?d=456122">Supporto del database Oracle in LMS</a>.';
$string['order1'] = 'Primo';
$string['order2'] = 'Secondo';
$string['order3'] = 'Terzo';
$string['order4'] = 'Quarto';
$string['outgoingmailconfig'] = 'Configurazione email in uscita';
$string['overridetossl'] = 'L\'impostazione Login HTTPS è stata deprecata ed è stato forzato l\'uso di SSL. Per eliminare questo messaggio, modificare wwwroot in https://';
$string['pageinfodebugsummary'] = 'La pagina è: {$a}';
$string['passwordchangelogout'] = 'Termina sessione dopo la modifica della password';
$string['passwordchangelogout_desc'] = 'Tutte le sessioni browser saranno terminate con l\'unica eccezione della sessione dove è stata modificata la password. (L\'impostazione non influenza la modifica della password effettuata tramite le Azioni in massa.)';
$string['passwordchangetokendeletion'] = 'Elimina i token di accesso web service quando viene cambiata la password';
$string['passwordchangetokendeletion_desc'] = 'I token di accesso web service verranno eliminati quando un utente cambia la proria password.';
$string['passwordpolicy'] = 'Regole password';
$string['passwordpolicycheckonlogin'] = 'Verifica password durante l\'autenticazione';
$string['passwordresettime'] = 'Tempo massimo validazione recupero password';
$string['passwordreuselimit'] = 'Rotazione password';
$string['passwordreuselimit_desc'] = 'Il numero di cambi di password necessari prima che si possa di poter riutilizzare una password. Gli hash delle password già utilizzate saranno memorizzati nel database. L\'impostazione può essere incompatibile con alcuni plugin di autenticazione esterna.';
$string['pathtodot'] = 'Percorso di dot';
$string['pathtodot_help'] = 'Percorso assoluto dell\'eseguibile dot, ad esempio /usr/bin/dot oppure (windows) C:\\Program Files (x86)\\Graphviz2.38\\bin\\dot.exe, su Mac /opt/local/bin/dot. Per generare grafici a partire dai file DOT, è necessario installare l\'eseguibile dot e configurare il percorso.';
$string['pathtodu'] = 'Percorso di du';
$string['pathtogs'] = 'Percorso di ghostscript';
$string['pathtogs_help'] = 'Generalmente su installazioni Linux è possibile usare \'/usr/bin/gs. Su Windows probabilmente è possibile usare \'\'c:\\gs\\bin\\gswin32c.exe\'. Accertarsi che non ci siano spazi nel percorso, nel caso copiare i file \'gswin32c.exe\' e \'gsdll32.dll\' in una cartella il cui percorso è privo di spazi.';
$string['pathtopdftoppm'] = 'Percorso del pdftoppm';
$string['pathtopdftoppm_help'] = '<a href="https://poppler.freedesktop.org/">Poppler</a> è una libreria di rendering PDF che include lo strumento pdftoppm utili per convertire file PDF in PNG. Le prestazioni sono generalmente migliori rispetto a Ghostscript, in particolare per file di grandi dimensioni. Se disponibile, verrà utilizzato di preferenza pdftoppm rispetto a Ghostscript. Sulla maggior parte delle installazioni Linux il percorso è /usr/bin/pdftoppm, altrimenti si deve installare il pacchetto poppler-utils o poppler, a seconda della distribuzione Linux utilizzata. Su Windows è fornito dalle installazioni di Cygwin.';
$string['pathtopgdump'] = 'Percorso di pg_dump';
$string['pathtopgdumpdesc'] = 'È necessario solo se hai più di un pg_dump sul sistema (per esempio hai più versioni di postgresql installate)';
$string['pathtopgdumpinvalid'] = 'Il percorso di pg_dump non è valido, è errato o punta ad un file non eseguibile';
$string['pathtophp'] = 'Percorso di PHP CLI';
$string['pathtopsql'] = 'Percorso di psql';
$string['pathtopsqldesc'] = 'È necessario solo se hai più di un psql sul sistema (per esempio hai più versioni di postgresql installate)';
$string['pathtopsqlinvalid'] = 'Il percorso di psql non è valido, è errato o punta ad un file non eseguibile';
$string['pathtopython'] = 'Percorso di Python';
$string['pathtopythondesc'] = 'Il percorso dell’eseguibile binario Python (sono supportati sia Python 2 sia Python 3).';
$string['pathtosassc'] = 'Percorso di SassC';
$string['pathtosassc_help'] = 'Specificando la posizione del binario SassC, il compilatore SASS passerà dall\'implementazione PHP di Moodle a SassC. Vedere https://github.com/sass/sassc per ulteriori informazioni.';
$string['pcreunicodewarning'] = 'Si raccomanda di utilizzare l\'estensione PHP PCRE che è compatibile con i caratteri Unicode.';
$string['perfdebug'] = 'Visualizza prestazioni';
$string['perfdebugdeferred'] = 'In attesa che lo script finisca per visualizzareil debug delle prestazioni...';
$string['performance'] = 'Prestazioni';
$string['pgcluster'] = 'Cluster PostgreSQL';
$string['pgclusterdescription'] = 'Parametro per le operazioni a linea di comando della versione/cluster di PostgreSQL. Se hai un solo postgresql sul sistema o non sei sicuro di cosa significhi, lascialo vuoto.';
$string['phpfloatproblem'] = 'È stato rilevato un problema inatteso durante l\'utilizzo di numeri a virgola mobile tramite PHP - {$a}';
$string['pid'] = 'PID';
$string['pleaserefreshregistration'] = 'Questo sito è registrato e l\'ultimo aggiornamento della registrazione è stato effettuato il {$a}. L\'elaborazione pianificata "Registrazione del sito" aggiorna con regolarità la registrazione, tuttavia è anche possibile aggiornarla manualmente in qualsiasi momento.';
$string['pleaserefreshregistrationnewdata'] = 'Le informazioni della registrazione sono cambiati. Per favore confermale utilizzando il pulsante \'Aggiorna registrazione\'';
$string['pleaserefreshregistrationunknown'] = 'Il sito è registrato ma non è nota la data di registrazione. Per favore aggiorna la registrazione con il pulsante \'Aggiorna registrazione\' oppure assicurati che l\'elaborazione pianificata \'Registrazione del sito\' sia attiva.';
$string['plugin'] = 'Plugin';
$string['plugin_disabled'] = '{$a} è stato disabilitato.';
$string['plugin_enabled'] = '{$a} è stato abilitato.';
$string['plugins'] = 'Plugin';
$string['pluginscheck'] = 'Controllo dipendenze plugin';
$string['pluginscheckfailed'] = 'Il controllo delle dipendenze plugin è fallito per {$a->pluginslist}';
$string['pluginschecktodo'] = 'È necessario soddisfare tutti i requisiti richiesti dai plugin prima di continuare con l\'installazione di questa versione di Moodle';
$string['pluginsoverview'] = 'Panoramica plugin';
$string['pluginsoverviewsee'] = 'Per maggiori informazioni consultare la pagina <a href="{$a->url}">panoramica plugin</a>.';
$string['policysettings'] = 'Impostazioni politiche';
$string['privacy:metadata'] = 'Il plugin "Amministrazione" non memorizza dati personali.';
$string['privacyandpolicies'] = 'Privacy e politiche';
$string['privacysettings'] = 'Impostazioni privacy';
$string['profilecategory'] = 'Categoria';
$string['profilecategoryname'] = 'Nome categoria (deve essere unico)';
$string['profilecategorynamenotunique'] = 'Nome categoria già in uso';
$string['profilecommonsettings'] = 'Impostazioni comuni';
$string['profileconfirmcategorydeletion'] = 'Questa categoria contiene {$a} campo/i. Eliminando la categoria, i campi saranno spostati nella categoria immediatamente superiore (oppure in quella immediatamente inferiore se stai eliminando la categoria di primo livello).<br/>Sei sicuro di eliminare questa categoria?';
$string['profileconfirmfielddeletion'] = 'Sono presenti {$a} record che contengono valori per questo campo. Eliminando il campo questi i valori saranno perduti.<br/>Sei sicuro di  eliminare questo campo?';
$string['profilecreatecategory'] = 'Crea una categoria per i campi personalizzati';
$string['profilecreatefield'] = 'Crea un campo personalizzato';
$string['profilecreatenewcategory'] = 'Creazione di una categoria per i campi personalizzati';
$string['profilecreatenewfield'] = 'Creazione di un campo personalizzato \'{$a}\'';
$string['profiledefaultcategory'] = 'Altri campi';
$string['profiledefaultchecked'] = 'Selezionata di default';
$string['profiledefaultdata'] = 'Valore di default';
$string['profiledeletecategory'] = 'Eliminazione di una categoria';
$string['profiledeletefield'] = 'Eliminazione del campo \'{$a}\'';
$string['profiledescription'] = 'Descrizione del campo';
$string['profiledscript'] = 'Lo script è stato profilato';
$string['profiledscriptview'] = 'Visualizza le informazioni di profilazione dello script';
$string['profileeditcategory'] = 'Modifica categoria: {$a}';
$string['profileeditfield'] = 'Modifica campo personalizzato: {$a}';
$string['profilefield'] = 'Campi personalizzati';
$string['profilefieldcolumns'] = 'Colonne';
$string['profilefieldispassword'] = 'È un campo password?';
$string['profilefieldlink'] = 'Link';
$string['profilefieldlink_help'] = 'Per trasformare un testo in un link, inserire un URL contenente $$, dove $$ sarà sostituito dal testo. Ad esempio per trasformare un ID Twitter in in link, inserire http://twitter.com/$$';
$string['profilefieldlinktarget'] = 'Link target';
$string['profilefieldmaxlength'] = 'Limite caratteri';
$string['profilefieldmaxlength_help'] = 'Per utilizzare questo campo nell\'impostazione \'Visualizza identità utente\', il limite deve essere di 255 caratteri o meno.';
$string['profilefieldrows'] = 'Righe';
$string['profilefields'] = 'Campi personalizzati';
$string['profilefieldsize'] = 'Numero caratteri visualizzati';
$string['profileforceunique'] = 'I dati devono essere univoci';
$string['profileinvaliddata'] = 'Valore non valido';
$string['profilelocked'] = 'Campo bloccato';
$string['profilemenudefaultnotinoptions'] = 'Il valore default non è una delle opzioni';
$string['profilemenunooptions'] = 'Nessuna opzione menu inserita';
$string['profilemenuoptions'] = 'Opzioni menu (una per riga)';
$string['profilemenutoofewoptions'] = 'Devi inserire almeno 2 opzioni';
$string['profilename'] = 'Nome';
$string['profilenofieldsdefined'] = 'Non ci sono campi personalizzati';
$string['profilerequired'] = 'Compilazione obbligatoria';
$string['profileroles'] = 'Ruoli visibili';
$string['profilesforenrolledusersonly'] = 'Profili utente visibili solo agli iscritti ai corsi';
$string['profileshortname'] = 'Nome abbreviato (univoco)';
$string['profileshortnameinvalid'] = 'Il nome abbreviato può contenere solo caratteri alfanumerici (lettere e numeri) o trattini bassi (_).';
$string['profileshortnamenotunique'] = 'Nome abbreviato già in uso';
$string['profilesignup'] = 'Da compilare nella pagina di creazione account';
$string['profilespecificsettings'] = 'Impostazioni specifiche';
$string['profilevisible'] = 'Visibilità del campo';
$string['profilevisible_help'] = '* Non visibile - Per dati riservati visibili solo all\'amministratore
* Visibile all\'utente - Per dati riservati visibili solo all\'utente e agli amministratori
* Visibile all\'utente, ai docenti e agli amministratori - Per dati riservati visibili solo all\'utente, agli amministratori e, nella pagine del profilo utente del corso, ai docenti
* Visibile a tutti';
$string['profilevisibleall'] = 'Visibile a tutti';
$string['profilevisiblenone'] = 'Non visibile';
$string['profilevisibleprivate'] = 'Visibile all\'utente';
$string['profilevisibleteachers'] = 'Visibile all\'utente, ai docenti e agli amministratori';
$string['profiling'] = 'Profiling';
$string['profilingallowall'] = 'Profiling continuo';
$string['profilingallowall_help'] = 'L\'impostazione consente di usare ovunque il parametro PROFILELALL, volto  al profiling di tutti gli script eseguiti durante la sessione Moodle. Per fermare il profiling è possibile usare il parametro PROFILESTOP.';
$string['profilingallowme'] = 'Profiling selettivo';
$string['profilingallowme_help'] = 'L\'impostazione consente di usare selettivamente (PGC) il parametro PROFILEME per ul profiling di specifici script. Per fermare il profiling è possibile usare il parametro DONTPROFILEME.';
$string['profilingautofrec'] = 'Profiling automatico';
$string['profilingautofrec_help'] = 'L\'impostazione attiverà il profiling automatico e casuale di richieste (basata sulla frequenza impostata, 1 su N). I risultati saranno memorizzati per successive analisi. Da notare che questo tipo di profiling tiene conto delle impostazioni di include/exclude. Il valore 0 disabilita il profiling automatic';
$string['profilingenabled'] = 'Abilita profiling';
$string['profilingenabled_help'] = 'L\'impostazione abilita le funzioni di profiling, il cui comportamento può essere regolato con le impostazioni che seguono';
$string['profilingexcluded'] = 'Escludi profiling';
$string['profilingexcluded_help'] = 'Elenco di URL (separato da virgole o da a capo, esclusi wwwroot assoluti, raggiungibili) che saranno esclusi dalla profilazione rispetto a quelle definite nell\'impostazione "Profila questi"';
$string['profilingimportprefix'] = 'Prefisso importazione profiling';
$string['profilingimportprefix_desc'] = 'Per una più facile identificazione, tutti i profiling run importati avranno il prefisso specificato.';
$string['profilingincluded'] = 'Profila questi';
$string['profilingincluded_help'] = 'Elenco di URL (separato da virgole o da a capo, esclusi wwwroot assoluti, raggiungibili) separato da virgole da profilare automaticamente. Esempio: /index.php, /course/view.php. È anche possibile specificare il carattere jolly * in qualsiasi posizione. Esempio: mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Mantieni profiling run';
$string['profilinglifetime_help'] = 'Imposta il periodo di conservazione dei profiling run precedenti. I run più vecchi saranno periodicamente eliminati. Da notare che i run di riferimento non saranno eliminati.';
$string['profilingslow'] = 'Profila pagine lente';
$string['profilingslow_help'] = 'Impostando un tempo minimo espresso in secondi, le pagine più lente del tempo impostato verranno profilate. Saranno mantenuti solamente i profili degli script più enti di un profilo esistente. Impostare a 0 per disabilitare. Da notare che viene risspettata l\'impostazione di esclusione.';
$string['protectusernames'] = 'Proteggi gli username';
$string['proxybypass'] = 'Proxy bypass host';
$string['proxyfixunsafe'] = 'Correggi le chiamate senza proxy';
$string['proxyhost'] = 'Proxy host';
$string['proxylogunsafe'] = 'Registra le chiamate senza proxy';
$string['proxypassword'] = 'Proxy password';
$string['proxyport'] = 'Porta proxy';
$string['proxytype'] = 'Tipo proxy';
$string['proxyuser'] = 'Proxy username';
$string['purgecaches'] = 'Svuota le cache';
$string['purgecachesconfirm'] = 'Moodle può tenere in cache temi, javascript, stringhe di lingua, testo filtrato, feed rss ed altri tipi di dati. Svuotando le cache i dati saranno eliminati dal server e il browser verrà costretto a ricaricarli, in questo modo potrai essere certo di visualizzare i dati più aggiornati. Svuotare le cache non presenta rischi, tuttavia il sito potrebbe subire un rallentamento fino a quando le cache non saranno ripristinate. ';
$string['purgecachesfinished'] = 'Tutte le cache sono state svuotate';
$string['purgecachesnoneselected'] = 'Seleziona le cache da svuotare';
$string['purgecachespage'] = 'Svuota cache';
$string['purgefiltercache'] = 'Filtri del testo';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'Stringhe di lingua';
$string['purgemuc'] = 'Tutte le cache MUC';
$string['purgeothercaches'] = 'Tutte le cache dei file e le cache non specifiche';
$string['purgeselectedcaches'] = 'Svuota le cache selezionate';
$string['purgeselectedcachesfinished'] = 'Le cache selezionate sono state svuotate.';
$string['purgetemplates'] = 'Modelli';
$string['purgethemecache'] = 'Temi';
$string['query'] = 'Query';
$string['question'] = 'Domanda';
$string['questionbehaviours'] = 'Comportamenti della domanda';
$string['questioncwqpfscheck'] = 'Una o più domande casuali in un quiz sono impostate in modo da pescare le domande da un misto di categorie condivise e non condivise. Esiste un <a href="{$a->reporturl}">report più dettagliato</a> ed è anche possibile leggere la <a href="{$a->docsurl}">pagina</a> della documentazione.';
$string['questioncwqpfsok'] = 'Bene. Non ci sono domande "a caso" nei tuoi quiz impostate in modo da pescare le domande da un misto di categorie condivise e non.';
$string['questiontype'] = 'Tipo domanda';
$string['questiontypes'] = 'Tipi domande';
$string['quizattemptsupgradedmessage'] = 'Moodle 2.1 ha introdotto un significativo aggiornamento alle domande. Sebbene sia stato possibile ritardare l\'aggiornamento del database, prima di migrare a Moodle 2.7 è indispensabile effettuare l\'aggiornamento.';
$string['recaptchaprivatekey'] = 'Chiave segreta CAPTCHA';
$string['recaptchapublickey'] = 'Chiave sito reCAPTCHA';
$string['referrernone'] = 'Default del browser';
$string['referrerpolicy'] = 'Referrer policy';
$string['referrerpolicydesc'] = 'Imposta la referrer policy header che sarà inclusa nelle risposte provenienti dal sito.';
$string['register'] = 'Registra il sito';
$string['registration'] = 'Registrazione';
$string['registration_help'] = 'Registrando il sito:

* saranno inviati avvisi di sicurezza
* sarà possibile attivare notifiche push per l\'app mobile
* sarà possibile contribuire alle statistiche di Moodle sulla comunità mondiale degli utilizzatori';
$string['registrationwarning'] = 'Se lo desideri puoi registrare il sito.';
$string['registrationwarningcontactadmin'] = 'Il sito non è registrato. Nel caso si desideri registrarlo, per favore avvertire l\'amministratore.';
$string['releasenoteslink'] = 'Per informazioni su questa versione di Moodle, si prega di consultare le <a target="_blank" href="{$a}">Note di rilascio</a> in linea';
$string['rememberuserlicensepref'] = 'Ricorda licenza scelta dall\'utente';
$string['rememberuserlicensepref_help'] = 'Consente di conservare l\'ultima licenza scelta dall\'utente durante il caricamento di file, riproponendola al successivo caricamento. In assenza di impostazione, sarà proposta la licenza di default del sito.';
$string['rememberusername'] = 'Ricorda username';
$string['rememberusername_desc'] = 'Memorizza un cookie permanente con lo username usato per il login. Tenere presente che i cookie permanenti possono rappresentare un problema di privacy se utilizzati in assenza di consenso.';
$string['replacefrontsearch'] = 'Utilizzato nella ricerca corsi della pagina home del sito';
$string['reportsmanage'] = 'Gestione report';
$string['required'] = 'Obbligatorio';
$string['requiredentrieschanged'] = 'Nota: dopo l\'aggiornamento, l\'impostazione \'Numero minimo di record da inserire prima di poter visualizzare il Database\' sarà forzata nelle seguenti attività Database:<br/>{$a->text}<br/>';
$string['requiremodintro'] = 'Descrizione dell\'attività obbligatoria';
$string['requiremodintro_desc'] = 'Abilitare l\'impostazione per rendere obbligatoria la descrizione delle attività.';
$string['requires'] = 'Richiede';
$string['resetindentation'] = 'Reimposta rientro in tutto il sito';
$string['resetindentation_help'] = 'Saranno rimossi tutti i rientri impostati nei corsi che utilizzano il formato {$a->format}.';
$string['resetindentation_title'] = 'Reimpostare il rientro in tutto il sito?';
$string['resetindentationsuccess'] = 'Reimpostazione rientro.';
$string['restorecourse'] = 'Ripristina corso';
$string['restorernewroleid'] = 'Ruolo nel corso per l\'utente che ripristina';
$string['restorernewroleid_help'] = 'Se l\'utente che ripristina corsi non è autorizzato a gestire corsi ripristinati, allora all\'utente verrà assegnato questo ruolo e, se necessario, iscritto al corso. Scegli "Nessuno" se non si desidera autorizzare l\'utente che ripristina i corsi a gestire qualsiasi corso ripristinato.';
$string['resultfilter'] = 'Filtra risultati';
$string['reverseproxy'] = 'Reverse proxy';
$string['reverseproxyignore'] = 'Ignora reverse proxy';
$string['riskconfig'] = 'Gli utenti possono modificare la configurazione e il comportamento del sito';
$string['riskconfigshort'] = 'Configurazione';
$string['riskdataloss'] = 'L\'utente potrebbe essere in grado di distruggere grandi quantità di dati';
$string['riskdatalossshort'] = 'Rischio di perdita di dati';
$string['riskmanagetrust'] = 'Gli utenti possono modificare le impostazioni di affidabilità di altri utenti';
$string['riskmanagetrustshort'] = 'Gestione rischi';
$string['riskpersonal'] = 'Gli utenti possono avere accesso alle informazioni personali di altri utenti';
$string['riskpersonalshort'] = 'Privacy';
$string['riskspam'] = 'Gli utenti possono inviare spam agli utenti del sito o ad altri';
$string['riskspamshort'] = 'Spam';
$string['riskxss'] = 'Gli utenti possono aggiungere file e testi che consentono il cross-site scripting (XSS)';
$string['riskxssshort'] = 'Rischio XSS';
$string['roleswithexceptions'] = '{$a->roles}, con {$a->exceptions}';
$string['rssglobaldisabled'] = 'Disabilitato a livello di sito';
$string['save'] = 'Salva';
$string['savechanges'] = 'Salva modifiche';
$string['scssinvalid'] = 'Il codice SCSS non è valido. Errore: {$a}';
$string['search'] = 'Ricerca';
$string['searchablecourses'] = 'Corsi dove cercare';
$string['searchallavailablecourses'] = 'Corsi dove cercare';
$string['searchallavailablecourses_desc'] = 'In alcuni casi il motore di ricerca può non funzionare correttamente lavorando su troppi corsi. È possibile limitare la ricerca ai corsi dove si è iscritti.';
$string['searchallavailablecourses_off'] = 'Cerca nei corsi dove l\'utente è iscritto';
$string['searchallavailablecourses_on'] = 'Cerca nei corsi dove l\'utente può accedere';
$string['searchallavailablecoursesdesc'] = 'If set to search within enrolled courses only, course information (name and summary) and course content will only be searched in courses which the user is enrolled in. Otherwise, course information and course content will be searched in all courses which the user can access, such as courses with guest access enabled.';
$string['searchalldeleted'] = 'Tutti i contenuti indicizzati sono stati eliminati';
$string['searchalternatesettings'] = 'Impostazioni alternative solo query';
$string['searchalternatesettings_desc'] = 'Completando queste impostazioni sarà possibile selezionare "impostazioni alternative" per il motore di ricerca nell\'opzione \'motore di ricerca solo query\', reperibile nella pagina \'Gestione ricerca globale\'. Utile solo quando ci si sposta tra due motori di ricerca dello stesso tipo.';
$string['searchareadisabled'] = 'Area di ricerca disabilitata';
$string['searchareaenabled'] = 'Area di ricerca abilitata';
$string['searchareas'] = 'Aree di ricerca';
$string['searchbanner'] = 'Ricerca';
$string['searchbannerenable'] = 'Visualizza le informazioni di ricerca';
$string['searchbannerenable_desc'] = 'Se abilitato, il testo di seguito verrà visualizzato nella parte superiore della schermata di ricerca per tutti gli utenti. Questo può essere utilizzato per informare gli utenti quando viene eseguita la manutenzione del motore di ricerca.';
$string['searchdefaultcategory'] = 'Categoria di ricerca predefinita';
$string['searchdefaultcategory_desc'] = 'I risultati dall\'area di ricerca selezionata saranno visualizzati in base all\'impostazione predefinita.';
$string['searchdeleteindex'] = 'Elimina tutti i contenuti indicizzati';
$string['searchdisplay'] = 'Opzioni di visualizzazione dei risultati della ricerca';
$string['searchenablecategories'] = 'Visualizza risultati in categorie separate';
$string['searchenablecategories_desc'] = 'I risultati della ricerca saranno visualizzati in categorie separate.';
$string['searchengine'] = 'Motore di ricerca';
$string['searchenginealternatesettings'] = '{$a} (impostazioni alternative)';
$string['searchenginequeryonly'] = 'Motore di ricerca solo query';
$string['searchenginequeryonly_desc'] = 'Questo motore di ricerca verrà utilizzato solo per effettuare query, non per indicizzare. Utilizzando questa funzione sarà possibile reindicizzare con un motore di ricerca diverso, mentre le query degli utenti continueranno a funzionare con questo.';
$string['searchenginequeryonly_none'] = 'Nessuno (usa il motore di ricerca principale per le query)';
$string['searchenginequeryonlysame'] = 'Il motore di ricerca di solo query e il motore di ricerca principale non possono essere impostati sullo stesso valore.';
$string['searchhideallcategory'] = 'Nascondi la categoria Tutti i risultati';
$string['searchhideallcategory_desc'] = 'Se selezionata, la categoria con tutti i risultati verrà nascosta nella schermata dei risultati della ricerca.';
$string['searchincludeallcourses'] = 'Includi tutti i corsi visibili';
$string['searchincludeallcourses_desc'] = 'Se abilitato, i risultati della ricerca includeranno le informazioni sul corso (nome e riepilogo) dei corsi che sono visibili all\'utente, anche se non ha accesso al contenuto del corso.';
$string['searchindexactions'] = 'Azioni indice';
$string['searchindexdeleted'] = 'Indice eliminato';
$string['searchindextime'] = 'Tempo limite di indicizzazione';
$string['searchindextime_desc'] = 'L\'elaborazione pianificata di indicizzazione si fermerà una volta raggiunto il tempo limite impostato. L\'indicizzazione proseguirà al successivo lancio dell\'elaborazione.';
$string['searchindexupdated'] = 'I contenuti del motore di ricerca sono stati aggiornati';
$string['searchindexwhendisabled'] = 'Indicizza quando disabilitato';
$string['searchindexwhendisabled_desc'] = 'L\'elaborazione pianificata di indicizzazione sarà eseguita anche quando la ricerca globale è disabilitata. L\'impostazione è particolarmente utile per indicizzare i contenuti prima di rendere disponibile agli utenti la ricerca globale.';
$string['searchinsettings'] = 'Cerca nelle impostazioni';
$string['searchlastrun'] = 'Ultima elaborazione (orario, # documenti, # record, # ignorati)';
$string['searchmanagement'] = 'Gestione della ricerca';
$string['searchmanagement_desc'] = 'Impostazioni utili quando si apportano modifiche su siti con indici di ricerca grandi che richiedono molto tempo per essere creati.';
$string['searchmaxtopresults'] = 'Numero massimo di risultati principali';
$string['searchmaxtopresults_desc'] = 'Il numero massimo di risultati principali che saranno visualizzati per primi nei risultati della ricerca di contenuti di corsi, corsi ed utenti.';
$string['searchnotavailable'] = 'La ricerca non è disponibile';
$string['searchoptions'] = 'Opzioni di ricerca';
$string['searchpartial'] = '(non ancora completamente indicizzato)';
$string['searchreindexed'] = 'Tutti i contenuti del sito sono stati indicizza di nuovo.';
$string['searchreindexindex'] = 'Indicizza di nuovo tutti i contenuti del sito';
$string['searchresults'] = 'Risultati della ricerca';
$string['searchsetupinfo'] = 'Impostazione ricerca';
$string['searchteacherroles'] = 'Ruoli del docente';
$string['searchteacherroles_desc'] = '';
$string['searchtopresults'] = 'Risultati principali';
$string['searchupdateindex'] = 'Aggiorna i contenuti indicizzati';
$string['sectionerror'] = 'Errore di sezione!';
$string['secureforms'] = 'Applica maggiore sicurezza per i form';
$string['security'] = 'Sicurezza';
$string['selectdevice'] = 'Seleziona dispositivo';
$string['selectsearchengine'] = 'Seleziona il motore di ricerca';
$string['selecttheme'] = 'Seleziona il tema per il dispositivo {$a}';
$string['server'] = 'Server';
$string['serverchecks'] = 'Verifiche server';
$string['serverlimit'] = 'Limite del server';
$string['servicespage'] = 'Link ai servizi e all\'assistenza';
$string['sessionautostartwarning'] = '<p>È stato individuato un errore di configurazione grave, per favore avverti l’amministratore</p><p> Moodle per funzionare correttamente ha bisogno di modifiche alle impostazioni PHP.</p><p><code>session.auto_start</code> deve essere impostato a <code>off</code>.</p><p>È possibile cambiare l\'impostazione modificando il file <code>php.ini</code>, la configurazione di Apache/IIS <br />oppure tramite il file  <code>.htaccess</code> sul server.</p>';
$string['sessioncookie'] = 'Suffisso cookie';
$string['sessioncookiedomain'] = 'Dominio cookie';
$string['sessioncookiepath'] = 'Percorso cookie';
$string['sessionhandling'] = 'Gestione sessione';
$string['sessiontimeout'] = 'Timeout di sessione';
$string['sessiontimeoutwarning'] = 'Avviso timeout';
$string['settingdependenton'] = 'L\'impostazione può essere nascosta in base al valore di <strong>{$a}</strong>.';
$string['settingfileuploads'] = 'Il caricamento di file è necessario per usare l\'ambiente, per favore abilitatelo nelle impostazioni del PHP.';
$string['settingmaxinputvars'] = 'L\'impostazione PHP max_input_vars è consigliata su almeno 5000.';
$string['settingmaxinputvarsrequired'] = 'L\'impostazione PHP max_input_vars deve essere almeno 5000.';
$string['settingmemorylimit'] = 'È stato riscontrato un limite di memoria troppo basso. Per favore aumentate il limite della memoria nelle impostazioni del PHP.';
$string['settingsafemode'] = 'Moodle non è del tutto compatibile con il safe mode, per favore chiedete all\'amministratore del server di impostare il safe mode ad off. Far girare Moodle con il safe mode ad on non è supportato e potrete riscontrare numerosi problemi.';
$string['setupsearchengine'] = 'Impostazione motore ricerca';
$string['showcommentscount'] = 'Visualizza il totale dei commenti';
$string['showdetails'] = 'Visualizza dettagli';
$string['showuseridentity'] = 'Visualizza identità dell\'utente';
$string['showuseridentity_desc'] = 'Quando si selezionano o cercano utenti e quando si visualizzano elenchi di utenti, è possibile visualizzare anche campi aggiuntivi oltre al nome e cognome. I campi aggiuntivi saranno comunque visibili solo ai ruoli che hanno il privilegio moodle/site:viewuseridentity, privilegio assegnato di default al ruolo Docente e Manager. (L\'impostazione può essere utile se si selezionano campi significativi per la propria organizzazione).

I campi contrassegnati da * sono campi personalizzati del profilo utente. È possibile selezionarli ma in alcune schermate non verranno visualizzati.';
$string['simplexmlrequired'] = 'Moodle richiede l\'estensione PHP SimpleXML.';
$string['sitemailcharset'] = 'Set di caratteri';
$string['sitemaintenance'] = 'Il sito è sottoposto a manutenzione e non è attualmente disponibile';
$string['sitemaintenancemode'] = 'Manutenzione';
$string['sitemaintenanceoff'] = 'La modalità manutenzione è stata disattivata e il sito è nuovamente operativo.';
$string['sitemaintenanceon'] = 'Il sito è attualmente in manutenzione (solo gli amministratori possono collegarsi o utilizzare il sito).';
$string['sitemaintenanceoncli'] = 'Il tuo sito è in modalità manutenzione CLI e non è consentito l\'accesso via web.';
$string['sitemaintenancetitle'] = '{$a} in manutenzione';
$string['sitemaintenancewarning'] = 'Il sito al momento è in manutenzione (solo gli amministratori possono collegarsi o utilizzare il sito). Per ripristinare la normale operatività, <a href="maintenance.php">disattivare la modalità manutenzione</a>.';
$string['sitemaintenancewarning2'] = 'Il sito al momento è in manutenzione (solo gli amministratori possono collegarsi o utilizzare il sito). Per ripristinare la normale operatività, <a href="{$a}"> disattivare la modalità manutenzione</a>.';
$string['sitemenubar'] = 'Navigazione del sito';
$string['sitenameintitle'] = 'Includi il nome del sito nel titolo delle pagine';
$string['sitenameintitle_help'] = 'Il nome del sito sarà aggiunto alla fine del titolo della pagina. Si consiglia di includere il nome del sito nel titolo della pagina poiché migliorerà l\'accessibilità del sito consentendo agli utenti di identificare rapidamente la pagina in cui si trovano.attualmente.';
$string['sitepolicies'] = 'Impostazioni di sicurezza del sito';
$string['sitepolicy'] = 'URL delle politiche del sito';
$string['sitepolicy_help'] = 'L\'URL delle politiche del sito che gli utenti dovranno leggere e accettare prima di poter utilizzare il sito. Da notare che l\'impostazione avrà effetto solo se il gestore delle politiche è stato impostato al valore predefinito (core).';
$string['sitepolicyguest'] = 'URL politiche del sito per gli ospiti';
$string['sitepolicyguest_help'] = 'È possibile specificare l\'URL delle politiche del sito per gli ospiti. Le politiche dovranno essere accettate per poter utilizzare il sito. Da notare che l\'impostazione ha effetto solo se il gestore delle politiche del sito è quello di default (core)';
$string['sitepolicyhandler'] = 'Gestore politiche del sito';
$string['sitepolicyhandler_desc'] = 'Selezionare il componente per la gestione  delle politiche e dei consensi degli utenti. Il gestore predefinito (core) di default fornisce funzionalità semplificate per le politiche del sito e le politiche del sito per gli ospiti. È possibile impostare il gestore delle politiche in grado di offrire funzionalità evolute per l\'impostazione delle politiche e la gestione dei consensi.';
$string['sitepolicyhandlercore'] = 'Default (core)';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'È possibile visualizzare una sezione nella pagina home del sito.';
$string['sixtyfourbitsrequired'] = 'È stato rilevato che il sito non utilizza una versione del PHP a 64 bit. È necessario aggiornare il sistema (sistema operativo, PHP...) prima di installare questa versione di Moodle.';
$string['sixtyfourbitswarning'] = 'È stato rilevao che il sito utilizza una versione PHP che non è a 64bit. Per compatibilità futura si raccomanda di aggiornare il PHP.';
$string['slasharguments'] = 'Utilizza gli "slash arguments"';
$string['slashargumentswarning'] = 'Si raccomanda di abilitare l\'utilizzo degli slash arguments poiché in futuro tale requisito sarà obbligatorio. Per maggiori informazioni: <a href="https://docs.moodle.org/en/admin/environment/slasharguments">Utilizzare gli slash arguments</a>.';
$string['smartpix'] = 'Ricerca icone intelligente';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'Tipo di autenticazione SMTP';
$string['smtpdetail'] = 'Impostazioni Simple Mail Transfer Protocol (SMTP) per l\'invio di email';
$string['smtphosts'] = 'Host SMTP';
$string['smtpmaxbulk'] = 'Limite per sessione SMTP';
$string['smtppass'] = 'Password SMTP';
$string['smtpsecure'] = 'Sicurezza SMTP';
$string['smtpuser'] = 'Username SMTP';
$string['soaprecommended'] = 'L\'estensione opzionale SOAP è utile per i web service ed altri plugin.';
$string['sort_fullname'] = 'Titolo del corso';
$string['sort_idnumber'] = 'Codice identificativo corso';
$string['sort_shortname'] = 'Titolo abbreviato del corso';
$string['sort_sortorder'] = 'Ordinamento predefinito';
$string['spellengine'] = 'Correttore ortografico';
$string['spelllanguagelist'] = 'Elenco lingue per controllo ortografico';
$string['splrequired'] = 'Moodle ha ora bisogno della estensione PHP SPL.';
$string['stats'] = 'Statistiche';
$string['statsfirstrun'] = 'Intervallo massimo di elaborazione';
$string['statsmaxruntime'] = 'Tempo massimo di esecuzione';
$string['statsmoodleorg'] = 'statistiche';
$string['statsruntimedays'] = 'Giorni da elaborare';
$string['statsruntimestart'] = 'Eseguire alle';
$string['statsuserthreshold'] = 'Soglia utenti';
$string['stickyblocks'] = 'Blocchi permanenti';
$string['stickyblockscourseview'] = 'Pagina del corso';
$string['stickyblocksduplicatenotice'] = 'Se aggiungete blocchi permanenti che sono già presenti in una data pagina, tali blocchi risulteranno duplicati.<br />Se riscontrate questa situazione, tenete presente che solo i blocchi permanenti non potranno essere modificati, mentre i blocchi duplicati potranno essere spostati o eliminati.';
$string['stickyblocksmymoodle'] = 'Il mio Moodle';
$string['stickyblockspagetype'] = 'Tipo di pagina da configurare';
$string['strictformsrequired'] = 'Validazione stringente dei campi obbligatori';
$string['stripalltitletags'] = 'Rimuovi tag HTML dai nomi delle attività';
$string['supportandservices'] = 'Supporto e servizi';
$string['supportavailability'] = 'Disponibilità supporto';
$string['supportcontact'] = 'Contatto di supporto';
$string['supportemail'] = 'Email assistenza';
$string['supportemailsubject'] = 'Richiesta di supporto - {$a}';
$string['supportname'] = 'Nominativo assistenza';
$string['supportpage'] = 'Link alla pagina web assistenza';
$string['suspenduser'] = 'Sospendi account';
$string['switchlang'] = 'Cambia la cartella della lingua';
$string['systempaths'] = 'Percorsi di sistema';
$string['tablenosave'] = 'Le modifiche apportate nella tabella soprastante saranno salvate automaticamente.';
$string['tablesnosave'] = 'Le modifiche apportate nelle tabelle soprastanti saranno salvate automaticamente.';
$string['tabselectedtofront'] = 'Nelle tabelle con tab, il tab selezionato deve essere portato in primo piano?';
$string['tabselectedtofronttext'] = 'Porta in primo piano il tab selezionato';
$string['task_adhoc_concurrency_limit'] = 'Numero massimo di elaborazioni ad hoc contemporanee';
$string['task_adhoc_concurrency_limit_desc'] = 'Il numero massimo consentito di elaborazioni ad hoc contemporanee. Se il numero è alto, allora le elaborazioni pianificate potranno subire ritardi per la presenza di molte elaborazioni ad hoc. Impostando il valore a zero si disabilitano le elaborazioni ad hoc.';
$string['task_adhoc_max_runtime'] = 'Durata delle elaborazioni ad hoc';
$string['task_adhoc_max_runtime_desc'] = 'La durata di un\'elaborazione ad hoc prima che venga interrotta. Si raccomanda di impostare una durata breve poiché non ci sono limiti al numero di elaborazioni ad hoc in coda. Se la durata è alta, allora le elaborazioni pianificate potranno subire ritardi per la presenza di molte elaborazioni ad hoc.';
$string['task_dbreads'] = 'Letture database';
$string['task_dbstats'] = 'Database';
$string['task_dbwrites'] = 'Scritture database';
$string['task_duration'] = 'Durata';
$string['task_endtime'] = 'Data di fine';
$string['task_logmode'] = 'Utilizzo del log';
$string['task_logmode_all'] = 'Utilizza il log per l\'ouptut di tutte le elaborazioni';
$string['task_logmode_desc'] = 'È possibile selezionare le elaborazioni da registrare nel log. Di default tutte le elaborazione sono registrare. È possibile disabilitare il log o registrare solo le elaborazioni non andate a buon fine.';
$string['task_logmode_failonly'] = 'Utilizza il log solo per le elaborazioni non andate a buon fine';
$string['task_logmode_none'] = 'Non utilizzare il log';
$string['task_logoutput'] = 'Output dell\'elaborazione';
$string['task_logretainruns'] = 'Numero di elaborazioni da mantenere';
$string['task_logretainruns_desc'] = 'Il numero di elaborazioni pianificate da mantenere. L\'impostazione interagisce con l\'impostazione \'Tempo di conservazione\', sarà utilizzata l\'impostazione che viene soddisfatta prima.';
$string['task_logretention'] = 'Tempo di conservazione';
$string['task_logretention_desc'] = 'Il tempo massimo di conservazione del log. L\'impostazione interagisce con l\'impostazione \'Numero di elaborazioni da mantenere\', sarà utilizzata l\'impostazione che viene soddisfatta prima.';
$string['task_logtostdout'] = 'Visualizza l\'output del log';
$string['task_logtostdout_desc'] = 'Durante l\'elaborazione e acquisizione dei processi, imposta se l\'output deve essere visualizzato durante l\'elaborazione del processo.';
$string['task_result'] = 'Esito';
$string['task_result:failed'] = 'Errore';
$string['task_scheduled_concurrency_limit'] = 'Numero massimo di elaborazione pianificate contemporanee';
$string['task_scheduled_concurrency_limit_desc'] = 'Il numero massimo consentito di elaborazione pianificate contemporanee. Se il numero è alto, il server potrà subire degrado di prestazioni. Impostando il valore a zero si disabilitano le elaborazioni pianificate. Impostando il valore a zero si disabilita l\'elaborazione ad hoc.';
$string['task_scheduled_max_runtime'] = 'Durata delle elaborazioni pianificate';
$string['task_scheduled_max_runtime_desc'] = 'La durata di un\'elaborazione pianificata prima che venga interrotta.';
$string['task_starttime'] = 'Ora d\'inizio';
$string['task_stats:dbreads'] = 'Letture: {$a}';
$string['task_stats:dbwrites'] = 'Scritture: {$a}';
$string['task_status'] = 'Stato dell\'elaborazione';
$string['task_status_desc'] = 'L\'elaborazione \'{$a->name}\' ha stato {$a->status}. Per maggiori dettagli vedere {$a->class}{$a->extradescription} in <a href="{$a->gotourl}">Elaborazioni pianificate</a>.';
$string['task_type:adhoc'] = 'Ad hoc';
$string['task_type:scheduled'] = 'Pianificata';
$string['taskadmintitle'] = 'Elaborazioni';
$string['taskanalyticscleanup'] = 'Pulizia analitica';
$string['taskautomatedbackup'] = 'Backup automatici';
$string['taskautomatedbackup_report'] = 'Report backup automatico';
$string['taskbackupcleanup'] = 'Pulizia tabelle del backup, dei log e dei file';
$string['taskbadgesadhoc'] = 'Rilascia badge';
$string['taskbadgescron'] = 'Rilascio badge';
$string['taskbadgesmessagecron'] = 'Elaborazione in background: invio notifiche dei badge';
$string['taskblogcron'] = 'Sincronizzazione blog esterni';
$string['taskcachecleanup'] = 'Rimozione elementi cache scaduti';
$string['taskcachecron'] = 'Elaborazione in background: cache';
$string['taskcalendarcron'] = 'Invio notifiche calendario';
$string['taskcheckforupdates'] = 'Controllo aggiornamenti';
$string['taskcompletiondaily'] = 'Indicazione di inizio al completamento';
$string['taskcompletionregular'] = 'Calcolo standard dei dati di completamento';
$string['taskcontextcleanup'] = 'Pulizia contesti';
$string['taskcreatecontexts'] = 'Creazione contesti mancanti';
$string['taskdeletecachetext'] = 'Eliminazione record di cache vecchi';
$string['taskdeleteincompleteusers'] = 'Eliminazione utenti con profilo non completato';
$string['taskdeleteunconfirmedusers'] = 'Eliminazione utenti non confermati';
$string['taskeventscron'] = 'Elaborazione in background: eventi';
$string['taskfiletrashcleanup'] = 'Pulizia file eliminati';
$string['taskglobalsearchindex'] = 'Indicizzazione della ricerca globale';
$string['taskglobalsearchoptimize'] = 'Ottimizzazione indici della ricerca globale';
$string['taskgradecron'] = 'Elaborazione in background: registro valutatore';
$string['taskgradehistorycleanup'] = 'Elaborazione in background: pulizia tabelle dello storico delle valutazioni';
$string['taskh5pcleanup'] = 'Pulizia file H5P non utilizzati';
$string['tasklegacycron'] = 'Elaborazione cron obsoleti dei pluign';
$string['tasklockcleanuptask'] = 'Pulizia metadati task ad hoc';
$string['tasklogcleanup'] = 'Pulizia log delle elaborazioni';
$string['tasklogging'] = 'Configurazione log delle elaborazioni';
$string['tasklogs'] = 'Log delle elaborazioni pianificate';
$string['taskmessagingcleanup'] = 'Elaborazione in background: messaggistica';
$string['taskpasswordresetcleanup'] = 'Pulizia tentativi recupero password';
$string['taskplagiarismcron'] = 'Elaborazione in background: cron obsoleti dei plugin prevenzione plagio';
$string['taskportfoliocron'] = 'Elaborazione in background: plugin portfolio';
$string['taskprocessing'] = 'Impostazione elaborazioni';
$string['taskquestioncron'] = 'Elaborazione in background: pulizia anteprime delle domande';
$string['taskquestionstatscleanupcron'] = 'Elaborazione in background: pulizia cache delle statistiche delle domande';
$string['taskrefreshsystemtokens'] = 'Aggiornamento token OAuth per gli account di servizio';
$string['taskregistrationcron'] = 'Registrazione del sito';
$string['tasksendfailedloginnotifications'] = 'Invio avvisi sui login errati';
$string['tasksendnewuserpasswords'] = 'Invio password ai nuovi utenti';
$string['tasksessioncleanup'] = 'Pulizia sessioni scadute';
$string['taskstatscron'] = 'Elaborazione in background: statistiche';
$string['tasktagcron'] = 'Elaborazione in background: tag';
$string['tasktempfilecleanup'] = 'Eliminazione file temporanei obsoleti';
$string['tasktype'] = 'Tipo';
$string['tempdatafoldercleanup'] = 'Elimina file temporanei dopo';
$string['templates'] = 'Modelli';
$string['testoutgoingmailconf'] = 'Test della configurazione email in uscita';
$string['testoutgoingmailconf_errorcommunications'] = 'Non è stato possibile mettersi in comunicazione con il mail server. È necessario controllare la configurazione delle email in uscita.';
$string['testoutgoingmailconf_fromemail'] = 'Username o indirizzo email \'From\'';
$string['testoutgoingmailconf_fromemail_help'] = 'Il campo simula l\'invio del messaggio da parte di questo utente, tuttavia l\'intestazione \'From\' utilizzata nelle mail realmente spedite dipenderà da altre impostazioni, come ad esempio allowedemaildomains';
$string['testoutgoingmailconf_fromemail_invalid'] = 'Lo username o l\'indirizzo email \'From\' non è valido. Deve essere un formato email valido oppure uno username già esistente in Moodle.';
$string['testoutgoingmailconf_message'] = 'Il presente messaggio conferma la corretta configurazione delle email in uscita. Inviato: {$a}';
$string['testoutgoingmailconf_sendtest'] = 'Invia messaggio di test';
$string['testoutgoingmailconf_sentmail'] = 'La consegna al mail server del messaggio di prova è avvenuta correttamente <br />Da: {$a->fromemail}<br />A: {$a->toemail}';
$string['testoutgoingmailconf_subject'] = '{$a->site}: messaggio di prova. {$a->additional} Inviato: {$a->time}';
$string['testoutgoingmailconf_subjectadditional'] = 'Oggetto aggiuntivo';
$string['testoutgoingmailconf_toemail'] = 'Email destinatario';
$string['testoutgoingmaildetail'] = 'Nota: prima di svolgere la prova è necessario salvare la configurazione.<br />{$a}';
$string['testsiteupgradewarning'] = 'Stai  utilizzando il sito di test {$a}, per aggiornarlo correttamente utilizzare l\'interfaccia a linea di comando.';
$string['themedefinedinconfigphp'] = 'Il tema non può essere modificato poiché è impostato a {$a} nel file config.php';
$string['themedesignermode'] = 'Modalità Theme designer';
$string['themedesignermodewarning'] = 'È abilitata la modalità Theme designer. In siti di produzioni questa impostazione deve essere disabilitata perché riduce fortemente le prestazioni.';
$string['themelist'] = 'Elenco temi';
$string['themenoselected'] = 'Non è stato selezionato nessun tema';
$string['themeresetcaches'] = 'Elimina le cache dei temi';
$string['themeselect'] = 'Cambia tema';
$string['themeselector'] = 'Selettore tema';
$string['themesettings'] = 'Impostazioni tema';
$string['therewereerrors'] = 'Si sono verificati errori nei vostri dati';
$string['thirdpartylibrary'] = 'Libreria';
$string['thirdpartylibrarylocation'] = 'Posizione';
$string['thirdpartylibs'] = 'Librerie di terze parti';
$string['timezone'] = 'Fuso orario di default';
$string['timezoneforced'] = 'L\'amministratore può scegliere di non consentire agli utenti di scegliere il proprio fuso orario.';
$string['timezoneinvalid'] = 'Fuso orario "{$a}" non valido';
$string['timezoneisforcedto'] = 'Obbligare tutti gli utenti all\'utilizzo';
$string['timezonenotforced'] = 'Gli utenti possono scegliere il proprio fuso orario';
$string['timezonephpdefault'] = 'Fuso orario PHP di default ({$a})';
$string['timezoneserver'] = 'Fuso orario del server ({$a})';
$string['tlswarning'] = 'Non sono state rilevate estensioni PHP/cURL con il supporto TLSv1.2. Si raccomanda fortemente di aggiornare le librerie TLS.';
$string['tokenduration'] = 'Durata dei token creati dagli utenti';
$string['tokenduration_desc'] = 'Imposta la durata temporale dei token web service creati dagli utenti (ad esempio tramite app mobile).';
$string['tokenizerrecommended'] = 'È raccomandata l\'installazione di Tokenizer - estensione opzionale del PHP - per migliorare la funzionalità del Moodle Networking.';
$string['tools'] = 'Tool amministrativi';
$string['toolsmanage'] = 'Gestione tool amministrativi';
$string['unattendedoperation'] = 'Operazione non assistita';
$string['unbookmarkthispage'] = 'Rimuovi questa pagina dai segnalibri';
$string['unicoderequired'] = 'È richiesto che tutti i dati vengano memorizzati in formato Unicode (UTF-8). Le nuove installazioni dovrebbero essere effettuate in database che hanno il proprio set di caratteri default impostato come Unicode. Se si sta facendo un aggiornamento, bisogna eseguire il processo di migrazione UTF-8 (vedi pagina di Amministrazione).';
$string['uninstallplugin'] = 'Rimuovi';
$string['unlockaccount'] = 'Sblocca profilo';
$string['unoconvwarning'] = 'La versione di unoconv installata non è supportata.';
$string['unsettheme'] = 'Deseleziona tema';
$string['unsupported'] = 'Non supportato';
$string['unsupporteddbfileformat'] = 'Il database utilizza il formato file Antelope. Per avere un supporto completo UTF-8 sia con MySQL sia con MariaDB è necessario utilizzare il formato file Barracuda. Per favore convertire le tabelle in formato Barracuda. Per dettagli sulla conversione, consultare la documentazione <a href="https://docs.moodle.org/en/admin/environment/custom check/mysql full unicode support">MySQL full unicode support</a>.';
$string['unsupporteddbfilepertable'] = 'Per avere un supporto completo UTF-8 sia in MySQL sia in MariaDB è necessario impostare \'innodb_file_per_table\' a \'ON\'. Per maggiori informazioni consultare la documentazione.';
$string['unsupporteddblargeprefix'] = 'Per avere un supporto completo UTF-8 sia in MySQL sia in MariaDB è necessario impostare \'innodb_large_prefix\' a \'ON\'. Per maggiori informazioni consultare la documentazione.';
$string['unsupporteddbstorageengine'] = 'Lo storage engine utilizzato dal database non è più supportato.';
$string['unsupporteddbtablerowformat'] = 'Il database utilizza il formato file Antelope. Si raccomanda di convertire le tabelle nel formato file Barracuda. Per dettagli su come convertire le tabelle InnoDB in formato Barracuda, è disponibile la documentazione: <a href="https://docs.moodle.org/en/cli">Administration via command line</a>';
$string['unsupportedphpversion7'] = 'La versione 7 o superiore del PHP non è supportata.';
$string['unsupportedphpversion71'] = 'La versione 7.1 o superiore del PHP non è supportata.';
$string['unsupportedphpversion72'] = 'La versione 7.2 o superiore del PHP non è supportata.';
$string['unsupportedphpversion73'] = 'La versione 7.3 o superiore del PHP non è supportata.';
$string['unsupportedphpversion74'] = 'La versione 7.4 o superiore del PHP non è supportata.';
$string['unsupportedphpversion80'] = 'La versione 8.0 o superiore del PHP non è supportata.';
$string['unsupportedphpversion81'] = 'La versione 8.1 o superiore del PHP non è supportata.';
$string['unsupportedphpversion82'] = 'Il PHP versione 8.2 e successive non sono supportate.';
$string['unsupportedphpversion83'] = 'Il PHP versione 8.3 e superiori non sono supportati.';
$string['unsuspenduser'] = 'Attiva account';
$string['updateaccounts'] = 'Aggiornare registrazioni esistenti';
$string['updateautocheck'] = 'Controllo automatico degli aggiornamenti';
$string['updateautocheck_desc'] = 'Attiva il controllo automatico degli aggiornamenti sia per Moodle e per plugin addizionali. In presenza di aggiornamenti, sarà inviato un messaggio all\'amministratore del sito.';
$string['updateavailable'] = 'È disponibile una nuova versione di Moodle!';
$string['updateavailable_moreinfo'] = 'Maggiori informazioni...';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Versione {$a}';
$string['updateavailabledetailslink'] = 'Per maggiori informazioni: {$a->url}';
$string['updateavailableforplugin'] = 'Sono disponibili nuove versioni per alcuni plugin addizionali!';
$string['updateavailableinstall'] = 'Installa questo aggiornamento';
$string['updateavailableinstallall'] = 'Installa gli aggiornamenti disponibili ({$a})';
$string['updateavailableinstallallhead'] = 'Installazione degli aggiornamenti in corso';
$string['updateavailablenot'] = 'Il codice di Moodle è aggiornato!';
$string['updateavailablerecommendation'] = 'Si raccomanda fortemente di aggiornare il sito alla versione più recente disponibile per risolvere bug e problemi di sicurezza.';
$string['updatecomponent'] = 'Aggiornamento componenti';
$string['updateminmaturity'] = 'Code maturity richesta';
$string['updateminmaturity_desc'] = 'Avvisa sulla disponibilità degli aggiornamenti solo se il codice aggiornato ha la code maturity scelta. Gli aggiornamenti di plugin che non dichiarano la propria code maturity verranno riportati comunque indipendentemente da questa impostazione.';
$string['updatenotificationfooter'] = 'Il sito Moodle {$a->siteurl} è configurato per verificare automaticamente la disponibilità di aggiornamenti e ricevi questo messaggio in qualità di amministratore del sito. È possibile disabilitare il controllo automatico degli aggiornamenti nella sezione Amministrazione del sito/ Server / Notifiche degli aggiornamenti oppure  personalizzare il recapito delle notifiche tramite la pagina delle preferenze';
$string['updatenotifications'] = 'Notifiche sugli aggiornamenti';
$string['updatenotificationsubject'] = 'Sono disponibili aggiornamenti Moodle per ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Avvisa sulla disponibilità di nuove build';
$string['updatenotifybuilds_desc'] = 'Consente la ricezione di avvisi sulla disponibilità di build più recenti per la versione di Moodle in uso. Le build sono miglioramenti continui di una data versione di Moodle e sono di norma rilasciate con cadenza settimanale. Se questa opzione è disabilitata, saranno inviati avvisi solo in caso di disponibilità di una nuova versione di Moodle. L\'impostazione non influenza la verifica degli aggiornamenti dei plugin.';
$string['upgradeerror'] = 'Si è verificato un errore sconosciuto durante l\'aggiornamento del plugin {$a->plugin} alla versione {$a->version}, non è possibile proseguire.';
$string['upgradeforumread'] = 'Una nuova caratteristica è stata aggiunta a Moodle 1.5 per tracciare gli interventi letti/non letti di un forum.<br />Per utilizzarla, bisogna<a href="{$a}">aggiornare le vostre tabelle</a>.';
$string['upgradeforumreadinfo'] = 'Una nuova caratteristica è stata aggiunta da Moodle 1.5 per tracciare i messaggi letti/non letti di un forum. Per utilizzarla, bisogna aggiornare le tabelle con tutte le informazioni di tracciamento dei messaggi pre-esistenti. Il tempo di esecuzione dipende dalle dimensioni del sito e potrebbe durare anche ore, sottoponendo il server ad un lavoro gravoso. È dunque consigliabile farlo in un momento tranquillo. In ogni caso, il sito continuerà a funzionare durante questa operazione e gli utenti non ne saranno interessati. Una volta lanciato, il processo non dovrebbe essere interrotto, lasciando aperta la finestra del browser. Se si fermasse il processo, chiudendo la finestra del browser, niente paura: si può sempre ricominciare. < br /><br />Si desidera iniziare adesso il processo di aggiornamento?';
$string['upgradekeyreq'] = 'Chiave per l\'aggiornamento';
$string['upgradekeyset'] = 'Chiave per l\'aggiornamento (lasciare vuoto se non impostata)';
$string['upgradelogs'] = 'Per la piena funzionalità, i vostri vecchi log devono essere aggiornati. <a href="{$a}">Ulteriori informazioni</a>';
$string['upgradelogsinfo'] = 'Alcune modifiche hanno cambiato il modo in cui vengono salvati alcuni log. Per poter visualizzare tutti i vecchi log su una base di per-attività , è necessario aggiornarli. In base al tuo sito questa operazione può richiedere molto tempo (es alcune ore) e può essere grosso lavoro per la base dati dei siti grandi. Una volta che l\'aggiornamento è iniziato devi lasciarlo terminare (mantenendo la finestra del browser aperta). Non preoccuparti - il tuo sito continuerà  a lavorare correttamente mentre i log vengono aggiornati.<br /><br />Vuoi aggiornare i log ora?';
$string['upgradepluginsfirst'] = 'Si consiglia di scaricare ed installare manualmente tutti gli aggiornamenti disponibili';
$string['upgradepluginsinfo'] = 'Aggiornamento plugin';
$string['upgradepluginsinfo_help'] = 'Sono disponibili aggiornamenti per uno o più plugin. È necessario installare le versioni aggiornate prima di eseguire l\'aggiornamento del Database di Moodle, Se l\'installazione automatica degli aggiornamenti è disabilitata, devi scaricare gli aggiornamenti ed installarli manualmente.';
$string['upgradepluginsinfo_link'] = 'admin/upgradepluginsinfo';
$string['upgradesettings'] = 'Nuove impostazioni';
$string['upgradesettingsintro'] = 'Le impostazioni sotto elencate sono state aggiunte durante l\'aggiornamento di Moodle. Apportare i cambiamenti necessari ai valori di default e poi cliccare su "Salva modifiche" in fondo alla pagina';
$string['upgradestalefiles'] = 'Sono state individuate versioni di Moodle incoerenti, l\'upgrade non può proseguire';
$string['upgradestalefilesinfo'] = 'L\'aggiornamento di Moodle è stato sospeso poiché nella cartella di installazione sono stati individuati script PHP appartenenti ad almeno due versioni diverse di Moodle.

Poiché la cosa può causare problemi gravi, devi accertarti che la cartella di installazione contenga solo i file appartenenti alla stessa versione.

Si suggerisce di procedere nel modo seguente:

* rinomina la cartella di installazione in "moodle_old"
* crea una nuova cartella di installazione contenente solo i file provenienti da un download di un pacchetto Moodle oppure ottenuti via repository Git
* sposta dalla cartella"moodle_old" nella nuova cartella il file config.php  e tutti i plugin non appartenenti alla distribuzione ufficiale

Una volta ottenuta una cartella di installazione pulita, ricarica questa pagina per riavviare il processo di aggiornamento di Moodle.

Questo messaggio è spesso causato dalla decompressione di pacchetti Moodle in una cartella che contiene già una versione precedente. Sebbene sia possibile eseguire questa operazione per aggiornamenti della stessa versione, è invece fortemente sconsigliato di farla quando si aggiorna ad una nuova versione.

Lo stesso messaggio può essere generato da un checkout incompleto da un repository Git, nel qual caso devi solo attendere che il checkout si completi correttamente prima di proseguire.

Per maggiori informazion sull\'upgrade: <a href="{$a}">{$a}</a>';
$string['upgradestart'] = 'Aggiorna il database di Moodle';
$string['upgradesure'] = '<p>I file di Moodle sono stati modificati e il sito sta per essere aggiornato alla versione:</p>
<p><strong>{$a}</strong></p>
<p>Una volta avviato l\'aggiornamento non sarà  possibile tornare indietro. Tenere presente che l\'elaborazione può durare a lungo.</p>
<p>Sei sicuro di continuare ?</p>';
$string['upgradetimedout'] = 'L\'aggiornamento è andato in timeout. Per favore riavvia l\'aggiornamento.';
$string['upgradingdata'] = 'Aggiornamento dei dati';
$string['upgradinglogs'] = 'Aggiornamento dei log';
$string['upgradingversion'] = 'Aggiornamento alla nuova versione';
$string['upwards'] = 'ed oltre';
$string['useblogassociations'] = 'Abilita associazioni';
$string['user'] = 'Utente';
$string['userbulk'] = 'Azioni in massa';
$string['userbulkdownload'] = 'Esporta utenti come';
$string['userdefaultpreferences'] = 'Preferenze utente di default';
$string['userfeedbackafterupgrade'] = 'Dopo ogni aggiornamento di versione';
$string['userfeedbackencouragement'] = '<p>Moodle include una funzionalità che offre agli utenti la possibilità di fornire feedback sul software Moodle tramite un sito di sondaggi esterno ospitato dal quartier generale di Moodle. Nessuna informazione identificativa dell\'utente sarà inoltrata al sito che ospita il sondaggio.</p>
<p>Moodle HQ si impegna a essere aperto e trasparente riguardo le proprie pratiche di raccolta dati. Pertanto, vogliamo assicurarci che tu sia a conoscenza e abbia il controllo di questa funzionalità.</p>
<p>Il feedback degli utenti aiuta il quartier generale di Moodle a migliorare il software Moodle. Per abilitare questa funzione, vai alle <a href="{$a}">Impostazioni feedback</a>.</p>';
$string['userfeedbacknextreminder'] = 'Prossimo promemoria feedback';
$string['userfeedbacknextreminder_desc'] = 'Imposta quando visualizzare di nuovo il promemoria del feedback.';
$string['userfeedbackperiodically'] = 'Periodicamente';
$string['userfeedbackremindafter'] = 'Visualizza promemoria dopo';
$string['userfeedbackremindafter_desc'] = 'Consente di visualizzare il promemoria dopo il numero di giorni impostato.';
$string['userfiltersdefault'] = 'Filtri utente di default';
$string['userfiltersdefault_desc'] = 'Seleziona i filtri che devono essere visualizzati nella pagina \'Sfoglia elenco di utenti\' e nella pagina \'Azioni utente in blocco\'. Tieni premuto il tasto Ctrl per selezionare più elementi. Eventuali filtri non selezionati saranno disponibili facendo clic sul collegamento \'Visualizza altro\'.';
$string['userimagesdisabled'] = 'Le immagini del profilo utente sono disabilitate.';
$string['userlist'] = 'Elenco utenti';
$string['usermanagement'] = 'Gestione utenti';
$string['userpolicies'] = 'Politiche utente';
$string['userpreference'] = 'Preferenze utente';
$string['userquota'] = 'Spazio per i file privati';
$string['userquota_desc'] = 'La quantità massima di dati che un utente può memorizzare nella propria area dei file privati.';
$string['users'] = 'Utenti';
$string['usesitenameforsitepages'] = 'Utilizza il nome del sito per le pagine del sito';
$string['usetags'] = 'Abilita Tag';
$string['validateemptylineerror'] = 'Le linee vuote non sono valide';
$string['validateerror'] = 'Questo valore non è valido';
$string['validateerrorlist'] = 'Queste voci non sono valide: {$a}';
$string['validateiperror'] = 'Questi indirizzi IP non sono validi: {$a}';
$string['verifychangedemail'] = 'Controlla i domini quando si cambia l\'email';
$string['warningcurrentsetting'] = 'Valore corrente non valido: {$a}';
$string['warningiconvbuggy'] = 'La versione della libreria iconv installata non supporta il modifier //IGNORE. Puoi installare l\'estensione mbstring che può essere utilizzata in alternativa per pulire le stringhe contenenti caratteri UTF-8 non validi.';
$string['webproxy'] = 'Proxy web';
$string['webproxyinfo'] = 'Utilizzare le impostazioni seguenti se il server Moodle non può accedere direttamente ad Internet. L\'accesso ad Internet è necessario per scaricare dati di ambiente, language pack, feed RSS, timezone, eccetera.<br /><em>L\'estensione PHP cURL è fortemente consigliata.</em>';
$string['xmlrpcwebserviceenabled'] = 'È stato rilevato che su questo sito è attivo il protocollo web service XML-RPC. Questa funzionalità si basa sull\'estensione PHP XML-RPC che non più mantenuta da PHP.';
$string['yuicomboloading'] = 'Caricamento YUI combo';
$string['ziprequired'] = 'Moodle richiede l\'estensione Zip PHP. Gli eseguibili info-ZIP o la libreria PclZip non sono più utilizzati.';
