<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'tr', version '4.3'.
 *
 * @package     quiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Bu sınavı önizleme olarak yapabilirsiniz, ancak bu gerçek bir sınav olsaydı, engellenirdiniz çünkü:';
$string['action'] = 'Eylem';
$string['activityoverview'] = 'Bitiş tarihi yaklaşan sınavlarınız bulunmaktadır';
$string['adaptive'] = 'Uyarlamalı mod';
$string['adaptive_help'] = 'Eğer etkinleştirilirse sınavdakı aynı uygulamada soruya birden fazla cevaplanmasına izin verilir. Örneğin cevap yanlış olduğunda öğrencinin  tekrar deneme yapmasına izin verilecektir. Ancak "Cezaları uygula" ayarına bağlı olarak her yanlış cevap için puandan kesinti yapılacaktır.';
$string['add'] = 'Ekle';
$string['addaquestion'] = 'yeni bir soru';
$string['addarandomquestion'] = 'rasgele bir soru';
$string['addarandomquestion_help'] = 'Rastgele bir soru eklendiğinde, kategoriden rastgele seçilmiş bir sorunun sınava eklenmesine neden olur. Bu da farklı öğrencilerin farklı sorularla karşılaşabileceği anlamına gelir ve bir sınav birden fazla denemeye izin verdiğinde her denemede yeni bir soru seçimi olması muhtemeldir.';
$string['addarandomquestion_success'] = 'Random sorular eklendi';
$string['addarandomselectedquestion'] = 'Rastgele seçilen soru ekle...';
$string['addasection'] = 'yeni bir bölüm başlığı';
$string['adddescriptionlabel'] = 'Açıklama ögesi ekle';
$string['addingquestion'] = 'Soru ekleniyor';
$string['addingquestions'] = '<p>Sayfanın bu tarafı soru bankasını yöneteceğiniz yerdir. Soruları daha kolay sınıflandırmanız için kategorilere ayrılırlar. Ayrıca \'yayınla\' yı seçerseniz bu sorular herhangi bir sınavda veya diğer kurslarda kullanılabilir.</p>
<p>Bir soru kategorisi seçtikten veya oluşturduktan sonra soruları düzenleyebilirsiniz. Sayfanın diğer tarafında soruları sınavınıza ekleyebilirsiniz. </p>';
$string['addmoreoverallfeedbacks'] = '{no} geribildirim alanı daha ekle';
$string['addnewgroupoverride'] = 'Gruplamayı geçersiz kılmayı ekleyiniz';
$string['addnewpagesafterselected'] = 'Sorular seçildikten sonra yeni sayfa ekle';
$string['addnewquestionsqbank'] = '{$a->catname} kategorisine soru ekle: {$a->link}';
$string['addnewuseroverride'] = 'Kullanıcı geçersiz kılmayı ekle';
$string['addpagebreak'] = 'Sayfa sonu ekle';
$string['addpagehere'] = 'Bu araya sayfa ekle';
$string['addquestion'] = 'Soru ekle';
$string['addquestionfrombankatend'] = 'En sona soru bankasından ekleyin';
$string['addquestionfrombanktopage'] = 'Sayfa {$a}\'ya rastgele soru ekle';
$string['addquestions'] = 'Soru ekle';
$string['addquestionstoquiz'] = 'Şu anki sınava soru ekle';
$string['addrandom'] = 'Rasgele {$a} soru ekle';
$string['addrandom1'] = '<< Ekle';
$string['addrandom2'] = 'rasgele sorular';
$string['addrandomfromcategory'] = 'Kategoriden rastgele soru ekle:';
$string['addrandomquestion'] = 'Rastgele soru ekle';
$string['addrandomquestionatend'] = 'Sonunda rastgele bir soru ekleyin';
$string['addrandomquestiontopage'] = 'Sayfa {$a}\'ya rastgele soru ekle';
$string['addrandomquestiontoquiz'] = '{$a} sınavına rastgele soru ekle';
$string['addselectedquestionstoquiz'] = 'Seçilen soruları sınava ekle';
$string['addselectedtoquiz'] = 'Seçileni sınava ekle';
$string['addtoquiz'] = 'Sınava ekle';
$string['affectedstudents'] = 'Etkilenen {$a}';
$string['aftereachquestion'] = 'Her soruyu ekledikten sonra';
$string['afternquestions'] = '{$a} soru ekledikten sonra';
$string['age'] = 'yaş';
$string['allattempts'] = 'Tüm uygulamalar';
$string['allinone'] = 'Sınırsız';
$string['allowreview'] = 'Yeniden gözden geçirme izni';
$string['alreadysubmitted'] = 'Bu denemeyi daha önceden yapmış görünüyorsunuz';
$string['alternativeunits'] = 'Alternatif birimler';
$string['alwaysavailable'] = 'Her zaman erişilebilir';
$string['alwayslatest'] = 'Her zaman en yeni';
$string['analysisoptions'] = 'Analiz seçenekleri';
$string['analysistitle'] = 'Öge analiz tablosu';
$string['answer'] = 'Cevap';
$string['answered'] = 'Cevap verildi';
$string['answerhowmany'] = 'Tek veya çok cevaplı';
$string['answers'] = 'Cevaplar';
$string['answersingleno'] = 'Birden fazla cevap verilebilir';
$string['answersingleyes'] = 'Sadece tek cevaplı';
$string['answertoolong'] = '{$a} satırından sonraki cevap çok uzun (max 255 karakter)';
$string['anytags'] = 'Herhangi bir etiket';
$string['aon'] = 'AON biçimi';
$string['areyousureremoveselected'] = 'Seçili tüm soruları silmek istediğinizden emin misiniz?';
$string['asshownoneditscreen'] = 'Düzenleme ekranında göründüğü gibi';
$string['attempt'] = '{$a}. uygulama';
$string['attemptalreadyclosed'] = 'Bu deneme zaten tamamlanmış';
$string['attemptclosed'] = 'Deneme daha bitmemiş';
$string['attemptduration'] = 'Geçen süre';
$string['attemptedon'] = 'Deneme zamanı';
$string['attempterror'] = 'Şuan bu sınavda bu uygulamaya izin verilmiyor Çünkü:  {$a}';
$string['attempterrorcontentchange'] = 'Bu sınavın önizlemesi artık etkin değil. (Bir sınav düzenlendiğinde, süreç içerisindeki önizlemeler otomatik olarak silinir.)';
$string['attempterrorcontentchangeforuser'] = 'Bu sınav denemesi artık etkin değil.';
$string['attempterrorinvalid'] = 'Geçersiz sınav denemesi ID\'si';
$string['attemptfirst'] = 'İlk deneme';
$string['attemptgradeddelay'] = 'Gecikmiş not verilecek deneme uyarısı';
$string['attemptgradeddelay_desc'] = 'Öğretmenin notu düzenlemesi için zaman tanımak amacıyla not verilen deneme bildirimleri gönderilmeden önce bir gecikme uygulanır.';
$string['attemptincomplete'] = '{$a} tarafından yapılan deneme henüz tamamlanmadı.';
$string['attemptlast'] = 'Son deneme';
$string['attemptnumber'] = 'Deneme';
$string['attemptquiz'] = 'Sınav denemesi';
$string['attemptquiznow'] = 'Sınavı şimdi uygula';
$string['attemptreviewtitle'] = '{$a}: Deneme incelemesi';
$string['attemptreviewtitlepaged'] = '{$a->name}: Denemesiin ({$a->totalpages} (sayfanın {$a->currentpage} sayfası) nın) önizlemesi';
$string['attempts'] = 'Denemeler';
$string['attempts_help'] = 'İzin verilen toplam deneme sayısı (ekstra deneme sayısı değil).';
$string['attemptsallowed'] = 'Deneme hakkı';
$string['attemptsdeleted'] = 'Sınav denemeleri silindi';
$string['attemptselection'] = 'Hangi deneme analiz edilecek:';
$string['attemptsexist'] = 'Artık soru ekleyemez veya çıkaramazsınız.';
$string['attemptsnum'] = 'Deneme: {$a}';
$string['attemptsnumthisgroup'] = 'Deneme: {$a->total} (bu gruptan {$a->group})';
$string['attemptsnumyourgroups'] = 'Deneme: {$a->total} (gruplarınızdan {$a->group})';
$string['attemptsonly'] = 'Sadece denemesine katılan öğrencileri göster';
$string['attemptstate'] = 'Durum';
$string['attemptstillinprogress'] = 'Deneme halen devam ediyor';
$string['attemptsummarytitle'] = '{$a}: Deneme özeti';
$string['attemptsunlimited'] = 'Sınırsız deneme';
$string['attempttitle'] = '{$a}';
$string['attempttitlepaged'] = '{$a->name} ({$a->totalpages} sayfasından {$a->currentpage} sayfası)';
$string['autosaveperiod'] = 'Otomatik kaydetme gecikmesi';
$string['autosaveperiod_desc'] = 'Test denemeleri sırasında yanıtlar otomatik olarak kaydedilebilir.  Yanıtlar, her değiştirildiğinde ve ardından bu gecikmeden sonra kaydedilir.  Bir değiş tokuş vardır: daha kısa bir gecikme, sunucu yükünü artırır, ancak öğrencilerin çalışmalarını kaybetme olasılığını azaltır.  Bu gecikmeyi çok daha kısa yapacaksanız, değeri kademeli olarak değiştirmeli ve sunucu yükünü izlemelisiniz.  Yük çok yükselirse, gecikmeyi tekrar uzatın.  Gecikmeyi 0 olarak ayarlamak otomatik kaydetmeyi kapatır.';
$string['back'] = 'Soruyu önizlemeye geri dön';
$string['backtocourse'] = 'Kursa dön';
$string['backtoquestionlist'] = 'Soru listesine dön';
$string['backtoquiz'] = 'Sınav düzenlemeye dön';
$string['basicideasofquiz'] = 'Sınav yapmak için temel fikirler';
$string['bestgrade'] = 'En yüksek not';
$string['bothattempts'] = 'Uygulama yapan ve yapmayan öğrencileri göster';
$string['browsersecurity'] = 'Tarayıcı güvenliği';
$string['browsersecurity_help'] = '"  JavaScript ile Tam ekran güvenli açılır pencere" seçilirse

*Sınav sadece Tarayıcı sayfasında JavaScript\'i etkinleştiren öğrenciler için başlayacaktır.
*Sınav tam ekran ve diğer tüm pencelereleri kapatan ve üzerinde gezinti çubukları olmayan bir sayfada görüntülenecektir.
*Mümkün olduğunca öğrencilerin kopyala ve yapıştır komutlarını kullanmaları engellenir.';
$string['cachedef_overrides'] = 'Kullanıcı ve grup geçersiz kılma bilgileri';
$string['calculated'] = 'Hesaplanan';
$string['calculatedquestion'] = '{$a}. satırdaki hesaplanan soru desteklenmiyor. Soru yok sayılacak';
$string['cannotcreatepath'] = 'Yol oluşturulamıyor ({$a})';
$string['cannoteditafterattempts'] = 'Bu sorular daha önceden uygulandığından  ({$a}) soru ekleyemez veya çıkaramazsınız.';
$string['cannotfindprevattempt'] = 'Üzerine inşa  edilecek önceki uygulama  bulunamıyor';
$string['cannotfindquestionregard'] = 'Yeniden not vermek için sorular getirilirken hata oluştu!';
$string['cannotinsert'] = 'Soru eklenemedi';
$string['cannotinsertrandomquestion'] = 'Rastegele soru eklenemedi!';
$string['cannotloadquestion'] = 'Soru seçenekleri yüklenemedi';
$string['cannotloadtypeinfo'] = 'Soru türlerinden özel soru bilgisi yüklenemiyor';
$string['cannotopen'] = 'Verilen dosya açılamadı ({$a})';
$string['cannotremoveallsectionslots'] = '\'{$a}\' bölüm başlığı altındaki tüm soruları seçtiniz.  Bir bölüm başlığı altındaki tüm soruların kaldırılmasına izin verilmez.';
$string['cannotremoveslots'] = 'Sorular kaldırılamıyor';
$string['cannotrestore'] = 'Soru oturumları geri yüklenemedi';
$string['cannotreviewopen'] = 'Bu uygulamaya gözatamazsınız. Uygulama hala açık.';
$string['cannotsavelayout'] = 'Düzen kaydedilemedi';
$string['cannotsavenumberofquestion'] = 'Safya başına soruların sayısı kaydedilemedi';
$string['cannotsavequestion'] = 'Soru listesi kaydedilemedi';
$string['cannotsetgrade'] = 'Sınav için yeni en yüksek not ayarı kaydedilemedi';
$string['cannotsetsumgrades'] = 'Not özeti ayarlanamadı';
$string['cannotstartgradesmismatch'] = 'Bu sınavda uygulama yapılamıyor. Sınav {$a->grade} kademeli olarak ayarlanır. Fakat soruların hiç birinin puan değeri belirtilmemiş. Bu hata sayfadaki \'Sınavı düzen\' den düzeltilebilir.';
$string['cannotstartmissingquestion'] = 'Bu sınavda uygulama yapılamıyor. Sınav tanımı, var olmayan bir soru içeriyor.';
$string['cannotstartnoquestions'] = 'Bu sınavda uygulama yapılamaz.  Bu sınav henüz yapılandırılmadı. Hiç bir soru eklenmedi';
$string['cannotwrite'] = 'Verilen dosyaya yazılamadı ({$a})';
$string['canredoquestions'] = 'Bir deneme içinde tekrar yapmaya izin ver';
$string['canredoquestions_desc'] = 'Bu seçenek etkinleştirildiğinde, bir soru denemeyi tamamladıktan sonra "Bu gibi başka bir soru dene" düğmesi görüntülenir. Bu, tüm sınav denemesinin gönderilmesi ve başka bir denemenin başlaması gerekmeden benzer bir sorunun (rastgele seçilen) veya aynı sorunun tekrar denenmesine olanak tanır. Bu seçenek, pratik sınavları için yararlıdır.

Bu ayar, yalnızca deneme gönderilmeden önce bir soruyu bitirmenin mümkün olduğu soru ve davranışları (anında geri bildirim veya birden fazla deneme ile etkileşim gibi) etkiler.';
$string['canredoquestions_help'] = 'Bu seçenek etkinleştirildiğinde, bir soru denemeyi tamamladıktan sonra "Bu gibi başka bir soru dene" düğmesi görüntülenir. Bu, tüm sınav denemesinin gönderilmesi ve başka bir denemenin başlaması gerekmeden benzer bir sorunun (rastgele seçilen) veya aynı sorunun tekrar denenmesine olanak tanır. Bu seçenek, pratik sınavları için yararlıdır.

Bu ayar, yalnızca deneme gönderilmeden önce bir soruyu bitirmenin mümkün olduğu soru ve davranışları (anında geri bildirim veya birden fazla deneme ile etkileşim gibi) etkiler.';
$string['canredoquestionsyes'] = 'Evet, başka bir soruyu deneme seçeneği sunun';
$string['caseno'] = 'Hayır, hArF duyarlılığı önemli değil';
$string['casesensitive'] = 'Harf duyarlılığı';
$string['caseyes'] = 'Evet, aynen uymalı';
$string['categoryadded'] = '\'{$a}\' kategorisi eklendi';
$string['categorydeleted'] = '\'{$a}\' kategorisi silindi';
$string['categorynoedit'] = '{$a}\' kategorinde düzenleme hakkına sahip değilsiniz.';
$string['categoryupdated'] = 'Kategori başarıyla güncellendi';
$string['close'] = 'Pencereyi kapat';
$string['closebeforeopen'] = 'Sınav güncellenemedi. Bitirme tarihini başlama tarihinden önce olarak belirttiniz.';
$string['closed'] = 'Kapandı';
$string['closepreview'] = 'Önizlemeyi kapat';
$string['closereview'] = 'İncelemeyi kapat';
$string['comment'] = 'Yorum';
$string['commentorgrade'] = 'Yorum yap veya tekrar not ver';
$string['comments'] = 'Yorumlar';
$string['completedon'] = 'Tamamlanma';
$string['completionattemptsexhausted'] = 'Geçme notu veya tüm denemelerin tamamlanması';
$string['completionattemptsexhausted_help'] = 'Öğrencilerin deneme sayıları maksimumuma ulaştığında, sınavı tamamlandı olarak işaretle';
$string['completiondetail:minattempts'] = '{$a} defa deneme yapın';
$string['completiondetail:passgrade'] = 'Geçer not alma';
$string['completiondetail:passorexhaust'] = 'Geçme notu alın veya mevcut tüm sınav uygulamalarını tamamlayın';
$string['completionminattempts'] = 'Minimum deneme';
$string['completionminattemptsdesc'] = 'Gerekli minimum deneme sayısı: {$a}';
$string['completionminattemptserror'] = 'Minimum deneme sayısı, izin verilen deneme sayısından düşük veya eşit olmalıdır.';
$string['completionminattemptsgroup'] = 'Deneme gereksin';
$string['completionpass'] = 'Geçme notu gereksin';
$string['completionpass_help'] = 'Etkinleştirilirse, öğrenci geçme notu (sınav ayarlarının Not bölümünde belirtildiği gibi) veya daha yüksek bir not aldığında bu etkinlik tamamlanmış sayılır.';
$string['completionpassdesc'] = 'Öğrenci bu aktiviteyi tamamlamak için geçer not almalıdır';
$string['completionpassorattemptsexhausteddesc'] = 'Öğrenci geçer not almalı veya bu etkinliği tamamlamak için mevcut tüm sınav uygulamalarını bitirmelidir.';
$string['configadaptive'] = 'Eğer bu sçeneğe evet derseniz, öğrencinin sınav yapıldığı esnada soruya birden fazla kez cevap vermesine izin verilecektir.';
$string['configattemptsallowed'] = 'Öğrencilerın sınav için izin verilen deneme sayısını kısıtlama getirilmesine izin verilir.';
$string['configdecimaldigits'] = 'Puanlar gösterilirken noktadan sonra gösterilecek ondalık basamak sayısı';
$string['configdecimalplaces'] = 'Sınav puanlar gösterilirken noktadan sonra gösterilecek ondalık basamak sayısı';
$string['configdecimalplacesquestion'] = 'Tek sorular için puanlar gösterilirken noktadan sonra gösterilecek ondalık basamak sayısı';
$string['configdelay1'] = 'Eğer bekleme süresi ayarlarsanız. Öğrenci ilk sınav uygulamasından sonra yeniden deneme yapabilmesi için bir süre beklemek zorunda kalacaktır.';
$string['configdelay1st2nd'] = 'Eğer burada  bekleme süresi ayarlarsanız, Öğrenci ilk sınav denemesinden sonra ikinci sınava bekleme süresini doldurmadan başlayamaz.';
$string['configdelay2'] = 'Eğer burada  bekleme süresi ayarlarsanız, öğrenci üçüncü ve sonraki denemeler içinayarlanan süre kadar beklemek zorundadır.';
$string['configdelaylater'] = 'Eğer burada  bekleme süresi ayarlarsanız, öğrenci üçüncü, dördüncü ...   denemeleri önceki uygulamalarından sonrası içinayarlanan süre kadar beklemek zorundadır.';
$string['configeachattemptbuildsonthelast'] = 'Birden çok deneme izin verilirse yeni uygulamalar önceki uygulamaların sonuçlarını da içerir.';
$string['configgrademethod'] = 'Birden çok denemeye izin verilirse öğrencinin sınav notu hesaplanırken hangi yöntemin kullanılacağı seçilmelidir.';
$string['configintro'] = 'Burada belirlediğiniz ayarlar, yeni sınav oluşturulurken varsayılan değer olarak kabul edilir. Ayrıca gelişmiş sınav ayarlarını da yapılandırabilirsiniz.';
$string['configmaximumgrade'] = 'Sınav puanı sınav için belirlenen puan aralağının dışındadır.';
$string['confignavmethod'] = 'Serbest gezinti çubuğunda,  soru gezinti çubuğunu kullanarak rastgele sırada cevap verilebilir. Sıralı sorulara sıralı cevap verilmelidir.';
$string['confignewpageevery'] = 'Soru eklediğinizde burda seçtiğiniz ayarlara göre sınav sayfalarında sayfa sonları otomatik olarak eklenecektir.';
$string['configoutcomesadvanced'] = 'Bu seçenek açık olursa,  Sınav düzenleme formunda gelişmiş ayarlar görüntülenir.';
$string['configpenaltyscheme'] = 'Uyarlamalı modda her yanlış cevap için ceza puanı kesilir.';
$string['configpopup'] = 'Açılır penceredeki sınav uygulamaları esnasında kopyala ve yapıştır vb hususları kısıtlamak için JavaScript ipuçlarını kullanın.';
$string['configrequirepassword'] = 'Öğrenciler sınav uygulamasından önce şifrelerini girmek zorundadırlar.';
$string['configrequiresubnet'] = 'Öğrenciler sadece bu bilgisayardan sınava katılabilirler.';
$string['configreviewoptions'] = 'Bu seçenek kullanıcıların kendi sınav uygulamalarını inceleme veya sınav raporlarını bakma ayarlarları bilgilerini kontrol etmenizi sağlar';
$string['configshowblocks'] = 'Sınav esnasında blokları göster.';
$string['configshowuserpicture'] = 'Sınav esnasında ekranda kullanıcıların resmini göster.';
$string['configshufflewithin'] = 'Bu seçeneği etkinleştirirseniz, seçeneğin soru ayarlarında da etkinleştirilmiş olması koşuluyla, bir öğrenci bu testte her denemeye başladığında tek tek soruları oluşturan bölümler rastgele karıştırılacaktır.';
$string['configtimelimit'] = 'Sınav için varsayılan dakika sınırı. 0 \'ın anlamı zaman sınırı yok demektir.';
$string['configtimelimitsec'] = 'Sınav için varsayılan saniye sınırı. 0 \'ın anlamı zaman sınırı yok demektir.';
$string['configurerandomquestion'] = 'Soru yapılandırılıyor';
$string['confirmclose'] = 'Cevaplarınızı gönderdikten sonra değiştiremezsiniz.';
$string['confirmremovequestion'] = 'Bu {$a} soruyu kaldırmak istediğinizden emin misiniz?';
$string['confirmremovesectionheading'] = '\'{$a}\' bölüm başlığını kaldırmak istediğinizden emin misiniz?';
$string['confirmserverdelete'] = '<b>{$a}</b> sunucunu listeden silmek istediğinizden emin misiniz?';
$string['connectionerror'] = 'Ağ bağlantısı kesildi. (Otomatik kaydetme başarısız oldu).

Bu sayfada son birkaç dakika içinde girilen cevaplarınız not edin, sonra yeniden bağlanmayı deneyin.

Bağlantı yeniden kurulduktan sonra cevaplarınızı  kaydedilir ve bu ileti kaybolur.';
$string['connectionok'] = 'Ağ bağlantısı geri yüklendi. Güvenle devam edebilirsiniz.';
$string['containercategorycreated'] = 'Bu kategori tüm orijinal kategoridekileri saklamak için oluşturuldu ve aşağıdaki sebepten dolayı site seviyesine taşındı.';
$string['continueattemptquiz'] = 'Denemeye devam et';
$string['continuepreview'] = 'Son gözden geçirmeden itibaren devam et';
$string['copyingfrom'] = '\'{$a}\' sorusunun bir kopyası oluşturuluyor';
$string['copyingquestion'] = 'Bir soru kopyalanıyor';
$string['correct'] = 'Doğru';
$string['correctanswer'] = 'Doğru yanıt';
$string['correctanswerformula'] = 'Doğru cevap formülü';
$string['correctansweris'] = 'Doğru yanıt: {$a}';
$string['correctanswerlength'] = 'Ondalık basamak sayısı';
$string['correctanswers'] = 'Doğru yanıtlar';
$string['correctanswershows'] = 'Doğru cevap gösterimi';
$string['corrresp'] = 'Doğru cevap';
$string['countdown'] = 'Sayaç';
$string['countdownfinished'] = 'Sınav bitiyor, cevaplarınızı şimdi göndermeniz gerekiyor.';
$string['countdowntenminutes'] = 'Sınav 10 dakika içinde bitecek.';
$string['coursetestmanager'] = 'Kurs Testi Yönetim biçimi';
$string['createcategoryandaddrandomquestion'] = 'Kategori oluştur ve rastgele soru ekle';
$string['createfirst'] = 'Önce birkaç kısa cevaplı soru oluşturmalısınız.';
$string['createmultiple'] = 'Sınava rasgele birkaç soru ekle';
$string['createnewquestion'] = 'Yeni soru oluştur';
$string['createquestionandadd'] = 'Yeni soru oluştur ve sınava ekle.';
$string['custom'] = 'Kişisel biçim';
$string['dataitemneed'] = 'Geçerli bir soru almak için veri kümesi ögeleri içinden en az bir tane eklemeniz gerekiyor.';
$string['datasetdefinitions'] = '{$a} kategorisi için yeniden kullanılabilir veri kümesi tanımlamaları';
$string['datasetnumber'] = 'Sayı';
$string['daysavailable'] = 'Erişime açık olduğu günler';
$string['decimaldigits'] = 'Notlardaki onluk sayılar';
$string['decimalplaces'] = 'Notlardaki ondalık sayılar';
$string['decimalplaces_help'] = 'Bu ayar, ondalık noktadan sonra Notları görüntülerken gösterilen basamak sayısını belirtir. Bu ayar Yalnızca notları, değil veritabanı, ve tam doğruluğu için yürütülen iç hesaplamaların sonucu oluşan notların görünümünü etkiler.';
$string['decimalplacesquestion'] = 'Soru notlarındaki ondalık sayılar';
$string['decimalplacesquestion_help'] = 'Soruların her biri için puanlar gösterilirken ondalık noktadan sonra gösterilen basamak sayısı.';
$string['decimalpoints'] = 'Ondalık basamak sayısı';
$string['default'] = 'Varsayılan';
$string['defaultgrade'] = 'Varsayılan soru notu';
$string['defaultinfo'] = 'Sorular için varsayılan kategori.';
$string['delay1'] = 'İlk ve ikinci deneme arasındaki gecikme zamanı';
$string['delay1st2nd'] = 'Birinci ve ikinci uygulama arasındaki mecburi bekleme süresi';
$string['delay1st2nd_help'] = 'Etkinleştirilirse, öğrencilerin sınavı ikinci kez uygulamak için belli bir süre beklemeleri gerekir.';
$string['delay2'] = 'Sonraki uygulamalar arasındaki gecikme zamanı';
$string['delaylater'] = 'Sonraki uygulamalardaki mecburi bekleme süresi';
$string['delaylater_help'] = 'Etkinleştirilirse, öğrencilerin sınavı üçüncü kez denemeden önce belli bir süre beklemesi gerekir.';
$string['deleteattemptcheck'] = 'Bu uygulamaların tamamını silmek istediğinizden emin misiniz?';
$string['deleteselected'] = 'Seçilileri sil';
$string['deletingquestionattempts'] = 'Soru uygulamaları siliniyor';
$string['description'] = 'Açıklama';
$string['disabled'] = 'Kapatıldı';
$string['displayoptions'] = 'Görünüm seçenekleri';
$string['donotuseautosave'] = 'Otomatik kaydı kullanma';
$string['download'] = 'Verilen kategori dosyasını indirin';
$string['downloadextra'] = '(dosya ayrıca kurs dosyalarındaki /backupdata/quiz klasörüne de kaydedilir)';
$string['dragtoafter'] = 'Sonra {$a}';
$string['dragtostart'] = 'Başlangıç';
$string['duplicateresponse'] = 'Daha önce buna denk bir yanıt verdiğiniz için bu iletim yoksayıldı.';
$string['eachattemptbuildsonthelast'] = 'Herbir uygulamada son kaldığı yerden devam';
$string['eachattemptbuildsonthelast_help'] = 'Birden fazla uygulama için izin verilmişse her yeni uygulama bir önceki uygulamanın sonuçlarına dahil edilir. Bu izin sınavın birden fazla denemeyle tamamlanmasını sağlar.';
$string['edit_slotdisplaynumber_hint'] = 'Soru numarasını düzenleyin (maksimum 16 karakter)';
$string['edit_slotdisplaynumber_label'] = '$a} için yeni değer';
$string['editcategories'] = 'Kategorileri düzenle';
$string['editcategory'] = 'Kategoriyi düzenle';
$string['editcatquestions'] = 'Kategori sorularını düzenle';
$string['editingquestion'] = 'Bir soru düzenleme';
$string['editingquiz'] = 'Sınav düzenleme';
$string['editingquiz_help'] = 'Bir sınav oluşturulurken ana temalar şunlardır:

*Sınav bir veya daha fazla sayfadan oluşur.
* Soru bankası, soruların bir veya daha fazla kategoride soruların kopyasının saklanmasını saklar.
*Rastgele soru Bİr öğrencinin her sınav demesinde farklı sorularla karşılaşır, aynı şeklid her öğrenciye farklı sorular gönderilir.';
$string['editingquiz_link'] = 'mod/quiz/edit';
$string['editingquizx'] = '{$a}: sınavı düzenleniyor';
$string['editmaxmark'] = 'En yüksek not düzenleniyor';
$string['editoverride'] = 'Geçersiz  kılmayı düzenle';
$string['editqcats'] = 'Soru kategorilerini düzenle';
$string['editquestion'] = 'Soruları düzenle';
$string['editquestions'] = 'Soruları düzenle';
$string['editquiz'] = 'Sınavı düzenle';
$string['editquizquestions'] = 'Sınav sorularını düzenle';
$string['emailconfirmautosubmitsmall'] = 'Cevaplarınızı \'{$a->quizname}\' adresine gönderdiğiniz için teşekkür ederiz.';
$string['emailconfirmbody'] = 'Sevgili {$a->username},

{$a->submissiontime} tarihinde \'{$a->coursename}\' dersindeki \'{$a->quizname}\' sınavına katılımınız için teşekkür ederiz.

Bu e-posta, cevaplarınızın bize güvenle ulaştığını bildirmek için gönderilmiştir.

Sınava bu adresten erişebilirsiniz {$a->quizurl}';
$string['emailconfirmbodyautosubmit'] = 'Merhaba {$a->username},

 \'{$a->coursename}\' kursundaki \'{$a->quizname}\' sınavının süresi doldu.  Cevaplarınız {$a->submissiontime} itibarıyla otomatik olarak gönderildi.

 Bu mesaj, cevaplarınızın kaydedildiğini onaylar.

 Bu teste {$a->quizurl} adresinden erişebilirsiniz.';
$string['emailconfirmsmall'] = '\'{$a->quizname}\'e  cevaplarınızı gönderdiğiniz için teşekkür ederiz';
$string['emailconfirmsubject'] = 'Gönderme onayı: {$a->quizname}';
$string['emailmanualgradedbody'] = 'Merhaba {$a->studentname},

{$a->attempttimefinish} adresindeki \'{$a->coursename}\' kursunda\'{$a->quizname}\'ye verdiğiniz cevaplara şimdi değerlendirildi.

Puanınızı ve geri bildiriminizi \'{$a->quizurl}\' adresini ziyaret ederek ve denemenizi gözden geçirerek görüntüleyebileceksiniz.';
$string['emailmanualgradedsubject'] = '$a->quizname} denemenize not verildi';
$string['emailnotifybody'] = 'Sevgili {$a->username},

{$a->studentname}, \'{$a->coursename}\' dersindeki \'{$a->quizname}\' ({$a->quizurl}) sınavını bitirdi.

Bu uygulamayı buradan inceleyebilirsiniz:
{$a->quizreviewurl}';
$string['emailnotifysmall'] = '{$a->studentname}, {$a->quizname} sınavını bitirdi. Bakınız {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname}, {$a->quizname} sınavını bitirdi';
$string['emailoverduebody'] = 'Sevgili {$a studentname->}

\'{$a coursename->}\', dersindeki  \'{$a->quizname}\' sınav uygulamasını  başlattın ama sen onu hiç göndermedin. {$a->attemptduedate} tarihine kadar gönderilmiş olmalıdır.

Hala bu uygulamayı göndermek istiyorsanız, lütfen  {$a->attemptsummaryurl}  gidi ve Gönder düğmesini tıklatın.
Bunu daha önce {$a attemptgraceend->} yapmanız gerekir
Aksi takdirde denemelerin sayılmayacaktır.';
$string['emailoverduesmall'] = '{$a->quizname} Uygulamanızı göndermediniz. Hala göndermek istiyorsanız {$a->attemptgraceend} önce {$a->attemptsummaryurl} gidiniz.';
$string['emailoverduesubject'] = 'Gecikmiş {$a->quizname}\'i uygula';
$string['empty'] = 'Boş';
$string['enabled'] = 'Etkinleştirildi';
$string['endtest'] = 'Uygulamayı bitir ...';
$string['erroraccessingreport'] = 'Bu rapora erişemezsiniz';
$string['errorinquestion'] = 'Soruda hata';
$string['errormissingquestion'] = 'Hata: Sistem bu id {$a} ile hataya sebep oldu';
$string['errornotnumbers'] = 'Hata - cevaplar sayısal olmalı';
$string['errorunexpectedevent'] = '{$a->attemptid} uygulamasındaki {$a->questionid} soruda beklenmedik {$a->event} olay kodu bulundu.';
$string['essay'] = 'Yazılı';
$string['essayquestions'] = 'Sorular';
$string['eventattemptautosaved'] = 'Sınav denemesi otomatik kaydedildi';
$string['eventattemptdeleted'] = 'Sınav uygulamalrı silindi';
$string['eventattemptmanualgradingcomplete'] = 'Sınav için elle puanlama tamamlandı';
$string['eventattemptpreviewstarted'] = 'Sınav önizleme si başladı';
$string['eventattemptquestionrestarted'] = 'Sınav denemesi sorusu yeniden başlatıldı';
$string['eventattemptreviewed'] = 'Sınav uygulamaları incelendi';
$string['eventattemptsummaryviewed'] = 'Sınav deneme özeti incelendi';
$string['eventattemptupdated'] = 'Sınav denemesi güncellendi';
$string['eventattemptviewed'] = 'Sınav denemesi incelendi';
$string['eventeditpageviewed'] = 'Sınav düzenleme sayfası incelendi';
$string['eventoverridecreated'] = 'Sınav geçersiz kılma eklendi';
$string['eventoverridedeleted'] = 'Sınav geçersiz kılma silindi';
$string['eventoverrideupdated'] = 'Sınav geçersiz kılma güncellendi';
$string['eventpagebreakcreated'] = 'Sayfa sonu oluşturuldu';
$string['eventpagebreakdeleted'] = 'Sayfa sonu silindi';
$string['eventquestionmanuallygraded'] = 'Soru maunel olarak puanlandı';
$string['eventquizattemptabandoned'] = 'Sınav uygulaması terk edildi';
$string['eventquizattemptregraded'] = 'Sınav denemesi yeniden değerlendirildi';
$string['eventquizattemptreopened'] = 'Sınav denemesi yeniden açıldı';
$string['eventquizattemptstarted'] = 'Sınav uygulaması başladı';
$string['eventquizattemptsubmitted'] = 'Sınav uygulaması  gönderildi';
$string['eventquizattempttimelimitexceeded'] = 'Sınav uygulaması zaman aşımına uğradı';
$string['eventquizgradeupdated'] = 'Sınav notu güncellendi';
$string['eventquizrepaginated'] = 'Sınav yeniden yayımlandı';
$string['eventreportviewed'] = 'Sınav raporu incelendi';
$string['eventsectionbreakcreated'] = 'Bölüm sonu oluşturuldu';
$string['eventsectionbreakdeleted'] = 'Bölüm sonu oluşturuldu';
$string['eventsectionshuffleupdated'] = 'Bölüm karıştırma güncellendi';
$string['eventsectiontitleupdated'] = 'Bölüm başlığı güncellendi';
$string['eventslotcreated'] = 'Alan oluşturuldu';
$string['eventslotdeleted'] = 'Yuva silindi';
$string['eventslotdisplayedquestionnumberupdated'] = 'Yuvada görüntülenen soru numarası güncellendi';
$string['eventslotmarkupdated'] = 'Yuva işareti güncellendi';
$string['eventslotmoved'] = 'Alan taşındı';
$string['eventslotrequirepreviousupdated'] = 'Yuva, önceden güncellenmeyi gerektirir';
$string['everynquestions'] = 'Her {$a} soru';
$string['everyquestion'] = 'Her soru';
$string['everythingon'] = 'Hepsinde';
$string['existingcategory'] = 'Mevcut kategori';
$string['exportcategory'] = 'kategoriyi dışa ver';
$string['exporterror'] = 'Verme işleminde bir hata oluştu';
$string['exportingquestions'] = 'Sorular dosyaya veriliyor';
$string['exportname'] = 'Dosya adı';
$string['exportquestions'] = 'Dosyaya soru yükle';
$string['extraattemptrestrictions'] = 'Uygulamalar için ek sınırlamalar';
$string['false'] = 'Yanlış';
$string['feedback'] = 'Geri bildirim';
$string['feedbackerrorboundaryformat'] = 'Geri bildirim not sınırı yüzdelik veya bir sayı olmalı. {$a} olarak girdiğiniz sınır kabul edilmedi.';
$string['feedbackerrorboundaryoutofrange'] = 'Geri bildirim not sınırı %0 ve %100 arasında olmalı. {$a} olarak girdiğiniz sınır bu aralığın dışında.';
$string['feedbackerrorjunkinboundary'] = 'Hiç aralık bırakmadan geribildirim not sınırı alanlarına sınırları girmelisiniz.';
$string['feedbackerrorjunkinfeedback'] = 'Hiç aralık bırakmadan geribildirim alanlarını doldurmalısınız.';
$string['feedbackerrororder'] = 'Geri bildirim puan sınırları ilk önce en yükseği olacak şekilde sıralı olmalı. {$a} olarak girdiğiniz değer sıraya uymuyor.';
$string['file'] = 'Dosya';
$string['fileformat'] = 'Dosya biçimi';
$string['fillcorrect'] = 'Doğrusuyla doldur';
$string['filloutnumericalanswer'] = 'En az bir olası cevabı ve toleransı sağlarsınız. İlk eşleşen cevap, notu ve geri bildirimi belirlemek için kullanılacaktır. Sonunda cevap olmadan bazı geri bildirimler verirseniz, bu, cevabı diğer yanıtlardan herhangi biriyle eşleşmeyen öğrencilere gösterilecektir.';
$string['filloutoneanswer'] = 'En az bir olası cevap vermelisiniz. Boş bırakılan cevaplar kullanılmayacaktır. \'*\' herhangi bir karakteri eşleştirmek için joker karakter olarak kullanılabilir. Eşleşen ilk cevap, notu ve geri bildirimi belirlemek için kullanılacaktır.';
$string['filloutthreequestions'] = 'Eşleşen cevaplarla birlikte en az üç soru vermelisiniz. Boş bir soru ile bir cevap vererek fazladan yanlış cevaplar sağlayabilirsiniz. Hem soru hem de cevabın boş olduğu girişler dikkate alınmayacaktır.';
$string['fillouttwochoices'] = 'En az iki seçenek doldurmalısınız. Boş seçenekler değerlendirilmez.';
$string['finishattemptdots'] = 'Uyuluma bitiyor...';
$string['finishreview'] = 'Gözden geçirmeyi bitir';
$string['forceregeneration'] = 'yeniden oluşturmaya zorla';
$string['formatnotfound'] = 'Alma/Verme biçimi ({$a}) bulunamadı';
$string['formulaerror'] = 'Formül hatası!';
$string['fractionsaddwrong'] = 'Seçtiğiniz pozitif notların toplamı %100\'ü  geçemez.<br/>Notlarınızın toplamı: %{$a}.<br/>Geri dönüp bu soruyu düzeltmek ister misiniz?';
$string['fractionsnomax'] = 'Cevaplardan birinin <br />%100 olduğu belirlenmiştir, böylece bir soruya tam not verebilirsiniz.<br />Geri dönüp bu soruyu düzeltmek ister misiniz?';
$string['fromfile'] = 'dosyadan:';
$string['functiondisabledbysecuremode'] = 'Bu özellik şu anda devre dışı';
$string['generalfeedback'] = 'Genel geribildirim';
$string['generalfeedback_help'] = 'Genel geribildirim, bir soru denendikten sonra gösterilen metindir. Verilen yanıta bağlı olarak belirli bir soru için geribildirimden farklı olarak, aynı genel geribildirim her zaman gösterilir.';
$string['gobacktoquiz'] = 'Geri dön';
$string['graceperiod'] = 'Gönderme süresi';
$string['graceperiod_desc'] = 'Süre sona erdiğinde ne yapılacağı \'Bir ek süre var...\' olarak ayarlanmışsa, bu izin verilen varsayılan ek süre miktarıdır.';
$string['graceperiod_help'] = 'Süre sona erdiğinde ne yapılacağı \'Bir ek süre var...\' olarak ayarlanmışsa, bu izin verilen ekstra süre miktarıdır.';
$string['graceperiodmin'] = 'Son gönderim itiraz süresi';
$string['graceperiodmin_desc'] = 'Sınavın sonunda doğru bir problem var. Bir taraftan, öğrencilerin son dakika bitimine kadar otomatik olarak sınavı gönderen zamanlayıcı yardımıyla öğrencileri son bir saniyeye kadar çalışmaya devam etmelerine izin vermek istiyoruz. Öte yandan, sunucu aşırı yüklenmiş olabilir ve yanıtları işleme koymak için zaman alabilir. Dolayısıyla, bu süre dolduktan sonra yanıtları kabul edeceğiz, böylece sunucu yavaş olduğu için cezalandırılmadı. Bununla birlikte, öğrenci aldatmaya çalışabilir ve sınava cevap vermek için bu kadar çok zaman alabilir. Sınavlar sırasında sunucunuzun performansına ne kadar güvendiğinize bağlı olarak bir ödüllendirmede bulunmanız gerekir.';
$string['graceperiodtoosmall'] = 'İzin verme süresi {$a} dan fazla olmalıdır.';
$string['grade'] = 'Not';
$string['gradeall'] = 'Tümünü puanla';
$string['gradeaverage'] = 'Not ortalaması';
$string['gradeboundary'] = 'Not sınırı';
$string['gradeessays'] = 'Yazılıları puanla';
$string['gradehighest'] = 'En yüksek not';
$string['grademethod'] = 'Puanlama yöntemi';
$string['grademethod_help'] = 'Birden çok uygulmaya izin verildiğinde, nihani sınav notunu hesaplamak için aşağıdaki yöntemler kullanılabilir:

* Bütün sınav uygulmalarından elde edlen en yüksek not
* Tüm sınav uygulmalarının ortalama (icmal) notu
* İlk sınav uygulması (diğer denemeler dikkate alınmaz)
* Son sınav uygulaması (diğer denemeler dikkate alınmaz)';
$string['gradesdeleted'] = 'Sınav notları silindi';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradetopassmustbeset'] = 'Bu sınavın tamamlanma yönteminin geçme notunu gerektirmesi için ayarlandığı için, geçmek için not sıfır olamaz. Lütfen sıfır olmayan bir değer ayarlayın.';
$string['gradetopassnotset'] = 'Bu sınavda henüz bir geçme notu ayarlanmamıştır. Sınav ayarlarının Not bölümünde ayarlanabilir.';
$string['gradetopassoutof'] = 'Geçme notu:  {$a->maxgrade} üzerinden {$a->grade}';
$string['gradingdetails'] = 'Bu gönderi için puan: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Önceki cezalarla birlikte <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Bu gönderi {$a} cezasını gerektirir.';
$string['gradingdetailszeropenalty'] = 'Bu gönderiden ceza almadınız.';
$string['gradingmethod'] = 'Puanlama yöntemi: {$a}';
$string['groupoverrides'] = 'Grup geçersiz kılma';
$string['groupoverridesdeleted'] = 'Grup geçersiz kılmaları silindi';
$string['groupsnone'] = 'Erişebileceğiniz grup yok.';
$string['guestsno'] = 'Üzgünüz, konuklar sınavları göremez ve uygulayamazlar';
$string['hidebreaks'] = 'Sayfa sonlarını gizle';
$string['hidereordertool'] = 'Sıralama aracını gizle';
$string['history'] = 'Cevap geçmişi:';
$string['howquestionsbehave_desc'] = 'Soruların bir sınavda nasıl davrandığına ilişkin varsayılan ayar.';
$string['imagedisplay'] = 'Gösterilecek resim';
$string['import_help'] = 'Bu işlev harici metin dosyalarından soruları içe aktarmanızı sağlar.

Dosyanız ASCII olmayan karakterler içeriyorsa, UTF-8 kodlamayı kullanmanız gerekir. Microsoft Office uygulamaları tarafından üretilen dosyalar için özellikle dikkatli olun çünkü bunlar doğru şekilde işlenemeyen özel kodlamayı sıklıkla kullanır.

İçe Aktarma ve Dışa Aktarma biçimleri takılabilir bir kaynaktır. Diğer isteğe bağlı formatlar Modüller ve Eklentiler veritabanında bulunabilir.';
$string['import_link'] = 'question/import';
$string['importcategory'] = 'kategori al';
$string['importerror'] = 'Alma işlemi sırasında bir hata oluştu';
$string['importfilearea'] = 'Mevcut kurs dosyalarından al...';
$string['importfileupload'] = 'Dosya yüklemesinden al...';
$string['importfromthisfile'] = 'Bu dosyadan al';
$string['importingquestions'] = 'Dosyadan {$a} soru alınıyor';
$string['importmax10error'] = 'Soruda bir hata var. 10 cevaptan fazlası olamaz.';
$string['importmaxerror'] = 'Suruda bir hata var. Çok fazla cevap.';
$string['importquestions'] = 'Dosyadan soru yükle';
$string['inactiveoverridehelp'] = '* Bu geçersiz kılma, kullanıcının etkinliğe erişimi sınırlı olduğu için etkin değildir. Bunun nedeni grup veya rol atamaları, diğer erişim kısıtlamaları veya gizlenen aktivite olabilir.';
$string['incorrect'] = 'Yanlış';
$string['indicator:cognitivedepth'] = 'Bilişsel sınav';
$string['indicator:cognitivedepth_help'] = 'Bu gösterge, öğrencinin bir Sınav etkinliğinde ulaştığı bilişsel derinliğe dayanır.';
$string['indicator:cognitivedepthdef'] = 'Bilişsel sınav';
$string['indicator:cognitivedepthdef_help'] = 'Katılımcı, bu analiz aralığı sırasında sınav etkinlikleri tarafından sunulan bilişsel katılımın bu yüzdesine ulaştı (Seviyeler = Görüntüleme Yok, Görüntüleme, Gönder, Geri Bildirimi Görüntüle, Geri Bildirime Yorum Yap, Geri Bildirimi Görüntüledikten Sonra Yeniden Gönder)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Sosyal sınav';
$string['indicator:socialbreadth_help'] = 'Bu gösterge, öğrencinin bir sınav etkinliğinde ulaştığı sosyal genişliğe dayalıdır.';
$string['indicator:socialbreadthdef'] = 'Sosyal sınav';
$string['indicator:socialbreadthdef_help'] = 'Katılımcı, bu analiz aralığı sırasında Test etkinlikleri tarafından sunulan sosyal katılımın bu yüzdesine ulaştı (Seviyeler = Katılım yok, Yalnızca Katılımcı, Diğerleriyle Katılımcı)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indivresp'] = 'Bireylerin her bir maddeye verdiği yanıtlar';
$string['info'] = 'Bilgi';
$string['infoshort'] = 'bilgi';
$string['initialnumfeedbacks'] = 'Genel geribildirim alanlarının başlangıç sayısı';
$string['initialnumfeedbacks_desc'] = 'Yeni bir sınav oluştururken, bu boş birçok genel geribildirim kutusunu sağlayın. Sınav oluşturulduktan sonra, form sınava geri bildirim sayısı için gereken alanların sayısını gösterir. Ayar en az 1 olmalı.';
$string['inprogress'] = 'Devam etmekte';
$string['introduction'] = 'Açıklama';
$string['invalidattemptid'] = 'Bu ID ile bir uygulama yok';
$string['invalidcategory'] = 'Kategori ID hatalı';
$string['invalidoverrideid'] = 'Geçersiz geçersiz kılma kimliği';
$string['invalidquestionid'] = 'Hatalı soru ID';
$string['invalidquizid'] = 'Hatalı sınav kimliği';
$string['invalidrandomslot'] = 'Bireylerin her bir maddeye verdiği yanıtlar';
$string['invalidsource'] = 'Kaynak geçerli kabul edilmedi';
$string['invalidsourcetype'] = 'Geçersiz kaynak tipi.';
$string['invalidstateid'] = 'Hatalı durum ID';
$string['lastanswer'] = 'Son yanıtınız';
$string['layout'] = 'Düzen';
$string['layoutasshown'] = 'Sayfa düzeni olarak gösterilen';
$string['layoutasshownwithpages'] = 'Sayaf yerlerişimi gösterildi. <small>(Otomatik Yeni sayfa{$a} her soru için.)</small>';
$string['layoutshuffledandpaged'] = 'Sorular, sayfa başına {$a} sorularla rasgele karıştırıldı.';
$string['layoutshuffledsinglepage'] = 'Sorular rastgele tek bir sayfada, karıştırılır.';
$string['link'] = 'Bağlantı';
$string['listitems'] = 'Sınavdaki maddelerin listesi';
$string['literal'] = 'Kelime';
$string['loadingquestionsfailed'] = 'Soru yüklenirken hata: {$a}';
$string['makecopy'] = 'Yeni soru olarak kaydet';
$string['managetypes'] = 'Soru tiplerini ve sunucuları yönet';
$string['manualgradequestion'] = 'El ile puanlanan soru {$a->question} de {$a->quiz} dan {$a->user}';
$string['manualgrading'] = 'Puanlama';
$string['mark'] = 'Gönder';
$string['markall'] = 'Sayfayı gönder';
$string['marks'] = 'Puanlar';
$string['marks_help'] = 'Her soru için alınan puan ve genel deneme puanı. Yalnızca Maksimum işaretler seçiliyse İşaretler\'i seçebilirsiniz.';
$string['match'] = 'Eşleştirmeli';
$string['matchanswer'] = 'Eşleşen cevap';
$string['matchanswerno'] = 'Eşleşen cevap {$a}';
$string['max'] = 'Maksimum';
$string['maxmark'] = 'En yüksek puan';
$string['maxmarks'] = 'Maksimum puan';
$string['maxmarks_help'] = 'Her soru için verilebilecek maksimum puan.';
$string['messageprovider:attempt_grading_complete'] = 'Denemenizin değerlendirildiğine dair bildirim';
$string['messageprovider:attempt_overdue'] = 'Sınav uygulaması geciktiğinde uyarı ver';
$string['messageprovider:confirmation'] = 'Kendi sınavlarını göndermeyi onaylama';
$string['messageprovider:submission'] = 'Öğrencilerinizin sınav gönderi bildirimleri';
$string['min'] = 'Minimum';
$string['minutes'] = 'Dakika';
$string['missingcorrectanswer'] = 'Doğru cevap belirtilmeli';
$string['missingitemtypename'] = 'Hatalı ad';
$string['missingquestion'] = 'Bu soru artık yok gibi görünüyor';
$string['modulename'] = 'Sınav';
$string['modulename_help'] = 'Sınav etkinliği, bir öğretmenin, çoktan seçmeli, eşleşen, kısa cevaplı ve sayısal olmak üzere çeşitli türden sorular içeren sınav hazırlamasına olanak tanır.

Öğretmen, sınavın soru bankasından rastgele seçilerek veya karıştırılarak birden çok kez denenmesine izin verebilir. Zaman sınırı ayarlanabilir.

Her deneme, kompozisyon soruları hariç olmak üzere otomatik olarak işaretlenir ve puan not defterine kaydedilir.

Öğretmen, öğrencilere ipuçları, geribildirim ve doğru cevaplar gösterilip gösterilmeyeceğini seçebilir.

Kısa sınavlar kullanılabilir

* Kurs sınavları gibi
* Okuma ödevi için veya konu sonu mini testleri olarak
* Geçmiş sınav sorularını kullanarak sınav uygulaması
* Performansla ilgili anında geri bildirim sağlamak için
* Öz değerlendirme için';
$string['modulename_link'] = 'mod/quiz/view';
$string['modulenameplural'] = 'Sınavlar';
$string['moveselectedonpage'] = 'Seçili soruları sayfaya taşı: {$a}';
$string['multichoice'] = 'Çoktan seçmeli';
$string['multipleanswers'] = 'En az bir cevap seçin';
$string['mustbesubmittedby'] = 'Bu uygulama {$a} tarafından gönderilmelidir.';
$string['name'] = 'Adı';
$string['navigatenext'] = 'Sonraki sayfa';
$string['navigateprevious'] = 'Önceki sayfa';
$string['navmethod'] = 'Gezinme yöntemi';
$string['navmethod_free'] = 'Serbest';
$string['navmethod_help'] = 'Ardışık gezinme etkinleştirildiğinde, öğrenci sırasıyla kısa sınav boyunca ilerlemeli ve önceki sayfalara dönmeyebilir veya ileride atlayamaz.';
$string['navmethod_seq'] = 'Ardışık';
$string['navnojswarning'] = 'Uyarı: Bu bağlantılar cevaplarınızı kaydetmez. Sayfanın altındaki Sonraki düğmesini kullanın.';
$string['neverallononepage'] = 'Hiçbiri, bütün soruları tek sayfada göster';
$string['newattemptfail'] = 'Hata: Sınavda yeni bir uygulama başlatılamadı';
$string['newcategory'] = 'Yeni kategori';
$string['newpage'] = 'Yeni sayfa';
$string['newpage_help'] = 'Daha uzun süreli sınavlar için, sayfalardaki soru sayısını sınırlayarak, sınava birkaç sayfa üzerinde basmak mantıklı olur. Teste soru eklerken, sayfa sonları bu ayara göre otomatik olarak eklenir. Bununla birlikte, sayfa sonları daha sonra düzenleme sayfasında el ile  taşınabilir.';
$string['newpageevery'] = 'Otomatik olarak yeni sayfa başlat';
$string['newsectionheading'] = 'Yeni başlık';
$string['noanswers'] = 'Yanıtlar seçilmedi!';
$string['noattempts'] = 'Bu sınavda hiçbir uygulama yapılmadı';
$string['noattemptsfound'] = 'Hiç uygulama yok';
$string['noattemptstoshow'] = 'Gösterilecek uygulama yok';
$string['nocategory'] = 'Hatalı veya kategori belirtilmedi';
$string['noclose'] = 'Kapanma tarihi yok';
$string['nocommentsyet'] = 'Henüz yorum yok.';
$string['noconnection'] = 'Bu soruyu işleyebilecek bir web servisi bağlantısı şu anda yok. Lütfen yöneticinizle iletişim kurun.';
$string['nodataset'] = 'hiçbirşey - bu bir joker karakter değil';
$string['nodatasubmitted'] = 'Veri gönderilmedi.';
$string['noessayquestionsfound'] = 'Elle not verilen soru bulunamadı';
$string['nogradewarning'] = 'Bu kısa sınava not verilmemiştir, bu nedenle nota göre farklı genel geribildirim ayarlayamazsınız.';
$string['nomoreattempts'] = 'Başka uygulamaya izin verilmemiştir';
$string['none'] = 'Hiçbiri';
$string['noopen'] = 'Başlama tarihi yok';
$string['nooverridedata'] = 'Sınav ayarladındanen az birini geçersiz kılman gerekiyor';
$string['nopossibledatasets'] = 'Veri kümesi yok';
$string['noquestionintext'] = 'Soru herhangi bir gömülü soru içermiyor';
$string['noquestions'] = 'Henüz bir soru eklenmemiş';
$string['noquestionsfound'] = 'Soru bulunamadı';
$string['noquestionsinquiz'] = 'Bu sınavda soru yok.';
$string['noquestionsnotinuse'] = 'Kategori boş olduğu için bu rastgele sorusu kullanımda değil.';
$string['noquestionsonpage'] = 'Boş sayfa';
$string['noresponse'] = 'Cevap yok';
$string['noreview'] = 'Bu sınava bakmaya izniniz yok';
$string['noreviewattempt'] = 'Bu uygulamayı gözden geçirmek için izniniz yok.';
$string['noreviewshort'] = 'İncelemeye izin verilmiyor';
$string['noreviewuntil'] = 'Bu sınava {$a} tarihine kadar bakmaya izniniz yok';
$string['noreviewuntilshort'] = '{$a} tarihine kadar ulaşılabilir';
$string['noscript'] = 'Devam etmek için javascript etkinleştirilmeli';
$string['notavailabletostudents'] = 'Not: Bu sınav öğrencilerinize şu anda açık değil';
$string['notenoughrandomquestions'] = 'Soru {$a->name} ({$a->id}) oluşturmak için kategori {$a->category}de yeterli soru yoktur.';
$string['notenoughsubquestions'] = 'Yeterli sayıda alt-soru tanımlanmadı!<br />Geri dönüp bu soruyu düzeltmek ister misiniz?';
$string['notifyattemptsgradedtask'] = 'Sınav denemesi not bildirimleri gönderme';
$string['notimedependentitems'] = 'Sınav modülü tarafından zaman sınırlı ögeler şu anda desteklenmemektedir. Çalışmak için, tüm sınav için bir zaman sınırı belirleyin. Farklı bir öge seçmek ister misiniz (veya şu anki ögeyi mi kullanmak istersiniz)?';
$string['notyetgraded'] = 'Henüz puanlanmadı';
$string['notyetviewed'] = 'Henüz incelenmedi';
$string['notyourattempt'] = 'Bu sizin uygulamanız değil!';
$string['noview'] = 'Giriş yapmış kullanıcının bu sınavı görme izni yok';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring}, {$a->attemptnum} uygulama yaptı';
$string['numberabbr'] = '#';
$string['numerical'] = 'Numaralı';
$string['numquestionsx'] = 'Sorular: {$a}';
$string['oneminute'] = '1 dakika';
$string['onlyteachersexport'] = 'Sadece eğitimciler soruları çıkarabilir';
$string['onlyteachersimport'] = 'Sadece düzenleme hakları olan eğitimciler soruları alabilir';
$string['onthispage'] = 'Bu sayfa';
$string['open'] = 'Cevaplanmadı';
$string['openafterclose'] = 'Sınav güncellenemedi. Kapanış tarihinden sonra olacak şekilde bir tarih belirttiniz.';
$string['openclosedatesupdated'] = 'Sınavın başlama ve bitiş tarihleri güncellendi';
$string['optional'] = 'isteğe bağlı';
$string['orderandpaging'] = 'Sıralama ve sayfalama';
$string['orderandpaging_help'] = 'Her sorunun karşısındaki 10, 20, 30, ... sayıları soruların sırasını belirtir. Eklenecek ek sorular için alan bırakarak sayıları 10 basamak artar. Soruları yeniden sıralamak için sayıları değiştirin ve ardından "Soruları yeniden sıralayın" düğmesini tıklayın.

Belirli soruların ardından sayfa sonları eklemek için, soruların yanındaki onay kutularını işaretleyin ve ardından "Seçili soruların ardından yeni sayfalar ekle" düğmesini tıklayın.

Soruları birkaç sayfa üzerine düzenlemek için Yeniden Satırla düğmesini tıklayın ve istediğiniz sayfa başına soru sayısını seçin.';
$string['orderingquiz'] = 'Sıralama ve sayfalama';
$string['orderingquizx'] = 'Sırala ve yeniden sayfalandır: {$a}';
$string['outcomesadvanced'] = 'Kazınm gelişmis ayarlardır';
$string['outof'] = '{$a->maxgrade} üzerinden {$a->grade}';
$string['outofpercent'] = '{$a->maxgrade} üzerinden {$a->grade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Sonuç geribildirimi';
$string['overallfeedback_help'] = 'Genel geribildirim, bir sınav denenmeden sonra gösterilen metindir. Ek dereceli sınırlar belirterek (yüzde veya sayı olarak), gösterilen metin elde edilen nota bağlı olabilir.';
$string['overdue'] = 'Geciken';
$string['overduehandling'] = 'Süre dolduğunda';
$string['overduehandling_desc'] = 'Bir öğrenci sınavı zaman aşımına uğratmadan göndermezse, varsayılan olarak ne olmalı?';
$string['overduehandling_help'] = 'Bu ayar, bir öğrenci süre dolmadan önce sınav denemesini göndermezse ne olacağını kontrol eder. Öğrenci o sırada sınavda aktif olarak çalışıyorsa geri sayım sayacı her zaman otomatik olarak denemeyi gönderir, ancak oturumu kapatmışsa bu ayar ne olacağını kontrol eder.';
$string['overduehandling_link'] = 'mod/quiz/timing';
$string['overduehandlingautoabandon'] = 'Süre dolmadan  uygulamaları göndermeniz gerekir aksi halde geçersiz sayılacaktır.';
$string['overduehandlingautosubmit'] = 'Açık uygulamalar otomatik olarak gönderildi.';
$string['overduehandlinggraceperiod'] = 'Açık denemeler gönderilebildiğinde bir yetkisiz kullanım süresi var, ancak başka soruya cevap yok';
$string['overduemustbesubmittedby'] = 'Bu denemenin süresi doldu. Daha önceden gönderilmiş olması gerekirdi. Bu sınava not verilmesni istiyorsanız, sınavı {$a} tarihine kadar göndermeniz gerekir. O zamana kadar göndermezseniz, bu denemeye ait hiçbir not geçerli olmaz.';
$string['override'] = 'Geçersiz kıl';
$string['overridedeletegroupsure'] = '{$a} grubu için geçersiz kılmayı silmek istediğinizden emin misiniz?';
$string['overridedeleteusersure'] = '{$a} kullanıcısı için geçersiz kılmayı silmek istediğinizden emin misiniz?';
$string['overridegroup'] = 'Grubu geçersiz kıl';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Geçersiz kılınanlar';
$string['overridesforquiz'] = 'Ayarları geçersiz kılma: {$a}';
$string['overridesnoneforgroups'] = 'Ayarlar geçersiz kılar: {$a}';
$string['overridesnoneforusers'] = 'Bu sınav için hiçbir kullanıcı ayarı geçersiz kılma oluşturulmamıştır.';
$string['overridessummary'] = 'Ayar geçersiz kılmaları mevcut ({$a})';
$string['overridessummarygroup'] = 'Gruplar: {$a}';
$string['overridessummarythisgroup'] = 'Bu grup için ayar geçersiz kılmaları mevcut ({$a})';
$string['overridessummaryuser'] = 'Kullanıcılar: {$a}';
$string['overridessummaryyourgroups'] = 'Gruplarınız için ayar geçersiz kılmaları mevcut ({$a})';
$string['overrideuser'] = 'Kullanıcıyı geçersiz kıl';
$string['overrideusereventname'] = '{$a quiz->} - geçersiz kıl';
$string['page-mod-quiz-attempt'] = 'Sınav sayfasınıuygula';
$string['page-mod-quiz-edit'] = 'Sınav sayfasını düzenle';
$string['page-mod-quiz-report'] = 'Herhangi bir sınav raporu sayfası';
$string['page-mod-quiz-review'] = 'Sınav uygulama sayfasını gözden geçir';
$string['page-mod-quiz-summary'] = 'Sınav ugulama özetleri sayfası';
$string['page-mod-quiz-view'] = 'Sınav bilgi sayfası';
$string['page-mod-quiz-x'] = 'Herhangi bir sınav modülü sayfası';
$string['pageshort'] = 'S';
$string['pagesize'] = 'Sayfa boyutu';
$string['parent'] = 'Üst';
$string['parentcategory'] = 'Ana kategori';
$string['parsingquestions'] = 'Alınan dosyadan sorular işleniyor.';
$string['partiallycorrect'] = 'Kısmen doğru';
$string['penalty'] = 'Ceza';
$string['penaltyscheme'] = 'Cezaları uygula';
$string['penaltyscheme_help'] = 'Etkinleştirilirse, yanlış bir cevap için bir soru için son işaretten bir ceza çıkarılır. Cezanın miktarı soru ayarlarında belirtilir. Bu ayar yalnızca uyarlanabilir mod etkinleştirildiyse geçerlidir.';
$string['percentcorrect'] = 'Doğruluk yüzdesi';
$string['pleaseclose'] = 'İsteğiniz işleme alındı. Şu anda pencereyi kapatabilirsiniz.';
$string['pluginadministration'] = 'Sınav yönetimi';
$string['pluginname'] = 'Sınav';
$string['popup'] = 'Sınavı güvenli bir pencerede göster';
$string['popupblockerwarning'] = 'Testin bu bölümü güvenli moddadır ve sınavı güvenli bir pencerede yapmanız gerekir. Lütfen açılır pencere engelleyicini devre dışı bırakın. Teşekkür ederiz.';
$string['popupnotice'] = 'Öğrenciler bu sınavı güvenli bir pencerede görürler';
$string['preprocesserror'] = 'Ön-işleme yapılırken hata oluştu!';
$string['preview'] = 'Önizleme';
$string['previewquestion'] = 'Soruyu önizleme';
$string['previewquiz'] = 'Önizleme {$a}';
$string['previewquiznow'] = 'Sınavı şimdi gözden geçir';
$string['previewquizstart'] = 'Sınavı önizleme';
$string['previous'] = 'Önceki durum';
$string['privacy:metadata:core_question'] = 'Sınav etkinliği, soru kullanım bilgilerini core_question alt sisteminde depolar.';
$string['privacy:metadata:quiz'] = 'Sınav etkinliği, sınav raporlarından yararlanır.';
$string['privacy:metadata:quiz_attempts'] = 'Bir sınavdaki her denemeyle ilgili ayrıntılar.';
$string['privacy:metadata:quiz_attempts:attempt'] = 'Deneme numarası.';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'Kullanıcının bulunduğu geçerli sayfa.';
$string['privacy:metadata:quiz_attempts:gradednotificationsenttime'] = 'Kullanıcının, denemesinin elle puanlandığınının bildirilme süresi';
$string['privacy:metadata:quiz_attempts:preview'] = 'Bunun sınavan bir önizlemesi olsun mu?';
$string['privacy:metadata:quiz_attempts:state'] = 'Denemenin mevcut durumu.';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'Denemedeki not toplamları.';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = 'Durumun kontrol edildiği saat.';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'Denemenin tamamlandığı saat.';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'Denemenin güncellendiği saat.';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = 'Denemenin bir çevrimdışı güncelleme aracılığıyla güncellendiği saat.';
$string['privacy:metadata:quiz_attempts:timestart'] = 'Denemenin başlatıldığı saat.';
$string['privacy:metadata:quiz_grades'] = 'Bu sınavın genel notuyla ilgili ayrıntılar.';
$string['privacy:metadata:quiz_grades:grade'] = 'Bu sınavın genel notu.';
$string['privacy:metadata:quiz_grades:quiz'] = 'Not verilen sınav.';
$string['privacy:metadata:quiz_grades:timemodified'] = 'Notun değiştirildiği saat.';
$string['privacy:metadata:quiz_grades:userid'] = 'Not verilen kullanıcı.';
$string['privacy:metadata:quiz_overrides'] = 'Bu sınav için geçersiz kılmalarla ilgili ayrıntılar';
$string['privacy:metadata:quiz_overrides:quiz'] = 'Geçersiz kılma bilgileri içeren sınav';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'Sınav için yeni kapanış saati.';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'Sınav için yeni süre sınırı.';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'Sınav için yeni başlanğıç saati.';
$string['privacy:metadata:quiz_overrides:userid'] = 'Geçersiz kılınan kullanıcı';
$string['privacy:metadata:quizaccess'] = 'Sınav etkinliği, sınav erişim kurallarını kullanır.';
$string['publish'] = 'Yayınla';
$string['publishedit'] = 'Bu kategoriye soru eklemek veya bu kategorideki soruları değiştirmek için yayınlama hakkınız olmalıdır';
$string['qbrief'] = 'S. {$a}';
$string['qname'] = 'isim';
$string['qti'] = 'IMS QTI biçimi';
$string['qtypename'] = 'tip, isim';
$string['question'] = 'Soru';
$string['questionbank'] = 'soru bankasından';
$string['questionbankmanagement'] = 'Soru bankası yönetimi';
$string['questionbehaviour'] = 'Soru davranışı';
$string['questioncats'] = 'Soru kategorileri';
$string['questiondeleted'] = 'Bu soru silinmiştir. Lütfen öğretmeninizle iletişime geçin.';
$string['questiondependencyadd'] = '{$a-> thisq} sorusu sorulduğunda kısıtlama yoktur • Değiştirmek için tıklayın';
$string['questiondependencyfree'] = 'Bu sorunun kısıtlanması yok';
$string['questiondependencyremove'] = '{$a->previousq} tamamlanıncaya kadar {$a->thisq} sorusu denenemiyor. • Değiştirmek için tıklayın';
$string['questiondependsonprevious'] = 'Bu soru, bir önceki soru tamamlanmadan denenemez.';
$string['questiondraftonly'] = '{$a} sorusu taslak durumunda.  Sınavda kullanmak için soru bankasına gidin ve durumu hazır olarak değiştirin.';
$string['questiondraftwillnotwork'] = 'Bu soru taslak durumundadır.  Sınavda kullanmak için soru bankasına gidin ve durumu hazır olarak değiştirin.';
$string['questioninuse'] = '\'{$a->questionname}\' sorusu burada kullanılmaktadır:<br />{$a->quiznames}<br />Soru, bu sınavlardan silinmez ama kategori listesinden silinir.';
$string['questionmissing'] = 'Bu oturum için soru eksik';
$string['questionname'] = 'Soru adı';
$string['questionnonav'] = '<span class="accesshide">Soru</span> {$a->number} <span class="accesshide">{$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Bilgi</span> {$a->number} <span class="accesshide">{$a->attributes}</span>';
$string['questionnotloaded'] = '{$a} sorusu veritabanından yüklenemedi';
$string['questionorder'] = 'Soru sıralama';
$string['questionposition'] = 'Yeni yıralamada soru {$a} konumunda';
$string['questions'] = 'Sorular';
$string['questionsetpreview'] = 'Soru seti
önizlemesi';
$string['questionsinclhidden'] = 'Sorular (gizli olanlar dahil)';
$string['questionsinthisquiz'] = 'Bu sınavdaki sorular';
$string['questionsmatchingfilter'] = 'Bu filtreyle eşleşen sorular: {$a}';
$string['questionsperpage'] = 'Her sayfadaki max soru sayısı';
$string['questionsperpageselected'] = 'Sayfa başına sorular, sayfalama şu anda sabitlenmiştir. Sonuç olarak, disk belleği denetimleri devre dışı bırakıldı. Bunu {$a} \'da değiştirebilirsiniz.';
$string['questionsperpagex'] = 'Her sayfadaki soru: {$a}';
$string['questiontext'] = 'Soru metni';
$string['questiontextisempty'] = '[Boş soru metni]';
$string['questiontype'] = 'Soru tipi {$a}';
$string['questiontypesetupoptions'] = 'Soru tipleri için seçenekleri ayarla';
$string['questionversion'] = 's{$a}';
$string['questionversionlatest'] = 's{$a} (en son)';
$string['quiz:addinstance'] = 'Yeni sınav ekle';
$string['quiz:attempt'] = 'Sınavları uygula';
$string['quiz:deleteattempts'] = 'Sınav uygulamalarını sil';
$string['quiz:emailconfirmsubmission'] = 'Kendi sınav gönderimlerinizin onayını alın';
$string['quiz:emailnotifyattemptgraded'] = 'Öğrencilerinizin sınav gönderimleri hakkında bildirim alın';
$string['quiz:emailnotifysubmission'] = 'Öğrencilerinizin kısa sınav gönderimlerine ilişkin bildirim alın';
$string['quiz:emailwarnoverdue'] = 'Sınav denemenizin süresi geçtiğinde uyarı alın';
$string['quiz:grade'] = 'Sınava manuel değerlendir';
$string['quiz:ignoretimelimits'] = 'Sınavlardaki zaman sınırını yoksay';
$string['quiz:manage'] = 'Uygulamaları yönet';
$string['quiz:manageoverrides'] = 'Sınav geçersiz kılmaları yönetin';
$string['quiz:preview'] = 'Uygulamalara gözat';
$string['quiz:regrade'] = 'Sınav uygulamalarına yeniden not ver';
$string['quiz:reopenattempts'] = 'Hiç gönderilmemiş test denemelerini yeniden aç';
$string['quiz:reviewmyattempts'] = 'Kendi denemelerinizi gözden geçirin';
$string['quiz:view'] = 'Sınav bilgisine bak';
$string['quiz:viewoverrides'] = 'Sınav ayarları geçersiz kılmalarını görüntüle';
$string['quiz:viewreports'] = 'Sınav raporlarına bak';
$string['quizavailable'] = 'Sınav şu tarihe kadar açıktır: {$a}';
$string['quizclose'] = 'Sınavı bitir';
$string['quizclosed'] = 'Bu sınav {$a} tarihinde bitti';
$string['quizcloses'] = 'Sınav bitişi';
$string['quizcloseson'] = 'Sınav bu tarihte bitecek: {$a}';
$string['quizeventcloses'] = '{$a} kapanacak';
$string['quizeventopens'] = '{$a} başlayacak';
$string['quizisclosed'] = 'Bu sınav kapalı';
$string['quizisclosedwillopen'] = 'Sınav kapandı  (opens {$a})';
$string['quizisopen'] = 'Bu sınav açık';
$string['quizisopenwillclose'] = 'Sınav açık (kapanma: {$a})';
$string['quiznavigation'] = 'Sınav gezintisi';
$string['quizopen'] = 'Sınavı başlat';
$string['quizopenclose'] = 'Başlama ve bitiş tarihleri';
$string['quizopenclose_help'] = 'Öğrenciler denemelerine ancak açılış saatinden sonra başlayabilirler ve denemelerini kapanış saatinden önce tamamlamaları gerekir.';
$string['quizopenclose_link'] = 'mod/quiz/timing';
$string['quizopened'] = 'Bu sınav açıktır.';
$string['quizopenedon'] = 'Bu sınav {$a} tarihinde başladı';
$string['quizopens'] = 'Sınav açık';
$string['quizopenwillclose'] = 'Bu sınav açık ve {$a} tarihinde kapanacak';
$string['quizordernotrandom'] = 'Sınavın sırası karıştırılmadı';
$string['quizorderrandom'] = '* Sınavın sırası karıştırıldı';
$string['quizreport'] = 'Sınav raporu';
$string['quizsettings'] = 'Sınav ayarları';
$string['quiztimer'] = 'Sınav sayacı';
$string['quizwillopen'] = 'Bu sınav {$a} tarihinde açılacak';
$string['random'] = 'Rasgele soru';
$string['randomcatwithsubcat'] = '{$a} ve alt kategoriler';
$string['randomcoursecatwithsubcat'] = '{$a} kurs kategorisi içindeki herhangi bir kategori';
$string['randomcoursewithsubcat'] = 'Bu kurstaki herhangi bir kategori';
$string['randomcreate'] = 'Rasgele soru oluştur';
$string['randomediting'] = 'Rastgele bir soruyu düzenleme';
$string['randomfaultynosubcat'] = 'Hatalı soru';
$string['randomfromcategory'] = 'Kategoriden rastgele soru:';
$string['randomfromexistingcategory'] = 'Varolan kategoriden rastgele soru';
$string['randomfromunavailabletag'] = '{$a} (kullanılamıyor)';
$string['randommodulewithsubcat'] = 'Bu sınavın herhangi bir kategorisi';
$string['randomnosubcat'] = 'Sadece bu kategorilerden soru, alt kategorilerinden değil';
$string['randomnumber'] = 'Rastgele soru sayısı';
$string['randomqname'] = 'Filtre koşuluna bağlı olarak rastgele soru';
$string['randomqnamecat'] = 'Rastgele ({$a->category}) temelli fitilemele koşuluna göre';
$string['randomqnamecattags'] = 'Random ({$a->category}) temelli  filitremeleme durumuna göre etiket: {$a->tags}';
$string['randomqnametags'] = 'Etiketlerle filtre koşuluna dayalı rastgele soru: {$a}';
$string['randomquestion'] = 'Rastgele soru';
$string['randomquestion_help'] = 'Rastgele soru, belirli bir kategoriden veya belirli bir etikete göre rastgele seçilen bir soruyu bir etkinliğe eklemenin bir yoludur.';
$string['randomquestiontags'] = 'Etiketler';
$string['randomquestiontags_help'] = 'Burada bazı soru etiketlerini belirterek seçim kriterlerini daha da kısıtlayabilirsiniz.

"Rastgele" sorular, tüm bu etiketlere sahip olan sorular arasından seçilecektir.';
$string['randomquestionusinganewcategory'] = 'Yeni bir kategori kullanılarak Rastgele soru';
$string['randomsystemwithsubcat'] = 'Herhangi bir sistem düzeyinde kategori';
$string['randomwithsubcat'] = 'Bu kategoriden ve alt kategorilerinden sorular';
$string['readytosend'] = 'Notu verilmiş sınavınızı yollamak istiyorsunuz. Devam etmek istiyor musunuz?';
$string['reattemptquiz'] = 'Sınavı tekrar uygula';
$string['recentlyaddedquestion'] = 'Yeni eklenmiş soru!';
$string['recurse'] = 'Alt kategorilerdeki soruları da dahil et';
$string['redoesofthisquestion'] = 'Diğer sorular burada denendi: {$a}';
$string['redoquestion'] = 'Bunun gibi başka bir soru deneyin';
$string['regrade'] = 'Tüm uygulamaları tekrar değerlendir';
$string['regradecomplete'] = 'Tüm uygulamalar tekrar değerlendirildi';
$string['regradecount'] = '{$a->attempt} uygulamadan {$a->changed} değişiklik değerlendirildi';
$string['regradedisplayexplanation'] = 'Yeniden puanlama esnasında değişen uygulamalar soru izleme penceresine bağlantı olarak gösterilmiştir';
$string['regradenotallowed'] = 'Bu sınava tekrar vermek için yetkiniz yok';
$string['regradingquestion'] = '"{$a}" tekrar puanlanıyor.';
$string['regradingquiz'] = '"{$a}" sınavı tekrar puanlanıyor';
$string['remove'] = 'Sil';
$string['removeallgroupoverrides'] = 'Tüm kullanıcı geçersiz kılmaları sil';
$string['removeallquizattempts'] = 'Bütün sınav uygulamalarını sil';
$string['removealluseroverrides'] = 'Tüm kullanıcı geçersiz kılmaları sil';
$string['removeemptypage'] = 'Boş sayfayı sil';
$string['removepagebreak'] = 'Sayfa sonunu kaldır';
$string['removeselected'] = 'Seçiliyi sil';
$string['rename'] = 'Ad değiştir';
$string['renderingserverconnectfailed'] = '{$a} sunucusu RQP isteğini işleme alırken hata oluştu. URL\'nin doğru olup olmadığını kontrol edin.';
$string['reopenattempt'] = 'Yeniden aç';
$string['reopenattemptareyousuremessage'] = 'Bu, {$a->attemptnumber} denemesini {$a->attemptuser} tarafından yeniden açacaktır.';
$string['reopenattemptareyousuretitle'] = 'Deneme yeniden açılsın mı?';
$string['reopenattemptwrongstate'] = '{$a->attemptid} denemesi, yeniden açılması için yanlış durumda ({$a->durum}).';
$string['reopenedattemptwillbeinprogress'] = 'Deneme açık kalacak ve devam ettirilebilecektir.';
$string['reopenedattemptwillbeinprogressuntil'] = 'Deneme açık kalacak ve sınav {$a} \' da kapanana kadar devam ettirilebilir.';
$string['reopenedattemptwillbesubmitted'] = 'Deneme derhal değerlendirilmek üzere gönderilecektir.';
$string['reorderquestions'] = 'Soruları yeniden sırala';
$string['reordertool'] = 'Yeniden sıralama aracını göster';
$string['repaginate'] = 'Her sayfada {$a} soru göster';
$string['repaginatecommand'] = 'Tekrar sayfalandır';
$string['repaginatenow'] = 'Şimdi tekrar sayfalandır';
$string['replace'] = 'Değiştir';
$string['replacementoptions'] = 'Değiştirme seçenekleri';
$string['report'] = 'Raporlar';
$string['reportanalysis'] = 'Öge analizi';
$string['reportattemptsfrom'] = 'Uygulamardan';
$string['reportattemptsthatare'] = 'Denemeler';
$string['reportdisplayoptions'] = 'Görüntüleme seçenekleri';
$string['reportfullstat'] = 'Ayrıntılı istatistikler';
$string['reportmulti_percent'] = 'Çoklu-yüzdelikler';
$string['reportmulti_q_x_student'] = 'Çoklu-öğrenci seçimleri';
$string['reportmulti_resp'] = 'Bireysel cevaplar';
$string['reportmustselectstate'] = 'En az bir durum seçmelisiniz';
$string['reportnotfound'] = 'Tanımsız rapor ({$a})';
$string['reportoverview'] = 'Gözden geçirme';
$string['reportregrade'] = 'Uygulamaları tekrar değerlendir';
$string['reportresponses'] = 'Ayrıntılı yanıtlar';
$string['reports'] = 'Raporlar';
$string['reportshowonly'] = 'Sadece uygulamaları göster';
$string['reportshowonlyfinished'] = 'Kullanıcı başına en fazla bir bitmiş deneme göster ({$a})';
$string['reportsimplestat'] = 'Basit istatistikler';
$string['reportusersall'] = 'sınava giren tüm kullanıcılar';
$string['reportuserswith'] = 'sınava giren kayıtlı kullanıcılar';
$string['reportuserswithorwithout'] = 'sınava giren/girmeyen kayıtlı kullanıcılar';
$string['reportuserswithout'] = 'sınava girmeyen kayıtlı kullanıcılar';
$string['reportwhattoinclude'] = 'Rapora ne dahil edilecek';
$string['requirepassword'] = 'Parola gerekli';
$string['requirepassword_help'] = 'Eğer parola belirtilmişse, öğrencilerin sınav uygulaması esnasında parolayı girmeleri gerekir.';
$string['requiresubnet'] = 'Ağ adresi gerekli';
$string['requiresubnet_help'] = 'Sınav erişimi, kısmi veya tam IP adres numaralarının virgül ile ayrılmış bir listesini belirleyerek LAN veya İnternet üzerindeki belirli alt ağlarla kısıtlanabilir. Bu, yalnızca belirli bir konumdaki kişilerin testlere erişebilmesini sağlamak için, tetiklenen (denetlenmiş) bir test için yararlı olabilir.';
$string['response'] = 'Verilen yanıt';
$string['responses'] = 'Verilen yanıtlar';
$string['results'] = 'Sonuçlar';
$string['returnattempt'] = 'Uygulamaya dön';
$string['reuseifpossible'] = 'önceki silineni yeniden kullan';
$string['reverttodefaults'] = 'Sınav varsayılan ayarlarına geri dön';
$string['review'] = 'Önizleme';
$string['reviewafter'] = 'Sınav bittikten sonra önizleme izni';
$string['reviewalways'] = 'Her zaman önizleme izni';
$string['reviewattempt'] = 'Uygulamaları incele';
$string['reviewbefore'] = 'Sınav devam ederken önizleme izni';
$string['reviewclosed'] = 'Sınav bittikten sonra';
$string['reviewduring'] = 'Uygulama boyunca';
$string['reviewimmediately'] = 'Yanıtladıktan hemen sonra';
$string['reviewnever'] = 'Önizleme izni yok';
$string['reviewofquestion'] = '{$a->quiz} \'te {$a->question} sorusunun {$a->user} tarafından incelenmesi';
$string['reviewopen'] = 'Sonra, sınav hala devam ederken';
$string['reviewoptions'] = 'Öğrenciler inceleyebilir';
$string['reviewoptionsheading'] = 'Seçenekleri incele';
$string['reviewoptionsheading_help'] = 'Bu seçenekler öğrencilerin bir sınav denemesini incelediğinde veya sınav raporlarına baktıklarında görebilecekleri bilgileri kontrol eder.

** Deneme sırasında ** ayarlar yalnızca bazı davranışlar için geçerlidir (örneğin, deneme sırasında geri bildirim gösterebilecek "birden çok denemeli etkileşimli").

** Denemeden hemen sonra ** ayarları, \'Tümünü gönder ve bitir\' ifadesinin ardından ilk iki dakika boyunca geçerli olur.

** Daha sonra, sınav hala açıkken ** ayarları, bundan sonra ve sınav bitiş tarihinden önce uygulanır.

** Sınav kapandıktan sonra, ** sınav kapanış tarihinden sonra ** ayarları geçerlidir. Sınavın bitiş tarihi yoksa, bu duruma hiçbir zaman ulaşılamaz.';
$string['reviewoverallfeedback'] = 'Genel geribildirim';
$string['reviewoverallfeedback_help'] = 'Öğrencinin toplam notuna bağlı olarak, denemenin sonunda verilecek geri bildirim.';
$string['reviewresponse'] = 'Verilen yanıtı incele';
$string['reviewresponsetoq'] = 'Verilen yanıta gözat (soru {$a})';
$string['reviewthisattempt'] = 'Bu uygulamaya verdiğiniz yanıtlara gözatın';
$string['rqp'] = 'Uzak soru';
$string['rqps'] = 'Uzak sorular';
$string['sameasoverall'] = 'Aynı puanlar';
$string['save'] = 'Kaydet';
$string['saveandedit'] = 'Değişiklikleri kaydet ve soruları düzenle';
$string['saveattemptfailed'] = 'Şu anki sınav uygulaması kaydedilirken hata oluştu.';
$string['savedfromdeletedcourse'] = 'Silinen kurstan "{$a}" kaydedildi';
$string['savegrades'] = 'Notları kaydet';
$string['savemyanswers'] = 'Yanıtlarımı kaydet';
$string['savenosubmit'] = 'Göndermeden kaydet';
$string['saveoverrideandstay'] = 'Kaydedin ve bir başka geçersiz kılma ekleyin';
$string['savequiz'] = 'Tüm sınavı kaydet';
$string['saving'] = 'Kaydediliyor';
$string['savingnewgradeforquestion'] = 'Soru kimliği {$a} için yeni puan kaydediliyor';
$string['savingnewmaximumgrade'] = 'Yeni maksimum puan ayarları kaydedildi.';
$string['score'] = 'Ham puan';
$string['scores'] = 'Puanlar';
$string['search:activity'] = 'Sınav - etkinlik bilgileri';
$string['sectionheadingedit'] = '\'{$a}\' başlığını düzenle';
$string['sectionheadingremove'] = '\'{$a}\' başlığını kaldırın';
$string['sectionnoname'] = 'İsimsiz bölüm';
$string['seequestions'] = '(Soruları gör)';
$string['select'] = 'Seç';
$string['selectall'] = 'Tümünü seç';
$string['selectattempt'] = 'Deneme seçin';
$string['selectcategory'] = 'Kategori seç';
$string['selectedattempts'] = 'Seçili uygulamalar...';
$string['selectmultipleitems'] = 'Birden fazla öğe seç';
$string['selectmultipletoolbar'] = 'Birden fazla araç çubuğu seç';
$string['selectnone'] = 'Hiçbirini seçme';
$string['selectquestionslot'] = '{$a} sorusunu seçin';
$string['selectquestiontype'] = '-- Kategori tipi seç --';
$string['serveradded'] = 'Sunucu eklendi';
$string['serveridentifier'] = 'Tanıtıcı';
$string['serverinfo'] = 'Sunucu bilgisi';
$string['servers'] = 'Sunucular';
$string['serverurl'] = 'Sunucu URL';
$string['shortanswer'] = 'Kısa cevap';
$string['show'] = 'Göster';
$string['showall'] = 'Bütün soruları tek sayfada göster';
$string['showblocks'] = 'Sınav uygulaması boyunca blokları göster';
$string['showblocks_help'] = 'Evet\'e ayarlanırsa, sınav denemeleri sırasında normal bloklar gösterilir';
$string['showbreaks'] = 'Sayfa sonu çizgilerini göster';
$string['showcategorycontents'] = 'Kategori içeriklerini göster {$a->arrow}';
$string['showcorrectanswer'] = 'Geri bildirim doğru cevapları göster?';
$string['showdetailedmarks'] = 'Puan ayrıntılarını göster';
$string['showeachpage'] = 'Bir seferde tek sayfa göster';
$string['showfeedback'] = 'Yanıtladıktan sonra geribildirim göster?';
$string['showinsecurepopup'] = 'Uygulamar için \'güvenli\' açılır pencere kullan';
$string['showlargeimage'] = 'Büyük resim';
$string['shownoattempts'] = 'Uygulama yapmayan öğrencileri göster';
$string['shownoattemptsonly'] = 'Uygulaması olmayan öğrencileri göster';
$string['shownoimage'] = 'Resim yok';
$string['showreport'] = 'Raporu göster';
$string['showsmallimage'] = 'Küçük resim';
$string['showteacherattempts'] = 'Öğretmen denemelerini göster';
$string['showuserpicture'] = 'Kullanıcıların resmini göster';
$string['showuserpicture_help'] = 'Etkinleştirilirse, öğrencinin adı ve resmi deneme sırasında ekranda ve inceleme ekranında gösterilerek, öğrencinin gözetmenli (gözetimli) bir sınavda kendisinin oturum açıp açmadığının kontrol edilmesini kolaylaştırır.';
$string['shuffle'] = 'Karıştır';
$string['shuffleanswers'] = 'Cevap şıklarını karıştır';
$string['shuffledrandomly'] = 'Rastgele karıştırıldı';
$string['shufflequestions'] = 'Karıştır';
$string['shufflequestions_help'] = 'Etkinleştirilirse, test her denendiğinde, bu bölümdeki soruların sırası farklı bir rastgele sıraya göre karıştırılacaktır.

Bu, öğrencilerin cevapları paylaşmasını zorlaştırabilir, ancak aynı zamanda öğrencilerin belirli bir soruyu öğretmenle tartışmasını da zorlaştırır.';
$string['shufflewithin'] = 'Soruları kendi içinde karıştır';
$string['shufflewithin_help'] = 'Etkinleştirilirse, soru ayarlarında seçeneği de etkinleştirilirse, bir öğrenci sınavı her denediğinde her soruyu oluşturan parçalar rastgele karıştırılır. Bu ayar, yalnızca çoktan seçmeli veya eşleşen sorular gibi birden çok bölümü olan sorular için geçerlidir.';
$string['singleanswer'] = 'Bir cevap seçin.';
$string['sortage'] = 'Kronolojik sırala';
$string['sortalpha'] = 'İsme göre sırala';
$string['sortquestionsbyx'] = 'Soruları sırala: {$a}';
$string['sortsubmit'] = 'Soruları sırala';
$string['sorttypealpha'] = 'Türe, ada göre sırala';
$string['specificapathnotonquestion'] = 'Belirtilen soru belirtilen dosya yolunda değil';
$string['specificquestionnotonquiz'] = 'Belirtilen soru belirtilen sınavda değil';
$string['startagain'] = 'Tekrar başlat';
$string['startattempt'] = 'Uygulamayı başlat';
$string['startedon'] = 'Başlangıç';
$string['startnewpreview'] = 'Yeni önizleme başlat';
$string['stateabandoned'] = 'Gönderilmeyen';
$string['statefinished'] = 'Biten';
$string['statefinisheddetails'] = 'Gönderildi {$a}';
$string['stateinprogress'] = 'Devam etmekte';
$string['statenotloaded'] = '{$a} sorusunun durumu veritabanından yüklenemedi';
$string['stateoverdue'] = 'Geciken';
$string['stateoverduedetails'] = '{$a} tarafından teslim edilmelidir';
$string['status'] = 'Durum';
$string['stoponerror'] = 'Hata oluşursa dur';
$string['submission_confirmation'] = 'Tüm cevaplarını gönderip bitirmek istiyor musunuz?';
$string['submission_confirmation_unanswered'] = 'Yanıtı olmayan sorular: {$a}';
$string['submitallandfinish'] = 'Tümünü gönder ve bitir';
$string['subneterror'] = 'Üzgünüz, bu sınava sadece belirli bölgelerden erişilebildiğinden dolayı bu sınav kilitli. Şu anda bilgisayarınız bu sınava yapmaya yetkili bilgisayarlardan değildir.';
$string['subnetnotice'] = 'Bu sınava sadece belirli yerlerden ulaşılabildiği için bu sınav size açık değildir. Bilgisayarınız izin verilen alt ağda değil. Öğretmen olarak önizleme yapmanıza izin verilmiştir.';
$string['subplugintype_quiz'] = 'Rapor';
$string['subplugintype_quiz_plural'] = 'Raporlar';
$string['subplugintype_quizaccess'] = 'Erişim kuralı';
$string['subplugintype_quizaccess_plural'] = 'Erişim Kuralları';
$string['substitutedby'] = 'bununla değiştirilecek';
$string['summaryofattempt'] = 'Uygulama özeti';
$string['summaryofattempts'] = 'Önceki uygulamalarınızın özeti';
$string['temporaryblocked'] = 'Sınavı tekrar uygulamanıza geçici olarak izin verilmiyor.<br />Başka bir sınav yapabilirsiniz:';
$string['theattempt'] = 'Bu uygulama';
$string['theattempt_help'] = 'Öğrenciler tüm sınav uygulamalarını inceleyebilsinler';
$string['time'] = 'Süre';
$string['timecompleted'] = 'Tamamlandı';
$string['timedelay'] = 'Zaman aralığını geçmediğiniz için diğer sınavı uygulamadan sınavı uygulama hakkınız yok';
$string['timeleft'] = 'Kalan süre';
$string['timelimit'] = 'Zaman sınırı';
$string['timelimit_help'] = 'Zaman sınırı etkinleştirilirse,  ilk test sayfasında gösterilir ve bir geri sayım sayacı sınav gezinti bloğunda sürekli olarak görüntülenir.';
$string['timelimit_link'] = 'mod/quiz/timing';
$string['timelimitexeeded'] = 'Üzgünüz! Sınav süresi aşıldı!';
$string['timestr'] = '%d/%m/%y %H:%M:%S';
$string['timesup'] = 'Süre doldu!';
$string['timetaken'] = 'Geçen süre';
$string['timing'] = 'Zamanlama';
$string['tofile'] = 'dosyaya';
$string['tolerance'] = 'Kabul edilen hata';
$string['toomanyrandom'] = 'Gereken rastgele soruların sayısı bu kategorinin içerdiğinden fazladır.';
$string['top'] = 'Üst';
$string['totalmarksx'] = 'Toplam not: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Bu kategorideki {$a} sorunun toplamı';
$string['true'] = 'Doğru';
$string['truefalse'] = 'Doğru/yanlış';
$string['type'] = 'Türü';
$string['unfinished'] = 'bitmemiş';
$string['ungraded'] = 'Not verilmedi';
$string['unit'] = 'Birim';
$string['unknowntype'] = '{$a}. satırdaki soru tipi desteklenmiyor. Soru yoksayılacak.';
$string['updatefilterconditon'] = 'Filtre koşullarını güncelle';
$string['updatefilterconditon_success'] = 'Filtre koşulları başarıyla güncellendi';
$string['updateoverdueattemptstask'] = 'Gecikmiş sınav denemelerini güncelleme';
$string['updatequizslotswithrandomxofy'] = '"Rastgele" soru verileriyle ({$a->done}/{$a->total}) sınav alanları güncelleniyor';
$string['updatesettings'] = 'Sınav ayarlarını güncelle';
$string['updatingatttemptgrades'] = 'Uygulama\'ya ait notlar güncelleniyor';
$string['updatingfinalgrades'] = 'Final notları güncelleniyor';
$string['updatingthegradebook'] = 'Notdefteri güncelleniyor';
$string['upgradesure'] = '<div>Sınav modülü, özellikle sınav tablolarında büyük bir değişiklik yapacak ve bu güncelleme yeterince test edilmedi. İşleme başlamadan önce veritabanı tablolarını yedeklemenizi şiddetle öneririz.</div>';
$string['upgradingquizattempts'] = 'Sınav uygulamaları güncelleniyor: Sınav  {$a->done}/{$a->outof} (Quiz id {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Çok eski sınav uygulamaları güncelleniyor: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Bu kategori korunmuş durumda ve başka kurslar tarafından kullanıldığı için site seviyesine taşındı.';
$string['useroverrides'] = 'Kullanıcıları geçersiz kılma';
$string['useroverridesdeleted'] = 'Kullanıcı geçersiz kılmaları silindi';
$string['usersnone'] = 'Hiç bir öğrenci bu sınavı uygulamadı';
$string['validate'] = 'Denetle';
$string['viewallanswers'] = '{$a} sınav denemesini görüntüle';
$string['viewallreports'] = '{$a} uygulaması için raporları görüntüle';
$string['viewed'] = 'Görüntülenen';
$string['warningmissingtype'] = '<b>Bu soru tipi henüz kurulmamış. Lütfen yöneticinizi uyarın.</b>';
$string['wheregrade'] = 'Notlarım nerede?';
$string['wildcard'] = 'Joker kart';
$string['windowclosing'] = 'Bu pencere kısa süre içinde kapanacak.';
$string['withsummary'] = 'Özet istatistiklerle';
$string['wronguse'] = 'Bu sayfayı böyle kullanamazsınız';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Bu sınavı uygulamadan önce bu kursa kaydolmanız gerekiyor';
$string['yourfinalgradeis'] = 'Bu sınav için son notunuz: {$a}.';
