<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'tr', version '4.3'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Erişim reddedildi';
$string['accountlocked'] = 'Hesabınız kilitlendi. E-posta yoluyla bir kilit açma bağlantısı gönderildi.';
$string['accounts'] = 'Hesaplar';
$string['accountunlocked'] = 'Hesabınızın kilidi açıldı. Giriş yapabilirsiniz.';
$string['addcategory'] = 'Bir kategori ekle';
$string['additionalhtml'] = 'Ek HTML';
$string['additionalhtml_desc'] = 'Bu ayarlar her sayfaya eklemek istediğiniz HTML kodunu belirtmenizi sağlar. Sayfanın HEAD etiketi içinde, BODY etiketi açıldıktan hemen sonra, ya da BODY etiketi kapanmadan hemen önce eklenecek HTML kodunu ayarlayabilirsiniz. <br/> Bunu yapmak size, seçtiğiniz temadan bağımsız olarak,  her tüm sayfalara özel üst ya da alt bilgi eklemeyi, ya da Google Analitik gibi hizmetler için destek ekleme olanağını sunar.';
$string['additionalhtml_heading'] = 'Ek HTML her sayfaya eklenecek.';
$string['additionalhtmlfooter'] = 'BODY kapatılmadan önce';
$string['additionalhtmlfooter_desc'] = 'Buradaki içerik her sayfaya, BODY etiketi kapatılmadan hemen önce eklenecektir.';
$string['additionalhtmlhead'] = 'HEAD içerisinde';
$string['additionalhtmlhead_desc'] = 'Buradaki içerik her sayfadaki HEAD etiketinin en altına eklenecektir.';
$string['additionalhtmltopofbody'] = 'BODY açıldığında';
$string['additionalhtmltopofbody_desc'] = 'Buradaki içerik <body> etiketinden hemen sonra, her sayfaya eklenecektir';
$string['admincategory'] = 'Kategori: {$a}';
$string['adminseesall'] = 'Yöneticiler tümünü görür';
$string['adminseesallevents'] = 'Yöneticiler tüm olayları görür';
$string['adminseesownevents'] = 'Yöneticiler diğer kullanıcılar gibidir';
$string['advancedfeatures'] = 'Gelişmiş özellikler';
$string['agedigitalconsentverification'] = 'Dijital yaş doğrulama';
$string['agedigitalconsentverification_desc'] = 'Kendileri kayıt olan kullanıcılar için, kayıt olma sayfasından önce dijital yaş doğrulama özelliğini etkinleştirir. Bu sitenizi küçük yaştaki çocukların ebeveyn onayı olmadan kayıt olmasına karşı korur. <a target="_blank" href="{$a}">Destek hattı</a> sayfasında küçük yaştaki çocuklara yardım sağlamak amacıyla detaylandırılmıştır.';
$string['ageofdigitalconsentmap'] = 'Dijital onay yaşı';
$string['ageofdigitalconsentmap_desc'] = 'Varsayılan dijital onay yaşı ve varsayılandan farklı olduğu herhangi bir ülkedeki yaş burada belirtilebilir. Her yaşı yeni bir satıra şu biçimle girin: ülke kodu, yaş (virgülle ayrılmış). Varsayılan yaş, ülke kodu yerine * ile gösterilir. Ülke kodları ISO 3166-2\'de belirtildiği gibidir.';
$string['allcountrycodes'] = 'Tüm ülke kodları';
$string['allowattachments'] = 'Dosya eklemeye izin ver';
$string['allowbeforeblock'] = 'Önce izin verilenler işleme alınacak';
$string['allowbeforeblockdesc'] = 'Varsayılan olarak, engellenen IP adresleri listesi ilk önce işleme alınır. Bu ayar etkinleştirilirse izin verilen IP adresleri, engellenenler listesinden önce işleme alınır.';
$string['allowcategorythemes'] = 'Kategori temalarına izin ver';
$string['allowcohortthemes'] = 'Topluluk temalarına izin ver';
$string['allowcoursethemes'] = 'Kurs temalarına izin ver';
$string['allowedemaildomains'] = 'İzin verilen e-posta alan adları';
$string['allowediplist'] = 'İzin verilen IP adresleri listesi';
$string['allowemailaddresses'] = 'İzin verilen e-posta alan adları';
$string['allowemojipicker'] = 'Emoji seçici';
$string['allowframembedding'] = 'Çerçeve gömmeye izin ver';
$string['allowframembedding_help'] = 'Etkinleştirilirse, bu site \'LTI aracı olarak yayınla\' kayıt eklentisi kullanıldığında önerildiği gibi uzak bir sistemdeki bir kareye gömülebilir. Aksi takdirde, güvenlik nedeniyle çerçeve yerleştirmeyi devre dışı bırakmanız önerilir. Mobil uygulama için bu ayarın yok sayıldığını ve çerçeve yerleştirmeye her zaman izin verildiğini lütfen unutmayın.';
$string['allowguestmymoodle'] = 'Misafirlerin kontrol paneli erişimine izin ver';
$string['allowindexing'] = 'Arama motorları tarafından indekslenmeye izin ver';
$string['allowindexing_desc'] = 'Bu, arama motorlarının sitenizi indekslemesine izin verip vermeyeceğini belirler. "Her yerde" seçeneği arama motorlarının oturum açma ve oturum sayfası da dahil olmak üzere her yerde arama yapmasına olanak tanıyacak ve bu da Force Login özelliği açık olan sitelerin dahi indekslenebileceği anlamına gelir. Kayıt sayfalarında spam oluşma ihtimalini önlemek için "Oturum açma ve kaydolma sayfaları hariç her yerde" seçeneğini kullanın. "Hiçbir yerde", arama motorlarına hiçbir sayfayı indeksleme diyecektir. Bunun sitenin başlığında sadece bir etiketten ibaret olduğuna dikkat edin. Etikete bağlı kalmak arama motorunun insiyatifindedir.';
$string['allowindexingeverywhere'] = 'Her yerde';
$string['allowindexingexceptlogin'] = 'Giriş ve kayıt sayfaları hariç her yerde';
$string['allowindexingnowhere'] = 'Hiçbir yerde';
$string['allowobjectembed'] = 'EMBED ve OBJECT etiketlerine izin ver';
$string['allowthemechangeonurl'] = 'URL üzerinde tema değişimine izin ver';
$string['allowuserblockhiding'] = 'Kullanıcılar blokları gizleyebilsin';
$string['allowusermailcharset'] = 'Kullanıcılar kendi yazı tiplerini seçebilsin';
$string['allowuserswitchrolestheycantassign'] = 'Kullanıcılara atama rolü yetkisi olmaksızın rol değişikliği yapma izni ver';
$string['allowuserthemes'] = 'Kullanıcı temasına izin ver';
$string['alternativefullnameformat'] = 'Alternatif tam ad biçimi';
$string['alternativefullnameformat_desc'] = 'Bu ayar kullanıcılara adların (varsayılan değer olarak yönetici, eğitmen ya da düzenleme yetkisi olmayan eğitmen) viewfullnames özelliğiyle nasıl gösterileceğini belirler. Kullanılabilecek yer tutucular "Tam adı biçimi" ayarlarında ayarlandığı şekildedir.';
$string['always'] = 'Daima';
$string['appearance'] = 'Görünüş';
$string['aspellpath'] = 'Aspell yolu';
$string['asyncbackupdisabled'] = 'Siteniz şu anda senkronize yedeklemeleri kullanacak şekilde yapılandırılmış.  Eşzamansız yedeklemeler daha iyi bir kullanıcı deneyimi sağlar.
 Moodle LMS 4.5 LTS\'den itibaren tüm siteler için eşzamansız yedeklemeler etkinleştirilecektir.
 Eşzamanlı yedeklemeler, Moodle LMS\'in 4.5 LTS\'den sonraki sürümünden kaldırılacaktır';
$string['authentication'] = 'Kimlik denetimi';
$string['authpreventaccountcreation'] = 'Kimlik doğrulaması yapılırken hesap oluşturulmasını engelle';
$string['authpreventaccountcreation_help'] = 'Bir kullanıcı giriş yaptığı yaptığı zaman sitede hesabı yoksa hesap otomatik olarak oluşturulur. LDAP gibi harici bir veritabanı giriş yapmak için kullanılıyorsa ve siz yalnızca varolan bir hesabı olan kullanıcılar için siteye erişim izni vermek istiyorsanız, o zaman bu seçenek etkin olmalıdır. Yeni hesapların elle veya yükleme özelliği yoluyla oluşturulması gerekecektir. Bu ayarın MNet kimlik doğrulaması için geçerli olmadığını unutmayın.';
$string['authsettings'] = 'Kimlik denetimini yönet';
$string['autolang'] = 'Otomatik dil algılama';
$string['autolangusercreation'] = 'Hesap oluştururken kullanıcının tarayıcı dilini tercih ettiği dil olarak ayarlayın';
$string['autologinguests'] = 'Otomatik misafir girişi';
$string['availableto'] = 'Uygun';
$string['availabletoanyone'] = 'Siteyi ziyaret eden herkes tarafından kullanılabilir';
$string['availabletoauthenticated'] = 'Kimliği doğrulanmış kullanıcılarla sınırla';
$string['backgroundcolour'] = 'Transparan renk';
$string['backup_shortname'] = 'Yedekleme dosya adında kurs adını kullan';
$string['backup_shortnamehelp'] = 'Kurs adı yedekleme dosya adınıniçinde geçsin.';
$string['backups'] = 'Yedekler';
$string['badwordsconfig'] = 'Kötü, küfürlü kelimeleri virgül ile ayırarak girin.';
$string['badwordsdefault'] = 'Belirtilen liste boşsa, dil paketinde geçen sözcükler kullanılacaktır.';
$string['badwordslist'] = 'Yasak sözcükler listesi';
$string['blockediplist'] = 'Engellenmiş IP adresleri listesi';
$string['blockinstances'] = 'Kullanım';
$string['blockmultiple'] = 'Çoklu kullanım';
$string['blockprotect'] = 'Kullanımları koru';
$string['blockprotect_help'] = 'Eğer belirli tipteki bir bloğu kilitlerseniz, kimse bu türdeki blok kullanımlarını ekleyemez veya silemez. (Eğer kullanımları düzenlemek gerekiyorsa, tabii ki, tekrar kilidini açabilirsiniz.)

Bu yanlışlıkla silinen ve geri alması çok zor olan dolaşımve ayarlar gibi blokları korumak için tasarlanmıştır.';
$string['blockprotectblock'] = '{$a} örneklerini koru';
$string['blockprotected'] = '{$a} blok örnekleri korunmaktadır.';
$string['blocksettings'] = 'Blokları yönet';
$string['blockunprotect'] = 'Korumayı kaldır';
$string['blockunprotectblock'] = '{$a} örneklerinin korumasını kaldırın';
$string['blockunprotected'] = '{$a} bloğu artık korunmuyor';
$string['bloglevel'] = 'Blok görünürlüğü';
$string['bookmarkadded'] = 'Yer imi eklendi.';
$string['bookmarkalreadyexists'] = 'Bu sayfayı zaten yer imi olarak eklediniz.';
$string['bookmarkdeleted'] = 'Yer imi silindi.';
$string['bookmarkthispage'] = 'Yer imlerine ekle';
$string['cacheapplication'] = 'Uygulama önbelleği';
$string['cacheapplicationhelp'] = 'Önbelleğe alınmış öğeler belirli bir zaman sürecinde tüm kullanıcılar arasında paylaşılır.';
$string['cachejs'] = 'Javascript önbelleğe alınsın';
$string['cachejs_help'] = 'Javascript önbelleğe alma ve sıkıştırma büyük ölçüde sayfa yükleme performansını artırır. Bu etkin siteleri için tavsiye edilir. Geliştiriciler muhtemelen bu özelliği devre dışı bırakmak isteyeceklerdir.';
$string['cacherequest'] = 'Talep önbelleği';
$string['cacherequesthelp'] = 'Kullanıcının talebi tamamlandığında süresi dolan, kullanıcıya özel önbellek. Statik depo kullanılan alanların yerini alması için tasarlanmıştır.';
$string['cachesession'] = 'Oturum önbelleği';
$string['cachesessionhelp'] = 'Kullanıcının oturumu sona erdiğinde süresi dolan, kullanıcıya özel önbellek. Oturum yükünü/şişkinliğini azaltmak için tasarlanmıştır.';
$string['cachesettings'] = 'Önbellek ayarları';
$string['cachetemplates'] = 'Önbellek şablonları';
$string['cachetemplates_help'] = 'Şablon önbelleğe alma, sayfa yükleme performansını iyileştirir ve üretim siteleri için şiddetle önerilir. Geliştiriciler muhtemelen bu özelliği devre dışı bırakmak isteyecektir.';
$string['caching'] = 'Önbelleğe alma';
$string['calendar_weekend'] = 'Haftasonu günler';
$string['calendarexportsalt'] = 'Takvim dışa aktarım şifresi';
$string['calendarsettings'] = 'Takvim';
$string['calendartype'] = 'Takvim türü';
$string['calendartype_desc'] = 'Tüm site için varsayılan takvim türünü seçin. Bu ayar daha sonra kullanıcılar tarafından kendi profillerinde değiştirilebilir.';
$string['campaign'] = 'Kampanya';
$string['cannotdeletemodfilter'] = '\'{$a->filter}\', \'{$a->module}\' eklentisinin bir parçası olduğu için kaldıramazsınız.';
$string['cannotuninstall'] = '\'{$a}\' kaldırılamaz';
$string['categoryemail'] = 'E-posta';
$string['cfgwwwrootslashwarning'] = 'config.php dosyasında $CFG->wwwroot yanlış tanımlanmış. Sonunda kaldırılması gereken bir \'/\' karakteri içerir.';
$string['cfgwwwrootwarning'] = '$ CFG-> wwwroot config.php dosyasında yanlış tanımlanmış. Bu sayfaya erişmek için kullandığınız URL ile eşleşmelidir';
$string['change'] = 'değiştir';
$string['checkboxno'] = 'Hayır';
$string['checkboxyes'] = 'Evet';
$string['checkupgradepending'] = 'Güncelle';
$string['choosefiletoedit'] = 'Düzenlenecek dosyayı seçiniz';
$string['cleanup'] = 'Temizlik';
$string['clianswerno'] = 'h';
$string['cliansweryes'] = 'e';
$string['cliexitgraceful'] = 'Çıkış yapılıyor, lütfen bekleyiniz ...';
$string['cliexitnow'] = 'ŞİMDİ yetkiden çıkılıyor';
$string['cliincorrectvalueerror'] = 'Hata, "{$a->option}" seçeneği için  geçersiz değer : "{$a->value}"';
$string['cliincorrectvalueretry'] = 'Geçersiz değer, lütfen tekrar deneyin';
$string['clistatusdisabled'] = 'Durum : Devre Dışı';
$string['clistatusenabled'] = 'Durum : Etkin';
$string['clistatusenabledlater'] = 'durum: CLI bakım modu {$a} için etkin olacak';
$string['clitypevalue'] = '';
$string['clitypevaluedefault'] = 'değeri yazın, varsayılan değeri ({$a}) kullanmak için Enter tuşuna basın';
$string['cliunknowoption'] = 'Tanımlanamauan seçenek:
   {$a}
Lütfen --help seçeneğini kullanın.';
$string['cliupgradecompletenomaintenanceupgrade'] = 'Kullanıcı trafiği yeni koda geçtikten sonra kalan önbellekleri temizlemek için:

  php admin/cli/purge_caches.php --muc
  php admin/cli/purge_caches.php --js
  php admin/cli/purge_caches.php --filter
  php admin/cli/purge_caches.php --other

Web sunucusundaki yük artışlarını azaltmak için bu temizleme işlemlerini komutlar arasında bir boşluk bırakarak ayrı ayrı gerçekleştirmelisiniz.';
$string['cliupgradedefault'] = 'Yeni ayar: {$a}';
$string['cliupgradedefaultheading'] = 'Yeni varsayılan değerleri ayarlama';
$string['cliupgradedefaultverbose'] = 'Yeni ayar: {$a->name}, Varsayılan değer: {$a-> defaultsetting}';
$string['cliupgradefinished'] = 'Komut satırı yükseltmesi {$a->oldversion} \'dan {$a->newversion}\' a başarıyla tamamlandı.';
$string['cliupgrademaintenancenotrequired'] = 'Bu yükseltme, kullanıcılar için bakım moduna neden OLMAYACAKTIR.';
$string['cliupgrademaintenancerequired'] = 'Bu yükseltme, kullanıcılar için bakım moduna neden OLACAKTIR.';
$string['cliupgradenoneed'] = 'Yüklü olan {$a} versiyonu için güncelleme gerekmiyor. Yİne de geldiğin için teşekkürler!';
$string['cliupgradepending'] = 'Bir güncelleme bekleniyor';
$string['cliupgradesetlock'] = 'Yükseltme yalnızca CLI yürütmesine kilitlendi.';
$string['cliupgradeunsetlock'] = 'Mevcut CLI yürütme yükseltme kilidi kaldırıldı.';
$string['cliyesnoprompt'] = 'e (evet) ya da h (hayır) yazın';
$string['close'] = 'Kapat';
$string['cohort_customfield'] = 'Topluluk özel alanları';
$string['commentsperpage'] = 'Sayfa başına görüntülenen yorum';
$string['commonactivitysettings'] = 'Ortak etkinlik ayarları';
$string['commonfiltersettings'] = 'Genel filtre ayarları';
$string['commonsettings'] = 'Ortak ayarlar';
$string['componentinstalled'] = 'Bileşen yüklendi';
$string['computedfromlogs'] = '{$a} tarihinden itibaren oluşan kayıtlar.';
$string['condifmodeditdefaults'] = 'Yeni bir etkinlik ya da kaynak yaratılırken ayarlar formundaki öntanımlı değerler kullanılır.';
$string['confeditorhidebuttons'] = 'HTML editöründe görünmeyecek düğmeleri seçin';
$string['configallcountrycodes'] = 'Bu kullanıcı profili gibi çeşitli yerlerde seçilebilecek ülke listesidir. Eğer boş bırakılırsa (varsayılan) countries.php dosyasındaki standart İngilizce dil paketi çevirisi olan liste kullanılacaktır. Bu ISO 3166-1 standardındaki listedir. Diğer türlü vigülle ayrılmış bir liste belirtebilirsiniz: \'GB,FR,ES\'. Eğer buraya yeni, standart olmayan kodlar girerseniz onları countries.php dosyasına \'en\' ve kendi dil dosyanıza ekleyin.';
$string['configallowassign'] = 'Sol sütundaki her rol için, diğer kişilelere atayabilecekleri rolleri seçin.';
$string['configallowattachments'] = 'Etkinleştirilirse, siteden gönderilen e-postalarda rozet gibi ekler olabilir.';
$string['configallowcategorythemes'] = 'Bunu etkinleştirirseniz temalar kategori düzeyinde ayarlanabilir. Bu, özel olarak kendi temalarını ayarlamadıkları sürece tüm alt kategorileri ve kursları etkileyecektir. UYARI: Kategori temalarını etkinleştirmek performansı etkileyebilir.';
$string['configallowcohortthemes'] = 'Bunu etkinleştirirseniz, temalar kohort düzeyinde ayarlanabilir. Bu, yalnızca bir kohort veya birden fazla ancak aynı temaya sahip tüm kullanıcıları etkiler.';
$string['configallowcoursethemes'] = 'Etkinleştirilirse, kursların kendi temalarını ayarlamasına izin verilecektir. Kurs temaları, diğer tüm tema seçeneklerini (site, kullanıcı, kategori, kohort veya URL tanımlı temalar) geçersiz kılar.';
$string['configallowedemaildomains'] = 'Giden e-postanın "Kimden" bölümünde açıklanmasına izin verilen e-posta alanlarını listeleyin. Varsayılan "Boş" olarak bırakılırsa giden tüm e-postalar için Yanıt Yok adresi kullanılır. Joker karakterler kullanılabilir; örneğin; * .example.com, example.com adresinin herhangi bir alt alanından gönderilen e-postalara izin verir, ancak example.com adresinin kendisinden olanlara değil. Bu, ayrı bir girdi gerektirir.';
$string['configallowemailaddresses'] = 'Yeni e-posta adreslerini belirli alan adlarıyla sınırlamak için, bunları burada boşluklarla ayırarak listeleyin. Diğer tüm alanlar reddedilecektir. Alt alan adlarına izin vermek için, alanı başında "." İle ekleyin. Bir kök etki alanına alt etki alanlarıyla birlikte izin vermek için, etki alanını iki kez ekleyin - bir kez başında "." ve bir kez ör. .ourcollege.edu.au ourcollege.edu.au.';
$string['configallowemojipicker'] = 'Emoji seçici, kullanıcıların araç çubuğundaki bir emoji seçici düğmesiyle mesajlara ve diğer metin alanlarına eklemek için ifadeler gibi emojileri seçmelerini sağlar.';
$string['configallowemojipickerincompatible'] = 'Mevcut veritabanı yapılandırmanız emojileri düzgün bir şekilde desteklemiyor. Emoji seçiciyi etkinleştirmek için <a href="https://docs.moodle.org/en/MySQL_full_unicode_support"> tam unicode desteği için veritabanınızı yükseltmeniz </a> gerekir.';
$string['configallowguestmymoodle'] = 'Etkinleştirilirse konuklar Gösterge Tablosuna erişebilir. Aksi takdirde konuklar site ana sayfasına yönlendirilir.';
$string['configallowobjectembed'] = 'Güvenlik için, öğrenci rolüne sahip kullanıcıların HTML\'de EMBED ve OBJECT etiketlerini kullanarak metinlerin içine multimedya yerleştirmelerine izin verilmez, ancak multimedya eklentileri filtresi kullanılarak multimedya görüntülenebilir. Eğer bu etiketlere izin vermek istiyorsanız bu seçeneği etkinleştirin.';
$string['configallowoverride'] = 'Sol taraftaki rollere sahip kişilerin, sütundaki bazı rolleri tekrar tanımlamasına izin verebilirsiniz.';
$string['configallowoverride2'] = 'Sol sütundaki her rol için geçersiz kılma ayarlayabilecekleri rolleri seçin.<br/>Kullanıcıların ayrıca moodle/role:override veya moodle/role:safeoverride yeteneğine sahip olması gerekir.';
$string['configallowswitch'] = 'Sol sütundaki her rol için hangi rollere geçebileceklerini seçin.<br/>Kullanıcıların ayrıca moodle/role:switchroles yeteneğine sahip olması gerekir.';
$string['configallowthemechangeonurl'] = 'Bu ayar etkinleştirilirse, herhangi bir Moodle adresine  bunlar eklenerek tema değiştirilebilir: <br/>?theme=temanın adı (örneğin: moodlesitesi.com/?theme=afterburner) ya da <br/>&theme=temanın adı (örneğin: moodlesitesi.com/course/view.php?id=2&theme=afterburner).';
$string['configallowuserblockhiding'] = 'Bu sitenin tamamında kullanıcıların blokları  gizleyip/göstermesine izin vermek istiyor musunuz? Bu özellik, her bir açılır/kapanır bloğun durumunu takip etmek için Javascript ve çerezleri kullanır. Ayrıca, sadece kullanıcının kendisinin sayfayı nasıl göreceğini etkiler.';
$string['configallowusermailcharset'] = 'Bunun etkinleştirilmesiyle her kullanıcının e-postası için kendi karakter setini ayarlamasına olanak verilir.';
$string['configallowuserswitchrolestheycantassign'] = 'Varsayılan olarak, moodle/role:assign kullanıcıların rol değişikliği yapmaları için gereklidir. Bu ayarı etkin kılmak bu gereksinimi ortadan kaldırır ve aşağı doğru açılan "Rolü değiştirin" menüsünde mevcut rollerin yalnızca "Rol atamalarına izin ver" tablosundaki ayarlar tarafından belirlenmesine yol açar. "Rol atamalarına izin ver" tablosundaki ayarların kullanıcılara şu anki rollerinden daha fazla yetenek içeren bir role geçmelerine izin vermemesi önerilir.';
$string['configallowuserthemes'] = 'Bunu etkinleştirirseniz, kullanıcıların kendi temalarını belirlemelerine izin verilir.  Kullanıcı temaları site temalarını geçersiz kılar (ancak kurs temalarını geçersiz kılmaz)';
$string['configallowview'] = 'Sol sütundaki her rol için hangi rolleri görüntüleyebileceklerini, arayabileceklerini ve filtreleyebileceklerini seçin.';
$string['configallusersaresitestudents'] = 'Ana sayfadaki etkinlikler için, kullanıcıların TÜMÜ öğrenci olarak kabul edilmeli mi?  Cevabınız evet ise, hesabı olan herkesin bu etkinliklere öğrenci olarak katılmasına izin verilecektir.  Hayır ise, yalnızca halihazırda en az bir kursa katılmış olan kullanıcılar bu etkinliklere katılabilir.  Yalnızca yöneticiler ve özel olarak atanmış öğretmenler, site anasayfa etkinlikleri için öğretmen olarak hareket edebilir.';
$string['configauthenticationplugins'] = 'Lütfen kullanmak istediğiniz giriş yapma eklentilerini seçin ve bu eklentileri en önemli en üstte olacak biçimde sıraya koyunuz.';
$string['configautolang'] = 'Tarayıcı ayalarından öntanımlı dili tespit et eğer devre dışı bırakılmışsa öntanımlı site dilini kullan.';
$string['configautolangusercreation'] = 'Etkinleştirilirse, bir kullanıcının hesabı ilk girişte otomatik olarak oluşturulduğunda (ör. LDAP veya OAuth 2 kimlik doğrulaması kullanılarak), kullanıcının tarayıcı dili tercih edilen dil olarak ayarlanır. Aksi takdirde, site için varsayılan dil, kullanıcının tercih ettiği dil olarak ayarlanır.';
$string['configautologinguests'] = 'Kurslara konuk erişimiyle girildiğinde ziyaretçiler konuk olarak giriş yapabilsin mi?';
$string['configbloglevel'] = 'Bu ayar, bu sitede görülebilen kullanıcı bloklarının seviyesini sınırlamanıza izin verir. Bu ayarın, göndereni veya blog mesajlarını değil, İZLEYİCİNİN maksimum seviyesini ayarladığını dikkate alın. İstemiyorsanız, bloglar tamamen kapatılabilir.';
$string['configcalendarcustomexport'] = 'Takvimde özel bir tarih aralığını dışa aktarmayı etkinleştir';
$string['configcalendarexportsalt'] = 'Bu rastgele metin, takvimlerin dışa aktarılmasında kullanılan giriş bilgilerinin güvenliğini geliştirmede kullanılır. Bu hash şifresini değiştirdiğinizde mevcut giriş bilgilerinin tamamının geçersiz olacağını unutmayın.';
$string['configcookiesecure'] = 'Sunucu yalnızca https bağlantılarını kabul ediyorsa, güvenli çerezlerin gönderiminin etkin kılınması önerilir. Etkin kılınırsa, web sunucusunun http:// kabul etmediğinden emin olun ya da https:// adresine kalıcı bir yeniden yönlendirmeyi ayarlayın - ya da en iyisi HSTS bağlıklarına gönderin. <em>wwwroot</em> adresi https:// ile başlamıyorsa bu ayar otomatik olarak kapatılır.';
$string['configcountry'] = 'Buradan bir ülke seçerseniz, yeni kullanıcılar için bu ülke varsayılan olarak seçili olacaktır. Ülke seçmeyi zorunlu tutmak istiyorsanız, bu seçeneği ayarlamayın.';
$string['configcoursegraceperiodafter'] = 'Geçmiş kursları, kurs bitiş tarihinden sonraki bu günler için devam eden olarak sınıflandırın.';
$string['configcoursegraceperiodbefore'] = 'Gelecekteki kursları, kurs başlangıç tarihinden önceki bu günler için devam eden olarak sınıflandırın.';
$string['configcourseoverviewfilesext'] = 'İzin verilen kurs görüntü dosyası uzantılarının virgülle ayrılmış listesi.';
$string['configcourseoverviewfileslimit'] = 'Kurs listesi sayfasındaki kurs özetinin yanında görüntülenebilecek maksimum dosya sayısı. Eklenen ilk resim dosyası, kullanıcıların Dashboard\'larındaki kursa genel bakışta kurs görüntüsü olarak kullanılır; tüm ek dosyalar yalnızca kurslar listesi sayfasında görüntülenir.';
$string['configcourserequestnotify'] = 'Yeni kurs istendiğinde bilgilendirilmesi için kullanıcının kullanıcı adını yazın.';
$string['configcourserequestnotify2'] = 'Bir kurs istendiğinde bilgilendirilecek kullanıcılar. Yalnızca kurslistelerini onaylayabilecek kullanıcılar burada listelenmiştir.';
$string['configcoursesperpage'] = 'Kurs listesinde sayfa başına görüntülenecek kurs sayısını girin.';
$string['configcourseswithsummarieslimit'] = 'Daha basit bir listelemeye dönmeden önce kursun özetini de içeren kurs listesinde gösterilecek maksimum sayı.';
$string['configcronclionly'] = 'Cron\'u bir web tarayıcısından çalıştırmak, ayrıcalıklı bilgileri anonim kullanıcılara ifşa edebilir. Bu nedenle, cron\'u yalnızca komut satırından çalıştırmanız veya uzaktan erişim için bir cron parolası ayarlamanız önerilir.';
$string['configcronremotepassword'] = 'Bu, cron.php komut dosyasının, aşağıdaki URL biçimini kullanarak parola sağlanmadan bir web tarayıcısından çalıştırılamayacağı anlamına gelir: <pre> https://site.example.com/admin/cron.php?password=opensesame </pre> Bu boş bırakılırsa, parola gerekmez.';
$string['configcurlcache'] = 'cURL önbelleği için saniye olarak yaşam süresi';
$string['configcustommenuitems'] = 'Burada özel bir menü yapılandırılabilir. Her bir menü öğesini yeni bir satıra şu formatla girin: menü metni, bir bağlantı URL\'si (isteğe bağlı, alt öğeleri olan bir üst menü öğesi için değil), bir araç ipucu başlığı (isteğe bağlı) ve bir dil kodu veya virgülle ayrılmış kod listesi ( isteğe bağlı, satırı yalnızca belirtilen dilin kullanıcılarına görüntülemek için), dikey çizgi karakterleriyle ayrılmış. Tire ile başlayan satırlar, önceki üst düzey menüde menü öğeleri olarak görünecek ve ### bir ayırıcı oluşturacaktır. Örneğin:
<pre>
Kurslar
-Tüm kurslar|/course/
-Kurs arama|/course/search.php
- ###
-SSS|Q|https://example.org/faq
-Preguntas más frecuentes|https://someurl .xyz/pmf||es
Mobil uygulama||https://example.org/app|Uygulamamızı indirin
</pre>';
$string['configcustomusermenuitems'] = 'Kullanıcı menüsünün içeriğini yapılandırabilirsiniz (otomatik olarak eklenen çıkış bağlantısı hariç).  Her satır boru karakterleriyle ayrılır ve 1) "langstringname, componentname" biçiminde veya düz metin olarak bir dizeden ve 2) bir URL\'den oluşur.  Bölücüler, istenildiği yerde bir veya daha fazla # karakterden oluşan bir satır eklenerek kullanılabilir.';
$string['configdbsessions'] = 'Etkinse, kullanıcı oturumlarını saklamak için veritabanı kullanılacaktır. Bu ayarı şimdi değiştirmeniz şu anda oturumu açık olan tüm kullanıcıların (siz de dahil) çıkış yapmasına neden olacaktır. MySQL kullanıyorsanız, my.cnf (veya my.ini) dosyasındaki \'max_allowed_packet\' ayarın en az 4M olduğundan emin olun. Diğer oturum sürücüleri doğrudan config.php üzerinden ayarlanabilir - daha fazla bilgi için config-dist.php dosyasına bakın. Eğer oturum sürücüsünü config.php dosyası içinde belirlerseniz bu seçenek görünmez olur.';
$string['configdebug'] = 'Bu seçeneği açık tutarsanız PHP\'deki error_reporting metodu daha fazla uyarı mesajı gösterecektir. Bu, sadece geliştiriciler için kullanışlıdır.';
$string['configdebugdisplay'] = 'Açık tutarsanız hata raporlaması HTML sayfasına gider. Bu uygulanabilir; ancak XHTML, JavaScript, oturum bilgilerini ve HTTP başlıklarını genelde bozar. Kapalı tutarsanız, daha iyi hata ayıklamaya izin vererek çıktıyı sunucu kütüklerine gönderir. PHP ayarında error_log  bu hata kaydının nereye gideceğini kontrol eder.';
$string['configdebugpageinfo'] = 'Sayfa bilgisinin sayfa altında yazdırılması için etkinleştirin.';
$string['configdebugvalidators'] = 'Sayfa alt bilgisinde harici doğrulama (validator) sunucularına bağlantılar olmasını istiyorsanız etkinleştirin. <em>w3cvalidator</em> kullanıcı adıyla yeni bir kullanıcı oluşturmanız ve konuk erişimi sağlamanız gerekebilir. Bu değişiklikler yetkisiz erişime izin verebilir. Etkin sitelerde etkinleştirmeyin!';
$string['configdefaulthomepage'] = 'Kullanıcılar siteye giriş yaptıktan sonra hangi sayfaya yönlendirilmeli? Ayar, Klasik tabanlı temaların kullanıcıları için gezinmedeki ilk bağlantıyı da belirler.';
$string['configdefaultrequestcategory'] = 'Sistem bağlamında yeni kurs talep etme kabiliyetine sahip kullanıcılar tarafından talep edilen kurslar, kullanıcılar farklı bir kategori seçemedikleri sürece bu kategoriye yerleştirilecektir.';
$string['configdefaultrequestedcategory'] = 'Talep edilen kurs onaylanırsa hangi kategoride yer alacak?';
$string['configdefaultuserroleid'] = 'Giriş yapan tüm kullanıcılara site seviyesinde  burada belirttiğiniz rolün yetkileri verilecektir. EK olarak, her bir kullanıcıya istediğiniz rol verilebilir. Varsayılan rol konuk rolüdür. Bu, başka rolleri olan kullanıcılarla karışıklığa sebep olmaz, tüm kullanıcıların site seviyesinde faydalı bir şey yapabilmesini garanti eder (forum mesajlarını okuma, kaynaklara bakma gibi).';
$string['configdeleteincompleteusers'] = 'Bu süreden sonra adı, soyadı veya e-posta alanı doldurulmamış tüm hesaplar silinir.';
$string['configdeleteunconfirmed'] = 'E-posta tabanlı kendi kendine kayıt gibi belirli kimlik doğrulama yöntemleri için, kullanıcıların belirli bir süre içinde hesaplarını onaylamaları gerekir. Bu sürenin sonunda, tüm eski onaylanmamış hesaplar silinir.';
$string['configdenyemailaddresses'] = 'Belirli adreslere ait e-posta adreslerini reddetmek için alan adlarını aynı biçimde buraya yazın. Alk alan adlarını reddetmek için alan adı öncesine \'.\' ekleyin. Örneğin: <strong>hotmail.com yahoo.com.uk .live.com</strong>';
$string['configdisableuserimages'] = 'Kullanıcıların kendi resimlerini değiştirmelerine izin verme';
$string['configdisplayloginfailures'] = 'Bu, kullanıcının önceden yapmış olduğu giriş hataları hakkında ekranda bilgi gösterir.';
$string['configdndallowtextandlinks'] = 'Kurs sayfasında metin ve linkler için sürükle bırakı etkinleştirin veya kapatın. Firefox içinde veya farklı tarayıcılar arasında metin sürüklemenin güvenilmez olduğunu unutmayın; hiçbir veri yüklenmemesi ya da bozuk metin yüklemesi ile sonuçlanabilir.';
$string['configdoclang'] = 'Belgeler sayfalarındaki bağlantılar için bu dil kullanılır.';
$string['configdocroot'] = 'Her sayfanın altbilgisindeki \'Bu sayfa için belgeler\' bağlantıları aracılığıyla bağlama özgü belgeler sağlamak için Moodle Docs\'a giden yolu tanımlar. Alan boş bırakılırsa bağlantılar görüntülenmez.';
$string['configdoctonewwindow'] = 'Etkinse, Moodle Belgeler bağlantıları yeni bir pencerede gösterilecektir.';
$string['configduration_high'] = 'Bu değer çok yüksek.  Maksimum değer {$a}\'dır.';
$string['configduration_low'] = 'Bu değer çok düşük.  Minimum değer {$a}\'dır.';
$string['configeditordictionary'] = 'Aspell, kullanıcının kendi dili için sözlüğe sahip değilse bu değer kullanılacaktır.';
$string['configeditorfontlist'] = 'Editör menüsünde görünecek fontları seçin.';
$string['configemailchangeconfirmation'] = 'Kullanıcılar, kimlik bilgilerindeki e-posta adresini değiştirdiklerinde e-posta ile onay iste.';
$string['configemaildkimselector'] = 'DKIM seçici isteğe bağlıdır ve DNS kayıtlarınız bununla eşleşmelidir.';
$string['configemailfromvia'] = 'Giden e-postanın "Kimden" bölümüne gönderen bilgisi ekleyin. Bu, alıcıyı bu e-postanın geldiği yer konusunda bilgilendirir ve yanlışlıkla "cevap vermeyin" e-posta adreslerine cevap yazan alıcılarla mücadele etmeye yardımcı olur.';
$string['configemailheaders'] = 'Tüm giden e-postalara harfi harfine eklenecek ham e-posta başlıkları.';
$string['configemailsubjectprefix'] = 'Tüm giden postaların konu satırına ön ek eklenecek metin.';
$string['configenableanalytics'] = '\'Okulu bırakma riski olan öğrenciler\' veya \'Yakında yapılacak etkinlikler\' gibi analiz modelleri tahminler oluşturabilir, içgörü bildirimleri gönderebilir ve mesajlaşma kullanıcıları gibi başka işlemler sunabilir.';
$string['configenableblogs'] = 'Bu anahtar tüm site kullanıcılarına kendi bloğunu oluşturma imkanı verir.';
$string['configenablecalendarexport'] = 'Takvimleri dışa aktarmaya ya da abone olmaya izin ver.';
$string['configenablecomments'] = 'Yorumları etkinleştir';
$string['configenablecourserequests'] = 'Etkinleştirilirse, yeni kurs talep etme yetkisine sahip kullanıcılar (moodle/course:request) bir kurs talep etme seçeneğini kullanabilir. Bu özelliğe varsayılan rollerin hiçbiri için izin verilmez. Sistem veya kategori bağlamında uygulanabilir.';
$string['configenabledevicedetection'] = 'Tema ve diğer özelliklerin uygulanması için telefon, akıllı telefon, tablet veya varsayılan cihazların (masaüstü bilgisayar, dizüstü bilgisayar, vs.) tespit edilmesini sağlar.';
$string['configenablemobilewebservice'] = 'Resmi Moodle uygulaması veya talep eden başka bir uygulama için mobil servisi etkinleştirin. Daha fazla bilgi için okuyun: {$a}';
$string['configenablerssfeeds'] = 'Etkinleştirilirse, site çapında - bloglar, forumlar, veritabanı etkinlikleri ve sözlükçeler gibi - çeşitli özellikler için RSS beslemeler oluşturulur. Aynı zamanda her bir etkinlik modülü için için RSS etkinliğinin etkinleştirmesi gerekir.';
$string['configenablerssfeedsdisabled'] = 'RSS içeriği tüm sitede devre dışı bırakıldığı için buna erişilemez. Etkinleştirmek için Yönetim/Yapılandırma ayarlarından Değişkenler bölümüne gidin.';
$string['configenablerssfeedsdisabled2'] = 'RSS beslemeleri şu anda site düzeyinde devre dışı bırakılmıştır. Site yönetimindeki Gelişmiş özelliklerde etkinleştirilebilirler.';
$string['configenablestats'] = 'Burada \'evet\'i seçerseniz, Moodle\'ın cronjob\'u günlükleri işleyecek ve bazı istatistikler oluşturacaktır.  Sitenizdeki trafik yoğunluğuna bağlı olarak bu işlem biraz zaman alabilir. Bunu etkinleştirirseniz, kurslarınızın her biri hakkında veya site genelinde bazı ilginç grafikler ve istatistikler görebilirsiniz.';
$string['configenabletrusttext'] = 'Varsayılan olarak Moodle, güvenlik riski oluşturabilecek kötü betikler, çokluortam vb nesneleri kaldırmak için kullanıcılardan geler metinleri temizler. Güvenli İçerik sistemi, belirli kullanıcılara bu gelişmiş özelliklere takılmaksızın kendi içeriklerini kullanabilme olanağı sunar. Bu sistemi etkinleştirdikten sonra istediğiniz role Güvenli İçerik İznini verin. Bu kullanıcılar tarafından gönderilen metinler ve yüklenen dosyalar güvenli olarak işaretlenir ve gösterilmeden önce temizlik işlemine tabi tutulmaz.';
$string['configenablewebservices'] = 'Web servisleri, Moodle uygulaması gibi diğer sistemlerin siteye giriş yapmasını ve işlem gerçekleştirmesini sağlar. Ekstra güvenlik için, uygulamayı veya web hizmetleri aracılığıyla entegrasyon gerektiren harici bir aracı/hizmeti kullanmıyorsanız ayar devre dışı bırakılmalıdır.';
$string['configenablewsdocumentation'] = 'Web Hizmetleri belgeleri otomatik üretimi ektinleştiriniz. Kullanıcı, kendi güvenlik anahtarları sayfasında {$a} kendi belgelerine erişebilir. Etkin iletişim kuralları yalnızca belgeleri görüntüler.';
$string['configerrorlevel'] = 'Görünmesini isteğiniz PHP uyarı miktarını seçiniz. Normal genellikle en iyi seçimdir.';
$string['configexportlookahead'] = 'Dışa aktarma sırasında ileriye dönük kaç güne bakılacak';
$string['configexportlookback'] = 'Dışa aktarma sırasında geriye dönük kaç güne bakılacak';
$string['configextendedusernamechars'] = 'Etkinleştirilirse, kullanıcı adları büyük harfler dışında herhangi bir karakter içerebilir. Aksi takdirde, yalnızca küçük harf, alt çizgi (_), kısa çizgi (-), nokta (.) ve (@) simgesi olan alfasayısal karakterlere izin verilir.';
$string['configextramemorylimit'] = 'Arama, yedekleme/geri yükleme veya cron gibi bazı betikler daha fazla bellek gerektirir. Büyük siteler için daha yüksek değerler ayarlayın.';
$string['configfilterall'] = 'Başlıklar, gezinme çubuğu ve benzeri yerlerdeki bütün metinleri filtrele. Bu, çoklu-dil filtresini kullanıyorsanız kullanışlıdır; diğer durumlarda sitenize biraz fazladan yük getirecektir.';
$string['configfiltermatchoneperpage'] = 'Otomatik-linkleme filtresi bir sayfanın tamamında sadece ilk eşleşen bağlantıya link verecektir. Diğer hepsi yok sayılır.';
$string['configfiltermatchonepertext'] = 'Otomatik bağlama filtreleri, sayfadaki her bir metin öğesinde bulunan ilk eşleşen metin örneği için yalnızca tek bir bağlantı oluşturur. Diğerleri görmezden gelinir. "Her sayfada bir kez filtre eşleşmesi" etkinleştirildiğinde bu ayarın hiçbir etkisi yoktur.';
$string['configfilternavigationwithsystemcontext'] = 'Filtrelemenin normal kullanımı, kullanıldığı bağlama bağlıdır (örneğin kurs bağlamı), ancak sitede gezinme için, her şeyi site bağlamıyla açıkça filtrelemek, "içerik ve başlıklar" filtrelemesini kullanırken performans iyileştirmeleri sağlayabilir.';
$string['configfilteruploadedfiles'] = 'Yüklenen tüm HTML ve metin dosyalarını göstermeden önce filtreleme işlemine tabii tut, sadece yüklenen HTML dosyalarını ya da hiçbirini seçebilirsiniz.';
$string['configforcelogin'] = 'Normalde, sitenin ana sayfası ve kurs listeleri (fakat kurslar değil) siteye giriş yapmayan herhangi bir kişi tarafından görülebilir. Bu kişilerin HİÇ BİR ŞEY yapmalarına izin vermeksizin giriş yapmaya zorunlu tutmak istiyorsanız bu ayarı etkinleştirebilirsiniz.';
$string['configforceloginforprofiles'] = 'Bu ayar insanları herhangi bir kullanıcının profilini görüntülemeden önce gerçek (Konuk-değil) hesap sahibi olarak oturum açmaya zorlar. Bu ayar devre dışı bıraktıysanız, bazı kullanıcılar herkese açık profillerinde  reklam (spam) veya diğer uygunsuz içerik ekleyerek herkesin görebileceği biçimde yayınlayabilirler.';
$string['configfrontpage'] = 'Yukarıda seçilen ögeler sitenin ana sayfasında gösterilecektir.';
$string['configfrontpagecourselimit'] = 'Maximum kurs sayısı';
$string['configfrontpagecourselimithelp'] = 'Kurs listelerinde site anasayfasında görüntülenecek en fazla kurs sayısı.';
$string['configfrontpageloggedin'] = 'Yukarıda seçilen ögeler kullanıcı giriş yaptığında sitenin anasayfasında gösterilecektir.';
$string['configfullnamedisplay'] = 'Bu, adların tam olarak görüntülendiklerinde nasıl gösterileceğini tanımlar. Varsayılan değer olan \'language\', karar vermek için geçerli dil paketindeki \'fullnamedisplay\' dizesine bırakır. Bazı dillerin farklı ad görüntüleme kuralları vardır.

Çoğu tek-dilli siteler için "Adı Soyadı" en uygun olan ayardır, ancak soyadları tamamen gizlemeyi seçebilirsiniz. Şu alanlar için  yer tutucular kullanılabilir: ad, soyad, firstnamephonetic, lastnamephonetic, middlename ve alternatename.';
$string['configgeoipfile'] = 'GeoLite2 City ikili veri dosyasının konumu. Bu dosya Moodle dağıtımının bir parçası değildir ve <a href="https://www.maxmind.com/">MaxMind</a>\'den ayrı olarak alınmalıdır. Ticari bir sürüm satın alabilir veya ücretsiz sürümü kullanabilirsiniz. <a href="https://dev.maxmind.com/geoip/geoip2/geolite2/">https://dev.maxmind.com/geoip/geoip2/geolite2/</a> adresinden yapabileceğiniz City veritabanı dosyasını indirmek için kayıt olmanız gerekir. Dosyayı kaydettirip indirdikten sonra, onu sunucunuzdaki "{$a}" dizinine çıkartın.';
$string['configgetremoteaddrconf'] = 'Sunucunuz ters bir vekil sunucu arkasındaysa, uzak IP adresini içermede hangi sayfa başlıklarının güvenli olacağını belirtmek için bu ayarı kullanabilirsiniz. Mevcut olan birincisi kullanılarak sayfa başlıkları sıra ile okunur.';
$string['configgradebookroles'] = 'Bu ayar, not defterinde kimlerin görüneceğini kontrol etmenizi sağlar.  Kullanıcıların bir kursun not defterinde gösterilebilmesi için o kursta bu rollerden en az birine sahip olması gerekir.';
$string['configgradeexport'] = 'Notları dışavermede not defteri dışaverim formatlarından hangilerinin birincil metod olacağına karar verin. Böylece, seçili takma programlar ayarlanır ve her not için \'en son dışaverilmiş\' alanı kullanır. Örneğin, bu dışaverilmiş kayıtların "yeni" ya da "güncellenmiş" olarak tanımlanmasıyla sonuçlanır. Bundan emin değilseniz hiçbir şeyi seçmeden bırakın.';
$string['confighiddenuserfields'] = 'Diğer kullanıcılardan, kurs yöneticileri ve eğitimcileri hariç, hangi kullanıcı bilgilerinin gizli kalmasını istediğinizi belirleyin. Bu ayar öğrenci gizliliğini arttırır. Birden fazla alan seçmek için CTRL tuşuna basılı tutun.';
$string['configidnumber'] = 'Şunları seçebilirsiniz: (a) Kullanıcılara hiç bir zaman ID no sorulmaz, (b) Kullanıcılara ID no sorulur ve bunu boş bırakmasına izin verilir, (c) Kullanıcılara ID no sorulur ama bunu boş bırakamaz. Belirtilirse Kullanıcının ID Numarası profilinde gösterilir.';
$string['configintro'] = 'Bu sayfada Moodle\'ın sunucunuzda düzgün bir şekilde çalışması için gerekli olan yapılandırma ayarlarını belirtebilirsiniz. Bunun için fazla tasalanmanıza gerek yok; çünkü, geçerli ayarlar genellikle iyi çalışır ve daha sonra bu sayfaya istediğiniz zaman geri gelip bu ayarları değiştirebilirsiniz.';
$string['configintroadmin'] = 'Bu sayfada sitenin tamamını kontrol altına alacak ana yönetici hesabınızı yapılandırmalısınız. Lütfen doğru bir e-postanın yanında güvenli bir kullanıcı adı ve şifre tanımladığınızdan da emin olun. Daha sonra daha fazla yönetici hesabı oluşturabilirsiniz.';
$string['configintrosite'] = 'Bu sayfa ana sayfayı ve sitenin adını yapılandırmanıza olanak sağlar. Bu ayarlarları değiştirmek için istediğiniz zaman ana sayfadaki Yönetim menülerini kullanarak buraya geri gelebilirsiniz.';
$string['configiplookup'] = 'Loglardaki bir IP adresini (ör: 34.12.222.93) tıkladığınızda IP adresinin nerede bulunduğunu tahmin eden bir harita size gösterilecektir. Bu tahmin için her birinin farklı avantaj ve dezavantajları olan seçebileceğiniz farklı eklentiler vardır.';
$string['configkeeptagnamecase'] = 'Biçim imi adlarının kendilerini oluşturan kullanıcılar tarafından girildiği büyük/küçük harf sistemi ile aynı kalmasını istiyorsanız bunu seçin';
$string['configlang'] = 'Sitenin tamamında geçerli olan varsayılan bir dil seçin. Kullanıcılar daha sonra dil menüsün veya kendi profil sayfalarını kullanark buyarı değiştirebilirler.';
$string['configlanglist'] = 'Boş bırakılırsa, sitede kurulu olan tüm diller dil menüsünde görüntülenecektir. Alternatif olarak, dil menüsü virgülle ayrılmış bir dil kodları listesi girilerek kısaltılabilir, örneğin en, de, fr. İstenirse, dil için dil paketi adından farklı bir ad şu format kullanılarak belirtilebilir: dil kodu | dil adı ör. En_kids | English, de_kids | Deutsch.';
$string['configlangmenu'] = 'Ana sayfa, giriş sayfası vb. yerlerde dil menüsünün görünüp görünmeyeceğini belirtin. Bu, kullanıcının kendi profilinde düzenleyebileceği dil tercihini etkilemeyecektir.';
$string['configlangstringcache'] = 'Bütün dil metinlerini derlenmiş dosyalar olarak data klasöründe  önbelleğe alır..';
$string['configlatinexcelexport'] = 'Excel dışaverimleri için kodlamayı seçin.';
$string['configlocale'] = 'Sitenin tamamı için geçerli bir yerelleştirme kodu girin. Bu, günlerin dilini ve gösterim biçimini  etkileyecektir. İşletim sisteminde bu yerelleştirmenin var olması gerekmektedir. Neyi seçeneğinizi bilmiyorsanız boş bırakınız. <br/> Örnekler: tr_TR.UTF-8, en_US.UTF-8 (Çoğu durumda bu alanın boş olması önerilir).';
$string['configlockrequestcategory'] = 'Etkinleştirilirse, sistem bağlamında yeni kurslar isteme yeteneğine sahip kullanıcılar, istekte yeni bir kurs formu olarak bir kategori seçemez. Kullanıcıları yalnızca bir kategoride yeni bir kurs istemekle sınırlamanın alternatif bir yolu, kategori bağlamında yeni kurslar isteme yeteneğini uygulamaktır.';
$string['configloglifetime'] = 'BBu, kullanıcı etkinlik kayıtlarının ne kadar süre saklı kalacağını belirtir. Bu süreden daha eski kayıtlar otomatikmen silinir. Kayıtları mümkün olan en uzun sürede tutmanız bunlara daha sonra gereksinim duymanız durumunda en iyisidir. Ancak, çok yoğun bir sunucunuz varsa ve performans sorunları yaşıyorsanız daha kısa bir süre belirtebilirsiniz. İstatistiklerin düzgün çalışıbilmesi için 30 dan düşük değerler tavsiye etmiyoruz.';
$string['configlookahead'] = 'Yaklaşan günler';
$string['configmailnewline'] = 'E-Posta mesajlarında yeni satır karakterleri kullanılılır. RFC 822bis\'e göre CRLF gerekir, bazı posta sunucuları LF\'den CRLF\'ye otomatik dönüştürme yaparken diğer posta sunucuları CRLF\'den CRCRLF\'ye yanlış dönüştürme yapar, öte yandan diğerleri yalın LF içeren postaları (örneğin qmail) reddeder. Gönderilemeyen e-posta ya da çift yeni satır sorunları yaşıyorsanız bu ayarı değiştirmeye çalışın.';
$string['configmaxbytes'] = 'Bu, siteye yüklenen dosyalar için bir maksimum boyutu belirtir. Bu ayar, post_max_size ve upload_max_filesize PHP ayarlarının yanı sıra Apache ayarı LimitRequestBody ile sınırlıdır. Buna göre, maxbytes, kurs veya etkinlik seviyesinde seçilebilecek boyut aralığını sınırlar. \'Site yükleme sınırı\' seçilirse, sunucunun izin verdiği maksimum boyut kullanılır.';
$string['configmaxconsecutiveidentchars'] = 'Parolalar bu sayıdan daha fazla ardışık aynı karakter içermemelidir. Bu seçimi geçersiz kılmak için 0 kullanın.';
$string['configmaxeditingtime'] = 'Bu ayar, kişilerin forum gönderileri ve sözlük yorumlarını ne kadar süre içinde tekrar düzenleyebileceğini tanımlar. Genellikle 30 dakika iyi bir değerdir.';
$string['configmaxevents'] = 'Yaklaşan Gün Olayları';
$string['configmaxusersperpage'] = 'Kurs, grup, topluluk, webservis vb. kullanıcı seçicide görüntülenen maksimum kullanıcı sayısı.';
$string['configmessaging'] = 'Etkinleştirilirse, kullanıcılar sitedeki diğer kullanıcılara mesaj gönderebilir.';
$string['configmessagingallowemailoverride'] = 'Kullanıcıların kendi profillerindeki email adreslerinden farklı bir email adresine bilgilendirme mesajları alabilmelerine izin ver.';
$string['configmessagingallusers'] = 'Etkinleştirilirse, kullanıcılar mesajlaşacak birini seçerken sitedeki tüm kullanıcıların listesini görüntüleyebilir ve mesaj tercihleri sitedeki herhangi birinden gelen mesajları kabul etme seçeneğini içerir. Devre dışı bırakılırsa, kullanıcılar yalnızca kurslarındaki kullanıcıların listesini görüntüleyebilir ve mesaj tercihlerinde yalnızca iki seçeneğe sahip olurlar: yalnızca kişilerinden veya kişilerinden ve kurslarındaki herhangi birinden gelen mesajları kabul etmek.';
$string['configmessagingdefaultpressenter'] = 'Kullanıcıların mesajlaşma ayarlarında \'Göndermek için enter kullan\' seçeneğinin varsayılan olarak etkin olup olmadığı.';
$string['configmessagingdeleteallnotificationsdelay'] = 'Yer kazanmak için okunmuş ve okunmamış bildirimler silinebilir. Bir bildirim oluşturulduktan ne kadar süre sonra silinebilir?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Okunmuş bildirimleri silmek diskte yer kazandıracaktır. Bildirimler okunduktan ne kadar süre sonra silinsin?';
$string['configminpassworddigits'] = 'Şifreler en az bu kadar rakam içermeli.';
$string['configminpasswordlength'] = 'Şifreler en az bu kadar karakter içermeli.';
$string['configminpasswordlower'] = 'Şifreler en az bu kadar küçük karakter içermeli.';
$string['configminpasswordnonalphanum'] = 'Şifreler en az bu kadar rakam veya sayı olmayan karakter içermeli.';
$string['configminpasswordupper'] = 'Şifreler en az bu kadar büyük karakter içermeli.';
$string['configmycoursesperpage'] = 'Kullanıcıların kendi kurs listesinde gösterilicek en fazla ders sayısı';
$string['configmymoodleredirect'] = 'Bu ayar, yönetici hakkına sahip olmayan kullanıcılar giriş yaptığında onları /my gezinme menüsüne yönlendirir ve üst düzey site dolaşımının yerine /my yerleştirir.';
$string['configmypagelocked'] = 'Bu ayar, varsayılan sayfanın yönetici olmayanlar tarafından düzenlenmesini önler.';
$string['confignavcourselimit'] = 'Kullanıcıya dolaşımda gösterilecek kurs sayısını sınırlandırır.';
$string['confignavshowallcourses'] = 'Bu ayar, kurslara kayıtlı olan kullanıcıların gezinti sırasında Kurslarım\'a (kayıtlı oldukları kursları listeler) ek olarak Kurslar\'ı (tüm kursları listeler) görüp göremeyeceğini belirler.';
$string['confignavshowcategories'] = 'Gezinti çubuğunda ve gezinti bloklarında kurs kategorilerini gösterin. Bu, kullanıcının halihazırda kayıtlı olduğu kurslarda gerçekleşmez; bunlar Kurslarım altında kategorisiz olarak listelenmeye devam eder.';
$string['confignoreplyaddress'] = 'E-postalar bazen bir kullanıcı tarafından gönderilir (forum gönderileri gibi). Burada belirteceğiniz adres, alıcılara direkt cevap verememesi gibi durumlarda "Kimden" alanında kullanılacaktır (örneğin bir kullanıcı kendi profilinde adresini gizli tutmayı tercih ettiğinde).  Bu ayar, e-posta gönderirken gönderici kısmı boş bırakılan mektupta gibi kullanılır';
$string['confignotifyloginfailures'] = 'Bu seçili kullanıcılara başarısız giriş iletilerini gönder. Bu seçenek için dahili bir kayıt deposunun (örneğin Standart Kayıt Deposu) devrede olması gerekir.';
$string['confignotifyloginthreshold'] = 'Giriş hataları uyarıları etkinse bir kullanıcı veya bir IP adresi tarafından kaç adet hatalı giriş denemesi dikkate alınacak?';
$string['confignotloggedinroleid'] = 'Siteye giriş yapmayan kullanıcılara site seviyesinde bu rol verilmiş olarak davranılacaktır. Konuk rolü burada belirtmek istediğiniz olacak, ancak daha az veya daha sınırlayıcı yeni rol oluşturarak bunu da kullanabilirsiniz. Mesaj gönderme gibi şeyler kullanıcının tam anlamıyla giriş yapmasını gerektirir.';
$string['configopentowebcrawlers'] = 'Bu ayarı etkinleştirirseniz, arama motorlarının sitenize konuk olarak girmesine izin verilir.  Ayrıca, sitenize bir arama motoru aracılığıyla gelen kişiler otomatik olarak konuk olarak oturum açacaktır.  Bunun yalnızca zaten misafir erişimine izin veren kurslara şeffaf erişim sağladığını unutmayın.';
$string['configoverride'] = 'config.php içerisinde tanımlanmış';
$string['configpasswordpolicy'] = 'Etkinleştirilirse, kullanıcı şifreleri, aşağıdaki ayarlarda belirtildiği gibi şifre politikasına göre kontrol edilecektir. Parola ilkesinin etkinleştirilmesi, mevcut kullanıcıları, parolalarını değiştirmeye karar vermedikçe veya değiştirmeleri gerekmedikçe veya \'Giriş sırasında parolayı kontrol et\' ayarı etkinleştirilmedikçe etkilemez.';
$string['configpasswordpolicycheckonlogin'] = 'Etkinleştirilirse, kullanıcılar her giriş yaptığında kullanıcı şifreleri şifre politikasına göre kontrol edilir. Kontrol başarısız olursa kullanıcının devam etmeden önce şifrelerini değiştirmesi gerekir.
Şifre politikasını güncelledikten sonra bu ayarı etkinleştirmek yararlıdır.';
$string['configpasswordresettime'] = 'Bu kullanıcıların şifre sıfırlama isteklerini süresi dolmadan önce doğrulamaları gereken zamanı ifade eder. Genellikle 30 dakika iyi bir değerdir.';
$string['configpathtodu'] = 'du\'nun yolu. İhtimalen /usr/bin/du gibi bir şeyler olmalı. Bunu girerseniz dosyası çok olan klasörlerin içerikleri daha hızlı gösterilir.';
$string['configpathtophp'] = 'PHP CLI yolu. Muhtemelen / usr / bin / php gibi bir şey. Bunu girerseniz, cron komut dosyaları yönetici web arayüzünden yürütülebilir.';
$string['configperfdebug'] = 'Bunu açık yaparsanız, performans bilgisi standard temanın altında yazılır';
$string['configprofileroles'] = 'Kullanıcı profillerinde ve Katılımcılar sayfasında listelenen roller.';
$string['configprofilesforenrolledusersonly'] = 'İstenmeyen e-posta göndericilerinin suistimalini engellemek için, henüz hiçbir derse kayıt yaptırmamış kullanıcıların profil açıklamaları gizlidir. Yeni kullanıcılar profil açıklaması ekleyebilmek için öncelikle en az bir kurs kayıt yaptırmış olmalıdırlar.';
$string['configprotectusernames'] = 'Etkinleştirilirse, unutulan şifre formu, hesap kullanıcı adlarının veya e-posta adreslerinin tahmin edilmesine izin veren herhangi bir ipucu göstermez.';
$string['configproxybypass'] = 'Vekil sunucu kullanmaması gereken (kısmi) internet adreslerinin ya da IP\'lerin virgül ile ayrılmış listesi (örnek,192.168., .alanadim.com)';
$string['configproxyfixunsafe_help'] = 'Bu işlem, MoodleBot Kullanıcı Aracısını ekleyerek ve proxy\'yi kullanarak proxy\'den geçmeyen dahili aramaları düzeltmeye çalışır.';
$string['configproxyhost'] = 'Bu <b>sunucunun</b> internete erişmek için bir vekil bilgisayara (firewall gibi) gereksinimi varsa vekil sunucunun host adını buraya yanız. Aksi takdirde boş bırakın.';
$string['configproxylogunsafe_help'] = 'Bu, proxy\'den geçmeyen ve olması gereken dahili aramaları günlüğe almaya çalışır.';
$string['configproxypassword'] = 'Gerektiğinde internete vekil sunucu üzerinden ulaşmak için parola gerekir, yoksa boştur (PHP cURL eklentisi gerekir).';
$string['configproxyport'] = 'Bu sunucu bir vekil sunucuya ihtiyaç duyuyorsa vekil sunucu portunu burada belirtin.';
$string['configproxytype'] = 'Web proxy tipi (SOCKS5 desteği için PHP5 ve cURL eklentisi gereklidir)';
$string['configproxyuser'] = 'Gerektiğinde internete vekil sunucu üzerinden ulaşmak için kullanıcı adı gerekir, yoksa boştur (PHP cURL eklentisi gerekir).';
$string['configrecaptchaprivatekey'] = 'Moodle sunucunuz ile recaptcha sunucusu arasında iletişim kurmak için kullanılan karakter dizisi (gizli anahtar). ReCAPTCHA anahtarları <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>\'dan edinilebilir.';
$string['configrecaptchapublickey'] = 'Kayıt ve site destek formunda reCAPTCHA öğesini görüntülemek için kullanılan karakter dizesi (site anahtarı). ReCAPTCHA anahtarları <a target="_blank" href="https://www.google.com/recaptcha"> Google reCAPTCHA </a> \'dan edinilebilir.';
$string['configrequestedstudentname'] = 'İstek kurslariçin öğrenci kelimesi';
$string['configrequestedstudentsname'] = 'İstek kurslar için öğrenciler kelimesi';
$string['configrequestedteachername'] = 'Talep edilen kurslar için öğretmenler için kullanılan kelime';
$string['configrequestedteachersname'] = 'Talep edilen kurslar için öğretmenler için kullanılan kelime';
$string['configreverseproxyignore'] = 'Sunucunuz, X-Forwarded-For başlığına eklenen birden çok ters proxy\'nin arkasındaysa, kullanıcının doğru IP adresini bulmak için yok sayılması gereken IP adreslerinin veya alt proxy\'lerin alt ağlarının virgülle ayrılmış bir listesini belirtin.';
$string['configsectioninterface'] = 'Arayüz';
$string['configsectionmail'] = 'Posta';
$string['configsectionmaintenance'] = 'Bakım';
$string['configsectionmisc'] = 'Çeşitli';
$string['configsectionoperatingsystem'] = 'İşletim Sistemi';
$string['configsectionpermissions'] = 'İzinler';
$string['configsectionrequestedcourse'] = 'Kurs istekleri';
$string['configsectionsecurity'] = 'Güvenlik';
$string['configsectionstats'] = 'İstatistik';
$string['configsectionuser'] = 'Kullanıcı';
$string['configsecureforms'] = 'Moodle, web formlarından veri kabul edilirken ek bir güvenlik seviyesi kullanabilir. Bu etkinse, tarayıcının adres çubuğundaki adresle HTTP_REFERER değişkeni kontrol edilir. Bazı durumlarda, kullanıcının firewall (Zonealarm gibi) programı web trafiğinden HTTP_REFERER değişkenini siliyorsa bu ayar sorunlara sebep olabilir. Bu durum web formları için kötü bir şeydir. Örneğin, bazı kullanıcılar giriş sayfasında sorunlar yaşıyorsa bu ayarı kapatabilirsiniz. Ancak bu durumda, bu değişken kontrol edilmediği için siteniz şifre deneyerek bulma saldırılarına açık olur. Bu durumdan şüpheleniyorsanız \'Evet\' seçin.';
$string['configservicespage'] = 'Bir hizmetler ve destek sayfasının URL\'sini girin veya moodle.com\'daki Moodle hizmetlerine bağlantı vermek için boş bırakın. Bağlantı yalnızca site yöneticileri için görüntülenir.';
$string['configsessioncookie'] = 'Bu seçenek Moodle oturumları için kullanılan çerezlerin adını ayarlar. Bu seçenek isteğe bağlıdır, ancak aynı anda aynı web sitesi birden çok moodle kopyası ile çalışıyorsa bu seçenek oluşan karışıklığı ortadan kaldırır.';
$string['configsessioncookiedomain'] = 'Bu Moodle çerezlerinin alındığı etki alanını değiştirmenizi sağlar. Bu, Moodle oturum bilgisini başka bir alt etki alanındaki web uygulaması ile paylaşması gereken Moodle özelleştirmeleri (örnek: kimlik denetimi ya da kayıt takma programları) için yararlıdır.<strong> UYARI: bu ayarın varsayılan (boş) halde bırakılması şiddetle önerilir - yanlış bir değer siteye tüm girişleri engelleyecektir.</strong>';
$string['configsessioncookiepath'] = 'Tarayıcıların Moodle çerezlerini (cookie) nereye kaydedeciğini değiştirmeye ihtiyaç duyuyorsanız, web sitenizin bir alt dizini belirtebilirsiniz. Diğer durumda geçerli \'/\' iyi bir seçenektir.';
$string['configsessiontimeout'] = 'Bu siteye giriş yapan kullanıcılar uzun süre işlem yapmazlarsa (sayfaları gezinmezse) ne kadar süre içinde oturum sona erecek?';
$string['configsessiontimeoutwarning'] = 'Bu siteye giriş yapan kişiler uzun süre boşta kalırsa (sayfaları yüklemeden), oturumlarının bitmek üzere olduğu konusunda uyarılırlar. Bu değişken, bu sürenin ne kadar olması gerektiğini belirtir.';
$string['configsessiontimeoutwarningcheck'] = 'Oturum zaman aşımı uyarısı, oturum zaman aşımından az olmalıdır';
$string['configshowcommentscount'] = 'Yorumların kaç kelimeden oluştuğunu göster. Yorum bağlantıları gösterilirken fazladan bir sorguya mal olacaktır.';
$string['configshowicalsource'] = 'iCal etkinlikleri için kaynak bilgisini göster';
$string['configshowsiteparticipantslist'] = 'Site öğrenci ve eğitimcilerinin hepsi, site katılımcı listesinde gösterilecektir. Bu katılımcı listesini kimlerin görmeye izni var?';
$string['configsitedefaultlicense'] = 'Varsayılan site lisansı';
$string['configsitedefaultlicensehelp'] = 'Bu sitede içerik yayınlamak için varsayılan lisans';
$string['configsitemailcharset'] = 'Siteniz tarafından oluşturulan bütün emailler burada belirttiğiniz karakter setinde gönderilecektir. Bir sonraki ayarı etkinleştirirseniz her bireysel kullanıcı kendininkini ayarlayabilecektir.';
$string['configsitemaxcategorydepth'] = 'Maximum kategori derinliği';
$string['configsitemaxcategorydepthhelp'] = 'Bu, kategoriler ya da açılır listeler gösterildiğinde alt katerogilerin en fazla derinliğinin ne olacağını belirler. Daha alt düzey kategoriler bağlantılar olarak sergilenir ve kullanıcı AJAX talepleriyle bunları genişletebilir.';
$string['configslasharguments'] = 'SCORM paketlerinin ve birden fazla dosyalı kaynakların doğru gösterilmesi için \'Slash argument\' (<em>PATH_INFO</em> kullanarak) gereklidir. Eğer sürücünüz \'slash arguments\' desteklemiyorsa ve ayarlarını yapamıyorsanız, bu seçenek devre dışı bırakılabilir - ama bazı şeylerin çalışmaması ile de sonuçlanabilir.<br/>Not: \'Slash arguments\' kullanımı gelecek Moodle sürümlerinde zorunlu olacak.';
$string['configsmartpix'] = 'Bunun seçilmesiyle, PHP betiği önce şu anki temayı, ardından bütün üst temaları, bunun ardından da Moodle /pix klasörüne göre arama yapacak ve simgeleri(ikon) buna göre gösterecektir.';
$string['configsmtpauthtype'] = 'Bu smtp sunucusunda kullanılacak kimlik doğrulama türünü ayarlar.';
$string['configsmtphosts'] = 'Moodle\'nin email göndermesi için bir veya birden fazla SMTP sunucu girebilirsiniz (ör: \'mail.a.com\' veya \'mail.a.com;mail.b.com\'). Bu seçeneği boş bırakırsanız PHP\'nin email gönderirken kullandığı varsayılan metot kullanılacaktır.';
$string['configsmtpmaxbulk'] = 'Her bir SMTP oturumu başına gönderilen maksimum mesaj sayısı. Mesajların gruplandırlması e-posta gönderimini hızlandırabilir. 2\'nin altındaki değerler her bir e-posta için yeni SMTP oturumunun oluşumunu zorunlu kılar.';
$string['configsmtpoauthservice'] = 'SMTP sunucusuyla konuşacak şekilde yapılandırılmış OAuth 2 hizmetini seçin.  Hizmet henüz yoksa, oluşturmanız gerekir.  SMTP Kimlik Doğrulama Türünü XOAUTH2 olarak ayarlamanız gerektiğini unutmayın.';
$string['configsmtpsecure'] = 'SMTP sunucusu güvenli bağlantı gerektiriyorsa, doğru protokol türünü belirtin.';
$string['configsmtpuser'] = 'Yukarıda bir SMTP sunucu belirttiyseniz ve bu sunucu yetki istiyorsa buraya sunucu için kullanıcı adı ve şifreyi giriniz.';
$string['configstartwday'] = 'Hafta başlangıcı';
$string['configstatsfirstrun'] = 'Cronjob istatistikleri <b>ilk kez</b> işlediğinde geriye dönük ne kadar kayıt (log) işleme alınacak. Web siteniz çok fazla trafiğe sahipse ve paylaşılan bir hostingde tutuluyorsa çok fazla geriye gitmeniz iyi bir fikir değildir. Çünkü, istatistiklerin çalışması çok uzun zaman alabilir ve aşırı bir şekilde kaynak tüketimine sebep olabilir. (Burada 1 ay = 28 gün, oluşturulan rapor ve grafiklerde ise 1 ay = 30 gündür)';
$string['configstatsmaxruntime'] = 'İstatistik işleme oldukça yoğun olabilir, bu yüzden bu ayarla istatistik işlemenin ne kadar süre çalışacağını tanımlayın.';
$string['configstatsmaxruntime2'] = 'İstatistik işlemi biraz yoğun olabilir, bir günlük istatistik bilgi toplamak için tanınan maksimum zamanı belirtin. Bir cron uygulamasında işlenen maksimum gün sayısı 31\'dir.';
$string['configstatsmaxruntime3'] = 'İstatistik işleminin sunucu üzerinde büyük yük oluşturacağını göz ardı etmeden, bir günlük istatistik hesaplaması için tanınan maksimum sürenin belirlenmesini sağlar. Bir cron işleminde işlenen maksimum gün sayısı aşağıda belirtilebilir.';
$string['configstatsruntimedays'] = 'Her bir istatistik işleminde işlenen maksimum gün sayısının belirlenmesini sağlar. İstatistikler güncellediğinde, yalnızca bir gün işlenecektir; bu nedenle, bu değeri sunucu yükünüze de bağlı olarak ayarlayın ve daha kısa cron işlemlerine gereksinim varsa azaltın.';
$string['configstatsruntimestart'] = 'Cronjob, istatistikleri işlemeye ne zaman başlasın? Tek bir sunucuda birden fazla Moodle sitesi varsa farklı zamanlar önerilir.';
$string['configstatsuserthreshold'] = 'Bu ayar; istatistiksel hesaplamalara dahil edilecek, bir kursa kayıtlı en az öğrenci sayısının belirlenmesini sağlar.';
$string['configstrictformsrequired'] = 'Etkinse, gerekli form alanlarında kullanıcıların boşluk girmesi ve yeni satıra geçmeleri engellenir.';
$string['configstripalltitletags'] = 'Etkinlik ve kaynak isimlerinde HTML etiketlerine izin vermek için bu seçeneğin işaretini kaldırın';
$string['configsupportavailability'] = 'Alt bilgiden site desteğine kimin erişebileceğini belirler.';
$string['configsupportemail'] = 'Bu sitede SMTP yapılandırılmışsa ve bir destek sayfası ayarlanmamışsa, bu e-posta adresi destek formu aracılığıyla gönderilen mesajları alacaktır. Gönderme başarısız olursa, oturum açmış kullanıcılara e-posta adresi gösterilecektir.';
$string['configsupportname'] = 'Destek formu veya destek sayfası aracılığıyla destek sağlayan kişinin veya diğer kuruluşun adı.';
$string['configsupportpage'] = 'Kullanıcıların site desteğiyle iletişim kurması için bu sayfaya bir bağlantı sağlanacaktır.  Alan boş bırakılırsa, bunun yerine bir destek formu bağlantısı sağlanır.';
$string['configtempdatafoldercleanup'] = 'Seçilen zamandan daha eski olan klasörleri ve data dosyalarını kaldır';
$string['configthemedesignermode'] = 'Normalde performans için tüm tema görselleri ve stil sayfaları tarayıcı tarafından önbelleğe alınmaktadır ve sunucu tarafından uzun süre tutulmaktadır. Eğer tema tasarımı yapıyorsanız ya da kod geliştiriyorsanız bu modu etkin hale getirebilirsiniz, bu sayede ön bellekteki sürümleri devre dışı bırakmış olursunuz. Uyarı: Bu işlem siteyi tüm kullanıcılar için daha yavaş çalışır hale getirir. Eğer isterseniz tema seçim sayfasından elle de önbelleği sıfırlayabilirsiniz.';
$string['configthemelist'] = 'Herhangi bir geçerli temanın kullanılmasına izin vermek istiyorsanız boş bırakın. Tema menüsünü kısaltmak istiyorsanız isimleri buraya virgülle ayırarak girebilirsiniz (Boşluk kullanmayın!). Örneğin: standard,orangewhite';
$string['configtimezone'] = 'Buradan tarihlerin gösterilmesi için varsayılan bölgesel zamanı ayarlayabilirsiniz - her bir kullanıcı kendi kişisel bilgilerinde bu ayarı kendisine göre ayarlayabilir. Cron görevleri ve diğer sunucu ayarları bu zaman dilimini kullanır. Eğer \'Geçersiz zaman dilimi\' uyarısı varsa bu ayarı değiştirmelisiniz.';
$string['configuseblogassociations'] = 'Kullanıcılar bloglarını, girdileri kurslar ve kurs modülleriyle ilişkilendirerek düzenleyebilir mi?';
$string['configusesitenameforsitepages'] = 'Etkinleştirilirse, sitenin kısa adı, gezinmedeki site sayfaları düğümü için \'Site sayfaları\' dizesi yerine kullanılacaktır.';
$string['configusetags'] = 'Etiket işlevselliği tüm sitede etkinleştirilsin mi?';
$string['configvariables'] = 'Değişkenler';
$string['configverifychangedemail'] = 'İzin verilen ve reddedilen e-posta etki alanı ayarları kullanarak değiştirilmiş e-posta adreslerinin onaylanmasını etkin kılar. Bu ayar geçersiz kılınmışsa, etki alanları yalnızca yeni kullanıcı oluştururken yürürlüğe girer.';
$string['configvisiblecourses'] = 'Gizli kategorilerdeki kursları normal şekilde göster';
$string['configwarning'] = 'Bu ayarları değiştirirken dikkatli olun. Bilmediğiniz değerleri girmeniz sorunlara sebep olabilir.';
$string['configyuicomboloading'] = 'Bu seçenekler YUI kütüphaneleri için müşterek dosya yükleme optimizasyonunu mümkün hale getirir. Bu ayar, performansa dayalı nedenlerle üretim sitelerinde etkinleştirilmelidir.';
$string['confirmation'] = 'Onaylama';
$string['confirmcontextlock'] = '{$a->contextname} şu anda donmuş durumda. Dondurmak onu salt okunur yapar ve kullanıcıların değişiklik yapmasını önler. Devam etmek istediğinizden emin misiniz?';
$string['confirmcontextunlock'] = '{$a->contextname} şu anda dondurulmuş. Dondurulmanın kaldırılması kullanıcıların değişiklik yapmasına olanak tanır. Devam etmek istediğinizden emin misiniz?';
$string['confirmdeletecomments'] = 'Seçilen yorumu/yorumları silmek istediğinizden emin misiniz?';
$string['confirmed'] = 'Onaylandı';
$string['contactsitesupport'] = 'Site desteğiyle iletişim kurun';
$string['contenttypeuninstalling'] = '{$a->type} tarafından desteklenen {$a->count} içeriği var. Bunlar silinecek. Devam etmek istediğinizden emin misiniz?';
$string['contextlockappliestoadmin'] = 'Bağlam dondurma yöneticiler için geçerlidir';
$string['contextlockappliestoadmin_desc'] = 'Devre dışı bırakılırsa, yöneticiler donmuş içeriklere yazma erişimine devam eder.';
$string['contextlocking'] = 'Dondurulmuş içerik';
$string['contextlocking_desc'] = 'Bu ayar, seçilen kategoriler, kurslar, etkinlikler veya bloklar için salt okunur erişimin ayarlanmasını sağlar.';
$string['cookiesecure'] = 'sadece güvenli çerezler';
$string['country'] = 'öntanımlı ülke';
$string['course_customfield'] = 'Kurs özel alanları';
$string['coursecolor'] = 'Renk {$a}';
$string['coursecolorheading_desc'] = 'Kurs ayarlarında kurs resmi ayarlanmamış tüm kurslar Kurslarım sayfasında desenli kurs kartı ile görüntülenir. Desende kullanılan renkler aşağıda belirtilebilir.';
$string['coursecolorsettings'] = 'Kurs kartı renkleri';
$string['coursecontact'] = 'Kurs yöneticileri';
$string['coursecontact_desc'] = 'Bu ayar, kurs açıklamasında kimlerin görüneceğini kontrol etmenizi sağlar. Kullanıcıların bir kursun kurs açıklamasında gösterilmesi için o kursta bu rollerden en az birine sahip olması gerekir.';
$string['coursecontactduplicates'] = 'Tüm kurs temas rollerini görüntüle';
$string['coursecontactduplicates_desc'] = 'Etkinleştirilirse, seçili kurs irtibat rollerinden birden fazlasına sahip olan kullanıcılar, rollerinin her birinde kurs açıklamasında görüntülenir. Aksi takdirde, yalnızca bir rolle gösterilirler (Site yönetiminde \'Rolleri tanımla\' hangisinde en yüksek olarak listelenirse).';
$string['coursecreationguide'] = 'Moodle kurs oluşturma kılavuzu URL\'si';
$string['coursecreationguide_help'] = 'Kurs oluşturmak için kısa videolar ve genel ipuçları içeren bir Hızlı Başlangıç kılavuzuna giden yolu tanımlar. Gösterilecek kurs olmadığında, Kurslarım sayfasında kılavuzun bağlantısı görüntülenir. Bağlantıyı yalnızca kurs oluşturma yetkisine sahip kullanıcılar görecektir.';
$string['coursegraceperiodafter'] = 'Geçmiş kurslar için ek süre';
$string['coursegraceperiodbefore'] = 'Gelecek kurslar için ek süre';
$string['courselistshortnames'] = 'Kurs adlarının uzun yazılışın göster';
$string['courselistshortnames_desc'] = 'Etkinleştirilirse kurs listelerinde tam adlara ek olarak kurs kısa adları da görüntülenir. Gerekirse genişletilmiş kurs adları, dil özelleştirme özelliği kullanılarak \'courseextendednamedisplay\' dil dizesi düzenlenerek özelleştirilebilir.';
$string['coursemgmt'] = 'Kursları ve kategorileri yönet';
$string['courseoverview'] = 'Kursa genel bakış';
$string['coursepage'] = 'Kurs sayfası';
$string['courserequestnotify'] = 'Kurs istek bildirimi';
$string['courserequestnotifyemail'] = 'Kullancı {$a->user} <a href="{$a->link}">{$a->link}</a>de yeni bir kurs istedi.';
$string['courserequests'] = 'Kurs istekleri';
$string['courserequestspending'] = 'Bekleyen kurs istekleri';
$string['courses'] = 'Kurslar';
$string['coursesperpage'] = 'Sayfa başına kurs';
$string['courseswithsummarieslimit'] = 'Özeti olan kurslar için sınır';
$string['creatornewroleid'] = 'Yeni kurslardaki oluşturanın rolü';
$string['creatornewroleid_help'] = 'Eğer kullanıcının önceden yeni dersi yönetme izni yok ise kullanıcı bu rolü kullanarak otomatik olarak yetkilendirilir.';
$string['cron'] = 'Zamanlayıcı';
$string['cron_enabled'] = 'Cron\'u etkinleştir';
$string['cron_enabled_desc'] = 'Cron normalde etkinleştirilmelidir, ancak bu ayar, örneğin bir sunucu yeniden başlatılmadan önce geçici olarak devre dışı bırakılmasına izin verir. Devre dışı bırakılırsa, sistemin yeni arka plan görevlerini başlatması engellenir. Önemli işlevselliğin çalışmasını engelleyeceği için cron\'un uzun süre devre dışı bırakılmaması gerektiğini unutmayın.';
$string['cron_help'] = 'Cron.php bakım betiği, forum iletileri için e-posta gönderilmesi gibi bir takım etkinliklerin ayarlanmış farklı zamanlarda gerçekleşmesini sağlar. Bu betik düzenli aralıklarla çalıştırılmalıdır - ideal olarak, her beş dakikada bir.';
$string['cron_keepalive'] = 'Canlı tut';
$string['cron_keepalive_desc'] = 'Ek görevler için yoklama yapmaya devam edilecek süre. Bu ayar cron\'un her zaman çalışmasını sağlamak içindir. Özel görev koşucuları kullanıyorsanız, 0 olarak ayarlayın. Aksi takdirde, geçici görev eşzamanlılık sınırına benzer bir değere ayarlayın. Daha uzun sürelerden kaçının. Maksimum süre 15 dakikadır.';
$string['cron_link'] = 'admin/cron';
$string['cronclionly'] = 'Cronu sadece komut satırından çalıştır';
$string['cronerrorclionly'] = 'Üzgünüz, bu sayfaya internet erişimi site yöneticisi tarafından devre dışı bırakılmıştır';
$string['cronerrorpassword'] = 'Üzgünüz, bu sayfaya erişmek için doğru bir şifre girmediniz.';
$string['croninfrequent'] = 'Cron bakım komut dosyasının son iki çalışması arasında {$a->actual} vardı ve her {$a->expected} çalıştırılmalıdır. Daha sık çalışacak şekilde yapılanmanızı öneririz.';
$string['cronremotepassword'] = 'Uzaktan erişim için cron şifresi';
$string['cronwarning'] = '<a href="{$a->url}">admin/cron.php script</a> betiği en az  {$a->actual} çalıştırılmadı ve {$a->expected}. çalıştırılmalıdır.';
$string['cronwarningcli'] = '<code>admin/cli/cron.php</code> betiği {$a->actual} için çalıştırılmadı ve {$a->beklenen} aralıklarla çalıştırılmalıdır.';
$string['cronwarningnever'] = '<code>admin/cli/cron.php</code> komut dosyası {$a->actual} için çalıştırılmadı ve her {$a->expected} çalıştırılmalıdır.';
$string['cronwarningneverweb'] = '<a href="{$a->url}">admin/cron.php script</a> hiç çalıştırılmamıştır ve her {a->expected} çalıştırılmalıdır.';
$string['ctyperequired'] = 'Site başarımını arttırmak ve çok dilli uyumluluk sunmak için ctype PHP uzantısı gereklidir.';
$string['curlcache'] = 'cURL önbelleği yaşam süresi';
$string['curlrequired'] = 'Moodle depolarıyla iletişim kurmak için artık Moodle tarafından cURL PHP uzantısı gerekiyor.';
$string['curlsecurityallowedport'] = 'cURL giriş listesine izin verdi';
$string['curlsecurityallowedportsyntax'] = 'cURL için bağlantı yapılabilecek port sayısı listesi. Geçerli değerler yalnızca tam sayılardır. Her bir girdiyi ayrı bir satıra yazın. Boş bırakılırsa bütün port\'lara izin verilir. Ayarlanırsa, hemen her zaman, standart HTTPS ve HTTP port;larına cURL bağlantısı için hem 443 hem de 80 belirlenmelidir.';
$string['curlsecurityblockedhosts'] = 'cURL engellenen barındırıcı listesi';
$string['curlsecurityblockedhostssyntax'] = 'Her girişi yeni bir satıra koyun. Geçerli girişler, tek bir ana bilgisayarla eşleşen tam IPv4 veya IPv6 adresleri (192.168.10.1, 0: 0: 0: 0: 0: 0: 0: 1, :: 1, fe80: :) gibi tam adreslerdir; Veya CIDR gösterimi (örneğin, 231.54.211.0/20 veya fe80 :: / 64); Veya aralık adresin son grubu için geçerli olan bir dizi IP adresi (örneğin 231.3.56.10-20 veya fe80 :: 1111-bbbb); Veya alan adları (localhost veya example.com gibi); Veya joker karakter alan adları (* .example.com veya * example.example.com gibi). Boş satırlara izin verilmiyor.';
$string['curlsecurityurlblocked'] = 'URL engellendi.';
$string['curltimeoutkbitrate'] = 'cURL zaman aşımları hesaplanırken kullanılacak bir değeri (Kbps)';
$string['curltimeoutkbitrate_help'] = 'Bu ayar, büyük cURL istekleri sırasında uygun bir zamanaşımı hesaplamak için kullanılır. Bu hesaplamanın bir parçası olarak içeriğin boyutunu belirlemek için bir HTTP HEAD isteği yapılır. Bunu 0 olarak ayarlamak, bu isteğin yapılmasını devre dışı bırakır.';
$string['currenttheme'] = 'Geçerli Tema';
$string['customcheck'] = 'Diğer kontroller';
$string['custommenu'] = 'Özelleştirilmiş menü';
$string['custommenuitems'] = 'Özelleştirilmiş menü elemanları';
$string['customusermenuitems'] = 'Kullanıcı menü öğeleri';
$string['datarootsecurityerror'] = '<p><strong>GÜVENLİK UYARISI!</strong></p><p>Verikökü dizininiz yanlış yerde ve web\'e açık durumda. Bu da tüm özel dosyalarınızın dünya üzerindeki herkese açık olması ve bazı kötü niyetli kişilerin sitenize yetkisiz yönetsel erişim yapmada kullanılabileceği anlamına gelir!</p><p>Verikökü dizinini ({$a}) halka açık web dizininde olmayan yeni bir yere <em>taşımalı</em> ve config.php\'nin <code>$CFG->dataroot</code> ayarını buna göre güncellemelisiniz.</p>';
$string['datarootsecuritywarning'] = 'Site yapılandırmanız güvenli olmayabilir. Lütfen veri dizininin (dataroot: {$a}) doğrudan internet üzerinden ulaşılmadığından emin olun.';
$string['dbprefixtoolong'] = 'Sitenizin veritabanı öneki ($CFG->prefix) çok uzun ({$a->current} karakter). İzin verilen maksimum karakter sayısı {$a->maximum}\'dur.';
$string['dbsessions'] = 'Oturum bilgileri için veritabanı kullan';
$string['debug'] = 'Hata ayıklama mesajları';
$string['debugall'] = 'TÜMÜ: Tüm uygun geribildirimleri göster';
$string['debugdeveloper'] = 'GELİŞTİRİCİ: Geliştiriciler için ek hata ayıklama mesajları';
$string['debugdisplay'] = 'Hata ayıklama mesajlarını göster';
$string['debugging'] = 'Hata ayıklama';
$string['debugminimal'] = 'MİNİMAL : Sadece onulmaz (ölümcül/fatal) hataları göster';
$string['debugnone'] = 'Hiç : Hiç bir hata ya da uyarıyı gösterme';
$string['debugnormal'] = 'Normal : Hataları, uyarı ve bildirimleri göster';
$string['debugpageinfo'] = 'Sayfa bilgisini göster';
$string['debugsqltrace'] = 'SQL çağrılarının kökenini göster';
$string['debugsqltrace1'] = 'Yalnızca tek bir çağrı hattını göster';
$string['debugsqltrace100'] = 'Yığın izinin tamamını göster';
$string['debugsqltrace2'] = '2 satır yığın izini göster';
$string['debugsqltrace_desc'] = 'Etkinleştirilirse, kısmi veya tam bir PHP yığın izlemesi, yorum olarak SQL\'e eklenir.';
$string['debugstringids'] = 'Dil ifadelerinin yerini göster';
$string['debugstringids_desc'] = 'Etkinleştirilirse, sayfa URL\'sine? ?strings=1 veya &strings=1 eklendiğinde dil dizesi bileşenleri ve tanımlayıcıları görüntülenir.';
$string['debugtemplateinfo'] = 'Şablon bilgilerini göster';
$string['debugtemplateinfo_desc'] = 'Etkinleştirilirse, işleme için kullanılan şablonlar sayfa HTML\'sinde yorum olarak gösterilir. Ayarı değiştirdikten sonra önbellekleri temizlemeniz gerekir. HTML doğrulama hataları ürettiğinden ve sayfa komut dosyalarını bozabileceğinden, yalnızca geçici hata ayıklama için kullanın. Ayrıca çekirdek işlevselliğini de bozabilir!';
$string['debugvalidators'] = 'Geçerlilik bağlantılarını göster';
$string['defaultcity'] = 'Öntanımlı şehir';
$string['defaultcity_help'] = 'Buraya girilen şehir, yeni kullanıcı hesapları oluştururken varsayılan şehir olacaktır.';
$string['defaultformatnotset'] = 'Varsayılan kurs biçimi belirlenirken hata oluştu. Lütfen site ayarlarını kontrol edin.';
$string['defaulthomepage'] = 'Kullanıcılar için başlangıç sayfası';
$string['defaultrequestcategory'] = 'Kurs istekleri için varsayılan kategori';
$string['defaultsettinginfo'] = 'Varsayılan: {$a}';
$string['defaultuserroleid'] = 'Tüm kullanıcılar için varsayılan rol';
$string['deleteincompleteusers'] = 'Bilgileri eksik kullanıcıları sil';
$string['deleteunconfirmed'] = 'Sonrasında tamamen ayarlanmamış kullanıcıları sil';
$string['deleteuser'] = 'Kullanıcı sil';
$string['density'] = 'Yoğunluk';
$string['denyemailaddresses'] = 'Reddedilen email domainleri';
$string['development'] = 'Geliştirme';
$string['devicedetectregex'] = 'Cihaz tespit düzenli ifadeleri';
$string['devicedetectregex_desc'] = '<p> Varsayılan olarak, Moodle, varsayılan varsayılan (masaüstü bilgisayarlar, dizüstü bilgisayarlar, vb.), Mobil (telefonlar ve küçük taşınabilir cihazlar), tablet (iPads, Android tabletler) ve eski (Internet Explorer 6 kullanıcıları) cihazlarını algılayabilir. Tema seçici, bunların hepsine ayrı temalar uygulamak için kullanılabilir. Bu ayar, fazladan cihaz türlerinin algılanmasına izin veren normal ifadelere izin verir (bunlar, varsayılan türlere göre önceliklidir). </p>
<p> Örneğin, sık kullanılan özellikli telefonların dönüş değerini \'özellikli telefon\' olarak eklemek için normal ifadeye \'/(MIDP-1.0|Maemo|Windows CE) /\' girebilirsiniz. Bu, bu cihazlarda kullanılacak bir tema eklemenizi sağlayacak tema seçici üzerinde \'özellik telefonu\' ekler. Diğer telefonlar, mobil cihaz türü için seçilen temayı kullanmaya devam eder. </p>';
$string['devicedetectregexexpression'] = 'Düzenli ifade';
$string['devicedetectregexvalue'] = 'Dönüş değeri';
$string['devicetype'] = 'Cihaz türü';
$string['devlibdirpresent'] = 'Herkese açık sitelerde <em>vendor</em> ve <em>node_modules</em> gibi geliştirme kitaplıkları içeren dizinlerin mevcut olmaması gerekir. Daha fazla ayrıntı için bakınız <a href="{$a->moreinfourl}">genel güvenlik raporu</a>.';
$string['disabled'] = 'Etkin değil';
$string['disableplugin'] = '{$a} \'ı devre dışı bırak';
$string['disableuserimages'] = 'Kullanıcı profil resimlerini devredışı bırak';
$string['displayerrorswarning'] = 'PHP için <em>display_errors (hataları göster)</em> ayarını etkinleştirmek deneme amaçlı olmayan siteler için önerilmez zira bazı hata mesajları, siteniz hakkındaki önemli bilgilerin açığa çıkmasına sebep olabilir.';
$string['displayloginfailures'] = 'Oturum açma hatalarını göster';
$string['divertallemails'] = 'E-posta yönlendirme';
$string['divertallemailsdetail'] = 'E-postaları test ederken geliştirme ortamlarında bir koruma olarak kullanılır ve üretimde kullanılmamalıdır.';
$string['divertallemailsexcept'] = 'E-posta yönlendirme istisnaları';
$string['divertallemailsexcept_desc'] = 'Virgülle veya yeni satırlarla ayrılmış e-posta istisna kurallarının bir listesi. Her kural normal bir ifade olarak yorumlanır, örneğin <pre>simone@acme.com
.*@ Acme.com
fred(\\+.*)?@acme.com
</pre>';
$string['divertallemailsto'] = 'Tüm e-postaları yönlendir';
$string['divertallemailsto_desc'] = 'Ayarlanırsa, tüm e-postalar bunun yerine bu tek e-posta adresine yönlendirilecektir.';
$string['dndallowtextandlinks'] = 'Sürükle bırak ile metin/link yükle';
$string['doclang'] = 'Döküman dili';
$string['docroot'] = 'Moodle Belgeleri yeri';
$string['doctonewwindow'] = 'Yeni pencerede aç';
$string['doesnotfit'] = 'E-posta gösterim ayarları';
$string['doesnotfitdetail'] = 'Moodle\'dan gönderilen e-postalar için ayarları görüntüle.';
$string['download'] = 'İndir';
$string['downloadcoursecontentallowed'] = 'Kursun içeriğini indirme özelliği mevcut';
$string['downloadcoursecontentallowed_desc'] = 'Kurs içeriği indirme özelliğinin kurslar için kullanılabilir olup olmadığı. Kullanılabilir olduğunda kurs içeriği indirmeleri, kurs düzenleme menüsündeki "Kurs içeriğini indirmeyi etkinleştir" ayarı kullanılarak etkinleştirilebilir/devre dışı bırakılabilir (bunun varsayılanı <a href={$a} target="_blank">Kurs varsayılan ayarları</a> içinde ayarlanabilir).';
$string['durationunits'] = 'süre birimleri';
$string['edithelpdocs'] = 'Yardım dökümanlarını düzenle';
$string['editlang'] = '<b>Düzenleme</b>';
$string['editorbackgroundcolor'] = 'Arka plan rengi';
$string['editordictionary'] = 'Editör sözlüğü';
$string['editorfontfamily'] = 'Font ailesi';
$string['editorfontlist'] = 'Font listesi';
$string['editorfontsize'] = 'Font Boyutu (Punto)';
$string['editorhidebuttons'] = 'Gizli butonlar';
$string['editorkillword'] = 'Word biçim filtresi';
$string['editorspelling'] = 'Editör yazım denetimi';
$string['editorspellinghelp'] = 'Sözcük denetimini etkinleştirip etkinleştirilmeyeceğini seçin. Etkinleştirildiğinde, <strong>aspell</strong> sunucuda kurulu olmalıdır.';
$string['editstrings'] = 'Kelime ve deyimleri düzenle';
$string['emailchangeconfirmation'] = 'email değişiklik onayı';
$string['emaildkim'] = 'DomainKeys Identified Mail (DKIM) e-posta imzalama';
$string['emaildkiminfo'] = 'Hem DKIM seçici ayarlanmışsa hem de e-postanın $CFG->dataroot/dkim/[domain]/[selector].private içindeki "Gönderen" adres alanıyla eşleşen özel bir sertifika dosyası bulunursa, e-posta imzalanır. Çoğu durumda (örneğin, izin verilen e-posta etki alanları boşsa) <pre>{$a->path}</pre> içinde yalnızca tek bir sertifika gerekir. Daha fazla kurulum ayrıntısı için <a href="{$a->docs}">Posta yapılandırması</a> belgelerine bakın.';
$string['emaildkimselector'] = 'DKIM seçici';
$string['emailfromvia'] = 'Bilgi üzerinden e-posta';
$string['emailheaders'] = 'E-posta başlıkları';
$string['emailsubjectprefix'] = 'E-posta konusu önek metni';
$string['emoticonalt'] = 'Alternatif metin';
$string['emoticoncomponent'] = 'Resim bileşeni';
$string['emoticonimagename'] = 'Resim adı';
$string['emoticons'] = 'Duygusal ifadeler';
$string['emoticons_desc'] = 'Bu form, sitenizde kullanılan ifadeleri (veya suratları) tanımlar. Tablodan bir satırı kaldırmak için, formu doldurmak için gerekli alanların herhangi birine boş bir değer kaydedin. Yeni bir ifade göndermek için son boş satırdaki alanları doldurun. Tüm alanları varsayılan değere sıfırlamak için yukarıdaki bağlantıyı izleyin.

* Metin (gerekli) - Bu metin, ifade görüntüsü ile değiştirilecektir. En az iki karakter uzunluğunda olmalıdır.
* Görüntü adı (gerekli) - Bileşen pix klasörüne göre uzantı içermeyen ifadenin resim adı.
* Görüntü bileşeni (gerekli) - simgesi sağlayan bileşen.
* Alternatif metin (isteğe bağlı) - İfadenin alternatif metnin dize tanımlayıcısı ve bileşeni.';
$string['emoticonsreset'] = 'Duygusal ifade ayarlarını öntanımlı değerler döndür';
$string['emoticontext'] = 'Metin';
$string['emptysettingvalue'] = 'Boş';
$string['enableanalytics'] = 'Analitikler';
$string['enableblogs'] = 'Blogları etkinleştir';
$string['enablecalendarexport'] = 'Takvim dışa aktarımını etkinleştir';
$string['enablecomments'] = 'Yorumları etkinleştir';
$string['enablecommunicationsubsystem'] = 'İletişim sağlayıcılarını etkinleştirin';
$string['enablecommunicationsubsystem_desc'] = 'Öğretmenlerin ve öğrencilerin daha kolay iletişim kurabilmesi için Matrix gibi iletişim sağlayıcılarla entegrasyona izin verin. Bu entegrasyonları <a href="settings.php?section=managecommunicationproviders">Plugins</a> bölümünden yönetebilirsiniz.';
$string['enablecourserelativedates'] = 'Kursun göreli tarihlerini etkinleştir';
$string['enablecourserelativedates_desc'] = 'Kursların, kullanıcının kurstaki başlangıç tarihine göre tarihleri gösterecek şekilde ayarlanmasına izin verin.';
$string['enablecourserequests'] = 'Kurs isteklerini etkinleştir';
$string['enabled'] = 'Etkinleştir';
$string['enabledashboard'] = 'Gösterge Tablosunu Etkinleştir';
$string['enabledashboard_help'] = 'Gösterge Tablosu, varsayılan olarak Zaman Çizelgesi, Takvim ve Son erişilen öğeleri gösterir. Herkes için farklı bir varsayılan Gösterge Tablosu ayarlayabilir ve kullanıcıların kendi Gösterge Tablolarını özelleştirmesine izin verebilirsiniz. Devre dışı bırakılırsa, \'Kullanıcılar için başlangıç sayfası\'nı Gösterge Tablosu dışında bir değere ayarlamanız gerekir.';
$string['enabledevicedetection'] = 'Cihaz tanımayı etkinleştir';
$string['enableglobalsearch'] = 'Global aramayı etkinleştir';
$string['enableglobalsearch_desc'] = 'Etkinleştirilirse, veriler zamanlanmış bir görev tarafından endekslenecek ve senkronize edilecektir.';
$string['enablegravatar'] = 'Gravatar etkinleştir';
$string['enablegravatar_help'] = 'Etkinleştirildiğinde eğer kullanıcı resim yüklememiş ise Moodle Gravatar\'dan kullanıcı profil resmi getirmeyi dener.';
$string['enablemobilewebservice'] = 'Mobile cihazlar için web servislerini etkinleştir';
$string['enablepdfexportfont'] = 'PDF fontlarını etkinleştir';
$string['enablepdfexportfont_desc'] = 'Sitenizde, oluşturulan PDF dosyalarında başka yazı tiplerine ihtiyaç duyan farklı dillerde kurslar varsa, kurs ayarlarında yazı tipini ayarlama seçeneği sunabilirsiniz. Mevcut yazı tiplerini config.php\'deki $CFG->pdfexportfont bölümünde belirtmeniz gerekir.';
$string['enableplugin'] = '{$a} etkinleştir';
$string['enablerecordcache'] = 'Kayıt önbelleklemeyi etkinleştir';
$string['enablerssfeeds'] = 'RSS beslemeleri etkinleştir';
$string['enablesearchareas'] = 'Arama alanlarını etkinleştir';
$string['enablesharingtomoodlenet'] = 'MoodleNet\'te paylaşımı etkinleştir (giden)';
$string['enablesharingtomoodlenet_desc'] = 'İlgili yeteneğe sahiplerse, kullanıcıların kurs içeriğini yapılandırılmış bir MoodleNet örneğinde paylaşmasına izin verin.';
$string['enablestats'] = 'İstatistikleri etkinleştir';
$string['enabletrusttext'] = 'Güvenli içeriği etkinleştir';
$string['enableuserfeedback'] = 'Bu yazılımla ilgili geri bildirimi etkinleştirin';
$string['enableuserfeedback_desc'] = 'Etkinleştirilirse, kullanıcıların Moodle HQ\'ya Moodle yazılımı hakkında geri bildirim vermesi için altbilgide \'Bu yazılım hakkında geri bildirim verin\' bağlantısı görüntülenir. \'Sonraki geri bildirim hatırlatıcısı\' seçeneği ayarlanırsa, kullanıcıya Gösterge Tablosunda belirtilen aralıklarla bir hatırlatıcı da gösterilir. "Sonraki geri bildirim hatırlatıcısı" nın "Asla" olarak ayarlanması, Altbilgide "Bu yazılım hakkında geri bildirim verin" bağlantısını bırakırken Gösterge Tablosu hatırlatıcısını devre dışı bırakır.';
$string['enablewebservices'] = 'Web hizmetlerini etkin kıl';
$string['enablewsdocumentation'] = 'Web servisleri dökümantasyonu';
$string['encryptedpassword_edit'] = 'Yeni değer girin';
$string['encryptedpassword_set'] = '(Ayarlanmış ve şifrelenmiş)';
$string['enroladminnewcourse'] = 'Yöneticiyi yeni kurslara otomatik kaydet';
$string['enroladminnewcourse_help'] = 'Bir yönetici yeni bir kurs eklediğinde, otomatik olarak kaydedilmeli ve yeni kurslarda içerik oluşturucu rolü atanmalı mı?';
$string['enrolinstancedefaults'] = 'Kayıt olma örneği varsayılanları';
$string['enrolinstancedefaults_desc'] = 'Yeni kurslar için varsayılan kayıt olma ayarları';
$string['enrolmultipleusers'] = 'Kullanıcıları kayıtla';
$string['entitytasklog'] = 'Görev günlüğü';
$string['environment'] = 'Ortam';
$string['environmenterrortodo'] = 'Bu Moodle sürümünü kurmaya başlamadan önce yukarıda bulunan bütün ortam sorunlarını (hatalarını) çözmeniz gerekiyor!';
$string['environmenterrorupgrade'] = 'Uyarı: Bu Moodle sürümüne geçmeden önce yukarıdaki bulunan bütün ortam sorunlarını (hatalarını) çözmeniz gerekiyor! Bu gereksinimleri yerine getirmeden güncelleme, veri kaybı gibi sorunlara neden olabilir. Güncellemeye devam etmek istediğinizden emin misiniz?';
$string['environmentmariadbwrongdbtype'] = 'Yanlış $CFG->dbtype. Bunu config.php dosyanızda \'mysqli\' yerine \'mariadb\' olarak değiştirmeniz gerekir.';
$string['environmentmustfixsetting'] = '';
$string['environmentok'] = 'Sunucunuz minumum gereksinimleri yerine getirmiş durumda.';
$string['environmentrecommendcustomcheck'] = 'bu test hata verirse önemli bir sorunu gösterir';
$string['environmentrecommendinstall'] = 'en iyi sonuçlar için yüklenmiş ve etkinleştirilmiş olmalıdır';
$string['environmentrecommendversion'] = 'sürüm {$a->needed} tavsiye edilir ve şu anda {$a->current} çalışıyor';
$string['environmentrequirecustomcheck'] = 'bu test geçmeli';
$string['environmentrequireinstall'] = 'yüklenmiş ve etkinleştirilmiş olmalıdır';
$string['environmentrequireversion'] = 'sürüm {$a->needed} gerekli ve şu anda {$a->current} çalışıyor';
$string['environmentsettingok'] = 'önerilen ayarda';
$string['environmentshouldfixcustomcheck'] = 'En iyi sonuç için etkinleştirilmelidir';
$string['environmentshouldfixsetting'] = 'PHP ayarı değiştirilmeli';
$string['environmentxmlerror'] = 'Ortam verisini okurken hata ({$a->error_code})';
$string['errordeletingconfig'] = '\'{$a}\' eklentisi için yapılandırma kayıtlarını silerken bir hata oluştu.';
$string['errorsetting'] = 'Ayar kaydedilemedi:';
$string['errorwithsettings'] = 'Bazı ayarlar bir hata yüzünden değişmedi.';
$string['eventshandlersinuse'] = 'Sisteminizdeki aşağıdaki eklentiler, Etkinlikler 1 API kullanımdan kaldırılmış işleyicileri kullanıyor: \'{$a}\'. Lütfen bunları, Etkinlik 2 API\'sini kullanacak şekilde güncelleyin.https://docs.moodle.org/dev/Events_API#Event_dispatching_and_observers sayfasına göz atın.';
$string['everyonewhocan'] = '\'{$a}\' izni olan herkes';
$string['exceptions'] = 'istisnalar';
$string['execpathnotallowed'] = 'Çalıştırılabilir ve yerel yollar ayarlama özelliği config.php dosyasında devre dışı';
$string['experimental'] = 'Deneysel';
$string['experimentalsettings'] = 'Deneysel ayarlar';
$string['extendedusernamechars'] = 'Kullanıcı adlarında extra karakterlere izin ver';
$string['extramemorylimit'] = 'Ektra PHP bellek sınırı';
$string['fatalsessionautostart'] = '<p>Ciddi bir yapılandırma hatası bulundu, lütfen sunucu yöneticisine haber verin.</p><p>Doğru çalışması için Moodle, yöneticinin PHP ayarlarını değiştirmesini gerekli görür.</p><p><code>session.auto_start</code> <code>off</code>\'a ayarlanmalıdır.</p><p> Bu ayar <code>php.ini</code>, sunucudaki Apache/IIS <br/> yapılandırmasını ya da <code>.htaccess</code> dosyasını düzelterek denetlenir.';
$string['favicon'] = 'Site ikonu';
$string['favicon_desc'] = 'Site ikonu, tarayıcı sekmesinde sayfa başlığının yanında görüntülenir. Özel bir site simgesi sağlanmazsa bir Moodle site simgesi görüntülenir.';
$string['feedbacksettings'] = 'Geri bildirim ayarları';
$string['fileconversioncleanuptask'] = 'Dosya dönüştürmeleri için geçici kayıtların temizlenmesi';
$string['filecreated'] = 'Yeni dosya oluşturuldu';
$string['filescleanupperiod'] = 'Çöp kutusu dosyalarını temizleme';
$string['filescleanupperiod_help'] = 'Çöp havuzu dosyalarının ne sıklıkta silindiği. Bunlar artık var olmayan bir bağlamla ilişkilendirilmiş dosyalardır, örneğin bir kurs silindiğinde. Lütfen dikkat: Bu ayar, \'Otomatik yedekleme ayarları\' içindeki \'Dosyaları dahil et\' (backup_auto_files) ayarı devre dışı bırakılırsa, bir kursta yedeklenen, silinen ve geri yüklenen dosyaların eksik olmasına neden olabilir.';
$string['filesizeunits'] = 'Dosya boyut birimleri';
$string['filestoredin'] = 'Dosyayı bu klasöre kaydet:';
$string['filestoredinhelp'] = 'Dosyanın kaydedileceği yer';
$string['filterall'] = 'Tüm ifadeleri filtrele';
$string['filtermatchoneperpage'] = 'Eşleşeni her sayfada bir kez filtrele';
$string['filtermatchonepertext'] = 'Eşleşeni her metinde bir kez filtrele';
$string['filternavigationwithsystemcontext'] = 'Sistem bağlamıyla filtre navigasyonu';
$string['filters'] = 'Filtreler';
$string['filtersettings'] = 'Filtreleri yönet';
$string['filtersettingsgeneral'] = 'Genel filtre ayarları';
$string['filteruploadedfiles'] = 'Gönderilen dosyaları filtrele';
$string['forceclean'] = 'Her yerde içerik temizleme';
$string['forceclean_desc'] = 'Güvenlik tehdidi olabilecek her şeyi kaldırmak için siteye eklenen içerik normalde gösterilmeden önce temizlenir. Ancak içerik, komut dosyalarının, ortamın, satır içi çerçevelerin vb. Eklenmesine izin vermek için etkinlik açıklamaları, sayfa kaynakları veya HTML blokları gibi belirli yerlerde temizlenmez. Bu ayar etkinleştirilirse, TÜM içerik temizlenir. Bu, mevcut içeriğin artık doğru bir şekilde görüntülenmemesine neden olabilir.';
$string['forcelogin'] = 'Kullanıcıları oturum açmaya zorla';
$string['forceloginforprofileimage'] = 'Kullanıcıları, kullanıcı resimlerini görebilmeleri için giriş yapmaya zorla';
$string['forceloginforprofileimage_help'] = 'Etkin olduğunda, kullanıcının kullanıcı resimlerini görebilmek için giriş yapılmış olması gerekir ve tüm bildirim e-postalarında varsayılan kullanıcı resmi kullanılır.';
$string['forceloginforprofiles'] = 'Profiller için kullanıcıları giriş yapmaya zorla';
$string['forcetimezone'] = 'Zaman dilimi seçmeye zorla';
$string['formatuninstallwithcourses'] = '{$a->format} biçimini kullanan {$a->count} kurs var. Biçimleri {$a->defaultformat} olacak (bu site için varsayılan biçim). Bazı biçime özel veriler kaybolabilir. Devam etmek istediğinizden emin misiniz?';
$string['frontpage'] = 'Ana sayfa';
$string['frontpagebackup'] = 'Anasayfa yedeklemesi';
$string['frontpagedefaultrole'] = 'Varsayılan anasayfa rolü';
$string['frontpagefilters'] = 'Anasayfa süzgeçleri';
$string['frontpageloggedin'] = 'Giriş yapıldığında anasayfa ögeleri';
$string['frontpageoverrides'] = 'Anasayfa izinlerinin geçersiz kıl';
$string['frontpagequestions'] = 'Anasayfa soruları';
$string['frontpagerestore'] = 'Anasayfa geri yükleme';
$string['frontpageroles'] = 'Anasayfa rolleri';
$string['frontpagesettings'] = 'Anasayfa ayarları';
$string['fullnamedisplay'] = 'Tam isim formatı';
$string['fullnamedisplayprivate'] = 'Tam ad formatı - özel';
$string['gdrequired'] = 'GD eklentisi görsel dönüştürme için Moodle\'da gereklidir.';
$string['generalsettings'] = 'Genel ayarlar';
$string['geoipfile'] = 'GeoLite2 City MaxMind DB';
$string['getremoteaddrconf'] = 'Kaydı tutulan IP adres kaynağı';
$string['globalsearch'] = 'Genel arama';
$string['globalsearchmanage'] = 'Genel armayı yönet';
$string['googlemapkey3'] = 'Google Maps API V3 anahtarı';
$string['googlemapkey3_help'] = 'IP adresi arama görselleştirmesi için Google Haritaları kullanabilirsiniz Bunun için özel bir anahtar girmeniz gerekir. Anahtarı ücretsiz olarak <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank"> https://developers.google.com/ adresinden edinebilirsiniz. Haritalar / dokümantasyon / javascript / öğretici # api_key </a>';
$string['gotofirst'] = 'İlk eksik ifadeye git';
$string['gradebook'] = 'Not defteri';
$string['gradebookroles'] = 'Not verilen roller';
$string['gradeexport'] = 'Birincil not dışa aktarma yöntemleri';
$string['gravatardefaulturl'] = 'Gravatar varsayılan resim URL\'i';
$string['gravatardefaulturl_help'] = 'Gravatar, belirli bir kullanıcı için resim bulamıyorsa görüntülemek için varsayılan bir resme ihtiyaç duyar. Bir resim için tam bir URL sağlayın. Bu ayarı boş bırakırsanız, Moodle, görüntülediğiniz sayfa için en uygun varsayılan resmi kullanmaya çalışacaktır. Ayrıca, Gravatar\'ın <a href="https://tr.gravatar.com/site/implement/images/#default-image"> varsayılan resimleri oluşturmak için </a> kullanılabilecek bir dizi kodu olduğunu da unutmayın.';
$string['group_customfield'] = 'Grup özel alanları';
$string['groupenrolmentkeypolicy'] = 'Grup kayıt anahtarı politikası';
$string['groupenrolmentkeypolicy_desc'] = 'Etkinleştirilirse, grup kayıt anahtarları yukarıdaki ayarlarda belirtildiği gibi parola politikasına göre kontrol edilecektir.';
$string['grouping_customfield'] = 'Grup özel alanları';
$string['guestroleid'] = 'Konuk için rol';
$string['guestroleid_help'] = 'Bu rol otomatik olarak konuk kullanıcıya atanır. Ayrıca geçici kayıt eklentisi aracılığıyla kursa giren kayıt yaptıran kullanıcılara geçici olarak atanmaz.';
$string['h5pgetcontenttypestask'] = 'Kullanılabilir H5P içerik türlerini h5p.org\'dan indirin';
$string['helpadminseesall'] = 'Site takviminde, yöneticiler tüm kurs takvimlerindeki etkinlikleri mi yoksa yalnızca kayıtlı oldukları kurslardaki etkinlikleri mi görüyor ve filtreliyor mu? Seçilen seçenekten bağımsız olarak, yöneticiler her zaman önce kursa gidip ardından kurs takvimine doğrudan erişerek her kurs takvimi için etkinlikleri yönetebileceklerdir.';
$string['helpcalendarcustomexport'] = 'Takvim dışa aktarmada özel tarih aralığı dışa aktarma seçeneğini etkinleştirin. Bunun etkili olması için takvim verme işlemlerinin etkinleştirilmesi gerekir.';
$string['helpexportlookahead'] = 'Takvim, dışa aktarma işlemi sırasında özel dışa aktarma seçeneği için kaç gün arayacak?';
$string['helpexportlookback'] = 'Takvim, dışa aktarma sırasında, özel dışa aktarma seçeneği için kaç gün geçmişe bakar?';
$string['helpforcetimezone'] = 'Kullanıcıların bireysel olarak zaman dilimlerini seçmelerine izin verebilir ya da herkesin aynı zaman dilimini kullanmasını zorunlu tutabilirsiniz.';
$string['helpshowicalsource'] = 'Etkinse, iCal\'dan içe aktarılan etkinliklerde abone ismi ve bağlantısı görüntülenir.';
$string['helpsitemaintenance'] = 'Sürüm yükseltme ve diğer çalışmalar için';
$string['helpstartofweek'] = 'Takvimde hafta hangi günle başlıyor?';
$string['helpupcominglookahead'] = 'Yaklaşan olaylar için takvimin görünümü ileriye yönelik kaç gün etkileyecek?';
$string['helpupcomingmaxevents'] = 'Varsayılan olarak en fazla kaç tane yaklaşan olay kullanıcılara gösterilecek?';
$string['helpweekenddays'] = 'Hangi günler "Hafta sonu" olarak değerlendirilecek ve farklı bir renkte görünecek?';
$string['hiddenuserfields'] = 'Kullanıcı alanlarını gizle';
$string['hidefromall'] = 'Tüm kullanıcılardan sakla';
$string['hidefromnone'] = 'Hiç kimseden saklama';
$string['hidefromstudents'] = 'Öğrencilerden sakla';
$string['hookcallbacknotcallable'] = 'Bu geri arama çağrılabilir değil. Bunun nedeni sınıf veya yöntemin mevcut olmaması veya yöntemin herkese açık olmaması olabilir.';
$string['hookcallbacks'] = 'Geri arama';
$string['hookcallbacks_help'] = 'Kanca gönderildiğinde çağrılacak geri aramaların listesi.

Gösterilen sıra, geri aramaların çağrılma sırasıdır.

Daha yüksek önceliğe sahip bir geri arama, daha düşük önceliğe sahip bir geri aramadan önce çağrılacaktır.';
$string['hookclassmissing'] = 'Kanca sınıfı bulunamadı';
$string['hookclassmissing_desc'] = 'Kanca bulma aracısı, var olmayan bir sınıf döndürdü.';
$string['hookconfigoverride'] = 'Geçersiz kılındı';
$string['hookconfigoverride_help'] = 'Bu geri aramanın tanımı, site yapılandırma dosyası config.php\'de geçersiz kılındı';
$string['hookdeprecates'] = 'Kullanımdan kaldırılan lib.php geri aramaları';
$string['hookdescription'] = 'Açıklama';
$string['hookdescriptionmissing'] = 'Hook\'un bir açıklama yöntemi yoktur';
$string['hookname'] = 'Kanca';
$string['hooksoverview'] = 'Kancalara genel bakış';
$string['hookunknown'] = 'Kanca bulunamadı';
$string['hookunknown_desc'] = 'Bu geri aramanın dinlediği nesne mevcut değil. Kaldırılmış veya yeniden adlandırılmış olabilir ya da Moodle\'ın bu sürümünde mevcut olmayabilir.';
$string['hostname'] = 'Ana bilgisayar adı';
$string['htmleditor'] = 'HTML düzenleyicisi';
$string['htmleditorsettings'] = 'HTML düzenleyici ayarları';
$string['htmlsettings'] = 'HTML ayarları';
$string['http'] = 'HTTP (Hiper-Metin Transfer Protokolü)';
$string['httpsecurity'] = 'HTTP güvenliği';
$string['iconvrequired'] = 'ICONV PHP eklentisinin kurulması gerekli.';
$string['igbinary322buggyversion'] = 'Sitede yüklü olan php-igbinary uzantısı PHP 7.2 ile çalışırken sorunlara yol açabilir. php-igbinary 3.2.5 veya sonraki bir sürümüne yükseltmeniz veya alternatif olarak PHP 7.3 veya sonraki bir sürümüne yükseltmeniz önerilir.';
$string['ignore'] = 'Yoksay';
$string['includemoduleuserdata'] = 'Eklentinin kullanıcı verisini dahil et';
$string['incompatibleblocks'] = 'Uyumsuz bloklar';
$string['incompleteunicodesupport'] = 'MySQL veya MariaDB\'nin geçerli kurulumu \'utf8\' kullanıyor. Bu karakter kümesi, bazı emoji içeren dört baytlık karakteri desteklemez. Bu karakterleri kullanmaya çalışmak, bir kaydı güncellerken hata ile sonuçlanır ve veritabanına gönderilen bilgiler kaybolur. Lütfen ayarlarınızı \'utf8mb4\' olarak değiştirin. Nasıl yapılacağı hakkında klavuzlara bakabilirsiniz.';
$string['indexdata'] = 'İndekslenmiş veriler';
$string['indexinginfo'] = 'Sitenizin içeriğini dizine eklemenin önerildiği yol, zamanlanmış görevi \'Genel arama dizinini oluşturma\' görevini kullanarak sağlamaktır.';
$string['installhijacked'] = 'Maalesef kurulum orijinal IP adresinden tamamlanmalıdır.';
$string['installsessionerror'] = 'PHP oturumu başlatılamıyor. Lütfen tarayıcınızın çerezleri kabul ettiğini doğrulayın.';
$string['intlrecommended'] = 'Intl uzantısı, yerel ayara göre sıralama gibi uluslararasılaştırma desteğini artırmak için kullanılır.';
$string['intlrequired'] = 'Konuma duyarlı sıralama ve uluslararası alan adları gibi uluslararasılaştırma desteği için intl eklentisi gerekli.';
$string['invalidagedigitalconsent'] = 'Dijital rıza yaşı geçerli değil: {$a}';
$string['invalidforgottenpasswordurl'] = 'Unutulan şifre URL\'si geçerli bir URL değil.';
$string['invalidsection'] = 'Geçersiz bölüm.';
$string['invalidthemepreset'] = 'Seçilen hazır ayar dosyası bu temayla uyumlu değil. SCSS derleme hatası: "{$a}"';
$string['invaliduserchangeme'] = '"changeme" kullanıcı adı rezerve edildiğinden dolayı bu hesabı oluşturamazsınız.';
$string['ipblocked'] = 'Bu siteye şu anda ulaşılamaz.';
$string['ipblocker'] = 'IP engelleyicisi';
$string['ipblockersyntax'] = 'Her girişi bir satıra koyun. Geçerli girişler, tek bir ana bilgisayarla eşleşen tam IP adresidir (örneğin <b>192.168.10.1</b>); veya bu numaralarla başlayan herhangi bir adresle eşleşen kısmi adres (<b>192.168</b> gibi); veya CIDR gösterimi (<b>231.54.211.0/20</b> gibi); veya aralığın adresin son kısmı için geçerli olduğu bir IP adresi aralığı (<b>231.3.56.10-20</b> gibi). Metin alan adları ("example.com" gibi) desteklenmez. Boş satırlar ve "#" karakterinden sonraki metin yok sayılır.';
$string['iplookup'] = 'IP adresi araması';
$string['iplookupgeoplugin'] = '<a href="https://www.geoplugin.com">geoPlugin</a> servisi coğrafik bilgi edinmek için kullanılıyor. Daha isabetli sonuçlar için, MaxMind GeoLite veritabanının yerel bir kopyasını yüklemenizi tavsiye ederiz.';
$string['iplookupinfo'] = 'Ücretsiz çevrimiçi NetGeo sunucusu IP adres konumlarını aramak için kullanılır. Ancak veritabanı artık korunmamaktadır ve yanlış veri döndürebilir. MaxMind\'ın ücretsiz GeoLite2 City veritabanının yerel bir kopyasının yüklenmesi önerilir.<br/>
Bir Google Maps API V3 anahtarı sağlanmışsa, IP adresi konumu Google Maps kullanılarak görüntülenir. Bir Google hesabınızın olması ve Google Maps API anahtarı için başvurmanız gerekir. Google Maps API V3 anahtarı sağlanmazsa IP adresi konumu OpenStreetMap kullanılarak görüntülenir.';
$string['iplookupmaxmindnote'] = 'Bu ürün, <a href="https://www.maxmind.com"> https://www.maxmind.com </a> adresinde bulunan MaxMind tarafından oluşturulan GeoLite2 verilerini içerir.';
$string['iscustomadminwarnings'] = 'Sitenizin özel bir yönetici dizini kullandığı tespit edildi. Bu özellik artık desteklenmemektedir ve Moodle 4.2\'den sonra kaldırılacaktır.';
$string['ishttpswarning'] = 'Sitenizin HTTPS kullanarak güvenli hale getirilmediği belirlendi. Güvenliğin artması ve diğer sistemlerle daha iyi uyum için sitenizi HTTPS adresine dönüştürmeninz önerilir.';
$string['keeptagnamecase'] = 'Etiket adının harf durumunu koru';
$string['lang'] = 'Varsayılan dil';
$string['langcache'] = 'Dil menüsünü önbellekle';
$string['langcache_desc'] = 'Dil menüsünü ön bellekle. Etkinleştirilirse, kullanılabilir çeviriler listesi ön belleğe alınır. Yerleşik dil paketleri yönetim aracı aracılığıyla bir dil paketini yüklediğinizde veya sildiyseniz, önbellek otomatik olarak yenilenir. Yeni bir dil paketi el ile kurarsanız önbellek listesini yenilemek için Tüm ön belleklerini temizle özelliğini kullanmalısınız.';
$string['langlist'] = 'Dil menüsündeki diller';
$string['langmenu'] = 'Dil menüsünü göster';
$string['langmenuinsecurelayout'] = 'Dil menüsünü güvenli düzende görüntüle';
$string['langmenuinsecurelayout_desc'] = 'Etkinleştirilirse, kullanıcı güvenli düzeni kullanarak bir test veya başka bir etkinlik denediğinde dilini değiştirebilir.';
$string['langpackwillbeupdated'] = 'Çevirmenler için not: Sürüm yükseltme sırasında dil paketleriniz güncellenecektir. Kurulumunuzdaki değişiklikler silinecektir. Lütfen yedek alın.';
$string['langstringcache'] = 'Tüm dil dizelerini önbellekle';
$string['languagesettings'] = 'Dil ayarları';
$string['latinexcelexport'] = 'Excel kodlaması';
$string['legacyfilesaddallowed'] = 'Eski kurs dosyalarına eklemeye izin ver';
$string['legacyfilesaddallowed_help'] = 'Bir kurs, eski kurs dosyalarına sahipse, yeni dosya ve klasörlerin eklenmesine izin verin.';
$string['legacyfilesinnewcourses'] = 'Yeni kurslarda eski kurs dosyaları';
$string['legacyfilesinnewcourses_help'] = 'Varsayılan olarak, eski kurs dosyaları alanları yalnızca yeni sürüme geçirilmiş kurslarda kullanılabilir. Etkinlik yedekleme ve geri yükleme gibi bazı özelliklerin bu ayarla uyumlu olmadığını lütfen unutmayın.';
$string['libcurlwarning'] = 'Libcurl\'ın CURLOPT_PROTOCOL desteğine sahip olmadığı tespit edildi. Güvenlik nedeniyle, güncel bir libcurl kurulumu önerilir.';
$string['licensesettings'] = 'Lisans ayarları';
$string['linkadmincategories'] = 'Yönetici kategorileri bağlantısı';
$string['linkadmincategories_help'] = 'Etkinleştirildiğinde, yönetici ayar kategorileri gezinme listesinde bağlantılar olarak görüntülenir ve yönetici kategori sayfalarına yönlendirilir.';
$string['linkcoursesections'] = 'Her zaman kurs bölümlerini bağlayın';
$string['linkcoursesections_help'] = 'Her zaman kurs bölümleri için bir bağlantı sağlamaya çalışın. Kurs bölümleri genelde yalnızca kurs formatında sayfa başına tek bir bölüm gösteriyorsa bağlantılar olarak gösterilir. Bu ayar etkinleştirilirse, bir bağlantı daima sağlanır.';
$string['loading'] = 'Yükleniyor';
$string['localetext'] = 'Site geneli yereli';
$string['localstringcustomization'] = 'Yerel ifade düzenlemesi';
$string['location'] = 'Bölge';
$string['locationsettings'] = 'Bölge ayarları';
$string['locked'] = 'Kilitli';
$string['lockoutduration'] = 'Hesap kilitleme süresi';
$string['lockoutduration_desc'] = 'Kilitli bir hesap bu zaman zarfından sonra otomatik olarak açılır.';
$string['lockoutemailbody'] = '\'{$a->sitename}\' sunucusunda, kullanıcı adı {$a->username} olan hesabınız birden fazla geçersiz oturum açma girişimi sonucu kilitlendi.

Hesabınızı açmak için hemen aşağıdaki adrese gidin

{$a->link}

Birçok mail programında mavi renkli bir bağlantı olarak görünmesi gerekir ve sadece üzerine tıklamanız yeterli olur. İşe yaramıyorsa bağlantıyı kopyala/yapıştır yöntemi ile tarayıcınızın adres çubuğuna girin ve entar tuşuna basın.

Yardıma ihtiyacınız olursa, lütfen site yöneticisi ile temasa geçin,
{$a->admin}';
$string['lockoutemailsubject'] = '{$a} üzerindeki hesabınız kilitlendi.';
$string['lockouterrorunlock'] = 'Hesap açma bilgisi geçersiz.';
$string['lockoutthreshold'] = 'Hesap kilitleme eşiği';
$string['lockoutthreshold_desc'] = 'Hesabın kilitlenmesi için gerekli başarısız oturum açma girişim sayısını  seçin. Bu özellik Dağıtılmış Hizmet Reddi saldırıları istismarına neden olabilir.';
$string['lockoutwindow'] = 'Hesap kilitleme penceresi';
$string['lockoutwindow_desc'] = 'Kilitleme eşiği için gözlem süresi,
Başarısız deneme yoksa eşik sayacı bu süreden sonra sıfırlanır.';
$string['lockrequestcategory'] = 'Kategori seçimini önle';
$string['log'] = 'Kayıtlar';
$string['logguests'] = 'Misafir erişimini günlüğe yaz';
$string['logguests_help'] = 'Bu ayar, oturum açan kullanıcıların değil, konuk hesabıyla işlemlerin günlüğe kaydedilmesini sağlar. Yüksek profilli siteler performans nedenleriyle bu günlük kaydını devre dışı bırakmak isteyebilir. Üretim sitelerinde bu ayarın etkin kılınması önerilir.';
$string['logininfoinsecurelayout'] = 'Giriş yapmış kullanıcıyı güvenli düzende görüntüle';
$string['logininfoinsecurelayout_desc'] = 'Etkinleştirilirse, güvenli mizanpaj kullanarak bir test veya başka bir etkinlik denendiğinde oturum açmış olan kullanıcının tam adı gezinme çubuğunda görüntülenir.';
$string['loginpageautofocus'] = 'Oturum açma sayfası formuna otomatik odaklan';
$string['loginpageautofocus_help'] = 'Bu seçeneğin etkinleştirilmesi, oturum açma sayfasının kullanılabilirliğini geliştirir, ancak otomatik odaklama alanları erişilebilirlik sorunu olarak kabul edilebilir.';
$string['loglifetime'] = 'Kayıtları sakla';
$string['logo'] = 'Logo';
$string['logo_desc'] = 'Bazı temalar (örneğin temel temalar) tarafından dekorasyon olarak kullanılmak üzere tam bir logo. Bu görüntü oldukça yüksek çözünürlüklü olabilir çünkü kullanım için küçültülür (ve performans için ön belleğe alınır). Yüksekten daha geniş logolar genellikle daha iyi sonuçlar verir.';
$string['logocompact'] = 'Küçük logo';
$string['logocompact_desc'] = 'Amblemi, ekranı veya simgesi gibi, yukarıdaki ile aynı logoyu içeren küçük bir versiyonu. Görüntü küçük boyutlarda bile net olmalıdır.';
$string['logossettings'] = 'Logolar';
$string['logstorenotrequired'] = 'Giriş deposu gerekli değildir';
$string['logstoressupported'] = 'Bu raporu destekleyen günlük dopoları';
$string['longtimewarning'] = '<b>Lütfen bu işlemin uzun sürebileceğini dikkate alın.</b>';
$string['mailnewline'] = 'Maildeki yenisatır karakterleri';
$string['maintenancemode'] = 'Bakım modunda';
$string['maintenancemodeisscheduled'] = 'Bu site {$a->min} dakika {$a->sec} saniye sonra bakım durumuna geçecek.';
$string['maintenancemodeisscheduledlong'] = 'Bu site, {$a->hour}saat {$a->min} dakika {$a->sec} saniye içinde bakım moduna geçirilecektir.';
$string['maintfileopenerror'] = 'Bakım dosyalarını açarken hata!';
$string['maintinprogress'] = 'Bakım işlemde...';
$string['managecontextlock'] = 'Bu bağlamı dondur';
$string['managecontextlocklocked'] = '{$a->contextname} ve daha düşük içerikler artık dondurulmuştur.';
$string['managecontextlockunlocked'] = '{$a->contextname} ve daha düşük içerikler artık çözülmemiştir.';
$string['managecontextunlock'] = 'Bu içeriği çöz';
$string['managecustomfields'] = 'Özel alan türlerini yönetme';
$string['manageformats'] = 'Kurs biçimlerini yönet';
$string['manageformatsgotosettings'] = '{$a} daki geçerli biçim değiştirilebilir';
$string['managelang'] = 'Yönet';
$string['manageqbanks'] = 'Soru bankası eklentilerini yönet';
$string['manageqbehaviours'] = 'Soru davranışlarını yönet';
$string['manageqtypes'] = 'Soru tiplerini yönet';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Yayımlanmaya aday sürüm';
$string['maturity200'] = 'Kararlı sürüm';
$string['maturity50'] = 'Alfa';
$string['maturityallowunstable'] = 'İpucu: Bu betiği --allow-unstable seçeneği ile çalıştırmak isteyebilirsiniz';
$string['maturitycoreinfo'] = 'Siteniz şu anda kararlı olmayan "{$a}" geliştirici kodunu çalıştırmaktadır.';
$string['maturitycorewarning'] = 'Yüklemek veya yükseltmek üzere olduğunuz Moodle sürümü, kararlı olmayan "{$a}" geliştirici kodları içermektedir ve kullanımda olan siteler için önerilmemektedir. Niyetiniz bu değildiyse, Moodle\'ın kararlı sürüm kodlarından birini kullanarak güncelleme yaptığınızdan emin olun. Dada fazla bilgi için Moodle Belgeler sayfasına bakın.';
$string['maxbytes'] = 'En fazla dosya yükleme boyutu';
$string['maxconsecutiveidentchars'] = 'Ardışık aynı karakterler';
$string['maxeditingtime'] = 'Mesajları düzenlemek için en fazla süre';
$string['maxsizeperdownloadcoursefile'] = 'Dosya başına maksimum boyut';
$string['maxsizeperdownloadcoursefile_desc'] = 'Kurs içeriğini indirirken her dosyanın maksimum boyutu. Bu boyutu aşan dosyalar indirmeden çıkarılacaktır.';
$string['maxtimelimit'] = 'Maksimum zaman sınırı';
$string['maxtimelimit_desc'] = 'Moodle\'ın gösterilen herhangi bir çıktı olmadan izin verecek en yüksek PHP yürütme süresini sınırlandırmak için, saniye cinsinden bir değer girin. 0, Moodle varsayılan kısıtlamaları kullanıldığı anlamına gelir. Kendi zaman sınırı olan bir ön uç sunucunuz varsa, günlüklerdeki PHP hatalarını almak için bu değeri daha düşük olarak ayarlayın. CLI komut dosyaları için geçerli değildir.';
$string['maxusersperpage'] = 'Sayfa başına en fazla kullanıcı';
$string['mbstringrecommended'] = 'Sitenizde latin olmayan dilleri kullanıyorsanız, isteğe bağlı MBSTRING kütüphanesinin kurulması site performansını arttırmak için şiddetle tavsiye edilir.';
$string['mbstringrequired'] = 'Özellikle siteniz Latin olmayan dilleri destekliyorsa, site performansını artırmak için MBSTRING kitaplığını yüklemeniz gerekir.';
$string['mediapluginavi'] = '.AVI filtresini etkinleştir';
$string['mediapluginflv'] = '.FLV filtresini etkinleştir';
$string['mediapluginimg'] = 'Bağlantı verilmiş resimleri sayfa içinde göstermeyi etkinleştir';
$string['mediapluginmov'] = '.MOV filtresini etkinleştir';
$string['mediapluginmp3'] = '.MP3 filtresini etkinleştir';
$string['mediapluginmpg'] = '.MPG filtresini etkinleştir';
$string['mediapluginogg'] = '.ogg filresini etkinleştir';
$string['mediapluginogv'] = '.ogv filresini etkinleştir';
$string['mediapluginram'] = '.RAM filtresini etkinleştir';
$string['mediapluginrm'] = '.RM filtresini etkinleştir';
$string['mediapluginrpm'] = '.RPM filtresini etkinleştir';
$string['mediapluginswf'] = '.SWF filtresini etkinleştir';
$string['mediapluginswfnote'] = 'Varsayılan bir güvenlik önlemi olarak, normal kullanıcıların swf flash dosyalarını yerleştirmesine izin verilmemelidir.';
$string['mediapluginwmv'] = '.WMV filtresini etkinleştir';
$string['mediapluginyoutube'] = 'YouTube bağlantıları filtresini etkinleştir';
$string['messaging'] = 'Mesajlaşmayı etkinleştir';
$string['messagingallowemailoverride'] = 'Bildirim e-postası geçersiz kılma';
$string['messagingallusers'] = 'Site genelinde mesajlaşmaya izin ver';
$string['messagingcategory'] = 'Mesajlaşma';
$string['messagingdefaultpressenter'] = 'Varsayılan olarak etkin göndermek için enter tuşunu kullanın';
$string['messagingdeleteallnotificationsdelay'] = 'Tüm bildirimleri sil';
$string['messagingdeletereadnotificationsdelay'] = 'Okundu bildirimlerini sil';
$string['messagingssettings'] = 'Mesajlaşma ayarları';
$string['minpassworddigits'] = 'Rakamlar';
$string['minpasswordlength'] = 'Şifre uzunluğu';
$string['minpasswordlower'] = 'Küçük harfler';
$string['minpasswordnonalphanum'] = 'Alfanümerik olmayan karakterler';
$string['minpasswordupper'] = 'Büyük harfler';
$string['misc'] = 'Çeşitli';
$string['mlbackendsettings'] = 'Makine öğrenimi arka uç ayarları';
$string['mnetrestore_extusers'] = '<strong>Not:</strong> Bu yedekleme dosyası, işlemin bir parçası olarak geri yüklenen Uzak Moodle Ağı Kullanıcı Hesaplarını içerir.';
$string['mnetrestore_extusers_admin'] = '<strong>Not:</strong> Bu yedekleme dosyası farklı bir Moodle kurulumundan gelmiş gibi gözüküyor ve uzak Moodle Ağı kullanıcı hesaplarını içeriyor. Geri yükleme süreci Moodle Ağı sunucularını tüm oluşturulmuş kullanıcılarla eşleştirmeye çalışacaktır. Eşleşmeyenler otomatik olarak iç kimlik denetimine açılacaktır (mnet yerine). Geri yükleme girişi sizi bu konuda bilgilendirecektir.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Not:</strong> Görünen o ki, bu yedekleme dosyası farklı bir Moodle kurulumundan geliyor ve geri yüklemede başarısız olabilecek uzak Moodle Ağı kullanıcı hesapları içeriyor. Bu işlem desteklenmez. Bu Moodle kurulumunda oluşturulduğundan eminseniz, ya da gerekli tüm Moodle Ağ Sunucularının yapılandırıldığını garanti edebiliyorsanız, geri yükleme yapmak isteyebilirsiniz.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Not:</strong> Bu yedekleme dosyası farklı bir Moodle kurulumundan geliyor gibi görünüyor ve uzak Moodle Ağı kullanıcı hesaplarını içeriyor. Bu tür bir geri yükleme yapmanıza izin verilmez. Sitenin yöneticisiyle iletişime geçin veya alternatif olarak bu kursu herhangi bir kullanıcı bilgisi (modüller, dosyalar...) olmadan geri yükleyin.';
$string['mnetrestore_extusers_switchuserauth'] = 'Uzak Moodle Ağı kullanıcısı {$a->username} ({$a->mnethosturl}\'den gelen) yerel {$a->auth} yetkili kullanıcıyla değiştirilmiştir.';
$string['mobilenotconfiguredwarning'] = 'Moodle uygulaması etkinleştirilmemiştir.';
$string['modassignmentinuse'] = 'Siteniz hala Assignment 2.2 eklentisini kullanıyor. Yükseltmeden önce, 1) saklamak istediğiniz tüm Atama 2.2 etkinliklerini yedeklemeli ve bunları Atama etkinlikleri olarak geri yüklemelisiniz ve 2) tüm Atama 2.2 verilerini veritabanından silmelisiniz.';
$string['modassignmentsubpluginsexist'] = 'Ödev 2.2.  alt eklentiler mevcut olabilir.  Yükseltmeden önce mod/atama klasörü ve tüm alt eklentilerinin kaldırılması gerekir.';
$string['modeditdefaults'] = 'Etkinlik ayarları için varsayılan değerler';
$string['modsettings'] = 'Etkinlikleri yönet';
$string['modulesecurity'] = 'Eklenti güvenliği';
$string['moodleapp'] = 'Moodle uygulaması';
$string['moodleapp_help'] = '<p>Ücretsiz Moodle uygulaması kullanıcıların kurslarına mobil cihazlardan erişmelerini sağlar. Pro veya Premium uygulama planıyla ek uygulama özellikleri kullanılabilir.</p>
<a href="https://moodle.com/mobile-app">Moodle uygulamasını edinin</a> <br/>
<a href="https://apps.moodle.com">Moodle Uygulama Portalı</a>';
$string['moodlebrandedapp'] = 'Markalı Moodle uygulaması';
$string['moodlebrandedapp_help'] = '<p>Markalı Moodle uygulaması, kendi özel markanızla birlikte Moodle için ücretsiz mobil uygulamamızın tüm işlevlerine sahiptir.</p>
<a href="https://moodle.com/branded-app">Markalı Moodle uygulaması hakkında</a>';
$string['moodlebrandedappreference'] = 'Alternatif olarak, kendi özel markanızla bir <a href="https://moodle.com/branded-app/">Markalı Moodle uygulaması</a> edinin.';
$string['moodlepartners'] = 'Moodle Ortakları';
$string['moodlepartners_help'] = '<p>Moodle İş Ortakları, kuruluşunuzun çevrimiçi öğrenme ortamına yüksek kaliteli Moodle hizmetleri sağlamak için Moodle Genel Merkezi tarafından onaylanmış hizmet sağlayıcılardır.</p>
<a href="https://moodle.com/about-partners/">Ortaklarımız Hakkında</a><br/>
<a href="https://moodle.com/partners">Bir İş Ortağı Bulun</a>';
$string['moodleservices'] = 'Moodle hizmetleri';
$string['moodleservices_help'] = 'Aşağıdaki Moodle hizmetlerini kullanarak Moodle öğrenme ortamınızdan en iyi şekilde yararlandığınızdan emin olun:';
$string['multilangforceold'] = 'Eski çokludil yazımını kullan: <span> class="multilang" ve <lang> olmaksızın';
$string['mustenablestats'] = 'Bu sitede istatistikler etkinleştirilmemiştir.';
$string['mycourses'] = 'Kurslarım';
$string['mycoursesperpage'] = 'Kurs sayısı';
$string['mydashboard'] = 'Varsayılan sistem paneli';
$string['mymoodle'] = 'Kontrol paneli';
$string['mymoodleredirect'] = 'Kullanıcıları Kişisel Moodle kullanmaya zorla';
$string['mypage'] = 'Varsayılan Kontrol Paneli sayfası';
$string['mypagelocked'] = 'Öntanımlı sayfayı sabitle';
$string['myprofile'] = 'Varsayılan profil sayfası';
$string['navadduserpostslinks'] = 'Kullanıcı mesajlarını görmek için bağlantı ekle';
$string['navadduserpostslinks_help'] = 'Etkinleştirilirse, kullanıcının başlattığı tartışmaları ve site genelindeki forumlarda veya belirli kurslarda yaptığı gönderileri görüntülemek için navigasyondaki her kullanıcıya iki bağlantı eklenecektir.';
$string['navcourselimit'] = 'Kurs sınırı';
$string['navigationupgrade'] = 'Bu yükseltme, bu blokların yerini alacak iki yeni gezinti bloğu tanıtıyor: Yönetim, Kurslar, Etkinlikler ve Katılımcılar. Bu bloklar üzerinde herhangi bir özel izin ayarladıysanız, her şeyin istediğiniz gibi davrandığından emin olmak için kontrol etmelisiniz.';
$string['navshowallcourses'] = 'Tüm kursları göster';
$string['navshowcategories'] = 'Kurs kategorilerini göster';
$string['navshowfrontpagemods'] = 'Gezinme bloğunda anasayfa etkinliklerini göster';
$string['navshowfrontpagemods_help'] = 'Etkinse, anasayfa etkinlikleri, site sayfalarının altındaki Gezinme bloğunda görüntülenir.';
$string['navshowfullcoursenames'] = 'Kursun tam adını göster';
$string['navshowfullcoursenames_help'] = 'Etkinleştirilirse, kısa adlar yerine ders tam adları navigasyonda kullanılacaktır.';
$string['navshowmycoursecategories'] = 'Kurs kategorilerimi göster';
$string['navshowmycoursecategories_help'] = 'Etkinleştirilirse, kullanıcının Kurslarım dalındaki kurslar, gezinme bloğundaki kategorilerde gösterilecektir (yalnızca Klasik tabanlı temalar).';
$string['navsortmycourseshiddenlast'] = 'Gizli kurslarımı en son sırala';
$string['navsortmycourseshiddenlast_help'] = 'Etkinleştirilirse, gizli kurslar görünür kurslardan sonra listelenir (gizli kursları görüntüleyebilen kullanıcılar için). Aksi takdirde, görünürlüklerine bakılmaksızın tüm kurslar \'Kurslarımı sırala\' ayarına göre listelenecektir.';
$string['navsortmycoursessort'] = 'Gezinti bloğundaki kursların sırası';
$string['navsortmycoursessort_help'] = 'Kurslar, Site yönetimi > Kurslar > Kursları ve kategorileri yönet bölümünde ayarlanan sıralama düzeninde mi yoksa kurs ayarına göre alfabetik olarak mı listelenmelidir? Bu ayar yalnızca Klasik tabanlı temalar için geçerlidir.';
$string['never'] = 'Asla';
$string['neverdeleteruns'] = 'Çalışırken silinemez';
$string['newestdocindexed'] = 'Dizine eklenen en yeni belge';
$string['nobookmarksforuser'] = 'Hiç yer imi yok.';
$string['nodatabase'] = 'Veritabanı yok';
$string['noemaileverwarning'] = '<strong>Not:</strong> Tüm giden e-postalar devre dışı bırakıldı';
$string['nohttpsformobilewarning'] = 'HTTPS güvenlik sertifikasını etkinleştirmeniz önerilir. Moodle uygulamaları her zaman öncelikli olarak güvenli bağlantı kurmaya çalışacaklardır.';
$string['nomissingstrings'] = 'Eksik ifade yok';
$string['none'] = 'Hiçbiri';
$string['nonewsettings'] = 'Bu güncelleme sırasında yeni bir ayar eklenmedi.';
$string['nonexistentbookmark'] = 'İstediğiniz yer imi yok.';
$string['noreplyaddress'] = 'Yanıtlamayan adres';
$string['noreplydomain'] = 'Yanıt yok ve alan adı';
$string['noreplydomaindetail'] = 'Cevapsız ve yapılandırılmış alanlar için ayarlar';
$string['noresults'] = 'Sonuç bulunamadı.';
$string['noroles'] = 'Roller yok';
$string['nosupportedlogstore'] = 'Desteklenen herhangi bir logstore bulunamadı';
$string['noteunneededblocks'] = 'Not: Gösterilecek şekilde ayarlanan bloklar, \'Gereksiz bloklar\' tema ayarında belirtilmişlerse, bir derste \'Blok ekle\' menüsünde listelenmeyecektir.';
$string['notifications'] = 'Bildirimler';
$string['notifyloginfailures'] = 'Giriş hatalarını e-posta ile gönder';
$string['notifyloginthreshold'] = 'Email bildirimleri için aralık';
$string['notloggedinroleid'] = 'Konuklar için rol';
$string['numberofmissingstrings'] = 'Eksik ifade sayısı: {$a}';
$string['numberofstrings'] = 'Toplam ifade sayısı: {$a->strings}<br/>Eksik: {$a->missing} (%&nbsp;{$a->missingpercent})';
$string['oauthrefreshtokenexpired'] = 'Sitenizde {$a->siteurl} OAuth hizmetlerinden biri için tazeleme anahtarının {$a->issuer} süresi doldu. Bu da bu hizmeti kullanan eklentilerden herhangi birinin işlevselliğini sınırlandırabilir. Sorunu çözmek için OAuth 2 Hizmetleri ayar sayfasına gidin ve bu hizmetin sırasındaki "Sistem hesabına başlan" simgesini tıklayın. Her bir seferinde OAuth sistemi için aynı hizme hesabıyla giriş yapmayı unutmayın.';
$string['oauthrefreshtokenexpiredshort'] = 'Sitenizde {$a->siteurl} OAuth tazeleme anahtarı  {$a->issuer} için sona erdi.';
$string['onlynoreply'] = 'Yalnızca bir yanıtlamayın türü adresten geldiğinde';
$string['opcacherecommended'] = 'PHP opcode önbellekleme performansı artırır ve bellek gereksinimlerini düşürür, OPcache uzantısı önerilir ve tamamen desteklenir.';
$string['opensslrecommended'] = 'OpenSSL kütüphanesinin kurulması şiddetle tavsiye edilir. Bu, Moodle Ağının işlevsel çalışmasını mümkün kılar.';
$string['opensslrequired'] = 'Moodle için daha sağlam kriptolama hizmeti sağlamak amacıyla OpenSSL PHP eklentisi artık zorunlu.';
$string['opentowebcrawlers'] = 'Google\'a aç';
$string['optionalmaintenancemessage'] = 'İsteğe bağlı Bakım mesajı';
$string['oracledatabaseinuse'] = 'Moodle Oracle DB desteğini kaldırılacak.  Moodle sürüm 4.5, Oracle\'ı veritabanını destekleyen son sürüm olacaktır.  Daha fazla bilgiyi <a href="https://moodle.org/mod/forum/discuss.php?d=456122" target="_blank">ÖYS\'de Oracle veritabanı desteği kullanımdan kaldırılıyor</a> bulabilirsiniz.';
$string['order1'] = 'İlk';
$string['order2'] = 'İkinci';
$string['order3'] = 'Üçüncü';
$string['order4'] = 'Dört';
$string['outgoingmailconfig'] = 'Giden posta yapılandırması';
$string['overridetossl'] = 'Oturum açma işlemleri için HTTPS artık önerilmiyor. Bu örnek şimdi SSL\'ye zorlandı. Bu uyarıyı gidermek için config.php dosyasındaki wwwroot\'unuzu https:// olarak değiştirin.';
$string['pageinfodebugsummary'] = 'Bu sayfa: {$a}';
$string['passwordchangelogout'] = 'Parola değiştiğinde oturumu kapat';
$string['passwordchangelogout_desc'] = 'Etkinleştirilirse, bir parola değiştirildiğinde, tüm tarayıcı oturumları, yeni parolanın belirtildiği oturumdan ayrı olarak sonlandırılır. (Bu ayar, toplu kullanıcı yüklemesi yoluyla şifre değişikliklerini etkilemez.)';
$string['passwordchangetokendeletion'] = 'Parola değişikliğinden sonra web hizmeti erişim belirteçlerini kaldırma';
$string['passwordchangetokendeletion_desc'] = 'Etkinleştirilirse, bir parola değiştirildiğinde tüm kullanıcı web hizmeti erişim belirteçleri silinir.';
$string['passwordpolicy'] = 'Şifre ilkesi';
$string['passwordpolicycheckonlogin'] = 'Girişte şifreyi kontrol et';
$string['passwordresettime'] = 'Şifre sıfırlama isteğinin onaylanması gereken süre';
$string['passwordreuselimit'] = 'Şifre çevirme sınırı';
$string['passwordreuselimit_desc'] = 'Bir kullanıcının bir şifreyi tekrar kullanmalarına izin verilmeden önce şifrelerini değiştirme sayısı. Daha önce kullanılan parolaların hash\'leri yerel veritabanı tablosunda saklanır. Bu özellik, bazı harici kimlik doğrulama eklentileri ile uyumlu olmayabilir.';
$string['pathtodot'] = 'Dağıtım yolu';
$string['pathtodot_help'] = 'Noktaya giden yol. Linux\'ta /usr/bin/dot gibi bir şeydir. Windows\'ta C:\\Program Files (x86)\\ Graphviz2.38\\bin\\dot.exe gibi bir şeydir. Mac\'te /opt/local/bin/dot gibi bir şeydir. DOT dosyalarından grafik oluşturabilmek için nokta yürütülebilir dosyayı kurmanız ve buraya işaret etmeniz gerekir.';
$string['pathtodu'] = 'Du yolu';
$string['pathtogs'] = 'Ghostscript için yol';
$string['pathtogs_help'] = 'Çoğu Linux kurulumunda bu, \'/ usr / bin / gs\' olarak bırakılabilir. Windows\'da \'c:\\gsbingswin32c.exe\' gibi bir şey olacaktır (yolda boşluk olmadığından emin olun - gerekirse \'gswin32c.exe\' ve \'gsdll32.dll\' dosyalarını yolda boşluk bırakmadan yeni bir klasöre kopyalayın)';
$string['pathtopdftoppm'] = 'Pdftoppm yolu';
$string['pathtopdftoppm_help'] = '\'pdftoppm\', PDF sayfalarını PNG\'ye en az \'gs\' kadar hızlı dönüştüren bir araçtır. Ancak, büyük belgeleri dönüştürürken muhtemelen daha iyi bir performansa sahip olacaksınız. Varsa, bu görev için "gs" yerine "pdftoppm" kullanılacaktır. Çoğu Linux kurulumunda, bu \'/ usr / bin / pdftoppm\' olarak bırakılabilir. Mevcut değilse, Linux dağıtımına bağlı olarak poppler-utils veya poppler paketini kurun. Windows\'ta Cygwin kurulumları tarafından sağlanacaktır. Daha fazla ayrıntı için <a href="https://poppler.freedesktop.org/" target="_blank"> Poppler projesine </a> bakın.';
$string['pathtopgdump'] = 'pg_dump yolu';
$string['pathtopgdumpdesc'] = 'Bu, sadece sisteminizde birden fazla pg_dump varsa gereklidir (örneğin birden fazla postgresql sürümü kurduysanız)';
$string['pathtopgdumpinvalid'] = 'Geçersiz pg_dump yolu. Ya yol yanlış ya da dosya çalıştırılabilir değil';
$string['pathtophp'] = 'PHP CLI yolu';
$string['pathtopsql'] = 'psql yolu';
$string['pathtopsqldesc'] = 'Bu, sadece sisteminizde birden fazla psql varsa gereklidir (örneğin birden fazla postgresql sürümü kurduysanız)';
$string['pathtopsqlinvalid'] = 'Geçersiz psql yolu. Ya yol yanlış ya da dosya çalıştırılabilir değil';
$string['pathtopython'] = 'Python yolu';
$string['pathtopythondesc'] = 'Python yorumlayıcısının dosya yolu (Python 2 veya Python 3).';
$string['pathtosassc'] = 'SassC yolu';
$string['pathtosassc_help'] = 'SassC ikili dosyasının konumunu belirtmek, SASS derleyicisini Moodle PHP uygulamasından SassC\'ye geçirecektir. Daha fazla bilgi için https://github.com/sass/sassc adresine bakın.';
$string['pcreunicodewarning'] = 'Unicode karakterler ile uyumlu  PCRE PHP uzantıları kullanmanız şiddetle tavsiye edilir.';
$string['perfdebug'] = 'Performans bilgisi';
$string['perfdebugdeferred'] = 'Performans hata ayıklamasını göstermek için betiğin bitmesi bekleniyor...';
$string['performance'] = 'Performans';
$string['pgcluster'] = 'PostgreSQL Cluster';
$string['pgclusterdescription'] = 'Komut satırı işlemleri için PostgreSQL sürüm/küme parametresi. Sisteminizde birden fazla postgresql varsa veya ne yaptığınızı bilmiyorsanız bunu boş bırakın.';
$string['phpfloatproblem'] = 'PHP ondalıklı sayılarının işletilmesinde beklenmeyen problem algılandı';
$string['pid'] = 'PID';
$string['pleaserefreshregistration'] = 'Siteniz kayıtlı. En son kayıt güncelleme {$a}.<br/>\'Site kaydı\' ayarlanmış görevi kaydı güncel tutar. Ayrıca istediğiniz zaman kendiniz de  kaydınızı güncelleyebilirsiniz.';
$string['pleaserefreshregistrationnewdata'] = 'Kayıt bilgileri değiştirildi. Lütfen \'Kaydı güncelleyin\' düğmesini kullanarak onaylayın.';
$string['pleaserefreshregistrationunknown'] = 'Siteniz kaydedildi, ancak kayıt tarihi bilinmiyor. Lütfen kaydınızı \'Kayıt güncelleme\' düğmesini kullanarak güncelleyin veya kaydınızı otomatik olarak güncellemek için \'Site kaydı\' zamanlanmış görevin etkinleştirildiğinden emin olun.';
$string['plugin'] = 'Eklenti';
$string['plugin_disabled'] = '{$a} devre dışı bırakıldı';
$string['plugin_enabled'] = '{$a} etkinleştirildi';
$string['plugins'] = 'Eklentiler';
$string['pluginscheck'] = 'Eklenti bağımlılıkları kontrolü';
$string['pluginscheckfailed'] = '{$a->pluginslist} için eklenti bağımlılıkları kontrolü başarsız oldu';
$string['pluginschecktodo'] = 'Bu Moodle sürümünü yükleme işlemine geçmeden önce tüm eklenti ihtiyaçlarını çözmeniz gerekir!';
$string['pluginsoverview'] = 'Eklentilere genel bakış';
$string['pluginsoverviewsee'] = 'Daha fazla bilgi için <a href="{$a->url}">eklentilere genel bakış</a>';
$string['policysettings'] = 'Politika ayarları';
$string['privacy:metadata'] = 'Yönetim eklentisi herhangi bir kişisel veri depolamaz.';
$string['privacyandpolicies'] = 'Gizlilik ve politikalar';
$string['privacysettings'] = 'Gizlilik ayarları';
$string['profilecategory'] = 'Kategori';
$string['profilecategoryname'] = 'Kategori adı (benzersiz olmalı)';
$string['profilecategorynamenotunique'] = 'Bu kategori adı zaten kullanımda';
$string['profilecommonsettings'] = 'Genel ayarlar';
$string['profileconfirmcategorydeletion'] = 'Bu kategoride, yukarıdaki kategoriye (veya üst kategori ise aşağıdakine) taşınacak {$a} alan var.<br/>Hala bu kategoriyi silmek istiyor musunuz?';
$string['profileconfirmfielddeletion'] = 'Bu alan için silinecek {$a} kullanıcı kaydı var. <br/>Bu alanı silmeyi hala istiyor musunuz?';
$string['profilecreatecategory'] = 'Yeni bir profil kategorisi oluştur';
$string['profilecreatefield'] = 'Yeni bir profil alanı oluştur';
$string['profilecreatenewcategory'] = 'Yeni bir kategori oluşturuluyor';
$string['profilecreatenewfield'] = 'Yeni bir \'{$a}\' profil alanı oluşturuluyor';
$string['profiledefaultcategory'] = 'Diğer alanlar';
$string['profiledefaultchecked'] = 'Varsayılan olarak seçili';
$string['profiledefaultdata'] = 'İlk değer';
$string['profiledeletecategory'] = 'Kategori siliniyor';
$string['profiledeletefield'] = '\'{$a}\' alanı siliniyor';
$string['profiledescription'] = 'Alan açıklaması';
$string['profiledscript'] = 'Komut oluşturuldu';
$string['profiledscriptview'] = 'Bu komut için başarım profili bilgilerini görüntüleyin';
$string['profileeditcategory'] = 'Kategori düzenleniyor: {$a}';
$string['profileeditfield'] = 'Profil alanı düzenleniyor: {$a}';
$string['profilefield'] = 'Profil alanı';
$string['profilefieldcolumns'] = 'Sütunlar';
$string['profilefieldispassword'] = 'Bu bir şifre alanı mı?';
$string['profilefieldlink'] = 'Bağlantı';
$string['profilefieldlink_help'] = 'Metni bir bağlantıya dönüştürmek için $$ içeren bir URL girin; burada $$ metinle değiştirilecektir. Örneğin, bir Twitter kimliğini bir bağlantıya dönüştürmek için https://twitter.com/$$ girin.';
$string['profilefieldlinktarget'] = 'Bağlantı hedefi';
$string['profilefieldmaxlength'] = 'Karakter sınırı';
$string['profilefieldmaxlength_help'] = 'Bu alanı \'Kullanıcı kimliğini göster\' ayarında kullanmak için sınır 255 karakter veya daha az olmalıdır.';
$string['profilefieldrows'] = 'Satırlar';
$string['profilefields'] = 'Kullanıcı profil alanları';
$string['profilefieldsize'] = 'Görünüm boyutu';
$string['profileforceunique'] = 'Veri benzersiz mi?';
$string['profileinvaliddata'] = 'Geçersiz değer';
$string['profilelocked'] = 'Bu alan kilitlensin mi?';
$string['profilemenudefaultnotinoptions'] = 'İlk değer seçeneklerden biri değil';
$string['profilemenunooptions'] = 'Menü seçenekleri verilmedi';
$string['profilemenuoptions'] = 'Menü seçenekleri (satır satır)';
$string['profilemenutoofewoptions'] = 'En az 2 seçenek vermelisiniz';
$string['profilename'] = 'İsim';
$string['profilenofieldsdefined'] = 'Hiçbir alan tanımlanmadı';
$string['profilerequired'] = 'Bu alan gerekli mi?';
$string['profileroles'] = 'Profil görünür rolleri';
$string['profilesforenrolledusersonly'] = 'Yalnızca kayıtlı kullanıcılar için profiller';
$string['profileshortname'] = 'Kısa ad (benzersiz olmalı)';
$string['profileshortnameinvalid'] = 'Bu kısa ad yalnızca alfasayısal karakterler (harfler ve sayılar) veya alt çizgi (_) içerebilir.';
$string['profileshortnamenotunique'] = 'Bu kısa ad zaten kullanımda';
$string['profilesignup'] = 'Kayıt sayfasında gösterilsin mi?';
$string['profilespecificsettings'] = 'Özel ayarlar';
$string['profilevisible'] = 'Bu alan kimlere görünür?';
$string['profilevisible_help'] = '* Görünmez - Yalnızca yöneticiler tarafından görüntülenebilir özel veriler içindir
* Kullanıcı tarafından görülebilir - Yalnızca kullanıcı ve yöneticiler tarafından görüntülenebilir özel veriler için
* Kullanıcı, öğretmenler ve yöneticiler tarafından görülebilir - Yalnızca kullanıcı, yöneticiler ve öğretmenler tarafından görüntülenebilir özel veriler için (ders profili)
* Herkese görünür';
$string['profilevisibleall'] = 'Herkese görünür';
$string['profilevisiblenone'] = 'Görünmez';
$string['profilevisibleprivate'] = 'Kullanıcıya görünür';
$string['profilevisibleteachers'] = 'Kullanıcı, öğretmenler ve yöneticiler tarafından görülebilir';
$string['profiling'] = 'Başarım profilleme';
$string['profilingallowall'] = 'Başarım profillemeye devam ediliyor';
$string['profilingallowall_help'] = 'Bu ayarı etkinleştirirseniz, Moodle oturum süresi boyunca tüm yürütülen komut dosyaları için profil oluşturmayı etkinleştirmek için herhangi bir anda PROFILEALL parametresini (PGC) kullanabilirsiniz. Benzer şekilde, durdurmak için PROFILEALLSTOP parametresini kullanabilirsiniz.';
$string['profilingallowme'] = 'Seçici başarım profilleme';
$string['profilingallowme_help'] = 'Bu ayarı etkinleştirirseniz, seçici olarak PROFILEME parametresini her yerde (PGC) kullanabilirsiniz ve bu komut dosyası için profil oluşturma gerçekleşir. Benzer şekilde, profil oluşmasını önlemek için DONTPROFILEME parametresini kullanabilirsiniz.';
$string['profilingautofrec'] = 'Otomatik başarım profilleme';
$string['profilingautofrec_help'] = 'Bu ayarı yapılandırarak, daha fazla analiz için sonuçları depolayan bazı istek (rasgele olarak, belirtilen frekansa göre - N\'nin 1\'i) seçilecek ve otomatik profil oluşturulacaktır. Bu şekilde profillemenin, include / exclude ayarlarını gözlemlediğini unutmayın. Otomatik profillemeyi devre dışı bırakmak için 0 değerine ayarlayın.';
$string['profilingenabled'] = 'Başarım profillemeyi etkinleştir';
$string['profilingenabled_help'] = 'Bu ayarı etkinleştirirseniz, profil oluşturma bu sitede sunulacak ve bir sonraki seçenekleri yapılandırarak davranışını tanımlayabileceksiniz.';
$string['profilingexcluded'] = 'Başarım profillemeyi çıkar';
$string['profilingexcluded_help'] = '\'Profiline göre\' ayarı tarafından tanımlananlardan hariç tutulacak (virgülle ayrılmış, mutlak atlama wwwroot, çağrılabilir) URL\'lerin listesi.';
$string['profilingimportprefix'] = 'Başarım profili içeri aktarma öneki';
$string['profilingimportprefix_desc'] = '';
$string['profilingincluded'] = 'Bu profil';
$string['profilingincluded_help'] = 'Otomatik olarak profillenecek (virgülle ayrılmış, mutlak atlama wwwroot, çağrılabilir) URL\'lerin listesi. Örnekler: /index.php, /course/view.php. Ayrıca herhangi bir konumda * wildchar kabul eder. Örnekler: / mod / forum / *, /mod/*/view.php.';
$string['profilinglifetime'] = 'Başarım profillemeyi çalışır durumda tut';
$string['profilinglifetime_help'] = 'Eski profil oluşturma işlemleri hakkında bilgi tutmak istediğiniz zamanı belirtin. Büyük olanlar periyodik olarak budama yapılacaktır. Bunun, \'referans yürütme\' olarak işaretlenmiş herhangi bir profil çalışması hariç tutulduğunu unutmayın.';
$string['profilingslow'] = 'Yavaş profil sayfaları';
$string['profilingslow_help'] = 'Saniye cinsinden minimum süre ayarlandığında, tüm sayfalar daha yavaş görüntülenecektir. Yalnızca aynı komut dosyası için var olan bir profilden daha yavaş olan profiller korunur. Devre dışı bırakmak için 0 olarak ayarlayın. Bunun hariç tutma ayarlarını gözlemlediğini unutmayın.';
$string['protectusernames'] = 'Kullanıcıadlarını koru';
$string['proxybypass'] = 'Bunlar için vekil sunucu kullanma';
$string['proxyfixunsafe'] = 'Esnek olmayan aramaları düzeltme';
$string['proxyhost'] = 'Vekil sunucu';
$string['proxylogunsafe'] = 'Esnek olmayan aramaları günlüğe kaydet';
$string['proxypassword'] = 'Vekil sunucu şifresi';
$string['proxyport'] = 'Vekil sunucu portu';
$string['proxytype'] = 'Vekil sunucu tipi';
$string['proxyuser'] = 'Vekil sunucu kullanıcı adı';
$string['purgecaches'] = 'Tüm önbelleği temizle';
$string['purgecachesconfirm'] = 'Moodle, temaları, javascript, dil dizeleri, filtre metni, rss yayınları ve diğer birçok hesaplanan verileri önbellekleyebilir. Bu önbellekleri temizlediğinizde, bu veriler sunucudan silinir ve tarayıcılara verileri tekrar getirir; böylece geçerli kodun ürettiği en güncel değerleri gördüğünüzde emin olabilirsiniz. Önbellekleri boşaltma konusunda herhangi bir tehlike yoktur, ancak sunucu ve istemciler yeni bilgiler hesaplayıp önbelleğe alana kadar siteniz bir süre daha yavaş görünebilir.';
$string['purgecachesfinished'] = 'Tüm önbellek temizlendi';
$string['purgecachesnoneselected'] = 'Silmek için bir veya daha fazla öge seçin';
$string['purgecachespage'] = 'Önbelleği temizle';
$string['purgefiltercache'] = 'Metin filtreleri';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'Dil dizeleri';
$string['purgemuc'] = 'Tüm MUC önbellekleri';
$string['purgeothercaches'] = 'Tüm dosya ve çeşitli önbellekler';
$string['purgeselectedcaches'] = 'Seçili ögeleri temizle';
$string['purgeselectedcachesfinished'] = 'Seçili ögeler temizlendi.';
$string['purgetemplates'] = 'Şablonlar';
$string['purgethemecache'] = 'Temalar';
$string['query'] = 'Sorgu';
$string['question'] = 'Soru';
$string['questionbehaviours'] = 'Soru davranışları';
$string['questioncwqpfscheck'] = 'Paylaşılan ve paylaşılmayan soru kategorileri karmasından seçmek üzere bir sınava bir ya da daha fazla \'rastgele\' soru yerleştirilir. <a href="{$a->reporturl}">Burada</a> daha ayrıntılı bir rapor  mevcuttur, ayrıca <a href="{$a->docsurl}">buradaki</a> Belgelere bakın.';
$string['questioncwqpfsok'] = 'Güzel. Sınavlarınızda paylaşılan ve paylaşılmayan soru kategorileri karmasından seçmek üzere yerleştirilmiş hiç \'rastgele\' soru yok.';
$string['questiontype'] = 'Soru tipi';
$string['questiontypes'] = 'Soru tipleri';
$string['quizattemptsupgradedmessage'] = 'Moodle 2.1 sürümünde sorularla ilgili büyük günceleme yapıldı. Veritabanın bir kısımının daha sonra güncellemek üzere geriye bırakmak mümkün oldu. Moodle 2.8\'e yükseltmeden önce, bu güncellemenin tamamlanması gerekir.';
$string['recaptchaprivatekey'] = 'ReCAPTCHA gizli anahtarı';
$string['recaptchapublickey'] = 'ReCAPTCHA site anahtarı';
$string['referrernone'] = 'Tarayıcı varsayılanı';
$string['referrerpolicy'] = 'Yönlendiren politikası';
$string['referrerpolicydesc'] = 'Sitenizden gelen yanıtlara dahil edilecek yönlendiren politikası başlığını ayarlayın.';
$string['register'] = 'Sitenizi kayıt ettirin';
$string['registration'] = 'Kayıt';
$string['registration_help'] = 'Kayıt olarak:

* Güvenlik uyarıları alacaksınız
* Sitenizden mobil uygulama push bildirimlerini etkinleştirebilirsiniz
* Dünya çapında topluluğun Moodle istatistiklerimize katkıda bulunuyorsunuz';
$string['registrationwarning'] = 'Siteniz henüz kaydedilmemiş.';
$string['registrationwarningcontactadmin'] = 'Siteniz henüz kayıtlı değil. Yöneticiyi bu konuda uyarın.';
$string['releasenoteslink'] = 'Moodle\'ın bu sürümü hakkında bilgi için lütfen çevrimiçi <a target="_blank" href="{$a}">Sürüm Notlarına</a> bakınız';
$string['rememberuserlicensepref'] = 'Kullanıcı lisansı tercihini hatırla';
$string['rememberuserlicensepref_help'] = 'Etkinleştirilirse, dosya seçiciye bir dosya yüklenirken kullanıcı tarafından seçilen son lisans önceden seçilir. Aksi takdirde, varsayılan site lisansı önceden seçilir.';
$string['rememberusername'] = 'Kullanıcı adını hatırla';
$string['rememberusername_desc'] = 'Kullanıcını oturum açma sırasında kullanıcı adı ile kalıcı tanımlama bilgileri depolamak istiyorsanız etkinleştirin. Rızası olmadan kullanıldığı takdirde kalıcı çerezler gizlilik sorunu olarak kabul edilebilir.';
$string['replacefrontsearch'] = 'Ana site dersi araması için kullanılır';
$string['reportsmanage'] = 'Raporları yönet';
$string['required'] = 'Gereklidir';
$string['requiredentrieschanged'] = 'Not: Yükseltme işleminden sonra, "Görüntülemeden önce gerekli girişler" ayarı artık aşağıdaki veritabanı etkinliklerinde zorunlu kılınmıştır: <br/> {$a->text} <br/>';
$string['requiremodintro'] = 'Etkinlik açıklamasını zorunlu tut';
$string['requiremodintro_desc'] = 'Etkinleştirilirse, kullanıcılar her etkinlik için bir açıklama girmeye zorlanır.';
$string['requires'] = 'Gerektirir';
$string['resetindentation'] = 'Site genelinde girintiyi sıfırla';
$string['resetindentation_help'] = 'Bu, {$a->format} biçimindeki sitedeki tüm kurslar için önceden ayarlanmış girintileri kaldıracaktır.';
$string['resetindentation_title'] = 'Site genelinde girinti sıfırlansın mı?';
$string['resetindentationsuccess'] = 'Girinti sıfırlandı.';
$string['restorecourse'] = 'Kursu geri yükle';
$string['restorernewroleid'] = 'Geri kazananların kurslardaki rolü';
$string['restorernewroleid_help'] = 'Kullanıcının zaten yeni geri kazanılmış dersi yönetme izni yoksa, kullanıcıya otomatik olarak bu rol verilir ve gerekirse kursa alınır. Eğer geri kazanana her dersi yönetme iznini vermek istemiyorsanız "Hiçbiri" seçeneğini seçin.';
$string['resultfilter'] = 'Sonuca göre filtrele';
$string['reverseproxy'] = 'Ters vekil sunucu';
$string['reverseproxyignore'] = 'Ters proxy\'leri yoksay';
$string['riskconfig'] = 'Kullanıcılar, site yapılandırmasını ve davranışını değiştirebilir';
$string['riskconfigshort'] = 'Yapılandırma riski';
$string['riskdataloss'] = 'Kullanıcılar yüksek miktarda içerik ya da bilgiyi tahrip edebilirler';
$string['riskdatalossshort'] = 'Veri kaybı riski';
$string['riskmanagetrust'] = 'Kullanıcılar, diğer kullanıcıların güvenilirlik ayarlarını değiştirebilir';
$string['riskmanagetrustshort'] = 'Güvenilirlik yönetimi';
$string['riskpersonal'] = 'Kullanıcılar, diğer kullanıcıların özel bilgilerine erişebilir';
$string['riskpersonalshort'] = 'Gizlilik riski';
$string['riskspam'] = 'Kullanıcılar, site kullanıcılarına veya diğer kişilere toplu mesaj gönderebilir';
$string['riskspamshort'] = 'Toplu mesaj riski';
$string['riskxss'] = 'Kullanıcılar, cross-site scripting (XSS) izni verilerek dosya ve metin ekleyebilirler';
$string['riskxssshort'] = 'XSS riski';
$string['roleswithexceptions'] = '{$a->roles}, {$a->exceptions} ile';
$string['rssglobaldisabled'] = 'Site düzeyinde devre dışı bırakıldı';
$string['save'] = 'Kaydet';
$string['savechanges'] = 'Değişiklikleri kaydet';
$string['scssinvalid'] = 'SCSS kodu geçerli değil, başarısız: {$a}';
$string['search'] = 'Ara';
$string['searchablecourses'] = 'Arama yapılabilen kurslar';
$string['searchallavailablecourses'] = 'Arama yapılabilen kurslar';
$string['searchallavailablecourses_desc'] = 'Bazı durumlarda, çok sayıda kurs boyunca arama yaparken arama motoru çalışmayabilir. Aranan kursların sayısını sınırlamanız gerekirse yalnızca kayıtlı kursları aramak üzere ayarlayın.';
$string['searchallavailablecourses_off'] = 'Yalnızca kayıtlı kurslarda arama yapın';
$string['searchallavailablecourses_on'] = 'Kullanıcının erişebileceği tüm kursları ara';
$string['searchallavailablecoursesdesc'] = 'Yalnızca kayıtlı kurslarda aramaya ayarlanırsa, kurs bilgileri (ad ve özet) ve kurs içeriği yalnızca kullanıcının kayıtlı olduğu kurslarda aranacaktır. Aksi takdirde, kullanıcının erişebileceği tüm kurslarda kurs bilgisi ve kurs içeriği aranacaktır, konuk erişimi etkin olan kurslar gibi.';
$string['searchalldeleted'] = 'Dizine eklenmiş tüm içerikler silindi';
$string['searchalternatesettings'] = 'Yalnızca sorgu alternatif ayarları';
$string['searchalternatesettings_desc'] = 'Bu ayarları tamamlarsanız, "Genel aramayı yönet" sayfasındaki salt sorgu arama motoru seçeneğinde bu arama motoru için "alternatif ayarlar" ı seçebilirsiniz. Bu, yalnızca aynı türden iki arama motoru arasında geçiş yaparken kullanışlıdır.';
$string['searchareadisabled'] = 'Arama alanı devre dışı';
$string['searchareaenabled'] = 'Arama alanı etkin';
$string['searchareas'] = 'Arama alanları';
$string['searchbanner'] = 'Arama bilgileri';
$string['searchbannerenable'] = 'Arama bilgilerini görüntüle';
$string['searchbannerenable_desc'] = 'Etkinleştirilirse, aşağıdaki metin tüm kullanıcılar için arama ekranının üst kısmında görüntülenecektir. Bu, arama motoru bakımı yapılırken kullanıcıları bilgilendirmek için kullanılabilir.';
$string['searchdefaultcategory'] = 'Varsayılan arama kategorisi';
$string['searchdefaultcategory_desc'] = 'Seçilen arama alanı kategorisindeki sonuçlar varsayılan olarak görüntülenir.';
$string['searchdeleteindex'] = 'İndekslenmiş tüm içeriği sil';
$string['searchdisplay'] = 'Arama sonuçları görüntüleme seçenekleri';
$string['searchenablecategories'] = 'Sonuçları ayrı kategorilerde görüntüle';
$string['searchenablecategories_desc'] = 'Etkinleştirilirse, arama sonuçları ayrı kategorilerde görüntülenir.';
$string['searchengine'] = 'Arama motoru';
$string['searchenginealternatesettings'] = '{$a} (alternatif ayarlar)';
$string['searchenginequeryonly'] = 'Yalnızca sorgu arama motoru';
$string['searchenginequeryonly_desc'] = 'Bu arama motoru indeksleme için değil, sadece sorgulama yapmak için kullanılacaktır. Bu özelliği kullanarak farklı bir arama motorunda yeniden dizin oluşturabilirken, kullanıcı sorguları bu arama motorundan çalışmaya devam eder.';
$string['searchenginequeryonly_none'] = 'Yok (sorgular için ana arama motorunu kullanın)';
$string['searchenginequeryonlysame'] = 'Yalnızca sorgu arama motoru ve ana arama motoru aynı değere ayarlanamaz.';
$string['searchhideallcategory'] = 'Tüm sonuçlar kategorisini gizle';
$string['searchhideallcategory_desc'] = 'İşaretlenirse, tüm sonuçları içeren kategori arama sonucu ekranında gizlenir.';
$string['searchincludeallcourses'] = 'Tüm görünür kursları dahil et';
$string['searchincludeallcourses_desc'] = 'Etkinleştirilirse, arama sonuçları, kurs içeriğine erişimi olmasa bile kullanıcı tarafından görülebilen kursların kurs bilgilerini (ad ve özet) içerecektir.';
$string['searchindexactions'] = 'Dizin hareketleri';
$string['searchindexdeleted'] = 'Dizin silindi';
$string['searchindextime'] = 'İndeksleme süresi sınırı';
$string['searchindextime_desc'] = 'Büyük miktarda yeni içeriği dizine eklerken, bu zaman sınırına ulaşıldıktan sonra zamanlanmış görev durdurulur. Görev bir daha ki sefere devam edecektir.';
$string['searchindexupdated'] = 'Arama motoru içeriği güncellendi';
$string['searchindexwhendisabled'] = 'Devre dışı bırakıldığında dizin';
$string['searchindexwhendisabled_desc'] = 'Zamanlanmış görevin, arama devre dışı bırakıldığında bile arama dizini oluşturmasına izin verir. Bu, arama tesisi öğrencilere görünmeden önce dizini oluşturmak istiyorsanız kullanışlıdır.';
$string['searchinsettings'] = 'Ayarlarda ara';
$string['searchlastrun'] = 'Son çalıştırlan (time, # docs, # records, # ignores)';
$string['searchmanagement'] = 'Arama yönetimi';
$string['searchmanagement_desc'] = 'Bu seçenekler, yeniden oluşturulması uzun süren çok büyük arama dizinlerine sahip sitelerde değişiklik yaparken kullanışlıdır.';
$string['searchmaxtopresults'] = 'Maksimum en iyi sonuçlar';
$string['searchmaxtopresults_desc'] = 'Kurs içeriği, kurslar ve kullanıcılar için arama sonuçlarının üzerinde görüntülenecek en yüksek sıralanmış maksimum sonuç sayısı.';
$string['searchnotavailable'] = 'Arama mevcut değil';
$string['searchoptions'] = 'Arama seçenekleri';
$string['searchpartial'] = '(henüz tam dizine eklenmemiş)';
$string['searchreindexed'] = 'Tüm site içeriği yeniden endekslendi.';
$string['searchreindexindex'] = 'Tüm site içeriğini yeniden görüntüle';
$string['searchresults'] = 'Arama sonuçları';
$string['searchsetupinfo'] = 'Arama kurulumu';
$string['searchteacherroles'] = 'Öğretmen rolleri';
$string['searchteacherroles_desc'] = 'Rol sıralayıcıya sahip kullanıcıları arama sonuçlarında daha üst sıralara çıkaran tüm rolleri seçin.';
$string['searchtopresults'] = 'En iyi sonuçlar
';
$string['searchupdateindex'] = 'İndekslenmiş içeriği güncelleyin';
$string['sectionerror'] = 'Bölüm hatası!';
$string['secureforms'] = 'Ek form güvenliği kullan';
$string['security'] = 'Güvenlik';
$string['selectdevice'] = 'Cihaz seç';
$string['selectsearchengine'] = 'Arama motorunu seçiniz';
$string['selecttheme'] = '{$a} cihazı için tema seç';
$string['server'] = 'Sunucu';
$string['serverchecks'] = 'Sunucu kontrolleri';
$string['serverlimit'] = 'Sunucu sınırı';
$string['servicespage'] = '\'Hizmetler ve destek\' bağlantısı';
$string['sessionautostartwarning'] = '<p> Ciddi yapılandırma hatası tespit edildi, lütfen sunucu yöneticisine bildirin. </p> <p> Moodle, düzgün çalışabilmesi için yöneticinin PHP ayarlarını değiştirmesini ister. </p> <p> <code> session.auto_start </code> <code> php.ini </code>, Apache / IIS yapılandırması veya <code> .htaccess düzenleyerek bu ayar kontrol edilir. </code> dosyası. </p>';
$string['sessioncookie'] = 'Çerez öneki';
$string['sessioncookiedomain'] = 'Çerez etki alanı';
$string['sessioncookiepath'] = 'Çerez yolu';
$string['sessionhandling'] = 'Oturum işleme';
$string['sessiontimeout'] = 'Zaman aşımı';
$string['sessiontimeoutwarning'] = 'Zaman Aşımı Uyarısı';
$string['settingdependenton'] = 'Bu ayar, <strong>{$a}</strong> değerine bağlı olarak gizlenmiş olabilir.';
$string['settingfileuploads'] = 'Dosya yükleme normal işlemler için gereklidir, lütfen PHP yapılandırmasında etkinleştirin.';
$string['settingmaxinputvars'] = 'PHP ayarı max_input_vars\'ın en az 5000 olması önerilir.';
$string['settingmaxinputvarsrequired'] = 'PHP ayarı max_input_vars en az 5000 olmalıdır.';
$string['settingmemorylimit'] = 'Yetersiz bellek algılandı, lütfen PHP ayarlarında daha yüksek sınır atayın.';
$string['settingsafemode'] = 'Moodle, güvenli modla tam olarak uyumlu değildir, lütfen sunucu yöneticisinden bunu kapatmasını isteyin. Güvenli modda Moodle çalıştırmanız durumunda, çeşitli problemlerle karşılaşabilirsiniz.';
$string['setupsearchengine'] = 'Arama motorunu kur';
$string['showcommentscount'] = 'Yorum sayısı göster';
$string['showdetails'] = 'Ayrıntıları göster';
$string['showuseridentity'] = 'Kullanıcı kimliğini göster';
$string['showuseridentity_desc'] = 'Kullanıcıları seçerken veya ararken ve kullanıcı listelerini görüntülerken, tam adlarına ek olarak bu alanlar gösterilebilir. Alanlar yalnızca moodle/site:viewuseridentity yeteneğine sahip kullanıcılara gösterilir; varsayılan olarak, öğretmenler ve yöneticiler. (Kurumunuzda zorunlu olan bir veya iki alan seçerseniz bu seçenek en mantıklıdır.)

* ile işaretlenmiş alanlar özel kullanıcı profili alanlarıdır. Bu alanları seçebilirsiniz, ancak şu anda görünmeyecekleri bazı ekranlar var.';
$string['simplexmlrequired'] = 'SimpleXML PHP eklentisinin kurulması gerekli';
$string['sitemailcharset'] = 'Karakter seti';
$string['sitemaintenance'] = 'Bu siteye şu anda bakım yapılıyor ve şimdilik erişilemez';
$string['sitemaintenancemode'] = 'Bakım modu';
$string['sitemaintenanceoff'] = 'Bakım modu etkin değil ve site şu anda tekrar normal çalışıyor';
$string['sitemaintenanceon'] = 'Siteniz şu anda bakım modunda (sadece yöneticiler giriş yapabilir ve siteyi kullanabilir)';
$string['sitemaintenanceoncli'] = 'Siteniz şu anda CLI bakım modunda, internet erişimine izin verilmez.';
$string['sitemaintenancetitle'] = '{$a} bakımda';
$string['sitemaintenancewarning'] = 'Siteniz şu anda bakım modunda (sadece yöneticiler giriş yapabilir). Bu siteyi normal haline döndürmek için <a href="maintenance.php">bakım modunu pasifleştirin</a>.';
$string['sitemaintenancewarning2'] = 'Siteniz şu anda bakım modunda ve sadece yöneticiler giriş yapabilir. Bu sitenin normal çalışması için, <a href="{$a}">bakım modunu devre dışı bırakın</a>.';
$string['sitemenubar'] = 'Site navigasyonu';
$string['sitenameintitle'] = 'Site adını sayfa başlığına ekle';
$string['sitenameintitle_help'] = 'Bu ayar, sayfa başlığının sonuna site adını ekleyecektir. Kullanıcıların o anda bulundukları sayfayı hızlı bir şekilde tanımlamalarını sağlayarak sitenin erişilebilirliğini artıracağından, sayfa başlığına site adının eklenmesi tavsiye edilir.';
$string['sitepolicies'] = 'Site güvenlik ayarları';
$string['sitepolicy'] = 'Site politikası adresi';
$string['sitepolicy_help'] = 'Tüm kayıtlı kullanıcıların siteye erişmeden önce görmesi ve kabul etmesi gereken site politikasının URL\'si. Bu ayarın yalnızca site ilkesi işleyicisi varsayılan (temel) olarak ayarlanmışsa etkili olacağını unutmayın.';
$string['sitepolicyguest'] = 'Konular için site politikası adresi';
$string['sitepolicyguest_help'] = 'Siteye erişmeden önce tüm misafirlerin görmesi ve kabul etmesi gereken site politikasının URL\'si. Bu ayarın yalnızca site ilkesi işleyicisi varsayılan (temel) olarak ayarlanmışsa etkili olacağını unutmayın.';
$string['sitepolicyhandler'] = 'Site politikası işleyicisi';
$string['sitepolicyhandler_desc'] = 'Bu, politikaların ve kullanıcı onaylarının nasıl yönetileceğini belirler. Varsayılan (çekirdek) işleyici, konukların belirtilmesi için bir site politikası URL\'si ve bir site politikası URL\'si sağlar. Politika işleyicisi site, gizlilik ve diğer politikaların belirlenmesini sağlar. Aynı zamanda kullanıcı onaylarının görüntülenmesini ve gerekirse küçükler adına onay verilmesini sağlar.';
$string['sitepolicyhandlercore'] = 'Varsayılan (çekirdek)';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'Seçilirse, sitenin anasayfasında konu bölümü görünecektir.';
$string['sixtyfourbitsrequired'] = 'Sitenizin 64 bit PHP sürümü kullanmadığı tespit edildi.  Bu Moodle sürümünü kurmadan önce sisteminizi (işletim sistemi, PHP...) yükseltmeniz gerekmektedir.';
$string['sixtyfourbitswarning'] = 'Sitenizin 64-bit PHP sürümünü kullanmadığı tespit edildi. Gelecekteki uyumluluğu sağlamak için sitenizi yükseltmeniz önerilir.';
$string['slasharguments'] = 'Slash parametrelerini kullan';
$string['slashargumentswarning'] = 'Eğik çizgi argümanlarının kullanımının etkinleştirilmesi önerilir. Gelecekte gerekli olacaktır. Daha fazla ayrıntı için <a href="https://docs.moodle.org/en/admin/environment/slasharguments"> eğik çizgi argümanlarını kullanma </a> belgelerine bakın.';
$string['smartpix'] = 'Akıllı grafik araması';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'SMTP Kimlik Doğrulama Türü';
$string['smtpdetail'] = 'E-posta göndermek için Basit Posta Aktarım Protokolü (SMTP) ayarları.';
$string['smtphosts'] = 'SMTP alan adları';
$string['smtpmaxbulk'] = 'SMTP oturum limiti';
$string['smtppass'] = 'SMTP şifre';
$string['smtpsecure'] = 'SMTP güvenliği';
$string['smtpuser'] = 'SMTP kullanıcıadı';
$string['soaprecommended'] = 'İsteğe bağlı SOAP PHP eklentisinin kurulması, web servisleri ve bazı eklentiler için faydalıdır.';
$string['sort_fullname'] = 'Kursun tam adı';
$string['sort_idnumber'] = 'Kursun kimlik numarası';
$string['sort_shortname'] = 'Kursun kısa adı';
$string['sort_sortorder'] = 'Sıralama şekli';
$string['spellengine'] = 'Yazım denetimi motoru';
$string['spelllanguagelist'] = 'Yazım denetimi dil listesi';
$string['splrequired'] = 'Şimdi SPL ve PHP eklentileri Moodle tarafından istenmektedir.';
$string['stats'] = 'İstatistikler';
$string['statsfirstrun'] = 'En fazla işleme aralığı';
$string['statsmaxruntime'] = 'Max çalışma zamanı';
$string['statsmoodleorg'] = 'istatistikler';
$string['statsruntimedays'] = 'İşlenecek günler';
$string['statsruntimestart'] = 'Çalıştır';
$string['statsuserthreshold'] = 'Kullanıcı eşiği';
$string['stickyblocks'] = 'Sabit bloklar';
$string['stickyblockscourseview'] = 'Kurs sayfası';
$string['stickyblocksduplicatenotice'] = 'Belirli bir sayfada zaten var olan bloğu buraya eklerseniz aynısının kopyası oluşacaktır.<br/>Sadece sabit blok düzenlenemez, ancak kopya blok düzenlenebilir.';
$string['stickyblocksmymoodle'] = 'Benim Moodle\'um';
$string['stickyblockspagetype'] = 'Yapılandırılacak sayfa tipi';
$string['strictformsrequired'] = 'Gerekli alanlar için katı doğrulama';
$string['stripalltitletags'] = 'Tüm etkinlik isimlerinden HTML etiketlerini sil';
$string['supportandservices'] = 'Destek ve hizmetler';
$string['supportavailability'] = 'Destek kullanılabilir';
$string['supportcontact'] = 'Destek personeli';
$string['supportemail'] = 'Destek e-posta';
$string['supportemailsubject'] = 'Site destek talebi - {$a}';
$string['supportname'] = 'Destek ismi';
$string['supportpage'] = 'Site destek bağlantısına başvurun';
$string['suspenduser'] = 'Kullanıcı hesabını askıya al';
$string['switchlang'] = 'Dil klasörüne geç';
$string['systempaths'] = 'Sistem yolu';
$string['tablenosave'] = 'Yukarıdaki tablodaki değişiklikler otomatikmen kaydedilir.';
$string['tablesnosave'] = 'Yukarıdaki tablolardaki değişiklikler otomatikmen kaydedilir.';
$string['tabselectedtofront'] = 'Sekmeleri kullanan tablolarda, şimdiki seçili sekme ön tarafa yerleştirilsin mi?';
$string['tabselectedtofronttext'] = 'Seçili sekmeyi öne getir';
$string['task_adhoc_concurrency_limit'] = 'Geçici görev eşzamanlılık sınırı';
$string['task_adhoc_concurrency_limit_desc'] = 'Eşzamanlı olarak çalışmasına izin verilen geçici görev koşucularının sayısı. Sınır yüksekse, zamanlanmış görevler çok sayıda geçici görev olduğunda düzenli olarak çalışmayabilir. 0 ayarı, geçici görevlerin işlenmesini tamamen devre dışı bırakır.';
$string['task_adhoc_max_runtime'] = 'Geçici görev koşucusu ömrü';
$string['task_adhoc_max_runtime_desc'] = 'Ad hoc görev koşucusunun serbest bırakılmadan önceki yaşı. Kuyruğa alınan geçici görevlerin sayısında bir sınır olmadığından, düşük bir süre önerilir. Bu sayı çok yüksekse ve büyük bir geçici görev kuyruğunuz varsa, zamanlanan görevler düzenli olarak çalıştırılmayabilir.';
$string['task_dbreads'] = 'Veritabanı okumaları';
$string['task_dbstats'] = 'Veritabanı';
$string['task_dbwrites'] = 'Veritabanı yazarları';
$string['task_duration'] = 'Süre';
$string['task_endtime'] = 'Bitiş tarihi';
$string['task_logmode'] = 'Ne zaman giriş yapıldı';
$string['task_logmode_all'] = 'Tüm işlerin günlük çıktısını depola';
$string['task_logmode_desc'] = 'Görev günlüğünün ne zaman gerçekleşmesini istediğinizi seçebilirsiniz. Varsayılan olarak günlükler her zaman yakalanır. Günlüğe kaydetmeyi tamamen devre dışı bırakabilir veya yalnızca başarısız olan günlük görevlerine geçebilirsiniz.';
$string['task_logmode_failonly'] = 'Günlükleri yalnızca başarısız olan işler için depola';
$string['task_logmode_none'] = 'Hiçbir şey kaydetme';
$string['task_logoutput'] = 'Görev çıkışı';
$string['task_logretainruns'] = 'İşlemleri koru';
$string['task_logretainruns_desc'] = 'Korunacak her görevin çalışma sayısı. Bu ayar \'Saklama süresi\' ayarıyla etkileşime girer: hangisine önce ulaşılırsa uygulanır.';
$string['task_logretention'] = 'Saklama süresi';
$string['task_logretention_desc'] = 'Günlüklerin saklanması gereken enfazla süre. Bu ayar \'Çalışmaları koru\' ayarıyla etkileşime girer: hangisine önce ulaşılırsa uygulanır';
$string['task_logtostdout'] = 'Görüntü günlüğü çıktısı';
$string['task_logtostdout_desc'] = 'İşler çalışırken ve çıktı yakalandığında, yakalanan çıktının görev çalışırken de görüntülenip görüntülenmeyeceği.';
$string['task_result'] = 'Sonuç';
$string['task_result:failed'] = 'Hata';
$string['task_scheduled_concurrency_limit'] = 'Zamanlanmış görev eşzamanlılık sınırı';
$string['task_scheduled_concurrency_limit_desc'] = 'Eşzamanlı olarak çalışmasına izin verilen zamanlanmış görev koşucusu sayısı. Limit yüksekse, sunucu performansı etkileyen yüksek yük yaşayabilir. 0 ayarı, zamanlanan görevlerin işlenmesini tamamen devre dışı bırakır.';
$string['task_scheduled_max_runtime'] = 'Zamanlanmış görev koşucusu ömrü';
$string['task_scheduled_max_runtime_desc'] = 'Zamanlanmış görev koşucusunun serbest bırakılmadan önceki yaşı.';
$string['task_starttime'] = 'Başlangıç zamanı';
$string['task_stats:dbreads'] = '{$a} okuma';
$string['task_stats:dbwrites'] = '{$a} yazma';
$string['task_status'] = 'Görev durumu';
$string['task_status_desc'] = '\'{$a->name}\' görevi {$a->status}. Ayrıntılar için <a href="{$a->gotourl}">Planlanmış görevler</a>\'deki {$a->class}{$a->extradescription} konusuna bakın.';
$string['task_type:adhoc'] = 'Geçici';
$string['task_type:scheduled'] = 'Tarifeli';
$string['taskadmintitle'] = 'Görevler';
$string['taskanalyticscleanup'] = 'Analitikleri temizle';
$string['taskautomatedbackup'] = 'Otomatik yedekleme';
$string['taskautomatedbackup_report'] = 'Otomatik yedekleme raporu';
$string['taskbackupcleanup'] = 'Yedekleme tablolarını, günlükleri ve dosyaları temizleyin';
$string['taskbadgesadhoc'] = 'Ödül rozeti';
$string['taskbadgescron'] = 'Ödül rozetleÖdül rozetleri adhoc görevleri ekleyinri';
$string['taskbadgesmessagecron'] = 'Rozet bildirimleri göndermek için arka plan işleme';
$string['taskblogcron'] = 'Harici blokları eşitle';
$string['taskcachecleanup'] = 'Süresi dolan önbellek girdileri kaldırın';
$string['taskcachecron'] = 'Cache Arkaplan işleme';
$string['taskcalendarcron'] = 'Takvim bildirimleri gönder';
$string['taskcheckforupdates'] = 'Güncelleme için kontrol et';
$string['taskcompletiondaily'] = 'Tamamlama işaretlemesi başlatıldı';
$string['taskcompletionregular'] = 'Düzenli tamamlanma verilerini hesapla';
$string['taskcontextcleanup'] = 'Temizleme bağlamları';
$string['taskcreatecontexts'] = 'Eksik bağlamları oluştur';
$string['taskdeletecachetext'] = 'Eski metin önbellek kayıtlarını sil';
$string['taskdeleteincompleteusers'] = 'Tamamlanmamış kullanıcıları sil';
$string['taskdeleteunconfirmedusers'] = 'Onaylanmamış kullanıcıları sil';
$string['taskeventscron'] = 'Olaylar arkaplanda işleniyor';
$string['taskfiletrashcleanup'] = 'Çöpü temizle';
$string['taskglobalsearchindex'] = 'Genel arama endekslemesi';
$string['taskglobalsearchoptimize'] = 'Genel arama dizini optimizasyonu';
$string['taskgradecron'] = 'Notdefteri arka planda işleniyor';
$string['taskgradehistorycleanup'] = 'Not geçmişi tablolarını temizlemek için arka plan işleme';
$string['taskh5pcleanup'] = 'Kullanılmayan H5P dosyaları temizleme';
$string['tasklegacycron'] = 'Eklentiler için eski cron işleme';
$string['tasklockcleanuptask'] = 'Ad hoc görev üstverilerini temizle';
$string['tasklogcleanup'] = 'Görev günlüklerinin temizlenmesi';
$string['tasklogging'] = 'Görev günlüğü yapılandırması';
$string['tasklogs'] = 'Görev günlükleri';
$string['taskmessagingcleanup'] = 'Mesajlar arka planda işleniyor';
$string['taskpasswordresetcleanup'] = 'Parola sıfırlama girişimlerini temizle';
$string['taskplagiarismcron'] = 'İntihal eklentilerinde eski cron için arka plan işleme';
$string['taskportfoliocron'] = 'Portfolyo eklentisi arka planda işleniyor';
$string['taskprocessing'] = 'Görev işleme';
$string['taskquestioncron'] = 'Soru önizlemelerini temizlemek için arka planda işleme';
$string['taskquestionstatscleanupcron'] = 'Soru istatistikleri önbelleklerini temizlemek için arka plan';
$string['taskrefreshsystemtokens'] = 'Hizmet hesapları için OAuth anahtarlarını tazele';
$string['taskregistrationcron'] = 'Site Kaydı';
$string['tasksendfailedloginnotifications'] = 'Başarısız oturum açma bildirimlerini gönder';
$string['tasksendnewuserpasswords'] = 'Yeni kullanıcı şifresini gönder';
$string['tasksessioncleanup'] = 'Eski oturumları temizle';
$string['taskstatscron'] = 'İstatistiklerin arka plan işleme';
$string['tasktagcron'] = 'Etiketler için arka plan işleme';
$string['tasktempfilecleanup'] = 'Eski geçici dosyaları sil';
$string['tasktype'] = 'Tür';
$string['tempdatafoldercleanup'] = '\'den daha eski geçici veri dosyalarını temizleyin';
$string['templates'] = 'Şablonlar';
$string['testoutgoingmailconf'] = 'Giden posta yapılandırmasını test etme';
$string['testoutgoingmailconf_errorcommunications'] = 'Siteniz posta sunucunuzla iletişim kuramadı. Lütfen giden posta yapılandırmanızı kontrol edin.';
$string['testoutgoingmailconf_fromemail'] = 'Kullanıcı adı veya e-posta adresinden';
$string['testoutgoingmailconf_fromemail_help'] = 'Bu alan,  söz konusu kullanıcadan mesaj gönderilmesini taklit eder, ancak gönderilen gerçek e-postada kullanılan Kimden başlığı, allowemaildomains gibi diğer ayarlara bağlı olacaktır.';
$string['testoutgoingmailconf_fromemail_invalid'] = 'Kullanıcı adı veya e-postadan geçersiz. Geçerli bir e-posta biçimi veya Moodle\'da mevcut bir kullanıcı adı olmalıdır.';
$string['testoutgoingmailconf_message'] = 'Bu, sitenizin giden postasını başarıyla yapılandırdığınızı doğrulamak için bir test mesajıdır. Gönderildi: {$a}';
$string['testoutgoingmailconf_sendtest'] = 'Test mesajı gönderin';
$string['testoutgoingmailconf_sentmail'] = 'Bu site posta sunucusuna başarıyla bir test mesajı gönderdi. <br/> Kimden: {$a->fromemail} <br/> Kime: {$a->toemail}';
$string['testoutgoingmailconf_subject'] = '{$a->site}: test mesajı. {$a->additional} Gönderildi: {$a->time}';
$string['testoutgoingmailconf_subjectadditional'] = 'Ek konu';
$string['testoutgoingmailconf_toemail'] = 'E-posta adresine';
$string['testoutgoingmaildetail'] = 'Not: Test etmeden önce lütfen yapılandırmanızı kaydedin. <br/> {$a}';
$string['testsiteupgradewarning'] = 'Şu anda {$a} test sitesi kullanıyorsunuz, düzgün yüksetlme yapabilmek için komut satırı arabirimi aracını kullanın.';
$string['themedefinedinconfigphp'] = 'Tema değiştirilemez çünkü config.php dosyasında {$a} olarak ayarlanmıştır.';
$string['themedesignermode'] = 'Tema tasarımcısı modu';
$string['themedesignermodewarning'] = 'Tema tasarımcısı modu etkindir. Performansı önemli ölçüde düşürebileceğinden, üretim sitelerinde etkinleştirilmemelidir.';
$string['themelist'] = 'Tema listesi';
$string['themenoselected'] = 'Tema seçilmedi';
$string['themeresetcaches'] = 'Tema önbelleklerini temizleyin';
$string['themeselect'] = 'Tema değiştir';
$string['themeselector'] = 'Tema seçici';
$string['themesettings'] = 'Tema ayarları';
$string['therewereerrors'] = 'Verinizde hatalar var';
$string['thirdpartylibrary'] = 'Kütüphane';
$string['thirdpartylibrarylocation'] = 'Konum';
$string['thirdpartylibs'] = 'Üçüncü parti kütüphaneler';
$string['timezone'] = 'Varsayılan yerel zaman';
$string['timezoneforced'] = 'Bu, site yöneticisi tarafından zorunlu tutuldu';
$string['timezoneinvalid'] = 'Geçersiz zaman dilimi "{$a}"';
$string['timezoneisforcedto'] = 'Bütün kullanıcıları, kullanmaya zorunlu tut';
$string['timezonenotforced'] = 'Kullanıcılar kendi zaman dilimini seçebilsin';
$string['timezonephpdefault'] = 'Geçerli PHP zaman dilimi ({$a})';
$string['timezoneserver'] = 'Sunucu zaman dilimi ({$a})';
$string['tlswarning'] = 'TLSv1.2 desteğiyle hiçbir PHP / cURL uzantısı tespit edilmedi. Bazı hizmetler çalışmayabilir. TLS kitaplıklarınızı yükseltmeniz şiddetle önerilir.';
$string['tokenduration'] = 'Kullanıcı tarafından oluşturulmuş gösterge süresi';
$string['tokenduration_desc'] = 'Bir kullanıcı tarafından (örneğin mobil uygulama yoluyla) oluşturulmuş bir web hizmetleri jetonunun geçerli olacağı süre.';
$string['tokenizerrecommended'] = 'İsteğe bağlı PHP Tokenizer eklentisini kurmanız tavsiye edilir. Bu, Moodle Ağı işlevselliğe yardımcı olur.';
$string['tools'] = 'Yönetici araçları';
$string['toolsmanage'] = 'Yönetici araçlarını yönet';
$string['unattendedoperation'] = 'Geçersiz işlem';
$string['unbookmarkthispage'] = 'Bu sayfayı yer imlerinden kaldır';
$string['unicoderequired'] = 'Bütün verilerinizi Unicode (UTF-8) olarak saklamanız gerekir. Yeni kurulumların veritabanlarına varsayılan olarak Unicode karakter setinde işlem yapması gerekir. Güncelleme yapıyorsanız, UTF-8 Çevirim işlemini yapmanız gerekiyor (Yönetici sayfasına bakınız).';
$string['uninstallplugin'] = 'Kaldır';
$string['unlockaccount'] = 'Hesabı aç';
$string['unoconvwarning'] = 'Yüklediğiniz unoconv sürümü desteklenmiyor. Moodle\'ın ödev tesviye özelliği 0.7 veya üstü gerektirir.';
$string['unsettheme'] = 'Temayı geri al';
$string['unsupported'] = 'Desteklenmez';
$string['unsupporteddbfileformat'] = 'Veritabanınız dosya biçimi olarak Antilop\'u kullanıyor. MySQL ve MariaDB\'de tam UTF-8 desteği, Barracuda dosya biçimini gerektirir. Lütfen Barracuda dosya biçimine geçin. Ayrıntılar için <a href="https://docs.moodle.org/en/admin/environment/custom check/mysql tam unicode desteği">MySQL tam unicode desteği</a> belgelerine bakın.';
$string['unsupporteddbfilepertable'] = 'Hem MySQL\'in hem de MariaDB\'nin tam olarak UTF-8 desteğine sahip olması için, MySQL\'deki \'innodb_file_per_table\' ayarını \'ON\' olarak değiştirmeniz gerekmekte. Daha fazla ayrıntı için klavuzlara bakınız.';
$string['unsupporteddblargeprefix'] = 'Hem MySQL\'in hem de MariaDB\'nin tam olarak UTF-8 desteğine sahip olması için, MySQL\'deki \'innodb_large_prefix\' ayarını \'ON\' olarak değiştirmeniz gerekmekte. Daha fazla ayrıntı için klavuzlara bakınız.';
$string['unsupporteddbstorageengine'] = 'Kullanılan veritabanı depolama motoru artık desteklenmiyor.';
$string['unsupporteddbtablerowformat'] = 'Veritabanınız Antelope dosya biçimini kullanıyor. Dosya sisteminizi Barracuda dosya biçimine dönüştürmenizi öneriyoruz.  Konu ile ilgili beleleri görmek için  <a href="https://docs.moodle.org/en/cli">Komut satırı aracılığıyla yönetim</a> InnoDB tablolarını  Barracuda dosya sistemine dönüştürmek için detaylar';
$string['unsupportedphpversion7'] = 'PHP versiyon 7 ve üstü desteklenmiyor.';
$string['unsupportedphpversion71'] = 'PHP sürüm 7.1  ve üstü desteklenmiyor.';
$string['unsupportedphpversion72'] = 'PHP sürüm 7.2  ve üstü desteklenmiyor.';
$string['unsupportedphpversion73'] = 'PHP sürüm 7.3  ve üstü desteklenmiyor.';
$string['unsupportedphpversion74'] = 'PHP sürüm 7.4  ve üstü desteklenmiyor.';
$string['unsupportedphpversion80'] = 'PHP sürüm 8.0 desteklenmez.';
$string['unsupportedphpversion81'] = 'PHP sürüm 8.1 ve üstü desteklenmiyor.';
$string['unsupportedphpversion82'] = 'PHP sürüm 8.2 ve üstü desteklenmez.';
$string['unsupportedphpversion83'] = 'PHP 8.3 ve üstü sürümler desteklenmemektedir.';
$string['unsuspenduser'] = 'Kullanıcı hesabını etkinleştir';
$string['updateaccounts'] = 'Var olan hesapları güncelle';
$string['updateautocheck'] = 'Mevcut güncellemeleri otomatik kontrol et';
$string['updateautocheck_desc'] = 'Etkinleştirildiğinde siteniz Moodle kodlarında ve tüm eklentilerdeki uygun günlemeleri otomatik olarak kontrol eder. Eğer yeni bir günleme mevcut ise, site yöneticisine bildirim gönderilir.';
$string['updateavailable'] = 'Kullanılabilir yeni bir Moodle sürümü var!';
$string['updateavailable_moreinfo'] = 'Daha fazla bilgi...';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Sürüm {$a}';
$string['updateavailabledetailslink'] = 'Daha fazla bilgi için {$a->url}';
$string['updateavailableforplugin'] = 'Mevcut eklentileriniz için kullanılabilir yeni sürümler var!';
$string['updateavailableinstall'] = 'Bu güncellemeyi yükle';
$string['updateavailableinstallall'] = 'Mevcut güncelleştirmeleri yükle ({$a})';
$string['updateavailableinstallallhead'] = 'Mevcut güncelleştirmeler yükleniyor';
$string['updateavailablenot'] = 'Moodle kodunuz güncel!';
$string['updateavailablerecommendation'] = 'En son güvenlik ve hata düzeltmelerini edinmek için sitenizi en son sürüme yükseltmeniz şiddetle önerilir.';
$string['updatecomponent'] = 'Bileşeni güncelle';
$string['updateminmaturity'] = 'Gerekli kod olgunluğu';
$string['updateminmaturity_desc'] = 'Kullanılabilir güncellemeler hakkında, yalnızca mevcut kod seçilen olgunluk seviyesi en az olması durumunda bildirimde bulunun. Kod olgunluk düzeyini beyan etmeyen eklentilere yönelik güncellemeler bu ayar ne olursa olsun her zaman raporlanır.';
$string['updatenotificationfooter'] = 'Moodle siteniz {$a->siteurl} mevcut güncellemeleri otomatik kontrol edecek şekilde ayarlı. Bu mesajı site yöneticisi olduğunuz için alıyorsunuz. Site Yönetimi/Sunucu/Bildirimleri güncelle bölümünden otomatik kontrolü devre dışı bırakabilirsiniz. Bu mesajın gönderim şeklini Profil Ayarlarım bölümündeki mesajlaşma ayarları aracılığı ile özelleştirebilirsiniz.';
$string['updatenotifications'] = 'Bildirimleri güncelle';
$string['updatenotificationsubject'] = 'Moodle güncelleştirmeleri var ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Yeni inşalar hakkında bildirimde bulun';
$string['updatenotifybuilds_desc'] = 'Etkinleştirilirse, geçerli sürüm için yeni bir yapı bulunduğu zaman Moodle kodu için mevcut güncelleme de raporlanır. Yapılar belirli bir Moodle sürümünün sürekli gelişmeleridir. Genellikle her hafta serbest bırakılırlar. Devre dışı bırakılmışsa, kullanılabilir güncelleme ancak Moodle\'ın daha yüksek bir sürümü çıktığında bildirilir. Eklentiler için yapılan kontroller bu ayardan etkilenmez.';
$string['upgradeerror'] = '{$a->plugin}, {$a->version} sürümüne yükseltilirken bilinmeyen hata. Devam edilemez.';
$string['upgradeforumread'] = 'Moodle 1.5 sürümünde forum mesajlarını izleme özelliği eklendi.<br/> Bu işlevselliği kullanmak için <a href="{$a}">tablolarınızı güncellemeniz gerekiyor</a>.';
$string['upgradeforumreadinfo'] = 'Moodle 1.5\'e forum mesajlarını okundu/okunmadı olarak izlemek için yeni bir özellik eklendi. Bu işlevselliği kullanabilmek için mevcut tüm mesajlardaki izleme bilgilerini güncellemeniz gerekiyor. Sitenizin büyüklüğüne göre bu işlem biraz uzun (saatlerce) sürebilir ve veritabanını bayağı yorabilir; Bu yüzden, sakin bir zamanda bu işlemi gerçekleştirmeniz en iyisidir. Ancak, güncelleme sırasında siteniz işlevselliğine devam edecek ve kullanıcılar bundan etkilenmeyecektir. Bu işlemi başlattığınızda bitmesine izin verin (tarayıcınız penceresini sürekli açık bırakın). Pencereyi kapatarak işleme son verdiğinizde kaygılanmanıza gerek yok; çünkü tekrar baştan başlayabilirsiniz..<br/><br/>Güncelleme işlemini şimdi başlatmak istiyor musunuz?';
$string['upgradekeyreq'] = 'Yükseltme anahtarı gereklidir';
$string['upgradekeyset'] = 'Yükseltme tuşu (ayarlanmak istenmiyorsa boş bırakın)';
$string['upgradelogs'] = 'Tam işlevsellik için, eski kayıt dosyalarınız güncellenmeli. <a href="{$a}">Daha fazla bilgi</a>';
$string['upgradelogsinfo'] = 'Kayıtların(loglar) kaydedilme biçiminde bazı değişiklikler yapıldı. Etkinlik seviyesindeki eski kayıtları görebilmeniz için güncellenmesi gerekiyor. Sitenize bağlı olarak bu işlem biraz uzun (bir kaç saat) sürebilir ve büyük sitelerde veritabanına oldukça fazla yük getirebilir. İşleme başladığınızda işlemin bitmesine izin verin (tarayıcı pencerenizi açık bırakarak). Kaygılanmanıza gerek yok - kayıtlar güncellenirken siteniz diğer kullanıcılar için çalışacaktır.<br/><br/>Kayıtları(loglar) şimdi güncellemek istiyor musunuz?';
$string['upgradepluginsfirst'] = 'İlk önce tüm güncelleştirmeleri yapmanız tavsiye edilir.';
$string['upgradepluginsinfo'] = 'Eklentiler güncelleniyor';
$string['upgradepluginsinfo_help'] = 'Eklentilerinizin bazıları için güncellemeler var. Moodle veritabanına ekleme yapmadan önce hepsini yüklemeniz gerekir. Siteniz otomatik güncelleştirmeler dağıtımını desteklemiyorsa, elle yeni eklenti sürümlerini indirmek ve sunucunuzda kurmak zorundasınız.';
$string['upgradepluginsinfo_link'] = 'admin/upgradepluginsinfo';
$string['upgradesettings'] = 'Yeni ayarlar';
$string['upgradesettingsintro'] = 'Aşağıda gösterilen ayarlar son Moodle güncelleştirmesi sırasında eklendi. Gerekli değişikliklikleri yaptıktan sonra sayfanın altındaki "Değişiklikleri kaydet" düğmesine basın.';
$string['upgradestalefiles'] = 'Karışık Moodle sürümleri tespit edildi, yükseltme devam edemez';
$string['upgradestalefilesinfo'] = 'PHP komut dosyalarından  iki farklı Moodle sürümü  Moodle dizininde algıladığından Moodle güncelleştirme işlemi duraklatıldı.

Bu daha sonra önemli sorunlar  neden olabilir, devam edebilmek için
Moodle dizinin tek bir Moodle sürüm içeren dosyalar içerdiğinden emin olmalısınız.

Moodle dizini temizlemek için önerilen yöntem aşağıdaki gibidir:

*geçerli Moodle klasörünün adını "eski_moodle" olarak değiştirin
*yeni bir Moodle klasörü oluşturun ve bul klasör Moodle Git den indirdiğiniz standart Moodle dosyalarını içersin.
*orjinal config.php dosyası ve standart olmayana eklentileri "eski_moodle" klasöründen yeni Moodle klasörüne taşıyın.

Temiz bir Moodle dizinine sahip olduğunuzda, Moodle güncelleştirme işlemine devam etmek için bu sayfayı yenileyin.


Bu uyarıyı genellikle standart bir Moodle paketinin Moodle önceki bir sürümü üzerine yüklenmesinden kaynaklanır. Bu küçük yükseltmeler için önemsiz iken, büyük Moodle yükseltmeleri için kesinlikle önerilmez.

Bu uyarı Git depolarından eksik dosya yüklenmesi ve bozuk dosya yüklenmesi sonucunda da oluşabilir,  Bu durumda işlemin tamamlanmasını beklemeniz gerekebilir ya da belki de uygun komutu çalıştırın ve işlemi yeniden deneyin.

Yükseltme ile ilgili daha detaylı bilgiyi yüksteltme dökümanlarında bulabilirsiniz. <a href="{$a}">{$a}</a>.';
$string['upgradestart'] = 'Şimdi Moodle veritabanını yükselt.';
$string['upgradesure'] = '<p> Moodle dosyalarınız değişti ve otomatik olarak sunucunuzu şu sürüme terfi etmek üzeresiniz: </p>
<p><strong>{$a}</strong></p>
<p>Bunu yaptığınızda tekrar geri dönemezsiniz. Lütfen bu işlemin uzun sürebileceğini dikkate alın.</p>
<p>Bu sunucuyu bu sürüme terfi etmek istediğinizden emin misiniz?</p>';
$string['upgradetimedout'] = 'Güncelleme zaman aşımına uğradı, lütfen tekrar başlatın.';
$string['upgradingdata'] = 'Veri güncelleniyor';
$string['upgradinglogs'] = 'Loglar güncelleniyor';
$string['upgradingversion'] = 'Yeni sürüme yükseltme';
$string['upwards'] = 'yukarısı';
$string['useblogassociations'] = 'İlişkilendirmeleri etkinleştir';
$string['user'] = 'Kullanıcı';
$string['userbulk'] = 'Toplu kullanıcı eylemleri';
$string['userbulkdownload'] = 'Kullanıcıları şu şekilde dışa aktar:';
$string['userdefaultpreferences'] = 'Kullanıcı varsasayılan tercihleri';
$string['userfeedbackafterupgrade'] = 'Her büyük yükseltmeden sonra';
$string['userfeedbackencouragement'] = '<p> Moodle, kullanıcılara Moodle HQ tarafından barındırılan harici bir anket sitesi aracılığıyla Moodle yazılımı hakkında geri bildirim sağlama seçeneği sunan bir özellik içerir. Anket sitesine kullanıcıyı tanımlayan hiçbir bilgi iletilmez.</p>
<p> Moodle HQ, veri toplama uygulamaları konusunda açık ve şeffaf olmaya gayret etmektedir. Bu nedenle, bu işlevselliğin farkında ve kontrolünde olduğunuzdan emin olmak istiyoruz.</p>
<p>Kullanıcılardan gelen geri bildirimler, Moodle HQ\'nun Moodle yazılımını geliştirmesine yardımcı olur. Bu özelliği etkinleştirmek için lütfen <a href="{$a}">Geri bildirim ayarları</a> bölümüne gidin.</p>';
$string['userfeedbacknextreminder'] = 'Sonraki geri bildirim hatırlatıcısı';
$string['userfeedbacknextreminder_desc'] = 'Ne zaman kullanıcıdan tekrar geri bildirimde bulunmasını istemeliyiz?';
$string['userfeedbackperiodically'] = 'Periyodik olarak';
$string['userfeedbackremindafter'] = 'Sonrasında hatırlatıcıyı göster';
$string['userfeedbackremindafter_desc'] = 'Kullanıcılara, belirtilen gün sayısından sonra geri bildirim vermelerini hatırlatın.';
$string['userfiltersdefault'] = 'Varsayılan kullanıcı filtreleri';
$string['userfiltersdefault_desc'] = '\'Kullanıcı listesine göz at\' sayfasında ve \'Toplu kullanıcı işlemleri\' sayfasında gösterilmesi gereken filtreleri seçin. Birden fazla öğe seçmek için Ctrl tuşunu basılı tutun. Seçilmeyen filtreler \'Daha fazla göster\' bağlantısını tıklayarak kullanılabilir.';
$string['userimagesdisabled'] = 'Kullanıcı profil görüntüleri devre dışı';
$string['userlist'] = 'Kullanıcılara gözat';
$string['usermanagement'] = 'Kullanıcı yönetimi';
$string['userpolicies'] = 'Kullanıcı ilkeleri';
$string['userpreference'] = 'Kullanıcı tercihi';
$string['userquota'] = 'Özel dosya alanı';
$string['userquota_desc'] = 'Her kullanıcının özel dosyalar alanında depolayabileceği maksimum veri miktarı.';
$string['users'] = 'Kullanıcılar';
$string['usesitenameforsitepages'] = 'Sitesi sayfaları için site adı kullan';
$string['usetags'] = 'Etiketlemeyi etkinleştir';
$string['validateemptylineerror'] = 'Boş satırlar geçerli değil';
$string['validateerror'] = 'Bu değer geçerli değildir';
$string['validateerrorlist'] = 'Bu kayıtlar geçersiz: {$a}';
$string['validateiperror'] = 'Bu IP adresleri geçersiz: {$a}';
$string['verifychangedemail'] = 'E-postayı değiştirirken etki alanlarını sınırla';
$string['warningcurrentsetting'] = 'Bu değer geçersiz: {$a}';
$string['warningiconvbuggy'] = 'Iconv kütüphanesi sürümünüz // IGNORE değiştiriciyi desteklemiyor. Bunun yerine geçersiz UTF-8 karakteri içeren bir dizeyi temizlemek için kullanılabilir mbstring uzantısı yüklemeniz gerekir.';
$string['webproxy'] = 'Web proxy';
$string['webproxyinfo'] = 'Moodle sunucusunun direkt olarak internete erişimi yoksa aşağıdaki seçenekleri doldurun. Ortam verisini, dil paketlerini, Haber içeriklerini, zaman dilimleri vb. indirirken internet erişimi gerekir.<br/><em>PHP cURL eklentisi şiddetle önerilir.</em>';
$string['xmlrpcwebserviceenabled'] = 'Sitenizde XML-RPC Web Hizmeti protokolünün etkinleştirildiği tespit edildi. Bu özellik, artık PHP tarafından korunmayan PHP XML-RPC uzantısına dayanır.';
$string['yuicomboloading'] = 'YUI combo yükleniyor';
$string['ziprequired'] = 'Moodle, Zip PHP eklentisini gerektirir. Info-ZIP dosyaları veya PclZip kütüphanesi artık kullanılmamaktadır.';
